=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::TiffExportOptions;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::FontFallbackRule;
use AsposeSlidesCloud::Object::FontSubstRule;
use AsposeSlidesCloud::Object::ImageExportOptionsBase;
use AsposeSlidesCloud::Object::SlidesLayoutOptions;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Provides options that control how a presentation is saved in TIFF format.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ format } = 'tiff';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Provides options that control how a presentation is saved in TIFF format.',
                                  class => 'TiffExportOptions',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'default_regular_font' => {
    	datatype => 'string',
    	base_name => 'DefaultRegularFont',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'delete_embedded_binary_objects' => {
    	datatype => 'boolean',
    	base_name => 'DeleteEmbeddedBinaryObjects',
    	description => 'True to delete delete all embedded binary objects.',
    	format => '',
    	read_only => '',
    		},
    'gradient_style' => {
    	datatype => 'string',
    	base_name => 'GradientStyle',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'font_fallback_rules' => {
    	datatype => 'ARRAY[FontFallbackRule]',
    	base_name => 'FontFallbackRules',
    	description => 'Gets of sets list of font fallback rules.',
    	format => '',
    	read_only => '',
    		},
    'font_subst_rules' => {
    	datatype => 'ARRAY[FontSubstRule]',
    	base_name => 'FontSubstRules',
    	description => 'Gets of sets list of font substitution rules.',
    	format => '',
    	read_only => '',
    		},
    'skip_java_script_links' => {
    	datatype => 'boolean',
    	base_name => 'SkipJavaScriptLinks',
    	description => 'True to skip hyperlinks with javascript calls when saving the presentation.',
    	format => '',
    	read_only => '',
    		},
    'format' => {
    	datatype => 'string',
    	base_name => 'Format',
    	description => 'Export format.',
    	format => '',
    	read_only => '',
    		},
    'height' => {
    	datatype => 'int',
    	base_name => 'Height',
    	description => 'Gets or sets the height of slides in the output image format.',
    	format => '',
    	read_only => '',
    		},
    'width' => {
    	datatype => 'int',
    	base_name => 'Width',
    	description => 'Gets or sets the height of slides in the output the output image format.',
    	format => '',
    	read_only => '',
    		},
    'compression' => {
    	datatype => 'string',
    	base_name => 'Compression',
    	description => 'Compression type.',
    	format => '',
    	read_only => '',
    		},
    'dpi_x' => {
    	datatype => 'int',
    	base_name => 'DpiX',
    	description => 'Horizontal resolution, in dots per inch.',
    	format => '',
    	read_only => '',
    		},
    'dpi_y' => {
    	datatype => 'int',
    	base_name => 'DpiY',
    	description => 'Vertical resolution, in dots per inch.',
    	format => '',
    	read_only => '',
    		},
    'show_hidden_slides' => {
    	datatype => 'boolean',
    	base_name => 'ShowHiddenSlides',
    	description => 'Specifies whether the generated document should include hidden slides or not. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'pixel_format' => {
    	datatype => 'string',
    	base_name => 'PixelFormat',
    	description => 'Specifies the pixel format for the generated images. Read/write ImagePixelFormat.',
    	format => '',
    	read_only => '',
    		},
    'slides_layout_options' => {
    	datatype => 'SlidesLayoutOptions',
    	base_name => 'SlidesLayoutOptions',
    	description => 'Slides layouting options',
    	format => '',
    	read_only => '',
    		},
    'bw_conversion_mode' => {
    	datatype => 'string',
    	base_name => 'BwConversionMode',
    	description => 'Specifies the algorithm for converting a color image into a black and white image. This option will applied only if Aspose.Slides.Export.TiffOptions.CompressionType is set to Aspose.Slides.Export.TiffCompressionTypes.CCITT4 or Aspose.Slides.Export.TiffCompressionTypes.CCITT3.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'default_regular_font' => 'string',
    'delete_embedded_binary_objects' => 'boolean',
    'gradient_style' => 'string',
    'font_fallback_rules' => 'ARRAY[FontFallbackRule]',
    'font_subst_rules' => 'ARRAY[FontSubstRule]',
    'skip_java_script_links' => 'boolean',
    'format' => 'string',
    'height' => 'int',
    'width' => 'int',
    'compression' => 'string',
    'dpi_x' => 'int',
    'dpi_y' => 'int',
    'show_hidden_slides' => 'boolean',
    'pixel_format' => 'string',
    'slides_layout_options' => 'SlidesLayoutOptions',
    'bw_conversion_mode' => 'string'
} );

__PACKAGE__->attribute_map( {
    'default_regular_font' => 'DefaultRegularFont',
    'delete_embedded_binary_objects' => 'DeleteEmbeddedBinaryObjects',
    'gradient_style' => 'GradientStyle',
    'font_fallback_rules' => 'FontFallbackRules',
    'font_subst_rules' => 'FontSubstRules',
    'skip_java_script_links' => 'SkipJavaScriptLinks',
    'format' => 'Format',
    'height' => 'Height',
    'width' => 'Width',
    'compression' => 'Compression',
    'dpi_x' => 'DpiX',
    'dpi_y' => 'DpiY',
    'show_hidden_slides' => 'ShowHiddenSlides',
    'pixel_format' => 'PixelFormat',
    'slides_layout_options' => 'SlidesLayoutOptions',
    'bw_conversion_mode' => 'BwConversionMode'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
