use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'PerlVision',
    AUTHOR              => q{Ashish Gulhati <perlvision at hash.neo.email>},
    VERSION_FROM        => 'lib/PV.pm',
    ABSTRACT_FROM       => 'lib/PV.pm',
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
      ? ('LICENSE'=> 'unrestricted')
      : ()),
    PL_FILES            => {},
    PREREQ_PM => {
        'Test::More' => 0,
        'Curses' => 1.45,
    },
    META_MERGE          => {
	provides => {
			'PV' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Checkbox' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Cutebutton' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Dialog' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Editbox' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Entryfield' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Listbox' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Menubar' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Mlistbox' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::PVD' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Password' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Plainbutton' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Pushbutton' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Radio' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::RadioG' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Static' => { file => 'lib/PV.pm', version => '1.507' },
			'PV::Viewbox' => { file => 'lib/PV.pm', version => '1.507' },
		    }
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'PerlVision-*' },
);
