# Generated by default/object.tt
package Paws::IoT::TimestreamDimension;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::TimestreamDimension

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::TimestreamDimension object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::TimestreamDimension object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Metadata attributes of the time series that are written in each measure
record.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The metadata dimension name. This is the name of the column in the
Amazon Timestream database table record.

Dimensions cannot be named: C<measure_name>, C<measure_value>, or
C<time>. These names are reserved. Dimension names cannot start with
C<ts_> or C<measure_value> and they cannot contain the colon (C<:>)
character.


=head2 B<REQUIRED> Value => Str

The value to write in this column of the database record.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

