# Generated by default/object.tt
package Paws::S3Control::AccountLevel;
  use Moose;
  has ActivityMetrics => (is => 'ro', isa => 'Paws::S3Control::ActivityMetrics');
  has BucketLevel => (is => 'ro', isa => 'Paws::S3Control::BucketLevel', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::AccountLevel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::AccountLevel object:

  $service_obj->Method(Att1 => { ActivityMetrics => $value, ..., BucketLevel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::AccountLevel object:

  $result = $service_obj->Method(...);
  $result->Att1->ActivityMetrics

=head1 DESCRIPTION

A container for the account level Amazon S3 Storage Lens configuration.

=head1 ATTRIBUTES


=head2 ActivityMetrics => L<Paws::S3Control::ActivityMetrics>

A container for the S3 Storage Lens activity metrics.


=head2 B<REQUIRED> BucketLevel => L<Paws::S3Control::BucketLevel>

A container for the S3 Storage Lens bucket-level configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

