# Generated by default/object.tt
package Paws::Athena::PreparedStatementSummary;
  use Moose;
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has StatementName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::PreparedStatementSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::PreparedStatementSummary object:

  $service_obj->Method(Att1 => { LastModifiedTime => $value, ..., StatementName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::PreparedStatementSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->LastModifiedTime

=head1 DESCRIPTION

The name and last modified time of the prepared statement.

=head1 ATTRIBUTES


=head2 LastModifiedTime => Str

The last modified time of the prepared statement.


=head2 StatementName => Str

The name of the prepared statement.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

