#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

VERDENSERKLÆRINGEN OM MENNESKERETTIGHEDERNE
INDLEDNING
Da anerkendelse af den mennesket iboende værdighed og af de lige og ufortabelige rettigheder for alle medlemmer af den menneskelige familie er grundlaget for frihed, retfærdighed og fred i verden,

da tilsidesættelse af og foragt for menneskerettighederne har ført til barbariske handlinger, der har oprørt menneskehedens samvittighed, og da skabelsen af en verden, hvor menneskene nyder tale- og trosfrihed og frihed for frygt og nød, er blevet forkyndt som folkenes højeste mål,

da det er af afgørende betydning, at menneskerettighederne beskyttes af loven, hvis ikke mennesket som en sidste udvej skal tvinges til at gøre oprør mod tyranni og undertrykkelse,

da det er af afgørende betydning at fremme udviklingen af venskabelige forhold mellem nationerne,

da De forenede Nationers folk i pagten påny har bekræftet deres tro på fundamentale menneskerettigheder, på menneskets værdighed og værd og på lige rettigheder for mænd og kvinder, og har besluttet at fremme sociale fremskridt og højne levevilkårene under større frihed,

da medlemsstaterne har forpligtet sig til i samarbejde med De forenede Nationer at arbejde for fremme af almindelig respekt fur og overholdelse af menneskerettigheder og fundamentale frihedsrettigheder,

da en fælles forståelse af disse rettigheder og friheder er af den største betydning for den fulde virkeliggørelse af denne forpligtelse,

proklamerer

PLENARFORSAMLINGEN

derfor nu denne VERDENSERKLÆRING OM MENNESKERETTIGHEDERNE som et fælles mål for alle folk og alle nationer med det formål, at ethvert menneske og ethvert samfundsorgan stedse med denne erklæring for øje skal stræbe efter gennem undervisning og opdragelse at fremme respekt for disse rettigheder og friheder og gennem fremadskridende nationale og internationale foranstaltninger at sikre, at de anerkendes og overholdes overalt og effektivt, både blandt befolkningerne i medlemsstaterne og blandt befolkningerne i de områder, der befinder sig under deres styre.

Artikel 1.
Alle mennesker er født frie og lige i værdighed og rettigheder. De er udstyret med fornuft og samvittighed, og de bør handle mod hverandre i en broderskabets ånd.

Artikel 2.
Enhver har krav på alle de rettigheder og friheder, som nævnes i denne erklæring, uden forskelsbehandling af nogen art, f. eks. på grund af race, farve, køn, sprog, religion, politisk eller anden anskuelse, national eller social oprindelse, formueforhold, fødsel eller anden samfundsmæssig stilling.

Der skal heller ikke gøres nogen forskel på grund af det lands eller områdes jurisdiktionsforhold eller politiske eller internationale stilling, til hvilket en person hører, hvadenten dette område er uafhængigt, under formynderskab eller er et ikke selvstyrende område, eller dets suverænitet på anden måde er begrænset.

Artikel 3.
Enhver har ret til liv, frihed og personlig sikkerhed.

Artikel 4.
Ingen må holdes i slaveri eller trældom ; slaveri og slavehandel under alle former skal være forbudt.

Artikel 5.
Ingen må underkastes tortur eller grusom, umenneskelig eller vanærende behandling eller straf.

Artikel 6.
Ethvert menneske har overalt i verden ret til at blive anerkendt som retssubjekt.

Artikel 7.
Alle er lige for loven og har uden forskelsbehandling af nogen art lige ret til lovens beskyttelse. Alle har ret til lige beskyttelse mod enhver forskelsbehandling i strid mod denne erklæring og mod enhver tilskyndelse til en sådan forskelsbehandling.

Artikel 8.
Enhver har ret til en fyldestgørende oprejsning ved de kompetente nationale domstole for handlinger, der krænker de fundamentale rettigheder, som forfatningen eller loven giver vedkommende.

Artikel 9.
Ingen må underkastes vilkårlig anholdelse, tilbageholdelse eller landsforvisning.

Artikel 10.
Enhver har under fuld ligeberettigelse krav på en retfærdig og offentlig behandling ved en uafhængig og upartisk domstol, når der skal træffes en afgørelse med hensyn til hans rettigheder og forpligtelser og med hensyn til en hvilken som helst mod ham rettet strafferetslig anklage.

Artikel 11.
Enhver, der anklages for et strafbart forhold, har ret til at blive anset for uskyldig, indtil hans skyld er godtgjort i henhold til lov ved en offentlig retshandling, hvorunder han har fået alle de garantier, der er fornødne for hans forsvar.
Ingen må anses for skyldig i noget strafbart forhold på grund af nogen handling eller undladelse, der ikke i henhold til national eller international ret var strafbar på det tidspunkt, da den blev begået. Der skal heller ikke kunne idømmes strengere straf end fastsat på den tid, da det strafbare forhold blev begået.
Artikel 12.
Ingen må være genstand for vilkårlig indblanding i private forhold, familie, hjem eller korrespondance, ej heller for angreb på ære og omdømme. Enhver har ret til lovens beskyttelse mod sådan indblanding eller angreb.

Artikel 13.
Enhver har ret til at bevæge sig frit og til frit at vælge opholdssted indenfor hver stats grænser.
Enhver har ret til at forlade et hvilket som helst land, herunder sig eget, og til at vende tilbage til sit eget land.
Artikel 14.
Enhver har ret til i andre lande at søge og få tilstået asyl mod forfølgelse.
Denne ret må ikke påberåbes ved anklager, der virkelig hidrører fra ikke-politiske forbrydelser eller fra handlinger i strid med De forenede Nationers formål og principper.
Artikel 15.
Enhver har ret til en nationalitet.
Ingen må vilkårligt berøves sin nationalitet eller nægtes ret til at skifte nationalitet.
Artikel 16.
Uden begrænsninger af racemæssige, nationalitetsmæssige eller religiøse grunde har mænd og kvinder, der har nået myndighedsalderen, ret til at gifte sig og stifte familie. De har krav på lige rettigheder med hensyn til indgåelse af ægteskab, under ægteskabet og ved dettes opløsning.
Ægteskab skal kun kunne indgås med begge parters frie og fulde samtykke.
Familien er samfundets naturlige og fundamentale enhedsgruppe og har krav på samfundets og statens beskyttelse.
Artikel 17.
Enhver har ret til at eje ejendom såvel alene som i fællig med andre.
Ingen må vilkårligt berøves sin ejendom.
Artikel 18.
Enhver har ret til tanke-, samvittigheds- og religionsfrihed: denne ret omfatter frihed til at skifte religion eller tro og frihed til enten alene eller i fællesskab med andre, offentligt eller privat, at give udtryk for sin religion eller tro gennem undervisning, udøvelse, gudsdyrkelse og overholdelse af religiøse forskrifter.

Artikel 19.
Enhver har ret til menings- og ytringsfrihed; denne ret omfatter frihed til at hævde sin opfattelse uden indblanding og til at søge, modtage og meddele oplysning og tanker ved et hvilket som helst meddelelsesmiddel og uanset landegrænser.

Artikel 20.
Alle har ret til under fredelige former frit at forsamles og danne foreninger.
Ingen kan tvinges til at være medlem af en forening.
Artikel 21.
Enhver har ret til at deltage i sit lands styre enten direkte eller gennem frit valgte repræsentanter.
Enhver har ret til lige adgang til offentlige embeder og hverv i sit land.
Folkets vilje skal være grundlaget for regeringens myndighed; denne vilje skal tilkendegives gennem periodiske og virkelige valg med almindelig og lige valgret og skal udøves gennem hemmelig afstemning eller tilsvarende frie afstemningsmåder.
Artikel 22.
Enhver har som medlem af samfundet ret til social tryghed og har krav på, at de økonomiske, sociale og kulturelle rettigheder, der er uundværlige for hans værdighed og hans personligheds frie udvikling, gennemføres ved nationale foranstaltninger og internationalt samarbejde og i overensstemmelse med hver stats organisation og hjælpekilder.

Artikel 23.
Enhver har ret til arbejde, til frit valg af beskæftigelse, til retfærdige og gunstige arbejdsvilkår og til beskyttelse mod arbejdsløshed.
Enhver har uden forskel ret til lige løn for lige arbejde.
Enhver, der arbejder, har ret til et retfærdigt og gunstigt vederlag, der sikrer ham selv og hans familie en menneskeværdig tilværelse, og om fornødent tillige til andre sociale beskyttelsesforanstaltninger.
Enhver har ret til at danne og indtræde i fagforeninger til beskyttelse af sine interesser.
Artikel 24.
Enhver har ret til hvile og fritid, herunder en rimelig begrænsning af arbejdstiden, og til periodisk ferie med løn.

Artikel 25.
Enhver har ret til en sådan levefod, som er tilstrækkelig til hans og hans families sundhed og velvære, herunder til føde, klæder, bolig og lægehjælp og de nødvendige sociale goder og ret til tryghed i tilfælde af arbejdsløshed, sygdom, uarbejdsdygtighed, enkestand, alderdom eller andet tab af fortjenstmulighed under omstændigheder, der ikke er selvforskyldt.
Mødre og børn har krav på særlig omsorg og hjælp. Alle børn skal, hvadenten de er født i eller udenfor ægteskab, have den samme sociale beskyttelse.
Artikel 26.
Enhver har ret til undervisning. Undervisningen skal være gratis, i det mindste på de elementære og grundlæggende trin. Elementær undervisning skal være obligatorisk. Teknisk og faglig uddannelse skal gøres almindelig tilgængelig for alle, og på grundlag af evner skal der være lige adgang for alle til højere undervisning.
Undervisningen skal tage sigte på den menneskelige personligheds fulde udvikling og på at styrke respekten for menneskerettigheder og grundlæggende friheder. Den skal fremme forståelse, tolerance og venskab mellem alle nationer og racemæssige og religiøse grupper, og den skal fremme De forenede Nationers arbejde til fredens bevarelse.
Forældre har førsteret til at vælge den form for undervisning, som deres børn skal have.
Artikel 27.
Enhver har ret til frit at deltage i samfundets kulturelle liv, til kunstnydelse og til at blive delagtiggjort i videnskabens fremskridt og dens goder.
Enhver har ret til beskyttelse af de moralske og materielle interesser, der hidrører fra en hvilken som helst videnskabelig, litterær eller kunstnerisk frembringelse, som vedkommende har skabt.
Artikel 28.
Enhver har krav på en social og international orden, i hvilken de i denne erklæring nævnte rettigheder og friheder fuldtud kan virkeliggøres.

Artikel 29.
Enhver har pligter overfor samfundet, der alene muliggør personlighedens frie og fulde udvikling.
Under udøvelsen af sine rettigheder og friheder er enhver kun underkastet de begrænsninger, der er fastsat i loven alene med det formål at sikre skyldig anerkendelse af og hensyntagen til andres rettigheder og friheder og med det formål at opfylde de retfærdige krav, som moralen, den offentlige orden og det almene vel stiller i et demokratisk samfund.
Disse rettigheder og friheder må i intet tilfælde udøves i strid med De forenede Nationers formål og principper.
Artikel 30.
Intet i denne erklæring må fortolkes som givende nogen stat, gruppe eller enkeltperson hjemmel til at indlade sig på nogen virksomhed eller foretage nogen handling, der tilsigter at nedbryde nogen af de heri opregnede rettigheder og friheder.

TEXT

is(Text::Guess::Language->guess($text),'da','is da');

done_testing;
