# Generated by default/object.tt
package Paws::Rekognition::ProtectiveEquipmentSummary;
  use Moose;
  has PersonsIndeterminate => (is => 'ro', isa => 'ArrayRef[Int]');
  has PersonsWithoutRequiredEquipment => (is => 'ro', isa => 'ArrayRef[Int]');
  has PersonsWithRequiredEquipment => (is => 'ro', isa => 'ArrayRef[Int]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::ProtectiveEquipmentSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::ProtectiveEquipmentSummary object:

  $service_obj->Method(Att1 => { PersonsIndeterminate => $value, ..., PersonsWithRequiredEquipment => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::ProtectiveEquipmentSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->PersonsIndeterminate

=head1 DESCRIPTION

Summary information for required items of personal protective equipment
(PPE) detected on persons by a call to DetectProtectiveEquipment. You
specify the required type of PPE in the C<SummarizationAttributes>
(ProtectiveEquipmentSummarizationAttributes) input parameter. The
summary includes which persons were detected wearing the required
personal protective equipment (C<PersonsWithRequiredEquipment>), which
persons were detected as not wearing the required PPE
(C<PersonsWithoutRequiredEquipment>), and the persons in which a
determination could not be made (C<PersonsIndeterminate>).

To get a total for each category, use the size of the field array. For
example, to find out how many people were detected as wearing the
specified PPE, use the size of the C<PersonsWithRequiredEquipment>
array. If you want to find out more about a person, such as the
location (BoundingBox) of the person on the image, use the person ID in
each array element. Each person ID matches the ID field of a
ProtectiveEquipmentPerson object returned in the C<Persons> array by
C<DetectProtectiveEquipment>.

=head1 ATTRIBUTES


=head2 PersonsIndeterminate => ArrayRef[Int]

An array of IDs for persons where it was not possible to determine if
they are wearing personal protective equipment.


=head2 PersonsWithoutRequiredEquipment => ArrayRef[Int]

An array of IDs for persons who are not wearing all of the types of PPE
specified in the C<RequiredEquipmentTypes> field of the detected
personal protective equipment.


=head2 PersonsWithRequiredEquipment => ArrayRef[Int]

An array of IDs for persons who are wearing detected personal
protective equipment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

