# Generated by default/object.tt
package Paws::ComputeOptimizer::S3Destination;
  use Moose;
  has Bucket => (is => 'ro', isa => 'Str', request_name => 'bucket', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has MetadataKey => (is => 'ro', isa => 'Str', request_name => 'metadataKey', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::S3Destination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::S3Destination object:

  $service_obj->Method(Att1 => { Bucket => $value, ..., MetadataKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::S3Destination object:

  $result = $service_obj->Method(...);
  $result->Att1->Bucket

=head1 DESCRIPTION

Describes the destination Amazon Simple Storage Service (Amazon S3)
bucket name and object keys of a recommendations export file, and its
associated metadata file.

=head1 ATTRIBUTES


=head2 Bucket => Str

The name of the Amazon S3 bucket used as the destination of an export
file.


=head2 Key => Str

The Amazon S3 bucket key of an export file.

The key uniquely identifies the object, or export file, in the S3
bucket.


=head2 MetadataKey => Str

The Amazon S3 bucket key of a metadata file.

The key uniquely identifies the object, or metadata file, in the S3
bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

