# Generated by default/object.tt
package Paws::ElasticBeanstalk::PlatformBranchSummary;
  use Moose;
  has BranchName => (is => 'ro', isa => 'Str');
  has BranchOrder => (is => 'ro', isa => 'Int');
  has LifecycleState => (is => 'ro', isa => 'Str');
  has PlatformName => (is => 'ro', isa => 'Str');
  has SupportedTierList => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElasticBeanstalk::PlatformBranchSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElasticBeanstalk::PlatformBranchSummary object:

  $service_obj->Method(Att1 => { BranchName => $value, ..., SupportedTierList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElasticBeanstalk::PlatformBranchSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BranchName

=head1 DESCRIPTION

Summary information about a platform branch.

=head1 ATTRIBUTES


=head2 BranchName => Str

The name of the platform branch.


=head2 BranchOrder => Int

An ordinal number that designates the order in which platform branches
have been added to a platform. This can be helpful, for example, if
your code calls the C<ListPlatformBranches> action and then displays a
list of platform branches.

A larger C<BranchOrder> value designates a newer platform branch within
the platform.


=head2 LifecycleState => Str

The support life cycle state of the platform branch.

Possible values: C<beta> | C<supported> | C<deprecated> | C<retired>


=head2 PlatformName => Str

The name of the platform to which this platform branch belongs.


=head2 SupportedTierList => ArrayRef[Str|Undef]

The environment tiers that platform versions in this branch support.

Possible values: C<WebServer/Standard> | C<Worker/SQS/HTTP>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElasticBeanstalk>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

