# Generated by default/object.tt
package Paws::Kendra::UserTokenConfiguration;
  use Moose;
  has JsonTokenTypeConfiguration => (is => 'ro', isa => 'Paws::Kendra::JsonTokenTypeConfiguration');
  has JwtTokenTypeConfiguration => (is => 'ro', isa => 'Paws::Kendra::JwtTokenTypeConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::UserTokenConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::UserTokenConfiguration object:

  $service_obj->Method(Att1 => { JsonTokenTypeConfiguration => $value, ..., JwtTokenTypeConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::UserTokenConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->JsonTokenTypeConfiguration

=head1 DESCRIPTION

Provides configuration information for a token configuration.

=head1 ATTRIBUTES


=head2 JsonTokenTypeConfiguration => L<Paws::Kendra::JsonTokenTypeConfiguration>

Information about the JSON token type configuration.


=head2 JwtTokenTypeConfiguration => L<Paws::Kendra::JwtTokenTypeConfiguration>

Information about the JWT token type configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

