
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/App/Term/Jump.pm

);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}

my @setup_lib=
qw(
) ;

for(@setup_lib)
	{
	$all_modules{$_} = "lib/App/Term/Jump/$_" ;
	}

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
chomp $number_of_commits ;

if($number_of_commits)
	{
	#print "number of git revision: $number_of_commits.\n" ;
	return("${version}.${number_of_commits}") ;
	}
else
	{
	print "Couldn't get git revision, using version from '$file'!\n" ;
	return($version) ;
	}
}

my $code = <<'EOC';
use strict ;
use warnings ;

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
chomp $number_of_commits ;

if($number_of_commits)
	{
	#print "number of git revision: $number_of_commits.\n" ;
	return("${version}.${number_of_commits}") ;
	}
else
	{
	print "Couldn't get git revision, using version from '$file'!\n" ;
	return($version) ;
	}
}

sub ACTION_author_test
{
my $self = shift;
local $self->{properties}{test_files} = 'xt/author/*.t' ;
$self->SUPER::ACTION_test();
}

sub ACTION_build 
{
my $self = shift;

my ($version) = GetVersionAndRevisionFrom('lib/App/Term/Jump.pm') ;

#~ print "Generating version module ($version)\n" ;

open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;

print VERSION <<EOV ;

# version module automatically generated by the build system

package Config::Version ;

sub GetVersion {return '$version'} ;

1 ;

# end of generated version module
EOV

close VERSION ;

$self->SUPER::ACTION_build(@_);
}

sub ACTION_dist
{
my $self = shift;

my $have_git = $self->do_system('git --version');

if($have_git)
	{
	print `git status`;
	
	if($self->do_system('git log --decorate > git_Changes'))
		{
		use File::Copy;
		move('git_Changes', 'Changes') ;
		}
	else
		{
		print "Couldn't get git log, 'Changes' will not be generated from git log!\n" ;
		}
	}
else
	{
	print "git not found, 'Changes' will not be generated from git log!\n" ;
	}

$self->SUPER::ACTION_test() ;
#~ $self->ACTION_author_test() ;

$self->SUPER::ACTION_dist();
};


EOC

my $class = Module::Build->subclass(class => 'App::Term::Jump', code => $code) ;

my $build = $class->new
	(
	module_name => 'App::Term::Jump',
	
	dist_version => GetVersionAndRevisionFrom('lib/App/Term/Jump.pm'),
	
	license => 'perl',
	build_requires => 
		{
		'Text::Diff' => 0,
		'Test::Block' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		},
	
	requires => 
		{
		'Readonly'         => 0,
		'Sub::Exporter'     => 0,
		'Data::TreeDumper' => 0,
		'Data::TreeDumper::Utils' => 0,
		
		'Cwd' => 0,
		'File::Basename' => 0,
		'File::Spec' => 0,
		'File::Slurp' => 0,
		'File::HomeDir'           => '0.86',
		'Text::Pluralize' => 0,
		'Tree::Trie' => 0,
		},
		
	pm_files     => \%all_modules,
	
	script_files => 
		[
		'scripts/jump',
		'scripts/jump_bash_completion.pl',
		'scripts/jump_bash_integration.sh',
		],

	dist_author  => 'Khemir Nadim ibn Hamouda. <nadim.khemir@gmail.com>',
	dist_abstract => 'App::Term::Jump - utility to navigate your filesystem with heuristic',
	);
	


$build->create_build_script;
  

