#!/usr/bin/perl -w
#
#    locale.pl
#
#    $Id: locale.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno);
use utf8;

use ExtUtils::testlib;
use ICU;
use ICU::Locale;

my $show_set_default = 1;
my $short_demo = 1;
my $demo_locales = 1;
my $show_all_locales = 1;
my $show_iso_countries = 1;
my $show_iso_languages = 1;

if ($show_set_default) {
    my $l_default = new ICU::Locale(ICU::Locale->getDefault());
    print "default locale is ".$l_default->getName()."\n";

    my $l_ja = new ICU::Locale('ja_JP');
    ICU::Locale->setDefault($l_ja);
    $l_default = ICU::Locale->getDefault();
    print "new default locale is ".$l_default->getName()."\n";

    # restore the old default else futher display may be weird
    ICU::Locale->setDefault($l_default);
}

if ($short_demo) {
    #
    # Locale
    #
    my $l_en = new ICU::Locale('en_US');
    print "DisplayLanguage in en is ".$l_en->getDisplayLanguage()."\n";
    print "DisplayCountry is ".$l_en->getDisplayCountry()."\n";

    my $l_ja = new ICU::Locale('ja_JP');
    print "DisplayLanguage in ja is ".$l_ja->getDisplayLanguage()."\n";
    print "DisplayCountry is ".$l_ja->getDisplayCountry()."\n";
    print "DisplayLanguage for ja in 'ja' is ".$l_ja->getDisplayLanguage($l_ja)."\n";
    #print "DisplayLanguage is ".$l_ja->getDisplayLanguage($df)."\n";


    my $l_de = new ICU::Locale('de_DE');
    print "DisplayLanguage for ja in 'de' is ".$l_ja->getDisplayLanguage($l_de)."\n";
    print "DisplayCountry for de is ".$l_de->getDisplayCountry()."\n";

    my $dup_l = new ICU::Locale($l_de);
    print "DisplayLanguage in dup is ".$dup_l->getDisplayLanguage()."\n";
}

if ($demo_locales) {
    demo_locale();
    demo_locale('en_US');
    demo_locale('en');
    demo_locale('en','US');
    demo_locale('de','DE');
    demo_locale('de','DE','EURO');
}


sub demo_locale {
    my ($language, $country, $variant) = @_;
    my $la = $language || '';
    my $co = $country  || '';
    my $va = $variant  || '';
    print "language/country/variant = $la/$co/$va\n";
    #my $l = new ICU::Locale($language, $country, $variant);
    my $l = new ICU::Locale(@_);

    my $get_language = $l->getLanguage();
    my $get_country  = $l->getCountry();
    my $get_variant  = $l->getVariant() || '()';
    my $locale_name = $l->getName();
    print "locale_name is $locale_name\n";

    print "    language/country/variant is $get_language/$get_country/$get_variant\n";
    my $lcid = $l->getLCID();
    print "    LCID is $lcid\n";

    my $displayLanguage = $l->getDisplayLanguage();
    print "    DisplayLanguage is $displayLanguage\n";

    my $displayCountry = $l->getDisplayCountry();
    print "    DisplayCountry is $displayCountry\n";

    my $displayVariant = $l->getDisplayVariant();
    print "    DisplayVariant is $displayVariant\n";

    my $displayName = $l->getDisplayName();
    print "    DisplayName is $displayName\n";

    my $hashCode = $l->hashCode();
    printf "    hashCode is 0x%08x\n", $hashCode;

    print "\n";
}

if ($show_all_locales) {
    print "    (start show_all_locales)\n";
    my @locales = ICU::Locale->getAvailableLocales();
    my $locale_length = scalar(@locales);
    print "lenght of \@locales is $locale_length\n";
    for (my $i=0; $i<$locale_length; $i++) { 
        print "locale[$i] = ".($locales[$i])->getName()."\n";
    }
    print "    (show_all_locales done)\n";
}

if ($show_iso_countries) {
    print "    (start show_iso_countries)\n";
    my @countries = ICU::Locale->getISOCountries();
    my $countries_length = scalar(@countries);
    print "lenght of \@countries is $countries_length\n";
    for (my $i=0; $i<$countries_length; $i++) { 
        print "countries[$i] = $countries[$i]\n";
    }
    print "    (show_iso_countries done)\n";
}

if ($show_iso_languages) {
    print "    (start show_iso_languages)\n";
    my @languages = ICU::Locale->getISOLanguages();
    my $languages_length = scalar(@languages);
    print "lenght of \@languages is $languages_length\n";
    for (my $i=0; $i<$languages_length; $i++) { 
        print "languages[$i] = $languages[$i]\n";
    }
    print "    (show_iso_languages done)\n";
}

exit(0);
