# NAME

ppk - Perl Packager

# SYNOPSIS

    ~$ ppk main.pl --dists Filesys-POSIX/ -o script
    ~$ ppk main.pl --dists Filesys-POSIX-0.9.tar.gz -o script
    ~$ ppk main.pl --modules lib/Foo/Bar.pm=Foo::Bar -o script
    ~$ ppk main.pl --dists Filesys-POSIX/ -c

# DESCRIPTION

ppk provides a means of packaging a main Perl script, along with any number
of dependencies in the form of modules explicitly specified by path and their
equivalent Perl names; or, entire Perl dists in the form of tarballs or paths
to unarchived dists, which contain a MANIFEST in either case.

# ARGUMENTS

- _main_

    The main entry point script around which a standalone wrapper script will be
    constructed.  All arguments passed to the wrapper script will be passed to this
    main script.

- **--dists** _dists ..._
- **-d** _dists ..._

    A single instance of the `--dists` flag, followed by the paths of any number
    of Perl dists (tarballs or directories) can be passed.  All files in the
    `lib/` directory listed in `MANIFEST` will be copied into the standalone
    script.

- **--modules** _file=module::name ..._

    A single instance of the `--modules` flag, followed by the paths and Perl
    module names as pairs separated by an equals (=) sign allow the user to archive
    only specific modules in disparate locations, into the standalone script.

- **--deps-from** _depsfile_

    Specifies a file from which dependencies are read.  If _depsfile_ is listed as
    a single dash ('-') character, then standard input will be read from.

    The format of the file is simple; either dists or modules can be listed, along
    with empty lines, lines containing whitespace, or comments denoted with the '#'
    character.  Dependencies assume the following syntax:

    - **module** _module::name_ _file_

        The file named for _file_ should be packaged as _module::name_ in the static
        script built.

    - **dist** _dist_

        The file or directory referred to by _dist_ will be included in the static
        script built.

    Example:

        #
        # Script build dependencies
        #
        dist Filesys-POSIX-0.9.1.tar.gz
        dist Mail-Alias-Reader-0.02.tar.gz
        module Foo::Bar::Baz arbitrary/location/Foo/Bar/Baz.pm
        module Foo::Bar::Baz/Boo arbitrary/location/Foo/Bar/Baz/Boo.pm

- **--output** _script_
- **-o** _script_

    This flag specifies the name of the output standalone script file to be created
    or overwritten.

- **--check**
- **-c**

    This flag causes the given main entry point script to be checked against any
    extracted dists, or modules specified, in a temporary directory.

- **--header** _file_
- **-H** _file_

    Allows the specification of a header file to be inserted at the top of the
    output file directly after the Perl shebang.

- **--desc** _string_
- **-D** _string_

    Specifies a value to insert into any instance of the `$Desc$` template that
    may occur in a header.  Requires **--header** or **-h** to be passed.

# RATIONALE

This tool does NOT perform automatic dependency calculation in the form of
either runtime or static analysis; rather, by design, it is meant to allow
for the granular selection of dependencies to target specific environments,
creating standalone Perl scripts in the smallest footprint feasible.

# MECHANISM

The standalone scripts generated by `ppk` are composed of a standard
bootstrapping wrapper, and a `__DATA__` section containing the main entry
point script, and all dependencies, in a base64-encoded tarball created by
tar(1) and gzip(1).  The Perl interpreter used to execute the standalone
script will be used to execute the main entry point script, passing all
arguments from the standalone script's `@ARGV` array directly to the
main entry point script.

Upon initial execution of a generated standalone script, the main entry point
script, as well as its dependencies, are extracted into a temporary directory
that is to be removed upon natural or forced program termination.

# COPYRIGHT

Copyright (c) 2018, cPanel, L.L.C.  All rights reserved.  This is free software;
you can redistribute it and/or modify it under the same terms as Perl itself.
See [perlartistic](https://metacpan.org/pod/perlartistic) for further details.
