/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.util.Pair;
import java.io.Serializable;

public class Span
implements Serializable {
    private static final long serialVersionUID = -3861451490217976693L;
    private int start;
    private int end;

    public Span(int s, int e) {
        this.start = s;
        this.end = e;
    }

    public Span(Span ... spans) {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
        for (Span span : spans) {
            this.expandToInclude(span);
        }
    }

    public static Span fromValues(int val1, int val2) {
        if (val1 <= val2) {
            return new Span(val1, val2);
        }
        return new Span(val2, val1);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public void setEnd(int e) {
        this.end = e;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Span)) {
            return false;
        }
        Span otherSpan = (Span)other;
        return this.start == otherSpan.start && this.end == otherSpan.end;
    }

    public int hashCode() {
        return new Pair<Integer, Integer>(this.start, this.end).hashCode();
    }

    public String toString() {
        return "[" + this.start + "," + this.end + ")";
    }

    public void expandToInclude(Span otherSpan) {
        if (otherSpan.start() < this.start) {
            this.setStart(otherSpan.start());
        }
        if (otherSpan.end() > this.end) {
            this.setEnd(otherSpan.end());
        }
    }

    public boolean contains(Span otherSpan) {
        return this.start <= otherSpan.start && otherSpan.end <= this.end;
    }

    public boolean contains(int i) {
        return this.start <= i && i < this.end;
    }

    public boolean isBefore(Span otherSpan) {
        if (this.contains(otherSpan) || otherSpan.contains(this)) {
            throw new IllegalArgumentException("Span " + this.toString() + " contains otherSpan " + otherSpan + " (or vice versa)");
        }
        return this.end <= otherSpan.start;
    }

    public boolean isAfter(Span otherSpan) {
        if (this.contains(otherSpan) || otherSpan.contains(this)) {
            throw new IllegalArgumentException("Span " + this.toString() + " contains otherSpan " + otherSpan + " (or vice versa)");
        }
        return this.start >= otherSpan.end;
    }
}

