/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractCollinsHeadFinder
implements HeadFinder {
    private static final boolean DEBUG = false;
    protected final TreebankLanguagePack tlp;
    protected Map<String, String[][]> nonTerminalInfo;
    protected String[] defaultRule;
    private String[] defaultLeftRule;
    private String[] defaultRightRule;
    private static final long serialVersionUID = -6540278059442931087L;

    protected AbstractCollinsHeadFinder(TreebankLanguagePack tlp) {
        this.tlp = tlp;
        this.setCategoriesToAvoid(new String[0]);
    }

    protected void setCategoriesToAvoid(String[] categoriesToAvoid) {
        ArrayList<String> asList = new ArrayList<String>(Arrays.asList(categoriesToAvoid));
        asList.add(0, "leftexcept");
        this.defaultLeftRule = new String[asList.size()];
        this.defaultRightRule = new String[asList.size()];
        asList.toArray(this.defaultLeftRule);
        asList.set(0, "rightexcept");
        asList.toArray(this.defaultRightRule);
    }

    protected Tree findMarkedHead(Tree t) {
        return null;
    }

    @Override
    public Tree determineHead(Tree t) {
        return this.determineHead(t, null);
    }

    @Override
    public Tree determineHead(Tree t, Tree parent) {
        if (this.nonTerminalInfo == null) {
            throw new RuntimeException("Classes derived from AbstractCollinsHeadFinder must create and fill HashMap nonTerminalInfo.");
        }
        if (t == null || t.isLeaf()) {
            return null;
        }
        Tree[] kids = t.children();
        Tree theHead = this.findMarkedHead(t);
        if (theHead != null) {
            return theHead;
        }
        if (kids.length == 1) {
            return kids[0];
        }
        return this.determineNonTrivialHead(t, parent);
    }

    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        Tree theHead = null;
        String motherCat = this.tlp.basicCategory(t.label().value());
        String[][] how = this.nonTerminalInfo.get(motherCat);
        if (how == null) {
            if (this.defaultRule != null) {
                return this.traverseLocate(t.children(), this.defaultRule, true);
            }
            return null;
        }
        for (int i = 0; i < how.length; ++i) {
            boolean lastResort = i == how.length - 1;
            theHead = this.traverseLocate(t.children(), how[i], lastResort);
            if (theHead != null) break;
        }
        return theHead;
    }

    protected Tree traverseLocate(Tree[] daughterTrees, String[] how, boolean lastResort) {
        boolean found;
        int headIdx;
        block32: {
            int i;
            headIdx = 0;
            found = false;
            if (how[0].equals("left")) {
                for (i = 1; i < how.length; ++i) {
                    for (headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                        String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                        if (!how[i].equals(childCat)) continue;
                        found = true;
                        break block32;
                    }
                }
            } else if (how[0].equals("leftdis")) {
                for (headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                    String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                    for (i = 1; i < how.length; ++i) {
                        if (!how[i].equals(childCat)) continue;
                        found = true;
                        break block32;
                    }
                }
            } else if (how[0].equals("right")) {
                for (i = 1; i < how.length; ++i) {
                    for (headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                        String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                        if (!how[i].equals(childCat)) continue;
                        found = true;
                        break block32;
                    }
                }
            } else if (how[0].equals("rightdis")) {
                for (headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                    String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                    for (i = 1; i < how.length; ++i) {
                        if (!how[i].equals(childCat)) continue;
                        found = true;
                        break block32;
                    }
                }
            } else if (how[0].equals("leftexcept")) {
                for (headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                    String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                    found = true;
                    for (i = 1; i < how.length; ++i) {
                        if (!how[i].equals(childCat)) continue;
                        found = false;
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            } else if (how[0].equals("rightexcept")) {
                for (headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                    String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                    found = true;
                    for (i = 1; i < how.length; ++i) {
                        if (!how[i].equals(childCat)) continue;
                        found = false;
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            } else {
                throw new RuntimeException("ERROR: invalid direction type " + how[0] + " to nonTerminalInfo map in AbstractCollinsHeadFinder.");
            }
        }
        if (!found) {
            if (lastResort) {
                String[] rule;
                if (how[0].startsWith("left")) {
                    headIdx = 0;
                    rule = this.defaultLeftRule;
                } else {
                    headIdx = daughterTrees.length - 1;
                    rule = this.defaultRightRule;
                }
                Tree child = this.traverseLocate(daughterTrees, rule, false);
                if (child != null) {
                    return child;
                }
            } else {
                return null;
            }
        }
        headIdx = this.postOperationFix(headIdx, daughterTrees);
        return daughterTrees[headIdx];
    }

    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        return headIdx;
    }
}

