/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TinyAttributeImpl
extends TinyNodeImpl {
    public TinyAttributeImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public void setSystemId(String uri) {
    }

    @Override
    public NodeInfo getParent() {
        return this.tree.getNode(this.tree.attParent[this.nodeNr]);
    }

    @Override
    public NodeInfo getRoot() {
        NodeInfo parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    protected long getSequenceNumber() {
        return ((TinyNodeImpl)this.getParent()).getSequenceNumber() + 32768L + (long)(this.nodeNr - this.tree.alpha[this.tree.attParent[this.nodeNr]]);
    }

    @Override
    public final int getNodeKind() {
        return 2;
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.tree.attValue[this.nodeNr];
    }

    @Override
    public String getStringValue() {
        return ((Object)this.tree.attValue[this.nodeNr]).toString();
    }

    @Override
    public int getFingerprint() {
        return this.tree.attCode[this.nodeNr] & 0xFFFFF;
    }

    @Override
    public int getNameCode() {
        return this.tree.attCode[this.nodeNr];
    }

    @Override
    public String getPrefix() {
        int code = this.tree.attCode[this.nodeNr];
        if (!NamePool.isPrefixed(code)) {
            return "";
        }
        return this.tree.getNamePool().getPrefix(code);
    }

    @Override
    public String getDisplayName() {
        return this.tree.getNamePool().getDisplayName(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public String getLocalPart() {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public final String getURI() {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public int getTypeAnnotation() {
        return this.tree.getAttributeAnnotation(this.nodeNr);
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.tree.attTypeCode == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.tree.getConfiguration().getSchemaType(this.tree.getAttributeAnnotation(this.nodeNr));
    }

    @Override
    public Value<? extends AtomicValue> atomize() throws XPathException {
        return this.tree.getTypedValueOfAttribute(this, this.nodeNr);
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        return this.tree.getTypedValueOfAttribute(this, this.nodeNr).iterate();
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append("a");
        buffer.append(Integer.toString(this.tree.attCode[this.nodeNr]));
    }

    @Override
    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        BuiltInAtomicType typeCode = CopyOptions.includes(copyOptions, 4) ? (SimpleType)this.getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
        out.attribute(new NameOfNode(this), typeCode, this.getStringValue(), locationId, 0);
    }

    @Override
    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.getParent().getColumnNumber();
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public boolean isId() {
        return this.tree.isIdAttribute(this.nodeNr);
    }

    @Override
    public boolean isIdref() {
        return this.tree.isIdrefAttribute(this.nodeNr);
    }

    @Override
    public int hashCode() {
        return (int)(this.tree.getDocumentNumber() & 0x3FFL) << 20 ^ this.nodeNr ^ 0xE0000;
    }
}

