# Generated by default/object.tt
package Paws::Chime::ChannelBan;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Paws::Chime::Identity');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has Member => (is => 'ro', isa => 'Paws::Chime::Identity');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::ChannelBan

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::ChannelBan object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Member => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::ChannelBan object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

The details of a channel ban.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the channel from which a member is being banned.


=head2 CreatedBy => L<Paws::Chime::Identity>

The C<AppInstanceUser> who created the ban.


=head2 CreatedTimestamp => Str

The time at which the ban was created.


=head2 Member => L<Paws::Chime::Identity>

The member being banned from the channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

