/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TemplatesHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.StylesheetSpaceStrippingRule;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import org.xml.sax.Locator;

public class TemplatesHandlerImpl
extends ReceivingContentHandler
implements TemplatesHandler {
    private LinkedTreeBuilder builder;
    private StyleNodeFactory nodeFactory;
    private Templates templates;
    private String systemId;

    protected TemplatesHandlerImpl(Configuration config) {
        this.setPipelineConfiguration(config.makePipelineConfiguration());
        this.nodeFactory = config.makeStyleNodeFactory();
        this.builder = new LinkedTreeBuilder(this.getPipelineConfiguration());
        this.builder.setNodeFactory(this.nodeFactory);
        this.builder.setLineNumbering(true);
        UseWhenFilter useWhenFilter = new UseWhenFilter(this.builder);
        StartTagBuffer startTagBuffer = new StartTagBuffer(useWhenFilter);
        useWhenFilter.setStartTagBuffer(startTagBuffer);
        StylesheetSpaceStrippingRule rule = new StylesheetSpaceStrippingRule(config.getNamePool());
        Stripper styleStripper = new Stripper(rule, startTagBuffer);
        CommentStripper commentStripper = new CommentStripper(styleStripper);
        this.setReceiver(commentStripper);
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl doc = (DocumentImpl)this.builder.getCurrentRoot();
            this.builder.reset();
            if (doc == null) {
                return null;
            }
            Configuration config = this.getConfiguration();
            CompilerInfo info = new CompilerInfo(config.getDefaultXsltCompilerInfo());
            info.setXsltVersion(this.nodeFactory.getXsltProcessorVersion());
            PreparedStylesheet sheet = new PreparedStylesheet(config, info);
            try {
                sheet.setStylesheetDocument(doc);
                this.templates = sheet;
            }
            catch (XPathException tce) {
                if (!tce.hasBeenReported()) {
                    try {
                        info.getErrorListener().fatalError(tce);
                    }
                    catch (TransformerException e2) {
                        // empty catch block
                    }
                }
                throw new IllegalStateException(tce.getMessage());
            }
        }
        return this.templates;
    }

    public void setSystemId(String url) {
        this.systemId = url;
        this.builder.setSystemId(url);
        super.setDocumentLocator(new Locator(){

            public int getColumnNumber() {
                return -1;
            }

            public int getLineNumber() {
                return -1;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return TemplatesHandlerImpl.this.systemId;
            }
        });
    }

    public void setDocumentLocator(Locator locator) {
        if (this.systemId == null) {
            super.setDocumentLocator(locator);
        }
    }

    public String getSystemId() {
        return this.systemId;
    }
}

