# Generated by default/object.tt
package Paws::EMRContainers::ConfigurationOverrides;
  use Moose;
  has ApplicationConfiguration => (is => 'ro', isa => 'ArrayRef[Paws::EMRContainers::Configuration]', request_name => 'applicationConfiguration', traits => ['NameInRequest']);
  has MonitoringConfiguration => (is => 'ro', isa => 'Paws::EMRContainers::MonitoringConfiguration', request_name => 'monitoringConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMRContainers::ConfigurationOverrides

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMRContainers::ConfigurationOverrides object:

  $service_obj->Method(Att1 => { ApplicationConfiguration => $value, ..., MonitoringConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMRContainers::ConfigurationOverrides object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplicationConfiguration

=head1 DESCRIPTION

A configuration specification to be used to override existing
configurations.

=head1 ATTRIBUTES


=head2 ApplicationConfiguration => ArrayRef[L<Paws::EMRContainers::Configuration>]

The configurations for the application running by the job run.


=head2 MonitoringConfiguration => L<Paws::EMRContainers::MonitoringConfiguration>

The configurations for monitoring.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMRContainers>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

