# Generated by default/object.tt
package Paws::Macie2::ResourcesAffected;
  use Moose;
  has S3Bucket => (is => 'ro', isa => 'Paws::Macie2::S3Bucket', request_name => 's3Bucket', traits => ['NameInRequest']);
  has S3Object => (is => 'ro', isa => 'Paws::Macie2::S3Object', request_name => 's3Object', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::ResourcesAffected

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::ResourcesAffected object:

  $service_obj->Method(Att1 => { S3Bucket => $value, ..., S3Object => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::ResourcesAffected object:

  $result = $service_obj->Method(...);
  $result->Att1->S3Bucket

=head1 DESCRIPTION

Provides information about the resources that a finding applies to.

=head1 ATTRIBUTES


=head2 S3Bucket => L<Paws::Macie2::S3Bucket>

The details of the S3 bucket that the finding applies to.


=head2 S3Object => L<Paws::Macie2::S3Object>

The details of the S3 object that the finding applies to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

