#!/usr/bin/perl -w

use strict;

use Test::More tests => 29;

use lib "t/lib";
use Test::FloatNear;

BEGIN {
	if ($] >= 5.006){
		require Fcntl; Fcntl->import(qw/SEEK_SET/);
	} else {
		require POSIX; POSIX->import(qw/SEEK_SET/);
	}
}

BEGIN { use_ok("MPEG::Audio::Frame") }

{
	isa_ok(my $frame = MPEG::Audio::Frame->read(\*DATA), "MPEG::Audio::Frame");
	ok(!$frame->has_crc, "no crc in frame");
	ok(!$frame->broken, "crc check returns true if no crc");
	is($frame->bitrate, 128, "bitrate");
	is($frame->sample, 44100, "sample rate");
	is_near($frame->seconds, 0.0261, "duration");
	is($frame->length, 418, "calculated byte length");
	is(length("$frame"), $frame->length, "actual byte length");

	seek DATA, $frame->offset, SEEK_SET;
	read DATA, my $data, $frame->length;
	is($data, $frame->asbin, "asbin returns data from handle");
}

{ # a different frame
	isa_ok(my $frame = MPEG::Audio::Frame->read(\*DATA), "MPEG::Audio::Frame");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "CRC is good");
	is($frame->bitrate, 224, "bitrate");
	is($frame->sample, 44100, "sample rate");
	is_near($frame->seconds, 0.0261, "duration");
	is($frame->length, 731, "calculated byte length");
	is(length("$frame"), $frame->length, "actual byte length");

	seek DATA, $frame->offset, SEEK_SET;
	read DATA, my $data, $frame->length;
	is($data, "$frame", "asbin through overload returns data from handle");
}

{ # yet another
	isa_ok(my $frame = MPEG::Audio::Frame->read(\*DATA), "MPEG::Audio::Frame");
	ok(!$frame->has_crc, "frame has no CRC");
	ok(!$frame->broken, "crc check returns true if no crc");
	is($frame->bitrate, 320, "bitrate");
	is($frame->sample, 44100, "sample rate");
	is(int($frame->seconds()*10000), 261, "duration");
	is($frame->length, 1045, "calculated byte length");
	is(length("$frame"), $frame->length, "actual byte length");

	seek DATA, $frame->offset, SEEK_SET;
	read DATA, my $data, $frame->length;
	is($data, "$frame", "asbin through overload returns data from handle");
}

ok(!MPEG::Audio::Frame->read(\*DATA), "no mpeg audio left in DATA");

__DATA__
the following data is used to test the module.

and mp3 header and frame will follow this (text|garbage)
and will be parsed and munged and whatever.

here goes nothing...



@     7                                                                                                                                                                                                                                                                                                                                                                                                                  



this is more garbage to be ignored


dgskjhag
  ɊH&N  HH e"= 
jK    c :#f;+\o >5gbqO
P(%1s?&.A"69O'ly+a*r.W"S"PhOfPr.nE|n\.x
Si*oG@0 <No | Y8 	L\1da8ȟ,"9  ,"c0A
@Șx6Arό7 Pо_7p00
D=1sA%YhROA0=AE$afbI%EM$ffkRUUzUj[<L)}JU}ko<ԳZC#3[G2.lӠ55TseC4VUokhY4u0L<
(Fh"̰TB8ӵT4SS3C̔5Egh&ٗ.
|pюu-:[^RߨMme$MTP
y
:~]9&oRLPFP6]A>etMC#=3LsBphq\`YF
	0Ѐsh>!hBYt4b`Y(nQ&<

dgkuwj more ʬĩϫgarbage&&$Y n4bnoet
aӲyco17*T1FIlƟ9;Wj.~I$K?8_nHփ,3PZ~\x,%+̎yb <G	 ͐> \HIDFG*|'GIѸU90FrcUNt
7ZGswcuퟹ}٤ɵOڟXd xb2",y8n	jLgXc faų  ?2Mj@ 6ziD3ȍî5/Vd'V3c
49(\	3H'
`!#4%
˜
ĚŦ	D2Xڐ5JLibi.rDJ fMd  3DH Pū@k!A؊%\i8T}Anh <P
bϴUMJ28.ܧ!dЧg)Th]V'n[Yܡxɸ5jh~lKn_?7jk-[U)j-6fnUn4F|T_jR />L!Ow?O|"(qZMl%^r
verujrȨ_	i> y6@ҰI&*|$I lyLVۭyՖP;wqU%M]nJ^Q^C)F)ou*                                                                                                                                                `  |aNpj ane͇4-HI%y4k:l1hG12400	-
$,
 ,. &)(&0TʁG"Hk-Q
p-@*
(4W/0
)3M牫T%{olMQ"yop7X7q{xa-A?&fYQ6@ o($:Po6JC<cYM^]?WT;~eb!a%ߡё:J:}v"D0 .AbPQxaoGPZmH)"*4@qX`  
OV` 
tƜ $U>Z/(Þ MG0C$AB8hA2$)31a,/˕Đvr`H "(B!`б 4d# p<,.b0nEJ!!0`Y)ЬD@}
B( lx:p1R1 $	Qy|t\b~"6&I(Q-kD1E2	Ht_Dh:iDШ]iDIi x[ƨ̊QYlԐ,}_QuNE(_     %FpaRy7/Tp务YI(F6vaᒧdb.YtS<%S
gR,q%B.24y7K!lx0T}hgfy)4٩oNy8c
y3@cɌ%H}{x[A.o&e,>뾔j˽tFN" p PaZluf\|<Tc
5b@SJ"H%48&3eD1+J^IP&:Q%0d.[`rARv	
:
ti	nSWPen"t;0'D}K!}K)1ߤG;=%5vnQv5o-e7uR Z*U~6+"w/Gmz
~^r3dq`'dcL."TĲc"F Bڷ/ZyX@-H5uy{mA~}EgbofX?/ٳ[}>*
Y-                                                                                                                                                `  [IcrEf$#\{c-p
q H=PG*X+x:M8_c{mxP:ʌ$:9,r0XlrdF*JD/8=<H"/֌|]#koYgAlk']/n*nOR-690t $'   _MrE)N
FAz+de0ko7"
