[![Build Status](https://travis-ci.org/fluent/fluent-logger-perl.svg?branch=master)](https://travis-ci.org/fluent/fluent-logger-perl)
# NAME

Fluent::Logger - A structured event logger for Fluent

# SYNOPSIS

    use Fluent::Logger;
    
    my $logger = Fluent::Logger->new(
        host => '127.0.0.1',
        port => 24224,
    );
    $logger->post("myapp.access", { "agent" => "foo" });
    # output: myapp.access {"agent":"foo"}
    
    my $logger = Fluent::Logger->new(
        tag_prefix => 'myapp',
        host       => '127.0.0.1',
        port       => 24224,
    );
    $logger->post("access", { "agent" => "foo" });
    # output: myapp.access {"agent":"foo"}

# DESCRIPTION

Fluent::Logger is a structured event logger for Fluent.

# METHODS

- **new**(%args)

    create new logger instance.

    %args:

        tag_prefix     => 'Str':  optional
        host           => 'Str':  default is '127.0.0.1'
        port           => 'Int':  default is 24224
        timeout        => 'Num':  default is 3.0
        socket         => 'Str':  default undef (e.g. "/var/run/fluent/fluent.sock")
        prefer_integer => 'Bool': default 1 (set to Data::MessagePack->prefer_integer)
        event_time     => 'Bool': default 0 (timestamp includes nanoseconds, supported by fluentd >= 0.14.0)

- **post**($tag:Str, $msg:HashRef)

    Send message to fluent server with tag.

    Return bytes length of written messages.

    If event\_time is set to true, log's timestamp includes nanoseconds.

- **post\_with\_time**($tag:Str, $msg:HashRef, $time:Int|Float)

    Send message to fluent server with tag and time.

    If event\_time is set to true, $time argument accepts Float value (such as Time::HiRes::time()).

- **close**()

    close connection.

    If the logger has pending data, flushing it to server on close.

- **errstr**

    return error message.

        $logger->post( info => { "msg": "test" } )
            or die $logger->errstr;

# AUTHOR

HIROSE Masaaki <hirose31 \_at\_ gmail.com>

Shinichiro Sei <sei \_at\_ kayac.com>

FUJIWARA Shunichiro <fujiwara \_at\_ cpan.org>

# THANKS TO

Kazuki Ohta

FURUHASHI Sadayuki

lestrrat

# REPOSITORY

[https://github.com/fluent/fluent-logger-perl](https://github.com/fluent/fluent-logger-perl)

    git clone git://github.com/fluent/fluent-logger-perl.git

patches and collaborators are welcome.

# SEE ALSO

[http://fluent.github.com/](http://fluent.github.com/)

# COPYRIGHT & LICENSE

Copyright FUJIWARA Shunichiro

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
