#!/usr/bin/perl

package eBay::API::XML::Call::GetMyeBayReminders;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMyeBayReminders.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMyeBayReminders

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMyeBayReminders inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersRequestType;
use eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetMyeBayReminders';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersResponseType';
}

#
# input properties
#

=head2 setBuyingReminders()

Specifies the type of buying reminders for which you want information.

  RequiredInput: No
#    Argument: 'ns:ReminderCustomizationType'

=cut
       
sub setBuyingReminders {
   my $self   = shift;
   my $pBuyingReminders = shift;
   $self->getRequestDataType()->setBuyingReminders($pBuyingReminders);
}

=head2 setSellingReminders()

Specifies the type of selling reminders for which you want information.

  RequiredInput: No
#    Argument: 'ns:ReminderCustomizationType'

=cut
       
sub setSellingReminders {
   my $self   = shift;
   my $pSellingReminders = shift;
   $self->getRequestDataType()->setSellingReminders($pSellingReminders);
}



#
# output properties
#

=head2 getBuyingReminders()

Contains the buying reminders in the user's My eBay account that match
the request criteria.

  Returned: Conditionally
#    Returns: 'ns:RemindersType'

=cut
       
sub getBuyingReminders {
   my $self = shift;
   return $self->getResponseDataType()->getBuyingReminders();
}

=head2 getSellingReminders()

Contains the selling reminders in the user's My eBay account that match
the request criteria.

  Returned: Conditionally
#    Returns: 'ns:RemindersType'

=cut
       
sub getSellingReminders {
   my $self = shift;
   return $self->getResponseDataType()->getSellingReminders();
}





1;   
