/*
    KWin - the KDE window manager
    This file is part of the KDE project.

    SPDX-FileCopyrightText: 2021 Xaver Hugl <xaver.hugl@gmail.com>

    SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once

#include "core/backendoutput.h"

namespace KWin
{

class DrmBackend;
class DrmOutputLayer;
class OutputFrame;

class DrmAbstractOutput : public BackendOutput
{
    Q_OBJECT
public:
    explicit DrmAbstractOutput();

    RenderLoop *renderLoop() const override;

protected:
    friend class DrmGpu;

    std::unique_ptr<RenderLoop> m_renderLoop;
};

}
