/*
    KWin - the KDE window manager
    This file is part of the KDE project.

    SPDX-FileCopyrightText: 2015 Martin Gräßlin <mgraesslin@kde.org>

    SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once

#include "core/outputlayer.h"
#include "core/renderbackend.h"
#include "qpainter/qpainterbackend.h"

#include <QList>
#include <QMap>
#include <QObject>
#include <chrono>
#include <memory>

namespace KWin
{

class GraphicsBufferAllocator;
class QPainterSwapchainSlot;
class QPainterSwapchain;
class VirtualBackend;
class VirtualQPainterBackend;

class VirtualQPainterLayer : public OutputLayer
{
public:
    VirtualQPainterLayer(BackendOutput *output, VirtualQPainterBackend *backend);
    ~VirtualQPainterLayer() override;

    std::optional<OutputLayerBeginFrameInfo> doBeginFrame() override;
    bool doEndFrame(const Region &renderedDeviceRegion, const Region &damagedDeviceRegion, OutputFrame *frame) override;
    QImage *image();
    DrmDevice *scanoutDevice() const override;
    QHash<uint32_t, QList<uint64_t>> supportedDrmFormats() const override;
    void releaseBuffers() override;

private:
    VirtualQPainterBackend *const m_backend;
    std::unique_ptr<QPainterSwapchain> m_swapchain;
    std::shared_ptr<QPainterSwapchainSlot> m_current;
    std::unique_ptr<CpuRenderTimeQuery> m_renderTime;
};

class VirtualQPainterBackend : public QPainterBackend
{
    Q_OBJECT
public:
    VirtualQPainterBackend(VirtualBackend *backend);
    ~VirtualQPainterBackend() override;

    GraphicsBufferAllocator *graphicsBufferAllocator() const;

    QList<OutputLayer *> compatibleOutputLayers(BackendOutput *output) override;

private:
    void addOutput(BackendOutput *output);

    VirtualBackend *const m_backend;
    std::unique_ptr<GraphicsBufferAllocator> m_allocator;
};

} // namespace KWin
