/* Copyright (C) 2025 Wildfire Games.
 * This file is part of 0 A.D.
 *
 * 0 A.D. is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * 0 A.D. is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 0 A.D.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INCLUDED_ICMPPARTICLEMANAGER
#define INCLUDED_ICMPPARTICLEMANAGER

#include "simulation2/system/Component.h"
#include "simulation2/system/Interface.h"

#include <js/Value.h>

/**
 * Minimal interface for particle rendering
 */
class ICmpParticleManager : public IComponent
{
public:

	/**
	 * Set whether particle rendering should use sim time
	 * If false, it uses real time and updates even during paused game
	 */
	virtual void SetUseSimTime(bool flag) = 0;

	DECLARE_INTERFACE_TYPE(ParticleManager)
};

#endif // INCLUDED_ICMPPARTICLEMANAGER
