#line 534 "filter/decl.m4"


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmisleading-indentation"
#endif

#include "nest/bird.h"
#include "filter/filter.h"
#include "filter/f-inst.h"

/* Instruction codes to string */
static const char * const f_instruction_name_str[] = {
#line 288 "filter/f-inst.c"
 /* Code enum to string for FI_ADD */
#line 288
  [FI_ADD] = "FI_ADD",
#line 293 "filter/f-inst.c"
 /* Code enum to string for FI_SUBTRACT */
#line 293
  [FI_SUBTRACT] = "FI_SUBTRACT",
#line 298 "filter/f-inst.c"
 /* Code enum to string for FI_MULTIPLY */
#line 298
  [FI_MULTIPLY] = "FI_MULTIPLY",
#line 304 "filter/f-inst.c"
 /* Code enum to string for FI_DIVIDE */
#line 304
  [FI_DIVIDE] = "FI_DIVIDE",
#line 309 "filter/f-inst.c"
 /* Code enum to string for FI_BITOR */
#line 309
  [FI_BITOR] = "FI_BITOR",
#line 314 "filter/f-inst.c"
 /* Code enum to string for FI_BITAND */
#line 314
  [FI_BITAND] = "FI_BITAND",
#line 324 "filter/f-inst.c"
 /* Code enum to string for FI_AND */
#line 324
  [FI_AND] = "FI_AND",
#line 335 "filter/f-inst.c"
 /* Code enum to string for FI_OR */
#line 335
  [FI_OR] = "FI_OR",
#line 345 "filter/f-inst.c"
 /* Code enum to string for FI_PAIR_CONSTRUCT */
#line 345
  [FI_PAIR_CONSTRUCT] = "FI_PAIR_CONSTRUCT",
#line 385 "filter/f-inst.c"
 /* Code enum to string for FI_EC_CONSTRUCT */
#line 385
  [FI_EC_CONSTRUCT] = "FI_EC_CONSTRUCT",
#line 392 "filter/f-inst.c"
 /* Code enum to string for FI_LC_CONSTRUCT */
#line 392
  [FI_LC_CONSTRUCT] = "FI_LC_CONSTRUCT",
#line 442 "filter/f-inst.c"
 /* Code enum to string for FI_PATHMASK_CONSTRUCT */
#line 442
  [FI_PATHMASK_CONSTRUCT] = "FI_PATHMASK_CONSTRUCT",
#line 449 "filter/f-inst.c"
 /* Code enum to string for FI_NEQ */
#line 449
  [FI_NEQ] = "FI_NEQ",
#line 456 "filter/f-inst.c"
 /* Code enum to string for FI_EQ */
#line 456
  [FI_EQ] = "FI_EQ",
#line 467 "filter/f-inst.c"
 /* Code enum to string for FI_LT */
#line 467
  [FI_LT] = "FI_LT",
#line 478 "filter/f-inst.c"
 /* Code enum to string for FI_LTE */
#line 478
  [FI_LTE] = "FI_LTE",
#line 483 "filter/f-inst.c"
 /* Code enum to string for FI_NOT */
#line 483
  [FI_NOT] = "FI_NOT",
#line 492 "filter/f-inst.c"
 /* Code enum to string for FI_MATCH */
#line 492
  [FI_MATCH] = "FI_MATCH",
#line 501 "filter/f-inst.c"
 /* Code enum to string for FI_NOT_MATCH */
#line 501
  [FI_NOT_MATCH] = "FI_NOT_MATCH",
#line 506 "filter/f-inst.c"
 /* Code enum to string for FI_DEFINED */
#line 506
  [FI_DEFINED] = "FI_DEFINED",
#line 507 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__type */
#line 507
  [FI_METHOD__T_NET__type] = "FI_METHOD__T_NET__type",
#line 510 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_IP__is_v4 */
#line 510
  [FI_METHOD__T_IP__is_v4] = "FI_METHOD__T_IP__is_v4",
#line 523 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_INIT */
#line 523
  [FI_VAR_INIT] = "FI_VAR_INIT",
#line 534 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_INIT0 */
#line 534
  [FI_VAR_INIT0] = "FI_VAR_INIT0",
#line 543 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_SET */
#line 543
  [FI_VAR_SET] = "FI_VAR_SET",
#line 550 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_GET */
#line 550
  [FI_VAR_GET] = "FI_VAR_GET",
#line 563 "filter/f-inst.c"
 /* Code enum to string for FI_CONSTANT */
#line 563
  [FI_CONSTANT] = "FI_CONSTANT",
#line 564 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__empty */
#line 564
  [FI_METHOD__T_PATH__empty] = "FI_METHOD__T_PATH__empty",
#line 565 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__empty */
#line 565
  [FI_METHOD__T_CLIST__empty] = "FI_METHOD__T_CLIST__empty",
#line 566 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__empty */
#line 566
  [FI_METHOD__T_ECLIST__empty] = "FI_METHOD__T_ECLIST__empty",
#line 569 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__empty */
#line 569
  [FI_METHOD__T_LCLIST__empty] = "FI_METHOD__T_LCLIST__empty",
#line 591 "filter/f-inst.c"
 /* Code enum to string for FI_FOR_LOOP_START */
#line 591
  [FI_FOR_LOOP_START] = "FI_FOR_LOOP_START",
#line 600 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_FOR_NEXT */
#line 600
  [FI_PATH_FOR_NEXT] = "FI_PATH_FOR_NEXT",
#line 609 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FOR_NEXT */
#line 609
  [FI_CLIST_FOR_NEXT] = "FI_CLIST_FOR_NEXT",
#line 618 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FOR_NEXT */
#line 618
  [FI_ECLIST_FOR_NEXT] = "FI_ECLIST_FOR_NEXT",
#line 627 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FOR_NEXT */
#line 627
  [FI_LCLIST_FOR_NEXT] = "FI_LCLIST_FOR_NEXT",
#line 640 "filter/f-inst.c"
 /* Code enum to string for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  [FI_ROUTES_BLOCK_FOR_NEXT] = "FI_ROUTES_BLOCK_FOR_NEXT",
#line 648 "filter/f-inst.c"
 /* Code enum to string for FI_CONDITION */
#line 648
  [FI_CONDITION] = "FI_CONDITION",
#line 661 "filter/f-inst.c"
 /* Code enum to string for FI_PRINT */
#line 661
  [FI_PRINT] = "FI_PRINT",
#line 668 "filter/f-inst.c"
 /* Code enum to string for FI_FLUSH */
#line 668
  [FI_FLUSH] = "FI_FLUSH",
#line 682 "filter/f-inst.c"
 /* Code enum to string for FI_DIE */
#line 682
  [FI_DIE] = "FI_DIE",
#line 689 "filter/f-inst.c"
 /* Code enum to string for FI_CURRENT_ROUTE */
#line 689
  [FI_CURRENT_ROUTE] = "FI_CURRENT_ROUTE",
#line 736 "filter/f-inst.c"
 /* Code enum to string for FI_RTA_GET */
#line 736
  [FI_RTA_GET] = "FI_RTA_GET",
#line 864 "filter/f-inst.c"
 /* Code enum to string for FI_RTA_SET */
#line 864
  [FI_RTA_SET] = "FI_RTA_SET",
#line 901 "filter/f-inst.c"
 /* Code enum to string for FI_EA_GET */
#line 901
  [FI_EA_GET] = "FI_EA_GET",
#line 942 "filter/f-inst.c"
 /* Code enum to string for FI_EA_SET */
#line 942
  [FI_EA_SET] = "FI_EA_SET",
#line 949 "filter/f-inst.c"
 /* Code enum to string for FI_EA_UNSET */
#line 949
  [FI_EA_UNSET] = "FI_EA_UNSET",
#line 963 "filter/f-inst.c"
 /* Code enum to string for FI_DEFAULT */
#line 963
  [FI_DEFAULT] = "FI_DEFAULT",
#line 964 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__len */
#line 964
  [FI_METHOD__T_NET__len] = "FI_METHOD__T_NET__len",
#line 965 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__len */
#line 965
  [FI_METHOD__T_PATH__len] = "FI_METHOD__T_PATH__len",
#line 966 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__len */
#line 966
  [FI_METHOD__T_CLIST__len] = "FI_METHOD__T_CLIST__len",
#line 967 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__len */
#line 967
  [FI_METHOD__T_ECLIST__len] = "FI_METHOD__T_ECLIST__len",
#line 969 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__len */
#line 969
  [FI_METHOD__T_LCLIST__len] = "FI_METHOD__T_LCLIST__len",
#line 1005 "filter/f-inst.c"
 /* Code enum to string for FI_NET_SRC */
#line 1005
  [FI_NET_SRC] = "FI_NET_SRC",
#line 1042 "filter/f-inst.c"
 /* Code enum to string for FI_NET_DST */
#line 1042
  [FI_NET_DST] = "FI_NET_DST",
#line 1052 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__maxlen */
#line 1052
  [FI_METHOD__T_NET__maxlen] = "FI_METHOD__T_NET__maxlen",
#line 1062 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__asn */
#line 1062
  [FI_METHOD__T_NET__asn] = "FI_METHOD__T_NET__asn",
#line 1064 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__ip */
#line 1064
  [FI_METHOD__T_NET__ip] = "FI_METHOD__T_NET__ip",
#line 1073 "filter/f-inst.c"
 /* Code enum to string for FI_ROUTE_DISTINGUISHER */
#line 1073
  [FI_ROUTE_DISTINGUISHER] = "FI_ROUTE_DISTINGUISHER",
#line 1076 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__first */
#line 1076
  [FI_METHOD__T_PATH__first] = "FI_METHOD__T_PATH__first",
#line 1079 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__last */
#line 1079
  [FI_METHOD__T_PATH__last] = "FI_METHOD__T_PATH__last",
#line 1082 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
  [FI_METHOD__T_PATH__last_nonaggregated] = "FI_METHOD__T_PATH__last_nonaggregated",
#line 1085 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PAIR__asn */
#line 1085
  [FI_METHOD__T_PAIR__asn] = "FI_METHOD__T_PAIR__asn",
#line 1088 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PAIR__data */
#line 1088
  [FI_METHOD__T_PAIR__data] = "FI_METHOD__T_PAIR__data",
#line 1091 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__asn */
#line 1091
  [FI_METHOD__T_LC__asn] = "FI_METHOD__T_LC__asn",
#line 1094 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__data1 */
#line 1094
  [FI_METHOD__T_LC__data1] = "FI_METHOD__T_LC__data1",
#line 1097 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__data2 */
#line 1097
  [FI_METHOD__T_LC__data2] = "FI_METHOD__T_LC__data2",
#line 1100 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__min */
#line 1100
  [FI_METHOD__T_CLIST__min] = "FI_METHOD__T_CLIST__min",
#line 1103 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__max */
#line 1103
  [FI_METHOD__T_CLIST__max] = "FI_METHOD__T_CLIST__max",
#line 1106 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__min */
#line 1106
  [FI_METHOD__T_ECLIST__min] = "FI_METHOD__T_ECLIST__min",
#line 1109 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__max */
#line 1109
  [FI_METHOD__T_ECLIST__max] = "FI_METHOD__T_ECLIST__max",
#line 1112 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__min */
#line 1112
  [FI_METHOD__T_LCLIST__min] = "FI_METHOD__T_LCLIST__min",
#line 1114 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__max */
#line 1114
  [FI_METHOD__T_LCLIST__max] = "FI_METHOD__T_LCLIST__max",
#line 1140 "filter/f-inst.c"
 /* Code enum to string for FI_RETURN */
#line 1140
  [FI_RETURN] = "FI_RETURN",
#line 1200 "filter/f-inst.c"
 /* Code enum to string for FI_CALL */
#line 1200
  [FI_CALL] = "FI_CALL",
#line 1205 "filter/f-inst.c"
 /* Code enum to string for FI_DROP_RESULT */
#line 1205
  [FI_DROP_RESULT] = "FI_DROP_RESULT",
#line 1246 "filter/f-inst.c"
 /* Code enum to string for FI_SWITCH */
#line 1246
  [FI_SWITCH] = "FI_SWITCH",
#line 1255 "filter/f-inst.c"
 /* Code enum to string for FI_IP_MASK */
#line 1255
  [FI_IP_MASK] = "FI_IP_MASK",
#line 1263 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_PREPEND */
#line 1263
  [FI_PATH_PREPEND] = "FI_PATH_PREPEND",
#line 1270 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_PAIR */
#line 1270
  [FI_CLIST_ADD_PAIR] = "FI_CLIST_ADD_PAIR",
#line 1284 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_IP */
#line 1284
  [FI_CLIST_ADD_IP] = "FI_CLIST_ADD_IP",
#line 1291 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_QUAD */
#line 1291
  [FI_CLIST_ADD_QUAD] = "FI_CLIST_ADD_QUAD",
#line 1298 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_CLIST */
#line 1298
  [FI_CLIST_ADD_CLIST] = "FI_CLIST_ADD_CLIST",
#line 1305 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_ADD_EC */
#line 1305
  [FI_ECLIST_ADD_EC] = "FI_ECLIST_ADD_EC",
#line 1312 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_ADD_ECLIST */
#line 1312
  [FI_ECLIST_ADD_ECLIST] = "FI_ECLIST_ADD_ECLIST",
#line 1319 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_ADD_LC */
#line 1319
  [FI_LCLIST_ADD_LC] = "FI_LCLIST_ADD_LC",
#line 1326 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_ADD_LCLIST */
#line 1326
  [FI_LCLIST_ADD_LCLIST] = "FI_LCLIST_ADD_LCLIST",
#line 1333 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_DELETE_INT */
#line 1333
  [FI_PATH_DELETE_INT] = "FI_PATH_DELETE_INT",
#line 1345 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_DELETE_SET */
#line 1345
  [FI_PATH_DELETE_SET] = "FI_PATH_DELETE_SET",
#line 1352 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_PAIR */
#line 1352
  [FI_CLIST_DELETE_PAIR] = "FI_CLIST_DELETE_PAIR",
#line 1366 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_IP */
#line 1366
  [FI_CLIST_DELETE_IP] = "FI_CLIST_DELETE_IP",
#line 1373 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_QUAD */
#line 1373
  [FI_CLIST_DELETE_QUAD] = "FI_CLIST_DELETE_QUAD",
#line 1380 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_CLIST */
#line 1380
  [FI_CLIST_DELETE_CLIST] = "FI_CLIST_DELETE_CLIST",
#line 1391 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_SET */
#line 1391
  [FI_CLIST_DELETE_SET] = "FI_CLIST_DELETE_SET",
#line 1398 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_EC */
#line 1398
  [FI_ECLIST_DELETE_EC] = "FI_ECLIST_DELETE_EC",
#line 1405 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_ECLIST */
#line 1405
  [FI_ECLIST_DELETE_ECLIST] = "FI_ECLIST_DELETE_ECLIST",
#line 1416 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_SET */
#line 1416
  [FI_ECLIST_DELETE_SET] = "FI_ECLIST_DELETE_SET",
#line 1423 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_LC */
#line 1423
  [FI_LCLIST_DELETE_LC] = "FI_LCLIST_DELETE_LC",
#line 1430 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_LCLIST */
#line 1430
  [FI_LCLIST_DELETE_LCLIST] = "FI_LCLIST_DELETE_LCLIST",
#line 1441 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_SET */
#line 1441
  [FI_LCLIST_DELETE_SET] = "FI_LCLIST_DELETE_SET",
#line 1452 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_FILTER_SET */
#line 1452
  [FI_PATH_FILTER_SET] = "FI_PATH_FILTER_SET",
#line 1459 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FILTER_CLIST */
#line 1459
  [FI_CLIST_FILTER_CLIST] = "FI_CLIST_FILTER_CLIST",
#line 1470 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FILTER_SET */
#line 1470
  [FI_CLIST_FILTER_SET] = "FI_CLIST_FILTER_SET",
#line 1477 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FILTER_ECLIST */
#line 1477
  [FI_ECLIST_FILTER_ECLIST] = "FI_ECLIST_FILTER_ECLIST",
#line 1488 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FILTER_SET */
#line 1488
  [FI_ECLIST_FILTER_SET] = "FI_ECLIST_FILTER_SET",
#line 1495 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FILTER_LCLIST */
#line 1495
  [FI_LCLIST_FILTER_LCLIST] = "FI_LCLIST_FILTER_LCLIST",
#line 1506 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FILTER_SET */
#line 1506
  [FI_LCLIST_FILTER_SET] = "FI_LCLIST_FILTER_SET",
#line 1528 "filter/f-inst.c"
 /* Code enum to string for FI_ROA_CHECK */
#line 1528
  [FI_ROA_CHECK] = "FI_ROA_CHECK",
#line 1544 "filter/f-inst.c"
 /* Code enum to string for FI_ASPA_CHECK_EXPLICIT */
#line 1544
  [FI_ASPA_CHECK_EXPLICIT] = "FI_ASPA_CHECK_EXPLICIT",
#line 1559 "filter/f-inst.c"
 /* Code enum to string for FI_FROM_HEX */
#line 1559
  [FI_FROM_HEX] = "FI_FROM_HEX",
#line 1564 "filter/f-inst.c"
 /* Code enum to string for FI_FORMAT */
#line 1564
  [FI_FORMAT] = "FI_FORMAT",
#line 830 "filter/decl.m4"
 /* Code enum to string for FI_ASSERT */
#line 830
  [FI_ASSERT] = "FI_ASSERT",
#line 547 "filter/decl.m4"

};

const char *
f_instruction_name_(enum f_instruction_code fi)
{
  if (fi < (sizeof(f_instruction_name_str) / sizeof(f_instruction_name_str[0])))
    return f_instruction_name_str[fi];
  else
    bug("Got unknown instruction code: %d", fi);
}

static inline struct f_inst *
fi_new(enum f_instruction_code fi_code)
{
  struct f_inst *what = tmp_allocz(sizeof(struct f_inst));
  what->lineno = ifs->lino;
  what->size = 1;
  what->fi_code = fi_code;
  return what;
}

static inline struct f_inst *
fi_constant(struct f_inst *what, struct f_val val)
{
  what->fi_code = FI_CONSTANT;
  what->i_FI_CONSTANT.val = val;
  return what;
}

int
f_const_promotion_(struct f_inst *arg, btype want, int update)
{
  if (arg->fi_code != FI_CONSTANT)
    return 0;

  struct f_val *c = &arg->i_FI_CONSTANT.val;

  if ((c->type == T_IP) && ipa_is_ip4(c->val.ip) && (want == T_QUAD)) {
    if (update)
      *c = (struct f_val) {
        .type = T_QUAD,
        .val.i = ipa_to_u32(c->val.ip),
      };
    return 1;
  }

  else if ((c->type == T_SET) && (!c->val.t) && (want == T_PREFIX_SET)) {
    if (update)
      *c = f_const_empty_prefix_set;
    return 1;
  }

  return 0;
}

#define v1 whati->f1->i_FI_CONSTANT.val
#define v2 whati->f2->i_FI_CONSTANT.val
#define v3 whati->f3->i_FI_CONSTANT.val
#define vv(i) items[i]->i_FI_CONSTANT.val
#define runtime(fmt, ...) cf_error("filter preevaluation, line %d: " fmt, ifs->lino, ##__VA_ARGS__)
#define fpool cfg_mem
#define falloc(size) cfg_alloc(size)
/* Instruction constructors */
#line 288 "filter/f-inst.c"
 /* Constructor for FI_ADD */
#line 288
struct f_inst *
#line 284 "filter/f-inst.c"
NONNULL(2)
#line 285 "filter/f-inst.c"
NONNULL(3)
#line 288 "filter/f-inst.c"
f_new_inst_FI_ADD(enum f_instruction_code fi_code
#line 284 "filter/f-inst.c"
  , struct f_inst * f1
#line 285 "filter/f-inst.c"
  , struct f_inst * f2
#line 288 "filter/f-inst.c"
)
#line 288
  {
#line 288
    /* Allocate the structure */
#line 288
    struct f_inst *what = fi_new(fi_code);
#line 288
    uint constargs = 1;
#line 288

#line 288
    /* Initialize all the members */
#line 288
  #define whati (&(what->i_FI_ADD))
#line 288
  #line 284 "filter/f-inst.c"
whati->f1 = f1;
#line 284
const struct f_inst *child1 = f1;
#line 284
do {
#line 284
  what->size += child1->size;
#line 284

#line 284
  if (child1->fi_code != FI_CONSTANT)
#line 284
    constargs = 0;
#line 284

#line 284
} while (child1 = child1->next);
#line 284

#line 284 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 284
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 284
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 285 "filter/f-inst.c"
whati->f2 = f2;
#line 285
const struct f_inst *child2 = f2;
#line 285
do {
#line 285
  what->size += child2->size;
#line 285

#line 285
  if (child2->fi_code != FI_CONSTANT)
#line 285
    constargs = 0;
#line 285

#line 285
} while (child2 = child2->next);
#line 285 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 285
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 285
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 286 "filter/f-inst.c"
what->type = T_INT;

#line 288 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 288
    if (!constargs)
#line 288
      return what;
#line 288

#line 288
    /* Try to pre-calculate the result */
#line 288
    #line 283 "filter/f-inst.c"
 {
    
#line 284 "filter/f-inst.c"
 #line 284 "filter/f-inst.c"
 ;
#line 285 "filter/f-inst.c"
    
#line 285 "filter/f-inst.c"
 #line 285 "filter/f-inst.c"
 ;
#line 286 "filter/f-inst.c"
     
#line 286 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i + v2.val.i } );
  }
  
  #undef whati
#line 288 "filter/f-inst.c"
  }
#line 288

#line 288

#line 293 "filter/f-inst.c"
 /* Constructor for FI_SUBTRACT */
#line 293
struct f_inst *
#line 289 "filter/f-inst.c"
NONNULL(2)
#line 290 "filter/f-inst.c"
NONNULL(3)
#line 293 "filter/f-inst.c"
f_new_inst_FI_SUBTRACT(enum f_instruction_code fi_code
#line 289 "filter/f-inst.c"
  , struct f_inst * f1
#line 290 "filter/f-inst.c"
  , struct f_inst * f2
#line 293 "filter/f-inst.c"
)
#line 293
  {
#line 293
    /* Allocate the structure */
#line 293
    struct f_inst *what = fi_new(fi_code);
#line 293
    uint constargs = 1;
#line 293

#line 293
    /* Initialize all the members */
#line 293
  #define whati (&(what->i_FI_SUBTRACT))
#line 293
  #line 289 "filter/f-inst.c"
whati->f1 = f1;
#line 289
const struct f_inst *child1 = f1;
#line 289
do {
#line 289
  what->size += child1->size;
#line 289

#line 289
  if (child1->fi_code != FI_CONSTANT)
#line 289
    constargs = 0;
#line 289

#line 289
} while (child1 = child1->next);
#line 289

#line 289 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 289
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 289
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 290 "filter/f-inst.c"
whati->f2 = f2;
#line 290
const struct f_inst *child2 = f2;
#line 290
do {
#line 290
  what->size += child2->size;
#line 290

#line 290
  if (child2->fi_code != FI_CONSTANT)
#line 290
    constargs = 0;
#line 290

#line 290
} while (child2 = child2->next);
#line 290 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 290
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 290
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 291 "filter/f-inst.c"
what->type = T_INT;

#line 293 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 293
    if (!constargs)
#line 293
      return what;
#line 293

#line 293
    /* Try to pre-calculate the result */
#line 293
    #line 288 "filter/f-inst.c"
 {
    
#line 289 "filter/f-inst.c"
 #line 289 "filter/f-inst.c"
 ;
#line 290 "filter/f-inst.c"
    
#line 290 "filter/f-inst.c"
 #line 290 "filter/f-inst.c"
 ;
#line 291 "filter/f-inst.c"
     
#line 291 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i - v2.val.i } );
  }
  
  #undef whati
#line 293 "filter/f-inst.c"
  }
#line 293

#line 293

#line 298 "filter/f-inst.c"
 /* Constructor for FI_MULTIPLY */
#line 298
struct f_inst *
#line 294 "filter/f-inst.c"
NONNULL(2)
#line 295 "filter/f-inst.c"
NONNULL(3)
#line 298 "filter/f-inst.c"
f_new_inst_FI_MULTIPLY(enum f_instruction_code fi_code
#line 294 "filter/f-inst.c"
  , struct f_inst * f1
#line 295 "filter/f-inst.c"
  , struct f_inst * f2
#line 298 "filter/f-inst.c"
)
#line 298
  {
#line 298
    /* Allocate the structure */
#line 298
    struct f_inst *what = fi_new(fi_code);
#line 298
    uint constargs = 1;
#line 298

#line 298
    /* Initialize all the members */
#line 298
  #define whati (&(what->i_FI_MULTIPLY))
#line 298
  #line 294 "filter/f-inst.c"
whati->f1 = f1;
#line 294
const struct f_inst *child1 = f1;
#line 294
do {
#line 294
  what->size += child1->size;
#line 294

#line 294
  if (child1->fi_code != FI_CONSTANT)
#line 294
    constargs = 0;
#line 294

#line 294
} while (child1 = child1->next);
#line 294

#line 294 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 294
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 294
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 295 "filter/f-inst.c"
whati->f2 = f2;
#line 295
const struct f_inst *child2 = f2;
#line 295
do {
#line 295
  what->size += child2->size;
#line 295

#line 295
  if (child2->fi_code != FI_CONSTANT)
#line 295
    constargs = 0;
#line 295

#line 295
} while (child2 = child2->next);
#line 295 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 295
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 295
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 296 "filter/f-inst.c"
what->type = T_INT;

#line 298 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 298
    if (!constargs)
#line 298
      return what;
#line 298

#line 298
    /* Try to pre-calculate the result */
#line 298
    #line 293 "filter/f-inst.c"
 {
    
#line 294 "filter/f-inst.c"
 #line 294 "filter/f-inst.c"
 ;
#line 295 "filter/f-inst.c"
    
#line 295 "filter/f-inst.c"
 #line 295 "filter/f-inst.c"
 ;
#line 296 "filter/f-inst.c"
     
#line 296 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i * v2.val.i } );
  }
  
  #undef whati
#line 298 "filter/f-inst.c"
  }
#line 298

#line 298

#line 304 "filter/f-inst.c"
 /* Constructor for FI_DIVIDE */
#line 304
struct f_inst *
#line 299 "filter/f-inst.c"
NONNULL(2)
#line 300 "filter/f-inst.c"
NONNULL(3)
#line 304 "filter/f-inst.c"
f_new_inst_FI_DIVIDE(enum f_instruction_code fi_code
#line 299 "filter/f-inst.c"
  , struct f_inst * f1
#line 300 "filter/f-inst.c"
  , struct f_inst * f2
#line 304 "filter/f-inst.c"
)
#line 304
  {
#line 304
    /* Allocate the structure */
#line 304
    struct f_inst *what = fi_new(fi_code);
#line 304
    uint constargs = 1;
#line 304

#line 304
    /* Initialize all the members */
#line 304
  #define whati (&(what->i_FI_DIVIDE))
#line 304
  #line 299 "filter/f-inst.c"
whati->f1 = f1;
#line 299
const struct f_inst *child1 = f1;
#line 299
do {
#line 299
  what->size += child1->size;
#line 299

#line 299
  if (child1->fi_code != FI_CONSTANT)
#line 299
    constargs = 0;
#line 299

#line 299
} while (child1 = child1->next);
#line 299

#line 299 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 299
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 299
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 300 "filter/f-inst.c"
whati->f2 = f2;
#line 300
const struct f_inst *child2 = f2;
#line 300
do {
#line 300
  what->size += child2->size;
#line 300

#line 300
  if (child2->fi_code != FI_CONSTANT)
#line 300
    constargs = 0;
#line 300

#line 300
} while (child2 = child2->next);
#line 300 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 300
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 300
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 302 "filter/f-inst.c"
what->type = T_INT;

#line 304 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 304
    if (!constargs)
#line 304
      return what;
#line 304

#line 304
    /* Try to pre-calculate the result */
#line 304
    #line 298 "filter/f-inst.c"
 {
    
#line 299 "filter/f-inst.c"
 #line 299 "filter/f-inst.c"
 ;
#line 300 "filter/f-inst.c"
    
#line 300 "filter/f-inst.c"
 #line 300 "filter/f-inst.c"
 ;
#line 301 "filter/f-inst.c"
    if (v2.val.i == 0) runtime( "Mother told me not to divide by 0" );
     
#line 302 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i / v2.val.i } );
  }
  
  #undef whati
#line 304 "filter/f-inst.c"
  }
#line 304

#line 304

#line 309 "filter/f-inst.c"
 /* Constructor for FI_BITOR */
#line 309
struct f_inst *
#line 305 "filter/f-inst.c"
NONNULL(2)
#line 306 "filter/f-inst.c"
NONNULL(3)
#line 309 "filter/f-inst.c"
f_new_inst_FI_BITOR(enum f_instruction_code fi_code
#line 305 "filter/f-inst.c"
  , struct f_inst * f1
#line 306 "filter/f-inst.c"
  , struct f_inst * f2
#line 309 "filter/f-inst.c"
)
#line 309
  {
#line 309
    /* Allocate the structure */
#line 309
    struct f_inst *what = fi_new(fi_code);
#line 309
    uint constargs = 1;
#line 309

#line 309
    /* Initialize all the members */
#line 309
  #define whati (&(what->i_FI_BITOR))
#line 309
  #line 305 "filter/f-inst.c"
whati->f1 = f1;
#line 305
const struct f_inst *child1 = f1;
#line 305
do {
#line 305
  what->size += child1->size;
#line 305

#line 305
  if (child1->fi_code != FI_CONSTANT)
#line 305
    constargs = 0;
#line 305

#line 305
} while (child1 = child1->next);
#line 305

#line 305 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 305
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 305
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 306 "filter/f-inst.c"
whati->f2 = f2;
#line 306
const struct f_inst *child2 = f2;
#line 306
do {
#line 306
  what->size += child2->size;
#line 306

#line 306
  if (child2->fi_code != FI_CONSTANT)
#line 306
    constargs = 0;
#line 306

#line 306
} while (child2 = child2->next);
#line 306 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 306
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 306
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 307 "filter/f-inst.c"
what->type = T_INT;

#line 309 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 309
    if (!constargs)
#line 309
      return what;
#line 309

#line 309
    /* Try to pre-calculate the result */
#line 309
    #line 304 "filter/f-inst.c"
 {
    
#line 305 "filter/f-inst.c"
 #line 305 "filter/f-inst.c"
 ;
#line 306 "filter/f-inst.c"
    
#line 306 "filter/f-inst.c"
 #line 306 "filter/f-inst.c"
 ;
#line 307 "filter/f-inst.c"
     
#line 307 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i | v2.val.i } );
  }
  
  #undef whati
#line 309 "filter/f-inst.c"
  }
#line 309

#line 309

#line 314 "filter/f-inst.c"
 /* Constructor for FI_BITAND */
#line 314
struct f_inst *
#line 310 "filter/f-inst.c"
NONNULL(2)
#line 311 "filter/f-inst.c"
NONNULL(3)
#line 314 "filter/f-inst.c"
f_new_inst_FI_BITAND(enum f_instruction_code fi_code
#line 310 "filter/f-inst.c"
  , struct f_inst * f1
#line 311 "filter/f-inst.c"
  , struct f_inst * f2
#line 314 "filter/f-inst.c"
)
#line 314
  {
#line 314
    /* Allocate the structure */
#line 314
    struct f_inst *what = fi_new(fi_code);
#line 314
    uint constargs = 1;
#line 314

#line 314
    /* Initialize all the members */
#line 314
  #define whati (&(what->i_FI_BITAND))
#line 314
  #line 310 "filter/f-inst.c"
whati->f1 = f1;
#line 310
const struct f_inst *child1 = f1;
#line 310
do {
#line 310
  what->size += child1->size;
#line 310

#line 310
  if (child1->fi_code != FI_CONSTANT)
#line 310
    constargs = 0;
#line 310

#line 310
} while (child1 = child1->next);
#line 310

#line 310 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 310
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 310
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 311 "filter/f-inst.c"
whati->f2 = f2;
#line 311
const struct f_inst *child2 = f2;
#line 311
do {
#line 311
  what->size += child2->size;
#line 311

#line 311
  if (child2->fi_code != FI_CONSTANT)
#line 311
    constargs = 0;
#line 311

#line 311
} while (child2 = child2->next);
#line 311 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 311
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 311
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 312 "filter/f-inst.c"
what->type = T_INT;

#line 314 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 314
    if (!constargs)
#line 314
      return what;
#line 314

#line 314
    /* Try to pre-calculate the result */
#line 314
    #line 309 "filter/f-inst.c"
 {
    
#line 310 "filter/f-inst.c"
 #line 310 "filter/f-inst.c"
 ;
#line 311 "filter/f-inst.c"
    
#line 311 "filter/f-inst.c"
 #line 311 "filter/f-inst.c"
 ;
#line 312 "filter/f-inst.c"
     
#line 312 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i & v2.val.i } );
  }
  
  #undef whati
#line 314 "filter/f-inst.c"
  }
#line 314

#line 314

#line 324 "filter/f-inst.c"
 /* Constructor for FI_AND */
#line 324
struct f_inst *
#line 315 "filter/f-inst.c"
NONNULL(2)
#line 324 "filter/f-inst.c"
f_new_inst_FI_AND(enum f_instruction_code fi_code
#line 315 "filter/f-inst.c"
  , struct f_inst * f1
#line 320 "filter/f-inst.c"
  , struct f_inst * f2
#line 324 "filter/f-inst.c"
)
#line 324
  {
#line 324
    /* Allocate the structure */
#line 324
    struct f_inst *what = fi_new(fi_code);
#line 324
    uint constargs = 1;
#line 324

#line 324
    /* Initialize all the members */
#line 324
  #define whati (&(what->i_FI_AND))
#line 324
  #line 315 "filter/f-inst.c"
whati->f1 = f1;
#line 315
const struct f_inst *child1 = f1;
#line 315
do {
#line 315
  what->size += child1->size;
#line 315

#line 315
  if (child1->fi_code != FI_CONSTANT)
#line 315
    constargs = 0;
#line 315

#line 315
} while (child1 = child1->next);
#line 315

#line 315 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 315
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 315
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 316 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 316
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 316
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 317 "filter/f-inst.c"
what->type = T_BOOL;
#line 320 "filter/f-inst.c"
whati->f2 = f2;

#line 324 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 324
    if (!constargs)
#line 324
      return what;
#line 324

#line 324
    /* Try to pre-calculate the result */
#line 324
    #line 314 "filter/f-inst.c"
 {
    
#line 315 "filter/f-inst.c"
 #line 315 "filter/f-inst.c"
 ;
#line 316 "filter/f-inst.c"
    #line 316 "filter/f-inst.c"
;
     
#line 317 "filter/f-inst.c"
;

    if (v1.val.i)
      
#line 320 "filter/f-inst.c"
return whati->f2
#line 320
;
    else
      return fi_constant(what, v1);
  }
  
  #undef whati
#line 324 "filter/f-inst.c"
  }
#line 324

#line 324

#line 335 "filter/f-inst.c"
 /* Constructor for FI_OR */
#line 335
struct f_inst *
#line 325 "filter/f-inst.c"
NONNULL(2)
#line 335 "filter/f-inst.c"
f_new_inst_FI_OR(enum f_instruction_code fi_code
#line 325 "filter/f-inst.c"
  , struct f_inst * f1
#line 330 "filter/f-inst.c"
  , struct f_inst * f2
#line 335 "filter/f-inst.c"
)
#line 335
  {
#line 335
    /* Allocate the structure */
#line 335
    struct f_inst *what = fi_new(fi_code);
#line 335
    uint constargs = 1;
#line 335

#line 335
    /* Initialize all the members */
#line 335
  #define whati (&(what->i_FI_OR))
#line 335
  #line 325 "filter/f-inst.c"
whati->f1 = f1;
#line 325
const struct f_inst *child1 = f1;
#line 325
do {
#line 325
  what->size += child1->size;
#line 325

#line 325
  if (child1->fi_code != FI_CONSTANT)
#line 325
    constargs = 0;
#line 325

#line 325
} while (child1 = child1->next);
#line 325

#line 325 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 325
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 325
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 326 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 326
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 326
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 327 "filter/f-inst.c"
what->type = T_BOOL;
#line 330 "filter/f-inst.c"
whati->f2 = f2;

#line 335 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 335
    if (!constargs)
#line 335
      return what;
#line 335

#line 335
    /* Try to pre-calculate the result */
#line 335
    #line 324 "filter/f-inst.c"
 {
    
#line 325 "filter/f-inst.c"
 #line 325 "filter/f-inst.c"
 ;
#line 326 "filter/f-inst.c"
    #line 326 "filter/f-inst.c"
;
     
#line 327 "filter/f-inst.c"
;

    if (!v1.val.i)
      
#line 330 "filter/f-inst.c"
return whati->f2
#line 330
;
    else
      return fi_constant(what, v1);
  }

  
  #undef whati
#line 335 "filter/f-inst.c"
  }
#line 335

#line 335

#line 345 "filter/f-inst.c"
 /* Constructor for FI_PAIR_CONSTRUCT */
#line 345
struct f_inst *
#line 336 "filter/f-inst.c"
NONNULL(2)
#line 337 "filter/f-inst.c"
NONNULL(3)
#line 345 "filter/f-inst.c"
f_new_inst_FI_PAIR_CONSTRUCT(enum f_instruction_code fi_code
#line 336 "filter/f-inst.c"
  , struct f_inst * f1
#line 337 "filter/f-inst.c"
  , struct f_inst * f2
#line 345 "filter/f-inst.c"
)
#line 345
  {
#line 345
    /* Allocate the structure */
#line 345
    struct f_inst *what = fi_new(fi_code);
#line 345
    uint constargs = 1;
#line 345

#line 345
    /* Initialize all the members */
#line 345
  #define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
  #line 336 "filter/f-inst.c"
whati->f1 = f1;
#line 336
const struct f_inst *child1 = f1;
#line 336
do {
#line 336
  what->size += child1->size;
#line 336

#line 336
  if (child1->fi_code != FI_CONSTANT)
#line 336
    constargs = 0;
#line 336

#line 336
} while (child1 = child1->next);
#line 336

#line 336 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 336
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 336
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 337 "filter/f-inst.c"
whati->f2 = f2;
#line 337
const struct f_inst *child2 = f2;
#line 337
do {
#line 337
  what->size += child2->size;
#line 337

#line 337
  if (child2->fi_code != FI_CONSTANT)
#line 337
    constargs = 0;
#line 337

#line 337
} while (child2 = child2->next);
#line 337 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 337
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 337
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 342 "filter/f-inst.c"
what->type = T_PAIR;

#line 345 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 345
    if (!constargs)
#line 345
      return what;
#line 345

#line 345
    /* Try to pre-calculate the result */
#line 345
    #line 335 "filter/f-inst.c"
 {
    
#line 336 "filter/f-inst.c"
 #line 336 "filter/f-inst.c"
 ;
#line 337 "filter/f-inst.c"
    
#line 337 "filter/f-inst.c"
 #line 337 "filter/f-inst.c"
 ;
#line 338 "filter/f-inst.c"
    uint u1 = v1.val.i;
    uint u2 = v2.val.i;
    if ((u1 > 0xFFFF) || (u2 > 0xFFFF))
      runtime( "Can't operate with value out of bounds in pair constructor" );
     
#line 342 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = (u1 << 16) | u2 } );
  }

  
  #undef whati
#line 345 "filter/f-inst.c"
  }
#line 345

#line 345

#line 385 "filter/f-inst.c"
 /* Constructor for FI_EC_CONSTRUCT */
#line 385
struct f_inst *
#line 346 "filter/f-inst.c"
NONNULL(2)
#line 347 "filter/f-inst.c"
NONNULL(3)
#line 385 "filter/f-inst.c"
f_new_inst_FI_EC_CONSTRUCT(enum f_instruction_code fi_code
#line 346 "filter/f-inst.c"
  , struct f_inst * f1
#line 347 "filter/f-inst.c"
  , struct f_inst * f2
#line 349 "filter/f-inst.c"
  , enum ec_subtype ecs
#line 385 "filter/f-inst.c"
)
#line 385
  {
#line 385
    /* Allocate the structure */
#line 385
    struct f_inst *what = fi_new(fi_code);
#line 385
    uint constargs = 1;
#line 385

#line 385
    /* Initialize all the members */
#line 385
  #define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
  #line 346 "filter/f-inst.c"
whati->f1 = f1;
#line 346
const struct f_inst *child1 = f1;
#line 346
do {
#line 346
  what->size += child1->size;
#line 346

#line 346
  if (child1->fi_code != FI_CONSTANT)
#line 346
    constargs = 0;
#line 346

#line 346
} while (child1 = child1->next);
#line 346

#line 347 "filter/f-inst.c"
whati->f2 = f2;
#line 347
const struct f_inst *child2 = f2;
#line 347
do {
#line 347
  what->size += child2->size;
#line 347

#line 347
  if (child2->fi_code != FI_CONSTANT)
#line 347
    constargs = 0;
#line 347

#line 347
} while (child2 = child2->next);
#line 347 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 347
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 347
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 349 "filter/f-inst.c"
whati->ecs = ecs;
#line 370 "filter/f-inst.c"
what->type = T_EC;

#line 385 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 385
    if (!constargs)
#line 385
      return what;
#line 385

#line 385
    /* Try to pre-calculate the result */
#line 385
    #line 345 "filter/f-inst.c"
 {
    
#line 346 "filter/f-inst.c"
;
    
#line 347 "filter/f-inst.c"
 #line 347 "filter/f-inst.c"
 ;
#line 348 "filter/f-inst.c"

    #line 349 "filter/f-inst.c"
;

    int ipv4_used;
    u32 key, val;

    if (v1.type == T_INT) {
      ipv4_used = 0; key = v1.val.i;
    }
    else if (v1.type == T_QUAD) {
      ipv4_used = 1; key = v1.val.i;
    }
    /* IP->Quad implicit conversion */
    else if (val_is_ip4(&v1)) {
      ipv4_used = 1; key = ipa_to_u32(v1.val.ip);
    }
    else
      runtime("Argument 1 of EC constructor must be integer or IPv4 address, got 0x%02x", v1.type);

    val = v2.val.i;

    if (ecs == EC_GENERIC)
       
#line 370 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_generic(key, val) } );
    else if (ipv4_used)
      if (val <= 0xFFFF)
	 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_ip4(ecs, key, val) } );
      else
	runtime("4-byte value %u can't be used with IP-address key in extended community", val);
    else if (key < 0x10000)
       return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_as2(ecs, key, val) } );
    else
      if (val <= 0xFFFF)
	 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_as4(ecs, key, val) } );
      else
	runtime("4-byte value %u can't be used with 4-byte ASN in extended community", val);
  }

  
  #undef whati
#line 385 "filter/f-inst.c"
  }
#line 385

#line 385

#line 392 "filter/f-inst.c"
 /* Constructor for FI_LC_CONSTRUCT */
#line 392
struct f_inst *
#line 386 "filter/f-inst.c"
NONNULL(2)
#line 387 "filter/f-inst.c"
NONNULL(3)
#line 388 "filter/f-inst.c"
NONNULL(4)
#line 392 "filter/f-inst.c"
f_new_inst_FI_LC_CONSTRUCT(enum f_instruction_code fi_code
#line 386 "filter/f-inst.c"
  , struct f_inst * f1
#line 387 "filter/f-inst.c"
  , struct f_inst * f2
#line 388 "filter/f-inst.c"
  , struct f_inst * f3
#line 392 "filter/f-inst.c"
)
#line 392
  {
#line 392
    /* Allocate the structure */
#line 392
    struct f_inst *what = fi_new(fi_code);
#line 392
    uint constargs = 1;
#line 392

#line 392
    /* Initialize all the members */
#line 392
  #define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
  #line 386 "filter/f-inst.c"
whati->f1 = f1;
#line 386
const struct f_inst *child1 = f1;
#line 386
do {
#line 386
  what->size += child1->size;
#line 386

#line 386
  if (child1->fi_code != FI_CONSTANT)
#line 386
    constargs = 0;
#line 386

#line 386
} while (child1 = child1->next);
#line 386

#line 386 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 386
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 386
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 387 "filter/f-inst.c"
whati->f2 = f2;
#line 387
const struct f_inst *child2 = f2;
#line 387
do {
#line 387
  what->size += child2->size;
#line 387

#line 387
  if (child2->fi_code != FI_CONSTANT)
#line 387
    constargs = 0;
#line 387

#line 387
} while (child2 = child2->next);
#line 387 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 387
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 387
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 388 "filter/f-inst.c"
whati->f3 = f3;
#line 388
const struct f_inst *child3 = f3;
#line 388
do {
#line 388
  what->size += child3->size;
#line 388

#line 388
  if (child3->fi_code != FI_CONSTANT)
#line 388
    constargs = 0;
#line 388

#line 388
} while (child3 = child3->next);
#line 388 "filter/f-inst.c"
if (f3->type && (f3->type != (T_INT)) && !f_const_promotion(f3, (T_INT)))
#line 388
  cf_error("Argument 3 of %s must be of type %s, got type %s",
#line 388
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f3->type));
#line 389 "filter/f-inst.c"
what->type = T_LC;

#line 392 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 392
    if (!constargs)
#line 392
      return what;
#line 392

#line 392
    /* Try to pre-calculate the result */
#line 392
    #line 385 "filter/f-inst.c"
 {
    
#line 386 "filter/f-inst.c"
 #line 386 "filter/f-inst.c"
 ;
#line 387 "filter/f-inst.c"
    
#line 387 "filter/f-inst.c"
 #line 387 "filter/f-inst.c"
 ;
#line 388 "filter/f-inst.c"
    
#line 388 "filter/f-inst.c"
 #line 388 "filter/f-inst.c"
 ;
#line 389 "filter/f-inst.c"
     
#line 389 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = (lcomm) { v1.val.i, v2.val.i, v3.val.i } } );
  }

  
  #undef whati
#line 392 "filter/f-inst.c"
  }
#line 392

#line 392

#line 442 "filter/f-inst.c"
 /* Constructor for FI_PATHMASK_CONSTRUCT */
#line 442
struct f_inst *
#line 442
f_new_inst_FI_PATHMASK_CONSTRUCT(enum f_instruction_code fi_code
#line 393 "filter/f-inst.c"
  , struct f_inst * fvar
#line 442 "filter/f-inst.c"
)
#line 442
  {
#line 442
    /* Allocate the structure */
#line 442
    struct f_inst *what = fi_new(fi_code);
#line 442
    uint constargs = 1;
#line 442

#line 442
    /* Initialize all the members */
#line 442
  #define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
  #line 393 "filter/f-inst.c"
whati->varcount = 0;
#line 393
whati->fvar = fvar;
#line 393
for (const struct f_inst *child = fvar; child; child = child->next, whati->varcount++) {
#line 393
  what->size += child->size;
#line 393

#line 393
  if (child->fi_code != FI_CONSTANT)
#line 393
    constargs = 0;
#line 393

#line 393
}
#line 393

#line 393
  const struct f_inst **items = NULL;
#line 393
  if (constargs && whati->varcount) {
#line 393
    items = alloca(whati->varcount * sizeof(struct f_inst *));
#line 393
    const struct f_inst *child = fvar;
#line 393
    for (uint i=0; child; i++)
#line 393
      child = (items[i] = child)->next;
#line 393
  }
#line 393

#line 437 "filter/f-inst.c"
what->type = T_PATH_MASK;

#line 442 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 442
    if (!constargs)
#line 442
      return what;
#line 442

#line 442
    /* Try to pre-calculate the result */
#line 442
    #line 392 "filter/f-inst.c"
 {
    
#line 393 "filter/f-inst.c"

#line 393

#line 393
;

    struct f_path_mask *pm = falloc(sizeof(struct f_path_mask) + whati->varcount * sizeof(struct f_path_mask_item));
    pm->len = whati->varcount;

    for (uint i=0; i<whati->varcount; i++) {
      switch (vv(i).type) {
	case T_PATH_MASK_ITEM:
	  if (vv(i).val.pmi.kind == PM_LOOP)
	  {
	    if (i == 0)
	      runtime("Path mask iterator '+' cannot be first");

	    /* We want PM_LOOP as prefix operator */
	    pm->item[i] = pm->item[i - 1];
	    pm->item[i - 1] = vv(i).val.pmi;
	    break;
	  }

	  pm->item[i] = vv(i).val.pmi;
	  break;

	case T_INT:
	  pm->item[i] = (struct f_path_mask_item) {
	    .asn = vv(i).val.i,
	    .kind = PM_ASN,
	  };
	  break;

	case T_SET:
	  if (!path_set_type(vv(i).val.t))
	    runtime("Only integer sets allowed in path mask");

	  pm->item[i] = (struct f_path_mask_item) {
	    .set = vv(i).val.t,
	    .kind = PM_ASN_SET,
	  };
	  break;

	default:
	  runtime( "Error resolving path mask template: value not an integer" );
      }
    }

     
#line 437 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH_MASK, .val.path_mask = pm } );
  }

/* Relational operators */

  
  #undef whati
#line 442 "filter/f-inst.c"
  }
#line 442

#line 442

#line 449 "filter/f-inst.c"
 /* Constructor for FI_NEQ */
#line 449
struct f_inst *
#line 443 "filter/f-inst.c"
NONNULL(2)
#line 444 "filter/f-inst.c"
NONNULL(3)
#line 449 "filter/f-inst.c"
f_new_inst_FI_NEQ(enum f_instruction_code fi_code
#line 443 "filter/f-inst.c"
  , struct f_inst * f1
#line 444 "filter/f-inst.c"
  , struct f_inst * f2
#line 449 "filter/f-inst.c"
)
#line 449
  {
#line 449
    /* Allocate the structure */
#line 449
    struct f_inst *what = fi_new(fi_code);
#line 449
    uint constargs = 1;
#line 449

#line 449
    /* Initialize all the members */
#line 449
  #define whati (&(what->i_FI_NEQ))
#line 449
  #line 443 "filter/f-inst.c"
whati->f1 = f1;
#line 443
const struct f_inst *child1 = f1;
#line 443
do {
#line 443
  what->size += child1->size;
#line 443

#line 443
  if (child1->fi_code != FI_CONSTANT)
#line 443
    constargs = 0;
#line 443

#line 443
} while (child1 = child1->next);
#line 443

#line 444 "filter/f-inst.c"
whati->f2 = f2;
#line 444
const struct f_inst *child2 = f2;
#line 444
do {
#line 444
  what->size += child2->size;
#line 444

#line 444
  if (child2->fi_code != FI_CONSTANT)
#line 444
    constargs = 0;
#line 444

#line 444
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type))
#line 445 "filter/f-inst.c"
   (void) (f_const_promotion(f2, f1->type) || f_const_promotion(f1, f2->type));
#line 446 "filter/f-inst.c"
what->type = T_BOOL;

#line 449 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 449
    if (!constargs)
#line 449
      return what;
#line 449

#line 449
    /* Try to pre-calculate the result */
#line 449
    #line 442 "filter/f-inst.c"
 {
    
#line 443 "filter/f-inst.c"
;
    
#line 444 "filter/f-inst.c"
;
    #line 445 "filter/f-inst.c"
;
     
#line 446 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !val_same(&v1, &v2) } );
  }

  
  #undef whati
#line 449 "filter/f-inst.c"
  }
#line 449

#line 449

#line 456 "filter/f-inst.c"
 /* Constructor for FI_EQ */
#line 456
struct f_inst *
#line 450 "filter/f-inst.c"
NONNULL(2)
#line 451 "filter/f-inst.c"
NONNULL(3)
#line 456 "filter/f-inst.c"
f_new_inst_FI_EQ(enum f_instruction_code fi_code
#line 450 "filter/f-inst.c"
  , struct f_inst * f1
#line 451 "filter/f-inst.c"
  , struct f_inst * f2
#line 456 "filter/f-inst.c"
)
#line 456
  {
#line 456
    /* Allocate the structure */
#line 456
    struct f_inst *what = fi_new(fi_code);
#line 456
    uint constargs = 1;
#line 456

#line 456
    /* Initialize all the members */
#line 456
  #define whati (&(what->i_FI_EQ))
#line 456
  #line 450 "filter/f-inst.c"
whati->f1 = f1;
#line 450
const struct f_inst *child1 = f1;
#line 450
do {
#line 450
  what->size += child1->size;
#line 450

#line 450
  if (child1->fi_code != FI_CONSTANT)
#line 450
    constargs = 0;
#line 450

#line 450
} while (child1 = child1->next);
#line 450

#line 451 "filter/f-inst.c"
whati->f2 = f2;
#line 451
const struct f_inst *child2 = f2;
#line 451
do {
#line 451
  what->size += child2->size;
#line 451

#line 451
  if (child2->fi_code != FI_CONSTANT)
#line 451
    constargs = 0;
#line 451

#line 451
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type))
#line 452 "filter/f-inst.c"
   (void) (f_const_promotion(f2, f1->type) || f_const_promotion(f1, f2->type));
#line 453 "filter/f-inst.c"
what->type = T_BOOL;

#line 456 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 456
    if (!constargs)
#line 456
      return what;
#line 456

#line 456
    /* Try to pre-calculate the result */
#line 456
    #line 449 "filter/f-inst.c"
 {
    
#line 450 "filter/f-inst.c"
;
    
#line 451 "filter/f-inst.c"
;
    #line 452 "filter/f-inst.c"
;
     
#line 453 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = val_same(&v1, &v2) } );
  }

  
  #undef whati
#line 456 "filter/f-inst.c"
  }
#line 456

#line 456

#line 467 "filter/f-inst.c"
 /* Constructor for FI_LT */
#line 467
struct f_inst *
#line 457 "filter/f-inst.c"
NONNULL(2)
#line 458 "filter/f-inst.c"
NONNULL(3)
#line 467 "filter/f-inst.c"
f_new_inst_FI_LT(enum f_instruction_code fi_code
#line 457 "filter/f-inst.c"
  , struct f_inst * f1
#line 458 "filter/f-inst.c"
  , struct f_inst * f2
#line 467 "filter/f-inst.c"
)
#line 467
  {
#line 467
    /* Allocate the structure */
#line 467
    struct f_inst *what = fi_new(fi_code);
#line 467
    uint constargs = 1;
#line 467

#line 467
    /* Initialize all the members */
#line 467
  #define whati (&(what->i_FI_LT))
#line 467
  #line 457 "filter/f-inst.c"
whati->f1 = f1;
#line 457
const struct f_inst *child1 = f1;
#line 457
do {
#line 457
  what->size += child1->size;
#line 457

#line 457
  if (child1->fi_code != FI_CONSTANT)
#line 457
    constargs = 0;
#line 457

#line 457
} while (child1 = child1->next);
#line 457

#line 458 "filter/f-inst.c"
whati->f2 = f2;
#line 458
const struct f_inst *child2 = f2;
#line 458
do {
#line 458
  what->size += child2->size;
#line 458

#line 458
  if (child2->fi_code != FI_CONSTANT)
#line 458
    constargs = 0;
#line 458

#line 458
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type) &&
#line 459 "filter/f-inst.c"
   !f_const_promotion(f2, f1->type) && !f_const_promotion(f1, f2->type))
#line 459
  cf_error("Arguments 1 and 2 of %s must be of the same type", f_instruction_name(what->fi_code));
#line 464 "filter/f-inst.c"
what->type = T_BOOL;

#line 467 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 467
    if (!constargs)
#line 467
      return what;
#line 467

#line 467
    /* Try to pre-calculate the result */
#line 467
    #line 456 "filter/f-inst.c"
 {
    
#line 457 "filter/f-inst.c"
;
    
#line 458 "filter/f-inst.c"
;
    #line 459 "filter/f-inst.c"
;

    int i = val_compare(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "Can't compare values of incompatible types" );
     
#line 464 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (i == -1) } );
  }

  
  #undef whati
#line 467 "filter/f-inst.c"
  }
#line 467

#line 467

#line 478 "filter/f-inst.c"
 /* Constructor for FI_LTE */
#line 478
struct f_inst *
#line 468 "filter/f-inst.c"
NONNULL(2)
#line 469 "filter/f-inst.c"
NONNULL(3)
#line 478 "filter/f-inst.c"
f_new_inst_FI_LTE(enum f_instruction_code fi_code
#line 468 "filter/f-inst.c"
  , struct f_inst * f1
#line 469 "filter/f-inst.c"
  , struct f_inst * f2
#line 478 "filter/f-inst.c"
)
#line 478
  {
#line 478
    /* Allocate the structure */
#line 478
    struct f_inst *what = fi_new(fi_code);
#line 478
    uint constargs = 1;
#line 478

#line 478
    /* Initialize all the members */
#line 478
  #define whati (&(what->i_FI_LTE))
#line 478
  #line 468 "filter/f-inst.c"
whati->f1 = f1;
#line 468
const struct f_inst *child1 = f1;
#line 468
do {
#line 468
  what->size += child1->size;
#line 468

#line 468
  if (child1->fi_code != FI_CONSTANT)
#line 468
    constargs = 0;
#line 468

#line 468
} while (child1 = child1->next);
#line 468

#line 469 "filter/f-inst.c"
whati->f2 = f2;
#line 469
const struct f_inst *child2 = f2;
#line 469
do {
#line 469
  what->size += child2->size;
#line 469

#line 469
  if (child2->fi_code != FI_CONSTANT)
#line 469
    constargs = 0;
#line 469

#line 469
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type) &&
#line 470 "filter/f-inst.c"
   !f_const_promotion(f2, f1->type) && !f_const_promotion(f1, f2->type))
#line 470
  cf_error("Arguments 1 and 2 of %s must be of the same type", f_instruction_name(what->fi_code));
#line 475 "filter/f-inst.c"
what->type = T_BOOL;

#line 478 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 478
    if (!constargs)
#line 478
      return what;
#line 478

#line 478
    /* Try to pre-calculate the result */
#line 478
    #line 467 "filter/f-inst.c"
 {
    
#line 468 "filter/f-inst.c"
;
    
#line 469 "filter/f-inst.c"
;
    #line 470 "filter/f-inst.c"
;

    int i = val_compare(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "Can't compare values of incompatible types" );
     
#line 475 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (i != 1) } );
  }

  
  #undef whati
#line 478 "filter/f-inst.c"
  }
#line 478

#line 478

#line 483 "filter/f-inst.c"
 /* Constructor for FI_NOT */
#line 483
struct f_inst *
#line 479 "filter/f-inst.c"
NONNULL(2)
#line 483 "filter/f-inst.c"
f_new_inst_FI_NOT(enum f_instruction_code fi_code
#line 479 "filter/f-inst.c"
  , struct f_inst * f1
#line 483 "filter/f-inst.c"
)
#line 483
  {
#line 483
    /* Allocate the structure */
#line 483
    struct f_inst *what = fi_new(fi_code);
#line 483
    uint constargs = 1;
#line 483

#line 483
    /* Initialize all the members */
#line 483
  #define whati (&(what->i_FI_NOT))
#line 483
  #line 479 "filter/f-inst.c"
whati->f1 = f1;
#line 479
const struct f_inst *child1 = f1;
#line 479
do {
#line 479
  what->size += child1->size;
#line 479

#line 479
  if (child1->fi_code != FI_CONSTANT)
#line 479
    constargs = 0;
#line 479

#line 479
} while (child1 = child1->next);
#line 479

#line 479 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 479
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 479
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 480 "filter/f-inst.c"
what->type = T_BOOL;

#line 483 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 483
    if (!constargs)
#line 483
      return what;
#line 483

#line 483
    /* Try to pre-calculate the result */
#line 483
    #line 478 "filter/f-inst.c"
 {
    
#line 479 "filter/f-inst.c"
 #line 479 "filter/f-inst.c"
 ;
#line 480 "filter/f-inst.c"
     
#line 480 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !v1.val.i } );
  }

  
  #undef whati
#line 483 "filter/f-inst.c"
  }
#line 483

#line 483

#line 492 "filter/f-inst.c"
 /* Constructor for FI_MATCH */
#line 492
struct f_inst *
#line 484 "filter/f-inst.c"
NONNULL(2)
#line 485 "filter/f-inst.c"
NONNULL(3)
#line 492 "filter/f-inst.c"
f_new_inst_FI_MATCH(enum f_instruction_code fi_code
#line 484 "filter/f-inst.c"
  , struct f_inst * f1
#line 485 "filter/f-inst.c"
  , struct f_inst * f2
#line 492 "filter/f-inst.c"
)
#line 492
  {
#line 492
    /* Allocate the structure */
#line 492
    struct f_inst *what = fi_new(fi_code);
#line 492
    uint constargs = 1;
#line 492

#line 492
    /* Initialize all the members */
#line 492
  #define whati (&(what->i_FI_MATCH))
#line 492
  #line 484 "filter/f-inst.c"
whati->f1 = f1;
#line 484
const struct f_inst *child1 = f1;
#line 484
do {
#line 484
  what->size += child1->size;
#line 484

#line 484
  if (child1->fi_code != FI_CONSTANT)
#line 484
    constargs = 0;
#line 484

#line 484
} while (child1 = child1->next);
#line 484

#line 485 "filter/f-inst.c"
whati->f2 = f2;
#line 485
const struct f_inst *child2 = f2;
#line 485
do {
#line 485
  what->size += child2->size;
#line 485

#line 485
  if (child2->fi_code != FI_CONSTANT)
#line 485
    constargs = 0;
#line 485

#line 485
} while (child2 = child2->next);
#line 489 "filter/f-inst.c"
what->type = T_BOOL;

#line 492 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 492
    if (!constargs)
#line 492
      return what;
#line 492

#line 492
    /* Try to pre-calculate the result */
#line 492
    #line 483 "filter/f-inst.c"
 {
    
#line 484 "filter/f-inst.c"
;
    
#line 485 "filter/f-inst.c"
;
    int i = val_in_range(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "~ applied on unknown type pair" );
     
#line 489 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !!i } );
  }

  
  #undef whati
#line 492 "filter/f-inst.c"
  }
#line 492

#line 492

#line 501 "filter/f-inst.c"
 /* Constructor for FI_NOT_MATCH */
#line 501
struct f_inst *
#line 493 "filter/f-inst.c"
NONNULL(2)
#line 494 "filter/f-inst.c"
NONNULL(3)
#line 501 "filter/f-inst.c"
f_new_inst_FI_NOT_MATCH(enum f_instruction_code fi_code
#line 493 "filter/f-inst.c"
  , struct f_inst * f1
#line 494 "filter/f-inst.c"
  , struct f_inst * f2
#line 501 "filter/f-inst.c"
)
#line 501
  {
#line 501
    /* Allocate the structure */
#line 501
    struct f_inst *what = fi_new(fi_code);
#line 501
    uint constargs = 1;
#line 501

#line 501
    /* Initialize all the members */
#line 501
  #define whati (&(what->i_FI_NOT_MATCH))
#line 501
  #line 493 "filter/f-inst.c"
whati->f1 = f1;
#line 493
const struct f_inst *child1 = f1;
#line 493
do {
#line 493
  what->size += child1->size;
#line 493

#line 493
  if (child1->fi_code != FI_CONSTANT)
#line 493
    constargs = 0;
#line 493

#line 493
} while (child1 = child1->next);
#line 493

#line 494 "filter/f-inst.c"
whati->f2 = f2;
#line 494
const struct f_inst *child2 = f2;
#line 494
do {
#line 494
  what->size += child2->size;
#line 494

#line 494
  if (child2->fi_code != FI_CONSTANT)
#line 494
    constargs = 0;
#line 494

#line 494
} while (child2 = child2->next);
#line 498 "filter/f-inst.c"
what->type = T_BOOL;

#line 501 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 501
    if (!constargs)
#line 501
      return what;
#line 501

#line 501
    /* Try to pre-calculate the result */
#line 501
    #line 492 "filter/f-inst.c"
 {
    
#line 493 "filter/f-inst.c"
;
    
#line 494 "filter/f-inst.c"
;
    int i = val_in_range(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "!~ applied on unknown type pair" );
     
#line 498 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !i } );
  }

  
  #undef whati
#line 501 "filter/f-inst.c"
  }
#line 501

#line 501

#line 506 "filter/f-inst.c"
 /* Constructor for FI_DEFINED */
#line 506
struct f_inst *
#line 502 "filter/f-inst.c"
NONNULL(2)
#line 506 "filter/f-inst.c"
f_new_inst_FI_DEFINED(enum f_instruction_code fi_code
#line 502 "filter/f-inst.c"
  , struct f_inst * f1
#line 506 "filter/f-inst.c"
)
#line 506
  {
#line 506
    /* Allocate the structure */
#line 506
    struct f_inst *what = fi_new(fi_code);
#line 506
    uint constargs = 1;
#line 506

#line 506
    /* Initialize all the members */
#line 506
  #define whati (&(what->i_FI_DEFINED))
#line 506
  #line 502 "filter/f-inst.c"
whati->f1 = f1;
#line 502
const struct f_inst *child1 = f1;
#line 502
do {
#line 502
  what->size += child1->size;
#line 502

#line 502
  if (child1->fi_code != FI_CONSTANT)
#line 502
    constargs = 0;
#line 502

#line 502
} while (child1 = child1->next);
#line 502

#line 503 "filter/f-inst.c"
what->type = T_BOOL;

#line 506 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 506
    if (!constargs)
#line 506
      return what;
#line 506

#line 506
    /* Try to pre-calculate the result */
#line 506
    #line 501 "filter/f-inst.c"
 {
    
#line 502 "filter/f-inst.c"
;
     
#line 503 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (v1.type != T_VOID) && !val_is_undefined(v1) } );
  }

  
  #undef whati
#line 506 "filter/f-inst.c"
  }
#line 506

#line 506

#line 507 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__type */
#line 507
struct f_inst *
#line 506 "filter/f-inst.c"
NONNULL(2)
#line 507 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__type(enum f_instruction_code fi_code
#line 506 "filter/f-inst.c"
  , struct f_inst * f1
#line 507 "filter/f-inst.c"
)
#line 507
  {
#line 507
    /* Allocate the structure */
#line 507
    struct f_inst *what = fi_new(fi_code);
#line 507
    uint constargs = 1;
#line 507

#line 507
    /* Initialize all the members */
#line 507
  #define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
  #line 506 "filter/f-inst.c"
whati->f1 = f1;
#line 506
const struct f_inst *child1 = f1;
#line 506
do {
#line 506
  what->size += child1->size;
#line 506

#line 506
  if (child1->fi_code != FI_CONSTANT)
#line 506
    constargs = 0;
#line 506

#line 506
} while (child1 = child1->next);
#line 506

#line 506 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 506
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 506
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 506 "filter/f-inst.c"
what->type = T_ENUM_NET_TYPE;

#line 507 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 507
    if (!constargs)
#line 507
      return what;
#line 507

#line 507
    /* Try to pre-calculate the result */
#line 507
    #line 506 "filter/f-inst.c"
 {
#line 506
  
#line 506 "filter/f-inst.c"
 #line 506 "filter/f-inst.c"
 ;
#line 506 "filter/f-inst.c"
    
#line 506 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ENUM_NET_TYPE, .val.i = v1.val.net->type } ) 
#line 506
  #line 506 "filter/f-inst.c"
;
#line 506
};
  
  #undef whati
#line 507 "filter/f-inst.c"
  }
#line 507

#line 507

#line 510 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_IP__is_v4 */
#line 510
struct f_inst *
#line 507 "filter/f-inst.c"
NONNULL(2)
#line 510 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_IP__is_v4(enum f_instruction_code fi_code
#line 507 "filter/f-inst.c"
  , struct f_inst * f1
#line 510 "filter/f-inst.c"
)
#line 510
  {
#line 510
    /* Allocate the structure */
#line 510
    struct f_inst *what = fi_new(fi_code);
#line 510
    uint constargs = 1;
#line 510

#line 510
    /* Initialize all the members */
#line 510
  #define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
  #line 507 "filter/f-inst.c"
whati->f1 = f1;
#line 507
const struct f_inst *child1 = f1;
#line 507
do {
#line 507
  what->size += child1->size;
#line 507

#line 507
  if (child1->fi_code != FI_CONSTANT)
#line 507
    constargs = 0;
#line 507

#line 507
} while (child1 = child1->next);
#line 507

#line 507 "filter/f-inst.c"
if (f1->type && (f1->type != (T_IP)) && !f_const_promotion(f1, (T_IP)))
#line 507
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 507
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f1->type));
#line 507 "filter/f-inst.c"
what->type = T_BOOL;

#line 510 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 510
    if (!constargs)
#line 510
      return what;
#line 510

#line 510
    /* Try to pre-calculate the result */
#line 510
    #line 507 "filter/f-inst.c"
 {
#line 507
  
#line 507 "filter/f-inst.c"
 #line 507 "filter/f-inst.c"
 ;
#line 507 "filter/f-inst.c"
    
#line 507 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = ipa_is_ip4(v1.val.ip) } ) 
#line 507
  #line 507 "filter/f-inst.c"
;
#line 507
};

  /* Add initialized variable */
  
  #undef whati
#line 510 "filter/f-inst.c"
  }
#line 510

#line 510

#line 523 "filter/f-inst.c"
 /* Constructor for FI_VAR_INIT */
#line 523
struct f_inst *
#line 512 "filter/f-inst.c"
NONNULL(2)
#line 523 "filter/f-inst.c"
f_new_inst_FI_VAR_INIT(enum f_instruction_code fi_code
#line 512 "filter/f-inst.c"
  , struct f_inst * f1
#line 513 "filter/f-inst.c"
  , struct symbol * sym
#line 523 "filter/f-inst.c"
)
#line 523
  {
#line 523
    /* Allocate the structure */
#line 523
    struct f_inst *what = fi_new(fi_code);
#line 523
    
#line 523

#line 523
    /* Initialize all the members */
#line 523
  #define whati (&(what->i_FI_VAR_INIT))
#line 523
  #line 512 "filter/f-inst.c"
whati->f1 = f1;
#line 512
const struct f_inst *child1 = f1;
#line 512
do {
#line 512
  what->size += child1->size;
#line 512

#line 512
} while (child1 = child1->next);
#line 512

#line 513 "filter/f-inst.c"
whati->sym = sym;
#line 514 "filter/f-inst.c"
if (f1->type && (f1->type != (sym->class & 0xff)) && !f_const_promotion(f1, (sym->class & 0xff)))
#line 514
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 514
	   f_instruction_name(what->fi_code), f_type_name(sym->class & 0xff), f_type_name(f1->type));

#line 523 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 523
    
#line 523
      return what;
#line 523

#line 523
    /* Try to pre-calculate the result */
#line 523
      #undef whati
#line 523
  }
#line 523

#line 523

#line 534 "filter/f-inst.c"
 /* Constructor for FI_VAR_INIT0 */
#line 534
struct f_inst *
#line 534
f_new_inst_FI_VAR_INIT0(enum f_instruction_code fi_code
#line 525 "filter/f-inst.c"
  , struct symbol * sym
#line 534 "filter/f-inst.c"
)
#line 534
  {
#line 534
    /* Allocate the structure */
#line 534
    struct f_inst *what = fi_new(fi_code);
#line 534
    
#line 534

#line 534
    /* Initialize all the members */
#line 534
  #define whati (&(what->i_FI_VAR_INIT0))
#line 534
  #line 525 "filter/f-inst.c"
whati->sym = sym;

#line 534 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 534
    
#line 534
      return what;
#line 534

#line 534
    /* Try to pre-calculate the result */
#line 534
      #undef whati
#line 534
  }
#line 534

#line 534

#line 543 "filter/f-inst.c"
 /* Constructor for FI_VAR_SET */
#line 543
struct f_inst *
#line 536 "filter/f-inst.c"
NONNULL(2)
#line 543 "filter/f-inst.c"
f_new_inst_FI_VAR_SET(enum f_instruction_code fi_code
#line 536 "filter/f-inst.c"
  , struct f_inst * f1
#line 537 "filter/f-inst.c"
  , struct symbol * sym
#line 543 "filter/f-inst.c"
)
#line 543
  {
#line 543
    /* Allocate the structure */
#line 543
    struct f_inst *what = fi_new(fi_code);
#line 543
    
#line 543

#line 543
    /* Initialize all the members */
#line 543
  #define whati (&(what->i_FI_VAR_SET))
#line 543
  #line 536 "filter/f-inst.c"
whati->f1 = f1;
#line 536
const struct f_inst *child1 = f1;
#line 536
do {
#line 536
  what->size += child1->size;
#line 536

#line 536
} while (child1 = child1->next);
#line 536

#line 537 "filter/f-inst.c"
whati->sym = sym;
#line 538 "filter/f-inst.c"
if (f1->type && (f1->type != (sym->class & 0xff)) && !f_const_promotion(f1, (sym->class & 0xff)))
#line 538
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 538
	   f_instruction_name(what->fi_code), f_type_name(sym->class & 0xff), f_type_name(f1->type));

#line 543 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 543
    
#line 543
      return what;
#line 543

#line 543
    /* Try to pre-calculate the result */
#line 543
      #undef whati
#line 543
  }
#line 543

#line 543

#line 550 "filter/f-inst.c"
 /* Constructor for FI_VAR_GET */
#line 550
struct f_inst *
#line 550
f_new_inst_FI_VAR_GET(enum f_instruction_code fi_code
#line 544 "filter/f-inst.c"
  , struct symbol * sym
#line 550 "filter/f-inst.c"
)
#line 550
  {
#line 550
    /* Allocate the structure */
#line 550
    struct f_inst *what = fi_new(fi_code);
#line 550
    
#line 550

#line 550
    /* Initialize all the members */
#line 550
  #define whati (&(what->i_FI_VAR_GET))
#line 550
  #line 544 "filter/f-inst.c"
whati->sym = sym;
#line 546 "filter/f-inst.c"
what->type = sym->class & 0xff;

#line 550 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 550
    
#line 550
      return what;
#line 550

#line 550
    /* Try to pre-calculate the result */
#line 550
      #undef whati
#line 550
  }
#line 550

#line 550

#line 563 "filter/f-inst.c"
 /* Constructor for FI_CONSTANT */
#line 563
struct f_inst *
#line 563
f_new_inst_FI_CONSTANT(enum f_instruction_code fi_code
#line 551 "filter/f-inst.c"
  , struct f_val val
#line 563 "filter/f-inst.c"
)
#line 563
  {
#line 563
    /* Allocate the structure */
#line 563
    struct f_inst *what = fi_new(fi_code);
#line 563
    uint constargs = 1;
#line 563

#line 563
    /* Initialize all the members */
#line 563
  #define whati (&(what->i_FI_CONSTANT))
#line 563
  #line 551 "filter/f-inst.c"
whati->val = val;
#line 559 "filter/f-inst.c"
what->type = val.type;

#line 563 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 563
    if (!constargs)
#line 563
      return what;
#line 563

#line 563
    /* Try to pre-calculate the result */
#line 563
    #line 550 "filter/f-inst.c"
 {
    #line 557 "filter/f-inst.c"
;

     
#line 559 "filter/f-inst.c"
;
    return fi_constant(what, val);
  }

  
  #undef whati
#line 563 "filter/f-inst.c"
  }
#line 563

#line 563

#line 564 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__empty */
#line 564
struct f_inst *
#line 563 "filter/f-inst.c"
NONNULL(2)
#line 564 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__empty(enum f_instruction_code fi_code
#line 563 "filter/f-inst.c"
  , struct f_inst * f1
#line 564 "filter/f-inst.c"
)
#line 564
  {
#line 564
    /* Allocate the structure */
#line 564
    struct f_inst *what = fi_new(fi_code);
#line 564
    uint constargs = 1;
#line 564

#line 564
    /* Initialize all the members */
#line 564
  #define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
  #line 563 "filter/f-inst.c"
whati->f1 = f1;
#line 563
const struct f_inst *child1 = f1;
#line 563
do {
#line 563
  what->size += child1->size;
#line 563

#line 563
  if (child1->fi_code != FI_CONSTANT)
#line 563
    constargs = 0;
#line 563

#line 563
} while (child1 = child1->next);
#line 563

#line 563 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 563
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 563
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 563 "filter/f-inst.c"
what->type = T_PATH;

#line 564 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 564
    if (!constargs)
#line 564
      return what;
#line 564

#line 564
    /* Try to pre-calculate the result */
#line 564
    #line 563 "filter/f-inst.c"
 {
#line 563
  
#line 563 "filter/f-inst.c"
 #line 563 "filter/f-inst.c"
 ;
#line 563 "filter/f-inst.c"
    
#line 563 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad = &null_adata } ) 
#line 563
  #line 563 "filter/f-inst.c"
;
#line 563
};
  
  #undef whati
#line 564 "filter/f-inst.c"
  }
#line 564

#line 564

#line 565 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__empty */
#line 565
struct f_inst *
#line 564 "filter/f-inst.c"
NONNULL(2)
#line 565 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__empty(enum f_instruction_code fi_code
#line 564 "filter/f-inst.c"
  , struct f_inst * f1
#line 565 "filter/f-inst.c"
)
#line 565
  {
#line 565
    /* Allocate the structure */
#line 565
    struct f_inst *what = fi_new(fi_code);
#line 565
    uint constargs = 1;
#line 565

#line 565
    /* Initialize all the members */
#line 565
  #define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
  #line 564 "filter/f-inst.c"
whati->f1 = f1;
#line 564
const struct f_inst *child1 = f1;
#line 564
do {
#line 564
  what->size += child1->size;
#line 564

#line 564
  if (child1->fi_code != FI_CONSTANT)
#line 564
    constargs = 0;
#line 564

#line 564
} while (child1 = child1->next);
#line 564

#line 564 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 564
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 564
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 564 "filter/f-inst.c"
what->type = T_CLIST;

#line 565 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 565
    if (!constargs)
#line 565
      return what;
#line 565

#line 565
    /* Try to pre-calculate the result */
#line 565
    #line 564 "filter/f-inst.c"
 {
#line 564
  
#line 564 "filter/f-inst.c"
 #line 564 "filter/f-inst.c"
 ;
#line 564 "filter/f-inst.c"
    
#line 564 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad = &null_adata } ) 
#line 564
  #line 564 "filter/f-inst.c"
;
#line 564
};
  
  #undef whati
#line 565 "filter/f-inst.c"
  }
#line 565

#line 565

#line 566 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__empty */
#line 566
struct f_inst *
#line 565 "filter/f-inst.c"
NONNULL(2)
#line 566 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__empty(enum f_instruction_code fi_code
#line 565 "filter/f-inst.c"
  , struct f_inst * f1
#line 566 "filter/f-inst.c"
)
#line 566
  {
#line 566
    /* Allocate the structure */
#line 566
    struct f_inst *what = fi_new(fi_code);
#line 566
    uint constargs = 1;
#line 566

#line 566
    /* Initialize all the members */
#line 566
  #define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
  #line 565 "filter/f-inst.c"
whati->f1 = f1;
#line 565
const struct f_inst *child1 = f1;
#line 565
do {
#line 565
  what->size += child1->size;
#line 565

#line 565
  if (child1->fi_code != FI_CONSTANT)
#line 565
    constargs = 0;
#line 565

#line 565
} while (child1 = child1->next);
#line 565

#line 565 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 565
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 565
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 565 "filter/f-inst.c"
what->type = T_ECLIST;

#line 566 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 566
    if (!constargs)
#line 566
      return what;
#line 566

#line 566
    /* Try to pre-calculate the result */
#line 566
    #line 565 "filter/f-inst.c"
 {
#line 565
  
#line 565 "filter/f-inst.c"
 #line 565 "filter/f-inst.c"
 ;
#line 565 "filter/f-inst.c"
    
#line 565 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad = &null_adata } ) 
#line 565
  #line 565 "filter/f-inst.c"
;
#line 565
};
  
  #undef whati
#line 566 "filter/f-inst.c"
  }
#line 566

#line 566

#line 569 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__empty */
#line 569
struct f_inst *
#line 566 "filter/f-inst.c"
NONNULL(2)
#line 569 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__empty(enum f_instruction_code fi_code
#line 566 "filter/f-inst.c"
  , struct f_inst * f1
#line 569 "filter/f-inst.c"
)
#line 569
  {
#line 569
    /* Allocate the structure */
#line 569
    struct f_inst *what = fi_new(fi_code);
#line 569
    uint constargs = 1;
#line 569

#line 569
    /* Initialize all the members */
#line 569
  #define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
  #line 566 "filter/f-inst.c"
whati->f1 = f1;
#line 566
const struct f_inst *child1 = f1;
#line 566
do {
#line 566
  what->size += child1->size;
#line 566

#line 566
  if (child1->fi_code != FI_CONSTANT)
#line 566
    constargs = 0;
#line 566

#line 566
} while (child1 = child1->next);
#line 566

#line 566 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 566
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 566
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 566 "filter/f-inst.c"
what->type = T_LCLIST;

#line 569 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 569
    if (!constargs)
#line 569
      return what;
#line 569

#line 569
    /* Try to pre-calculate the result */
#line 569
    #line 566 "filter/f-inst.c"
 {
#line 566
  
#line 566 "filter/f-inst.c"
 #line 566 "filter/f-inst.c"
 ;
#line 566 "filter/f-inst.c"
    
#line 566 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad = &null_adata } ) 
#line 566
  #line 566 "filter/f-inst.c"
;
#line 566
};

  /* Common loop begin instruction, always created by f_for_cycle() */
  
  #undef whati
#line 569 "filter/f-inst.c"
  }
#line 569

#line 569

#line 591 "filter/f-inst.c"
 /* Constructor for FI_FOR_LOOP_START */
#line 591
struct f_inst *
#line 591
f_new_inst_FI_FOR_LOOP_START(enum f_instruction_code fi_code
#line 571 "filter/f-inst.c"
  , struct symbol * sym
#line 591 "filter/f-inst.c"
)
#line 591
  {
#line 591
    /* Allocate the structure */
#line 591
    struct f_inst *what = fi_new(fi_code);
#line 591
    
#line 591

#line 591
    /* Initialize all the members */
#line 591
  #define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
  #line 571 "filter/f-inst.c"
whati->sym = sym;
#line 587 "filter/f-inst.c"
what->type = T_VOID;

#line 591 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 591
    
#line 591
      return what;
#line 591

#line 591
    /* Try to pre-calculate the result */
#line 591
      #undef whati
#line 591
  }
#line 591

#line 591

#line 600 "filter/f-inst.c"
 /* Constructor for FI_PATH_FOR_NEXT */
#line 600
struct f_inst *
#line 593 "filter/f-inst.c"
NONNULL(2)
#line 600 "filter/f-inst.c"
f_new_inst_FI_PATH_FOR_NEXT(enum f_instruction_code fi_code
#line 593 "filter/f-inst.c"
  , struct f_inst * f1
#line 595 "filter/f-inst.c"
  , struct f_inst * f2
#line 600 "filter/f-inst.c"
)
#line 600
  {
#line 600
    /* Allocate the structure */
#line 600
    struct f_inst *what = fi_new(fi_code);
#line 600
    
#line 600

#line 600
    /* Initialize all the members */
#line 600
  #define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 600
  #line 593 "filter/f-inst.c"
whati->f1 = f1;
#line 593
const struct f_inst *child1 = f1;
#line 593
do {
#line 593
  what->size += child1->size;
#line 593

#line 593
} while (child1 = child1->next);
#line 593

#line 593 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 593
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 593
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 595 "filter/f-inst.c"
whati->f2 = f2;

#line 600 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 600
    
#line 600
      return what;
#line 600

#line 600
    /* Try to pre-calculate the result */
#line 600
      #undef whati
#line 600
  }
#line 600

#line 600

#line 609 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FOR_NEXT */
#line 609
struct f_inst *
#line 602 "filter/f-inst.c"
NONNULL(2)
#line 609 "filter/f-inst.c"
f_new_inst_FI_CLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 602 "filter/f-inst.c"
  , struct f_inst * f1
#line 604 "filter/f-inst.c"
  , struct f_inst * f2
#line 609 "filter/f-inst.c"
)
#line 609
  {
#line 609
    /* Allocate the structure */
#line 609
    struct f_inst *what = fi_new(fi_code);
#line 609
    
#line 609

#line 609
    /* Initialize all the members */
#line 609
  #define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 609
  #line 602 "filter/f-inst.c"
whati->f1 = f1;
#line 602
const struct f_inst *child1 = f1;
#line 602
do {
#line 602
  what->size += child1->size;
#line 602

#line 602
} while (child1 = child1->next);
#line 602

#line 602 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 602
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 602
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 604 "filter/f-inst.c"
whati->f2 = f2;

#line 609 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 609
    
#line 609
      return what;
#line 609

#line 609
    /* Try to pre-calculate the result */
#line 609
      #undef whati
#line 609
  }
#line 609

#line 609

#line 618 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FOR_NEXT */
#line 618
struct f_inst *
#line 611 "filter/f-inst.c"
NONNULL(2)
#line 618 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 611 "filter/f-inst.c"
  , struct f_inst * f1
#line 613 "filter/f-inst.c"
  , struct f_inst * f2
#line 618 "filter/f-inst.c"
)
#line 618
  {
#line 618
    /* Allocate the structure */
#line 618
    struct f_inst *what = fi_new(fi_code);
#line 618
    
#line 618

#line 618
    /* Initialize all the members */
#line 618
  #define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 618
  #line 611 "filter/f-inst.c"
whati->f1 = f1;
#line 611
const struct f_inst *child1 = f1;
#line 611
do {
#line 611
  what->size += child1->size;
#line 611

#line 611
} while (child1 = child1->next);
#line 611

#line 611 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 611
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 611
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 613 "filter/f-inst.c"
whati->f2 = f2;

#line 618 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 618
    
#line 618
      return what;
#line 618

#line 618
    /* Try to pre-calculate the result */
#line 618
      #undef whati
#line 618
  }
#line 618

#line 618

#line 627 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FOR_NEXT */
#line 627
struct f_inst *
#line 620 "filter/f-inst.c"
NONNULL(2)
#line 627 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 620 "filter/f-inst.c"
  , struct f_inst * f1
#line 622 "filter/f-inst.c"
  , struct f_inst * f2
#line 627 "filter/f-inst.c"
)
#line 627
  {
#line 627
    /* Allocate the structure */
#line 627
    struct f_inst *what = fi_new(fi_code);
#line 627
    
#line 627

#line 627
    /* Initialize all the members */
#line 627
  #define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 627
  #line 620 "filter/f-inst.c"
whati->f1 = f1;
#line 620
const struct f_inst *child1 = f1;
#line 620
do {
#line 620
  what->size += child1->size;
#line 620

#line 620
} while (child1 = child1->next);
#line 620

#line 620 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 620
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 620
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 622 "filter/f-inst.c"
whati->f2 = f2;

#line 627 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 627
    
#line 627
      return what;
#line 627

#line 627
    /* Try to pre-calculate the result */
#line 627
      #undef whati
#line 627
  }
#line 627

#line 627

#line 640 "filter/f-inst.c"
 /* Constructor for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
struct f_inst *
#line 629 "filter/f-inst.c"
NONNULL(2)
#line 640 "filter/f-inst.c"
f_new_inst_FI_ROUTES_BLOCK_FOR_NEXT(enum f_instruction_code fi_code
#line 629 "filter/f-inst.c"
  , struct f_inst * f1
#line 634 "filter/f-inst.c"
  , struct f_inst * f2
#line 640 "filter/f-inst.c"
)
#line 640
  {
#line 640
    /* Allocate the structure */
#line 640
    struct f_inst *what = fi_new(fi_code);
#line 640
    
#line 640

#line 640
    /* Initialize all the members */
#line 640
  #define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
  #line 629 "filter/f-inst.c"
whati->f1 = f1;
#line 629
const struct f_inst *child1 = f1;
#line 629
do {
#line 629
  what->size += child1->size;
#line 629

#line 629
} while (child1 = child1->next);
#line 629

#line 629 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTES_BLOCK)) && !f_const_promotion(f1, (T_ROUTES_BLOCK)))
#line 629
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 629
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTES_BLOCK), f_type_name(f1->type));
#line 634 "filter/f-inst.c"
whati->f2 = f2;

#line 640 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 640
    
#line 640
      return what;
#line 640

#line 640
    /* Try to pre-calculate the result */
#line 640
      #undef whati
#line 640
  }
#line 640

#line 640

#line 648 "filter/f-inst.c"
 /* Constructor for FI_CONDITION */
#line 648
struct f_inst *
#line 641 "filter/f-inst.c"
NONNULL(2)
#line 648 "filter/f-inst.c"
f_new_inst_FI_CONDITION(enum f_instruction_code fi_code
#line 641 "filter/f-inst.c"
  , struct f_inst * f1
#line 643 "filter/f-inst.c"
  , struct f_inst * f2
#line 645 "filter/f-inst.c"
  , struct f_inst * f3
#line 648 "filter/f-inst.c"
)
#line 648
  {
#line 648
    /* Allocate the structure */
#line 648
    struct f_inst *what = fi_new(fi_code);
#line 648
    uint constargs = 1;
#line 648

#line 648
    /* Initialize all the members */
#line 648
  #define whati (&(what->i_FI_CONDITION))
#line 648
  #line 641 "filter/f-inst.c"
whati->f1 = f1;
#line 641
const struct f_inst *child1 = f1;
#line 641
do {
#line 641
  what->size += child1->size;
#line 641

#line 641
  if (child1->fi_code != FI_CONSTANT)
#line 641
    constargs = 0;
#line 641

#line 641
} while (child1 = child1->next);
#line 641

#line 641 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 641
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 641
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 643 "filter/f-inst.c"
whati->f2 = f2;
#line 645 "filter/f-inst.c"
whati->f3 = f3;

#line 648 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 648
    if (!constargs)
#line 648
      return what;
#line 648

#line 648
    /* Try to pre-calculate the result */
#line 648
    #line 640 "filter/f-inst.c"
 {
    
#line 641 "filter/f-inst.c"
 #line 641 "filter/f-inst.c"
 ;
#line 642 "filter/f-inst.c"
    if (v1.val.i)
      
#line 643 "filter/f-inst.c"
return whati->f2
#line 643
;
    else
      
#line 645 "filter/f-inst.c"
return whati->f3
#line 645
;
  }

  
  #undef whati
#line 648 "filter/f-inst.c"
  }
#line 648

#line 648

#line 661 "filter/f-inst.c"
 /* Constructor for FI_PRINT */
#line 661
struct f_inst *
#line 650 "filter/f-inst.c"
NONNULL(2)
#line 661 "filter/f-inst.c"
f_new_inst_FI_PRINT(enum f_instruction_code fi_code
#line 650 "filter/f-inst.c"
  , struct f_inst * f1
#line 661 "filter/f-inst.c"
)
#line 661
  {
#line 661
    /* Allocate the structure */
#line 661
    struct f_inst *what = fi_new(fi_code);
#line 661
    
#line 661

#line 661
    /* Initialize all the members */
#line 661
  #define whati (&(what->i_FI_PRINT))
#line 661
  #line 650 "filter/f-inst.c"
whati->f1 = f1;
#line 650
const struct f_inst *child1 = f1;
#line 650
do {
#line 650
  what->size += child1->size;
#line 650

#line 650
} while (child1 = child1->next);
#line 650


#line 661 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 661
    
#line 661
      return what;
#line 661

#line 661
    /* Try to pre-calculate the result */
#line 661
      #undef whati
#line 661
  }
#line 661

#line 661

#line 668 "filter/f-inst.c"
 /* Constructor for FI_FLUSH */
#line 668
struct f_inst *
#line 668
f_new_inst_FI_FLUSH(enum f_instruction_code fi_code
#line 668
)
#line 668
  {
#line 668
    /* Allocate the structure */
#line 668
    struct f_inst *what = fi_new(fi_code);
#line 668
    
#line 668

#line 668
    /* Initialize all the members */
#line 668
  #define whati (&(what->i_FI_FLUSH))
#line 668
  
#line 668
    /* If not constant, return the instruction itself */
#line 668
    
#line 668
      return what;
#line 668

#line 668
    /* Try to pre-calculate the result */
#line 668
      #undef whati
#line 668
  }
#line 668

#line 668

#line 682 "filter/f-inst.c"
 /* Constructor for FI_DIE */
#line 682
struct f_inst *
#line 682
f_new_inst_FI_DIE(enum f_instruction_code fi_code
#line 670 "filter/f-inst.c"
  , enum filter_return fret
#line 682 "filter/f-inst.c"
)
#line 682
  {
#line 682
    /* Allocate the structure */
#line 682
    struct f_inst *what = fi_new(fi_code);
#line 682
    
#line 682

#line 682
    /* Initialize all the members */
#line 682
  #define whati (&(what->i_FI_DIE))
#line 682
  #line 670 "filter/f-inst.c"
whati->fret = fret;

#line 682 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 682
    
#line 682
      return what;
#line 682

#line 682
    /* Try to pre-calculate the result */
#line 682
      #undef whati
#line 682
  }
#line 682

#line 682

#line 689 "filter/f-inst.c"
 /* Constructor for FI_CURRENT_ROUTE */
#line 689
struct f_inst *
#line 689
f_new_inst_FI_CURRENT_ROUTE(enum f_instruction_code fi_code
#line 689
)
#line 689
  {
#line 689
    /* Allocate the structure */
#line 689
    struct f_inst *what = fi_new(fi_code);
#line 689
    
#line 689

#line 689
    /* Initialize all the members */
#line 689
  #define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
  #line 685 "filter/f-inst.c"
what->type = T_ROUTE;

#line 689 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 689
    
#line 689
      return what;
#line 689

#line 689
    /* Try to pre-calculate the result */
#line 689
      #undef whati
#line 689
  }
#line 689

#line 689

#line 736 "filter/f-inst.c"
 /* Constructor for FI_RTA_GET */
#line 736
struct f_inst *
#line 691 "filter/f-inst.c"
NONNULL(2)
#line 736 "filter/f-inst.c"
f_new_inst_FI_RTA_GET(enum f_instruction_code fi_code
#line 691 "filter/f-inst.c"
  , struct f_inst * f1
#line 692 "filter/f-inst.c"
  , struct f_static_attr sa
#line 736 "filter/f-inst.c"
)
#line 736
  {
#line 736
    /* Allocate the structure */
#line 736
    struct f_inst *what = fi_new(fi_code);
#line 736
    uint constargs = 1;
#line 736

#line 736
    /* Initialize all the members */
#line 736
  #define whati (&(what->i_FI_RTA_GET))
#line 736
  #line 691 "filter/f-inst.c"
whati->f1 = f1;
#line 691
const struct f_inst *child1 = f1;
#line 691
do {
#line 691
  what->size += child1->size;
#line 691

#line 691
  if (child1->fi_code != FI_CONSTANT)
#line 691
    constargs = 0;
#line 691

#line 691
} while (child1 = child1->next);
#line 691

#line 691 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTE)) && !f_const_promotion(f1, (T_ROUTE)))
#line 691
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 691
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTE), f_type_name(f1->type));
#line 692 "filter/f-inst.c"
whati->sa = sa;
#line 698 "filter/f-inst.c"
what->type = sa.type;

#line 736 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 736
    if (!constargs)
#line 736
      return what;
#line 736

#line 736
    /* Try to pre-calculate the result */
#line 736
    #line 689 "filter/f-inst.c"
 {
    {
      
#line 691 "filter/f-inst.c"
 #line 691 "filter/f-inst.c"
 ;
#line 692 "filter/f-inst.c"
      #line 692 "filter/f-inst.c"
;

      struct rte *rte = v1.val.rte;

      switch (sa.sa_code)
      {
      case SA_NET:	 
#line 698 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = sa.type, .val.net = rte->net } ); break;
      case SA_PROTO:	 return fi_constant(what,  (struct f_val) { .type = sa.type, .val.s = rte->src->owner->name } ); break;
      default:
	{
	  struct eattr *nhea = ea_find(rte->attrs, &ea_gen_nexthop);
	  struct nexthop_adata *nhad = nhea ? (struct nexthop_adata *) nhea->u.ptr : NULL;
	  struct nexthop *nh = nhad ? &nhad->nh : NULL;

	  switch (sa.sa_code)
	  {
	    case SA_DEST:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = nhad ?
#line 709
		  (NEXTHOP_IS_REACHABLE(nhad) ? RTD_UNICAST : nhad->dest)
#line 709
		  : RTD_NONE } );
#line 712
	      break;
	    case SA_GW:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.ip = nh ? nh->gw : IPA_NONE } );
	      break;
	    case SA_IFNAME:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.s = (nh && nh->iface) ? nh->iface->name : "" } );
	      break;
	    case SA_IFINDEX:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && nh->iface) ? nh->iface->index : 0 } );
	      break;
	    case SA_WEIGHT:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh ? nh->weight : 0) + 1 } );
	      break;
	    case SA_GW_MPLS:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && nh->labels) ? nh->label[0] : MPLS_NULL } );
	      break;
	    default:
	      bug("Invalid static attribute access (%u/%u)", sa.type, sa.sa_code);
	  }
	}
      }
    }
  }

  
  #undef whati
#line 736 "filter/f-inst.c"
  }
#line 736

#line 736

#line 864 "filter/f-inst.c"
 /* Constructor for FI_RTA_SET */
#line 864
struct f_inst *
#line 738 "filter/f-inst.c"
NONNULL(2)
#line 864 "filter/f-inst.c"
f_new_inst_FI_RTA_SET(enum f_instruction_code fi_code
#line 738 "filter/f-inst.c"
  , struct f_inst * f1
#line 739 "filter/f-inst.c"
  , struct f_static_attr sa
#line 864 "filter/f-inst.c"
)
#line 864
  {
#line 864
    /* Allocate the structure */
#line 864
    struct f_inst *what = fi_new(fi_code);
#line 864
    
#line 864

#line 864
    /* Initialize all the members */
#line 864
  #define whati (&(what->i_FI_RTA_SET))
#line 864
  #line 738 "filter/f-inst.c"
whati->f1 = f1;
#line 738
const struct f_inst *child1 = f1;
#line 738
do {
#line 738
  what->size += child1->size;
#line 738

#line 738
} while (child1 = child1->next);
#line 738

#line 739 "filter/f-inst.c"
whati->sa = sa;
#line 740 "filter/f-inst.c"
if (f1->type && (f1->type != (sa.type)) && !f_const_promotion(f1, (sa.type)))
#line 740
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 740
	   f_instruction_name(what->fi_code), f_type_name(sa.type), f_type_name(f1->type));

#line 864 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 864
    
#line 864
      return what;
#line 864

#line 864
    /* Try to pre-calculate the result */
#line 864
      #undef whati
#line 864
  }
#line 864

#line 864

#line 901 "filter/f-inst.c"
 /* Constructor for FI_EA_GET */
#line 901
struct f_inst *
#line 865 "filter/f-inst.c"
NONNULL(2)
#line 901 "filter/f-inst.c"
f_new_inst_FI_EA_GET(enum f_instruction_code fi_code
#line 865 "filter/f-inst.c"
  , struct f_inst * f1
#line 866 "filter/f-inst.c"
  , const struct ea_class * da
#line 901 "filter/f-inst.c"
)
#line 901
  {
#line 901
    /* Allocate the structure */
#line 901
    struct f_inst *what = fi_new(fi_code);
#line 901
    uint constargs = 1;
#line 901

#line 901
    /* Initialize all the members */
#line 901
  #define whati (&(what->i_FI_EA_GET))
#line 901
  #line 865 "filter/f-inst.c"
whati->f1 = f1;
#line 865
const struct f_inst *child1 = f1;
#line 865
do {
#line 865
  what->size += child1->size;
#line 865

#line 865
  if (child1->fi_code != FI_CONSTANT)
#line 865
    constargs = 0;
#line 865

#line 865
} while (child1 = child1->next);
#line 865

#line 865 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTE)) && !f_const_promotion(f1, (T_ROUTE)))
#line 865
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 865
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTE), f_type_name(f1->type));
#line 866 "filter/f-inst.c"
whati->da = da;
#line 867 "filter/f-inst.c"
what->type = da->type;

#line 901 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 901
    if (!constargs)
#line 901
      return what;
#line 901

#line 901
    /* Try to pre-calculate the result */
#line 901
    #line 864 "filter/f-inst.c"
 {	/* Access to extended attributes */
    
#line 865 "filter/f-inst.c"
 #line 865 "filter/f-inst.c"
 ;
#line 866 "filter/f-inst.c"
    #line 866 "filter/f-inst.c"
;
     
#line 867 "filter/f-inst.c"
;
    {
      struct f_val empty;
      const eattr *e = ea_find(v1.val.rte->attrs, da->id);

      if (e)
      {
	ASSERT_DIE(e->type == da->type);

	switch (e->type) {
	  case T_IP:
	    return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip = *((const ip_addr *) e->u.ptr->data) } );
	    break;

	  case T_STRING:
	    return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s = (const char *) e->u.ptr->data } );
	    break;

	  default:
	    return fi_constant(what, (struct f_val) {
#line 886
		.type = e->type,
#line 886
		.val.bval = e->u,
#line 886
		});
#line 890
	}
      }
      else if (da->empty)
	return fi_constant(what, da->empty(da));
      else if ((empty = f_get_empty(da->type)).type != T_VOID)
	return fi_constant(what, empty);
      else
	return fi_constant(what,  (struct f_val) { .type = T_VOID } );
    }
  }

  
  #undef whati
#line 901 "filter/f-inst.c"
  }
#line 901

#line 901

#line 942 "filter/f-inst.c"
 /* Constructor for FI_EA_SET */
#line 942
struct f_inst *
#line 903 "filter/f-inst.c"
NONNULL(2)
#line 942 "filter/f-inst.c"
f_new_inst_FI_EA_SET(enum f_instruction_code fi_code
#line 903 "filter/f-inst.c"
  , struct f_inst * f1
#line 904 "filter/f-inst.c"
  , const struct ea_class * da
#line 942 "filter/f-inst.c"
)
#line 942
  {
#line 942
    /* Allocate the structure */
#line 942
    struct f_inst *what = fi_new(fi_code);
#line 942
    
#line 942

#line 942
    /* Initialize all the members */
#line 942
  #define whati (&(what->i_FI_EA_SET))
#line 942
  #line 903 "filter/f-inst.c"
whati->f1 = f1;
#line 903
const struct f_inst *child1 = f1;
#line 903
do {
#line 903
  what->size += child1->size;
#line 903

#line 903
} while (child1 = child1->next);
#line 903

#line 904 "filter/f-inst.c"
whati->da = da;
#line 905 "filter/f-inst.c"
if (f1->type && (f1->type != (da->type)) && !f_const_promotion(f1, (da->type)))
#line 905
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 905
	   f_instruction_name(what->fi_code), f_type_name(da->type), f_type_name(f1->type));
;
#line 908 "filter/f-inst.c"
      if (da->type == T_OPAQUE)
	cf_error("Setting opaque attribute is not allowed");

    
#line 942 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 942
    
#line 942
      return what;
#line 942

#line 942
    /* Try to pre-calculate the result */
#line 942
      #undef whati
#line 942
  }
#line 942

#line 942

#line 949 "filter/f-inst.c"
 /* Constructor for FI_EA_UNSET */
#line 949
struct f_inst *
#line 949
f_new_inst_FI_EA_UNSET(enum f_instruction_code fi_code
#line 943 "filter/f-inst.c"
  , const struct ea_class * da
#line 949 "filter/f-inst.c"
)
#line 949
  {
#line 949
    /* Allocate the structure */
#line 949
    struct f_inst *what = fi_new(fi_code);
#line 949
    
#line 949

#line 949
    /* Initialize all the members */
#line 949
  #define whati (&(what->i_FI_EA_UNSET))
#line 949
  #line 943 "filter/f-inst.c"
whati->da = da;

#line 949 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 949
    
#line 949
      return what;
#line 949

#line 949
    /* Try to pre-calculate the result */
#line 949
      #undef whati
#line 949
  }
#line 949

#line 949

#line 963 "filter/f-inst.c"
 /* Constructor for FI_DEFAULT */
#line 963
struct f_inst *
#line 950 "filter/f-inst.c"
NONNULL(2)
#line 951 "filter/f-inst.c"
NONNULL(3)
#line 963 "filter/f-inst.c"
f_new_inst_FI_DEFAULT(enum f_instruction_code fi_code
#line 950 "filter/f-inst.c"
  , struct f_inst * f1
#line 951 "filter/f-inst.c"
  , struct f_inst * f2
#line 963 "filter/f-inst.c"
)
#line 963
  {
#line 963
    /* Allocate the structure */
#line 963
    struct f_inst *what = fi_new(fi_code);
#line 963
    uint constargs = 1;
#line 963

#line 963
    /* Initialize all the members */
#line 963
  #define whati (&(what->i_FI_DEFAULT))
#line 963
  #line 950 "filter/f-inst.c"
whati->f1 = f1;
#line 950
const struct f_inst *child1 = f1;
#line 950
do {
#line 950
  what->size += child1->size;
#line 950

#line 950
  if (child1->fi_code != FI_CONSTANT)
#line 950
    constargs = 0;
#line 950

#line 950
} while (child1 = child1->next);
#line 950

#line 951 "filter/f-inst.c"
whati->f2 = f2;
#line 951
const struct f_inst *child2 = f2;
#line 951
do {
#line 951
  what->size += child2->size;
#line 951

#line 951
  if (child2->fi_code != FI_CONSTANT)
#line 951
    constargs = 0;
#line 951

#line 951
} while (child2 = child2->next);
#line 952 "filter/f-inst.c"
what->type = f_type_element_type(v2.type);

#line 963 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 963
    if (!constargs)
#line 963
      return what;
#line 963

#line 963
    /* Try to pre-calculate the result */
#line 963
    #line 949 "filter/f-inst.c"
 {
    
#line 950 "filter/f-inst.c"
;
    
#line 951 "filter/f-inst.c"
;
     
#line 952 "filter/f-inst.c"
;

    log(L_INFO "Type of arg 1 is: %d", v1.type);

    if (v1.type == T_VOID)
      return fi_constant(what, v2);
    else
      return fi_constant(what, v1);
  }

  /* Get length of */
  
  #undef whati
#line 963 "filter/f-inst.c"
  }
#line 963

#line 963

#line 964 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__len */
#line 964
struct f_inst *
#line 963 "filter/f-inst.c"
NONNULL(2)
#line 964 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__len(enum f_instruction_code fi_code
#line 963 "filter/f-inst.c"
  , struct f_inst * f1
#line 964 "filter/f-inst.c"
)
#line 964
  {
#line 964
    /* Allocate the structure */
#line 964
    struct f_inst *what = fi_new(fi_code);
#line 964
    uint constargs = 1;
#line 964

#line 964
    /* Initialize all the members */
#line 964
  #define whati (&(what->i_FI_METHOD__T_NET__len))
#line 964
  #line 963 "filter/f-inst.c"
whati->f1 = f1;
#line 963
const struct f_inst *child1 = f1;
#line 963
do {
#line 963
  what->size += child1->size;
#line 963

#line 963
  if (child1->fi_code != FI_CONSTANT)
#line 963
    constargs = 0;
#line 963

#line 963
} while (child1 = child1->next);
#line 963

#line 963 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 963
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 963
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 963 "filter/f-inst.c"
what->type = T_INT;

#line 964 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 964
    if (!constargs)
#line 964
      return what;
#line 964

#line 964
    /* Try to pre-calculate the result */
#line 964
    #line 963 "filter/f-inst.c"
 {
#line 963
  
#line 963 "filter/f-inst.c"
 #line 963 "filter/f-inst.c"
 ;
#line 963 "filter/f-inst.c"
    
#line 963 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = net_pxlen(v1.val.net) } ) 
#line 963
  #line 963 "filter/f-inst.c"
;
#line 963
};
  
  #undef whati
#line 964 "filter/f-inst.c"
  }
#line 964

#line 964

#line 965 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__len */
#line 965
struct f_inst *
#line 964 "filter/f-inst.c"
NONNULL(2)
#line 965 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__len(enum f_instruction_code fi_code
#line 964 "filter/f-inst.c"
  , struct f_inst * f1
#line 965 "filter/f-inst.c"
)
#line 965
  {
#line 965
    /* Allocate the structure */
#line 965
    struct f_inst *what = fi_new(fi_code);
#line 965
    uint constargs = 1;
#line 965

#line 965
    /* Initialize all the members */
#line 965
  #define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 965
  #line 964 "filter/f-inst.c"
whati->f1 = f1;
#line 964
const struct f_inst *child1 = f1;
#line 964
do {
#line 964
  what->size += child1->size;
#line 964

#line 964
  if (child1->fi_code != FI_CONSTANT)
#line 964
    constargs = 0;
#line 964

#line 964
} while (child1 = child1->next);
#line 964

#line 964 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 964
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 964
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 964 "filter/f-inst.c"
what->type = T_INT;

#line 965 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 965
    if (!constargs)
#line 965
      return what;
#line 965

#line 965
    /* Try to pre-calculate the result */
#line 965
    #line 964 "filter/f-inst.c"
 {
#line 964
  
#line 964 "filter/f-inst.c"
 #line 964 "filter/f-inst.c"
 ;
#line 964 "filter/f-inst.c"
    
#line 964 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = as_path_getlen(v1.val.ad) } ) 
#line 964
  #line 964 "filter/f-inst.c"
;
#line 964
};
  
  #undef whati
#line 965 "filter/f-inst.c"
  }
#line 965

#line 965

#line 966 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__len */
#line 966
struct f_inst *
#line 965 "filter/f-inst.c"
NONNULL(2)
#line 966 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__len(enum f_instruction_code fi_code
#line 965 "filter/f-inst.c"
  , struct f_inst * f1
#line 966 "filter/f-inst.c"
)
#line 966
  {
#line 966
    /* Allocate the structure */
#line 966
    struct f_inst *what = fi_new(fi_code);
#line 966
    uint constargs = 1;
#line 966

#line 966
    /* Initialize all the members */
#line 966
  #define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 966
  #line 965 "filter/f-inst.c"
whati->f1 = f1;
#line 965
const struct f_inst *child1 = f1;
#line 965
do {
#line 965
  what->size += child1->size;
#line 965

#line 965
  if (child1->fi_code != FI_CONSTANT)
#line 965
    constargs = 0;
#line 965

#line 965
} while (child1 = child1->next);
#line 965

#line 965 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 965
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 965
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 965 "filter/f-inst.c"
what->type = T_INT;

#line 966 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 966
    if (!constargs)
#line 966
      return what;
#line 966

#line 966
    /* Try to pre-calculate the result */
#line 966
    #line 965 "filter/f-inst.c"
 {
#line 965
  
#line 965 "filter/f-inst.c"
 #line 965 "filter/f-inst.c"
 ;
#line 965 "filter/f-inst.c"
    
#line 965 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = int_set_get_size(v1.val.ad) } ) 
#line 965
  #line 965 "filter/f-inst.c"
;
#line 965
};
  
  #undef whati
#line 966 "filter/f-inst.c"
  }
#line 966

#line 966

#line 967 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__len */
#line 967
struct f_inst *
#line 966 "filter/f-inst.c"
NONNULL(2)
#line 967 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__len(enum f_instruction_code fi_code
#line 966 "filter/f-inst.c"
  , struct f_inst * f1
#line 967 "filter/f-inst.c"
)
#line 967
  {
#line 967
    /* Allocate the structure */
#line 967
    struct f_inst *what = fi_new(fi_code);
#line 967
    uint constargs = 1;
#line 967

#line 967
    /* Initialize all the members */
#line 967
  #define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 967
  #line 966 "filter/f-inst.c"
whati->f1 = f1;
#line 966
const struct f_inst *child1 = f1;
#line 966
do {
#line 966
  what->size += child1->size;
#line 966

#line 966
  if (child1->fi_code != FI_CONSTANT)
#line 966
    constargs = 0;
#line 966

#line 966
} while (child1 = child1->next);
#line 966

#line 966 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 966
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 966
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 966 "filter/f-inst.c"
what->type = T_INT;

#line 967 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 967
    if (!constargs)
#line 967
      return what;
#line 967

#line 967
    /* Try to pre-calculate the result */
#line 967
    #line 966 "filter/f-inst.c"
 {
#line 966
  
#line 966 "filter/f-inst.c"
 #line 966 "filter/f-inst.c"
 ;
#line 966 "filter/f-inst.c"
    
#line 966 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ec_set_get_size(v1.val.ad) } ) 
#line 966
  #line 966 "filter/f-inst.c"
;
#line 966
};
  
  #undef whati
#line 967 "filter/f-inst.c"
  }
#line 967

#line 967

#line 969 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__len */
#line 969
struct f_inst *
#line 967 "filter/f-inst.c"
NONNULL(2)
#line 969 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__len(enum f_instruction_code fi_code
#line 967 "filter/f-inst.c"
  , struct f_inst * f1
#line 969 "filter/f-inst.c"
)
#line 969
  {
#line 969
    /* Allocate the structure */
#line 969
    struct f_inst *what = fi_new(fi_code);
#line 969
    uint constargs = 1;
#line 969

#line 969
    /* Initialize all the members */
#line 969
  #define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 969
  #line 967 "filter/f-inst.c"
whati->f1 = f1;
#line 967
const struct f_inst *child1 = f1;
#line 967
do {
#line 967
  what->size += child1->size;
#line 967

#line 967
  if (child1->fi_code != FI_CONSTANT)
#line 967
    constargs = 0;
#line 967

#line 967
} while (child1 = child1->next);
#line 967

#line 967 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 967
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 967
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 967 "filter/f-inst.c"
what->type = T_INT;

#line 969 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 969
    if (!constargs)
#line 969
      return what;
#line 969

#line 969
    /* Try to pre-calculate the result */
#line 969
    #line 967 "filter/f-inst.c"
 {
#line 967
  
#line 967 "filter/f-inst.c"
 #line 967 "filter/f-inst.c"
 ;
#line 967 "filter/f-inst.c"
    
#line 967 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = lc_set_get_size(v1.val.ad) } ) 
#line 967
  #line 967 "filter/f-inst.c"
;
#line 967
};

  
  #undef whati
#line 969 "filter/f-inst.c"
  }
#line 969

#line 969

#line 1005 "filter/f-inst.c"
 /* Constructor for FI_NET_SRC */
#line 1005
struct f_inst *
#line 970 "filter/f-inst.c"
NONNULL(2)
#line 1005 "filter/f-inst.c"
f_new_inst_FI_NET_SRC(enum f_instruction_code fi_code
#line 970 "filter/f-inst.c"
  , struct f_inst * f1
#line 1005 "filter/f-inst.c"
)
#line 1005
  {
#line 1005
    /* Allocate the structure */
#line 1005
    struct f_inst *what = fi_new(fi_code);
#line 1005
    uint constargs = 1;
#line 1005

#line 1005
    /* Initialize all the members */
#line 1005
  #define whati (&(what->i_FI_NET_SRC))
#line 1005
  #line 970 "filter/f-inst.c"
whati->f1 = f1;
#line 970
const struct f_inst *child1 = f1;
#line 970
do {
#line 970
  what->size += child1->size;
#line 970

#line 970
  if (child1->fi_code != FI_CONSTANT)
#line 970
    constargs = 0;
#line 970

#line 970
} while (child1 = child1->next);
#line 970

#line 970 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 970
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 970
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1002 "filter/f-inst.c"
what->type = T_NET;

#line 1005 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1005
    if (!constargs)
#line 1005
      return what;
#line 1005

#line 1005
    /* Try to pre-calculate the result */
#line 1005
    #line 969 "filter/f-inst.c"
 { 	/* Get src prefix */
    
#line 970 "filter/f-inst.c"
 #line 970 "filter/f-inst.c"
 ;
#line 971 "filter/f-inst.c"
    #line 971 "filter/f-inst.c"
;

    net_addr_union *net = (void *) v1.val.net;
    net_addr *src = falloc(sizeof(net_addr_ip6));
    const byte *part;

    switch(v1.val.net->type) {
    case NET_FLOW4:
      part = flow4_get_part(&net->flow4, FLOW_TYPE_SRC_PREFIX);
      if (part)
	net_fill_ip4(src, flow_read_ip4_part(part), flow_read_pxlen(part));
      else
	net_fill_ip4(src, IP4_NONE, 0);
      break;

    case NET_FLOW6:
      part = flow6_get_part(&net->flow6, FLOW_TYPE_SRC_PREFIX);
      if (part)
	net_fill_ip6(src, flow_read_ip6_part(part), flow_read_pxlen(part));
      else
	net_fill_ip6(src, IP6_NONE, 0);
      break;

    case NET_IP6_SADR:
      net_fill_ip6(src, net->ip6_sadr.src_prefix, net->ip6_sadr.src_pxlen);
      break;

    default:
      runtime( "Flow or SADR expected" );
    }

     
#line 1002 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_NET, .val.net = src } );
  }

  
  #undef whati
#line 1005 "filter/f-inst.c"
  }
#line 1005

#line 1005

#line 1042 "filter/f-inst.c"
 /* Constructor for FI_NET_DST */
#line 1042
struct f_inst *
#line 1006 "filter/f-inst.c"
NONNULL(2)
#line 1042 "filter/f-inst.c"
f_new_inst_FI_NET_DST(enum f_instruction_code fi_code
#line 1006 "filter/f-inst.c"
  , struct f_inst * f1
#line 1042 "filter/f-inst.c"
)
#line 1042
  {
#line 1042
    /* Allocate the structure */
#line 1042
    struct f_inst *what = fi_new(fi_code);
#line 1042
    uint constargs = 1;
#line 1042

#line 1042
    /* Initialize all the members */
#line 1042
  #define whati (&(what->i_FI_NET_DST))
#line 1042
  #line 1006 "filter/f-inst.c"
whati->f1 = f1;
#line 1006
const struct f_inst *child1 = f1;
#line 1006
do {
#line 1006
  what->size += child1->size;
#line 1006

#line 1006
  if (child1->fi_code != FI_CONSTANT)
#line 1006
    constargs = 0;
#line 1006

#line 1006
} while (child1 = child1->next);
#line 1006

#line 1006 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1006
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1006
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1038 "filter/f-inst.c"
what->type = T_NET;

#line 1042 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1042
    if (!constargs)
#line 1042
      return what;
#line 1042

#line 1042
    /* Try to pre-calculate the result */
#line 1042
    #line 1005 "filter/f-inst.c"
 { 	/* Get dst prefix */
    
#line 1006 "filter/f-inst.c"
 #line 1006 "filter/f-inst.c"
 ;
#line 1007 "filter/f-inst.c"
    #line 1007 "filter/f-inst.c"
;

    net_addr_union *net = (void *) v1.val.net;
    net_addr *dst = falloc(sizeof(net_addr_ip6));
    const byte *part;

    switch(v1.val.net->type) {
    case NET_FLOW4:
      part = flow4_get_part(&net->flow4, FLOW_TYPE_DST_PREFIX);
      if (part)
	net_fill_ip4(dst, flow_read_ip4_part(part), flow_read_pxlen(part));
      else
	net_fill_ip4(dst, IP4_NONE, 0);
      break;

    case NET_FLOW6:
      part = flow6_get_part(&net->flow6, FLOW_TYPE_DST_PREFIX);
      if (part)
	net_fill_ip6(dst, flow_read_ip6_part(part), flow_read_pxlen(part));
      else
	net_fill_ip6(dst, IP6_NONE, 0);
      break;

    case NET_IP6_SADR:
      net_fill_ip6(dst, net->ip6_sadr.dst_prefix, net->ip6_sadr.dst_pxlen);
      break;

    default:
      runtime( "Flow or SADR expected" );
    }

     
#line 1038 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_NET, .val.net = dst } );
  }

  /* Get ROA max prefix length */
  
  #undef whati
#line 1042 "filter/f-inst.c"
  }
#line 1042

#line 1042

#line 1052 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__maxlen */
#line 1052
struct f_inst *
#line 1042 "filter/f-inst.c"
NONNULL(2)
#line 1052 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__maxlen(enum f_instruction_code fi_code
#line 1042 "filter/f-inst.c"
  , struct f_inst * f1
#line 1052 "filter/f-inst.c"
)
#line 1052
  {
#line 1052
    /* Allocate the structure */
#line 1052
    struct f_inst *what = fi_new(fi_code);
#line 1052
    uint constargs = 1;
#line 1052

#line 1052
    /* Initialize all the members */
#line 1052
  #define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1052
  #line 1042 "filter/f-inst.c"
whati->f1 = f1;
#line 1042
const struct f_inst *child1 = f1;
#line 1042
do {
#line 1042
  what->size += child1->size;
#line 1042

#line 1042
  if (child1->fi_code != FI_CONSTANT)
#line 1042
    constargs = 0;
#line 1042

#line 1042
} while (child1 = child1->next);
#line 1042

#line 1042 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1042
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1042
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1042 "filter/f-inst.c"
what->type = T_INT;

#line 1052 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1052
    if (!constargs)
#line 1052
      return what;
#line 1052

#line 1052
    /* Try to pre-calculate the result */
#line 1052
    #line 1042 "filter/f-inst.c"
 {
#line 1042
  
#line 1042 "filter/f-inst.c"
 #line 1042 "filter/f-inst.c"
 ;
#line 1042 "filter/f-inst.c"
  
#line 1042
    if (!net_is_roa(v1.val.net))
#line 1042
      runtime( "ROA expected" );
#line 1042

#line 1042
     
#line 1042 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = (v1.val.net->type == NET_ROA4) ?
#line 1042
      ((net_addr_roa4 *) v1.val.net)->max_pxlen :
#line 1042
      ((net_addr_roa6 *) v1.val.net)->max_pxlen } );
#line 1042
  
#line 1042
  #line 1042 "filter/f-inst.c"
;
#line 1042
};
#line 1050

  /* Get ROA ASN */
  
  #undef whati
#line 1052 "filter/f-inst.c"
  }
#line 1052

#line 1052

#line 1062 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__asn */
#line 1062
struct f_inst *
#line 1052 "filter/f-inst.c"
NONNULL(2)
#line 1062 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__asn(enum f_instruction_code fi_code
#line 1052 "filter/f-inst.c"
  , struct f_inst * f1
#line 1062 "filter/f-inst.c"
)
#line 1062
  {
#line 1062
    /* Allocate the structure */
#line 1062
    struct f_inst *what = fi_new(fi_code);
#line 1062
    uint constargs = 1;
#line 1062

#line 1062
    /* Initialize all the members */
#line 1062
  #define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1062
  #line 1052 "filter/f-inst.c"
whati->f1 = f1;
#line 1052
const struct f_inst *child1 = f1;
#line 1052
do {
#line 1052
  what->size += child1->size;
#line 1052

#line 1052
  if (child1->fi_code != FI_CONSTANT)
#line 1052
    constargs = 0;
#line 1052

#line 1052
} while (child1 = child1->next);
#line 1052

#line 1052 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1052
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1052
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1052 "filter/f-inst.c"
what->type = T_INT;

#line 1062 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1062
    if (!constargs)
#line 1062
      return what;
#line 1062

#line 1062
    /* Try to pre-calculate the result */
#line 1062
    #line 1052 "filter/f-inst.c"
 {
#line 1052
  
#line 1052 "filter/f-inst.c"
 #line 1052 "filter/f-inst.c"
 ;
#line 1052 "filter/f-inst.c"
  
#line 1052
        if (!net_is_roa(v1.val.net))
#line 1052
          runtime( "ROA expected" );
#line 1052

#line 1052
         
#line 1052 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = (v1.val.net->type == NET_ROA4) ?
#line 1052
          ((net_addr_roa4 *) v1.val.net)->asn :
#line 1052
          ((net_addr_roa6 *) v1.val.net)->asn } );
#line 1052
  
#line 1052
  #line 1052 "filter/f-inst.c"
;
#line 1052
};
#line 1060

  /* Convert prefix to IP */
  
  #undef whati
#line 1062 "filter/f-inst.c"
  }
#line 1062

#line 1062

#line 1064 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__ip */
#line 1064
struct f_inst *
#line 1062 "filter/f-inst.c"
NONNULL(2)
#line 1064 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__ip(enum f_instruction_code fi_code
#line 1062 "filter/f-inst.c"
  , struct f_inst * f1
#line 1064 "filter/f-inst.c"
)
#line 1064
  {
#line 1064
    /* Allocate the structure */
#line 1064
    struct f_inst *what = fi_new(fi_code);
#line 1064
    uint constargs = 1;
#line 1064

#line 1064
    /* Initialize all the members */
#line 1064
  #define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1064
  #line 1062 "filter/f-inst.c"
whati->f1 = f1;
#line 1062
const struct f_inst *child1 = f1;
#line 1062
do {
#line 1062
  what->size += child1->size;
#line 1062

#line 1062
  if (child1->fi_code != FI_CONSTANT)
#line 1062
    constargs = 0;
#line 1062

#line 1062
} while (child1 = child1->next);
#line 1062

#line 1062 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1062
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1062
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1062 "filter/f-inst.c"
what->type = T_IP;

#line 1064 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1064
    if (!constargs)
#line 1064
      return what;
#line 1064

#line 1064
    /* Try to pre-calculate the result */
#line 1064
    #line 1062 "filter/f-inst.c"
 {
#line 1062
  
#line 1062 "filter/f-inst.c"
 #line 1062 "filter/f-inst.c"
 ;
#line 1062 "filter/f-inst.c"
    
#line 1062 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip = net_prefix(v1.val.net) } ) 
#line 1062
  #line 1062 "filter/f-inst.c"
;
#line 1062
};

  
  #undef whati
#line 1064 "filter/f-inst.c"
  }
#line 1064

#line 1064

#line 1073 "filter/f-inst.c"
 /* Constructor for FI_ROUTE_DISTINGUISHER */
#line 1073
struct f_inst *
#line 1065 "filter/f-inst.c"
NONNULL(2)
#line 1073 "filter/f-inst.c"
f_new_inst_FI_ROUTE_DISTINGUISHER(enum f_instruction_code fi_code
#line 1065 "filter/f-inst.c"
  , struct f_inst * f1
#line 1073 "filter/f-inst.c"
)
#line 1073
  {
#line 1073
    /* Allocate the structure */
#line 1073
    struct f_inst *what = fi_new(fi_code);
#line 1073
    uint constargs = 1;
#line 1073

#line 1073
    /* Initialize all the members */
#line 1073
  #define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1073
  #line 1065 "filter/f-inst.c"
whati->f1 = f1;
#line 1065
const struct f_inst *child1 = f1;
#line 1065
do {
#line 1065
  what->size += child1->size;
#line 1065

#line 1065
  if (child1->fi_code != FI_CONSTANT)
#line 1065
    constargs = 0;
#line 1065

#line 1065
} while (child1 = child1->next);
#line 1065

#line 1065 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1065
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1065
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1069 "filter/f-inst.c"
what->type = T_RD;

#line 1073 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1073
    if (!constargs)
#line 1073
      return what;
#line 1073

#line 1073
    /* Try to pre-calculate the result */
#line 1073
    #line 1064 "filter/f-inst.c"
 {
    
#line 1065 "filter/f-inst.c"
 #line 1065 "filter/f-inst.c"
 ;
#line 1066 "filter/f-inst.c"
    #line 1066 "filter/f-inst.c"
;
    if (!net_is_vpn(v1.val.net))
      runtime( "VPN address expected" );
     
#line 1069 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_RD, .val.rd = net_rd(v1.val.net) } );
  }

  /* Get first ASN from AS PATH */
  
  #undef whati
#line 1073 "filter/f-inst.c"
  }
#line 1073

#line 1073

#line 1076 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__first */
#line 1076
struct f_inst *
#line 1073 "filter/f-inst.c"
NONNULL(2)
#line 1076 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__first(enum f_instruction_code fi_code
#line 1073 "filter/f-inst.c"
  , struct f_inst * f1
#line 1076 "filter/f-inst.c"
)
#line 1076
  {
#line 1076
    /* Allocate the structure */
#line 1076
    struct f_inst *what = fi_new(fi_code);
#line 1076
    uint constargs = 1;
#line 1076

#line 1076
    /* Initialize all the members */
#line 1076
  #define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1076
  #line 1073 "filter/f-inst.c"
whati->f1 = f1;
#line 1073
const struct f_inst *child1 = f1;
#line 1073
do {
#line 1073
  what->size += child1->size;
#line 1073

#line 1073
  if (child1->fi_code != FI_CONSTANT)
#line 1073
    constargs = 0;
#line 1073

#line 1073
} while (child1 = child1->next);
#line 1073

#line 1073 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1073
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1073
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1073 "filter/f-inst.c"
what->type = T_INT;

#line 1076 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1076
    if (!constargs)
#line 1076
      return what;
#line 1076

#line 1076
    /* Try to pre-calculate the result */
#line 1076
    #line 1073 "filter/f-inst.c"
 {
#line 1073
  
#line 1073 "filter/f-inst.c"
 #line 1073 "filter/f-inst.c"
 ;
#line 1073 "filter/f-inst.c"
    
#line 1073 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ({ u32 as = 0; as_path_get_first(v1.val.ad, &as); as; }) } ) 
#line 1073
  #line 1073 "filter/f-inst.c"
;
#line 1073
};

  /* Get last ASN from AS PATH */
  
  #undef whati
#line 1076 "filter/f-inst.c"
  }
#line 1076

#line 1076

#line 1079 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__last */
#line 1079
struct f_inst *
#line 1076 "filter/f-inst.c"
NONNULL(2)
#line 1079 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__last(enum f_instruction_code fi_code
#line 1076 "filter/f-inst.c"
  , struct f_inst * f1
#line 1079 "filter/f-inst.c"
)
#line 1079
  {
#line 1079
    /* Allocate the structure */
#line 1079
    struct f_inst *what = fi_new(fi_code);
#line 1079
    uint constargs = 1;
#line 1079

#line 1079
    /* Initialize all the members */
#line 1079
  #define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1079
  #line 1076 "filter/f-inst.c"
whati->f1 = f1;
#line 1076
const struct f_inst *child1 = f1;
#line 1076
do {
#line 1076
  what->size += child1->size;
#line 1076

#line 1076
  if (child1->fi_code != FI_CONSTANT)
#line 1076
    constargs = 0;
#line 1076

#line 1076
} while (child1 = child1->next);
#line 1076

#line 1076 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1076
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1076
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1076 "filter/f-inst.c"
what->type = T_INT;

#line 1079 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1079
    if (!constargs)
#line 1079
      return what;
#line 1079

#line 1079
    /* Try to pre-calculate the result */
#line 1079
    #line 1076 "filter/f-inst.c"
 {
#line 1076
  
#line 1076 "filter/f-inst.c"
 #line 1076 "filter/f-inst.c"
 ;
#line 1076 "filter/f-inst.c"
    
#line 1076 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ({ u32 as = 0; as_path_get_last(v1.val.ad, &as); as; }) } ) 
#line 1076
  #line 1076 "filter/f-inst.c"
;
#line 1076
};

  /* Get last ASN from non-aggregated part of AS PATH */
  
  #undef whati
#line 1079 "filter/f-inst.c"
  }
#line 1079

#line 1079

#line 1082 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
struct f_inst *
#line 1079 "filter/f-inst.c"
NONNULL(2)
#line 1082 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__last_nonaggregated(enum f_instruction_code fi_code
#line 1079 "filter/f-inst.c"
  , struct f_inst * f1
#line 1082 "filter/f-inst.c"
)
#line 1082
  {
#line 1082
    /* Allocate the structure */
#line 1082
    struct f_inst *what = fi_new(fi_code);
#line 1082
    uint constargs = 1;
#line 1082

#line 1082
    /* Initialize all the members */
#line 1082
  #define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
  #line 1079 "filter/f-inst.c"
whati->f1 = f1;
#line 1079
const struct f_inst *child1 = f1;
#line 1079
do {
#line 1079
  what->size += child1->size;
#line 1079

#line 1079
  if (child1->fi_code != FI_CONSTANT)
#line 1079
    constargs = 0;
#line 1079

#line 1079
} while (child1 = child1->next);
#line 1079

#line 1079 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1079
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1079
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1079 "filter/f-inst.c"
what->type = T_INT;

#line 1082 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1082
    if (!constargs)
#line 1082
      return what;
#line 1082

#line 1082
    /* Try to pre-calculate the result */
#line 1082
    #line 1079 "filter/f-inst.c"
 {
#line 1079
  
#line 1079 "filter/f-inst.c"
 #line 1079 "filter/f-inst.c"
 ;
#line 1079 "filter/f-inst.c"
    
#line 1079 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = as_path_get_last_nonaggregated(v1.val.ad) } ) 
#line 1079
  #line 1079 "filter/f-inst.c"
;
#line 1079
};

  /* Get ASN part from the standard community ASN */
  
  #undef whati
#line 1082 "filter/f-inst.c"
  }
#line 1082

#line 1082

#line 1085 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PAIR__asn */
#line 1085
struct f_inst *
#line 1082 "filter/f-inst.c"
NONNULL(2)
#line 1085 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PAIR__asn(enum f_instruction_code fi_code
#line 1082 "filter/f-inst.c"
  , struct f_inst * f1
#line 1085 "filter/f-inst.c"
)
#line 1085
  {
#line 1085
    /* Allocate the structure */
#line 1085
    struct f_inst *what = fi_new(fi_code);
#line 1085
    uint constargs = 1;
#line 1085

#line 1085
    /* Initialize all the members */
#line 1085
  #define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1085
  #line 1082 "filter/f-inst.c"
whati->f1 = f1;
#line 1082
const struct f_inst *child1 = f1;
#line 1082
do {
#line 1082
  what->size += child1->size;
#line 1082

#line 1082
  if (child1->fi_code != FI_CONSTANT)
#line 1082
    constargs = 0;
#line 1082

#line 1082
} while (child1 = child1->next);
#line 1082

#line 1082 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PAIR)) && !f_const_promotion(f1, (T_PAIR)))
#line 1082
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1082
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f1->type));
#line 1082 "filter/f-inst.c"
what->type = T_INT;

#line 1085 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1085
    if (!constargs)
#line 1085
      return what;
#line 1085

#line 1085
    /* Try to pre-calculate the result */
#line 1085
    #line 1082 "filter/f-inst.c"
 {
#line 1082
  
#line 1082 "filter/f-inst.c"
 #line 1082 "filter/f-inst.c"
 ;
#line 1082 "filter/f-inst.c"
    
#line 1082 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i >> 16 } ) 
#line 1082
  #line 1082 "filter/f-inst.c"
;
#line 1082
};

  /* Get data part from the standard community */
  
  #undef whati
#line 1085 "filter/f-inst.c"
  }
#line 1085

#line 1085

#line 1088 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PAIR__data */
#line 1088
struct f_inst *
#line 1085 "filter/f-inst.c"
NONNULL(2)
#line 1088 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PAIR__data(enum f_instruction_code fi_code
#line 1085 "filter/f-inst.c"
  , struct f_inst * f1
#line 1088 "filter/f-inst.c"
)
#line 1088
  {
#line 1088
    /* Allocate the structure */
#line 1088
    struct f_inst *what = fi_new(fi_code);
#line 1088
    uint constargs = 1;
#line 1088

#line 1088
    /* Initialize all the members */
#line 1088
  #define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1088
  #line 1085 "filter/f-inst.c"
whati->f1 = f1;
#line 1085
const struct f_inst *child1 = f1;
#line 1085
do {
#line 1085
  what->size += child1->size;
#line 1085

#line 1085
  if (child1->fi_code != FI_CONSTANT)
#line 1085
    constargs = 0;
#line 1085

#line 1085
} while (child1 = child1->next);
#line 1085

#line 1085 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PAIR)) && !f_const_promotion(f1, (T_PAIR)))
#line 1085
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1085
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f1->type));
#line 1085 "filter/f-inst.c"
what->type = T_INT;

#line 1088 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1088
    if (!constargs)
#line 1088
      return what;
#line 1088

#line 1088
    /* Try to pre-calculate the result */
#line 1088
    #line 1085 "filter/f-inst.c"
 {
#line 1085
  
#line 1085 "filter/f-inst.c"
 #line 1085 "filter/f-inst.c"
 ;
#line 1085 "filter/f-inst.c"
    
#line 1085 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i & 0xFFFF } ) 
#line 1085
  #line 1085 "filter/f-inst.c"
;
#line 1085
};

  /* Get ASN part from the large community */
  
  #undef whati
#line 1088 "filter/f-inst.c"
  }
#line 1088

#line 1088

#line 1091 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__asn */
#line 1091
struct f_inst *
#line 1088 "filter/f-inst.c"
NONNULL(2)
#line 1091 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__asn(enum f_instruction_code fi_code
#line 1088 "filter/f-inst.c"
  , struct f_inst * f1
#line 1091 "filter/f-inst.c"
)
#line 1091
  {
#line 1091
    /* Allocate the structure */
#line 1091
    struct f_inst *what = fi_new(fi_code);
#line 1091
    uint constargs = 1;
#line 1091

#line 1091
    /* Initialize all the members */
#line 1091
  #define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1091
  #line 1088 "filter/f-inst.c"
whati->f1 = f1;
#line 1088
const struct f_inst *child1 = f1;
#line 1088
do {
#line 1088
  what->size += child1->size;
#line 1088

#line 1088
  if (child1->fi_code != FI_CONSTANT)
#line 1088
    constargs = 0;
#line 1088

#line 1088
} while (child1 = child1->next);
#line 1088

#line 1088 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1088
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1088
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1088 "filter/f-inst.c"
what->type = T_INT;

#line 1091 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1091
    if (!constargs)
#line 1091
      return what;
#line 1091

#line 1091
    /* Try to pre-calculate the result */
#line 1091
    #line 1088 "filter/f-inst.c"
 {
#line 1088
  
#line 1088 "filter/f-inst.c"
 #line 1088 "filter/f-inst.c"
 ;
#line 1088 "filter/f-inst.c"
    
#line 1088 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.asn } ) 
#line 1088
  #line 1088 "filter/f-inst.c"
;
#line 1088
};

  /* Get data1 part from the large community */
  
  #undef whati
#line 1091 "filter/f-inst.c"
  }
#line 1091

#line 1091

#line 1094 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__data1 */
#line 1094
struct f_inst *
#line 1091 "filter/f-inst.c"
NONNULL(2)
#line 1094 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__data1(enum f_instruction_code fi_code
#line 1091 "filter/f-inst.c"
  , struct f_inst * f1
#line 1094 "filter/f-inst.c"
)
#line 1094
  {
#line 1094
    /* Allocate the structure */
#line 1094
    struct f_inst *what = fi_new(fi_code);
#line 1094
    uint constargs = 1;
#line 1094

#line 1094
    /* Initialize all the members */
#line 1094
  #define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1094
  #line 1091 "filter/f-inst.c"
whati->f1 = f1;
#line 1091
const struct f_inst *child1 = f1;
#line 1091
do {
#line 1091
  what->size += child1->size;
#line 1091

#line 1091
  if (child1->fi_code != FI_CONSTANT)
#line 1091
    constargs = 0;
#line 1091

#line 1091
} while (child1 = child1->next);
#line 1091

#line 1091 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1091
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1091
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1091 "filter/f-inst.c"
what->type = T_INT;

#line 1094 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1094
    if (!constargs)
#line 1094
      return what;
#line 1094

#line 1094
    /* Try to pre-calculate the result */
#line 1094
    #line 1091 "filter/f-inst.c"
 {
#line 1091
  
#line 1091 "filter/f-inst.c"
 #line 1091 "filter/f-inst.c"
 ;
#line 1091 "filter/f-inst.c"
    
#line 1091 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.ldp1 } ) 
#line 1091
  #line 1091 "filter/f-inst.c"
;
#line 1091
};

  /* Get data2 part from the large community */
  
  #undef whati
#line 1094 "filter/f-inst.c"
  }
#line 1094

#line 1094

#line 1097 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__data2 */
#line 1097
struct f_inst *
#line 1094 "filter/f-inst.c"
NONNULL(2)
#line 1097 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__data2(enum f_instruction_code fi_code
#line 1094 "filter/f-inst.c"
  , struct f_inst * f1
#line 1097 "filter/f-inst.c"
)
#line 1097
  {
#line 1097
    /* Allocate the structure */
#line 1097
    struct f_inst *what = fi_new(fi_code);
#line 1097
    uint constargs = 1;
#line 1097

#line 1097
    /* Initialize all the members */
#line 1097
  #define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1097
  #line 1094 "filter/f-inst.c"
whati->f1 = f1;
#line 1094
const struct f_inst *child1 = f1;
#line 1094
do {
#line 1094
  what->size += child1->size;
#line 1094

#line 1094
  if (child1->fi_code != FI_CONSTANT)
#line 1094
    constargs = 0;
#line 1094

#line 1094
} while (child1 = child1->next);
#line 1094

#line 1094 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1094
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1094
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1094 "filter/f-inst.c"
what->type = T_INT;

#line 1097 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1097
    if (!constargs)
#line 1097
      return what;
#line 1097

#line 1097
    /* Try to pre-calculate the result */
#line 1097
    #line 1094 "filter/f-inst.c"
 {
#line 1094
  
#line 1094 "filter/f-inst.c"
 #line 1094 "filter/f-inst.c"
 ;
#line 1094 "filter/f-inst.c"
    
#line 1094 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.ldp2 } ) 
#line 1094
  #line 1094 "filter/f-inst.c"
;
#line 1094
};

  /* Get minimum element from clist */
  
  #undef whati
#line 1097 "filter/f-inst.c"
  }
#line 1097

#line 1097

#line 1100 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__min */
#line 1100
struct f_inst *
#line 1097 "filter/f-inst.c"
NONNULL(2)
#line 1100 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__min(enum f_instruction_code fi_code
#line 1097 "filter/f-inst.c"
  , struct f_inst * f1
#line 1100 "filter/f-inst.c"
)
#line 1100
  {
#line 1100
    /* Allocate the structure */
#line 1100
    struct f_inst *what = fi_new(fi_code);
#line 1100
    uint constargs = 1;
#line 1100

#line 1100
    /* Initialize all the members */
#line 1100
  #define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1100
  #line 1097 "filter/f-inst.c"
whati->f1 = f1;
#line 1097
const struct f_inst *child1 = f1;
#line 1097
do {
#line 1097
  what->size += child1->size;
#line 1097

#line 1097
  if (child1->fi_code != FI_CONSTANT)
#line 1097
    constargs = 0;
#line 1097

#line 1097
} while (child1 = child1->next);
#line 1097

#line 1097 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1097
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1097
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1097 "filter/f-inst.c"
what->type = T_PAIR;

#line 1100 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1100
    if (!constargs)
#line 1100
      return what;
#line 1100

#line 1100
    /* Try to pre-calculate the result */
#line 1100
    #line 1097 "filter/f-inst.c"
 {
#line 1097
  
#line 1097 "filter/f-inst.c"
 #line 1097 "filter/f-inst.c"
 ;
#line 1097 "filter/f-inst.c"
    
#line 1097 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = ({ u32 val = 0; int_set_min(v1.val.ad, &val); val; }) } ) 
#line 1097
  #line 1097 "filter/f-inst.c"
;
#line 1097
};

  /* Get maximum element from clist */
  
  #undef whati
#line 1100 "filter/f-inst.c"
  }
#line 1100

#line 1100

#line 1103 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__max */
#line 1103
struct f_inst *
#line 1100 "filter/f-inst.c"
NONNULL(2)
#line 1103 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__max(enum f_instruction_code fi_code
#line 1100 "filter/f-inst.c"
  , struct f_inst * f1
#line 1103 "filter/f-inst.c"
)
#line 1103
  {
#line 1103
    /* Allocate the structure */
#line 1103
    struct f_inst *what = fi_new(fi_code);
#line 1103
    uint constargs = 1;
#line 1103

#line 1103
    /* Initialize all the members */
#line 1103
  #define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1103
  #line 1100 "filter/f-inst.c"
whati->f1 = f1;
#line 1100
const struct f_inst *child1 = f1;
#line 1100
do {
#line 1100
  what->size += child1->size;
#line 1100

#line 1100
  if (child1->fi_code != FI_CONSTANT)
#line 1100
    constargs = 0;
#line 1100

#line 1100
} while (child1 = child1->next);
#line 1100

#line 1100 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1100
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1100
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1100 "filter/f-inst.c"
what->type = T_PAIR;

#line 1103 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1103
    if (!constargs)
#line 1103
      return what;
#line 1103

#line 1103
    /* Try to pre-calculate the result */
#line 1103
    #line 1100 "filter/f-inst.c"
 {
#line 1100
  
#line 1100 "filter/f-inst.c"
 #line 1100 "filter/f-inst.c"
 ;
#line 1100 "filter/f-inst.c"
    
#line 1100 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = ({ u32 val = 0; int_set_max(v1.val.ad, &val); val; }) } ) 
#line 1100
  #line 1100 "filter/f-inst.c"
;
#line 1100
};

  /* Get minimum element from eclist */
  
  #undef whati
#line 1103 "filter/f-inst.c"
  }
#line 1103

#line 1103

#line 1106 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__min */
#line 1106
struct f_inst *
#line 1103 "filter/f-inst.c"
NONNULL(2)
#line 1106 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__min(enum f_instruction_code fi_code
#line 1103 "filter/f-inst.c"
  , struct f_inst * f1
#line 1106 "filter/f-inst.c"
)
#line 1106
  {
#line 1106
    /* Allocate the structure */
#line 1106
    struct f_inst *what = fi_new(fi_code);
#line 1106
    uint constargs = 1;
#line 1106

#line 1106
    /* Initialize all the members */
#line 1106
  #define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1106
  #line 1103 "filter/f-inst.c"
whati->f1 = f1;
#line 1103
const struct f_inst *child1 = f1;
#line 1103
do {
#line 1103
  what->size += child1->size;
#line 1103

#line 1103
  if (child1->fi_code != FI_CONSTANT)
#line 1103
    constargs = 0;
#line 1103

#line 1103
} while (child1 = child1->next);
#line 1103

#line 1103 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1103
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1103
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1103 "filter/f-inst.c"
what->type = T_EC;

#line 1106 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1106
    if (!constargs)
#line 1106
      return what;
#line 1106

#line 1106
    /* Try to pre-calculate the result */
#line 1106
    #line 1103 "filter/f-inst.c"
 {
#line 1103
  
#line 1103 "filter/f-inst.c"
 #line 1103 "filter/f-inst.c"
 ;
#line 1103 "filter/f-inst.c"
    
#line 1103 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ({ u64 val = 0; ec_set_min(v1.val.ad, &val); val; }) } ) 
#line 1103
  #line 1103 "filter/f-inst.c"
;
#line 1103
};

  /* Get maximum element from eclist */
  
  #undef whati
#line 1106 "filter/f-inst.c"
  }
#line 1106

#line 1106

#line 1109 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__max */
#line 1109
struct f_inst *
#line 1106 "filter/f-inst.c"
NONNULL(2)
#line 1109 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__max(enum f_instruction_code fi_code
#line 1106 "filter/f-inst.c"
  , struct f_inst * f1
#line 1109 "filter/f-inst.c"
)
#line 1109
  {
#line 1109
    /* Allocate the structure */
#line 1109
    struct f_inst *what = fi_new(fi_code);
#line 1109
    uint constargs = 1;
#line 1109

#line 1109
    /* Initialize all the members */
#line 1109
  #define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1109
  #line 1106 "filter/f-inst.c"
whati->f1 = f1;
#line 1106
const struct f_inst *child1 = f1;
#line 1106
do {
#line 1106
  what->size += child1->size;
#line 1106

#line 1106
  if (child1->fi_code != FI_CONSTANT)
#line 1106
    constargs = 0;
#line 1106

#line 1106
} while (child1 = child1->next);
#line 1106

#line 1106 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1106
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1106
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1106 "filter/f-inst.c"
what->type = T_EC;

#line 1109 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1109
    if (!constargs)
#line 1109
      return what;
#line 1109

#line 1109
    /* Try to pre-calculate the result */
#line 1109
    #line 1106 "filter/f-inst.c"
 {
#line 1106
  
#line 1106 "filter/f-inst.c"
 #line 1106 "filter/f-inst.c"
 ;
#line 1106 "filter/f-inst.c"
    
#line 1106 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ({ u64 val = 0; ec_set_max(v1.val.ad, &val); val; }) } ) 
#line 1106
  #line 1106 "filter/f-inst.c"
;
#line 1106
};

  /* Get minimum element from lclist */
  
  #undef whati
#line 1109 "filter/f-inst.c"
  }
#line 1109

#line 1109

#line 1112 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__min */
#line 1112
struct f_inst *
#line 1109 "filter/f-inst.c"
NONNULL(2)
#line 1112 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__min(enum f_instruction_code fi_code
#line 1109 "filter/f-inst.c"
  , struct f_inst * f1
#line 1112 "filter/f-inst.c"
)
#line 1112
  {
#line 1112
    /* Allocate the structure */
#line 1112
    struct f_inst *what = fi_new(fi_code);
#line 1112
    uint constargs = 1;
#line 1112

#line 1112
    /* Initialize all the members */
#line 1112
  #define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1112
  #line 1109 "filter/f-inst.c"
whati->f1 = f1;
#line 1109
const struct f_inst *child1 = f1;
#line 1109
do {
#line 1109
  what->size += child1->size;
#line 1109

#line 1109
  if (child1->fi_code != FI_CONSTANT)
#line 1109
    constargs = 0;
#line 1109

#line 1109
} while (child1 = child1->next);
#line 1109

#line 1109 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1109
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1109
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1109 "filter/f-inst.c"
what->type = T_LC;

#line 1112 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1112
    if (!constargs)
#line 1112
      return what;
#line 1112

#line 1112
    /* Try to pre-calculate the result */
#line 1112
    #line 1109 "filter/f-inst.c"
 {
#line 1109
  
#line 1109 "filter/f-inst.c"
 #line 1109 "filter/f-inst.c"
 ;
#line 1109 "filter/f-inst.c"
    
#line 1109 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = ({ lcomm val = {}; lc_set_min(v1.val.ad, &val); val; }) } ) 
#line 1109
  #line 1109 "filter/f-inst.c"
;
#line 1109
};

  /* Get maximum element from lclist */
  
  #undef whati
#line 1112 "filter/f-inst.c"
  }
#line 1112

#line 1112

#line 1114 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__max */
#line 1114
struct f_inst *
#line 1112 "filter/f-inst.c"
NONNULL(2)
#line 1114 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__max(enum f_instruction_code fi_code
#line 1112 "filter/f-inst.c"
  , struct f_inst * f1
#line 1114 "filter/f-inst.c"
)
#line 1114
  {
#line 1114
    /* Allocate the structure */
#line 1114
    struct f_inst *what = fi_new(fi_code);
#line 1114
    uint constargs = 1;
#line 1114

#line 1114
    /* Initialize all the members */
#line 1114
  #define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1114
  #line 1112 "filter/f-inst.c"
whati->f1 = f1;
#line 1112
const struct f_inst *child1 = f1;
#line 1112
do {
#line 1112
  what->size += child1->size;
#line 1112

#line 1112
  if (child1->fi_code != FI_CONSTANT)
#line 1112
    constargs = 0;
#line 1112

#line 1112
} while (child1 = child1->next);
#line 1112

#line 1112 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1112
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1112
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1112 "filter/f-inst.c"
what->type = T_LC;

#line 1114 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1114
    if (!constargs)
#line 1114
      return what;
#line 1114

#line 1114
    /* Try to pre-calculate the result */
#line 1114
    #line 1112 "filter/f-inst.c"
 {
#line 1112
  
#line 1112 "filter/f-inst.c"
 #line 1112 "filter/f-inst.c"
 ;
#line 1112 "filter/f-inst.c"
    
#line 1112 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = ({ lcomm val = {}; lc_set_max(v1.val.ad, &val); val; }) } ) 
#line 1112
  #line 1112 "filter/f-inst.c"
;
#line 1112
};

  
  #undef whati
#line 1114 "filter/f-inst.c"
  }
#line 1114

#line 1114

#line 1140 "filter/f-inst.c"
 /* Constructor for FI_RETURN */
#line 1140
struct f_inst *
#line 1117 "filter/f-inst.c"
NONNULL(2)
#line 1140 "filter/f-inst.c"
f_new_inst_FI_RETURN(enum f_instruction_code fi_code
#line 1117 "filter/f-inst.c"
  , struct f_inst * f1
#line 1140 "filter/f-inst.c"
)
#line 1140
  {
#line 1140
    /* Allocate the structure */
#line 1140
    struct f_inst *what = fi_new(fi_code);
#line 1140
    
#line 1140

#line 1140
    /* Initialize all the members */
#line 1140
  #define whati (&(what->i_FI_RETURN))
#line 1140
  #line 1117 "filter/f-inst.c"
whati->f1 = f1;
#line 1117
const struct f_inst *child1 = f1;
#line 1117
do {
#line 1117
  what->size += child1->size;
#line 1117

#line 1117
} while (child1 = child1->next);
#line 1117


#line 1140 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1140
    
#line 1140
      return what;
#line 1140

#line 1140
    /* Try to pre-calculate the result */
#line 1140
      #undef whati
#line 1140
  }
#line 1140

#line 1140

#line 1200 "filter/f-inst.c"
 /* Constructor for FI_CALL */
#line 1200
struct f_inst *
#line 1200
f_new_inst_FI_CALL(enum f_instruction_code fi_code
#line 1142 "filter/f-inst.c"
  , struct f_inst * fvar
#line 1143 "filter/f-inst.c"
  , struct symbol * sym
#line 1200 "filter/f-inst.c"
)
#line 1200
  {
#line 1200
    /* Allocate the structure */
#line 1200
    struct f_inst *what = fi_new(fi_code);
#line 1200
    
#line 1200

#line 1200
    /* Initialize all the members */
#line 1200
  #define whati (&(what->i_FI_CALL))
#line 1200
  #line 1142 "filter/f-inst.c"
whati->varcount = 0;
#line 1142
whati->fvar = fvar;
#line 1142
for (const struct f_inst *child = fvar; child; child = child->next, whati->varcount++) {
#line 1142
  what->size += child->size;
#line 1142

#line 1142
}
#line 1142

#line 1143 "filter/f-inst.c"
whati->sym = sym;
#line 1144 "filter/f-inst.c"
what->type = sym->function->return_type;

#line 1147 "filter/f-inst.c"
    ASSERT(sym->class == SYM_FUNCTION);

    if (whati->varcount != sym->function->args)
      cf_error("Function '%s' expects %u arguments, got %u arguments",
	       sym->name, sym->function->args, whati->varcount);

    /* Typecheck individual arguments */
    struct f_inst *a = fvar;
    struct f_arg *b = sym->function->arg_list;
    for (uint i = 1; a && b; a = a->next, b = b->next, i++)
    {
      enum btype b_type = b->arg->class & 0xff;

      if (a->type && (a->type != b_type) && !f_const_promotion(a, b_type))
	cf_error("Argument %u of '%s' must be %s, got %s",
		 i, sym->name, f_type_name(b_type), f_type_name(a->type));
    }
    ASSERT(!a && !b);

    /* Add implicit void slot for the return value */
    struct f_inst *tmp = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_VOID });
    tmp->next = whati->fvar;
    whati->fvar = tmp;
    what->size += tmp->size;

    /* Mark recursive calls, they have dummy f_line */
    if (!sym->function->len)
      what->flags |= FIF_RECURSIVE;

    
#line 1200 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1200
    
#line 1200
      return what;
#line 1200

#line 1200
    /* Try to pre-calculate the result */
#line 1200
      #undef whati
#line 1200
  }
#line 1200

#line 1200

#line 1205 "filter/f-inst.c"
 /* Constructor for FI_DROP_RESULT */
#line 1205
struct f_inst *
#line 1202 "filter/f-inst.c"
NONNULL(2)
#line 1205 "filter/f-inst.c"
f_new_inst_FI_DROP_RESULT(enum f_instruction_code fi_code
#line 1202 "filter/f-inst.c"
  , struct f_inst * f1
#line 1205 "filter/f-inst.c"
)
#line 1205
  {
#line 1205
    /* Allocate the structure */
#line 1205
    struct f_inst *what = fi_new(fi_code);
#line 1205
    
#line 1205

#line 1205
    /* Initialize all the members */
#line 1205
  #define whati (&(what->i_FI_DROP_RESULT))
#line 1205
  #line 1202 "filter/f-inst.c"
whati->f1 = f1;
#line 1202
const struct f_inst *child1 = f1;
#line 1202
do {
#line 1202
  what->size += child1->size;
#line 1202

#line 1202
} while (child1 = child1->next);
#line 1202


#line 1205 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1205
    
#line 1205
      return what;
#line 1205

#line 1205
    /* Try to pre-calculate the result */
#line 1205
      #undef whati
#line 1205
  }
#line 1205

#line 1205

#line 1246 "filter/f-inst.c"
 /* Constructor for FI_SWITCH */
#line 1246
struct f_inst *
#line 1206 "filter/f-inst.c"
NONNULL(2)
#line 1246 "filter/f-inst.c"
f_new_inst_FI_SWITCH(enum f_instruction_code fi_code
#line 1206 "filter/f-inst.c"
  , struct f_inst * f1
#line 1208 "filter/f-inst.c"
  , struct f_tree * tree
#line 1246 "filter/f-inst.c"
)
#line 1246
  {
#line 1246
    /* Allocate the structure */
#line 1246
    struct f_inst *what = fi_new(fi_code);
#line 1246
    uint constargs = 1;
#line 1246

#line 1246
    /* Initialize all the members */
#line 1246
  #define whati (&(what->i_FI_SWITCH))
#line 1246
  #line 1206 "filter/f-inst.c"
whati->f1 = f1;
#line 1206
const struct f_inst *child1 = f1;
#line 1206
do {
#line 1206
  what->size += child1->size;
#line 1206

#line 1206
  if (child1->fi_code != FI_CONSTANT)
#line 1206
    constargs = 0;
#line 1206

#line 1206
} while (child1 = child1->next);
#line 1206

#line 1208 "filter/f-inst.c"
whati->tree = tree;

#line 1246 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1246
    if (!constargs)
#line 1246
      return what;
#line 1246

#line 1246
    /* Try to pre-calculate the result */
#line 1246
    #line 1205 "filter/f-inst.c"
 {
    
#line 1206 "filter/f-inst.c"
;

    #line 1208 "filter/f-inst.c"
;

    
#line 1232 "filter/f-inst.c"
    /* In parse-time use find_tree_linear(), in runtime use find_tree() */
    const struct f_tree *t = find_tree_linear(tree, &v1);
    if (!t) {
      v1.type = T_VOID;
      t = find_tree_linear(tree, &v1);
      if (!t) {
	debug( "No else statement?\n");
	return NULL;
      }
    }

    return t->data ;
#line 1244 "filter/f-inst.c"
  }

  
  #undef whati
#line 1246 "filter/f-inst.c"
  }
#line 1246

#line 1246

#line 1255 "filter/f-inst.c"
 /* Constructor for FI_IP_MASK */
#line 1255
struct f_inst *
#line 1247 "filter/f-inst.c"
NONNULL(2)
#line 1248 "filter/f-inst.c"
NONNULL(3)
#line 1255 "filter/f-inst.c"
f_new_inst_FI_IP_MASK(enum f_instruction_code fi_code
#line 1247 "filter/f-inst.c"
  , struct f_inst * f1
#line 1248 "filter/f-inst.c"
  , struct f_inst * f2
#line 1255 "filter/f-inst.c"
)
#line 1255
  {
#line 1255
    /* Allocate the structure */
#line 1255
    struct f_inst *what = fi_new(fi_code);
#line 1255
    uint constargs = 1;
#line 1255

#line 1255
    /* Initialize all the members */
#line 1255
  #define whati (&(what->i_FI_IP_MASK))
#line 1255
  #line 1247 "filter/f-inst.c"
whati->f1 = f1;
#line 1247
const struct f_inst *child1 = f1;
#line 1247
do {
#line 1247
  what->size += child1->size;
#line 1247

#line 1247
  if (child1->fi_code != FI_CONSTANT)
#line 1247
    constargs = 0;
#line 1247

#line 1247
} while (child1 = child1->next);
#line 1247

#line 1247 "filter/f-inst.c"
if (f1->type && (f1->type != (T_IP)) && !f_const_promotion(f1, (T_IP)))
#line 1247
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1247
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f1->type));
#line 1248 "filter/f-inst.c"
whati->f2 = f2;
#line 1248
const struct f_inst *child2 = f2;
#line 1248
do {
#line 1248
  what->size += child2->size;
#line 1248

#line 1248
  if (child2->fi_code != FI_CONSTANT)
#line 1248
    constargs = 0;
#line 1248

#line 1248
} while (child2 = child2->next);
#line 1248 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1248
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1248
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1250 "filter/f-inst.c"
what->type = T_IP;

#line 1255 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1255
    if (!constargs)
#line 1255
      return what;
#line 1255

#line 1255
    /* Try to pre-calculate the result */
#line 1255
    #line 1246 "filter/f-inst.c"
 { /* IP.MASK(val) */
    
#line 1247 "filter/f-inst.c"
 #line 1247 "filter/f-inst.c"
 ;
#line 1248 "filter/f-inst.c"
    
#line 1248 "filter/f-inst.c"
 #line 1248 "filter/f-inst.c"
 ;
#line 1249 "filter/f-inst.c"
    #line 1249 "filter/f-inst.c"
;
     
#line 1250 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip =  ipa_is_ip4(v1.val.ip) ?
#line 1250
      ipa_from_ip4(ip4_and(ipa_to_ip4(v1.val.ip), ip4_mkmask(v2.val.i))) :
#line 1250
      ipa_from_ip6(ip6_and(ipa_to_ip6(v1.val.ip), ip6_mkmask(v2.val.i)))  } );
#line 1253
  }

  
  #undef whati
#line 1255 "filter/f-inst.c"
  }
#line 1255

#line 1255

#line 1263 "filter/f-inst.c"
 /* Constructor for FI_PATH_PREPEND */
#line 1263
struct f_inst *
#line 1256 "filter/f-inst.c"
NONNULL(2)
#line 1257 "filter/f-inst.c"
NONNULL(3)
#line 1263 "filter/f-inst.c"
f_new_inst_FI_PATH_PREPEND(enum f_instruction_code fi_code
#line 1256 "filter/f-inst.c"
  , struct f_inst * f1
#line 1257 "filter/f-inst.c"
  , struct f_inst * f2
#line 1263 "filter/f-inst.c"
)
#line 1263
  {
#line 1263
    /* Allocate the structure */
#line 1263
    struct f_inst *what = fi_new(fi_code);
#line 1263
    uint constargs = 1;
#line 1263

#line 1263
    /* Initialize all the members */
#line 1263
  #define whati (&(what->i_FI_PATH_PREPEND))
#line 1263
  #line 1256 "filter/f-inst.c"
whati->f1 = f1;
#line 1256
const struct f_inst *child1 = f1;
#line 1256
do {
#line 1256
  what->size += child1->size;
#line 1256

#line 1256
  if (child1->fi_code != FI_CONSTANT)
#line 1256
    constargs = 0;
#line 1256

#line 1256
} while (child1 = child1->next);
#line 1256

#line 1256 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1256
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1256
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1257 "filter/f-inst.c"
whati->f2 = f2;
#line 1257
const struct f_inst *child2 = f2;
#line 1257
do {
#line 1257
  what->size += child2->size;
#line 1257

#line 1257
  if (child2->fi_code != FI_CONSTANT)
#line 1257
    constargs = 0;
#line 1257

#line 1257
} while (child2 = child2->next);
#line 1257 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1257
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1257
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1259 "filter/f-inst.c"
what->type = T_PATH;

#line 1263 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1263
    if (!constargs)
#line 1263
      return what;
#line 1263

#line 1263
    /* Try to pre-calculate the result */
#line 1263
    #line 1255 "filter/f-inst.c"
 {	/* Path prepend */
    
#line 1256 "filter/f-inst.c"
 #line 1256 "filter/f-inst.c"
 ;
#line 1257 "filter/f-inst.c"
    
#line 1257 "filter/f-inst.c"
 #line 1257 "filter/f-inst.c"
 ;
#line 1258 "filter/f-inst.c"
    #line 1258 "filter/f-inst.c"
;
     
#line 1259 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_prepend(fpool, v1.val.ad, v2.val.i)  } );
  }

  /* Community list add */
  
  #undef whati
#line 1263 "filter/f-inst.c"
  }
#line 1263

#line 1263

#line 1270 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_PAIR */
#line 1270
struct f_inst *
#line 1264 "filter/f-inst.c"
NONNULL(2)
#line 1265 "filter/f-inst.c"
NONNULL(3)
#line 1270 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_PAIR(enum f_instruction_code fi_code
#line 1264 "filter/f-inst.c"
  , struct f_inst * f1
#line 1265 "filter/f-inst.c"
  , struct f_inst * f2
#line 1270 "filter/f-inst.c"
)
#line 1270
  {
#line 1270
    /* Allocate the structure */
#line 1270
    struct f_inst *what = fi_new(fi_code);
#line 1270
    uint constargs = 1;
#line 1270

#line 1270
    /* Initialize all the members */
#line 1270
  #define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1270
  #line 1264 "filter/f-inst.c"
whati->f1 = f1;
#line 1264
const struct f_inst *child1 = f1;
#line 1264
do {
#line 1264
  what->size += child1->size;
#line 1264

#line 1264
  if (child1->fi_code != FI_CONSTANT)
#line 1264
    constargs = 0;
#line 1264

#line 1264
} while (child1 = child1->next);
#line 1264

#line 1264 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1264
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1264
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1265 "filter/f-inst.c"
whati->f2 = f2;
#line 1265
const struct f_inst *child2 = f2;
#line 1265
do {
#line 1265
  what->size += child2->size;
#line 1265

#line 1265
  if (child2->fi_code != FI_CONSTANT)
#line 1265
    constargs = 0;
#line 1265

#line 1265
} while (child2 = child2->next);
#line 1265 "filter/f-inst.c"
if (f2->type && (f2->type != (T_PAIR)) && !f_const_promotion(f2, (T_PAIR)))
#line 1265
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1265
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f2->type));
#line 1267 "filter/f-inst.c"
what->type = T_CLIST;

#line 1270 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1270
    if (!constargs)
#line 1270
      return what;
#line 1270

#line 1270
    /* Try to pre-calculate the result */
#line 1270
    #line 1263 "filter/f-inst.c"
 {
    
#line 1264 "filter/f-inst.c"
 #line 1264 "filter/f-inst.c"
 ;
#line 1265 "filter/f-inst.c"
    
#line 1265 "filter/f-inst.c"
 #line 1265 "filter/f-inst.c"
 ;
#line 1266 "filter/f-inst.c"
    #line 1266 "filter/f-inst.c"
;
     
#line 1267 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1270 "filter/f-inst.c"
  }
#line 1270

#line 1270

#line 1284 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_IP */
#line 1284
struct f_inst *
#line 1271 "filter/f-inst.c"
NONNULL(2)
#line 1272 "filter/f-inst.c"
NONNULL(3)
#line 1284 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_IP(enum f_instruction_code fi_code
#line 1271 "filter/f-inst.c"
  , struct f_inst * f1
#line 1272 "filter/f-inst.c"
  , struct f_inst * f2
#line 1284 "filter/f-inst.c"
)
#line 1284
  {
#line 1284
    /* Allocate the structure */
#line 1284
    struct f_inst *what = fi_new(fi_code);
#line 1284
    uint constargs = 1;
#line 1284

#line 1284
    /* Initialize all the members */
#line 1284
  #define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1284
  #line 1271 "filter/f-inst.c"
whati->f1 = f1;
#line 1271
const struct f_inst *child1 = f1;
#line 1271
do {
#line 1271
  what->size += child1->size;
#line 1271

#line 1271
  if (child1->fi_code != FI_CONSTANT)
#line 1271
    constargs = 0;
#line 1271

#line 1271
} while (child1 = child1->next);
#line 1271

#line 1271 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1271
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1271
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1272 "filter/f-inst.c"
whati->f2 = f2;
#line 1272
const struct f_inst *child2 = f2;
#line 1272
do {
#line 1272
  what->size += child2->size;
#line 1272

#line 1272
  if (child2->fi_code != FI_CONSTANT)
#line 1272
    constargs = 0;
#line 1272

#line 1272
} while (child2 = child2->next);
#line 1272 "filter/f-inst.c"
if (f2->type && (f2->type != (T_IP)) && !f_const_promotion(f2, (T_IP)))
#line 1272
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1272
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f2->type));
;
#line 1276 "filter/f-inst.c"
    /* IP->Quad implicit conversion, must be before FI_CLIST_ADD_QUAD */
    cf_warn("Method add(clist, ip) is deprecated, please use add(clist, quad)");

    #line 1281 "filter/f-inst.c"
what->type = T_CLIST;

#line 1284 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1284
    if (!constargs)
#line 1284
      return what;
#line 1284

#line 1284
    /* Try to pre-calculate the result */
#line 1284
    #line 1270 "filter/f-inst.c"
 {
    
#line 1271 "filter/f-inst.c"
 #line 1271 "filter/f-inst.c"
 ;
#line 1272 "filter/f-inst.c"
    
#line 1272 "filter/f-inst.c"
 #line 1272 "filter/f-inst.c"
 ;
#line 1273 "filter/f-inst.c"
    #line 1273 "filter/f-inst.c"
;

    ;
#line 1280 "filter/f-inst.c"
    if (!val_is_ip4(&v2)) runtime("Mismatched IP type");
     
#line 1281 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, ipa_to_u32(v2.val.ip))  } );
  }

  
  #undef whati
#line 1284 "filter/f-inst.c"
  }
#line 1284

#line 1284

#line 1291 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_QUAD */
#line 1291
struct f_inst *
#line 1285 "filter/f-inst.c"
NONNULL(2)
#line 1286 "filter/f-inst.c"
NONNULL(3)
#line 1291 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_QUAD(enum f_instruction_code fi_code
#line 1285 "filter/f-inst.c"
  , struct f_inst * f1
#line 1286 "filter/f-inst.c"
  , struct f_inst * f2
#line 1291 "filter/f-inst.c"
)
#line 1291
  {
#line 1291
    /* Allocate the structure */
#line 1291
    struct f_inst *what = fi_new(fi_code);
#line 1291
    uint constargs = 1;
#line 1291

#line 1291
    /* Initialize all the members */
#line 1291
  #define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1291
  #line 1285 "filter/f-inst.c"
whati->f1 = f1;
#line 1285
const struct f_inst *child1 = f1;
#line 1285
do {
#line 1285
  what->size += child1->size;
#line 1285

#line 1285
  if (child1->fi_code != FI_CONSTANT)
#line 1285
    constargs = 0;
#line 1285

#line 1285
} while (child1 = child1->next);
#line 1285

#line 1285 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1285
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1285
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1286 "filter/f-inst.c"
whati->f2 = f2;
#line 1286
const struct f_inst *child2 = f2;
#line 1286
do {
#line 1286
  what->size += child2->size;
#line 1286

#line 1286
  if (child2->fi_code != FI_CONSTANT)
#line 1286
    constargs = 0;
#line 1286

#line 1286
} while (child2 = child2->next);
#line 1286 "filter/f-inst.c"
if (f2->type && (f2->type != (T_QUAD)) && !f_const_promotion(f2, (T_QUAD)))
#line 1286
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1286
	   f_instruction_name(what->fi_code), f_type_name(T_QUAD), f_type_name(f2->type));
#line 1288 "filter/f-inst.c"
what->type = T_CLIST;

#line 1291 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1291
    if (!constargs)
#line 1291
      return what;
#line 1291

#line 1291
    /* Try to pre-calculate the result */
#line 1291
    #line 1284 "filter/f-inst.c"
 {
    
#line 1285 "filter/f-inst.c"
 #line 1285 "filter/f-inst.c"
 ;
#line 1286 "filter/f-inst.c"
    
#line 1286 "filter/f-inst.c"
 #line 1286 "filter/f-inst.c"
 ;
#line 1287 "filter/f-inst.c"
    #line 1287 "filter/f-inst.c"
;
     
#line 1288 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1291 "filter/f-inst.c"
  }
#line 1291

#line 1291

#line 1298 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_CLIST */
#line 1298
struct f_inst *
#line 1292 "filter/f-inst.c"
NONNULL(2)
#line 1293 "filter/f-inst.c"
NONNULL(3)
#line 1298 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_CLIST(enum f_instruction_code fi_code
#line 1292 "filter/f-inst.c"
  , struct f_inst * f1
#line 1293 "filter/f-inst.c"
  , struct f_inst * f2
#line 1298 "filter/f-inst.c"
)
#line 1298
  {
#line 1298
    /* Allocate the structure */
#line 1298
    struct f_inst *what = fi_new(fi_code);
#line 1298
    uint constargs = 1;
#line 1298

#line 1298
    /* Initialize all the members */
#line 1298
  #define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1298
  #line 1292 "filter/f-inst.c"
whati->f1 = f1;
#line 1292
const struct f_inst *child1 = f1;
#line 1292
do {
#line 1292
  what->size += child1->size;
#line 1292

#line 1292
  if (child1->fi_code != FI_CONSTANT)
#line 1292
    constargs = 0;
#line 1292

#line 1292
} while (child1 = child1->next);
#line 1292

#line 1292 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1292
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1292
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1293 "filter/f-inst.c"
whati->f2 = f2;
#line 1293
const struct f_inst *child2 = f2;
#line 1293
do {
#line 1293
  what->size += child2->size;
#line 1293

#line 1293
  if (child2->fi_code != FI_CONSTANT)
#line 1293
    constargs = 0;
#line 1293

#line 1293
} while (child2 = child2->next);
#line 1293 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1293
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1293
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1295 "filter/f-inst.c"
what->type = T_CLIST;

#line 1298 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1298
    if (!constargs)
#line 1298
      return what;
#line 1298

#line 1298
    /* Try to pre-calculate the result */
#line 1298
    #line 1291 "filter/f-inst.c"
 {
    
#line 1292 "filter/f-inst.c"
 #line 1292 "filter/f-inst.c"
 ;
#line 1293 "filter/f-inst.c"
    
#line 1293 "filter/f-inst.c"
 #line 1293 "filter/f-inst.c"
 ;
#line 1294 "filter/f-inst.c"
    #line 1294 "filter/f-inst.c"
;
     
#line 1295 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1298 "filter/f-inst.c"
  }
#line 1298

#line 1298

#line 1305 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_ADD_EC */
#line 1305
struct f_inst *
#line 1299 "filter/f-inst.c"
NONNULL(2)
#line 1300 "filter/f-inst.c"
NONNULL(3)
#line 1305 "filter/f-inst.c"
f_new_inst_FI_ECLIST_ADD_EC(enum f_instruction_code fi_code
#line 1299 "filter/f-inst.c"
  , struct f_inst * f1
#line 1300 "filter/f-inst.c"
  , struct f_inst * f2
#line 1305 "filter/f-inst.c"
)
#line 1305
  {
#line 1305
    /* Allocate the structure */
#line 1305
    struct f_inst *what = fi_new(fi_code);
#line 1305
    uint constargs = 1;
#line 1305

#line 1305
    /* Initialize all the members */
#line 1305
  #define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1305
  #line 1299 "filter/f-inst.c"
whati->f1 = f1;
#line 1299
const struct f_inst *child1 = f1;
#line 1299
do {
#line 1299
  what->size += child1->size;
#line 1299

#line 1299
  if (child1->fi_code != FI_CONSTANT)
#line 1299
    constargs = 0;
#line 1299

#line 1299
} while (child1 = child1->next);
#line 1299

#line 1299 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1299
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1299
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1300 "filter/f-inst.c"
whati->f2 = f2;
#line 1300
const struct f_inst *child2 = f2;
#line 1300
do {
#line 1300
  what->size += child2->size;
#line 1300

#line 1300
  if (child2->fi_code != FI_CONSTANT)
#line 1300
    constargs = 0;
#line 1300

#line 1300
} while (child2 = child2->next);
#line 1300 "filter/f-inst.c"
if (f2->type && (f2->type != (T_EC)) && !f_const_promotion(f2, (T_EC)))
#line 1300
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1300
	   f_instruction_name(what->fi_code), f_type_name(T_EC), f_type_name(f2->type));
#line 1302 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1305 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1305
    if (!constargs)
#line 1305
      return what;
#line 1305

#line 1305
    /* Try to pre-calculate the result */
#line 1305
    #line 1298 "filter/f-inst.c"
 {
    
#line 1299 "filter/f-inst.c"
 #line 1299 "filter/f-inst.c"
 ;
#line 1300 "filter/f-inst.c"
    
#line 1300 "filter/f-inst.c"
 #line 1300 "filter/f-inst.c"
 ;
#line 1301 "filter/f-inst.c"
    #line 1301 "filter/f-inst.c"
;
     
#line 1302 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_add(fpool, v1.val.ad, v2.val.ec)  } );
  }

  
  #undef whati
#line 1305 "filter/f-inst.c"
  }
#line 1305

#line 1305

#line 1312 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_ADD_ECLIST */
#line 1312
struct f_inst *
#line 1306 "filter/f-inst.c"
NONNULL(2)
#line 1307 "filter/f-inst.c"
NONNULL(3)
#line 1312 "filter/f-inst.c"
f_new_inst_FI_ECLIST_ADD_ECLIST(enum f_instruction_code fi_code
#line 1306 "filter/f-inst.c"
  , struct f_inst * f1
#line 1307 "filter/f-inst.c"
  , struct f_inst * f2
#line 1312 "filter/f-inst.c"
)
#line 1312
  {
#line 1312
    /* Allocate the structure */
#line 1312
    struct f_inst *what = fi_new(fi_code);
#line 1312
    uint constargs = 1;
#line 1312

#line 1312
    /* Initialize all the members */
#line 1312
  #define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1312
  #line 1306 "filter/f-inst.c"
whati->f1 = f1;
#line 1306
const struct f_inst *child1 = f1;
#line 1306
do {
#line 1306
  what->size += child1->size;
#line 1306

#line 1306
  if (child1->fi_code != FI_CONSTANT)
#line 1306
    constargs = 0;
#line 1306

#line 1306
} while (child1 = child1->next);
#line 1306

#line 1306 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1306
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1306
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1307 "filter/f-inst.c"
whati->f2 = f2;
#line 1307
const struct f_inst *child2 = f2;
#line 1307
do {
#line 1307
  what->size += child2->size;
#line 1307

#line 1307
  if (child2->fi_code != FI_CONSTANT)
#line 1307
    constargs = 0;
#line 1307

#line 1307
} while (child2 = child2->next);
#line 1307 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1307
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1307
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1309 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1312 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1312
    if (!constargs)
#line 1312
      return what;
#line 1312

#line 1312
    /* Try to pre-calculate the result */
#line 1312
    #line 1305 "filter/f-inst.c"
 {
    
#line 1306 "filter/f-inst.c"
 #line 1306 "filter/f-inst.c"
 ;
#line 1307 "filter/f-inst.c"
    
#line 1307 "filter/f-inst.c"
 #line 1307 "filter/f-inst.c"
 ;
#line 1308 "filter/f-inst.c"
    #line 1308 "filter/f-inst.c"
;
     
#line 1309 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1312 "filter/f-inst.c"
  }
#line 1312

#line 1312

#line 1319 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_ADD_LC */
#line 1319
struct f_inst *
#line 1313 "filter/f-inst.c"
NONNULL(2)
#line 1314 "filter/f-inst.c"
NONNULL(3)
#line 1319 "filter/f-inst.c"
f_new_inst_FI_LCLIST_ADD_LC(enum f_instruction_code fi_code
#line 1313 "filter/f-inst.c"
  , struct f_inst * f1
#line 1314 "filter/f-inst.c"
  , struct f_inst * f2
#line 1319 "filter/f-inst.c"
)
#line 1319
  {
#line 1319
    /* Allocate the structure */
#line 1319
    struct f_inst *what = fi_new(fi_code);
#line 1319
    uint constargs = 1;
#line 1319

#line 1319
    /* Initialize all the members */
#line 1319
  #define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1319
  #line 1313 "filter/f-inst.c"
whati->f1 = f1;
#line 1313
const struct f_inst *child1 = f1;
#line 1313
do {
#line 1313
  what->size += child1->size;
#line 1313

#line 1313
  if (child1->fi_code != FI_CONSTANT)
#line 1313
    constargs = 0;
#line 1313

#line 1313
} while (child1 = child1->next);
#line 1313

#line 1313 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1313
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1313
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1314 "filter/f-inst.c"
whati->f2 = f2;
#line 1314
const struct f_inst *child2 = f2;
#line 1314
do {
#line 1314
  what->size += child2->size;
#line 1314

#line 1314
  if (child2->fi_code != FI_CONSTANT)
#line 1314
    constargs = 0;
#line 1314

#line 1314
} while (child2 = child2->next);
#line 1314 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LC)) && !f_const_promotion(f2, (T_LC)))
#line 1314
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1314
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f2->type));
#line 1316 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1319 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1319
    if (!constargs)
#line 1319
      return what;
#line 1319

#line 1319
    /* Try to pre-calculate the result */
#line 1319
    #line 1312 "filter/f-inst.c"
 {
    
#line 1313 "filter/f-inst.c"
 #line 1313 "filter/f-inst.c"
 ;
#line 1314 "filter/f-inst.c"
    
#line 1314 "filter/f-inst.c"
 #line 1314 "filter/f-inst.c"
 ;
#line 1315 "filter/f-inst.c"
    #line 1315 "filter/f-inst.c"
;
     
#line 1316 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_add(fpool, v1.val.ad, v2.val.lc)  } );
  }

  
  #undef whati
#line 1319 "filter/f-inst.c"
  }
#line 1319

#line 1319

#line 1326 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_ADD_LCLIST */
#line 1326
struct f_inst *
#line 1320 "filter/f-inst.c"
NONNULL(2)
#line 1321 "filter/f-inst.c"
NONNULL(3)
#line 1326 "filter/f-inst.c"
f_new_inst_FI_LCLIST_ADD_LCLIST(enum f_instruction_code fi_code
#line 1320 "filter/f-inst.c"
  , struct f_inst * f1
#line 1321 "filter/f-inst.c"
  , struct f_inst * f2
#line 1326 "filter/f-inst.c"
)
#line 1326
  {
#line 1326
    /* Allocate the structure */
#line 1326
    struct f_inst *what = fi_new(fi_code);
#line 1326
    uint constargs = 1;
#line 1326

#line 1326
    /* Initialize all the members */
#line 1326
  #define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1326
  #line 1320 "filter/f-inst.c"
whati->f1 = f1;
#line 1320
const struct f_inst *child1 = f1;
#line 1320
do {
#line 1320
  what->size += child1->size;
#line 1320

#line 1320
  if (child1->fi_code != FI_CONSTANT)
#line 1320
    constargs = 0;
#line 1320

#line 1320
} while (child1 = child1->next);
#line 1320

#line 1320 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1320
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1320
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1321 "filter/f-inst.c"
whati->f2 = f2;
#line 1321
const struct f_inst *child2 = f2;
#line 1321
do {
#line 1321
  what->size += child2->size;
#line 1321

#line 1321
  if (child2->fi_code != FI_CONSTANT)
#line 1321
    constargs = 0;
#line 1321

#line 1321
} while (child2 = child2->next);
#line 1321 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1321
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1321
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1323 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1326 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1326
    if (!constargs)
#line 1326
      return what;
#line 1326

#line 1326
    /* Try to pre-calculate the result */
#line 1326
    #line 1319 "filter/f-inst.c"
 {
    
#line 1320 "filter/f-inst.c"
 #line 1320 "filter/f-inst.c"
 ;
#line 1321 "filter/f-inst.c"
    
#line 1321 "filter/f-inst.c"
 #line 1321 "filter/f-inst.c"
 ;
#line 1322 "filter/f-inst.c"
    #line 1322 "filter/f-inst.c"
;
     
#line 1323 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1326 "filter/f-inst.c"
  }
#line 1326

#line 1326

#line 1333 "filter/f-inst.c"
 /* Constructor for FI_PATH_DELETE_INT */
#line 1333
struct f_inst *
#line 1327 "filter/f-inst.c"
NONNULL(2)
#line 1328 "filter/f-inst.c"
NONNULL(3)
#line 1333 "filter/f-inst.c"
f_new_inst_FI_PATH_DELETE_INT(enum f_instruction_code fi_code
#line 1327 "filter/f-inst.c"
  , struct f_inst * f1
#line 1328 "filter/f-inst.c"
  , struct f_inst * f2
#line 1333 "filter/f-inst.c"
)
#line 1333
  {
#line 1333
    /* Allocate the structure */
#line 1333
    struct f_inst *what = fi_new(fi_code);
#line 1333
    uint constargs = 1;
#line 1333

#line 1333
    /* Initialize all the members */
#line 1333
  #define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1333
  #line 1327 "filter/f-inst.c"
whati->f1 = f1;
#line 1327
const struct f_inst *child1 = f1;
#line 1327
do {
#line 1327
  what->size += child1->size;
#line 1327

#line 1327
  if (child1->fi_code != FI_CONSTANT)
#line 1327
    constargs = 0;
#line 1327

#line 1327
} while (child1 = child1->next);
#line 1327

#line 1327 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1327
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1327
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1328 "filter/f-inst.c"
whati->f2 = f2;
#line 1328
const struct f_inst *child2 = f2;
#line 1328
do {
#line 1328
  what->size += child2->size;
#line 1328

#line 1328
  if (child2->fi_code != FI_CONSTANT)
#line 1328
    constargs = 0;
#line 1328

#line 1328
} while (child2 = child2->next);
#line 1328 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1328
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1328
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1330 "filter/f-inst.c"
what->type = T_PATH;

#line 1333 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1333
    if (!constargs)
#line 1333
      return what;
#line 1333

#line 1333
    /* Try to pre-calculate the result */
#line 1333
    #line 1326 "filter/f-inst.c"
 {
    
#line 1327 "filter/f-inst.c"
 #line 1327 "filter/f-inst.c"
 ;
#line 1328 "filter/f-inst.c"
    
#line 1328 "filter/f-inst.c"
 #line 1328 "filter/f-inst.c"
 ;
#line 1329 "filter/f-inst.c"
    #line 1329 "filter/f-inst.c"
;
     
#line 1330 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1333 "filter/f-inst.c"
  }
#line 1333

#line 1333

#line 1345 "filter/f-inst.c"
 /* Constructor for FI_PATH_DELETE_SET */
#line 1345
struct f_inst *
#line 1334 "filter/f-inst.c"
NONNULL(2)
#line 1335 "filter/f-inst.c"
NONNULL(3)
#line 1345 "filter/f-inst.c"
f_new_inst_FI_PATH_DELETE_SET(enum f_instruction_code fi_code
#line 1334 "filter/f-inst.c"
  , struct f_inst * f1
#line 1335 "filter/f-inst.c"
  , struct f_inst * f2
#line 1345 "filter/f-inst.c"
)
#line 1345
  {
#line 1345
    /* Allocate the structure */
#line 1345
    struct f_inst *what = fi_new(fi_code);
#line 1345
    uint constargs = 1;
#line 1345

#line 1345
    /* Initialize all the members */
#line 1345
  #define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1345
  #line 1334 "filter/f-inst.c"
whati->f1 = f1;
#line 1334
const struct f_inst *child1 = f1;
#line 1334
do {
#line 1334
  what->size += child1->size;
#line 1334

#line 1334
  if (child1->fi_code != FI_CONSTANT)
#line 1334
    constargs = 0;
#line 1334

#line 1334
} while (child1 = child1->next);
#line 1334

#line 1334 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1334
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1334
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1335 "filter/f-inst.c"
whati->f2 = f2;
#line 1335
const struct f_inst *child2 = f2;
#line 1335
do {
#line 1335
  what->size += child2->size;
#line 1335

#line 1335
  if (child2->fi_code != FI_CONSTANT)
#line 1335
    constargs = 0;
#line 1335

#line 1335
} while (child2 = child2->next);
#line 1335 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1335
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1335
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1341 "filter/f-inst.c"
what->type = T_PATH;

#line 1345 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1345
    if (!constargs)
#line 1345
      return what;
#line 1345

#line 1345
    /* Try to pre-calculate the result */
#line 1345
    #line 1333 "filter/f-inst.c"
 {
    
#line 1334 "filter/f-inst.c"
 #line 1334 "filter/f-inst.c"
 ;
#line 1335 "filter/f-inst.c"
    
#line 1335 "filter/f-inst.c"
 #line 1335 "filter/f-inst.c"
 ;
#line 1336 "filter/f-inst.c"
    #line 1336 "filter/f-inst.c"
;

    if (!path_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1341 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  /* Community list delete */
  
  #undef whati
#line 1345 "filter/f-inst.c"
  }
#line 1345

#line 1345

#line 1352 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_PAIR */
#line 1352
struct f_inst *
#line 1346 "filter/f-inst.c"
NONNULL(2)
#line 1347 "filter/f-inst.c"
NONNULL(3)
#line 1352 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_PAIR(enum f_instruction_code fi_code
#line 1346 "filter/f-inst.c"
  , struct f_inst * f1
#line 1347 "filter/f-inst.c"
  , struct f_inst * f2
#line 1352 "filter/f-inst.c"
)
#line 1352
  {
#line 1352
    /* Allocate the structure */
#line 1352
    struct f_inst *what = fi_new(fi_code);
#line 1352
    uint constargs = 1;
#line 1352

#line 1352
    /* Initialize all the members */
#line 1352
  #define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1352
  #line 1346 "filter/f-inst.c"
whati->f1 = f1;
#line 1346
const struct f_inst *child1 = f1;
#line 1346
do {
#line 1346
  what->size += child1->size;
#line 1346

#line 1346
  if (child1->fi_code != FI_CONSTANT)
#line 1346
    constargs = 0;
#line 1346

#line 1346
} while (child1 = child1->next);
#line 1346

#line 1346 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1346
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1346
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1347 "filter/f-inst.c"
whati->f2 = f2;
#line 1347
const struct f_inst *child2 = f2;
#line 1347
do {
#line 1347
  what->size += child2->size;
#line 1347

#line 1347
  if (child2->fi_code != FI_CONSTANT)
#line 1347
    constargs = 0;
#line 1347

#line 1347
} while (child2 = child2->next);
#line 1347 "filter/f-inst.c"
if (f2->type && (f2->type != (T_PAIR)) && !f_const_promotion(f2, (T_PAIR)))
#line 1347
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1347
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f2->type));
#line 1349 "filter/f-inst.c"
what->type = T_CLIST;

#line 1352 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1352
    if (!constargs)
#line 1352
      return what;
#line 1352

#line 1352
    /* Try to pre-calculate the result */
#line 1352
    #line 1345 "filter/f-inst.c"
 {
    
#line 1346 "filter/f-inst.c"
 #line 1346 "filter/f-inst.c"
 ;
#line 1347 "filter/f-inst.c"
    
#line 1347 "filter/f-inst.c"
 #line 1347 "filter/f-inst.c"
 ;
#line 1348 "filter/f-inst.c"
    #line 1348 "filter/f-inst.c"
;
     
#line 1349 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1352 "filter/f-inst.c"
  }
#line 1352

#line 1352

#line 1366 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_IP */
#line 1366
struct f_inst *
#line 1353 "filter/f-inst.c"
NONNULL(2)
#line 1354 "filter/f-inst.c"
NONNULL(3)
#line 1366 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_IP(enum f_instruction_code fi_code
#line 1353 "filter/f-inst.c"
  , struct f_inst * f1
#line 1354 "filter/f-inst.c"
  , struct f_inst * f2
#line 1366 "filter/f-inst.c"
)
#line 1366
  {
#line 1366
    /* Allocate the structure */
#line 1366
    struct f_inst *what = fi_new(fi_code);
#line 1366
    uint constargs = 1;
#line 1366

#line 1366
    /* Initialize all the members */
#line 1366
  #define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1366
  #line 1353 "filter/f-inst.c"
whati->f1 = f1;
#line 1353
const struct f_inst *child1 = f1;
#line 1353
do {
#line 1353
  what->size += child1->size;
#line 1353

#line 1353
  if (child1->fi_code != FI_CONSTANT)
#line 1353
    constargs = 0;
#line 1353

#line 1353
} while (child1 = child1->next);
#line 1353

#line 1353 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1353
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1353
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1354 "filter/f-inst.c"
whati->f2 = f2;
#line 1354
const struct f_inst *child2 = f2;
#line 1354
do {
#line 1354
  what->size += child2->size;
#line 1354

#line 1354
  if (child2->fi_code != FI_CONSTANT)
#line 1354
    constargs = 0;
#line 1354

#line 1354
} while (child2 = child2->next);
#line 1354 "filter/f-inst.c"
if (f2->type && (f2->type != (T_IP)) && !f_const_promotion(f2, (T_IP)))
#line 1354
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1354
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f2->type));
;
#line 1358 "filter/f-inst.c"
    /* IP->Quad implicit conversion, must be before FI_CLIST_DELETE_QUAD */
    cf_warn("Method delete(clist, ip) is deprecated, please use delete(clist, quad)");

    #line 1363 "filter/f-inst.c"
what->type = T_CLIST;

#line 1366 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1366
    if (!constargs)
#line 1366
      return what;
#line 1366

#line 1366
    /* Try to pre-calculate the result */
#line 1366
    #line 1352 "filter/f-inst.c"
 {
    
#line 1353 "filter/f-inst.c"
 #line 1353 "filter/f-inst.c"
 ;
#line 1354 "filter/f-inst.c"
    
#line 1354 "filter/f-inst.c"
 #line 1354 "filter/f-inst.c"
 ;
#line 1355 "filter/f-inst.c"
    #line 1355 "filter/f-inst.c"
;

    ;
#line 1362 "filter/f-inst.c"
    if (!val_is_ip4(&v2)) runtime("Mismatched IP type");
     
#line 1363 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, ipa_to_u32(v2.val.ip))  } );
  }

  
  #undef whati
#line 1366 "filter/f-inst.c"
  }
#line 1366

#line 1366

#line 1373 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_QUAD */
#line 1373
struct f_inst *
#line 1367 "filter/f-inst.c"
NONNULL(2)
#line 1368 "filter/f-inst.c"
NONNULL(3)
#line 1373 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_QUAD(enum f_instruction_code fi_code
#line 1367 "filter/f-inst.c"
  , struct f_inst * f1
#line 1368 "filter/f-inst.c"
  , struct f_inst * f2
#line 1373 "filter/f-inst.c"
)
#line 1373
  {
#line 1373
    /* Allocate the structure */
#line 1373
    struct f_inst *what = fi_new(fi_code);
#line 1373
    uint constargs = 1;
#line 1373

#line 1373
    /* Initialize all the members */
#line 1373
  #define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1373
  #line 1367 "filter/f-inst.c"
whati->f1 = f1;
#line 1367
const struct f_inst *child1 = f1;
#line 1367
do {
#line 1367
  what->size += child1->size;
#line 1367

#line 1367
  if (child1->fi_code != FI_CONSTANT)
#line 1367
    constargs = 0;
#line 1367

#line 1367
} while (child1 = child1->next);
#line 1367

#line 1367 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1367
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1367
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1368 "filter/f-inst.c"
whati->f2 = f2;
#line 1368
const struct f_inst *child2 = f2;
#line 1368
do {
#line 1368
  what->size += child2->size;
#line 1368

#line 1368
  if (child2->fi_code != FI_CONSTANT)
#line 1368
    constargs = 0;
#line 1368

#line 1368
} while (child2 = child2->next);
#line 1368 "filter/f-inst.c"
if (f2->type && (f2->type != (T_QUAD)) && !f_const_promotion(f2, (T_QUAD)))
#line 1368
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1368
	   f_instruction_name(what->fi_code), f_type_name(T_QUAD), f_type_name(f2->type));
#line 1370 "filter/f-inst.c"
what->type = T_CLIST;

#line 1373 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1373
    if (!constargs)
#line 1373
      return what;
#line 1373

#line 1373
    /* Try to pre-calculate the result */
#line 1373
    #line 1366 "filter/f-inst.c"
 {
    
#line 1367 "filter/f-inst.c"
 #line 1367 "filter/f-inst.c"
 ;
#line 1368 "filter/f-inst.c"
    
#line 1368 "filter/f-inst.c"
 #line 1368 "filter/f-inst.c"
 ;
#line 1369 "filter/f-inst.c"
    #line 1369 "filter/f-inst.c"
;
     
#line 1370 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1373 "filter/f-inst.c"
  }
#line 1373

#line 1373

#line 1380 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_CLIST */
#line 1380
struct f_inst *
#line 1374 "filter/f-inst.c"
NONNULL(2)
#line 1375 "filter/f-inst.c"
NONNULL(3)
#line 1380 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_CLIST(enum f_instruction_code fi_code
#line 1374 "filter/f-inst.c"
  , struct f_inst * f1
#line 1375 "filter/f-inst.c"
  , struct f_inst * f2
#line 1380 "filter/f-inst.c"
)
#line 1380
  {
#line 1380
    /* Allocate the structure */
#line 1380
    struct f_inst *what = fi_new(fi_code);
#line 1380
    uint constargs = 1;
#line 1380

#line 1380
    /* Initialize all the members */
#line 1380
  #define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1380
  #line 1374 "filter/f-inst.c"
whati->f1 = f1;
#line 1374
const struct f_inst *child1 = f1;
#line 1374
do {
#line 1374
  what->size += child1->size;
#line 1374

#line 1374
  if (child1->fi_code != FI_CONSTANT)
#line 1374
    constargs = 0;
#line 1374

#line 1374
} while (child1 = child1->next);
#line 1374

#line 1374 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1374
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1374
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1375 "filter/f-inst.c"
whati->f2 = f2;
#line 1375
const struct f_inst *child2 = f2;
#line 1375
do {
#line 1375
  what->size += child2->size;
#line 1375

#line 1375
  if (child2->fi_code != FI_CONSTANT)
#line 1375
    constargs = 0;
#line 1375

#line 1375
} while (child2 = child2->next);
#line 1375 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1375
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1375
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1377 "filter/f-inst.c"
what->type = T_CLIST;

#line 1380 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1380
    if (!constargs)
#line 1380
      return what;
#line 1380

#line 1380
    /* Try to pre-calculate the result */
#line 1380
    #line 1373 "filter/f-inst.c"
 {
    
#line 1374 "filter/f-inst.c"
 #line 1374 "filter/f-inst.c"
 ;
#line 1375 "filter/f-inst.c"
    
#line 1375 "filter/f-inst.c"
 #line 1375 "filter/f-inst.c"
 ;
#line 1376 "filter/f-inst.c"
    #line 1376 "filter/f-inst.c"
;
     
#line 1377 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1380 "filter/f-inst.c"
  }
#line 1380

#line 1380

#line 1391 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_SET */
#line 1391
struct f_inst *
#line 1381 "filter/f-inst.c"
NONNULL(2)
#line 1382 "filter/f-inst.c"
NONNULL(3)
#line 1391 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1381 "filter/f-inst.c"
  , struct f_inst * f1
#line 1382 "filter/f-inst.c"
  , struct f_inst * f2
#line 1391 "filter/f-inst.c"
)
#line 1391
  {
#line 1391
    /* Allocate the structure */
#line 1391
    struct f_inst *what = fi_new(fi_code);
#line 1391
    uint constargs = 1;
#line 1391

#line 1391
    /* Initialize all the members */
#line 1391
  #define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1391
  #line 1381 "filter/f-inst.c"
whati->f1 = f1;
#line 1381
const struct f_inst *child1 = f1;
#line 1381
do {
#line 1381
  what->size += child1->size;
#line 1381

#line 1381
  if (child1->fi_code != FI_CONSTANT)
#line 1381
    constargs = 0;
#line 1381

#line 1381
} while (child1 = child1->next);
#line 1381

#line 1381 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1381
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1381
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1382 "filter/f-inst.c"
whati->f2 = f2;
#line 1382
const struct f_inst *child2 = f2;
#line 1382
do {
#line 1382
  what->size += child2->size;
#line 1382

#line 1382
  if (child2->fi_code != FI_CONSTANT)
#line 1382
    constargs = 0;
#line 1382

#line 1382
} while (child2 = child2->next);
#line 1382 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1382
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1382
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1388 "filter/f-inst.c"
what->type = T_CLIST;

#line 1391 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1391
    if (!constargs)
#line 1391
      return what;
#line 1391

#line 1391
    /* Try to pre-calculate the result */
#line 1391
    #line 1380 "filter/f-inst.c"
 {
    
#line 1381 "filter/f-inst.c"
 #line 1381 "filter/f-inst.c"
 ;
#line 1382 "filter/f-inst.c"
    
#line 1382 "filter/f-inst.c"
 #line 1382 "filter/f-inst.c"
 ;
#line 1383 "filter/f-inst.c"
    #line 1383 "filter/f-inst.c"
;

    if (!clist_set_type(v2.val.t, &(struct f_val){}))
      runtime("Mismatched set type");

     
#line 1388 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1391 "filter/f-inst.c"
  }
#line 1391

#line 1391

#line 1398 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_EC */
#line 1398
struct f_inst *
#line 1392 "filter/f-inst.c"
NONNULL(2)
#line 1393 "filter/f-inst.c"
NONNULL(3)
#line 1398 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_EC(enum f_instruction_code fi_code
#line 1392 "filter/f-inst.c"
  , struct f_inst * f1
#line 1393 "filter/f-inst.c"
  , struct f_inst * f2
#line 1398 "filter/f-inst.c"
)
#line 1398
  {
#line 1398
    /* Allocate the structure */
#line 1398
    struct f_inst *what = fi_new(fi_code);
#line 1398
    uint constargs = 1;
#line 1398

#line 1398
    /* Initialize all the members */
#line 1398
  #define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1398
  #line 1392 "filter/f-inst.c"
whati->f1 = f1;
#line 1392
const struct f_inst *child1 = f1;
#line 1392
do {
#line 1392
  what->size += child1->size;
#line 1392

#line 1392
  if (child1->fi_code != FI_CONSTANT)
#line 1392
    constargs = 0;
#line 1392

#line 1392
} while (child1 = child1->next);
#line 1392

#line 1392 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1392
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1392
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1393 "filter/f-inst.c"
whati->f2 = f2;
#line 1393
const struct f_inst *child2 = f2;
#line 1393
do {
#line 1393
  what->size += child2->size;
#line 1393

#line 1393
  if (child2->fi_code != FI_CONSTANT)
#line 1393
    constargs = 0;
#line 1393

#line 1393
} while (child2 = child2->next);
#line 1393 "filter/f-inst.c"
if (f2->type && (f2->type != (T_EC)) && !f_const_promotion(f2, (T_EC)))
#line 1393
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1393
	   f_instruction_name(what->fi_code), f_type_name(T_EC), f_type_name(f2->type));
#line 1395 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1398 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1398
    if (!constargs)
#line 1398
      return what;
#line 1398

#line 1398
    /* Try to pre-calculate the result */
#line 1398
    #line 1391 "filter/f-inst.c"
 {
    
#line 1392 "filter/f-inst.c"
 #line 1392 "filter/f-inst.c"
 ;
#line 1393 "filter/f-inst.c"
    
#line 1393 "filter/f-inst.c"
 #line 1393 "filter/f-inst.c"
 ;
#line 1394 "filter/f-inst.c"
    #line 1394 "filter/f-inst.c"
;
     
#line 1395 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_del(fpool, v1.val.ad, v2.val.ec)  } );
  }

  
  #undef whati
#line 1398 "filter/f-inst.c"
  }
#line 1398

#line 1398

#line 1405 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_ECLIST */
#line 1405
struct f_inst *
#line 1399 "filter/f-inst.c"
NONNULL(2)
#line 1400 "filter/f-inst.c"
NONNULL(3)
#line 1405 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_ECLIST(enum f_instruction_code fi_code
#line 1399 "filter/f-inst.c"
  , struct f_inst * f1
#line 1400 "filter/f-inst.c"
  , struct f_inst * f2
#line 1405 "filter/f-inst.c"
)
#line 1405
  {
#line 1405
    /* Allocate the structure */
#line 1405
    struct f_inst *what = fi_new(fi_code);
#line 1405
    uint constargs = 1;
#line 1405

#line 1405
    /* Initialize all the members */
#line 1405
  #define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1405
  #line 1399 "filter/f-inst.c"
whati->f1 = f1;
#line 1399
const struct f_inst *child1 = f1;
#line 1399
do {
#line 1399
  what->size += child1->size;
#line 1399

#line 1399
  if (child1->fi_code != FI_CONSTANT)
#line 1399
    constargs = 0;
#line 1399

#line 1399
} while (child1 = child1->next);
#line 1399

#line 1399 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1399
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1399
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1400 "filter/f-inst.c"
whati->f2 = f2;
#line 1400
const struct f_inst *child2 = f2;
#line 1400
do {
#line 1400
  what->size += child2->size;
#line 1400

#line 1400
  if (child2->fi_code != FI_CONSTANT)
#line 1400
    constargs = 0;
#line 1400

#line 1400
} while (child2 = child2->next);
#line 1400 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1400
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1400
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1402 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1405 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1405
    if (!constargs)
#line 1405
      return what;
#line 1405

#line 1405
    /* Try to pre-calculate the result */
#line 1405
    #line 1398 "filter/f-inst.c"
 {
    
#line 1399 "filter/f-inst.c"
 #line 1399 "filter/f-inst.c"
 ;
#line 1400 "filter/f-inst.c"
    
#line 1400 "filter/f-inst.c"
 #line 1400 "filter/f-inst.c"
 ;
#line 1401 "filter/f-inst.c"
    #line 1401 "filter/f-inst.c"
;
     
#line 1402 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1405 "filter/f-inst.c"
  }
#line 1405

#line 1405

#line 1416 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_SET */
#line 1416
struct f_inst *
#line 1406 "filter/f-inst.c"
NONNULL(2)
#line 1407 "filter/f-inst.c"
NONNULL(3)
#line 1416 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1406 "filter/f-inst.c"
  , struct f_inst * f1
#line 1407 "filter/f-inst.c"
  , struct f_inst * f2
#line 1416 "filter/f-inst.c"
)
#line 1416
  {
#line 1416
    /* Allocate the structure */
#line 1416
    struct f_inst *what = fi_new(fi_code);
#line 1416
    uint constargs = 1;
#line 1416

#line 1416
    /* Initialize all the members */
#line 1416
  #define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1416
  #line 1406 "filter/f-inst.c"
whati->f1 = f1;
#line 1406
const struct f_inst *child1 = f1;
#line 1406
do {
#line 1406
  what->size += child1->size;
#line 1406

#line 1406
  if (child1->fi_code != FI_CONSTANT)
#line 1406
    constargs = 0;
#line 1406

#line 1406
} while (child1 = child1->next);
#line 1406

#line 1406 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1406
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1406
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1407 "filter/f-inst.c"
whati->f2 = f2;
#line 1407
const struct f_inst *child2 = f2;
#line 1407
do {
#line 1407
  what->size += child2->size;
#line 1407

#line 1407
  if (child2->fi_code != FI_CONSTANT)
#line 1407
    constargs = 0;
#line 1407

#line 1407
} while (child2 = child2->next);
#line 1407 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1407
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1407
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1413 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1416 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1416
    if (!constargs)
#line 1416
      return what;
#line 1416

#line 1416
    /* Try to pre-calculate the result */
#line 1416
    #line 1405 "filter/f-inst.c"
 {
    
#line 1406 "filter/f-inst.c"
 #line 1406 "filter/f-inst.c"
 ;
#line 1407 "filter/f-inst.c"
    
#line 1407 "filter/f-inst.c"
 #line 1407 "filter/f-inst.c"
 ;
#line 1408 "filter/f-inst.c"
    #line 1408 "filter/f-inst.c"
;

    if (!eclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1413 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1416 "filter/f-inst.c"
  }
#line 1416

#line 1416

#line 1423 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_LC */
#line 1423
struct f_inst *
#line 1417 "filter/f-inst.c"
NONNULL(2)
#line 1418 "filter/f-inst.c"
NONNULL(3)
#line 1423 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_LC(enum f_instruction_code fi_code
#line 1417 "filter/f-inst.c"
  , struct f_inst * f1
#line 1418 "filter/f-inst.c"
  , struct f_inst * f2
#line 1423 "filter/f-inst.c"
)
#line 1423
  {
#line 1423
    /* Allocate the structure */
#line 1423
    struct f_inst *what = fi_new(fi_code);
#line 1423
    uint constargs = 1;
#line 1423

#line 1423
    /* Initialize all the members */
#line 1423
  #define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1423
  #line 1417 "filter/f-inst.c"
whati->f1 = f1;
#line 1417
const struct f_inst *child1 = f1;
#line 1417
do {
#line 1417
  what->size += child1->size;
#line 1417

#line 1417
  if (child1->fi_code != FI_CONSTANT)
#line 1417
    constargs = 0;
#line 1417

#line 1417
} while (child1 = child1->next);
#line 1417

#line 1417 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1417
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1417
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1418 "filter/f-inst.c"
whati->f2 = f2;
#line 1418
const struct f_inst *child2 = f2;
#line 1418
do {
#line 1418
  what->size += child2->size;
#line 1418

#line 1418
  if (child2->fi_code != FI_CONSTANT)
#line 1418
    constargs = 0;
#line 1418

#line 1418
} while (child2 = child2->next);
#line 1418 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LC)) && !f_const_promotion(f2, (T_LC)))
#line 1418
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1418
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f2->type));
#line 1420 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1423 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1423
    if (!constargs)
#line 1423
      return what;
#line 1423

#line 1423
    /* Try to pre-calculate the result */
#line 1423
    #line 1416 "filter/f-inst.c"
 {
    
#line 1417 "filter/f-inst.c"
 #line 1417 "filter/f-inst.c"
 ;
#line 1418 "filter/f-inst.c"
    
#line 1418 "filter/f-inst.c"
 #line 1418 "filter/f-inst.c"
 ;
#line 1419 "filter/f-inst.c"
    #line 1419 "filter/f-inst.c"
;
     
#line 1420 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_del(fpool, v1.val.ad, v2.val.lc)  } );
  }

  
  #undef whati
#line 1423 "filter/f-inst.c"
  }
#line 1423

#line 1423

#line 1430 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_LCLIST */
#line 1430
struct f_inst *
#line 1424 "filter/f-inst.c"
NONNULL(2)
#line 1425 "filter/f-inst.c"
NONNULL(3)
#line 1430 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_LCLIST(enum f_instruction_code fi_code
#line 1424 "filter/f-inst.c"
  , struct f_inst * f1
#line 1425 "filter/f-inst.c"
  , struct f_inst * f2
#line 1430 "filter/f-inst.c"
)
#line 1430
  {
#line 1430
    /* Allocate the structure */
#line 1430
    struct f_inst *what = fi_new(fi_code);
#line 1430
    uint constargs = 1;
#line 1430

#line 1430
    /* Initialize all the members */
#line 1430
  #define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1430
  #line 1424 "filter/f-inst.c"
whati->f1 = f1;
#line 1424
const struct f_inst *child1 = f1;
#line 1424
do {
#line 1424
  what->size += child1->size;
#line 1424

#line 1424
  if (child1->fi_code != FI_CONSTANT)
#line 1424
    constargs = 0;
#line 1424

#line 1424
} while (child1 = child1->next);
#line 1424

#line 1424 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1424
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1424
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1425 "filter/f-inst.c"
whati->f2 = f2;
#line 1425
const struct f_inst *child2 = f2;
#line 1425
do {
#line 1425
  what->size += child2->size;
#line 1425

#line 1425
  if (child2->fi_code != FI_CONSTANT)
#line 1425
    constargs = 0;
#line 1425

#line 1425
} while (child2 = child2->next);
#line 1425 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1425
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1425
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1427 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1430 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1430
    if (!constargs)
#line 1430
      return what;
#line 1430

#line 1430
    /* Try to pre-calculate the result */
#line 1430
    #line 1423 "filter/f-inst.c"
 {
    
#line 1424 "filter/f-inst.c"
 #line 1424 "filter/f-inst.c"
 ;
#line 1425 "filter/f-inst.c"
    
#line 1425 "filter/f-inst.c"
 #line 1425 "filter/f-inst.c"
 ;
#line 1426 "filter/f-inst.c"
    #line 1426 "filter/f-inst.c"
;
     
#line 1427 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1430 "filter/f-inst.c"
  }
#line 1430

#line 1430

#line 1441 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_SET */
#line 1441
struct f_inst *
#line 1431 "filter/f-inst.c"
NONNULL(2)
#line 1432 "filter/f-inst.c"
NONNULL(3)
#line 1441 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1431 "filter/f-inst.c"
  , struct f_inst * f1
#line 1432 "filter/f-inst.c"
  , struct f_inst * f2
#line 1441 "filter/f-inst.c"
)
#line 1441
  {
#line 1441
    /* Allocate the structure */
#line 1441
    struct f_inst *what = fi_new(fi_code);
#line 1441
    uint constargs = 1;
#line 1441

#line 1441
    /* Initialize all the members */
#line 1441
  #define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1441
  #line 1431 "filter/f-inst.c"
whati->f1 = f1;
#line 1431
const struct f_inst *child1 = f1;
#line 1431
do {
#line 1431
  what->size += child1->size;
#line 1431

#line 1431
  if (child1->fi_code != FI_CONSTANT)
#line 1431
    constargs = 0;
#line 1431

#line 1431
} while (child1 = child1->next);
#line 1431

#line 1431 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1431
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1431
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1432 "filter/f-inst.c"
whati->f2 = f2;
#line 1432
const struct f_inst *child2 = f2;
#line 1432
do {
#line 1432
  what->size += child2->size;
#line 1432

#line 1432
  if (child2->fi_code != FI_CONSTANT)
#line 1432
    constargs = 0;
#line 1432

#line 1432
} while (child2 = child2->next);
#line 1432 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1432
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1432
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1438 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1441 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1441
    if (!constargs)
#line 1441
      return what;
#line 1441

#line 1441
    /* Try to pre-calculate the result */
#line 1441
    #line 1430 "filter/f-inst.c"
 {
    
#line 1431 "filter/f-inst.c"
 #line 1431 "filter/f-inst.c"
 ;
#line 1432 "filter/f-inst.c"
    
#line 1432 "filter/f-inst.c"
 #line 1432 "filter/f-inst.c"
 ;
#line 1433 "filter/f-inst.c"
    #line 1433 "filter/f-inst.c"
;

    if (!lclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1438 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1441 "filter/f-inst.c"
  }
#line 1441

#line 1441

#line 1452 "filter/f-inst.c"
 /* Constructor for FI_PATH_FILTER_SET */
#line 1452
struct f_inst *
#line 1442 "filter/f-inst.c"
NONNULL(2)
#line 1443 "filter/f-inst.c"
NONNULL(3)
#line 1452 "filter/f-inst.c"
f_new_inst_FI_PATH_FILTER_SET(enum f_instruction_code fi_code
#line 1442 "filter/f-inst.c"
  , struct f_inst * f1
#line 1443 "filter/f-inst.c"
  , struct f_inst * f2
#line 1452 "filter/f-inst.c"
)
#line 1452
  {
#line 1452
    /* Allocate the structure */
#line 1452
    struct f_inst *what = fi_new(fi_code);
#line 1452
    uint constargs = 1;
#line 1452

#line 1452
    /* Initialize all the members */
#line 1452
  #define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1452
  #line 1442 "filter/f-inst.c"
whati->f1 = f1;
#line 1442
const struct f_inst *child1 = f1;
#line 1442
do {
#line 1442
  what->size += child1->size;
#line 1442

#line 1442
  if (child1->fi_code != FI_CONSTANT)
#line 1442
    constargs = 0;
#line 1442

#line 1442
} while (child1 = child1->next);
#line 1442

#line 1442 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1442
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1442
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1443 "filter/f-inst.c"
whati->f2 = f2;
#line 1443
const struct f_inst *child2 = f2;
#line 1443
do {
#line 1443
  what->size += child2->size;
#line 1443

#line 1443
  if (child2->fi_code != FI_CONSTANT)
#line 1443
    constargs = 0;
#line 1443

#line 1443
} while (child2 = child2->next);
#line 1443 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1443
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1443
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1449 "filter/f-inst.c"
what->type = T_PATH;

#line 1452 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1452
    if (!constargs)
#line 1452
      return what;
#line 1452

#line 1452
    /* Try to pre-calculate the result */
#line 1452
    #line 1441 "filter/f-inst.c"
 {
    
#line 1442 "filter/f-inst.c"
 #line 1442 "filter/f-inst.c"
 ;
#line 1443 "filter/f-inst.c"
    
#line 1443 "filter/f-inst.c"
 #line 1443 "filter/f-inst.c"
 ;
#line 1444 "filter/f-inst.c"
    #line 1444 "filter/f-inst.c"
;

    if (!path_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1449 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1452 "filter/f-inst.c"
  }
#line 1452

#line 1452

#line 1459 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FILTER_CLIST */
#line 1459
struct f_inst *
#line 1453 "filter/f-inst.c"
NONNULL(2)
#line 1454 "filter/f-inst.c"
NONNULL(3)
#line 1459 "filter/f-inst.c"
f_new_inst_FI_CLIST_FILTER_CLIST(enum f_instruction_code fi_code
#line 1453 "filter/f-inst.c"
  , struct f_inst * f1
#line 1454 "filter/f-inst.c"
  , struct f_inst * f2
#line 1459 "filter/f-inst.c"
)
#line 1459
  {
#line 1459
    /* Allocate the structure */
#line 1459
    struct f_inst *what = fi_new(fi_code);
#line 1459
    uint constargs = 1;
#line 1459

#line 1459
    /* Initialize all the members */
#line 1459
  #define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1459
  #line 1453 "filter/f-inst.c"
whati->f1 = f1;
#line 1453
const struct f_inst *child1 = f1;
#line 1453
do {
#line 1453
  what->size += child1->size;
#line 1453

#line 1453
  if (child1->fi_code != FI_CONSTANT)
#line 1453
    constargs = 0;
#line 1453

#line 1453
} while (child1 = child1->next);
#line 1453

#line 1453 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1453
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1453
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1454 "filter/f-inst.c"
whati->f2 = f2;
#line 1454
const struct f_inst *child2 = f2;
#line 1454
do {
#line 1454
  what->size += child2->size;
#line 1454

#line 1454
  if (child2->fi_code != FI_CONSTANT)
#line 1454
    constargs = 0;
#line 1454

#line 1454
} while (child2 = child2->next);
#line 1454 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1454
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1454
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1456 "filter/f-inst.c"
what->type = T_CLIST;

#line 1459 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1459
    if (!constargs)
#line 1459
      return what;
#line 1459

#line 1459
    /* Try to pre-calculate the result */
#line 1459
    #line 1452 "filter/f-inst.c"
 {
    
#line 1453 "filter/f-inst.c"
 #line 1453 "filter/f-inst.c"
 ;
#line 1454 "filter/f-inst.c"
    
#line 1454 "filter/f-inst.c"
 #line 1454 "filter/f-inst.c"
 ;
#line 1455 "filter/f-inst.c"
    #line 1455 "filter/f-inst.c"
;
     
#line 1456 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1459 "filter/f-inst.c"
  }
#line 1459

#line 1459

#line 1470 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FILTER_SET */
#line 1470
struct f_inst *
#line 1460 "filter/f-inst.c"
NONNULL(2)
#line 1461 "filter/f-inst.c"
NONNULL(3)
#line 1470 "filter/f-inst.c"
f_new_inst_FI_CLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1460 "filter/f-inst.c"
  , struct f_inst * f1
#line 1461 "filter/f-inst.c"
  , struct f_inst * f2
#line 1470 "filter/f-inst.c"
)
#line 1470
  {
#line 1470
    /* Allocate the structure */
#line 1470
    struct f_inst *what = fi_new(fi_code);
#line 1470
    uint constargs = 1;
#line 1470

#line 1470
    /* Initialize all the members */
#line 1470
  #define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1470
  #line 1460 "filter/f-inst.c"
whati->f1 = f1;
#line 1460
const struct f_inst *child1 = f1;
#line 1460
do {
#line 1460
  what->size += child1->size;
#line 1460

#line 1460
  if (child1->fi_code != FI_CONSTANT)
#line 1460
    constargs = 0;
#line 1460

#line 1460
} while (child1 = child1->next);
#line 1460

#line 1460 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1460
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1460
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1461 "filter/f-inst.c"
whati->f2 = f2;
#line 1461
const struct f_inst *child2 = f2;
#line 1461
do {
#line 1461
  what->size += child2->size;
#line 1461

#line 1461
  if (child2->fi_code != FI_CONSTANT)
#line 1461
    constargs = 0;
#line 1461

#line 1461
} while (child2 = child2->next);
#line 1461 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1461
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1461
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1467 "filter/f-inst.c"
what->type = T_CLIST;

#line 1470 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1470
    if (!constargs)
#line 1470
      return what;
#line 1470

#line 1470
    /* Try to pre-calculate the result */
#line 1470
    #line 1459 "filter/f-inst.c"
 {
    
#line 1460 "filter/f-inst.c"
 #line 1460 "filter/f-inst.c"
 ;
#line 1461 "filter/f-inst.c"
    
#line 1461 "filter/f-inst.c"
 #line 1461 "filter/f-inst.c"
 ;
#line 1462 "filter/f-inst.c"
    #line 1462 "filter/f-inst.c"
;

    if (!clist_set_type(v2.val.t, &(struct f_val){}))
      runtime("Mismatched set type");

     
#line 1467 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1470 "filter/f-inst.c"
  }
#line 1470

#line 1470

#line 1477 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FILTER_ECLIST */
#line 1477
struct f_inst *
#line 1471 "filter/f-inst.c"
NONNULL(2)
#line 1472 "filter/f-inst.c"
NONNULL(3)
#line 1477 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FILTER_ECLIST(enum f_instruction_code fi_code
#line 1471 "filter/f-inst.c"
  , struct f_inst * f1
#line 1472 "filter/f-inst.c"
  , struct f_inst * f2
#line 1477 "filter/f-inst.c"
)
#line 1477
  {
#line 1477
    /* Allocate the structure */
#line 1477
    struct f_inst *what = fi_new(fi_code);
#line 1477
    uint constargs = 1;
#line 1477

#line 1477
    /* Initialize all the members */
#line 1477
  #define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1477
  #line 1471 "filter/f-inst.c"
whati->f1 = f1;
#line 1471
const struct f_inst *child1 = f1;
#line 1471
do {
#line 1471
  what->size += child1->size;
#line 1471

#line 1471
  if (child1->fi_code != FI_CONSTANT)
#line 1471
    constargs = 0;
#line 1471

#line 1471
} while (child1 = child1->next);
#line 1471

#line 1471 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1471
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1471
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1472 "filter/f-inst.c"
whati->f2 = f2;
#line 1472
const struct f_inst *child2 = f2;
#line 1472
do {
#line 1472
  what->size += child2->size;
#line 1472

#line 1472
  if (child2->fi_code != FI_CONSTANT)
#line 1472
    constargs = 0;
#line 1472

#line 1472
} while (child2 = child2->next);
#line 1472 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1472
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1472
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1474 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1477 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1477
    if (!constargs)
#line 1477
      return what;
#line 1477

#line 1477
    /* Try to pre-calculate the result */
#line 1477
    #line 1470 "filter/f-inst.c"
 {
    
#line 1471 "filter/f-inst.c"
 #line 1471 "filter/f-inst.c"
 ;
#line 1472 "filter/f-inst.c"
    
#line 1472 "filter/f-inst.c"
 #line 1472 "filter/f-inst.c"
 ;
#line 1473 "filter/f-inst.c"
    #line 1473 "filter/f-inst.c"
;
     
#line 1474 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1477 "filter/f-inst.c"
  }
#line 1477

#line 1477

#line 1488 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FILTER_SET */
#line 1488
struct f_inst *
#line 1478 "filter/f-inst.c"
NONNULL(2)
#line 1479 "filter/f-inst.c"
NONNULL(3)
#line 1488 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1478 "filter/f-inst.c"
  , struct f_inst * f1
#line 1479 "filter/f-inst.c"
  , struct f_inst * f2
#line 1488 "filter/f-inst.c"
)
#line 1488
  {
#line 1488
    /* Allocate the structure */
#line 1488
    struct f_inst *what = fi_new(fi_code);
#line 1488
    uint constargs = 1;
#line 1488

#line 1488
    /* Initialize all the members */
#line 1488
  #define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1488
  #line 1478 "filter/f-inst.c"
whati->f1 = f1;
#line 1478
const struct f_inst *child1 = f1;
#line 1478
do {
#line 1478
  what->size += child1->size;
#line 1478

#line 1478
  if (child1->fi_code != FI_CONSTANT)
#line 1478
    constargs = 0;
#line 1478

#line 1478
} while (child1 = child1->next);
#line 1478

#line 1478 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1478
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1478
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1479 "filter/f-inst.c"
whati->f2 = f2;
#line 1479
const struct f_inst *child2 = f2;
#line 1479
do {
#line 1479
  what->size += child2->size;
#line 1479

#line 1479
  if (child2->fi_code != FI_CONSTANT)
#line 1479
    constargs = 0;
#line 1479

#line 1479
} while (child2 = child2->next);
#line 1479 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1479
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1479
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1485 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1488 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1488
    if (!constargs)
#line 1488
      return what;
#line 1488

#line 1488
    /* Try to pre-calculate the result */
#line 1488
    #line 1477 "filter/f-inst.c"
 {
    
#line 1478 "filter/f-inst.c"
 #line 1478 "filter/f-inst.c"
 ;
#line 1479 "filter/f-inst.c"
    
#line 1479 "filter/f-inst.c"
 #line 1479 "filter/f-inst.c"
 ;
#line 1480 "filter/f-inst.c"
    #line 1480 "filter/f-inst.c"
;

    if (!eclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1485 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1488 "filter/f-inst.c"
  }
#line 1488

#line 1488

#line 1495 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FILTER_LCLIST */
#line 1495
struct f_inst *
#line 1489 "filter/f-inst.c"
NONNULL(2)
#line 1490 "filter/f-inst.c"
NONNULL(3)
#line 1495 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FILTER_LCLIST(enum f_instruction_code fi_code
#line 1489 "filter/f-inst.c"
  , struct f_inst * f1
#line 1490 "filter/f-inst.c"
  , struct f_inst * f2
#line 1495 "filter/f-inst.c"
)
#line 1495
  {
#line 1495
    /* Allocate the structure */
#line 1495
    struct f_inst *what = fi_new(fi_code);
#line 1495
    uint constargs = 1;
#line 1495

#line 1495
    /* Initialize all the members */
#line 1495
  #define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1495
  #line 1489 "filter/f-inst.c"
whati->f1 = f1;
#line 1489
const struct f_inst *child1 = f1;
#line 1489
do {
#line 1489
  what->size += child1->size;
#line 1489

#line 1489
  if (child1->fi_code != FI_CONSTANT)
#line 1489
    constargs = 0;
#line 1489

#line 1489
} while (child1 = child1->next);
#line 1489

#line 1489 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1489
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1489
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1490 "filter/f-inst.c"
whati->f2 = f2;
#line 1490
const struct f_inst *child2 = f2;
#line 1490
do {
#line 1490
  what->size += child2->size;
#line 1490

#line 1490
  if (child2->fi_code != FI_CONSTANT)
#line 1490
    constargs = 0;
#line 1490

#line 1490
} while (child2 = child2->next);
#line 1490 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1490
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1490
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1492 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1495 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1495
    if (!constargs)
#line 1495
      return what;
#line 1495

#line 1495
    /* Try to pre-calculate the result */
#line 1495
    #line 1488 "filter/f-inst.c"
 {
    
#line 1489 "filter/f-inst.c"
 #line 1489 "filter/f-inst.c"
 ;
#line 1490 "filter/f-inst.c"
    
#line 1490 "filter/f-inst.c"
 #line 1490 "filter/f-inst.c"
 ;
#line 1491 "filter/f-inst.c"
    #line 1491 "filter/f-inst.c"
;
     
#line 1492 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1495 "filter/f-inst.c"
  }
#line 1495

#line 1495

#line 1506 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FILTER_SET */
#line 1506
struct f_inst *
#line 1496 "filter/f-inst.c"
NONNULL(2)
#line 1497 "filter/f-inst.c"
NONNULL(3)
#line 1506 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1496 "filter/f-inst.c"
  , struct f_inst * f1
#line 1497 "filter/f-inst.c"
  , struct f_inst * f2
#line 1506 "filter/f-inst.c"
)
#line 1506
  {
#line 1506
    /* Allocate the structure */
#line 1506
    struct f_inst *what = fi_new(fi_code);
#line 1506
    uint constargs = 1;
#line 1506

#line 1506
    /* Initialize all the members */
#line 1506
  #define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1506
  #line 1496 "filter/f-inst.c"
whati->f1 = f1;
#line 1496
const struct f_inst *child1 = f1;
#line 1496
do {
#line 1496
  what->size += child1->size;
#line 1496

#line 1496
  if (child1->fi_code != FI_CONSTANT)
#line 1496
    constargs = 0;
#line 1496

#line 1496
} while (child1 = child1->next);
#line 1496

#line 1496 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1496
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1496
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1497 "filter/f-inst.c"
whati->f2 = f2;
#line 1497
const struct f_inst *child2 = f2;
#line 1497
do {
#line 1497
  what->size += child2->size;
#line 1497

#line 1497
  if (child2->fi_code != FI_CONSTANT)
#line 1497
    constargs = 0;
#line 1497

#line 1497
} while (child2 = child2->next);
#line 1497 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1497
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1497
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1503 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1506 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1506
    if (!constargs)
#line 1506
      return what;
#line 1506

#line 1506
    /* Try to pre-calculate the result */
#line 1506
    #line 1495 "filter/f-inst.c"
 {
    
#line 1496 "filter/f-inst.c"
 #line 1496 "filter/f-inst.c"
 ;
#line 1497 "filter/f-inst.c"
    
#line 1497 "filter/f-inst.c"
 #line 1497 "filter/f-inst.c"
 ;
#line 1498 "filter/f-inst.c"
    #line 1498 "filter/f-inst.c"
;

    if (!lclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1503 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1506 "filter/f-inst.c"
  }
#line 1506

#line 1506

#line 1528 "filter/f-inst.c"
 /* Constructor for FI_ROA_CHECK */
#line 1528
struct f_inst *
#line 1508 "filter/f-inst.c"
NONNULL(2)
#line 1509 "filter/f-inst.c"
NONNULL(3)
#line 1528 "filter/f-inst.c"
f_new_inst_FI_ROA_CHECK(enum f_instruction_code fi_code
#line 1508 "filter/f-inst.c"
  , struct f_inst * f1
#line 1509 "filter/f-inst.c"
  , struct f_inst * f2
#line 1510 "filter/f-inst.c"
  , struct rtable_config * rtc
#line 1528 "filter/f-inst.c"
)
#line 1528
  {
#line 1528
    /* Allocate the structure */
#line 1528
    struct f_inst *what = fi_new(fi_code);
#line 1528
    
#line 1528

#line 1528
    /* Initialize all the members */
#line 1528
  #define whati (&(what->i_FI_ROA_CHECK))
#line 1528
  #line 1508 "filter/f-inst.c"
whati->f1 = f1;
#line 1508
const struct f_inst *child1 = f1;
#line 1508
do {
#line 1508
  what->size += child1->size;
#line 1508

#line 1508
} while (child1 = child1->next);
#line 1508

#line 1508 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1508
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1508
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1509 "filter/f-inst.c"
whati->f2 = f2;
#line 1509
const struct f_inst *child2 = f2;
#line 1509
do {
#line 1509
  what->size += child2->size;
#line 1509

#line 1509
} while (child2 = child2->next);
#line 1509 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1509
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1509
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1510 "filter/f-inst.c"
whati->rtc = rtc;
#line 1522 "filter/f-inst.c"
what->type = T_ENUM_ROA;

#line 1528 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1528
    
#line 1528
      return what;
#line 1528

#line 1528
    /* Try to pre-calculate the result */
#line 1528
      #undef whati
#line 1528
  }
#line 1528

#line 1528

#line 1544 "filter/f-inst.c"
 /* Constructor for FI_ASPA_CHECK_EXPLICIT */
#line 1544
struct f_inst *
#line 1530 "filter/f-inst.c"
NONNULL(2)
#line 1531 "filter/f-inst.c"
NONNULL(3)
#line 1544 "filter/f-inst.c"
f_new_inst_FI_ASPA_CHECK_EXPLICIT(enum f_instruction_code fi_code
#line 1530 "filter/f-inst.c"
  , struct f_inst * f1
#line 1531 "filter/f-inst.c"
  , struct f_inst * f2
#line 1532 "filter/f-inst.c"
  , struct rtable_config * rtc
#line 1544 "filter/f-inst.c"
)
#line 1544
  {
#line 1544
    /* Allocate the structure */
#line 1544
    struct f_inst *what = fi_new(fi_code);
#line 1544
    
#line 1544

#line 1544
    /* Initialize all the members */
#line 1544
  #define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1544
  #line 1530 "filter/f-inst.c"
whati->f1 = f1;
#line 1530
const struct f_inst *child1 = f1;
#line 1530
do {
#line 1530
  what->size += child1->size;
#line 1530

#line 1530
} while (child1 = child1->next);
#line 1530

#line 1530 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1530
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1530
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1531 "filter/f-inst.c"
whati->f2 = f2;
#line 1531
const struct f_inst *child2 = f2;
#line 1531
do {
#line 1531
  what->size += child2->size;
#line 1531

#line 1531
} while (child2 = child2->next);
#line 1531 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 1531
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1531
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 1532 "filter/f-inst.c"
whati->rtc = rtc;
#line 1541 "filter/f-inst.c"
what->type = T_ENUM_ASPA;

#line 1544 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1544
    
#line 1544
      return what;
#line 1544

#line 1544
    /* Try to pre-calculate the result */
#line 1544
      #undef whati
#line 1544
  }
#line 1544

#line 1544

#line 1559 "filter/f-inst.c"
 /* Constructor for FI_FROM_HEX */
#line 1559
struct f_inst *
#line 1545 "filter/f-inst.c"
NONNULL(2)
#line 1559 "filter/f-inst.c"
f_new_inst_FI_FROM_HEX(enum f_instruction_code fi_code
#line 1545 "filter/f-inst.c"
  , struct f_inst * f1
#line 1559 "filter/f-inst.c"
)
#line 1559
  {
#line 1559
    /* Allocate the structure */
#line 1559
    struct f_inst *what = fi_new(fi_code);
#line 1559
    uint constargs = 1;
#line 1559

#line 1559
    /* Initialize all the members */
#line 1559
  #define whati (&(what->i_FI_FROM_HEX))
#line 1559
  #line 1545 "filter/f-inst.c"
whati->f1 = f1;
#line 1545
const struct f_inst *child1 = f1;
#line 1545
do {
#line 1545
  what->size += child1->size;
#line 1545

#line 1545
  if (child1->fi_code != FI_CONSTANT)
#line 1545
    constargs = 0;
#line 1545

#line 1545
} while (child1 = child1->next);
#line 1545

#line 1545 "filter/f-inst.c"
if (f1->type && (f1->type != (T_STRING)) && !f_const_promotion(f1, (T_STRING)))
#line 1545
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1545
	   f_instruction_name(what->fi_code), f_type_name(T_STRING), f_type_name(f1->type));
#line 1556 "filter/f-inst.c"
what->type = T_BYTESTRING;

#line 1559 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1559
    if (!constargs)
#line 1559
      return what;
#line 1559

#line 1559
    /* Try to pre-calculate the result */
#line 1559
    #line 1544 "filter/f-inst.c"
 {	/* Convert hex text to bytestring */
    
#line 1545 "filter/f-inst.c"
 #line 1545 "filter/f-inst.c"
 ;
#line 1546 "filter/f-inst.c"

    int len = bstrhextobin(v1.val.s, NULL);
    if (len < 0)
      runtime("Invalid hex string");

    struct adata *bs;
    bs = falloc(sizeof(struct adata) + len);
    bs->length = bstrhextobin(v1.val.s, bs->data);
    ASSERT(bs->length == (size_t) len);

     
#line 1556 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BYTESTRING, .val.bs = bs } );
  }

  
  #undef whati
#line 1559 "filter/f-inst.c"
  }
#line 1559

#line 1559

#line 1564 "filter/f-inst.c"
 /* Constructor for FI_FORMAT */
#line 1564
struct f_inst *
#line 1560 "filter/f-inst.c"
NONNULL(2)
#line 1564 "filter/f-inst.c"
f_new_inst_FI_FORMAT(enum f_instruction_code fi_code
#line 1560 "filter/f-inst.c"
  , struct f_inst * f1
#line 1564 "filter/f-inst.c"
)
#line 1564
  {
#line 1564
    /* Allocate the structure */
#line 1564
    struct f_inst *what = fi_new(fi_code);
#line 1564
    uint constargs = 1;
#line 1564

#line 1564
    /* Initialize all the members */
#line 1564
  #define whati (&(what->i_FI_FORMAT))
#line 1564
  #line 1560 "filter/f-inst.c"
whati->f1 = f1;
#line 1560
const struct f_inst *child1 = f1;
#line 1560
do {
#line 1560
  what->size += child1->size;
#line 1560

#line 1560
  if (child1->fi_code != FI_CONSTANT)
#line 1560
    constargs = 0;
#line 1560

#line 1560
} while (child1 = child1->next);
#line 1560

#line 1561 "filter/f-inst.c"
what->type = T_STRING;

#line 1564 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1564
    if (!constargs)
#line 1564
      return what;
#line 1564

#line 1564
    /* Try to pre-calculate the result */
#line 1564
    #line 1559 "filter/f-inst.c"
 {	/* Format */
    
#line 1560 "filter/f-inst.c"
;
     
#line 1561 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s = val_format_str(fpool, &v1) } );
  }

  
  #undef whati
#line 1564 "filter/f-inst.c"
  }
#line 1564

#line 1564

#line 830 "filter/decl.m4"
 /* Constructor for FI_ASSERT */
#line 830
struct f_inst *
#line 1566 "filter/f-inst.c"
NONNULL(2)
#line 830 "filter/decl.m4"
f_new_inst_FI_ASSERT(enum f_instruction_code fi_code
#line 1566 "filter/f-inst.c"
  , struct f_inst * f1
#line 1568 "filter/f-inst.c"
  , char * s
#line 830 "filter/decl.m4"
)
#line 830
  {
#line 830
    /* Allocate the structure */
#line 830
    struct f_inst *what = fi_new(fi_code);
#line 830
    
#line 830

#line 830
    /* Initialize all the members */
#line 830
  #define whati (&(what->i_FI_ASSERT))
#line 830
  #line 1566 "filter/f-inst.c"
whati->f1 = f1;
#line 1566
const struct f_inst *child1 = f1;
#line 1566
do {
#line 1566
  what->size += child1->size;
#line 1566

#line 1566
} while (child1 = child1->next);
#line 1566

#line 1566 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 1566
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1566
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 1568 "filter/f-inst.c"
whati->s = s;

#line 830 "filter/decl.m4"
    /* If not constant, return the instruction itself */
#line 830
    
#line 830
      return what;
#line 830

#line 830
    /* Try to pre-calculate the result */
#line 830
      #undef whati
#line 830
  }
#line 830

#line 830

#line 611 "filter/decl.m4"

#undef v1
#undef v2
#undef v3
#undef vv

/* Method constructor wrappers */
#line 288 "filter/f-inst.c"

#line 293 "filter/f-inst.c"

#line 298 "filter/f-inst.c"

#line 304 "filter/f-inst.c"

#line 309 "filter/f-inst.c"

#line 314 "filter/f-inst.c"

#line 324 "filter/f-inst.c"

#line 335 "filter/f-inst.c"

#line 345 "filter/f-inst.c"

#line 385 "filter/f-inst.c"

#line 392 "filter/f-inst.c"

#line 442 "filter/f-inst.c"

#line 449 "filter/f-inst.c"

#line 456 "filter/f-inst.c"

#line 467 "filter/f-inst.c"

#line 478 "filter/f-inst.c"

#line 483 "filter/f-inst.c"

#line 492 "filter/f-inst.c"

#line 501 "filter/f-inst.c"

#line 506 "filter/f-inst.c"

#line 507 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__type */
#line 507
struct f_inst * NONNULL(1)
#line 507
f_new_method_FI_METHOD__T_NET__type(struct f_inst *obj, struct f_inst *args)
#line 507
  {
#line 507
    /* Unwind the arguments (1) */
#line 507
        if (args) cf_error("Too many arguments");
#line 506 "filter/f-inst.c"

#line 506

    return f_new_inst(FI_METHOD__T_NET__type, obj
#line 507 "filter/f-inst.c"

#line 507
    );
#line 507
  }
#line 507

#line 510 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_IP__is_v4 */
#line 510
struct f_inst * NONNULL(1)
#line 510
f_new_method_FI_METHOD__T_IP__is_v4(struct f_inst *obj, struct f_inst *args)
#line 510
  {
#line 510
    /* Unwind the arguments (1) */
#line 510
        if (args) cf_error("Too many arguments");
#line 507 "filter/f-inst.c"

#line 507

    return f_new_inst(FI_METHOD__T_IP__is_v4, obj
#line 510 "filter/f-inst.c"

#line 510
    );
#line 510
  }
#line 510

#line 523 "filter/f-inst.c"

#line 534 "filter/f-inst.c"

#line 543 "filter/f-inst.c"

#line 550 "filter/f-inst.c"

#line 563 "filter/f-inst.c"

#line 564 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__empty */
#line 564
struct f_inst * NONNULL(1)
#line 564
f_new_method_FI_METHOD__T_PATH__empty(struct f_inst *obj, struct f_inst *args)
#line 564
  {
#line 564
    /* Unwind the arguments (1) */
#line 564
        if (args) cf_error("Too many arguments");
#line 563 "filter/f-inst.c"

#line 563

    return f_new_inst(FI_METHOD__T_PATH__empty, obj
#line 564 "filter/f-inst.c"

#line 564
    );
#line 564
  }
#line 564

#line 565 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__empty */
#line 565
struct f_inst * NONNULL(1)
#line 565
f_new_method_FI_METHOD__T_CLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 565
  {
#line 565
    /* Unwind the arguments (1) */
#line 565
        if (args) cf_error("Too many arguments");
#line 564 "filter/f-inst.c"

#line 564

    return f_new_inst(FI_METHOD__T_CLIST__empty, obj
#line 565 "filter/f-inst.c"

#line 565
    );
#line 565
  }
#line 565

#line 566 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__empty */
#line 566
struct f_inst * NONNULL(1)
#line 566
f_new_method_FI_METHOD__T_ECLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 566
  {
#line 566
    /* Unwind the arguments (1) */
#line 566
        if (args) cf_error("Too many arguments");
#line 565 "filter/f-inst.c"

#line 565

    return f_new_inst(FI_METHOD__T_ECLIST__empty, obj
#line 566 "filter/f-inst.c"

#line 566
    );
#line 566
  }
#line 566

#line 569 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__empty */
#line 569
struct f_inst * NONNULL(1)
#line 569
f_new_method_FI_METHOD__T_LCLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 569
  {
#line 569
    /* Unwind the arguments (1) */
#line 569
        if (args) cf_error("Too many arguments");
#line 566 "filter/f-inst.c"

#line 566

    return f_new_inst(FI_METHOD__T_LCLIST__empty, obj
#line 569 "filter/f-inst.c"

#line 569
    );
#line 569
  }
#line 569

#line 591 "filter/f-inst.c"

#line 600 "filter/f-inst.c"
 /* Method constructor for FI_PATH_FOR_NEXT */
#line 600
struct f_inst * NONNULL(1)
#line 600
f_new_method_FI_PATH_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 600
  {
#line 600
    /* Unwind the arguments (2) */
#line 600
    #line 595 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 595
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_FOR_NEXT */
#line 595
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 597 "filter/f-inst.c"

#line 597

    return f_new_inst(FI_PATH_FOR_NEXT, obj
#line 595 "filter/f-inst.c"
    , arg2
#line 600 "filter/f-inst.c"

#line 600
    );
#line 600
  }
#line 600

#line 609 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FOR_NEXT */
#line 609
struct f_inst * NONNULL(1)
#line 609
f_new_method_FI_CLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 609
  {
#line 609
    /* Unwind the arguments (2) */
#line 609
    #line 604 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 604
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FOR_NEXT */
#line 604
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 606 "filter/f-inst.c"

#line 606

    return f_new_inst(FI_CLIST_FOR_NEXT, obj
#line 604 "filter/f-inst.c"
    , arg2
#line 609 "filter/f-inst.c"

#line 609
    );
#line 609
  }
#line 609

#line 618 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FOR_NEXT */
#line 618
struct f_inst * NONNULL(1)
#line 618
f_new_method_FI_ECLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 618
  {
#line 618
    /* Unwind the arguments (2) */
#line 618
    #line 613 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 613
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FOR_NEXT */
#line 613
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 615 "filter/f-inst.c"

#line 615

    return f_new_inst(FI_ECLIST_FOR_NEXT, obj
#line 613 "filter/f-inst.c"
    , arg2
#line 618 "filter/f-inst.c"

#line 618
    );
#line 618
  }
#line 618

#line 627 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FOR_NEXT */
#line 627
struct f_inst * NONNULL(1)
#line 627
f_new_method_FI_LCLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 627
  {
#line 627
    /* Unwind the arguments (2) */
#line 627
    #line 622 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 622
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FOR_NEXT */
#line 622
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 624 "filter/f-inst.c"

#line 624

    return f_new_inst(FI_LCLIST_FOR_NEXT, obj
#line 622 "filter/f-inst.c"
    , arg2
#line 627 "filter/f-inst.c"

#line 627
    );
#line 627
  }
#line 627

#line 640 "filter/f-inst.c"
 /* Method constructor for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
struct f_inst * NONNULL(1)
#line 640
f_new_method_FI_ROUTES_BLOCK_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 640
  {
#line 640
    /* Unwind the arguments (2) */
#line 640
    #line 634 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 634
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ROUTES_BLOCK_FOR_NEXT */
#line 634
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 637 "filter/f-inst.c"

#line 637

    return f_new_inst(FI_ROUTES_BLOCK_FOR_NEXT, obj
#line 634 "filter/f-inst.c"
    , arg2
#line 640 "filter/f-inst.c"

#line 640
    );
#line 640
  }
#line 640

#line 648 "filter/f-inst.c"

#line 661 "filter/f-inst.c"

#line 668 "filter/f-inst.c"

#line 682 "filter/f-inst.c"

#line 689 "filter/f-inst.c"

#line 736 "filter/f-inst.c"

#line 864 "filter/f-inst.c"

#line 901 "filter/f-inst.c"

#line 942 "filter/f-inst.c"

#line 949 "filter/f-inst.c"

#line 963 "filter/f-inst.c"

#line 964 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__len */
#line 964
struct f_inst * NONNULL(1)
#line 964
f_new_method_FI_METHOD__T_NET__len(struct f_inst *obj, struct f_inst *args)
#line 964
  {
#line 964
    /* Unwind the arguments (1) */
#line 964
        if (args) cf_error("Too many arguments");
#line 963 "filter/f-inst.c"

#line 963

    return f_new_inst(FI_METHOD__T_NET__len, obj
#line 964 "filter/f-inst.c"

#line 964
    );
#line 964
  }
#line 964

#line 965 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__len */
#line 965
struct f_inst * NONNULL(1)
#line 965
f_new_method_FI_METHOD__T_PATH__len(struct f_inst *obj, struct f_inst *args)
#line 965
  {
#line 965
    /* Unwind the arguments (1) */
#line 965
        if (args) cf_error("Too many arguments");
#line 964 "filter/f-inst.c"

#line 964

    return f_new_inst(FI_METHOD__T_PATH__len, obj
#line 965 "filter/f-inst.c"

#line 965
    );
#line 965
  }
#line 965

#line 966 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__len */
#line 966
struct f_inst * NONNULL(1)
#line 966
f_new_method_FI_METHOD__T_CLIST__len(struct f_inst *obj, struct f_inst *args)
#line 966
  {
#line 966
    /* Unwind the arguments (1) */
#line 966
        if (args) cf_error("Too many arguments");
#line 965 "filter/f-inst.c"

#line 965

    return f_new_inst(FI_METHOD__T_CLIST__len, obj
#line 966 "filter/f-inst.c"

#line 966
    );
#line 966
  }
#line 966

#line 967 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__len */
#line 967
struct f_inst * NONNULL(1)
#line 967
f_new_method_FI_METHOD__T_ECLIST__len(struct f_inst *obj, struct f_inst *args)
#line 967
  {
#line 967
    /* Unwind the arguments (1) */
#line 967
        if (args) cf_error("Too many arguments");
#line 966 "filter/f-inst.c"

#line 966

    return f_new_inst(FI_METHOD__T_ECLIST__len, obj
#line 967 "filter/f-inst.c"

#line 967
    );
#line 967
  }
#line 967

#line 969 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__len */
#line 969
struct f_inst * NONNULL(1)
#line 969
f_new_method_FI_METHOD__T_LCLIST__len(struct f_inst *obj, struct f_inst *args)
#line 969
  {
#line 969
    /* Unwind the arguments (1) */
#line 969
        if (args) cf_error("Too many arguments");
#line 967 "filter/f-inst.c"

#line 967

    return f_new_inst(FI_METHOD__T_LCLIST__len, obj
#line 969 "filter/f-inst.c"

#line 969
    );
#line 969
  }
#line 969

#line 1005 "filter/f-inst.c"
 /* Method constructor for FI_NET_SRC */
#line 1005
struct f_inst * NONNULL(1)
#line 1005
f_new_method_FI_NET_SRC(struct f_inst *obj, struct f_inst *args)
#line 1005
  {
#line 1005
    /* Unwind the arguments (1) */
#line 1005
        if (args) cf_error("Too many arguments");
#line 971 "filter/f-inst.c"

#line 971

    return f_new_inst(FI_NET_SRC, obj
#line 1005 "filter/f-inst.c"

#line 1005
    );
#line 1005
  }
#line 1005

#line 1042 "filter/f-inst.c"
 /* Method constructor for FI_NET_DST */
#line 1042
struct f_inst * NONNULL(1)
#line 1042
f_new_method_FI_NET_DST(struct f_inst *obj, struct f_inst *args)
#line 1042
  {
#line 1042
    /* Unwind the arguments (1) */
#line 1042
        if (args) cf_error("Too many arguments");
#line 1007 "filter/f-inst.c"

#line 1007

    return f_new_inst(FI_NET_DST, obj
#line 1042 "filter/f-inst.c"

#line 1042
    );
#line 1042
  }
#line 1042

#line 1052 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__maxlen */
#line 1052
struct f_inst * NONNULL(1)
#line 1052
f_new_method_FI_METHOD__T_NET__maxlen(struct f_inst *obj, struct f_inst *args)
#line 1052
  {
#line 1052
    /* Unwind the arguments (1) */
#line 1052
        if (args) cf_error("Too many arguments");
#line 1042 "filter/f-inst.c"

#line 1042

    return f_new_inst(FI_METHOD__T_NET__maxlen, obj
#line 1052 "filter/f-inst.c"

#line 1052
    );
#line 1052
  }
#line 1052

#line 1062 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__asn */
#line 1062
struct f_inst * NONNULL(1)
#line 1062
f_new_method_FI_METHOD__T_NET__asn(struct f_inst *obj, struct f_inst *args)
#line 1062
  {
#line 1062
    /* Unwind the arguments (1) */
#line 1062
        if (args) cf_error("Too many arguments");
#line 1052 "filter/f-inst.c"

#line 1052

    return f_new_inst(FI_METHOD__T_NET__asn, obj
#line 1062 "filter/f-inst.c"

#line 1062
    );
#line 1062
  }
#line 1062

#line 1064 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__ip */
#line 1064
struct f_inst * NONNULL(1)
#line 1064
f_new_method_FI_METHOD__T_NET__ip(struct f_inst *obj, struct f_inst *args)
#line 1064
  {
#line 1064
    /* Unwind the arguments (1) */
#line 1064
        if (args) cf_error("Too many arguments");
#line 1062 "filter/f-inst.c"

#line 1062

    return f_new_inst(FI_METHOD__T_NET__ip, obj
#line 1064 "filter/f-inst.c"

#line 1064
    );
#line 1064
  }
#line 1064

#line 1073 "filter/f-inst.c"
 /* Method constructor for FI_ROUTE_DISTINGUISHER */
#line 1073
struct f_inst * NONNULL(1)
#line 1073
f_new_method_FI_ROUTE_DISTINGUISHER(struct f_inst *obj, struct f_inst *args)
#line 1073
  {
#line 1073
    /* Unwind the arguments (1) */
#line 1073
        if (args) cf_error("Too many arguments");
#line 1066 "filter/f-inst.c"

#line 1066

    return f_new_inst(FI_ROUTE_DISTINGUISHER, obj
#line 1073 "filter/f-inst.c"

#line 1073
    );
#line 1073
  }
#line 1073

#line 1076 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__first */
#line 1076
struct f_inst * NONNULL(1)
#line 1076
f_new_method_FI_METHOD__T_PATH__first(struct f_inst *obj, struct f_inst *args)
#line 1076
  {
#line 1076
    /* Unwind the arguments (1) */
#line 1076
        if (args) cf_error("Too many arguments");
#line 1073 "filter/f-inst.c"

#line 1073

    return f_new_inst(FI_METHOD__T_PATH__first, obj
#line 1076 "filter/f-inst.c"

#line 1076
    );
#line 1076
  }
#line 1076

#line 1079 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__last */
#line 1079
struct f_inst * NONNULL(1)
#line 1079
f_new_method_FI_METHOD__T_PATH__last(struct f_inst *obj, struct f_inst *args)
#line 1079
  {
#line 1079
    /* Unwind the arguments (1) */
#line 1079
        if (args) cf_error("Too many arguments");
#line 1076 "filter/f-inst.c"

#line 1076

    return f_new_inst(FI_METHOD__T_PATH__last, obj
#line 1079 "filter/f-inst.c"

#line 1079
    );
#line 1079
  }
#line 1079

#line 1082 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
struct f_inst * NONNULL(1)
#line 1082
f_new_method_FI_METHOD__T_PATH__last_nonaggregated(struct f_inst *obj, struct f_inst *args)
#line 1082
  {
#line 1082
    /* Unwind the arguments (1) */
#line 1082
        if (args) cf_error("Too many arguments");
#line 1079 "filter/f-inst.c"

#line 1079

    return f_new_inst(FI_METHOD__T_PATH__last_nonaggregated, obj
#line 1082 "filter/f-inst.c"

#line 1082
    );
#line 1082
  }
#line 1082

#line 1085 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PAIR__asn */
#line 1085
struct f_inst * NONNULL(1)
#line 1085
f_new_method_FI_METHOD__T_PAIR__asn(struct f_inst *obj, struct f_inst *args)
#line 1085
  {
#line 1085
    /* Unwind the arguments (1) */
#line 1085
        if (args) cf_error("Too many arguments");
#line 1082 "filter/f-inst.c"

#line 1082

    return f_new_inst(FI_METHOD__T_PAIR__asn, obj
#line 1085 "filter/f-inst.c"

#line 1085
    );
#line 1085
  }
#line 1085

#line 1088 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PAIR__data */
#line 1088
struct f_inst * NONNULL(1)
#line 1088
f_new_method_FI_METHOD__T_PAIR__data(struct f_inst *obj, struct f_inst *args)
#line 1088
  {
#line 1088
    /* Unwind the arguments (1) */
#line 1088
        if (args) cf_error("Too many arguments");
#line 1085 "filter/f-inst.c"

#line 1085

    return f_new_inst(FI_METHOD__T_PAIR__data, obj
#line 1088 "filter/f-inst.c"

#line 1088
    );
#line 1088
  }
#line 1088

#line 1091 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__asn */
#line 1091
struct f_inst * NONNULL(1)
#line 1091
f_new_method_FI_METHOD__T_LC__asn(struct f_inst *obj, struct f_inst *args)
#line 1091
  {
#line 1091
    /* Unwind the arguments (1) */
#line 1091
        if (args) cf_error("Too many arguments");
#line 1088 "filter/f-inst.c"

#line 1088

    return f_new_inst(FI_METHOD__T_LC__asn, obj
#line 1091 "filter/f-inst.c"

#line 1091
    );
#line 1091
  }
#line 1091

#line 1094 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__data1 */
#line 1094
struct f_inst * NONNULL(1)
#line 1094
f_new_method_FI_METHOD__T_LC__data1(struct f_inst *obj, struct f_inst *args)
#line 1094
  {
#line 1094
    /* Unwind the arguments (1) */
#line 1094
        if (args) cf_error("Too many arguments");
#line 1091 "filter/f-inst.c"

#line 1091

    return f_new_inst(FI_METHOD__T_LC__data1, obj
#line 1094 "filter/f-inst.c"

#line 1094
    );
#line 1094
  }
#line 1094

#line 1097 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__data2 */
#line 1097
struct f_inst * NONNULL(1)
#line 1097
f_new_method_FI_METHOD__T_LC__data2(struct f_inst *obj, struct f_inst *args)
#line 1097
  {
#line 1097
    /* Unwind the arguments (1) */
#line 1097
        if (args) cf_error("Too many arguments");
#line 1094 "filter/f-inst.c"

#line 1094

    return f_new_inst(FI_METHOD__T_LC__data2, obj
#line 1097 "filter/f-inst.c"

#line 1097
    );
#line 1097
  }
#line 1097

#line 1100 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__min */
#line 1100
struct f_inst * NONNULL(1)
#line 1100
f_new_method_FI_METHOD__T_CLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1100
  {
#line 1100
    /* Unwind the arguments (1) */
#line 1100
        if (args) cf_error("Too many arguments");
#line 1097 "filter/f-inst.c"

#line 1097

    return f_new_inst(FI_METHOD__T_CLIST__min, obj
#line 1100 "filter/f-inst.c"

#line 1100
    );
#line 1100
  }
#line 1100

#line 1103 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__max */
#line 1103
struct f_inst * NONNULL(1)
#line 1103
f_new_method_FI_METHOD__T_CLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1103
  {
#line 1103
    /* Unwind the arguments (1) */
#line 1103
        if (args) cf_error("Too many arguments");
#line 1100 "filter/f-inst.c"

#line 1100

    return f_new_inst(FI_METHOD__T_CLIST__max, obj
#line 1103 "filter/f-inst.c"

#line 1103
    );
#line 1103
  }
#line 1103

#line 1106 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__min */
#line 1106
struct f_inst * NONNULL(1)
#line 1106
f_new_method_FI_METHOD__T_ECLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1106
  {
#line 1106
    /* Unwind the arguments (1) */
#line 1106
        if (args) cf_error("Too many arguments");
#line 1103 "filter/f-inst.c"

#line 1103

    return f_new_inst(FI_METHOD__T_ECLIST__min, obj
#line 1106 "filter/f-inst.c"

#line 1106
    );
#line 1106
  }
#line 1106

#line 1109 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__max */
#line 1109
struct f_inst * NONNULL(1)
#line 1109
f_new_method_FI_METHOD__T_ECLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1109
  {
#line 1109
    /* Unwind the arguments (1) */
#line 1109
        if (args) cf_error("Too many arguments");
#line 1106 "filter/f-inst.c"

#line 1106

    return f_new_inst(FI_METHOD__T_ECLIST__max, obj
#line 1109 "filter/f-inst.c"

#line 1109
    );
#line 1109
  }
#line 1109

#line 1112 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__min */
#line 1112
struct f_inst * NONNULL(1)
#line 1112
f_new_method_FI_METHOD__T_LCLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1112
  {
#line 1112
    /* Unwind the arguments (1) */
#line 1112
        if (args) cf_error("Too many arguments");
#line 1109 "filter/f-inst.c"

#line 1109

    return f_new_inst(FI_METHOD__T_LCLIST__min, obj
#line 1112 "filter/f-inst.c"

#line 1112
    );
#line 1112
  }
#line 1112

#line 1114 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__max */
#line 1114
struct f_inst * NONNULL(1)
#line 1114
f_new_method_FI_METHOD__T_LCLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1114
  {
#line 1114
    /* Unwind the arguments (1) */
#line 1114
        if (args) cf_error("Too many arguments");
#line 1112 "filter/f-inst.c"

#line 1112

    return f_new_inst(FI_METHOD__T_LCLIST__max, obj
#line 1114 "filter/f-inst.c"

#line 1114
    );
#line 1114
  }
#line 1114

#line 1140 "filter/f-inst.c"

#line 1200 "filter/f-inst.c"

#line 1205 "filter/f-inst.c"

#line 1246 "filter/f-inst.c"

#line 1255 "filter/f-inst.c"
 /* Method constructor for FI_IP_MASK */
#line 1255
struct f_inst * NONNULL(1)
#line 1255
f_new_method_FI_IP_MASK(struct f_inst *obj, struct f_inst *args)
#line 1255
  {
#line 1255
    /* Unwind the arguments (2) */
#line 1255
    #line 1248 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1248
  if (args == NULL) cf_error("Not enough arguments"); /* FI_IP_MASK */
#line 1248
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1249 "filter/f-inst.c"

#line 1249

    return f_new_inst(FI_IP_MASK, obj
#line 1248 "filter/f-inst.c"
    , arg2
#line 1255 "filter/f-inst.c"

#line 1255
    );
#line 1255
  }
#line 1255

#line 1263 "filter/f-inst.c"
 /* Method constructor for FI_PATH_PREPEND */
#line 1263
struct f_inst * NONNULL(1)
#line 1263
f_new_method_FI_PATH_PREPEND(struct f_inst *obj, struct f_inst *args)
#line 1263
  {
#line 1263
    /* Unwind the arguments (2) */
#line 1263
    #line 1257 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1257
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_PREPEND */
#line 1257
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1258 "filter/f-inst.c"

#line 1258

    return f_new_inst(FI_PATH_PREPEND, obj
#line 1257 "filter/f-inst.c"
    , arg2
#line 1263 "filter/f-inst.c"

#line 1263
    );
#line 1263
  }
#line 1263

#line 1270 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_PAIR */
#line 1270
struct f_inst * NONNULL(1)
#line 1270
f_new_method_FI_CLIST_ADD_PAIR(struct f_inst *obj, struct f_inst *args)
#line 1270
  {
#line 1270
    /* Unwind the arguments (2) */
#line 1270
    #line 1265 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1265
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_PAIR */
#line 1265
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1266 "filter/f-inst.c"

#line 1266

    return f_new_inst(FI_CLIST_ADD_PAIR, obj
#line 1265 "filter/f-inst.c"
    , arg2
#line 1270 "filter/f-inst.c"

#line 1270
    );
#line 1270
  }
#line 1270

#line 1284 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_IP */
#line 1284
struct f_inst * NONNULL(1)
#line 1284
f_new_method_FI_CLIST_ADD_IP(struct f_inst *obj, struct f_inst *args)
#line 1284
  {
#line 1284
    /* Unwind the arguments (2) */
#line 1284
    #line 1272 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1272
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_IP */
#line 1272
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1273 "filter/f-inst.c"

#line 1273

    return f_new_inst(FI_CLIST_ADD_IP, obj
#line 1272 "filter/f-inst.c"
    , arg2
#line 1284 "filter/f-inst.c"

#line 1284
    );
#line 1284
  }
#line 1284

#line 1291 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_QUAD */
#line 1291
struct f_inst * NONNULL(1)
#line 1291
f_new_method_FI_CLIST_ADD_QUAD(struct f_inst *obj, struct f_inst *args)
#line 1291
  {
#line 1291
    /* Unwind the arguments (2) */
#line 1291
    #line 1286 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1286
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_QUAD */
#line 1286
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1287 "filter/f-inst.c"

#line 1287

    return f_new_inst(FI_CLIST_ADD_QUAD, obj
#line 1286 "filter/f-inst.c"
    , arg2
#line 1291 "filter/f-inst.c"

#line 1291
    );
#line 1291
  }
#line 1291

#line 1298 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_CLIST */
#line 1298
struct f_inst * NONNULL(1)
#line 1298
f_new_method_FI_CLIST_ADD_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1298
  {
#line 1298
    /* Unwind the arguments (2) */
#line 1298
    #line 1293 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1293
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_CLIST */
#line 1293
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1294 "filter/f-inst.c"

#line 1294

    return f_new_inst(FI_CLIST_ADD_CLIST, obj
#line 1293 "filter/f-inst.c"
    , arg2
#line 1298 "filter/f-inst.c"

#line 1298
    );
#line 1298
  }
#line 1298

#line 1305 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_ADD_EC */
#line 1305
struct f_inst * NONNULL(1)
#line 1305
f_new_method_FI_ECLIST_ADD_EC(struct f_inst *obj, struct f_inst *args)
#line 1305
  {
#line 1305
    /* Unwind the arguments (2) */
#line 1305
    #line 1300 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1300
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_ADD_EC */
#line 1300
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1301 "filter/f-inst.c"

#line 1301

    return f_new_inst(FI_ECLIST_ADD_EC, obj
#line 1300 "filter/f-inst.c"
    , arg2
#line 1305 "filter/f-inst.c"

#line 1305
    );
#line 1305
  }
#line 1305

#line 1312 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_ADD_ECLIST */
#line 1312
struct f_inst * NONNULL(1)
#line 1312
f_new_method_FI_ECLIST_ADD_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1312
  {
#line 1312
    /* Unwind the arguments (2) */
#line 1312
    #line 1307 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1307
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_ADD_ECLIST */
#line 1307
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1308 "filter/f-inst.c"

#line 1308

    return f_new_inst(FI_ECLIST_ADD_ECLIST, obj
#line 1307 "filter/f-inst.c"
    , arg2
#line 1312 "filter/f-inst.c"

#line 1312
    );
#line 1312
  }
#line 1312

#line 1319 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_ADD_LC */
#line 1319
struct f_inst * NONNULL(1)
#line 1319
f_new_method_FI_LCLIST_ADD_LC(struct f_inst *obj, struct f_inst *args)
#line 1319
  {
#line 1319
    /* Unwind the arguments (2) */
#line 1319
    #line 1314 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1314
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_ADD_LC */
#line 1314
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1315 "filter/f-inst.c"

#line 1315

    return f_new_inst(FI_LCLIST_ADD_LC, obj
#line 1314 "filter/f-inst.c"
    , arg2
#line 1319 "filter/f-inst.c"

#line 1319
    );
#line 1319
  }
#line 1319

#line 1326 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_ADD_LCLIST */
#line 1326
struct f_inst * NONNULL(1)
#line 1326
f_new_method_FI_LCLIST_ADD_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1326
  {
#line 1326
    /* Unwind the arguments (2) */
#line 1326
    #line 1321 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1321
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_ADD_LCLIST */
#line 1321
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1322 "filter/f-inst.c"

#line 1322

    return f_new_inst(FI_LCLIST_ADD_LCLIST, obj
#line 1321 "filter/f-inst.c"
    , arg2
#line 1326 "filter/f-inst.c"

#line 1326
    );
#line 1326
  }
#line 1326

#line 1333 "filter/f-inst.c"
 /* Method constructor for FI_PATH_DELETE_INT */
#line 1333
struct f_inst * NONNULL(1)
#line 1333
f_new_method_FI_PATH_DELETE_INT(struct f_inst *obj, struct f_inst *args)
#line 1333
  {
#line 1333
    /* Unwind the arguments (2) */
#line 1333
    #line 1328 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1328
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_DELETE_INT */
#line 1328
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1329 "filter/f-inst.c"

#line 1329

    return f_new_inst(FI_PATH_DELETE_INT, obj
#line 1328 "filter/f-inst.c"
    , arg2
#line 1333 "filter/f-inst.c"

#line 1333
    );
#line 1333
  }
#line 1333

#line 1345 "filter/f-inst.c"
 /* Method constructor for FI_PATH_DELETE_SET */
#line 1345
struct f_inst * NONNULL(1)
#line 1345
f_new_method_FI_PATH_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1345
  {
#line 1345
    /* Unwind the arguments (2) */
#line 1345
    #line 1335 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1335
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_DELETE_SET */
#line 1335
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1336 "filter/f-inst.c"

#line 1336

    return f_new_inst(FI_PATH_DELETE_SET, obj
#line 1335 "filter/f-inst.c"
    , arg2
#line 1345 "filter/f-inst.c"

#line 1345
    );
#line 1345
  }
#line 1345

#line 1352 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_PAIR */
#line 1352
struct f_inst * NONNULL(1)
#line 1352
f_new_method_FI_CLIST_DELETE_PAIR(struct f_inst *obj, struct f_inst *args)
#line 1352
  {
#line 1352
    /* Unwind the arguments (2) */
#line 1352
    #line 1347 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1347
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_PAIR */
#line 1347
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1348 "filter/f-inst.c"

#line 1348

    return f_new_inst(FI_CLIST_DELETE_PAIR, obj
#line 1347 "filter/f-inst.c"
    , arg2
#line 1352 "filter/f-inst.c"

#line 1352
    );
#line 1352
  }
#line 1352

#line 1366 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_IP */
#line 1366
struct f_inst * NONNULL(1)
#line 1366
f_new_method_FI_CLIST_DELETE_IP(struct f_inst *obj, struct f_inst *args)
#line 1366
  {
#line 1366
    /* Unwind the arguments (2) */
#line 1366
    #line 1354 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1354
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_IP */
#line 1354
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1355 "filter/f-inst.c"

#line 1355

    return f_new_inst(FI_CLIST_DELETE_IP, obj
#line 1354 "filter/f-inst.c"
    , arg2
#line 1366 "filter/f-inst.c"

#line 1366
    );
#line 1366
  }
#line 1366

#line 1373 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_QUAD */
#line 1373
struct f_inst * NONNULL(1)
#line 1373
f_new_method_FI_CLIST_DELETE_QUAD(struct f_inst *obj, struct f_inst *args)
#line 1373
  {
#line 1373
    /* Unwind the arguments (2) */
#line 1373
    #line 1368 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1368
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_QUAD */
#line 1368
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1369 "filter/f-inst.c"

#line 1369

    return f_new_inst(FI_CLIST_DELETE_QUAD, obj
#line 1368 "filter/f-inst.c"
    , arg2
#line 1373 "filter/f-inst.c"

#line 1373
    );
#line 1373
  }
#line 1373

#line 1380 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_CLIST */
#line 1380
struct f_inst * NONNULL(1)
#line 1380
f_new_method_FI_CLIST_DELETE_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1380
  {
#line 1380
    /* Unwind the arguments (2) */
#line 1380
    #line 1375 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1375
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_CLIST */
#line 1375
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1376 "filter/f-inst.c"

#line 1376

    return f_new_inst(FI_CLIST_DELETE_CLIST, obj
#line 1375 "filter/f-inst.c"
    , arg2
#line 1380 "filter/f-inst.c"

#line 1380
    );
#line 1380
  }
#line 1380

#line 1391 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_SET */
#line 1391
struct f_inst * NONNULL(1)
#line 1391
f_new_method_FI_CLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1391
  {
#line 1391
    /* Unwind the arguments (2) */
#line 1391
    #line 1382 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1382
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_SET */
#line 1382
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1383 "filter/f-inst.c"

#line 1383

    return f_new_inst(FI_CLIST_DELETE_SET, obj
#line 1382 "filter/f-inst.c"
    , arg2
#line 1391 "filter/f-inst.c"

#line 1391
    );
#line 1391
  }
#line 1391

#line 1398 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_EC */
#line 1398
struct f_inst * NONNULL(1)
#line 1398
f_new_method_FI_ECLIST_DELETE_EC(struct f_inst *obj, struct f_inst *args)
#line 1398
  {
#line 1398
    /* Unwind the arguments (2) */
#line 1398
    #line 1393 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1393
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_EC */
#line 1393
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1394 "filter/f-inst.c"

#line 1394

    return f_new_inst(FI_ECLIST_DELETE_EC, obj
#line 1393 "filter/f-inst.c"
    , arg2
#line 1398 "filter/f-inst.c"

#line 1398
    );
#line 1398
  }
#line 1398

#line 1405 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_ECLIST */
#line 1405
struct f_inst * NONNULL(1)
#line 1405
f_new_method_FI_ECLIST_DELETE_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1405
  {
#line 1405
    /* Unwind the arguments (2) */
#line 1405
    #line 1400 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1400
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_ECLIST */
#line 1400
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1401 "filter/f-inst.c"

#line 1401

    return f_new_inst(FI_ECLIST_DELETE_ECLIST, obj
#line 1400 "filter/f-inst.c"
    , arg2
#line 1405 "filter/f-inst.c"

#line 1405
    );
#line 1405
  }
#line 1405

#line 1416 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_SET */
#line 1416
struct f_inst * NONNULL(1)
#line 1416
f_new_method_FI_ECLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1416
  {
#line 1416
    /* Unwind the arguments (2) */
#line 1416
    #line 1407 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1407
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_SET */
#line 1407
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1408 "filter/f-inst.c"

#line 1408

    return f_new_inst(FI_ECLIST_DELETE_SET, obj
#line 1407 "filter/f-inst.c"
    , arg2
#line 1416 "filter/f-inst.c"

#line 1416
    );
#line 1416
  }
#line 1416

#line 1423 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_LC */
#line 1423
struct f_inst * NONNULL(1)
#line 1423
f_new_method_FI_LCLIST_DELETE_LC(struct f_inst *obj, struct f_inst *args)
#line 1423
  {
#line 1423
    /* Unwind the arguments (2) */
#line 1423
    #line 1418 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1418
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_LC */
#line 1418
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1419 "filter/f-inst.c"

#line 1419

    return f_new_inst(FI_LCLIST_DELETE_LC, obj
#line 1418 "filter/f-inst.c"
    , arg2
#line 1423 "filter/f-inst.c"

#line 1423
    );
#line 1423
  }
#line 1423

#line 1430 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_LCLIST */
#line 1430
struct f_inst * NONNULL(1)
#line 1430
f_new_method_FI_LCLIST_DELETE_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1430
  {
#line 1430
    /* Unwind the arguments (2) */
#line 1430
    #line 1425 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1425
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_LCLIST */
#line 1425
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1426 "filter/f-inst.c"

#line 1426

    return f_new_inst(FI_LCLIST_DELETE_LCLIST, obj
#line 1425 "filter/f-inst.c"
    , arg2
#line 1430 "filter/f-inst.c"

#line 1430
    );
#line 1430
  }
#line 1430

#line 1441 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_SET */
#line 1441
struct f_inst * NONNULL(1)
#line 1441
f_new_method_FI_LCLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1441
  {
#line 1441
    /* Unwind the arguments (2) */
#line 1441
    #line 1432 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1432
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_SET */
#line 1432
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1433 "filter/f-inst.c"

#line 1433

    return f_new_inst(FI_LCLIST_DELETE_SET, obj
#line 1432 "filter/f-inst.c"
    , arg2
#line 1441 "filter/f-inst.c"

#line 1441
    );
#line 1441
  }
#line 1441

#line 1452 "filter/f-inst.c"
 /* Method constructor for FI_PATH_FILTER_SET */
#line 1452
struct f_inst * NONNULL(1)
#line 1452
f_new_method_FI_PATH_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1452
  {
#line 1452
    /* Unwind the arguments (2) */
#line 1452
    #line 1443 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1443
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_FILTER_SET */
#line 1443
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1444 "filter/f-inst.c"

#line 1444

    return f_new_inst(FI_PATH_FILTER_SET, obj
#line 1443 "filter/f-inst.c"
    , arg2
#line 1452 "filter/f-inst.c"

#line 1452
    );
#line 1452
  }
#line 1452

#line 1459 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FILTER_CLIST */
#line 1459
struct f_inst * NONNULL(1)
#line 1459
f_new_method_FI_CLIST_FILTER_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1459
  {
#line 1459
    /* Unwind the arguments (2) */
#line 1459
    #line 1454 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1454
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FILTER_CLIST */
#line 1454
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1455 "filter/f-inst.c"

#line 1455

    return f_new_inst(FI_CLIST_FILTER_CLIST, obj
#line 1454 "filter/f-inst.c"
    , arg2
#line 1459 "filter/f-inst.c"

#line 1459
    );
#line 1459
  }
#line 1459

#line 1470 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FILTER_SET */
#line 1470
struct f_inst * NONNULL(1)
#line 1470
f_new_method_FI_CLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1470
  {
#line 1470
    /* Unwind the arguments (2) */
#line 1470
    #line 1461 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1461
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FILTER_SET */
#line 1461
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1462 "filter/f-inst.c"

#line 1462

    return f_new_inst(FI_CLIST_FILTER_SET, obj
#line 1461 "filter/f-inst.c"
    , arg2
#line 1470 "filter/f-inst.c"

#line 1470
    );
#line 1470
  }
#line 1470

#line 1477 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FILTER_ECLIST */
#line 1477
struct f_inst * NONNULL(1)
#line 1477
f_new_method_FI_ECLIST_FILTER_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1477
  {
#line 1477
    /* Unwind the arguments (2) */
#line 1477
    #line 1472 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1472
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FILTER_ECLIST */
#line 1472
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1473 "filter/f-inst.c"

#line 1473

    return f_new_inst(FI_ECLIST_FILTER_ECLIST, obj
#line 1472 "filter/f-inst.c"
    , arg2
#line 1477 "filter/f-inst.c"

#line 1477
    );
#line 1477
  }
#line 1477

#line 1488 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FILTER_SET */
#line 1488
struct f_inst * NONNULL(1)
#line 1488
f_new_method_FI_ECLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1488
  {
#line 1488
    /* Unwind the arguments (2) */
#line 1488
    #line 1479 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1479
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FILTER_SET */
#line 1479
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1480 "filter/f-inst.c"

#line 1480

    return f_new_inst(FI_ECLIST_FILTER_SET, obj
#line 1479 "filter/f-inst.c"
    , arg2
#line 1488 "filter/f-inst.c"

#line 1488
    );
#line 1488
  }
#line 1488

#line 1495 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FILTER_LCLIST */
#line 1495
struct f_inst * NONNULL(1)
#line 1495
f_new_method_FI_LCLIST_FILTER_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1495
  {
#line 1495
    /* Unwind the arguments (2) */
#line 1495
    #line 1490 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1490
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FILTER_LCLIST */
#line 1490
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1491 "filter/f-inst.c"

#line 1491

    return f_new_inst(FI_LCLIST_FILTER_LCLIST, obj
#line 1490 "filter/f-inst.c"
    , arg2
#line 1495 "filter/f-inst.c"

#line 1495
    );
#line 1495
  }
#line 1495

#line 1506 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FILTER_SET */
#line 1506
struct f_inst * NONNULL(1)
#line 1506
f_new_method_FI_LCLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1506
  {
#line 1506
    /* Unwind the arguments (2) */
#line 1506
    #line 1497 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1497
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FILTER_SET */
#line 1497
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1498 "filter/f-inst.c"

#line 1498

    return f_new_inst(FI_LCLIST_FILTER_SET, obj
#line 1497 "filter/f-inst.c"
    , arg2
#line 1506 "filter/f-inst.c"

#line 1506
    );
#line 1506
  }
#line 1506

#line 1528 "filter/f-inst.c"

#line 1544 "filter/f-inst.c"

#line 1559 "filter/f-inst.c"

#line 1564 "filter/f-inst.c"

#line 830 "filter/decl.m4"

#line 618 "filter/decl.m4"


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverride-init"
#endif

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Winitializer-overrides"
#endif

static struct sym_scope f_type_method_scopes[] = {
#line 507 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__type */
#line 507
  [T_NET] = {},
#line 510 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_IP__is_v4 */
#line 510
  [T_IP] = {},
#line 564 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__empty */
#line 564
  [T_PATH] = {},
#line 565 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__empty */
#line 565
  [T_CLIST] = {},
#line 566 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__empty */
#line 566
  [T_ECLIST] = {},
#line 569 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__empty */
#line 569
  [T_LCLIST] = {},
#line 600 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_FOR_NEXT */
#line 600
  [T_PATH] = {},
#line 609 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FOR_NEXT */
#line 609
  [T_CLIST] = {},
#line 618 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FOR_NEXT */
#line 618
  [T_ECLIST] = {},
#line 627 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FOR_NEXT */
#line 627
  [T_LCLIST] = {},
#line 640 "filter/f-inst.c"
 /* Method scope initializator for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  [T_ROUTES_BLOCK] = {},
#line 964 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__len */
#line 964
  [T_NET] = {},
#line 965 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__len */
#line 965
  [T_PATH] = {},
#line 966 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__len */
#line 966
  [T_CLIST] = {},
#line 967 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__len */
#line 967
  [T_ECLIST] = {},
#line 969 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__len */
#line 969
  [T_LCLIST] = {},
#line 1005 "filter/f-inst.c"
 /* Method scope initializator for FI_NET_SRC */
#line 1005
  [T_NET] = {},
#line 1042 "filter/f-inst.c"
 /* Method scope initializator for FI_NET_DST */
#line 1042
  [T_NET] = {},
#line 1052 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__maxlen */
#line 1052
  [T_NET] = {},
#line 1062 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__asn */
#line 1062
  [T_NET] = {},
#line 1064 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__ip */
#line 1064
  [T_NET] = {},
#line 1073 "filter/f-inst.c"
 /* Method scope initializator for FI_ROUTE_DISTINGUISHER */
#line 1073
  [T_NET] = {},
#line 1076 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__first */
#line 1076
  [T_PATH] = {},
#line 1079 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__last */
#line 1079
  [T_PATH] = {},
#line 1082 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
  [T_PATH] = {},
#line 1085 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PAIR__asn */
#line 1085
  [T_PAIR] = {},
#line 1088 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PAIR__data */
#line 1088
  [T_PAIR] = {},
#line 1091 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__asn */
#line 1091
  [T_LC] = {},
#line 1094 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__data1 */
#line 1094
  [T_LC] = {},
#line 1097 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__data2 */
#line 1097
  [T_LC] = {},
#line 1100 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__min */
#line 1100
  [T_CLIST] = {},
#line 1103 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__max */
#line 1103
  [T_CLIST] = {},
#line 1106 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__min */
#line 1106
  [T_ECLIST] = {},
#line 1109 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__max */
#line 1109
  [T_ECLIST] = {},
#line 1112 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__min */
#line 1112
  [T_LCLIST] = {},
#line 1114 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__max */
#line 1114
  [T_LCLIST] = {},
#line 1255 "filter/f-inst.c"
 /* Method scope initializator for FI_IP_MASK */
#line 1255
  [T_IP] = {},
#line 1263 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_PREPEND */
#line 1263
  [T_PATH] = {},
#line 1270 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_PAIR */
#line 1270
  [T_CLIST] = {},
#line 1284 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_IP */
#line 1284
  [T_CLIST] = {},
#line 1291 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_QUAD */
#line 1291
  [T_CLIST] = {},
#line 1298 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_CLIST */
#line 1298
  [T_CLIST] = {},
#line 1305 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_ADD_EC */
#line 1305
  [T_ECLIST] = {},
#line 1312 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_ADD_ECLIST */
#line 1312
  [T_ECLIST] = {},
#line 1319 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_ADD_LC */
#line 1319
  [T_LCLIST] = {},
#line 1326 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_ADD_LCLIST */
#line 1326
  [T_LCLIST] = {},
#line 1333 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_DELETE_INT */
#line 1333
  [T_PATH] = {},
#line 1345 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_DELETE_SET */
#line 1345
  [T_PATH] = {},
#line 1352 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_PAIR */
#line 1352
  [T_CLIST] = {},
#line 1366 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_IP */
#line 1366
  [T_CLIST] = {},
#line 1373 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_QUAD */
#line 1373
  [T_CLIST] = {},
#line 1380 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_CLIST */
#line 1380
  [T_CLIST] = {},
#line 1391 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_SET */
#line 1391
  [T_CLIST] = {},
#line 1398 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_EC */
#line 1398
  [T_ECLIST] = {},
#line 1405 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_ECLIST */
#line 1405
  [T_ECLIST] = {},
#line 1416 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_SET */
#line 1416
  [T_ECLIST] = {},
#line 1423 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_LC */
#line 1423
  [T_LCLIST] = {},
#line 1430 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_LCLIST */
#line 1430
  [T_LCLIST] = {},
#line 1441 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_SET */
#line 1441
  [T_LCLIST] = {},
#line 1452 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_FILTER_SET */
#line 1452
  [T_PATH] = {},
#line 1459 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FILTER_CLIST */
#line 1459
  [T_CLIST] = {},
#line 1470 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FILTER_SET */
#line 1470
  [T_CLIST] = {},
#line 1477 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FILTER_ECLIST */
#line 1477
  [T_ECLIST] = {},
#line 1488 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FILTER_SET */
#line 1488
  [T_ECLIST] = {},
#line 1495 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FILTER_LCLIST */
#line 1495
  [T_LCLIST] = {},
#line 1506 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FILTER_SET */
#line 1506
  [T_LCLIST] = {},
#line 631 "filter/decl.m4"

};

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic pop
#endif

struct sym_scope *f_type_method_scope(enum btype t)
{
  return (t < ARRAY_SIZE(f_type_method_scopes)) ? &f_type_method_scopes[t] : NULL;
}

static void
f_register_method(enum btype t, const byte *name, struct f_method *dsc)
{
  struct sym_scope *scope = &f_type_method_scopes[t];
  struct symbol *sym = cf_find_symbol_scope(scope, name);

  if (!sym)
  {
    sym = cf_root_symbol(name, scope);
    sym->class = SYM_METHOD;
  }

  dsc->sym = sym;
  dsc->next = sym->method;
  sym->method = dsc;
}

extern struct sym_scope global_filter_scope;

void f_type_methods_register(void)
{
  struct f_method *method;

#line 507 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__type */
#line 507
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 507
  method->new_inst = f_new_method_FI_METHOD__T_NET__type;
#line 507
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 507 "filter/f-inst.c"

#line 507
  f_register_method(T_NET, "type", method);
#line 507

#line 507

#line 510 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_IP__is_v4 */
#line 510
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 510
  method->new_inst = f_new_method_FI_METHOD__T_IP__is_v4;
#line 510
  method->arg_num = 1;
  method->args_type[0] = T_IP;
#line 510 "filter/f-inst.c"

#line 510
  f_register_method(T_IP, "is_v4", method);
#line 510

#line 510

#line 564 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__empty */
#line 564
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 564
  method->new_inst = f_new_method_FI_METHOD__T_PATH__empty;
#line 564
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 564 "filter/f-inst.c"

#line 564
  f_register_method(T_PATH, "empty", method);
#line 564

#line 564

#line 565 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__empty */
#line 565
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 565
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__empty;
#line 565
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 565 "filter/f-inst.c"

#line 565
  f_register_method(T_CLIST, "empty", method);
#line 565

#line 565

#line 566 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__empty */
#line 566
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 566
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__empty;
#line 566
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 566 "filter/f-inst.c"

#line 566
  f_register_method(T_ECLIST, "empty", method);
#line 566

#line 566

#line 569 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__empty */
#line 569
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 569
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__empty;
#line 569
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 569 "filter/f-inst.c"

#line 569
  f_register_method(T_LCLIST, "empty", method);
#line 569

#line 569

#line 600 "filter/f-inst.c"
 /* Method registrator for FI_PATH_FOR_NEXT */
#line 600
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 600
  method->new_inst = f_new_method_FI_PATH_FOR_NEXT;
#line 600
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
#line 600 "filter/f-inst.c"

#line 600
  f_register_method(T_PATH, "!for_next", method);
#line 600

#line 600

#line 609 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FOR_NEXT */
#line 609
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 609
  method->new_inst = f_new_method_FI_CLIST_FOR_NEXT;
#line 609
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
#line 609 "filter/f-inst.c"

#line 609
  f_register_method(T_CLIST, "!for_next", method);
#line 609

#line 609

#line 618 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FOR_NEXT */
#line 618
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 618
  method->new_inst = f_new_method_FI_ECLIST_FOR_NEXT;
#line 618
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
#line 618 "filter/f-inst.c"

#line 618
  f_register_method(T_ECLIST, "!for_next", method);
#line 618

#line 618

#line 627 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FOR_NEXT */
#line 627
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 627
  method->new_inst = f_new_method_FI_LCLIST_FOR_NEXT;
#line 627
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
#line 627 "filter/f-inst.c"

#line 627
  f_register_method(T_LCLIST, "!for_next", method);
#line 627

#line 627

#line 640 "filter/f-inst.c"
 /* Method registrator for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 640
  method->new_inst = f_new_method_FI_ROUTES_BLOCK_FOR_NEXT;
#line 640
  method->arg_num = 2;
  method->args_type[0] = T_ROUTES_BLOCK;
#line 640 "filter/f-inst.c"

#line 640
  f_register_method(T_ROUTES_BLOCK, "!for_next", method);
#line 640

#line 640

#line 964 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__len */
#line 964
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 964
  method->new_inst = f_new_method_FI_METHOD__T_NET__len;
#line 964
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 964 "filter/f-inst.c"

#line 964
  f_register_method(T_NET, "len", method);
#line 964

#line 964

#line 965 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__len */
#line 965
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 965
  method->new_inst = f_new_method_FI_METHOD__T_PATH__len;
#line 965
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 965 "filter/f-inst.c"

#line 965
  f_register_method(T_PATH, "len", method);
#line 965

#line 965

#line 966 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__len */
#line 966
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 966
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__len;
#line 966
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 966 "filter/f-inst.c"

#line 966
  f_register_method(T_CLIST, "len", method);
#line 966

#line 966

#line 967 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__len */
#line 967
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 967
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__len;
#line 967
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 967 "filter/f-inst.c"

#line 967
  f_register_method(T_ECLIST, "len", method);
#line 967

#line 967

#line 969 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__len */
#line 969
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 969
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__len;
#line 969
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 969 "filter/f-inst.c"

#line 969
  f_register_method(T_LCLIST, "len", method);
#line 969

#line 969

#line 1005 "filter/f-inst.c"
 /* Method registrator for FI_NET_SRC */
#line 1005
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1005
  method->new_inst = f_new_method_FI_NET_SRC;
#line 1005
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1005 "filter/f-inst.c"

#line 1005
  f_register_method(T_NET, "src", method);
#line 1005

#line 1005

#line 1042 "filter/f-inst.c"
 /* Method registrator for FI_NET_DST */
#line 1042
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1042
  method->new_inst = f_new_method_FI_NET_DST;
#line 1042
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1042 "filter/f-inst.c"

#line 1042
  f_register_method(T_NET, "dst", method);
#line 1042

#line 1042

#line 1052 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__maxlen */
#line 1052
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1052
  method->new_inst = f_new_method_FI_METHOD__T_NET__maxlen;
#line 1052
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1052 "filter/f-inst.c"

#line 1052
  f_register_method(T_NET, "maxlen", method);
#line 1052

#line 1052

#line 1062 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__asn */
#line 1062
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1062
  method->new_inst = f_new_method_FI_METHOD__T_NET__asn;
#line 1062
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1062 "filter/f-inst.c"

#line 1062
  f_register_method(T_NET, "asn", method);
#line 1062

#line 1062

#line 1064 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__ip */
#line 1064
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1064
  method->new_inst = f_new_method_FI_METHOD__T_NET__ip;
#line 1064
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1064 "filter/f-inst.c"

#line 1064
  f_register_method(T_NET, "ip", method);
#line 1064

#line 1064

#line 1073 "filter/f-inst.c"
 /* Method registrator for FI_ROUTE_DISTINGUISHER */
#line 1073
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1073
  method->new_inst = f_new_method_FI_ROUTE_DISTINGUISHER;
#line 1073
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1073 "filter/f-inst.c"

#line 1073
  f_register_method(T_NET, "rd", method);
#line 1073

#line 1073

#line 1076 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__first */
#line 1076
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1076
  method->new_inst = f_new_method_FI_METHOD__T_PATH__first;
#line 1076
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1076 "filter/f-inst.c"

#line 1076
  f_register_method(T_PATH, "first", method);
#line 1076

#line 1076

#line 1079 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__last */
#line 1079
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1079
  method->new_inst = f_new_method_FI_METHOD__T_PATH__last;
#line 1079
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1079 "filter/f-inst.c"

#line 1079
  f_register_method(T_PATH, "last", method);
#line 1079

#line 1079

#line 1082 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1082
  method->new_inst = f_new_method_FI_METHOD__T_PATH__last_nonaggregated;
#line 1082
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1082 "filter/f-inst.c"

#line 1082
  f_register_method(T_PATH, "last_nonaggregated", method);
#line 1082

#line 1082

#line 1085 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PAIR__asn */
#line 1085
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1085
  method->new_inst = f_new_method_FI_METHOD__T_PAIR__asn;
#line 1085
  method->arg_num = 1;
  method->args_type[0] = T_PAIR;
#line 1085 "filter/f-inst.c"

#line 1085
  f_register_method(T_PAIR, "asn", method);
#line 1085

#line 1085

#line 1088 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PAIR__data */
#line 1088
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1088
  method->new_inst = f_new_method_FI_METHOD__T_PAIR__data;
#line 1088
  method->arg_num = 1;
  method->args_type[0] = T_PAIR;
#line 1088 "filter/f-inst.c"

#line 1088
  f_register_method(T_PAIR, "data", method);
#line 1088

#line 1088

#line 1091 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__asn */
#line 1091
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1091
  method->new_inst = f_new_method_FI_METHOD__T_LC__asn;
#line 1091
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1091 "filter/f-inst.c"

#line 1091
  f_register_method(T_LC, "asn", method);
#line 1091

#line 1091

#line 1094 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__data1 */
#line 1094
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1094
  method->new_inst = f_new_method_FI_METHOD__T_LC__data1;
#line 1094
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1094 "filter/f-inst.c"

#line 1094
  f_register_method(T_LC, "data1", method);
#line 1094

#line 1094

#line 1097 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__data2 */
#line 1097
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1097
  method->new_inst = f_new_method_FI_METHOD__T_LC__data2;
#line 1097
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1097 "filter/f-inst.c"

#line 1097
  f_register_method(T_LC, "data2", method);
#line 1097

#line 1097

#line 1100 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__min */
#line 1100
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1100
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__min;
#line 1100
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 1100 "filter/f-inst.c"

#line 1100
  f_register_method(T_CLIST, "min", method);
#line 1100

#line 1100

#line 1103 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__max */
#line 1103
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1103
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__max;
#line 1103
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 1103 "filter/f-inst.c"

#line 1103
  f_register_method(T_CLIST, "max", method);
#line 1103

#line 1103

#line 1106 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__min */
#line 1106
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1106
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__min;
#line 1106
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1106 "filter/f-inst.c"

#line 1106
  f_register_method(T_ECLIST, "min", method);
#line 1106

#line 1106

#line 1109 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__max */
#line 1109
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1109
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__max;
#line 1109
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1109 "filter/f-inst.c"

#line 1109
  f_register_method(T_ECLIST, "max", method);
#line 1109

#line 1109

#line 1112 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__min */
#line 1112
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1112
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__min;
#line 1112
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1112 "filter/f-inst.c"

#line 1112
  f_register_method(T_LCLIST, "min", method);
#line 1112

#line 1112

#line 1114 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__max */
#line 1114
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1114
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__max;
#line 1114
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1114 "filter/f-inst.c"

#line 1114
  f_register_method(T_LCLIST, "max", method);
#line 1114

#line 1114

#line 1255 "filter/f-inst.c"
 /* Method registrator for FI_IP_MASK */
#line 1255
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1255
  method->new_inst = f_new_method_FI_IP_MASK;
#line 1255
  method->arg_num = 2;
  method->args_type[0] = T_IP;
  method->args_type[1] = T_INT;
#line 1255 "filter/f-inst.c"

#line 1255
  f_register_method(T_IP, "mask", method);
#line 1255

#line 1255

#line 1263 "filter/f-inst.c"
 /* Method registrator for FI_PATH_PREPEND */
#line 1263
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1263
  method->new_inst = f_new_method_FI_PATH_PREPEND;
#line 1263
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_INT;
#line 1263 "filter/f-inst.c"

#line 1263
  f_register_method(T_PATH, "prepend", method);
#line 1263

#line 1263

#line 1270 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_PAIR */
#line 1270
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1270
  method->new_inst = f_new_method_FI_CLIST_ADD_PAIR;
#line 1270
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_PAIR;
#line 1270 "filter/f-inst.c"

#line 1270
  f_register_method(T_CLIST, "add", method);
#line 1270

#line 1270

#line 1284 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_IP */
#line 1284
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1284
  method->new_inst = f_new_method_FI_CLIST_ADD_IP;
#line 1284
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_IP;
#line 1284 "filter/f-inst.c"

#line 1284
  f_register_method(T_CLIST, "add", method);
#line 1284

#line 1284

#line 1291 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_QUAD */
#line 1291
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1291
  method->new_inst = f_new_method_FI_CLIST_ADD_QUAD;
#line 1291
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_QUAD;
#line 1291 "filter/f-inst.c"

#line 1291
  f_register_method(T_CLIST, "add", method);
#line 1291

#line 1291

#line 1298 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_CLIST */
#line 1298
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1298
  method->new_inst = f_new_method_FI_CLIST_ADD_CLIST;
#line 1298
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1298 "filter/f-inst.c"

#line 1298
  f_register_method(T_CLIST, "add", method);
#line 1298

#line 1298

#line 1305 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_ADD_EC */
#line 1305
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1305
  method->new_inst = f_new_method_FI_ECLIST_ADD_EC;
#line 1305
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_EC;
#line 1305 "filter/f-inst.c"

#line 1305
  f_register_method(T_ECLIST, "add", method);
#line 1305

#line 1305

#line 1312 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_ADD_ECLIST */
#line 1312
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1312
  method->new_inst = f_new_method_FI_ECLIST_ADD_ECLIST;
#line 1312
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1312 "filter/f-inst.c"

#line 1312
  f_register_method(T_ECLIST, "add", method);
#line 1312

#line 1312

#line 1319 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_ADD_LC */
#line 1319
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1319
  method->new_inst = f_new_method_FI_LCLIST_ADD_LC;
#line 1319
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LC;
#line 1319 "filter/f-inst.c"

#line 1319
  f_register_method(T_LCLIST, "add", method);
#line 1319

#line 1319

#line 1326 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_ADD_LCLIST */
#line 1326
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1326
  method->new_inst = f_new_method_FI_LCLIST_ADD_LCLIST;
#line 1326
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1326 "filter/f-inst.c"

#line 1326
  f_register_method(T_LCLIST, "add", method);
#line 1326

#line 1326

#line 1333 "filter/f-inst.c"
 /* Method registrator for FI_PATH_DELETE_INT */
#line 1333
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1333
  method->new_inst = f_new_method_FI_PATH_DELETE_INT;
#line 1333
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_INT;
#line 1333 "filter/f-inst.c"

#line 1333
  f_register_method(T_PATH, "delete", method);
#line 1333

#line 1333

#line 1345 "filter/f-inst.c"
 /* Method registrator for FI_PATH_DELETE_SET */
#line 1345
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1345
  method->new_inst = f_new_method_FI_PATH_DELETE_SET;
#line 1345
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_SET;
#line 1345 "filter/f-inst.c"

#line 1345
  f_register_method(T_PATH, "delete", method);
#line 1345

#line 1345

#line 1352 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_PAIR */
#line 1352
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1352
  method->new_inst = f_new_method_FI_CLIST_DELETE_PAIR;
#line 1352
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_PAIR;
#line 1352 "filter/f-inst.c"

#line 1352
  f_register_method(T_CLIST, "delete", method);
#line 1352

#line 1352

#line 1366 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_IP */
#line 1366
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1366
  method->new_inst = f_new_method_FI_CLIST_DELETE_IP;
#line 1366
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_IP;
#line 1366 "filter/f-inst.c"

#line 1366
  f_register_method(T_CLIST, "delete", method);
#line 1366

#line 1366

#line 1373 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_QUAD */
#line 1373
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1373
  method->new_inst = f_new_method_FI_CLIST_DELETE_QUAD;
#line 1373
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_QUAD;
#line 1373 "filter/f-inst.c"

#line 1373
  f_register_method(T_CLIST, "delete", method);
#line 1373

#line 1373

#line 1380 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_CLIST */
#line 1380
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1380
  method->new_inst = f_new_method_FI_CLIST_DELETE_CLIST;
#line 1380
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1380 "filter/f-inst.c"

#line 1380
  f_register_method(T_CLIST, "delete", method);
#line 1380

#line 1380

#line 1391 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_SET */
#line 1391
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1391
  method->new_inst = f_new_method_FI_CLIST_DELETE_SET;
#line 1391
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_SET;
#line 1391 "filter/f-inst.c"

#line 1391
  f_register_method(T_CLIST, "delete", method);
#line 1391

#line 1391

#line 1398 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_EC */
#line 1398
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1398
  method->new_inst = f_new_method_FI_ECLIST_DELETE_EC;
#line 1398
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_EC;
#line 1398 "filter/f-inst.c"

#line 1398
  f_register_method(T_ECLIST, "delete", method);
#line 1398

#line 1398

#line 1405 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_ECLIST */
#line 1405
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1405
  method->new_inst = f_new_method_FI_ECLIST_DELETE_ECLIST;
#line 1405
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1405 "filter/f-inst.c"

#line 1405
  f_register_method(T_ECLIST, "delete", method);
#line 1405

#line 1405

#line 1416 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_SET */
#line 1416
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1416
  method->new_inst = f_new_method_FI_ECLIST_DELETE_SET;
#line 1416
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_SET;
#line 1416 "filter/f-inst.c"

#line 1416
  f_register_method(T_ECLIST, "delete", method);
#line 1416

#line 1416

#line 1423 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_LC */
#line 1423
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1423
  method->new_inst = f_new_method_FI_LCLIST_DELETE_LC;
#line 1423
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LC;
#line 1423 "filter/f-inst.c"

#line 1423
  f_register_method(T_LCLIST, "delete", method);
#line 1423

#line 1423

#line 1430 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_LCLIST */
#line 1430
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1430
  method->new_inst = f_new_method_FI_LCLIST_DELETE_LCLIST;
#line 1430
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1430 "filter/f-inst.c"

#line 1430
  f_register_method(T_LCLIST, "delete", method);
#line 1430

#line 1430

#line 1441 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_SET */
#line 1441
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1441
  method->new_inst = f_new_method_FI_LCLIST_DELETE_SET;
#line 1441
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_SET;
#line 1441 "filter/f-inst.c"

#line 1441
  f_register_method(T_LCLIST, "delete", method);
#line 1441

#line 1441

#line 1452 "filter/f-inst.c"
 /* Method registrator for FI_PATH_FILTER_SET */
#line 1452
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1452
  method->new_inst = f_new_method_FI_PATH_FILTER_SET;
#line 1452
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_SET;
#line 1452 "filter/f-inst.c"

#line 1452
  f_register_method(T_PATH, "filter", method);
#line 1452

#line 1452

#line 1459 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FILTER_CLIST */
#line 1459
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1459
  method->new_inst = f_new_method_FI_CLIST_FILTER_CLIST;
#line 1459
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1459 "filter/f-inst.c"

#line 1459
  f_register_method(T_CLIST, "filter", method);
#line 1459

#line 1459

#line 1470 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FILTER_SET */
#line 1470
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1470
  method->new_inst = f_new_method_FI_CLIST_FILTER_SET;
#line 1470
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_SET;
#line 1470 "filter/f-inst.c"

#line 1470
  f_register_method(T_CLIST, "filter", method);
#line 1470

#line 1470

#line 1477 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FILTER_ECLIST */
#line 1477
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1477
  method->new_inst = f_new_method_FI_ECLIST_FILTER_ECLIST;
#line 1477
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1477 "filter/f-inst.c"

#line 1477
  f_register_method(T_ECLIST, "filter", method);
#line 1477

#line 1477

#line 1488 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FILTER_SET */
#line 1488
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1488
  method->new_inst = f_new_method_FI_ECLIST_FILTER_SET;
#line 1488
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_SET;
#line 1488 "filter/f-inst.c"

#line 1488
  f_register_method(T_ECLIST, "filter", method);
#line 1488

#line 1488

#line 1495 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FILTER_LCLIST */
#line 1495
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1495
  method->new_inst = f_new_method_FI_LCLIST_FILTER_LCLIST;
#line 1495
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1495 "filter/f-inst.c"

#line 1495
  f_register_method(T_LCLIST, "filter", method);
#line 1495

#line 1495

#line 1506 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FILTER_SET */
#line 1506
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1506
  method->new_inst = f_new_method_FI_LCLIST_FILTER_SET;
#line 1506
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_SET;
#line 1506 "filter/f-inst.c"

#line 1506
  f_register_method(T_LCLIST, "filter", method);
#line 1506

#line 1506

#line 670 "filter/decl.m4"


  for (uint i = 0; i < ARRAY_SIZE(f_type_method_scopes); i++)
    f_type_method_scopes[i].readonly = 1;

  f_type_method_scopes[T_ROUTE].next = &global_filter_scope;
}

/* Line dumpers */
#define INDENT (((const char *) f_dump_line_indent_str) + sizeof(f_dump_line_indent_str) - (indent) - 1)
static const char f_dump_line_indent_str[] = "                                ";

#line 288 "filter/f-inst.c"
 /* Dump line for FI_ADD */
#line 288
static inline void f_dump_line_item_FI_ADD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 288

#line 288
{
#line 288
#define item (&(item_->i_FI_ADD))
#line 288
#undef item
#line 288
}
#line 288

#line 293 "filter/f-inst.c"
 /* Dump line for FI_SUBTRACT */
#line 293
static inline void f_dump_line_item_FI_SUBTRACT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 293

#line 293
{
#line 293
#define item (&(item_->i_FI_SUBTRACT))
#line 293
#undef item
#line 293
}
#line 293

#line 298 "filter/f-inst.c"
 /* Dump line for FI_MULTIPLY */
#line 298
static inline void f_dump_line_item_FI_MULTIPLY(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 298

#line 298
{
#line 298
#define item (&(item_->i_FI_MULTIPLY))
#line 298
#undef item
#line 298
}
#line 298

#line 304 "filter/f-inst.c"
 /* Dump line for FI_DIVIDE */
#line 304
static inline void f_dump_line_item_FI_DIVIDE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 304

#line 304
{
#line 304
#define item (&(item_->i_FI_DIVIDE))
#line 304
#undef item
#line 304
}
#line 304

#line 309 "filter/f-inst.c"
 /* Dump line for FI_BITOR */
#line 309
static inline void f_dump_line_item_FI_BITOR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 309

#line 309
{
#line 309
#define item (&(item_->i_FI_BITOR))
#line 309
#undef item
#line 309
}
#line 309

#line 314 "filter/f-inst.c"
 /* Dump line for FI_BITAND */
#line 314
static inline void f_dump_line_item_FI_BITAND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 314

#line 314
{
#line 314
#define item (&(item_->i_FI_BITAND))
#line 314
#undef item
#line 314
}
#line 314

#line 324 "filter/f-inst.c"
 /* Dump line for FI_AND */
#line 324
static inline void f_dump_line_item_FI_AND(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 324

#line 324
{
#line 324
#define item (&(item_->i_FI_AND))
#line 320 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 324 "filter/f-inst.c"
#undef item
#line 324
}
#line 324

#line 335 "filter/f-inst.c"
 /* Dump line for FI_OR */
#line 335
static inline void f_dump_line_item_FI_OR(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 335

#line 335
{
#line 335
#define item (&(item_->i_FI_OR))
#line 330 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 335 "filter/f-inst.c"
#undef item
#line 335
}
#line 335

#line 345 "filter/f-inst.c"
 /* Dump line for FI_PAIR_CONSTRUCT */
#line 345
static inline void f_dump_line_item_FI_PAIR_CONSTRUCT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 345

#line 345
{
#line 345
#define item (&(item_->i_FI_PAIR_CONSTRUCT))
#line 345
#undef item
#line 345
}
#line 345

#line 385 "filter/f-inst.c"
 /* Dump line for FI_EC_CONSTRUCT */
#line 385
static inline void f_dump_line_item_FI_EC_CONSTRUCT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 385

#line 385
{
#line 385
#define item (&(item_->i_FI_EC_CONSTRUCT))
#line 349 "filter/f-inst.c"
RDUMP("%s" "ec subtype %s" "\n", INDENT, ec_subtype_str(item->ecs));
#line 349

#line 385 "filter/f-inst.c"
#undef item
#line 385
}
#line 385

#line 392 "filter/f-inst.c"
 /* Dump line for FI_LC_CONSTRUCT */
#line 392
static inline void f_dump_line_item_FI_LC_CONSTRUCT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 392

#line 392
{
#line 392
#define item (&(item_->i_FI_LC_CONSTRUCT))
#line 392
#undef item
#line 392
}
#line 392

#line 442 "filter/f-inst.c"
 /* Dump line for FI_PATHMASK_CONSTRUCT */
#line 442
static inline void f_dump_line_item_FI_PATHMASK_CONSTRUCT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 442

#line 442
{
#line 442
#define item (&(item_->i_FI_PATHMASK_CONSTRUCT))
#line 393 "filter/f-inst.c"
  RDUMP("%snumber of varargs %u\n", INDENT, item->varcount);
#line 442 "filter/f-inst.c"
#undef item
#line 442
}
#line 442

#line 449 "filter/f-inst.c"
 /* Dump line for FI_NEQ */
#line 449
static inline void f_dump_line_item_FI_NEQ(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 449

#line 449
{
#line 449
#define item (&(item_->i_FI_NEQ))
#line 449
#undef item
#line 449
}
#line 449

#line 456 "filter/f-inst.c"
 /* Dump line for FI_EQ */
#line 456
static inline void f_dump_line_item_FI_EQ(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 456

#line 456
{
#line 456
#define item (&(item_->i_FI_EQ))
#line 456
#undef item
#line 456
}
#line 456

#line 467 "filter/f-inst.c"
 /* Dump line for FI_LT */
#line 467
static inline void f_dump_line_item_FI_LT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 467

#line 467
{
#line 467
#define item (&(item_->i_FI_LT))
#line 467
#undef item
#line 467
}
#line 467

#line 478 "filter/f-inst.c"
 /* Dump line for FI_LTE */
#line 478
static inline void f_dump_line_item_FI_LTE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 478

#line 478
{
#line 478
#define item (&(item_->i_FI_LTE))
#line 478
#undef item
#line 478
}
#line 478

#line 483 "filter/f-inst.c"
 /* Dump line for FI_NOT */
#line 483
static inline void f_dump_line_item_FI_NOT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 483

#line 483
{
#line 483
#define item (&(item_->i_FI_NOT))
#line 483
#undef item
#line 483
}
#line 483

#line 492 "filter/f-inst.c"
 /* Dump line for FI_MATCH */
#line 492
static inline void f_dump_line_item_FI_MATCH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 492

#line 492
{
#line 492
#define item (&(item_->i_FI_MATCH))
#line 492
#undef item
#line 492
}
#line 492

#line 501 "filter/f-inst.c"
 /* Dump line for FI_NOT_MATCH */
#line 501
static inline void f_dump_line_item_FI_NOT_MATCH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 501

#line 501
{
#line 501
#define item (&(item_->i_FI_NOT_MATCH))
#line 501
#undef item
#line 501
}
#line 501

#line 506 "filter/f-inst.c"
 /* Dump line for FI_DEFINED */
#line 506
static inline void f_dump_line_item_FI_DEFINED(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 506

#line 506
{
#line 506
#define item (&(item_->i_FI_DEFINED))
#line 506
#undef item
#line 506
}
#line 506

#line 507 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__type */
#line 507
static inline void f_dump_line_item_FI_METHOD__T_NET__type(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 507

#line 507
{
#line 507
#define item (&(item_->i_FI_METHOD__T_NET__type))
#line 507
#undef item
#line 507
}
#line 507

#line 510 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_IP__is_v4 */
#line 510
static inline void f_dump_line_item_FI_METHOD__T_IP__is_v4(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 510

#line 510
{
#line 510
#define item (&(item_->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef item
#line 510
}
#line 510

#line 523 "filter/f-inst.c"
 /* Dump line for FI_VAR_INIT */
#line 523
static inline void f_dump_line_item_FI_VAR_INIT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 523

#line 523
{
#line 523
#define item (&(item_->i_FI_VAR_INIT))
#line 513 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 513

#line 523 "filter/f-inst.c"
#undef item
#line 523
}
#line 523

#line 534 "filter/f-inst.c"
 /* Dump line for FI_VAR_INIT0 */
#line 534
static inline void f_dump_line_item_FI_VAR_INIT0(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 534

#line 534
{
#line 534
#define item (&(item_->i_FI_VAR_INIT0))
#line 525 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 525

#line 534 "filter/f-inst.c"
#undef item
#line 534
}
#line 534

#line 543 "filter/f-inst.c"
 /* Dump line for FI_VAR_SET */
#line 543
static inline void f_dump_line_item_FI_VAR_SET(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 543

#line 543
{
#line 543
#define item (&(item_->i_FI_VAR_SET))
#line 537 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 537

#line 543 "filter/f-inst.c"
#undef item
#line 543
}
#line 543

#line 550 "filter/f-inst.c"
 /* Dump line for FI_VAR_GET */
#line 550
static inline void f_dump_line_item_FI_VAR_GET(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 550

#line 550
{
#line 550
#define item (&(item_->i_FI_VAR_GET))
#line 544 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 544

#line 550 "filter/f-inst.c"
#undef item
#line 550
}
#line 550

#line 563 "filter/f-inst.c"
 /* Dump line for FI_CONSTANT */
#line 563
static inline void f_dump_line_item_FI_CONSTANT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 563

#line 563
{
#line 563
#define item (&(item_->i_FI_CONSTANT))
#line 551 "filter/f-inst.c"
RDUMP("%s" "value %s" "\n", INDENT, val_dump(&(item->val))
#line 551
    );
#line 551

#line 563 "filter/f-inst.c"
#undef item
#line 563
}
#line 563

#line 564 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__empty */
#line 564
static inline void f_dump_line_item_FI_METHOD__T_PATH__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 564

#line 564
{
#line 564
#define item (&(item_->i_FI_METHOD__T_PATH__empty))
#line 564
#undef item
#line 564
}
#line 564

#line 565 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__empty */
#line 565
static inline void f_dump_line_item_FI_METHOD__T_CLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 565

#line 565
{
#line 565
#define item (&(item_->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef item
#line 565
}
#line 565

#line 566 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__empty */
#line 566
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 566

#line 566
{
#line 566
#define item (&(item_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef item
#line 566
}
#line 566

#line 569 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__empty */
#line 569
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 569

#line 569
{
#line 569
#define item (&(item_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef item
#line 569
}
#line 569

#line 591 "filter/f-inst.c"
 /* Dump line for FI_FOR_LOOP_START */
#line 591
static inline void f_dump_line_item_FI_FOR_LOOP_START(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 591

#line 591
{
#line 591
#define item (&(item_->i_FI_FOR_LOOP_START))
#line 571 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 571

#line 591 "filter/f-inst.c"
#undef item
#line 591
}
#line 591

#line 600 "filter/f-inst.c"
 /* Dump line for FI_PATH_FOR_NEXT */
#line 600
static inline void f_dump_line_item_FI_PATH_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 600

#line 600
{
#line 600
#define item (&(item_->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 600 "filter/f-inst.c"
#undef item
#line 600
}
#line 600

#line 609 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FOR_NEXT */
#line 609
static inline void f_dump_line_item_FI_CLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 609

#line 609
{
#line 609
#define item (&(item_->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 609 "filter/f-inst.c"
#undef item
#line 609
}
#line 609

#line 618 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FOR_NEXT */
#line 618
static inline void f_dump_line_item_FI_ECLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 618

#line 618
{
#line 618
#define item (&(item_->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 618 "filter/f-inst.c"
#undef item
#line 618
}
#line 618

#line 627 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FOR_NEXT */
#line 627
static inline void f_dump_line_item_FI_LCLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 627

#line 627
{
#line 627
#define item (&(item_->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 627 "filter/f-inst.c"
#undef item
#line 627
}
#line 627

#line 640 "filter/f-inst.c"
 /* Dump line for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
static inline void f_dump_line_item_FI_ROUTES_BLOCK_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 640

#line 640
{
#line 640
#define item (&(item_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 640 "filter/f-inst.c"
#undef item
#line 640
}
#line 640

#line 648 "filter/f-inst.c"
 /* Dump line for FI_CONDITION */
#line 648
static inline void f_dump_line_item_FI_CONDITION(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 648

#line 648
{
#line 648
#define item (&(item_->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 645 "filter/f-inst.c"
f_dump_line(dreq, item->fl3, indent + 1);
#line 648 "filter/f-inst.c"
#undef item
#line 648
}
#line 648

#line 661 "filter/f-inst.c"
 /* Dump line for FI_PRINT */
#line 661
static inline void f_dump_line_item_FI_PRINT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 661

#line 661
{
#line 661
#define item (&(item_->i_FI_PRINT))
#line 661
#undef item
#line 661
}
#line 661

#line 668 "filter/f-inst.c"
 /* Dump line for FI_FLUSH */
#line 668
static inline void f_dump_line_item_FI_FLUSH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 668

#line 668
{
#line 668
#define item (&(item_->i_FI_FLUSH))
#line 668
#undef item
#line 668
}
#line 668

#line 682 "filter/f-inst.c"
 /* Dump line for FI_DIE */
#line 682
static inline void f_dump_line_item_FI_DIE(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 682

#line 682
{
#line 682
#define item (&(item_->i_FI_DIE))
#line 670 "filter/f-inst.c"
RDUMP("%s" "%s" "\n", INDENT, filter_return_str(item->fret));
#line 670

#line 682 "filter/f-inst.c"
#undef item
#line 682
}
#line 682

#line 689 "filter/f-inst.c"
 /* Dump line for FI_CURRENT_ROUTE */
#line 689
static inline void f_dump_line_item_FI_CURRENT_ROUTE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 689

#line 689
{
#line 689
#define item (&(item_->i_FI_CURRENT_ROUTE))
#line 689
#undef item
#line 689
}
#line 689

#line 736 "filter/f-inst.c"
 /* Dump line for FI_RTA_GET */
#line 736
static inline void f_dump_line_item_FI_RTA_GET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 736

#line 736
{
#line 736
#define item (&(item_->i_FI_RTA_GET))
#line 736
#undef item
#line 736
}
#line 736

#line 864 "filter/f-inst.c"
 /* Dump line for FI_RTA_SET */
#line 864
static inline void f_dump_line_item_FI_RTA_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 864

#line 864
{
#line 864
#define item (&(item_->i_FI_RTA_SET))
#line 864
#undef item
#line 864
}
#line 864

#line 901 "filter/f-inst.c"
 /* Dump line for FI_EA_GET */
#line 901
static inline void f_dump_line_item_FI_EA_GET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 901

#line 901
{
#line 901
#define item (&(item_->i_FI_EA_GET))
#line 901
#undef item
#line 901
}
#line 901

#line 942 "filter/f-inst.c"
 /* Dump line for FI_EA_SET */
#line 942
static inline void f_dump_line_item_FI_EA_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 942

#line 942
{
#line 942
#define item (&(item_->i_FI_EA_SET))
#line 942
#undef item
#line 942
}
#line 942

#line 949 "filter/f-inst.c"
 /* Dump line for FI_EA_UNSET */
#line 949
static inline void f_dump_line_item_FI_EA_UNSET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 949

#line 949
{
#line 949
#define item (&(item_->i_FI_EA_UNSET))
#line 949
#undef item
#line 949
}
#line 949

#line 963 "filter/f-inst.c"
 /* Dump line for FI_DEFAULT */
#line 963
static inline void f_dump_line_item_FI_DEFAULT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 963

#line 963
{
#line 963
#define item (&(item_->i_FI_DEFAULT))
#line 963
#undef item
#line 963
}
#line 963

#line 964 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__len */
#line 964
static inline void f_dump_line_item_FI_METHOD__T_NET__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 964

#line 964
{
#line 964
#define item (&(item_->i_FI_METHOD__T_NET__len))
#line 964
#undef item
#line 964
}
#line 964

#line 965 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__len */
#line 965
static inline void f_dump_line_item_FI_METHOD__T_PATH__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 965

#line 965
{
#line 965
#define item (&(item_->i_FI_METHOD__T_PATH__len))
#line 965
#undef item
#line 965
}
#line 965

#line 966 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__len */
#line 966
static inline void f_dump_line_item_FI_METHOD__T_CLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 966

#line 966
{
#line 966
#define item (&(item_->i_FI_METHOD__T_CLIST__len))
#line 966
#undef item
#line 966
}
#line 966

#line 967 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__len */
#line 967
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 967

#line 967
{
#line 967
#define item (&(item_->i_FI_METHOD__T_ECLIST__len))
#line 967
#undef item
#line 967
}
#line 967

#line 969 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__len */
#line 969
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 969

#line 969
{
#line 969
#define item (&(item_->i_FI_METHOD__T_LCLIST__len))
#line 969
#undef item
#line 969
}
#line 969

#line 1005 "filter/f-inst.c"
 /* Dump line for FI_NET_SRC */
#line 1005
static inline void f_dump_line_item_FI_NET_SRC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1005

#line 1005
{
#line 1005
#define item (&(item_->i_FI_NET_SRC))
#line 1005
#undef item
#line 1005
}
#line 1005

#line 1042 "filter/f-inst.c"
 /* Dump line for FI_NET_DST */
#line 1042
static inline void f_dump_line_item_FI_NET_DST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1042

#line 1042
{
#line 1042
#define item (&(item_->i_FI_NET_DST))
#line 1042
#undef item
#line 1042
}
#line 1042

#line 1052 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__maxlen */
#line 1052
static inline void f_dump_line_item_FI_METHOD__T_NET__maxlen(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1052

#line 1052
{
#line 1052
#define item (&(item_->i_FI_METHOD__T_NET__maxlen))
#line 1052
#undef item
#line 1052
}
#line 1052

#line 1062 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__asn */
#line 1062
static inline void f_dump_line_item_FI_METHOD__T_NET__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1062

#line 1062
{
#line 1062
#define item (&(item_->i_FI_METHOD__T_NET__asn))
#line 1062
#undef item
#line 1062
}
#line 1062

#line 1064 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__ip */
#line 1064
static inline void f_dump_line_item_FI_METHOD__T_NET__ip(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1064

#line 1064
{
#line 1064
#define item (&(item_->i_FI_METHOD__T_NET__ip))
#line 1064
#undef item
#line 1064
}
#line 1064

#line 1073 "filter/f-inst.c"
 /* Dump line for FI_ROUTE_DISTINGUISHER */
#line 1073
static inline void f_dump_line_item_FI_ROUTE_DISTINGUISHER(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1073

#line 1073
{
#line 1073
#define item (&(item_->i_FI_ROUTE_DISTINGUISHER))
#line 1073
#undef item
#line 1073
}
#line 1073

#line 1076 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__first */
#line 1076
static inline void f_dump_line_item_FI_METHOD__T_PATH__first(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1076

#line 1076
{
#line 1076
#define item (&(item_->i_FI_METHOD__T_PATH__first))
#line 1076
#undef item
#line 1076
}
#line 1076

#line 1079 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__last */
#line 1079
static inline void f_dump_line_item_FI_METHOD__T_PATH__last(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1079

#line 1079
{
#line 1079
#define item (&(item_->i_FI_METHOD__T_PATH__last))
#line 1079
#undef item
#line 1079
}
#line 1079

#line 1082 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
static inline void f_dump_line_item_FI_METHOD__T_PATH__last_nonaggregated(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1082

#line 1082
{
#line 1082
#define item (&(item_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
#undef item
#line 1082
}
#line 1082

#line 1085 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PAIR__asn */
#line 1085
static inline void f_dump_line_item_FI_METHOD__T_PAIR__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1085

#line 1085
{
#line 1085
#define item (&(item_->i_FI_METHOD__T_PAIR__asn))
#line 1085
#undef item
#line 1085
}
#line 1085

#line 1088 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PAIR__data */
#line 1088
static inline void f_dump_line_item_FI_METHOD__T_PAIR__data(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1088

#line 1088
{
#line 1088
#define item (&(item_->i_FI_METHOD__T_PAIR__data))
#line 1088
#undef item
#line 1088
}
#line 1088

#line 1091 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__asn */
#line 1091
static inline void f_dump_line_item_FI_METHOD__T_LC__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1091

#line 1091
{
#line 1091
#define item (&(item_->i_FI_METHOD__T_LC__asn))
#line 1091
#undef item
#line 1091
}
#line 1091

#line 1094 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__data1 */
#line 1094
static inline void f_dump_line_item_FI_METHOD__T_LC__data1(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1094

#line 1094
{
#line 1094
#define item (&(item_->i_FI_METHOD__T_LC__data1))
#line 1094
#undef item
#line 1094
}
#line 1094

#line 1097 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__data2 */
#line 1097
static inline void f_dump_line_item_FI_METHOD__T_LC__data2(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1097

#line 1097
{
#line 1097
#define item (&(item_->i_FI_METHOD__T_LC__data2))
#line 1097
#undef item
#line 1097
}
#line 1097

#line 1100 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__min */
#line 1100
static inline void f_dump_line_item_FI_METHOD__T_CLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1100

#line 1100
{
#line 1100
#define item (&(item_->i_FI_METHOD__T_CLIST__min))
#line 1100
#undef item
#line 1100
}
#line 1100

#line 1103 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__max */
#line 1103
static inline void f_dump_line_item_FI_METHOD__T_CLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1103

#line 1103
{
#line 1103
#define item (&(item_->i_FI_METHOD__T_CLIST__max))
#line 1103
#undef item
#line 1103
}
#line 1103

#line 1106 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__min */
#line 1106
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1106

#line 1106
{
#line 1106
#define item (&(item_->i_FI_METHOD__T_ECLIST__min))
#line 1106
#undef item
#line 1106
}
#line 1106

#line 1109 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__max */
#line 1109
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1109

#line 1109
{
#line 1109
#define item (&(item_->i_FI_METHOD__T_ECLIST__max))
#line 1109
#undef item
#line 1109
}
#line 1109

#line 1112 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__min */
#line 1112
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1112

#line 1112
{
#line 1112
#define item (&(item_->i_FI_METHOD__T_LCLIST__min))
#line 1112
#undef item
#line 1112
}
#line 1112

#line 1114 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__max */
#line 1114
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1114

#line 1114
{
#line 1114
#define item (&(item_->i_FI_METHOD__T_LCLIST__max))
#line 1114
#undef item
#line 1114
}
#line 1114

#line 1140 "filter/f-inst.c"
 /* Dump line for FI_RETURN */
#line 1140
static inline void f_dump_line_item_FI_RETURN(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1140

#line 1140
{
#line 1140
#define item (&(item_->i_FI_RETURN))
#line 1140
#undef item
#line 1140
}
#line 1140

#line 1200 "filter/f-inst.c"
 /* Dump line for FI_CALL */
#line 1200
static inline void f_dump_line_item_FI_CALL(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1200

#line 1200
{
#line 1200
#define item (&(item_->i_FI_CALL))
#line 1142 "filter/f-inst.c"
  RDUMP("%snumber of varargs %u\n", INDENT, item->varcount);
#line 1143 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 1143

#line 1200 "filter/f-inst.c"
#undef item
#line 1200
}
#line 1200

#line 1205 "filter/f-inst.c"
 /* Dump line for FI_DROP_RESULT */
#line 1205
static inline void f_dump_line_item_FI_DROP_RESULT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1205

#line 1205
{
#line 1205
#define item (&(item_->i_FI_DROP_RESULT))
#line 1205
#undef item
#line 1205
}
#line 1205

#line 1246 "filter/f-inst.c"
 /* Dump line for FI_SWITCH */
#line 1246
static inline void f_dump_line_item_FI_SWITCH(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1246

#line 1246
{
#line 1246
#define item (&(item_->i_FI_SWITCH))
#line 1208 "filter/f-inst.c"
RDUMP("%s" "tree %p" "\n", INDENT, item->tree);
#line 1208

#line 1246 "filter/f-inst.c"
#undef item
#line 1246
}
#line 1246

#line 1255 "filter/f-inst.c"
 /* Dump line for FI_IP_MASK */
#line 1255
static inline void f_dump_line_item_FI_IP_MASK(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1255

#line 1255
{
#line 1255
#define item (&(item_->i_FI_IP_MASK))
#line 1255
#undef item
#line 1255
}
#line 1255

#line 1263 "filter/f-inst.c"
 /* Dump line for FI_PATH_PREPEND */
#line 1263
static inline void f_dump_line_item_FI_PATH_PREPEND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1263

#line 1263
{
#line 1263
#define item (&(item_->i_FI_PATH_PREPEND))
#line 1263
#undef item
#line 1263
}
#line 1263

#line 1270 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_PAIR */
#line 1270
static inline void f_dump_line_item_FI_CLIST_ADD_PAIR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1270

#line 1270
{
#line 1270
#define item (&(item_->i_FI_CLIST_ADD_PAIR))
#line 1270
#undef item
#line 1270
}
#line 1270

#line 1284 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_IP */
#line 1284
static inline void f_dump_line_item_FI_CLIST_ADD_IP(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1284

#line 1284
{
#line 1284
#define item (&(item_->i_FI_CLIST_ADD_IP))
#line 1284
#undef item
#line 1284
}
#line 1284

#line 1291 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_QUAD */
#line 1291
static inline void f_dump_line_item_FI_CLIST_ADD_QUAD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1291

#line 1291
{
#line 1291
#define item (&(item_->i_FI_CLIST_ADD_QUAD))
#line 1291
#undef item
#line 1291
}
#line 1291

#line 1298 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_CLIST */
#line 1298
static inline void f_dump_line_item_FI_CLIST_ADD_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1298

#line 1298
{
#line 1298
#define item (&(item_->i_FI_CLIST_ADD_CLIST))
#line 1298
#undef item
#line 1298
}
#line 1298

#line 1305 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_ADD_EC */
#line 1305
static inline void f_dump_line_item_FI_ECLIST_ADD_EC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1305

#line 1305
{
#line 1305
#define item (&(item_->i_FI_ECLIST_ADD_EC))
#line 1305
#undef item
#line 1305
}
#line 1305

#line 1312 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_ADD_ECLIST */
#line 1312
static inline void f_dump_line_item_FI_ECLIST_ADD_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1312

#line 1312
{
#line 1312
#define item (&(item_->i_FI_ECLIST_ADD_ECLIST))
#line 1312
#undef item
#line 1312
}
#line 1312

#line 1319 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_ADD_LC */
#line 1319
static inline void f_dump_line_item_FI_LCLIST_ADD_LC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1319

#line 1319
{
#line 1319
#define item (&(item_->i_FI_LCLIST_ADD_LC))
#line 1319
#undef item
#line 1319
}
#line 1319

#line 1326 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_ADD_LCLIST */
#line 1326
static inline void f_dump_line_item_FI_LCLIST_ADD_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1326

#line 1326
{
#line 1326
#define item (&(item_->i_FI_LCLIST_ADD_LCLIST))
#line 1326
#undef item
#line 1326
}
#line 1326

#line 1333 "filter/f-inst.c"
 /* Dump line for FI_PATH_DELETE_INT */
#line 1333
static inline void f_dump_line_item_FI_PATH_DELETE_INT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1333

#line 1333
{
#line 1333
#define item (&(item_->i_FI_PATH_DELETE_INT))
#line 1333
#undef item
#line 1333
}
#line 1333

#line 1345 "filter/f-inst.c"
 /* Dump line for FI_PATH_DELETE_SET */
#line 1345
static inline void f_dump_line_item_FI_PATH_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1345

#line 1345
{
#line 1345
#define item (&(item_->i_FI_PATH_DELETE_SET))
#line 1345
#undef item
#line 1345
}
#line 1345

#line 1352 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_PAIR */
#line 1352
static inline void f_dump_line_item_FI_CLIST_DELETE_PAIR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1352

#line 1352
{
#line 1352
#define item (&(item_->i_FI_CLIST_DELETE_PAIR))
#line 1352
#undef item
#line 1352
}
#line 1352

#line 1366 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_IP */
#line 1366
static inline void f_dump_line_item_FI_CLIST_DELETE_IP(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1366

#line 1366
{
#line 1366
#define item (&(item_->i_FI_CLIST_DELETE_IP))
#line 1366
#undef item
#line 1366
}
#line 1366

#line 1373 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_QUAD */
#line 1373
static inline void f_dump_line_item_FI_CLIST_DELETE_QUAD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1373

#line 1373
{
#line 1373
#define item (&(item_->i_FI_CLIST_DELETE_QUAD))
#line 1373
#undef item
#line 1373
}
#line 1373

#line 1380 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_CLIST */
#line 1380
static inline void f_dump_line_item_FI_CLIST_DELETE_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1380

#line 1380
{
#line 1380
#define item (&(item_->i_FI_CLIST_DELETE_CLIST))
#line 1380
#undef item
#line 1380
}
#line 1380

#line 1391 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_SET */
#line 1391
static inline void f_dump_line_item_FI_CLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1391

#line 1391
{
#line 1391
#define item (&(item_->i_FI_CLIST_DELETE_SET))
#line 1391
#undef item
#line 1391
}
#line 1391

#line 1398 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_EC */
#line 1398
static inline void f_dump_line_item_FI_ECLIST_DELETE_EC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1398

#line 1398
{
#line 1398
#define item (&(item_->i_FI_ECLIST_DELETE_EC))
#line 1398
#undef item
#line 1398
}
#line 1398

#line 1405 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_ECLIST */
#line 1405
static inline void f_dump_line_item_FI_ECLIST_DELETE_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1405

#line 1405
{
#line 1405
#define item (&(item_->i_FI_ECLIST_DELETE_ECLIST))
#line 1405
#undef item
#line 1405
}
#line 1405

#line 1416 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_SET */
#line 1416
static inline void f_dump_line_item_FI_ECLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1416

#line 1416
{
#line 1416
#define item (&(item_->i_FI_ECLIST_DELETE_SET))
#line 1416
#undef item
#line 1416
}
#line 1416

#line 1423 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_LC */
#line 1423
static inline void f_dump_line_item_FI_LCLIST_DELETE_LC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1423

#line 1423
{
#line 1423
#define item (&(item_->i_FI_LCLIST_DELETE_LC))
#line 1423
#undef item
#line 1423
}
#line 1423

#line 1430 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_LCLIST */
#line 1430
static inline void f_dump_line_item_FI_LCLIST_DELETE_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1430

#line 1430
{
#line 1430
#define item (&(item_->i_FI_LCLIST_DELETE_LCLIST))
#line 1430
#undef item
#line 1430
}
#line 1430

#line 1441 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_SET */
#line 1441
static inline void f_dump_line_item_FI_LCLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1441

#line 1441
{
#line 1441
#define item (&(item_->i_FI_LCLIST_DELETE_SET))
#line 1441
#undef item
#line 1441
}
#line 1441

#line 1452 "filter/f-inst.c"
 /* Dump line for FI_PATH_FILTER_SET */
#line 1452
static inline void f_dump_line_item_FI_PATH_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1452

#line 1452
{
#line 1452
#define item (&(item_->i_FI_PATH_FILTER_SET))
#line 1452
#undef item
#line 1452
}
#line 1452

#line 1459 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FILTER_CLIST */
#line 1459
static inline void f_dump_line_item_FI_CLIST_FILTER_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1459

#line 1459
{
#line 1459
#define item (&(item_->i_FI_CLIST_FILTER_CLIST))
#line 1459
#undef item
#line 1459
}
#line 1459

#line 1470 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FILTER_SET */
#line 1470
static inline void f_dump_line_item_FI_CLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1470

#line 1470
{
#line 1470
#define item (&(item_->i_FI_CLIST_FILTER_SET))
#line 1470
#undef item
#line 1470
}
#line 1470

#line 1477 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FILTER_ECLIST */
#line 1477
static inline void f_dump_line_item_FI_ECLIST_FILTER_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1477

#line 1477
{
#line 1477
#define item (&(item_->i_FI_ECLIST_FILTER_ECLIST))
#line 1477
#undef item
#line 1477
}
#line 1477

#line 1488 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FILTER_SET */
#line 1488
static inline void f_dump_line_item_FI_ECLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1488

#line 1488
{
#line 1488
#define item (&(item_->i_FI_ECLIST_FILTER_SET))
#line 1488
#undef item
#line 1488
}
#line 1488

#line 1495 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FILTER_LCLIST */
#line 1495
static inline void f_dump_line_item_FI_LCLIST_FILTER_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1495

#line 1495
{
#line 1495
#define item (&(item_->i_FI_LCLIST_FILTER_LCLIST))
#line 1495
#undef item
#line 1495
}
#line 1495

#line 1506 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FILTER_SET */
#line 1506
static inline void f_dump_line_item_FI_LCLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1506

#line 1506
{
#line 1506
#define item (&(item_->i_FI_LCLIST_FILTER_SET))
#line 1506
#undef item
#line 1506
}
#line 1506

#line 1528 "filter/f-inst.c"
 /* Dump line for FI_ROA_CHECK */
#line 1528
static inline void f_dump_line_item_FI_ROA_CHECK(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1528

#line 1528
{
#line 1528
#define item (&(item_->i_FI_ROA_CHECK))
#line 1510 "filter/f-inst.c"
RDUMP("%s" "route table %s" "\n", INDENT, item->rtc->name);
#line 1510

#line 1528 "filter/f-inst.c"
#undef item
#line 1528
}
#line 1528

#line 1544 "filter/f-inst.c"
 /* Dump line for FI_ASPA_CHECK_EXPLICIT */
#line 1544
static inline void f_dump_line_item_FI_ASPA_CHECK_EXPLICIT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1544

#line 1544
{
#line 1544
#define item (&(item_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1532 "filter/f-inst.c"
RDUMP("%s" "route table %s" "\n", INDENT, item->rtc->name);
#line 1532

#line 1544 "filter/f-inst.c"
#undef item
#line 1544
}
#line 1544

#line 1559 "filter/f-inst.c"
 /* Dump line for FI_FROM_HEX */
#line 1559
static inline void f_dump_line_item_FI_FROM_HEX(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1559

#line 1559
{
#line 1559
#define item (&(item_->i_FI_FROM_HEX))
#line 1559
#undef item
#line 1559
}
#line 1559

#line 1564 "filter/f-inst.c"
 /* Dump line for FI_FORMAT */
#line 1564
static inline void f_dump_line_item_FI_FORMAT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1564

#line 1564
{
#line 1564
#define item (&(item_->i_FI_FORMAT))
#line 1564
#undef item
#line 1564
}
#line 1564

#line 830 "filter/decl.m4"
 /* Dump line for FI_ASSERT */
#line 830
static inline void f_dump_line_item_FI_ASSERT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 830

#line 830
{
#line 830
#define item (&(item_->i_FI_ASSERT))
#line 1568 "filter/f-inst.c"
RDUMP("%s" "string %s" "\n", INDENT, item->s);
#line 1568

#line 830 "filter/decl.m4"
#undef item
#line 830
}
#line 830

#line 682 "filter/decl.m4"


void f_dump_line(struct dump_request *dreq, const struct f_line *dest, uint indent)
{
  if (!dest) {
    RDUMP("%sNo filter line (NULL)\n", INDENT);
    return;
  }
  RDUMP("%sFilter line %p (len=%u)\n", INDENT, dest, dest->len);
  for (uint i=0; i<dest->len; i++) {
    const struct f_line_item *item = &dest->items[i];
    RDUMP("%sInstruction %s at line %u\n", INDENT, f_instruction_name_(item->fi_code), item->lineno);
    switch (item->fi_code) {
#line 288 "filter/f-inst.c"
 /* Dump line caller for FI_ADD */
#line 288
case FI_ADD: f_dump_line_item_FI_ADD(dreq, item, indent + 1); break;
#line 288

#line 293 "filter/f-inst.c"
 /* Dump line caller for FI_SUBTRACT */
#line 293
case FI_SUBTRACT: f_dump_line_item_FI_SUBTRACT(dreq, item, indent + 1); break;
#line 293

#line 298 "filter/f-inst.c"
 /* Dump line caller for FI_MULTIPLY */
#line 298
case FI_MULTIPLY: f_dump_line_item_FI_MULTIPLY(dreq, item, indent + 1); break;
#line 298

#line 304 "filter/f-inst.c"
 /* Dump line caller for FI_DIVIDE */
#line 304
case FI_DIVIDE: f_dump_line_item_FI_DIVIDE(dreq, item, indent + 1); break;
#line 304

#line 309 "filter/f-inst.c"
 /* Dump line caller for FI_BITOR */
#line 309
case FI_BITOR: f_dump_line_item_FI_BITOR(dreq, item, indent + 1); break;
#line 309

#line 314 "filter/f-inst.c"
 /* Dump line caller for FI_BITAND */
#line 314
case FI_BITAND: f_dump_line_item_FI_BITAND(dreq, item, indent + 1); break;
#line 314

#line 324 "filter/f-inst.c"
 /* Dump line caller for FI_AND */
#line 324
case FI_AND: f_dump_line_item_FI_AND(dreq, item, indent + 1); break;
#line 324

#line 335 "filter/f-inst.c"
 /* Dump line caller for FI_OR */
#line 335
case FI_OR: f_dump_line_item_FI_OR(dreq, item, indent + 1); break;
#line 335

#line 345 "filter/f-inst.c"
 /* Dump line caller for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT: f_dump_line_item_FI_PAIR_CONSTRUCT(dreq, item, indent + 1); break;
#line 345

#line 385 "filter/f-inst.c"
 /* Dump line caller for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT: f_dump_line_item_FI_EC_CONSTRUCT(dreq, item, indent + 1); break;
#line 385

#line 392 "filter/f-inst.c"
 /* Dump line caller for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT: f_dump_line_item_FI_LC_CONSTRUCT(dreq, item, indent + 1); break;
#line 392

#line 442 "filter/f-inst.c"
 /* Dump line caller for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT: f_dump_line_item_FI_PATHMASK_CONSTRUCT(dreq, item, indent + 1); break;
#line 442

#line 449 "filter/f-inst.c"
 /* Dump line caller for FI_NEQ */
#line 449
case FI_NEQ: f_dump_line_item_FI_NEQ(dreq, item, indent + 1); break;
#line 449

#line 456 "filter/f-inst.c"
 /* Dump line caller for FI_EQ */
#line 456
case FI_EQ: f_dump_line_item_FI_EQ(dreq, item, indent + 1); break;
#line 456

#line 467 "filter/f-inst.c"
 /* Dump line caller for FI_LT */
#line 467
case FI_LT: f_dump_line_item_FI_LT(dreq, item, indent + 1); break;
#line 467

#line 478 "filter/f-inst.c"
 /* Dump line caller for FI_LTE */
#line 478
case FI_LTE: f_dump_line_item_FI_LTE(dreq, item, indent + 1); break;
#line 478

#line 483 "filter/f-inst.c"
 /* Dump line caller for FI_NOT */
#line 483
case FI_NOT: f_dump_line_item_FI_NOT(dreq, item, indent + 1); break;
#line 483

#line 492 "filter/f-inst.c"
 /* Dump line caller for FI_MATCH */
#line 492
case FI_MATCH: f_dump_line_item_FI_MATCH(dreq, item, indent + 1); break;
#line 492

#line 501 "filter/f-inst.c"
 /* Dump line caller for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH: f_dump_line_item_FI_NOT_MATCH(dreq, item, indent + 1); break;
#line 501

#line 506 "filter/f-inst.c"
 /* Dump line caller for FI_DEFINED */
#line 506
case FI_DEFINED: f_dump_line_item_FI_DEFINED(dreq, item, indent + 1); break;
#line 506

#line 507 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type: f_dump_line_item_FI_METHOD__T_NET__type(dreq, item, indent + 1); break;
#line 507

#line 510 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4: f_dump_line_item_FI_METHOD__T_IP__is_v4(dreq, item, indent + 1); break;
#line 510

#line 523 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_INIT */
#line 523
case FI_VAR_INIT: f_dump_line_item_FI_VAR_INIT(dreq, item, indent + 1); break;
#line 523

#line 534 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0: f_dump_line_item_FI_VAR_INIT0(dreq, item, indent + 1); break;
#line 534

#line 543 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_SET */
#line 543
case FI_VAR_SET: f_dump_line_item_FI_VAR_SET(dreq, item, indent + 1); break;
#line 543

#line 550 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_GET */
#line 550
case FI_VAR_GET: f_dump_line_item_FI_VAR_GET(dreq, item, indent + 1); break;
#line 550

#line 563 "filter/f-inst.c"
 /* Dump line caller for FI_CONSTANT */
#line 563
case FI_CONSTANT: f_dump_line_item_FI_CONSTANT(dreq, item, indent + 1); break;
#line 563

#line 564 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty: f_dump_line_item_FI_METHOD__T_PATH__empty(dreq, item, indent + 1); break;
#line 564

#line 565 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty: f_dump_line_item_FI_METHOD__T_CLIST__empty(dreq, item, indent + 1); break;
#line 565

#line 566 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty: f_dump_line_item_FI_METHOD__T_ECLIST__empty(dreq, item, indent + 1); break;
#line 566

#line 569 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty: f_dump_line_item_FI_METHOD__T_LCLIST__empty(dreq, item, indent + 1); break;
#line 569

#line 591 "filter/f-inst.c"
 /* Dump line caller for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START: f_dump_line_item_FI_FOR_LOOP_START(dreq, item, indent + 1); break;
#line 591

#line 600 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT: f_dump_line_item_FI_PATH_FOR_NEXT(dreq, item, indent + 1); break;
#line 600

#line 609 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT: f_dump_line_item_FI_CLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 609

#line 618 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT: f_dump_line_item_FI_ECLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 618

#line 627 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT: f_dump_line_item_FI_LCLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 627

#line 640 "filter/f-inst.c"
 /* Dump line caller for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT: f_dump_line_item_FI_ROUTES_BLOCK_FOR_NEXT(dreq, item, indent + 1); break;
#line 640

#line 648 "filter/f-inst.c"
 /* Dump line caller for FI_CONDITION */
#line 648
case FI_CONDITION: f_dump_line_item_FI_CONDITION(dreq, item, indent + 1); break;
#line 648

#line 661 "filter/f-inst.c"
 /* Dump line caller for FI_PRINT */
#line 661
case FI_PRINT: f_dump_line_item_FI_PRINT(dreq, item, indent + 1); break;
#line 661

#line 668 "filter/f-inst.c"
 /* Dump line caller for FI_FLUSH */
#line 668
case FI_FLUSH: f_dump_line_item_FI_FLUSH(dreq, item, indent + 1); break;
#line 668

#line 682 "filter/f-inst.c"
 /* Dump line caller for FI_DIE */
#line 682
case FI_DIE: f_dump_line_item_FI_DIE(dreq, item, indent + 1); break;
#line 682

#line 689 "filter/f-inst.c"
 /* Dump line caller for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE: f_dump_line_item_FI_CURRENT_ROUTE(dreq, item, indent + 1); break;
#line 689

#line 736 "filter/f-inst.c"
 /* Dump line caller for FI_RTA_GET */
#line 736
case FI_RTA_GET: f_dump_line_item_FI_RTA_GET(dreq, item, indent + 1); break;
#line 736

#line 864 "filter/f-inst.c"
 /* Dump line caller for FI_RTA_SET */
#line 864
case FI_RTA_SET: f_dump_line_item_FI_RTA_SET(dreq, item, indent + 1); break;
#line 864

#line 901 "filter/f-inst.c"
 /* Dump line caller for FI_EA_GET */
#line 901
case FI_EA_GET: f_dump_line_item_FI_EA_GET(dreq, item, indent + 1); break;
#line 901

#line 942 "filter/f-inst.c"
 /* Dump line caller for FI_EA_SET */
#line 942
case FI_EA_SET: f_dump_line_item_FI_EA_SET(dreq, item, indent + 1); break;
#line 942

#line 949 "filter/f-inst.c"
 /* Dump line caller for FI_EA_UNSET */
#line 949
case FI_EA_UNSET: f_dump_line_item_FI_EA_UNSET(dreq, item, indent + 1); break;
#line 949

#line 963 "filter/f-inst.c"
 /* Dump line caller for FI_DEFAULT */
#line 963
case FI_DEFAULT: f_dump_line_item_FI_DEFAULT(dreq, item, indent + 1); break;
#line 963

#line 964 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__len */
#line 964
case FI_METHOD__T_NET__len: f_dump_line_item_FI_METHOD__T_NET__len(dreq, item, indent + 1); break;
#line 964

#line 965 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__len */
#line 965
case FI_METHOD__T_PATH__len: f_dump_line_item_FI_METHOD__T_PATH__len(dreq, item, indent + 1); break;
#line 965

#line 966 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__len */
#line 966
case FI_METHOD__T_CLIST__len: f_dump_line_item_FI_METHOD__T_CLIST__len(dreq, item, indent + 1); break;
#line 966

#line 967 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__len */
#line 967
case FI_METHOD__T_ECLIST__len: f_dump_line_item_FI_METHOD__T_ECLIST__len(dreq, item, indent + 1); break;
#line 967

#line 969 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__len */
#line 969
case FI_METHOD__T_LCLIST__len: f_dump_line_item_FI_METHOD__T_LCLIST__len(dreq, item, indent + 1); break;
#line 969

#line 1005 "filter/f-inst.c"
 /* Dump line caller for FI_NET_SRC */
#line 1005
case FI_NET_SRC: f_dump_line_item_FI_NET_SRC(dreq, item, indent + 1); break;
#line 1005

#line 1042 "filter/f-inst.c"
 /* Dump line caller for FI_NET_DST */
#line 1042
case FI_NET_DST: f_dump_line_item_FI_NET_DST(dreq, item, indent + 1); break;
#line 1042

#line 1052 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__maxlen */
#line 1052
case FI_METHOD__T_NET__maxlen: f_dump_line_item_FI_METHOD__T_NET__maxlen(dreq, item, indent + 1); break;
#line 1052

#line 1062 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__asn */
#line 1062
case FI_METHOD__T_NET__asn: f_dump_line_item_FI_METHOD__T_NET__asn(dreq, item, indent + 1); break;
#line 1062

#line 1064 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__ip */
#line 1064
case FI_METHOD__T_NET__ip: f_dump_line_item_FI_METHOD__T_NET__ip(dreq, item, indent + 1); break;
#line 1064

#line 1073 "filter/f-inst.c"
 /* Dump line caller for FI_ROUTE_DISTINGUISHER */
#line 1073
case FI_ROUTE_DISTINGUISHER: f_dump_line_item_FI_ROUTE_DISTINGUISHER(dreq, item, indent + 1); break;
#line 1073

#line 1076 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__first */
#line 1076
case FI_METHOD__T_PATH__first: f_dump_line_item_FI_METHOD__T_PATH__first(dreq, item, indent + 1); break;
#line 1076

#line 1079 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__last */
#line 1079
case FI_METHOD__T_PATH__last: f_dump_line_item_FI_METHOD__T_PATH__last(dreq, item, indent + 1); break;
#line 1079

#line 1082 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
case FI_METHOD__T_PATH__last_nonaggregated: f_dump_line_item_FI_METHOD__T_PATH__last_nonaggregated(dreq, item, indent + 1); break;
#line 1082

#line 1085 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PAIR__asn */
#line 1085
case FI_METHOD__T_PAIR__asn: f_dump_line_item_FI_METHOD__T_PAIR__asn(dreq, item, indent + 1); break;
#line 1085

#line 1088 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PAIR__data */
#line 1088
case FI_METHOD__T_PAIR__data: f_dump_line_item_FI_METHOD__T_PAIR__data(dreq, item, indent + 1); break;
#line 1088

#line 1091 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__asn */
#line 1091
case FI_METHOD__T_LC__asn: f_dump_line_item_FI_METHOD__T_LC__asn(dreq, item, indent + 1); break;
#line 1091

#line 1094 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__data1 */
#line 1094
case FI_METHOD__T_LC__data1: f_dump_line_item_FI_METHOD__T_LC__data1(dreq, item, indent + 1); break;
#line 1094

#line 1097 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__data2 */
#line 1097
case FI_METHOD__T_LC__data2: f_dump_line_item_FI_METHOD__T_LC__data2(dreq, item, indent + 1); break;
#line 1097

#line 1100 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__min */
#line 1100
case FI_METHOD__T_CLIST__min: f_dump_line_item_FI_METHOD__T_CLIST__min(dreq, item, indent + 1); break;
#line 1100

#line 1103 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__max */
#line 1103
case FI_METHOD__T_CLIST__max: f_dump_line_item_FI_METHOD__T_CLIST__max(dreq, item, indent + 1); break;
#line 1103

#line 1106 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__min */
#line 1106
case FI_METHOD__T_ECLIST__min: f_dump_line_item_FI_METHOD__T_ECLIST__min(dreq, item, indent + 1); break;
#line 1106

#line 1109 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__max */
#line 1109
case FI_METHOD__T_ECLIST__max: f_dump_line_item_FI_METHOD__T_ECLIST__max(dreq, item, indent + 1); break;
#line 1109

#line 1112 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__min */
#line 1112
case FI_METHOD__T_LCLIST__min: f_dump_line_item_FI_METHOD__T_LCLIST__min(dreq, item, indent + 1); break;
#line 1112

#line 1114 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__max */
#line 1114
case FI_METHOD__T_LCLIST__max: f_dump_line_item_FI_METHOD__T_LCLIST__max(dreq, item, indent + 1); break;
#line 1114

#line 1140 "filter/f-inst.c"
 /* Dump line caller for FI_RETURN */
#line 1140
case FI_RETURN: f_dump_line_item_FI_RETURN(dreq, item, indent + 1); break;
#line 1140

#line 1200 "filter/f-inst.c"
 /* Dump line caller for FI_CALL */
#line 1200
case FI_CALL: f_dump_line_item_FI_CALL(dreq, item, indent + 1); break;
#line 1200

#line 1205 "filter/f-inst.c"
 /* Dump line caller for FI_DROP_RESULT */
#line 1205
case FI_DROP_RESULT: f_dump_line_item_FI_DROP_RESULT(dreq, item, indent + 1); break;
#line 1205

#line 1246 "filter/f-inst.c"
 /* Dump line caller for FI_SWITCH */
#line 1246
case FI_SWITCH: f_dump_line_item_FI_SWITCH(dreq, item, indent + 1); break;
#line 1246

#line 1255 "filter/f-inst.c"
 /* Dump line caller for FI_IP_MASK */
#line 1255
case FI_IP_MASK: f_dump_line_item_FI_IP_MASK(dreq, item, indent + 1); break;
#line 1255

#line 1263 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_PREPEND */
#line 1263
case FI_PATH_PREPEND: f_dump_line_item_FI_PATH_PREPEND(dreq, item, indent + 1); break;
#line 1263

#line 1270 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_PAIR */
#line 1270
case FI_CLIST_ADD_PAIR: f_dump_line_item_FI_CLIST_ADD_PAIR(dreq, item, indent + 1); break;
#line 1270

#line 1284 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_IP */
#line 1284
case FI_CLIST_ADD_IP: f_dump_line_item_FI_CLIST_ADD_IP(dreq, item, indent + 1); break;
#line 1284

#line 1291 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_QUAD */
#line 1291
case FI_CLIST_ADD_QUAD: f_dump_line_item_FI_CLIST_ADD_QUAD(dreq, item, indent + 1); break;
#line 1291

#line 1298 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_CLIST */
#line 1298
case FI_CLIST_ADD_CLIST: f_dump_line_item_FI_CLIST_ADD_CLIST(dreq, item, indent + 1); break;
#line 1298

#line 1305 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_ADD_EC */
#line 1305
case FI_ECLIST_ADD_EC: f_dump_line_item_FI_ECLIST_ADD_EC(dreq, item, indent + 1); break;
#line 1305

#line 1312 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_ADD_ECLIST */
#line 1312
case FI_ECLIST_ADD_ECLIST: f_dump_line_item_FI_ECLIST_ADD_ECLIST(dreq, item, indent + 1); break;
#line 1312

#line 1319 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_ADD_LC */
#line 1319
case FI_LCLIST_ADD_LC: f_dump_line_item_FI_LCLIST_ADD_LC(dreq, item, indent + 1); break;
#line 1319

#line 1326 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_ADD_LCLIST */
#line 1326
case FI_LCLIST_ADD_LCLIST: f_dump_line_item_FI_LCLIST_ADD_LCLIST(dreq, item, indent + 1); break;
#line 1326

#line 1333 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_DELETE_INT */
#line 1333
case FI_PATH_DELETE_INT: f_dump_line_item_FI_PATH_DELETE_INT(dreq, item, indent + 1); break;
#line 1333

#line 1345 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_DELETE_SET */
#line 1345
case FI_PATH_DELETE_SET: f_dump_line_item_FI_PATH_DELETE_SET(dreq, item, indent + 1); break;
#line 1345

#line 1352 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_PAIR */
#line 1352
case FI_CLIST_DELETE_PAIR: f_dump_line_item_FI_CLIST_DELETE_PAIR(dreq, item, indent + 1); break;
#line 1352

#line 1366 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_IP */
#line 1366
case FI_CLIST_DELETE_IP: f_dump_line_item_FI_CLIST_DELETE_IP(dreq, item, indent + 1); break;
#line 1366

#line 1373 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_QUAD */
#line 1373
case FI_CLIST_DELETE_QUAD: f_dump_line_item_FI_CLIST_DELETE_QUAD(dreq, item, indent + 1); break;
#line 1373

#line 1380 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_CLIST */
#line 1380
case FI_CLIST_DELETE_CLIST: f_dump_line_item_FI_CLIST_DELETE_CLIST(dreq, item, indent + 1); break;
#line 1380

#line 1391 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_SET */
#line 1391
case FI_CLIST_DELETE_SET: f_dump_line_item_FI_CLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1391

#line 1398 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_EC */
#line 1398
case FI_ECLIST_DELETE_EC: f_dump_line_item_FI_ECLIST_DELETE_EC(dreq, item, indent + 1); break;
#line 1398

#line 1405 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_ECLIST */
#line 1405
case FI_ECLIST_DELETE_ECLIST: f_dump_line_item_FI_ECLIST_DELETE_ECLIST(dreq, item, indent + 1); break;
#line 1405

#line 1416 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_SET */
#line 1416
case FI_ECLIST_DELETE_SET: f_dump_line_item_FI_ECLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1416

#line 1423 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_LC */
#line 1423
case FI_LCLIST_DELETE_LC: f_dump_line_item_FI_LCLIST_DELETE_LC(dreq, item, indent + 1); break;
#line 1423

#line 1430 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_LCLIST */
#line 1430
case FI_LCLIST_DELETE_LCLIST: f_dump_line_item_FI_LCLIST_DELETE_LCLIST(dreq, item, indent + 1); break;
#line 1430

#line 1441 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_SET */
#line 1441
case FI_LCLIST_DELETE_SET: f_dump_line_item_FI_LCLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1441

#line 1452 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_FILTER_SET */
#line 1452
case FI_PATH_FILTER_SET: f_dump_line_item_FI_PATH_FILTER_SET(dreq, item, indent + 1); break;
#line 1452

#line 1459 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FILTER_CLIST */
#line 1459
case FI_CLIST_FILTER_CLIST: f_dump_line_item_FI_CLIST_FILTER_CLIST(dreq, item, indent + 1); break;
#line 1459

#line 1470 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FILTER_SET */
#line 1470
case FI_CLIST_FILTER_SET: f_dump_line_item_FI_CLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1470

#line 1477 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FILTER_ECLIST */
#line 1477
case FI_ECLIST_FILTER_ECLIST: f_dump_line_item_FI_ECLIST_FILTER_ECLIST(dreq, item, indent + 1); break;
#line 1477

#line 1488 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FILTER_SET */
#line 1488
case FI_ECLIST_FILTER_SET: f_dump_line_item_FI_ECLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1488

#line 1495 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FILTER_LCLIST */
#line 1495
case FI_LCLIST_FILTER_LCLIST: f_dump_line_item_FI_LCLIST_FILTER_LCLIST(dreq, item, indent + 1); break;
#line 1495

#line 1506 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FILTER_SET */
#line 1506
case FI_LCLIST_FILTER_SET: f_dump_line_item_FI_LCLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1506

#line 1528 "filter/f-inst.c"
 /* Dump line caller for FI_ROA_CHECK */
#line 1528
case FI_ROA_CHECK: f_dump_line_item_FI_ROA_CHECK(dreq, item, indent + 1); break;
#line 1528

#line 1544 "filter/f-inst.c"
 /* Dump line caller for FI_ASPA_CHECK_EXPLICIT */
#line 1544
case FI_ASPA_CHECK_EXPLICIT: f_dump_line_item_FI_ASPA_CHECK_EXPLICIT(dreq, item, indent + 1); break;
#line 1544

#line 1559 "filter/f-inst.c"
 /* Dump line caller for FI_FROM_HEX */
#line 1559
case FI_FROM_HEX: f_dump_line_item_FI_FROM_HEX(dreq, item, indent + 1); break;
#line 1559

#line 1564 "filter/f-inst.c"
 /* Dump line caller for FI_FORMAT */
#line 1564
case FI_FORMAT: f_dump_line_item_FI_FORMAT(dreq, item, indent + 1); break;
#line 1564

#line 830 "filter/decl.m4"
 /* Dump line caller for FI_ASSERT */
#line 830
case FI_ASSERT: f_dump_line_item_FI_ASSERT(dreq, item, indent + 1); break;
#line 830

#line 695 "filter/decl.m4"

      default: bug("Unknown instruction %x in f_dump_line", item->fi_code);
    }
  }
  RDUMP("%sFilter line %p dump done\n", INDENT, dest);
}

/* Linearize */
static uint
linearize(struct f_line *dest, const struct f_inst *what, uint pos)
{
  for ( ; what; what = what->next) {
    switch (what->fi_code) {
#line 288 "filter/f-inst.c"
 /* Linearize for FI_ADD */
#line 288
case FI_ADD: {
#line 288
#define whati (&(what->i_FI_ADD))
#line 288
#define item (&(dest->items[pos].i_FI_ADD))
#line 288
  #line 284 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 285 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 288 "filter/f-inst.c"
#undef item
#line 288
  dest->items[pos].fi_code = what->fi_code;
#line 288
  dest->items[pos].flags = what->flags;
#line 288
  dest->items[pos].lineno = what->lineno;
#line 288
  break;
#line 288
}
#line 288

#line 293 "filter/f-inst.c"
 /* Linearize for FI_SUBTRACT */
#line 293
case FI_SUBTRACT: {
#line 293
#define whati (&(what->i_FI_SUBTRACT))
#line 293
#define item (&(dest->items[pos].i_FI_SUBTRACT))
#line 293
  #line 289 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 290 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 293 "filter/f-inst.c"
#undef item
#line 293
  dest->items[pos].fi_code = what->fi_code;
#line 293
  dest->items[pos].flags = what->flags;
#line 293
  dest->items[pos].lineno = what->lineno;
#line 293
  break;
#line 293
}
#line 293

#line 298 "filter/f-inst.c"
 /* Linearize for FI_MULTIPLY */
#line 298
case FI_MULTIPLY: {
#line 298
#define whati (&(what->i_FI_MULTIPLY))
#line 298
#define item (&(dest->items[pos].i_FI_MULTIPLY))
#line 298
  #line 294 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 295 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 298 "filter/f-inst.c"
#undef item
#line 298
  dest->items[pos].fi_code = what->fi_code;
#line 298
  dest->items[pos].flags = what->flags;
#line 298
  dest->items[pos].lineno = what->lineno;
#line 298
  break;
#line 298
}
#line 298

#line 304 "filter/f-inst.c"
 /* Linearize for FI_DIVIDE */
#line 304
case FI_DIVIDE: {
#line 304
#define whati (&(what->i_FI_DIVIDE))
#line 304
#define item (&(dest->items[pos].i_FI_DIVIDE))
#line 304
  #line 299 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 300 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 304 "filter/f-inst.c"
#undef item
#line 304
  dest->items[pos].fi_code = what->fi_code;
#line 304
  dest->items[pos].flags = what->flags;
#line 304
  dest->items[pos].lineno = what->lineno;
#line 304
  break;
#line 304
}
#line 304

#line 309 "filter/f-inst.c"
 /* Linearize for FI_BITOR */
#line 309
case FI_BITOR: {
#line 309
#define whati (&(what->i_FI_BITOR))
#line 309
#define item (&(dest->items[pos].i_FI_BITOR))
#line 309
  #line 305 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 306 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 309 "filter/f-inst.c"
#undef item
#line 309
  dest->items[pos].fi_code = what->fi_code;
#line 309
  dest->items[pos].flags = what->flags;
#line 309
  dest->items[pos].lineno = what->lineno;
#line 309
  break;
#line 309
}
#line 309

#line 314 "filter/f-inst.c"
 /* Linearize for FI_BITAND */
#line 314
case FI_BITAND: {
#line 314
#define whati (&(what->i_FI_BITAND))
#line 314
#define item (&(dest->items[pos].i_FI_BITAND))
#line 314
  #line 310 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 311 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 314 "filter/f-inst.c"
#undef item
#line 314
  dest->items[pos].fi_code = what->fi_code;
#line 314
  dest->items[pos].flags = what->flags;
#line 314
  dest->items[pos].lineno = what->lineno;
#line 314
  break;
#line 314
}
#line 314

#line 324 "filter/f-inst.c"
 /* Linearize for FI_AND */
#line 324
case FI_AND: {
#line 324
#define whati (&(what->i_FI_AND))
#line 324
#define item (&(dest->items[pos].i_FI_AND))
#line 324
  #line 315 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 320 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 1);
#undef whati
#line 324 "filter/f-inst.c"
#undef item
#line 324
  dest->items[pos].fi_code = what->fi_code;
#line 324
  dest->items[pos].flags = what->flags;
#line 324
  dest->items[pos].lineno = what->lineno;
#line 324
  break;
#line 324
}
#line 324

#line 335 "filter/f-inst.c"
 /* Linearize for FI_OR */
#line 335
case FI_OR: {
#line 335
#define whati (&(what->i_FI_OR))
#line 335
#define item (&(dest->items[pos].i_FI_OR))
#line 335
  #line 325 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 330 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 1);
#undef whati
#line 335 "filter/f-inst.c"
#undef item
#line 335
  dest->items[pos].fi_code = what->fi_code;
#line 335
  dest->items[pos].flags = what->flags;
#line 335
  dest->items[pos].lineno = what->lineno;
#line 335
  break;
#line 335
}
#line 335

#line 345 "filter/f-inst.c"
 /* Linearize for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT: {
#line 345
#define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
#define item (&(dest->items[pos].i_FI_PAIR_CONSTRUCT))
#line 345
  #line 336 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 337 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 345 "filter/f-inst.c"
#undef item
#line 345
  dest->items[pos].fi_code = what->fi_code;
#line 345
  dest->items[pos].flags = what->flags;
#line 345
  dest->items[pos].lineno = what->lineno;
#line 345
  break;
#line 345
}
#line 345

#line 385 "filter/f-inst.c"
 /* Linearize for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT: {
#line 385
#define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
#define item (&(dest->items[pos].i_FI_EC_CONSTRUCT))
#line 385
  #line 346 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 347 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 349 "filter/f-inst.c"
item->ecs = whati->ecs;
#line 349

#undef whati
#line 385 "filter/f-inst.c"
#undef item
#line 385
  dest->items[pos].fi_code = what->fi_code;
#line 385
  dest->items[pos].flags = what->flags;
#line 385
  dest->items[pos].lineno = what->lineno;
#line 385
  break;
#line 385
}
#line 385

#line 392 "filter/f-inst.c"
 /* Linearize for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT: {
#line 392
#define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
#define item (&(dest->items[pos].i_FI_LC_CONSTRUCT))
#line 392
  #line 386 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 387 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 388 "filter/f-inst.c"
pos = linearize(dest, whati->f3, pos);
#undef whati
#line 392 "filter/f-inst.c"
#undef item
#line 392
  dest->items[pos].fi_code = what->fi_code;
#line 392
  dest->items[pos].flags = what->flags;
#line 392
  dest->items[pos].lineno = what->lineno;
#line 392
  break;
#line 392
}
#line 392

#line 442 "filter/f-inst.c"
 /* Linearize for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT: {
#line 442
#define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
#define item (&(dest->items[pos].i_FI_PATHMASK_CONSTRUCT))
#line 442
  #line 393 "filter/f-inst.c"
  pos = linearize(dest, whati->fvar, pos);
#line 393
  item->varcount = whati->varcount;
#undef whati
#line 442 "filter/f-inst.c"
#undef item
#line 442
  dest->items[pos].fi_code = what->fi_code;
#line 442
  dest->items[pos].flags = what->flags;
#line 442
  dest->items[pos].lineno = what->lineno;
#line 442
  break;
#line 442
}
#line 442

#line 449 "filter/f-inst.c"
 /* Linearize for FI_NEQ */
#line 449
case FI_NEQ: {
#line 449
#define whati (&(what->i_FI_NEQ))
#line 449
#define item (&(dest->items[pos].i_FI_NEQ))
#line 449
  #line 443 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 444 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 449 "filter/f-inst.c"
#undef item
#line 449
  dest->items[pos].fi_code = what->fi_code;
#line 449
  dest->items[pos].flags = what->flags;
#line 449
  dest->items[pos].lineno = what->lineno;
#line 449
  break;
#line 449
}
#line 449

#line 456 "filter/f-inst.c"
 /* Linearize for FI_EQ */
#line 456
case FI_EQ: {
#line 456
#define whati (&(what->i_FI_EQ))
#line 456
#define item (&(dest->items[pos].i_FI_EQ))
#line 456
  #line 450 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 451 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 456 "filter/f-inst.c"
#undef item
#line 456
  dest->items[pos].fi_code = what->fi_code;
#line 456
  dest->items[pos].flags = what->flags;
#line 456
  dest->items[pos].lineno = what->lineno;
#line 456
  break;
#line 456
}
#line 456

#line 467 "filter/f-inst.c"
 /* Linearize for FI_LT */
#line 467
case FI_LT: {
#line 467
#define whati (&(what->i_FI_LT))
#line 467
#define item (&(dest->items[pos].i_FI_LT))
#line 467
  #line 457 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 458 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 467 "filter/f-inst.c"
#undef item
#line 467
  dest->items[pos].fi_code = what->fi_code;
#line 467
  dest->items[pos].flags = what->flags;
#line 467
  dest->items[pos].lineno = what->lineno;
#line 467
  break;
#line 467
}
#line 467

#line 478 "filter/f-inst.c"
 /* Linearize for FI_LTE */
#line 478
case FI_LTE: {
#line 478
#define whati (&(what->i_FI_LTE))
#line 478
#define item (&(dest->items[pos].i_FI_LTE))
#line 478
  #line 468 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 469 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 478 "filter/f-inst.c"
#undef item
#line 478
  dest->items[pos].fi_code = what->fi_code;
#line 478
  dest->items[pos].flags = what->flags;
#line 478
  dest->items[pos].lineno = what->lineno;
#line 478
  break;
#line 478
}
#line 478

#line 483 "filter/f-inst.c"
 /* Linearize for FI_NOT */
#line 483
case FI_NOT: {
#line 483
#define whati (&(what->i_FI_NOT))
#line 483
#define item (&(dest->items[pos].i_FI_NOT))
#line 483
  #line 479 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 483 "filter/f-inst.c"
#undef item
#line 483
  dest->items[pos].fi_code = what->fi_code;
#line 483
  dest->items[pos].flags = what->flags;
#line 483
  dest->items[pos].lineno = what->lineno;
#line 483
  break;
#line 483
}
#line 483

#line 492 "filter/f-inst.c"
 /* Linearize for FI_MATCH */
#line 492
case FI_MATCH: {
#line 492
#define whati (&(what->i_FI_MATCH))
#line 492
#define item (&(dest->items[pos].i_FI_MATCH))
#line 492
  #line 484 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 485 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 492 "filter/f-inst.c"
#undef item
#line 492
  dest->items[pos].fi_code = what->fi_code;
#line 492
  dest->items[pos].flags = what->flags;
#line 492
  dest->items[pos].lineno = what->lineno;
#line 492
  break;
#line 492
}
#line 492

#line 501 "filter/f-inst.c"
 /* Linearize for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH: {
#line 501
#define whati (&(what->i_FI_NOT_MATCH))
#line 501
#define item (&(dest->items[pos].i_FI_NOT_MATCH))
#line 501
  #line 493 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 494 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 501 "filter/f-inst.c"
#undef item
#line 501
  dest->items[pos].fi_code = what->fi_code;
#line 501
  dest->items[pos].flags = what->flags;
#line 501
  dest->items[pos].lineno = what->lineno;
#line 501
  break;
#line 501
}
#line 501

#line 506 "filter/f-inst.c"
 /* Linearize for FI_DEFINED */
#line 506
case FI_DEFINED: {
#line 506
#define whati (&(what->i_FI_DEFINED))
#line 506
#define item (&(dest->items[pos].i_FI_DEFINED))
#line 506
  #line 502 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 506 "filter/f-inst.c"
#undef item
#line 506
  dest->items[pos].fi_code = what->fi_code;
#line 506
  dest->items[pos].flags = what->flags;
#line 506
  dest->items[pos].lineno = what->lineno;
#line 506
  break;
#line 506
}
#line 506

#line 507 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type: {
#line 507
#define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__type))
#line 507
  #line 506 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 507 "filter/f-inst.c"
#undef item
#line 507
  dest->items[pos].fi_code = what->fi_code;
#line 507
  dest->items[pos].flags = what->flags;
#line 507
  dest->items[pos].lineno = what->lineno;
#line 507
  break;
#line 507
}
#line 507

#line 510 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4: {
#line 510
#define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
#define item (&(dest->items[pos].i_FI_METHOD__T_IP__is_v4))
#line 510
  #line 507 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 510 "filter/f-inst.c"
#undef item
#line 510
  dest->items[pos].fi_code = what->fi_code;
#line 510
  dest->items[pos].flags = what->flags;
#line 510
  dest->items[pos].lineno = what->lineno;
#line 510
  break;
#line 510
}
#line 510

#line 523 "filter/f-inst.c"
 /* Linearize for FI_VAR_INIT */
#line 523
case FI_VAR_INIT: {
#line 523
#define whati (&(what->i_FI_VAR_INIT))
#line 523
#define item (&(dest->items[pos].i_FI_VAR_INIT))
#line 523
  #line 512 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 513 "filter/f-inst.c"
item->sym = whati->sym;
#line 513

#undef whati
#line 523 "filter/f-inst.c"
#undef item
#line 523
  dest->items[pos].fi_code = what->fi_code;
#line 523
  dest->items[pos].flags = what->flags;
#line 523
  dest->items[pos].lineno = what->lineno;
#line 523
  break;
#line 523
}
#line 523

#line 534 "filter/f-inst.c"
 /* Linearize for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0: {
#line 534
#define whati (&(what->i_FI_VAR_INIT0))
#line 534
#define item (&(dest->items[pos].i_FI_VAR_INIT0))
#line 534
  #line 525 "filter/f-inst.c"
item->sym = whati->sym;
#line 525

#undef whati
#line 534 "filter/f-inst.c"
#undef item
#line 534
  dest->items[pos].fi_code = what->fi_code;
#line 534
  dest->items[pos].flags = what->flags;
#line 534
  dest->items[pos].lineno = what->lineno;
#line 534
  break;
#line 534
}
#line 534

#line 543 "filter/f-inst.c"
 /* Linearize for FI_VAR_SET */
#line 543
case FI_VAR_SET: {
#line 543
#define whati (&(what->i_FI_VAR_SET))
#line 543
#define item (&(dest->items[pos].i_FI_VAR_SET))
#line 543
  #line 536 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 537 "filter/f-inst.c"
item->sym = whati->sym;
#line 537

#undef whati
#line 543 "filter/f-inst.c"
#undef item
#line 543
  dest->items[pos].fi_code = what->fi_code;
#line 543
  dest->items[pos].flags = what->flags;
#line 543
  dest->items[pos].lineno = what->lineno;
#line 543
  break;
#line 543
}
#line 543

#line 550 "filter/f-inst.c"
 /* Linearize for FI_VAR_GET */
#line 550
case FI_VAR_GET: {
#line 550
#define whati (&(what->i_FI_VAR_GET))
#line 550
#define item (&(dest->items[pos].i_FI_VAR_GET))
#line 550
  #line 544 "filter/f-inst.c"
item->sym = whati->sym;
#line 544

#undef whati
#line 550 "filter/f-inst.c"
#undef item
#line 550
  dest->items[pos].fi_code = what->fi_code;
#line 550
  dest->items[pos].flags = what->flags;
#line 550
  dest->items[pos].lineno = what->lineno;
#line 550
  break;
#line 550
}
#line 550

#line 563 "filter/f-inst.c"
 /* Linearize for FI_CONSTANT */
#line 563
case FI_CONSTANT: {
#line 563
#define whati (&(what->i_FI_CONSTANT))
#line 563
#define item (&(dest->items[pos].i_FI_CONSTANT))
#line 563
  #line 551 "filter/f-inst.c"
item->val = whati->val;
#line 551

#undef whati
#line 563 "filter/f-inst.c"
#undef item
#line 563
  dest->items[pos].fi_code = what->fi_code;
#line 563
  dest->items[pos].flags = what->flags;
#line 563
  dest->items[pos].lineno = what->lineno;
#line 563
  break;
#line 563
}
#line 563

#line 564 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty: {
#line 564
#define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__empty))
#line 564
  #line 563 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 564 "filter/f-inst.c"
#undef item
#line 564
  dest->items[pos].fi_code = what->fi_code;
#line 564
  dest->items[pos].flags = what->flags;
#line 564
  dest->items[pos].lineno = what->lineno;
#line 564
  break;
#line 564
}
#line 564

#line 565 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty: {
#line 565
#define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__empty))
#line 565
  #line 564 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 565 "filter/f-inst.c"
#undef item
#line 565
  dest->items[pos].fi_code = what->fi_code;
#line 565
  dest->items[pos].flags = what->flags;
#line 565
  dest->items[pos].lineno = what->lineno;
#line 565
  break;
#line 565
}
#line 565

#line 566 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty: {
#line 566
#define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__empty))
#line 566
  #line 565 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 566 "filter/f-inst.c"
#undef item
#line 566
  dest->items[pos].fi_code = what->fi_code;
#line 566
  dest->items[pos].flags = what->flags;
#line 566
  dest->items[pos].lineno = what->lineno;
#line 566
  break;
#line 566
}
#line 566

#line 569 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty: {
#line 569
#define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__empty))
#line 569
  #line 566 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 569 "filter/f-inst.c"
#undef item
#line 569
  dest->items[pos].fi_code = what->fi_code;
#line 569
  dest->items[pos].flags = what->flags;
#line 569
  dest->items[pos].lineno = what->lineno;
#line 569
  break;
#line 569
}
#line 569

#line 591 "filter/f-inst.c"
 /* Linearize for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START: {
#line 591
#define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
#define item (&(dest->items[pos].i_FI_FOR_LOOP_START))
#line 591
  #line 571 "filter/f-inst.c"
item->sym = whati->sym;
#line 571

#undef whati
#line 591 "filter/f-inst.c"
#undef item
#line 591
  dest->items[pos].fi_code = what->fi_code;
#line 591
  dest->items[pos].flags = what->flags;
#line 591
  dest->items[pos].lineno = what->lineno;
#line 591
  break;
#line 591
}
#line 591

#line 600 "filter/f-inst.c"
 /* Linearize for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT: {
#line 600
#define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 600
#define item (&(dest->items[pos].i_FI_PATH_FOR_NEXT))
#line 600
  #line 593 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 595 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 600 "filter/f-inst.c"
#undef item
#line 600
  dest->items[pos].fi_code = what->fi_code;
#line 600
  dest->items[pos].flags = what->flags;
#line 600
  dest->items[pos].lineno = what->lineno;
#line 600
  break;
#line 600
}
#line 600

#line 609 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT: {
#line 609
#define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 609
#define item (&(dest->items[pos].i_FI_CLIST_FOR_NEXT))
#line 609
  #line 602 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 604 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 609 "filter/f-inst.c"
#undef item
#line 609
  dest->items[pos].fi_code = what->fi_code;
#line 609
  dest->items[pos].flags = what->flags;
#line 609
  dest->items[pos].lineno = what->lineno;
#line 609
  break;
#line 609
}
#line 609

#line 618 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT: {
#line 618
#define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 618
#define item (&(dest->items[pos].i_FI_ECLIST_FOR_NEXT))
#line 618
  #line 611 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 613 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 618 "filter/f-inst.c"
#undef item
#line 618
  dest->items[pos].fi_code = what->fi_code;
#line 618
  dest->items[pos].flags = what->flags;
#line 618
  dest->items[pos].lineno = what->lineno;
#line 618
  break;
#line 618
}
#line 618

#line 627 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT: {
#line 627
#define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 627
#define item (&(dest->items[pos].i_FI_LCLIST_FOR_NEXT))
#line 627
  #line 620 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 622 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 627 "filter/f-inst.c"
#undef item
#line 627
  dest->items[pos].fi_code = what->fi_code;
#line 627
  dest->items[pos].flags = what->flags;
#line 627
  dest->items[pos].lineno = what->lineno;
#line 627
  break;
#line 627
}
#line 627

#line 640 "filter/f-inst.c"
 /* Linearize for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT: {
#line 640
#define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
#define item (&(dest->items[pos].i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
  #line 629 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 634 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 640 "filter/f-inst.c"
#undef item
#line 640
  dest->items[pos].fi_code = what->fi_code;
#line 640
  dest->items[pos].flags = what->flags;
#line 640
  dest->items[pos].lineno = what->lineno;
#line 640
  break;
#line 640
}
#line 640

#line 648 "filter/f-inst.c"
 /* Linearize for FI_CONDITION */
#line 648
case FI_CONDITION: {
#line 648
#define whati (&(what->i_FI_CONDITION))
#line 648
#define item (&(dest->items[pos].i_FI_CONDITION))
#line 648
  #line 641 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 643 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#line 645 "filter/f-inst.c"
item->fl3 = f_linearize(whati->f3, 0);
#undef whati
#line 648 "filter/f-inst.c"
#undef item
#line 648
  dest->items[pos].fi_code = what->fi_code;
#line 648
  dest->items[pos].flags = what->flags;
#line 648
  dest->items[pos].lineno = what->lineno;
#line 648
  break;
#line 648
}
#line 648

#line 661 "filter/f-inst.c"
 /* Linearize for FI_PRINT */
#line 661
case FI_PRINT: {
#line 661
#define whati (&(what->i_FI_PRINT))
#line 661
#define item (&(dest->items[pos].i_FI_PRINT))
#line 661
  #line 650 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 661 "filter/f-inst.c"
#undef item
#line 661
  dest->items[pos].fi_code = what->fi_code;
#line 661
  dest->items[pos].flags = what->flags;
#line 661
  dest->items[pos].lineno = what->lineno;
#line 661
  break;
#line 661
}
#line 661

#line 668 "filter/f-inst.c"
 /* Linearize for FI_FLUSH */
#line 668
case FI_FLUSH: {
#line 668
#define whati (&(what->i_FI_FLUSH))
#line 668
#define item (&(dest->items[pos].i_FI_FLUSH))
#line 668
  #undef whati
#line 668
#undef item
#line 668
  dest->items[pos].fi_code = what->fi_code;
#line 668
  dest->items[pos].flags = what->flags;
#line 668
  dest->items[pos].lineno = what->lineno;
#line 668
  break;
#line 668
}
#line 668

#line 682 "filter/f-inst.c"
 /* Linearize for FI_DIE */
#line 682
case FI_DIE: {
#line 682
#define whati (&(what->i_FI_DIE))
#line 682
#define item (&(dest->items[pos].i_FI_DIE))
#line 682
  #line 670 "filter/f-inst.c"
item->fret = whati->fret;
#line 670

#undef whati
#line 682 "filter/f-inst.c"
#undef item
#line 682
  dest->items[pos].fi_code = what->fi_code;
#line 682
  dest->items[pos].flags = what->flags;
#line 682
  dest->items[pos].lineno = what->lineno;
#line 682
  break;
#line 682
}
#line 682

#line 689 "filter/f-inst.c"
 /* Linearize for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE: {
#line 689
#define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
#define item (&(dest->items[pos].i_FI_CURRENT_ROUTE))
#line 689
  #undef whati
#line 689
#undef item
#line 689
  dest->items[pos].fi_code = what->fi_code;
#line 689
  dest->items[pos].flags = what->flags;
#line 689
  dest->items[pos].lineno = what->lineno;
#line 689
  break;
#line 689
}
#line 689

#line 736 "filter/f-inst.c"
 /* Linearize for FI_RTA_GET */
#line 736
case FI_RTA_GET: {
#line 736
#define whati (&(what->i_FI_RTA_GET))
#line 736
#define item (&(dest->items[pos].i_FI_RTA_GET))
#line 736
  #line 691 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 692 "filter/f-inst.c"
item->sa = whati->sa;
#line 692

#undef whati
#line 736 "filter/f-inst.c"
#undef item
#line 736
  dest->items[pos].fi_code = what->fi_code;
#line 736
  dest->items[pos].flags = what->flags;
#line 736
  dest->items[pos].lineno = what->lineno;
#line 736
  break;
#line 736
}
#line 736

#line 864 "filter/f-inst.c"
 /* Linearize for FI_RTA_SET */
#line 864
case FI_RTA_SET: {
#line 864
#define whati (&(what->i_FI_RTA_SET))
#line 864
#define item (&(dest->items[pos].i_FI_RTA_SET))
#line 864
  #line 738 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 739 "filter/f-inst.c"
item->sa = whati->sa;
#line 739

#undef whati
#line 864 "filter/f-inst.c"
#undef item
#line 864
  dest->items[pos].fi_code = what->fi_code;
#line 864
  dest->items[pos].flags = what->flags;
#line 864
  dest->items[pos].lineno = what->lineno;
#line 864
  break;
#line 864
}
#line 864

#line 901 "filter/f-inst.c"
 /* Linearize for FI_EA_GET */
#line 901
case FI_EA_GET: {
#line 901
#define whati (&(what->i_FI_EA_GET))
#line 901
#define item (&(dest->items[pos].i_FI_EA_GET))
#line 901
  #line 865 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 866 "filter/f-inst.c"
item->da = whati->da;
#line 866

#undef whati
#line 901 "filter/f-inst.c"
#undef item
#line 901
  dest->items[pos].fi_code = what->fi_code;
#line 901
  dest->items[pos].flags = what->flags;
#line 901
  dest->items[pos].lineno = what->lineno;
#line 901
  break;
#line 901
}
#line 901

#line 942 "filter/f-inst.c"
 /* Linearize for FI_EA_SET */
#line 942
case FI_EA_SET: {
#line 942
#define whati (&(what->i_FI_EA_SET))
#line 942
#define item (&(dest->items[pos].i_FI_EA_SET))
#line 942
  #line 903 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 904 "filter/f-inst.c"
item->da = whati->da;
#line 904

#undef whati
#line 942 "filter/f-inst.c"
#undef item
#line 942
  dest->items[pos].fi_code = what->fi_code;
#line 942
  dest->items[pos].flags = what->flags;
#line 942
  dest->items[pos].lineno = what->lineno;
#line 942
  break;
#line 942
}
#line 942

#line 949 "filter/f-inst.c"
 /* Linearize for FI_EA_UNSET */
#line 949
case FI_EA_UNSET: {
#line 949
#define whati (&(what->i_FI_EA_UNSET))
#line 949
#define item (&(dest->items[pos].i_FI_EA_UNSET))
#line 949
  #line 943 "filter/f-inst.c"
item->da = whati->da;
#line 943

#undef whati
#line 949 "filter/f-inst.c"
#undef item
#line 949
  dest->items[pos].fi_code = what->fi_code;
#line 949
  dest->items[pos].flags = what->flags;
#line 949
  dest->items[pos].lineno = what->lineno;
#line 949
  break;
#line 949
}
#line 949

#line 963 "filter/f-inst.c"
 /* Linearize for FI_DEFAULT */
#line 963
case FI_DEFAULT: {
#line 963
#define whati (&(what->i_FI_DEFAULT))
#line 963
#define item (&(dest->items[pos].i_FI_DEFAULT))
#line 963
  #line 950 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 951 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 963 "filter/f-inst.c"
#undef item
#line 963
  dest->items[pos].fi_code = what->fi_code;
#line 963
  dest->items[pos].flags = what->flags;
#line 963
  dest->items[pos].lineno = what->lineno;
#line 963
  break;
#line 963
}
#line 963

#line 964 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__len */
#line 964
case FI_METHOD__T_NET__len: {
#line 964
#define whati (&(what->i_FI_METHOD__T_NET__len))
#line 964
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__len))
#line 964
  #line 963 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 964 "filter/f-inst.c"
#undef item
#line 964
  dest->items[pos].fi_code = what->fi_code;
#line 964
  dest->items[pos].flags = what->flags;
#line 964
  dest->items[pos].lineno = what->lineno;
#line 964
  break;
#line 964
}
#line 964

#line 965 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__len */
#line 965
case FI_METHOD__T_PATH__len: {
#line 965
#define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 965
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__len))
#line 965
  #line 964 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 965 "filter/f-inst.c"
#undef item
#line 965
  dest->items[pos].fi_code = what->fi_code;
#line 965
  dest->items[pos].flags = what->flags;
#line 965
  dest->items[pos].lineno = what->lineno;
#line 965
  break;
#line 965
}
#line 965

#line 966 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__len */
#line 966
case FI_METHOD__T_CLIST__len: {
#line 966
#define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 966
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__len))
#line 966
  #line 965 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 966 "filter/f-inst.c"
#undef item
#line 966
  dest->items[pos].fi_code = what->fi_code;
#line 966
  dest->items[pos].flags = what->flags;
#line 966
  dest->items[pos].lineno = what->lineno;
#line 966
  break;
#line 966
}
#line 966

#line 967 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__len */
#line 967
case FI_METHOD__T_ECLIST__len: {
#line 967
#define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 967
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__len))
#line 967
  #line 966 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 967 "filter/f-inst.c"
#undef item
#line 967
  dest->items[pos].fi_code = what->fi_code;
#line 967
  dest->items[pos].flags = what->flags;
#line 967
  dest->items[pos].lineno = what->lineno;
#line 967
  break;
#line 967
}
#line 967

#line 969 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__len */
#line 969
case FI_METHOD__T_LCLIST__len: {
#line 969
#define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 969
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__len))
#line 969
  #line 967 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 969 "filter/f-inst.c"
#undef item
#line 969
  dest->items[pos].fi_code = what->fi_code;
#line 969
  dest->items[pos].flags = what->flags;
#line 969
  dest->items[pos].lineno = what->lineno;
#line 969
  break;
#line 969
}
#line 969

#line 1005 "filter/f-inst.c"
 /* Linearize for FI_NET_SRC */
#line 1005
case FI_NET_SRC: {
#line 1005
#define whati (&(what->i_FI_NET_SRC))
#line 1005
#define item (&(dest->items[pos].i_FI_NET_SRC))
#line 1005
  #line 970 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1005 "filter/f-inst.c"
#undef item
#line 1005
  dest->items[pos].fi_code = what->fi_code;
#line 1005
  dest->items[pos].flags = what->flags;
#line 1005
  dest->items[pos].lineno = what->lineno;
#line 1005
  break;
#line 1005
}
#line 1005

#line 1042 "filter/f-inst.c"
 /* Linearize for FI_NET_DST */
#line 1042
case FI_NET_DST: {
#line 1042
#define whati (&(what->i_FI_NET_DST))
#line 1042
#define item (&(dest->items[pos].i_FI_NET_DST))
#line 1042
  #line 1006 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1042 "filter/f-inst.c"
#undef item
#line 1042
  dest->items[pos].fi_code = what->fi_code;
#line 1042
  dest->items[pos].flags = what->flags;
#line 1042
  dest->items[pos].lineno = what->lineno;
#line 1042
  break;
#line 1042
}
#line 1042

#line 1052 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__maxlen */
#line 1052
case FI_METHOD__T_NET__maxlen: {
#line 1052
#define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1052
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__maxlen))
#line 1052
  #line 1042 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1052 "filter/f-inst.c"
#undef item
#line 1052
  dest->items[pos].fi_code = what->fi_code;
#line 1052
  dest->items[pos].flags = what->flags;
#line 1052
  dest->items[pos].lineno = what->lineno;
#line 1052
  break;
#line 1052
}
#line 1052

#line 1062 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__asn */
#line 1062
case FI_METHOD__T_NET__asn: {
#line 1062
#define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1062
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__asn))
#line 1062
  #line 1052 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1062 "filter/f-inst.c"
#undef item
#line 1062
  dest->items[pos].fi_code = what->fi_code;
#line 1062
  dest->items[pos].flags = what->flags;
#line 1062
  dest->items[pos].lineno = what->lineno;
#line 1062
  break;
#line 1062
}
#line 1062

#line 1064 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__ip */
#line 1064
case FI_METHOD__T_NET__ip: {
#line 1064
#define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1064
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__ip))
#line 1064
  #line 1062 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1064 "filter/f-inst.c"
#undef item
#line 1064
  dest->items[pos].fi_code = what->fi_code;
#line 1064
  dest->items[pos].flags = what->flags;
#line 1064
  dest->items[pos].lineno = what->lineno;
#line 1064
  break;
#line 1064
}
#line 1064

#line 1073 "filter/f-inst.c"
 /* Linearize for FI_ROUTE_DISTINGUISHER */
#line 1073
case FI_ROUTE_DISTINGUISHER: {
#line 1073
#define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1073
#define item (&(dest->items[pos].i_FI_ROUTE_DISTINGUISHER))
#line 1073
  #line 1065 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1073 "filter/f-inst.c"
#undef item
#line 1073
  dest->items[pos].fi_code = what->fi_code;
#line 1073
  dest->items[pos].flags = what->flags;
#line 1073
  dest->items[pos].lineno = what->lineno;
#line 1073
  break;
#line 1073
}
#line 1073

#line 1076 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__first */
#line 1076
case FI_METHOD__T_PATH__first: {
#line 1076
#define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1076
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__first))
#line 1076
  #line 1073 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1076 "filter/f-inst.c"
#undef item
#line 1076
  dest->items[pos].fi_code = what->fi_code;
#line 1076
  dest->items[pos].flags = what->flags;
#line 1076
  dest->items[pos].lineno = what->lineno;
#line 1076
  break;
#line 1076
}
#line 1076

#line 1079 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__last */
#line 1079
case FI_METHOD__T_PATH__last: {
#line 1079
#define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1079
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__last))
#line 1079
  #line 1076 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1079 "filter/f-inst.c"
#undef item
#line 1079
  dest->items[pos].fi_code = what->fi_code;
#line 1079
  dest->items[pos].flags = what->flags;
#line 1079
  dest->items[pos].lineno = what->lineno;
#line 1079
  break;
#line 1079
}
#line 1079

#line 1082 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
case FI_METHOD__T_PATH__last_nonaggregated: {
#line 1082
#define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
  #line 1079 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1082 "filter/f-inst.c"
#undef item
#line 1082
  dest->items[pos].fi_code = what->fi_code;
#line 1082
  dest->items[pos].flags = what->flags;
#line 1082
  dest->items[pos].lineno = what->lineno;
#line 1082
  break;
#line 1082
}
#line 1082

#line 1085 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PAIR__asn */
#line 1085
case FI_METHOD__T_PAIR__asn: {
#line 1085
#define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1085
#define item (&(dest->items[pos].i_FI_METHOD__T_PAIR__asn))
#line 1085
  #line 1082 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1085 "filter/f-inst.c"
#undef item
#line 1085
  dest->items[pos].fi_code = what->fi_code;
#line 1085
  dest->items[pos].flags = what->flags;
#line 1085
  dest->items[pos].lineno = what->lineno;
#line 1085
  break;
#line 1085
}
#line 1085

#line 1088 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PAIR__data */
#line 1088
case FI_METHOD__T_PAIR__data: {
#line 1088
#define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1088
#define item (&(dest->items[pos].i_FI_METHOD__T_PAIR__data))
#line 1088
  #line 1085 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1088 "filter/f-inst.c"
#undef item
#line 1088
  dest->items[pos].fi_code = what->fi_code;
#line 1088
  dest->items[pos].flags = what->flags;
#line 1088
  dest->items[pos].lineno = what->lineno;
#line 1088
  break;
#line 1088
}
#line 1088

#line 1091 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__asn */
#line 1091
case FI_METHOD__T_LC__asn: {
#line 1091
#define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1091
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__asn))
#line 1091
  #line 1088 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1091 "filter/f-inst.c"
#undef item
#line 1091
  dest->items[pos].fi_code = what->fi_code;
#line 1091
  dest->items[pos].flags = what->flags;
#line 1091
  dest->items[pos].lineno = what->lineno;
#line 1091
  break;
#line 1091
}
#line 1091

#line 1094 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__data1 */
#line 1094
case FI_METHOD__T_LC__data1: {
#line 1094
#define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1094
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__data1))
#line 1094
  #line 1091 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1094 "filter/f-inst.c"
#undef item
#line 1094
  dest->items[pos].fi_code = what->fi_code;
#line 1094
  dest->items[pos].flags = what->flags;
#line 1094
  dest->items[pos].lineno = what->lineno;
#line 1094
  break;
#line 1094
}
#line 1094

#line 1097 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__data2 */
#line 1097
case FI_METHOD__T_LC__data2: {
#line 1097
#define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1097
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__data2))
#line 1097
  #line 1094 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1097 "filter/f-inst.c"
#undef item
#line 1097
  dest->items[pos].fi_code = what->fi_code;
#line 1097
  dest->items[pos].flags = what->flags;
#line 1097
  dest->items[pos].lineno = what->lineno;
#line 1097
  break;
#line 1097
}
#line 1097

#line 1100 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__min */
#line 1100
case FI_METHOD__T_CLIST__min: {
#line 1100
#define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1100
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__min))
#line 1100
  #line 1097 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1100 "filter/f-inst.c"
#undef item
#line 1100
  dest->items[pos].fi_code = what->fi_code;
#line 1100
  dest->items[pos].flags = what->flags;
#line 1100
  dest->items[pos].lineno = what->lineno;
#line 1100
  break;
#line 1100
}
#line 1100

#line 1103 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__max */
#line 1103
case FI_METHOD__T_CLIST__max: {
#line 1103
#define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1103
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__max))
#line 1103
  #line 1100 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1103 "filter/f-inst.c"
#undef item
#line 1103
  dest->items[pos].fi_code = what->fi_code;
#line 1103
  dest->items[pos].flags = what->flags;
#line 1103
  dest->items[pos].lineno = what->lineno;
#line 1103
  break;
#line 1103
}
#line 1103

#line 1106 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__min */
#line 1106
case FI_METHOD__T_ECLIST__min: {
#line 1106
#define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1106
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__min))
#line 1106
  #line 1103 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1106 "filter/f-inst.c"
#undef item
#line 1106
  dest->items[pos].fi_code = what->fi_code;
#line 1106
  dest->items[pos].flags = what->flags;
#line 1106
  dest->items[pos].lineno = what->lineno;
#line 1106
  break;
#line 1106
}
#line 1106

#line 1109 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__max */
#line 1109
case FI_METHOD__T_ECLIST__max: {
#line 1109
#define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1109
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__max))
#line 1109
  #line 1106 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1109 "filter/f-inst.c"
#undef item
#line 1109
  dest->items[pos].fi_code = what->fi_code;
#line 1109
  dest->items[pos].flags = what->flags;
#line 1109
  dest->items[pos].lineno = what->lineno;
#line 1109
  break;
#line 1109
}
#line 1109

#line 1112 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__min */
#line 1112
case FI_METHOD__T_LCLIST__min: {
#line 1112
#define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1112
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__min))
#line 1112
  #line 1109 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1112 "filter/f-inst.c"
#undef item
#line 1112
  dest->items[pos].fi_code = what->fi_code;
#line 1112
  dest->items[pos].flags = what->flags;
#line 1112
  dest->items[pos].lineno = what->lineno;
#line 1112
  break;
#line 1112
}
#line 1112

#line 1114 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__max */
#line 1114
case FI_METHOD__T_LCLIST__max: {
#line 1114
#define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1114
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__max))
#line 1114
  #line 1112 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1114 "filter/f-inst.c"
#undef item
#line 1114
  dest->items[pos].fi_code = what->fi_code;
#line 1114
  dest->items[pos].flags = what->flags;
#line 1114
  dest->items[pos].lineno = what->lineno;
#line 1114
  break;
#line 1114
}
#line 1114

#line 1140 "filter/f-inst.c"
 /* Linearize for FI_RETURN */
#line 1140
case FI_RETURN: {
#line 1140
#define whati (&(what->i_FI_RETURN))
#line 1140
#define item (&(dest->items[pos].i_FI_RETURN))
#line 1140
  #line 1117 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1140 "filter/f-inst.c"
#undef item
#line 1140
  dest->items[pos].fi_code = what->fi_code;
#line 1140
  dest->items[pos].flags = what->flags;
#line 1140
  dest->items[pos].lineno = what->lineno;
#line 1140
  break;
#line 1140
}
#line 1140

#line 1200 "filter/f-inst.c"
 /* Linearize for FI_CALL */
#line 1200
case FI_CALL: {
#line 1200
#define whati (&(what->i_FI_CALL))
#line 1200
#define item (&(dest->items[pos].i_FI_CALL))
#line 1200
  #line 1142 "filter/f-inst.c"
  pos = linearize(dest, whati->fvar, pos);
#line 1142
  item->varcount = whati->varcount;
#line 1143 "filter/f-inst.c"
item->sym = whati->sym;
#line 1143

#undef whati
#line 1200 "filter/f-inst.c"
#undef item
#line 1200
  dest->items[pos].fi_code = what->fi_code;
#line 1200
  dest->items[pos].flags = what->flags;
#line 1200
  dest->items[pos].lineno = what->lineno;
#line 1200
  break;
#line 1200
}
#line 1200

#line 1205 "filter/f-inst.c"
 /* Linearize for FI_DROP_RESULT */
#line 1205
case FI_DROP_RESULT: {
#line 1205
#define whati (&(what->i_FI_DROP_RESULT))
#line 1205
#define item (&(dest->items[pos].i_FI_DROP_RESULT))
#line 1205
  #line 1202 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1205 "filter/f-inst.c"
#undef item
#line 1205
  dest->items[pos].fi_code = what->fi_code;
#line 1205
  dest->items[pos].flags = what->flags;
#line 1205
  dest->items[pos].lineno = what->lineno;
#line 1205
  break;
#line 1205
}
#line 1205

#line 1246 "filter/f-inst.c"
 /* Linearize for FI_SWITCH */
#line 1246
case FI_SWITCH: {
#line 1246
#define whati (&(what->i_FI_SWITCH))
#line 1246
#define item (&(dest->items[pos].i_FI_SWITCH))
#line 1246
  #line 1206 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1208 "filter/f-inst.c"
item->tree = whati->tree;
#line 1208


#line 1211 "filter/f-inst.c"
    /* Linearize all branches in switch */
    struct f_inst *last_inst = NULL;
    struct f_line *last_line = NULL;
    for (struct f_tree *t = whati->tree; t; t = t->left)
    {
      if (t->data != last_inst)
      {
	last_inst = t->data;
	last_line = f_linearize(t->data, 0);
      }

      t->data = last_line;
    }

    /* Balance the tree */
    item->tree = build_tree(whati->tree);

    #undef whati
#line 1246 "filter/f-inst.c"
#undef item
#line 1246
  dest->items[pos].fi_code = what->fi_code;
#line 1246
  dest->items[pos].flags = what->flags;
#line 1246
  dest->items[pos].lineno = what->lineno;
#line 1246
  break;
#line 1246
}
#line 1246

#line 1255 "filter/f-inst.c"
 /* Linearize for FI_IP_MASK */
#line 1255
case FI_IP_MASK: {
#line 1255
#define whati (&(what->i_FI_IP_MASK))
#line 1255
#define item (&(dest->items[pos].i_FI_IP_MASK))
#line 1255
  #line 1247 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1248 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1255 "filter/f-inst.c"
#undef item
#line 1255
  dest->items[pos].fi_code = what->fi_code;
#line 1255
  dest->items[pos].flags = what->flags;
#line 1255
  dest->items[pos].lineno = what->lineno;
#line 1255
  break;
#line 1255
}
#line 1255

#line 1263 "filter/f-inst.c"
 /* Linearize for FI_PATH_PREPEND */
#line 1263
case FI_PATH_PREPEND: {
#line 1263
#define whati (&(what->i_FI_PATH_PREPEND))
#line 1263
#define item (&(dest->items[pos].i_FI_PATH_PREPEND))
#line 1263
  #line 1256 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1257 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1263 "filter/f-inst.c"
#undef item
#line 1263
  dest->items[pos].fi_code = what->fi_code;
#line 1263
  dest->items[pos].flags = what->flags;
#line 1263
  dest->items[pos].lineno = what->lineno;
#line 1263
  break;
#line 1263
}
#line 1263

#line 1270 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_PAIR */
#line 1270
case FI_CLIST_ADD_PAIR: {
#line 1270
#define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1270
#define item (&(dest->items[pos].i_FI_CLIST_ADD_PAIR))
#line 1270
  #line 1264 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1265 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1270 "filter/f-inst.c"
#undef item
#line 1270
  dest->items[pos].fi_code = what->fi_code;
#line 1270
  dest->items[pos].flags = what->flags;
#line 1270
  dest->items[pos].lineno = what->lineno;
#line 1270
  break;
#line 1270
}
#line 1270

#line 1284 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_IP */
#line 1284
case FI_CLIST_ADD_IP: {
#line 1284
#define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1284
#define item (&(dest->items[pos].i_FI_CLIST_ADD_IP))
#line 1284
  #line 1271 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1272 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1284 "filter/f-inst.c"
#undef item
#line 1284
  dest->items[pos].fi_code = what->fi_code;
#line 1284
  dest->items[pos].flags = what->flags;
#line 1284
  dest->items[pos].lineno = what->lineno;
#line 1284
  break;
#line 1284
}
#line 1284

#line 1291 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_QUAD */
#line 1291
case FI_CLIST_ADD_QUAD: {
#line 1291
#define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1291
#define item (&(dest->items[pos].i_FI_CLIST_ADD_QUAD))
#line 1291
  #line 1285 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1286 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1291 "filter/f-inst.c"
#undef item
#line 1291
  dest->items[pos].fi_code = what->fi_code;
#line 1291
  dest->items[pos].flags = what->flags;
#line 1291
  dest->items[pos].lineno = what->lineno;
#line 1291
  break;
#line 1291
}
#line 1291

#line 1298 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_CLIST */
#line 1298
case FI_CLIST_ADD_CLIST: {
#line 1298
#define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1298
#define item (&(dest->items[pos].i_FI_CLIST_ADD_CLIST))
#line 1298
  #line 1292 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1293 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1298 "filter/f-inst.c"
#undef item
#line 1298
  dest->items[pos].fi_code = what->fi_code;
#line 1298
  dest->items[pos].flags = what->flags;
#line 1298
  dest->items[pos].lineno = what->lineno;
#line 1298
  break;
#line 1298
}
#line 1298

#line 1305 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_ADD_EC */
#line 1305
case FI_ECLIST_ADD_EC: {
#line 1305
#define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1305
#define item (&(dest->items[pos].i_FI_ECLIST_ADD_EC))
#line 1305
  #line 1299 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1300 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1305 "filter/f-inst.c"
#undef item
#line 1305
  dest->items[pos].fi_code = what->fi_code;
#line 1305
  dest->items[pos].flags = what->flags;
#line 1305
  dest->items[pos].lineno = what->lineno;
#line 1305
  break;
#line 1305
}
#line 1305

#line 1312 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_ADD_ECLIST */
#line 1312
case FI_ECLIST_ADD_ECLIST: {
#line 1312
#define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1312
#define item (&(dest->items[pos].i_FI_ECLIST_ADD_ECLIST))
#line 1312
  #line 1306 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1307 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1312 "filter/f-inst.c"
#undef item
#line 1312
  dest->items[pos].fi_code = what->fi_code;
#line 1312
  dest->items[pos].flags = what->flags;
#line 1312
  dest->items[pos].lineno = what->lineno;
#line 1312
  break;
#line 1312
}
#line 1312

#line 1319 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_ADD_LC */
#line 1319
case FI_LCLIST_ADD_LC: {
#line 1319
#define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1319
#define item (&(dest->items[pos].i_FI_LCLIST_ADD_LC))
#line 1319
  #line 1313 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1314 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1319 "filter/f-inst.c"
#undef item
#line 1319
  dest->items[pos].fi_code = what->fi_code;
#line 1319
  dest->items[pos].flags = what->flags;
#line 1319
  dest->items[pos].lineno = what->lineno;
#line 1319
  break;
#line 1319
}
#line 1319

#line 1326 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_ADD_LCLIST */
#line 1326
case FI_LCLIST_ADD_LCLIST: {
#line 1326
#define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1326
#define item (&(dest->items[pos].i_FI_LCLIST_ADD_LCLIST))
#line 1326
  #line 1320 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1321 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1326 "filter/f-inst.c"
#undef item
#line 1326
  dest->items[pos].fi_code = what->fi_code;
#line 1326
  dest->items[pos].flags = what->flags;
#line 1326
  dest->items[pos].lineno = what->lineno;
#line 1326
  break;
#line 1326
}
#line 1326

#line 1333 "filter/f-inst.c"
 /* Linearize for FI_PATH_DELETE_INT */
#line 1333
case FI_PATH_DELETE_INT: {
#line 1333
#define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1333
#define item (&(dest->items[pos].i_FI_PATH_DELETE_INT))
#line 1333
  #line 1327 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1328 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1333 "filter/f-inst.c"
#undef item
#line 1333
  dest->items[pos].fi_code = what->fi_code;
#line 1333
  dest->items[pos].flags = what->flags;
#line 1333
  dest->items[pos].lineno = what->lineno;
#line 1333
  break;
#line 1333
}
#line 1333

#line 1345 "filter/f-inst.c"
 /* Linearize for FI_PATH_DELETE_SET */
#line 1345
case FI_PATH_DELETE_SET: {
#line 1345
#define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1345
#define item (&(dest->items[pos].i_FI_PATH_DELETE_SET))
#line 1345
  #line 1334 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1335 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1345 "filter/f-inst.c"
#undef item
#line 1345
  dest->items[pos].fi_code = what->fi_code;
#line 1345
  dest->items[pos].flags = what->flags;
#line 1345
  dest->items[pos].lineno = what->lineno;
#line 1345
  break;
#line 1345
}
#line 1345

#line 1352 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_PAIR */
#line 1352
case FI_CLIST_DELETE_PAIR: {
#line 1352
#define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1352
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_PAIR))
#line 1352
  #line 1346 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1347 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1352 "filter/f-inst.c"
#undef item
#line 1352
  dest->items[pos].fi_code = what->fi_code;
#line 1352
  dest->items[pos].flags = what->flags;
#line 1352
  dest->items[pos].lineno = what->lineno;
#line 1352
  break;
#line 1352
}
#line 1352

#line 1366 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_IP */
#line 1366
case FI_CLIST_DELETE_IP: {
#line 1366
#define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1366
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_IP))
#line 1366
  #line 1353 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1354 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1366 "filter/f-inst.c"
#undef item
#line 1366
  dest->items[pos].fi_code = what->fi_code;
#line 1366
  dest->items[pos].flags = what->flags;
#line 1366
  dest->items[pos].lineno = what->lineno;
#line 1366
  break;
#line 1366
}
#line 1366

#line 1373 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_QUAD */
#line 1373
case FI_CLIST_DELETE_QUAD: {
#line 1373
#define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1373
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_QUAD))
#line 1373
  #line 1367 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1368 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1373 "filter/f-inst.c"
#undef item
#line 1373
  dest->items[pos].fi_code = what->fi_code;
#line 1373
  dest->items[pos].flags = what->flags;
#line 1373
  dest->items[pos].lineno = what->lineno;
#line 1373
  break;
#line 1373
}
#line 1373

#line 1380 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_CLIST */
#line 1380
case FI_CLIST_DELETE_CLIST: {
#line 1380
#define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1380
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_CLIST))
#line 1380
  #line 1374 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1375 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1380 "filter/f-inst.c"
#undef item
#line 1380
  dest->items[pos].fi_code = what->fi_code;
#line 1380
  dest->items[pos].flags = what->flags;
#line 1380
  dest->items[pos].lineno = what->lineno;
#line 1380
  break;
#line 1380
}
#line 1380

#line 1391 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_SET */
#line 1391
case FI_CLIST_DELETE_SET: {
#line 1391
#define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1391
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_SET))
#line 1391
  #line 1381 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1382 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1391 "filter/f-inst.c"
#undef item
#line 1391
  dest->items[pos].fi_code = what->fi_code;
#line 1391
  dest->items[pos].flags = what->flags;
#line 1391
  dest->items[pos].lineno = what->lineno;
#line 1391
  break;
#line 1391
}
#line 1391

#line 1398 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_EC */
#line 1398
case FI_ECLIST_DELETE_EC: {
#line 1398
#define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1398
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_EC))
#line 1398
  #line 1392 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1393 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1398 "filter/f-inst.c"
#undef item
#line 1398
  dest->items[pos].fi_code = what->fi_code;
#line 1398
  dest->items[pos].flags = what->flags;
#line 1398
  dest->items[pos].lineno = what->lineno;
#line 1398
  break;
#line 1398
}
#line 1398

#line 1405 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_ECLIST */
#line 1405
case FI_ECLIST_DELETE_ECLIST: {
#line 1405
#define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1405
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_ECLIST))
#line 1405
  #line 1399 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1400 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1405 "filter/f-inst.c"
#undef item
#line 1405
  dest->items[pos].fi_code = what->fi_code;
#line 1405
  dest->items[pos].flags = what->flags;
#line 1405
  dest->items[pos].lineno = what->lineno;
#line 1405
  break;
#line 1405
}
#line 1405

#line 1416 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_SET */
#line 1416
case FI_ECLIST_DELETE_SET: {
#line 1416
#define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1416
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_SET))
#line 1416
  #line 1406 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1407 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1416 "filter/f-inst.c"
#undef item
#line 1416
  dest->items[pos].fi_code = what->fi_code;
#line 1416
  dest->items[pos].flags = what->flags;
#line 1416
  dest->items[pos].lineno = what->lineno;
#line 1416
  break;
#line 1416
}
#line 1416

#line 1423 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_LC */
#line 1423
case FI_LCLIST_DELETE_LC: {
#line 1423
#define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1423
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_LC))
#line 1423
  #line 1417 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1418 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1423 "filter/f-inst.c"
#undef item
#line 1423
  dest->items[pos].fi_code = what->fi_code;
#line 1423
  dest->items[pos].flags = what->flags;
#line 1423
  dest->items[pos].lineno = what->lineno;
#line 1423
  break;
#line 1423
}
#line 1423

#line 1430 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_LCLIST */
#line 1430
case FI_LCLIST_DELETE_LCLIST: {
#line 1430
#define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1430
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_LCLIST))
#line 1430
  #line 1424 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1425 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1430 "filter/f-inst.c"
#undef item
#line 1430
  dest->items[pos].fi_code = what->fi_code;
#line 1430
  dest->items[pos].flags = what->flags;
#line 1430
  dest->items[pos].lineno = what->lineno;
#line 1430
  break;
#line 1430
}
#line 1430

#line 1441 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_SET */
#line 1441
case FI_LCLIST_DELETE_SET: {
#line 1441
#define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1441
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_SET))
#line 1441
  #line 1431 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1432 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1441 "filter/f-inst.c"
#undef item
#line 1441
  dest->items[pos].fi_code = what->fi_code;
#line 1441
  dest->items[pos].flags = what->flags;
#line 1441
  dest->items[pos].lineno = what->lineno;
#line 1441
  break;
#line 1441
}
#line 1441

#line 1452 "filter/f-inst.c"
 /* Linearize for FI_PATH_FILTER_SET */
#line 1452
case FI_PATH_FILTER_SET: {
#line 1452
#define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1452
#define item (&(dest->items[pos].i_FI_PATH_FILTER_SET))
#line 1452
  #line 1442 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1443 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1452 "filter/f-inst.c"
#undef item
#line 1452
  dest->items[pos].fi_code = what->fi_code;
#line 1452
  dest->items[pos].flags = what->flags;
#line 1452
  dest->items[pos].lineno = what->lineno;
#line 1452
  break;
#line 1452
}
#line 1452

#line 1459 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FILTER_CLIST */
#line 1459
case FI_CLIST_FILTER_CLIST: {
#line 1459
#define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1459
#define item (&(dest->items[pos].i_FI_CLIST_FILTER_CLIST))
#line 1459
  #line 1453 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1454 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1459 "filter/f-inst.c"
#undef item
#line 1459
  dest->items[pos].fi_code = what->fi_code;
#line 1459
  dest->items[pos].flags = what->flags;
#line 1459
  dest->items[pos].lineno = what->lineno;
#line 1459
  break;
#line 1459
}
#line 1459

#line 1470 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FILTER_SET */
#line 1470
case FI_CLIST_FILTER_SET: {
#line 1470
#define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1470
#define item (&(dest->items[pos].i_FI_CLIST_FILTER_SET))
#line 1470
  #line 1460 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1461 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1470 "filter/f-inst.c"
#undef item
#line 1470
  dest->items[pos].fi_code = what->fi_code;
#line 1470
  dest->items[pos].flags = what->flags;
#line 1470
  dest->items[pos].lineno = what->lineno;
#line 1470
  break;
#line 1470
}
#line 1470

#line 1477 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FILTER_ECLIST */
#line 1477
case FI_ECLIST_FILTER_ECLIST: {
#line 1477
#define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1477
#define item (&(dest->items[pos].i_FI_ECLIST_FILTER_ECLIST))
#line 1477
  #line 1471 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1472 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1477 "filter/f-inst.c"
#undef item
#line 1477
  dest->items[pos].fi_code = what->fi_code;
#line 1477
  dest->items[pos].flags = what->flags;
#line 1477
  dest->items[pos].lineno = what->lineno;
#line 1477
  break;
#line 1477
}
#line 1477

#line 1488 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FILTER_SET */
#line 1488
case FI_ECLIST_FILTER_SET: {
#line 1488
#define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1488
#define item (&(dest->items[pos].i_FI_ECLIST_FILTER_SET))
#line 1488
  #line 1478 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1479 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1488 "filter/f-inst.c"
#undef item
#line 1488
  dest->items[pos].fi_code = what->fi_code;
#line 1488
  dest->items[pos].flags = what->flags;
#line 1488
  dest->items[pos].lineno = what->lineno;
#line 1488
  break;
#line 1488
}
#line 1488

#line 1495 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FILTER_LCLIST */
#line 1495
case FI_LCLIST_FILTER_LCLIST: {
#line 1495
#define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1495
#define item (&(dest->items[pos].i_FI_LCLIST_FILTER_LCLIST))
#line 1495
  #line 1489 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1490 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1495 "filter/f-inst.c"
#undef item
#line 1495
  dest->items[pos].fi_code = what->fi_code;
#line 1495
  dest->items[pos].flags = what->flags;
#line 1495
  dest->items[pos].lineno = what->lineno;
#line 1495
  break;
#line 1495
}
#line 1495

#line 1506 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FILTER_SET */
#line 1506
case FI_LCLIST_FILTER_SET: {
#line 1506
#define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1506
#define item (&(dest->items[pos].i_FI_LCLIST_FILTER_SET))
#line 1506
  #line 1496 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1497 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1506 "filter/f-inst.c"
#undef item
#line 1506
  dest->items[pos].fi_code = what->fi_code;
#line 1506
  dest->items[pos].flags = what->flags;
#line 1506
  dest->items[pos].lineno = what->lineno;
#line 1506
  break;
#line 1506
}
#line 1506

#line 1528 "filter/f-inst.c"
 /* Linearize for FI_ROA_CHECK */
#line 1528
case FI_ROA_CHECK: {
#line 1528
#define whati (&(what->i_FI_ROA_CHECK))
#line 1528
#define item (&(dest->items[pos].i_FI_ROA_CHECK))
#line 1528
  #line 1508 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1509 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 1510 "filter/f-inst.c"
item->rtc = whati->rtc;
#line 1510

#undef whati
#line 1528 "filter/f-inst.c"
#undef item
#line 1528
  dest->items[pos].fi_code = what->fi_code;
#line 1528
  dest->items[pos].flags = what->flags;
#line 1528
  dest->items[pos].lineno = what->lineno;
#line 1528
  break;
#line 1528
}
#line 1528

#line 1544 "filter/f-inst.c"
 /* Linearize for FI_ASPA_CHECK_EXPLICIT */
#line 1544
case FI_ASPA_CHECK_EXPLICIT: {
#line 1544
#define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1544
#define item (&(dest->items[pos].i_FI_ASPA_CHECK_EXPLICIT))
#line 1544
  #line 1530 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1531 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 1532 "filter/f-inst.c"
item->rtc = whati->rtc;
#line 1532

#undef whati
#line 1544 "filter/f-inst.c"
#undef item
#line 1544
  dest->items[pos].fi_code = what->fi_code;
#line 1544
  dest->items[pos].flags = what->flags;
#line 1544
  dest->items[pos].lineno = what->lineno;
#line 1544
  break;
#line 1544
}
#line 1544

#line 1559 "filter/f-inst.c"
 /* Linearize for FI_FROM_HEX */
#line 1559
case FI_FROM_HEX: {
#line 1559
#define whati (&(what->i_FI_FROM_HEX))
#line 1559
#define item (&(dest->items[pos].i_FI_FROM_HEX))
#line 1559
  #line 1545 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1559 "filter/f-inst.c"
#undef item
#line 1559
  dest->items[pos].fi_code = what->fi_code;
#line 1559
  dest->items[pos].flags = what->flags;
#line 1559
  dest->items[pos].lineno = what->lineno;
#line 1559
  break;
#line 1559
}
#line 1559

#line 1564 "filter/f-inst.c"
 /* Linearize for FI_FORMAT */
#line 1564
case FI_FORMAT: {
#line 1564
#define whati (&(what->i_FI_FORMAT))
#line 1564
#define item (&(dest->items[pos].i_FI_FORMAT))
#line 1564
  #line 1560 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1564 "filter/f-inst.c"
#undef item
#line 1564
  dest->items[pos].fi_code = what->fi_code;
#line 1564
  dest->items[pos].flags = what->flags;
#line 1564
  dest->items[pos].lineno = what->lineno;
#line 1564
  break;
#line 1564
}
#line 1564

#line 830 "filter/decl.m4"
 /* Linearize for FI_ASSERT */
#line 830
case FI_ASSERT: {
#line 830
#define whati (&(what->i_FI_ASSERT))
#line 830
#define item (&(dest->items[pos].i_FI_ASSERT))
#line 830
  #line 1566 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1568 "filter/f-inst.c"
item->s = whati->s;
#line 1568

#undef whati
#line 830 "filter/decl.m4"
#undef item
#line 830
  dest->items[pos].fi_code = what->fi_code;
#line 830
  dest->items[pos].flags = what->flags;
#line 830
  dest->items[pos].lineno = what->lineno;
#line 830
  break;
#line 830
}
#line 830

#line 708 "filter/decl.m4"

    }
    pos++;
  }
  return pos;
}

struct f_line *
f_linearize_concat(const struct f_inst * const inst[], uint count, uint results)
{
  uint len = 0;
  for (uint i=0; i<count; i++)
    for (const struct f_inst *what = inst[i]; what; what = what->next)
      len += what->size;

  struct f_line *out = cfg_allocz(sizeof(struct f_line) + sizeof(struct f_line_item)*len);

  for (uint i=0; i<count; i++)
    out->len = linearize(out, inst[i], out->len);

  out->results = results;
  return out;
}

/* Filter line comparison */
int
f_same(const struct f_line *fl1, const struct f_line *fl2)
{
  if ((!fl1) && (!fl2))
    return 1;
  if ((!fl1) || (!fl2))
    return 0;
  if (fl1->len != fl2->len)
    return 0;
  for (uint i=0; i<fl1->len; i++) {
#define f1_ (&(fl1->items[i]))
#define f2_ (&(fl2->items[i]))
    if (f1_->fi_code != f2_->fi_code)
      return 0;
    if (f1_->flags != f2_->flags)
      return 0;

    switch(f1_->fi_code) {
#line 288 "filter/f-inst.c"
 /* Comparison for FI_ADD */
#line 288
case FI_ADD:
#line 288
#define f1 (&(f1_->i_FI_ADD))
#line 288
#define f2 (&(f2_->i_FI_ADD))
#line 288
#undef f1
#line 288
#undef f2
#line 288
break;
#line 288

#line 293 "filter/f-inst.c"
 /* Comparison for FI_SUBTRACT */
#line 293
case FI_SUBTRACT:
#line 293
#define f1 (&(f1_->i_FI_SUBTRACT))
#line 293
#define f2 (&(f2_->i_FI_SUBTRACT))
#line 293
#undef f1
#line 293
#undef f2
#line 293
break;
#line 293

#line 298 "filter/f-inst.c"
 /* Comparison for FI_MULTIPLY */
#line 298
case FI_MULTIPLY:
#line 298
#define f1 (&(f1_->i_FI_MULTIPLY))
#line 298
#define f2 (&(f2_->i_FI_MULTIPLY))
#line 298
#undef f1
#line 298
#undef f2
#line 298
break;
#line 298

#line 304 "filter/f-inst.c"
 /* Comparison for FI_DIVIDE */
#line 304
case FI_DIVIDE:
#line 304
#define f1 (&(f1_->i_FI_DIVIDE))
#line 304
#define f2 (&(f2_->i_FI_DIVIDE))
#line 304
#undef f1
#line 304
#undef f2
#line 304
break;
#line 304

#line 309 "filter/f-inst.c"
 /* Comparison for FI_BITOR */
#line 309
case FI_BITOR:
#line 309
#define f1 (&(f1_->i_FI_BITOR))
#line 309
#define f2 (&(f2_->i_FI_BITOR))
#line 309
#undef f1
#line 309
#undef f2
#line 309
break;
#line 309

#line 314 "filter/f-inst.c"
 /* Comparison for FI_BITAND */
#line 314
case FI_BITAND:
#line 314
#define f1 (&(f1_->i_FI_BITAND))
#line 314
#define f2 (&(f2_->i_FI_BITAND))
#line 314
#undef f1
#line 314
#undef f2
#line 314
break;
#line 314

#line 324 "filter/f-inst.c"
 /* Comparison for FI_AND */
#line 324
case FI_AND:
#line 324
#define f1 (&(f1_->i_FI_AND))
#line 324
#define f2 (&(f2_->i_FI_AND))
#line 320 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 324 "filter/f-inst.c"
#undef f1
#line 324
#undef f2
#line 324
break;
#line 324

#line 335 "filter/f-inst.c"
 /* Comparison for FI_OR */
#line 335
case FI_OR:
#line 335
#define f1 (&(f1_->i_FI_OR))
#line 335
#define f2 (&(f2_->i_FI_OR))
#line 330 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 335 "filter/f-inst.c"
#undef f1
#line 335
#undef f2
#line 335
break;
#line 335

#line 345 "filter/f-inst.c"
 /* Comparison for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT:
#line 345
#define f1 (&(f1_->i_FI_PAIR_CONSTRUCT))
#line 345
#define f2 (&(f2_->i_FI_PAIR_CONSTRUCT))
#line 345
#undef f1
#line 345
#undef f2
#line 345
break;
#line 345

#line 385 "filter/f-inst.c"
 /* Comparison for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT:
#line 385
#define f1 (&(f1_->i_FI_EC_CONSTRUCT))
#line 385
#define f2 (&(f2_->i_FI_EC_CONSTRUCT))
#line 349 "filter/f-inst.c"
if (f1->ecs != f2->ecs) return 0;
#line 349

#line 349

#line 385 "filter/f-inst.c"
#undef f1
#line 385
#undef f2
#line 385
break;
#line 385

#line 392 "filter/f-inst.c"
 /* Comparison for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT:
#line 392
#define f1 (&(f1_->i_FI_LC_CONSTRUCT))
#line 392
#define f2 (&(f2_->i_FI_LC_CONSTRUCT))
#line 392
#undef f1
#line 392
#undef f2
#line 392
break;
#line 392

#line 442 "filter/f-inst.c"
 /* Comparison for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT:
#line 442
#define f1 (&(f1_->i_FI_PATHMASK_CONSTRUCT))
#line 442
#define f2 (&(f2_->i_FI_PATHMASK_CONSTRUCT))
#line 393 "filter/f-inst.c"
  if (f1->varcount != f2->varcount) return 0;
#line 442 "filter/f-inst.c"
#undef f1
#line 442
#undef f2
#line 442
break;
#line 442

#line 449 "filter/f-inst.c"
 /* Comparison for FI_NEQ */
#line 449
case FI_NEQ:
#line 449
#define f1 (&(f1_->i_FI_NEQ))
#line 449
#define f2 (&(f2_->i_FI_NEQ))
#line 449
#undef f1
#line 449
#undef f2
#line 449
break;
#line 449

#line 456 "filter/f-inst.c"
 /* Comparison for FI_EQ */
#line 456
case FI_EQ:
#line 456
#define f1 (&(f1_->i_FI_EQ))
#line 456
#define f2 (&(f2_->i_FI_EQ))
#line 456
#undef f1
#line 456
#undef f2
#line 456
break;
#line 456

#line 467 "filter/f-inst.c"
 /* Comparison for FI_LT */
#line 467
case FI_LT:
#line 467
#define f1 (&(f1_->i_FI_LT))
#line 467
#define f2 (&(f2_->i_FI_LT))
#line 467
#undef f1
#line 467
#undef f2
#line 467
break;
#line 467

#line 478 "filter/f-inst.c"
 /* Comparison for FI_LTE */
#line 478
case FI_LTE:
#line 478
#define f1 (&(f1_->i_FI_LTE))
#line 478
#define f2 (&(f2_->i_FI_LTE))
#line 478
#undef f1
#line 478
#undef f2
#line 478
break;
#line 478

#line 483 "filter/f-inst.c"
 /* Comparison for FI_NOT */
#line 483
case FI_NOT:
#line 483
#define f1 (&(f1_->i_FI_NOT))
#line 483
#define f2 (&(f2_->i_FI_NOT))
#line 483
#undef f1
#line 483
#undef f2
#line 483
break;
#line 483

#line 492 "filter/f-inst.c"
 /* Comparison for FI_MATCH */
#line 492
case FI_MATCH:
#line 492
#define f1 (&(f1_->i_FI_MATCH))
#line 492
#define f2 (&(f2_->i_FI_MATCH))
#line 492
#undef f1
#line 492
#undef f2
#line 492
break;
#line 492

#line 501 "filter/f-inst.c"
 /* Comparison for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH:
#line 501
#define f1 (&(f1_->i_FI_NOT_MATCH))
#line 501
#define f2 (&(f2_->i_FI_NOT_MATCH))
#line 501
#undef f1
#line 501
#undef f2
#line 501
break;
#line 501

#line 506 "filter/f-inst.c"
 /* Comparison for FI_DEFINED */
#line 506
case FI_DEFINED:
#line 506
#define f1 (&(f1_->i_FI_DEFINED))
#line 506
#define f2 (&(f2_->i_FI_DEFINED))
#line 506
#undef f1
#line 506
#undef f2
#line 506
break;
#line 506

#line 507 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type:
#line 507
#define f1 (&(f1_->i_FI_METHOD__T_NET__type))
#line 507
#define f2 (&(f2_->i_FI_METHOD__T_NET__type))
#line 507
#undef f1
#line 507
#undef f2
#line 507
break;
#line 507

#line 510 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4:
#line 510
#define f1 (&(f1_->i_FI_METHOD__T_IP__is_v4))
#line 510
#define f2 (&(f2_->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef f1
#line 510
#undef f2
#line 510
break;
#line 510

#line 523 "filter/f-inst.c"
 /* Comparison for FI_VAR_INIT */
#line 523
case FI_VAR_INIT:
#line 523
#define f1 (&(f1_->i_FI_VAR_INIT))
#line 523
#define f2 (&(f2_->i_FI_VAR_INIT))
#line 513 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 513

#line 513

#line 523 "filter/f-inst.c"
#undef f1
#line 523
#undef f2
#line 523
break;
#line 523

#line 534 "filter/f-inst.c"
 /* Comparison for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0:
#line 534
#define f1 (&(f1_->i_FI_VAR_INIT0))
#line 534
#define f2 (&(f2_->i_FI_VAR_INIT0))
#line 525 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 525

#line 525

#line 534 "filter/f-inst.c"
#undef f1
#line 534
#undef f2
#line 534
break;
#line 534

#line 543 "filter/f-inst.c"
 /* Comparison for FI_VAR_SET */
#line 543
case FI_VAR_SET:
#line 543
#define f1 (&(f1_->i_FI_VAR_SET))
#line 543
#define f2 (&(f2_->i_FI_VAR_SET))
#line 537 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 537

#line 537

#line 543 "filter/f-inst.c"
#undef f1
#line 543
#undef f2
#line 543
break;
#line 543

#line 550 "filter/f-inst.c"
 /* Comparison for FI_VAR_GET */
#line 550
case FI_VAR_GET:
#line 550
#define f1 (&(f1_->i_FI_VAR_GET))
#line 550
#define f2 (&(f2_->i_FI_VAR_GET))
#line 544 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 544

#line 544

#line 550 "filter/f-inst.c"
#undef f1
#line 550
#undef f2
#line 550
break;
#line 550

#line 563 "filter/f-inst.c"
 /* Comparison for FI_CONSTANT */
#line 563
case FI_CONSTANT:
#line 563
#define f1 (&(f1_->i_FI_CONSTANT))
#line 563
#define f2 (&(f2_->i_FI_CONSTANT))
#line 551 "filter/f-inst.c"
if ( !val_same(&(f1->val), &(f2->val)) ) return 0;
#line 551

#line 551

#line 563 "filter/f-inst.c"
#undef f1
#line 563
#undef f2
#line 563
break;
#line 563

#line 564 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty:
#line 564
#define f1 (&(f1_->i_FI_METHOD__T_PATH__empty))
#line 564
#define f2 (&(f2_->i_FI_METHOD__T_PATH__empty))
#line 564
#undef f1
#line 564
#undef f2
#line 564
break;
#line 564

#line 565 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty:
#line 565
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__empty))
#line 565
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef f1
#line 565
#undef f2
#line 565
break;
#line 565

#line 566 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty:
#line 566
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef f1
#line 566
#undef f2
#line 566
break;
#line 566

#line 569 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty:
#line 569
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef f1
#line 569
#undef f2
#line 569
break;
#line 569

#line 591 "filter/f-inst.c"
 /* Comparison for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START:
#line 591
#define f1 (&(f1_->i_FI_FOR_LOOP_START))
#line 591
#define f2 (&(f2_->i_FI_FOR_LOOP_START))
#line 571 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 571

#line 571

#line 591 "filter/f-inst.c"
#undef f1
#line 591
#undef f2
#line 591
break;
#line 591

#line 600 "filter/f-inst.c"
 /* Comparison for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT:
#line 600
#define f1 (&(f1_->i_FI_PATH_FOR_NEXT))
#line 600
#define f2 (&(f2_->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 600 "filter/f-inst.c"
#undef f1
#line 600
#undef f2
#line 600
break;
#line 600

#line 609 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT:
#line 609
#define f1 (&(f1_->i_FI_CLIST_FOR_NEXT))
#line 609
#define f2 (&(f2_->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 609 "filter/f-inst.c"
#undef f1
#line 609
#undef f2
#line 609
break;
#line 609

#line 618 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT:
#line 618
#define f1 (&(f1_->i_FI_ECLIST_FOR_NEXT))
#line 618
#define f2 (&(f2_->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 618 "filter/f-inst.c"
#undef f1
#line 618
#undef f2
#line 618
break;
#line 618

#line 627 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT:
#line 627
#define f1 (&(f1_->i_FI_LCLIST_FOR_NEXT))
#line 627
#define f2 (&(f2_->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 627 "filter/f-inst.c"
#undef f1
#line 627
#undef f2
#line 627
break;
#line 627

#line 640 "filter/f-inst.c"
 /* Comparison for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT:
#line 640
#define f1 (&(f1_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
#define f2 (&(f2_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 640 "filter/f-inst.c"
#undef f1
#line 640
#undef f2
#line 640
break;
#line 640

#line 648 "filter/f-inst.c"
 /* Comparison for FI_CONDITION */
#line 648
case FI_CONDITION:
#line 648
#define f1 (&(f1_->i_FI_CONDITION))
#line 648
#define f2 (&(f2_->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 645 "filter/f-inst.c"
if (!f_same(f1->fl3, f2->fl3)) return 0;
#line 648 "filter/f-inst.c"
#undef f1
#line 648
#undef f2
#line 648
break;
#line 648

#line 661 "filter/f-inst.c"
 /* Comparison for FI_PRINT */
#line 661
case FI_PRINT:
#line 661
#define f1 (&(f1_->i_FI_PRINT))
#line 661
#define f2 (&(f2_->i_FI_PRINT))
#line 661
#undef f1
#line 661
#undef f2
#line 661
break;
#line 661

#line 668 "filter/f-inst.c"
 /* Comparison for FI_FLUSH */
#line 668
case FI_FLUSH:
#line 668
#define f1 (&(f1_->i_FI_FLUSH))
#line 668
#define f2 (&(f2_->i_FI_FLUSH))
#line 668
#undef f1
#line 668
#undef f2
#line 668
break;
#line 668

#line 682 "filter/f-inst.c"
 /* Comparison for FI_DIE */
#line 682
case FI_DIE:
#line 682
#define f1 (&(f1_->i_FI_DIE))
#line 682
#define f2 (&(f2_->i_FI_DIE))
#line 670 "filter/f-inst.c"
if (f1->fret != f2->fret) return 0;
#line 670

#line 670

#line 682 "filter/f-inst.c"
#undef f1
#line 682
#undef f2
#line 682
break;
#line 682

#line 689 "filter/f-inst.c"
 /* Comparison for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE:
#line 689
#define f1 (&(f1_->i_FI_CURRENT_ROUTE))
#line 689
#define f2 (&(f2_->i_FI_CURRENT_ROUTE))
#line 689
#undef f1
#line 689
#undef f2
#line 689
break;
#line 689

#line 736 "filter/f-inst.c"
 /* Comparison for FI_RTA_GET */
#line 736
case FI_RTA_GET:
#line 736
#define f1 (&(f1_->i_FI_RTA_GET))
#line 736
#define f2 (&(f2_->i_FI_RTA_GET))
#line 692 "filter/f-inst.c"
if (f1->sa.sa_code != f2->sa.sa_code) return 0;
#line 692

#line 692

#line 736 "filter/f-inst.c"
#undef f1
#line 736
#undef f2
#line 736
break;
#line 736

#line 864 "filter/f-inst.c"
 /* Comparison for FI_RTA_SET */
#line 864
case FI_RTA_SET:
#line 864
#define f1 (&(f1_->i_FI_RTA_SET))
#line 864
#define f2 (&(f2_->i_FI_RTA_SET))
#line 739 "filter/f-inst.c"
if (f1->sa.sa_code != f2->sa.sa_code) return 0;
#line 739

#line 739

#line 864 "filter/f-inst.c"
#undef f1
#line 864
#undef f2
#line 864
break;
#line 864

#line 901 "filter/f-inst.c"
 /* Comparison for FI_EA_GET */
#line 901
case FI_EA_GET:
#line 901
#define f1 (&(f1_->i_FI_EA_GET))
#line 901
#define f2 (&(f2_->i_FI_EA_GET))
#line 866 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 866

#line 866

#line 901 "filter/f-inst.c"
#undef f1
#line 901
#undef f2
#line 901
break;
#line 901

#line 942 "filter/f-inst.c"
 /* Comparison for FI_EA_SET */
#line 942
case FI_EA_SET:
#line 942
#define f1 (&(f1_->i_FI_EA_SET))
#line 942
#define f2 (&(f2_->i_FI_EA_SET))
#line 904 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 904

#line 904

#line 942 "filter/f-inst.c"
#undef f1
#line 942
#undef f2
#line 942
break;
#line 942

#line 949 "filter/f-inst.c"
 /* Comparison for FI_EA_UNSET */
#line 949
case FI_EA_UNSET:
#line 949
#define f1 (&(f1_->i_FI_EA_UNSET))
#line 949
#define f2 (&(f2_->i_FI_EA_UNSET))
#line 943 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 943

#line 943

#line 949 "filter/f-inst.c"
#undef f1
#line 949
#undef f2
#line 949
break;
#line 949

#line 963 "filter/f-inst.c"
 /* Comparison for FI_DEFAULT */
#line 963
case FI_DEFAULT:
#line 963
#define f1 (&(f1_->i_FI_DEFAULT))
#line 963
#define f2 (&(f2_->i_FI_DEFAULT))
#line 963
#undef f1
#line 963
#undef f2
#line 963
break;
#line 963

#line 964 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__len */
#line 964
case FI_METHOD__T_NET__len:
#line 964
#define f1 (&(f1_->i_FI_METHOD__T_NET__len))
#line 964
#define f2 (&(f2_->i_FI_METHOD__T_NET__len))
#line 964
#undef f1
#line 964
#undef f2
#line 964
break;
#line 964

#line 965 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__len */
#line 965
case FI_METHOD__T_PATH__len:
#line 965
#define f1 (&(f1_->i_FI_METHOD__T_PATH__len))
#line 965
#define f2 (&(f2_->i_FI_METHOD__T_PATH__len))
#line 965
#undef f1
#line 965
#undef f2
#line 965
break;
#line 965

#line 966 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__len */
#line 966
case FI_METHOD__T_CLIST__len:
#line 966
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__len))
#line 966
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__len))
#line 966
#undef f1
#line 966
#undef f2
#line 966
break;
#line 966

#line 967 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__len */
#line 967
case FI_METHOD__T_ECLIST__len:
#line 967
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__len))
#line 967
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__len))
#line 967
#undef f1
#line 967
#undef f2
#line 967
break;
#line 967

#line 969 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__len */
#line 969
case FI_METHOD__T_LCLIST__len:
#line 969
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__len))
#line 969
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__len))
#line 969
#undef f1
#line 969
#undef f2
#line 969
break;
#line 969

#line 1005 "filter/f-inst.c"
 /* Comparison for FI_NET_SRC */
#line 1005
case FI_NET_SRC:
#line 1005
#define f1 (&(f1_->i_FI_NET_SRC))
#line 1005
#define f2 (&(f2_->i_FI_NET_SRC))
#line 1005
#undef f1
#line 1005
#undef f2
#line 1005
break;
#line 1005

#line 1042 "filter/f-inst.c"
 /* Comparison for FI_NET_DST */
#line 1042
case FI_NET_DST:
#line 1042
#define f1 (&(f1_->i_FI_NET_DST))
#line 1042
#define f2 (&(f2_->i_FI_NET_DST))
#line 1042
#undef f1
#line 1042
#undef f2
#line 1042
break;
#line 1042

#line 1052 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__maxlen */
#line 1052
case FI_METHOD__T_NET__maxlen:
#line 1052
#define f1 (&(f1_->i_FI_METHOD__T_NET__maxlen))
#line 1052
#define f2 (&(f2_->i_FI_METHOD__T_NET__maxlen))
#line 1052
#undef f1
#line 1052
#undef f2
#line 1052
break;
#line 1052

#line 1062 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__asn */
#line 1062
case FI_METHOD__T_NET__asn:
#line 1062
#define f1 (&(f1_->i_FI_METHOD__T_NET__asn))
#line 1062
#define f2 (&(f2_->i_FI_METHOD__T_NET__asn))
#line 1062
#undef f1
#line 1062
#undef f2
#line 1062
break;
#line 1062

#line 1064 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__ip */
#line 1064
case FI_METHOD__T_NET__ip:
#line 1064
#define f1 (&(f1_->i_FI_METHOD__T_NET__ip))
#line 1064
#define f2 (&(f2_->i_FI_METHOD__T_NET__ip))
#line 1064
#undef f1
#line 1064
#undef f2
#line 1064
break;
#line 1064

#line 1073 "filter/f-inst.c"
 /* Comparison for FI_ROUTE_DISTINGUISHER */
#line 1073
case FI_ROUTE_DISTINGUISHER:
#line 1073
#define f1 (&(f1_->i_FI_ROUTE_DISTINGUISHER))
#line 1073
#define f2 (&(f2_->i_FI_ROUTE_DISTINGUISHER))
#line 1073
#undef f1
#line 1073
#undef f2
#line 1073
break;
#line 1073

#line 1076 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__first */
#line 1076
case FI_METHOD__T_PATH__first:
#line 1076
#define f1 (&(f1_->i_FI_METHOD__T_PATH__first))
#line 1076
#define f2 (&(f2_->i_FI_METHOD__T_PATH__first))
#line 1076
#undef f1
#line 1076
#undef f2
#line 1076
break;
#line 1076

#line 1079 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__last */
#line 1079
case FI_METHOD__T_PATH__last:
#line 1079
#define f1 (&(f1_->i_FI_METHOD__T_PATH__last))
#line 1079
#define f2 (&(f2_->i_FI_METHOD__T_PATH__last))
#line 1079
#undef f1
#line 1079
#undef f2
#line 1079
break;
#line 1079

#line 1082 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
case FI_METHOD__T_PATH__last_nonaggregated:
#line 1082
#define f1 (&(f1_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
#define f2 (&(f2_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
#undef f1
#line 1082
#undef f2
#line 1082
break;
#line 1082

#line 1085 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PAIR__asn */
#line 1085
case FI_METHOD__T_PAIR__asn:
#line 1085
#define f1 (&(f1_->i_FI_METHOD__T_PAIR__asn))
#line 1085
#define f2 (&(f2_->i_FI_METHOD__T_PAIR__asn))
#line 1085
#undef f1
#line 1085
#undef f2
#line 1085
break;
#line 1085

#line 1088 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PAIR__data */
#line 1088
case FI_METHOD__T_PAIR__data:
#line 1088
#define f1 (&(f1_->i_FI_METHOD__T_PAIR__data))
#line 1088
#define f2 (&(f2_->i_FI_METHOD__T_PAIR__data))
#line 1088
#undef f1
#line 1088
#undef f2
#line 1088
break;
#line 1088

#line 1091 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__asn */
#line 1091
case FI_METHOD__T_LC__asn:
#line 1091
#define f1 (&(f1_->i_FI_METHOD__T_LC__asn))
#line 1091
#define f2 (&(f2_->i_FI_METHOD__T_LC__asn))
#line 1091
#undef f1
#line 1091
#undef f2
#line 1091
break;
#line 1091

#line 1094 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__data1 */
#line 1094
case FI_METHOD__T_LC__data1:
#line 1094
#define f1 (&(f1_->i_FI_METHOD__T_LC__data1))
#line 1094
#define f2 (&(f2_->i_FI_METHOD__T_LC__data1))
#line 1094
#undef f1
#line 1094
#undef f2
#line 1094
break;
#line 1094

#line 1097 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__data2 */
#line 1097
case FI_METHOD__T_LC__data2:
#line 1097
#define f1 (&(f1_->i_FI_METHOD__T_LC__data2))
#line 1097
#define f2 (&(f2_->i_FI_METHOD__T_LC__data2))
#line 1097
#undef f1
#line 1097
#undef f2
#line 1097
break;
#line 1097

#line 1100 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__min */
#line 1100
case FI_METHOD__T_CLIST__min:
#line 1100
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__min))
#line 1100
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__min))
#line 1100
#undef f1
#line 1100
#undef f2
#line 1100
break;
#line 1100

#line 1103 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__max */
#line 1103
case FI_METHOD__T_CLIST__max:
#line 1103
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__max))
#line 1103
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__max))
#line 1103
#undef f1
#line 1103
#undef f2
#line 1103
break;
#line 1103

#line 1106 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__min */
#line 1106
case FI_METHOD__T_ECLIST__min:
#line 1106
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__min))
#line 1106
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__min))
#line 1106
#undef f1
#line 1106
#undef f2
#line 1106
break;
#line 1106

#line 1109 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__max */
#line 1109
case FI_METHOD__T_ECLIST__max:
#line 1109
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__max))
#line 1109
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__max))
#line 1109
#undef f1
#line 1109
#undef f2
#line 1109
break;
#line 1109

#line 1112 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__min */
#line 1112
case FI_METHOD__T_LCLIST__min:
#line 1112
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__min))
#line 1112
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__min))
#line 1112
#undef f1
#line 1112
#undef f2
#line 1112
break;
#line 1112

#line 1114 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__max */
#line 1114
case FI_METHOD__T_LCLIST__max:
#line 1114
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__max))
#line 1114
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__max))
#line 1114
#undef f1
#line 1114
#undef f2
#line 1114
break;
#line 1114

#line 1140 "filter/f-inst.c"
 /* Comparison for FI_RETURN */
#line 1140
case FI_RETURN:
#line 1140
#define f1 (&(f1_->i_FI_RETURN))
#line 1140
#define f2 (&(f2_->i_FI_RETURN))
#line 1140
#undef f1
#line 1140
#undef f2
#line 1140
break;
#line 1140

#line 1200 "filter/f-inst.c"
 /* Comparison for FI_CALL */
#line 1200
case FI_CALL:
#line 1200
#define f1 (&(f1_->i_FI_CALL))
#line 1200
#define f2 (&(f2_->i_FI_CALL))
#line 1142 "filter/f-inst.c"
  if (f1->varcount != f2->varcount) return 0;
#line 1143 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 1143

#line 1143


#line 1177 "filter/f-inst.c"
    if (!(f1->sym->flags & SYM_FLAG_SAME) && !(f1_->flags & FIF_RECURSIVE))
      return 0;

    #line 1200 "filter/f-inst.c"
#undef f1
#line 1200
#undef f2
#line 1200
break;
#line 1200

#line 1205 "filter/f-inst.c"
 /* Comparison for FI_DROP_RESULT */
#line 1205
case FI_DROP_RESULT:
#line 1205
#define f1 (&(f1_->i_FI_DROP_RESULT))
#line 1205
#define f2 (&(f2_->i_FI_DROP_RESULT))
#line 1205
#undef f1
#line 1205
#undef f2
#line 1205
break;
#line 1205

#line 1246 "filter/f-inst.c"
 /* Comparison for FI_SWITCH */
#line 1246
case FI_SWITCH:
#line 1246
#define f1 (&(f1_->i_FI_SWITCH))
#line 1246
#define f2 (&(f2_->i_FI_SWITCH))
#line 1208 "filter/f-inst.c"
if (!same_tree(f1->tree, f2->tree)) return 0;
#line 1208

#line 1208

#line 1246 "filter/f-inst.c"
#undef f1
#line 1246
#undef f2
#line 1246
break;
#line 1246

#line 1255 "filter/f-inst.c"
 /* Comparison for FI_IP_MASK */
#line 1255
case FI_IP_MASK:
#line 1255
#define f1 (&(f1_->i_FI_IP_MASK))
#line 1255
#define f2 (&(f2_->i_FI_IP_MASK))
#line 1255
#undef f1
#line 1255
#undef f2
#line 1255
break;
#line 1255

#line 1263 "filter/f-inst.c"
 /* Comparison for FI_PATH_PREPEND */
#line 1263
case FI_PATH_PREPEND:
#line 1263
#define f1 (&(f1_->i_FI_PATH_PREPEND))
#line 1263
#define f2 (&(f2_->i_FI_PATH_PREPEND))
#line 1263
#undef f1
#line 1263
#undef f2
#line 1263
break;
#line 1263

#line 1270 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_PAIR */
#line 1270
case FI_CLIST_ADD_PAIR:
#line 1270
#define f1 (&(f1_->i_FI_CLIST_ADD_PAIR))
#line 1270
#define f2 (&(f2_->i_FI_CLIST_ADD_PAIR))
#line 1270
#undef f1
#line 1270
#undef f2
#line 1270
break;
#line 1270

#line 1284 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_IP */
#line 1284
case FI_CLIST_ADD_IP:
#line 1284
#define f1 (&(f1_->i_FI_CLIST_ADD_IP))
#line 1284
#define f2 (&(f2_->i_FI_CLIST_ADD_IP))
#line 1284
#undef f1
#line 1284
#undef f2
#line 1284
break;
#line 1284

#line 1291 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_QUAD */
#line 1291
case FI_CLIST_ADD_QUAD:
#line 1291
#define f1 (&(f1_->i_FI_CLIST_ADD_QUAD))
#line 1291
#define f2 (&(f2_->i_FI_CLIST_ADD_QUAD))
#line 1291
#undef f1
#line 1291
#undef f2
#line 1291
break;
#line 1291

#line 1298 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_CLIST */
#line 1298
case FI_CLIST_ADD_CLIST:
#line 1298
#define f1 (&(f1_->i_FI_CLIST_ADD_CLIST))
#line 1298
#define f2 (&(f2_->i_FI_CLIST_ADD_CLIST))
#line 1298
#undef f1
#line 1298
#undef f2
#line 1298
break;
#line 1298

#line 1305 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_ADD_EC */
#line 1305
case FI_ECLIST_ADD_EC:
#line 1305
#define f1 (&(f1_->i_FI_ECLIST_ADD_EC))
#line 1305
#define f2 (&(f2_->i_FI_ECLIST_ADD_EC))
#line 1305
#undef f1
#line 1305
#undef f2
#line 1305
break;
#line 1305

#line 1312 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_ADD_ECLIST */
#line 1312
case FI_ECLIST_ADD_ECLIST:
#line 1312
#define f1 (&(f1_->i_FI_ECLIST_ADD_ECLIST))
#line 1312
#define f2 (&(f2_->i_FI_ECLIST_ADD_ECLIST))
#line 1312
#undef f1
#line 1312
#undef f2
#line 1312
break;
#line 1312

#line 1319 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_ADD_LC */
#line 1319
case FI_LCLIST_ADD_LC:
#line 1319
#define f1 (&(f1_->i_FI_LCLIST_ADD_LC))
#line 1319
#define f2 (&(f2_->i_FI_LCLIST_ADD_LC))
#line 1319
#undef f1
#line 1319
#undef f2
#line 1319
break;
#line 1319

#line 1326 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_ADD_LCLIST */
#line 1326
case FI_LCLIST_ADD_LCLIST:
#line 1326
#define f1 (&(f1_->i_FI_LCLIST_ADD_LCLIST))
#line 1326
#define f2 (&(f2_->i_FI_LCLIST_ADD_LCLIST))
#line 1326
#undef f1
#line 1326
#undef f2
#line 1326
break;
#line 1326

#line 1333 "filter/f-inst.c"
 /* Comparison for FI_PATH_DELETE_INT */
#line 1333
case FI_PATH_DELETE_INT:
#line 1333
#define f1 (&(f1_->i_FI_PATH_DELETE_INT))
#line 1333
#define f2 (&(f2_->i_FI_PATH_DELETE_INT))
#line 1333
#undef f1
#line 1333
#undef f2
#line 1333
break;
#line 1333

#line 1345 "filter/f-inst.c"
 /* Comparison for FI_PATH_DELETE_SET */
#line 1345
case FI_PATH_DELETE_SET:
#line 1345
#define f1 (&(f1_->i_FI_PATH_DELETE_SET))
#line 1345
#define f2 (&(f2_->i_FI_PATH_DELETE_SET))
#line 1345
#undef f1
#line 1345
#undef f2
#line 1345
break;
#line 1345

#line 1352 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_PAIR */
#line 1352
case FI_CLIST_DELETE_PAIR:
#line 1352
#define f1 (&(f1_->i_FI_CLIST_DELETE_PAIR))
#line 1352
#define f2 (&(f2_->i_FI_CLIST_DELETE_PAIR))
#line 1352
#undef f1
#line 1352
#undef f2
#line 1352
break;
#line 1352

#line 1366 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_IP */
#line 1366
case FI_CLIST_DELETE_IP:
#line 1366
#define f1 (&(f1_->i_FI_CLIST_DELETE_IP))
#line 1366
#define f2 (&(f2_->i_FI_CLIST_DELETE_IP))
#line 1366
#undef f1
#line 1366
#undef f2
#line 1366
break;
#line 1366

#line 1373 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_QUAD */
#line 1373
case FI_CLIST_DELETE_QUAD:
#line 1373
#define f1 (&(f1_->i_FI_CLIST_DELETE_QUAD))
#line 1373
#define f2 (&(f2_->i_FI_CLIST_DELETE_QUAD))
#line 1373
#undef f1
#line 1373
#undef f2
#line 1373
break;
#line 1373

#line 1380 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_CLIST */
#line 1380
case FI_CLIST_DELETE_CLIST:
#line 1380
#define f1 (&(f1_->i_FI_CLIST_DELETE_CLIST))
#line 1380
#define f2 (&(f2_->i_FI_CLIST_DELETE_CLIST))
#line 1380
#undef f1
#line 1380
#undef f2
#line 1380
break;
#line 1380

#line 1391 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_SET */
#line 1391
case FI_CLIST_DELETE_SET:
#line 1391
#define f1 (&(f1_->i_FI_CLIST_DELETE_SET))
#line 1391
#define f2 (&(f2_->i_FI_CLIST_DELETE_SET))
#line 1391
#undef f1
#line 1391
#undef f2
#line 1391
break;
#line 1391

#line 1398 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_EC */
#line 1398
case FI_ECLIST_DELETE_EC:
#line 1398
#define f1 (&(f1_->i_FI_ECLIST_DELETE_EC))
#line 1398
#define f2 (&(f2_->i_FI_ECLIST_DELETE_EC))
#line 1398
#undef f1
#line 1398
#undef f2
#line 1398
break;
#line 1398

#line 1405 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_ECLIST */
#line 1405
case FI_ECLIST_DELETE_ECLIST:
#line 1405
#define f1 (&(f1_->i_FI_ECLIST_DELETE_ECLIST))
#line 1405
#define f2 (&(f2_->i_FI_ECLIST_DELETE_ECLIST))
#line 1405
#undef f1
#line 1405
#undef f2
#line 1405
break;
#line 1405

#line 1416 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_SET */
#line 1416
case FI_ECLIST_DELETE_SET:
#line 1416
#define f1 (&(f1_->i_FI_ECLIST_DELETE_SET))
#line 1416
#define f2 (&(f2_->i_FI_ECLIST_DELETE_SET))
#line 1416
#undef f1
#line 1416
#undef f2
#line 1416
break;
#line 1416

#line 1423 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_LC */
#line 1423
case FI_LCLIST_DELETE_LC:
#line 1423
#define f1 (&(f1_->i_FI_LCLIST_DELETE_LC))
#line 1423
#define f2 (&(f2_->i_FI_LCLIST_DELETE_LC))
#line 1423
#undef f1
#line 1423
#undef f2
#line 1423
break;
#line 1423

#line 1430 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_LCLIST */
#line 1430
case FI_LCLIST_DELETE_LCLIST:
#line 1430
#define f1 (&(f1_->i_FI_LCLIST_DELETE_LCLIST))
#line 1430
#define f2 (&(f2_->i_FI_LCLIST_DELETE_LCLIST))
#line 1430
#undef f1
#line 1430
#undef f2
#line 1430
break;
#line 1430

#line 1441 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_SET */
#line 1441
case FI_LCLIST_DELETE_SET:
#line 1441
#define f1 (&(f1_->i_FI_LCLIST_DELETE_SET))
#line 1441
#define f2 (&(f2_->i_FI_LCLIST_DELETE_SET))
#line 1441
#undef f1
#line 1441
#undef f2
#line 1441
break;
#line 1441

#line 1452 "filter/f-inst.c"
 /* Comparison for FI_PATH_FILTER_SET */
#line 1452
case FI_PATH_FILTER_SET:
#line 1452
#define f1 (&(f1_->i_FI_PATH_FILTER_SET))
#line 1452
#define f2 (&(f2_->i_FI_PATH_FILTER_SET))
#line 1452
#undef f1
#line 1452
#undef f2
#line 1452
break;
#line 1452

#line 1459 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FILTER_CLIST */
#line 1459
case FI_CLIST_FILTER_CLIST:
#line 1459
#define f1 (&(f1_->i_FI_CLIST_FILTER_CLIST))
#line 1459
#define f2 (&(f2_->i_FI_CLIST_FILTER_CLIST))
#line 1459
#undef f1
#line 1459
#undef f2
#line 1459
break;
#line 1459

#line 1470 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FILTER_SET */
#line 1470
case FI_CLIST_FILTER_SET:
#line 1470
#define f1 (&(f1_->i_FI_CLIST_FILTER_SET))
#line 1470
#define f2 (&(f2_->i_FI_CLIST_FILTER_SET))
#line 1470
#undef f1
#line 1470
#undef f2
#line 1470
break;
#line 1470

#line 1477 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FILTER_ECLIST */
#line 1477
case FI_ECLIST_FILTER_ECLIST:
#line 1477
#define f1 (&(f1_->i_FI_ECLIST_FILTER_ECLIST))
#line 1477
#define f2 (&(f2_->i_FI_ECLIST_FILTER_ECLIST))
#line 1477
#undef f1
#line 1477
#undef f2
#line 1477
break;
#line 1477

#line 1488 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FILTER_SET */
#line 1488
case FI_ECLIST_FILTER_SET:
#line 1488
#define f1 (&(f1_->i_FI_ECLIST_FILTER_SET))
#line 1488
#define f2 (&(f2_->i_FI_ECLIST_FILTER_SET))
#line 1488
#undef f1
#line 1488
#undef f2
#line 1488
break;
#line 1488

#line 1495 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FILTER_LCLIST */
#line 1495
case FI_LCLIST_FILTER_LCLIST:
#line 1495
#define f1 (&(f1_->i_FI_LCLIST_FILTER_LCLIST))
#line 1495
#define f2 (&(f2_->i_FI_LCLIST_FILTER_LCLIST))
#line 1495
#undef f1
#line 1495
#undef f2
#line 1495
break;
#line 1495

#line 1506 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FILTER_SET */
#line 1506
case FI_LCLIST_FILTER_SET:
#line 1506
#define f1 (&(f1_->i_FI_LCLIST_FILTER_SET))
#line 1506
#define f2 (&(f2_->i_FI_LCLIST_FILTER_SET))
#line 1506
#undef f1
#line 1506
#undef f2
#line 1506
break;
#line 1506

#line 1528 "filter/f-inst.c"
 /* Comparison for FI_ROA_CHECK */
#line 1528
case FI_ROA_CHECK:
#line 1528
#define f1 (&(f1_->i_FI_ROA_CHECK))
#line 1528
#define f2 (&(f2_->i_FI_ROA_CHECK))
#line 1510 "filter/f-inst.c"
if (strcmp(f1->rtc->name, f2->rtc->name)) return 0;
#line 1510

#line 1510

#line 1528 "filter/f-inst.c"
#undef f1
#line 1528
#undef f2
#line 1528
break;
#line 1528

#line 1544 "filter/f-inst.c"
 /* Comparison for FI_ASPA_CHECK_EXPLICIT */
#line 1544
case FI_ASPA_CHECK_EXPLICIT:
#line 1544
#define f1 (&(f1_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1544
#define f2 (&(f2_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1532 "filter/f-inst.c"
if (strcmp(f1->rtc->name, f2->rtc->name)) return 0;
#line 1532

#line 1532

#line 1544 "filter/f-inst.c"
#undef f1
#line 1544
#undef f2
#line 1544
break;
#line 1544

#line 1559 "filter/f-inst.c"
 /* Comparison for FI_FROM_HEX */
#line 1559
case FI_FROM_HEX:
#line 1559
#define f1 (&(f1_->i_FI_FROM_HEX))
#line 1559
#define f2 (&(f2_->i_FI_FROM_HEX))
#line 1559
#undef f1
#line 1559
#undef f2
#line 1559
break;
#line 1559

#line 1564 "filter/f-inst.c"
 /* Comparison for FI_FORMAT */
#line 1564
case FI_FORMAT:
#line 1564
#define f1 (&(f1_->i_FI_FORMAT))
#line 1564
#define f2 (&(f2_->i_FI_FORMAT))
#line 1564
#undef f1
#line 1564
#undef f2
#line 1564
break;
#line 1564

#line 830 "filter/decl.m4"
 /* Comparison for FI_ASSERT */
#line 830
case FI_ASSERT:
#line 830
#define f1 (&(f1_->i_FI_ASSERT))
#line 830
#define f2 (&(f2_->i_FI_ASSERT))
#line 1568 "filter/f-inst.c"
if (strcmp(f1->s, f2->s)) return 0;
#line 1568

#line 1568

#line 830 "filter/decl.m4"
#undef f1
#line 830
#undef f2
#line 830
break;
#line 830

#line 751 "filter/decl.m4"

    }
  }
#undef f1_
#undef f2_
  return 1;
}


/* Part of FI_SWITCH filter iterator */
static void
f_add_tree_lines(const struct f_tree *t, void *fit_)
{
  struct filter_iterator * fit = fit_;

  if (t->data)
    BUFFER_PUSH(fit->lines) = t->data;
}

/* Filter line iterator */
void
f_add_lines(const struct f_line_item *what, struct filter_iterator *fit)
{
  switch(what->fi_code) {
#line 288 "filter/f-inst.c"
 /* Iteration for FI_ADD */
#line 288
case FI_ADD:
#line 288
#define whati (&(what->i_FI_ADD))
#line 288
#undef whati
#line 288
break;
#line 288

#line 293 "filter/f-inst.c"
 /* Iteration for FI_SUBTRACT */
#line 293
case FI_SUBTRACT:
#line 293
#define whati (&(what->i_FI_SUBTRACT))
#line 293
#undef whati
#line 293
break;
#line 293

#line 298 "filter/f-inst.c"
 /* Iteration for FI_MULTIPLY */
#line 298
case FI_MULTIPLY:
#line 298
#define whati (&(what->i_FI_MULTIPLY))
#line 298
#undef whati
#line 298
break;
#line 298

#line 304 "filter/f-inst.c"
 /* Iteration for FI_DIVIDE */
#line 304
case FI_DIVIDE:
#line 304
#define whati (&(what->i_FI_DIVIDE))
#line 304
#undef whati
#line 304
break;
#line 304

#line 309 "filter/f-inst.c"
 /* Iteration for FI_BITOR */
#line 309
case FI_BITOR:
#line 309
#define whati (&(what->i_FI_BITOR))
#line 309
#undef whati
#line 309
break;
#line 309

#line 314 "filter/f-inst.c"
 /* Iteration for FI_BITAND */
#line 314
case FI_BITAND:
#line 314
#define whati (&(what->i_FI_BITAND))
#line 314
#undef whati
#line 314
break;
#line 314

#line 324 "filter/f-inst.c"
 /* Iteration for FI_AND */
#line 324
case FI_AND:
#line 324
#define whati (&(what->i_FI_AND))
#line 320 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 324 "filter/f-inst.c"
#undef whati
#line 324
break;
#line 324

#line 335 "filter/f-inst.c"
 /* Iteration for FI_OR */
#line 335
case FI_OR:
#line 335
#define whati (&(what->i_FI_OR))
#line 330 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 335 "filter/f-inst.c"
#undef whati
#line 335
break;
#line 335

#line 345 "filter/f-inst.c"
 /* Iteration for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT:
#line 345
#define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
#undef whati
#line 345
break;
#line 345

#line 385 "filter/f-inst.c"
 /* Iteration for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT:
#line 385
#define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
#undef whati
#line 385
break;
#line 385

#line 392 "filter/f-inst.c"
 /* Iteration for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT:
#line 392
#define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
#undef whati
#line 392
break;
#line 392

#line 442 "filter/f-inst.c"
 /* Iteration for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT:
#line 442
#define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
#undef whati
#line 442
break;
#line 442

#line 449 "filter/f-inst.c"
 /* Iteration for FI_NEQ */
#line 449
case FI_NEQ:
#line 449
#define whati (&(what->i_FI_NEQ))
#line 449
#undef whati
#line 449
break;
#line 449

#line 456 "filter/f-inst.c"
 /* Iteration for FI_EQ */
#line 456
case FI_EQ:
#line 456
#define whati (&(what->i_FI_EQ))
#line 456
#undef whati
#line 456
break;
#line 456

#line 467 "filter/f-inst.c"
 /* Iteration for FI_LT */
#line 467
case FI_LT:
#line 467
#define whati (&(what->i_FI_LT))
#line 467
#undef whati
#line 467
break;
#line 467

#line 478 "filter/f-inst.c"
 /* Iteration for FI_LTE */
#line 478
case FI_LTE:
#line 478
#define whati (&(what->i_FI_LTE))
#line 478
#undef whati
#line 478
break;
#line 478

#line 483 "filter/f-inst.c"
 /* Iteration for FI_NOT */
#line 483
case FI_NOT:
#line 483
#define whati (&(what->i_FI_NOT))
#line 483
#undef whati
#line 483
break;
#line 483

#line 492 "filter/f-inst.c"
 /* Iteration for FI_MATCH */
#line 492
case FI_MATCH:
#line 492
#define whati (&(what->i_FI_MATCH))
#line 492
#undef whati
#line 492
break;
#line 492

#line 501 "filter/f-inst.c"
 /* Iteration for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH:
#line 501
#define whati (&(what->i_FI_NOT_MATCH))
#line 501
#undef whati
#line 501
break;
#line 501

#line 506 "filter/f-inst.c"
 /* Iteration for FI_DEFINED */
#line 506
case FI_DEFINED:
#line 506
#define whati (&(what->i_FI_DEFINED))
#line 506
#undef whati
#line 506
break;
#line 506

#line 507 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type:
#line 507
#define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
#undef whati
#line 507
break;
#line 507

#line 510 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4:
#line 510
#define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef whati
#line 510
break;
#line 510

#line 523 "filter/f-inst.c"
 /* Iteration for FI_VAR_INIT */
#line 523
case FI_VAR_INIT:
#line 523
#define whati (&(what->i_FI_VAR_INIT))
#line 523
#undef whati
#line 523
break;
#line 523

#line 534 "filter/f-inst.c"
 /* Iteration for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0:
#line 534
#define whati (&(what->i_FI_VAR_INIT0))
#line 534
#undef whati
#line 534
break;
#line 534

#line 543 "filter/f-inst.c"
 /* Iteration for FI_VAR_SET */
#line 543
case FI_VAR_SET:
#line 543
#define whati (&(what->i_FI_VAR_SET))
#line 543
#undef whati
#line 543
break;
#line 543

#line 550 "filter/f-inst.c"
 /* Iteration for FI_VAR_GET */
#line 550
case FI_VAR_GET:
#line 550
#define whati (&(what->i_FI_VAR_GET))
#line 550
#undef whati
#line 550
break;
#line 550

#line 563 "filter/f-inst.c"
 /* Iteration for FI_CONSTANT */
#line 563
case FI_CONSTANT:
#line 563
#define whati (&(what->i_FI_CONSTANT))
#line 563
#undef whati
#line 563
break;
#line 563

#line 564 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty:
#line 564
#define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
#undef whati
#line 564
break;
#line 564

#line 565 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty:
#line 565
#define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef whati
#line 565
break;
#line 565

#line 566 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty:
#line 566
#define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef whati
#line 566
break;
#line 566

#line 569 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty:
#line 569
#define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef whati
#line 569
break;
#line 569

#line 591 "filter/f-inst.c"
 /* Iteration for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START:
#line 591
#define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
#undef whati
#line 591
break;
#line 591

#line 600 "filter/f-inst.c"
 /* Iteration for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT:
#line 600
#define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 600 "filter/f-inst.c"
#undef whati
#line 600
break;
#line 600

#line 609 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT:
#line 609
#define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 609 "filter/f-inst.c"
#undef whati
#line 609
break;
#line 609

#line 618 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT:
#line 618
#define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 618 "filter/f-inst.c"
#undef whati
#line 618
break;
#line 618

#line 627 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT:
#line 627
#define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 627 "filter/f-inst.c"
#undef whati
#line 627
break;
#line 627

#line 640 "filter/f-inst.c"
 /* Iteration for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT:
#line 640
#define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 640 "filter/f-inst.c"
#undef whati
#line 640
break;
#line 640

#line 648 "filter/f-inst.c"
 /* Iteration for FI_CONDITION */
#line 648
case FI_CONDITION:
#line 648
#define whati (&(what->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 645 "filter/f-inst.c"
if (whati->fl3) BUFFER_PUSH(fit->lines) = whati->fl3;
#line 648 "filter/f-inst.c"
#undef whati
#line 648
break;
#line 648

#line 661 "filter/f-inst.c"
 /* Iteration for FI_PRINT */
#line 661
case FI_PRINT:
#line 661
#define whati (&(what->i_FI_PRINT))
#line 661
#undef whati
#line 661
break;
#line 661

#line 668 "filter/f-inst.c"
 /* Iteration for FI_FLUSH */
#line 668
case FI_FLUSH:
#line 668
#define whati (&(what->i_FI_FLUSH))
#line 668
#undef whati
#line 668
break;
#line 668

#line 682 "filter/f-inst.c"
 /* Iteration for FI_DIE */
#line 682
case FI_DIE:
#line 682
#define whati (&(what->i_FI_DIE))
#line 682
#undef whati
#line 682
break;
#line 682

#line 689 "filter/f-inst.c"
 /* Iteration for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE:
#line 689
#define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
#undef whati
#line 689
break;
#line 689

#line 736 "filter/f-inst.c"
 /* Iteration for FI_RTA_GET */
#line 736
case FI_RTA_GET:
#line 736
#define whati (&(what->i_FI_RTA_GET))
#line 736
#undef whati
#line 736
break;
#line 736

#line 864 "filter/f-inst.c"
 /* Iteration for FI_RTA_SET */
#line 864
case FI_RTA_SET:
#line 864
#define whati (&(what->i_FI_RTA_SET))
#line 864
#undef whati
#line 864
break;
#line 864

#line 901 "filter/f-inst.c"
 /* Iteration for FI_EA_GET */
#line 901
case FI_EA_GET:
#line 901
#define whati (&(what->i_FI_EA_GET))
#line 901
#undef whati
#line 901
break;
#line 901

#line 942 "filter/f-inst.c"
 /* Iteration for FI_EA_SET */
#line 942
case FI_EA_SET:
#line 942
#define whati (&(what->i_FI_EA_SET))
#line 942
#undef whati
#line 942
break;
#line 942

#line 949 "filter/f-inst.c"
 /* Iteration for FI_EA_UNSET */
#line 949
case FI_EA_UNSET:
#line 949
#define whati (&(what->i_FI_EA_UNSET))
#line 949
#undef whati
#line 949
break;
#line 949

#line 963 "filter/f-inst.c"
 /* Iteration for FI_DEFAULT */
#line 963
case FI_DEFAULT:
#line 963
#define whati (&(what->i_FI_DEFAULT))
#line 963
#undef whati
#line 963
break;
#line 963

#line 964 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__len */
#line 964
case FI_METHOD__T_NET__len:
#line 964
#define whati (&(what->i_FI_METHOD__T_NET__len))
#line 964
#undef whati
#line 964
break;
#line 964

#line 965 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__len */
#line 965
case FI_METHOD__T_PATH__len:
#line 965
#define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 965
#undef whati
#line 965
break;
#line 965

#line 966 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__len */
#line 966
case FI_METHOD__T_CLIST__len:
#line 966
#define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 966
#undef whati
#line 966
break;
#line 966

#line 967 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__len */
#line 967
case FI_METHOD__T_ECLIST__len:
#line 967
#define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 967
#undef whati
#line 967
break;
#line 967

#line 969 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__len */
#line 969
case FI_METHOD__T_LCLIST__len:
#line 969
#define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 969
#undef whati
#line 969
break;
#line 969

#line 1005 "filter/f-inst.c"
 /* Iteration for FI_NET_SRC */
#line 1005
case FI_NET_SRC:
#line 1005
#define whati (&(what->i_FI_NET_SRC))
#line 1005
#undef whati
#line 1005
break;
#line 1005

#line 1042 "filter/f-inst.c"
 /* Iteration for FI_NET_DST */
#line 1042
case FI_NET_DST:
#line 1042
#define whati (&(what->i_FI_NET_DST))
#line 1042
#undef whati
#line 1042
break;
#line 1042

#line 1052 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__maxlen */
#line 1052
case FI_METHOD__T_NET__maxlen:
#line 1052
#define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1052
#undef whati
#line 1052
break;
#line 1052

#line 1062 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__asn */
#line 1062
case FI_METHOD__T_NET__asn:
#line 1062
#define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1062
#undef whati
#line 1062
break;
#line 1062

#line 1064 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__ip */
#line 1064
case FI_METHOD__T_NET__ip:
#line 1064
#define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1064
#undef whati
#line 1064
break;
#line 1064

#line 1073 "filter/f-inst.c"
 /* Iteration for FI_ROUTE_DISTINGUISHER */
#line 1073
case FI_ROUTE_DISTINGUISHER:
#line 1073
#define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1073
#undef whati
#line 1073
break;
#line 1073

#line 1076 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__first */
#line 1076
case FI_METHOD__T_PATH__first:
#line 1076
#define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1076
#undef whati
#line 1076
break;
#line 1076

#line 1079 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__last */
#line 1079
case FI_METHOD__T_PATH__last:
#line 1079
#define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1079
#undef whati
#line 1079
break;
#line 1079

#line 1082 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__last_nonaggregated */
#line 1082
case FI_METHOD__T_PATH__last_nonaggregated:
#line 1082
#define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1082
#undef whati
#line 1082
break;
#line 1082

#line 1085 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PAIR__asn */
#line 1085
case FI_METHOD__T_PAIR__asn:
#line 1085
#define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1085
#undef whati
#line 1085
break;
#line 1085

#line 1088 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PAIR__data */
#line 1088
case FI_METHOD__T_PAIR__data:
#line 1088
#define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1088
#undef whati
#line 1088
break;
#line 1088

#line 1091 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__asn */
#line 1091
case FI_METHOD__T_LC__asn:
#line 1091
#define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1091
#undef whati
#line 1091
break;
#line 1091

#line 1094 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__data1 */
#line 1094
case FI_METHOD__T_LC__data1:
#line 1094
#define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1094
#undef whati
#line 1094
break;
#line 1094

#line 1097 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__data2 */
#line 1097
case FI_METHOD__T_LC__data2:
#line 1097
#define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1097
#undef whati
#line 1097
break;
#line 1097

#line 1100 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__min */
#line 1100
case FI_METHOD__T_CLIST__min:
#line 1100
#define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1100
#undef whati
#line 1100
break;
#line 1100

#line 1103 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__max */
#line 1103
case FI_METHOD__T_CLIST__max:
#line 1103
#define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1103
#undef whati
#line 1103
break;
#line 1103

#line 1106 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__min */
#line 1106
case FI_METHOD__T_ECLIST__min:
#line 1106
#define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1106
#undef whati
#line 1106
break;
#line 1106

#line 1109 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__max */
#line 1109
case FI_METHOD__T_ECLIST__max:
#line 1109
#define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1109
#undef whati
#line 1109
break;
#line 1109

#line 1112 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__min */
#line 1112
case FI_METHOD__T_LCLIST__min:
#line 1112
#define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1112
#undef whati
#line 1112
break;
#line 1112

#line 1114 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__max */
#line 1114
case FI_METHOD__T_LCLIST__max:
#line 1114
#define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1114
#undef whati
#line 1114
break;
#line 1114

#line 1140 "filter/f-inst.c"
 /* Iteration for FI_RETURN */
#line 1140
case FI_RETURN:
#line 1140
#define whati (&(what->i_FI_RETURN))
#line 1140
#undef whati
#line 1140
break;
#line 1140

#line 1200 "filter/f-inst.c"
 /* Iteration for FI_CALL */
#line 1200
case FI_CALL:
#line 1200
#define whati (&(what->i_FI_CALL))

#line 1181 "filter/f-inst.c"
    if (!(what->flags & FIF_RECURSIVE))
      BUFFER_PUSH(fit->lines) = whati->sym->function;

    #line 1200 "filter/f-inst.c"
#undef whati
#line 1200
break;
#line 1200

#line 1205 "filter/f-inst.c"
 /* Iteration for FI_DROP_RESULT */
#line 1205
case FI_DROP_RESULT:
#line 1205
#define whati (&(what->i_FI_DROP_RESULT))
#line 1205
#undef whati
#line 1205
break;
#line 1205

#line 1246 "filter/f-inst.c"
 /* Iteration for FI_SWITCH */
#line 1246
case FI_SWITCH:
#line 1246
#define whati (&(what->i_FI_SWITCH))

#line 1229 "filter/f-inst.c"
    tree_walk(whati->tree, f_add_tree_lines, fit);

    #line 1246 "filter/f-inst.c"
#undef whati
#line 1246
break;
#line 1246

#line 1255 "filter/f-inst.c"
 /* Iteration for FI_IP_MASK */
#line 1255
case FI_IP_MASK:
#line 1255
#define whati (&(what->i_FI_IP_MASK))
#line 1255
#undef whati
#line 1255
break;
#line 1255

#line 1263 "filter/f-inst.c"
 /* Iteration for FI_PATH_PREPEND */
#line 1263
case FI_PATH_PREPEND:
#line 1263
#define whati (&(what->i_FI_PATH_PREPEND))
#line 1263
#undef whati
#line 1263
break;
#line 1263

#line 1270 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_PAIR */
#line 1270
case FI_CLIST_ADD_PAIR:
#line 1270
#define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1270
#undef whati
#line 1270
break;
#line 1270

#line 1284 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_IP */
#line 1284
case FI_CLIST_ADD_IP:
#line 1284
#define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1284
#undef whati
#line 1284
break;
#line 1284

#line 1291 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_QUAD */
#line 1291
case FI_CLIST_ADD_QUAD:
#line 1291
#define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1291
#undef whati
#line 1291
break;
#line 1291

#line 1298 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_CLIST */
#line 1298
case FI_CLIST_ADD_CLIST:
#line 1298
#define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1298
#undef whati
#line 1298
break;
#line 1298

#line 1305 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_ADD_EC */
#line 1305
case FI_ECLIST_ADD_EC:
#line 1305
#define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1305
#undef whati
#line 1305
break;
#line 1305

#line 1312 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_ADD_ECLIST */
#line 1312
case FI_ECLIST_ADD_ECLIST:
#line 1312
#define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1312
#undef whati
#line 1312
break;
#line 1312

#line 1319 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_ADD_LC */
#line 1319
case FI_LCLIST_ADD_LC:
#line 1319
#define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1319
#undef whati
#line 1319
break;
#line 1319

#line 1326 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_ADD_LCLIST */
#line 1326
case FI_LCLIST_ADD_LCLIST:
#line 1326
#define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1326
#undef whati
#line 1326
break;
#line 1326

#line 1333 "filter/f-inst.c"
 /* Iteration for FI_PATH_DELETE_INT */
#line 1333
case FI_PATH_DELETE_INT:
#line 1333
#define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1333
#undef whati
#line 1333
break;
#line 1333

#line 1345 "filter/f-inst.c"
 /* Iteration for FI_PATH_DELETE_SET */
#line 1345
case FI_PATH_DELETE_SET:
#line 1345
#define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1345
#undef whati
#line 1345
break;
#line 1345

#line 1352 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_PAIR */
#line 1352
case FI_CLIST_DELETE_PAIR:
#line 1352
#define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1352
#undef whati
#line 1352
break;
#line 1352

#line 1366 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_IP */
#line 1366
case FI_CLIST_DELETE_IP:
#line 1366
#define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1366
#undef whati
#line 1366
break;
#line 1366

#line 1373 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_QUAD */
#line 1373
case FI_CLIST_DELETE_QUAD:
#line 1373
#define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1373
#undef whati
#line 1373
break;
#line 1373

#line 1380 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_CLIST */
#line 1380
case FI_CLIST_DELETE_CLIST:
#line 1380
#define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1380
#undef whati
#line 1380
break;
#line 1380

#line 1391 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_SET */
#line 1391
case FI_CLIST_DELETE_SET:
#line 1391
#define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1391
#undef whati
#line 1391
break;
#line 1391

#line 1398 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_EC */
#line 1398
case FI_ECLIST_DELETE_EC:
#line 1398
#define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1398
#undef whati
#line 1398
break;
#line 1398

#line 1405 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_ECLIST */
#line 1405
case FI_ECLIST_DELETE_ECLIST:
#line 1405
#define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1405
#undef whati
#line 1405
break;
#line 1405

#line 1416 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_SET */
#line 1416
case FI_ECLIST_DELETE_SET:
#line 1416
#define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1416
#undef whati
#line 1416
break;
#line 1416

#line 1423 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_LC */
#line 1423
case FI_LCLIST_DELETE_LC:
#line 1423
#define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1423
#undef whati
#line 1423
break;
#line 1423

#line 1430 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_LCLIST */
#line 1430
case FI_LCLIST_DELETE_LCLIST:
#line 1430
#define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1430
#undef whati
#line 1430
break;
#line 1430

#line 1441 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_SET */
#line 1441
case FI_LCLIST_DELETE_SET:
#line 1441
#define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1441
#undef whati
#line 1441
break;
#line 1441

#line 1452 "filter/f-inst.c"
 /* Iteration for FI_PATH_FILTER_SET */
#line 1452
case FI_PATH_FILTER_SET:
#line 1452
#define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1452
#undef whati
#line 1452
break;
#line 1452

#line 1459 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FILTER_CLIST */
#line 1459
case FI_CLIST_FILTER_CLIST:
#line 1459
#define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1459
#undef whati
#line 1459
break;
#line 1459

#line 1470 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FILTER_SET */
#line 1470
case FI_CLIST_FILTER_SET:
#line 1470
#define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1470
#undef whati
#line 1470
break;
#line 1470

#line 1477 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FILTER_ECLIST */
#line 1477
case FI_ECLIST_FILTER_ECLIST:
#line 1477
#define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1477
#undef whati
#line 1477
break;
#line 1477

#line 1488 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FILTER_SET */
#line 1488
case FI_ECLIST_FILTER_SET:
#line 1488
#define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1488
#undef whati
#line 1488
break;
#line 1488

#line 1495 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FILTER_LCLIST */
#line 1495
case FI_LCLIST_FILTER_LCLIST:
#line 1495
#define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1495
#undef whati
#line 1495
break;
#line 1495

#line 1506 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FILTER_SET */
#line 1506
case FI_LCLIST_FILTER_SET:
#line 1506
#define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1506
#undef whati
#line 1506
break;
#line 1506

#line 1528 "filter/f-inst.c"
 /* Iteration for FI_ROA_CHECK */
#line 1528
case FI_ROA_CHECK:
#line 1528
#define whati (&(what->i_FI_ROA_CHECK))
#line 1528
#undef whati
#line 1528
break;
#line 1528

#line 1544 "filter/f-inst.c"
 /* Iteration for FI_ASPA_CHECK_EXPLICIT */
#line 1544
case FI_ASPA_CHECK_EXPLICIT:
#line 1544
#define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1544
#undef whati
#line 1544
break;
#line 1544

#line 1559 "filter/f-inst.c"
 /* Iteration for FI_FROM_HEX */
#line 1559
case FI_FROM_HEX:
#line 1559
#define whati (&(what->i_FI_FROM_HEX))
#line 1559
#undef whati
#line 1559
break;
#line 1559

#line 1564 "filter/f-inst.c"
 /* Iteration for FI_FORMAT */
#line 1564
case FI_FORMAT:
#line 1564
#define whati (&(what->i_FI_FORMAT))
#line 1564
#undef whati
#line 1564
break;
#line 1564

#line 830 "filter/decl.m4"
 /* Iteration for FI_ASSERT */
#line 830
case FI_ASSERT:
#line 830
#define whati (&(what->i_FI_ASSERT))
#line 830
#undef whati
#line 830
break;
#line 830

#line 775 "filter/decl.m4"

  }
}


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic pop
#endif

