/* SwitcherooControl.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SwitcherooControl.vala, do not modify */

/*
 * Copyright 2020 Bastien Nocera
 * Copyright 2020-2021 Justin Haygood
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy SwitcherooControlDBusProxy;
typedef GDBusProxyClass SwitcherooControlDBusProxyClass;
enum  {
	SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_0_PROPERTY,
	SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_HAS_DUAL_GPU_PROPERTY,
	SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_switcheroo_control_properties[SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static GType switcheroo_control_dbus_type_id = 0;
static gpointer slingshot_backend_switcheroo_control_parent_class = NULL;
static SwitcherooControlDBus* slingshot_backend_switcheroo_control__dbus;
static SwitcherooControlDBus* slingshot_backend_switcheroo_control__dbus = NULL;
static GType slingshot_backend_switcheroo_control_type_id = 0;

static void switcheroo_control_dbus_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters);
static gboolean switcheroo_control_dbus_dbus_proxy_get_has_dual_gpu (SwitcherooControlDBus* self);
static GHashTable** switcheroo_control_dbus_dbus_proxy_get_gpus (SwitcherooControlDBus* self,
                                                          gint* result_length1);
static void switcheroo_control_dbus_proxy_switcheroo_control_dbus_interface_init (SwitcherooControlDBusIface* iface);
static void switcheroo_control_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* switcheroo_control_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static GVariant* _dbus_switcheroo_control_dbus_get_has_dual_gpu (SwitcherooControlDBus* self);
static GVariant* _dbus_switcheroo_control_dbus_get_gpus (SwitcherooControlDBus* self);
static gboolean switcheroo_control_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _switcheroo_control_dbus_unregister_object (gpointer user_data);
static SwitcherooControlDBus* slingshot_backend_switcheroo_control_get_dbus (void);
static void slingshot_backend_switcheroo_control_set_dbus (SwitcherooControlDBus* value);
static void slingshot_backend_switcheroo_control_finalize (GObject * obj);
static void _vala_slingshot_backend_switcheroo_control_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_slingshot_backend_switcheroo_control_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _switcheroo_control_dbus_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _switcheroo_control_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _switcheroo_control_dbus_dbus_property_info_has_dual_gpu = {-1, "HasDualGpu", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _switcheroo_control_dbus_dbus_property_info_gpus = {-1, "GPUs", "aa{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _switcheroo_control_dbus_dbus_property_info[] = {&_switcheroo_control_dbus_dbus_property_info_has_dual_gpu, &_switcheroo_control_dbus_dbus_property_info_gpus, NULL};
static const GDBusInterfaceInfo _switcheroo_control_dbus_dbus_interface_info = {-1, "net.hadess.SwitcherooControl", (GDBusMethodInfo **) (&_switcheroo_control_dbus_dbus_method_info), (GDBusSignalInfo **) (&_switcheroo_control_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_switcheroo_control_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _switcheroo_control_dbus_dbus_interface_vtable = {switcheroo_control_dbus_dbus_interface_method_call, switcheroo_control_dbus_dbus_interface_get_property, switcheroo_control_dbus_dbus_interface_set_property};

gboolean
switcheroo_control_dbus_get_has_dual_gpu (SwitcherooControlDBus* self)
{
	SwitcherooControlDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SWITCHEROO_CONTROL_DBUS_GET_INTERFACE (self);
	if (_iface_->get_has_dual_gpu) {
		return _iface_->get_has_dual_gpu (self);
	}
	return FALSE;
}

GHashTable**
switcheroo_control_dbus_get_gpus (SwitcherooControlDBus* self,
                                  gint* result_length1)
{
	SwitcherooControlDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SWITCHEROO_CONTROL_DBUS_GET_INTERFACE (self);
	if (_iface_->get_gpus) {
		return _iface_->get_gpus (self, result_length1);
	}
	return NULL;
}

static void
switcheroo_control_dbus_default_init (SwitcherooControlDBusIface * iface,
                                      gpointer iface_data)
{
}

GType
switcheroo_control_dbus_get_type (void)
{
	return switcheroo_control_dbus_type_id;
}

GType
switcheroo_control_dbus_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitcherooControlDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcheroo_control_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	switcheroo_control_dbus_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SwitcherooControlDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (switcheroo_control_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (switcheroo_control_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) switcheroo_control_dbus_proxy_get_type);
	g_type_set_qdata (switcheroo_control_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.hadess.SwitcherooControl");
	g_type_set_qdata (switcheroo_control_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_switcheroo_control_dbus_dbus_interface_info));
	g_type_set_qdata (switcheroo_control_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) switcheroo_control_dbus_register_object);
	return switcheroo_control_dbus_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SwitcherooControlDBusProxy, switcheroo_control_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SWITCHEROO_CONTROL_DBUS, switcheroo_control_dbus_proxy_switcheroo_control_dbus_interface_init) )
static void
switcheroo_control_dbus_proxy_class_init (SwitcherooControlDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = switcheroo_control_dbus_proxy_g_signal;
}

static void
switcheroo_control_dbus_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters)
{
}

static void
switcheroo_control_dbus_proxy_class_finalize (SwitcherooControlDBusProxyClass* klass)
{
}

void
switcheroo_control_dbus_proxy_register_dynamic_type (GTypeModule* module)
{
	switcheroo_control_dbus_proxy_register_type (module);
}

static void
switcheroo_control_dbus_proxy_init (SwitcherooControlDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_switcheroo_control_dbus_dbus_interface_info));
}

static gboolean
switcheroo_control_dbus_dbus_proxy_get_has_dual_gpu (SwitcherooControlDBus* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasDualGpu");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.SwitcherooControl"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasDualGpu"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp13_ = FALSE;
			return _tmp13_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static GHashTable**
switcheroo_control_dbus_dbus_proxy_get_gpus (SwitcherooControlDBus* self,
                                             gint* result_length1)
{
	GVariant *_inner_reply;
	GHashTable** _result;
	gint _result_length1;
	GHashTable** _tmp14_;
	gint _tmp14__length;
	gint _tmp14__size;
	gint _tmp14__length1;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "GPUs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.SwitcherooControl"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("GPUs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp14_ = g_new (GHashTable*, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	g_variant_iter_init (&_tmp15_, _inner_reply);
	for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp14__length1++) {
		GHashTable* _tmp17_;
		GVariantIter _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (GHashTable*, _tmp14_, _tmp14__size + 1);
		}
		_tmp17_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp18_, _tmp16_);
		while (g_variant_iter_loop (&_tmp18_, "{?*}", &_tmp19_, &_tmp20_)) {
			g_hash_table_insert (_tmp17_, g_variant_dup_string (_tmp19_, NULL), g_variant_get_variant (_tmp20_));
		}
		_tmp14_[_tmp14__length++] = _tmp17_;
		g_variant_unref (_tmp16_);
	}
	_result_length1 = _tmp14__length1;
	_tmp14_[_tmp14__length] = NULL;
	_result = _tmp14_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static void
switcheroo_control_dbus_proxy_switcheroo_control_dbus_interface_init (SwitcherooControlDBusIface* iface)
{
	iface->get_has_dual_gpu = switcheroo_control_dbus_dbus_proxy_get_has_dual_gpu;
	iface->get_gpus = switcheroo_control_dbus_dbus_proxy_get_gpus;
}

static void
switcheroo_control_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_switcheroo_control_dbus_get_has_dual_gpu (SwitcherooControlDBus* self)
{
	gboolean result;
	GVariant* _reply;
	result = switcheroo_control_dbus_get_has_dual_gpu (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_switcheroo_control_dbus_get_gpus (SwitcherooControlDBus* self)
{
	GHashTable** result;
	gint result_length1 = 0;
	GVariant* _reply;
	GHashTable** _tmp21_;
	GVariantBuilder _tmp22_;
	gint _tmp23_;
	result = switcheroo_control_dbus_get_gpus (self, &result_length1);
	_tmp21_ = result;
	g_variant_builder_init (&_tmp22_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp23_ = 0; _tmp23_ < result_length1; _tmp23_++) {
		GVariantBuilder _tmp24_;
		GHashTableIter _tmp25_;
		gpointer _tmp26_;
		gpointer _tmp27_;
		g_hash_table_iter_init (&_tmp25_, *_tmp21_);
		g_variant_builder_init (&_tmp24_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp25_, &_tmp26_, &_tmp27_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp26_;
			_value = (GVariant*) _tmp27_;
			g_variant_builder_add (&_tmp24_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp22_, g_variant_builder_end (&_tmp24_));
		_tmp21_++;
	}
	_reply = g_variant_builder_end (&_tmp22_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	return _reply;
}

static GVariant*
switcheroo_control_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasDualGpu") == 0) {
		return _dbus_switcheroo_control_dbus_get_has_dual_gpu (object);
	} else if (strcmp (property_name, "GPUs") == 0) {
		return _dbus_switcheroo_control_dbus_get_gpus (object);
	}
	return NULL;
}

static gboolean
switcheroo_control_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
switcheroo_control_dbus_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_switcheroo_control_dbus_dbus_interface_info), &_switcheroo_control_dbus_dbus_interface_vtable, data, _switcheroo_control_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_switcheroo_control_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
slingshot_backend_switcheroo_control_apply_gpu_environment (SlingshotBackendSwitcherooControl* self,
                                                            GAppLaunchContext* context,
                                                            gboolean use_default_gpu)
{
	SwitcherooControlDBus* _tmp0_;
	SwitcherooControlDBus* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SwitcherooControlDBus* _tmp4_;
	SwitcherooControlDBus* _tmp5_;
	GHashTable** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	GHashTable** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = slingshot_backend_switcheroo_control_get_dbus ();
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		g_warning ("SwitcherooControl.vala:49: Could not apply discrete GPU environment, s" \
"witcheroo-control not available");
		return;
	}
	_tmp2_ = slingshot_backend_switcheroo_control_get_has_dual_gpu (self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = slingshot_backend_switcheroo_control_get_dbus ();
	_tmp5_ = _tmp4_;
	_tmp6_ = switcheroo_control_dbus_get_gpus (_tmp5_, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	{
		GHashTable** gpu_collection = NULL;
		gint gpu_collection_length1 = 0;
		gint _gpu_collection_size_ = 0;
		gint gpu_it = 0;
		gpu_collection = _tmp8_;
		gpu_collection_length1 = _tmp8__length1;
		for (gpu_it = 0; gpu_it < gpu_collection_length1; gpu_it = gpu_it + 1) {
			GHashTable* _tmp9_;
			GHashTable* gpu = NULL;
			_tmp9_ = _g_hash_table_ref0 (gpu_collection[gpu_it]);
			gpu = _tmp9_;
			{
				gboolean is_default = FALSE;
				GHashTable* _tmp10_;
				gconstpointer _tmp11_;
				_tmp10_ = gpu;
				_tmp11_ = g_hash_table_lookup (_tmp10_, "Default");
				is_default = g_variant_get_boolean ((GVariant*) _tmp11_);
				if (is_default == use_default_gpu) {
					GHashTable* _tmp12_;
					gconstpointer _tmp13_;
					const gchar* _tmp14_;
					GVariant* environment = NULL;
					GHashTable* _tmp15_;
					gconstpointer _tmp16_;
					GVariant* _tmp17_;
					const gchar** environment_set = NULL;
					GVariant* _tmp18_;
					gsize _tmp19_ = 0;
					const gchar** _tmp20_;
					gint environment_set_length1;
					gint _environment_set_size_;
					_tmp12_ = gpu;
					_tmp13_ = g_hash_table_lookup (_tmp12_, "Name");
					_tmp14_ = g_variant_get_string ((GVariant*) _tmp13_, NULL);
					g_debug ("SwitcherooControl.vala:61: Using GPU: %s", _tmp14_);
					_tmp15_ = gpu;
					_tmp16_ = g_hash_table_lookup (_tmp15_, "Environment");
					_tmp17_ = _g_variant_ref0 ((GVariant*) _tmp16_);
					environment = _tmp17_;
					_tmp18_ = environment;
					_tmp20_ = g_variant_get_strv (_tmp18_, &_tmp19_);
					environment_set = _tmp20_;
					environment_set_length1 = _tmp19_;
					_environment_set_size_ = environment_set_length1;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp21_ = FALSE;
							_tmp21_ = TRUE;
							while (TRUE) {
								const gchar** _tmp22_;
								gint _tmp22__length1;
								const gchar* _tmp23_;
								const gchar** _tmp24_;
								gint _tmp24__length1;
								const gchar* _tmp25_;
								const gchar** _tmp26_;
								gint _tmp26__length1;
								const gchar* _tmp27_;
								if (!_tmp21_) {
									i = i + 2;
								}
								_tmp21_ = FALSE;
								_tmp22_ = environment_set;
								_tmp22__length1 = environment_set_length1;
								_tmp23_ = _tmp22_[i];
								if (!(_tmp23_ != NULL)) {
									break;
								}
								_tmp24_ = environment_set;
								_tmp24__length1 = environment_set_length1;
								_tmp25_ = _tmp24_[i];
								_tmp26_ = environment_set;
								_tmp26__length1 = environment_set_length1;
								_tmp27_ = _tmp26_[i + 1];
								g_app_launch_context_setenv (context, _tmp25_, _tmp27_);
							}
						}
					}
					environment_set = (g_free (environment_set), NULL);
					_g_variant_unref0 (environment);
					_g_hash_table_unref0 (gpu);
					gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					return;
				}
				_g_hash_table_unref0 (gpu);
			}
		}
		gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	}
	g_warning ("SwitcherooControl.vala:75: Could not apply discrete GPU environment, n" \
"o GPUs in list");
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
slingshot_backend_switcheroo_control_get_gpu_name (SlingshotBackendSwitcherooControl* self,
                                                   gboolean default_gpu)
{
	SwitcherooControlDBus* _tmp0_;
	SwitcherooControlDBus* _tmp1_;
	SwitcherooControlDBus* _tmp3_;
	SwitcherooControlDBus* _tmp4_;
	GHashTable** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	GHashTable** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = slingshot_backend_switcheroo_control_get_dbus ();
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		g_warning ("SwitcherooControl.vala:80: Could not fetch GPU name, switcheroo-contro" \
"l not available");
		_tmp2_ = g_strdup (_ ("Default"));
		result = _tmp2_;
		return result;
	}
	_tmp3_ = slingshot_backend_switcheroo_control_get_dbus ();
	_tmp4_ = _tmp3_;
	_tmp5_ = switcheroo_control_dbus_get_gpus (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	{
		GHashTable** gpu_collection = NULL;
		gint gpu_collection_length1 = 0;
		gint _gpu_collection_size_ = 0;
		gint gpu_it = 0;
		gpu_collection = _tmp7_;
		gpu_collection_length1 = _tmp7__length1;
		for (gpu_it = 0; gpu_it < gpu_collection_length1; gpu_it = gpu_it + 1) {
			GHashTable* _tmp8_;
			GHashTable* gpu = NULL;
			_tmp8_ = _g_hash_table_ref0 (gpu_collection[gpu_it]);
			gpu = _tmp8_;
			{
				gboolean is_default = FALSE;
				GHashTable* _tmp9_;
				gconstpointer _tmp10_;
				_tmp9_ = gpu;
				_tmp10_ = g_hash_table_lookup (_tmp9_, "Default");
				is_default = g_variant_get_boolean ((GVariant*) _tmp10_);
				if (is_default == default_gpu) {
					gchar* gpu_name = NULL;
					GHashTable* _tmp11_;
					gconstpointer _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp18_;
					const gchar* _tmp20_;
					_tmp11_ = gpu;
					_tmp12_ = g_hash_table_lookup (_tmp11_, "Name");
					_tmp13_ = g_variant_get_string ((GVariant*) _tmp12_, NULL);
					_tmp14_ = g_strdup (_tmp13_);
					gpu_name = _tmp14_;
					_tmp15_ = gpu_name;
					g_debug ("SwitcherooControl.vala:91: Using GPU: %s", _tmp15_);
					_tmp16_ = gpu_name;
					if (string_contains (_tmp16_, "NVIDIA")) {
						gchar* _tmp17_;
						_tmp17_ = g_strdup ("NVIDIA");
						result = _tmp17_;
						_g_free0 (gpu_name);
						_g_hash_table_unref0 (gpu);
						gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
						return result;
					}
					_tmp18_ = gpu_name;
					if (string_contains (_tmp18_, "Intel")) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("Intel");
						result = _tmp19_;
						_g_free0 (gpu_name);
						_g_hash_table_unref0 (gpu);
						gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
						return result;
					}
					_tmp20_ = gpu_name;
					if (string_contains (_tmp20_, "AMD")) {
						gchar* _tmp21_;
						_tmp21_ = g_strdup ("AMD");
						result = _tmp21_;
						_g_free0 (gpu_name);
						_g_hash_table_unref0 (gpu);
						gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
						return result;
					}
					result = gpu_name;
					_g_hash_table_unref0 (gpu);
					gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					return result;
				}
				_g_hash_table_unref0 (gpu);
			}
		}
		gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	}
	_tmp22_ = g_strdup (_ ("Default"));
	result = _tmp22_;
	return result;
}

SlingshotBackendSwitcherooControl*
slingshot_backend_switcheroo_control_construct (GType object_type)
{
	SlingshotBackendSwitcherooControl * self = NULL;
	self = (SlingshotBackendSwitcherooControl*) g_object_new (object_type, NULL);
	return self;
}

SlingshotBackendSwitcherooControl*
slingshot_backend_switcheroo_control_new (void)
{
	return slingshot_backend_switcheroo_control_construct (SLINGSHOT_BACKEND_TYPE_SWITCHEROO_CONTROL);
}

static SwitcherooControlDBus*
slingshot_backend_switcheroo_control_get_dbus (void)
{
	SwitcherooControlDBus* result;
	SwitcherooControlDBus* _tmp0_;
	_tmp0_ = slingshot_backend_switcheroo_control__dbus;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_backend_switcheroo_control_set_dbus (SwitcherooControlDBus* value)
{
	SwitcherooControlDBus* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (slingshot_backend_switcheroo_control__dbus);
	slingshot_backend_switcheroo_control__dbus = _tmp0_;
}

gboolean
slingshot_backend_switcheroo_control_get_has_dual_gpu (SlingshotBackendSwitcherooControl* self)
{
	gboolean result;
	SwitcherooControlDBus* _tmp0_;
	SwitcherooControlDBus* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = slingshot_backend_switcheroo_control_get_dbus ();
	_tmp1_ = _tmp0_;
	_tmp2_ = switcheroo_control_dbus_get_has_dual_gpu (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
slingshot_backend_switcheroo_control_class_init (SlingshotBackendSwitcherooControlClass * klass,
                                                 gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	slingshot_backend_switcheroo_control_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_switcheroo_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_switcheroo_control_set_property;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_switcheroo_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_HAS_DUAL_GPU_PROPERTY, slingshot_backend_switcheroo_control_properties[SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_HAS_DUAL_GPU_PROPERTY] = g_param_spec_boolean ("has-dual-gpu", "has-dual-gpu", "has-dual-gpu", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	{
		SwitcherooControlDBus* _tmp0_ = NULL;
		SwitcherooControlDBus* _tmp1_;
		_tmp1_ = (SwitcherooControlDBus*) g_initable_new (TYPE_SWITCHEROO_CONTROL_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "net.hadess.SwitcherooControl", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/net/hadess/SwitcherooControl", "g-interface-name", "net.hadess.SwitcherooControl", NULL);
		_tmp0_ = (SwitcherooControlDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		slingshot_backend_switcheroo_control_set_dbus (_tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("SwitcherooControl.vala:37: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
slingshot_backend_switcheroo_control_instance_init (SlingshotBackendSwitcherooControl * self,
                                                    gpointer klass)
{
}

static void
slingshot_backend_switcheroo_control_finalize (GObject * obj)
{
	SlingshotBackendSwitcherooControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_SWITCHEROO_CONTROL, SlingshotBackendSwitcherooControl);
	G_OBJECT_CLASS (slingshot_backend_switcheroo_control_parent_class)->finalize (obj);
}

GType
slingshot_backend_switcheroo_control_get_type (void)
{
	return slingshot_backend_switcheroo_control_type_id;
}

GType
slingshot_backend_switcheroo_control_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendSwitcherooControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_switcheroo_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendSwitcherooControl), 0, (GInstanceInitFunc) slingshot_backend_switcheroo_control_instance_init, NULL };
	slingshot_backend_switcheroo_control_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SlingshotBackendSwitcherooControl", &g_define_type_info, 0);
	return slingshot_backend_switcheroo_control_type_id;
}

static void
_vala_slingshot_backend_switcheroo_control_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	SlingshotBackendSwitcherooControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_SWITCHEROO_CONTROL, SlingshotBackendSwitcherooControl);
	switch (property_id) {
		case SLINGSHOT_BACKEND_SWITCHEROO_CONTROL_HAS_DUAL_GPU_PROPERTY:
		g_value_set_boolean (value, slingshot_backend_switcheroo_control_get_has_dual_gpu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_switcheroo_control_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	SlingshotBackendSwitcherooControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_SWITCHEROO_CONTROL, SlingshotBackendSwitcherooControl);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

