/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Attribute classes' member function definitions                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

AMDGPUNumSGPRAttr *AMDGPUNumSGPRAttr::clone(ASTContext &C) const {
  auto *A = new (C) AMDGPUNumSGPRAttr(getLocation(), C, numSGPR, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AMDGPUNumSGPRAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((amdgpu_num_sgpr(" << getNumSGPR() << ")))";
    break;
  }
}
}

const char *AMDGPUNumSGPRAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "amdgpu_num_sgpr";
  }
}

AMDGPUNumVGPRAttr *AMDGPUNumVGPRAttr::clone(ASTContext &C) const {
  auto *A = new (C) AMDGPUNumVGPRAttr(getLocation(), C, numVGPR, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AMDGPUNumVGPRAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((amdgpu_num_vgpr(" << getNumVGPR() << ")))";
    break;
  }
}
}

const char *AMDGPUNumVGPRAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "amdgpu_num_vgpr";
  }
}

ARMInterruptAttr *ARMInterruptAttr::clone(ASTContext &C) const {
  auto *A = new (C) ARMInterruptAttr(getLocation(), C, interrupt, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ARMInterruptAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((interrupt(\"" << ARMInterruptAttr::ConvertInterruptTypeToStr(getInterrupt()) << "\")))";
    break;
  }
}
}

const char *ARMInterruptAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "interrupt";
  }
}

AcquireCapabilityAttr *AcquireCapabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) AcquireCapabilityAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AcquireCapabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((acquire_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[clang::acquire_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((acquire_shared_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 3 : {
    OS << " [[clang::acquire_shared_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 4 : {
    OS << " __attribute__((exclusive_lock_function(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 5 : {
    OS << " __attribute__((shared_lock_function(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *AcquireCapabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "acquire_capability";
  case 1:
    return "acquire_capability";
  case 2:
    return "acquire_shared_capability";
  case 3:
    return "acquire_shared_capability";
  case 4:
    return "exclusive_lock_function";
  case 5:
    return "shared_lock_function";
  }
}

AcquiredAfterAttr *AcquiredAfterAttr::clone(ASTContext &C) const {
  auto *A = new (C) AcquiredAfterAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AcquiredAfterAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((acquired_after(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *AcquiredAfterAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "acquired_after";
  }
}

AcquiredBeforeAttr *AcquiredBeforeAttr::clone(ASTContext &C) const {
  auto *A = new (C) AcquiredBeforeAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AcquiredBeforeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((acquired_before(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *AcquiredBeforeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "acquired_before";
  }
}

AliasAttr *AliasAttr::clone(ASTContext &C) const {
  auto *A = new (C) AliasAttr(getLocation(), C, getAliasee(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AliasAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((alias(\"" << getAliasee() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::alias(\"" << getAliasee() << "\")]]";
    break;
  }
}
}

const char *AliasAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "alias";
  case 1:
    return "alias";
  }
}

AlignMac68kAttr *AlignMac68kAttr::clone(ASTContext &C) const {
  auto *A = new (C) AlignMac68kAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AlignMac68kAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *AlignMac68kAttr::getSpelling() const {
  return "(No spelling)";
}

AlignValueAttr *AlignValueAttr::clone(ASTContext &C) const {
  auto *A = new (C) AlignValueAttr(getLocation(), C, alignment, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AlignValueAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((align_value(" << getAlignment() << ")))";
    break;
  }
}
}

const char *AlignValueAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "align_value";
  }
}

bool AlignedAttr::isAlignmentDependent() const {
  if (isalignmentExpr)
    return alignmentExpr && (alignmentExpr->isValueDependent() || alignmentExpr->isTypeDependent());
  else
    return alignmentType->getType()->isDependentType();
}
unsigned AlignedAttr::getAlignment(ASTContext &Ctx) const {
  assert(!isAlignmentDependent());
  if (isalignmentExpr)
    return alignmentExpr ? alignmentExpr->EvaluateKnownConstInt(Ctx).getZExtValue() * Ctx.getCharWidth() : Ctx.getTargetDefaultAlignForAttributeAligned();
  else
    return 0; // FIXME
}
AlignedAttr *AlignedAttr::clone(ASTContext &C) const {
  auto *A = new (C) AlignedAttr(getLocation(), C, isalignmentExpr, isalignmentExpr ? static_cast<void*>(alignmentExpr) : alignmentType, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AlignedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((aligned(";
    if (isalignmentExpr && alignmentExpr)
      alignmentExpr->printPretty(OS, 0, Policy);
    OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::aligned(";
    if (isalignmentExpr && alignmentExpr)
      alignmentExpr->printPretty(OS, 0, Policy);
    OS << ")]]";
    break;
  }
  case 2 : {
    OS << " __declspec(align(";
    if (isalignmentExpr && alignmentExpr)
      alignmentExpr->printPretty(OS, 0, Policy);
    OS << "))";
    break;
  }
  case 3 : {
    OS << " alignas(";
    if (isalignmentExpr && alignmentExpr)
      alignmentExpr->printPretty(OS, 0, Policy);
    OS << ")";
    break;
  }
  case 4 : {
    OS << " _Alignas(";
    if (isalignmentExpr && alignmentExpr)
      alignmentExpr->printPretty(OS, 0, Policy);
    OS << ")";
    break;
  }
}
}

const char *AlignedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "aligned";
  case 1:
    return "aligned";
  case 2:
    return "align";
  case 3:
    return "alignas";
  case 4:
    return "_Alignas";
  }
}

AlwaysInlineAttr *AlwaysInlineAttr::clone(ASTContext &C) const {
  auto *A = new (C) AlwaysInlineAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AlwaysInlineAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((always_inline))";
    break;
  }
  case 1 : {
    OS << " [[gnu::always_inline]]";
    break;
  }
  case 2 : {
    OS << " __forceinline";
    break;
  }
}
}

const char *AlwaysInlineAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "always_inline";
  case 1:
    return "always_inline";
  case 2:
    return "__forceinline";
  }
}

AnalyzerNoReturnAttr *AnalyzerNoReturnAttr::clone(ASTContext &C) const {
  auto *A = new (C) AnalyzerNoReturnAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AnalyzerNoReturnAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((analyzer_noreturn))";
    break;
  }
}
}

const char *AnalyzerNoReturnAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "analyzer_noreturn";
  }
}

AnnotateAttr *AnnotateAttr::clone(ASTContext &C) const {
  auto *A = new (C) AnnotateAttr(getLocation(), C, getAnnotation(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AnnotateAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((annotate(\"" << getAnnotation() << "\")))";
    break;
  }
}
}

const char *AnnotateAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "annotate";
  }
}

ArcWeakrefUnavailableAttr *ArcWeakrefUnavailableAttr::clone(ASTContext &C) const {
  auto *A = new (C) ArcWeakrefUnavailableAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ArcWeakrefUnavailableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_arc_weak_reference_unavailable))";
    break;
  }
}
}

const char *ArcWeakrefUnavailableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_arc_weak_reference_unavailable";
  }
}

ArgumentWithTypeTagAttr *ArgumentWithTypeTagAttr::clone(ASTContext &C) const {
  auto *A = new (C) ArgumentWithTypeTagAttr(getLocation(), C, argumentKind, argumentIdx, typeTagIdx, isPointer, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ArgumentWithTypeTagAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((argument_with_type_tag(" << getArgumentKind()->getName() << ", " << getArgumentIdx() << ", " << getTypeTagIdx() << ", " << getIsPointer() << ")))";
    break;
  }
  case 1 : {
    OS << " __attribute__((pointer_with_type_tag(" << getArgumentKind()->getName() << ", " << getArgumentIdx() << ", " << getTypeTagIdx() << ", " << getIsPointer() << ")))";
    break;
  }
}
}

const char *ArgumentWithTypeTagAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "argument_with_type_tag";
  case 1:
    return "pointer_with_type_tag";
  }
}

AsmLabelAttr *AsmLabelAttr::clone(ASTContext &C) const {
  auto *A = new (C) AsmLabelAttr(getLocation(), C, getLabel(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AsmLabelAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " asm(\"" << getLabel() << "\")";
    break;
  }
  case 1 : {
    OS << " __asm__(\"" << getLabel() << "\")";
    break;
  }
}
}

const char *AsmLabelAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "asm";
  case 1:
    return "__asm__";
  }
}

AssertCapabilityAttr *AssertCapabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) AssertCapabilityAttr(getLocation(), C, expr, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AssertCapabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((assert_capability(" << getExpr() << ")))";
    break;
  }
  case 1 : {
    OS << " [[clang::assert_capability(" << getExpr() << ")]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((assert_shared_capability(" << getExpr() << ")))";
    break;
  }
  case 3 : {
    OS << " [[clang::assert_shared_capability(" << getExpr() << ")]]";
    break;
  }
}
}

const char *AssertCapabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "assert_capability";
  case 1:
    return "assert_capability";
  case 2:
    return "assert_shared_capability";
  case 3:
    return "assert_shared_capability";
  }
}

AssertExclusiveLockAttr *AssertExclusiveLockAttr::clone(ASTContext &C) const {
  auto *A = new (C) AssertExclusiveLockAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AssertExclusiveLockAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((assert_exclusive_lock(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *AssertExclusiveLockAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "assert_exclusive_lock";
  }
}

AssertSharedLockAttr *AssertSharedLockAttr::clone(ASTContext &C) const {
  auto *A = new (C) AssertSharedLockAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AssertSharedLockAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((assert_shared_lock(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *AssertSharedLockAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "assert_shared_lock";
  }
}

AssumeAlignedAttr *AssumeAlignedAttr::clone(ASTContext &C) const {
  auto *A = new (C) AssumeAlignedAttr(getLocation(), C, alignment, offset, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AssumeAlignedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((assume_aligned(" << getAlignment() << ", " << getOffset() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::assume_aligned(" << getAlignment() << ", " << getOffset() << ")]]";
    break;
  }
}
}

const char *AssumeAlignedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "assume_aligned";
  case 1:
    return "assume_aligned";
  }
}

AvailabilityAttr *AvailabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) AvailabilityAttr(getLocation(), C, platform, getIntroduced(), getDeprecated(), getObsoleted(), unavailable, getMessage(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void AvailabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((availability(" << getPlatform()->getName();
  if (!getIntroduced().empty()) OS << ", introduced=" << getIntroduced();
  if (!getDeprecated().empty()) OS << ", deprecated=" << getDeprecated();
  if (!getObsoleted().empty()) OS << ", obsoleted=" << getObsoleted();
  if (getUnavailable()) OS << ", unavailable";
  OS << ")))";
    break;
  }
}
}

const char *AvailabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "availability";
  }
}

BlocksAttr *BlocksAttr::clone(ASTContext &C) const {
  auto *A = new (C) BlocksAttr(getLocation(), C, type, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void BlocksAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((blocks(\"" << BlocksAttr::ConvertBlockTypeToStr(getType()) << "\")))";
    break;
  }
}
}

const char *BlocksAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "blocks";
  }
}

C11NoReturnAttr *C11NoReturnAttr::clone(ASTContext &C) const {
  auto *A = new (C) C11NoReturnAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void C11NoReturnAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " _Noreturn";
    break;
  }
}
}

const char *C11NoReturnAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "_Noreturn";
  }
}

CDeclAttr *CDeclAttr::clone(ASTContext &C) const {
  auto *A = new (C) CDeclAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CDeclAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cdecl))";
    break;
  }
  case 1 : {
    OS << " [[gnu::cdecl]]";
    break;
  }
  case 2 : {
    OS << " __cdecl";
    break;
  }
  case 3 : {
    OS << " _cdecl";
    break;
  }
}
}

const char *CDeclAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cdecl";
  case 1:
    return "cdecl";
  case 2:
    return "__cdecl";
  case 3:
    return "_cdecl";
  }
}

CFAuditedTransferAttr *CFAuditedTransferAttr::clone(ASTContext &C) const {
  auto *A = new (C) CFAuditedTransferAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CFAuditedTransferAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cf_audited_transfer))";
    break;
  }
}
}

const char *CFAuditedTransferAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cf_audited_transfer";
  }
}

CFConsumedAttr *CFConsumedAttr::clone(ASTContext &C) const {
  auto *A = new (C) CFConsumedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CFConsumedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cf_consumed))";
    break;
  }
}
}

const char *CFConsumedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cf_consumed";
  }
}

CFReturnsNotRetainedAttr *CFReturnsNotRetainedAttr::clone(ASTContext &C) const {
  auto *A = new (C) CFReturnsNotRetainedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CFReturnsNotRetainedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cf_returns_not_retained))";
    break;
  }
}
}

const char *CFReturnsNotRetainedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cf_returns_not_retained";
  }
}

CFReturnsRetainedAttr *CFReturnsRetainedAttr::clone(ASTContext &C) const {
  auto *A = new (C) CFReturnsRetainedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CFReturnsRetainedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cf_returns_retained))";
    break;
  }
}
}

const char *CFReturnsRetainedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cf_returns_retained";
  }
}

CFUnknownTransferAttr *CFUnknownTransferAttr::clone(ASTContext &C) const {
  auto *A = new (C) CFUnknownTransferAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CFUnknownTransferAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cf_unknown_transfer))";
    break;
  }
}
}

const char *CFUnknownTransferAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cf_unknown_transfer";
  }
}

CUDAConstantAttr *CUDAConstantAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDAConstantAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDAConstantAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((constant))";
    break;
  }
}
}

const char *CUDAConstantAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "constant";
  }
}

CUDADeviceAttr *CUDADeviceAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDADeviceAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDADeviceAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((device))";
    break;
  }
}
}

const char *CUDADeviceAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "device";
  }
}

CUDAGlobalAttr *CUDAGlobalAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDAGlobalAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDAGlobalAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((global))";
    break;
  }
}
}

const char *CUDAGlobalAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "global";
  }
}

CUDAHostAttr *CUDAHostAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDAHostAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDAHostAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((host))";
    break;
  }
}
}

const char *CUDAHostAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "host";
  }
}

CUDAInvalidTargetAttr *CUDAInvalidTargetAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDAInvalidTargetAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDAInvalidTargetAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *CUDAInvalidTargetAttr::getSpelling() const {
  return "(No spelling)";
}

CUDALaunchBoundsAttr *CUDALaunchBoundsAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDALaunchBoundsAttr(getLocation(), C, maxThreads, minBlocks, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDALaunchBoundsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((launch_bounds(" << getMaxThreads() << ", " << getMinBlocks() << ")))";
    break;
  }
}
}

const char *CUDALaunchBoundsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "launch_bounds";
  }
}

CUDASharedAttr *CUDASharedAttr::clone(ASTContext &C) const {
  auto *A = new (C) CUDASharedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CUDASharedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((shared))";
    break;
  }
}
}

const char *CUDASharedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "shared";
  }
}

CXX11NoReturnAttr *CXX11NoReturnAttr::clone(ASTContext &C) const {
  auto *A = new (C) CXX11NoReturnAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CXX11NoReturnAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[noreturn]]";
    break;
  }
}
}

const char *CXX11NoReturnAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "noreturn";
  }
}

CallableWhenAttr *CallableWhenAttr::clone(ASTContext &C) const {
  auto *A = new (C) CallableWhenAttr(getLocation(), C, callableStates_, callableStates_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CallableWhenAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((callable_when(";
  bool isFirst = true;
  for (const auto &Val : callableStates()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << "\"" << CallableWhenAttr::ConvertConsumedStateToStr(Val)<< "\"";
  }
  OS << ")))";
    break;
  }
}
}

const char *CallableWhenAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "callable_when";
  }
}

CapabilityAttr *CapabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) CapabilityAttr(getLocation(), C, getName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CapabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((capability(\"" << getName() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[clang::capability(\"" << getName() << "\")]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((shared_capability(\"" << getName() << "\")))";
    break;
  }
  case 3 : {
    OS << " [[clang::shared_capability(\"" << getName() << "\")]]";
    break;
  }
}
}

const char *CapabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "capability";
  case 1:
    return "capability";
  case 2:
    return "shared_capability";
  case 3:
    return "shared_capability";
  }
}

CapturedRecordAttr *CapturedRecordAttr::clone(ASTContext &C) const {
  auto *A = new (C) CapturedRecordAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CapturedRecordAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *CapturedRecordAttr::getSpelling() const {
  return "(No spelling)";
}

CarriesDependencyAttr *CarriesDependencyAttr::clone(ASTContext &C) const {
  auto *A = new (C) CarriesDependencyAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CarriesDependencyAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((carries_dependency))";
    break;
  }
  case 1 : {
    OS << " [[carries_dependency]]";
    break;
  }
}
}

const char *CarriesDependencyAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "carries_dependency";
  case 1:
    return "carries_dependency";
  }
}

CleanupAttr *CleanupAttr::clone(ASTContext &C) const {
  auto *A = new (C) CleanupAttr(getLocation(), C, functionDecl, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CleanupAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cleanup(" << getFunctionDecl()->getNameInfo().getAsString() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::cleanup(" << getFunctionDecl()->getNameInfo().getAsString() << ")]]";
    break;
  }
}
}

const char *CleanupAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cleanup";
  case 1:
    return "cleanup";
  }
}

ColdAttr *ColdAttr::clone(ASTContext &C) const {
  auto *A = new (C) ColdAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ColdAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((cold))";
    break;
  }
  case 1 : {
    OS << " [[gnu::cold]]";
    break;
  }
}
}

const char *ColdAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "cold";
  case 1:
    return "cold";
  }
}

CommonAttr *CommonAttr::clone(ASTContext &C) const {
  auto *A = new (C) CommonAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void CommonAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((common))";
    break;
  }
  case 1 : {
    OS << " [[gnu::common]]";
    break;
  }
}
}

const char *CommonAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "common";
  case 1:
    return "common";
  }
}

ConstAttr *ConstAttr::clone(ASTContext &C) const {
  auto *A = new (C) ConstAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ConstAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((const))";
    break;
  }
  case 1 : {
    OS << " [[gnu::const]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((__const))";
    break;
  }
  case 3 : {
    OS << " [[gnu::__const]]";
    break;
  }
}
}

const char *ConstAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "const";
  case 1:
    return "const";
  case 2:
    return "__const";
  case 3:
    return "__const";
  }
}

ConstructorAttr *ConstructorAttr::clone(ASTContext &C) const {
  auto *A = new (C) ConstructorAttr(getLocation(), C, priority, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ConstructorAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((constructor(" << getPriority() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::constructor(" << getPriority() << ")]]";
    break;
  }
}
}

const char *ConstructorAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "constructor";
  case 1:
    return "constructor";
  }
}

ConsumableAttr *ConsumableAttr::clone(ASTContext &C) const {
  auto *A = new (C) ConsumableAttr(getLocation(), C, defaultState, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ConsumableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((consumable(\"" << ConsumableAttr::ConvertConsumedStateToStr(getDefaultState()) << "\")))";
    break;
  }
}
}

const char *ConsumableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "consumable";
  }
}

ConsumableAutoCastAttr *ConsumableAutoCastAttr::clone(ASTContext &C) const {
  auto *A = new (C) ConsumableAutoCastAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ConsumableAutoCastAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((consumable_auto_cast_state))";
    break;
  }
}
}

const char *ConsumableAutoCastAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "consumable_auto_cast_state";
  }
}

ConsumableSetOnReadAttr *ConsumableSetOnReadAttr::clone(ASTContext &C) const {
  auto *A = new (C) ConsumableSetOnReadAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ConsumableSetOnReadAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((consumable_set_state_on_read))";
    break;
  }
}
}

const char *ConsumableSetOnReadAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "consumable_set_state_on_read";
  }
}

DLLExportAttr *DLLExportAttr::clone(ASTContext &C) const {
  auto *A = new (C) DLLExportAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void DLLExportAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(dllexport)";
    break;
  }
  case 1 : {
    OS << " __attribute__((dllexport))";
    break;
  }
  case 2 : {
    OS << " [[gnu::dllexport]]";
    break;
  }
}
}

const char *DLLExportAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "dllexport";
  case 1:
    return "dllexport";
  case 2:
    return "dllexport";
  }
}

DLLImportAttr *DLLImportAttr::clone(ASTContext &C) const {
  auto *A = new (C) DLLImportAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void DLLImportAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(dllimport)";
    break;
  }
  case 1 : {
    OS << " __attribute__((dllimport))";
    break;
  }
  case 2 : {
    OS << " [[gnu::dllimport]]";
    break;
  }
}
}

const char *DLLImportAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "dllimport";
  case 1:
    return "dllimport";
  case 2:
    return "dllimport";
  }
}

DeprecatedAttr *DeprecatedAttr::clone(ASTContext &C) const {
  auto *A = new (C) DeprecatedAttr(getLocation(), C, getMessage(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void DeprecatedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((deprecated(\"" << getMessage() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::deprecated(\"" << getMessage() << "\")]]";
    break;
  }
  case 2 : {
    OS << " __declspec(deprecated(\"" << getMessage() << "\"))";
    break;
  }
  case 3 : {
    OS << " [[deprecated(\"" << getMessage() << "\")]]";
    break;
  }
}
}

const char *DeprecatedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "deprecated";
  case 1:
    return "deprecated";
  case 2:
    return "deprecated";
  case 3:
    return "deprecated";
  }
}

DestructorAttr *DestructorAttr::clone(ASTContext &C) const {
  auto *A = new (C) DestructorAttr(getLocation(), C, priority, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void DestructorAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((destructor(" << getPriority() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::destructor(" << getPriority() << ")]]";
    break;
  }
}
}

const char *DestructorAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "destructor";
  case 1:
    return "destructor";
  }
}

EnableIfAttr *EnableIfAttr::clone(ASTContext &C) const {
  auto *A = new (C) EnableIfAttr(getLocation(), C, cond, getMessage(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void EnableIfAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((enable_if(" << getCond() << ", \"" << getMessage() << "\")))";
    break;
  }
}
}

const char *EnableIfAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "enable_if";
  }
}

ExclusiveTrylockFunctionAttr *ExclusiveTrylockFunctionAttr::clone(ASTContext &C) const {
  auto *A = new (C) ExclusiveTrylockFunctionAttr(getLocation(), C, successValue, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ExclusiveTrylockFunctionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((exclusive_trylock_function(" << getSuccessValue() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *ExclusiveTrylockFunctionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "exclusive_trylock_function";
  }
}

FallThroughAttr *FallThroughAttr::clone(ASTContext &C) const {
  auto *A = new (C) FallThroughAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FallThroughAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[clang::fallthrough]]";
    break;
  }
}
}

const char *FallThroughAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "fallthrough";
  }
}

FastCallAttr *FastCallAttr::clone(ASTContext &C) const {
  auto *A = new (C) FastCallAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FastCallAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((fastcall))";
    break;
  }
  case 1 : {
    OS << " [[gnu::fastcall]]";
    break;
  }
  case 2 : {
    OS << " __fastcall";
    break;
  }
  case 3 : {
    OS << " _fastcall";
    break;
  }
}
}

const char *FastCallAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "fastcall";
  case 1:
    return "fastcall";
  case 2:
    return "__fastcall";
  case 3:
    return "_fastcall";
  }
}

FinalAttr *FinalAttr::clone(ASTContext &C) const {
  auto *A = new (C) FinalAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FinalAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " final";
    break;
  }
  case 1 : {
    OS << " sealed";
    break;
  }
}
}

const char *FinalAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "final";
  case 1:
    return "sealed";
  }
}

FlagEnumAttr *FlagEnumAttr::clone(ASTContext &C) const {
  auto *A = new (C) FlagEnumAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FlagEnumAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((flag_enum))";
    break;
  }
}
}

const char *FlagEnumAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "flag_enum";
  }
}

FlattenAttr *FlattenAttr::clone(ASTContext &C) const {
  auto *A = new (C) FlattenAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FlattenAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((flatten))";
    break;
  }
  case 1 : {
    OS << " [[gnu::flatten]]";
    break;
  }
}
}

const char *FlattenAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "flatten";
  case 1:
    return "flatten";
  }
}

FormatAttr *FormatAttr::clone(ASTContext &C) const {
  auto *A = new (C) FormatAttr(getLocation(), C, type, formatIdx, firstArg, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FormatAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((format(" << getType()->getName() << ", " << getFormatIdx() << ", " << getFirstArg() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::format(" << getType()->getName() << ", " << getFormatIdx() << ", " << getFirstArg() << ")]]";
    break;
  }
}
}

const char *FormatAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "format";
  case 1:
    return "format";
  }
}

FormatArgAttr *FormatArgAttr::clone(ASTContext &C) const {
  auto *A = new (C) FormatArgAttr(getLocation(), C, formatIdx, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void FormatArgAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((format_arg(" << getFormatIdx() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::format_arg(" << getFormatIdx() << ")]]";
    break;
  }
}
}

const char *FormatArgAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "format_arg";
  case 1:
    return "format_arg";
  }
}

GNUInlineAttr *GNUInlineAttr::clone(ASTContext &C) const {
  auto *A = new (C) GNUInlineAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void GNUInlineAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((gnu_inline))";
    break;
  }
  case 1 : {
    OS << " [[gnu::gnu_inline]]";
    break;
  }
}
}

const char *GNUInlineAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "gnu_inline";
  case 1:
    return "gnu_inline";
  }
}

GuardedByAttr *GuardedByAttr::clone(ASTContext &C) const {
  auto *A = new (C) GuardedByAttr(getLocation(), C, arg, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void GuardedByAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((guarded_by(" << getArg() << ")))";
    break;
  }
}
}

const char *GuardedByAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "guarded_by";
  }
}

GuardedVarAttr *GuardedVarAttr::clone(ASTContext &C) const {
  auto *A = new (C) GuardedVarAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void GuardedVarAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((guarded_var))";
    break;
  }
}
}

const char *GuardedVarAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "guarded_var";
  }
}

HLSLAllowSparseNodesAttr *HLSLAllowSparseNodesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLAllowSparseNodesAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLAllowSparseNodesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[allowsparsenodes]]";
    break;
  }
}
}

const char *HLSLAllowSparseNodesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "allowsparsenodes";
  }
}

HLSLAllowUAVConditionAttr *HLSLAllowUAVConditionAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLAllowUAVConditionAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLAllowUAVConditionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[allow_uav_condition]]";
    break;
  }
}
}

const char *HLSLAllowUAVConditionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "allow_uav_condition";
  }
}

HLSLBranchAttr *HLSLBranchAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLBranchAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLBranchAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[branch]]";
    break;
  }
}
}

const char *HLSLBranchAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "branch";
  }
}

HLSLCXXOverloadAttr *HLSLCXXOverloadAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLCXXOverloadAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLCXXOverloadAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLCXXOverloadAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLCallAttr *HLSLCallAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLCallAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLCallAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[call]]";
    break;
  }
}
}

const char *HLSLCallAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "call";
  }
}

HLSLCenterAttr *HLSLCenterAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLCenterAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLCenterAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[center]]";
    break;
  }
}
}

const char *HLSLCenterAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "center";
  }
}

HLSLCentroidAttr *HLSLCentroidAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLCentroidAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLCentroidAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[centroid]]";
    break;
  }
}
}

const char *HLSLCentroidAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "centroid";
  }
}

HLSLClipPlanesAttr *HLSLClipPlanesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLClipPlanesAttr(getLocation(), C, clipPlane1, clipPlane2, clipPlane3, clipPlane4, clipPlane5, clipPlane6, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLClipPlanesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[clipplanes(" << getClipPlane1() << ", " << getClipPlane2() << ", " << getClipPlane3() << ", " << getClipPlane4() << ", " << getClipPlane5() << ", " << getClipPlane6() << ")]]";
    break;
  }
}
}

const char *HLSLClipPlanesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "clipplanes";
  }
}

HLSLDomainAttr *HLSLDomainAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLDomainAttr(getLocation(), C, getDomainType(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLDomainAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[domain(\"" << getDomainType() << "\")]]";
    break;
  }
}
}

const char *HLSLDomainAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "domain";
  }
}

HLSLEarlyDepthStencilAttr *HLSLEarlyDepthStencilAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLEarlyDepthStencilAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLEarlyDepthStencilAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[earlydepthstencil]]";
    break;
  }
}
}

const char *HLSLEarlyDepthStencilAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "earlydepthstencil";
  }
}

HLSLExperimentalAttr *HLSLExperimentalAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLExperimentalAttr(getLocation(), C, getName(), getValue(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLExperimentalAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[experimental(\"" << getName() << "\", \"" << getValue() << "\")]]";
    break;
  }
}
}

const char *HLSLExperimentalAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "experimental";
  }
}

HLSLExportAttr *HLSLExportAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLExportAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLExportAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[export]]";
    break;
  }
}
}

const char *HLSLExportAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "export";
  }
}

HLSLFastOptAttr *HLSLFastOptAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLFastOptAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLFastOptAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[fastopt]]";
    break;
  }
}
}

const char *HLSLFastOptAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "fastopt";
  }
}

HLSLFlattenAttr *HLSLFlattenAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLFlattenAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLFlattenAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[flatten]]";
    break;
  }
}
}

const char *HLSLFlattenAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "flatten";
  }
}

HLSLForceCaseAttr *HLSLForceCaseAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLForceCaseAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLForceCaseAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[forcecase]]";
    break;
  }
}
}

const char *HLSLForceCaseAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "forcecase";
  }
}

HLSLGloballyCoherentAttr *HLSLGloballyCoherentAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLGloballyCoherentAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLGloballyCoherentAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[globallycoherent]]";
    break;
  }
}
}

const char *HLSLGloballyCoherentAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "globallycoherent";
  }
}

HLSLGroupSharedAttr *HLSLGroupSharedAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLGroupSharedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLGroupSharedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[groupshared]]";
    break;
  }
}
}

const char *HLSLGroupSharedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "groupshared";
  }
}

HLSLHitObjectAttr *HLSLHitObjectAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLHitObjectAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLHitObjectAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLHitObjectAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLInAttr *HLSLInAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLInAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLInAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[in]]";
    break;
  }
}
}

const char *HLSLInAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "in";
  }
}

HLSLInOutAttr *HLSLInOutAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLInOutAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLInOutAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[inout]]";
    break;
  }
}
}

const char *HLSLInOutAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "inout";
  }
}

HLSLIndicesAttr *HLSLIndicesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLIndicesAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLIndicesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[indices]]";
    break;
  }
}
}

const char *HLSLIndicesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "indices";
  }
}

HLSLInstanceAttr *HLSLInstanceAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLInstanceAttr(getLocation(), C, count, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLInstanceAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[instance(" << getCount() << ")]]";
    break;
  }
}
}

const char *HLSLInstanceAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "instance";
  }
}

HLSLIntrinsicAttr *HLSLIntrinsicAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLIntrinsicAttr(getLocation(), C, getGroup(), getLowering(), opcode, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLIntrinsicAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[intrinsic(\"" << getGroup() << "\", \"" << getLowering() << "\", " << getOpcode() << ")]]";
    break;
  }
}
}

const char *HLSLIntrinsicAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "intrinsic";
  }
}

HLSLLineAttr *HLSLLineAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLLineAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLLineAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[line]]";
    break;
  }
}
}

const char *HLSLLineAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "line";
  }
}

HLSLLineAdjAttr *HLSLLineAdjAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLLineAdjAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLLineAdjAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[lineadj]]";
    break;
  }
}
}

const char *HLSLLineAdjAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "lineadj";
  }
}

HLSLLinearAttr *HLSLLinearAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLLinearAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLLinearAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[linear]]";
    break;
  }
}
}

const char *HLSLLinearAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "linear";
  }
}

HLSLLoopAttr *HLSLLoopAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLLoopAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLLoopAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[loop]]";
    break;
  }
}
}

const char *HLSLLoopAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "loop";
  }
}

HLSLMatrixAttr *HLSLMatrixAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLMatrixAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLMatrixAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLMatrixAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLMaxRecordsAttr *HLSLMaxRecordsAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLMaxRecordsAttr(getLocation(), C, maxCount, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLMaxRecordsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[MaxRecords(" << getMaxCount() << ")]]";
    break;
  }
}
}

const char *HLSLMaxRecordsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "MaxRecords";
  }
}

HLSLMaxRecordsSharedWithAttr *HLSLMaxRecordsSharedWithAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLMaxRecordsSharedWithAttr(getLocation(), C, name, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLMaxRecordsSharedWithAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[maxrecordssharedwith(" << getName()->getName() << ")]]";
    break;
  }
}
}

const char *HLSLMaxRecordsSharedWithAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "maxrecordssharedwith";
  }
}

HLSLMaxTessFactorAttr *HLSLMaxTessFactorAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLMaxTessFactorAttr(getLocation(), C, factor, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLMaxTessFactorAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[maxtessfactor(" << getFactor() << ")]]";
    break;
  }
}
}

const char *HLSLMaxTessFactorAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "maxtessfactor";
  }
}

HLSLMaxVertexCountAttr *HLSLMaxVertexCountAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLMaxVertexCountAttr(getLocation(), C, count, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLMaxVertexCountAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[maxvertexcount(" << getCount() << ")]]";
    break;
  }
}
}

const char *HLSLMaxVertexCountAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "maxvertexcount";
  }
}

HLSLMaybeUnusedAttr *HLSLMaybeUnusedAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLMaybeUnusedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLMaybeUnusedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[maybe_unused]]";
    break;
  }
}
}

const char *HLSLMaybeUnusedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "maybe_unused";
  }
}

HLSLNoInterpolationAttr *HLSLNoInterpolationAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNoInterpolationAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNoInterpolationAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nointerpolation]]";
    break;
  }
}
}

const char *HLSLNoInterpolationAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nointerpolation";
  }
}

HLSLNoPerspectiveAttr *HLSLNoPerspectiveAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNoPerspectiveAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNoPerspectiveAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[noperspective]]";
    break;
  }
}
}

const char *HLSLNoPerspectiveAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "noperspective";
  }
}

HLSLNodeArraySizeAttr *HLSLNodeArraySizeAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeArraySizeAttr(getLocation(), C, count, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeArraySizeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[NodeArraySize(" << getCount() << ")]]";
    break;
  }
}
}

const char *HLSLNodeArraySizeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "NodeArraySize";
  }
}

HLSLNodeDispatchGridAttr *HLSLNodeDispatchGridAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeDispatchGridAttr(getLocation(), C, x, y, z, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeDispatchGridAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodedispatchgrid(" << getX() << ", " << getY() << ", " << getZ() << ")]]";
    break;
  }
}
}

const char *HLSLNodeDispatchGridAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodedispatchgrid";
  }
}

HLSLNodeIdAttr *HLSLNodeIdAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeIdAttr(getLocation(), C, getName(), arrayIndex, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeIdAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodeid(\"" << getName() << "\", " << getArrayIndex() << ")]]";
    break;
  }
}
}

const char *HLSLNodeIdAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodeid";
  }
}

HLSLNodeIsProgramEntryAttr *HLSLNodeIsProgramEntryAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeIsProgramEntryAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeIsProgramEntryAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodeisprogramentry]]";
    break;
  }
}
}

const char *HLSLNodeIsProgramEntryAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodeisprogramentry";
  }
}

HLSLNodeLaunchAttr *HLSLNodeLaunchAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeLaunchAttr(getLocation(), C, getLaunchType(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeLaunchAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodelaunch(\"" << getLaunchType() << "\")]]";
    break;
  }
}
}

const char *HLSLNodeLaunchAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodelaunch";
  }
}

HLSLNodeLocalRootArgumentsTableIndexAttr *HLSLNodeLocalRootArgumentsTableIndexAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeLocalRootArgumentsTableIndexAttr(getLocation(), C, index, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeLocalRootArgumentsTableIndexAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodelocalrootargumentstableindex(" << getIndex() << ")]]";
    break;
  }
}
}

const char *HLSLNodeLocalRootArgumentsTableIndexAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodelocalrootargumentstableindex";
  }
}

HLSLNodeMaxDispatchGridAttr *HLSLNodeMaxDispatchGridAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeMaxDispatchGridAttr(getLocation(), C, x, y, z, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeMaxDispatchGridAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodemaxdispatchgrid(" << getX() << ", " << getY() << ", " << getZ() << ")]]";
    break;
  }
}
}

const char *HLSLNodeMaxDispatchGridAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodemaxdispatchgrid";
  }
}

HLSLNodeMaxRecursionDepthAttr *HLSLNodeMaxRecursionDepthAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeMaxRecursionDepthAttr(getLocation(), C, count, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeMaxRecursionDepthAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodemaxrecursiondepth(" << getCount() << ")]]";
    break;
  }
}
}

const char *HLSLNodeMaxRecursionDepthAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodemaxrecursiondepth";
  }
}

HLSLNodeObjectAttr *HLSLNodeObjectAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeObjectAttr(getLocation(), C, type, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeObjectAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLNodeObjectAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLNodeShareInputOfAttr *HLSLNodeShareInputOfAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeShareInputOfAttr(getLocation(), C, getName(), arrayIndex, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeShareInputOfAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodeshareinputof(\"" << getName() << "\", " << getArrayIndex() << ")]]";
    break;
  }
}
}

const char *HLSLNodeShareInputOfAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodeshareinputof";
  }
}

HLSLNodeTrackRWInputSharingAttr *HLSLNodeTrackRWInputSharingAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNodeTrackRWInputSharingAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNodeTrackRWInputSharingAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[nodetrackrwinputsharing]]";
    break;
  }
}
}

const char *HLSLNodeTrackRWInputSharingAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodetrackrwinputsharing";
  }
}

HLSLNumThreadsAttr *HLSLNumThreadsAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLNumThreadsAttr(getLocation(), C, x, y, z, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLNumThreadsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[numthreads(" << getX() << ", " << getY() << ", " << getZ() << ")]]";
    break;
  }
}
}

const char *HLSLNumThreadsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "numthreads";
  }
}

HLSLOutAttr *HLSLOutAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLOutAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLOutAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[out]]";
    break;
  }
}
}

const char *HLSLOutAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "out";
  }
}

HLSLOutputControlPointsAttr *HLSLOutputControlPointsAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLOutputControlPointsAttr(getLocation(), C, count, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLOutputControlPointsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[outputcontrolpoints(" << getCount() << ")]]";
    break;
  }
}
}

const char *HLSLOutputControlPointsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "outputcontrolpoints";
  }
}

HLSLOutputTopologyAttr *HLSLOutputTopologyAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLOutputTopologyAttr(getLocation(), C, getTopology(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLOutputTopologyAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[outputtopology(\"" << getTopology() << "\")]]";
    break;
  }
}
}

const char *HLSLOutputTopologyAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "outputtopology";
  }
}

HLSLPartitioningAttr *HLSLPartitioningAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLPartitioningAttr(getLocation(), C, getScheme(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLPartitioningAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[partitioning(\"" << getScheme() << "\")]]";
    break;
  }
}
}

const char *HLSLPartitioningAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "partitioning";
  }
}

HLSLPatchConstantFuncAttr *HLSLPatchConstantFuncAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLPatchConstantFuncAttr(getLocation(), C, getFunctionName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLPatchConstantFuncAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[patchconstantfunc(\"" << getFunctionName() << "\")]]";
    break;
  }
}
}

const char *HLSLPatchConstantFuncAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "patchconstantfunc";
  }
}

HLSLPayloadAttr *HLSLPayloadAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLPayloadAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLPayloadAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[payload]]";
    break;
  }
}
}

const char *HLSLPayloadAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "payload";
  }
}

HLSLPointAttr *HLSLPointAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLPointAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLPointAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[point]]";
    break;
  }
}
}

const char *HLSLPointAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "point";
  }
}

HLSLPreciseAttr *HLSLPreciseAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLPreciseAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLPreciseAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[precise]]";
    break;
  }
}
}

const char *HLSLPreciseAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "precise";
  }
}

HLSLPrimitivesAttr *HLSLPrimitivesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLPrimitivesAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLPrimitivesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[primitives]]";
    break;
  }
}
}

const char *HLSLPrimitivesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "primitives";
  }
}

HLSLRayPayloadAttr *HLSLRayPayloadAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLRayPayloadAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLRayPayloadAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[raypayload]]";
    break;
  }
}
}

const char *HLSLRayPayloadAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "raypayload";
  }
}

HLSLRayQueryObjectAttr *HLSLRayQueryObjectAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLRayQueryObjectAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLRayQueryObjectAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLRayQueryObjectAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLReorderCoherentAttr *HLSLReorderCoherentAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLReorderCoherentAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLReorderCoherentAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[reordercoherent]]";
    break;
  }
}
}

const char *HLSLReorderCoherentAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "reordercoherent";
  }
}

HLSLResourceAttr *HLSLResourceAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLResourceAttr(getLocation(), C, resKindUint, resClassUint, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLResourceAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLResourceAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLRootSignatureAttr *HLSLRootSignatureAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLRootSignatureAttr(getLocation(), C, getSignatureName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLRootSignatureAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[RootSignature(\"" << getSignatureName() << "\")]]";
    break;
  }
}
}

const char *HLSLRootSignatureAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "RootSignature";
  }
}

HLSLSampleAttr *HLSLSampleAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLSampleAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLSampleAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[sample]]";
    break;
  }
}
}

const char *HLSLSampleAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "sample";
  }
}

HLSLSemanticAttr *HLSLSemanticAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLSemanticAttr(getLocation(), C, getName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLSemanticAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLSemanticAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLShaderAttr *HLSLShaderAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLShaderAttr(getLocation(), C, getStage(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLShaderAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[shader(\"" << getStage() << "\")]]";
    break;
  }
}
}

const char *HLSLShaderAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "shader";
  }
}

HLSLSharedAttr *HLSLSharedAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLSharedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLSharedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[shared]]";
    break;
  }
}
}

const char *HLSLSharedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "shared";
  }
}

HLSLSnormAttr *HLSLSnormAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLSnormAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLSnormAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[snorm]]";
    break;
  }
}
}

const char *HLSLSnormAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "snorm";
  }
}

HLSLStreamOutputAttr *HLSLStreamOutputAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLStreamOutputAttr(getLocation(), C, primVertices, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLStreamOutputAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLStreamOutputAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLSubObjectAttr *HLSLSubObjectAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLSubObjectAttr(getLocation(), C, subObjKindUint, hitGroupType, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLSubObjectAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLSubObjectAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLTessPatchAttr *HLSLTessPatchAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLTessPatchAttr(getLocation(), C, isInput, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLTessPatchAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLTessPatchAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLTriangleAttr *HLSLTriangleAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLTriangleAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLTriangleAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[triangle]]";
    break;
  }
}
}

const char *HLSLTriangleAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "triangle";
  }
}

HLSLTriangleAdjAttr *HLSLTriangleAdjAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLTriangleAdjAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLTriangleAdjAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[triangleadj]]";
    break;
  }
}
}

const char *HLSLTriangleAdjAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "triangleadj";
  }
}

HLSLUnboundedSparseNodesAttr *HLSLUnboundedSparseNodesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLUnboundedSparseNodesAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLUnboundedSparseNodesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[unboundedsparsenodes]]";
    break;
  }
}
}

const char *HLSLUnboundedSparseNodesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "unboundedsparsenodes";
  }
}

HLSLUniformAttr *HLSLUniformAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLUniformAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLUniformAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[uniform]]";
    break;
  }
}
}

const char *HLSLUniformAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "uniform";
  }
}

HLSLUnormAttr *HLSLUnormAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLUnormAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLUnormAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[unorm]]";
    break;
  }
}
}

const char *HLSLUnormAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "unorm";
  }
}

HLSLUnrollAttr *HLSLUnrollAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLUnrollAttr(getLocation(), C, count, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLUnrollAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[unroll(" << getCount() << ")]]";
    break;
  }
}
}

const char *HLSLUnrollAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "unroll";
  }
}

HLSLVectorAttr *HLSLVectorAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLVectorAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLVectorAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *HLSLVectorAttr::getSpelling() const {
  return "(No spelling)";
}

HLSLVerticesAttr *HLSLVerticesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLVerticesAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLVerticesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vertices]]";
    break;
  }
}
}

const char *HLSLVerticesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "vertices";
  }
}

HLSLWaveOpsIncludeHelperLanesAttr *HLSLWaveOpsIncludeHelperLanesAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLWaveOpsIncludeHelperLanesAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLWaveOpsIncludeHelperLanesAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[waveopsincludehelperlanes]]";
    break;
  }
}
}

const char *HLSLWaveOpsIncludeHelperLanesAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "waveopsincludehelperlanes";
  }
}

HLSLWaveSensitiveAttr *HLSLWaveSensitiveAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLWaveSensitiveAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLWaveSensitiveAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[wavesensitive]]";
    break;
  }
}
}

const char *HLSLWaveSensitiveAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "wavesensitive";
  }
}

HLSLWaveSizeAttr *HLSLWaveSizeAttr::clone(ASTContext &C) const {
  auto *A = new (C) HLSLWaveSizeAttr(getLocation(), C, min, max, preferred, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HLSLWaveSizeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[wavesize(" << getMin() << ", " << getMax() << ", " << getPreferred() << ")]]";
    break;
  }
}
}

const char *HLSLWaveSizeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "wavesize";
  }
}

HotAttr *HotAttr::clone(ASTContext &C) const {
  auto *A = new (C) HotAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void HotAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((hot))";
    break;
  }
  case 1 : {
    OS << " [[gnu::hot]]";
    break;
  }
}
}

const char *HotAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "hot";
  case 1:
    return "hot";
  }
}

IBActionAttr *IBActionAttr::clone(ASTContext &C) const {
  auto *A = new (C) IBActionAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void IBActionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ibaction))";
    break;
  }
}
}

const char *IBActionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ibaction";
  }
}

IBOutletAttr *IBOutletAttr::clone(ASTContext &C) const {
  auto *A = new (C) IBOutletAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void IBOutletAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((iboutlet))";
    break;
  }
}
}

const char *IBOutletAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "iboutlet";
  }
}

IBOutletCollectionAttr *IBOutletCollectionAttr::clone(ASTContext &C) const {
  auto *A = new (C) IBOutletCollectionAttr(getLocation(), C, interface, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void IBOutletCollectionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((iboutletcollection(" << getInterface().getAsString() << ")))";
    break;
  }
}
}

const char *IBOutletCollectionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "iboutletcollection";
  }
}

InitPriorityAttr *InitPriorityAttr::clone(ASTContext &C) const {
  auto *A = new (C) InitPriorityAttr(getLocation(), C, priority, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void InitPriorityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((init_priority(" << getPriority() << ")))";
    break;
  }
}
}

const char *InitPriorityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "init_priority";
  }
}

InitSegAttr *InitSegAttr::clone(ASTContext &C) const {
  auto *A = new (C) InitSegAttr(getLocation(), C, getSection(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void InitSegAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << "#pragma init_seg ";
    printPrettyPragma(OS, Policy);
    break;
  }
}
}

const char *InitSegAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "init_seg";
  }
}

IntelOclBiccAttr *IntelOclBiccAttr::clone(ASTContext &C) const {
  auto *A = new (C) IntelOclBiccAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void IntelOclBiccAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((intel_ocl_bicc))";
    break;
  }
}
}

const char *IntelOclBiccAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "intel_ocl_bicc";
  }
}

LockReturnedAttr *LockReturnedAttr::clone(ASTContext &C) const {
  auto *A = new (C) LockReturnedAttr(getLocation(), C, arg, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void LockReturnedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((lock_returned(" << getArg() << ")))";
    break;
  }
}
}

const char *LockReturnedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "lock_returned";
  }
}

LocksExcludedAttr *LocksExcludedAttr::clone(ASTContext &C) const {
  auto *A = new (C) LocksExcludedAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void LocksExcludedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((locks_excluded(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *LocksExcludedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "locks_excluded";
  }
}

LoopHintAttr *LoopHintAttr::clone(ASTContext &C) const {
  auto *A = new (C) LoopHintAttr(getLocation(), C, option, state, value, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void LoopHintAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << "#pragma clang loop ";
    printPrettyPragma(OS, Policy);
    break;
  }
  case 1 : {
    OS << "#pragma unroll ";
    printPrettyPragma(OS, Policy);
    break;
  }
  case 2 : {
    OS << "#pragma nounroll ";
    printPrettyPragma(OS, Policy);
    break;
  }
}
}

const char *LoopHintAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "loop";
  case 1:
    return "unroll";
  case 2:
    return "nounroll";
  }
}

MSABIAttr *MSABIAttr::clone(ASTContext &C) const {
  auto *A = new (C) MSABIAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MSABIAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ms_abi))";
    break;
  }
  case 1 : {
    OS << " [[gnu::ms_abi]]";
    break;
  }
}
}

const char *MSABIAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ms_abi";
  case 1:
    return "ms_abi";
  }
}

MSInheritanceAttr *MSInheritanceAttr::clone(ASTContext &C) const {
  auto *A = new (C) MSInheritanceAttr(getLocation(), C, bestCase, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MSInheritanceAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __single_inheritance(" << getBestCase() << ")";
    break;
  }
  case 1 : {
    OS << " __multiple_inheritance(" << getBestCase() << ")";
    break;
  }
  case 2 : {
    OS << " __virtual_inheritance(" << getBestCase() << ")";
    break;
  }
  case 3 : {
    OS << " __unspecified_inheritance(" << getBestCase() << ")";
    break;
  }
}
}

const char *MSInheritanceAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "__single_inheritance";
  case 1:
    return "__multiple_inheritance";
  case 2:
    return "__virtual_inheritance";
  case 3:
    return "__unspecified_inheritance";
  }
}

MSNoVTableAttr *MSNoVTableAttr::clone(ASTContext &C) const {
  auto *A = new (C) MSNoVTableAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MSNoVTableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(novtable)";
    break;
  }
}
}

const char *MSNoVTableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "novtable";
  }
}

MSP430InterruptAttr *MSP430InterruptAttr::clone(ASTContext &C) const {
  auto *A = new (C) MSP430InterruptAttr(getLocation(), C, number, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MSP430InterruptAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((interrupt(" << getNumber() << ")))";
    break;
  }
}
}

const char *MSP430InterruptAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "interrupt";
  }
}

MSStructAttr *MSStructAttr::clone(ASTContext &C) const {
  auto *A = new (C) MSStructAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MSStructAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ms_struct))";
    break;
  }
  case 1 : {
    OS << " [[gnu::ms_struct]]";
    break;
  }
}
}

const char *MSStructAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ms_struct";
  case 1:
    return "ms_struct";
  }
}

MSVtorDispAttr *MSVtorDispAttr::clone(ASTContext &C) const {
  auto *A = new (C) MSVtorDispAttr(getLocation(), C, vdm, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MSVtorDispAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *MSVtorDispAttr::getSpelling() const {
  return "(No spelling)";
}

MaxFieldAlignmentAttr *MaxFieldAlignmentAttr::clone(ASTContext &C) const {
  auto *A = new (C) MaxFieldAlignmentAttr(getLocation(), C, alignment, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MaxFieldAlignmentAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *MaxFieldAlignmentAttr::getSpelling() const {
  return "(No spelling)";
}

MayAliasAttr *MayAliasAttr::clone(ASTContext &C) const {
  auto *A = new (C) MayAliasAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MayAliasAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((may_alias))";
    break;
  }
  case 1 : {
    OS << " [[gnu::may_alias]]";
    break;
  }
}
}

const char *MayAliasAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "may_alias";
  case 1:
    return "may_alias";
  }
}

MinSizeAttr *MinSizeAttr::clone(ASTContext &C) const {
  auto *A = new (C) MinSizeAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void MinSizeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((minsize))";
    break;
  }
}
}

const char *MinSizeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "minsize";
  }
}

Mips16Attr *Mips16Attr::clone(ASTContext &C) const {
  auto *A = new (C) Mips16Attr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void Mips16Attr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((mips16))";
    break;
  }
  case 1 : {
    OS << " [[gnu::mips16]]";
    break;
  }
}
}

const char *Mips16Attr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "mips16";
  case 1:
    return "mips16";
  }
}

ModeAttr *ModeAttr::clone(ASTContext &C) const {
  auto *A = new (C) ModeAttr(getLocation(), C, mode, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ModeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((mode(" << getMode()->getName() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::mode(" << getMode()->getName() << ")]]";
    break;
  }
}
}

const char *ModeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "mode";
  case 1:
    return "mode";
  }
}

NSConsumedAttr *NSConsumedAttr::clone(ASTContext &C) const {
  auto *A = new (C) NSConsumedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NSConsumedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ns_consumed))";
    break;
  }
}
}

const char *NSConsumedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ns_consumed";
  }
}

NSConsumesSelfAttr *NSConsumesSelfAttr::clone(ASTContext &C) const {
  auto *A = new (C) NSConsumesSelfAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NSConsumesSelfAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ns_consumes_self))";
    break;
  }
}
}

const char *NSConsumesSelfAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ns_consumes_self";
  }
}

NSReturnsAutoreleasedAttr *NSReturnsAutoreleasedAttr::clone(ASTContext &C) const {
  auto *A = new (C) NSReturnsAutoreleasedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NSReturnsAutoreleasedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ns_returns_autoreleased))";
    break;
  }
}
}

const char *NSReturnsAutoreleasedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ns_returns_autoreleased";
  }
}

NSReturnsNotRetainedAttr *NSReturnsNotRetainedAttr::clone(ASTContext &C) const {
  auto *A = new (C) NSReturnsNotRetainedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NSReturnsNotRetainedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ns_returns_not_retained))";
    break;
  }
}
}

const char *NSReturnsNotRetainedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ns_returns_not_retained";
  }
}

NSReturnsRetainedAttr *NSReturnsRetainedAttr::clone(ASTContext &C) const {
  auto *A = new (C) NSReturnsRetainedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NSReturnsRetainedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ns_returns_retained))";
    break;
  }
}
}

const char *NSReturnsRetainedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ns_returns_retained";
  }
}

NakedAttr *NakedAttr::clone(ASTContext &C) const {
  auto *A = new (C) NakedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NakedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((naked))";
    break;
  }
  case 1 : {
    OS << " [[gnu::naked]]";
    break;
  }
  case 2 : {
    OS << " __declspec(naked)";
    break;
  }
}
}

const char *NakedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "naked";
  case 1:
    return "naked";
  case 2:
    return "naked";
  }
}

NoCommonAttr *NoCommonAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoCommonAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoCommonAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((nocommon))";
    break;
  }
  case 1 : {
    OS << " [[gnu::nocommon]]";
    break;
  }
}
}

const char *NoCommonAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nocommon";
  case 1:
    return "nocommon";
  }
}

NoDebugAttr *NoDebugAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoDebugAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoDebugAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((nodebug))";
    break;
  }
  case 1 : {
    OS << " [[gnu::nodebug]]";
    break;
  }
}
}

const char *NoDebugAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nodebug";
  case 1:
    return "nodebug";
  }
}

NoDuplicateAttr *NoDuplicateAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoDuplicateAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoDuplicateAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((noduplicate))";
    break;
  }
  case 1 : {
    OS << " [[clang::noduplicate]]";
    break;
  }
}
}

const char *NoDuplicateAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "noduplicate";
  case 1:
    return "noduplicate";
  }
}

NoInlineAttr *NoInlineAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoInlineAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoInlineAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((noinline))";
    break;
  }
  case 1 : {
    OS << " [[gnu::noinline]]";
    break;
  }
  case 2 : {
    OS << " __declspec(noinline)";
    break;
  }
  case 3 : {
    OS << " [[noinline]]";
    break;
  }
}
}

const char *NoInlineAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "noinline";
  case 1:
    return "noinline";
  case 2:
    return "noinline";
  case 3:
    return "noinline";
  }
}

NoInstrumentFunctionAttr *NoInstrumentFunctionAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoInstrumentFunctionAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoInstrumentFunctionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((no_instrument_function))";
    break;
  }
  case 1 : {
    OS << " [[gnu::no_instrument_function]]";
    break;
  }
}
}

const char *NoInstrumentFunctionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "no_instrument_function";
  case 1:
    return "no_instrument_function";
  }
}

NoMips16Attr *NoMips16Attr::clone(ASTContext &C) const {
  auto *A = new (C) NoMips16Attr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoMips16Attr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((nomips16))";
    break;
  }
  case 1 : {
    OS << " [[gnu::nomips16]]";
    break;
  }
}
}

const char *NoMips16Attr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nomips16";
  case 1:
    return "nomips16";
  }
}

NoReturnAttr *NoReturnAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoReturnAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoReturnAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((noreturn))";
    break;
  }
  case 1 : {
    OS << " [[gnu::noreturn]]";
    break;
  }
  case 2 : {
    OS << " __declspec(noreturn)";
    break;
  }
}
}

const char *NoReturnAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "noreturn";
  case 1:
    return "noreturn";
  case 2:
    return "noreturn";
  }
}

NoSanitizeAttr *NoSanitizeAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoSanitizeAttr(getLocation(), C, sanitizers_, sanitizers_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoSanitizeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((no_sanitize(";
  bool isFirst = true;
  for (const auto &Val : sanitizers()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << "\"" << Val << "\"";
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[clang::no_sanitize(";
  bool isFirst = true;
  for (const auto &Val : sanitizers()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << "\"" << Val << "\"";
  }
  OS << ")]]";
    break;
  }
}
}

const char *NoSanitizeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "no_sanitize";
  case 1:
    return "no_sanitize";
  }
}

NoSplitStackAttr *NoSplitStackAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoSplitStackAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoSplitStackAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((no_split_stack))";
    break;
  }
  case 1 : {
    OS << " [[gnu::no_split_stack]]";
    break;
  }
}
}

const char *NoSplitStackAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "no_split_stack";
  case 1:
    return "no_split_stack";
  }
}

NoThreadSafetyAnalysisAttr *NoThreadSafetyAnalysisAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoThreadSafetyAnalysisAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoThreadSafetyAnalysisAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((no_thread_safety_analysis))";
    break;
  }
}
}

const char *NoThreadSafetyAnalysisAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "no_thread_safety_analysis";
  }
}

NoThrowAttr *NoThrowAttr::clone(ASTContext &C) const {
  auto *A = new (C) NoThrowAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NoThrowAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((nothrow))";
    break;
  }
  case 1 : {
    OS << " [[gnu::nothrow]]";
    break;
  }
  case 2 : {
    OS << " __declspec(nothrow)";
    break;
  }
}
}

const char *NoThrowAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nothrow";
  case 1:
    return "nothrow";
  case 2:
    return "nothrow";
  }
}

NonNullAttr *NonNullAttr::clone(ASTContext &C) const {
  auto *A = new (C) NonNullAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void NonNullAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((nonnull(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::nonnull(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
}
}

const char *NonNullAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "nonnull";
  case 1:
    return "nonnull";
  }
}

OMPThreadPrivateDeclAttr *OMPThreadPrivateDeclAttr::clone(ASTContext &C) const {
  auto *A = new (C) OMPThreadPrivateDeclAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OMPThreadPrivateDeclAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
}

const char *OMPThreadPrivateDeclAttr::getSpelling() const {
  return "(No spelling)";
}

ObjCBoxableAttr *ObjCBoxableAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCBoxableAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCBoxableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_boxable))";
    break;
  }
}
}

const char *ObjCBoxableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_boxable";
  }
}

ObjCBridgeAttr *ObjCBridgeAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCBridgeAttr(getLocation(), C, bridgedType, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCBridgeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_bridge(" << getBridgedType()->getName() << ")))";
    break;
  }
}
}

const char *ObjCBridgeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_bridge";
  }
}

ObjCBridgeMutableAttr *ObjCBridgeMutableAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCBridgeMutableAttr(getLocation(), C, bridgedType, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCBridgeMutableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_bridge_mutable(" << getBridgedType()->getName() << ")))";
    break;
  }
}
}

const char *ObjCBridgeMutableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_bridge_mutable";
  }
}

ObjCBridgeRelatedAttr *ObjCBridgeRelatedAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCBridgeRelatedAttr(getLocation(), C, relatedClass, classMethod, instanceMethod, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCBridgeRelatedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_bridge_related(" << getRelatedClass()->getName() << ", " << getClassMethod()->getName() << ", " << getInstanceMethod()->getName() << ")))";
    break;
  }
}
}

const char *ObjCBridgeRelatedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_bridge_related";
  }
}

ObjCDesignatedInitializerAttr *ObjCDesignatedInitializerAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCDesignatedInitializerAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCDesignatedInitializerAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_designated_initializer))";
    break;
  }
}
}

const char *ObjCDesignatedInitializerAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_designated_initializer";
  }
}

ObjCExceptionAttr *ObjCExceptionAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCExceptionAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCExceptionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_exception))";
    break;
  }
}
}

const char *ObjCExceptionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_exception";
  }
}

ObjCExplicitProtocolImplAttr *ObjCExplicitProtocolImplAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCExplicitProtocolImplAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCExplicitProtocolImplAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_protocol_requires_explicit_implementation))";
    break;
  }
}
}

const char *ObjCExplicitProtocolImplAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_protocol_requires_explicit_implementation";
  }
}

ObjCIndependentClassAttr *ObjCIndependentClassAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCIndependentClassAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCIndependentClassAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_independent_class))";
    break;
  }
}
}

const char *ObjCIndependentClassAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_independent_class";
  }
}

ObjCMethodFamilyAttr *ObjCMethodFamilyAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCMethodFamilyAttr(getLocation(), C, family, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCMethodFamilyAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_method_family(\"" << ObjCMethodFamilyAttr::ConvertFamilyKindToStr(getFamily()) << "\")))";
    break;
  }
}
}

const char *ObjCMethodFamilyAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_method_family";
  }
}

ObjCNSObjectAttr *ObjCNSObjectAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCNSObjectAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCNSObjectAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((NSObject))";
    break;
  }
}
}

const char *ObjCNSObjectAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "NSObject";
  }
}

ObjCPreciseLifetimeAttr *ObjCPreciseLifetimeAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCPreciseLifetimeAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCPreciseLifetimeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_precise_lifetime))";
    break;
  }
}
}

const char *ObjCPreciseLifetimeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_precise_lifetime";
  }
}

ObjCRequiresPropertyDefsAttr *ObjCRequiresPropertyDefsAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCRequiresPropertyDefsAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCRequiresPropertyDefsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_requires_property_definitions))";
    break;
  }
}
}

const char *ObjCRequiresPropertyDefsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_requires_property_definitions";
  }
}

ObjCRequiresSuperAttr *ObjCRequiresSuperAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCRequiresSuperAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCRequiresSuperAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_requires_super))";
    break;
  }
}
}

const char *ObjCRequiresSuperAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_requires_super";
  }
}

ObjCReturnsInnerPointerAttr *ObjCReturnsInnerPointerAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCReturnsInnerPointerAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCReturnsInnerPointerAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_returns_inner_pointer))";
    break;
  }
}
}

const char *ObjCReturnsInnerPointerAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_returns_inner_pointer";
  }
}

ObjCRootClassAttr *ObjCRootClassAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCRootClassAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCRootClassAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_root_class))";
    break;
  }
}
}

const char *ObjCRootClassAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_root_class";
  }
}

ObjCRuntimeNameAttr *ObjCRuntimeNameAttr::clone(ASTContext &C) const {
  auto *A = new (C) ObjCRuntimeNameAttr(getLocation(), C, getMetadataName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ObjCRuntimeNameAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((objc_runtime_name(\"" << getMetadataName() << "\")))";
    break;
  }
}
}

const char *ObjCRuntimeNameAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "objc_runtime_name";
  }
}

OpenCLImageAccessAttr *OpenCLImageAccessAttr::clone(ASTContext &C) const {
  auto *A = new (C) OpenCLImageAccessAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OpenCLImageAccessAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __read_only";
    break;
  }
  case 1 : {
    OS << " read_only";
    break;
  }
  case 2 : {
    OS << " __write_only";
    break;
  }
  case 3 : {
    OS << " write_only";
    break;
  }
  case 4 : {
    OS << " __read_write";
    break;
  }
  case 5 : {
    OS << " read_write";
    break;
  }
}
}

const char *OpenCLImageAccessAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "__read_only";
  case 1:
    return "read_only";
  case 2:
    return "__write_only";
  case 3:
    return "write_only";
  case 4:
    return "__read_write";
  case 5:
    return "read_write";
  }
}

OpenCLKernelAttr *OpenCLKernelAttr::clone(ASTContext &C) const {
  auto *A = new (C) OpenCLKernelAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OpenCLKernelAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __kernel";
    break;
  }
  case 1 : {
    OS << " kernel";
    break;
  }
}
}

const char *OpenCLKernelAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "__kernel";
  case 1:
    return "kernel";
  }
}

OptimizeNoneAttr *OptimizeNoneAttr::clone(ASTContext &C) const {
  auto *A = new (C) OptimizeNoneAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OptimizeNoneAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((optnone))";
    break;
  }
  case 1 : {
    OS << " [[clang::optnone]]";
    break;
  }
}
}

const char *OptimizeNoneAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "optnone";
  case 1:
    return "optnone";
  }
}

OverloadableAttr *OverloadableAttr::clone(ASTContext &C) const {
  auto *A = new (C) OverloadableAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OverloadableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((overloadable))";
    break;
  }
}
}

const char *OverloadableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "overloadable";
  }
}

OverrideAttr *OverrideAttr::clone(ASTContext &C) const {
  auto *A = new (C) OverrideAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OverrideAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " override";
    break;
  }
}
}

const char *OverrideAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "override";
  }
}

OwnershipAttr *OwnershipAttr::clone(ASTContext &C) const {
  auto *A = new (C) OwnershipAttr(getLocation(), C, module, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void OwnershipAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((ownership_holds(" << getModule()->getName() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " __attribute__((ownership_returns(" << getModule()->getName() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 2 : {
    OS << " __attribute__((ownership_takes(" << getModule()->getName() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *OwnershipAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ownership_holds";
  case 1:
    return "ownership_returns";
  case 2:
    return "ownership_takes";
  }
}

PackedAttr *PackedAttr::clone(ASTContext &C) const {
  auto *A = new (C) PackedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void PackedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((packed))";
    break;
  }
  case 1 : {
    OS << " [[gnu::packed]]";
    break;
  }
}
}

const char *PackedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "packed";
  case 1:
    return "packed";
  }
}

ParamTypestateAttr *ParamTypestateAttr::clone(ASTContext &C) const {
  auto *A = new (C) ParamTypestateAttr(getLocation(), C, paramState, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ParamTypestateAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((param_typestate(\"" << ParamTypestateAttr::ConvertConsumedStateToStr(getParamState()) << "\")))";
    break;
  }
}
}

const char *ParamTypestateAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "param_typestate";
  }
}

PascalAttr *PascalAttr::clone(ASTContext &C) const {
  auto *A = new (C) PascalAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void PascalAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((pascal))";
    break;
  }
  case 1 : {
    OS << " __pascal";
    break;
  }
  case 2 : {
    OS << " _pascal";
    break;
  }
}
}

const char *PascalAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "pascal";
  case 1:
    return "__pascal";
  case 2:
    return "_pascal";
  }
}

PcsAttr *PcsAttr::clone(ASTContext &C) const {
  auto *A = new (C) PcsAttr(getLocation(), C, pCS, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void PcsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((pcs(\"" << PcsAttr::ConvertPCSTypeToStr(getPCS()) << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::pcs(\"" << PcsAttr::ConvertPCSTypeToStr(getPCS()) << "\")]]";
    break;
  }
}
}

const char *PcsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "pcs";
  case 1:
    return "pcs";
  }
}

PtGuardedByAttr *PtGuardedByAttr::clone(ASTContext &C) const {
  auto *A = new (C) PtGuardedByAttr(getLocation(), C, arg, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void PtGuardedByAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((pt_guarded_by(" << getArg() << ")))";
    break;
  }
}
}

const char *PtGuardedByAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "pt_guarded_by";
  }
}

PtGuardedVarAttr *PtGuardedVarAttr::clone(ASTContext &C) const {
  auto *A = new (C) PtGuardedVarAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void PtGuardedVarAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((pt_guarded_var))";
    break;
  }
}
}

const char *PtGuardedVarAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "pt_guarded_var";
  }
}

PureAttr *PureAttr::clone(ASTContext &C) const {
  auto *A = new (C) PureAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void PureAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((pure))";
    break;
  }
  case 1 : {
    OS << " [[gnu::pure]]";
    break;
  }
}
}

const char *PureAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "pure";
  case 1:
    return "pure";
  }
}

ReleaseCapabilityAttr *ReleaseCapabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) ReleaseCapabilityAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ReleaseCapabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((release_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[clang::release_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((release_shared_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 3 : {
    OS << " [[clang::release_shared_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 4 : {
    OS << " __attribute__((release_generic_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 5 : {
    OS << " [[clang::release_generic_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 6 : {
    OS << " __attribute__((unlock_function(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *ReleaseCapabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "release_capability";
  case 1:
    return "release_capability";
  case 2:
    return "release_shared_capability";
  case 3:
    return "release_shared_capability";
  case 4:
    return "release_generic_capability";
  case 5:
    return "release_generic_capability";
  case 6:
    return "unlock_function";
  }
}

ReqdWorkGroupSizeAttr *ReqdWorkGroupSizeAttr::clone(ASTContext &C) const {
  auto *A = new (C) ReqdWorkGroupSizeAttr(getLocation(), C, xDim, yDim, zDim, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ReqdWorkGroupSizeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((reqd_work_group_size(" << getXDim() << ", " << getYDim() << ", " << getZDim() << ")))";
    break;
  }
}
}

const char *ReqdWorkGroupSizeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "reqd_work_group_size";
  }
}

RequiresCapabilityAttr *RequiresCapabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) RequiresCapabilityAttr(getLocation(), C, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void RequiresCapabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((requires_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[clang::requires_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((exclusive_locks_required(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 3 : {
    OS << " __attribute__((requires_shared_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 4 : {
    OS << " [[clang::requires_shared_capability(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 5 : {
    OS << " __attribute__((shared_locks_required(";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *RequiresCapabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "requires_capability";
  case 1:
    return "requires_capability";
  case 2:
    return "exclusive_locks_required";
  case 3:
    return "requires_shared_capability";
  case 4:
    return "requires_shared_capability";
  case 5:
    return "shared_locks_required";
  }
}

RestrictAttr *RestrictAttr::clone(ASTContext &C) const {
  auto *A = new (C) RestrictAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void RestrictAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(restrict)";
    break;
  }
  case 1 : {
    OS << " __attribute__((malloc))";
    break;
  }
  case 2 : {
    OS << " [[gnu::malloc]]";
    break;
  }
}
}

const char *RestrictAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "restrict";
  case 1:
    return "malloc";
  case 2:
    return "malloc";
  }
}

ReturnTypestateAttr *ReturnTypestateAttr::clone(ASTContext &C) const {
  auto *A = new (C) ReturnTypestateAttr(getLocation(), C, state, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ReturnTypestateAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((return_typestate(\"" << ReturnTypestateAttr::ConvertConsumedStateToStr(getState()) << "\")))";
    break;
  }
}
}

const char *ReturnTypestateAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "return_typestate";
  }
}

ReturnsNonNullAttr *ReturnsNonNullAttr::clone(ASTContext &C) const {
  auto *A = new (C) ReturnsNonNullAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ReturnsNonNullAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((returns_nonnull))";
    break;
  }
  case 1 : {
    OS << " [[gnu::returns_nonnull]]";
    break;
  }
}
}

const char *ReturnsNonNullAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "returns_nonnull";
  case 1:
    return "returns_nonnull";
  }
}

ReturnsTwiceAttr *ReturnsTwiceAttr::clone(ASTContext &C) const {
  auto *A = new (C) ReturnsTwiceAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ReturnsTwiceAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((returns_twice))";
    break;
  }
  case 1 : {
    OS << " [[gnu::returns_twice]]";
    break;
  }
}
}

const char *ReturnsTwiceAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "returns_twice";
  case 1:
    return "returns_twice";
  }
}

ScopedLockableAttr *ScopedLockableAttr::clone(ASTContext &C) const {
  auto *A = new (C) ScopedLockableAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ScopedLockableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((scoped_lockable))";
    break;
  }
}
}

const char *ScopedLockableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "scoped_lockable";
  }
}

SectionAttr *SectionAttr::clone(ASTContext &C) const {
  auto *A = new (C) SectionAttr(getLocation(), C, getName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void SectionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((section(\"" << getName() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::section(\"" << getName() << "\")]]";
    break;
  }
  case 2 : {
    OS << " __declspec(allocate(\"" << getName() << "\"))";
    break;
  }
}
}

const char *SectionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "section";
  case 1:
    return "section";
  case 2:
    return "allocate";
  }
}

SelectAnyAttr *SelectAnyAttr::clone(ASTContext &C) const {
  auto *A = new (C) SelectAnyAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void SelectAnyAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(selectany)";
    break;
  }
}
}

const char *SelectAnyAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "selectany";
  }
}

SentinelAttr *SentinelAttr::clone(ASTContext &C) const {
  auto *A = new (C) SentinelAttr(getLocation(), C, sentinel, nullPos, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void SentinelAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((sentinel(" << getSentinel() << ", " << getNullPos() << ")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::sentinel(" << getSentinel() << ", " << getNullPos() << ")]]";
    break;
  }
}
}

const char *SentinelAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "sentinel";
  case 1:
    return "sentinel";
  }
}

SetTypestateAttr *SetTypestateAttr::clone(ASTContext &C) const {
  auto *A = new (C) SetTypestateAttr(getLocation(), C, newState, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void SetTypestateAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((set_typestate(\"" << SetTypestateAttr::ConvertConsumedStateToStr(getNewState()) << "\")))";
    break;
  }
}
}

const char *SetTypestateAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "set_typestate";
  }
}

SharedTrylockFunctionAttr *SharedTrylockFunctionAttr::clone(ASTContext &C) const {
  auto *A = new (C) SharedTrylockFunctionAttr(getLocation(), C, successValue, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void SharedTrylockFunctionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((shared_trylock_function(" << getSuccessValue() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
}
}

const char *SharedTrylockFunctionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "shared_trylock_function";
  }
}

StdCallAttr *StdCallAttr::clone(ASTContext &C) const {
  auto *A = new (C) StdCallAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void StdCallAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((stdcall))";
    break;
  }
  case 1 : {
    OS << " [[gnu::stdcall]]";
    break;
  }
  case 2 : {
    OS << " __stdcall";
    break;
  }
  case 3 : {
    OS << " _stdcall";
    break;
  }
}
}

const char *StdCallAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stdcall";
  case 1:
    return "stdcall";
  case 2:
    return "__stdcall";
  case 3:
    return "_stdcall";
  }
}

SysVABIAttr *SysVABIAttr::clone(ASTContext &C) const {
  auto *A = new (C) SysVABIAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void SysVABIAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((sysv_abi))";
    break;
  }
  case 1 : {
    OS << " [[gnu::sysv_abi]]";
    break;
  }
}
}

const char *SysVABIAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "sysv_abi";
  case 1:
    return "sysv_abi";
  }
}

TLSModelAttr *TLSModelAttr::clone(ASTContext &C) const {
  auto *A = new (C) TLSModelAttr(getLocation(), C, getModel(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TLSModelAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((tls_model(\"" << getModel() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::tls_model(\"" << getModel() << "\")]]";
    break;
  }
}
}

const char *TLSModelAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "tls_model";
  case 1:
    return "tls_model";
  }
}

TargetAttr *TargetAttr::clone(ASTContext &C) const {
  auto *A = new (C) TargetAttr(getLocation(), C, getFeatures(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TargetAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((target(\"" << getFeatures() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::target(\"" << getFeatures() << "\")]]";
    break;
  }
}
}

const char *TargetAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "target";
  case 1:
    return "target";
  }
}

TestTypestateAttr *TestTypestateAttr::clone(ASTContext &C) const {
  auto *A = new (C) TestTypestateAttr(getLocation(), C, testState, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TestTypestateAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((test_typestate(\"" << TestTypestateAttr::ConvertConsumedStateToStr(getTestState()) << "\")))";
    break;
  }
}
}

const char *TestTypestateAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "test_typestate";
  }
}

ThisCallAttr *ThisCallAttr::clone(ASTContext &C) const {
  auto *A = new (C) ThisCallAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ThisCallAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((thiscall))";
    break;
  }
  case 1 : {
    OS << " [[gnu::thiscall]]";
    break;
  }
  case 2 : {
    OS << " __thiscall";
    break;
  }
  case 3 : {
    OS << " _thiscall";
    break;
  }
}
}

const char *ThisCallAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "thiscall";
  case 1:
    return "thiscall";
  case 2:
    return "__thiscall";
  case 3:
    return "_thiscall";
  }
}

ThreadAttr *ThreadAttr::clone(ASTContext &C) const {
  auto *A = new (C) ThreadAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void ThreadAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(thread)";
    break;
  }
}
}

const char *ThreadAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "thread";
  }
}

TransparentUnionAttr *TransparentUnionAttr::clone(ASTContext &C) const {
  auto *A = new (C) TransparentUnionAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TransparentUnionAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((transparent_union))";
    break;
  }
  case 1 : {
    OS << " [[gnu::transparent_union]]";
    break;
  }
}
}

const char *TransparentUnionAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "transparent_union";
  case 1:
    return "transparent_union";
  }
}

TryAcquireCapabilityAttr *TryAcquireCapabilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) TryAcquireCapabilityAttr(getLocation(), C, successValue, args_, args_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TryAcquireCapabilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((try_acquire_capability(" << getSuccessValue() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 1 : {
    OS << " [[clang::try_acquire_capability(" << getSuccessValue() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
  case 2 : {
    OS << " __attribute__((try_acquire_shared_capability(" << getSuccessValue() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")))";
    break;
  }
  case 3 : {
    OS << " [[clang::try_acquire_shared_capability(" << getSuccessValue() << ", ";
  bool isFirst = true;
  for (const auto &Val : args()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
}
}

const char *TryAcquireCapabilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "try_acquire_capability";
  case 1:
    return "try_acquire_capability";
  case 2:
    return "try_acquire_shared_capability";
  case 3:
    return "try_acquire_shared_capability";
  }
}

TypeTagForDatatypeAttr *TypeTagForDatatypeAttr::clone(ASTContext &C) const {
  auto *A = new (C) TypeTagForDatatypeAttr(getLocation(), C, argumentKind, matchingCType, layoutCompatible, mustBeNull, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TypeTagForDatatypeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((type_tag_for_datatype(" << getArgumentKind()->getName() << ", " << getMatchingCType().getAsString() << ", " << getLayoutCompatible() << ", " << getMustBeNull() << ")))";
    break;
  }
}
}

const char *TypeTagForDatatypeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "type_tag_for_datatype";
  }
}

TypeVisibilityAttr *TypeVisibilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) TypeVisibilityAttr(getLocation(), C, visibility, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void TypeVisibilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((type_visibility(\"" << TypeVisibilityAttr::ConvertVisibilityTypeToStr(getVisibility()) << "\")))";
    break;
  }
  case 1 : {
    OS << " [[clang::type_visibility(\"" << TypeVisibilityAttr::ConvertVisibilityTypeToStr(getVisibility()) << "\")]]";
    break;
  }
}
}

const char *TypeVisibilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "type_visibility";
  case 1:
    return "type_visibility";
  }
}

UnavailableAttr *UnavailableAttr::clone(ASTContext &C) const {
  auto *A = new (C) UnavailableAttr(getLocation(), C, getMessage(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void UnavailableAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((unavailable(\"" << getMessage() << "\")))";
    break;
  }
}
}

const char *UnavailableAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "unavailable";
  }
}

UnusedAttr *UnusedAttr::clone(ASTContext &C) const {
  auto *A = new (C) UnusedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void UnusedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((unused))";
    break;
  }
  case 1 : {
    OS << " [[gnu::unused]]";
    break;
  }
}
}

const char *UnusedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "unused";
  case 1:
    return "unused";
  }
}

UsedAttr *UsedAttr::clone(ASTContext &C) const {
  auto *A = new (C) UsedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void UsedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((used))";
    break;
  }
  case 1 : {
    OS << " [[gnu::used]]";
    break;
  }
}
}

const char *UsedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "used";
  case 1:
    return "used";
  }
}

UuidAttr *UuidAttr::clone(ASTContext &C) const {
  auto *A = new (C) UuidAttr(getLocation(), C, getGuid(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void UuidAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __declspec(uuid(\"" << getGuid() << "\"))";
    break;
  }
}
}

const char *UuidAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "uuid";
  }
}

VKAliasedPointerAttr *VKAliasedPointerAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKAliasedPointerAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKAliasedPointerAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::aliased_pointer]]";
    break;
  }
}
}

const char *VKAliasedPointerAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "aliased_pointer";
  }
}

VKBindingAttr *VKBindingAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKBindingAttr(getLocation(), C, binding, set, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKBindingAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::binding(" << getBinding() << ", " << getSet() << ")]]";
    break;
  }
}
}

const char *VKBindingAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "binding";
  }
}

VKBufferPointerAttr *VKBufferPointerAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKBufferPointerAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKBufferPointerAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[hlsl_vk_buffer_pointer]]";
    break;
  }
}
}

const char *VKBufferPointerAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "hlsl_vk_buffer_pointer";
  }
}

VKBuiltInAttr *VKBuiltInAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKBuiltInAttr(getLocation(), C, getBuiltIn(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKBuiltInAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::builtin(\"" << getBuiltIn() << "\")]]";
    break;
  }
}
}

const char *VKBuiltInAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "builtin";
  }
}

VKCapabilityExtAttr *VKCapabilityExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKCapabilityExtAttr(getLocation(), C, capability, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKCapabilityExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_capability(" << getCapability() << ")]]";
    break;
  }
}
}

const char *VKCapabilityExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_capability";
  }
}

VKCombinedImageSamplerAttr *VKCombinedImageSamplerAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKCombinedImageSamplerAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKCombinedImageSamplerAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::combinedImageSampler]]";
    break;
  }
}
}

const char *VKCombinedImageSamplerAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "combinedImageSampler";
  }
}

VKConstantIdAttr *VKConstantIdAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKConstantIdAttr(getLocation(), C, specConstId, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKConstantIdAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::constant_id(" << getSpecConstId() << ")]]";
    break;
  }
}
}

const char *VKConstantIdAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "constant_id";
  }
}

VKCounterBindingAttr *VKCounterBindingAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKCounterBindingAttr(getLocation(), C, binding, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKCounterBindingAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::counter_binding(" << getBinding() << ")]]";
    break;
  }
}
}

const char *VKCounterBindingAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "counter_binding";
  }
}

VKDecorateExtAttr *VKDecorateExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKDecorateExtAttr(getLocation(), C, decorate, literals_, literals_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKDecorateExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_decorate(" << getDecorate() << ", ";
  bool isFirst = true;
  for (const auto &Val : literals()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
}
}

const char *VKDecorateExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_decorate";
  }
}

VKDecorateIdExtAttr *VKDecorateIdExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKDecorateIdExtAttr(getLocation(), C, decorate, arguments_, arguments_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKDecorateIdExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_decorate_id(" << getDecorate() << ", ";
  bool isFirst = true;
  for (const auto &Val : arguments()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << Val;
  }
  OS << ")]]";
    break;
  }
}
}

const char *VKDecorateIdExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_decorate_id";
  }
}

VKDecorateStringExtAttr *VKDecorateStringExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKDecorateStringExtAttr(getLocation(), C, decorate, arguments_, arguments_Size, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKDecorateStringExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_decorate_string(" << getDecorate() << ", ";
  bool isFirst = true;
  for (const auto &Val : arguments()) {
    if (isFirst) isFirst = false;
    else OS << ", ";
    OS << "\"" << Val << "\"";
  }
  OS << ")]]";
    break;
  }
}
}

const char *VKDecorateStringExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_decorate_string";
  }
}

VKDepthUnchangedAttr *VKDepthUnchangedAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKDepthUnchangedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKDepthUnchangedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::depth_unchanged]]";
    break;
  }
}
}

const char *VKDepthUnchangedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "depth_unchanged";
  }
}

VKEarlyAndLateTestsAttr *VKEarlyAndLateTestsAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKEarlyAndLateTestsAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKEarlyAndLateTestsAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::early_and_late_tests]]";
    break;
  }
}
}

const char *VKEarlyAndLateTestsAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "early_and_late_tests";
  }
}

VKExtBuiltinInputAttr *VKExtBuiltinInputAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKExtBuiltinInputAttr(getLocation(), C, builtInID, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKExtBuiltinInputAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_builtin_input(" << getBuiltInID() << ")]]";
    break;
  }
}
}

const char *VKExtBuiltinInputAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_builtin_input";
  }
}

VKExtBuiltinOutputAttr *VKExtBuiltinOutputAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKExtBuiltinOutputAttr(getLocation(), C, builtInID, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKExtBuiltinOutputAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_builtin_output(" << getBuiltInID() << ")]]";
    break;
  }
}
}

const char *VKExtBuiltinOutputAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_builtin_output";
  }
}

VKExtensionExtAttr *VKExtensionExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKExtensionExtAttr(getLocation(), C, getName(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKExtensionExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_extension(\"" << getName() << "\")]]";
    break;
  }
}
}

const char *VKExtensionExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_extension";
  }
}

VKImageFormatAttr *VKImageFormatAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKImageFormatAttr(getLocation(), C, imageFormat, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKImageFormatAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::image_format(\"" << VKImageFormatAttr::ConvertImageFormatTypeToStr(getImageFormat()) << "\")]]";
    break;
  }
}
}

const char *VKImageFormatAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "image_format";
  }
}

VKIndexAttr *VKIndexAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKIndexAttr(getLocation(), C, number, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKIndexAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::index(" << getNumber() << ")]]";
    break;
  }
}
}

const char *VKIndexAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "index";
  }
}

VKInputAttachmentIndexAttr *VKInputAttachmentIndexAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKInputAttachmentIndexAttr(getLocation(), C, index, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKInputAttachmentIndexAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::input_attachment_index(" << getIndex() << ")]]";
    break;
  }
}
}

const char *VKInputAttachmentIndexAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "input_attachment_index";
  }
}

VKInstructionExtAttr *VKInstructionExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKInstructionExtAttr(getLocation(), C, opcode, getInstruction_set(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKInstructionExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_instruction(" << getOpcode() << ", \"" << getInstruction_set() << "\")]]";
    break;
  }
}
}

const char *VKInstructionExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_instruction";
  }
}

VKLiteralExtAttr *VKLiteralExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKLiteralExtAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKLiteralExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_literal]]";
    break;
  }
}
}

const char *VKLiteralExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_literal";
  }
}

VKLocationAttr *VKLocationAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKLocationAttr(getLocation(), C, number, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKLocationAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::location(" << getNumber() << ")]]";
    break;
  }
}
}

const char *VKLocationAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "location";
  }
}

VKOffsetAttr *VKOffsetAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKOffsetAttr(getLocation(), C, offset, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKOffsetAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::offset(" << getOffset() << ")]]";
    break;
  }
}
}

const char *VKOffsetAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "offset";
  }
}

VKPostDepthCoverageAttr *VKPostDepthCoverageAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKPostDepthCoverageAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKPostDepthCoverageAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::post_depth_coverage]]";
    break;
  }
}
}

const char *VKPostDepthCoverageAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "post_depth_coverage";
  }
}

VKPushConstantAttr *VKPushConstantAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKPushConstantAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKPushConstantAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::push_constant]]";
    break;
  }
}
}

const char *VKPushConstantAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "push_constant";
  }
}

VKReferenceExtAttr *VKReferenceExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKReferenceExtAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKReferenceExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_reference]]";
    break;
  }
}
}

const char *VKReferenceExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_reference";
  }
}

VKShaderRecordEXTAttr *VKShaderRecordEXTAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKShaderRecordEXTAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKShaderRecordEXTAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::shader_record_ext]]";
    break;
  }
}
}

const char *VKShaderRecordEXTAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "shader_record_ext";
  }
}

VKShaderRecordNVAttr *VKShaderRecordNVAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKShaderRecordNVAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKShaderRecordNVAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::shader_record_nv]]";
    break;
  }
}
}

const char *VKShaderRecordNVAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "shader_record_nv";
  }
}

VKSpvExecutionModeAttr *VKSpvExecutionModeAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKSpvExecutionModeAttr(getLocation(), C, executionMode, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKSpvExecutionModeAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::spvexecutionmode(" << getExecutionMode() << ")]]";
    break;
  }
}
}

const char *VKSpvExecutionModeAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "spvexecutionmode";
  }
}

VKStencilRefGreaterEqualBackAttr *VKStencilRefGreaterEqualBackAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStencilRefGreaterEqualBackAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStencilRefGreaterEqualBackAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::stencil_ref_greater_equal_back]]";
    break;
  }
}
}

const char *VKStencilRefGreaterEqualBackAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stencil_ref_greater_equal_back";
  }
}

VKStencilRefGreaterEqualFrontAttr *VKStencilRefGreaterEqualFrontAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStencilRefGreaterEqualFrontAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStencilRefGreaterEqualFrontAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::stencil_ref_greater_equal_front]]";
    break;
  }
}
}

const char *VKStencilRefGreaterEqualFrontAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stencil_ref_greater_equal_front";
  }
}

VKStencilRefLessEqualBackAttr *VKStencilRefLessEqualBackAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStencilRefLessEqualBackAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStencilRefLessEqualBackAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::stencil_ref_less_equal_back]]";
    break;
  }
}
}

const char *VKStencilRefLessEqualBackAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stencil_ref_less_equal_back";
  }
}

VKStencilRefLessEqualFrontAttr *VKStencilRefLessEqualFrontAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStencilRefLessEqualFrontAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStencilRefLessEqualFrontAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::stencil_ref_less_equal_front]]";
    break;
  }
}
}

const char *VKStencilRefLessEqualFrontAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stencil_ref_less_equal_front";
  }
}

VKStencilRefUnchangedBackAttr *VKStencilRefUnchangedBackAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStencilRefUnchangedBackAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStencilRefUnchangedBackAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::stencil_ref_unchanged_back]]";
    break;
  }
}
}

const char *VKStencilRefUnchangedBackAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stencil_ref_unchanged_back";
  }
}

VKStencilRefUnchangedFrontAttr *VKStencilRefUnchangedFrontAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStencilRefUnchangedFrontAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStencilRefUnchangedFrontAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::stencil_ref_unchanged_front]]";
    break;
  }
}
}

const char *VKStencilRefUnchangedFrontAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "stencil_ref_unchanged_front";
  }
}

VKStorageClassExtAttr *VKStorageClassExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKStorageClassExtAttr(getLocation(), C, stclass, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKStorageClassExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_storage_class(" << getStclass() << ")]]";
    break;
  }
}
}

const char *VKStorageClassExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_storage_class";
  }
}

VKTypeDefExtAttr *VKTypeDefExtAttr::clone(ASTContext &C) const {
  auto *A = new (C) VKTypeDefExtAttr(getLocation(), C, id, opcode, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VKTypeDefExtAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " [[vk::ext_type_def(" << getId() << ", " << getOpcode() << ")]]";
    break;
  }
}
}

const char *VKTypeDefExtAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "ext_type_def";
  }
}

VecReturnAttr *VecReturnAttr::clone(ASTContext &C) const {
  auto *A = new (C) VecReturnAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VecReturnAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((vecreturn))";
    break;
  }
}
}

const char *VecReturnAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "vecreturn";
  }
}

VecTypeHintAttr *VecTypeHintAttr::clone(ASTContext &C) const {
  auto *A = new (C) VecTypeHintAttr(getLocation(), C, typeHint, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VecTypeHintAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((vec_type_hint(" << getTypeHint().getAsString() << ")))";
    break;
  }
}
}

const char *VecTypeHintAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "vec_type_hint";
  }
}

VectorCallAttr *VectorCallAttr::clone(ASTContext &C) const {
  auto *A = new (C) VectorCallAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VectorCallAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((vectorcall))";
    break;
  }
  case 1 : {
    OS << " __vectorcall";
    break;
  }
  case 2 : {
    OS << " _vectorcall";
    break;
  }
}
}

const char *VectorCallAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "vectorcall";
  case 1:
    return "__vectorcall";
  case 2:
    return "_vectorcall";
  }
}

VisibilityAttr *VisibilityAttr::clone(ASTContext &C) const {
  auto *A = new (C) VisibilityAttr(getLocation(), C, visibility, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void VisibilityAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((visibility(\"" << VisibilityAttr::ConvertVisibilityTypeToStr(getVisibility()) << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::visibility(\"" << VisibilityAttr::ConvertVisibilityTypeToStr(getVisibility()) << "\")]]";
    break;
  }
}
}

const char *VisibilityAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "visibility";
  case 1:
    return "visibility";
  }
}

WarnUnusedAttr *WarnUnusedAttr::clone(ASTContext &C) const {
  auto *A = new (C) WarnUnusedAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void WarnUnusedAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((warn_unused))";
    break;
  }
}
}

const char *WarnUnusedAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "warn_unused";
  }
}

WarnUnusedResultAttr *WarnUnusedResultAttr::clone(ASTContext &C) const {
  auto *A = new (C) WarnUnusedResultAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void WarnUnusedResultAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((warn_unused_result))";
    break;
  }
  case 1 : {
    OS << " [[gnu::warn_unused_result]]";
    break;
  }
  case 2 : {
    OS << " [[clang::warn_unused_result]]";
    break;
  }
}
}

const char *WarnUnusedResultAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "warn_unused_result";
  case 1:
    return "warn_unused_result";
  case 2:
    return "warn_unused_result";
  }
}

WeakAttr *WeakAttr::clone(ASTContext &C) const {
  auto *A = new (C) WeakAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void WeakAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((weak))";
    break;
  }
  case 1 : {
    OS << " [[gnu::weak]]";
    break;
  }
}
}

const char *WeakAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "weak";
  case 1:
    return "weak";
  }
}

WeakImportAttr *WeakImportAttr::clone(ASTContext &C) const {
  auto *A = new (C) WeakImportAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void WeakImportAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((weak_import))";
    break;
  }
}
}

const char *WeakImportAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "weak_import";
  }
}

WeakRefAttr *WeakRefAttr::clone(ASTContext &C) const {
  auto *A = new (C) WeakRefAttr(getLocation(), C, getAliasee(), getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void WeakRefAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((weakref(\"" << getAliasee() << "\")))";
    break;
  }
  case 1 : {
    OS << " [[gnu::weakref(\"" << getAliasee() << "\")]]";
    break;
  }
}
}

const char *WeakRefAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "weakref";
  case 1:
    return "weakref";
  }
}

WorkGroupSizeHintAttr *WorkGroupSizeHintAttr::clone(ASTContext &C) const {
  auto *A = new (C) WorkGroupSizeHintAttr(getLocation(), C, xDim, yDim, zDim, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void WorkGroupSizeHintAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((work_group_size_hint(" << getXDim() << ", " << getYDim() << ", " << getZDim() << ")))";
    break;
  }
}
}

const char *WorkGroupSizeHintAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "work_group_size_hint";
  }
}

X86ForceAlignArgPointerAttr *X86ForceAlignArgPointerAttr::clone(ASTContext &C) const {
  auto *A = new (C) X86ForceAlignArgPointerAttr(getLocation(), C, getSpellingListIndex());
  A->Inherited = Inherited;
  A->IsPackExpansion = IsPackExpansion;
  A->Implicit = Implicit;
  return A;
}

void X86ForceAlignArgPointerAttr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    break;
  case 0 : {
    OS << " __attribute__((force_align_arg_pointer))";
    break;
  }
}
}

const char *X86ForceAlignArgPointerAttr::getSpelling() const {
  switch (SpellingListIndex) {
  default:
    llvm_unreachable("Unknown attribute spelling!");
    return "(No spelling)";
  case 0:
    return "force_align_arg_pointer";
  }
}

const char *Attr::getSpelling() const {
  switch (getKind()) {
  case attr::AMDGPUNumSGPR:
    return cast<AMDGPUNumSGPRAttr>(this)->getSpelling();
  case attr::AMDGPUNumVGPR:
    return cast<AMDGPUNumVGPRAttr>(this)->getSpelling();
  case attr::ARMInterrupt:
    return cast<ARMInterruptAttr>(this)->getSpelling();
  case attr::AcquireCapability:
    return cast<AcquireCapabilityAttr>(this)->getSpelling();
  case attr::AcquiredAfter:
    return cast<AcquiredAfterAttr>(this)->getSpelling();
  case attr::AcquiredBefore:
    return cast<AcquiredBeforeAttr>(this)->getSpelling();
  case attr::Alias:
    return cast<AliasAttr>(this)->getSpelling();
  case attr::AlignMac68k:
    return cast<AlignMac68kAttr>(this)->getSpelling();
  case attr::AlignValue:
    return cast<AlignValueAttr>(this)->getSpelling();
  case attr::Aligned:
    return cast<AlignedAttr>(this)->getSpelling();
  case attr::AlwaysInline:
    return cast<AlwaysInlineAttr>(this)->getSpelling();
  case attr::AnalyzerNoReturn:
    return cast<AnalyzerNoReturnAttr>(this)->getSpelling();
  case attr::Annotate:
    return cast<AnnotateAttr>(this)->getSpelling();
  case attr::ArcWeakrefUnavailable:
    return cast<ArcWeakrefUnavailableAttr>(this)->getSpelling();
  case attr::ArgumentWithTypeTag:
    return cast<ArgumentWithTypeTagAttr>(this)->getSpelling();
  case attr::AsmLabel:
    return cast<AsmLabelAttr>(this)->getSpelling();
  case attr::AssertCapability:
    return cast<AssertCapabilityAttr>(this)->getSpelling();
  case attr::AssertExclusiveLock:
    return cast<AssertExclusiveLockAttr>(this)->getSpelling();
  case attr::AssertSharedLock:
    return cast<AssertSharedLockAttr>(this)->getSpelling();
  case attr::AssumeAligned:
    return cast<AssumeAlignedAttr>(this)->getSpelling();
  case attr::Availability:
    return cast<AvailabilityAttr>(this)->getSpelling();
  case attr::Blocks:
    return cast<BlocksAttr>(this)->getSpelling();
  case attr::C11NoReturn:
    return cast<C11NoReturnAttr>(this)->getSpelling();
  case attr::CDecl:
    return cast<CDeclAttr>(this)->getSpelling();
  case attr::CFAuditedTransfer:
    return cast<CFAuditedTransferAttr>(this)->getSpelling();
  case attr::CFConsumed:
    return cast<CFConsumedAttr>(this)->getSpelling();
  case attr::CFReturnsNotRetained:
    return cast<CFReturnsNotRetainedAttr>(this)->getSpelling();
  case attr::CFReturnsRetained:
    return cast<CFReturnsRetainedAttr>(this)->getSpelling();
  case attr::CFUnknownTransfer:
    return cast<CFUnknownTransferAttr>(this)->getSpelling();
  case attr::CUDAConstant:
    return cast<CUDAConstantAttr>(this)->getSpelling();
  case attr::CUDADevice:
    return cast<CUDADeviceAttr>(this)->getSpelling();
  case attr::CUDAGlobal:
    return cast<CUDAGlobalAttr>(this)->getSpelling();
  case attr::CUDAHost:
    return cast<CUDAHostAttr>(this)->getSpelling();
  case attr::CUDAInvalidTarget:
    return cast<CUDAInvalidTargetAttr>(this)->getSpelling();
  case attr::CUDALaunchBounds:
    return cast<CUDALaunchBoundsAttr>(this)->getSpelling();
  case attr::CUDAShared:
    return cast<CUDASharedAttr>(this)->getSpelling();
  case attr::CXX11NoReturn:
    return cast<CXX11NoReturnAttr>(this)->getSpelling();
  case attr::CallableWhen:
    return cast<CallableWhenAttr>(this)->getSpelling();
  case attr::Capability:
    return cast<CapabilityAttr>(this)->getSpelling();
  case attr::CapturedRecord:
    return cast<CapturedRecordAttr>(this)->getSpelling();
  case attr::CarriesDependency:
    return cast<CarriesDependencyAttr>(this)->getSpelling();
  case attr::Cleanup:
    return cast<CleanupAttr>(this)->getSpelling();
  case attr::Cold:
    return cast<ColdAttr>(this)->getSpelling();
  case attr::Common:
    return cast<CommonAttr>(this)->getSpelling();
  case attr::Const:
    return cast<ConstAttr>(this)->getSpelling();
  case attr::Constructor:
    return cast<ConstructorAttr>(this)->getSpelling();
  case attr::Consumable:
    return cast<ConsumableAttr>(this)->getSpelling();
  case attr::ConsumableAutoCast:
    return cast<ConsumableAutoCastAttr>(this)->getSpelling();
  case attr::ConsumableSetOnRead:
    return cast<ConsumableSetOnReadAttr>(this)->getSpelling();
  case attr::DLLExport:
    return cast<DLLExportAttr>(this)->getSpelling();
  case attr::DLLImport:
    return cast<DLLImportAttr>(this)->getSpelling();
  case attr::Deprecated:
    return cast<DeprecatedAttr>(this)->getSpelling();
  case attr::Destructor:
    return cast<DestructorAttr>(this)->getSpelling();
  case attr::EnableIf:
    return cast<EnableIfAttr>(this)->getSpelling();
  case attr::ExclusiveTrylockFunction:
    return cast<ExclusiveTrylockFunctionAttr>(this)->getSpelling();
  case attr::FallThrough:
    return cast<FallThroughAttr>(this)->getSpelling();
  case attr::FastCall:
    return cast<FastCallAttr>(this)->getSpelling();
  case attr::Final:
    return cast<FinalAttr>(this)->getSpelling();
  case attr::FlagEnum:
    return cast<FlagEnumAttr>(this)->getSpelling();
  case attr::Flatten:
    return cast<FlattenAttr>(this)->getSpelling();
  case attr::Format:
    return cast<FormatAttr>(this)->getSpelling();
  case attr::FormatArg:
    return cast<FormatArgAttr>(this)->getSpelling();
  case attr::GNUInline:
    return cast<GNUInlineAttr>(this)->getSpelling();
  case attr::GuardedBy:
    return cast<GuardedByAttr>(this)->getSpelling();
  case attr::GuardedVar:
    return cast<GuardedVarAttr>(this)->getSpelling();
  case attr::HLSLAllowSparseNodes:
    return cast<HLSLAllowSparseNodesAttr>(this)->getSpelling();
  case attr::HLSLAllowUAVCondition:
    return cast<HLSLAllowUAVConditionAttr>(this)->getSpelling();
  case attr::HLSLBranch:
    return cast<HLSLBranchAttr>(this)->getSpelling();
  case attr::HLSLCXXOverload:
    return cast<HLSLCXXOverloadAttr>(this)->getSpelling();
  case attr::HLSLCall:
    return cast<HLSLCallAttr>(this)->getSpelling();
  case attr::HLSLCenter:
    return cast<HLSLCenterAttr>(this)->getSpelling();
  case attr::HLSLCentroid:
    return cast<HLSLCentroidAttr>(this)->getSpelling();
  case attr::HLSLClipPlanes:
    return cast<HLSLClipPlanesAttr>(this)->getSpelling();
  case attr::HLSLDomain:
    return cast<HLSLDomainAttr>(this)->getSpelling();
  case attr::HLSLEarlyDepthStencil:
    return cast<HLSLEarlyDepthStencilAttr>(this)->getSpelling();
  case attr::HLSLExperimental:
    return cast<HLSLExperimentalAttr>(this)->getSpelling();
  case attr::HLSLExport:
    return cast<HLSLExportAttr>(this)->getSpelling();
  case attr::HLSLFastOpt:
    return cast<HLSLFastOptAttr>(this)->getSpelling();
  case attr::HLSLFlatten:
    return cast<HLSLFlattenAttr>(this)->getSpelling();
  case attr::HLSLForceCase:
    return cast<HLSLForceCaseAttr>(this)->getSpelling();
  case attr::HLSLGloballyCoherent:
    return cast<HLSLGloballyCoherentAttr>(this)->getSpelling();
  case attr::HLSLGroupShared:
    return cast<HLSLGroupSharedAttr>(this)->getSpelling();
  case attr::HLSLHitObject:
    return cast<HLSLHitObjectAttr>(this)->getSpelling();
  case attr::HLSLIn:
    return cast<HLSLInAttr>(this)->getSpelling();
  case attr::HLSLInOut:
    return cast<HLSLInOutAttr>(this)->getSpelling();
  case attr::HLSLIndices:
    return cast<HLSLIndicesAttr>(this)->getSpelling();
  case attr::HLSLInstance:
    return cast<HLSLInstanceAttr>(this)->getSpelling();
  case attr::HLSLIntrinsic:
    return cast<HLSLIntrinsicAttr>(this)->getSpelling();
  case attr::HLSLLine:
    return cast<HLSLLineAttr>(this)->getSpelling();
  case attr::HLSLLineAdj:
    return cast<HLSLLineAdjAttr>(this)->getSpelling();
  case attr::HLSLLinear:
    return cast<HLSLLinearAttr>(this)->getSpelling();
  case attr::HLSLLoop:
    return cast<HLSLLoopAttr>(this)->getSpelling();
  case attr::HLSLMatrix:
    return cast<HLSLMatrixAttr>(this)->getSpelling();
  case attr::HLSLMaxRecords:
    return cast<HLSLMaxRecordsAttr>(this)->getSpelling();
  case attr::HLSLMaxRecordsSharedWith:
    return cast<HLSLMaxRecordsSharedWithAttr>(this)->getSpelling();
  case attr::HLSLMaxTessFactor:
    return cast<HLSLMaxTessFactorAttr>(this)->getSpelling();
  case attr::HLSLMaxVertexCount:
    return cast<HLSLMaxVertexCountAttr>(this)->getSpelling();
  case attr::HLSLMaybeUnused:
    return cast<HLSLMaybeUnusedAttr>(this)->getSpelling();
  case attr::HLSLNoInterpolation:
    return cast<HLSLNoInterpolationAttr>(this)->getSpelling();
  case attr::HLSLNoPerspective:
    return cast<HLSLNoPerspectiveAttr>(this)->getSpelling();
  case attr::HLSLNodeArraySize:
    return cast<HLSLNodeArraySizeAttr>(this)->getSpelling();
  case attr::HLSLNodeDispatchGrid:
    return cast<HLSLNodeDispatchGridAttr>(this)->getSpelling();
  case attr::HLSLNodeId:
    return cast<HLSLNodeIdAttr>(this)->getSpelling();
  case attr::HLSLNodeIsProgramEntry:
    return cast<HLSLNodeIsProgramEntryAttr>(this)->getSpelling();
  case attr::HLSLNodeLaunch:
    return cast<HLSLNodeLaunchAttr>(this)->getSpelling();
  case attr::HLSLNodeLocalRootArgumentsTableIndex:
    return cast<HLSLNodeLocalRootArgumentsTableIndexAttr>(this)->getSpelling();
  case attr::HLSLNodeMaxDispatchGrid:
    return cast<HLSLNodeMaxDispatchGridAttr>(this)->getSpelling();
  case attr::HLSLNodeMaxRecursionDepth:
    return cast<HLSLNodeMaxRecursionDepthAttr>(this)->getSpelling();
  case attr::HLSLNodeObject:
    return cast<HLSLNodeObjectAttr>(this)->getSpelling();
  case attr::HLSLNodeShareInputOf:
    return cast<HLSLNodeShareInputOfAttr>(this)->getSpelling();
  case attr::HLSLNodeTrackRWInputSharing:
    return cast<HLSLNodeTrackRWInputSharingAttr>(this)->getSpelling();
  case attr::HLSLNumThreads:
    return cast<HLSLNumThreadsAttr>(this)->getSpelling();
  case attr::HLSLOut:
    return cast<HLSLOutAttr>(this)->getSpelling();
  case attr::HLSLOutputControlPoints:
    return cast<HLSLOutputControlPointsAttr>(this)->getSpelling();
  case attr::HLSLOutputTopology:
    return cast<HLSLOutputTopologyAttr>(this)->getSpelling();
  case attr::HLSLPartitioning:
    return cast<HLSLPartitioningAttr>(this)->getSpelling();
  case attr::HLSLPatchConstantFunc:
    return cast<HLSLPatchConstantFuncAttr>(this)->getSpelling();
  case attr::HLSLPayload:
    return cast<HLSLPayloadAttr>(this)->getSpelling();
  case attr::HLSLPoint:
    return cast<HLSLPointAttr>(this)->getSpelling();
  case attr::HLSLPrecise:
    return cast<HLSLPreciseAttr>(this)->getSpelling();
  case attr::HLSLPrimitives:
    return cast<HLSLPrimitivesAttr>(this)->getSpelling();
  case attr::HLSLRayPayload:
    return cast<HLSLRayPayloadAttr>(this)->getSpelling();
  case attr::HLSLRayQueryObject:
    return cast<HLSLRayQueryObjectAttr>(this)->getSpelling();
  case attr::HLSLReorderCoherent:
    return cast<HLSLReorderCoherentAttr>(this)->getSpelling();
  case attr::HLSLResource:
    return cast<HLSLResourceAttr>(this)->getSpelling();
  case attr::HLSLRootSignature:
    return cast<HLSLRootSignatureAttr>(this)->getSpelling();
  case attr::HLSLSample:
    return cast<HLSLSampleAttr>(this)->getSpelling();
  case attr::HLSLSemantic:
    return cast<HLSLSemanticAttr>(this)->getSpelling();
  case attr::HLSLShader:
    return cast<HLSLShaderAttr>(this)->getSpelling();
  case attr::HLSLShared:
    return cast<HLSLSharedAttr>(this)->getSpelling();
  case attr::HLSLSnorm:
    return cast<HLSLSnormAttr>(this)->getSpelling();
  case attr::HLSLStreamOutput:
    return cast<HLSLStreamOutputAttr>(this)->getSpelling();
  case attr::HLSLSubObject:
    return cast<HLSLSubObjectAttr>(this)->getSpelling();
  case attr::HLSLTessPatch:
    return cast<HLSLTessPatchAttr>(this)->getSpelling();
  case attr::HLSLTriangle:
    return cast<HLSLTriangleAttr>(this)->getSpelling();
  case attr::HLSLTriangleAdj:
    return cast<HLSLTriangleAdjAttr>(this)->getSpelling();
  case attr::HLSLUnboundedSparseNodes:
    return cast<HLSLUnboundedSparseNodesAttr>(this)->getSpelling();
  case attr::HLSLUniform:
    return cast<HLSLUniformAttr>(this)->getSpelling();
  case attr::HLSLUnorm:
    return cast<HLSLUnormAttr>(this)->getSpelling();
  case attr::HLSLUnroll:
    return cast<HLSLUnrollAttr>(this)->getSpelling();
  case attr::HLSLVector:
    return cast<HLSLVectorAttr>(this)->getSpelling();
  case attr::HLSLVertices:
    return cast<HLSLVerticesAttr>(this)->getSpelling();
  case attr::HLSLWaveOpsIncludeHelperLanes:
    return cast<HLSLWaveOpsIncludeHelperLanesAttr>(this)->getSpelling();
  case attr::HLSLWaveSensitive:
    return cast<HLSLWaveSensitiveAttr>(this)->getSpelling();
  case attr::HLSLWaveSize:
    return cast<HLSLWaveSizeAttr>(this)->getSpelling();
  case attr::Hot:
    return cast<HotAttr>(this)->getSpelling();
  case attr::IBAction:
    return cast<IBActionAttr>(this)->getSpelling();
  case attr::IBOutlet:
    return cast<IBOutletAttr>(this)->getSpelling();
  case attr::IBOutletCollection:
    return cast<IBOutletCollectionAttr>(this)->getSpelling();
  case attr::InitPriority:
    return cast<InitPriorityAttr>(this)->getSpelling();
  case attr::InitSeg:
    return cast<InitSegAttr>(this)->getSpelling();
  case attr::IntelOclBicc:
    return cast<IntelOclBiccAttr>(this)->getSpelling();
  case attr::LockReturned:
    return cast<LockReturnedAttr>(this)->getSpelling();
  case attr::LocksExcluded:
    return cast<LocksExcludedAttr>(this)->getSpelling();
  case attr::LoopHint:
    return cast<LoopHintAttr>(this)->getSpelling();
  case attr::MSABI:
    return cast<MSABIAttr>(this)->getSpelling();
  case attr::MSInheritance:
    return cast<MSInheritanceAttr>(this)->getSpelling();
  case attr::MSNoVTable:
    return cast<MSNoVTableAttr>(this)->getSpelling();
  case attr::MSP430Interrupt:
    return cast<MSP430InterruptAttr>(this)->getSpelling();
  case attr::MSStruct:
    return cast<MSStructAttr>(this)->getSpelling();
  case attr::MSVtorDisp:
    return cast<MSVtorDispAttr>(this)->getSpelling();
  case attr::MaxFieldAlignment:
    return cast<MaxFieldAlignmentAttr>(this)->getSpelling();
  case attr::MayAlias:
    return cast<MayAliasAttr>(this)->getSpelling();
  case attr::MinSize:
    return cast<MinSizeAttr>(this)->getSpelling();
  case attr::Mips16:
    return cast<Mips16Attr>(this)->getSpelling();
  case attr::Mode:
    return cast<ModeAttr>(this)->getSpelling();
  case attr::NSConsumed:
    return cast<NSConsumedAttr>(this)->getSpelling();
  case attr::NSConsumesSelf:
    return cast<NSConsumesSelfAttr>(this)->getSpelling();
  case attr::NSReturnsAutoreleased:
    return cast<NSReturnsAutoreleasedAttr>(this)->getSpelling();
  case attr::NSReturnsNotRetained:
    return cast<NSReturnsNotRetainedAttr>(this)->getSpelling();
  case attr::NSReturnsRetained:
    return cast<NSReturnsRetainedAttr>(this)->getSpelling();
  case attr::Naked:
    return cast<NakedAttr>(this)->getSpelling();
  case attr::NoCommon:
    return cast<NoCommonAttr>(this)->getSpelling();
  case attr::NoDebug:
    return cast<NoDebugAttr>(this)->getSpelling();
  case attr::NoDuplicate:
    return cast<NoDuplicateAttr>(this)->getSpelling();
  case attr::NoInline:
    return cast<NoInlineAttr>(this)->getSpelling();
  case attr::NoInstrumentFunction:
    return cast<NoInstrumentFunctionAttr>(this)->getSpelling();
  case attr::NoMips16:
    return cast<NoMips16Attr>(this)->getSpelling();
  case attr::NoReturn:
    return cast<NoReturnAttr>(this)->getSpelling();
  case attr::NoSanitize:
    return cast<NoSanitizeAttr>(this)->getSpelling();
  case attr::NoSplitStack:
    return cast<NoSplitStackAttr>(this)->getSpelling();
  case attr::NoThreadSafetyAnalysis:
    return cast<NoThreadSafetyAnalysisAttr>(this)->getSpelling();
  case attr::NoThrow:
    return cast<NoThrowAttr>(this)->getSpelling();
  case attr::NonNull:
    return cast<NonNullAttr>(this)->getSpelling();
  case attr::OMPThreadPrivateDecl:
    return cast<OMPThreadPrivateDeclAttr>(this)->getSpelling();
  case attr::ObjCBoxable:
    return cast<ObjCBoxableAttr>(this)->getSpelling();
  case attr::ObjCBridge:
    return cast<ObjCBridgeAttr>(this)->getSpelling();
  case attr::ObjCBridgeMutable:
    return cast<ObjCBridgeMutableAttr>(this)->getSpelling();
  case attr::ObjCBridgeRelated:
    return cast<ObjCBridgeRelatedAttr>(this)->getSpelling();
  case attr::ObjCDesignatedInitializer:
    return cast<ObjCDesignatedInitializerAttr>(this)->getSpelling();
  case attr::ObjCException:
    return cast<ObjCExceptionAttr>(this)->getSpelling();
  case attr::ObjCExplicitProtocolImpl:
    return cast<ObjCExplicitProtocolImplAttr>(this)->getSpelling();
  case attr::ObjCIndependentClass:
    return cast<ObjCIndependentClassAttr>(this)->getSpelling();
  case attr::ObjCMethodFamily:
    return cast<ObjCMethodFamilyAttr>(this)->getSpelling();
  case attr::ObjCNSObject:
    return cast<ObjCNSObjectAttr>(this)->getSpelling();
  case attr::ObjCPreciseLifetime:
    return cast<ObjCPreciseLifetimeAttr>(this)->getSpelling();
  case attr::ObjCRequiresPropertyDefs:
    return cast<ObjCRequiresPropertyDefsAttr>(this)->getSpelling();
  case attr::ObjCRequiresSuper:
    return cast<ObjCRequiresSuperAttr>(this)->getSpelling();
  case attr::ObjCReturnsInnerPointer:
    return cast<ObjCReturnsInnerPointerAttr>(this)->getSpelling();
  case attr::ObjCRootClass:
    return cast<ObjCRootClassAttr>(this)->getSpelling();
  case attr::ObjCRuntimeName:
    return cast<ObjCRuntimeNameAttr>(this)->getSpelling();
  case attr::OpenCLImageAccess:
    return cast<OpenCLImageAccessAttr>(this)->getSpelling();
  case attr::OpenCLKernel:
    return cast<OpenCLKernelAttr>(this)->getSpelling();
  case attr::OptimizeNone:
    return cast<OptimizeNoneAttr>(this)->getSpelling();
  case attr::Overloadable:
    return cast<OverloadableAttr>(this)->getSpelling();
  case attr::Override:
    return cast<OverrideAttr>(this)->getSpelling();
  case attr::Ownership:
    return cast<OwnershipAttr>(this)->getSpelling();
  case attr::Packed:
    return cast<PackedAttr>(this)->getSpelling();
  case attr::ParamTypestate:
    return cast<ParamTypestateAttr>(this)->getSpelling();
  case attr::Pascal:
    return cast<PascalAttr>(this)->getSpelling();
  case attr::Pcs:
    return cast<PcsAttr>(this)->getSpelling();
  case attr::PtGuardedBy:
    return cast<PtGuardedByAttr>(this)->getSpelling();
  case attr::PtGuardedVar:
    return cast<PtGuardedVarAttr>(this)->getSpelling();
  case attr::Pure:
    return cast<PureAttr>(this)->getSpelling();
  case attr::ReleaseCapability:
    return cast<ReleaseCapabilityAttr>(this)->getSpelling();
  case attr::ReqdWorkGroupSize:
    return cast<ReqdWorkGroupSizeAttr>(this)->getSpelling();
  case attr::RequiresCapability:
    return cast<RequiresCapabilityAttr>(this)->getSpelling();
  case attr::Restrict:
    return cast<RestrictAttr>(this)->getSpelling();
  case attr::ReturnTypestate:
    return cast<ReturnTypestateAttr>(this)->getSpelling();
  case attr::ReturnsNonNull:
    return cast<ReturnsNonNullAttr>(this)->getSpelling();
  case attr::ReturnsTwice:
    return cast<ReturnsTwiceAttr>(this)->getSpelling();
  case attr::ScopedLockable:
    return cast<ScopedLockableAttr>(this)->getSpelling();
  case attr::Section:
    return cast<SectionAttr>(this)->getSpelling();
  case attr::SelectAny:
    return cast<SelectAnyAttr>(this)->getSpelling();
  case attr::Sentinel:
    return cast<SentinelAttr>(this)->getSpelling();
  case attr::SetTypestate:
    return cast<SetTypestateAttr>(this)->getSpelling();
  case attr::SharedTrylockFunction:
    return cast<SharedTrylockFunctionAttr>(this)->getSpelling();
  case attr::StdCall:
    return cast<StdCallAttr>(this)->getSpelling();
  case attr::SysVABI:
    return cast<SysVABIAttr>(this)->getSpelling();
  case attr::TLSModel:
    return cast<TLSModelAttr>(this)->getSpelling();
  case attr::Target:
    return cast<TargetAttr>(this)->getSpelling();
  case attr::TestTypestate:
    return cast<TestTypestateAttr>(this)->getSpelling();
  case attr::ThisCall:
    return cast<ThisCallAttr>(this)->getSpelling();
  case attr::Thread:
    return cast<ThreadAttr>(this)->getSpelling();
  case attr::TransparentUnion:
    return cast<TransparentUnionAttr>(this)->getSpelling();
  case attr::TryAcquireCapability:
    return cast<TryAcquireCapabilityAttr>(this)->getSpelling();
  case attr::TypeTagForDatatype:
    return cast<TypeTagForDatatypeAttr>(this)->getSpelling();
  case attr::TypeVisibility:
    return cast<TypeVisibilityAttr>(this)->getSpelling();
  case attr::Unavailable:
    return cast<UnavailableAttr>(this)->getSpelling();
  case attr::Unused:
    return cast<UnusedAttr>(this)->getSpelling();
  case attr::Used:
    return cast<UsedAttr>(this)->getSpelling();
  case attr::Uuid:
    return cast<UuidAttr>(this)->getSpelling();
  case attr::VKAliasedPointer:
    return cast<VKAliasedPointerAttr>(this)->getSpelling();
  case attr::VKBinding:
    return cast<VKBindingAttr>(this)->getSpelling();
  case attr::VKBufferPointer:
    return cast<VKBufferPointerAttr>(this)->getSpelling();
  case attr::VKBuiltIn:
    return cast<VKBuiltInAttr>(this)->getSpelling();
  case attr::VKCapabilityExt:
    return cast<VKCapabilityExtAttr>(this)->getSpelling();
  case attr::VKCombinedImageSampler:
    return cast<VKCombinedImageSamplerAttr>(this)->getSpelling();
  case attr::VKConstantId:
    return cast<VKConstantIdAttr>(this)->getSpelling();
  case attr::VKCounterBinding:
    return cast<VKCounterBindingAttr>(this)->getSpelling();
  case attr::VKDecorateExt:
    return cast<VKDecorateExtAttr>(this)->getSpelling();
  case attr::VKDecorateIdExt:
    return cast<VKDecorateIdExtAttr>(this)->getSpelling();
  case attr::VKDecorateStringExt:
    return cast<VKDecorateStringExtAttr>(this)->getSpelling();
  case attr::VKDepthUnchanged:
    return cast<VKDepthUnchangedAttr>(this)->getSpelling();
  case attr::VKEarlyAndLateTests:
    return cast<VKEarlyAndLateTestsAttr>(this)->getSpelling();
  case attr::VKExtBuiltinInput:
    return cast<VKExtBuiltinInputAttr>(this)->getSpelling();
  case attr::VKExtBuiltinOutput:
    return cast<VKExtBuiltinOutputAttr>(this)->getSpelling();
  case attr::VKExtensionExt:
    return cast<VKExtensionExtAttr>(this)->getSpelling();
  case attr::VKImageFormat:
    return cast<VKImageFormatAttr>(this)->getSpelling();
  case attr::VKIndex:
    return cast<VKIndexAttr>(this)->getSpelling();
  case attr::VKInputAttachmentIndex:
    return cast<VKInputAttachmentIndexAttr>(this)->getSpelling();
  case attr::VKInstructionExt:
    return cast<VKInstructionExtAttr>(this)->getSpelling();
  case attr::VKLiteralExt:
    return cast<VKLiteralExtAttr>(this)->getSpelling();
  case attr::VKLocation:
    return cast<VKLocationAttr>(this)->getSpelling();
  case attr::VKOffset:
    return cast<VKOffsetAttr>(this)->getSpelling();
  case attr::VKPostDepthCoverage:
    return cast<VKPostDepthCoverageAttr>(this)->getSpelling();
  case attr::VKPushConstant:
    return cast<VKPushConstantAttr>(this)->getSpelling();
  case attr::VKReferenceExt:
    return cast<VKReferenceExtAttr>(this)->getSpelling();
  case attr::VKShaderRecordEXT:
    return cast<VKShaderRecordEXTAttr>(this)->getSpelling();
  case attr::VKShaderRecordNV:
    return cast<VKShaderRecordNVAttr>(this)->getSpelling();
  case attr::VKSpvExecutionMode:
    return cast<VKSpvExecutionModeAttr>(this)->getSpelling();
  case attr::VKStencilRefGreaterEqualBack:
    return cast<VKStencilRefGreaterEqualBackAttr>(this)->getSpelling();
  case attr::VKStencilRefGreaterEqualFront:
    return cast<VKStencilRefGreaterEqualFrontAttr>(this)->getSpelling();
  case attr::VKStencilRefLessEqualBack:
    return cast<VKStencilRefLessEqualBackAttr>(this)->getSpelling();
  case attr::VKStencilRefLessEqualFront:
    return cast<VKStencilRefLessEqualFrontAttr>(this)->getSpelling();
  case attr::VKStencilRefUnchangedBack:
    return cast<VKStencilRefUnchangedBackAttr>(this)->getSpelling();
  case attr::VKStencilRefUnchangedFront:
    return cast<VKStencilRefUnchangedFrontAttr>(this)->getSpelling();
  case attr::VKStorageClassExt:
    return cast<VKStorageClassExtAttr>(this)->getSpelling();
  case attr::VKTypeDefExt:
    return cast<VKTypeDefExtAttr>(this)->getSpelling();
  case attr::VecReturn:
    return cast<VecReturnAttr>(this)->getSpelling();
  case attr::VecTypeHint:
    return cast<VecTypeHintAttr>(this)->getSpelling();
  case attr::VectorCall:
    return cast<VectorCallAttr>(this)->getSpelling();
  case attr::Visibility:
    return cast<VisibilityAttr>(this)->getSpelling();
  case attr::WarnUnused:
    return cast<WarnUnusedAttr>(this)->getSpelling();
  case attr::WarnUnusedResult:
    return cast<WarnUnusedResultAttr>(this)->getSpelling();
  case attr::Weak:
    return cast<WeakAttr>(this)->getSpelling();
  case attr::WeakImport:
    return cast<WeakImportAttr>(this)->getSpelling();
  case attr::WeakRef:
    return cast<WeakRefAttr>(this)->getSpelling();
  case attr::WorkGroupSizeHint:
    return cast<WorkGroupSizeHintAttr>(this)->getSpelling();
  case attr::X86ForceAlignArgPointer:
    return cast<X86ForceAlignArgPointerAttr>(this)->getSpelling();
  case attr::NUM_ATTRS:
    break;
  }
  llvm_unreachable("Unexpected attribute kind!");
}

Attr *Attr::clone(ASTContext &C) const {
  switch (getKind()) {
  case attr::AMDGPUNumSGPR:
    return cast<AMDGPUNumSGPRAttr>(this)->clone(C);
  case attr::AMDGPUNumVGPR:
    return cast<AMDGPUNumVGPRAttr>(this)->clone(C);
  case attr::ARMInterrupt:
    return cast<ARMInterruptAttr>(this)->clone(C);
  case attr::AcquireCapability:
    return cast<AcquireCapabilityAttr>(this)->clone(C);
  case attr::AcquiredAfter:
    return cast<AcquiredAfterAttr>(this)->clone(C);
  case attr::AcquiredBefore:
    return cast<AcquiredBeforeAttr>(this)->clone(C);
  case attr::Alias:
    return cast<AliasAttr>(this)->clone(C);
  case attr::AlignMac68k:
    return cast<AlignMac68kAttr>(this)->clone(C);
  case attr::AlignValue:
    return cast<AlignValueAttr>(this)->clone(C);
  case attr::Aligned:
    return cast<AlignedAttr>(this)->clone(C);
  case attr::AlwaysInline:
    return cast<AlwaysInlineAttr>(this)->clone(C);
  case attr::AnalyzerNoReturn:
    return cast<AnalyzerNoReturnAttr>(this)->clone(C);
  case attr::Annotate:
    return cast<AnnotateAttr>(this)->clone(C);
  case attr::ArcWeakrefUnavailable:
    return cast<ArcWeakrefUnavailableAttr>(this)->clone(C);
  case attr::ArgumentWithTypeTag:
    return cast<ArgumentWithTypeTagAttr>(this)->clone(C);
  case attr::AsmLabel:
    return cast<AsmLabelAttr>(this)->clone(C);
  case attr::AssertCapability:
    return cast<AssertCapabilityAttr>(this)->clone(C);
  case attr::AssertExclusiveLock:
    return cast<AssertExclusiveLockAttr>(this)->clone(C);
  case attr::AssertSharedLock:
    return cast<AssertSharedLockAttr>(this)->clone(C);
  case attr::AssumeAligned:
    return cast<AssumeAlignedAttr>(this)->clone(C);
  case attr::Availability:
    return cast<AvailabilityAttr>(this)->clone(C);
  case attr::Blocks:
    return cast<BlocksAttr>(this)->clone(C);
  case attr::C11NoReturn:
    return cast<C11NoReturnAttr>(this)->clone(C);
  case attr::CDecl:
    return cast<CDeclAttr>(this)->clone(C);
  case attr::CFAuditedTransfer:
    return cast<CFAuditedTransferAttr>(this)->clone(C);
  case attr::CFConsumed:
    return cast<CFConsumedAttr>(this)->clone(C);
  case attr::CFReturnsNotRetained:
    return cast<CFReturnsNotRetainedAttr>(this)->clone(C);
  case attr::CFReturnsRetained:
    return cast<CFReturnsRetainedAttr>(this)->clone(C);
  case attr::CFUnknownTransfer:
    return cast<CFUnknownTransferAttr>(this)->clone(C);
  case attr::CUDAConstant:
    return cast<CUDAConstantAttr>(this)->clone(C);
  case attr::CUDADevice:
    return cast<CUDADeviceAttr>(this)->clone(C);
  case attr::CUDAGlobal:
    return cast<CUDAGlobalAttr>(this)->clone(C);
  case attr::CUDAHost:
    return cast<CUDAHostAttr>(this)->clone(C);
  case attr::CUDAInvalidTarget:
    return cast<CUDAInvalidTargetAttr>(this)->clone(C);
  case attr::CUDALaunchBounds:
    return cast<CUDALaunchBoundsAttr>(this)->clone(C);
  case attr::CUDAShared:
    return cast<CUDASharedAttr>(this)->clone(C);
  case attr::CXX11NoReturn:
    return cast<CXX11NoReturnAttr>(this)->clone(C);
  case attr::CallableWhen:
    return cast<CallableWhenAttr>(this)->clone(C);
  case attr::Capability:
    return cast<CapabilityAttr>(this)->clone(C);
  case attr::CapturedRecord:
    return cast<CapturedRecordAttr>(this)->clone(C);
  case attr::CarriesDependency:
    return cast<CarriesDependencyAttr>(this)->clone(C);
  case attr::Cleanup:
    return cast<CleanupAttr>(this)->clone(C);
  case attr::Cold:
    return cast<ColdAttr>(this)->clone(C);
  case attr::Common:
    return cast<CommonAttr>(this)->clone(C);
  case attr::Const:
    return cast<ConstAttr>(this)->clone(C);
  case attr::Constructor:
    return cast<ConstructorAttr>(this)->clone(C);
  case attr::Consumable:
    return cast<ConsumableAttr>(this)->clone(C);
  case attr::ConsumableAutoCast:
    return cast<ConsumableAutoCastAttr>(this)->clone(C);
  case attr::ConsumableSetOnRead:
    return cast<ConsumableSetOnReadAttr>(this)->clone(C);
  case attr::DLLExport:
    return cast<DLLExportAttr>(this)->clone(C);
  case attr::DLLImport:
    return cast<DLLImportAttr>(this)->clone(C);
  case attr::Deprecated:
    return cast<DeprecatedAttr>(this)->clone(C);
  case attr::Destructor:
    return cast<DestructorAttr>(this)->clone(C);
  case attr::EnableIf:
    return cast<EnableIfAttr>(this)->clone(C);
  case attr::ExclusiveTrylockFunction:
    return cast<ExclusiveTrylockFunctionAttr>(this)->clone(C);
  case attr::FallThrough:
    return cast<FallThroughAttr>(this)->clone(C);
  case attr::FastCall:
    return cast<FastCallAttr>(this)->clone(C);
  case attr::Final:
    return cast<FinalAttr>(this)->clone(C);
  case attr::FlagEnum:
    return cast<FlagEnumAttr>(this)->clone(C);
  case attr::Flatten:
    return cast<FlattenAttr>(this)->clone(C);
  case attr::Format:
    return cast<FormatAttr>(this)->clone(C);
  case attr::FormatArg:
    return cast<FormatArgAttr>(this)->clone(C);
  case attr::GNUInline:
    return cast<GNUInlineAttr>(this)->clone(C);
  case attr::GuardedBy:
    return cast<GuardedByAttr>(this)->clone(C);
  case attr::GuardedVar:
    return cast<GuardedVarAttr>(this)->clone(C);
  case attr::HLSLAllowSparseNodes:
    return cast<HLSLAllowSparseNodesAttr>(this)->clone(C);
  case attr::HLSLAllowUAVCondition:
    return cast<HLSLAllowUAVConditionAttr>(this)->clone(C);
  case attr::HLSLBranch:
    return cast<HLSLBranchAttr>(this)->clone(C);
  case attr::HLSLCXXOverload:
    return cast<HLSLCXXOverloadAttr>(this)->clone(C);
  case attr::HLSLCall:
    return cast<HLSLCallAttr>(this)->clone(C);
  case attr::HLSLCenter:
    return cast<HLSLCenterAttr>(this)->clone(C);
  case attr::HLSLCentroid:
    return cast<HLSLCentroidAttr>(this)->clone(C);
  case attr::HLSLClipPlanes:
    return cast<HLSLClipPlanesAttr>(this)->clone(C);
  case attr::HLSLDomain:
    return cast<HLSLDomainAttr>(this)->clone(C);
  case attr::HLSLEarlyDepthStencil:
    return cast<HLSLEarlyDepthStencilAttr>(this)->clone(C);
  case attr::HLSLExperimental:
    return cast<HLSLExperimentalAttr>(this)->clone(C);
  case attr::HLSLExport:
    return cast<HLSLExportAttr>(this)->clone(C);
  case attr::HLSLFastOpt:
    return cast<HLSLFastOptAttr>(this)->clone(C);
  case attr::HLSLFlatten:
    return cast<HLSLFlattenAttr>(this)->clone(C);
  case attr::HLSLForceCase:
    return cast<HLSLForceCaseAttr>(this)->clone(C);
  case attr::HLSLGloballyCoherent:
    return cast<HLSLGloballyCoherentAttr>(this)->clone(C);
  case attr::HLSLGroupShared:
    return cast<HLSLGroupSharedAttr>(this)->clone(C);
  case attr::HLSLHitObject:
    return cast<HLSLHitObjectAttr>(this)->clone(C);
  case attr::HLSLIn:
    return cast<HLSLInAttr>(this)->clone(C);
  case attr::HLSLInOut:
    return cast<HLSLInOutAttr>(this)->clone(C);
  case attr::HLSLIndices:
    return cast<HLSLIndicesAttr>(this)->clone(C);
  case attr::HLSLInstance:
    return cast<HLSLInstanceAttr>(this)->clone(C);
  case attr::HLSLIntrinsic:
    return cast<HLSLIntrinsicAttr>(this)->clone(C);
  case attr::HLSLLine:
    return cast<HLSLLineAttr>(this)->clone(C);
  case attr::HLSLLineAdj:
    return cast<HLSLLineAdjAttr>(this)->clone(C);
  case attr::HLSLLinear:
    return cast<HLSLLinearAttr>(this)->clone(C);
  case attr::HLSLLoop:
    return cast<HLSLLoopAttr>(this)->clone(C);
  case attr::HLSLMatrix:
    return cast<HLSLMatrixAttr>(this)->clone(C);
  case attr::HLSLMaxRecords:
    return cast<HLSLMaxRecordsAttr>(this)->clone(C);
  case attr::HLSLMaxRecordsSharedWith:
    return cast<HLSLMaxRecordsSharedWithAttr>(this)->clone(C);
  case attr::HLSLMaxTessFactor:
    return cast<HLSLMaxTessFactorAttr>(this)->clone(C);
  case attr::HLSLMaxVertexCount:
    return cast<HLSLMaxVertexCountAttr>(this)->clone(C);
  case attr::HLSLMaybeUnused:
    return cast<HLSLMaybeUnusedAttr>(this)->clone(C);
  case attr::HLSLNoInterpolation:
    return cast<HLSLNoInterpolationAttr>(this)->clone(C);
  case attr::HLSLNoPerspective:
    return cast<HLSLNoPerspectiveAttr>(this)->clone(C);
  case attr::HLSLNodeArraySize:
    return cast<HLSLNodeArraySizeAttr>(this)->clone(C);
  case attr::HLSLNodeDispatchGrid:
    return cast<HLSLNodeDispatchGridAttr>(this)->clone(C);
  case attr::HLSLNodeId:
    return cast<HLSLNodeIdAttr>(this)->clone(C);
  case attr::HLSLNodeIsProgramEntry:
    return cast<HLSLNodeIsProgramEntryAttr>(this)->clone(C);
  case attr::HLSLNodeLaunch:
    return cast<HLSLNodeLaunchAttr>(this)->clone(C);
  case attr::HLSLNodeLocalRootArgumentsTableIndex:
    return cast<HLSLNodeLocalRootArgumentsTableIndexAttr>(this)->clone(C);
  case attr::HLSLNodeMaxDispatchGrid:
    return cast<HLSLNodeMaxDispatchGridAttr>(this)->clone(C);
  case attr::HLSLNodeMaxRecursionDepth:
    return cast<HLSLNodeMaxRecursionDepthAttr>(this)->clone(C);
  case attr::HLSLNodeObject:
    return cast<HLSLNodeObjectAttr>(this)->clone(C);
  case attr::HLSLNodeShareInputOf:
    return cast<HLSLNodeShareInputOfAttr>(this)->clone(C);
  case attr::HLSLNodeTrackRWInputSharing:
    return cast<HLSLNodeTrackRWInputSharingAttr>(this)->clone(C);
  case attr::HLSLNumThreads:
    return cast<HLSLNumThreadsAttr>(this)->clone(C);
  case attr::HLSLOut:
    return cast<HLSLOutAttr>(this)->clone(C);
  case attr::HLSLOutputControlPoints:
    return cast<HLSLOutputControlPointsAttr>(this)->clone(C);
  case attr::HLSLOutputTopology:
    return cast<HLSLOutputTopologyAttr>(this)->clone(C);
  case attr::HLSLPartitioning:
    return cast<HLSLPartitioningAttr>(this)->clone(C);
  case attr::HLSLPatchConstantFunc:
    return cast<HLSLPatchConstantFuncAttr>(this)->clone(C);
  case attr::HLSLPayload:
    return cast<HLSLPayloadAttr>(this)->clone(C);
  case attr::HLSLPoint:
    return cast<HLSLPointAttr>(this)->clone(C);
  case attr::HLSLPrecise:
    return cast<HLSLPreciseAttr>(this)->clone(C);
  case attr::HLSLPrimitives:
    return cast<HLSLPrimitivesAttr>(this)->clone(C);
  case attr::HLSLRayPayload:
    return cast<HLSLRayPayloadAttr>(this)->clone(C);
  case attr::HLSLRayQueryObject:
    return cast<HLSLRayQueryObjectAttr>(this)->clone(C);
  case attr::HLSLReorderCoherent:
    return cast<HLSLReorderCoherentAttr>(this)->clone(C);
  case attr::HLSLResource:
    return cast<HLSLResourceAttr>(this)->clone(C);
  case attr::HLSLRootSignature:
    return cast<HLSLRootSignatureAttr>(this)->clone(C);
  case attr::HLSLSample:
    return cast<HLSLSampleAttr>(this)->clone(C);
  case attr::HLSLSemantic:
    return cast<HLSLSemanticAttr>(this)->clone(C);
  case attr::HLSLShader:
    return cast<HLSLShaderAttr>(this)->clone(C);
  case attr::HLSLShared:
    return cast<HLSLSharedAttr>(this)->clone(C);
  case attr::HLSLSnorm:
    return cast<HLSLSnormAttr>(this)->clone(C);
  case attr::HLSLStreamOutput:
    return cast<HLSLStreamOutputAttr>(this)->clone(C);
  case attr::HLSLSubObject:
    return cast<HLSLSubObjectAttr>(this)->clone(C);
  case attr::HLSLTessPatch:
    return cast<HLSLTessPatchAttr>(this)->clone(C);
  case attr::HLSLTriangle:
    return cast<HLSLTriangleAttr>(this)->clone(C);
  case attr::HLSLTriangleAdj:
    return cast<HLSLTriangleAdjAttr>(this)->clone(C);
  case attr::HLSLUnboundedSparseNodes:
    return cast<HLSLUnboundedSparseNodesAttr>(this)->clone(C);
  case attr::HLSLUniform:
    return cast<HLSLUniformAttr>(this)->clone(C);
  case attr::HLSLUnorm:
    return cast<HLSLUnormAttr>(this)->clone(C);
  case attr::HLSLUnroll:
    return cast<HLSLUnrollAttr>(this)->clone(C);
  case attr::HLSLVector:
    return cast<HLSLVectorAttr>(this)->clone(C);
  case attr::HLSLVertices:
    return cast<HLSLVerticesAttr>(this)->clone(C);
  case attr::HLSLWaveOpsIncludeHelperLanes:
    return cast<HLSLWaveOpsIncludeHelperLanesAttr>(this)->clone(C);
  case attr::HLSLWaveSensitive:
    return cast<HLSLWaveSensitiveAttr>(this)->clone(C);
  case attr::HLSLWaveSize:
    return cast<HLSLWaveSizeAttr>(this)->clone(C);
  case attr::Hot:
    return cast<HotAttr>(this)->clone(C);
  case attr::IBAction:
    return cast<IBActionAttr>(this)->clone(C);
  case attr::IBOutlet:
    return cast<IBOutletAttr>(this)->clone(C);
  case attr::IBOutletCollection:
    return cast<IBOutletCollectionAttr>(this)->clone(C);
  case attr::InitPriority:
    return cast<InitPriorityAttr>(this)->clone(C);
  case attr::InitSeg:
    return cast<InitSegAttr>(this)->clone(C);
  case attr::IntelOclBicc:
    return cast<IntelOclBiccAttr>(this)->clone(C);
  case attr::LockReturned:
    return cast<LockReturnedAttr>(this)->clone(C);
  case attr::LocksExcluded:
    return cast<LocksExcludedAttr>(this)->clone(C);
  case attr::LoopHint:
    return cast<LoopHintAttr>(this)->clone(C);
  case attr::MSABI:
    return cast<MSABIAttr>(this)->clone(C);
  case attr::MSInheritance:
    return cast<MSInheritanceAttr>(this)->clone(C);
  case attr::MSNoVTable:
    return cast<MSNoVTableAttr>(this)->clone(C);
  case attr::MSP430Interrupt:
    return cast<MSP430InterruptAttr>(this)->clone(C);
  case attr::MSStruct:
    return cast<MSStructAttr>(this)->clone(C);
  case attr::MSVtorDisp:
    return cast<MSVtorDispAttr>(this)->clone(C);
  case attr::MaxFieldAlignment:
    return cast<MaxFieldAlignmentAttr>(this)->clone(C);
  case attr::MayAlias:
    return cast<MayAliasAttr>(this)->clone(C);
  case attr::MinSize:
    return cast<MinSizeAttr>(this)->clone(C);
  case attr::Mips16:
    return cast<Mips16Attr>(this)->clone(C);
  case attr::Mode:
    return cast<ModeAttr>(this)->clone(C);
  case attr::NSConsumed:
    return cast<NSConsumedAttr>(this)->clone(C);
  case attr::NSConsumesSelf:
    return cast<NSConsumesSelfAttr>(this)->clone(C);
  case attr::NSReturnsAutoreleased:
    return cast<NSReturnsAutoreleasedAttr>(this)->clone(C);
  case attr::NSReturnsNotRetained:
    return cast<NSReturnsNotRetainedAttr>(this)->clone(C);
  case attr::NSReturnsRetained:
    return cast<NSReturnsRetainedAttr>(this)->clone(C);
  case attr::Naked:
    return cast<NakedAttr>(this)->clone(C);
  case attr::NoCommon:
    return cast<NoCommonAttr>(this)->clone(C);
  case attr::NoDebug:
    return cast<NoDebugAttr>(this)->clone(C);
  case attr::NoDuplicate:
    return cast<NoDuplicateAttr>(this)->clone(C);
  case attr::NoInline:
    return cast<NoInlineAttr>(this)->clone(C);
  case attr::NoInstrumentFunction:
    return cast<NoInstrumentFunctionAttr>(this)->clone(C);
  case attr::NoMips16:
    return cast<NoMips16Attr>(this)->clone(C);
  case attr::NoReturn:
    return cast<NoReturnAttr>(this)->clone(C);
  case attr::NoSanitize:
    return cast<NoSanitizeAttr>(this)->clone(C);
  case attr::NoSplitStack:
    return cast<NoSplitStackAttr>(this)->clone(C);
  case attr::NoThreadSafetyAnalysis:
    return cast<NoThreadSafetyAnalysisAttr>(this)->clone(C);
  case attr::NoThrow:
    return cast<NoThrowAttr>(this)->clone(C);
  case attr::NonNull:
    return cast<NonNullAttr>(this)->clone(C);
  case attr::OMPThreadPrivateDecl:
    return cast<OMPThreadPrivateDeclAttr>(this)->clone(C);
  case attr::ObjCBoxable:
    return cast<ObjCBoxableAttr>(this)->clone(C);
  case attr::ObjCBridge:
    return cast<ObjCBridgeAttr>(this)->clone(C);
  case attr::ObjCBridgeMutable:
    return cast<ObjCBridgeMutableAttr>(this)->clone(C);
  case attr::ObjCBridgeRelated:
    return cast<ObjCBridgeRelatedAttr>(this)->clone(C);
  case attr::ObjCDesignatedInitializer:
    return cast<ObjCDesignatedInitializerAttr>(this)->clone(C);
  case attr::ObjCException:
    return cast<ObjCExceptionAttr>(this)->clone(C);
  case attr::ObjCExplicitProtocolImpl:
    return cast<ObjCExplicitProtocolImplAttr>(this)->clone(C);
  case attr::ObjCIndependentClass:
    return cast<ObjCIndependentClassAttr>(this)->clone(C);
  case attr::ObjCMethodFamily:
    return cast<ObjCMethodFamilyAttr>(this)->clone(C);
  case attr::ObjCNSObject:
    return cast<ObjCNSObjectAttr>(this)->clone(C);
  case attr::ObjCPreciseLifetime:
    return cast<ObjCPreciseLifetimeAttr>(this)->clone(C);
  case attr::ObjCRequiresPropertyDefs:
    return cast<ObjCRequiresPropertyDefsAttr>(this)->clone(C);
  case attr::ObjCRequiresSuper:
    return cast<ObjCRequiresSuperAttr>(this)->clone(C);
  case attr::ObjCReturnsInnerPointer:
    return cast<ObjCReturnsInnerPointerAttr>(this)->clone(C);
  case attr::ObjCRootClass:
    return cast<ObjCRootClassAttr>(this)->clone(C);
  case attr::ObjCRuntimeName:
    return cast<ObjCRuntimeNameAttr>(this)->clone(C);
  case attr::OpenCLImageAccess:
    return cast<OpenCLImageAccessAttr>(this)->clone(C);
  case attr::OpenCLKernel:
    return cast<OpenCLKernelAttr>(this)->clone(C);
  case attr::OptimizeNone:
    return cast<OptimizeNoneAttr>(this)->clone(C);
  case attr::Overloadable:
    return cast<OverloadableAttr>(this)->clone(C);
  case attr::Override:
    return cast<OverrideAttr>(this)->clone(C);
  case attr::Ownership:
    return cast<OwnershipAttr>(this)->clone(C);
  case attr::Packed:
    return cast<PackedAttr>(this)->clone(C);
  case attr::ParamTypestate:
    return cast<ParamTypestateAttr>(this)->clone(C);
  case attr::Pascal:
    return cast<PascalAttr>(this)->clone(C);
  case attr::Pcs:
    return cast<PcsAttr>(this)->clone(C);
  case attr::PtGuardedBy:
    return cast<PtGuardedByAttr>(this)->clone(C);
  case attr::PtGuardedVar:
    return cast<PtGuardedVarAttr>(this)->clone(C);
  case attr::Pure:
    return cast<PureAttr>(this)->clone(C);
  case attr::ReleaseCapability:
    return cast<ReleaseCapabilityAttr>(this)->clone(C);
  case attr::ReqdWorkGroupSize:
    return cast<ReqdWorkGroupSizeAttr>(this)->clone(C);
  case attr::RequiresCapability:
    return cast<RequiresCapabilityAttr>(this)->clone(C);
  case attr::Restrict:
    return cast<RestrictAttr>(this)->clone(C);
  case attr::ReturnTypestate:
    return cast<ReturnTypestateAttr>(this)->clone(C);
  case attr::ReturnsNonNull:
    return cast<ReturnsNonNullAttr>(this)->clone(C);
  case attr::ReturnsTwice:
    return cast<ReturnsTwiceAttr>(this)->clone(C);
  case attr::ScopedLockable:
    return cast<ScopedLockableAttr>(this)->clone(C);
  case attr::Section:
    return cast<SectionAttr>(this)->clone(C);
  case attr::SelectAny:
    return cast<SelectAnyAttr>(this)->clone(C);
  case attr::Sentinel:
    return cast<SentinelAttr>(this)->clone(C);
  case attr::SetTypestate:
    return cast<SetTypestateAttr>(this)->clone(C);
  case attr::SharedTrylockFunction:
    return cast<SharedTrylockFunctionAttr>(this)->clone(C);
  case attr::StdCall:
    return cast<StdCallAttr>(this)->clone(C);
  case attr::SysVABI:
    return cast<SysVABIAttr>(this)->clone(C);
  case attr::TLSModel:
    return cast<TLSModelAttr>(this)->clone(C);
  case attr::Target:
    return cast<TargetAttr>(this)->clone(C);
  case attr::TestTypestate:
    return cast<TestTypestateAttr>(this)->clone(C);
  case attr::ThisCall:
    return cast<ThisCallAttr>(this)->clone(C);
  case attr::Thread:
    return cast<ThreadAttr>(this)->clone(C);
  case attr::TransparentUnion:
    return cast<TransparentUnionAttr>(this)->clone(C);
  case attr::TryAcquireCapability:
    return cast<TryAcquireCapabilityAttr>(this)->clone(C);
  case attr::TypeTagForDatatype:
    return cast<TypeTagForDatatypeAttr>(this)->clone(C);
  case attr::TypeVisibility:
    return cast<TypeVisibilityAttr>(this)->clone(C);
  case attr::Unavailable:
    return cast<UnavailableAttr>(this)->clone(C);
  case attr::Unused:
    return cast<UnusedAttr>(this)->clone(C);
  case attr::Used:
    return cast<UsedAttr>(this)->clone(C);
  case attr::Uuid:
    return cast<UuidAttr>(this)->clone(C);
  case attr::VKAliasedPointer:
    return cast<VKAliasedPointerAttr>(this)->clone(C);
  case attr::VKBinding:
    return cast<VKBindingAttr>(this)->clone(C);
  case attr::VKBufferPointer:
    return cast<VKBufferPointerAttr>(this)->clone(C);
  case attr::VKBuiltIn:
    return cast<VKBuiltInAttr>(this)->clone(C);
  case attr::VKCapabilityExt:
    return cast<VKCapabilityExtAttr>(this)->clone(C);
  case attr::VKCombinedImageSampler:
    return cast<VKCombinedImageSamplerAttr>(this)->clone(C);
  case attr::VKConstantId:
    return cast<VKConstantIdAttr>(this)->clone(C);
  case attr::VKCounterBinding:
    return cast<VKCounterBindingAttr>(this)->clone(C);
  case attr::VKDecorateExt:
    return cast<VKDecorateExtAttr>(this)->clone(C);
  case attr::VKDecorateIdExt:
    return cast<VKDecorateIdExtAttr>(this)->clone(C);
  case attr::VKDecorateStringExt:
    return cast<VKDecorateStringExtAttr>(this)->clone(C);
  case attr::VKDepthUnchanged:
    return cast<VKDepthUnchangedAttr>(this)->clone(C);
  case attr::VKEarlyAndLateTests:
    return cast<VKEarlyAndLateTestsAttr>(this)->clone(C);
  case attr::VKExtBuiltinInput:
    return cast<VKExtBuiltinInputAttr>(this)->clone(C);
  case attr::VKExtBuiltinOutput:
    return cast<VKExtBuiltinOutputAttr>(this)->clone(C);
  case attr::VKExtensionExt:
    return cast<VKExtensionExtAttr>(this)->clone(C);
  case attr::VKImageFormat:
    return cast<VKImageFormatAttr>(this)->clone(C);
  case attr::VKIndex:
    return cast<VKIndexAttr>(this)->clone(C);
  case attr::VKInputAttachmentIndex:
    return cast<VKInputAttachmentIndexAttr>(this)->clone(C);
  case attr::VKInstructionExt:
    return cast<VKInstructionExtAttr>(this)->clone(C);
  case attr::VKLiteralExt:
    return cast<VKLiteralExtAttr>(this)->clone(C);
  case attr::VKLocation:
    return cast<VKLocationAttr>(this)->clone(C);
  case attr::VKOffset:
    return cast<VKOffsetAttr>(this)->clone(C);
  case attr::VKPostDepthCoverage:
    return cast<VKPostDepthCoverageAttr>(this)->clone(C);
  case attr::VKPushConstant:
    return cast<VKPushConstantAttr>(this)->clone(C);
  case attr::VKReferenceExt:
    return cast<VKReferenceExtAttr>(this)->clone(C);
  case attr::VKShaderRecordEXT:
    return cast<VKShaderRecordEXTAttr>(this)->clone(C);
  case attr::VKShaderRecordNV:
    return cast<VKShaderRecordNVAttr>(this)->clone(C);
  case attr::VKSpvExecutionMode:
    return cast<VKSpvExecutionModeAttr>(this)->clone(C);
  case attr::VKStencilRefGreaterEqualBack:
    return cast<VKStencilRefGreaterEqualBackAttr>(this)->clone(C);
  case attr::VKStencilRefGreaterEqualFront:
    return cast<VKStencilRefGreaterEqualFrontAttr>(this)->clone(C);
  case attr::VKStencilRefLessEqualBack:
    return cast<VKStencilRefLessEqualBackAttr>(this)->clone(C);
  case attr::VKStencilRefLessEqualFront:
    return cast<VKStencilRefLessEqualFrontAttr>(this)->clone(C);
  case attr::VKStencilRefUnchangedBack:
    return cast<VKStencilRefUnchangedBackAttr>(this)->clone(C);
  case attr::VKStencilRefUnchangedFront:
    return cast<VKStencilRefUnchangedFrontAttr>(this)->clone(C);
  case attr::VKStorageClassExt:
    return cast<VKStorageClassExtAttr>(this)->clone(C);
  case attr::VKTypeDefExt:
    return cast<VKTypeDefExtAttr>(this)->clone(C);
  case attr::VecReturn:
    return cast<VecReturnAttr>(this)->clone(C);
  case attr::VecTypeHint:
    return cast<VecTypeHintAttr>(this)->clone(C);
  case attr::VectorCall:
    return cast<VectorCallAttr>(this)->clone(C);
  case attr::Visibility:
    return cast<VisibilityAttr>(this)->clone(C);
  case attr::WarnUnused:
    return cast<WarnUnusedAttr>(this)->clone(C);
  case attr::WarnUnusedResult:
    return cast<WarnUnusedResultAttr>(this)->clone(C);
  case attr::Weak:
    return cast<WeakAttr>(this)->clone(C);
  case attr::WeakImport:
    return cast<WeakImportAttr>(this)->clone(C);
  case attr::WeakRef:
    return cast<WeakRefAttr>(this)->clone(C);
  case attr::WorkGroupSizeHint:
    return cast<WorkGroupSizeHintAttr>(this)->clone(C);
  case attr::X86ForceAlignArgPointer:
    return cast<X86ForceAlignArgPointerAttr>(this)->clone(C);
  case attr::NUM_ATTRS:
    break;
  }
  llvm_unreachable("Unexpected attribute kind!");
}

void Attr::printPretty(raw_ostream &OS, const PrintingPolicy &Policy) const {
  switch (getKind()) {
  case attr::AMDGPUNumSGPR:
    return cast<AMDGPUNumSGPRAttr>(this)->printPretty(OS, Policy);
  case attr::AMDGPUNumVGPR:
    return cast<AMDGPUNumVGPRAttr>(this)->printPretty(OS, Policy);
  case attr::ARMInterrupt:
    return cast<ARMInterruptAttr>(this)->printPretty(OS, Policy);
  case attr::AcquireCapability:
    return cast<AcquireCapabilityAttr>(this)->printPretty(OS, Policy);
  case attr::AcquiredAfter:
    return cast<AcquiredAfterAttr>(this)->printPretty(OS, Policy);
  case attr::AcquiredBefore:
    return cast<AcquiredBeforeAttr>(this)->printPretty(OS, Policy);
  case attr::Alias:
    return cast<AliasAttr>(this)->printPretty(OS, Policy);
  case attr::AlignMac68k:
    return cast<AlignMac68kAttr>(this)->printPretty(OS, Policy);
  case attr::AlignValue:
    return cast<AlignValueAttr>(this)->printPretty(OS, Policy);
  case attr::Aligned:
    return cast<AlignedAttr>(this)->printPretty(OS, Policy);
  case attr::AlwaysInline:
    return cast<AlwaysInlineAttr>(this)->printPretty(OS, Policy);
  case attr::AnalyzerNoReturn:
    return cast<AnalyzerNoReturnAttr>(this)->printPretty(OS, Policy);
  case attr::Annotate:
    return cast<AnnotateAttr>(this)->printPretty(OS, Policy);
  case attr::ArcWeakrefUnavailable:
    return cast<ArcWeakrefUnavailableAttr>(this)->printPretty(OS, Policy);
  case attr::ArgumentWithTypeTag:
    return cast<ArgumentWithTypeTagAttr>(this)->printPretty(OS, Policy);
  case attr::AsmLabel:
    return cast<AsmLabelAttr>(this)->printPretty(OS, Policy);
  case attr::AssertCapability:
    return cast<AssertCapabilityAttr>(this)->printPretty(OS, Policy);
  case attr::AssertExclusiveLock:
    return cast<AssertExclusiveLockAttr>(this)->printPretty(OS, Policy);
  case attr::AssertSharedLock:
    return cast<AssertSharedLockAttr>(this)->printPretty(OS, Policy);
  case attr::AssumeAligned:
    return cast<AssumeAlignedAttr>(this)->printPretty(OS, Policy);
  case attr::Availability:
    return cast<AvailabilityAttr>(this)->printPretty(OS, Policy);
  case attr::Blocks:
    return cast<BlocksAttr>(this)->printPretty(OS, Policy);
  case attr::C11NoReturn:
    return cast<C11NoReturnAttr>(this)->printPretty(OS, Policy);
  case attr::CDecl:
    return cast<CDeclAttr>(this)->printPretty(OS, Policy);
  case attr::CFAuditedTransfer:
    return cast<CFAuditedTransferAttr>(this)->printPretty(OS, Policy);
  case attr::CFConsumed:
    return cast<CFConsumedAttr>(this)->printPretty(OS, Policy);
  case attr::CFReturnsNotRetained:
    return cast<CFReturnsNotRetainedAttr>(this)->printPretty(OS, Policy);
  case attr::CFReturnsRetained:
    return cast<CFReturnsRetainedAttr>(this)->printPretty(OS, Policy);
  case attr::CFUnknownTransfer:
    return cast<CFUnknownTransferAttr>(this)->printPretty(OS, Policy);
  case attr::CUDAConstant:
    return cast<CUDAConstantAttr>(this)->printPretty(OS, Policy);
  case attr::CUDADevice:
    return cast<CUDADeviceAttr>(this)->printPretty(OS, Policy);
  case attr::CUDAGlobal:
    return cast<CUDAGlobalAttr>(this)->printPretty(OS, Policy);
  case attr::CUDAHost:
    return cast<CUDAHostAttr>(this)->printPretty(OS, Policy);
  case attr::CUDAInvalidTarget:
    return cast<CUDAInvalidTargetAttr>(this)->printPretty(OS, Policy);
  case attr::CUDALaunchBounds:
    return cast<CUDALaunchBoundsAttr>(this)->printPretty(OS, Policy);
  case attr::CUDAShared:
    return cast<CUDASharedAttr>(this)->printPretty(OS, Policy);
  case attr::CXX11NoReturn:
    return cast<CXX11NoReturnAttr>(this)->printPretty(OS, Policy);
  case attr::CallableWhen:
    return cast<CallableWhenAttr>(this)->printPretty(OS, Policy);
  case attr::Capability:
    return cast<CapabilityAttr>(this)->printPretty(OS, Policy);
  case attr::CapturedRecord:
    return cast<CapturedRecordAttr>(this)->printPretty(OS, Policy);
  case attr::CarriesDependency:
    return cast<CarriesDependencyAttr>(this)->printPretty(OS, Policy);
  case attr::Cleanup:
    return cast<CleanupAttr>(this)->printPretty(OS, Policy);
  case attr::Cold:
    return cast<ColdAttr>(this)->printPretty(OS, Policy);
  case attr::Common:
    return cast<CommonAttr>(this)->printPretty(OS, Policy);
  case attr::Const:
    return cast<ConstAttr>(this)->printPretty(OS, Policy);
  case attr::Constructor:
    return cast<ConstructorAttr>(this)->printPretty(OS, Policy);
  case attr::Consumable:
    return cast<ConsumableAttr>(this)->printPretty(OS, Policy);
  case attr::ConsumableAutoCast:
    return cast<ConsumableAutoCastAttr>(this)->printPretty(OS, Policy);
  case attr::ConsumableSetOnRead:
    return cast<ConsumableSetOnReadAttr>(this)->printPretty(OS, Policy);
  case attr::DLLExport:
    return cast<DLLExportAttr>(this)->printPretty(OS, Policy);
  case attr::DLLImport:
    return cast<DLLImportAttr>(this)->printPretty(OS, Policy);
  case attr::Deprecated:
    return cast<DeprecatedAttr>(this)->printPretty(OS, Policy);
  case attr::Destructor:
    return cast<DestructorAttr>(this)->printPretty(OS, Policy);
  case attr::EnableIf:
    return cast<EnableIfAttr>(this)->printPretty(OS, Policy);
  case attr::ExclusiveTrylockFunction:
    return cast<ExclusiveTrylockFunctionAttr>(this)->printPretty(OS, Policy);
  case attr::FallThrough:
    return cast<FallThroughAttr>(this)->printPretty(OS, Policy);
  case attr::FastCall:
    return cast<FastCallAttr>(this)->printPretty(OS, Policy);
  case attr::Final:
    return cast<FinalAttr>(this)->printPretty(OS, Policy);
  case attr::FlagEnum:
    return cast<FlagEnumAttr>(this)->printPretty(OS, Policy);
  case attr::Flatten:
    return cast<FlattenAttr>(this)->printPretty(OS, Policy);
  case attr::Format:
    return cast<FormatAttr>(this)->printPretty(OS, Policy);
  case attr::FormatArg:
    return cast<FormatArgAttr>(this)->printPretty(OS, Policy);
  case attr::GNUInline:
    return cast<GNUInlineAttr>(this)->printPretty(OS, Policy);
  case attr::GuardedBy:
    return cast<GuardedByAttr>(this)->printPretty(OS, Policy);
  case attr::GuardedVar:
    return cast<GuardedVarAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLAllowSparseNodes:
    return cast<HLSLAllowSparseNodesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLAllowUAVCondition:
    return cast<HLSLAllowUAVConditionAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLBranch:
    return cast<HLSLBranchAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLCXXOverload:
    return cast<HLSLCXXOverloadAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLCall:
    return cast<HLSLCallAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLCenter:
    return cast<HLSLCenterAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLCentroid:
    return cast<HLSLCentroidAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLClipPlanes:
    return cast<HLSLClipPlanesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLDomain:
    return cast<HLSLDomainAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLEarlyDepthStencil:
    return cast<HLSLEarlyDepthStencilAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLExperimental:
    return cast<HLSLExperimentalAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLExport:
    return cast<HLSLExportAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLFastOpt:
    return cast<HLSLFastOptAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLFlatten:
    return cast<HLSLFlattenAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLForceCase:
    return cast<HLSLForceCaseAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLGloballyCoherent:
    return cast<HLSLGloballyCoherentAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLGroupShared:
    return cast<HLSLGroupSharedAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLHitObject:
    return cast<HLSLHitObjectAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLIn:
    return cast<HLSLInAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLInOut:
    return cast<HLSLInOutAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLIndices:
    return cast<HLSLIndicesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLInstance:
    return cast<HLSLInstanceAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLIntrinsic:
    return cast<HLSLIntrinsicAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLLine:
    return cast<HLSLLineAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLLineAdj:
    return cast<HLSLLineAdjAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLLinear:
    return cast<HLSLLinearAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLLoop:
    return cast<HLSLLoopAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLMatrix:
    return cast<HLSLMatrixAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLMaxRecords:
    return cast<HLSLMaxRecordsAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLMaxRecordsSharedWith:
    return cast<HLSLMaxRecordsSharedWithAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLMaxTessFactor:
    return cast<HLSLMaxTessFactorAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLMaxVertexCount:
    return cast<HLSLMaxVertexCountAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLMaybeUnused:
    return cast<HLSLMaybeUnusedAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNoInterpolation:
    return cast<HLSLNoInterpolationAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNoPerspective:
    return cast<HLSLNoPerspectiveAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeArraySize:
    return cast<HLSLNodeArraySizeAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeDispatchGrid:
    return cast<HLSLNodeDispatchGridAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeId:
    return cast<HLSLNodeIdAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeIsProgramEntry:
    return cast<HLSLNodeIsProgramEntryAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeLaunch:
    return cast<HLSLNodeLaunchAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeLocalRootArgumentsTableIndex:
    return cast<HLSLNodeLocalRootArgumentsTableIndexAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeMaxDispatchGrid:
    return cast<HLSLNodeMaxDispatchGridAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeMaxRecursionDepth:
    return cast<HLSLNodeMaxRecursionDepthAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeObject:
    return cast<HLSLNodeObjectAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeShareInputOf:
    return cast<HLSLNodeShareInputOfAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNodeTrackRWInputSharing:
    return cast<HLSLNodeTrackRWInputSharingAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLNumThreads:
    return cast<HLSLNumThreadsAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLOut:
    return cast<HLSLOutAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLOutputControlPoints:
    return cast<HLSLOutputControlPointsAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLOutputTopology:
    return cast<HLSLOutputTopologyAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLPartitioning:
    return cast<HLSLPartitioningAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLPatchConstantFunc:
    return cast<HLSLPatchConstantFuncAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLPayload:
    return cast<HLSLPayloadAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLPoint:
    return cast<HLSLPointAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLPrecise:
    return cast<HLSLPreciseAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLPrimitives:
    return cast<HLSLPrimitivesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLRayPayload:
    return cast<HLSLRayPayloadAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLRayQueryObject:
    return cast<HLSLRayQueryObjectAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLReorderCoherent:
    return cast<HLSLReorderCoherentAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLResource:
    return cast<HLSLResourceAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLRootSignature:
    return cast<HLSLRootSignatureAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLSample:
    return cast<HLSLSampleAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLSemantic:
    return cast<HLSLSemanticAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLShader:
    return cast<HLSLShaderAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLShared:
    return cast<HLSLSharedAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLSnorm:
    return cast<HLSLSnormAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLStreamOutput:
    return cast<HLSLStreamOutputAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLSubObject:
    return cast<HLSLSubObjectAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLTessPatch:
    return cast<HLSLTessPatchAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLTriangle:
    return cast<HLSLTriangleAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLTriangleAdj:
    return cast<HLSLTriangleAdjAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLUnboundedSparseNodes:
    return cast<HLSLUnboundedSparseNodesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLUniform:
    return cast<HLSLUniformAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLUnorm:
    return cast<HLSLUnormAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLUnroll:
    return cast<HLSLUnrollAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLVector:
    return cast<HLSLVectorAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLVertices:
    return cast<HLSLVerticesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLWaveOpsIncludeHelperLanes:
    return cast<HLSLWaveOpsIncludeHelperLanesAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLWaveSensitive:
    return cast<HLSLWaveSensitiveAttr>(this)->printPretty(OS, Policy);
  case attr::HLSLWaveSize:
    return cast<HLSLWaveSizeAttr>(this)->printPretty(OS, Policy);
  case attr::Hot:
    return cast<HotAttr>(this)->printPretty(OS, Policy);
  case attr::IBAction:
    return cast<IBActionAttr>(this)->printPretty(OS, Policy);
  case attr::IBOutlet:
    return cast<IBOutletAttr>(this)->printPretty(OS, Policy);
  case attr::IBOutletCollection:
    return cast<IBOutletCollectionAttr>(this)->printPretty(OS, Policy);
  case attr::InitPriority:
    return cast<InitPriorityAttr>(this)->printPretty(OS, Policy);
  case attr::InitSeg:
    return cast<InitSegAttr>(this)->printPretty(OS, Policy);
  case attr::IntelOclBicc:
    return cast<IntelOclBiccAttr>(this)->printPretty(OS, Policy);
  case attr::LockReturned:
    return cast<LockReturnedAttr>(this)->printPretty(OS, Policy);
  case attr::LocksExcluded:
    return cast<LocksExcludedAttr>(this)->printPretty(OS, Policy);
  case attr::LoopHint:
    return cast<LoopHintAttr>(this)->printPretty(OS, Policy);
  case attr::MSABI:
    return cast<MSABIAttr>(this)->printPretty(OS, Policy);
  case attr::MSInheritance:
    return cast<MSInheritanceAttr>(this)->printPretty(OS, Policy);
  case attr::MSNoVTable:
    return cast<MSNoVTableAttr>(this)->printPretty(OS, Policy);
  case attr::MSP430Interrupt:
    return cast<MSP430InterruptAttr>(this)->printPretty(OS, Policy);
  case attr::MSStruct:
    return cast<MSStructAttr>(this)->printPretty(OS, Policy);
  case attr::MSVtorDisp:
    return cast<MSVtorDispAttr>(this)->printPretty(OS, Policy);
  case attr::MaxFieldAlignment:
    return cast<MaxFieldAlignmentAttr>(this)->printPretty(OS, Policy);
  case attr::MayAlias:
    return cast<MayAliasAttr>(this)->printPretty(OS, Policy);
  case attr::MinSize:
    return cast<MinSizeAttr>(this)->printPretty(OS, Policy);
  case attr::Mips16:
    return cast<Mips16Attr>(this)->printPretty(OS, Policy);
  case attr::Mode:
    return cast<ModeAttr>(this)->printPretty(OS, Policy);
  case attr::NSConsumed:
    return cast<NSConsumedAttr>(this)->printPretty(OS, Policy);
  case attr::NSConsumesSelf:
    return cast<NSConsumesSelfAttr>(this)->printPretty(OS, Policy);
  case attr::NSReturnsAutoreleased:
    return cast<NSReturnsAutoreleasedAttr>(this)->printPretty(OS, Policy);
  case attr::NSReturnsNotRetained:
    return cast<NSReturnsNotRetainedAttr>(this)->printPretty(OS, Policy);
  case attr::NSReturnsRetained:
    return cast<NSReturnsRetainedAttr>(this)->printPretty(OS, Policy);
  case attr::Naked:
    return cast<NakedAttr>(this)->printPretty(OS, Policy);
  case attr::NoCommon:
    return cast<NoCommonAttr>(this)->printPretty(OS, Policy);
  case attr::NoDebug:
    return cast<NoDebugAttr>(this)->printPretty(OS, Policy);
  case attr::NoDuplicate:
    return cast<NoDuplicateAttr>(this)->printPretty(OS, Policy);
  case attr::NoInline:
    return cast<NoInlineAttr>(this)->printPretty(OS, Policy);
  case attr::NoInstrumentFunction:
    return cast<NoInstrumentFunctionAttr>(this)->printPretty(OS, Policy);
  case attr::NoMips16:
    return cast<NoMips16Attr>(this)->printPretty(OS, Policy);
  case attr::NoReturn:
    return cast<NoReturnAttr>(this)->printPretty(OS, Policy);
  case attr::NoSanitize:
    return cast<NoSanitizeAttr>(this)->printPretty(OS, Policy);
  case attr::NoSplitStack:
    return cast<NoSplitStackAttr>(this)->printPretty(OS, Policy);
  case attr::NoThreadSafetyAnalysis:
    return cast<NoThreadSafetyAnalysisAttr>(this)->printPretty(OS, Policy);
  case attr::NoThrow:
    return cast<NoThrowAttr>(this)->printPretty(OS, Policy);
  case attr::NonNull:
    return cast<NonNullAttr>(this)->printPretty(OS, Policy);
  case attr::OMPThreadPrivateDecl:
    return cast<OMPThreadPrivateDeclAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCBoxable:
    return cast<ObjCBoxableAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCBridge:
    return cast<ObjCBridgeAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCBridgeMutable:
    return cast<ObjCBridgeMutableAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCBridgeRelated:
    return cast<ObjCBridgeRelatedAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCDesignatedInitializer:
    return cast<ObjCDesignatedInitializerAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCException:
    return cast<ObjCExceptionAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCExplicitProtocolImpl:
    return cast<ObjCExplicitProtocolImplAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCIndependentClass:
    return cast<ObjCIndependentClassAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCMethodFamily:
    return cast<ObjCMethodFamilyAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCNSObject:
    return cast<ObjCNSObjectAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCPreciseLifetime:
    return cast<ObjCPreciseLifetimeAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCRequiresPropertyDefs:
    return cast<ObjCRequiresPropertyDefsAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCRequiresSuper:
    return cast<ObjCRequiresSuperAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCReturnsInnerPointer:
    return cast<ObjCReturnsInnerPointerAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCRootClass:
    return cast<ObjCRootClassAttr>(this)->printPretty(OS, Policy);
  case attr::ObjCRuntimeName:
    return cast<ObjCRuntimeNameAttr>(this)->printPretty(OS, Policy);
  case attr::OpenCLImageAccess:
    return cast<OpenCLImageAccessAttr>(this)->printPretty(OS, Policy);
  case attr::OpenCLKernel:
    return cast<OpenCLKernelAttr>(this)->printPretty(OS, Policy);
  case attr::OptimizeNone:
    return cast<OptimizeNoneAttr>(this)->printPretty(OS, Policy);
  case attr::Overloadable:
    return cast<OverloadableAttr>(this)->printPretty(OS, Policy);
  case attr::Override:
    return cast<OverrideAttr>(this)->printPretty(OS, Policy);
  case attr::Ownership:
    return cast<OwnershipAttr>(this)->printPretty(OS, Policy);
  case attr::Packed:
    return cast<PackedAttr>(this)->printPretty(OS, Policy);
  case attr::ParamTypestate:
    return cast<ParamTypestateAttr>(this)->printPretty(OS, Policy);
  case attr::Pascal:
    return cast<PascalAttr>(this)->printPretty(OS, Policy);
  case attr::Pcs:
    return cast<PcsAttr>(this)->printPretty(OS, Policy);
  case attr::PtGuardedBy:
    return cast<PtGuardedByAttr>(this)->printPretty(OS, Policy);
  case attr::PtGuardedVar:
    return cast<PtGuardedVarAttr>(this)->printPretty(OS, Policy);
  case attr::Pure:
    return cast<PureAttr>(this)->printPretty(OS, Policy);
  case attr::ReleaseCapability:
    return cast<ReleaseCapabilityAttr>(this)->printPretty(OS, Policy);
  case attr::ReqdWorkGroupSize:
    return cast<ReqdWorkGroupSizeAttr>(this)->printPretty(OS, Policy);
  case attr::RequiresCapability:
    return cast<RequiresCapabilityAttr>(this)->printPretty(OS, Policy);
  case attr::Restrict:
    return cast<RestrictAttr>(this)->printPretty(OS, Policy);
  case attr::ReturnTypestate:
    return cast<ReturnTypestateAttr>(this)->printPretty(OS, Policy);
  case attr::ReturnsNonNull:
    return cast<ReturnsNonNullAttr>(this)->printPretty(OS, Policy);
  case attr::ReturnsTwice:
    return cast<ReturnsTwiceAttr>(this)->printPretty(OS, Policy);
  case attr::ScopedLockable:
    return cast<ScopedLockableAttr>(this)->printPretty(OS, Policy);
  case attr::Section:
    return cast<SectionAttr>(this)->printPretty(OS, Policy);
  case attr::SelectAny:
    return cast<SelectAnyAttr>(this)->printPretty(OS, Policy);
  case attr::Sentinel:
    return cast<SentinelAttr>(this)->printPretty(OS, Policy);
  case attr::SetTypestate:
    return cast<SetTypestateAttr>(this)->printPretty(OS, Policy);
  case attr::SharedTrylockFunction:
    return cast<SharedTrylockFunctionAttr>(this)->printPretty(OS, Policy);
  case attr::StdCall:
    return cast<StdCallAttr>(this)->printPretty(OS, Policy);
  case attr::SysVABI:
    return cast<SysVABIAttr>(this)->printPretty(OS, Policy);
  case attr::TLSModel:
    return cast<TLSModelAttr>(this)->printPretty(OS, Policy);
  case attr::Target:
    return cast<TargetAttr>(this)->printPretty(OS, Policy);
  case attr::TestTypestate:
    return cast<TestTypestateAttr>(this)->printPretty(OS, Policy);
  case attr::ThisCall:
    return cast<ThisCallAttr>(this)->printPretty(OS, Policy);
  case attr::Thread:
    return cast<ThreadAttr>(this)->printPretty(OS, Policy);
  case attr::TransparentUnion:
    return cast<TransparentUnionAttr>(this)->printPretty(OS, Policy);
  case attr::TryAcquireCapability:
    return cast<TryAcquireCapabilityAttr>(this)->printPretty(OS, Policy);
  case attr::TypeTagForDatatype:
    return cast<TypeTagForDatatypeAttr>(this)->printPretty(OS, Policy);
  case attr::TypeVisibility:
    return cast<TypeVisibilityAttr>(this)->printPretty(OS, Policy);
  case attr::Unavailable:
    return cast<UnavailableAttr>(this)->printPretty(OS, Policy);
  case attr::Unused:
    return cast<UnusedAttr>(this)->printPretty(OS, Policy);
  case attr::Used:
    return cast<UsedAttr>(this)->printPretty(OS, Policy);
  case attr::Uuid:
    return cast<UuidAttr>(this)->printPretty(OS, Policy);
  case attr::VKAliasedPointer:
    return cast<VKAliasedPointerAttr>(this)->printPretty(OS, Policy);
  case attr::VKBinding:
    return cast<VKBindingAttr>(this)->printPretty(OS, Policy);
  case attr::VKBufferPointer:
    return cast<VKBufferPointerAttr>(this)->printPretty(OS, Policy);
  case attr::VKBuiltIn:
    return cast<VKBuiltInAttr>(this)->printPretty(OS, Policy);
  case attr::VKCapabilityExt:
    return cast<VKCapabilityExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKCombinedImageSampler:
    return cast<VKCombinedImageSamplerAttr>(this)->printPretty(OS, Policy);
  case attr::VKConstantId:
    return cast<VKConstantIdAttr>(this)->printPretty(OS, Policy);
  case attr::VKCounterBinding:
    return cast<VKCounterBindingAttr>(this)->printPretty(OS, Policy);
  case attr::VKDecorateExt:
    return cast<VKDecorateExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKDecorateIdExt:
    return cast<VKDecorateIdExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKDecorateStringExt:
    return cast<VKDecorateStringExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKDepthUnchanged:
    return cast<VKDepthUnchangedAttr>(this)->printPretty(OS, Policy);
  case attr::VKEarlyAndLateTests:
    return cast<VKEarlyAndLateTestsAttr>(this)->printPretty(OS, Policy);
  case attr::VKExtBuiltinInput:
    return cast<VKExtBuiltinInputAttr>(this)->printPretty(OS, Policy);
  case attr::VKExtBuiltinOutput:
    return cast<VKExtBuiltinOutputAttr>(this)->printPretty(OS, Policy);
  case attr::VKExtensionExt:
    return cast<VKExtensionExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKImageFormat:
    return cast<VKImageFormatAttr>(this)->printPretty(OS, Policy);
  case attr::VKIndex:
    return cast<VKIndexAttr>(this)->printPretty(OS, Policy);
  case attr::VKInputAttachmentIndex:
    return cast<VKInputAttachmentIndexAttr>(this)->printPretty(OS, Policy);
  case attr::VKInstructionExt:
    return cast<VKInstructionExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKLiteralExt:
    return cast<VKLiteralExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKLocation:
    return cast<VKLocationAttr>(this)->printPretty(OS, Policy);
  case attr::VKOffset:
    return cast<VKOffsetAttr>(this)->printPretty(OS, Policy);
  case attr::VKPostDepthCoverage:
    return cast<VKPostDepthCoverageAttr>(this)->printPretty(OS, Policy);
  case attr::VKPushConstant:
    return cast<VKPushConstantAttr>(this)->printPretty(OS, Policy);
  case attr::VKReferenceExt:
    return cast<VKReferenceExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKShaderRecordEXT:
    return cast<VKShaderRecordEXTAttr>(this)->printPretty(OS, Policy);
  case attr::VKShaderRecordNV:
    return cast<VKShaderRecordNVAttr>(this)->printPretty(OS, Policy);
  case attr::VKSpvExecutionMode:
    return cast<VKSpvExecutionModeAttr>(this)->printPretty(OS, Policy);
  case attr::VKStencilRefGreaterEqualBack:
    return cast<VKStencilRefGreaterEqualBackAttr>(this)->printPretty(OS, Policy);
  case attr::VKStencilRefGreaterEqualFront:
    return cast<VKStencilRefGreaterEqualFrontAttr>(this)->printPretty(OS, Policy);
  case attr::VKStencilRefLessEqualBack:
    return cast<VKStencilRefLessEqualBackAttr>(this)->printPretty(OS, Policy);
  case attr::VKStencilRefLessEqualFront:
    return cast<VKStencilRefLessEqualFrontAttr>(this)->printPretty(OS, Policy);
  case attr::VKStencilRefUnchangedBack:
    return cast<VKStencilRefUnchangedBackAttr>(this)->printPretty(OS, Policy);
  case attr::VKStencilRefUnchangedFront:
    return cast<VKStencilRefUnchangedFrontAttr>(this)->printPretty(OS, Policy);
  case attr::VKStorageClassExt:
    return cast<VKStorageClassExtAttr>(this)->printPretty(OS, Policy);
  case attr::VKTypeDefExt:
    return cast<VKTypeDefExtAttr>(this)->printPretty(OS, Policy);
  case attr::VecReturn:
    return cast<VecReturnAttr>(this)->printPretty(OS, Policy);
  case attr::VecTypeHint:
    return cast<VecTypeHintAttr>(this)->printPretty(OS, Policy);
  case attr::VectorCall:
    return cast<VectorCallAttr>(this)->printPretty(OS, Policy);
  case attr::Visibility:
    return cast<VisibilityAttr>(this)->printPretty(OS, Policy);
  case attr::WarnUnused:
    return cast<WarnUnusedAttr>(this)->printPretty(OS, Policy);
  case attr::WarnUnusedResult:
    return cast<WarnUnusedResultAttr>(this)->printPretty(OS, Policy);
  case attr::Weak:
    return cast<WeakAttr>(this)->printPretty(OS, Policy);
  case attr::WeakImport:
    return cast<WeakImportAttr>(this)->printPretty(OS, Policy);
  case attr::WeakRef:
    return cast<WeakRefAttr>(this)->printPretty(OS, Policy);
  case attr::WorkGroupSizeHint:
    return cast<WorkGroupSizeHintAttr>(this)->printPretty(OS, Policy);
  case attr::X86ForceAlignArgPointer:
    return cast<X86ForceAlignArgPointerAttr>(this)->printPretty(OS, Policy);
  case attr::NUM_ATTRS:
    break;
  }
  llvm_unreachable("Unexpected attribute kind!");
}

