/** An implementation of mineSweeper for use as a hacking minigame.
 *  Original implementation by https://github.com/daid
 */

#ifndef MINESWEEPER_H
#define MINESWEEPER_H

#include "miniGame.h"
#include "gui/gui2_togglebutton.h"


class MineSweeper : public MiniGame {
  public:
    MineSweeper(GuiPanel* owner, GuiHackingDialog* parent, int difficulty);
    virtual void reset() override;
    virtual void disable() override;
    virtual float getProgress() override;
    virtual glm::vec2 getBoardSize() override;
  protected:
    virtual void gameComplete() override;
  private:
    void onFieldClick(int x, int y);
    int error_count;
    int correct_count;
    int field_size;
    int bomb_count;
    class FieldItem : public GuiToggleButton
    {
    public:
        FieldItem(GuiContainer* owner, string id, string text, func_t func);

        bool bomb;
    };
    FieldItem* getFieldItem(int x, int y);
};

#endif//MINESWEEPER_H
