
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "browserwindow_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BrowserWindow_Type = nullptr;
static PyTypeObject *Sbk_BrowserWindow_TypeF(void)
{
    return _Sbk_BrowserWindow_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void BrowserWindowWrapper::pysideInitQtMetaTypes()
{
}

void BrowserWindowWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

BrowserWindowWrapper::BrowserWindowWrapper(::Qz::BrowserWindowType type, const ::QList<QUrl> urls) : BrowserWindow(type, urls)
{
}

void BrowserWindowWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BrowserWindow", funcName, gil, pyOverride, signal);
}

void BrowserWindowWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMainWindow::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

::QMenu * BrowserWindowWrapper::createPopupMenu()
{
    static const char *funcName = "createPopupMenu";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMainWindow::createPopupMenu();
    }
    return sbk_o_createPopupMenu("BrowserWindow", funcName, gil, pyOverride);
}

::QMenu * BrowserWindowWrapper::sbk_o_createPopupMenu(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QMenu >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMenu *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void BrowserWindowWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

int BrowserWindowWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("BrowserWindow", funcName, gil, pyOverride);
}

void BrowserWindowWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("BrowserWindow", funcName, gil, pyOverride, signal);
}

void BrowserWindowWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

bool BrowserWindowWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("BrowserWindow", funcName, gil, pyOverride, watched, event);
}

void BrowserWindowWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

bool BrowserWindowWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("BrowserWindow", funcName, gil, pyOverride, next);
}

void BrowserWindowWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

bool BrowserWindowWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("BrowserWindow", funcName, gil, pyOverride);
}

int BrowserWindowWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("BrowserWindow", funcName, gil, pyOverride, arg__1);
}

void BrowserWindowWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("BrowserWindow", funcName, gil, pyOverride, painter);
}

void BrowserWindowWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

::QVariant BrowserWindowWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("BrowserWindow", funcName, gil, pyOverride, arg__1);
}

void BrowserWindowWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

int BrowserWindowWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("BrowserWindow", funcName, gil, pyOverride, arg__1);
}

::QSize BrowserWindowWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("BrowserWindow", funcName, gil, pyOverride);
}

void BrowserWindowWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

bool BrowserWindowWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("BrowserWindow", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * BrowserWindowWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("BrowserWindow", funcName, gil, pyOverride);
}

void BrowserWindowWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

::QPaintDevice * BrowserWindowWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("BrowserWindow", funcName, gil, pyOverride, offset);
}

void BrowserWindowWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("BrowserWindow", funcName, gil, pyOverride, visible);
}

::QPainter * BrowserWindowWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("BrowserWindow", funcName, gil, pyOverride);
}

void BrowserWindowWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

::QSize BrowserWindowWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("BrowserWindow", funcName, gil, pyOverride);
}

void BrowserWindowWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

void BrowserWindowWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_BrowserWindow_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("BrowserWindow", funcName, gil, pyOverride, event);
}

const QMetaObject *BrowserWindowWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return BrowserWindow::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int BrowserWindowWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = BrowserWindow::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *BrowserWindowWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< BrowserWindowWrapper *>(this));
    }
    return BrowserWindow::qt_metacast(_clname);
}

BrowserWindowWrapper::~BrowserWindowWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_BrowserWindow_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BrowserWindow_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BrowserWindow >()))
        return -1;

    BrowserWindowWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:BrowserWindow", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: BrowserWindow::BrowserWindow(Qz::BrowserWindowType,QList<QUrl>=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_BrowserWindowType_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // BrowserWindow(Qz::BrowserWindowType,QList<QUrl>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX], (pyArgs[1])))) {
            overloadId = 0; // BrowserWindow(Qz::BrowserWindowType,QList<QUrl>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"urls", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
            }
        }
        ::Qz::BrowserWindowType cppArg0{Qz::BW_FirstAppWindow};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QList<QUrl> cppArg1{};
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // BrowserWindow(Qz::BrowserWindowType,QList<QUrl>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) BrowserWindowWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new BrowserWindowWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< BrowserWindow >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
    };


    return 1;
}

static PyObject *Sbk_BrowserWindowFunc_action(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::action(QString)const->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // action(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "action", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // action(QString)const
            QAction * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->action(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_addBookmark(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addBookmark", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BrowserWindow::addBookmark(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // addBookmark(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addBookmark(QUrl,QString)
            cppSelf->addBookmark(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_addDeleteOnCloseWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::addDeleteOnCloseWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // addDeleteOnCloseWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addDeleteOnCloseWidget", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addDeleteOnCloseWidget(QWidget*)
            cppSelf->addDeleteOnCloseWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_addTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // addTab()
        cppSelf->addTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_bookmarkAllTabs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bookmarkAllTabs()
        cppSelf->bookmarkAllTabs();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_bookmarkPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bookmarkPage()
        cppSelf->bookmarkPage();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_closeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::closeEvent(QCloseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QCloseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // closeEvent(QCloseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "closeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("closeEvent(QCloseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_createEncodingMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::createEncodingMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // createEncodingMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createEncodingMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createEncodingMenu(QMenu*)
            cppSelf->createEncodingMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_createSidebarsMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::createSidebarsMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // createSidebarsMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createSidebarsMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createSidebarsMenu(QMenu*)
            cppSelf->createSidebarsMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_createToolbarsMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::createToolbarsMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // createToolbarsMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createToolbarsMenu", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createToolbarsMenu(QMenu*)
            cppSelf->createToolbarsMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_currentTabChanged(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentTabChanged()
        cppSelf->currentTabChanged();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("event(QEvent *event)");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_fullScreenNavigationVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fullScreenNavigationVisible()const
        bool cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->fullScreenNavigationVisible();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_goBack(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goBack()
        cppSelf->goBack();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_goForward(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goForward()
        cppSelf->goForward();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_goHome(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goHome()
        cppSelf->goHome();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_goHomeInNewTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goHomeInNewTab()
        cppSelf->goHomeInNewTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_hideNavigationWithFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hideNavigationWithFullScreen()
        cppSelf->hideNavigationWithFullScreen();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_homepageUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // homepageUrl()const
        QUrl cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->homepageUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_ipLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // ipLabel()const
        QLabel * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->ipLabel();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyPressEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyReleaseEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_loadActionUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "loadActionUrl", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    if (PyArg_ParseTuple(args, "|O:loadActionUrl", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BrowserWindow::loadActionUrl(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // loadActionUrl(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // loadActionUrl(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "loadActionUrl", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"obj", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "loadActionUrl", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadActionUrl(QObject*)
            cppSelf->loadActionUrl(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_loadActionUrlInNewTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "loadActionUrlInNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    if (PyArg_ParseTuple(args, "|O:loadActionUrlInNewTab", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BrowserWindow::loadActionUrlInNewTab(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // loadActionUrlInNewTab(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // loadActionUrlInNewTab(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "loadActionUrlInNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"obj", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "loadActionUrlInNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadActionUrlInNewTab(QObject*)
            cppSelf->loadActionUrlInNewTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_loadAddress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::loadAddress(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // loadAddress(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadAddress", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // loadAddress(QUrl)
            cppSelf->loadAddress(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_locationBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // locationBar()const
        LocationBar * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->locationBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_navigationBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // navigationBar()const
        NavigationBar * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->navigationBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_reload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reload()
        cppSelf->reload();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_reloadBypassCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reloadBypassCache()
        cppSelf->reloadBypassCache();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_removeActions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::removeActions(QList<QAction*>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QActionPTR_IDX], (pyArg)))) {
        overloadId = 0; // removeActions(QList<QAction*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeActions", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        ::QList<QAction*> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeActions(QList<QAction*>)
            cppSelf->removeActions(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_requestHtmlFullScreen(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "requestHtmlFullScreen", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BrowserWindow::requestHtmlFullScreen(TabbedWebView*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // requestHtmlFullScreen(TabbedWebView*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "requestHtmlFullScreen", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::TabbedWebView *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // requestHtmlFullScreen(TabbedWebView*,bool)
            cppSelf->requestHtmlFullScreen(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("resizeEvent(QResizeEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_saveSideBarSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveSideBarSettings()
        cppSelf->saveSideBarSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_setStartPage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::setStartPage(WebPage*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArg)))) {
        overloadId = 0; // setStartPage(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStartPage", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStartPage(WebPage*)
            cppSelf->setStartPage(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_setStartTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::setStartTab(WebTab*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArg)))) {
        overloadId = 0; // setStartTab(WebTab*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStartTab", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebTab *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStartTab(WebTab*)
            cppSelf->setStartTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_setWindowTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::setWindowTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setWindowTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWindowTitle", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindowTitle(QString)
            cppSelf->setWindowTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_showHistoryManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showHistoryManager()
        cppSelf->showHistoryManager();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_showNavigationWithFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showNavigationWithFullScreen()
        cppSelf->showNavigationWithFullScreen();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_showSource(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showSource", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    if (PyArg_ParseTuple(args, "|O:showSource", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BrowserWindow::showSource(WebView*=)
    if (numArgs == 0) {
        overloadId = 0; // showSource(WebView*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArgs[0])))) {
        overloadId = 0; // showSource(WebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showSource", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"view", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showSource", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebView *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showSource(WebView*)
            cppSelf->showSource(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_showWebInspector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showWebInspector()
        cppSelf->showWebInspector();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_sideBarManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sideBarManager()const
        SideBarManager * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->sideBarManager();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_statusBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // statusBar()const
        StatusBar * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->statusBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_StatusBar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_superMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // superMenu()const
        QMenu * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->superMenu();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_tabCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabCount()const
        int cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->tabCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_tabModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabModel()const
        TabModel * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->tabModel();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_tabMruModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabMruModel()const
        TabMruModel * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->tabMruModel();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabMruModel_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_tabWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabWidget()const
        TabWidget * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->tabWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_toggleFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleFullScreen()
        cppSelf->toggleFullScreen();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_toggleShowBookmarksToolbar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleShowBookmarksToolbar()
        cppSelf->toggleShowBookmarksToolbar();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_toggleShowMenubar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleShowMenubar()
        cppSelf->toggleShowMenubar();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_toggleShowNavigationToolbar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleShowNavigationToolbar()
        cppSelf->toggleShowNavigationToolbar();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_toggleShowStatusBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleShowStatusBar()
        cppSelf->toggleShowStatusBar();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_toggleTabsOnTop(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BrowserWindow::toggleTabsOnTop(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // toggleTabsOnTop(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "toggleTabsOnTop", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toggleTabsOnTop(bool)
            cppSelf->toggleTabsOnTop(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_toggleWebInspector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleWebInspector()
        cppSelf->toggleWebInspector();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_updateLoadingActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // updateLoadingActions()
        cppSelf->updateLoadingActions();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BrowserWindowFunc_useTabNumberShortcuts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // useTabNumberShortcuts()const
        bool cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->useTabNumberShortcuts();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_weView(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "weView", 0, 1, &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BrowserWindow::weView()const->TabbedWebView*
    // 1: BrowserWindow::weView(int)const->TabbedWebView*
    if (numArgs == 0) {
        overloadId = 0; // weView()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // weView(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "weView", errInfo, SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // weView() const
        {

            // weView()const
            TabbedWebView * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->weView();
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
            break;
        }
        case 1: // weView(int index) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // weView(int)const
                TabbedWebView * cppResult = const_cast<const BrowserWindowWrapper *>(cppSelf)->weView(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), cppResult);
                // Ownership transferences (return value heuristics).
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BrowserWindowFunc_windowType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BrowserWindowWrapper *>(reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // windowType()const
        Qz::BrowserWindowType cppResult = Qz::BrowserWindowType(const_cast<const BrowserWindowWrapper *>(cppSelf)->windowType());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_BrowserWindowType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_BrowserWindow_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BrowserWindow_methods[] = {
    {"action", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_action), METH_O, nullptr},
    {"addBookmark", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_addBookmark), METH_VARARGS, nullptr},
    {"addDeleteOnCloseWidget", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_addDeleteOnCloseWidget), METH_O, nullptr},
    {"addTab", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_addTab), METH_NOARGS, nullptr},
    {"bookmarkAllTabs", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_bookmarkAllTabs), METH_NOARGS, nullptr},
    {"bookmarkPage", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_bookmarkPage), METH_NOARGS, nullptr},
    {"closeEvent", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_closeEvent), METH_O, nullptr},
    {"createEncodingMenu", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_createEncodingMenu), METH_O, nullptr},
    {"createSidebarsMenu", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_createSidebarsMenu), METH_O, nullptr},
    {"createToolbarsMenu", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_createToolbarsMenu), METH_O, nullptr},
    {"currentTabChanged", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_currentTabChanged), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_event), METH_O, nullptr},
    {"fullScreenNavigationVisible", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_fullScreenNavigationVisible), METH_NOARGS, nullptr},
    {"goBack", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_goBack), METH_NOARGS, nullptr},
    {"goForward", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_goForward), METH_NOARGS, nullptr},
    {"goHome", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_goHome), METH_NOARGS, nullptr},
    {"goHomeInNewTab", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_goHomeInNewTab), METH_NOARGS, nullptr},
    {"hideNavigationWithFullScreen", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_hideNavigationWithFullScreen), METH_NOARGS, nullptr},
    {"homepageUrl", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_homepageUrl), METH_NOARGS, nullptr},
    {"ipLabel", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_ipLabel), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_keyPressEvent), METH_O, nullptr},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_keyReleaseEvent), METH_O, nullptr},
    {"loadActionUrl", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_loadActionUrl), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"loadActionUrlInNewTab", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_loadActionUrlInNewTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"loadAddress", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_loadAddress), METH_O, nullptr},
    {"locationBar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_locationBar), METH_NOARGS, nullptr},
    {"navigationBar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_navigationBar), METH_NOARGS, nullptr},
    {"reload", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_reload), METH_NOARGS, nullptr},
    {"reloadBypassCache", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_reloadBypassCache), METH_NOARGS, nullptr},
    {"removeActions", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_removeActions), METH_O, nullptr},
    {"requestHtmlFullScreen", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_requestHtmlFullScreen), METH_VARARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_resizeEvent), METH_O, nullptr},
    {"saveSideBarSettings", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_saveSideBarSettings), METH_NOARGS, nullptr},
    {"setStartPage", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_setStartPage), METH_O, nullptr},
    {"setStartTab", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_setStartTab), METH_O, nullptr},
    {"setWindowTitle", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_setWindowTitle), METH_O, nullptr},
    {"showHistoryManager", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_showHistoryManager), METH_NOARGS, nullptr},
    {"showNavigationWithFullScreen", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_showNavigationWithFullScreen), METH_NOARGS, nullptr},
    {"showSource", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_showSource), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"showWebInspector", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_showWebInspector), METH_NOARGS, nullptr},
    {"sideBarManager", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_sideBarManager), METH_NOARGS, nullptr},
    {"statusBar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_statusBar), METH_NOARGS, nullptr},
    {"superMenu", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_superMenu), METH_NOARGS, nullptr},
    {"tabCount", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_tabCount), METH_NOARGS, nullptr},
    {"tabModel", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_tabModel), METH_NOARGS, nullptr},
    {"tabMruModel", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_tabMruModel), METH_NOARGS, nullptr},
    {"tabWidget", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_tabWidget), METH_NOARGS, nullptr},
    {"toggleFullScreen", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleFullScreen), METH_NOARGS, nullptr},
    {"toggleShowBookmarksToolbar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleShowBookmarksToolbar), METH_NOARGS, nullptr},
    {"toggleShowMenubar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleShowMenubar), METH_NOARGS, nullptr},
    {"toggleShowNavigationToolbar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleShowNavigationToolbar), METH_NOARGS, nullptr},
    {"toggleShowStatusBar", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleShowStatusBar), METH_NOARGS, nullptr},
    {"toggleTabsOnTop", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleTabsOnTop), METH_O, nullptr},
    {"toggleWebInspector", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_toggleWebInspector), METH_NOARGS, nullptr},
    {"updateLoadingActions", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_updateLoadingActions), METH_NOARGS, nullptr},
    {"useTabNumberShortcuts", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_useTabNumberShortcuts), METH_NOARGS, nullptr},
    {"weView", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_weView), METH_VARARGS, nullptr},
    {"windowType", reinterpret_cast<PyCFunction>(Sbk_BrowserWindowFunc_windowType), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_BrowserWindow_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::BrowserWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<BrowserWindowWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_BrowserWindow_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BrowserWindow_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_BrowserWindowSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::BrowserWindow *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX]))
        return static_cast< ::QMainWindow *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BrowserWindow_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_BrowserWindow_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BrowserWindow_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BrowserWindow_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BrowserWindow_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BrowserWindow_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BrowserWindow_spec = {
    "1:PyFalkon.BrowserWindow",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BrowserWindow_slots
};

} //extern "C"

static void *Sbk_BrowserWindow_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::BrowserWindow *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::BrowserWindow *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::BrowserWindow *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BrowserWindow_PythonToCpp_BrowserWindow_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BrowserWindow_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BrowserWindow_PythonToCpp_BrowserWindow_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BrowserWindow_TypeF()))
        return BrowserWindow_PythonToCpp_BrowserWindow_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BrowserWindow_PTR_CppToPython_BrowserWindow(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::BrowserWindow *>(const_cast<void *>(cppIn)), Sbk_BrowserWindow_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BrowserWindow_SignatureStrings[] = {
    "PyFalkon.BrowserWindow(self,type:PyFalkon.Qz.BrowserWindowType,urls:QList[PySide6.QtCore.QUrl]={})",
    "PyFalkon.BrowserWindow.action(self,name:QString)->PySide6.QtGui.QAction",
    "PyFalkon.BrowserWindow.addBookmark(self,url:typing.Union[PySide6.QtCore.QUrl, QString],title:QString)",
    "PyFalkon.BrowserWindow.addDeleteOnCloseWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "PyFalkon.BrowserWindow.addTab(self)",
    "PyFalkon.BrowserWindow.bookmarkAllTabs(self)",
    "PyFalkon.BrowserWindow.bookmarkPage(self)",
    "PyFalkon.BrowserWindow.closeEvent(self,event:PySide6.QtGui.QCloseEvent)",
    "PyFalkon.BrowserWindow.createEncodingMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "PyFalkon.BrowserWindow.createSidebarsMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "PyFalkon.BrowserWindow.createToolbarsMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "PyFalkon.BrowserWindow.currentTabChanged(self)",
    "PyFalkon.BrowserWindow.event(self,event:PySide6.QtCore.QEvent)->bool",
    "PyFalkon.BrowserWindow.fullScreenNavigationVisible(self)->bool",
    "PyFalkon.BrowserWindow.goBack(self)",
    "PyFalkon.BrowserWindow.goForward(self)",
    "PyFalkon.BrowserWindow.goHome(self)",
    "PyFalkon.BrowserWindow.goHomeInNewTab(self)",
    "PyFalkon.BrowserWindow.hideNavigationWithFullScreen(self)",
    "PyFalkon.BrowserWindow.homepageUrl(self)->PySide6.QtCore.QUrl",
    "PyFalkon.BrowserWindow.ipLabel(self)->PySide6.QtWidgets.QLabel",
    "PyFalkon.BrowserWindow.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.BrowserWindow.keyReleaseEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.BrowserWindow.loadActionUrl(self,obj:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.BrowserWindow.loadActionUrlInNewTab(self,obj:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.BrowserWindow.loadAddress(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "PyFalkon.BrowserWindow.locationBar(self)->PyFalkon.LocationBar",
    "PyFalkon.BrowserWindow.navigationBar(self)->PyFalkon.NavigationBar",
    "PyFalkon.BrowserWindow.reload(self)",
    "PyFalkon.BrowserWindow.reloadBypassCache(self)",
    "PyFalkon.BrowserWindow.removeActions(self,actions:QList[PySide6.QtGui.QAction])",
    "PyFalkon.BrowserWindow.requestHtmlFullScreen(self,view:PyFalkon.TabbedWebView,enable:bool)",
    "PyFalkon.BrowserWindow.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "PyFalkon.BrowserWindow.saveSideBarSettings(self)",
    "PyFalkon.BrowserWindow.setStartPage(self,page:PyFalkon.WebPage)",
    "PyFalkon.BrowserWindow.setStartTab(self,tab:PyFalkon.WebTab)",
    "PyFalkon.BrowserWindow.setWindowTitle(self,t:QString)",
    "PyFalkon.BrowserWindow.showHistoryManager(self)",
    "PyFalkon.BrowserWindow.showNavigationWithFullScreen(self)",
    "PyFalkon.BrowserWindow.showSource(self,view:PyFalkon.WebView=nullptr)",
    "PyFalkon.BrowserWindow.showWebInspector(self)",
    "PyFalkon.BrowserWindow.sideBarManager(self)->PyFalkon.SideBarManager",
    "PyFalkon.BrowserWindow.statusBar(self)->PyFalkon.StatusBar",
    "PyFalkon.BrowserWindow.superMenu(self)->PySide6.QtWidgets.QMenu",
    "PyFalkon.BrowserWindow.tabCount(self)->int",
    "PyFalkon.BrowserWindow.tabModel(self)->PyFalkon.TabModel",
    "PyFalkon.BrowserWindow.tabMruModel(self)->PyFalkon.TabMruModel",
    "PyFalkon.BrowserWindow.tabWidget(self)->PyFalkon.TabWidget",
    "PyFalkon.BrowserWindow.toggleFullScreen(self)",
    "PyFalkon.BrowserWindow.toggleShowBookmarksToolbar(self)",
    "PyFalkon.BrowserWindow.toggleShowMenubar(self)",
    "PyFalkon.BrowserWindow.toggleShowNavigationToolbar(self)",
    "PyFalkon.BrowserWindow.toggleShowStatusBar(self)",
    "PyFalkon.BrowserWindow.toggleTabsOnTop(self,enable:bool)",
    "PyFalkon.BrowserWindow.toggleWebInspector(self)",
    "PyFalkon.BrowserWindow.updateLoadingActions(self)",
    "PyFalkon.BrowserWindow.useTabNumberShortcuts(self)->bool",
    "1:PyFalkon.BrowserWindow.weView(self)->PyFalkon.TabbedWebView",
    "0:PyFalkon.BrowserWindow.weView(self,index:int)->PyFalkon.TabbedWebView",
    "PyFalkon.BrowserWindow.windowType(self)->PyFalkon.Qz.BrowserWindowType",
    nullptr}; // Sentinel
#else
static constexpr size_t BrowserWindow_SignatureByteSize = 841;
static constexpr uint8_t BrowserWindow_SignatureBytes[841] = {
    0x78, 0xda, 0xad, 0x57, 0x4d, 0x53, 0xdb, 0x30, 0x10, 0xbd, 0xf3, 0x2b, 0x7a, 0x2c, 0x33, 0x26,
    0xd3, 0x5e, 0x7a, 0xf0, 0x0c, 0xcc, 0x90, 0x14, 0x0a, 0xd3, 0x10, 0x12, 0x0c, 0xe4, 0xd0, 0xe1,
    0x20, 0xdb, 0x8b, 0x23, 0xa2, 0x48, 0xae, 0x24, 0xc7, 0x4d, 0x3b, 0xfd, 0xef, 0x5d, 0x59, 0x8e,
    0x9d, 0x80, 0x65, 0x1b, 0xca, 0xcd, 0x93, 0x7d, 0xef, 0x49, 0xfb, 0xa9, 0xcd, 0x74, 0x73, 0x4e,
    0xd8, 0x52, 0xf0, 0xc1, 0x50, 0x8a, 0x5c, 0x81, 0x9c, 0x53, 0x1e, 0x8b, 0xfc, 0xa3, 0x02, 0xf6,
    0xe8, 0xe9, 0x4d, 0x0a, 0xfe, 0x74, 0x0b, 0x98, 0xfd, 0xde, 0xc7, 0xdc, 0xa2, 0xd5, 0xcb, 0x24,
    0x53, 0xfe, 0x6c, 0x4c, 0x95, 0xfe, 0x31, 0xdd, 0x04, 0x34, 0x86, 0x2f, 0x83, 0x99, 0x1e, 0x09,
    0x09, 0x83, 0xd9, 0x9d, 0x64, 0x0f, 0xc7, 0x7f, 0xfe, 0x1e, 0x1e, 0x4c, 0x1b, 0x8f, 0x18, 0x90,
    0x48, 0x53, 0xc1, 0xed, 0x49, 0x9c, 0xac, 0xc0, 0x9f, 0x05, 0x5a, 0x52, 0x9e, 0x1c, 0x1e, 0x9d,
    0xd4, 0x52, 0xdf, 0x32, 0x3a, 0x98, 0x9d, 0x16, 0x48, 0xa7, 0x4e, 0x1c, 0x0f, 0x85, 0x58, 0xae,
    0x88, 0x5c, 0x5a, 0x31, 0xbc, 0x93, 0x8f, 0x57, 0x47, 0xa9, 0xc1, 0x1d, 0x47, 0x62, 0xd3, 0xcd,
    0xbc, 0x0f, 0xe5, 0x69, 0x0f, 0x9e, 0xa6, 0x9a, 0xd5, 0x87, 0xb7, 0x9c, 0xf2, 0x15, 0x18, 0x68,
    0xb8, 0xe6, 0x23, 0x26, 0x14, 0xcc, 0x69, 0x9c, 0x80, 0xb6, 0x07, 0xe6, 0xc5, 0xb7, 0x5f, 0x1f,
    0x63, 0x8d, 0x6a, 0x30, 0xb3, 0x1f, 0x6d, 0xa2, 0xb7, 0x24, 0x2c, 0x44, 0x9c, 0x98, 0xb0, 0xf4,
    0xed, 0x94, 0x31, 0xc4, 0xaa, 0x7e, 0xe0, 0x29, 0x49, 0xa0, 0x1d, 0x19, 0x19, 0x27, 0xce, 0xd6,
    0xc0, 0x4b, 0x1f, 0xc0, 0x7c, 0xfa, 0xcf, 0x02, 0x3f, 0xaa, 0x40, 0x6e, 0x1d, 0x09, 0x44, 0xc3,
    0x19, 0x8f, 0x44, 0x8c, 0xe1, 0xbb, 0x02, 0x9e, 0x59, 0xbd, 0x15, 0x7e, 0x35, 0x45, 0xc4, 0x20,
    0x3a, 0xc4, 0x0c, 0x27, 0x24, 0x52, 0xbd, 0x8b, 0xd8, 0xad, 0x10, 0xec, 0x3d, 0xc4, 0x32, 0x29,
    0x31, 0x0c, 0x98, 0x81, 0xd1, 0x82, 0xf0, 0x04, 0xe2, 0xf6, 0xe8, 0x82, 0x3b, 0xb0, 0xb6, 0x04,
    0x6d, 0x50, 0x8f, 0x4e, 0x30, 0x61, 0xcc, 0x25, 0xf2, 0x98, 0x31, 0x16, 0xa0, 0x17, 0xc0, 0x27,
    0x64, 0x4d, 0x13, 0x62, 0x9a, 0xe0, 0x9e, 0x2a, 0x1a, 0xb2, 0x32, 0xb7, 0xed, 0xf4, 0x44, 0x0c,
    0x49, 0xb4, 0x6c, 0xbf, 0x67, 0x22, 0xce, 0x85, 0xcc, 0x89, 0x8c, 0xbb, 0x60, 0x17, 0x62, 0x05,
    0x7d, 0x30, 0x97, 0x7c, 0x02, 0x79, 0x67, 0x4d, 0x2f, 0x30, 0x16, 0xb5, 0x4f, 0x73, 0xaa, 0x17,
    0xe7, 0x95, 0xaf, 0x1d, 0x4c, 0x3c, 0x23, 0xc5, 0xe2, 0xc6, 0x16, 0xde, 0xc6, 0xa0, 0xa1, 0xbb,
    0x5d, 0x6c, 0x9a, 0x8e, 0x49, 0x08, 0x0d, 0xcc, 0xaa, 0x08, 0x0a, 0xbb, 0x8b, 0xbe, 0x84, 0xcd,
    0x54, 0x82, 0x52, 0x5d, 0x6d, 0xf3, 0x1d, 0x36, 0xed, 0x4d, 0x83, 0x42, 0x37, 0x38, 0x4c, 0x48,
    0x77, 0x07, 0x76, 0x4a, 0x31, 0x41, 0x62, 0x3b, 0x1f, 0xb7, 0x21, 0xf1, 0x44, 0xf8, 0xf4, 0xa2,
    0xde, 0xae, 0xc3, 0x27, 0x88, 0xf4, 0x31, 0xc7, 0x30, 0xa7, 0x5a, 0xf6, 0x53, 0xdb, 0xcb, 0xe5,
    0x7f, 0xab, 0xc6, 0xb1, 0x09, 0xdd, 0x5b, 0x26, 0x74, 0x8b, 0x6e, 0x54, 0x14, 0xd0, 0x90, 0xc8,
    0x3a, 0xa5, 0x25, 0x72, 0x5c, 0xdb, 0x5c, 0x74, 0x5e, 0x55, 0x60, 0x93, 0xc0, 0x64, 0xd7, 0xea,
    0x92, 0x90, 0x60, 0x7c, 0x6b, 0x2f, 0x59, 0x8b, 0x19, 0x6e, 0x52, 0xa2, 0xd4, 0x88, 0x44, 0x0b,
    0xe8, 0x82, 0xaf, 0xc4, 0x1a, 0x6c, 0x12, 0xca, 0x70, 0xd9, 0x97, 0xf2, 0xe5, 0x3b, 0xbb, 0xf3,
    0x38, 0x3e, 0xb4, 0xe8, 0xfd, 0xcc, 0x40, 0xe9, 0x0b, 0xbd, 0x62, 0xcf, 0x9a, 0xcc, 0x5b, 0x53,
    0xc8, 0xeb, 0xf7, 0x1d, 0x33, 0x1d, 0x42, 0x3c, 0x87, 0xf0, 0x1e, 0x7f, 0xf6, 0x80, 0x13, 0x9c,
    0x33, 0xbe, 0x19, 0x30, 0x2d, 0xd2, 0x8a, 0xfe, 0xee, 0x2c, 0xe1, 0x9b, 0x1a, 0xe5, 0x54, 0x52,
    0x64, 0x5d, 0x8c, 0x7d, 0x0c, 0x75, 0x00, 0x5a, 0x63, 0xd6, 0x3b, 0x1e, 0x3a, 0x05, 0x3a, 0xd0,
    0x44, 0xea, 0xea, 0xa1, 0xf3, 0xcc, 0x54, 0xa8, 0x9d, 0x41, 0x37, 0x8c, 0xa9, 0x93, 0x5f, 0x95,
    0xb7, 0x26, 0xe1, 0x1e, 0x1b, 0x0d, 0x6d, 0xe4, 0x72, 0x05, 0x32, 0xab, 0x43, 0xc9, 0xef, 0xdc,
    0x20, 0xd4, 0x42, 0xe4, 0x17, 0x98, 0x40, 0x21, 0x37, 0x57, 0x84, 0xe3, 0xe5, 0x64, 0x87, 0x8b,
    0x88, 0x7f, 0xdb, 0x90, 0x34, 0xcc, 0x40, 0x64, 0x32, 0x82, 0xa6, 0x3c, 0x97, 0x19, 0xee, 0xec,
    0x5a, 0xa3, 0x82, 0xd8, 0x4b, 0xae, 0x52, 0x6c, 0x72, 0xd1, 0x75, 0x5b, 0x9b, 0xbd, 0x3d, 0xcf,
    0x76, 0xba, 0x29, 0xd8, 0x33, 0x3b, 0x45, 0x34, 0xd1, 0x99, 0x6a, 0xea, 0xc6, 0x60, 0x6b, 0x71,
    0x52, 0xb3, 0x14, 0x64, 0xf5, 0xc8, 0x37, 0x0f, 0x77, 0x63, 0x76, 0xf1, 0x31, 0xff, 0x23, 0x91,
    0x95, 0x85, 0x8c, 0x74, 0xca, 0x75, 0x0b, 0xf4, 0x4a, 0xc4, 0xbb, 0xcf, 0x48, 0xdd, 0x41, 0x85,
    0xa1, 0x8d, 0x28, 0x33, 0x37, 0xb7, 0xb4, 0xb5, 0xd0, 0x77, 0xb6, 0xce, 0x67, 0x64, 0x6b, 0x71,
    0x52, 0x45, 0x92, 0x30, 0xe8, 0x5b, 0x3f, 0x16, 0x1d, 0x60, 0xfe, 0xb7, 0x8b, 0xb5, 0x2a, 0xd7,
    0xa8, 0xbe, 0x3c, 0x13, 0xe9, 0x57, 0xc0, 0xeb, 0x32, 0x7f, 0xe5, 0x39, 0xc1, 0x7e, 0xc1, 0xb4,
    0x13, 0xcc, 0xfa, 0x7c, 0x8d, 0x27, 0xa4, 0xe5, 0xb0, 0xea, 0x31, 0xe1, 0x2c, 0xb1, 0x7f, 0x17,
    0x64, 0x69, 0x8c, 0x3b, 0xe7, 0x18, 0xe7, 0x3d, 0x4e, 0x82, 0xdd, 0x19, 0xee, 0x66, 0x28, 0x73,
    0xaf, 0x49, 0xb6, 0x0a, 0x41, 0xa2, 0x47, 0x52, 0x47, 0x99, 0x56, 0x7b, 0xeb, 0xdd, 0x67, 0xdf,
    0x41, 0xcd, 0xc1, 0xf4, 0x71, 0x53, 0x31, 0xd4, 0x73, 0xfc, 0xe0, 0x53, 0x0f, 0xb6, 0x87, 0xbf,
    0xc0, 0x2f, 0x9f, 0x16, 0x1b, 0xa9, 0x43, 0xc7, 0xa5, 0x52, 0xfd, 0x15, 0x7c, 0x71, 0x8f, 0xa6,
    0xff, 0x8b, 0x07, 0xff, 0x00, 0x62, 0xb8, 0x5e, 0xd7
};
#endif

PyTypeObject *init_BrowserWindow(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX].type;

    Shiboken::AutoDecRef Sbk_BrowserWindow_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX]))));

    _Sbk_BrowserWindow_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BrowserWindow",
        "BrowserWindow*",
        &Sbk_BrowserWindow_spec,
        &Shiboken::callCppDestructor< BrowserWindow >,
        Sbk_BrowserWindow_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_BrowserWindow_TypeF(); // references _Sbk_BrowserWindow_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BrowserWindow_SignatureStrings);
#else
    InitSignatureBytes(pyType, BrowserWindow_SignatureBytes, BrowserWindow_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BrowserWindow_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BrowserWindow_PythonToCpp_BrowserWindow_PTR,
        is_BrowserWindow_PythonToCpp_BrowserWindow_PTR_Convertible,
        BrowserWindow_PTR_CppToPython_BrowserWindow);

    Shiboken::Conversions::registerConverterName(converter, "BrowserWindow");
    Shiboken::Conversions::registerConverterName(converter, "BrowserWindow*");
    Shiboken::Conversions::registerConverterName(converter, "BrowserWindow&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BrowserWindow).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(BrowserWindowWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_BrowserWindow_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_BrowserWindow_TypeF(), &Sbk_BrowserWindowSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_BrowserWindow_TypeF(), &Sbk_BrowserWindow_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::BrowserWindow::staticMetaObject);
    BrowserWindowWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::BrowserWindow::staticMetaObject, sizeof(BrowserWindowWrapper));

    return pyType;
}
