
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "searchenginesmanager_engine_wrapper.h"

// Argument includes
#include <searchenginesmanager.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SearchEnginesManager_Engine_Type = nullptr;
static PyTypeObject *Sbk_SearchEnginesManager_Engine_TypeF(void)
{
    return _Sbk_SearchEnginesManager_Engine_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SearchEnginesManager_Engine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SearchEnginesManager::Engine >()))
        return -1;

    ::SearchEnginesManager::Engine *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Engine", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Engine::Engine()
    // 1: Engine::Engine(SearchEnginesManager::Engine)
    if (numArgs == 0) {
        overloadId = 0; // Engine()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Engine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Engine()
        {

            // Engine()
            cptr = new ::SearchEnginesManager::Engine();
            break;
        }
        case 1: // Engine(const SearchEnginesManager::Engine &Engine)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::SearchEnginesManager::Engine cppArg0_local;
            ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // Engine(SearchEnginesManager::Engine)
                cptr = new ::SearchEnginesManager::Engine(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::SearchEnginesManager::Engine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_SearchEnginesManager_EngineFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::SearchEnginesManager::Engine *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManager_Engine__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_SearchEnginesManager_Engine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SearchEnginesManager_Engine_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManager_EngineFunc_isValid), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManager_Engine__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_SearchEnginesManager_Engine_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArg)))) {
                // operator==(const SearchEnginesManager::Engine &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::SearchEnginesManager::Engine cppArg0_local;
                ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_name(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->name);
}
static int Sbk_SearchEnginesManager_Engine_set_name(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("name");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("name", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->name;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_icon(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->icon), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_icon(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("icon");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("icon", "QIcon");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_url(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->url);
}
static int Sbk_SearchEnginesManager_Engine_set_url(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("url");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("url", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->url;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_shortcut(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->shortcut);
}
static int Sbk_SearchEnginesManager_Engine_set_shortcut(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("shortcut");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("shortcut", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->shortcut;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_suggestionsUrl(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->suggestionsUrl);
}
static int Sbk_SearchEnginesManager_Engine_set_suggestionsUrl(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("suggestionsUrl");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("suggestionsUrl", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->suggestionsUrl;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_suggestionsParameters(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->suggestionsParameters), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->suggestionsParameters), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_suggestionsParameters(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("suggestionsParameters");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("suggestionsParameters", "QByteArray");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->suggestionsParameters;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_postData(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->postData), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->postData), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_postData(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("postData");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("postData", "QByteArray");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->postData;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Engine
static PyGetSetDef Sbk_SearchEnginesManager_Engine_getsetlist[] = {
    {"name", Sbk_SearchEnginesManager_Engine_get_name, Sbk_SearchEnginesManager_Engine_set_name, "QString", nullptr},
    {"icon", Sbk_SearchEnginesManager_Engine_get_icon, Sbk_SearchEnginesManager_Engine_set_icon, "PySide6.QtGui.QIcon", nullptr},
    {"url", Sbk_SearchEnginesManager_Engine_get_url, Sbk_SearchEnginesManager_Engine_set_url, "QString", nullptr},
    {"shortcut", Sbk_SearchEnginesManager_Engine_get_shortcut, Sbk_SearchEnginesManager_Engine_set_shortcut, "QString", nullptr},
    {"suggestionsUrl", Sbk_SearchEnginesManager_Engine_get_suggestionsUrl, Sbk_SearchEnginesManager_Engine_set_suggestionsUrl, "QString", nullptr},
    {"suggestionsParameters", Sbk_SearchEnginesManager_Engine_get_suggestionsParameters, Sbk_SearchEnginesManager_Engine_set_suggestionsParameters, "PySide6.QtCore.QByteArray", nullptr},
    {"postData", Sbk_SearchEnginesManager_Engine_get_postData, Sbk_SearchEnginesManager_Engine_set_postData, "PySide6.QtCore.QByteArray", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_SearchEnginesManager_Engine_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SearchEnginesManager_Engine_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SearchEnginesManager_Engine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SearchEnginesManager_Engine_spec = {
    "1:PyFalkon.SearchEnginesManager.Engine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SearchEnginesManager_Engine_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Engine_PythonToCpp_Engine_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SearchEnginesManager_Engine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Engine_PythonToCpp_Engine_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SearchEnginesManager_Engine_TypeF()))
        return Engine_PythonToCpp_Engine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Engine_PTR_CppToPython_Engine(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_SearchEnginesManager_Engine_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_SearchEnginesManager_Engine_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *Engine_COPY_CppToPython_Engine(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::SearchEnginesManager::Engine *>(cppIn);
    return Shiboken::Object::newObject(Sbk_SearchEnginesManager_Engine_TypeF(), new ::SearchEnginesManager::Engine(*source), true, true);
}

// Python to C++ copy conversion.
static void Engine_PythonToCpp_Engine_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::SearchEnginesManager::Engine *>(cppOut) = *reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Engine_PythonToCpp_Engine_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_SearchEnginesManager_Engine_TypeF()))
        return Engine_PythonToCpp_Engine_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SearchEnginesManager_Engine_SignatureStrings[] = {
    "1:PyFalkon.SearchEnginesManager.Engine(self)",
    "0:PyFalkon.SearchEnginesManager.Engine(self,Engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.Engine.isValid(self)->bool",
    "PyFalkon.SearchEnginesManager.Engine.__copy__(self)->typing._Self",
    "PyFalkon.SearchEnginesManager.Engine.__eq__(self,other:PyFalkon.SearchEnginesManager.Engine)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t SearchEnginesManager_Engine_SignatureByteSize = 118;
static constexpr uint8_t SearchEnginesManager_Engine_SignatureBytes[118] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x4e, 0x4d,
    0x2c, 0x4a, 0xce, 0x70, 0xcd, 0x4b, 0xcf, 0xcc, 0x4b, 0x2d, 0xf6, 0x4d, 0xcc, 0x4b, 0x4c, 0x4f,
    0x2d, 0xd2, 0x83, 0x70, 0x35, 0x8a, 0x53, 0x73, 0xd2, 0x34, 0xb9, 0x0c, 0x88, 0x57, 0xac, 0x03,
    0x61, 0x13, 0xa5, 0x41, 0x93, 0x8b, 0x18, 0x55, 0x7a, 0x99, 0xc5, 0x61, 0x89, 0x39, 0x99, 0x29,
    0x10, 0xb7, 0xe8, 0xda, 0x25, 0xe5, 0xe7, 0xe7, 0x10, 0xa7, 0x31, 0x3e, 0x3e, 0x39, 0xbf, 0xa0,
    0x32, 0x3e, 0x1e, 0xa6, 0xb3, 0xa4, 0xb2, 0x20, 0x33, 0x2f, 0x5d, 0x2f, 0x3e, 0x18, 0xc8, 0x25,
    0xd6, 0x84, 0xd4, 0x42, 0xa8, 0x7e, 0x9d, 0xfc, 0x92, 0x8c, 0xd4, 0x22, 0xe2, 0xfc, 0x05, 0x75,
    0x24, 0x00, 0xb3, 0xd9, 0x82, 0x2d
};
#endif

PyTypeObject *init_SearchEnginesManager_Engine(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX].type;

    Shiboken::AutoDecRef Sbk_SearchEnginesManager_Engine_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_SearchEnginesManager_Engine_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Engine",
        "SearchEnginesManager::Engine",
        &Sbk_SearchEnginesManager_Engine_spec,
        &Shiboken::callCppDestructor< ::SearchEnginesManager::Engine >,
        Sbk_SearchEnginesManager_Engine_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_SearchEnginesManager_Engine_Type; // references _Sbk_SearchEnginesManager_Engine_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SearchEnginesManager_Engine_SignatureStrings);
#else
    InitSignatureBytes(pyType, SearchEnginesManager_Engine_SignatureBytes, SearchEnginesManager_Engine_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SearchEnginesManager_Engine_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Engine_PythonToCpp_Engine_PTR,
        is_Engine_PythonToCpp_Engine_PTR_Convertible,
        Engine_PTR_CppToPython_Engine,
        Engine_COPY_CppToPython_Engine);

    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager::Engine");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager::Engine*");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager::Engine&");
    Shiboken::Conversions::registerConverterAlias(converter, "Engine");
    Shiboken::Conversions::registerConverterAlias(converter, "Engine*");
    Shiboken::Conversions::registerConverterAlias(converter, "Engine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SearchEnginesManager::Engine).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Engine_PythonToCpp_Engine_COPY,
        is_Engine_PythonToCpp_Engine_COPY_Convertible);

    qRegisterMetaType< ::SearchEnginesManager::Engine >("Engine");
    qRegisterMetaType< ::SearchEnginesManager::Engine >("SearchEnginesManager::Engine");

    return pyType;
}
