#pragma once
#include <stdint.h>
#include <stdbool.h>

struct emoji_vs {
    uint32_t start:21;
    uint32_t end:21;
    bool vs15:1;
    bool vs16:1;
} __attribute__((packed));
_Static_assert(sizeof(struct emoji_vs) == 6, "unexpected struct size");

#if defined(FOOT_GRAPHEME_CLUSTERING)

static const struct emoji_vs emoji_vs[183] = {
    {
        .start = 0x23,
        .end = 0x23,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2A,
        .end = 0x2a,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x30,
        .end = 0x39,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0xA9,
        .end = 0xa9,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0xAE,
        .end = 0xae,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x203C,
        .end = 0x203c,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2049,
        .end = 0x2049,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2122,
        .end = 0x2122,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2139,
        .end = 0x2139,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2194,
        .end = 0x2199,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x21A9,
        .end = 0x21aa,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x231A,
        .end = 0x231b,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2328,
        .end = 0x2328,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x23CF,
        .end = 0x23cf,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x23E9,
        .end = 0x23f3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x23F8,
        .end = 0x23fa,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x24C2,
        .end = 0x24c2,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x25AA,
        .end = 0x25ab,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x25B6,
        .end = 0x25b6,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x25C0,
        .end = 0x25c0,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x25FB,
        .end = 0x25fe,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2600,
        .end = 0x2604,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x260E,
        .end = 0x260e,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2611,
        .end = 0x2611,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2614,
        .end = 0x2615,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2618,
        .end = 0x2618,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x261D,
        .end = 0x261d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2620,
        .end = 0x2620,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2622,
        .end = 0x2623,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2626,
        .end = 0x2626,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x262A,
        .end = 0x262a,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x262E,
        .end = 0x262f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2638,
        .end = 0x263a,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2640,
        .end = 0x2640,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2642,
        .end = 0x2642,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2648,
        .end = 0x2653,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x265F,
        .end = 0x2660,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2663,
        .end = 0x2663,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2665,
        .end = 0x2666,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2668,
        .end = 0x2668,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x267B,
        .end = 0x267b,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x267E,
        .end = 0x267f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2692,
        .end = 0x2697,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2699,
        .end = 0x2699,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x269B,
        .end = 0x269c,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26A0,
        .end = 0x26a1,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26A7,
        .end = 0x26a7,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26AA,
        .end = 0x26ab,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26B0,
        .end = 0x26b1,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26BD,
        .end = 0x26be,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26C4,
        .end = 0x26c5,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26C8,
        .end = 0x26c8,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26CE,
        .end = 0x26cf,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26D1,
        .end = 0x26d1,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26D3,
        .end = 0x26d4,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26E9,
        .end = 0x26ea,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26F0,
        .end = 0x26f5,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26F7,
        .end = 0x26fa,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x26FD,
        .end = 0x26fd,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2702,
        .end = 0x2702,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2705,
        .end = 0x2705,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2708,
        .end = 0x270d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x270F,
        .end = 0x270f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2712,
        .end = 0x2712,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2714,
        .end = 0x2714,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2716,
        .end = 0x2716,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x271D,
        .end = 0x271d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2721,
        .end = 0x2721,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2728,
        .end = 0x2728,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2733,
        .end = 0x2734,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2744,
        .end = 0x2744,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2747,
        .end = 0x2747,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x274C,
        .end = 0x274c,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x274E,
        .end = 0x274e,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2753,
        .end = 0x2755,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2757,
        .end = 0x2757,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2763,
        .end = 0x2764,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2795,
        .end = 0x2797,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x27A1,
        .end = 0x27a1,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x27B0,
        .end = 0x27b0,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x27BF,
        .end = 0x27bf,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2934,
        .end = 0x2935,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2B05,
        .end = 0x2b07,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2B1B,
        .end = 0x2b1c,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2B50,
        .end = 0x2b50,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x2B55,
        .end = 0x2b55,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x3030,
        .end = 0x3030,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x303D,
        .end = 0x303d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x3297,
        .end = 0x3297,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x3299,
        .end = 0x3299,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F004,
        .end = 0x1f004,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F170,
        .end = 0x1f171,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F17E,
        .end = 0x1f17f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F202,
        .end = 0x1f202,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F21A,
        .end = 0x1f21a,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F22F,
        .end = 0x1f22f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F237,
        .end = 0x1f237,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F30D,
        .end = 0x1f30f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F315,
        .end = 0x1f315,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F31C,
        .end = 0x1f31c,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F321,
        .end = 0x1f321,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F324,
        .end = 0x1f32c,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F336,
        .end = 0x1f336,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F378,
        .end = 0x1f378,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F37D,
        .end = 0x1f37d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F393,
        .end = 0x1f393,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F396,
        .end = 0x1f397,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F399,
        .end = 0x1f39b,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F39E,
        .end = 0x1f39f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3A7,
        .end = 0x1f3a7,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3AC,
        .end = 0x1f3ae,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3C2,
        .end = 0x1f3c2,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3C4,
        .end = 0x1f3c4,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3C6,
        .end = 0x1f3c6,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3CA,
        .end = 0x1f3ce,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3D4,
        .end = 0x1f3e0,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3ED,
        .end = 0x1f3ed,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3F3,
        .end = 0x1f3f3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3F5,
        .end = 0x1f3f5,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F3F7,
        .end = 0x1f3f7,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F408,
        .end = 0x1f408,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F415,
        .end = 0x1f415,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F41F,
        .end = 0x1f41f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F426,
        .end = 0x1f426,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F43F,
        .end = 0x1f43f,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F441,
        .end = 0x1f442,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F446,
        .end = 0x1f449,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F44D,
        .end = 0x1f44e,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F453,
        .end = 0x1f453,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F46A,
        .end = 0x1f46a,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F47D,
        .end = 0x1f47d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4A3,
        .end = 0x1f4a3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4B0,
        .end = 0x1f4b0,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4B3,
        .end = 0x1f4b3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4BB,
        .end = 0x1f4bb,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4BF,
        .end = 0x1f4bf,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4CB,
        .end = 0x1f4cb,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4DA,
        .end = 0x1f4da,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4DF,
        .end = 0x1f4df,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4E4,
        .end = 0x1f4e6,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4EA,
        .end = 0x1f4ed,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4F7,
        .end = 0x1f4f7,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4F9,
        .end = 0x1f4fb,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F4FD,
        .end = 0x1f4fd,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F508,
        .end = 0x1f508,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F50D,
        .end = 0x1f50d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F512,
        .end = 0x1f513,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F549,
        .end = 0x1f54a,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F550,
        .end = 0x1f567,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F56F,
        .end = 0x1f570,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F573,
        .end = 0x1f579,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F587,
        .end = 0x1f587,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F58A,
        .end = 0x1f58d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F590,
        .end = 0x1f590,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5A5,
        .end = 0x1f5a5,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5A8,
        .end = 0x1f5a8,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5B1,
        .end = 0x1f5b2,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5BC,
        .end = 0x1f5bc,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5C2,
        .end = 0x1f5c4,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5D1,
        .end = 0x1f5d3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5DC,
        .end = 0x1f5de,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5E1,
        .end = 0x1f5e1,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5E3,
        .end = 0x1f5e3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5E8,
        .end = 0x1f5e8,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5EF,
        .end = 0x1f5ef,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5F3,
        .end = 0x1f5f3,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F5FA,
        .end = 0x1f5fa,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F610,
        .end = 0x1f610,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F687,
        .end = 0x1f687,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F68D,
        .end = 0x1f68d,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F691,
        .end = 0x1f691,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F694,
        .end = 0x1f694,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F698,
        .end = 0x1f698,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6AD,
        .end = 0x1f6ad,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6B2,
        .end = 0x1f6b2,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6B9,
        .end = 0x1f6ba,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6BC,
        .end = 0x1f6bc,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6CB,
        .end = 0x1f6cb,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6CD,
        .end = 0x1f6cf,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6E0,
        .end = 0x1f6e5,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6E9,
        .end = 0x1f6e9,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6F0,
        .end = 0x1f6f0,
        .vs15 = true,
        .vs16 = true,
    },
    {
        .start = 0x1F6F3,
        .end = 0x1f6f3,
        .vs15 = true,
        .vs16 = true,
    },
};

#endif  /* FOOT_GRAPHEME_CLUSTERING */
