/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-kinetic-dp-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_kinetic_dp_family_to_string(FuKineticDpFamily val)
{
    if (val == FU_KINETIC_DP_FAMILY_UNKNOWN)
        return "unknown";
    if (val == FU_KINETIC_DP_FAMILY_MUSTANG)
        return "mustang";
    if (val == FU_KINETIC_DP_FAMILY_JAGUAR)
        return "jaguar";
    if (val == FU_KINETIC_DP_FAMILY_PUMA)
        return "puma";
    return NULL;
}

const gchar *
fu_kinetic_dp_chip_to_string(FuKineticDpChip val)
{
    if (val == FU_KINETIC_DP_CHIP_NONE)
        return "none";
    if (val == FU_KINETIC_DP_CHIP_BOBCAT_2800)
        return "bobcat-2800";
    if (val == FU_KINETIC_DP_CHIP_BOBCAT_2850)
        return "bobcat-2850";
    if (val == FU_KINETIC_DP_CHIP_PEGASUS)
        return "pegasus";
    if (val == FU_KINETIC_DP_CHIP_MYSTIQUE)
        return "mystique";
    if (val == FU_KINETIC_DP_CHIP_DP2VGA)
        return "dp2vga";
    if (val == FU_KINETIC_DP_CHIP_PUMA_2900)
        return "puma-2900";
    if (val == FU_KINETIC_DP_CHIP_PUMA_2920)
        return "puma-2920";
    if (val == FU_KINETIC_DP_CHIP_JAGUAR_5000)
        return "jaguar-5000";
    if (val == FU_KINETIC_DP_CHIP_MUSTANG_5200)
        return "mustang-5200";
    return NULL;
}


const gchar *
fu_kinetic_dp_bank_to_string(FuKineticDpBank val)
{
    if (val == FU_KINETIC_DP_BANK_A)
        return "a";
    if (val == FU_KINETIC_DP_BANK_B)
        return "b";
    if (val == FU_KINETIC_DP_BANK_NONE)
        return "none";
    return NULL;
}


const gchar *
fu_kinetic_dp_fw_state_to_string(FuKineticDpFwState val)
{
    if (val == FU_KINETIC_DP_FW_STATE_NONE)
        return "none";
    if (val == FU_KINETIC_DP_FW_STATE_IROM)
        return "irom";
    if (val == FU_KINETIC_DP_FW_STATE_BOOT_CODE)
        return "boot-code";
    if (val == FU_KINETIC_DP_FW_STATE_APP)
        return "app";
    return NULL;
}

const gchar *
fu_kinetic_dp_puma_mode_to_string(FuKineticDpPumaMode val)
{
    if (val == FU_KINETIC_DP_PUMA_MODE_CHUNK_PROCESSED)
        return "chunk-processed";
    if (val == FU_KINETIC_DP_PUMA_MODE_CHUNK_RECEIVED)
        return "chunk-received";
    if (val == FU_KINETIC_DP_PUMA_MODE_FLASH_INFO_READY)
        return "flash-info-ready";
    if (val == FU_KINETIC_DP_PUMA_MODE_UPDATE_ABORT)
        return "update-abort";
    return NULL;
}


const gchar *
fu_kinetic_dp_dpcd_to_string(FuKineticDpDpcd val)
{
    if (val == FU_KINETIC_DP_DPCD_CMD_STS_NONE)
        return "cmd-sts-none";
    if (val == FU_KINETIC_DP_DPCD_STS_INVALID_INFO)
        return "sts-invalid-info";
    if (val == FU_KINETIC_DP_DPCD_STS_CRC_FAILURE)
        return "sts-crc-failure";
    if (val == FU_KINETIC_DP_DPCD_STS_INVALID_IMAGE)
        return "sts-invalid-image";
    if (val == FU_KINETIC_DP_DPCD_STS_SECURE_ENABLED)
        return "sts-secure-enabled";
    if (val == FU_KINETIC_DP_DPCD_STS_SECURE_DISABLED)
        return "sts-secure-disabled";
    if (val == FU_KINETIC_DP_DPCD_STS_SPI_FLASH_FAILURE)
        return "sts-spi-flash-failure";
    if (val == FU_KINETIC_DP_DPCD_CMD_PREPARE_FOR_ISP_MODE)
        return "cmd-prepare-for-isp-mode";
    if (val == FU_KINETIC_DP_DPCD_CMD_ENTER_CODE_LOADING_MODE)
        return "cmd-enter-code-loading-mode";
    if (val == FU_KINETIC_DP_DPCD_CMD_EXECUTE_RAM_CODE)
        return "cmd-execute-ram-code";
    if (val == FU_KINETIC_DP_DPCD_CMD_ENTER_FW_UPDATE_MODE)
        return "cmd-enter-fw-update-mode";
    if (val == FU_KINETIC_DP_DPCD_CMD_CHUNK_DATA_PROCESSED)
        return "cmd-chunk-data-processed";
    if (val == FU_KINETIC_DP_DPCD_CMD_INSTALL_IMAGES)
        return "cmd-install-images";
    if (val == FU_KINETIC_DP_DPCD_CMD_RESET_SYSTEM)
        return "cmd-reset-system";
    if (val == FU_KINETIC_DP_DPCD_CMD_ENABLE_AUX_FORWARD)
        return "cmd-enable-aux-forward";
    if (val == FU_KINETIC_DP_DPCD_CMD_DISABLE_AUX_FORWARD)
        return "cmd-disable-aux-forward";
    if (val == FU_KINETIC_DP_DPCD_CMD_GET_ACTIVE_FLASH_BANK)
        return "cmd-get-active-flash-bank";
    if (val == FU_KINETIC_DP_DPCD_CMD_RESERVED)
        return "cmd-reserved";
    return NULL;
}
/**
 * fu_struct_kinetic_dp_puma_header_ref: (skip):
 **/
FuStructKineticDpPumaHeader *
fu_struct_kinetic_dp_puma_header_ref(FuStructKineticDpPumaHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_kinetic_dp_puma_header_unref: (skip):
 **/
void
fu_struct_kinetic_dp_puma_header_unref(FuStructKineticDpPumaHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructKineticDpPumaHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructKineticDpPumaHeader *
fu_struct_kinetic_dp_puma_header_new_internal(void)
{
    FuStructKineticDpPumaHeader *st = g_new0(FuStructKineticDpPumaHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_kinetic_dp_puma_header_get_object_count: (skip):
 **/
static guint8
fu_struct_kinetic_dp_puma_header_get_object_count(const FuStructKineticDpPumaHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_kinetic_dp_puma_header_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_puma_header_to_string(const FuStructKineticDpPumaHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructKineticDpPumaHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_kinetic_dp_puma_header_validate_internal(FuStructKineticDpPumaHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_kinetic_dp_puma_header_get_object_count(st) != 8) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructKineticDpPumaHeader.object_count was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_kinetic_dp_puma_header_parse_internal(FuStructKineticDpPumaHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_kinetic_dp_puma_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_kinetic_dp_puma_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_kinetic_dp_puma_header_parse_stream: (skip):
 **/
FuStructKineticDpPumaHeader *
fu_struct_kinetic_dp_puma_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructKineticDpPumaHeader) st = fu_struct_kinetic_dp_puma_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 2, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructKineticDpPumaHeader failed read of 0x%x: ", (guint) 2);
        return NULL;
    }
    if (st->buf->len != 2) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructKineticDpPumaHeader requested 0x%x and got 0x%x",
                    (guint) 2,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_kinetic_dp_puma_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_kinetic_dp_puma_header_info_ref: (skip):
 **/
FuStructKineticDpPumaHeaderInfo *
fu_struct_kinetic_dp_puma_header_info_ref(FuStructKineticDpPumaHeaderInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_kinetic_dp_puma_header_info_unref: (skip):
 **/
void
fu_struct_kinetic_dp_puma_header_info_unref(FuStructKineticDpPumaHeaderInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructKineticDpPumaHeaderInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructKineticDpPumaHeaderInfo *
fu_struct_kinetic_dp_puma_header_info_new_internal(void)
{
    FuStructKineticDpPumaHeaderInfo *st = g_new0(FuStructKineticDpPumaHeaderInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_kinetic_dp_puma_header_info_get_type: (skip):
 **/
guint8
fu_struct_kinetic_dp_puma_header_info_get_type(const FuStructKineticDpPumaHeaderInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_kinetic_dp_puma_header_info_get_subtype: (skip):
 **/
guint8
fu_struct_kinetic_dp_puma_header_info_get_subtype(const FuStructKineticDpPumaHeaderInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_kinetic_dp_puma_header_info_get_length: (skip):
 **/
guint32
fu_struct_kinetic_dp_puma_header_info_get_length(const FuStructKineticDpPumaHeaderInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_kinetic_dp_puma_header_info_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_puma_header_info_to_string(const FuStructKineticDpPumaHeaderInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructKineticDpPumaHeaderInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_puma_header_info_get_type(st));
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_puma_header_info_get_subtype(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_puma_header_info_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_kinetic_dp_puma_header_info_validate_internal(FuStructKineticDpPumaHeaderInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_kinetic_dp_puma_header_info_parse_internal(FuStructKineticDpPumaHeaderInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_kinetic_dp_puma_header_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_kinetic_dp_puma_header_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_kinetic_dp_puma_header_info_parse_stream: (skip):
 **/
FuStructKineticDpPumaHeaderInfo *
fu_struct_kinetic_dp_puma_header_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructKineticDpPumaHeaderInfo) st = fu_struct_kinetic_dp_puma_header_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 6, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructKineticDpPumaHeaderInfo failed read of 0x%x: ", (guint) 6);
        return NULL;
    }
    if (st->buf->len != 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructKineticDpPumaHeaderInfo requested 0x%x and got 0x%x",
                    (guint) 6,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_kinetic_dp_puma_header_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_ref: (skip):
 **/
FuStructKineticDpJaguarFooter *
fu_struct_kinetic_dp_jaguar_footer_ref(FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_unref: (skip):
 **/
void
fu_struct_kinetic_dp_jaguar_footer_unref(FuStructKineticDpJaguarFooter *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructKineticDpJaguarFooter refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructKineticDpJaguarFooter *
fu_struct_kinetic_dp_jaguar_footer_new_internal(void)
{
    FuStructKineticDpJaguarFooter *st = g_new0(FuStructKineticDpJaguarFooter, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_app_id_struct_ver: (skip):
 **/
guint32
fu_struct_kinetic_dp_jaguar_footer_get_app_id_struct_ver(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_app_id: (skip):
 **/
const guint8 *
fu_struct_kinetic_dp_jaguar_footer_get_app_id(const FuStructKineticDpJaguarFooter *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 4;
    return st->buf->data + 4;
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_app_ver_id: (skip):
 **/
guint32
fu_struct_kinetic_dp_jaguar_footer_get_app_ver_id(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_fw_ver: (skip):
 **/
guint16
fu_struct_kinetic_dp_jaguar_footer_get_fw_ver(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_fw_rev: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_fw_rev(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_project_id: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_project_id(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[15];
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_ver: (skip):
 **/
guint16
fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_ver(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_chip_rev: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_chip_rev(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[18];
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_is_fpga_enabled: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_is_fpga_enabled(const FuStructKineticDpJaguarFooter *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[19];
}

/* setters */
/**
 * fu_struct_kinetic_dp_jaguar_footer_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_jaguar_footer_to_string(const FuStructKineticDpJaguarFooter *st)
{
    g_autoptr(GString) str = g_string_new("FuStructKineticDpJaguarFooter:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  app_id_struct_ver: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_app_id_struct_ver(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_kinetic_dp_jaguar_footer_get_app_id(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  app_id: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  app_ver_id: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_app_ver_id(st));
    g_string_append_printf(str, "  fw_ver: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_fw_ver(st));
    g_string_append_printf(str, "  fw_rev: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_fw_rev(st));
    g_string_append_printf(str, "  customer_fw_project_id: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_project_id(st));
    g_string_append_printf(str, "  customer_fw_ver: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_ver(st));
    g_string_append_printf(str, "  chip_rev: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_chip_rev(st));
    g_string_append_printf(str, "  is_fpga_enabled: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_is_fpga_enabled(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_kinetic_dp_jaguar_footer_validate_internal(FuStructKineticDpJaguarFooter *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_kinetic_dp_jaguar_footer_parse_internal(FuStructKineticDpJaguarFooter *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_kinetic_dp_jaguar_footer_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_kinetic_dp_jaguar_footer_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_parse_stream: (skip):
 **/
FuStructKineticDpJaguarFooter *
fu_struct_kinetic_dp_jaguar_footer_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructKineticDpJaguarFooter) st = fu_struct_kinetic_dp_jaguar_footer_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructKineticDpJaguarFooter failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructKineticDpJaguarFooter requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_kinetic_dp_jaguar_footer_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_kinetic_dp_flash_info_ref: (skip):
 **/
FuStructKineticDpFlashInfo *
fu_struct_kinetic_dp_flash_info_ref(FuStructKineticDpFlashInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_kinetic_dp_flash_info_unref: (skip):
 **/
void
fu_struct_kinetic_dp_flash_info_unref(FuStructKineticDpFlashInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructKineticDpFlashInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructKineticDpFlashInfo *
fu_struct_kinetic_dp_flash_info_new_internal(void)
{
    FuStructKineticDpFlashInfo *st = g_new0(FuStructKineticDpFlashInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_kinetic_dp_flash_info_get_id: (skip):
 **/
guint16
fu_struct_kinetic_dp_flash_info_get_id(const FuStructKineticDpFlashInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_flash_info_get_size: (skip):
 **/
guint16
fu_struct_kinetic_dp_flash_info_get_size(const FuStructKineticDpFlashInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_flash_info_get_erase_time: (skip):
 **/
guint16
fu_struct_kinetic_dp_flash_info_get_erase_time(const FuStructKineticDpFlashInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_kinetic_dp_flash_info_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_flash_info_to_string(const FuStructKineticDpFlashInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructKineticDpFlashInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  id: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_flash_info_get_id(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_flash_info_get_size(st));
    g_string_append_printf(str, "  erase_time: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_flash_info_get_erase_time(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_kinetic_dp_flash_info_validate_internal(FuStructKineticDpFlashInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_kinetic_dp_flash_info_parse_internal(FuStructKineticDpFlashInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_kinetic_dp_flash_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_kinetic_dp_flash_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_kinetic_dp_flash_info_parse: (skip):
 **/
FuStructKineticDpFlashInfo *
fu_struct_kinetic_dp_flash_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructKineticDpFlashInfo) st = fu_struct_kinetic_dp_flash_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructKineticDpFlashInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 6);
    if (!fu_struct_kinetic_dp_flash_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
