/* plugin-actionable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin-actionable.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include "geary-engine.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLUGIN_ACTIONABLE_0_PROPERTY,
	PLUGIN_ACTIONABLE_LABEL_PROPERTY,
	PLUGIN_ACTIONABLE_ICON_NAME_PROPERTY,
	PLUGIN_ACTIONABLE_ACTION_PROPERTY,
	PLUGIN_ACTIONABLE_ACTION_TARGET_PROPERTY,
	PLUGIN_ACTIONABLE_NUM_PROPERTIES
};
static GParamSpec* plugin_actionable_properties[PLUGIN_ACTIONABLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _PluginActionablePrivate {
	gchar* _label;
	gchar* _icon_name;
	GAction* _action;
	GVariant* _action_target;
};

static gint PluginActionable_private_offset;
static gpointer plugin_actionable_parent_class = NULL;

static void plugin_actionable_set_label (PluginActionable* self,
                                  const gchar* value);
static void plugin_actionable_set_icon_name (PluginActionable* self,
                                      const gchar* value);
static void plugin_actionable_set_action (PluginActionable* self,
                                   GAction* value);
static void plugin_actionable_set_action_target (PluginActionable* self,
                                          GVariant* value);
static void plugin_actionable_finalize (GObject * obj);
static GType plugin_actionable_get_type_once (void);
static void _vala_plugin_actionable_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_plugin_actionable_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
plugin_actionable_get_instance_private (PluginActionable* self)
{
	return G_STRUCT_MEMBER_P (self, PluginActionable_private_offset);
}

const gchar*
plugin_actionable_get_label (PluginActionable* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_ACTIONABLE (self), NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
plugin_actionable_set_label (PluginActionable* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (PLUGIN_IS_ACTIONABLE (self));
	old_value = plugin_actionable_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_actionable_properties[PLUGIN_ACTIONABLE_LABEL_PROPERTY]);
	}
}

const gchar*
plugin_actionable_get_icon_name (PluginActionable* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_ACTIONABLE (self), NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
plugin_actionable_set_icon_name (PluginActionable* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (PLUGIN_IS_ACTIONABLE (self));
	old_value = plugin_actionable_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_actionable_properties[PLUGIN_ACTIONABLE_ICON_NAME_PROPERTY]);
	}
}

GAction*
plugin_actionable_get_action (PluginActionable* self)
{
	GAction* result;
	GAction* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_ACTIONABLE (self), NULL);
	_tmp0_ = self->priv->_action;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plugin_actionable_set_action (PluginActionable* self,
                              GAction* value)
{
	GAction* old_value;
	g_return_if_fail (PLUGIN_IS_ACTIONABLE (self));
	old_value = plugin_actionable_get_action (self);
	if (old_value != value) {
		GAction* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action);
		self->priv->_action = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_actionable_properties[PLUGIN_ACTIONABLE_ACTION_PROPERTY]);
	}
}

GVariant*
plugin_actionable_get_action_target (PluginActionable* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_ACTIONABLE (self), NULL);
	_tmp0_ = self->priv->_action_target;
	result = _tmp0_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
plugin_actionable_set_action_target (PluginActionable* self,
                                     GVariant* value)
{
	GVariant* old_value;
	g_return_if_fail (PLUGIN_IS_ACTIONABLE (self));
	old_value = plugin_actionable_get_action_target (self);
	if (old_value != value) {
		GVariant* _tmp0_;
		_tmp0_ = _g_variant_ref0 (value);
		_g_variant_unref0 (self->priv->_action_target);
		self->priv->_action_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_actionable_properties[PLUGIN_ACTIONABLE_ACTION_TARGET_PROPERTY]);
	}
}

/** Constructs a new actionable with a text label. */
PluginActionable*
plugin_actionable_construct (GType object_type,
                             const gchar* label,
                             GAction* action,
                             GVariant* action_target)
{
	PluginActionable * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_action_get_type ()), NULL);
	self = (PluginActionable*) geary_base_object_construct (object_type);
	plugin_actionable_set_label (self, label);
	plugin_actionable_set_action (self, action);
	plugin_actionable_set_action_target (self, action_target);
	return self;
}

PluginActionable*
plugin_actionable_new (const gchar* label,
                       GAction* action,
                       GVariant* action_target)
{
	return plugin_actionable_construct (PLUGIN_TYPE_ACTIONABLE, label, action, action_target);
}

/** Constructs a new actionable with a text label and icon name. */
PluginActionable*
plugin_actionable_construct_with_icon (GType object_type,
                                       const gchar* label,
                                       const gchar* icon_name,
                                       GAction* action,
                                       GVariant* action_target)
{
	PluginActionable * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_action_get_type ()), NULL);
	self = (PluginActionable*) geary_base_object_construct (object_type);
	plugin_actionable_set_label (self, label);
	plugin_actionable_set_icon_name (self, icon_name);
	plugin_actionable_set_action (self, action);
	plugin_actionable_set_action_target (self, action_target);
	return self;
}

PluginActionable*
plugin_actionable_new_with_icon (const gchar* label,
                                 const gchar* icon_name,
                                 GAction* action,
                                 GVariant* action_target)
{
	return plugin_actionable_construct_with_icon (PLUGIN_TYPE_ACTIONABLE, label, icon_name, action, action_target);
}

static void
plugin_actionable_class_init (PluginActionableClass * klass,
                              gpointer klass_data)
{
	plugin_actionable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginActionable_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_actionable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_actionable_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_actionable_finalize;
	/**
	     * A short human-readable label for the actionable.
	     *
	     * This should ideally be less than 10 characters long. It will be
	     * used as the label for the button, menu item, etc, depending on
	     * how it was registered.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTIONABLE_LABEL_PROPERTY, plugin_actionable_properties[PLUGIN_ACTIONABLE_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The name of an icon from the current icon theme to display.
	     *
	     * How and if the image displayed depends on the context and
	     * implementation. When used for a button, this may be displayed
	     * instead of {@link label}, for menu items it may not be
	     * displayed at all.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTIONABLE_ICON_NAME_PROPERTY, plugin_actionable_properties[PLUGIN_ACTIONABLE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The action to be invoked when the actionable is activated. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTIONABLE_ACTION_PROPERTY, plugin_actionable_properties[PLUGIN_ACTIONABLE_ACTION_PROPERTY] = g_param_spec_object ("action", "action", "action", g_action_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The parameter value for the action, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTIONABLE_ACTION_TARGET_PROPERTY, plugin_actionable_properties[PLUGIN_ACTIONABLE_ACTION_TARGET_PROPERTY] = g_param_spec_variant ("action-target", "action-target", "action-target", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plugin_actionable_instance_init (PluginActionable * self,
                                 gpointer klass)
{
	self->priv = plugin_actionable_get_instance_private (self);
	self->priv->_icon_name = NULL;
}

static void
plugin_actionable_finalize (GObject * obj)
{
	PluginActionable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_TYPE_ACTIONABLE, PluginActionable);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_action);
	_g_variant_unref0 (self->priv->_action_target);
	G_OBJECT_CLASS (plugin_actionable_parent_class)->finalize (obj);
}

/**
 * Enables plugins to add user interface elements such as buttons.
 *
 * Depending on how it is used, this interface may be used to specify
 * buttons, menu items, and so on. The associated action must be
 * registered via {@link Application.register_action} or similar calls
 * for it to be enabled.
 */
static GType
plugin_actionable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_actionable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginActionable), 0, (GInstanceInitFunc) plugin_actionable_instance_init, NULL };
	GType plugin_actionable_type_id;
	plugin_actionable_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "PluginActionable", &g_define_type_info, 0);
	PluginActionable_private_offset = g_type_add_instance_private (plugin_actionable_type_id, sizeof (PluginActionablePrivate));
	return plugin_actionable_type_id;
}

GType
plugin_actionable_get_type (void)
{
	static volatile gsize plugin_actionable_type_id__once = 0;
	if (g_once_init_enter (&plugin_actionable_type_id__once)) {
		GType plugin_actionable_type_id;
		plugin_actionable_type_id = plugin_actionable_get_type_once ();
		g_once_init_leave (&plugin_actionable_type_id__once, plugin_actionable_type_id);
	}
	return plugin_actionable_type_id__once;
}

static void
_vala_plugin_actionable_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	PluginActionable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_ACTIONABLE, PluginActionable);
	switch (property_id) {
		case PLUGIN_ACTIONABLE_LABEL_PROPERTY:
		g_value_set_string (value, plugin_actionable_get_label (self));
		break;
		case PLUGIN_ACTIONABLE_ICON_NAME_PROPERTY:
		g_value_set_string (value, plugin_actionable_get_icon_name (self));
		break;
		case PLUGIN_ACTIONABLE_ACTION_PROPERTY:
		g_value_set_object (value, plugin_actionable_get_action (self));
		break;
		case PLUGIN_ACTIONABLE_ACTION_TARGET_PROPERTY:
		g_value_set_variant (value, plugin_actionable_get_action_target (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_actionable_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	PluginActionable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_ACTIONABLE, PluginActionable);
	switch (property_id) {
		case PLUGIN_ACTIONABLE_LABEL_PROPERTY:
		plugin_actionable_set_label (self, g_value_get_string (value));
		break;
		case PLUGIN_ACTIONABLE_ICON_NAME_PROPERTY:
		plugin_actionable_set_icon_name (self, g_value_get_string (value));
		break;
		case PLUGIN_ACTIONABLE_ACTION_PROPERTY:
		plugin_actionable_set_action (self, g_value_get_object (value));
		break;
		case PLUGIN_ACTIONABLE_ACTION_TARGET_PROPERTY:
		plugin_actionable_set_action_target (self, g_value_get_variant (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

