/* string-input-stream.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from string-input-stream.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_STRING_INPUT_STREAM_0_PROPERTY,
	GAMES_STRING_INPUT_STREAM_NUM_PROPERTIES
};
static GParamSpec* games_string_input_stream_properties[GAMES_STRING_INPUT_STREAM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesStringInputStreamPrivate {
	GFile* file;
};

static gint GamesStringInputStream_private_offset;
static gpointer games_string_input_stream_parent_class = NULL;

static void games_string_input_stream_finalize (GObject * obj);
static GType games_string_input_stream_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_string_input_stream_get_instance_private (GamesStringInputStream* self)
{
	return G_STRUCT_MEMBER_P (self, GamesStringInputStream_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesStringInputStream*
games_string_input_stream_construct (GType object_type,
                                     GFile* file)
{
	GamesStringInputStream * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesStringInputStream*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

GamesStringInputStream*
games_string_input_stream_new (GFile* file)
{
	return games_string_input_stream_construct (GAMES_TYPE_STRING_INPUT_STREAM, file);
}

gboolean
games_string_input_stream_has_string (GamesStringInputStream* self,
                                      gsize offset,
                                      const gchar* value,
                                      GError** error)
{
	gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp1_ = strlen (value);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_string_input_stream_read_string_for_size (self, offset, (gsize) _tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	result = g_strcmp0 (_tmp0_, value) == 0;
	_g_free0 (_tmp0_);
	return result;
}

gchar*
games_string_input_stream_read_string (GamesStringInputStream* self,
                                       gsize offset,
                                       GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* stream = NULL;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gsize length = 0UL;
	gchar* _tmp5_ = NULL;
	GDataInputStream* _tmp6_;
	gsize _tmp7_ = 0UL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	stream = _tmp3_;
	_tmp4_ = stream;
	g_seekable_seek ((GSeekable*) _tmp4_, (gint64) offset, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp6_ = stream;
	_tmp8_ = g_data_input_stream_read_upto (_tmp6_, "\0", (gssize) 1, &_tmp7_, NULL, &_inner_error0_);
	length = _tmp7_;
	_tmp5_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp9_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp9_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (stream);
	_g_object_unref0 (_tmp0_);
	return result;
}

gchar*
games_string_input_stream_read_string_for_size (GamesStringInputStream* self,
                                                gsize offset,
                                                gsize size,
                                                GError** error)
{
	GFileInputStream* stream = NULL;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_;
	GFileInputStream* _tmp2_;
	guint8* buffer = NULL;
	guint8* _tmp3_;
	gint buffer_length1;
	gint _buffer_size_;
	GFileInputStream* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_read (_tmp0_, NULL, &_inner_error0_);
	stream = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = stream;
	G_TYPE_INSTANCE_GET_CLASS (_tmp2_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp2_, (gint64) offset, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = g_new0 (guint8, size);
	buffer = _tmp3_;
	buffer_length1 = size;
	_buffer_size_ = buffer_length1;
	_tmp4_ = stream;
	_tmp5_ = buffer;
	_tmp5__length1 = buffer_length1;
	g_input_stream_read ((GInputStream*) _tmp4_, _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp6_ = buffer;
	_tmp6__length1 = buffer_length1;
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	result = _tmp7_;
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (stream);
	return result;
}

static void
games_string_input_stream_class_init (GamesStringInputStreamClass * klass,
                                      gpointer klass_data)
{
	games_string_input_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesStringInputStream_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_string_input_stream_finalize;
}

static void
games_string_input_stream_instance_init (GamesStringInputStream * self,
                                         gpointer klass)
{
	self->priv = games_string_input_stream_get_instance_private (self);
}

static void
games_string_input_stream_finalize (GObject * obj)
{
	GamesStringInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STRING_INPUT_STREAM, GamesStringInputStream);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_string_input_stream_parent_class)->finalize (obj);
}

static GType
games_string_input_stream_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesStringInputStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_string_input_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesStringInputStream), 0, (GInstanceInitFunc) games_string_input_stream_instance_init, NULL };
	GType games_string_input_stream_type_id;
	games_string_input_stream_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesStringInputStream", &g_define_type_info, 0);
	GamesStringInputStream_private_offset = g_type_add_instance_private (games_string_input_stream_type_id, sizeof (GamesStringInputStreamPrivate));
	return games_string_input_stream_type_id;
}

GType
games_string_input_stream_get_type (void)
{
	static volatile gsize games_string_input_stream_type_id__once = 0;
	if (g_once_init_enter (&games_string_input_stream_type_id__once)) {
		GType games_string_input_stream_type_id;
		games_string_input_stream_type_id = games_string_input_stream_get_type_once ();
		g_once_init_leave (&games_string_input_stream_type_id__once, games_string_input_stream_type_id);
	}
	return games_string_input_stream_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

