{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Contains information that is useful to compute the size of a toplevel.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.ToplevelSize
    ( 

-- * Exported types
    ToplevelSize(..)                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getBounds]("GI.Gdk.Structs.ToplevelSize#g:method:getBounds").
-- 
-- ==== Setters
-- [setMinSize]("GI.Gdk.Structs.ToplevelSize#g:method:setMinSize"), [setShadowWidth]("GI.Gdk.Structs.ToplevelSize#g:method:setShadowWidth"), [setSize]("GI.Gdk.Structs.ToplevelSize#g:method:setSize").

#if defined(ENABLE_OVERLOADING)
    ResolveToplevelSizeMethod               ,
#endif

-- ** getBounds #method:getBounds#

#if defined(ENABLE_OVERLOADING)
    ToplevelSizeGetBoundsMethodInfo         ,
#endif
    toplevelSizeGetBounds                   ,


-- ** setMinSize #method:setMinSize#

#if defined(ENABLE_OVERLOADING)
    ToplevelSizeSetMinSizeMethodInfo        ,
#endif
    toplevelSizeSetMinSize                  ,


-- ** setShadowWidth #method:setShadowWidth#

#if defined(ENABLE_OVERLOADING)
    ToplevelSizeSetShadowWidthMethodInfo    ,
#endif
    toplevelSizeSetShadowWidth              ,


-- ** setSize #method:setSize#

#if defined(ENABLE_OVERLOADING)
    ToplevelSizeSetSizeMethodInfo           ,
#endif
    toplevelSizeSetSize                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ToplevelSize = ToplevelSize (SP.ManagedPtr ToplevelSize)
    deriving (Eq)

instance SP.ManagedPtrNewtype ToplevelSize where
    toManagedPtr (ToplevelSize p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ToplevelSize where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ToplevelSize
type instance O.AttributeList ToplevelSize = ToplevelSizeAttributeList
type ToplevelSizeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method ToplevelSize::get_bounds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "size"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevelSize`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bounds_width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bounds_height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_size_get_bounds" gdk_toplevel_size_get_bounds :: 
    Ptr ToplevelSize ->                     -- size : TInterface (Name {namespace = "Gdk", name = "ToplevelSize"})
    Ptr Int32 ->                            -- bounds_width : TBasicType TInt
    Ptr Int32 ->                            -- bounds_height : TBasicType TInt
    IO ()

-- | Retrieves the bounds the toplevel is placed within.
-- 
-- The bounds represent the largest size a toplevel may have while still being
-- able to fit within some type of boundary. Depending on the backend, this may
-- be equivalent to the dimensions of the work area or the monitor on which the
-- window is being presented on, or something else that limits the way a
-- toplevel can be presented.
toplevelSizeGetBounds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelSize
    -- ^ /@size@/: a @GdkToplevelSize@
    -> m ((Int32, Int32))
toplevelSizeGetBounds size = liftIO $ do
    size' <- unsafeManagedPtrGetPtr size
    boundsWidth <- allocMem :: IO (Ptr Int32)
    boundsHeight <- allocMem :: IO (Ptr Int32)
    gdk_toplevel_size_get_bounds size' boundsWidth boundsHeight
    boundsWidth' <- peek boundsWidth
    boundsHeight' <- peek boundsHeight
    touchManagedPtr size
    freeMem boundsWidth
    freeMem boundsHeight
    return (boundsWidth', boundsHeight')

#if defined(ENABLE_OVERLOADING)
data ToplevelSizeGetBoundsMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m) => O.OverloadedMethod ToplevelSizeGetBoundsMethodInfo ToplevelSize signature where
    overloadedMethod = toplevelSizeGetBounds

instance O.OverloadedMethodInfo ToplevelSizeGetBoundsMethodInfo ToplevelSize where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelSize.toplevelSizeGetBounds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelSize.html#v:toplevelSizeGetBounds"
        })


#endif

-- method ToplevelSize::set_min_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "size"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevelSize`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min_width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimum width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min_height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimum height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_size_set_min_size" gdk_toplevel_size_set_min_size :: 
    Ptr ToplevelSize ->                     -- size : TInterface (Name {namespace = "Gdk", name = "ToplevelSize"})
    Int32 ->                                -- min_width : TBasicType TInt
    Int32 ->                                -- min_height : TBasicType TInt
    IO ()

-- | Sets the minimum size of the toplevel.
-- 
-- The minimum size corresponds to the limitations the toplevel can be shrunk
-- to, without resulting in incorrect painting. A user of a @GdkToplevel@ should
-- calculate these given both the existing size, and the bounds retrieved from
-- the @GdkToplevelSize@ object.
-- 
-- The minimum size should be within the bounds (see
-- 'GI.Gdk.Structs.ToplevelSize.toplevelSizeGetBounds').
toplevelSizeSetMinSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelSize
    -- ^ /@size@/: a @GdkToplevelSize@
    -> Int32
    -- ^ /@minWidth@/: the minimum width
    -> Int32
    -- ^ /@minHeight@/: the minimum height
    -> m ()
toplevelSizeSetMinSize size minWidth minHeight = liftIO $ do
    size' <- unsafeManagedPtrGetPtr size
    gdk_toplevel_size_set_min_size size' minWidth minHeight
    touchManagedPtr size
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSizeSetMinSizeMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod ToplevelSizeSetMinSizeMethodInfo ToplevelSize signature where
    overloadedMethod = toplevelSizeSetMinSize

instance O.OverloadedMethodInfo ToplevelSizeSetMinSizeMethodInfo ToplevelSize where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelSize.toplevelSizeSetMinSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelSize.html#v:toplevelSizeSetMinSize"
        })


#endif

-- method ToplevelSize::set_shadow_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "size"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevelSize`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "left"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width of the left part of the shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "right"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width of the right part of the shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "top"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "height of the top part of the shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bottom"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "height of the bottom part of the shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_size_set_shadow_width" gdk_toplevel_size_set_shadow_width :: 
    Ptr ToplevelSize ->                     -- size : TInterface (Name {namespace = "Gdk", name = "ToplevelSize"})
    Int32 ->                                -- left : TBasicType TInt
    Int32 ->                                -- right : TBasicType TInt
    Int32 ->                                -- top : TBasicType TInt
    Int32 ->                                -- bottom : TBasicType TInt
    IO ()

-- | Sets the shadows size of the toplevel.
-- 
-- The shadow width corresponds to the part of the computed surface size
-- that would consist of the shadow margin surrounding the window, would
-- there be any.
-- 
-- Shadow width should only be set if
-- @/Gtk.Display.supports_shadow_width()/@ is 'P.True'.
toplevelSizeSetShadowWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelSize
    -- ^ /@size@/: a @GdkToplevelSize@
    -> Int32
    -- ^ /@left@/: width of the left part of the shadow
    -> Int32
    -- ^ /@right@/: width of the right part of the shadow
    -> Int32
    -- ^ /@top@/: height of the top part of the shadow
    -> Int32
    -- ^ /@bottom@/: height of the bottom part of the shadow
    -> m ()
toplevelSizeSetShadowWidth size left right top bottom = liftIO $ do
    size' <- unsafeManagedPtrGetPtr size
    gdk_toplevel_size_set_shadow_width size' left right top bottom
    touchManagedPtr size
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSizeSetShadowWidthMethodInfo
instance (signature ~ (Int32 -> Int32 -> Int32 -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod ToplevelSizeSetShadowWidthMethodInfo ToplevelSize signature where
    overloadedMethod = toplevelSizeSetShadowWidth

instance O.OverloadedMethodInfo ToplevelSizeSetShadowWidthMethodInfo ToplevelSize where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelSize.toplevelSizeSetShadowWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelSize.html#v:toplevelSizeSetShadowWidth"
        })


#endif

-- method ToplevelSize::set_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "size"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevelSize`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_size_set_size" gdk_toplevel_size_set_size :: 
    Ptr ToplevelSize ->                     -- size : TInterface (Name {namespace = "Gdk", name = "ToplevelSize"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the size the toplevel prefers to be resized to.
-- 
-- The size should be within the bounds (see
-- 'GI.Gdk.Structs.ToplevelSize.toplevelSizeGetBounds'). The set size should
-- be considered as a hint, and should not be assumed to be
-- respected by the windowing system, or backend.
toplevelSizeSetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelSize
    -- ^ /@size@/: a @GdkToplevelSize@
    -> Int32
    -- ^ /@width@/: the width
    -> Int32
    -- ^ /@height@/: the height
    -> m ()
toplevelSizeSetSize size width height = liftIO $ do
    size' <- unsafeManagedPtrGetPtr size
    gdk_toplevel_size_set_size size' width height
    touchManagedPtr size
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSizeSetSizeMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod ToplevelSizeSetSizeMethodInfo ToplevelSize signature where
    overloadedMethod = toplevelSizeSetSize

instance O.OverloadedMethodInfo ToplevelSizeSetSizeMethodInfo ToplevelSize where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelSize.toplevelSizeSetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelSize.html#v:toplevelSizeSetSize"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveToplevelSizeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveToplevelSizeMethod "getBounds" o = ToplevelSizeGetBoundsMethodInfo
    ResolveToplevelSizeMethod "setMinSize" o = ToplevelSizeSetMinSizeMethodInfo
    ResolveToplevelSizeMethod "setShadowWidth" o = ToplevelSizeSetShadowWidthMethodInfo
    ResolveToplevelSizeMethod "setSize" o = ToplevelSizeSetSizeMethodInfo
    ResolveToplevelSizeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveToplevelSizeMethod t ToplevelSize, O.OverloadedMethod info ToplevelSize p) => OL.IsLabel t (ToplevelSize -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveToplevelSizeMethod t ToplevelSize, O.OverloadedMethod info ToplevelSize p, R.HasField t ToplevelSize p) => R.HasField t ToplevelSize p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveToplevelSizeMethod t ToplevelSize, O.OverloadedMethodInfo info ToplevelSize) => OL.IsLabel t (O.MethodProxy info ToplevelSize) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


