{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Acts as a lightweight registry for possible valid file attributes.
-- The registry stores Key-Value pair formats as @/GFileAttributeInfos/@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.FileAttributeInfoList
    ( 

-- * Exported types
    FileAttributeInfoList(..)               ,
    newZeroFileAttributeInfoList            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [add]("GI.Gio.Structs.FileAttributeInfoList#g:method:add"), [dup]("GI.Gio.Structs.FileAttributeInfoList#g:method:dup"), [lookup]("GI.Gio.Structs.FileAttributeInfoList#g:method:lookup"), [ref]("GI.Gio.Structs.FileAttributeInfoList#g:method:ref"), [unref]("GI.Gio.Structs.FileAttributeInfoList#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveFileAttributeInfoListMethod      ,
#endif

-- ** add #method:add#

#if defined(ENABLE_OVERLOADING)
    FileAttributeInfoListAddMethodInfo      ,
#endif
    fileAttributeInfoListAdd                ,


-- ** dup #method:dup#

#if defined(ENABLE_OVERLOADING)
    FileAttributeInfoListDupMethodInfo      ,
#endif
    fileAttributeInfoListDup                ,


-- ** lookup #method:lookup#

#if defined(ENABLE_OVERLOADING)
    FileAttributeInfoListLookupMethodInfo   ,
#endif
    fileAttributeInfoListLookup             ,


-- ** new #method:new#

    fileAttributeInfoListNew                ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    FileAttributeInfoListRefMethodInfo      ,
#endif
    fileAttributeInfoListRef                ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    FileAttributeInfoListUnrefMethodInfo    ,
#endif
    fileAttributeInfoListUnref              ,




 -- * Properties


-- ** infos #attr:infos#
-- | an array of @/GFileAttributeInfos/@.

    clearFileAttributeInfoListInfos         ,
#if defined(ENABLE_OVERLOADING)
    fileAttributeInfoList_infos             ,
#endif
    getFileAttributeInfoListInfos           ,
    setFileAttributeInfoListInfos           ,


-- ** nInfos #attr:nInfos#
-- | the number of values in the array.

#if defined(ENABLE_OVERLOADING)
    fileAttributeInfoList_nInfos            ,
#endif
    getFileAttributeInfoListNInfos          ,
    setFileAttributeInfoListNInfos          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo

#else
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo

#endif

-- | Memory-managed wrapper type.
newtype FileAttributeInfoList = FileAttributeInfoList (SP.ManagedPtr FileAttributeInfoList)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileAttributeInfoList where
    toManagedPtr (FileAttributeInfoList p) = p

foreign import ccall "g_file_attribute_info_list_get_type" c_g_file_attribute_info_list_get_type :: 
    IO GType

type instance O.ParentTypes FileAttributeInfoList = '[]
instance O.HasParentTypes FileAttributeInfoList

instance B.Types.TypedObject FileAttributeInfoList where
    glibType = c_g_file_attribute_info_list_get_type

instance B.Types.GBoxed FileAttributeInfoList

-- | Convert t'FileAttributeInfoList' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileAttributeInfoList) where
    gvalueGType_ = c_g_file_attribute_info_list_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr FileAttributeInfoList)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr FileAttributeInfoList)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed FileAttributeInfoList ptr
        else return P.Nothing
        
    

-- | Construct a t'FileAttributeInfoList' struct initialized to zero.
newZeroFileAttributeInfoList :: MonadIO m => m FileAttributeInfoList
newZeroFileAttributeInfoList = liftIO $ callocBoxedBytes 16 >>= wrapBoxed FileAttributeInfoList

instance tag ~ 'AttrSet => Constructible FileAttributeInfoList tag where
    new _ attrs = do
        o <- newZeroFileAttributeInfoList
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@infos@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileAttributeInfoList #infos
-- @
getFileAttributeInfoListInfos :: MonadIO m => FileAttributeInfoList -> m (Maybe Gio.FileAttributeInfo.FileAttributeInfo)
getFileAttributeInfoListInfos s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Gio.FileAttributeInfo.FileAttributeInfo)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Gio.FileAttributeInfo.FileAttributeInfo) val'
        return val''
    return result

-- | Set the value of the “@infos@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileAttributeInfoList [ #infos 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileAttributeInfoListInfos :: MonadIO m => FileAttributeInfoList -> Ptr Gio.FileAttributeInfo.FileAttributeInfo -> m ()
setFileAttributeInfoListInfos s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Gio.FileAttributeInfo.FileAttributeInfo)

-- | Set the value of the “@infos@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #infos
-- @
clearFileAttributeInfoListInfos :: MonadIO m => FileAttributeInfoList -> m ()
clearFileAttributeInfoListInfos s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Gio.FileAttributeInfo.FileAttributeInfo)

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListInfosFieldInfo
instance AttrInfo FileAttributeInfoListInfosFieldInfo where
    type AttrBaseTypeConstraint FileAttributeInfoListInfosFieldInfo = (~) FileAttributeInfoList
    type AttrAllowedOps FileAttributeInfoListInfosFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FileAttributeInfoListInfosFieldInfo = (~) (Ptr Gio.FileAttributeInfo.FileAttributeInfo)
    type AttrTransferTypeConstraint FileAttributeInfoListInfosFieldInfo = (~)(Ptr Gio.FileAttributeInfo.FileAttributeInfo)
    type AttrTransferType FileAttributeInfoListInfosFieldInfo = (Ptr Gio.FileAttributeInfo.FileAttributeInfo)
    type AttrGetType FileAttributeInfoListInfosFieldInfo = Maybe Gio.FileAttributeInfo.FileAttributeInfo
    type AttrLabel FileAttributeInfoListInfosFieldInfo = "infos"
    type AttrOrigin FileAttributeInfoListInfosFieldInfo = FileAttributeInfoList
    attrGet = getFileAttributeInfoListInfos
    attrSet = setFileAttributeInfoListInfos
    attrConstruct = undefined
    attrClear = clearFileAttributeInfoListInfos
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.infos"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#g:attr:infos"
        })

fileAttributeInfoList_infos :: AttrLabelProxy "infos"
fileAttributeInfoList_infos = AttrLabelProxy

#endif


-- | Get the value of the “@n_infos@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileAttributeInfoList #nInfos
-- @
getFileAttributeInfoListNInfos :: MonadIO m => FileAttributeInfoList -> m Int32
getFileAttributeInfoListNInfos s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@n_infos@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileAttributeInfoList [ #nInfos 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileAttributeInfoListNInfos :: MonadIO m => FileAttributeInfoList -> Int32 -> m ()
setFileAttributeInfoListNInfos s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListNInfosFieldInfo
instance AttrInfo FileAttributeInfoListNInfosFieldInfo where
    type AttrBaseTypeConstraint FileAttributeInfoListNInfosFieldInfo = (~) FileAttributeInfoList
    type AttrAllowedOps FileAttributeInfoListNInfosFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FileAttributeInfoListNInfosFieldInfo = (~) Int32
    type AttrTransferTypeConstraint FileAttributeInfoListNInfosFieldInfo = (~)Int32
    type AttrTransferType FileAttributeInfoListNInfosFieldInfo = Int32
    type AttrGetType FileAttributeInfoListNInfosFieldInfo = Int32
    type AttrLabel FileAttributeInfoListNInfosFieldInfo = "n_infos"
    type AttrOrigin FileAttributeInfoListNInfosFieldInfo = FileAttributeInfoList
    attrGet = getFileAttributeInfoListNInfos
    attrSet = setFileAttributeInfoListNInfos
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.nInfos"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#g:attr:nInfos"
        })

fileAttributeInfoList_nInfos :: AttrLabelProxy "nInfos"
fileAttributeInfoList_nInfos = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileAttributeInfoList
type instance O.AttributeList FileAttributeInfoList = FileAttributeInfoListAttributeList
type FileAttributeInfoListAttributeList = ('[ '("infos", FileAttributeInfoListInfosFieldInfo), '("nInfos", FileAttributeInfoListNInfosFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method FileAttributeInfoList::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "FileAttributeInfoList" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_attribute_info_list_new" g_file_attribute_info_list_new :: 
    IO (Ptr FileAttributeInfoList)

-- | Creates a new file attribute info list.
fileAttributeInfoListNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m FileAttributeInfoList
    -- ^ __Returns:__ a t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList'.
fileAttributeInfoListNew  = liftIO $ do
    result <- g_file_attribute_info_list_new
    checkUnexpectedReturnNULL "fileAttributeInfoListNew" result
    result' <- (wrapBoxed FileAttributeInfoList) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FileAttributeInfoList::add
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileAttributeInfoList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileAttributeInfoList."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the attribute to add."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileAttributeType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GFileAttributeType for the attribute."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileAttributeInfoFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GFileAttributeInfoFlags for the attribute."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_attribute_info_list_add" g_file_attribute_info_list_add :: 
    Ptr FileAttributeInfoList ->            -- list : TInterface (Name {namespace = "Gio", name = "FileAttributeInfoList"})
    CString ->                              -- name : TBasicType TUTF8
    CUInt ->                                -- type : TInterface (Name {namespace = "Gio", name = "FileAttributeType"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "FileAttributeInfoFlags"})
    IO ()

-- | Adds a new attribute with /@name@/ to the /@list@/, setting
-- its /@type@/ and /@flags@/.
fileAttributeInfoListAdd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FileAttributeInfoList
    -- ^ /@list@/: a t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList'.
    -> T.Text
    -- ^ /@name@/: the name of the attribute to add.
    -> Gio.Enums.FileAttributeType
    -- ^ /@type@/: the t'GI.Gio.Enums.FileAttributeType' for the attribute.
    -> [Gio.Flags.FileAttributeInfoFlags]
    -- ^ /@flags@/: t'GI.Gio.Flags.FileAttributeInfoFlags' for the attribute.
    -> m ()
fileAttributeInfoListAdd list name type_ flags = liftIO $ do
    list' <- unsafeManagedPtrGetPtr list
    name' <- textToCString name
    let type_' = (fromIntegral . fromEnum) type_
    let flags' = gflagsToWord flags
    g_file_attribute_info_list_add list' name' type_' flags'
    touchManagedPtr list
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListAddMethodInfo
instance (signature ~ (T.Text -> Gio.Enums.FileAttributeType -> [Gio.Flags.FileAttributeInfoFlags] -> m ()), MonadIO m) => O.OverloadedMethod FileAttributeInfoListAddMethodInfo FileAttributeInfoList signature where
    overloadedMethod = fileAttributeInfoListAdd

instance O.OverloadedMethodInfo FileAttributeInfoListAddMethodInfo FileAttributeInfoList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.fileAttributeInfoListAdd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#v:fileAttributeInfoListAdd"
        })


#endif

-- method FileAttributeInfoList::dup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileAttributeInfoList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileAttributeInfoList to duplicate."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "FileAttributeInfoList" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_attribute_info_list_dup" g_file_attribute_info_list_dup :: 
    Ptr FileAttributeInfoList ->            -- list : TInterface (Name {namespace = "Gio", name = "FileAttributeInfoList"})
    IO (Ptr FileAttributeInfoList)

-- | Makes a duplicate of a file attribute info list.
fileAttributeInfoListDup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FileAttributeInfoList
    -- ^ /@list@/: a t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList' to duplicate.
    -> m FileAttributeInfoList
    -- ^ __Returns:__ a copy of the given /@list@/.
fileAttributeInfoListDup list = liftIO $ do
    list' <- unsafeManagedPtrGetPtr list
    result <- g_file_attribute_info_list_dup list'
    checkUnexpectedReturnNULL "fileAttributeInfoListDup" result
    result' <- (wrapBoxed FileAttributeInfoList) result
    touchManagedPtr list
    return result'

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListDupMethodInfo
instance (signature ~ (m FileAttributeInfoList), MonadIO m) => O.OverloadedMethod FileAttributeInfoListDupMethodInfo FileAttributeInfoList signature where
    overloadedMethod = fileAttributeInfoListDup

instance O.OverloadedMethodInfo FileAttributeInfoListDupMethodInfo FileAttributeInfoList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.fileAttributeInfoListDup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#v:fileAttributeInfoListDup"
        })


#endif

-- method FileAttributeInfoList::lookup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileAttributeInfoList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileAttributeInfoList."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the attribute to look up."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "FileAttributeInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_attribute_info_list_lookup" g_file_attribute_info_list_lookup :: 
    Ptr FileAttributeInfoList ->            -- list : TInterface (Name {namespace = "Gio", name = "FileAttributeInfoList"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gio.FileAttributeInfo.FileAttributeInfo)

-- | Gets the file attribute with the name /@name@/ from /@list@/.
fileAttributeInfoListLookup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FileAttributeInfoList
    -- ^ /@list@/: a t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList'.
    -> T.Text
    -- ^ /@name@/: the name of the attribute to look up.
    -> m Gio.FileAttributeInfo.FileAttributeInfo
    -- ^ __Returns:__ a t'GI.Gio.Structs.FileAttributeInfo.FileAttributeInfo' for the /@name@/, or 'P.Nothing' if an
    -- attribute isn\'t found.
fileAttributeInfoListLookup list name = liftIO $ do
    list' <- unsafeManagedPtrGetPtr list
    name' <- textToCString name
    result <- g_file_attribute_info_list_lookup list' name'
    checkUnexpectedReturnNULL "fileAttributeInfoListLookup" result
    result' <- (newPtr Gio.FileAttributeInfo.FileAttributeInfo) result
    touchManagedPtr list
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListLookupMethodInfo
instance (signature ~ (T.Text -> m Gio.FileAttributeInfo.FileAttributeInfo), MonadIO m) => O.OverloadedMethod FileAttributeInfoListLookupMethodInfo FileAttributeInfoList signature where
    overloadedMethod = fileAttributeInfoListLookup

instance O.OverloadedMethodInfo FileAttributeInfoListLookupMethodInfo FileAttributeInfoList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.fileAttributeInfoListLookup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#v:fileAttributeInfoListLookup"
        })


#endif

-- method FileAttributeInfoList::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileAttributeInfoList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileAttributeInfoList to reference."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "FileAttributeInfoList" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_attribute_info_list_ref" g_file_attribute_info_list_ref :: 
    Ptr FileAttributeInfoList ->            -- list : TInterface (Name {namespace = "Gio", name = "FileAttributeInfoList"})
    IO (Ptr FileAttributeInfoList)

-- | References a file attribute info list.
fileAttributeInfoListRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FileAttributeInfoList
    -- ^ /@list@/: a t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList' to reference.
    -> m FileAttributeInfoList
    -- ^ __Returns:__ t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList' or 'P.Nothing' on error.
fileAttributeInfoListRef list = liftIO $ do
    list' <- unsafeManagedPtrGetPtr list
    result <- g_file_attribute_info_list_ref list'
    checkUnexpectedReturnNULL "fileAttributeInfoListRef" result
    result' <- (wrapBoxed FileAttributeInfoList) result
    touchManagedPtr list
    return result'

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListRefMethodInfo
instance (signature ~ (m FileAttributeInfoList), MonadIO m) => O.OverloadedMethod FileAttributeInfoListRefMethodInfo FileAttributeInfoList signature where
    overloadedMethod = fileAttributeInfoListRef

instance O.OverloadedMethodInfo FileAttributeInfoListRefMethodInfo FileAttributeInfoList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.fileAttributeInfoListRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#v:fileAttributeInfoListRef"
        })


#endif

-- method FileAttributeInfoList::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileAttributeInfoList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GFileAttributeInfoList to unreference."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_attribute_info_list_unref" g_file_attribute_info_list_unref :: 
    Ptr FileAttributeInfoList ->            -- list : TInterface (Name {namespace = "Gio", name = "FileAttributeInfoList"})
    IO ()

-- | Removes a reference from the given /@list@/. If the reference count
-- falls to zero, the /@list@/ is deleted.
fileAttributeInfoListUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FileAttributeInfoList
    -- ^ /@list@/: The t'GI.Gio.Structs.FileAttributeInfoList.FileAttributeInfoList' to unreference.
    -> m ()
fileAttributeInfoListUnref list = liftIO $ do
    list' <- unsafeManagedPtrGetPtr list
    g_file_attribute_info_list_unref list'
    touchManagedPtr list
    return ()

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoListUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod FileAttributeInfoListUnrefMethodInfo FileAttributeInfoList signature where
    overloadedMethod = fileAttributeInfoListUnref

instance O.OverloadedMethodInfo FileAttributeInfoListUnrefMethodInfo FileAttributeInfoList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfoList.fileAttributeInfoListUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfoList.html#v:fileAttributeInfoListUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFileAttributeInfoListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileAttributeInfoListMethod "add" o = FileAttributeInfoListAddMethodInfo
    ResolveFileAttributeInfoListMethod "dup" o = FileAttributeInfoListDupMethodInfo
    ResolveFileAttributeInfoListMethod "lookup" o = FileAttributeInfoListLookupMethodInfo
    ResolveFileAttributeInfoListMethod "ref" o = FileAttributeInfoListRefMethodInfo
    ResolveFileAttributeInfoListMethod "unref" o = FileAttributeInfoListUnrefMethodInfo
    ResolveFileAttributeInfoListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileAttributeInfoListMethod t FileAttributeInfoList, O.OverloadedMethod info FileAttributeInfoList p) => OL.IsLabel t (FileAttributeInfoList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileAttributeInfoListMethod t FileAttributeInfoList, O.OverloadedMethod info FileAttributeInfoList p, R.HasField t FileAttributeInfoList p) => R.HasField t FileAttributeInfoList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileAttributeInfoListMethod t FileAttributeInfoList, O.OverloadedMethodInfo info FileAttributeInfoList) => OL.IsLabel t (O.MethodProxy info FileAttributeInfoList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


