{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.InputStreamClass
    ( 

-- * Exported types
    InputStreamClass(..)                    ,
    newZeroInputStreamClass                 ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveInputStreamClassMethod           ,
#endif



 -- * Properties


-- ** closeAsync #attr:closeAsync#
-- | /No description available in the introspection data./

    clearInputStreamClassCloseAsync         ,
    getInputStreamClassCloseAsync           ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_closeAsync             ,
#endif
    setInputStreamClassCloseAsync           ,


-- ** closeFinish #attr:closeFinish#
-- | /No description available in the introspection data./

    clearInputStreamClassCloseFinish        ,
    getInputStreamClassCloseFinish          ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_closeFinish            ,
#endif
    setInputStreamClassCloseFinish          ,


-- ** closeFn #attr:closeFn#
-- | /No description available in the introspection data./

    clearInputStreamClassCloseFn            ,
    getInputStreamClassCloseFn              ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_closeFn                ,
#endif
    setInputStreamClassCloseFn              ,


-- ** parentClass #attr:parentClass#
-- | /No description available in the introspection data./

    getInputStreamClassParentClass          ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_parentClass            ,
#endif


-- ** readAsync #attr:readAsync#
-- | /No description available in the introspection data./

    clearInputStreamClassReadAsync          ,
    getInputStreamClassReadAsync            ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_readAsync              ,
#endif
    setInputStreamClassReadAsync            ,


-- ** readFinish #attr:readFinish#
-- | /No description available in the introspection data./

    clearInputStreamClassReadFinish         ,
    getInputStreamClassReadFinish           ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_readFinish             ,
#endif
    setInputStreamClassReadFinish           ,


-- ** readFn #attr:readFn#
-- | /No description available in the introspection data./

    clearInputStreamClassReadFn             ,
    getInputStreamClassReadFn               ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_readFn                 ,
#endif
    setInputStreamClassReadFn               ,


-- ** skip #attr:skip#
-- | /No description available in the introspection data./

    clearInputStreamClassSkip               ,
    getInputStreamClassSkip                 ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_skip                   ,
#endif
    setInputStreamClassSkip                 ,


-- ** skipAsync #attr:skipAsync#
-- | /No description available in the introspection data./

    clearInputStreamClassSkipAsync          ,
    getInputStreamClassSkipAsync            ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_skipAsync              ,
#endif
    setInputStreamClassSkipAsync            ,


-- ** skipFinish #attr:skipFinish#
-- | /No description available in the introspection data./

    clearInputStreamClassSkipFinish         ,
    getInputStreamClassSkipFinish           ,
#if defined(ENABLE_OVERLOADING)
    inputStreamClass_skipFinish             ,
#endif
    setInputStreamClassSkipFinish           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gio.Callbacks as Gio.Callbacks

#else
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gio.Callbacks as Gio.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype InputStreamClass = InputStreamClass (SP.ManagedPtr InputStreamClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype InputStreamClass where
    toManagedPtr (InputStreamClass p) = p

instance BoxedPtr InputStreamClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 248 >=> B.ManagedPtr.wrapPtr InputStreamClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr InputStreamClass where
    boxedPtrCalloc = callocBytes 248


-- | Construct a t'InputStreamClass' struct initialized to zero.
newZeroInputStreamClass :: MonadIO m => m InputStreamClass
newZeroInputStreamClass = liftIO $ boxedPtrCalloc >>= wrapPtr InputStreamClass

instance tag ~ 'AttrSet => Constructible InputStreamClass tag where
    new _ attrs = do
        o <- newZeroInputStreamClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@parent_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #parentClass
-- @
getInputStreamClassParentClass :: MonadIO m => InputStreamClass -> m GObject.ObjectClass.ObjectClass
getInputStreamClassParentClass s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.ObjectClass.ObjectClass)
    val' <- (newPtr GObject.ObjectClass.ObjectClass) val
    return val'

#if defined(ENABLE_OVERLOADING)
data InputStreamClassParentClassFieldInfo
instance AttrInfo InputStreamClassParentClassFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassParentClassFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassParentClassFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint InputStreamClassParentClassFieldInfo = (~) (Ptr GObject.ObjectClass.ObjectClass)
    type AttrTransferTypeConstraint InputStreamClassParentClassFieldInfo = (~)(Ptr GObject.ObjectClass.ObjectClass)
    type AttrTransferType InputStreamClassParentClassFieldInfo = (Ptr GObject.ObjectClass.ObjectClass)
    type AttrGetType InputStreamClassParentClassFieldInfo = GObject.ObjectClass.ObjectClass
    type AttrLabel InputStreamClassParentClassFieldInfo = "parent_class"
    type AttrOrigin InputStreamClassParentClassFieldInfo = InputStreamClass
    attrGet = getInputStreamClassParentClass
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.parentClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:parentClass"
        })

inputStreamClass_parentClass :: AttrLabelProxy "parentClass"
inputStreamClass_parentClass = AttrLabelProxy

#endif


-- | Get the value of the “@read_fn@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #readFn
-- @
getInputStreamClassReadFn :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassReadFnFieldCallback)
getInputStreamClassReadFn s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 136) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassReadFnFieldCallback val'
        return val''
    return result

-- | Set the value of the “@read_fn@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #readFn 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassReadFn :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback -> m ()
setInputStreamClassReadFn s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 136) (val :: FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback)

-- | Set the value of the “@read_fn@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #readFn
-- @
clearInputStreamClassReadFn :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassReadFn s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 136) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassReadFnFieldInfo
instance AttrInfo InputStreamClassReadFnFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassReadFnFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassReadFnFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassReadFnFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassReadFnFieldInfo = (~)(FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback)
    type AttrTransferType InputStreamClassReadFnFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassReadFnFieldCallback)
    type AttrGetType InputStreamClassReadFnFieldInfo = Maybe Gio.Callbacks.InputStreamClassReadFnFieldCallback
    type AttrLabel InputStreamClassReadFnFieldInfo = "read_fn"
    type AttrOrigin InputStreamClassReadFnFieldInfo = InputStreamClass
    attrGet = getInputStreamClassReadFn
    attrSet = setInputStreamClassReadFn
    attrConstruct = undefined
    attrClear = clearInputStreamClassReadFn
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.readFn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:readFn"
        })

inputStreamClass_readFn :: AttrLabelProxy "readFn"
inputStreamClass_readFn = AttrLabelProxy

#endif


-- | Get the value of the “@skip@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #skip
-- @
getInputStreamClassSkip :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassSkipFieldCallback)
getInputStreamClassSkip s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 144) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassSkipFieldCallback val'
        return val''
    return result

-- | Set the value of the “@skip@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #skip 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassSkip :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback -> m ()
setInputStreamClassSkip s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 144) (val :: FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback)

-- | Set the value of the “@skip@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #skip
-- @
clearInputStreamClassSkip :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassSkip s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 144) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassSkipFieldInfo
instance AttrInfo InputStreamClassSkipFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassSkipFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassSkipFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassSkipFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassSkipFieldInfo = (~)(FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback)
    type AttrTransferType InputStreamClassSkipFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassSkipFieldCallback)
    type AttrGetType InputStreamClassSkipFieldInfo = Maybe Gio.Callbacks.InputStreamClassSkipFieldCallback
    type AttrLabel InputStreamClassSkipFieldInfo = "skip"
    type AttrOrigin InputStreamClassSkipFieldInfo = InputStreamClass
    attrGet = getInputStreamClassSkip
    attrSet = setInputStreamClassSkip
    attrConstruct = undefined
    attrClear = clearInputStreamClassSkip
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.skip"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:skip"
        })

inputStreamClass_skip :: AttrLabelProxy "skip"
inputStreamClass_skip = AttrLabelProxy

#endif


-- | Get the value of the “@close_fn@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #closeFn
-- @
getInputStreamClassCloseFn :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassCloseFnFieldCallback)
getInputStreamClassCloseFn s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 152) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassCloseFnFieldCallback val'
        return val''
    return result

-- | Set the value of the “@close_fn@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #closeFn 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassCloseFn :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback -> m ()
setInputStreamClassCloseFn s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 152) (val :: FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback)

-- | Set the value of the “@close_fn@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #closeFn
-- @
clearInputStreamClassCloseFn :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassCloseFn s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 152) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassCloseFnFieldInfo
instance AttrInfo InputStreamClassCloseFnFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassCloseFnFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassCloseFnFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassCloseFnFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassCloseFnFieldInfo = (~)(FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback)
    type AttrTransferType InputStreamClassCloseFnFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassCloseFnFieldCallback)
    type AttrGetType InputStreamClassCloseFnFieldInfo = Maybe Gio.Callbacks.InputStreamClassCloseFnFieldCallback
    type AttrLabel InputStreamClassCloseFnFieldInfo = "close_fn"
    type AttrOrigin InputStreamClassCloseFnFieldInfo = InputStreamClass
    attrGet = getInputStreamClassCloseFn
    attrSet = setInputStreamClassCloseFn
    attrConstruct = undefined
    attrClear = clearInputStreamClassCloseFn
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.closeFn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:closeFn"
        })

inputStreamClass_closeFn :: AttrLabelProxy "closeFn"
inputStreamClass_closeFn = AttrLabelProxy

#endif


-- | Get the value of the “@read_async@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #readAsync
-- @
getInputStreamClassReadAsync :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassReadAsyncFieldCallback_WithClosures)
getInputStreamClassReadAsync s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 160) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassReadAsyncFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassReadAsyncFieldCallback val'
        return val''
    return result

-- | Set the value of the “@read_async@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #readAsync 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassReadAsync :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassReadAsyncFieldCallback -> m ()
setInputStreamClassReadAsync s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 160) (val :: FunPtr Gio.Callbacks.C_InputStreamClassReadAsyncFieldCallback)

-- | Set the value of the “@read_async@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #readAsync
-- @
clearInputStreamClassReadAsync :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassReadAsync s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 160) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassReadAsyncFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassReadAsyncFieldInfo
instance AttrInfo InputStreamClassReadAsyncFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassReadAsyncFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassReadAsyncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassReadAsyncFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassReadAsyncFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassReadAsyncFieldInfo = (~)Gio.Callbacks.InputStreamClassReadAsyncFieldCallback_WithClosures
    type AttrTransferType InputStreamClassReadAsyncFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassReadAsyncFieldCallback)
    type AttrGetType InputStreamClassReadAsyncFieldInfo = Maybe Gio.Callbacks.InputStreamClassReadAsyncFieldCallback_WithClosures
    type AttrLabel InputStreamClassReadAsyncFieldInfo = "read_async"
    type AttrOrigin InputStreamClassReadAsyncFieldInfo = InputStreamClass
    attrGet = getInputStreamClassReadAsync
    attrSet = setInputStreamClassReadAsync
    attrConstruct = undefined
    attrClear = clearInputStreamClassReadAsync
    attrTransfer _ v = do
        Gio.Callbacks.mk_InputStreamClassReadAsyncFieldCallback (Gio.Callbacks.wrap_InputStreamClassReadAsyncFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.readAsync"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:readAsync"
        })

inputStreamClass_readAsync :: AttrLabelProxy "readAsync"
inputStreamClass_readAsync = AttrLabelProxy

#endif


-- | Get the value of the “@read_finish@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #readFinish
-- @
getInputStreamClassReadFinish :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassReadFinishFieldCallback)
getInputStreamClassReadFinish s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 168) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassReadFinishFieldCallback val'
        return val''
    return result

-- | Set the value of the “@read_finish@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #readFinish 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassReadFinish :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback -> m ()
setInputStreamClassReadFinish s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 168) (val :: FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback)

-- | Set the value of the “@read_finish@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #readFinish
-- @
clearInputStreamClassReadFinish :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassReadFinish s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 168) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassReadFinishFieldInfo
instance AttrInfo InputStreamClassReadFinishFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassReadFinishFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassReadFinishFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassReadFinishFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassReadFinishFieldInfo = (~)(FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback)
    type AttrTransferType InputStreamClassReadFinishFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassReadFinishFieldCallback)
    type AttrGetType InputStreamClassReadFinishFieldInfo = Maybe Gio.Callbacks.InputStreamClassReadFinishFieldCallback
    type AttrLabel InputStreamClassReadFinishFieldInfo = "read_finish"
    type AttrOrigin InputStreamClassReadFinishFieldInfo = InputStreamClass
    attrGet = getInputStreamClassReadFinish
    attrSet = setInputStreamClassReadFinish
    attrConstruct = undefined
    attrClear = clearInputStreamClassReadFinish
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.readFinish"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:readFinish"
        })

inputStreamClass_readFinish :: AttrLabelProxy "readFinish"
inputStreamClass_readFinish = AttrLabelProxy

#endif


-- | Get the value of the “@skip_async@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #skipAsync
-- @
getInputStreamClassSkipAsync :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassSkipAsyncFieldCallback_WithClosures)
getInputStreamClassSkipAsync s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 176) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassSkipAsyncFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassSkipAsyncFieldCallback val'
        return val''
    return result

-- | Set the value of the “@skip_async@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #skipAsync 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassSkipAsync :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassSkipAsyncFieldCallback -> m ()
setInputStreamClassSkipAsync s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 176) (val :: FunPtr Gio.Callbacks.C_InputStreamClassSkipAsyncFieldCallback)

-- | Set the value of the “@skip_async@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #skipAsync
-- @
clearInputStreamClassSkipAsync :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassSkipAsync s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 176) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassSkipAsyncFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassSkipAsyncFieldInfo
instance AttrInfo InputStreamClassSkipAsyncFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassSkipAsyncFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassSkipAsyncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassSkipAsyncFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassSkipAsyncFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassSkipAsyncFieldInfo = (~)Gio.Callbacks.InputStreamClassSkipAsyncFieldCallback_WithClosures
    type AttrTransferType InputStreamClassSkipAsyncFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassSkipAsyncFieldCallback)
    type AttrGetType InputStreamClassSkipAsyncFieldInfo = Maybe Gio.Callbacks.InputStreamClassSkipAsyncFieldCallback_WithClosures
    type AttrLabel InputStreamClassSkipAsyncFieldInfo = "skip_async"
    type AttrOrigin InputStreamClassSkipAsyncFieldInfo = InputStreamClass
    attrGet = getInputStreamClassSkipAsync
    attrSet = setInputStreamClassSkipAsync
    attrConstruct = undefined
    attrClear = clearInputStreamClassSkipAsync
    attrTransfer _ v = do
        Gio.Callbacks.mk_InputStreamClassSkipAsyncFieldCallback (Gio.Callbacks.wrap_InputStreamClassSkipAsyncFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.skipAsync"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:skipAsync"
        })

inputStreamClass_skipAsync :: AttrLabelProxy "skipAsync"
inputStreamClass_skipAsync = AttrLabelProxy

#endif


-- | Get the value of the “@skip_finish@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #skipFinish
-- @
getInputStreamClassSkipFinish :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassSkipFinishFieldCallback)
getInputStreamClassSkipFinish s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 184) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassSkipFinishFieldCallback val'
        return val''
    return result

-- | Set the value of the “@skip_finish@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #skipFinish 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassSkipFinish :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback -> m ()
setInputStreamClassSkipFinish s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 184) (val :: FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback)

-- | Set the value of the “@skip_finish@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #skipFinish
-- @
clearInputStreamClassSkipFinish :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassSkipFinish s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 184) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassSkipFinishFieldInfo
instance AttrInfo InputStreamClassSkipFinishFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassSkipFinishFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassSkipFinishFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassSkipFinishFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassSkipFinishFieldInfo = (~)(FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback)
    type AttrTransferType InputStreamClassSkipFinishFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassSkipFinishFieldCallback)
    type AttrGetType InputStreamClassSkipFinishFieldInfo = Maybe Gio.Callbacks.InputStreamClassSkipFinishFieldCallback
    type AttrLabel InputStreamClassSkipFinishFieldInfo = "skip_finish"
    type AttrOrigin InputStreamClassSkipFinishFieldInfo = InputStreamClass
    attrGet = getInputStreamClassSkipFinish
    attrSet = setInputStreamClassSkipFinish
    attrConstruct = undefined
    attrClear = clearInputStreamClassSkipFinish
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.skipFinish"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:skipFinish"
        })

inputStreamClass_skipFinish :: AttrLabelProxy "skipFinish"
inputStreamClass_skipFinish = AttrLabelProxy

#endif


-- | Get the value of the “@close_async@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #closeAsync
-- @
getInputStreamClassCloseAsync :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassCloseAsyncFieldCallback_WithClosures)
getInputStreamClassCloseAsync s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 192) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassCloseAsyncFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassCloseAsyncFieldCallback val'
        return val''
    return result

-- | Set the value of the “@close_async@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #closeAsync 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassCloseAsync :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassCloseAsyncFieldCallback -> m ()
setInputStreamClassCloseAsync s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 192) (val :: FunPtr Gio.Callbacks.C_InputStreamClassCloseAsyncFieldCallback)

-- | Set the value of the “@close_async@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #closeAsync
-- @
clearInputStreamClassCloseAsync :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassCloseAsync s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 192) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassCloseAsyncFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassCloseAsyncFieldInfo
instance AttrInfo InputStreamClassCloseAsyncFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassCloseAsyncFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassCloseAsyncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassCloseAsyncFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassCloseAsyncFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassCloseAsyncFieldInfo = (~)Gio.Callbacks.InputStreamClassCloseAsyncFieldCallback_WithClosures
    type AttrTransferType InputStreamClassCloseAsyncFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassCloseAsyncFieldCallback)
    type AttrGetType InputStreamClassCloseAsyncFieldInfo = Maybe Gio.Callbacks.InputStreamClassCloseAsyncFieldCallback_WithClosures
    type AttrLabel InputStreamClassCloseAsyncFieldInfo = "close_async"
    type AttrOrigin InputStreamClassCloseAsyncFieldInfo = InputStreamClass
    attrGet = getInputStreamClassCloseAsync
    attrSet = setInputStreamClassCloseAsync
    attrConstruct = undefined
    attrClear = clearInputStreamClassCloseAsync
    attrTransfer _ v = do
        Gio.Callbacks.mk_InputStreamClassCloseAsyncFieldCallback (Gio.Callbacks.wrap_InputStreamClassCloseAsyncFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.closeAsync"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:closeAsync"
        })

inputStreamClass_closeAsync :: AttrLabelProxy "closeAsync"
inputStreamClass_closeAsync = AttrLabelProxy

#endif


-- | Get the value of the “@close_finish@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputStreamClass #closeFinish
-- @
getInputStreamClassCloseFinish :: MonadIO m => InputStreamClass -> m (Maybe Gio.Callbacks.InputStreamClassCloseFinishFieldCallback)
getInputStreamClassCloseFinish s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 200) :: IO (FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_InputStreamClassCloseFinishFieldCallback val'
        return val''
    return result

-- | Set the value of the “@close_finish@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputStreamClass [ #closeFinish 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputStreamClassCloseFinish :: MonadIO m => InputStreamClass -> FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback -> m ()
setInputStreamClassCloseFinish s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 200) (val :: FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback)

-- | Set the value of the “@close_finish@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #closeFinish
-- @
clearInputStreamClassCloseFinish :: MonadIO m => InputStreamClass -> m ()
clearInputStreamClassCloseFinish s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 200) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InputStreamClassCloseFinishFieldInfo
instance AttrInfo InputStreamClassCloseFinishFieldInfo where
    type AttrBaseTypeConstraint InputStreamClassCloseFinishFieldInfo = (~) InputStreamClass
    type AttrAllowedOps InputStreamClassCloseFinishFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputStreamClassCloseFinishFieldInfo = (~) (FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback)
    type AttrTransferTypeConstraint InputStreamClassCloseFinishFieldInfo = (~)(FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback)
    type AttrTransferType InputStreamClassCloseFinishFieldInfo = (FunPtr Gio.Callbacks.C_InputStreamClassCloseFinishFieldCallback)
    type AttrGetType InputStreamClassCloseFinishFieldInfo = Maybe Gio.Callbacks.InputStreamClassCloseFinishFieldCallback
    type AttrLabel InputStreamClassCloseFinishFieldInfo = "close_finish"
    type AttrOrigin InputStreamClassCloseFinishFieldInfo = InputStreamClass
    attrGet = getInputStreamClassCloseFinish
    attrSet = setInputStreamClassCloseFinish
    attrConstruct = undefined
    attrClear = clearInputStreamClassCloseFinish
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputStreamClass.closeFinish"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-InputStreamClass.html#g:attr:closeFinish"
        })

inputStreamClass_closeFinish :: AttrLabelProxy "closeFinish"
inputStreamClass_closeFinish = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InputStreamClass
type instance O.AttributeList InputStreamClass = InputStreamClassAttributeList
type InputStreamClassAttributeList = ('[ '("parentClass", InputStreamClassParentClassFieldInfo), '("readFn", InputStreamClassReadFnFieldInfo), '("skip", InputStreamClassSkipFieldInfo), '("closeFn", InputStreamClassCloseFnFieldInfo), '("readAsync", InputStreamClassReadAsyncFieldInfo), '("readFinish", InputStreamClassReadFinishFieldInfo), '("skipAsync", InputStreamClassSkipAsyncFieldInfo), '("skipFinish", InputStreamClassSkipFinishFieldInfo), '("closeAsync", InputStreamClassCloseAsyncFieldInfo), '("closeFinish", InputStreamClassCloseFinishFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveInputStreamClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInputStreamClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInputStreamClassMethod t InputStreamClass, O.OverloadedMethod info InputStreamClass p) => OL.IsLabel t (InputStreamClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInputStreamClassMethod t InputStreamClass, O.OverloadedMethod info InputStreamClass p, R.HasField t InputStreamClass p) => R.HasField t InputStreamClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInputStreamClassMethod t InputStreamClass, O.OverloadedMethodInfo info InputStreamClass) => OL.IsLabel t (O.MethodProxy info InputStreamClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


