{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Constants
    ( 
    pattern WIN32_MSG_HANDLE                ,
    pattern VERSION_MIN_REQUIRED            ,
    pattern VA_COPY_AS_ARRAY                ,
    pattern USEC_PER_SEC                    ,
    pattern URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS,
    pattern URI_RESERVED_CHARS_GENERIC_DELIMITERS,
    pattern UNICHAR_MAX_DECOMPOSITION_LENGTH,
    pattern TIME_SPAN_SECOND                ,
    pattern TIME_SPAN_MINUTE                ,
    pattern TIME_SPAN_MILLISECOND           ,
    pattern TIME_SPAN_HOUR                  ,
    pattern TIME_SPAN_DAY                   ,
    pattern TEST_OPTION_NO_PRGNAME          ,
    pattern TEST_OPTION_NONFATAL_ASSERTIONS ,
    pattern TEST_OPTION_ISOLATE_DIRS        ,
    pattern SYSDEF_MSG_PEEK                 ,
    pattern SYSDEF_MSG_OOB                  ,
    pattern SYSDEF_MSG_DONTROUTE            ,
    pattern SYSDEF_AF_UNIX                  ,
    pattern SYSDEF_AF_INET6                 ,
    pattern SYSDEF_AF_INET                  ,
    pattern STR_DELIMITERS                  ,
    pattern SQRT2                           ,
    pattern SOURCE_REMOVE                   ,
    pattern SOURCE_CONTINUE                 ,
    pattern SIZEOF_VOID_P                   ,
    pattern SIZEOF_SSIZE_T                  ,
    pattern SIZEOF_SIZE_T                   ,
    pattern SIZEOF_LONG                     ,
    pattern SEARCHPATH_SEPARATOR_S          ,
    pattern SEARCHPATH_SEPARATOR            ,
    pattern REF_COUNT_INIT                  ,
    pattern PRIORITY_LOW                    ,
    pattern PRIORITY_HIGH_IDLE              ,
    pattern PRIORITY_HIGH                   ,
    pattern PRIORITY_DEFAULT_IDLE           ,
    pattern PRIORITY_DEFAULT                ,
    pattern POLLFD_FORMAT                   ,
    pattern PI_4                            ,
    pattern PI_2                            ,
    pattern PID_FORMAT                      ,
    pattern PI                              ,
    pattern PDP_ENDIAN                      ,
    pattern OPTION_REMAINING                ,
    pattern MODULE_SUFFIX                   ,
    pattern MINOR_VERSION                   ,
    pattern MININT8                         ,
    pattern MININT64                        ,
    pattern MININT32                        ,
    pattern MININT16                        ,
    pattern MICRO_VERSION                   ,
    pattern MAXUINT8                        ,
    pattern MAXUINT64                       ,
    pattern MAXUINT32                       ,
    pattern MAXUINT16                       ,
    pattern MAXINT8                         ,
    pattern MAXINT64                        ,
    pattern MAXINT32                        ,
    pattern MAXINT16                        ,
    pattern MAJOR_VERSION                   ,
    pattern LOG_LEVEL_USER_SHIFT            ,
    pattern LOG_FATAL_MASK                  ,
    pattern LOG_DOMAIN                      ,
    pattern LOG_2_BASE_10                   ,
    pattern LN2                             ,
    pattern LN10                            ,
    pattern LITTLE_ENDIAN                   ,
    pattern KEY_FILE_DESKTOP_TYPE_LINK      ,
    pattern KEY_FILE_DESKTOP_TYPE_DIRECTORY ,
    pattern KEY_FILE_DESKTOP_TYPE_APPLICATION,
    pattern KEY_FILE_DESKTOP_KEY_VERSION    ,
    pattern KEY_FILE_DESKTOP_KEY_URL        ,
    pattern KEY_FILE_DESKTOP_KEY_TYPE       ,
    pattern KEY_FILE_DESKTOP_KEY_TRY_EXEC   ,
    pattern KEY_FILE_DESKTOP_KEY_TERMINAL   ,
    pattern KEY_FILE_DESKTOP_KEY_STARTUP_WM_CLASS,
    pattern KEY_FILE_DESKTOP_KEY_STARTUP_NOTIFY,
    pattern KEY_FILE_DESKTOP_KEY_PATH       ,
    pattern KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN,
    pattern KEY_FILE_DESKTOP_KEY_NO_DISPLAY ,
    pattern KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN,
    pattern KEY_FILE_DESKTOP_KEY_NAME       ,
    pattern KEY_FILE_DESKTOP_KEY_MIME_TYPE  ,
    pattern KEY_FILE_DESKTOP_KEY_ICON       ,
    pattern KEY_FILE_DESKTOP_KEY_HIDDEN     ,
    pattern KEY_FILE_DESKTOP_KEY_GENERIC_NAME,
    pattern KEY_FILE_DESKTOP_KEY_EXEC       ,
    pattern KEY_FILE_DESKTOP_KEY_DBUS_ACTIVATABLE,
    pattern KEY_FILE_DESKTOP_KEY_COMMENT    ,
    pattern KEY_FILE_DESKTOP_KEY_CATEGORIES ,
    pattern KEY_FILE_DESKTOP_KEY_ACTIONS    ,
    pattern KEY_FILE_DESKTOP_GROUP          ,
    pattern IEEE754_FLOAT_BIAS              ,
    pattern IEEE754_DOUBLE_BIAS             ,
    pattern HOOK_FLAG_USER_SHIFT            ,
    pattern HAVE_ISO_VARARGS                ,
    pattern HAVE_GROWING_STACK              ,
    pattern HAVE_GNUC_VISIBILITY            ,
    pattern HAVE_GNUC_VARARGS               ,
    pattern HAVE_GINT64                     ,
    pattern GUINTPTR_FORMAT                 ,
    pattern GUINT64_FORMAT                  ,
    pattern GUINT32_FORMAT                  ,
    pattern GUINT16_FORMAT                  ,
    pattern GSSIZE_MODIFIER                 ,
    pattern GSSIZE_FORMAT                   ,
    pattern GSIZE_MODIFIER                  ,
    pattern GSIZE_FORMAT                    ,
    pattern GNUC_PRETTY_FUNCTION            ,
    pattern GNUC_FUNCTION                   ,
    pattern GINTPTR_MODIFIER                ,
    pattern GINTPTR_FORMAT                  ,
    pattern GINT64_MODIFIER                 ,
    pattern GINT64_FORMAT                   ,
    pattern GINT32_MODIFIER                 ,
    pattern GINT32_FORMAT                   ,
    pattern GINT16_MODIFIER                 ,
    pattern GINT16_FORMAT                   ,
    pattern E                               ,
    pattern DIR_SEPARATOR_S                 ,
    pattern DIR_SEPARATOR                   ,
    pattern DATE_BAD_YEAR                   ,
    pattern DATE_BAD_JULIAN                 ,
    pattern DATE_BAD_DAY                    ,
    pattern DATALIST_FLAGS_MASK             ,
    pattern C_STD_VERSION                   ,
    pattern CSET_a_2_z                      ,
    pattern CSET_DIGITS                     ,
    pattern CSET_A_2_Z                      ,
    pattern C'macro__has_attribute_no_sanitize_address,
    pattern C'macro__has_attribute_ifunc    ,
    pattern C'macro__has_attribute___noreturn__,
    pattern BIG_ENDIAN                      ,
    pattern ATOMIC_REF_COUNT_INIT           ,
    pattern ASCII_DTOSTR_BUF_SIZE           ,
    pattern ANALYZER_ANALYZING              ,
    pattern ALLOC_ONLY                      ,
    pattern ALLOC_AND_FREE                  ,
    pattern ALLOCATOR_SLIST                 ,
    pattern ALLOCATOR_NODE                  ,
    pattern ALLOCATOR_LIST                  ,

    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | /No description available in the introspection data./
pattern WIN32_MSG_HANDLE = 19981206 :: Int32

-- | A macro that should be defined by the user prior to including
-- the glib.h header.
-- The definition should be one of the predefined GLib version
-- macros: @/GLIB_VERSION_2_26/@, @/GLIB_VERSION_2_28/@,...
-- 
-- This macro defines the earliest version of GLib that the package is
-- required to be able to compile against.
-- 
-- If the compiler is configured to warn about the use of deprecated
-- functions, then using functions that were deprecated in version
-- 'GI.GLib.Constants.VERSION_MIN_REQUIRED' or earlier will cause warnings (but
-- using functions deprecated in later releases will not).
-- 
-- /Since: 2.32/
pattern VERSION_MIN_REQUIRED = 2 :: Int32

-- | /No description available in the introspection data./
pattern VA_COPY_AS_ARRAY = 1 :: Int32

-- | Number of microseconds in one second (1 million).
-- This macro is provided for code readability.
pattern USEC_PER_SEC = 1000000 :: Int32

-- | Subcomponent delimiter characters as defined in
-- <https://tools.ietf.org/html/rfc3986 RFC 3986>. Includes @!$&\'()*+,;=@.
-- 
-- /Since: 2.16/
pattern URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS = "!$&'()*+,;=" :: T.Text

-- | Generic delimiters characters as defined in
-- <https://tools.ietf.org/html/rfc3986 RFC 3986>. Includes @:\/?#[]\@@.
-- 
-- /Since: 2.16/
pattern URI_RESERVED_CHARS_GENERIC_DELIMITERS = ":/?#[]@" :: T.Text

-- | The maximum length (in codepoints) of a compatibility or canonical
-- decomposition of a single Unicode character.
-- 
-- This is as defined by Unicode 6.1.
-- 
-- /Since: 2.32/
pattern UNICHAR_MAX_DECOMPOSITION_LENGTH = 18 :: Int32

-- | Evaluates to a time span of one second.
-- 
-- /Since: 2.26/
pattern TIME_SPAN_SECOND = 1000000 :: Int64

-- | Evaluates to a time span of one minute.
-- 
-- /Since: 2.26/
pattern TIME_SPAN_MINUTE = 60000000 :: Int64

-- | Evaluates to a time span of one millisecond.
-- 
-- /Since: 2.26/
pattern TIME_SPAN_MILLISECOND = 1000 :: Int64

-- | Evaluates to a time span of one hour.
-- 
-- /Since: 2.26/
pattern TIME_SPAN_HOUR = 3600000000 :: Int64

-- | Evaluates to a time span of one day.
-- 
-- /Since: 2.26/
pattern TIME_SPAN_DAY = 86400000000 :: Int64

-- | A value that can be passed as an option to @/GLib.test_init/@.
-- 
-- If this option is given, @/GLib.test_init/@ will not call 'GI.GLib.Functions.setPrgname'.
-- 
-- /Since: 2.84/
pattern TEST_OPTION_NO_PRGNAME = "no_g_set_prgname" :: T.Text

-- | A value that can be passed as an option to @/GLib.test_init/@.
-- 
-- If this option is given, assertions will not abort the process, but
-- call 'GI.GLib.Functions.testFail'. Equivalent to 'GI.GLib.Functions.testSetNonfatalAssertions'.
-- 
-- /Since: 2.84/
pattern TEST_OPTION_NONFATAL_ASSERTIONS = "nonfatal-assertions" :: T.Text

-- | A value that can be passed as an option to @/GLib.test_init/@.
-- 
-- Creates a unique temporary directory for each unit test and uses sets
-- XDG directories to point into subdirectories of it for the duration of
-- the unit test. The directory tree is cleaned up after the test finishes
-- successfully.
-- 
-- Note that this doesn’t take effect until 'GI.GLib.Functions.testRun' is called,
-- so calls to (for example) 'GI.GLib.Functions.getHomeDir' will return the
-- system-wide value when made in a test program’s @/main()/@ function.
-- 
-- The following functions will return subdirectories of the temporary directory
-- when this option is used. The specific subdirectory paths in use are not
-- guaranteed to be stable API — always use a getter function to retrieve them.
-- 
-- * 'GI.GLib.Functions.getHomeDir'
-- * 'GI.GLib.Functions.getUserCacheDir'
-- * 'GI.GLib.Functions.getSystemConfigDirs'
-- * 'GI.GLib.Functions.getUserConfigDir'
-- * 'GI.GLib.Functions.getSystemDataDirs'
-- * 'GI.GLib.Functions.getUserDataDir'
-- * 'GI.GLib.Functions.getUserStateDir'
-- * 'GI.GLib.Functions.getUserRuntimeDir'
-- 
-- 
-- The subdirectories may not be created by the test harness; as with normal
-- calls to functions like 'GI.GLib.Functions.getUserCacheDir', the caller must
-- be prepared to create the directory if it doesn’t exist.
-- 
-- /Since: 2.60/
pattern TEST_OPTION_ISOLATE_DIRS = "isolate_dirs" :: T.Text

-- | /No description available in the introspection data./
pattern SYSDEF_MSG_PEEK = 2 :: Int32

-- | /No description available in the introspection data./
pattern SYSDEF_MSG_OOB = 1 :: Int32

-- | /No description available in the introspection data./
pattern SYSDEF_MSG_DONTROUTE = 4 :: Int32

-- | /No description available in the introspection data./
pattern SYSDEF_AF_UNIX = 1 :: Int32

-- | /No description available in the introspection data./
pattern SYSDEF_AF_INET6 = 10 :: Int32

-- | /No description available in the introspection data./
pattern SYSDEF_AF_INET = 2 :: Int32

-- | The standard delimiters, used in 'GI.GLib.Functions.strdelimit'.
pattern STR_DELIMITERS = "_-|> <." :: T.Text

-- | The square root of two.
pattern SQRT2 = 1.414214 :: Double

-- | Use this macro as the return value of a [callback/@gLib@/.SourceFunc] to remove
-- the t'GI.GLib.Structs.Source.Source' from the main loop.
-- 
-- /Since: 2.32/
pattern SOURCE_REMOVE = P.False :: Bool

-- | Use this macro as the return value of a [callback/@gLib@/.SourceFunc] to leave
-- the t'GI.GLib.Structs.Source.Source' in the main loop.
-- 
-- /Since: 2.32/
pattern SOURCE_CONTINUE = P.True :: Bool

-- | /No description available in the introspection data./
pattern SIZEOF_VOID_P = 8 :: Int32

-- | /No description available in the introspection data./
pattern SIZEOF_SSIZE_T = 8 :: Int32

-- | /No description available in the introspection data./
pattern SIZEOF_SIZE_T = 8 :: Int32

-- | /No description available in the introspection data./
pattern SIZEOF_LONG = 8 :: Int32

-- | The search path separator as a string.
-- This is \":\" on UNIX machines and \";\" under Windows.
pattern SEARCHPATH_SEPARATOR_S = ":" :: T.Text

-- | The search path separator character.
-- This is \':\' on UNIX machines and \';\' under Windows.
pattern SEARCHPATH_SEPARATOR = 58 :: Int32

-- | Evaluates to the initial reference count for @grefcount@.
-- 
-- This macro is useful for initializing @grefcount@ fields inside
-- structures, for instance:
-- 
-- 
-- === /C code/
-- >
-- >typedef struct {
-- >  grefcount ref_count;
-- >  char *name;
-- >  char *address;
-- >} Person;
-- >
-- >static const Person default_person = {
-- >  .ref_count = G_REF_COUNT_INIT,
-- >  .name = "Default name",
-- >  .address = "Default address",
-- >};
-- 
-- 
-- /Since: 2.78/
pattern REF_COUNT_INIT = -1 :: Int32

-- | Use this for very low priority background tasks.
-- 
-- It is not used within GLib or GTK.
pattern PRIORITY_LOW = 300 :: Int32

-- | Use this for high priority idle functions.
-- 
-- GTK uses 'GI.GLib.Constants.PRIORITY_HIGH_IDLE' + 10 for resizing operations,
-- and 'GI.GLib.Constants.PRIORITY_HIGH_IDLE' + 20 for redrawing operations. (This is
-- done to ensure that any pending resizes are processed before any
-- pending redraws, so that widgets are not redrawn twice unnecessarily.)
pattern PRIORITY_HIGH_IDLE = 100 :: Int32

-- | Use this for high priority event sources.
-- 
-- It is not used within GLib or GTK.
pattern PRIORITY_HIGH = -100 :: Int32

-- | Use this for default priority idle functions.
-- 
-- In GLib this priority is used when adding idle functions with
-- 'GI.GLib.Functions.idleAdd'.
pattern PRIORITY_DEFAULT_IDLE = 200 :: Int32

-- | Use this for default priority event sources.
-- 
-- In GLib this priority is used when adding timeout functions
-- with 'GI.GLib.Functions.timeoutAdd'. In GDK this priority is used for events
-- from the X server.
pattern PRIORITY_DEFAULT = 0 :: Int32

-- | A format specifier that can be used in @/printf()/@-style format strings
-- when printing the /@fd@/ member of a t'GI.GLib.Structs.PollFD.PollFD'.
pattern POLLFD_FORMAT = "%d" :: T.Text

-- | Pi divided by 4.
pattern PI_4 = 0.785398 :: Double

-- | Pi divided by 2.
pattern PI_2 = 1.570796 :: Double

-- | A format specifier that can be used in @/printf()/@-style format strings
-- when printing a @/GPid/@.
-- 
-- /Since: 2.50/
pattern PID_FORMAT = "i" :: T.Text

-- | The value of pi (ratio of circle\'s circumference to its diameter).
pattern PI = 3.141593 :: Double

-- | Specifies one of the possible types of byte order
-- (currently unused). See @/G_BYTE_ORDER/@.
pattern PDP_ENDIAN = 3412 :: Int32

-- | If a long option in the main group has this name, it is not treated as a
-- regular option. Instead it collects all non-option arguments which would
-- otherwise be left in @argv@. The option must be of type
-- 'GI.GLib.Enums.OptionArgCallback', 'GI.GLib.Enums.OptionArgStringArray'
-- or 'GI.GLib.Enums.OptionArgFilenameArray'.
-- 
-- 
-- Using 'GI.GLib.Constants.OPTION_REMAINING' instead of simply scanning @argv@
-- for leftover arguments has the advantage that GOption takes care of
-- necessary encoding conversions for strings or filenames.
-- 
-- /Since: 2.6/
pattern OPTION_REMAINING = "" :: T.Text

-- | /No description available in the introspection data./
pattern MODULE_SUFFIX = "so" :: T.Text

-- | The minor version number of the GLib library.
-- 
-- Like @/gtk_minor_version/@, but from the headers used at
-- application compile time, rather than from the library
-- linked against at application run time.
pattern MINOR_VERSION = 86 :: Int32

-- | The minimum value which can be held in a @/gint8/@.
-- 
-- /Since: 2.4/
pattern MININT8 = -128 :: Int8

-- | The minimum value which can be held in a @/gint64/@.
pattern MININT64 = -9223372036854775808 :: Int64

-- | The minimum value which can be held in a @/gint32/@.
-- 
-- /Since: 2.4/
pattern MININT32 = -2147483648 :: Int32

-- | The minimum value which can be held in a @/gint16/@.
-- 
-- /Since: 2.4/
pattern MININT16 = -32768 :: Int16

-- | The micro version number of the GLib library.
-- 
-- Like @/gtk_micro_version/@, but from the headers used at
-- application compile time, rather than from the library
-- linked against at application run time.
pattern MICRO_VERSION = 2 :: Int32

-- | /No description available in the introspection data./
pattern MAXUINT8 = 255 :: Word8

-- | /No description available in the introspection data./
pattern MAXUINT64 = 18446744073709551615 :: Word64

-- | /No description available in the introspection data./
pattern MAXUINT32 = 4294967295 :: Word32

-- | /No description available in the introspection data./
pattern MAXUINT16 = 65535 :: Word16

-- | /No description available in the introspection data./
pattern MAXINT8 = 127 :: Int8

-- | /No description available in the introspection data./
pattern MAXINT64 = 9223372036854775807 :: Int64

-- | /No description available in the introspection data./
pattern MAXINT32 = 2147483647 :: Int32

-- | /No description available in the introspection data./
pattern MAXINT16 = 32767 :: Int16

-- | The major version number of the GLib library.
-- 
-- Like @/glib_major_version/@, but from the headers used at
-- application compile time, rather than from the library
-- linked against at application run time.
pattern MAJOR_VERSION = 2 :: Int32

-- | Log levels below @1\<\<G_LOG_LEVEL_USER_SHIFT@ are used by GLib.
-- Higher bits can be used for user-defined log levels.
pattern LOG_LEVEL_USER_SHIFT = 8 :: Int32

-- | GLib log levels that are considered fatal by default.
-- 
-- This is not used if structured logging is enabled; see
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
pattern LOG_FATAL_MASK = 5 :: Int32

-- | Defines the log domain. See <http://developer.gnome.org/glib/stable/#log-domains Log Domains>.
-- 
-- Libraries should define this so that any messages
-- which they log can be differentiated from messages from other
-- libraries and application code. But be careful not to define
-- it in any public header files.
-- 
-- Log domains must be unique, and it is recommended that they are the
-- application or library name, optionally followed by a hyphen and a sub-domain
-- name. For example, @bloatpad@ or @bloatpad-io@.
-- 
-- If undefined, it defaults to the default 'P.Nothing' (or @\"\"@) log domain; this is
-- not advisable, as it cannot be filtered against using the @G_MESSAGES_DEBUG@
-- environment variable.
-- 
-- For example, GTK uses this in its @Makefile.am@:
-- 
-- 	
-- >
-- >AM_CPPFLAGS = -DG_LOG_DOMAIN=\"Gtk\"
-- 
-- 
-- Applications can choose to leave it as the default 'P.Nothing' (or @\"\"@)
-- domain. However, defining the domain offers the same advantages as
-- above.
pattern LOG_DOMAIN = 0 :: Int8

-- | Multiplying the base 2 exponent by this number yields the base 10 exponent.
pattern LOG_2_BASE_10 = 0.301030 :: Double

-- | The natural logarithm of 2.
pattern LN2 = 0.693147 :: Double

-- | The natural logarithm of 10.
pattern LN10 = 2.302585 :: Double

-- | Specifies one of the possible types of byte order.
-- See @/G_BYTE_ORDER/@.
pattern LITTLE_ENDIAN = 1234 :: Int32

-- | The value of the [const/@gLib@/.KEY_FILE_DESKTOP_KEY_TYPE], key for desktop
-- entries representing links to documents.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_TYPE_LINK = "Link" :: T.Text

-- | The value of the [const/@gLib@/.KEY_FILE_DESKTOP_KEY_TYPE], key for desktop
-- entries representing directories.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_TYPE_DIRECTORY = "Directory" :: T.Text

-- | The value of the [const/@gLib@/.KEY_FILE_DESKTOP_KEY_TYPE], key for desktop
-- entries representing applications.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_TYPE_APPLICATION = "Application" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string
-- giving the version of the Desktop Entry Specification used for
-- the desktop entry file.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_VERSION = "Version" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string
-- giving the URL to access.
-- 
-- It is only valid for desktop entries with the @Link@ type.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_URL = "URL" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string
-- giving the type of the desktop entry.
-- 
-- Usually [const/@gLib@/.KEY_FILE_DESKTOP_TYPE_APPLICATION],
-- [const/@gLib@/.KEY_FILE_DESKTOP_TYPE_LINK], or
-- [const/@gLib@/.KEY_FILE_DESKTOP_TYPE_DIRECTORY].
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_TYPE = "Type" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string
-- giving the file name of a binary on disk used to determine if the
-- program is actually installed.
-- 
-- It is only valid for desktop entries with the @Application@ type.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_TRY_EXEC = "TryExec" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
-- stating whether the program should be run in a terminal window.
-- 
-- It is only valid for desktop entries with the @Application@ type.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_TERMINAL = "Terminal" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is string
-- identifying the WM class or name hint of a window that the application
-- will create, which can be used to emulate
-- <https://specifications.freedesktop.org/startup-notification-spec/latest/ Startup Notification>
-- with older applications.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_STARTUP_WM_CLASS = "StartupWMClass" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
-- stating whether the application supports the
-- <https://specifications.freedesktop.org/startup-notification-spec/latest/ Startup Notification Protocol Specification>.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_STARTUP_NOTIFY = "StartupNotify" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string
-- containing the working directory to run the program in.
-- 
-- It is only valid for desktop entries with the @Application@ type.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_PATH = "Path" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a list of
-- strings identifying the environments that should display the
-- desktop entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN = "OnlyShowIn" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
-- stating whether the desktop entry should be shown in menus.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_NO_DISPLAY = "NoDisplay" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a list of
-- strings identifying the environments that should not display the
-- desktop entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN = "NotShowIn" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a localized
-- string giving the specific name of the desktop entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_NAME = "Name" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a list
-- of strings giving the MIME types supported by this desktop entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_MIME_TYPE = "MimeType" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a localized
-- string giving the name of the icon to be displayed for the desktop
-- entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_ICON = "Icon" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
-- stating whether the desktop entry has been deleted by the user.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_HIDDEN = "Hidden" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a localized
-- string giving the generic name of the desktop entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_GENERIC_NAME = "GenericName" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string
-- giving the command line to execute.
-- 
-- It is only valid for desktop entries with the @Application@ type.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_EXEC = "Exec" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
-- set to true if the application is D-Bus activatable.
-- 
-- /Since: 2.38/
pattern KEY_FILE_DESKTOP_KEY_DBUS_ACTIVATABLE = "DBusActivatable" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a localized
-- string giving the tooltip for the desktop entry.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_COMMENT = "Comment" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a list
-- of strings giving the categories in which the desktop entry
-- should be shown in a menu.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_KEY_CATEGORIES = "Categories" :: T.Text

-- | A key under [const/@gLib@/.KEY_FILE_DESKTOP_GROUP], whose value is a string list
-- giving the available application actions.
-- 
-- /Since: 2.38/
pattern KEY_FILE_DESKTOP_KEY_ACTIONS = "Actions" :: T.Text

-- | The name of the main group of a desktop entry file, as defined in the
-- <https://specifications.freedesktop.org/desktop-entry-spec/latest/ Desktop Entry Specification>.
-- 
-- Consult the specification for more
-- details about the meanings of the keys below.
-- 
-- /Since: 2.14/
pattern KEY_FILE_DESKTOP_GROUP = "Desktop Entry" :: T.Text

-- | The bias by which exponents in single-precision floats are offset.
pattern IEEE754_FLOAT_BIAS = 127 :: Int32

-- | The bias by which exponents in double-precision floats are offset.
pattern IEEE754_DOUBLE_BIAS = 1023 :: Int32

-- | The position of the first bit which is not reserved for internal
-- use be the t'GI.GLib.Structs.Hook.Hook' implementation, i.e.
-- @1 \<\< G_HOOK_FLAG_USER_SHIFT@ is the first
-- bit which can be used for application-defined flags.
pattern HOOK_FLAG_USER_SHIFT = 4 :: Int32

-- | /No description available in the introspection data./
pattern HAVE_ISO_VARARGS = 1 :: Int32

-- | /No description available in the introspection data./
pattern HAVE_GROWING_STACK = 0 :: Int32

-- | Defined to 1 if gcc-style visibility handling is supported.
pattern HAVE_GNUC_VISIBILITY = 1 :: Int32

-- | /No description available in the introspection data./
pattern HAVE_GNUC_VARARGS = 1 :: Int32

-- | /No description available in the introspection data./
pattern HAVE_GINT64 = 1 :: Int32

-- | /No description available in the introspection data./
pattern GUINTPTR_FORMAT = "lu" :: T.Text

-- | /No description available in the introspection data./
pattern GUINT64_FORMAT = "lu" :: T.Text

-- | /No description available in the introspection data./
pattern GUINT32_FORMAT = "u" :: T.Text

-- | /No description available in the introspection data./
pattern GUINT16_FORMAT = "hu" :: T.Text

-- | /No description available in the introspection data./
pattern GSSIZE_MODIFIER = "l" :: T.Text

-- | /No description available in the introspection data./
pattern GSSIZE_FORMAT = "li" :: T.Text

-- | /No description available in the introspection data./
pattern GSIZE_MODIFIER = "l" :: T.Text

-- | /No description available in the introspection data./
pattern GSIZE_FORMAT = "lu" :: T.Text

{-# DEPRECATED GNUC_PRETTY_FUNCTION ["(Since version 2.16)","Use @/G_STRFUNC()/@ instead"] #-}
-- | Expands to \"\" on all modern compilers, and to __PRETTY_FUNCTION__
-- on gcc version 2.x. Don\'t use it.
pattern GNUC_PRETTY_FUNCTION = "" :: T.Text

{-# DEPRECATED GNUC_FUNCTION ["(Since version 2.16)","Use @/G_STRFUNC()/@ instead"] #-}
-- | Expands to \"\" on all modern compilers, and to  __FUNCTION__ on gcc
-- version 2.x. Don\'t use it.
pattern GNUC_FUNCTION = "" :: T.Text

-- | /No description available in the introspection data./
pattern GINTPTR_MODIFIER = "l" :: T.Text

-- | /No description available in the introspection data./
pattern GINTPTR_FORMAT = "li" :: T.Text

-- | /No description available in the introspection data./
pattern GINT64_MODIFIER = "l" :: T.Text

-- | /No description available in the introspection data./
pattern GINT64_FORMAT = "li" :: T.Text

-- | /No description available in the introspection data./
pattern GINT32_MODIFIER = "" :: T.Text

-- | /No description available in the introspection data./
pattern GINT32_FORMAT = "i" :: T.Text

-- | /No description available in the introspection data./
pattern GINT16_MODIFIER = "h" :: T.Text

-- | /No description available in the introspection data./
pattern GINT16_FORMAT = "hi" :: T.Text

-- | The base of natural logarithms.
pattern E = 2.718282 :: Double

-- | The directory separator as a string.
-- 
-- This is @\"\/\"@ on UNIX machines and @\"\\\"@ under Windows.
pattern DIR_SEPARATOR_S = "/" :: T.Text

-- | The directory separator character.
-- 
-- This is @\'\/\'@ on UNIX machines and @\'\\\'@ under Windows.
pattern DIR_SEPARATOR = 47 :: Int32

-- | Represents an invalid year.
pattern DATE_BAD_YEAR = 0 :: Int32

-- | Represents an invalid Julian day number.
pattern DATE_BAD_JULIAN = 0 :: Int32

-- | Represents an invalid @/GDateDay/@.
pattern DATE_BAD_DAY = 0 :: Int32

-- | A bitmask that restricts the possible flags passed to
-- 'GI.GLib.Functions.datalistSetFlags'. Passing a flags value where
-- flags & ~G_DATALIST_FLAGS_MASK != 0 is an error.
pattern DATALIST_FLAGS_MASK = 3 :: Int32

-- | The C standard version the code is compiling against, it\'s normally
-- defined with the same value of @__STDC_VERSION__@ for C standard
-- compatible compilers, while it uses the lowest standard version
-- in pure MSVC, given that in such compiler the definition depends on
-- a compilation flag.
-- 
-- This is granted to be undefined when compiling with a C++ compiler.
-- 
-- See also: @/G_C_STD_CHECK_VERSION/@ and @/G_CXX_STD_VERSION/@
-- 
-- /Since: 2.76/
pattern C_STD_VERSION = 199000 :: Int32

-- | The set of lowercase ASCII alphabet characters.
-- Used for specifying valid identifier characters
-- in t'GI.GLib.Structs.ScannerConfig.ScannerConfig'.
pattern CSET_a_2_z = "abcdefghijklmnopqrstuvwxyz" :: T.Text

-- | The set of ASCII digits.
-- Used for specifying valid identifier characters
-- in t'GI.GLib.Structs.ScannerConfig.ScannerConfig'.
pattern CSET_DIGITS = "0123456789" :: T.Text

-- | The set of uppercase ASCII alphabet characters.
-- Used for specifying valid identifier characters
-- in t'GI.GLib.Structs.ScannerConfig.ScannerConfig'.
pattern CSET_A_2_Z = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" :: T.Text

-- | /No description available in the introspection data./
pattern C'macro__has_attribute_no_sanitize_address = 0 :: Int32

-- | /No description available in the introspection data./
pattern C'macro__has_attribute_ifunc = 0 :: Int32

-- | /No description available in the introspection data./
pattern C'macro__has_attribute___noreturn__ = 0 :: Int32

-- | Specifies one of the possible types of byte order.
-- See @/G_BYTE_ORDER/@.
pattern BIG_ENDIAN = 4321 :: Int32

-- | Evaluates to the initial reference count for @gatomicrefcount@.
-- 
-- This macro is useful for initializing @gatomicrefcount@ fields inside
-- structures, for instance:
-- 
-- 
-- === /C code/
-- >
-- >typedef struct {
-- >  gatomicrefcount ref_count;
-- >  char *name;
-- >  char *address;
-- >} Person;
-- >
-- >static const Person default_person = {
-- >  .ref_count = G_ATOMIC_REF_COUNT_INIT,
-- >  .name = "Default name",
-- >  .address = "Default address",
-- >};
-- 
-- 
-- /Since: 2.78/
pattern ATOMIC_REF_COUNT_INIT = 1 :: Int32

-- | A good size for a buffer to be passed into 'GI.GLib.Functions.asciiDtostr'.
-- It is guaranteed to be enough for all output of that function
-- on systems with 64bit IEEE-compatible doubles.
-- 
-- The typical usage would be something like:
-- 
-- === /C code/
-- >char buf[G_ASCII_DTOSTR_BUF_SIZE];
-- >
-- >fprintf (out, "value=%s\n", g_ascii_dtostr (buf, sizeof (buf), value));
pattern ASCII_DTOSTR_BUF_SIZE = 39 :: Int32

-- | /No description available in the introspection data./
pattern ANALYZER_ANALYZING = 1 :: Int32

{-# DEPRECATED ALLOC_ONLY ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
pattern ALLOC_ONLY = 1 :: Int32

{-# DEPRECATED ALLOC_AND_FREE ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
pattern ALLOC_AND_FREE = 2 :: Int32

{-# DEPRECATED ALLOCATOR_SLIST ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
pattern ALLOCATOR_SLIST = 2 :: Int32

{-# DEPRECATED ALLOCATOR_NODE ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
pattern ALLOCATOR_NODE = 3 :: Int32

{-# DEPRECATED ALLOCATOR_LIST ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
pattern ALLOCATOR_LIST = 1 :: Int32


