{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GTypeModule@ provides a simple implementation of the @GTypePlugin@
-- interface.
-- 
-- The model of @GTypeModule@ is a dynamically loaded module which
-- implements some number of types and interface implementations.
-- 
-- When the module is loaded, it registers its types and interfaces
-- using 'GI.GObject.Objects.TypeModule.typeModuleRegisterType' and
-- 'GI.GObject.Objects.TypeModule.typeModuleAddInterface'.
-- As long as any instances of these types and interface implementations
-- are in use, the module is kept loaded. When the types and interfaces
-- are gone, the module may be unloaded. If the types and interfaces
-- become used again, the module will be reloaded. Note that the last
-- reference cannot be released from within the module code, since that
-- would lead to the caller\'s code being unloaded before @g_object_unref()@
-- returns to it.
-- 
-- Keeping track of whether the module should be loaded or not is done by
-- using a use count - it starts at zero, and whenever it is greater than
-- zero, the module is loaded. The use count is maintained internally by
-- the type system, but also can be explicitly controlled by
-- 'GI.GObject.Objects.TypeModule.typeModuleUse' and 'GI.GObject.Objects.TypeModule.typeModuleUnuse'.
-- Typically, when loading a module for the first type, @g_type_module_use()@
-- will be used to load it so that it can initialize its types. At some later
-- point, when the module no longer needs to be loaded except for the type
-- implementations it contains, @g_type_module_unuse()@ is called.
-- 
-- @GTypeModule@ does not actually provide any implementation of module
-- loading and unloading. To create a particular module type you must
-- derive from @GTypeModule@ and implement the load and unload functions
-- in @GTypeModuleClass@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Objects.TypeModule
    ( 

-- * Exported types
    TypeModule(..)                          ,
    IsTypeModule                            ,
    toTypeModule                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addInterface]("GI.GObject.Objects.TypeModule#g:method:addInterface"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [completeInterfaceInfo]("GI.GObject.Interfaces.TypePlugin#g:method:completeInterfaceInfo"), [completeTypeInfo]("GI.GObject.Interfaces.TypePlugin#g:method:completeTypeInfo"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [registerEnum]("GI.GObject.Objects.TypeModule#g:method:registerEnum"), [registerFlags]("GI.GObject.Objects.TypeModule#g:method:registerFlags"), [registerType]("GI.GObject.Objects.TypeModule#g:method:registerType"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unuse]("GI.GObject.Objects.TypeModule#g:method:unuse"), [use]("GI.GObject.Objects.TypeModule#g:method:use"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.GObject.Objects.TypeModule#g:method:setName"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTypeModuleMethod                 ,
#endif

-- ** addInterface #method:addInterface#

#if defined(ENABLE_OVERLOADING)
    TypeModuleAddInterfaceMethodInfo        ,
#endif
    typeModuleAddInterface                  ,


-- ** registerEnum #method:registerEnum#

#if defined(ENABLE_OVERLOADING)
    TypeModuleRegisterEnumMethodInfo        ,
#endif
    typeModuleRegisterEnum                  ,


-- ** registerFlags #method:registerFlags#

#if defined(ENABLE_OVERLOADING)
    TypeModuleRegisterFlagsMethodInfo       ,
#endif
    typeModuleRegisterFlags                 ,


-- ** registerType #method:registerType#

#if defined(ENABLE_OVERLOADING)
    TypeModuleRegisterTypeMethodInfo        ,
#endif
    typeModuleRegisterType                  ,


-- ** setName #method:setName#

#if defined(ENABLE_OVERLOADING)
    TypeModuleSetNameMethodInfo             ,
#endif
    typeModuleSetName                       ,


-- ** unuse #method:unuse#

#if defined(ENABLE_OVERLOADING)
    TypeModuleUnuseMethodInfo               ,
#endif
    typeModuleUnuse                         ,


-- ** use #method:use#

#if defined(ENABLE_OVERLOADING)
    TypeModuleUseMethodInfo                 ,
#endif
    typeModuleUse                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Binding as GObject.Binding
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumValue as GObject.EnumValue
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsValue as GObject.FlagsValue
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable

#else
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumValue as GObject.EnumValue
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsValue as GObject.FlagsValue
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo

#endif

-- | Memory-managed wrapper type.
newtype TypeModule = TypeModule (SP.ManagedPtr TypeModule)
    deriving (Eq)

instance SP.ManagedPtrNewtype TypeModule where
    toManagedPtr (TypeModule p) = p

foreign import ccall "g_type_module_get_type"
    c_g_type_module_get_type :: IO B.Types.GType

instance B.Types.TypedObject TypeModule where
    glibType = c_g_type_module_get_type

instance B.Types.GObject TypeModule

-- | Type class for types which can be safely cast to t'TypeModule', for instance with `toTypeModule`.
class (SP.GObject o, O.IsDescendantOf TypeModule o) => IsTypeModule o
instance (SP.GObject o, O.IsDescendantOf TypeModule o) => IsTypeModule o

instance O.HasParentTypes TypeModule
type instance O.ParentTypes TypeModule = '[GObject.Object.Object, GObject.TypePlugin.TypePlugin]

-- | Cast to t'TypeModule', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTypeModule :: (MIO.MonadIO m, IsTypeModule o) => o -> m TypeModule
toTypeModule = MIO.liftIO . B.ManagedPtr.unsafeCastTo TypeModule

-- | Convert t'TypeModule' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TypeModule) where
    gvalueGType_ = c_g_type_module_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TypeModule)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TypeModule)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TypeModule ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTypeModuleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTypeModuleMethod "addInterface" o = TypeModuleAddInterfaceMethodInfo
    ResolveTypeModuleMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTypeModuleMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTypeModuleMethod "completeInterfaceInfo" o = GObject.TypePlugin.TypePluginCompleteInterfaceInfoMethodInfo
    ResolveTypeModuleMethod "completeTypeInfo" o = GObject.TypePlugin.TypePluginCompleteTypeInfoMethodInfo
    ResolveTypeModuleMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTypeModuleMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTypeModuleMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTypeModuleMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTypeModuleMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTypeModuleMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTypeModuleMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTypeModuleMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTypeModuleMethod "registerEnum" o = TypeModuleRegisterEnumMethodInfo
    ResolveTypeModuleMethod "registerFlags" o = TypeModuleRegisterFlagsMethodInfo
    ResolveTypeModuleMethod "registerType" o = TypeModuleRegisterTypeMethodInfo
    ResolveTypeModuleMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTypeModuleMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTypeModuleMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTypeModuleMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTypeModuleMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTypeModuleMethod "unuse" o = TypeModuleUnuseMethodInfo
    ResolveTypeModuleMethod "use" o = TypeModuleUseMethodInfo
    ResolveTypeModuleMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTypeModuleMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTypeModuleMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTypeModuleMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTypeModuleMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTypeModuleMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTypeModuleMethod "setName" o = TypeModuleSetNameMethodInfo
    ResolveTypeModuleMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTypeModuleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTypeModuleMethod t TypeModule, O.OverloadedMethod info TypeModule p) => OL.IsLabel t (TypeModule -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTypeModuleMethod t TypeModule, O.OverloadedMethod info TypeModule p, R.HasField t TypeModule p) => R.HasField t TypeModule p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTypeModuleMethod t TypeModule, O.OverloadedMethodInfo info TypeModule) => OL.IsLabel t (O.MethodProxy info TypeModule) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TypeModule
type instance O.AttributeList TypeModule = TypeModuleAttributeList
type TypeModuleAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TypeModule = TypeModuleSignalList
type TypeModuleSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TypeModule::add_interface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type to which to add the interface."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "interface type to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "InterfaceInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type information structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_add_interface" g_type_module_add_interface :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    CGType ->                               -- instance_type : TBasicType TGType
    CGType ->                               -- interface_type : TBasicType TGType
    Ptr GObject.InterfaceInfo.InterfaceInfo -> -- interface_info : TInterface (Name {namespace = "GObject", name = "InterfaceInfo"})
    IO ()

-- | Registers an additional interface for a type, whose interface lives
-- in the given type plugin. If the interface was already registered
-- for the type in this plugin, nothing will be done.
-- 
-- As long as any instances of the type exist, the type plugin will
-- not be unloaded.
-- 
-- Since 2.56 if /@module@/ is 'P.Nothing' this will call 'GI.GObject.Functions.typeAddInterfaceStatic'
-- instead. This can be used when making a static build of the module.
typeModuleAddInterface ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    Maybe (a)
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'
    -> GType
    -- ^ /@instanceType@/: type to which to add the interface.
    -> GType
    -- ^ /@interfaceType@/: interface type to add
    -> GObject.InterfaceInfo.InterfaceInfo
    -- ^ /@interfaceInfo@/: type information structure
    -> m ()
typeModuleAddInterface module_ instanceType interfaceType interfaceInfo = liftIO $ do
    maybeModule_ <- case module_ of
        Nothing -> return FP.nullPtr
        Just jModule_ -> do
            jModule_' <- unsafeManagedPtrCastPtr jModule_
            return jModule_'
    let instanceType' = gtypeToCGType instanceType
    let interfaceType' = gtypeToCGType interfaceType
    interfaceInfo' <- unsafeManagedPtrGetPtr interfaceInfo
    g_type_module_add_interface maybeModule_ instanceType' interfaceType' interfaceInfo'
    whenJust module_ touchManagedPtr
    touchManagedPtr interfaceInfo
    return ()

#if defined(ENABLE_OVERLOADING)
data TypeModuleAddInterfaceMethodInfo
instance (signature ~ (GType -> GType -> GObject.InterfaceInfo.InterfaceInfo -> m ()), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleAddInterfaceMethodInfo a signature where
    overloadedMethod i = typeModuleAddInterface (Just i)

instance O.OverloadedMethodInfo TypeModuleAddInterfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleAddInterface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleAddInterface"
        })


#endif

-- method TypeModule::register_enum
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name for the type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "const_static_values"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "GObject" , name = "EnumValue" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an array of #GEnumValue\n structs for the possible enumeration values. The array is terminated by a\n struct with all members being 0."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_register_enum" g_type_module_register_enum :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr (Ptr GObject.EnumValue.EnumValue) -> -- const_static_values : TCArray True (-1) (-1) (TInterface (Name {namespace = "GObject", name = "EnumValue"}))
    IO CGType

-- | Looks up or registers an enumeration that is implemented with a particular
-- type plugin. If a type with name /@typeName@/ was previously registered,
-- the t'GType' identifier for the type is returned, otherwise the type
-- is newly registered, and the resulting t'GType' identifier returned.
-- 
-- As long as any instances of the type exist, the type plugin will
-- not be unloaded.
-- 
-- Since 2.56 if /@module@/ is 'P.Nothing' this will call 'GI.GObject.Functions.typeRegisterStatic'
-- instead. This can be used when making a static build of the module.
-- 
-- /Since: 2.6/
typeModuleRegisterEnum ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    Maybe (a)
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'
    -> T.Text
    -- ^ /@name@/: name for the type
    -> [GObject.EnumValue.EnumValue]
    -- ^ /@constStaticValues@/: an array of t'GI.GObject.Structs.EnumValue.EnumValue'
    --  structs for the possible enumeration values. The array is terminated by a
    --  struct with all members being 0.
    -> m GType
    -- ^ __Returns:__ the new or existing type ID
typeModuleRegisterEnum module_ name constStaticValues = liftIO $ do
    maybeModule_ <- case module_ of
        Nothing -> return FP.nullPtr
        Just jModule_ -> do
            jModule_' <- unsafeManagedPtrCastPtr jModule_
            return jModule_'
    name' <- textToCString name
    constStaticValues' <- mapM unsafeManagedPtrGetPtr constStaticValues
    constStaticValues'' <- packZeroTerminatedPtrArray constStaticValues'
    result <- g_type_module_register_enum maybeModule_ name' constStaticValues''
    let result' = GType result
    whenJust module_ touchManagedPtr
    mapM_ touchManagedPtr constStaticValues
    freeMem name'
    freeMem constStaticValues''
    return result'

#if defined(ENABLE_OVERLOADING)
data TypeModuleRegisterEnumMethodInfo
instance (signature ~ (T.Text -> [GObject.EnumValue.EnumValue] -> m GType), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleRegisterEnumMethodInfo a signature where
    overloadedMethod i = typeModuleRegisterEnum (Just i)

instance O.OverloadedMethodInfo TypeModuleRegisterEnumMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleRegisterEnum",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleRegisterEnum"
        })


#endif

-- method TypeModule::register_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name for the type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "const_static_values"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "GObject" , name = "FlagsValue" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an array of #GFlagsValue\n structs for the possible flags values. The array is terminated by a struct\n with all members being 0."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_register_flags" g_type_module_register_flags :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr (Ptr GObject.FlagsValue.FlagsValue) -> -- const_static_values : TCArray True (-1) (-1) (TInterface (Name {namespace = "GObject", name = "FlagsValue"}))
    IO CGType

-- | Looks up or registers a flags type that is implemented with a particular
-- type plugin. If a type with name /@typeName@/ was previously registered,
-- the t'GType' identifier for the type is returned, otherwise the type
-- is newly registered, and the resulting t'GType' identifier returned.
-- 
-- As long as any instances of the type exist, the type plugin will
-- not be unloaded.
-- 
-- Since 2.56 if /@module@/ is 'P.Nothing' this will call 'GI.GObject.Functions.typeRegisterStatic'
-- instead. This can be used when making a static build of the module.
-- 
-- /Since: 2.6/
typeModuleRegisterFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    Maybe (a)
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'
    -> T.Text
    -- ^ /@name@/: name for the type
    -> [GObject.FlagsValue.FlagsValue]
    -- ^ /@constStaticValues@/: an array of t'GI.GObject.Structs.FlagsValue.FlagsValue'
    --  structs for the possible flags values. The array is terminated by a struct
    --  with all members being 0.
    -> m GType
    -- ^ __Returns:__ the new or existing type ID
typeModuleRegisterFlags module_ name constStaticValues = liftIO $ do
    maybeModule_ <- case module_ of
        Nothing -> return FP.nullPtr
        Just jModule_ -> do
            jModule_' <- unsafeManagedPtrCastPtr jModule_
            return jModule_'
    name' <- textToCString name
    constStaticValues' <- mapM unsafeManagedPtrGetPtr constStaticValues
    constStaticValues'' <- packZeroTerminatedPtrArray constStaticValues'
    result <- g_type_module_register_flags maybeModule_ name' constStaticValues''
    let result' = GType result
    whenJust module_ touchManagedPtr
    mapM_ touchManagedPtr constStaticValues
    freeMem name'
    freeMem constStaticValues''
    return result'

#if defined(ENABLE_OVERLOADING)
data TypeModuleRegisterFlagsMethodInfo
instance (signature ~ (T.Text -> [GObject.FlagsValue.FlagsValue] -> m GType), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleRegisterFlagsMethodInfo a signature where
    overloadedMethod i = typeModuleRegisterFlags (Just i)

instance O.OverloadedMethodInfo TypeModuleRegisterFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleRegisterFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleRegisterFlags"
        })


#endif

-- method TypeModule::register_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type for the parent class"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name for the type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type_info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type information structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags field providing details about the type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_register_type" g_type_module_register_type :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    CGType ->                               -- parent_type : TBasicType TGType
    CString ->                              -- type_name : TBasicType TUTF8
    Ptr GObject.TypeInfo.TypeInfo ->        -- type_info : TInterface (Name {namespace = "GObject", name = "TypeInfo"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "TypeFlags"})
    IO CGType

-- | Looks up or registers a type that is implemented with a particular
-- type plugin. If a type with name /@typeName@/ was previously registered,
-- the t'GType' identifier for the type is returned, otherwise the type
-- is newly registered, and the resulting t'GType' identifier returned.
-- 
-- When reregistering a type (typically because a module is unloaded
-- then reloaded, and reinitialized), /@module@/ and /@parentType@/ must
-- be the same as they were previously.
-- 
-- As long as any instances of the type exist, the type plugin will
-- not be unloaded.
-- 
-- Since 2.56 if /@module@/ is 'P.Nothing' this will call 'GI.GObject.Functions.typeRegisterStatic'
-- instead. This can be used when making a static build of the module.
typeModuleRegisterType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    Maybe (a)
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'
    -> GType
    -- ^ /@parentType@/: the type for the parent class
    -> T.Text
    -- ^ /@typeName@/: name for the type
    -> GObject.TypeInfo.TypeInfo
    -- ^ /@typeInfo@/: type information structure
    -> [GObject.Flags.TypeFlags]
    -- ^ /@flags@/: flags field providing details about the type
    -> m GType
    -- ^ __Returns:__ the new or existing type ID
typeModuleRegisterType module_ parentType typeName typeInfo flags = liftIO $ do
    maybeModule_ <- case module_ of
        Nothing -> return FP.nullPtr
        Just jModule_ -> do
            jModule_' <- unsafeManagedPtrCastPtr jModule_
            return jModule_'
    let parentType' = gtypeToCGType parentType
    typeName' <- textToCString typeName
    typeInfo' <- unsafeManagedPtrGetPtr typeInfo
    let flags' = gflagsToWord flags
    result <- g_type_module_register_type maybeModule_ parentType' typeName' typeInfo' flags'
    let result' = GType result
    whenJust module_ touchManagedPtr
    touchManagedPtr typeInfo
    freeMem typeName'
    return result'

#if defined(ENABLE_OVERLOADING)
data TypeModuleRegisterTypeMethodInfo
instance (signature ~ (GType -> T.Text -> GObject.TypeInfo.TypeInfo -> [GObject.Flags.TypeFlags] -> m GType), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleRegisterTypeMethodInfo a signature where
    overloadedMethod i = typeModuleRegisterType (Just i)

instance O.OverloadedMethodInfo TypeModuleRegisterTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleRegisterType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleRegisterType"
        })


#endif

-- method TypeModule::set_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a human-readable name to use in error messages."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_set_name" g_type_module_set_name :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets the name for a t'GI.GObject.Objects.TypeModule.TypeModule'
typeModuleSetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    a
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'.
    -> T.Text
    -- ^ /@name@/: a human-readable name to use in error messages.
    -> m ()
typeModuleSetName module_ name = liftIO $ do
    module_' <- unsafeManagedPtrCastPtr module_
    name' <- textToCString name
    g_type_module_set_name module_' name'
    touchManagedPtr module_
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data TypeModuleSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleSetNameMethodInfo a signature where
    overloadedMethod = typeModuleSetName

instance O.OverloadedMethodInfo TypeModuleSetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleSetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleSetName"
        })


#endif

-- method TypeModule::unuse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_unuse" g_type_module_unuse :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    IO ()

-- | Decreases the use count of a t'GI.GObject.Objects.TypeModule.TypeModule' by one. If the
-- result is zero, the module will be unloaded. (However, the
-- t'GI.GObject.Objects.TypeModule.TypeModule' will not be freed, and types associated with the
-- t'GI.GObject.Objects.TypeModule.TypeModule' are not unregistered. Once a t'GI.GObject.Objects.TypeModule.TypeModule' is
-- initialized, it must exist forever.)
typeModuleUnuse ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    a
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'
    -> m ()
typeModuleUnuse module_ = liftIO $ do
    module_' <- unsafeManagedPtrCastPtr module_
    g_type_module_unuse module_'
    touchManagedPtr module_
    return ()

#if defined(ENABLE_OVERLOADING)
data TypeModuleUnuseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleUnuseMethodInfo a signature where
    overloadedMethod = typeModuleUnuse

instance O.OverloadedMethodInfo TypeModuleUnuseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleUnuse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleUnuse"
        })


#endif

-- method TypeModule::use
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeModule" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeModule" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_module_use" g_type_module_use :: 
    Ptr TypeModule ->                       -- module : TInterface (Name {namespace = "GObject", name = "TypeModule"})
    IO CInt

-- | Increases the use count of a t'GI.GObject.Objects.TypeModule.TypeModule' by one. If the
-- use count was zero before, the plugin will be loaded.
-- If loading the plugin fails, the use count is reset to
-- its prior value.
typeModuleUse ::
    (B.CallStack.HasCallStack, MonadIO m, IsTypeModule a) =>
    a
    -- ^ /@module@/: a t'GI.GObject.Objects.TypeModule.TypeModule'
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the plugin needed to be loaded and
    --  loading the plugin failed.
typeModuleUse module_ = liftIO $ do
    module_' <- unsafeManagedPtrCastPtr module_
    result <- g_type_module_use module_'
    let result' = (/= 0) result
    touchManagedPtr module_
    return result'

#if defined(ENABLE_OVERLOADING)
data TypeModuleUseMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTypeModule a) => O.OverloadedMethod TypeModuleUseMethodInfo a signature where
    overloadedMethod = typeModuleUse

instance O.OverloadedMethodInfo TypeModuleUseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.TypeModule.typeModuleUse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-TypeModule.html#v:typeModuleUse"
        })


#endif


