{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Presents contextual actions.
-- 
-- \<picture>
--   \<source srcset=\"action-bar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkActionBar\" src=\"action-bar.png\">
-- \<\/picture>
-- 
-- @GtkActionBar@ is expected to be displayed below the content and expand
-- horizontally to fill the area.
-- 
-- It allows placing children at the start or the end. In addition, it
-- contains an internal centered box which is centered with respect to
-- the full width of the box, even if the children at either side take
-- up different amounts of space.
-- 
-- = GtkActionBar as GtkBuildable
-- 
-- The @GtkActionBar@ implementation of the @GtkBuildable@ interface supports
-- adding children at the start or end sides by specifying “start” or “end” as
-- the “type” attribute of a @\<child>@ element, or setting the center widget
-- by specifying “center” value.
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >actionbar
-- >╰── revealer
-- >    ╰── box
-- >        ├── box.start
-- >        │   ╰── [start children]
-- >        ├── [center widget]
-- >        ╰── box.end
-- >            ╰── [end children]
-- 
-- 
-- A @GtkActionBar@\'s CSS node is called @actionbar@. It contains a @revealer@
-- subnode, which contains a @box@ subnode, which contains two @box@ subnodes at
-- the start and end of the action bar, with @start@ and @end@ style classes
-- respectively, as well as a center node that represents the center child.
-- 
-- Each of the boxes contains children packed for that side.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ActionBar
    ( 

-- * Exported types
    ActionBar(..)                           ,
    IsActionBar                             ,
    toActionBar                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [packEnd]("GI.Gtk.Objects.ActionBar#g:method:packEnd"), [packStart]("GI.Gtk.Objects.ActionBar#g:method:packStart"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.ActionBar#g:method:remove"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCenterWidget]("GI.Gtk.Objects.ActionBar#g:method:getCenterWidget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRevealed]("GI.Gtk.Objects.ActionBar#g:method:getRevealed"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCenterWidget]("GI.Gtk.Objects.ActionBar#g:method:setCenterWidget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRevealed]("GI.Gtk.Objects.ActionBar#g:method:setRevealed"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveActionBarMethod                  ,
#endif

-- ** getCenterWidget #method:getCenterWidget#

#if defined(ENABLE_OVERLOADING)
    ActionBarGetCenterWidgetMethodInfo      ,
#endif
    actionBarGetCenterWidget                ,


-- ** getRevealed #method:getRevealed#

#if defined(ENABLE_OVERLOADING)
    ActionBarGetRevealedMethodInfo          ,
#endif
    actionBarGetRevealed                    ,


-- ** new #method:new#

    actionBarNew                            ,


-- ** packEnd #method:packEnd#

#if defined(ENABLE_OVERLOADING)
    ActionBarPackEndMethodInfo              ,
#endif
    actionBarPackEnd                        ,


-- ** packStart #method:packStart#

#if defined(ENABLE_OVERLOADING)
    ActionBarPackStartMethodInfo            ,
#endif
    actionBarPackStart                      ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    ActionBarRemoveMethodInfo               ,
#endif
    actionBarRemove                         ,


-- ** setCenterWidget #method:setCenterWidget#

#if defined(ENABLE_OVERLOADING)
    ActionBarSetCenterWidgetMethodInfo      ,
#endif
    actionBarSetCenterWidget                ,


-- ** setRevealed #method:setRevealed#

#if defined(ENABLE_OVERLOADING)
    ActionBarSetRevealedMethodInfo          ,
#endif
    actionBarSetRevealed                    ,




 -- * Properties


-- ** revealed #attr:revealed#
-- | Controls whether the action bar shows its contents.

#if defined(ENABLE_OVERLOADING)
    ActionBarRevealedPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    actionBarRevealed                       ,
#endif
    constructActionBarRevealed              ,
    getActionBarRevealed                    ,
    setActionBarRevealed                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ActionBar = ActionBar (SP.ManagedPtr ActionBar)
    deriving (Eq)

instance SP.ManagedPtrNewtype ActionBar where
    toManagedPtr (ActionBar p) = p

foreign import ccall "gtk_action_bar_get_type"
    c_gtk_action_bar_get_type :: IO B.Types.GType

instance B.Types.TypedObject ActionBar where
    glibType = c_gtk_action_bar_get_type

instance B.Types.GObject ActionBar

-- | Type class for types which can be safely cast to t'ActionBar', for instance with `toActionBar`.
class (SP.GObject o, O.IsDescendantOf ActionBar o) => IsActionBar o
instance (SP.GObject o, O.IsDescendantOf ActionBar o) => IsActionBar o

instance O.HasParentTypes ActionBar
type instance O.ParentTypes ActionBar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ActionBar', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toActionBar :: (MIO.MonadIO m, IsActionBar o) => o -> m ActionBar
toActionBar = MIO.liftIO . B.ManagedPtr.unsafeCastTo ActionBar

-- | Convert t'ActionBar' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ActionBar) where
    gvalueGType_ = c_gtk_action_bar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ActionBar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ActionBar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ActionBar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveActionBarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveActionBarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveActionBarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveActionBarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveActionBarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveActionBarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveActionBarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveActionBarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveActionBarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveActionBarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveActionBarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveActionBarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveActionBarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveActionBarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveActionBarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveActionBarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveActionBarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveActionBarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveActionBarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveActionBarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveActionBarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveActionBarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveActionBarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveActionBarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveActionBarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveActionBarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveActionBarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveActionBarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveActionBarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveActionBarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveActionBarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveActionBarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveActionBarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveActionBarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveActionBarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveActionBarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveActionBarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveActionBarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveActionBarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveActionBarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveActionBarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveActionBarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveActionBarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveActionBarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveActionBarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveActionBarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveActionBarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveActionBarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveActionBarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveActionBarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveActionBarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveActionBarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveActionBarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveActionBarMethod "packEnd" o = ActionBarPackEndMethodInfo
    ResolveActionBarMethod "packStart" o = ActionBarPackStartMethodInfo
    ResolveActionBarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveActionBarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveActionBarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveActionBarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveActionBarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveActionBarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveActionBarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveActionBarMethod "remove" o = ActionBarRemoveMethodInfo
    ResolveActionBarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveActionBarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveActionBarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveActionBarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveActionBarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveActionBarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveActionBarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveActionBarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveActionBarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveActionBarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveActionBarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveActionBarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveActionBarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveActionBarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveActionBarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveActionBarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveActionBarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveActionBarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveActionBarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveActionBarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveActionBarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveActionBarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveActionBarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveActionBarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveActionBarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveActionBarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveActionBarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveActionBarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveActionBarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveActionBarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveActionBarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveActionBarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveActionBarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveActionBarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveActionBarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveActionBarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveActionBarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveActionBarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveActionBarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveActionBarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveActionBarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveActionBarMethod "getCenterWidget" o = ActionBarGetCenterWidgetMethodInfo
    ResolveActionBarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveActionBarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveActionBarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveActionBarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveActionBarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveActionBarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveActionBarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveActionBarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveActionBarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveActionBarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveActionBarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveActionBarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveActionBarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveActionBarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveActionBarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveActionBarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveActionBarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveActionBarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveActionBarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveActionBarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveActionBarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveActionBarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveActionBarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveActionBarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveActionBarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveActionBarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveActionBarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveActionBarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveActionBarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveActionBarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveActionBarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveActionBarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveActionBarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveActionBarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveActionBarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveActionBarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveActionBarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveActionBarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveActionBarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveActionBarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveActionBarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveActionBarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveActionBarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveActionBarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveActionBarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveActionBarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveActionBarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveActionBarMethod "getRevealed" o = ActionBarGetRevealedMethodInfo
    ResolveActionBarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveActionBarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveActionBarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveActionBarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveActionBarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveActionBarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveActionBarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveActionBarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveActionBarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveActionBarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveActionBarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveActionBarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveActionBarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveActionBarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveActionBarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveActionBarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveActionBarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveActionBarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveActionBarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveActionBarMethod "setCenterWidget" o = ActionBarSetCenterWidgetMethodInfo
    ResolveActionBarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveActionBarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveActionBarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveActionBarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveActionBarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveActionBarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveActionBarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveActionBarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveActionBarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveActionBarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveActionBarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveActionBarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveActionBarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveActionBarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveActionBarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveActionBarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveActionBarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveActionBarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveActionBarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveActionBarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveActionBarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveActionBarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveActionBarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveActionBarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveActionBarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveActionBarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveActionBarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveActionBarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveActionBarMethod "setRevealed" o = ActionBarSetRevealedMethodInfo
    ResolveActionBarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveActionBarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveActionBarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveActionBarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveActionBarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveActionBarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveActionBarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveActionBarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveActionBarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveActionBarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveActionBarMethod t ActionBar, O.OverloadedMethod info ActionBar p) => OL.IsLabel t (ActionBar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveActionBarMethod t ActionBar, O.OverloadedMethod info ActionBar p, R.HasField t ActionBar p) => R.HasField t ActionBar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveActionBarMethod t ActionBar, O.OverloadedMethodInfo info ActionBar) => OL.IsLabel t (O.MethodProxy info ActionBar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "revealed"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@revealed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionBar #revealed
-- @
getActionBarRevealed :: (MonadIO m, IsActionBar o) => o -> m Bool
getActionBarRevealed obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "revealed"

-- | Set the value of the “@revealed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionBar [ #revealed 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionBarRevealed :: (MonadIO m, IsActionBar o) => o -> Bool -> m ()
setActionBarRevealed obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "revealed" val

-- | Construct a t'GValueConstruct' with valid value for the “@revealed@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructActionBarRevealed :: (IsActionBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructActionBarRevealed val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "revealed" val

#if defined(ENABLE_OVERLOADING)
data ActionBarRevealedPropertyInfo
instance AttrInfo ActionBarRevealedPropertyInfo where
    type AttrAllowedOps ActionBarRevealedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ActionBarRevealedPropertyInfo = IsActionBar
    type AttrSetTypeConstraint ActionBarRevealedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ActionBarRevealedPropertyInfo = (~) Bool
    type AttrTransferType ActionBarRevealedPropertyInfo = Bool
    type AttrGetType ActionBarRevealedPropertyInfo = Bool
    type AttrLabel ActionBarRevealedPropertyInfo = "revealed"
    type AttrOrigin ActionBarRevealedPropertyInfo = ActionBar
    attrGet = getActionBarRevealed
    attrSet = setActionBarRevealed
    attrTransfer _ v = do
        return v
    attrConstruct = constructActionBarRevealed
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.revealed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#g:attr:revealed"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ActionBar
type instance O.AttributeList ActionBar = ActionBarAttributeList
type ActionBarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("revealed", ActionBarRevealedPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
actionBarRevealed :: AttrLabelProxy "revealed"
actionBarRevealed = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ActionBar = ActionBarSignalList
type ActionBarSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ActionBar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ActionBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_new" gtk_action_bar_new :: 
    IO (Ptr ActionBar)

-- | Creates a new action bar widget.
actionBarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ActionBar
    -- ^ __Returns:__ a new @GtkActionBar@
actionBarNew  = liftIO $ do
    result <- gtk_action_bar_new
    checkUnexpectedReturnNULL "actionBarNew" result
    result' <- (newObject ActionBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ActionBar::get_center_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bsar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_get_center_widget" gtk_action_bar_get_center_widget :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the center bar widget of the bar.
actionBarGetCenterWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a) =>
    a
    -- ^ /@actionBar@/: an action bsar
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the center widget
actionBarGetCenterWidget actionBar = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    result <- gtk_action_bar_get_center_widget actionBar'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr actionBar
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ActionBarGetCenterWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsActionBar a) => O.OverloadedMethod ActionBarGetCenterWidgetMethodInfo a signature where
    overloadedMethod = actionBarGetCenterWidget

instance O.OverloadedMethodInfo ActionBarGetCenterWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarGetCenterWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarGetCenterWidget"
        })


#endif

-- method ActionBar::get_revealed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_get_revealed" gtk_action_bar_get_revealed :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    IO CInt

-- | Gets whether the contents of the action bar are revealed.
actionBarGetRevealed ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a) =>
    a
    -- ^ /@actionBar@/: an action bar
    -> m Bool
    -- ^ __Returns:__ the current value of the [ActionBar:revealed]("GI.Gtk.Objects.ActionBar#g:attr:revealed")
    --   property
actionBarGetRevealed actionBar = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    result <- gtk_action_bar_get_revealed actionBar'
    let result' = (/= 0) result
    touchManagedPtr actionBar
    return result'

#if defined(ENABLE_OVERLOADING)
data ActionBarGetRevealedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsActionBar a) => O.OverloadedMethod ActionBarGetRevealedMethodInfo a signature where
    overloadedMethod = actionBarGetRevealed

instance O.OverloadedMethodInfo ActionBarGetRevealedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarGetRevealed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarGetRevealed"
        })


#endif

-- method ActionBar::pack_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be added"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_pack_end" gtk_action_bar_pack_end :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Adds a child to the action bar, packed with reference to the
-- end of the action bar.
actionBarPackEnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@actionBar@/: an action bar
    -> b
    -- ^ /@child@/: the widget to be added
    -> m ()
actionBarPackEnd actionBar child = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    child' <- unsafeManagedPtrCastPtr child
    gtk_action_bar_pack_end actionBar' child'
    touchManagedPtr actionBar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ActionBarPackEndMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ActionBarPackEndMethodInfo a signature where
    overloadedMethod = actionBarPackEnd

instance O.OverloadedMethodInfo ActionBarPackEndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarPackEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarPackEnd"
        })


#endif

-- method ActionBar::pack_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be added"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_pack_start" gtk_action_bar_pack_start :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Adds a child to the action, packed with reference to the
-- start of the action bar.
actionBarPackStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@actionBar@/: an action bar
    -> b
    -- ^ /@child@/: the widget to be added
    -> m ()
actionBarPackStart actionBar child = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    child' <- unsafeManagedPtrCastPtr child
    gtk_action_bar_pack_start actionBar' child'
    touchManagedPtr actionBar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ActionBarPackStartMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ActionBarPackStartMethodInfo a signature where
    overloadedMethod = actionBarPackStart

instance O.OverloadedMethodInfo ActionBarPackStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarPackStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarPackStart"
        })


#endif

-- method ActionBar::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_remove" gtk_action_bar_remove :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes a child from the action bar.
actionBarRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@actionBar@/: an action bar
    -> b
    -- ^ /@child@/: the widget to be removed
    -> m ()
actionBarRemove actionBar child = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    child' <- unsafeManagedPtrCastPtr child
    gtk_action_bar_remove actionBar' child'
    touchManagedPtr actionBar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ActionBarRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ActionBarRemoveMethodInfo a signature where
    overloadedMethod = actionBarRemove

instance O.OverloadedMethodInfo ActionBarRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarRemove"
        })


#endif

-- method ActionBar::set_center_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center_widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget to use for the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_set_center_widget" gtk_action_bar_set_center_widget :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    Ptr Gtk.Widget.Widget ->                -- center_widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the center widget for the action bar.
actionBarSetCenterWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@actionBar@/: an action bar
    -> Maybe (b)
    -- ^ /@centerWidget@/: a widget to use for the center
    -> m ()
actionBarSetCenterWidget actionBar centerWidget = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    maybeCenterWidget <- case centerWidget of
        Nothing -> return FP.nullPtr
        Just jCenterWidget -> do
            jCenterWidget' <- unsafeManagedPtrCastPtr jCenterWidget
            return jCenterWidget'
    gtk_action_bar_set_center_widget actionBar' maybeCenterWidget
    touchManagedPtr actionBar
    whenJust centerWidget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ActionBarSetCenterWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsActionBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ActionBarSetCenterWidgetMethodInfo a signature where
    overloadedMethod = actionBarSetCenterWidget

instance O.OverloadedMethodInfo ActionBarSetCenterWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarSetCenterWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarSetCenterWidget"
        })


#endif

-- method ActionBar::set_revealed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "action_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ActionBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "revealed"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value for the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_action_bar_set_revealed" gtk_action_bar_set_revealed :: 
    Ptr ActionBar ->                        -- action_bar : TInterface (Name {namespace = "Gtk", name = "ActionBar"})
    CInt ->                                 -- revealed : TBasicType TBoolean
    IO ()

-- | Reveals or conceals the content of the action bar.
-- 
-- Note: this does not show or hide the action bar in the
-- [Widget:visible]("GI.Gtk.Objects.Widget#g:attr:visible") sense, so revealing has
-- no effect if the action bar is hidden.
actionBarSetRevealed ::
    (B.CallStack.HasCallStack, MonadIO m, IsActionBar a) =>
    a
    -- ^ /@actionBar@/: an action bar
    -> Bool
    -- ^ /@revealed@/: the new value for the property
    -> m ()
actionBarSetRevealed actionBar revealed = liftIO $ do
    actionBar' <- unsafeManagedPtrCastPtr actionBar
    let revealed' = (P.fromIntegral . P.fromEnum) revealed
    gtk_action_bar_set_revealed actionBar' revealed'
    touchManagedPtr actionBar
    return ()

#if defined(ENABLE_OVERLOADING)
data ActionBarSetRevealedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsActionBar a) => O.OverloadedMethod ActionBarSetRevealedMethodInfo a signature where
    overloadedMethod = actionBarSetRevealed

instance O.OverloadedMethodInfo ActionBarSetRevealedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ActionBar.actionBarSetRevealed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ActionBar.html#v:actionBarSetRevealed"
        })


#endif


