
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktitlewidget_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <ktitlewidget.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTitleWidget_Type = nullptr;
static PyTypeObject *Sbk_KTitleWidget_TypeF(void)
{
    return _Sbk_KTitleWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KTitleWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KTitleWidgetWrapper::KTitleWidgetWrapper(::QWidget * parent) : KTitleWidget(parent)
{
}

void KTitleWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTitleWidget::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KTitleWidget", funcName, gil, pyOverride, e);
}

void KTitleWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTitleWidget", funcName, gil, pyOverride, signal);
}

void KTitleWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

int KTitleWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KTitleWidget", funcName, gil, pyOverride);
}

void KTitleWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTitleWidget", funcName, gil, pyOverride, signal);
}

void KTitleWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

bool KTitleWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KTitleWidget", funcName, gil, pyOverride, event);
}

bool KTitleWidgetWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTitleWidget::eventFilter(object, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KTitleWidget", funcName, gil, pyOverride, object, event);
}

void KTitleWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

bool KTitleWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KTitleWidget", funcName, gil, pyOverride, next);
}

void KTitleWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

bool KTitleWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KTitleWidget", funcName, gil, pyOverride);
}

int KTitleWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KTitleWidget", funcName, gil, pyOverride, arg__1);
}

void KTitleWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KTitleWidget", funcName, gil, pyOverride, painter);
}

void KTitleWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

::QVariant KTitleWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KTitleWidget", funcName, gil, pyOverride, arg__1);
}

void KTitleWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

int KTitleWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KTitleWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KTitleWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KTitleWidget", funcName, gil, pyOverride);
}

void KTitleWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

bool KTitleWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KTitleWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KTitleWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KTitleWidget", funcName, gil, pyOverride);
}

void KTitleWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * KTitleWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KTitleWidget", funcName, gil, pyOverride, offset);
}

void KTitleWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KTitleWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KTitleWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KTitleWidget", funcName, gil, pyOverride);
}

void KTitleWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTitleWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

::QSize KTitleWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KTitleWidget", funcName, gil, pyOverride);
}

void KTitleWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

void KTitleWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTitleWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KTitleWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KTitleWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KTitleWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KTitleWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KTitleWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KTitleWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KTitleWidgetWrapper *>(this));
    }
    return KTitleWidget::qt_metacast(_clname);
}

KTitleWidgetWrapper::~KTitleWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KTitleWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KTitleWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KTitleWidget >()))
        return -1;

    KTitleWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KTitleWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KTitleWidget::KTitleWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KTitleWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KTitleWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KTitleWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KTitleWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KTitleWidgetWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KTitleWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KTitleWidgetFunc_autoHideTimeout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // autoHideTimeout()const
        int cppResult = const_cast<const ::KTitleWidget *>(cppSelf)->autoHideTimeout();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTitleWidgetFunc_changeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::changeEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // changeEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "changeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTitleWidget::changeEvent(cppArg0)
                : cppSelf->changeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_comment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // comment()const
        QString cppResult = const_cast<const ::KTitleWidget *>(cppSelf)->comment();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTitleWidgetFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTitleWidget::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTitleWidgetFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KTitleWidget *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTitleWidgetFunc_iconSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconSize()const
        QSize cppResult = const_cast<const ::KTitleWidget *>(cppSelf)->iconSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTitleWidgetFunc_level(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // level()
        int cppResult = cppSelf->level();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTitleWidgetFunc_setAutoHideTimeout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTitleWidget::setAutoHideTimeout(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setAutoHideTimeout(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoHideTimeout", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoHideTimeout(int)
            cppSelf->setAutoHideTimeout(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setBuddy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTitleWidget::setBuddy(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setBuddy(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBuddy", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBuddy(QWidget*)
            cppSelf->setBuddy(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setComment(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setComment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setComment", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTitleWidget::setComment(QString,KTitleWidget::MessageType=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setComment(QString,KTitleWidget::MessageType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_MessageType_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // setComment(QString,KTitleWidget::MessageType)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setComment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"type", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_MessageType_IDX])))->converter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setComment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KTitleWidget::MessageType cppArg1(KTitleWidget::MessageType::PlainMessage);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComment(QString,KTitleWidget::MessageType)
            cppSelf->setComment(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setIcon(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setIcon", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTitleWidget::setIcon(KTitleWidget::MessageType,KTitleWidget::ImageAlignment=)
    // 1: KTitleWidget::setIcon(QIcon,KTitleWidget::ImageAlignment=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setIcon(QIcon,KTitleWidget::ImageAlignment)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_ImageAlignment_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 1; // setIcon(QIcon,KTitleWidget::ImageAlignment)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_MessageType_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setIcon(KTitleWidget::MessageType,KTitleWidget::ImageAlignment)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_ImageAlignment_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // setIcon(KTitleWidget::MessageType,KTitleWidget::ImageAlignment)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setIcon(KTitleWidget::MessageType type, KTitleWidget::ImageAlignment alignment)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"alignment", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_ImageAlignment_IDX])))->converter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
                }
            }
            ::KTitleWidget::MessageType cppArg0{KTitleWidget::PlainMessage};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KTitleWidget::ImageAlignment cppArg1(KTitleWidget::ImageAlignment::ImageRight);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setIcon(KTitleWidget::MessageType,KTitleWidget::ImageAlignment)
                cppSelf->setIcon(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setIcon(const QIcon &icon, KTitleWidget::ImageAlignment alignment)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"alignment", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_ImageAlignment_IDX])))->converter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::KTitleWidget::ImageAlignment cppArg1(KTitleWidget::ImageAlignment::ImageRight);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setIcon(QIcon,KTitleWidget::ImageAlignment)
                cppSelf->setIcon(*cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setIconSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTitleWidget::setIconSize(QSize)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), (pyArg)))) {
        overloadId = 0; // setIconSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIconSize", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIconSize(QSize)
            cppSelf->setIconSize(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTitleWidget::setLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLevel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLevel(int)
            cppSelf->setLevel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setText(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setText", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTitleWidget::setText(QString,KTitleWidget::MessageType)
    // 1: KTitleWidget::setText(QString,QFlags<Qt::AlignmentFlag>=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setText(QString,QFlags<Qt::AlignmentFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 1; // setText(QString,QFlags<Qt::AlignmentFlag>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_MessageType_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // setText(QString,KTitleWidget::MessageType)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setText(const QString &text, KTitleWidget::MessageType type)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KTitleWidget::MessageType cppArg1{KTitleWidget::PlainMessage};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setText(QString,KTitleWidget::MessageType)
                cppSelf->setText(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setText(const QString &text, QFlags<Qt::AlignmentFlag> alignment)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"alignment", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::AlignmentFlag> cppArg1(Qt::AlignLeft | Qt::AlignVCenter);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setText(QString,QFlags<Qt::AlignmentFlag>)
                cppSelf->setText(cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_setWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTitleWidget::setWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWidget(QWidget*)
            cppSelf->setWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QShowEvent_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTitleWidget::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTitleWidgetFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KTitleWidget *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KTitleWidget_PropertyStrings[] = {
    "autoHideTimeout::",
    "comment::",
    "icon::",
    "iconSize::",
    "text::",
    nullptr // Sentinel
};

static const char *Sbk_KTitleWidget_EnumFlagInfo[] = {
    "ImageAlignment:IntEnum",
    "MessageType:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTitleWidget_methods[] = {
    {"autoHideTimeout", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_autoHideTimeout), METH_NOARGS, nullptr},
    {"changeEvent", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_changeEvent), METH_O, nullptr},
    {"comment", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_comment), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_eventFilter), METH_VARARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_icon), METH_NOARGS, nullptr},
    {"iconSize", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_iconSize), METH_NOARGS, nullptr},
    {"level", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_level), METH_NOARGS, nullptr},
    {"setAutoHideTimeout", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setAutoHideTimeout), METH_O, nullptr},
    {"setBuddy", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setBuddy), METH_O, nullptr},
    {"setComment", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setComment), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setIcon), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setIconSize", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setIconSize), METH_O, nullptr},
    {"setLevel", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setLevel), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setText), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setWidget", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_setWidget), METH_O, nullptr},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_showEvent), METH_O, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KTitleWidgetFunc_text), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KTitleWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KTitleWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KTitleWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KTitleWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTitleWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KTitleWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KTitleWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTitleWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KTitleWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTitleWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTitleWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTitleWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTitleWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTitleWidget_spec = {
    "1:KWidgetsAddons.KTitleWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTitleWidget_slots
};

} //extern "C"

static void *Sbk_KTitleWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KTitleWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KTitleWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KTitleWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KTitleWidget_ImageAlignment(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KTitleWidget::ImageAlignment>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KTitleWidget::ImageAlignment *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KTitleWidget_ImageAlignment_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_ImageAlignment_IDX])))
        return Enum_PythonToCpp_KTitleWidget_ImageAlignment;
    return {};
}

static PyObject *KTitleWidget_ImageAlignment_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KTitleWidget::ImageAlignment>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KTitleWidget::ImageAlignment *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KTitleWidget_MessageType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KTitleWidget::MessageType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KTitleWidget::MessageType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KTitleWidget_MessageType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_MessageType_IDX])))
        return Enum_PythonToCpp_KTitleWidget_MessageType;
    return {};
}

static PyObject *KTitleWidget_MessageType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KTitleWidget::MessageType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KTitleWidget::MessageType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KTitleWidget_PythonToCpp_KTitleWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KTitleWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KTitleWidget_PythonToCpp_KTitleWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KTitleWidget_TypeF()))
        return KTitleWidget_PythonToCpp_KTitleWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KTitleWidget_PTR_CppToPython_KTitleWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KTitleWidget *>(const_cast<void *>(cppIn)), Sbk_KTitleWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KTitleWidget_SignatureStrings[] = {
    "KWidgetsAddons.KTitleWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,text:QString=None,comment:QString=None,icon:QIcon=None,iconSize:QSize=None,autoHideTimeout:int=None)",
    "KWidgetsAddons.KTitleWidget.autoHideTimeout(self)->int",
    "KWidgetsAddons.KTitleWidget.changeEvent(self,e:PySide6.QtCore.QEvent)",
    "KWidgetsAddons.KTitleWidget.comment(self)->QString",
    "KWidgetsAddons.KTitleWidget.eventFilter(self,object:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KTitleWidget.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KTitleWidget.iconSize(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KTitleWidget.level(self)->int",
    "KWidgetsAddons.KTitleWidget.setAutoHideTimeout(self,msecs:int)",
    "KWidgetsAddons.KTitleWidget.setBuddy(self,buddy:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KTitleWidget.setComment(self,comment:QString,type:KWidgetsAddons.KTitleWidget.MessageType=KTitleWidget.MessageType.PlainMessage)",
    "1:KWidgetsAddons.KTitleWidget.setIcon(self,type:KWidgetsAddons.KTitleWidget.MessageType,alignment:KWidgetsAddons.KTitleWidget.ImageAlignment=KTitleWidget.ImageAlignment.ImageRight)",
    "0:KWidgetsAddons.KTitleWidget.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],alignment:KWidgetsAddons.KTitleWidget.ImageAlignment=KTitleWidget.ImageAlignment.ImageRight)",
    "KWidgetsAddons.KTitleWidget.setIconSize(self,iconSize:PySide6.QtCore.QSize)",
    "KWidgetsAddons.KTitleWidget.setLevel(self,level:int)",
    "1:KWidgetsAddons.KTitleWidget.setText(self,text:QString,type:KWidgetsAddons.KTitleWidget.MessageType)",
    "0:KWidgetsAddons.KTitleWidget.setText(self,text:QString,alignment:PySide6.QtCore.Qt.AlignmentFlag=Qt.AlignLeft | Qt.AlignVCenter)",
    "KWidgetsAddons.KTitleWidget.setWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KTitleWidget.showEvent(self,event:PySide6.QtGui.QShowEvent)",
    "KWidgetsAddons.KTitleWidget.text(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KTitleWidget_SignatureByteSize = 481;
static constexpr uint8_t KTitleWidget_SignatureBytes[481] = {
    0x78, 0xda, 0xb5, 0x55, 0x4d, 0x6f, 0xa3, 0x30, 0x10, 0xbd, 0xe7, 0x57, 0xe4, 0xb8, 0xa9, 0x5c,
    0xab, 0xbd, 0xf4, 0x80, 0x44, 0xa5, 0x34, 0x6a, 0xb6, 0x51, 0xda, 0x6d, 0x68, 0xd2, 0xee, 0xa1,
    0xea, 0x81, 0xc0, 0x94, 0xb8, 0x32, 0x76, 0x04, 0xc3, 0x26, 0x54, 0xfb, 0xe3, 0xd7, 0xd8, 0x90,
    0xb0, 0x34, 0x98, 0x64, 0xa5, 0xbd, 0x20, 0x7b, 0x3c, 0x6f, 0xe6, 0xcd, 0x27, 0xd3, 0x9f, 0x2c,
    0x8c, 0x00, 0xd3, 0x61, 0x18, 0x4a, 0x91, 0xd2, 0xe9, 0x82, 0x21, 0x07, 0x23, 0xfb, 0x96, 0x02,
    0x7f, 0x27, 0x6b, 0x3f, 0x01, 0x81, 0xce, 0x2c, 0x9f, 0xb3, 0x10, 0xae, 0xa8, 0x87, 0x25, 0x80,
    0x7a, 0xe6, 0xe0, 0x8a, 0x8c, 0xf3, 0x35, 0x26, 0xe4, 0xcc, 0x99, 0x42, 0xbe, 0x91, 0x49, 0xf8,
    0x28, 0x78, 0xee, 0xfe, 0x90, 0x02, 0x08, 0xc2, 0x16, 0x1d, 0x6f, 0x8e, 0x09, 0x13, 0x91, 0x91,
    0x04, 0x32, 0x8e, 0x0b, 0x73, 0x7f, 0x09, 0x59, 0x20, 0x85, 0xe3, 0x4d, 0xd4, 0x77, 0x7f, 0x9f,
    0xb3, 0x4f, 0x50, 0x5a, 0xea, 0x6b, 0x64, 0x7e, 0x86, 0xf2, 0x4e, 0x31, 0x58, 0xb0, 0x18, 0x64,
    0x86, 0x0e, 0x13, 0xa8, 0x1f, 0x06, 0xbd, 0x69, 0x7b, 0x04, 0xb4, 0x81, 0xd2, 0x11, 0x0d, 0xce,
    0xaf, 0x15, 0xd8, 0x0a, 0x0b, 0x56, 0xbe, 0x88, 0xe0, 0xf6, 0x97, 0x62, 0x6a, 0x92, 0x00, 0xb5,
    0xf8, 0x47, 0x32, 0x01, 0xea, 0xe9, 0x47, 0xbb, 0xf3, 0x32, 0xd6, 0xca, 0x69, 0x19, 0xb2, 0x15,
    0x02, 0x85, 0xd5, 0x31, 0xe3, 0x08, 0x89, 0x71, 0x2c, 0x97, 0x1f, 0x10, 0xe0, 0x17, 0xef, 0x8f,
    0x5a, 0x4c, 0xb4, 0x7a, 0x0b, 0xb5, 0xf3, 0xeb, 0xa5, 0x94, 0xdc, 0xea, 0xad, 0xc8, 0x73, 0xc5,
    0x6e, 0x6f, 0xe4, 0x7b, 0xc6, 0xa8, 0x2e, 0x46, 0x27, 0xb6, 0xa8, 0xce, 0x57, 0xbc, 0x21, 0x51,
    0xbc, 0x59, 0x0d, 0x70, 0x45, 0x9e, 0x1f, 0x5b, 0x90, 0x14, 0x70, 0x78, 0xa0, 0x94, 0x24, 0x4e,
    0x21, 0x48, 0x8b, 0x5e, 0x18, 0x74, 0xc1, 0x6f, 0xb2, 0x30, 0xcc, 0x0d, 0x68, 0x59, 0x1c, 0xdb,
    0x1b, 0xba, 0xd3, 0xd4, 0xa8, 0x56, 0xd7, 0x66, 0x43, 0x13, 0xcc, 0xd7, 0xe0, 0xd8, 0x0c, 0x3c,
    0x40, 0x9a, 0xfa, 0x11, 0x2c, 0x94, 0x9e, 0xdb, 0xf6, 0x40, 0x67, 0xdc, 0x67, 0xa2, 0x14, 0x0c,
    0x7a, 0x97, 0x4e, 0x07, 0xa3, 0x49, 0x55, 0xc8, 0x93, 0xdc, 0x13, 0x9f, 0xb3, 0x48, 0x68, 0xf6,
    0x36, 0xc4, 0x24, 0x56, 0xfa, 0xc3, 0x4a, 0xd5, 0xb5, 0xbc, 0x99, 0xeb, 0x13, 0x8b, 0x56, 0x2a,
    0x89, 0x17, 0xc7, 0x93, 0xd6, 0xf3, 0xaf, 0x98, 0xab, 0xfc, 0xd1, 0x67, 0xc1, 0xa4, 0x78, 0x3d,
    0xd0, 0x8d, 0xa4, 0xdf, 0x10, 0xce, 0xd8, 0x36, 0xf6, 0xd7, 0x6f, 0xff, 0x37, 0x8a, 0x23, 0x62,
    0xd8, 0x4d, 0xc1, 0x7e, 0x6f, 0x1d, 0x1a, 0x86, 0x4e, 0x5b, 0xf7, 0xbb, 0x81, 0x20, 0x7a, 0x36,
    0x4c, 0x5b, 0x77, 0xd6, 0x7e, 0xa1, 0x76, 0x6c, 0x59, 0xfb, 0xda, 0xb6, 0x3d, 0xa9, 0x11, 0x8e,
    0x28, 0x56, 0x8b, 0x97, 0x7d, 0xee, 0x9b, 0x21, 0x23, 0xdd, 0x25, 0x74, 0xcc, 0xfd, 0xc8, 0xad,
    0x04, 0xf7, 0xf0, 0x8e, 0xfd, 0xdf, 0xfd, 0xea, 0xfa, 0x32, 0x52, 0x0a, 0x90, 0x74, 0x26, 0xa7,
    0xfe, 0x47, 0xda, 0xe8, 0xf3, 0x3f, 0x0f, 0xf0, 0x4a, 0x6e, 0xea, 0x9b, 0xbd, 0xb1, 0x42, 0x75,
    0x6b, 0xcd, 0x2b, 0x1d, 0xbb, 0x29, 0xac, 0x92, 0x52, 0xdb, 0xee, 0x7f, 0x00, 0xcc, 0x7c, 0xb1,
    0x39
};
#endif

PyTypeObject *init_KTitleWidget(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KTitleWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KTitleWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTitleWidget",
        "KTitleWidget*",
        &Sbk_KTitleWidget_spec,
        &Shiboken::callCppDestructor< KTitleWidget >,
        Sbk_KTitleWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KTitleWidget_Type; // references _Sbk_KTitleWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KTitleWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KTitleWidget_SignatureBytes, KTitleWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTitleWidget_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KTitleWidget_PythonToCpp_KTitleWidget_PTR,
        is_KTitleWidget_PythonToCpp_KTitleWidget_PTR_Convertible,
        KTitleWidget_PTR_CppToPython_KTitleWidget);

    Shiboken::Conversions::registerConverterName(converter, "KTitleWidget");
    Shiboken::Conversions::registerConverterName(converter, "KTitleWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KTitleWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KTitleWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KTitleWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KTitleWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KTitleWidget_TypeF(), &Sbk_KTitleWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KTitleWidget_TypeF(), &Sbk_KTitleWidget_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KTitleWidget_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ImageAlignment'.
    const char *ImageAlignment_Initializer[] = {
        "ImageLeft",
        "ImageRight",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ImageAlignment_InitializerValues[] = {
        uint8_t(KTitleWidget::ImageAlignment::ImageLeft), //  0x00  0
        uint8_t(KTitleWidget::ImageAlignment::ImageRight) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KTitleWidget_TypeF(),
        "1:KWidgetsAddons.KTitleWidget.ImageAlignment",
        ImageAlignment_Initializer, ImageAlignment_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_ImageAlignment_IDX].type = EType;
    // Register converter for enum 'KTitleWidget::ImageAlignment'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KTitleWidget_ImageAlignment_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KTitleWidget_ImageAlignment,
            is_Enum_PythonToCpp_KTitleWidget_ImageAlignment_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KTitleWidget::ImageAlignment");
        Shiboken::Conversions::registerConverterAlias(converter, "ImageAlignment");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ImageAlignment' enum.

    // Initialization of enum 'MessageType'.
    const char *MessageType_Initializer[] = {
        "PlainMessage",
        "InfoMessage",
        "WarningMessage",
        "ErrorMessage",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t MessageType_InitializerValues[] = {
        uint8_t(KTitleWidget::MessageType::PlainMessage),   //  0x00  0
        uint8_t(KTitleWidget::MessageType::InfoMessage),    //  0x01  1
        uint8_t(KTitleWidget::MessageType::WarningMessage), //  0x02  2
        uint8_t(KTitleWidget::MessageType::ErrorMessage)    //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KTitleWidget_TypeF(),
        "1:KWidgetsAddons.KTitleWidget.MessageType",
        MessageType_Initializer, MessageType_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_MessageType_IDX].type = EType;
    // Register converter for enum 'KTitleWidget::MessageType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KTitleWidget_MessageType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KTitleWidget_MessageType,
            is_Enum_PythonToCpp_KTitleWidget_MessageType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KTitleWidget::MessageType");
        Shiboken::Conversions::registerConverterAlias(converter, "MessageType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'MessageType' enum.

    qRegisterMetaType< ::KTitleWidget::ImageAlignment >("KTitleWidget::ImageAlignment");
    qRegisterMetaType< ::KTitleWidget::MessageType >("KTitleWidget::MessageType");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KTitleWidget::staticMetaObject, sizeof(KTitleWidgetWrapper));

    return pyType;
}
