// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolGauge = sync.Pool{
		New: func() any {
			return &otlpmetrics.Gauge{}
		},
	}
)

func NewOrigGauge() *otlpmetrics.Gauge {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.Gauge{}
	}
	return protoPoolGauge.Get().(*otlpmetrics.Gauge)
}

func DeleteOrigGauge(orig *otlpmetrics.Gauge, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.DataPoints {
		DeleteOrigNumberDataPoint(orig.DataPoints[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolGauge.Put(orig)
	}
}

func CopyOrigGauge(dest, src *otlpmetrics.Gauge) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.DataPoints = CopyOrigNumberDataPointSlice(dest.DataPoints, src.DataPoints)
}

func GenTestOrigGauge() *otlpmetrics.Gauge {
	orig := NewOrigGauge()
	orig.DataPoints = GenerateOrigTestNumberDataPointSlice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigGauge(orig *otlpmetrics.Gauge, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		MarshalJSONOrigNumberDataPoint(orig.DataPoints[0], dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			MarshalJSONOrigNumberDataPoint(orig.DataPoints[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigGauge unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigGauge(orig *otlpmetrics.Gauge, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "dataPoints", "data_points":
			for iter.ReadArray() {
				orig.DataPoints = append(orig.DataPoints, NewOrigNumberDataPoint())
				UnmarshalJSONOrigNumberDataPoint(orig.DataPoints[len(orig.DataPoints)-1], iter)
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigGauge(orig *otlpmetrics.Gauge) int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = SizeProtoOrigNumberDataPoint(orig.DataPoints[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigGauge(orig *otlpmetrics.Gauge, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.DataPoints) - 1; i >= 0; i-- {
		l = MarshalProtoOrigNumberDataPoint(orig.DataPoints[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigGauge(orig *otlpmetrics.Gauge, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DataPoints = append(orig.DataPoints, NewOrigNumberDataPoint())
			err = UnmarshalProtoOrigNumberDataPoint(orig.DataPoints[len(orig.DataPoints)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
