/* == Start of generated table == */
/*
 * The following table is generated by running:
 *
 *   ./gen-ucd-table.py --rust ucd.nounihan.grouped.xml hb-script-list.h
 *
 * on file with this description: Unicode 17.0.0
 */

pub(crate) mod ucd {

#![allow(unused_parens)]
#![allow(clippy::unnecessary_cast, clippy::unreadable_literal, clippy::double_parens)]

use crate::hb::algs::{HB_CODEPOINT_ENCODE3, HB_CODEPOINT_ENCODE3_11_7_14};
use crate::hb::common::script;
use crate::hb::common::Script as hb_script_t;

pub(crate) static _hb_ucd_sc_map: [hb_script_t; 176]=
[
                   script::COMMON,              script::INHERITED,
                  script::UNKNOWN,                 script::ARABIC,
                 script::ARMENIAN,                script::BENGALI,
                 script::CYRILLIC,             script::DEVANAGARI,
                 script::GEORGIAN,                  script::GREEK,
                 script::GUJARATI,               script::GURMUKHI,
                   script::HANGUL,                    script::HAN,
                   script::HEBREW,               script::HIRAGANA,
                  script::KANNADA,               script::KATAKANA,
                      script::LAO,                  script::LATIN,
                script::MALAYALAM,                  script::ORIYA,
                    script::TAMIL,                 script::TELUGU,
                     script::THAI,                script::TIBETAN,
                 script::BOPOMOFO,                script::BRAILLE,
       script::CANADIAN_SYLLABICS,               script::CHEROKEE,
                 script::ETHIOPIC,                  script::KHMER,
                script::MONGOLIAN,                script::MYANMAR,
                    script::OGHAM,                  script::RUNIC,
                  script::SINHALA,                 script::SYRIAC,
                   script::THAANA,                     script::YI,
                  script::DESERET,                 script::GOTHIC,
               script::OLD_ITALIC,                  script::BUHID,
                  script::HANUNOO,                script::TAGALOG,
                 script::TAGBANWA,                script::CYPRIOT,
                    script::LIMBU,               script::LINEAR_B,
                  script::OSMANYA,                script::SHAVIAN,
                   script::TAI_LE,               script::UGARITIC,
                 script::BUGINESE,                 script::COPTIC,
               script::GLAGOLITIC,             script::KHAROSHTHI,
              script::NEW_TAI_LUE,            script::OLD_PERSIAN,
             script::SYLOTI_NAGRI,               script::TIFINAGH,
                 script::BALINESE,              script::CUNEIFORM,
                      script::NKO,               script::PHAGS_PA,
               script::PHOENICIAN,                 script::CARIAN,
                     script::CHAM,               script::KAYAH_LI,
                   script::LEPCHA,                 script::LYCIAN,
                   script::LYDIAN,               script::OL_CHIKI,
                   script::REJANG,             script::SAURASHTRA,
                script::SUNDANESE,                    script::VAI,
                  script::AVESTAN,                  script::BAMUM,
     script::EGYPTIAN_HIEROGLYPHS,       script::IMPERIAL_ARAMAIC,
    script::INSCRIPTIONAL_PAHLAVI, script::INSCRIPTIONAL_PARTHIAN,
                 script::JAVANESE,                 script::KAITHI,
                     script::LISU,           script::MEETEI_MAYEK,
        script::OLD_SOUTH_ARABIAN,             script::OLD_TURKIC,
                script::SAMARITAN,               script::TAI_THAM,
                 script::TAI_VIET,                  script::BATAK,
                   script::BRAHMI,                script::MANDAIC,
                   script::CHAKMA,       script::MEROITIC_CURSIVE,
     script::MEROITIC_HIEROGLYPHS,                   script::MIAO,
                  script::SHARADA,           script::SORA_SOMPENG,
                    script::TAKRI,              script::BASSA_VAH,
       script::CAUCASIAN_ALBANIAN,               script::DUPLOYAN,
                  script::ELBASAN,                script::GRANTHA,
                   script::KHOJKI,              script::KHUDAWADI,
                 script::LINEAR_A,               script::MAHAJANI,
               script::MANICHAEAN,          script::MENDE_KIKAKUI,
                     script::MODI,                    script::MRO,
                script::NABATAEAN,      script::OLD_NORTH_ARABIAN,
               script::OLD_PERMIC,           script::PAHAWH_HMONG,
                script::PALMYRENE,            script::PAU_CIN_HAU,
          script::PSALTER_PAHLAVI,                script::SIDDHAM,
                  script::TIRHUTA,            script::WARANG_CITI,
                     script::AHOM,  script::ANATOLIAN_HIEROGLYPHS,
                   script::HATRAN,                script::MULTANI,
            script::OLD_HUNGARIAN,            script::SIGNWRITING,
                    script::ADLAM,              script::BHAIKSUKI,
                  script::MARCHEN,                  script::OSAGE,
                   script::TANGUT,                   script::NEWA,
            script::MASARAM_GONDI,                  script::NUSHU,
                  script::SOYOMBO,       script::ZANABAZAR_SQUARE,
                    script::DOGRA,          script::GUNJALA_GONDI,
          script::HANIFI_ROHINGYA,                script::MAKASAR,
              script::MEDEFAIDRIN,            script::OLD_SOGDIAN,
                  script::SOGDIAN,                script::ELYMAIC,
              script::NANDINAGARI, script::NYIAKENG_PUACHUE_HMONG,
                   script::WANCHO,             script::CHORASMIAN,
              script::DIVES_AKURU,    script::KHITAN_SMALL_SCRIPT,
                   script::YEZIDI,           script::CYPRO_MINOAN,
               script::OLD_UYGHUR,                 script::TANGSA,
                     script::TOTO,               script::VITHKUQI,
                     script::MATH,                   script::KAWI,
              script::NAG_MUNDARI,                  script::GARAY,
             script::GURUNG_KHEMA,              script::KIRAT_RAI,
                  script::OL_ONAL,                script::SUNUWAR,
                   script::TODHRI,          script::TULU_TIGALARI,
               script::BERIA_ERFE,                script::SIDETIC,
                   script::TAI_YO,            script::TOLONG_SIKI,
];
pub(crate) static _hb_ucd_dm1_p0_map: [u16; 825]=
[
   0x003B, 0x004B, 0x0060, 0x00B4, 0x00B7, 0x00C5, 0x02B9, 0x0300,
   0x0301, 0x0313, 0x0385, 0x0386, 0x0388, 0x0389, 0x038A, 0x038C,
   0x038E, 0x038F, 0x0390, 0x03A9, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
   0x03B0, 0x03B9, 0x03CC, 0x03CD, 0x03CE, 0x2002, 0x2003, 0x3008,
   0x3009, 0x349E, 0x34B9, 0x34BB, 0x34DF, 0x3515, 0x36EE, 0x36FC,
   0x3781, 0x382F, 0x3862, 0x387C, 0x38C7, 0x38E3, 0x391C, 0x393A,
   0x3A2E, 0x3A6C, 0x3AE4, 0x3B08, 0x3B19, 0x3B49, 0x3B9D, 0x3C18,
   0x3C4E, 0x3D33, 0x3D96, 0x3EAC, 0x3EB8, 0x3F1B, 0x3FFC, 0x4008,
   0x4018, 0x4039, 0x4046, 0x4096, 0x40E3, 0x412F, 0x4202, 0x4227,
   0x42A0, 0x4301, 0x4334, 0x4359, 0x43D5, 0x43D9, 0x440B, 0x446B,
   0x452B, 0x455D, 0x4561, 0x456B, 0x45D7, 0x45F9, 0x4635, 0x46BE,
   0x46C7, 0x4995, 0x49E6, 0x4A6E, 0x4A76, 0x4AB2, 0x4B33, 0x4BCE,
   0x4CCE, 0x4CED, 0x4CF8, 0x4D56, 0x4E0D, 0x4E26, 0x4E32, 0x4E38,
   0x4E39, 0x4E3D, 0x4E41, 0x4E82, 0x4E86, 0x4EAE, 0x4EC0, 0x4ECC,
   0x4EE4, 0x4F60, 0x4F80, 0x4F86, 0x4F8B, 0x4FAE, 0x4FBB, 0x4FBF,
   0x5002, 0x502B, 0x507A, 0x5099, 0x50CF, 0x50DA, 0x50E7, 0x5140,
   0x5145, 0x514D, 0x5154, 0x5164, 0x5167, 0x5168, 0x5169, 0x516D,
   0x5177, 0x5180, 0x518D, 0x5192, 0x5195, 0x5197, 0x51A4, 0x51AC,
   0x51B5, 0x51B7, 0x51C9, 0x51CC, 0x51DC, 0x51DE, 0x51F5, 0x5203,
   0x5207, 0x5217, 0x5229, 0x523A, 0x523B, 0x5246, 0x5272, 0x5277,
   0x5289, 0x529B, 0x52A3, 0x52B3, 0x52C7, 0x52C9, 0x52D2, 0x52DE,
   0x52E4, 0x52F5, 0x52FA, 0x5305, 0x5306, 0x5317, 0x533F, 0x5349,
   0x5351, 0x535A, 0x5373, 0x5375, 0x537D, 0x537F, 0x53C3, 0x53CA,
   0x53DF, 0x53E5, 0x53EB, 0x53F1, 0x5406, 0x540F, 0x541D, 0x5438,
   0x5442, 0x5448, 0x5468, 0x549E, 0x54A2, 0x54BD, 0x54F6, 0x5510,
   0x5553, 0x5555, 0x5563, 0x5584, 0x5587, 0x5599, 0x559D, 0x55AB,
   0x55B3, 0x55C0, 0x55C2, 0x55E2, 0x5606, 0x5651, 0x5668, 0x5674,
   0x56F9, 0x5716, 0x5717, 0x578B, 0x57CE, 0x57F4, 0x580D, 0x5831,
   0x5832, 0x5840, 0x585A, 0x585E, 0x58A8, 0x58AC, 0x58B3, 0x58D8,
   0x58DF, 0x58EE, 0x58F2, 0x58F7, 0x5906, 0x591A, 0x5922, 0x5944,
   0x5948, 0x5951, 0x5954, 0x5962, 0x5973, 0x59D8, 0x59EC, 0x5A1B,
   0x5A27, 0x5A62, 0x5A66, 0x5AB5, 0x5B08, 0x5B28, 0x5B3E, 0x5B85,
   0x5BC3, 0x5BD8, 0x5BE7, 0x5BEE, 0x5BF3, 0x5BFF, 0x5C06, 0x5C22,
   0x5C3F, 0x5C60, 0x5C62, 0x5C64, 0x5C65, 0x5C6E, 0x5C8D, 0x5CC0,
   0x5D19, 0x5D43, 0x5D50, 0x5D6B, 0x5D6E, 0x5D7C, 0x5DB2, 0x5DBA,
   0x5DE1, 0x5DE2, 0x5DFD, 0x5E28, 0x5E3D, 0x5E69, 0x5E74, 0x5EA6,
   0x5EB0, 0x5EB3, 0x5EB6, 0x5EC9, 0x5ECA, 0x5ED2, 0x5ED3, 0x5ED9,
   0x5EEC, 0x5EFE, 0x5F04, 0x5F22, 0x5F53, 0x5F62, 0x5F69, 0x5F6B,
   0x5F8B, 0x5F9A, 0x5FA9, 0x5FAD, 0x5FCD, 0x5FD7, 0x5FF5, 0x5FF9,
   0x6012, 0x601C, 0x6075, 0x6081, 0x6094, 0x60C7, 0x60D8, 0x60E1,
   0x6108, 0x6144, 0x6148, 0x614C, 0x614E, 0x6160, 0x6168, 0x617A,
   0x618E, 0x6190, 0x61A4, 0x61AF, 0x61B2, 0x61DE, 0x61F2, 0x61F6,
   0x6200, 0x6210, 0x621B, 0x622E, 0x6234, 0x625D, 0x62B1, 0x62C9,
   0x62CF, 0x62D3, 0x62D4, 0x62FC, 0x62FE, 0x633D, 0x6350, 0x6368,
   0x637B, 0x6383, 0x63A0, 0x63A9, 0x63C4, 0x63C5, 0x63E4, 0x641C,
   0x6422, 0x6452, 0x6469, 0x6477, 0x647E, 0x649A, 0x649D, 0x64C4,
   0x654F, 0x6556, 0x656C, 0x6578, 0x6599, 0x65C5, 0x65E2, 0x65E3,
   0x6613, 0x6649, 0x6674, 0x6688, 0x6691, 0x669C, 0x66B4, 0x66C6,
   0x66F4, 0x66F8, 0x6700, 0x6717, 0x671B, 0x6721, 0x674E, 0x6753,
   0x6756, 0x675E, 0x677B, 0x6785, 0x6797, 0x67F3, 0x67FA, 0x6817,
   0x681F, 0x6852, 0x6881, 0x6885, 0x688E, 0x68A8, 0x6914, 0x6942,
   0x69A3, 0x69EA, 0x6A02, 0x6A13, 0x6AA8, 0x6AD3, 0x6ADB, 0x6B04,
   0x6B21, 0x6B54, 0x6B72, 0x6B77, 0x6B79, 0x6B9F, 0x6BAE, 0x6BBA,
   0x6BBB, 0x6C4E, 0x6C67, 0x6C88, 0x6CBF, 0x6CCC, 0x6CCD, 0x6CE5,
   0x6D16, 0x6D1B, 0x6D1E, 0x6D34, 0x6D3E, 0x6D41, 0x6D69, 0x6D6A,
   0x6D77, 0x6D78, 0x6D85, 0x6DCB, 0x6DDA, 0x6DEA, 0x6DF9, 0x6E1A,
   0x6E2F, 0x6E6E, 0x6E9C, 0x6EBA, 0x6EC7, 0x6ECB, 0x6ED1, 0x6EDB,
   0x6F0F, 0x6F22, 0x6F23, 0x6F6E, 0x6FC6, 0x6FEB, 0x6FFE, 0x701B,
   0x701E, 0x7039, 0x704A, 0x7070, 0x7077, 0x707D, 0x7099, 0x70AD,
   0x70C8, 0x70D9, 0x7145, 0x7149, 0x716E, 0x719C, 0x71CE, 0x71D0,
   0x7210, 0x721B, 0x7228, 0x722B, 0x7235, 0x7250, 0x7262, 0x7280,
   0x7295, 0x72AF, 0x72C0, 0x72FC, 0x732A, 0x7375, 0x737A, 0x7387,
   0x738B, 0x73A5, 0x73B2, 0x73DE, 0x7406, 0x7409, 0x7422, 0x7447,
   0x745C, 0x7469, 0x7471, 0x7485, 0x7489, 0x7498, 0x74CA, 0x7506,
   0x7524, 0x753B, 0x753E, 0x7559, 0x7565, 0x7570, 0x75E2, 0x7610,
   0x761D, 0x761F, 0x7642, 0x7669, 0x76CA, 0x76DB, 0x76E7, 0x76F4,
   0x7701, 0x771E, 0x771F, 0x7740, 0x774A, 0x778B, 0x77A7, 0x784E,
   0x786B, 0x788C, 0x7891, 0x78CA, 0x78CC, 0x78FB, 0x792A, 0x793C,
   0x793E, 0x7948, 0x7949, 0x7950, 0x7956, 0x795D, 0x795E, 0x7965,
   0x797F, 0x798D, 0x798E, 0x798F, 0x79AE, 0x79CA, 0x79EB, 0x7A1C,
   0x7A40, 0x7A4A, 0x7A4F, 0x7A81, 0x7AB1, 0x7ACB, 0x7AEE, 0x7B20,
   0x7BC0, 0x7BC6, 0x7BC9, 0x7C3E, 0x7C60, 0x7C7B, 0x7C92, 0x7CBE,
   0x7CD2, 0x7CD6, 0x7CE3, 0x7CE7, 0x7CE8, 0x7D00, 0x7D10, 0x7D22,
   0x7D2F, 0x7D5B, 0x7D63, 0x7DA0, 0x7DBE, 0x7DC7, 0x7DF4, 0x7E02,
   0x7E09, 0x7E37, 0x7E41, 0x7E45, 0x7F3E, 0x7F72, 0x7F79, 0x7F7A,
   0x7F85, 0x7F95, 0x7F9A, 0x7FBD, 0x7FFA, 0x8001, 0x8005, 0x8046,
   0x8060, 0x806F, 0x8070, 0x807E, 0x808B, 0x80AD, 0x80B2, 0x8103,
   0x813E, 0x81D8, 0x81E8, 0x81ED, 0x8201, 0x8204, 0x8218, 0x826F,
   0x8279, 0x828B, 0x8291, 0x829D, 0x82B1, 0x82B3, 0x82BD, 0x82E5,
   0x82E6, 0x831D, 0x8323, 0x8336, 0x8352, 0x8353, 0x8363, 0x83AD,
   0x83BD, 0x83C9, 0x83CA, 0x83CC, 0x83DC, 0x83E7, 0x83EF, 0x83F1,
   0x843D, 0x8449, 0x8457, 0x84EE, 0x84F1, 0x84F3, 0x84FC, 0x8516,
   0x8564, 0x85CD, 0x85FA, 0x8606, 0x8612, 0x862D, 0x863F, 0x8650,
   0x865C, 0x8667, 0x8669, 0x8688, 0x86A9, 0x86E2, 0x870E, 0x8728,
   0x876B, 0x8779, 0x8786, 0x87BA, 0x87E1, 0x8801, 0x881F, 0x884C,
   0x8860, 0x8863, 0x88C2, 0x88CF, 0x88D7, 0x88DE, 0x88E1, 0x88F8,
   0x88FA, 0x8910, 0x8941, 0x8964, 0x8986, 0x898B, 0x8996, 0x8AA0,
   0x8AAA, 0x8ABF, 0x8ACB, 0x8AD2, 0x8AD6, 0x8AED, 0x8AF8, 0x8AFE,
   0x8B01, 0x8B39, 0x8B58, 0x8B80, 0x8B8A, 0x8C48, 0x8C55, 0x8CAB,
   0x8CC1, 0x8CC2, 0x8CC8, 0x8CD3, 0x8D08, 0x8D1B, 0x8D77, 0x8DBC,
   0x8DCB, 0x8DEF, 0x8DF0, 0x8ECA, 0x8ED4, 0x8F26, 0x8F2A, 0x8F38,
   0x8F3B, 0x8F62, 0x8F9E, 0x8FB0, 0x8FB6, 0x9023, 0x9038, 0x9072,
   0x907C, 0x908F, 0x9094, 0x90CE, 0x90DE, 0x90F1, 0x90FD, 0x9111,
   0x911B, 0x916A, 0x9199, 0x91B4, 0x91CC, 0x91CF, 0x91D1, 0x9234,
   0x9238, 0x9276, 0x927C, 0x92D7, 0x92D8, 0x9304, 0x934A, 0x93F9,
   0x9415, 0x958B, 0x95AD, 0x95B7, 0x962E, 0x964B, 0x964D, 0x9675,
   0x9678, 0x967C, 0x9686, 0x96A3, 0x96B7, 0x96B8, 0x96C3, 0x96E2,
   0x96E3, 0x96F6, 0x96F7, 0x9723, 0x9732, 0x9748, 0x9756, 0x97DB,
   0x97E0, 0x97FF, 0x980B, 0x9818, 0x9829, 0x983B, 0x985E, 0x98E2,
   0x98EF, 0x98FC, 0x9928, 0x9929, 0x99A7, 0x99C2, 0x99F1, 0x99FE,
   0x9A6A, 0x9B12, 0x9B6F, 0x9C40, 0x9C57, 0x9CFD, 0x9D67, 0x9DB4,
   0x9DFA, 0x9E1E, 0x9E7F, 0x9E97, 0x9E9F, 0x9EBB, 0x9ECE, 0x9EF9,
   0x9EFE, 0x9F05, 0x9F0F, 0x9F16, 0x9F3B, 0x9F43, 0x9F8D, 0x9F8E,
   0x9F9C,
];
pub(crate) static _hb_ucd_dm1_p2_map: [u16; 110]=
[
   0x0122, 0x051C, 0x0525, 0x054B, 0x063A, 0x0804, 0x08DE, 0x0A2C,
   0x0B63, 0x14E4, 0x16A8, 0x16EA, 0x19C8, 0x1B18, 0x1D0B, 0x1DE4,
   0x1DE6, 0x2183, 0x219F, 0x2331, 0x26D4, 0x2844, 0x284A, 0x2B0C,
   0x2BF1, 0x300A, 0x32B8, 0x335F, 0x3393, 0x339C, 0x33C3, 0x33D5,
   0x346D, 0x36A3, 0x38A7, 0x3A8D, 0x3AFA, 0x3CBC, 0x3D1E, 0x3ED1,
   0x3F5E, 0x3F8E, 0x4263, 0x42EE, 0x43AB, 0x4608, 0x4735, 0x4814,
   0x4C36, 0x4C92, 0x4FA1, 0x4FB8, 0x5044, 0x50F2, 0x50F3, 0x5119,
   0x5133, 0x5249, 0x541D, 0x5626, 0x569A, 0x56C5, 0x597C, 0x5AA7,
   0x5BAB, 0x5C80, 0x5CD0, 0x5F86, 0x61DA, 0x6228, 0x6247, 0x62D9,
   0x633E, 0x64DA, 0x6523, 0x65A8, 0x67A7, 0x67B5, 0x6B3C, 0x6C36,
   0x6CD5, 0x6D6B, 0x6F2C, 0x6FB1, 0x70D2, 0x73CA, 0x7667, 0x78AE,
   0x7966, 0x7CA8, 0x7ED3, 0x7F2F, 0x85D2, 0x85ED, 0x872E, 0x8BFA,
   0x8D77, 0x9145, 0x91DF, 0x921A, 0x940A, 0x9496, 0x95B6, 0x9B30,
   0xA0CE, 0xA105, 0xA20E, 0xA291, 0xA392, 0xA600,
];
pub(crate) static _hb_ucd_dm2_u32_map: [u32; 638]=
[
  HB_CODEPOINT_ENCODE3_11_7_14 (0x003C, 0x0338, 0x226E),HB_CODEPOINT_ENCODE3_11_7_14 (0x003D, 0x0338, 0x2260),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x003E, 0x0338, 0x226F),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0300, 0x00C0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0301, 0x00C1),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0302, 0x00C2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0303, 0x00C3),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0304, 0x0100),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0306, 0x0102),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0307, 0x0226),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0308, 0x00C4),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0309, 0x1EA2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x030A, 0x00C5),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x030C, 0x01CD),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x030F, 0x0200),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0311, 0x0202),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0323, 0x1EA0),HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0325, 0x1E00),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0041, 0x0328, 0x0104),HB_CODEPOINT_ENCODE3_11_7_14 (0x0042, 0x0307, 0x1E02),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0042, 0x0323, 0x1E04),HB_CODEPOINT_ENCODE3_11_7_14 (0x0042, 0x0331, 0x1E06),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0043, 0x0301, 0x0106),HB_CODEPOINT_ENCODE3_11_7_14 (0x0043, 0x0302, 0x0108),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0043, 0x0307, 0x010A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0043, 0x030C, 0x010C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0043, 0x0327, 0x00C7),HB_CODEPOINT_ENCODE3_11_7_14 (0x0044, 0x0307, 0x1E0A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0044, 0x030C, 0x010E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0044, 0x0323, 0x1E0C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0044, 0x0327, 0x1E10),HB_CODEPOINT_ENCODE3_11_7_14 (0x0044, 0x032D, 0x1E12),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0044, 0x0331, 0x1E0E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0300, 0x00C8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0301, 0x00C9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0302, 0x00CA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0303, 0x1EBC),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0304, 0x0112),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0306, 0x0114),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0307, 0x0116),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0308, 0x00CB),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0309, 0x1EBA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x030C, 0x011A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x030F, 0x0204),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0311, 0x0206),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0323, 0x1EB8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0327, 0x0228),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0328, 0x0118),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x032D, 0x1E18),HB_CODEPOINT_ENCODE3_11_7_14 (0x0045, 0x0330, 0x1E1A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0046, 0x0307, 0x1E1E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x0301, 0x01F4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x0302, 0x011C),HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x0304, 0x1E20),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x0306, 0x011E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x0307, 0x0120),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x030C, 0x01E6),HB_CODEPOINT_ENCODE3_11_7_14 (0x0047, 0x0327, 0x0122),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x0302, 0x0124),HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x0307, 0x1E22),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x0308, 0x1E26),HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x030C, 0x021E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x0323, 0x1E24),HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x0327, 0x1E28),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0048, 0x032E, 0x1E2A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0300, 0x00CC),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0301, 0x00CD),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0302, 0x00CE),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0303, 0x0128),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0304, 0x012A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0306, 0x012C),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0307, 0x0130),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0308, 0x00CF),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0309, 0x1EC8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x030C, 0x01CF),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x030F, 0x0208),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0311, 0x020A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0323, 0x1ECA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0328, 0x012E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0049, 0x0330, 0x1E2C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004A, 0x0302, 0x0134),HB_CODEPOINT_ENCODE3_11_7_14 (0x004B, 0x0301, 0x1E30),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004B, 0x030C, 0x01E8),HB_CODEPOINT_ENCODE3_11_7_14 (0x004B, 0x0323, 0x1E32),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004B, 0x0327, 0x0136),HB_CODEPOINT_ENCODE3_11_7_14 (0x004B, 0x0331, 0x1E34),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004C, 0x0301, 0x0139),HB_CODEPOINT_ENCODE3_11_7_14 (0x004C, 0x030C, 0x013D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004C, 0x0323, 0x1E36),HB_CODEPOINT_ENCODE3_11_7_14 (0x004C, 0x0327, 0x013B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004C, 0x032D, 0x1E3C),HB_CODEPOINT_ENCODE3_11_7_14 (0x004C, 0x0331, 0x1E3A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004D, 0x0301, 0x1E3E),HB_CODEPOINT_ENCODE3_11_7_14 (0x004D, 0x0307, 0x1E40),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004D, 0x0323, 0x1E42),HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0300, 0x01F8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0301, 0x0143),HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0303, 0x00D1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0307, 0x1E44),HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x030C, 0x0147),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0323, 0x1E46),HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0327, 0x0145),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x032D, 0x1E4A),HB_CODEPOINT_ENCODE3_11_7_14 (0x004E, 0x0331, 0x1E48),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0300, 0x00D2),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0301, 0x00D3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0302, 0x00D4),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0303, 0x00D5),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0304, 0x014C),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0306, 0x014E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0307, 0x022E),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0308, 0x00D6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0309, 0x1ECE),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x030B, 0x0150),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x030C, 0x01D1),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x030F, 0x020C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0311, 0x020E),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x031B, 0x01A0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0323, 0x1ECC),HB_CODEPOINT_ENCODE3_11_7_14 (0x004F, 0x0328, 0x01EA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0050, 0x0301, 0x1E54),HB_CODEPOINT_ENCODE3_11_7_14 (0x0050, 0x0307, 0x1E56),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x0301, 0x0154),HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x0307, 0x1E58),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x030C, 0x0158),HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x030F, 0x0210),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x0311, 0x0212),HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x0323, 0x1E5A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x0327, 0x0156),HB_CODEPOINT_ENCODE3_11_7_14 (0x0052, 0x0331, 0x1E5E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x0301, 0x015A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x0302, 0x015C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x0307, 0x1E60),HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x030C, 0x0160),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x0323, 0x1E62),HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x0326, 0x0218),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0053, 0x0327, 0x015E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x0307, 0x1E6A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x030C, 0x0164),HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x0323, 0x1E6C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x0326, 0x021A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x0327, 0x0162),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x032D, 0x1E70),HB_CODEPOINT_ENCODE3_11_7_14 (0x0054, 0x0331, 0x1E6E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0300, 0x00D9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0301, 0x00DA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0302, 0x00DB),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0303, 0x0168),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0304, 0x016A),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0306, 0x016C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0308, 0x00DC),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0309, 0x1EE6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x030A, 0x016E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x030B, 0x0170),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x030C, 0x01D3),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x030F, 0x0214),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0311, 0x0216),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x031B, 0x01AF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0323, 0x1EE4),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0324, 0x1E72),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0328, 0x0172),HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x032D, 0x1E76),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0055, 0x0330, 0x1E74),HB_CODEPOINT_ENCODE3_11_7_14 (0x0056, 0x0303, 0x1E7C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0056, 0x0323, 0x1E7E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0057, 0x0300, 0x1E80),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0057, 0x0301, 0x1E82),HB_CODEPOINT_ENCODE3_11_7_14 (0x0057, 0x0302, 0x0174),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0057, 0x0307, 0x1E86),HB_CODEPOINT_ENCODE3_11_7_14 (0x0057, 0x0308, 0x1E84),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0057, 0x0323, 0x1E88),HB_CODEPOINT_ENCODE3_11_7_14 (0x0058, 0x0307, 0x1E8A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0058, 0x0308, 0x1E8C),HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0300, 0x1EF2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0301, 0x00DD),HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0302, 0x0176),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0303, 0x1EF8),HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0304, 0x0232),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0307, 0x1E8E),HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0308, 0x0178),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0309, 0x1EF6),HB_CODEPOINT_ENCODE3_11_7_14 (0x0059, 0x0323, 0x1EF4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x005A, 0x0301, 0x0179),HB_CODEPOINT_ENCODE3_11_7_14 (0x005A, 0x0302, 0x1E90),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x005A, 0x0307, 0x017B),HB_CODEPOINT_ENCODE3_11_7_14 (0x005A, 0x030C, 0x017D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x005A, 0x0323, 0x1E92),HB_CODEPOINT_ENCODE3_11_7_14 (0x005A, 0x0331, 0x1E94),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0300, 0x00E0),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0301, 0x00E1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0302, 0x00E2),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0303, 0x00E3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0304, 0x0101),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0306, 0x0103),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0307, 0x0227),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0308, 0x00E4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0309, 0x1EA3),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x030A, 0x00E5),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x030C, 0x01CE),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x030F, 0x0201),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0311, 0x0203),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0323, 0x1EA1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0325, 0x1E01),HB_CODEPOINT_ENCODE3_11_7_14 (0x0061, 0x0328, 0x0105),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0062, 0x0307, 0x1E03),HB_CODEPOINT_ENCODE3_11_7_14 (0x0062, 0x0323, 0x1E05),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0062, 0x0331, 0x1E07),HB_CODEPOINT_ENCODE3_11_7_14 (0x0063, 0x0301, 0x0107),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0063, 0x0302, 0x0109),HB_CODEPOINT_ENCODE3_11_7_14 (0x0063, 0x0307, 0x010B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0063, 0x030C, 0x010D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0063, 0x0327, 0x00E7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0064, 0x0307, 0x1E0B),HB_CODEPOINT_ENCODE3_11_7_14 (0x0064, 0x030C, 0x010F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0064, 0x0323, 0x1E0D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0064, 0x0327, 0x1E11),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0064, 0x032D, 0x1E13),HB_CODEPOINT_ENCODE3_11_7_14 (0x0064, 0x0331, 0x1E0F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0300, 0x00E8),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0301, 0x00E9),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0302, 0x00EA),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0303, 0x1EBD),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0304, 0x0113),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0306, 0x0115),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0307, 0x0117),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0308, 0x00EB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0309, 0x1EBB),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x030C, 0x011B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x030F, 0x0205),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0311, 0x0207),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0323, 0x1EB9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0327, 0x0229),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0328, 0x0119),HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x032D, 0x1E19),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0065, 0x0330, 0x1E1B),HB_CODEPOINT_ENCODE3_11_7_14 (0x0066, 0x0307, 0x1E1F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x0301, 0x01F5),HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x0302, 0x011D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x0304, 0x1E21),HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x0306, 0x011F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x0307, 0x0121),HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x030C, 0x01E7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0067, 0x0327, 0x0123),HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x0302, 0x0125),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x0307, 0x1E23),HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x0308, 0x1E27),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x030C, 0x021F),HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x0323, 0x1E25),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x0327, 0x1E29),HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x032E, 0x1E2B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0068, 0x0331, 0x1E96),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0300, 0x00EC),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0301, 0x00ED),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0302, 0x00EE),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0303, 0x0129),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0304, 0x012B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0306, 0x012D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0308, 0x00EF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0309, 0x1EC9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x030C, 0x01D0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x030F, 0x0209),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0311, 0x020B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0323, 0x1ECB),HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0328, 0x012F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0069, 0x0330, 0x1E2D),HB_CODEPOINT_ENCODE3_11_7_14 (0x006A, 0x0302, 0x0135),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006A, 0x030C, 0x01F0),HB_CODEPOINT_ENCODE3_11_7_14 (0x006B, 0x0301, 0x1E31),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006B, 0x030C, 0x01E9),HB_CODEPOINT_ENCODE3_11_7_14 (0x006B, 0x0323, 0x1E33),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006B, 0x0327, 0x0137),HB_CODEPOINT_ENCODE3_11_7_14 (0x006B, 0x0331, 0x1E35),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006C, 0x0301, 0x013A),HB_CODEPOINT_ENCODE3_11_7_14 (0x006C, 0x030C, 0x013E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006C, 0x0323, 0x1E37),HB_CODEPOINT_ENCODE3_11_7_14 (0x006C, 0x0327, 0x013C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006C, 0x032D, 0x1E3D),HB_CODEPOINT_ENCODE3_11_7_14 (0x006C, 0x0331, 0x1E3B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006D, 0x0301, 0x1E3F),HB_CODEPOINT_ENCODE3_11_7_14 (0x006D, 0x0307, 0x1E41),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006D, 0x0323, 0x1E43),HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0300, 0x01F9),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0301, 0x0144),HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0303, 0x00F1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0307, 0x1E45),HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x030C, 0x0148),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0323, 0x1E47),HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0327, 0x0146),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x032D, 0x1E4B),HB_CODEPOINT_ENCODE3_11_7_14 (0x006E, 0x0331, 0x1E49),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0300, 0x00F2),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0301, 0x00F3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0302, 0x00F4),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0303, 0x00F5),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0304, 0x014D),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0306, 0x014F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0307, 0x022F),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0308, 0x00F6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0309, 0x1ECF),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x030B, 0x0151),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x030C, 0x01D2),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x030F, 0x020D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0311, 0x020F),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x031B, 0x01A1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0323, 0x1ECD),HB_CODEPOINT_ENCODE3_11_7_14 (0x006F, 0x0328, 0x01EB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0070, 0x0301, 0x1E55),HB_CODEPOINT_ENCODE3_11_7_14 (0x0070, 0x0307, 0x1E57),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x0301, 0x0155),HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x0307, 0x1E59),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x030C, 0x0159),HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x030F, 0x0211),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x0311, 0x0213),HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x0323, 0x1E5B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x0327, 0x0157),HB_CODEPOINT_ENCODE3_11_7_14 (0x0072, 0x0331, 0x1E5F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x0301, 0x015B),HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x0302, 0x015D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x0307, 0x1E61),HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x030C, 0x0161),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x0323, 0x1E63),HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x0326, 0x0219),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0073, 0x0327, 0x015F),HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x0307, 0x1E6B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x0308, 0x1E97),HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x030C, 0x0165),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x0323, 0x1E6D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x0326, 0x021B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x0327, 0x0163),HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x032D, 0x1E71),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0074, 0x0331, 0x1E6F),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0300, 0x00F9),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0301, 0x00FA),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0302, 0x00FB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0303, 0x0169),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0304, 0x016B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0306, 0x016D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0308, 0x00FC),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0309, 0x1EE7),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x030A, 0x016F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x030B, 0x0171),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x030C, 0x01D4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x030F, 0x0215),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0311, 0x0217),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x031B, 0x01B0),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0323, 0x1EE5),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0324, 0x1E73),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0328, 0x0173),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x032D, 0x1E77),HB_CODEPOINT_ENCODE3_11_7_14 (0x0075, 0x0330, 0x1E75),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0076, 0x0303, 0x1E7D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0076, 0x0323, 0x1E7F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x0300, 0x1E81),HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x0301, 0x1E83),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x0302, 0x0175),HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x0307, 0x1E87),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x0308, 0x1E85),HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x030A, 0x1E98),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0077, 0x0323, 0x1E89),HB_CODEPOINT_ENCODE3_11_7_14 (0x0078, 0x0307, 0x1E8B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0078, 0x0308, 0x1E8D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0300, 0x1EF3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0301, 0x00FD),HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0302, 0x0177),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0303, 0x1EF9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0304, 0x0233),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0307, 0x1E8F),HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0308, 0x00FF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0309, 0x1EF7),HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x030A, 0x1E99),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0079, 0x0323, 0x1EF5),HB_CODEPOINT_ENCODE3_11_7_14 (0x007A, 0x0301, 0x017A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x007A, 0x0302, 0x1E91),HB_CODEPOINT_ENCODE3_11_7_14 (0x007A, 0x0307, 0x017C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x007A, 0x030C, 0x017E),HB_CODEPOINT_ENCODE3_11_7_14 (0x007A, 0x0323, 0x1E93),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x007A, 0x0331, 0x1E95),HB_CODEPOINT_ENCODE3_11_7_14 (0x00A8, 0x0300, 0x1FED),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00A8, 0x0301, 0x0385),HB_CODEPOINT_ENCODE3_11_7_14 (0x00A8, 0x0342, 0x1FC1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00C2, 0x0300, 0x1EA6),HB_CODEPOINT_ENCODE3_11_7_14 (0x00C2, 0x0301, 0x1EA4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00C2, 0x0303, 0x1EAA),HB_CODEPOINT_ENCODE3_11_7_14 (0x00C2, 0x0309, 0x1EA8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00C4, 0x0304, 0x01DE),HB_CODEPOINT_ENCODE3_11_7_14 (0x00C5, 0x0301, 0x01FA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00C6, 0x0301, 0x01FC),HB_CODEPOINT_ENCODE3_11_7_14 (0x00C6, 0x0304, 0x01E2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00C7, 0x0301, 0x1E08),HB_CODEPOINT_ENCODE3_11_7_14 (0x00CA, 0x0300, 0x1EC0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00CA, 0x0301, 0x1EBE),HB_CODEPOINT_ENCODE3_11_7_14 (0x00CA, 0x0303, 0x1EC4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00CA, 0x0309, 0x1EC2),HB_CODEPOINT_ENCODE3_11_7_14 (0x00CF, 0x0301, 0x1E2E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00D4, 0x0300, 0x1ED2),HB_CODEPOINT_ENCODE3_11_7_14 (0x00D4, 0x0301, 0x1ED0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00D4, 0x0303, 0x1ED6),HB_CODEPOINT_ENCODE3_11_7_14 (0x00D4, 0x0309, 0x1ED4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00D5, 0x0301, 0x1E4C),HB_CODEPOINT_ENCODE3_11_7_14 (0x00D5, 0x0304, 0x022C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00D5, 0x0308, 0x1E4E),HB_CODEPOINT_ENCODE3_11_7_14 (0x00D6, 0x0304, 0x022A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00D8, 0x0301, 0x01FE),HB_CODEPOINT_ENCODE3_11_7_14 (0x00DC, 0x0300, 0x01DB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00DC, 0x0301, 0x01D7),HB_CODEPOINT_ENCODE3_11_7_14 (0x00DC, 0x0304, 0x01D5),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00DC, 0x030C, 0x01D9),HB_CODEPOINT_ENCODE3_11_7_14 (0x00E2, 0x0300, 0x1EA7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00E2, 0x0301, 0x1EA5),HB_CODEPOINT_ENCODE3_11_7_14 (0x00E2, 0x0303, 0x1EAB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00E2, 0x0309, 0x1EA9),HB_CODEPOINT_ENCODE3_11_7_14 (0x00E4, 0x0304, 0x01DF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00E5, 0x0301, 0x01FB),HB_CODEPOINT_ENCODE3_11_7_14 (0x00E6, 0x0301, 0x01FD),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00E6, 0x0304, 0x01E3),HB_CODEPOINT_ENCODE3_11_7_14 (0x00E7, 0x0301, 0x1E09),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00EA, 0x0300, 0x1EC1),HB_CODEPOINT_ENCODE3_11_7_14 (0x00EA, 0x0301, 0x1EBF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00EA, 0x0303, 0x1EC5),HB_CODEPOINT_ENCODE3_11_7_14 (0x00EA, 0x0309, 0x1EC3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00EF, 0x0301, 0x1E2F),HB_CODEPOINT_ENCODE3_11_7_14 (0x00F4, 0x0300, 0x1ED3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00F4, 0x0301, 0x1ED1),HB_CODEPOINT_ENCODE3_11_7_14 (0x00F4, 0x0303, 0x1ED7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00F4, 0x0309, 0x1ED5),HB_CODEPOINT_ENCODE3_11_7_14 (0x00F5, 0x0301, 0x1E4D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00F5, 0x0304, 0x022D),HB_CODEPOINT_ENCODE3_11_7_14 (0x00F5, 0x0308, 0x1E4F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00F6, 0x0304, 0x022B),HB_CODEPOINT_ENCODE3_11_7_14 (0x00F8, 0x0301, 0x01FF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00FC, 0x0300, 0x01DC),HB_CODEPOINT_ENCODE3_11_7_14 (0x00FC, 0x0301, 0x01D8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x00FC, 0x0304, 0x01D6),HB_CODEPOINT_ENCODE3_11_7_14 (0x00FC, 0x030C, 0x01DA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0102, 0x0300, 0x1EB0),HB_CODEPOINT_ENCODE3_11_7_14 (0x0102, 0x0301, 0x1EAE),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0102, 0x0303, 0x1EB4),HB_CODEPOINT_ENCODE3_11_7_14 (0x0102, 0x0309, 0x1EB2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0103, 0x0300, 0x1EB1),HB_CODEPOINT_ENCODE3_11_7_14 (0x0103, 0x0301, 0x1EAF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0103, 0x0303, 0x1EB5),HB_CODEPOINT_ENCODE3_11_7_14 (0x0103, 0x0309, 0x1EB3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0112, 0x0300, 0x1E14),HB_CODEPOINT_ENCODE3_11_7_14 (0x0112, 0x0301, 0x1E16),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0113, 0x0300, 0x1E15),HB_CODEPOINT_ENCODE3_11_7_14 (0x0113, 0x0301, 0x1E17),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x014C, 0x0300, 0x1E50),HB_CODEPOINT_ENCODE3_11_7_14 (0x014C, 0x0301, 0x1E52),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x014D, 0x0300, 0x1E51),HB_CODEPOINT_ENCODE3_11_7_14 (0x014D, 0x0301, 0x1E53),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x015A, 0x0307, 0x1E64),HB_CODEPOINT_ENCODE3_11_7_14 (0x015B, 0x0307, 0x1E65),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0160, 0x0307, 0x1E66),HB_CODEPOINT_ENCODE3_11_7_14 (0x0161, 0x0307, 0x1E67),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0168, 0x0301, 0x1E78),HB_CODEPOINT_ENCODE3_11_7_14 (0x0169, 0x0301, 0x1E79),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x016A, 0x0308, 0x1E7A),HB_CODEPOINT_ENCODE3_11_7_14 (0x016B, 0x0308, 0x1E7B),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x017F, 0x0307, 0x1E9B),HB_CODEPOINT_ENCODE3_11_7_14 (0x01A0, 0x0300, 0x1EDC),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01A0, 0x0301, 0x1EDA),HB_CODEPOINT_ENCODE3_11_7_14 (0x01A0, 0x0303, 0x1EE0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01A0, 0x0309, 0x1EDE),HB_CODEPOINT_ENCODE3_11_7_14 (0x01A0, 0x0323, 0x1EE2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01A1, 0x0300, 0x1EDD),HB_CODEPOINT_ENCODE3_11_7_14 (0x01A1, 0x0301, 0x1EDB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01A1, 0x0303, 0x1EE1),HB_CODEPOINT_ENCODE3_11_7_14 (0x01A1, 0x0309, 0x1EDF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01A1, 0x0323, 0x1EE3),HB_CODEPOINT_ENCODE3_11_7_14 (0x01AF, 0x0300, 0x1EEA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01AF, 0x0301, 0x1EE8),HB_CODEPOINT_ENCODE3_11_7_14 (0x01AF, 0x0303, 0x1EEE),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01AF, 0x0309, 0x1EEC),HB_CODEPOINT_ENCODE3_11_7_14 (0x01AF, 0x0323, 0x1EF0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01B0, 0x0300, 0x1EEB),HB_CODEPOINT_ENCODE3_11_7_14 (0x01B0, 0x0301, 0x1EE9),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01B0, 0x0303, 0x1EEF),HB_CODEPOINT_ENCODE3_11_7_14 (0x01B0, 0x0309, 0x1EED),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01B0, 0x0323, 0x1EF1),HB_CODEPOINT_ENCODE3_11_7_14 (0x01B7, 0x030C, 0x01EE),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x01EA, 0x0304, 0x01EC),HB_CODEPOINT_ENCODE3_11_7_14 (0x01EB, 0x0304, 0x01ED),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0226, 0x0304, 0x01E0),HB_CODEPOINT_ENCODE3_11_7_14 (0x0227, 0x0304, 0x01E1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0228, 0x0306, 0x1E1C),HB_CODEPOINT_ENCODE3_11_7_14 (0x0229, 0x0306, 0x1E1D),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x022E, 0x0304, 0x0230),HB_CODEPOINT_ENCODE3_11_7_14 (0x022F, 0x0304, 0x0231),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0292, 0x030C, 0x01EF),HB_CODEPOINT_ENCODE3_11_7_14 (0x0308, 0x0301, 0x0000),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0300, 0x1FBA),HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0301, 0x0386),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0304, 0x1FB9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0306, 0x1FB8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0313, 0x1F08),HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0314, 0x1F09),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0391, 0x0345, 0x1FBC),HB_CODEPOINT_ENCODE3_11_7_14 (0x0395, 0x0300, 0x1FC8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0395, 0x0301, 0x0388),HB_CODEPOINT_ENCODE3_11_7_14 (0x0395, 0x0313, 0x1F18),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0395, 0x0314, 0x1F19),HB_CODEPOINT_ENCODE3_11_7_14 (0x0397, 0x0300, 0x1FCA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0397, 0x0301, 0x0389),HB_CODEPOINT_ENCODE3_11_7_14 (0x0397, 0x0313, 0x1F28),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0397, 0x0314, 0x1F29),HB_CODEPOINT_ENCODE3_11_7_14 (0x0397, 0x0345, 0x1FCC),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0300, 0x1FDA),HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0301, 0x038A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0304, 0x1FD9),HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0306, 0x1FD8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0308, 0x03AA),HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0313, 0x1F38),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0399, 0x0314, 0x1F39),HB_CODEPOINT_ENCODE3_11_7_14 (0x039F, 0x0300, 0x1FF8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x039F, 0x0301, 0x038C),HB_CODEPOINT_ENCODE3_11_7_14 (0x039F, 0x0313, 0x1F48),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x039F, 0x0314, 0x1F49),HB_CODEPOINT_ENCODE3_11_7_14 (0x03A1, 0x0314, 0x1FEC),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03A5, 0x0300, 0x1FEA),HB_CODEPOINT_ENCODE3_11_7_14 (0x03A5, 0x0301, 0x038E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03A5, 0x0304, 0x1FE9),HB_CODEPOINT_ENCODE3_11_7_14 (0x03A5, 0x0306, 0x1FE8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03A5, 0x0308, 0x03AB),HB_CODEPOINT_ENCODE3_11_7_14 (0x03A5, 0x0314, 0x1F59),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03A9, 0x0300, 0x1FFA),HB_CODEPOINT_ENCODE3_11_7_14 (0x03A9, 0x0301, 0x038F),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03A9, 0x0313, 0x1F68),HB_CODEPOINT_ENCODE3_11_7_14 (0x03A9, 0x0314, 0x1F69),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03A9, 0x0345, 0x1FFC),HB_CODEPOINT_ENCODE3_11_7_14 (0x03AC, 0x0345, 0x1FB4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03AE, 0x0345, 0x1FC4),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0300, 0x1F70),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0301, 0x03AC),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0304, 0x1FB1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0306, 0x1FB0),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0313, 0x1F00),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0314, 0x1F01),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0342, 0x1FB6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B1, 0x0345, 0x1FB3),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B5, 0x0300, 0x1F72),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B5, 0x0301, 0x03AD),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B5, 0x0313, 0x1F10),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B5, 0x0314, 0x1F11),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B7, 0x0300, 0x1F74),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B7, 0x0301, 0x03AE),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B7, 0x0313, 0x1F20),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B7, 0x0314, 0x1F21),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B7, 0x0342, 0x1FC6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B7, 0x0345, 0x1FC3),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0300, 0x1F76),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0301, 0x03AF),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0304, 0x1FD1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0306, 0x1FD0),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0308, 0x03CA),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0313, 0x1F30),HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0314, 0x1F31),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03B9, 0x0342, 0x1FD6),HB_CODEPOINT_ENCODE3_11_7_14 (0x03BF, 0x0300, 0x1F78),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03BF, 0x0301, 0x03CC),HB_CODEPOINT_ENCODE3_11_7_14 (0x03BF, 0x0313, 0x1F40),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03BF, 0x0314, 0x1F41),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C1, 0x0313, 0x1FE4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C1, 0x0314, 0x1FE5),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0300, 0x1F7A),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0301, 0x03CD),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0304, 0x1FE1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0306, 0x1FE0),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0308, 0x03CB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0313, 0x1F50),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0314, 0x1F51),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C5, 0x0342, 0x1FE6),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C9, 0x0300, 0x1F7C),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C9, 0x0301, 0x03CE),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C9, 0x0313, 0x1F60),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C9, 0x0314, 0x1F61),HB_CODEPOINT_ENCODE3_11_7_14 (0x03C9, 0x0342, 0x1FF6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03C9, 0x0345, 0x1FF3),HB_CODEPOINT_ENCODE3_11_7_14 (0x03CA, 0x0300, 0x1FD2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03CA, 0x0301, 0x0390),HB_CODEPOINT_ENCODE3_11_7_14 (0x03CA, 0x0342, 0x1FD7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03CB, 0x0300, 0x1FE2),HB_CODEPOINT_ENCODE3_11_7_14 (0x03CB, 0x0301, 0x03B0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03CB, 0x0342, 0x1FE7),HB_CODEPOINT_ENCODE3_11_7_14 (0x03CE, 0x0345, 0x1FF4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x03D2, 0x0301, 0x03D3),HB_CODEPOINT_ENCODE3_11_7_14 (0x03D2, 0x0308, 0x03D4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0406, 0x0308, 0x0407),HB_CODEPOINT_ENCODE3_11_7_14 (0x0410, 0x0306, 0x04D0),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0410, 0x0308, 0x04D2),HB_CODEPOINT_ENCODE3_11_7_14 (0x0413, 0x0301, 0x0403),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0415, 0x0300, 0x0400),HB_CODEPOINT_ENCODE3_11_7_14 (0x0415, 0x0306, 0x04D6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0415, 0x0308, 0x0401),HB_CODEPOINT_ENCODE3_11_7_14 (0x0416, 0x0306, 0x04C1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0416, 0x0308, 0x04DC),HB_CODEPOINT_ENCODE3_11_7_14 (0x0417, 0x0308, 0x04DE),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0418, 0x0300, 0x040D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0418, 0x0304, 0x04E2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0418, 0x0306, 0x0419),HB_CODEPOINT_ENCODE3_11_7_14 (0x0418, 0x0308, 0x04E4),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x041A, 0x0301, 0x040C),HB_CODEPOINT_ENCODE3_11_7_14 (0x041E, 0x0308, 0x04E6),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0423, 0x0304, 0x04EE),HB_CODEPOINT_ENCODE3_11_7_14 (0x0423, 0x0306, 0x040E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0423, 0x0308, 0x04F0),HB_CODEPOINT_ENCODE3_11_7_14 (0x0423, 0x030B, 0x04F2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0427, 0x0308, 0x04F4),HB_CODEPOINT_ENCODE3_11_7_14 (0x042B, 0x0308, 0x04F8),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x042D, 0x0308, 0x04EC),HB_CODEPOINT_ENCODE3_11_7_14 (0x0430, 0x0306, 0x04D1),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0430, 0x0308, 0x04D3),HB_CODEPOINT_ENCODE3_11_7_14 (0x0433, 0x0301, 0x0453),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0435, 0x0300, 0x0450),HB_CODEPOINT_ENCODE3_11_7_14 (0x0435, 0x0306, 0x04D7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0435, 0x0308, 0x0451),HB_CODEPOINT_ENCODE3_11_7_14 (0x0436, 0x0306, 0x04C2),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0436, 0x0308, 0x04DD),HB_CODEPOINT_ENCODE3_11_7_14 (0x0437, 0x0308, 0x04DF),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0438, 0x0300, 0x045D),HB_CODEPOINT_ENCODE3_11_7_14 (0x0438, 0x0304, 0x04E3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0438, 0x0306, 0x0439),HB_CODEPOINT_ENCODE3_11_7_14 (0x0438, 0x0308, 0x04E5),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x043A, 0x0301, 0x045C),HB_CODEPOINT_ENCODE3_11_7_14 (0x043E, 0x0308, 0x04E7),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0443, 0x0304, 0x04EF),HB_CODEPOINT_ENCODE3_11_7_14 (0x0443, 0x0306, 0x045E),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0443, 0x0308, 0x04F1),HB_CODEPOINT_ENCODE3_11_7_14 (0x0443, 0x030B, 0x04F3),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0447, 0x0308, 0x04F5),HB_CODEPOINT_ENCODE3_11_7_14 (0x044B, 0x0308, 0x04F9),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x044D, 0x0308, 0x04ED),HB_CODEPOINT_ENCODE3_11_7_14 (0x0456, 0x0308, 0x0457),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x0474, 0x030F, 0x0476),HB_CODEPOINT_ENCODE3_11_7_14 (0x0475, 0x030F, 0x0477),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x04D8, 0x0308, 0x04DA),HB_CODEPOINT_ENCODE3_11_7_14 (0x04D9, 0x0308, 0x04DB),
  HB_CODEPOINT_ENCODE3_11_7_14 (0x04E8, 0x0308, 0x04EA),HB_CODEPOINT_ENCODE3_11_7_14 (0x04E9, 0x0308, 0x04EB),
];
pub(crate) static _hb_ucd_dm2_u64_map: [u64; 408]=
[
     HB_CODEPOINT_ENCODE3 (0x05D0, 0x05B7, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D0, 0x05B8, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05D0, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D1, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05D1, 0x05BF, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D2, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05D3, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D4, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05D5, 0x05B9, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D5, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05D6, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D8, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05D9, 0x05B4, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05D9, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05DA, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05DB, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05DB, 0x05BF, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05DC, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05DE, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05E0, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05E1, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05E3, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05E4, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05E4, 0x05BF, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05E6, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05E7, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05E8, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05E9, 0x05BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05E9, 0x05C1, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05E9, 0x05C2, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x05EA, 0x05BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x05F2, 0x05B7, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0627, 0x0653, 0x0622),   HB_CODEPOINT_ENCODE3 (0x0627, 0x0654, 0x0623),
     HB_CODEPOINT_ENCODE3 (0x0627, 0x0655, 0x0625),   HB_CODEPOINT_ENCODE3 (0x0648, 0x0654, 0x0624),
     HB_CODEPOINT_ENCODE3 (0x064A, 0x0654, 0x0626),   HB_CODEPOINT_ENCODE3 (0x06C1, 0x0654, 0x06C2),
     HB_CODEPOINT_ENCODE3 (0x06D2, 0x0654, 0x06D3),   HB_CODEPOINT_ENCODE3 (0x06D5, 0x0654, 0x06C0),
     HB_CODEPOINT_ENCODE3 (0x0915, 0x093C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0916, 0x093C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0917, 0x093C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x091C, 0x093C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0921, 0x093C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0922, 0x093C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0928, 0x093C, 0x0929),   HB_CODEPOINT_ENCODE3 (0x092B, 0x093C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x092F, 0x093C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0930, 0x093C, 0x0931),
     HB_CODEPOINT_ENCODE3 (0x0933, 0x093C, 0x0934),   HB_CODEPOINT_ENCODE3 (0x09A1, 0x09BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x09A2, 0x09BC, 0x0000),   HB_CODEPOINT_ENCODE3 (0x09AF, 0x09BC, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x09C7, 0x09BE, 0x09CB),   HB_CODEPOINT_ENCODE3 (0x09C7, 0x09D7, 0x09CC),
     HB_CODEPOINT_ENCODE3 (0x0A16, 0x0A3C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0A17, 0x0A3C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0A1C, 0x0A3C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0A2B, 0x0A3C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0A32, 0x0A3C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0A38, 0x0A3C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0B21, 0x0B3C, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0B22, 0x0B3C, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0B47, 0x0B3E, 0x0B4B),   HB_CODEPOINT_ENCODE3 (0x0B47, 0x0B56, 0x0B48),
     HB_CODEPOINT_ENCODE3 (0x0B47, 0x0B57, 0x0B4C),   HB_CODEPOINT_ENCODE3 (0x0B92, 0x0BD7, 0x0B94),
     HB_CODEPOINT_ENCODE3 (0x0BC6, 0x0BBE, 0x0BCA),   HB_CODEPOINT_ENCODE3 (0x0BC6, 0x0BD7, 0x0BCC),
     HB_CODEPOINT_ENCODE3 (0x0BC7, 0x0BBE, 0x0BCB),   HB_CODEPOINT_ENCODE3 (0x0C46, 0x0C56, 0x0C48),
     HB_CODEPOINT_ENCODE3 (0x0CBF, 0x0CD5, 0x0CC0),   HB_CODEPOINT_ENCODE3 (0x0CC6, 0x0CC2, 0x0CCA),
     HB_CODEPOINT_ENCODE3 (0x0CC6, 0x0CD5, 0x0CC7),   HB_CODEPOINT_ENCODE3 (0x0CC6, 0x0CD6, 0x0CC8),
     HB_CODEPOINT_ENCODE3 (0x0CCA, 0x0CD5, 0x0CCB),   HB_CODEPOINT_ENCODE3 (0x0D46, 0x0D3E, 0x0D4A),
     HB_CODEPOINT_ENCODE3 (0x0D46, 0x0D57, 0x0D4C),   HB_CODEPOINT_ENCODE3 (0x0D47, 0x0D3E, 0x0D4B),
     HB_CODEPOINT_ENCODE3 (0x0DD9, 0x0DCA, 0x0DDA),   HB_CODEPOINT_ENCODE3 (0x0DD9, 0x0DCF, 0x0DDC),
     HB_CODEPOINT_ENCODE3 (0x0DD9, 0x0DDF, 0x0DDE),   HB_CODEPOINT_ENCODE3 (0x0DDC, 0x0DCA, 0x0DDD),
     HB_CODEPOINT_ENCODE3 (0x0F40, 0x0FB5, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0F42, 0x0FB7, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0F4C, 0x0FB7, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0F51, 0x0FB7, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0F56, 0x0FB7, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0F5B, 0x0FB7, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0F71, 0x0F72, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0F71, 0x0F74, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0F71, 0x0F80, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0F90, 0x0FB5, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0F92, 0x0FB7, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0F9C, 0x0FB7, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0FA1, 0x0FB7, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0FA6, 0x0FB7, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0FAB, 0x0FB7, 0x0000),   HB_CODEPOINT_ENCODE3 (0x0FB2, 0x0F80, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x0FB3, 0x0F80, 0x0000),   HB_CODEPOINT_ENCODE3 (0x1025, 0x102E, 0x1026),
     HB_CODEPOINT_ENCODE3 (0x1B05, 0x1B35, 0x1B06),   HB_CODEPOINT_ENCODE3 (0x1B07, 0x1B35, 0x1B08),
     HB_CODEPOINT_ENCODE3 (0x1B09, 0x1B35, 0x1B0A),   HB_CODEPOINT_ENCODE3 (0x1B0B, 0x1B35, 0x1B0C),
     HB_CODEPOINT_ENCODE3 (0x1B0D, 0x1B35, 0x1B0E),   HB_CODEPOINT_ENCODE3 (0x1B11, 0x1B35, 0x1B12),
     HB_CODEPOINT_ENCODE3 (0x1B3A, 0x1B35, 0x1B3B),   HB_CODEPOINT_ENCODE3 (0x1B3C, 0x1B35, 0x1B3D),
     HB_CODEPOINT_ENCODE3 (0x1B3E, 0x1B35, 0x1B40),   HB_CODEPOINT_ENCODE3 (0x1B3F, 0x1B35, 0x1B41),
     HB_CODEPOINT_ENCODE3 (0x1B42, 0x1B35, 0x1B43),   HB_CODEPOINT_ENCODE3 (0x1E36, 0x0304, 0x1E38),
     HB_CODEPOINT_ENCODE3 (0x1E37, 0x0304, 0x1E39),   HB_CODEPOINT_ENCODE3 (0x1E5A, 0x0304, 0x1E5C),
     HB_CODEPOINT_ENCODE3 (0x1E5B, 0x0304, 0x1E5D),   HB_CODEPOINT_ENCODE3 (0x1E62, 0x0307, 0x1E68),
     HB_CODEPOINT_ENCODE3 (0x1E63, 0x0307, 0x1E69),   HB_CODEPOINT_ENCODE3 (0x1EA0, 0x0302, 0x1EAC),
     HB_CODEPOINT_ENCODE3 (0x1EA0, 0x0306, 0x1EB6),   HB_CODEPOINT_ENCODE3 (0x1EA1, 0x0302, 0x1EAD),
     HB_CODEPOINT_ENCODE3 (0x1EA1, 0x0306, 0x1EB7),   HB_CODEPOINT_ENCODE3 (0x1EB8, 0x0302, 0x1EC6),
     HB_CODEPOINT_ENCODE3 (0x1EB9, 0x0302, 0x1EC7),   HB_CODEPOINT_ENCODE3 (0x1ECC, 0x0302, 0x1ED8),
     HB_CODEPOINT_ENCODE3 (0x1ECD, 0x0302, 0x1ED9),   HB_CODEPOINT_ENCODE3 (0x1F00, 0x0300, 0x1F02),
     HB_CODEPOINT_ENCODE3 (0x1F00, 0x0301, 0x1F04),   HB_CODEPOINT_ENCODE3 (0x1F00, 0x0342, 0x1F06),
     HB_CODEPOINT_ENCODE3 (0x1F00, 0x0345, 0x1F80),   HB_CODEPOINT_ENCODE3 (0x1F01, 0x0300, 0x1F03),
     HB_CODEPOINT_ENCODE3 (0x1F01, 0x0301, 0x1F05),   HB_CODEPOINT_ENCODE3 (0x1F01, 0x0342, 0x1F07),
     HB_CODEPOINT_ENCODE3 (0x1F01, 0x0345, 0x1F81),   HB_CODEPOINT_ENCODE3 (0x1F02, 0x0345, 0x1F82),
     HB_CODEPOINT_ENCODE3 (0x1F03, 0x0345, 0x1F83),   HB_CODEPOINT_ENCODE3 (0x1F04, 0x0345, 0x1F84),
     HB_CODEPOINT_ENCODE3 (0x1F05, 0x0345, 0x1F85),   HB_CODEPOINT_ENCODE3 (0x1F06, 0x0345, 0x1F86),
     HB_CODEPOINT_ENCODE3 (0x1F07, 0x0345, 0x1F87),   HB_CODEPOINT_ENCODE3 (0x1F08, 0x0300, 0x1F0A),
     HB_CODEPOINT_ENCODE3 (0x1F08, 0x0301, 0x1F0C),   HB_CODEPOINT_ENCODE3 (0x1F08, 0x0342, 0x1F0E),
     HB_CODEPOINT_ENCODE3 (0x1F08, 0x0345, 0x1F88),   HB_CODEPOINT_ENCODE3 (0x1F09, 0x0300, 0x1F0B),
     HB_CODEPOINT_ENCODE3 (0x1F09, 0x0301, 0x1F0D),   HB_CODEPOINT_ENCODE3 (0x1F09, 0x0342, 0x1F0F),
     HB_CODEPOINT_ENCODE3 (0x1F09, 0x0345, 0x1F89),   HB_CODEPOINT_ENCODE3 (0x1F0A, 0x0345, 0x1F8A),
     HB_CODEPOINT_ENCODE3 (0x1F0B, 0x0345, 0x1F8B),   HB_CODEPOINT_ENCODE3 (0x1F0C, 0x0345, 0x1F8C),
     HB_CODEPOINT_ENCODE3 (0x1F0D, 0x0345, 0x1F8D),   HB_CODEPOINT_ENCODE3 (0x1F0E, 0x0345, 0x1F8E),
     HB_CODEPOINT_ENCODE3 (0x1F0F, 0x0345, 0x1F8F),   HB_CODEPOINT_ENCODE3 (0x1F10, 0x0300, 0x1F12),
     HB_CODEPOINT_ENCODE3 (0x1F10, 0x0301, 0x1F14),   HB_CODEPOINT_ENCODE3 (0x1F11, 0x0300, 0x1F13),
     HB_CODEPOINT_ENCODE3 (0x1F11, 0x0301, 0x1F15),   HB_CODEPOINT_ENCODE3 (0x1F18, 0x0300, 0x1F1A),
     HB_CODEPOINT_ENCODE3 (0x1F18, 0x0301, 0x1F1C),   HB_CODEPOINT_ENCODE3 (0x1F19, 0x0300, 0x1F1B),
     HB_CODEPOINT_ENCODE3 (0x1F19, 0x0301, 0x1F1D),   HB_CODEPOINT_ENCODE3 (0x1F20, 0x0300, 0x1F22),
     HB_CODEPOINT_ENCODE3 (0x1F20, 0x0301, 0x1F24),   HB_CODEPOINT_ENCODE3 (0x1F20, 0x0342, 0x1F26),
     HB_CODEPOINT_ENCODE3 (0x1F20, 0x0345, 0x1F90),   HB_CODEPOINT_ENCODE3 (0x1F21, 0x0300, 0x1F23),
     HB_CODEPOINT_ENCODE3 (0x1F21, 0x0301, 0x1F25),   HB_CODEPOINT_ENCODE3 (0x1F21, 0x0342, 0x1F27),
     HB_CODEPOINT_ENCODE3 (0x1F21, 0x0345, 0x1F91),   HB_CODEPOINT_ENCODE3 (0x1F22, 0x0345, 0x1F92),
     HB_CODEPOINT_ENCODE3 (0x1F23, 0x0345, 0x1F93),   HB_CODEPOINT_ENCODE3 (0x1F24, 0x0345, 0x1F94),
     HB_CODEPOINT_ENCODE3 (0x1F25, 0x0345, 0x1F95),   HB_CODEPOINT_ENCODE3 (0x1F26, 0x0345, 0x1F96),
     HB_CODEPOINT_ENCODE3 (0x1F27, 0x0345, 0x1F97),   HB_CODEPOINT_ENCODE3 (0x1F28, 0x0300, 0x1F2A),
     HB_CODEPOINT_ENCODE3 (0x1F28, 0x0301, 0x1F2C),   HB_CODEPOINT_ENCODE3 (0x1F28, 0x0342, 0x1F2E),
     HB_CODEPOINT_ENCODE3 (0x1F28, 0x0345, 0x1F98),   HB_CODEPOINT_ENCODE3 (0x1F29, 0x0300, 0x1F2B),
     HB_CODEPOINT_ENCODE3 (0x1F29, 0x0301, 0x1F2D),   HB_CODEPOINT_ENCODE3 (0x1F29, 0x0342, 0x1F2F),
     HB_CODEPOINT_ENCODE3 (0x1F29, 0x0345, 0x1F99),   HB_CODEPOINT_ENCODE3 (0x1F2A, 0x0345, 0x1F9A),
     HB_CODEPOINT_ENCODE3 (0x1F2B, 0x0345, 0x1F9B),   HB_CODEPOINT_ENCODE3 (0x1F2C, 0x0345, 0x1F9C),
     HB_CODEPOINT_ENCODE3 (0x1F2D, 0x0345, 0x1F9D),   HB_CODEPOINT_ENCODE3 (0x1F2E, 0x0345, 0x1F9E),
     HB_CODEPOINT_ENCODE3 (0x1F2F, 0x0345, 0x1F9F),   HB_CODEPOINT_ENCODE3 (0x1F30, 0x0300, 0x1F32),
     HB_CODEPOINT_ENCODE3 (0x1F30, 0x0301, 0x1F34),   HB_CODEPOINT_ENCODE3 (0x1F30, 0x0342, 0x1F36),
     HB_CODEPOINT_ENCODE3 (0x1F31, 0x0300, 0x1F33),   HB_CODEPOINT_ENCODE3 (0x1F31, 0x0301, 0x1F35),
     HB_CODEPOINT_ENCODE3 (0x1F31, 0x0342, 0x1F37),   HB_CODEPOINT_ENCODE3 (0x1F38, 0x0300, 0x1F3A),
     HB_CODEPOINT_ENCODE3 (0x1F38, 0x0301, 0x1F3C),   HB_CODEPOINT_ENCODE3 (0x1F38, 0x0342, 0x1F3E),
     HB_CODEPOINT_ENCODE3 (0x1F39, 0x0300, 0x1F3B),   HB_CODEPOINT_ENCODE3 (0x1F39, 0x0301, 0x1F3D),
     HB_CODEPOINT_ENCODE3 (0x1F39, 0x0342, 0x1F3F),   HB_CODEPOINT_ENCODE3 (0x1F40, 0x0300, 0x1F42),
     HB_CODEPOINT_ENCODE3 (0x1F40, 0x0301, 0x1F44),   HB_CODEPOINT_ENCODE3 (0x1F41, 0x0300, 0x1F43),
     HB_CODEPOINT_ENCODE3 (0x1F41, 0x0301, 0x1F45),   HB_CODEPOINT_ENCODE3 (0x1F48, 0x0300, 0x1F4A),
     HB_CODEPOINT_ENCODE3 (0x1F48, 0x0301, 0x1F4C),   HB_CODEPOINT_ENCODE3 (0x1F49, 0x0300, 0x1F4B),
     HB_CODEPOINT_ENCODE3 (0x1F49, 0x0301, 0x1F4D),   HB_CODEPOINT_ENCODE3 (0x1F50, 0x0300, 0x1F52),
     HB_CODEPOINT_ENCODE3 (0x1F50, 0x0301, 0x1F54),   HB_CODEPOINT_ENCODE3 (0x1F50, 0x0342, 0x1F56),
     HB_CODEPOINT_ENCODE3 (0x1F51, 0x0300, 0x1F53),   HB_CODEPOINT_ENCODE3 (0x1F51, 0x0301, 0x1F55),
     HB_CODEPOINT_ENCODE3 (0x1F51, 0x0342, 0x1F57),   HB_CODEPOINT_ENCODE3 (0x1F59, 0x0300, 0x1F5B),
     HB_CODEPOINT_ENCODE3 (0x1F59, 0x0301, 0x1F5D),   HB_CODEPOINT_ENCODE3 (0x1F59, 0x0342, 0x1F5F),
     HB_CODEPOINT_ENCODE3 (0x1F60, 0x0300, 0x1F62),   HB_CODEPOINT_ENCODE3 (0x1F60, 0x0301, 0x1F64),
     HB_CODEPOINT_ENCODE3 (0x1F60, 0x0342, 0x1F66),   HB_CODEPOINT_ENCODE3 (0x1F60, 0x0345, 0x1FA0),
     HB_CODEPOINT_ENCODE3 (0x1F61, 0x0300, 0x1F63),   HB_CODEPOINT_ENCODE3 (0x1F61, 0x0301, 0x1F65),
     HB_CODEPOINT_ENCODE3 (0x1F61, 0x0342, 0x1F67),   HB_CODEPOINT_ENCODE3 (0x1F61, 0x0345, 0x1FA1),
     HB_CODEPOINT_ENCODE3 (0x1F62, 0x0345, 0x1FA2),   HB_CODEPOINT_ENCODE3 (0x1F63, 0x0345, 0x1FA3),
     HB_CODEPOINT_ENCODE3 (0x1F64, 0x0345, 0x1FA4),   HB_CODEPOINT_ENCODE3 (0x1F65, 0x0345, 0x1FA5),
     HB_CODEPOINT_ENCODE3 (0x1F66, 0x0345, 0x1FA6),   HB_CODEPOINT_ENCODE3 (0x1F67, 0x0345, 0x1FA7),
     HB_CODEPOINT_ENCODE3 (0x1F68, 0x0300, 0x1F6A),   HB_CODEPOINT_ENCODE3 (0x1F68, 0x0301, 0x1F6C),
     HB_CODEPOINT_ENCODE3 (0x1F68, 0x0342, 0x1F6E),   HB_CODEPOINT_ENCODE3 (0x1F68, 0x0345, 0x1FA8),
     HB_CODEPOINT_ENCODE3 (0x1F69, 0x0300, 0x1F6B),   HB_CODEPOINT_ENCODE3 (0x1F69, 0x0301, 0x1F6D),
     HB_CODEPOINT_ENCODE3 (0x1F69, 0x0342, 0x1F6F),   HB_CODEPOINT_ENCODE3 (0x1F69, 0x0345, 0x1FA9),
     HB_CODEPOINT_ENCODE3 (0x1F6A, 0x0345, 0x1FAA),   HB_CODEPOINT_ENCODE3 (0x1F6B, 0x0345, 0x1FAB),
     HB_CODEPOINT_ENCODE3 (0x1F6C, 0x0345, 0x1FAC),   HB_CODEPOINT_ENCODE3 (0x1F6D, 0x0345, 0x1FAD),
     HB_CODEPOINT_ENCODE3 (0x1F6E, 0x0345, 0x1FAE),   HB_CODEPOINT_ENCODE3 (0x1F6F, 0x0345, 0x1FAF),
     HB_CODEPOINT_ENCODE3 (0x1F70, 0x0345, 0x1FB2),   HB_CODEPOINT_ENCODE3 (0x1F74, 0x0345, 0x1FC2),
     HB_CODEPOINT_ENCODE3 (0x1F7C, 0x0345, 0x1FF2),   HB_CODEPOINT_ENCODE3 (0x1FB6, 0x0345, 0x1FB7),
     HB_CODEPOINT_ENCODE3 (0x1FBF, 0x0300, 0x1FCD),   HB_CODEPOINT_ENCODE3 (0x1FBF, 0x0301, 0x1FCE),
     HB_CODEPOINT_ENCODE3 (0x1FBF, 0x0342, 0x1FCF),   HB_CODEPOINT_ENCODE3 (0x1FC6, 0x0345, 0x1FC7),
     HB_CODEPOINT_ENCODE3 (0x1FF6, 0x0345, 0x1FF7),   HB_CODEPOINT_ENCODE3 (0x1FFE, 0x0300, 0x1FDD),
     HB_CODEPOINT_ENCODE3 (0x1FFE, 0x0301, 0x1FDE),   HB_CODEPOINT_ENCODE3 (0x1FFE, 0x0342, 0x1FDF),
     HB_CODEPOINT_ENCODE3 (0x2190, 0x0338, 0x219A),   HB_CODEPOINT_ENCODE3 (0x2192, 0x0338, 0x219B),
     HB_CODEPOINT_ENCODE3 (0x2194, 0x0338, 0x21AE),   HB_CODEPOINT_ENCODE3 (0x21D0, 0x0338, 0x21CD),
     HB_CODEPOINT_ENCODE3 (0x21D2, 0x0338, 0x21CF),   HB_CODEPOINT_ENCODE3 (0x21D4, 0x0338, 0x21CE),
     HB_CODEPOINT_ENCODE3 (0x2203, 0x0338, 0x2204),   HB_CODEPOINT_ENCODE3 (0x2208, 0x0338, 0x2209),
     HB_CODEPOINT_ENCODE3 (0x220B, 0x0338, 0x220C),   HB_CODEPOINT_ENCODE3 (0x2223, 0x0338, 0x2224),
     HB_CODEPOINT_ENCODE3 (0x2225, 0x0338, 0x2226),   HB_CODEPOINT_ENCODE3 (0x223C, 0x0338, 0x2241),
     HB_CODEPOINT_ENCODE3 (0x2243, 0x0338, 0x2244),   HB_CODEPOINT_ENCODE3 (0x2245, 0x0338, 0x2247),
     HB_CODEPOINT_ENCODE3 (0x2248, 0x0338, 0x2249),   HB_CODEPOINT_ENCODE3 (0x224D, 0x0338, 0x226D),
     HB_CODEPOINT_ENCODE3 (0x2261, 0x0338, 0x2262),   HB_CODEPOINT_ENCODE3 (0x2264, 0x0338, 0x2270),
     HB_CODEPOINT_ENCODE3 (0x2265, 0x0338, 0x2271),   HB_CODEPOINT_ENCODE3 (0x2272, 0x0338, 0x2274),
     HB_CODEPOINT_ENCODE3 (0x2273, 0x0338, 0x2275),   HB_CODEPOINT_ENCODE3 (0x2276, 0x0338, 0x2278),
     HB_CODEPOINT_ENCODE3 (0x2277, 0x0338, 0x2279),   HB_CODEPOINT_ENCODE3 (0x227A, 0x0338, 0x2280),
     HB_CODEPOINT_ENCODE3 (0x227B, 0x0338, 0x2281),   HB_CODEPOINT_ENCODE3 (0x227C, 0x0338, 0x22E0),
     HB_CODEPOINT_ENCODE3 (0x227D, 0x0338, 0x22E1),   HB_CODEPOINT_ENCODE3 (0x2282, 0x0338, 0x2284),
     HB_CODEPOINT_ENCODE3 (0x2283, 0x0338, 0x2285),   HB_CODEPOINT_ENCODE3 (0x2286, 0x0338, 0x2288),
     HB_CODEPOINT_ENCODE3 (0x2287, 0x0338, 0x2289),   HB_CODEPOINT_ENCODE3 (0x2291, 0x0338, 0x22E2),
     HB_CODEPOINT_ENCODE3 (0x2292, 0x0338, 0x22E3),   HB_CODEPOINT_ENCODE3 (0x22A2, 0x0338, 0x22AC),
     HB_CODEPOINT_ENCODE3 (0x22A8, 0x0338, 0x22AD),   HB_CODEPOINT_ENCODE3 (0x22A9, 0x0338, 0x22AE),
     HB_CODEPOINT_ENCODE3 (0x22AB, 0x0338, 0x22AF),   HB_CODEPOINT_ENCODE3 (0x22B2, 0x0338, 0x22EA),
     HB_CODEPOINT_ENCODE3 (0x22B3, 0x0338, 0x22EB),   HB_CODEPOINT_ENCODE3 (0x22B4, 0x0338, 0x22EC),
     HB_CODEPOINT_ENCODE3 (0x22B5, 0x0338, 0x22ED),   HB_CODEPOINT_ENCODE3 (0x2ADD, 0x0338, 0x0000),
     HB_CODEPOINT_ENCODE3 (0x3046, 0x3099, 0x3094),   HB_CODEPOINT_ENCODE3 (0x304B, 0x3099, 0x304C),
     HB_CODEPOINT_ENCODE3 (0x304D, 0x3099, 0x304E),   HB_CODEPOINT_ENCODE3 (0x304F, 0x3099, 0x3050),
     HB_CODEPOINT_ENCODE3 (0x3051, 0x3099, 0x3052),   HB_CODEPOINT_ENCODE3 (0x3053, 0x3099, 0x3054),
     HB_CODEPOINT_ENCODE3 (0x3055, 0x3099, 0x3056),   HB_CODEPOINT_ENCODE3 (0x3057, 0x3099, 0x3058),
     HB_CODEPOINT_ENCODE3 (0x3059, 0x3099, 0x305A),   HB_CODEPOINT_ENCODE3 (0x305B, 0x3099, 0x305C),
     HB_CODEPOINT_ENCODE3 (0x305D, 0x3099, 0x305E),   HB_CODEPOINT_ENCODE3 (0x305F, 0x3099, 0x3060),
     HB_CODEPOINT_ENCODE3 (0x3061, 0x3099, 0x3062),   HB_CODEPOINT_ENCODE3 (0x3064, 0x3099, 0x3065),
     HB_CODEPOINT_ENCODE3 (0x3066, 0x3099, 0x3067),   HB_CODEPOINT_ENCODE3 (0x3068, 0x3099, 0x3069),
     HB_CODEPOINT_ENCODE3 (0x306F, 0x3099, 0x3070),   HB_CODEPOINT_ENCODE3 (0x306F, 0x309A, 0x3071),
     HB_CODEPOINT_ENCODE3 (0x3072, 0x3099, 0x3073),   HB_CODEPOINT_ENCODE3 (0x3072, 0x309A, 0x3074),
     HB_CODEPOINT_ENCODE3 (0x3075, 0x3099, 0x3076),   HB_CODEPOINT_ENCODE3 (0x3075, 0x309A, 0x3077),
     HB_CODEPOINT_ENCODE3 (0x3078, 0x3099, 0x3079),   HB_CODEPOINT_ENCODE3 (0x3078, 0x309A, 0x307A),
     HB_CODEPOINT_ENCODE3 (0x307B, 0x3099, 0x307C),   HB_CODEPOINT_ENCODE3 (0x307B, 0x309A, 0x307D),
     HB_CODEPOINT_ENCODE3 (0x309D, 0x3099, 0x309E),   HB_CODEPOINT_ENCODE3 (0x30A6, 0x3099, 0x30F4),
     HB_CODEPOINT_ENCODE3 (0x30AB, 0x3099, 0x30AC),   HB_CODEPOINT_ENCODE3 (0x30AD, 0x3099, 0x30AE),
     HB_CODEPOINT_ENCODE3 (0x30AF, 0x3099, 0x30B0),   HB_CODEPOINT_ENCODE3 (0x30B1, 0x3099, 0x30B2),
     HB_CODEPOINT_ENCODE3 (0x30B3, 0x3099, 0x30B4),   HB_CODEPOINT_ENCODE3 (0x30B5, 0x3099, 0x30B6),
     HB_CODEPOINT_ENCODE3 (0x30B7, 0x3099, 0x30B8),   HB_CODEPOINT_ENCODE3 (0x30B9, 0x3099, 0x30BA),
     HB_CODEPOINT_ENCODE3 (0x30BB, 0x3099, 0x30BC),   HB_CODEPOINT_ENCODE3 (0x30BD, 0x3099, 0x30BE),
     HB_CODEPOINT_ENCODE3 (0x30BF, 0x3099, 0x30C0),   HB_CODEPOINT_ENCODE3 (0x30C1, 0x3099, 0x30C2),
     HB_CODEPOINT_ENCODE3 (0x30C4, 0x3099, 0x30C5),   HB_CODEPOINT_ENCODE3 (0x30C6, 0x3099, 0x30C7),
     HB_CODEPOINT_ENCODE3 (0x30C8, 0x3099, 0x30C9),   HB_CODEPOINT_ENCODE3 (0x30CF, 0x3099, 0x30D0),
     HB_CODEPOINT_ENCODE3 (0x30CF, 0x309A, 0x30D1),   HB_CODEPOINT_ENCODE3 (0x30D2, 0x3099, 0x30D3),
     HB_CODEPOINT_ENCODE3 (0x30D2, 0x309A, 0x30D4),   HB_CODEPOINT_ENCODE3 (0x30D5, 0x3099, 0x30D6),
     HB_CODEPOINT_ENCODE3 (0x30D5, 0x309A, 0x30D7),   HB_CODEPOINT_ENCODE3 (0x30D8, 0x3099, 0x30D9),
     HB_CODEPOINT_ENCODE3 (0x30D8, 0x309A, 0x30DA),   HB_CODEPOINT_ENCODE3 (0x30DB, 0x3099, 0x30DC),
     HB_CODEPOINT_ENCODE3 (0x30DB, 0x309A, 0x30DD),   HB_CODEPOINT_ENCODE3 (0x30EF, 0x3099, 0x30F7),
     HB_CODEPOINT_ENCODE3 (0x30F0, 0x3099, 0x30F8),   HB_CODEPOINT_ENCODE3 (0x30F1, 0x3099, 0x30F9),
     HB_CODEPOINT_ENCODE3 (0x30F2, 0x3099, 0x30FA),   HB_CODEPOINT_ENCODE3 (0x30FD, 0x3099, 0x30FE),
     HB_CODEPOINT_ENCODE3 (0xFB49, 0x05C1, 0x0000),   HB_CODEPOINT_ENCODE3 (0xFB49, 0x05C2, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x105D2, 0x0307, 0x105C9), HB_CODEPOINT_ENCODE3 (0x105DA, 0x0307, 0x105E4),
  HB_CODEPOINT_ENCODE3 (0x11099, 0x110BA, 0x1109A),HB_CODEPOINT_ENCODE3 (0x1109B, 0x110BA, 0x1109C),
  HB_CODEPOINT_ENCODE3 (0x110A5, 0x110BA, 0x110AB),HB_CODEPOINT_ENCODE3 (0x11131, 0x11127, 0x1112E),
  HB_CODEPOINT_ENCODE3 (0x11132, 0x11127, 0x1112F),HB_CODEPOINT_ENCODE3 (0x11347, 0x1133E, 0x1134B),
  HB_CODEPOINT_ENCODE3 (0x11347, 0x11357, 0x1134C),HB_CODEPOINT_ENCODE3 (0x11382, 0x113C9, 0x11383),
  HB_CODEPOINT_ENCODE3 (0x11384, 0x113BB, 0x11385),HB_CODEPOINT_ENCODE3 (0x1138B, 0x113C2, 0x1138E),
  HB_CODEPOINT_ENCODE3 (0x11390, 0x113C9, 0x11391),HB_CODEPOINT_ENCODE3 (0x113C2, 0x113B8, 0x113C7),
  HB_CODEPOINT_ENCODE3 (0x113C2, 0x113C2, 0x113C5),HB_CODEPOINT_ENCODE3 (0x113C2, 0x113C9, 0x113C8),
  HB_CODEPOINT_ENCODE3 (0x114B9, 0x114B0, 0x114BC),HB_CODEPOINT_ENCODE3 (0x114B9, 0x114BA, 0x114BB),
  HB_CODEPOINT_ENCODE3 (0x114B9, 0x114BD, 0x114BE),HB_CODEPOINT_ENCODE3 (0x115B8, 0x115AF, 0x115BA),
  HB_CODEPOINT_ENCODE3 (0x115B9, 0x115AF, 0x115BB),HB_CODEPOINT_ENCODE3 (0x11935, 0x11930, 0x11938),
  HB_CODEPOINT_ENCODE3 (0x1611E, 0x1611E, 0x16121),HB_CODEPOINT_ENCODE3 (0x1611E, 0x1611F, 0x16123),
  HB_CODEPOINT_ENCODE3 (0x1611E, 0x16120, 0x16125),HB_CODEPOINT_ENCODE3 (0x1611E, 0x16129, 0x16122),
  HB_CODEPOINT_ENCODE3 (0x16121, 0x1611F, 0x16126),HB_CODEPOINT_ENCODE3 (0x16121, 0x16120, 0x16128),
  HB_CODEPOINT_ENCODE3 (0x16122, 0x1611F, 0x16127),HB_CODEPOINT_ENCODE3 (0x16129, 0x1611F, 0x16124),
  HB_CODEPOINT_ENCODE3 (0x16D63, 0x16D67, 0x16D69),HB_CODEPOINT_ENCODE3 (0x16D67, 0x16D67, 0x16D68),
  HB_CODEPOINT_ENCODE3 (0x16D69, 0x16D67, 0x16D6A), HB_CODEPOINT_ENCODE3 (0x1D157, 0x1D165, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x1D158, 0x1D165, 0x0000), HB_CODEPOINT_ENCODE3 (0x1D15F, 0x1D16E, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x1D15F, 0x1D16F, 0x0000), HB_CODEPOINT_ENCODE3 (0x1D15F, 0x1D170, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x1D15F, 0x1D171, 0x0000), HB_CODEPOINT_ENCODE3 (0x1D15F, 0x1D172, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x1D1B9, 0x1D165, 0x0000), HB_CODEPOINT_ENCODE3 (0x1D1BA, 0x1D165, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x1D1BB, 0x1D16E, 0x0000), HB_CODEPOINT_ENCODE3 (0x1D1BB, 0x1D16F, 0x0000),
   HB_CODEPOINT_ENCODE3 (0x1D1BC, 0x1D16E, 0x0000), HB_CODEPOINT_ENCODE3 (0x1D1BC, 0x1D16F, 0x0000),
];

static _hb_ucd_u8: [u8; 19868]=
[
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
   16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 27, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   28, 26, 29, 30, 31, 32, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 33, 34, 34, 34, 34,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 36, 37, 38, 39,
   40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
   26, 56, 57, 58, 58, 58, 58, 59, 26, 26, 60, 26, 26, 26, 26, 26,
   26, 61, 26, 62, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   63, 58, 58, 58, 26, 64, 65, 66, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 67, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 68, 69, 70, 58, 58, 58, 58, 71, 58,
   58, 58, 58, 58, 58, 58, 72, 73, 74, 75, 76, 77, 78, 79, 58, 80,
   81, 82, 83, 84, 85, 58, 86, 87, 88, 89, 78, 90, 91, 92, 58, 58,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 93, 26, 26, 26, 26, 26, 26, 26, 26, 94, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 95, 26, 26, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 96, 26, 97, 58, 58, 58, 58, 26, 98, 58, 58,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 99, 26, 26, 26, 26, 26, 26,
   26, 26, 26, 26, 26, 26, 26, 26, 26, 26,100, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
  101, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,102,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,103,
    0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  2,  4,  5,  6,  2,
    7,  7,  7,  7,  7,  2,  8,  9, 10, 11, 11, 11, 11, 11, 11, 11,
   11, 11, 11, 11, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16,
   16, 16, 16, 16, 16, 17, 18, 19,  1, 20, 20, 21, 22, 23, 24, 25,
   26, 27, 15,  2, 28, 29, 27, 30, 11, 11, 11, 11, 11, 11, 11, 11,
   11, 11, 11, 31, 11, 11, 11, 32, 16, 16, 16, 16, 16, 16, 16, 16,
   16, 16, 16, 33, 16, 16, 16, 16, 32, 32, 32, 32, 32, 32, 32, 32,
   32, 32, 32, 32, 34, 34, 34, 34, 34, 34, 34, 34, 16, 32, 32, 32,
   32, 32, 32, 32, 11, 34, 34, 16, 34, 32, 32, 11, 34, 11, 16, 11,
   11, 34, 32, 11, 32, 16, 11, 34, 32, 32, 32, 11, 34, 16, 32, 11,
   34, 11, 34, 34, 32, 35, 32, 16, 36, 36, 37, 34, 38, 37, 34, 34,
   34, 34, 34, 34, 34, 34, 16, 32, 34, 38, 32, 11, 32, 32, 32, 32,
   32, 32, 16, 16, 16, 11, 34, 32, 34, 34, 11, 32, 32, 32, 32, 32,
   16, 16, 36, 16, 16, 16, 16, 16, 39, 39, 39, 39, 39, 39, 39, 39,
   39, 40, 40, 39, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40,
   39, 39, 41, 40, 40, 40, 41, 41, 40, 40, 40, 40, 40, 40, 40, 40,
   42, 42, 42, 42, 42, 42, 42, 42, 32, 32, 41, 32, 43, 44, 16, 10,
   43, 43, 40, 45, 11, 46, 46, 11, 34, 11, 11, 11, 11, 11, 11, 11,
   11, 47, 11, 11, 11, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 34,
   16, 11, 32, 16, 32, 32, 32, 32, 16, 16, 32, 48, 34, 32, 34, 11,
   32, 49, 42, 42, 50, 32, 32, 32, 11, 34, 34, 34, 34, 34, 34, 16,
   47, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 46, 51,  2,  2,  2,
   16, 16, 16, 16, 52, 53, 54, 55, 56, 42, 42, 42, 42, 42, 42, 42,
   42, 42, 42, 42, 42, 42, 42, 57, 58, 59, 42, 58, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 60, 43, 61,
   36, 62, 63, 43, 43, 43, 43, 43, 64, 64, 64,  8,  9, 65,  2, 66,
   42, 42, 42, 42, 42, 59, 67,  2, 68, 36, 36, 36, 36, 69, 42, 42,
    7,  7,  7,  7,  7,  2,  2, 36, 70, 36, 36, 36, 36, 36, 36, 36,
   36, 36, 71, 42, 42, 42, 72, 49, 42, 42, 73, 74, 75, 42, 42, 36,
    7,  7,  7,  7,  7, 36, 76, 77,  2,  2,  2,  2,  2,  2,  2, 78,
   69, 36, 36, 36, 36, 36, 36, 36, 42, 42, 42, 42, 42, 79, 61, 36,
   36, 36, 36, 42, 42, 42, 42, 42, 70, 43, 43, 43, 43, 43, 43, 43,
    7,  7,  7,  7,  7, 36, 36, 36, 36, 36, 36, 36, 36, 69, 42, 42,
   42, 42, 39, 21,  2, 80, 56, 20, 36, 36, 36, 42, 42, 74, 42, 42,
   42, 42, 74, 42, 74, 42, 42, 43,  2,  2,  2,  2,  2,  2,  2, 63,
   36, 36, 36, 36, 69, 42, 43, 63, 36, 36, 36, 36, 36, 60, 43, 43,
   36, 36, 36, 36, 81, 36, 36, 36, 64, 43, 43, 56, 42, 42, 42, 42,
   36, 36, 36, 36, 82, 42, 42, 42, 42, 83, 42, 42, 42, 42, 42, 42,
   42, 84, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 84, 70, 85,
   86, 42, 42, 42, 84, 85, 86, 85, 69, 42, 42, 42, 36, 36, 36, 36,
   36, 42,  2,  7,  7,  7,  7,  7, 87, 36, 36, 36, 36, 36, 36, 36,
   69, 85, 61, 36, 36, 36, 60, 61, 60, 61, 36, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 60, 36, 36, 36, 60, 60, 43, 36, 36, 43, 70, 85,
   86, 42, 79, 88, 89, 88, 86, 60, 43, 43, 43, 88, 43, 43, 36, 61,
   36, 42, 43,  7,  7,  7,  7,  7, 36, 20, 27, 27, 27, 55, 62, 79,
   56, 84, 61, 36, 36, 60, 43, 61, 60, 36, 61, 60, 36, 43, 79, 85,
   86, 79, 43, 56, 79, 56, 42, 43, 56, 43, 43, 43, 61, 36, 60, 60,
   43, 43, 43,  7,  7,  7,  7,  7, 42, 36, 69, 63, 43, 43, 43, 43,
   56, 84, 61, 36, 36, 36, 36, 61, 36, 61, 36, 36, 36, 36, 36, 36,
   60, 36, 61, 36, 36, 43, 70, 85, 86, 42, 42, 56, 84, 88, 86, 43,
   60, 43, 43, 43, 43, 43, 43, 43, 65, 43, 43, 43, 61, 42, 42, 42,
   56, 85, 61, 36, 36, 36, 60, 61, 60, 36, 61, 36, 36, 43, 70, 86,
   86, 42, 79, 88, 89, 88, 86, 43, 43, 43, 56, 84, 43, 43, 36, 61,
   77, 27, 27, 27, 43, 43, 43, 43, 43, 70, 61, 36, 36, 60, 43, 36,
   60, 36, 36, 43, 61, 60, 60, 36, 43, 61, 60, 43, 36, 60, 43, 36,
   36, 36, 36, 36, 36, 43, 43, 85, 84, 89, 43, 85, 89, 85, 86, 43,
   60, 43, 43, 88, 43, 43, 43, 43, 27, 90, 66, 66, 55, 91, 43, 43,
   84, 85, 70, 36, 36, 36, 60, 36, 60, 36, 36, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 36, 43, 70, 42, 84, 85, 89, 42, 79, 42, 42, 43,
   43, 43, 56, 79, 36, 60, 36, 43, 43, 43, 43, 92, 27, 27, 27, 90,
   69, 85, 71, 36, 36, 36, 60, 36, 36, 36, 61, 36, 36, 43, 70, 86,
   85, 85, 89, 84, 89, 85, 42, 43, 43, 43, 88, 89, 43, 43, 36, 60,
   61, 93, 43, 43, 43, 43, 43, 43, 42, 85, 36, 36, 36, 36, 60, 36,
   36, 36, 36, 36, 36, 69, 70, 85, 86, 42, 79, 85, 89, 85, 86, 76,
   43, 43, 36, 93, 27, 27, 27, 94, 27, 27, 27, 27, 90, 36, 36, 36,
   56, 85, 61, 36, 36, 36, 36, 36, 36, 36, 36, 60, 43, 36, 36, 36,
   36, 61, 36, 36, 36, 36, 61, 43, 36, 36, 36, 60, 43, 79, 43, 88,
   85, 42, 79, 79, 85, 85, 85, 85, 43, 85, 63, 43, 43, 43, 43, 43,
   61, 36, 36, 36, 36, 36, 36, 36, 69, 36, 42, 42, 42, 79, 43, 95,
   36, 36, 36, 74, 42, 42, 42, 59,  7,  7,  7,  7,  7,  2, 43, 43,
   43, 43, 43, 43, 43, 43, 43, 43, 61, 60, 60, 36, 36, 60, 36, 36,
   36, 36, 61, 61, 36, 36, 36, 36, 69, 36, 42, 42, 42, 42, 70, 43,
   36, 36, 60, 80, 42, 42, 42, 79,  7,  7,  7,  7,  7, 43, 36, 36,
   76, 66,  2,  2,  2,  2,  2,  2,  2, 96, 96, 66, 42, 66, 66, 66,
    7,  7,  7,  7,  7, 27, 27, 27, 27, 27, 49, 49, 49,  4,  4, 85,
   36, 36, 36, 36, 61, 36, 36, 36, 36, 36, 36, 36, 36, 36, 60, 43,
   56, 42, 42, 42, 42, 42, 42, 84, 42, 42, 59, 42, 36, 36, 69, 42,
   42, 42, 42, 42, 56, 42, 42, 42, 42, 42, 42, 42, 42, 42, 79, 66,
   66, 66, 66, 75, 66, 66, 91, 66,  2,  2, 96, 66, 21, 63, 43, 43,
   36, 36, 36, 36, 36, 93, 86, 42, 84, 42, 42, 42, 86, 84, 86, 70,
    7,  7,  7,  7,  7,  2,  2,  2, 36, 36, 36, 85, 42, 36, 36, 42,
   70, 85, 97, 93, 85, 85, 85, 36, 69, 42, 70, 36, 36, 36, 36, 36,
   36, 84, 86, 84, 85, 85, 86, 93,  7,  7,  7,  7,  7, 85, 86, 66,
   11, 11, 11, 47, 43, 43, 47, 43, 16, 16, 16, 16, 16, 52, 44, 16,
   36, 36, 36, 36, 60, 36, 36, 43, 36, 36, 36, 60, 60, 36, 36, 43,
   60, 36, 36, 43, 36, 36, 36, 60, 60, 36, 36, 43, 36, 36, 36, 36,
   36, 36, 36, 60, 36, 36, 36, 36, 36, 36, 36, 36, 36, 60, 56, 42,
    2,  2,  2,  2, 98, 27, 27, 27, 27, 27, 27, 27, 27, 27, 99, 43,
   66, 66, 66, 66, 66, 43, 43, 43, 11, 11, 11, 43, 16, 16, 16, 43,
  100, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 76, 71,
  101, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,102,103, 43,
   36, 36, 36, 36, 36, 62,  2,104,105, 36, 36, 36, 60, 43, 43, 43,
   36, 42, 84, 43, 43, 43, 43, 61, 36, 42,106, 63, 43, 43, 43, 43,
   36, 42, 43, 43, 43, 43, 43, 43, 36, 36, 36, 36, 36, 36, 60, 36,
   60, 42, 43, 43, 43, 43, 43, 43, 36, 36, 42, 86, 42, 42, 42, 85,
   85, 85, 85, 84, 86, 42, 42, 42, 42, 42,  2, 87,  2, 65, 69, 43,
    7,  7,  7,  7,  7, 43, 43, 43, 27, 27, 27, 27, 27, 43, 43, 43,
    2,  2,  2,107,  2, 58, 42, 83, 36, 82, 36, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 60, 43, 43, 43, 36, 36, 69, 70, 36, 36, 36, 36,
   36, 36, 36, 36, 69, 60, 43, 43, 36, 36, 36, 43, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 36, 60, 42, 84, 85, 86, 84, 85, 43, 43,
   85, 84, 85, 85, 86, 42, 43, 43, 91, 43,  2,  7,  7,  7,  7,  7,
   36, 36, 36, 36, 36, 36, 36, 43, 36, 36, 60, 43, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 43, 43, 36, 36, 36, 36, 36, 43, 43, 43,
    7,  7,  7,  7,  7, 99, 43, 66, 66, 66, 66, 66, 66, 66, 66, 66,
   36, 36, 36, 69, 84, 86, 43,  2, 36, 36, 93, 84, 42, 42, 42, 79,
   84, 84, 86, 42, 42, 42, 84, 85, 85, 86, 42, 42, 42, 42, 79, 56,
    2,  2,  2, 87,  2,  2,  2, 43, 42, 42, 42, 42, 42, 42, 42,108,
   42, 42, 42, 42, 42, 42, 42, 43, 42, 42, 42, 42, 42, 42, 43, 43,
   42, 42, 97, 36, 36, 36, 36, 36, 36, 36, 84, 42, 42, 84, 84, 85,
   85, 84, 97, 36, 36, 36, 60,  2, 96, 66, 66, 66, 66, 49, 42, 42,
   42, 42, 66, 66, 66, 66, 21,  2, 42, 97, 36, 36, 36, 36, 36, 36,
   93, 42, 42, 85, 42, 86, 42, 36, 36, 36, 36, 84, 42, 85, 86, 86,
   42, 85, 43, 43, 43, 43,  2,  2, 36, 36, 85, 85, 85, 85, 42, 42,
   42, 42, 85, 42, 43, 92,  2,  2,  7,  7,  7,  7,  7, 43, 61, 36,
   36, 36, 36, 36, 39, 39, 39,  2, 16, 16, 16, 16, 34,109, 43, 43,
   11, 11, 11, 11, 11, 46, 47, 11,  2,  2,  2,  2, 43, 43, 43, 43,
   42, 59, 42, 42, 42, 42, 42, 42, 84, 42, 42, 42, 70, 36, 69, 36,
   36, 36, 70, 93, 42, 60, 43, 43, 16, 16, 16, 16, 16, 16, 39, 39,
   39, 39, 39, 39, 39, 44, 16, 16, 16, 16, 16, 16, 44, 16, 16, 16,
   16, 16, 16, 16, 16,110, 39, 39, 32, 32, 32, 16, 16, 16, 16, 32,
   16, 16, 16, 16, 11, 11, 11, 11, 16, 16, 16, 43, 11, 11, 11, 43,
   16, 16, 16, 16, 47, 47, 47, 47, 16, 16, 16, 16, 16, 16, 16, 43,
   16, 16, 16, 16,111,111,111,111, 16, 16,109, 16, 11, 11,112,113,
   40, 16,109, 16, 11, 11,112, 40, 16, 16, 43, 16, 11, 11,114, 40,
   16, 16, 16, 16, 11, 11,115, 40, 43, 16,109, 16, 11, 11,112,116,
  117,117,117,117,117,118, 64, 64,119,119,119,  2,120,121,120,121,
    2,  2,  2,  2,122, 64, 64,123,  2,  2,  2,  2,124,125,  2,126,
  127,  2,128,129,  2,  2,  2,  2,  2,  9,127,  2,  2,  2,  2,130,
   64, 64,131, 64, 64, 64, 64, 64,132, 43, 27, 27, 27,  8,128,133,
   27, 27, 27, 27, 27,  8,128,103, 39, 39, 39, 39, 39, 39, 80, 43,
   20, 20, 20, 20, 20, 20, 20, 20, 20, 43, 43, 43, 43, 43, 43, 43,
   42, 42, 42, 42, 42, 42,134, 50,108, 50,108, 42, 42, 42, 42, 42,
   79, 43, 43, 43, 43, 43, 43, 43, 66,135, 66,136, 66, 34, 11, 16,
   11, 32,136, 66, 48, 11, 11, 66, 66, 66,135,135,135, 11, 11,137,
   11, 11, 35, 36,138, 66, 16, 11,  8,  8, 48, 16, 16, 26, 66,139,
   27, 27, 27, 27, 27, 27, 27, 27,104,104,104,104,104,104,104,104,
  104,140,141,104,142, 66, 43, 43,  8,  8,143, 66, 66,  8, 66, 66,
  143, 26, 66,143, 66, 66, 66,143, 66, 66, 66, 66, 66, 66, 66,  8,
   66,143,143, 66, 66, 66, 66, 66, 66, 66,  8,  8,  8,  8,  8,  8,
    8,  8,  8,  8,  8,  8,  8,  8, 66, 66, 66, 66,  4,  4, 66, 66,
    8, 66, 66, 66,144,145, 66, 66, 66, 66, 66, 66, 66, 66,143, 66,
   66, 66, 66, 66, 66, 26,  8,  8,  8,  8, 66, 66, 66, 66, 66, 66,
   66, 66, 66, 66, 66, 66,  8,  8,  8, 66, 66, 66, 66, 66, 66, 66,
   66, 66, 66, 66, 66, 91, 43, 43, 27, 27, 27, 27, 27, 27, 66, 66,
   66, 66, 66, 66, 66, 27, 27, 27, 66, 66, 66, 26, 66, 66, 66, 66,
   26, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,  8,  8,  8,  8,
   66, 66, 66, 66, 66, 66, 66, 26, 66, 66, 66, 66,  4,  4,  4,  4,
    4,  4,  4, 27, 27, 27, 27, 27, 27, 27, 66, 66, 66, 66, 66, 66,
    8,  8,128,146,  8,  8,  8,  8,  8,  8,  8,  4,  4,  4,  4,  4,
    8,128,147,147,147,147,147,147,147,147,147,147,146,  8,  8,  8,
    8,  8,  8,  8,  4,  4,  8,  8,  8,  8,  8,  8,  8,  8,  4,  8,
    8,  8,143, 26,  8,  8,143, 66, 66, 66, 43, 66, 66, 66, 66, 66,
   32, 11, 32, 34, 34, 34, 34, 11, 32, 32, 34, 16, 16, 16, 39, 11,
   32, 32,139, 66, 66,136, 34,148, 42, 32, 43, 43, 92,  2, 98,  2,
   16, 16, 16,149, 43, 43,149, 43, 36, 36, 36, 36, 43, 43, 43, 51,
   63, 43, 43, 43, 43, 43, 43, 56, 36, 36, 36, 60, 43, 43, 43, 43,
   36, 36, 36, 60, 36, 36, 36, 60,  2,120,120,  2,124,125,120,  2,
    2,  2,  2,  6,  2,107,120,  2,120,  4,  4,  4,  4,  2,  2, 87,
    2,  2,  2,  2,  2,119,  2,  2,107,150,  2,  2,  2,  2,  2,  2,
   66,  2,151,147,147,147,152, 43, 66, 66, 66, 66, 66, 54, 66, 66,
   66, 66, 43, 43, 43, 43, 43, 43, 66, 66, 66, 43, 43, 43, 43, 43,
    1,  2,153,154,  4,  4,  4,  4,  4, 66,  4,  4,  4,  4,155,156,
  157,104,104,104,104, 42, 42, 85,158, 39, 39, 66,104,159, 62, 66,
   36, 36, 36, 60, 56,160,161, 68, 36, 36, 36, 36, 36, 62, 39, 68,
   43, 43, 61, 36, 36, 36, 36, 36, 66, 27, 27, 66, 66, 66, 66, 66,
   66, 66, 66, 43, 43, 43, 43, 54, 66, 66, 66, 66, 66, 66, 66, 91,
   27, 27, 27, 27, 27, 66, 66, 66, 66, 66, 66, 66, 27, 27, 27, 27,
  162, 27, 27, 27, 27, 27, 27, 27, 36, 36, 82, 36, 36, 36, 36, 36,
   66, 66, 66, 91, 43, 43, 43, 43, 36, 36, 36, 36, 36, 36,163,  2,
    7,  7,  7,  7,  7, 36, 43, 43, 32, 32, 32, 32, 32, 32, 32, 69,
   50,164, 42, 42, 42, 42, 42, 87, 32, 32, 32, 32, 32, 32, 39, 42,
   36, 36, 36,104,104,104,104,104, 42,  2,  2,  2, 43, 43, 43, 43,
   40, 40, 40,161, 39, 39, 39, 39, 40, 32, 32, 32, 32, 32, 32, 32,
   16, 32, 32, 32, 32, 32, 32, 32, 44, 16, 16, 16, 34, 34, 34, 32,
   32, 32, 32, 32, 41,165, 34, 35, 32, 32, 16, 32, 32, 32, 32, 32,
   32, 32, 32, 32, 32, 11, 11, 32, 11, 11, 32, 32, 32, 32, 32, 32,
   32, 32, 11, 11, 34, 34, 32, 32, 32, 32, 32, 32, 32, 32, 46, 43,
   51, 39,166, 35, 39, 35, 36, 36, 36, 70, 36, 70, 36, 69, 36, 36,
   36, 93, 86, 84, 66, 66, 79, 43, 27, 27, 27, 66,167, 43, 43, 43,
   36, 36,  2,  2, 43, 43, 43, 43, 85, 36, 36, 36, 36, 36, 36, 36,
   36, 36, 85, 85, 85, 85, 85, 85, 85, 85, 42, 43, 43, 43, 43,  2,
   42, 36, 36, 36,  2, 71, 71, 69, 36, 36, 36, 42, 42, 42, 42,  2,
   36, 36, 36, 69, 42, 42, 42, 42, 42, 85, 43, 43, 43, 43, 43, 92,
   36, 69, 85, 42, 42, 85, 42, 85,106,  2,  2,  2,  2,  2,  2, 51,
    7,  7,  7,  7,  7, 43, 43,  2, 36, 36, 69, 68, 36, 36, 36, 36,
    7,  7,  7,  7,  7, 36, 36, 60, 36, 36, 36, 36, 69, 42, 42, 84,
   86, 84, 86, 79, 43, 43, 43, 43, 36, 69, 36, 36, 36, 36, 84, 43,
    7,  7,  7,  7,  7, 43,  2,  2, 68, 36, 36, 76, 66, 93, 84, 36,
   70, 42, 70, 69, 70, 36, 36, 42, 69, 60, 43, 43, 43, 43, 43, 43,
   43, 43, 43, 43, 43, 61, 82,  2, 36, 36, 36, 36, 36, 93, 42, 85,
    2, 82,168, 79, 43, 43, 43, 43, 61, 36, 36, 60, 61, 36, 36, 60,
   61, 36, 36, 60, 43, 43, 43, 43, 16, 16, 16, 16, 16,113, 39, 39,
   16, 16, 16, 16,110, 40, 43, 43, 36, 93, 86, 85, 84,106, 86, 43,
   36, 36, 43, 43, 43, 43, 43, 43, 36, 36, 36, 60, 43, 61, 36, 36,
  169,169,169,169,169,169,169,169,170,170,170,170,170,170,170,170,
   16, 16, 16,109, 43, 43, 43, 43, 43,149, 16, 16, 43, 43, 61, 70,
   36, 36, 36, 36,171, 36, 36, 36, 36, 36, 36, 60, 36, 36, 60, 60,
   36, 61, 60, 36, 36, 36, 36, 36, 36, 40, 40, 40, 40, 40, 40, 40,
   40, 22, 66, 66, 66, 66, 66, 66, 66, 77, 36, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 36, 36, 36,147, 66, 36, 36, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 66, 66, 66, 66, 36, 36, 36, 36, 36, 36,167, 66,
    2,  2,  2,151,129, 43, 43, 43,  6,172,173,147,147,147,147,147,
  147,147,129,151,129,  2,126,174,  2, 63,  2,  2,155,147,147,129,
    2,175,  8,176, 65,  2, 43, 43, 36, 36, 60, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 36, 36, 60, 78, 92,  2,  3,  2,  4,  5,  6,  2,
   16, 16, 16, 16, 16, 17, 18,128,129,  4,  2, 36, 36, 36, 36, 36,
   68, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 39,
   43, 36, 36, 36, 43, 36, 36, 36, 43, 36, 36, 36, 43, 36, 60, 43,
   20,177, 55,178, 26,  8,143, 91, 43, 43, 43, 43, 78, 64, 66, 43,
   36, 36, 36, 36, 36, 36, 61, 36, 36, 36, 36, 36, 36, 60, 36, 61,
    2, 63, 43,179, 27, 27, 27, 27, 27, 27, 43, 54, 66, 66, 66, 66,
  104,104,142, 27, 90, 66, 66, 66, 66, 66, 66, 66, 66, 27, 66, 91,
   66, 66, 66, 66, 66, 66, 91, 43, 91, 43, 43, 43, 43, 43, 43, 43,
   66, 66, 66, 66, 66, 66, 49, 43,180, 27, 27, 27, 27, 27, 27, 27,
   27, 27, 27, 27, 27, 27, 43, 43, 27, 27, 43, 43, 43, 43, 61, 36,
  154, 36, 36, 36, 36,181, 43, 43, 36, 36, 36, 42, 42, 79, 43, 43,
   36, 36, 36, 36, 36, 36, 36, 92, 36, 36, 43, 43, 36, 36, 36, 36,
  182,104,104, 43, 43, 43, 43, 43, 11, 11, 11, 11, 16, 16, 16, 16,
   11, 11, 43, 43, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 43, 43,
   36, 36, 36, 36, 43, 43, 43, 43, 36, 36, 43, 43, 43, 43, 43, 92,
   11, 11, 11, 11, 11, 46, 11, 11, 11, 46, 11,149, 16, 16, 16, 16,
   16,149, 16, 16, 16, 16, 16, 16, 16,149, 16, 16, 16,149,109, 43,
   39, 39, 39, 51, 39, 39, 39, 39, 80, 39, 39, 39, 39, 80, 43, 43,
   36, 36, 36, 43, 60, 36, 36, 36, 36, 36, 36, 61, 60, 43, 60, 61,
   36, 36, 36, 92, 27, 27, 27, 27, 36, 36, 36, 76,162, 27, 27, 27,
   43, 43, 43,179, 27, 27, 27, 27, 36, 60, 36, 43, 43,179, 27, 27,
   36, 36, 36, 27, 27, 27, 43, 92, 36, 36, 36, 36, 36, 43, 43, 92,
   36, 36, 36, 36, 43, 43, 27, 36, 43, 27, 27, 27, 27, 27, 27, 27,
   69, 42, 56, 79, 43, 43, 42, 42, 36, 36, 61, 36, 61, 36, 36, 36,
   36, 36, 36, 43, 42, 79, 43, 56, 27, 27, 27, 27, 99, 43, 43, 43,
    2,  2,  2,  2, 63, 43, 43, 43, 36, 36, 36, 36, 36, 36,183, 30,
   36, 36, 36, 36, 36, 36,183, 27, 36, 36, 36, 36, 77, 36, 36, 36,
   36, 36, 69, 79, 43,179, 27, 27,  2,  2,  2, 63, 43, 43, 43, 43,
   36, 36, 36, 43, 92,  2,  2,  2, 36, 36, 36, 43, 27, 27, 27, 27,
   36, 60, 43, 43, 27, 27, 27, 27, 36, 43, 43, 43, 92,  2, 63, 43,
   43, 43, 43, 43,179, 27, 27, 27, 11, 46, 43, 43, 43, 43, 43, 43,
   16,109, 43, 43, 43, 27, 27, 27, 36, 36, 42, 42, 43, 43, 43, 43,
    7,  7,  7,  7,  7, 36, 36, 68, 11, 11, 11, 43, 56, 42, 42,158,
   16, 16, 16, 43, 43, 43, 43,  8, 27, 27, 27, 27, 27, 27, 27, 99,
   36, 36, 36, 36, 36, 56,184, 43, 36, 43, 43, 43, 43, 43, 43, 43,
   43, 36, 82, 36, 43, 43, 43, 43, 96, 66, 66, 66, 91, 43, 43, 43,
   43, 43, 43, 43, 43, 42, 42, 42, 27, 27, 27, 94, 43, 43, 43, 43,
  180, 27, 30,  2,  2, 43, 43, 43, 36, 42, 42,  2,  2, 43, 43, 43,
   36, 36,183, 27, 27, 27, 43, 43, 86, 97, 36, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 42, 42, 42, 42, 42, 42, 42, 59,  2,  2,  2, 43,
   27, 27, 27,  7,  7,  7,  7,  7, 70, 69, 70, 43, 43, 43, 43, 56,
   85, 86, 42, 84, 86, 59,185,  2,  2, 79, 43, 43, 43, 43, 78, 43,
   42, 70, 36, 36, 36, 36, 36, 36, 36, 36, 36, 69, 42, 42, 86, 42,
   42, 42, 79,  7,  7,  7,  7,  7,  2,  2, 93, 97, 43, 43, 43, 43,
   36, 69,  2, 60, 43, 43, 43, 43, 36, 93, 85, 42, 42, 42, 42, 84,
   97, 36, 62,  2, 58, 42, 59, 86,  7,  7,  7,  7,  7, 62, 62,  2,
  179, 27, 27, 27, 27, 27, 27, 27, 27, 27, 99, 43, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 85, 86, 42, 85, 84, 42,  2,  2,  2, 70,
   69, 43, 43, 43, 43, 43, 43, 43, 36, 36, 36, 60, 60, 36, 36, 61,
   36, 36, 36, 36, 36, 36, 36, 61, 36, 36, 36, 36, 62, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 36, 69, 85, 86, 42, 42, 42, 79, 43, 43,
   42, 85, 61, 36, 36, 36, 60, 61, 60, 36, 61, 36, 36, 56, 70, 85,
   84, 85, 89, 88, 89, 88, 85, 43, 60, 43, 43, 88, 43, 43, 61, 36,
   36, 85, 43, 42, 42, 42, 79, 43, 42, 42, 79, 43, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 61, 43, 60, 36, 36, 36, 61, 85, 86, 42, 42,
   79, 89, 88, 88, 85, 89, 85, 84, 70, 70,  2, 92, 63, 43, 43, 43,
   56, 79, 43, 43, 43, 43, 43, 43, 36, 36, 93, 85, 42, 42, 42, 42,
   85, 42, 84, 70, 36, 62,  2,  2,  7,  7,  7,  7,  7,  2, 92, 70,
   85, 86, 42, 42, 84, 84, 85, 86, 84, 42, 36, 71, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 36, 93, 85, 42, 42, 43, 85, 85, 42, 86,
   59,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 36, 36, 42, 43,
   85, 86, 42, 42, 42, 84, 86, 86, 59,  2, 60, 43, 43, 43, 43, 43,
    2,  2,  2,  2,  2,  2, 63, 43, 36, 36, 36, 36, 36, 69, 86, 85,
   42, 42, 42, 86, 62, 43, 43, 43,  7,  7,  7,  7,  7,  7,  7,  7,
    7,  7, 43, 43, 43, 43, 43, 43, 36, 36, 36, 36, 36, 60, 56, 86,
   85, 42, 42, 86, 42, 42, 43, 43,  7,  7,  7,  7,  7, 27,  2, 96,
   42, 42, 42, 42, 86, 59, 43, 43, 27, 99, 43, 43, 43, 43, 43, 61,
   36, 36, 36, 60, 61, 43, 36, 36, 36, 36, 61, 60, 36, 36, 36, 36,
   85, 85, 85, 88, 89, 56, 84, 70, 97, 86,  2, 63, 43, 43, 43, 43,
   36, 36, 36, 36, 43, 36, 36, 36, 93, 85, 42, 42, 43, 42, 85, 85,
   70, 71, 89, 43, 43, 43, 43, 43, 69, 42, 42, 42, 42, 70, 36, 36,
   36, 69, 42, 42, 84, 69, 42, 59,  2,  2,  2, 58, 43, 43, 43, 43,
   69, 42, 42, 84, 86, 42, 36, 36, 36, 36, 36, 36, 36, 42, 42, 42,
   42, 42, 42, 84, 42,  2, 71,  2,  2, 63, 43, 43, 43, 43, 43, 43,
    2,  2,  2,  2,  2, 43, 43, 43, 84, 42, 84, 84, 43, 43, 43, 43,
   62, 43, 43, 43, 43, 43, 43, 43, 42, 42, 42, 79, 42, 42, 42, 86,
   62,  2,  2, 43, 43, 43, 43, 43,  2, 36, 36, 36, 36, 36, 36, 36,
   43, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 88, 42, 42, 42,
   84, 42, 86, 79, 43, 43, 43, 43, 36, 36, 36, 60, 36, 61, 36, 36,
   69, 42, 42, 79, 43, 79, 42, 56, 42, 42, 42, 69, 43, 43, 43, 43,
   36, 36, 36, 61, 60, 36, 36, 36, 36, 36, 36, 36, 36, 85, 85, 89,
   42, 88, 86, 86, 60, 43, 43, 43, 36, 36, 36, 36, 82, 36, 43, 43,
   36, 69, 84,106, 63, 43, 43, 43, 42, 93, 36, 36, 36, 36, 36, 36,
   36, 36, 85, 42, 42, 79, 43, 85, 84, 59,  2,  2,  2,  2,  2,  2,
    7,  7,  7,  7,  7, 79, 43, 43, 27, 27, 90, 66, 66, 66, 55, 20,
  167, 66, 66, 66, 66, 66, 66, 66, 66, 43, 43, 43, 43, 43, 43, 92,
  104,104,104,104,104,104,104,181,  2,  2, 63, 43, 43, 43, 43, 43,
   62, 63, 43, 43, 43, 43, 43, 43, 64, 64, 64, 64, 64, 64, 64, 64,
   70, 36, 36, 69, 42, 42, 42, 42, 42, 42, 42, 43, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 36, 36, 42, 42, 42, 42, 42, 42, 85, 86, 42,
   42, 42, 59, 43, 43, 43, 43, 43, 42, 42, 42, 59,  2,  2, 66, 66,
   39, 39, 96, 43, 43, 43, 43, 43,  7,  7,  7,  7,  7,179, 27, 27,
   27, 61, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 43, 43, 61, 36,
   39, 68, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 82,163,  2,
   27, 27, 27, 30,  2, 63, 43, 43, 11, 11, 11, 11, 46,149, 16, 16,
   16, 16, 43, 43, 43, 43, 43, 43, 36, 36, 36, 36, 36, 60, 43, 56,
   93, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
   85, 85, 85, 85, 43, 43, 43, 56, 42, 73, 39, 39, 39, 39, 39, 39,
   39, 87, 79, 43, 43, 43, 43, 43, 85, 39,104,181, 43, 43, 43, 43,
   43, 43, 43, 43, 43, 43, 43, 61, 36, 60, 43, 43, 43, 43, 43, 43,
   39, 39, 51, 39, 39, 39, 51, 80, 43, 60, 43, 43, 43, 43, 43, 43,
   36, 60, 61, 43, 43, 43, 43, 43, 43, 43, 36, 36, 43, 43, 43, 43,
   36, 36, 36, 36, 36, 43, 49, 59, 64, 64, 43, 43, 43, 43, 43, 43,
    7,  7,  7,  7,  7, 66, 91, 43, 66, 66, 43, 43, 43, 66, 66, 66,
  176, 43, 43, 43, 43, 43, 43, 43, 42, 42, 42, 79, 43, 43, 43, 43,
   66, 66, 66, 91, 54, 66, 66, 66, 66, 66,186, 86, 42, 66,186, 85,
   85,187, 64, 64, 64, 83, 42, 42, 42, 75, 49, 42, 42, 42, 66, 66,
   66, 66, 66, 66, 66, 42, 42, 66, 66, 42, 75, 43, 43, 43, 43, 43,
   27, 27, 43, 43, 43, 43, 43, 43, 11, 11, 11, 11, 11, 16, 16, 16,
   16, 16, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 16,
   16, 16,109, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
   16, 16, 16, 16, 16, 16, 46, 11, 43, 46, 47, 46, 47, 11, 46, 11,
   11, 11, 11, 16, 16,149,149, 16, 16, 16,149, 16, 16, 16, 16, 16,
   16, 16, 11, 47, 11, 46, 47, 11, 11, 11, 46, 11, 11, 11, 46, 16,
   16, 16, 16, 16, 11, 47, 11, 46, 11, 11, 46, 46, 43, 11, 11, 11,
   46, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 11,
   11, 11, 11, 16, 16, 16, 16, 16, 16, 16, 16, 43, 11, 11, 11, 11,
   31, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 33, 16, 16,
   16, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 31, 16, 16,
   16, 16, 33, 16, 16, 16, 11, 11, 11, 11, 31, 16, 16, 16, 16, 16,
   16, 16, 16, 16, 16, 16, 16, 33, 16, 16, 16, 11, 11, 11, 11, 11,
   11, 11, 11, 11, 11, 11, 11, 31, 16, 16, 16, 16, 33, 16, 16, 16,
   11, 11, 11, 11, 31, 16, 16, 16, 16, 33, 16, 16, 16, 32, 43,  7,
   42, 42, 42, 75, 66, 49, 42, 42, 42, 42, 42, 42, 42, 42, 75, 66,
   66, 66, 49, 66, 66, 66, 66, 66, 66, 66, 75, 21,  2,  2, 43, 43,
   43, 43, 43, 43, 43, 56, 42, 42, 16, 16, 16, 16, 16,138, 16, 16,
   16, 16, 16, 16, 16, 16, 16,109, 43, 43,149, 16, 16,109, 43, 43,
   42, 42, 42, 79, 42, 42, 42, 42, 42, 42, 42, 42, 79, 56, 42, 42,
   42, 56, 79, 42, 42, 79, 43, 43, 39, 39, 39, 39, 39, 39, 39, 43,
   43, 43, 43, 43, 43, 43, 43, 56, 42, 42, 42, 73, 39, 39, 39, 43,
    7,  7,  7,  7,  7, 43, 43, 76, 36, 36, 36, 36, 36, 36, 36, 79,
   36, 36, 36, 36, 36, 36, 42, 42,  7,  7,  7,  7,  7, 43, 43, 95,
   36, 36, 36, 36, 36, 82, 42, 42,188,  7,  7,  7,  7,189, 43, 92,
   36, 69, 36, 70, 36, 36, 36, 42, 36, 36, 69, 43, 43, 43, 43, 82,
   36, 36, 36, 60, 36, 36, 61, 60, 36, 36, 60,179, 27, 27, 27, 27,
   16, 16, 42, 42, 42, 73, 43, 43, 27, 27, 27, 27, 27, 27,162, 27,
  190, 27, 99, 43, 43, 43, 43, 43, 27, 27, 27, 27, 27, 27, 27,162,
   27, 27, 27, 27, 27, 27, 27, 43, 36, 36, 61, 36, 36, 36, 36, 36,
   61, 60, 60, 61, 61, 36, 36, 36, 36, 60, 36, 36, 61, 61, 43, 43,
   43, 60, 43, 61, 61, 61, 61, 36, 61, 60, 60, 61, 61, 61, 61, 61,
   61, 60, 60, 61, 36, 60, 36, 36, 36, 60, 36, 36, 61, 36, 60, 60,
   36, 36, 36, 36, 36, 61, 36, 36, 61, 36, 61, 36, 36, 61, 36, 36,
    8, 43, 43, 43, 43, 43, 43, 43, 66, 66, 66, 66, 66, 66, 43, 43,
   54, 66, 66, 66, 66, 66, 66, 66, 27, 27, 27, 27, 27, 27, 90, 66,
   66, 66, 66, 66, 66, 66, 66, 43, 43, 43, 43, 66, 66, 66, 66, 66,
   66, 91, 43, 43, 43, 43, 43, 43, 66, 66, 66, 66, 91, 43, 43, 43,
   66, 43, 43, 43, 43, 43, 43, 43, 66, 66, 66, 66, 66, 25, 40, 40,
   66, 66, 66, 66, 91, 43, 66, 66, 66, 66, 66, 66, 43, 43, 43, 43,
    8,  8,  8,  8,176, 43, 43, 43, 66, 66, 66, 66, 66, 91, 43, 66,
   66, 66, 66, 91, 91, 43, 54, 66, 66, 66, 66, 66, 66, 66, 91, 54,
   66, 66, 66, 66, 66, 91, 43, 54, 66, 91, 66, 66, 66, 66, 66, 66,
    7,  7,  7,  7,  7, 91, 43, 43, 78, 43, 43, 43, 43, 43, 43, 43,
  170,170,170,170,170,170,170, 43,170,170,170,170,170,170,170,  0,
    0,  0, 29, 21, 21, 21, 23, 21, 22, 18, 21, 25, 21, 17, 13, 13,
   25, 25, 25, 21, 21,  9,  9,  9,  9, 22, 21, 18, 24, 16, 24,  5,
    5,  5,  5, 22, 25, 18, 25,  0, 23, 23, 26, 21, 24, 26,  7, 20,
   25,  1, 26, 24, 26, 25, 15, 15, 24, 15,  7, 19, 15, 21,  9, 25,
    9,  5,  5, 25,  5,  9,  5,  7,  7,  7,  9,  8,  8,  5,  6,  6,
   24, 24,  6, 24, 12, 12,  2,  2,  6,  5,  9, 21,  9,  2,  2,  9,
   25,  9, 26, 12, 11, 11,  2,  6,  5, 21, 17,  2,  2, 26, 26, 23,
    2, 12, 17, 12, 21, 12, 12, 21,  7,  2,  2,  7,  7, 21, 21,  2,
    1,  1, 21, 23, 26, 26,  1, 21,  6,  7,  7, 12, 12,  7, 21,  7,
   12,  1, 12,  6,  6, 12, 12, 26,  7, 26, 26,  7,  2,  1, 12,  2,
    6,  2, 24,  7,  7,  6,  1, 12, 12, 10, 10, 10, 10, 12, 21,  6,
    2, 10, 10,  2, 15, 26, 26,  2,  2, 21,  7, 10, 15,  7,  2, 23,
   21, 26, 10,  7, 21, 15, 15,  2, 17,  7, 29,  7,  7, 22, 18,  2,
   14, 14, 14,  7, 10, 21, 17, 21, 11, 12,  5,  2,  5,  6,  8,  8,
    8, 24,  5, 24,  2, 24,  9, 24, 24,  2, 29, 29, 29,  1, 17, 17,
   20, 19, 22, 20, 27, 28,  1, 29, 21, 20, 19, 21, 21, 16, 16, 21,
   25, 22, 18, 21, 21, 29,  1,  2, 15,  6, 18,  6, 12, 11,  9, 26,
   26,  9, 26,  5,  7,  5,  5, 26, 14,  9,  5, 14, 14, 15, 25, 26,
   26, 22, 18, 26, 18, 25, 18, 22,  5, 12,  2,  5, 22, 21, 21, 22,
   18, 17, 26,  6,  7, 14, 17, 22, 18, 18, 26, 14, 17,  6, 14,  6,
   12, 24, 24,  6, 26, 15,  6, 21, 11, 21, 24,  9,  6,  9, 23, 26,
    6, 10,  4,  4,  3,  3,  7, 25, 17, 16, 16, 22, 16, 16, 25, 17,
   25,  2, 25, 24, 23,  2,  2, 15, 12, 15, 14,  2, 21, 14,  7, 15,
   12, 17, 21,  1, 26, 10, 10,  1,  7, 13, 13,  2, 23, 15,  0,  1,
    2,  3,  4,  5,  6,  7,  8,  9,  0, 10, 11, 12, 13,  0, 14,  0,
    0,  0,  0,  0, 15,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 17, 18, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  0, 21, 22, 23,
    0,  0,  0, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 35,  0,
    0,  0,  0, 36,  0, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 39, 40,  0,  0,  0,  0,  0,  0, 41, 42,
   43, 44, 45,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,
    0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,
    6,  7,  8,  0,  9,  0, 10, 11,  0,  0, 12, 13, 14, 15, 16,  0,
    0,  0,  0, 17, 18, 19, 20,  0, 21,  0, 22, 23,  0, 24, 25,  0,
    0, 24, 26, 27,  0, 24, 26,  0,  0, 24, 26,  0,  0, 24, 26,  0,
    0,  0, 26,  0,  0, 24, 28,  0,  0, 24, 26,  0,  0, 29, 26,  0,
    0,  0, 30,  0,  0, 31, 32,  0,  0, 33, 34,  0, 35, 36,  0, 37,
   38,  0, 39,  0,  0, 40,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 42,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 43, 44,  0,  0,
    0,  0, 45,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,
    0,  0,  0,  0, 48,  0,  0, 49,  0, 50, 51, 52,  0, 53, 54, 55,
    0, 56,  0, 57,  0, 58,  0,  0,  0,  0, 59, 60,  0,  0,  0,  0,
    0,  0, 61, 62,  0,  0,  0,  0,  0,  0, 63, 64,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 65,  0,  0,  0, 66,
    0,  0,  0, 67,  0, 68,  0,  0, 69,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 70, 71,  0,  0, 72,  0,  0,  0,  0,
    0,  0,  0,  0, 73, 74,  0,  0,  0,  0, 54, 75,  0, 76, 77,  0,
    0, 78, 79,  0,  0,  0,  0,  0,  0, 80, 81, 82,  0,  0,  0,  0,
    0,  0,  0, 26,  0,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0,
    0,  0,  0,  0,  0, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 85,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0, 87,
    0,  0,  0,  0, 88, 89,  0,  0,  0,  0,  0, 90,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91,  0, 92,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0, 94,  0,  0, 95,  0,
   96,  0,  0,  0,  0,  0, 73, 97,  0, 98,  0,  0, 99,100,  0, 78,
    0,  0,101,  0,  0,102,  0,  0,  0,  0,  0,103,  0,104, 26,105,
    0,  0,106,  0,  0,  0,107,  0,  0,  0,108,  0,  0,  0,  0,  0,
    0, 66,109,  0,  0, 66,  0,  0,  0,110,  0,  0,  0,111,  0,  0,
    0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,112,113,  0,
    0,  0,  0, 79,  0, 44,114,  0,115,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 66,  0,  0,  0,  0,  0,  0,  0,  0,116,  0,
  117,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,118,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,119,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,120,  0,121,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,122,  0,  0,  0,  0,123,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,124,
  125,126,  0,  0,  0,  0,127,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,128,129,  0,  0,130,  0,  0,  0,  0,121,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,131,  0,132,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,133,  0,  0,  0,  0,
    0,  0,  0,134,  0,  0,  0,  0,  0,  0,  0,135,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,136,  0,  0,  0,137,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,
    1,  2,  3,  4,  5,  6,  7,  4,  4,  8,  9, 10,  1, 11, 12, 13,
   14, 15, 16, 17, 18,  1,  1,  1,  0,  0,  0,  0, 19,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0, 20, 21, 22,  1, 23,  4, 21, 24,
   25, 26, 27, 28, 29, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  1, 31,  0,  0,  0, 32, 33, 34, 35,  1, 36,  0,  0,  0,  0,
   37,  0,  0,  0,  0,  0,  0,  0,  0, 38,  1, 39, 14, 39, 40, 41,
    0,  0,  0,  0,  0,  0,  0,  0, 42,  0,  0,  0,  0,  0,  0,  0,
   43, 36, 44, 45, 21, 45, 46,  0,  0,  0,  0,  0,  0,  0, 19,  1,
   21,  0,  0, 47,  0,  0,  0,  0,  0, 38, 48,  1,  1, 49, 49, 50,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,  0,  0,  0,  0,  0,
    0, 19, 52,  1,  0,  0, 38, 14,  4,  1,  1,  1, 53, 21, 43, 52,
   54, 21, 35,  1,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0, 56,
   57, 58,  0,  0,  0,  0,  0, 56,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 59,  0,  0,  0, 56,  0, 60,  0,  0,  0,  0,  0,  0,
    0,  0, 61, 62,  0,  0, 63,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 64,  0,  0,  0, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 66,  0,  0,  0, 67,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 68,  0,  0,  0,  0,  0,  0, 69, 70,  0,  0,  0,  0,  0,
   71, 72, 73, 74, 75, 76,  0,  0,  0,  0,  0,  0,  0, 77,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 78, 79,  0,  0,  0,  0, 47,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 49,  0,  0,  0,  0,
    0, 80,  0,  0,  0,  0,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,
   63,  0,  0, 81,  0,  0, 82,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 83,  0,  0,  0,  0,  0,  0, 19, 84,  0, 62,  0,  0,  0,
    0, 49,  1, 85,  0,  0,  0,  0,  1, 52, 15, 86, 36, 10, 21,  1,
    1,  1,  1, 41,  1, 21, 87,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 55,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,  0, 19, 10,
    1,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0, 89,  0,  0,
   88,  0,  0,  0,  0,  0,  0,  0,  0, 78,  0,  0,  0,  0,  0,  0,
   90,  9, 12,  4, 91,  8, 92, 47,  0, 58, 50,  0, 21,  1, 21, 93,
   94,  1,  1,  1,  1,  1,  1,  1,  1, 95, 96, 97,  0,  0,  0,  0,
   98,  1, 99, 58, 81,100,101,  4, 58,  0,  0,  0,  0,  0,  0, 19,
   50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 61,  1,  1,  1,  1,
    1,  1,  1,  1,  0,  0,102,103,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,104,  0,  0,  0,  0, 19,  0,  1,  1, 50,  0,  0,  0,  0,
    0,  0,  0, 38,  0,  0,  0,  0, 50,  0,  0,  0,  0, 63,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 62,  0,  0,  0,  0,  1,  1,  1,  1,
   50,  0,  0,  0,  0,  0,105, 68,  0,  0,  0,  0,  0,  0,  0,  0,
   61,  0,  0,  0,  0,  0,  0,  0, 78,  0,  0,  0, 62,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,106,107, 58, 38, 81,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 63,  0,  0,  0,  0,  0,  0,
    0,  0,  0,108,  1, 14,  4, 12,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 47, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 38, 90,  0,  0,  0,  0,109,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,110, 61,  0,111,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0, 49, 50,  0,  0,  0,  0,  0,  0, 19, 58,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,112, 51,  0,112, 14, 52,
   84,  0,  0,  0,113, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   62,  0,  0, 61,  0,  0,  0,  0,  0,  0,114,  0, 90,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0, 61, 62,  0,  0, 62,  0, 89,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,114,  0,  0,  0,  0,115,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 78, 55,  0, 38,  1, 58,
    1, 58,  0,  0,  0,  0,  0, 88, 62,  0,  0,  0, 63, 89,  0,  0,
    0,  0,  0, 59,116,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0, 61,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 79, 78,  0,  0,  0,
    0,  0,  0,  0,  0, 61,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 56,  0, 89, 80,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 61,  0,  0, 79,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 61,
    0,  0,  0,  0,  0,  0,  0,  0,  8, 92,  0,  0,  0,  0,  0,  0,
    1, 90,  0,  0,  0,  0,  0,  0,117,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,118,  0,119,120,121,122,  0,105,  4,123, 49, 23,  0,
    0,  0,  0,  0,  0,  0, 38, 50,  0,  0,  0,  0, 38, 58,  0,  0,
    0,  0,  0,  0,  1, 90,  1,  1,  1,  1, 39,  1, 48,106, 90,  0,
    0,  0,  0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,  0, 59,
    0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,124,
    0,  0,  0,  0,  0,  0,  0,113,  0,  0,  0,  0, 19, 59,  0, 38,
    0, 81,  0,  0,  0,  0,  0,  0,  4,123,  0,  0,  0,  1,125,  0,
    0,  0,  0,  0,  0,  0,  0,  0,230,230,230,230,230,232,220,220,
  220,220,232,216,220,220,220,220,220,202,202,220,220,220,220,202,
  202,220,220,220,  1,  1,  1,  1,  1,220,220,220,220,230,230,230,
  230,240,230,220,220,220,230,230,230,220,220,  0,230,230,230,220,
  220,220,220,230,232,220,220,230,233,234,234,233,234,234,233,230,
    0,  0,  0,230,  0,220,230,230,230,230,220,230,230,230,222,220,
  230,230,220,220,230,222,228,230, 10, 11, 12, 13, 14, 15, 16, 17,
   18, 19, 19, 20, 21, 22,  0, 23,  0, 24, 25,  0,230,220,  0, 18,
   30, 31, 32,  0,  0,  0,  0, 27, 28, 29, 30, 31, 32, 33, 34,230,
  230,220,220,230,220,230,230,220, 35,  0,  0,  0,  0,  0,230,230,
  230,  0,  0,230,230,  0,220,230,230,220,  0,  0,  0, 36,  0,  0,
  230,220,230,230,220,220,230,220,220,230,220,230,220,230,230,  0,
    0,220,  0,  0,230,230,  0,230,  0,230,230,230,230,230,  0,  0,
    0,220,220,220,230,220,220,220,230,230,  0,220, 27, 28, 29,230,
    7,  0,  0,  0,  0,  9,  0,  0,  0,230,220,230,230,  0,  0,  0,
    0,  0,230,  0,  0, 84, 91,  0,  0,  0,  0,  9,  9,  0,  0,  0,
    0,  0,  9,  0,103,103,  9,  0,107,107,107,107,118,118,  9,  0,
  122,122,122,122,220,220,  0,  0,  0,220,  0,220,  0,216,  0,  0,
    0,129,130,  0,132,  0,  0,  0,  0,  0,130,130,130,130,  0,  0,
  130,  0,230,230,  9,  0,230,230,  0,  0,220,  0,  0,  0,  0,  7,
    0,  9,  9,  0,  9,  9,  0,  0,  0,230,  0,  0,  0,228,  0,  0,
    0,222,230,220,220,  0,  0,  0,230,  0,  0,220,230,220,  0,220,
  230,230,230,234,  0,  0,  9,  9,  0,  0,  7,  0,230,230,230,  0,
  230,  0,  1,  1,  1,  0,  0,  0,230,234,214,220,202,230,230,230,
  230,230,232,228,228,220,218,230,233,220,230,220,230,230,  1,  1,
    1,  1,  1,230,  0,  1,  1,230,220,230,  1,  1,  0,  0,218,228,
  232,222,224,224,  0,  8,  8,  0,  0,  0,  0,220,230,  0,230,230,
  220,  0,  0,230,  0,  0, 26,  0,  0,220,  0,230,230,  1,220,  0,
    0,230,220,  0,  0,  0,220,220,  0,  0,230,220,  0,  9,  7,  0,
    0,  7,  9,  0,  0,  0,  9,  7,  6,  6,  0,  0,  0,  0,  1,  0,
    0,216,216,  1,  1,  1,  0,  0,  0,226,216,216,216,216,216,  0,
  220,220,220,  0,232,232,220,230,230,230,  7,  0, 16, 17, 17, 17,
   17, 17, 17, 33, 17, 17, 17, 19, 17, 17, 17, 17, 20,101, 17,113,
  129,169, 17, 27, 28, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,237,  0,  1,  2,  2,
    0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  6,  7,  8,
    9,  0,  0,  0, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 20,  0,  0, 21, 22,  0,  0,  0,  0,
   23, 24, 25, 26,  0, 27,  0, 28, 29, 30, 31, 32,  0,  0,  0,  0,
    0,  0,  0, 33, 34, 35, 36,  0,  0,  0,  0,  0, 37,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 38, 39,  0,  0,  0,  0,  1,  2, 40, 41,
    0,  1,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,
    0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  3,  4,  0,  0,  5,  0,
    0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  7,  1,  0,  0,  0,  0,
    0,  0,  8,  9,  0,  0,  0,  0,  0,  0, 10,  0,  0, 10,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 10,
    0,  0,  0,  0,  0,  0, 11, 12,  0, 13,  0, 14, 15, 16,  0,  0,
    0,  0,  0,  1, 17, 18,  0, 19,  7,  1,  0,  0,  0, 20, 20,  7,
   20, 20, 20, 20, 20, 20, 20,  8, 21,  0, 22,  0,  7, 23, 24,  0,
   20, 20, 25,  0,  0,  0, 26, 27,  1,  7, 20, 20, 20, 20, 20,  1,
   28, 29, 30, 31,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0, 10,  0,
    0,  0,  0,  0,  0,  0, 20, 20, 20,  1,  0,  0,  8, 21, 32,  4,
    0, 10,  0, 33,  7, 20, 20, 20,  0,  0,  0,  0,  8, 34, 34, 35,
   36, 34, 37,  0, 38,  1, 20, 20,  0,  0, 39,  0,  1,  1,  0,  8,
   21,  1, 20,  0,  0,  0,  1,  0,  0, 40,  1,  1,  0,  0,  8, 21,
    0,  1,  0,  1,  0,  1,  0,  0,  0,  0, 26, 34, 34, 34, 34, 34,
   34, 34, 34, 34, 21,  7, 20, 41, 34, 34, 34, 34, 34, 34, 34, 34,
   34, 21,  0, 42, 43, 44,  0, 45,  0,  8, 21,  0,  0,  0,  0,  0,
    0,  0,  0, 46,  7,  1, 10,  1,  0,  0,  0,  1, 20, 20,  1,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 26, 34,  9,  0,  0, 20, 20,
    1, 20, 20,  0,  0,  0,  0,  0,  0,  0, 26, 21,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3, 47, 48,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  7,  7,
    7,  7,  7,  7,  7,  7,  7,  7,  9, 10, 11, 11, 11, 11, 12, 13,
   13, 13, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 13, 13, 13,
   24, 25, 26, 26, 26, 27, 13, 13, 13, 28, 29, 30, 13, 31, 32, 33,
   34, 35, 36, 37,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    7,  7,  7,  7,  7,  7,  7,  7, 38,  7,  7, 39,  7, 40,  7,  7,
    7, 41, 13, 42,  7,  7, 43,  7,  7,  7, 44, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 45,  0,  0,  1,  2,  2,  2,  3,  4,  5,  6,  7,
    8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
   24, 25, 26, 27, 28, 29, 30, 31, 32, 32, 33, 34, 35, 36, 37, 37,
   37, 37, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
   51, 52,  2,  2, 53, 54, 55, 56, 57, 58, 59, 59, 59, 59, 60, 59,
   59, 59, 59, 59, 59, 59, 61, 61, 59, 59, 59, 59, 62, 59, 63, 64,
   65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 59, 69, 69,
   69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
   69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
   69, 78, 69, 69, 69, 69, 79, 79, 79, 79, 79, 79, 79, 79, 79, 80,
   81, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 32, 32,
   32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
   32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
   32, 32, 32, 32, 32, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
   95, 95, 95, 95, 95, 95, 95, 95, 69, 69, 96, 97, 98, 99, 99, 99,
  100,101,102,103,104,105,106,107,108,109, 95,110,111,112,113,114,
  115,116,117,117,118,119,120,121,122,123,124,125,126,127,128,129,
  130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
   95,146,147,148,149, 95,150,151,152,153,154,155,156,157,158,159,
  160,161, 95,162,163,164,165,165,165,165,165,165,165,166,167,165,
  168, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
   95, 95, 95, 95, 95,169,170,170,170,170,170,170,170,170,171,170,
  170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,
  170,170,170,170,170,170,170,170,170,170,170,170,170,172,173,173,
  173,173,174, 95, 95, 95, 95, 95,175, 95, 95, 95, 95, 95, 95, 95,
   95, 95, 95, 95, 95, 95,176,176,176,176,177,178,179,180, 95, 95,
  181, 95,182,183,184,185,186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,186,186,187,187,187,188,
  189,190, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
   95, 95, 95, 95, 95,191,192,193,194,195,195,196, 95, 95, 95, 95,
   95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,197,198,
   95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 59,199,
   59, 59, 59,200,201,202, 59,203,204,205,206,207,208, 95,209,210,
  211, 59, 59,212, 59,213,214,214,214,214,214,215, 95, 95, 95, 95,
   95, 95, 95, 95,216, 95,217,218,219, 95, 95,220, 95, 95, 95,221,
   95,222, 95,223, 95,224,225,226,227, 95, 95, 95, 95, 95,228,229,
  230, 95,231,232, 95, 95,233,234, 59,235,236, 95, 59, 59, 59, 59,
   59, 59, 59,237, 59,238,239,240, 59, 59,241,242, 59,243, 95, 95,
   95, 95, 95, 95, 95, 95, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
   69, 69, 69,244, 69, 69,245, 69, 69, 69, 69, 69, 69, 69, 69, 69,
   69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
   69, 69, 69,246, 69, 69, 69, 69, 69, 69, 69, 69, 69,247, 69, 69,
   69, 69,248, 95, 95, 95, 69, 69, 69, 69,249, 95, 95, 95, 95, 95,
   95, 95, 95, 95, 95, 95, 69, 69, 69, 69, 69, 69,250, 69, 69, 69,
   69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,251, 95,
   95, 95, 95, 95, 95, 95,252, 95,253,254,  0,  1,  2,  2,  0,  1,
    2,  2,  2,  3,  4,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0, 19,
   19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
   19,  0,  0,  0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0, 19, 19,
   19, 19, 19, 19, 19,  0, 19,  0,  0,  0,  0,  0,  0,  0, 19, 19,
   19, 19, 19,  0,  0,  0,  0,  0, 26, 26,  0,  0,  0,  0,  1,  1,
    1,  1,  1,  1,  1,  1,  9,  9,  9,  9,  0,  9,  9,  9,  2,  2,
    9,  9,  9,  9,  0,  9,  2,  2,  2,  2,  9,  0,  9,  0,  9,  9,
    9,  2,  9,  2,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    2,  9,  9,  9,  9,  9,  9,  9, 55, 55, 55, 55, 55, 55, 55, 55,
   55, 55, 55, 55, 55, 55,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
    6,  6,  6,  1,  1,  6,  2,  4,  4,  4,  4,  4,  4,  4,  4,  4,
    4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  2,  4,  4,
    4,  2,  2,  4,  4,  4,  2, 14, 14, 14, 14, 14, 14, 14, 14, 14,
   14, 14, 14, 14, 14, 14,  2,  2,  2,  2,  2,  2,  2,  2, 14, 14,
   14,  2,  2,  2,  2, 14, 14, 14, 14, 14, 14,  2,  2,  2,  3,  3,
    3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  0,  0,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  3,  3,  1,  3,  3,  3,  3,  3,  3,  3, 37, 37,
   37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,  2, 37, 37, 37,
   37,  2,  2, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
    2,  2,  2,  2,  2,  2, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
   64,  2,  2, 64, 64, 64, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
   90, 90, 90, 90,  2,  2, 90, 90, 90, 90, 90, 90, 90,  2, 95, 95,
   95, 95, 95, 95, 95, 95, 95, 95, 95, 95,  2,  2, 95,  2, 37, 37,
   37,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,  2,  2,  3,  3,  3,
    0,  3,  3,  3,  3,  3,  7,  7,  7,  7,  7,  7,  7,  7,  7,  1,
    1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  0,  0,  7,  7,  5,  5,
    5,  5,  2,  5,  5,  5,  5,  5,  5,  5,  5,  2,  2,  5,  5,  2,
    2,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  2,
    5,  5,  5,  5,  5,  5,  5,  2,  5,  2,  2,  2,  5,  5,  5,  5,
    2,  2,  5,  5,  5,  5,  5,  2,  2,  5,  5,  5,  5,  2,  2,  2,
    2,  2,  2,  2,  2,  5,  2,  2,  2,  2,  5,  5,  2,  5,  5,  5,
    5,  5,  2,  2,  5,  5,  5,  5,  5,  5,  5,  5,  5,  2,  2, 11,
   11, 11,  2, 11, 11, 11, 11, 11, 11,  2,  2,  2,  2, 11, 11,  2,
    2, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  2,
   11, 11, 11, 11, 11, 11, 11,  2, 11, 11,  2, 11, 11,  2, 11, 11,
    2,  2, 11,  2, 11, 11, 11,  2,  2, 11, 11, 11,  2,  2,  2, 11,
    2,  2,  2,  2,  2,  2,  2, 11, 11, 11, 11,  2, 11,  2,  2,  2,
    2,  2,  2,  2, 11, 11, 11, 11, 11, 11, 11, 11, 11,  2,  2, 10,
   10, 10,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10,  2, 10, 10, 10,
    2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  2,
   10, 10, 10, 10, 10, 10, 10,  2, 10, 10,  2, 10, 10, 10, 10, 10,
    2,  2, 10, 10, 10, 10, 10, 10,  2, 10, 10, 10,  2,  2, 10,  2,
    2,  2,  2,  2,  2,  2, 10, 10, 10, 10,  2,  2, 10, 10, 10, 10,
    2,  2,  2,  2,  2,  2,  2, 10, 10, 10, 10, 10, 10, 10,  2, 21,
   21, 21,  2, 21, 21, 21, 21, 21, 21, 21, 21,  2,  2, 21, 21,  2,
    2, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  2,
   21, 21, 21, 21, 21, 21, 21,  2, 21, 21,  2, 21, 21, 21, 21, 21,
    2,  2, 21, 21, 21, 21, 21,  2,  2, 21, 21, 21,  2,  2,  2,  2,
    2,  2,  2, 21, 21, 21,  2,  2,  2,  2, 21, 21,  2, 21, 21, 21,
   21, 21,  2,  2, 21, 21,  2,  2, 22, 22,  2, 22, 22, 22, 22, 22,
   22,  2,  2,  2, 22, 22, 22,  2, 22, 22, 22, 22,  2,  2,  2, 22,
   22,  2, 22,  2, 22, 22,  2,  2,  2, 22, 22,  2,  2,  2, 22, 22,
   22, 22, 22, 22, 22, 22, 22, 22,  2,  2,  2,  2, 22, 22, 22,  2,
    2,  2,  2,  2,  2, 22,  2,  2,  2,  2,  2,  2, 22, 22, 22, 22,
   22,  2,  2,  2,  2,  2, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
   23, 23, 23,  2, 23, 23, 23,  2, 23, 23, 23, 23, 23, 23, 23, 23,
    2,  2, 23, 23, 23, 23, 23,  2, 23, 23, 23, 23,  2,  2,  2,  2,
    2,  2,  2, 23, 23,  2, 23, 23, 23,  2, 23, 23,  2,  2, 23, 23,
   23, 23,  2,  2, 23, 23,  2,  2,  2,  2,  2,  2,  2, 23, 16, 16,
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  2, 16, 16, 16,  2,
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  2, 16, 16, 16, 16, 16,
    2,  2, 16, 16, 16, 16, 16,  2, 16, 16, 16, 16,  2,  2,  2,  2,
    2,  2,  2, 16, 16,  2,  2,  2,  2,  2, 16, 16, 16,  2, 16, 16,
   16, 16,  2,  2, 16, 16,  2, 16, 16, 16,  2,  2,  2,  2, 20, 20,
   20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  2, 20, 20, 20,  2,
   20, 20, 20, 20, 20, 20,  2,  2,  2,  2, 20, 20, 20, 20, 20, 20,
   20, 20,  2,  2, 20, 20,  2, 36, 36, 36,  2, 36, 36, 36, 36, 36,
   36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,  2,  2,  2,
   36, 36, 36, 36, 36, 36, 36, 36,  2, 36, 36, 36, 36, 36, 36, 36,
   36, 36,  2, 36,  2,  2,  2,  2, 36,  2,  2,  2,  2, 36, 36, 36,
   36, 36, 36,  2, 36,  2,  2,  2,  2,  2,  2,  2, 36, 36,  2,  2,
   36, 36, 36,  2,  2,  2,  2, 24, 24, 24, 24, 24, 24, 24, 24, 24,
   24, 24, 24, 24, 24, 24, 24, 24, 24,  2,  2,  2,  2,  0, 24, 24,
   24, 24,  2,  2,  2,  2,  2, 18, 18,  2, 18,  2, 18, 18, 18, 18,
   18,  2, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
   18, 18,  2, 18,  2, 18, 18, 18, 18, 18, 18, 18,  2,  2, 18, 18,
   18, 18, 18,  2, 18,  2, 18, 18, 18, 18, 18, 18, 18,  2, 18, 18,
    2,  2, 18, 18, 18, 18, 25, 25, 25, 25, 25, 25, 25, 25,  2, 25,
   25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,  2,  2,  2, 25, 25,
   25, 25, 25,  2, 25, 25, 25, 25, 25, 25, 25,  0,  0,  0,  0, 25,
   25,  2,  2,  2,  2,  2, 33, 33, 33, 33, 33, 33, 33, 33,  8,  8,
    8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  2,  8,  2,  2,
    2,  2,  2,  8,  2,  2,  8,  8,  8,  0,  8,  8,  8,  8, 12, 12,
   12, 12, 12, 12, 12, 12, 30, 30, 30, 30, 30, 30, 30, 30, 30,  2,
   30, 30, 30, 30,  2,  2, 30, 30, 30, 30, 30, 30, 30,  2, 30, 30,
   30,  2,  2, 30, 30, 30, 30, 30, 30, 30, 30,  2,  2,  2, 30, 30,
    2,  2,  2,  2,  2,  2, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
   29, 29, 29, 29,  2,  2, 28, 28, 28, 28, 28, 28, 28, 28, 34, 34,
   34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,  2,  2,  2, 35, 35,
   35, 35, 35, 35, 35, 35, 35, 35, 35,  0,  0,  0, 35, 35, 35,  2,
    2,  2,  2,  2,  2,  2, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
   45, 45, 45, 45,  2,  2,  2,  2,  2,  2,  2,  2,  2, 45, 44, 44,
   44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,  0,  0,  2, 43, 43,
   43, 43, 43, 43, 43, 43, 43, 43, 43, 43,  2,  2,  2,  2, 46, 46,
   46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  2, 46, 46, 46,  2,
   46, 46,  2,  2,  2,  2, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
   31, 31, 31, 31,  2,  2, 31, 31,  2,  2,  2,  2,  2,  2, 32, 32,
    0,  0, 32,  0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    2,  2,  2,  2,  2,  2, 32,  2,  2,  2,  2,  2,  2,  2, 32, 32,
   32,  2,  2,  2,  2,  2, 28, 28, 28, 28, 28, 28,  2,  2, 48, 48,
   48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,  2, 48, 48,
   48, 48,  2,  2,  2,  2, 48,  2,  2,  2, 48, 48, 48, 48, 52, 52,
   52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,  2,  2, 52, 52,
   52, 52, 52,  2,  2,  2, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
   58, 58,  2,  2,  2,  2, 58, 58,  2,  2,  2,  2,  2,  2, 58, 58,
   58,  2,  2,  2, 58, 58, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
   54, 54,  2,  2, 54, 54, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91,  2, 91, 91, 91, 91, 91,  2,  2, 91, 91, 91,
    2,  2,  2,  2,  2,  2, 91, 91, 91, 91, 91, 91,  2,  2,  1,  1,
    1,  1,  1,  1,  2,  2,  1,  1,  1,  1,  2,  2,  2,  2, 62, 62,
   62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,  2, 62, 62, 76, 76,
   76, 76, 76, 76, 76, 76, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
   93, 93,  2,  2,  2,  2,  2,  2,  2,  2, 93, 93, 93, 93, 70, 70,
   70, 70, 70, 70, 70, 70,  2,  2,  2, 70, 70, 70, 70, 70, 70, 70,
    2,  2,  2, 70, 70, 70, 73, 73, 73, 73, 73, 73, 73, 73,  6,  6,
    6,  2,  2,  2,  2,  2,  8,  8,  8,  2,  2,  8,  8,  8,  1,  1,
    1,  0,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1,  1,  1,  1,  0,
    0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  1,
    0,  2,  2,  2,  2,  2, 19, 19, 19, 19, 19, 19,  9,  9,  9,  9,
    9,  6, 19, 19, 19, 19, 19, 19, 19, 19, 19,  9,  9,  9,  9,  9,
   19, 19, 19, 19,  9,  9,  9,  9,  9, 19, 19, 19, 19, 19,  6, 19,
   19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,  9,  9,  9,
    9,  9,  9,  9,  2,  2,  2,  9,  2,  9,  2,  9,  2,  9,  9,  9,
    9,  9,  9,  2,  9,  9,  9,  9,  9,  9,  2,  2,  9,  9,  9,  9,
    9,  9,  2,  9,  9,  9,  2,  2,  9,  9,  9,  2,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  2,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,
    0,  0,  0,  2,  0,  0,  0, 19,  2,  2,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,  0,  2, 19, 19,
   19, 19, 19,  2,  2,  2,  0,  0,  2,  2,  2,  2,  2,  2,  1,  2,
    2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,
   19, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 19,  0, 19,  0,
    0,  0,  2,  2,  2,  2,  0,  0,  0,  2,  2,  2,  2,  2, 27, 27,
   27, 27, 27, 27, 27, 27,  0,  0,  0,  0,  2,  2,  0,  0, 56, 56,
   56, 56, 56, 56, 56, 56, 55, 55, 55, 55,  2,  2,  2,  2,  2, 55,
   55, 55, 55, 55, 55, 55, 61, 61, 61, 61, 61, 61, 61, 61,  2,  2,
    2,  2,  2,  2,  2, 61, 61,  2,  2,  2,  2,  2,  2,  2,  0,  0,
    0,  0,  0,  0,  2,  2, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    2, 13, 13, 13, 13, 13, 13, 13, 13, 13,  2,  2,  2,  2, 13, 13,
   13, 13, 13, 13,  2,  2,  0,  0,  0,  0,  0, 13,  0, 13,  0, 13,
   13, 13, 13, 13, 13, 13, 13, 13,  1,  1,  1,  1, 12, 12, 13, 13,
   13, 13,  0,  0,  0,  0,  2, 15, 15, 15, 15, 15, 15, 15, 15, 15,
   15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  2,  2,  1,
    1,  0,  0, 15, 15, 15,  0, 17, 17, 17, 17, 17, 17, 17, 17, 17,
   17, 17, 17, 17, 17, 17, 17, 17, 17,  0,  0, 17, 17, 17,  2,  2,
    2,  2,  2, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  2, 12,
   12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  2,  2,  2,
    2,  2,  2,  2,  2,  0, 12, 12, 12, 12, 12, 12, 12,  0, 17, 17,
   17, 17, 17, 17, 17,  0, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
   39, 39, 39,  2,  2,  2, 39, 39, 39, 39, 39, 39, 39,  2, 86, 86,
   86, 86, 86, 86, 86, 86, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
   77, 77,  2,  2,  2,  2, 79, 79, 79, 79, 79, 79, 79, 79,  0,  0,
   19, 19, 19, 19, 19, 19,  0,  0,  0, 19, 19, 19, 19, 19,  2, 19,
   19, 19, 19, 19, 19, 19, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
   60, 60, 60,  2,  2,  2, 65, 65, 65, 65, 65, 65, 65, 65, 75, 75,
   75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  2,  2,  2,  2,
    2,  2,  2,  2, 75, 75, 75, 75,  2,  2,  2,  2,  2,  2, 69, 69,
   69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,  0, 69, 74, 74,
   74, 74, 74, 74, 74, 74, 74, 74, 74, 74,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  2,  2, 74, 12, 12, 12, 12, 12,  2,  2,  2, 84, 84,
   84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  2,  0, 84, 84,
    2,  2,  2,  2, 84, 84, 33, 33, 33, 33, 33, 33, 33,  2, 68, 68,
   68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,  2, 68, 68,
   68, 68, 68, 68,  2,  2, 68, 68,  2,  2, 68, 68, 68, 68, 92, 92,
   92, 92, 92, 92, 92, 92, 92, 92, 92,  2,  2,  2,  2,  2,  2,  2,
    2, 92, 92, 92, 92, 92, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
   87, 87, 87, 87, 87,  2,  2, 30, 30, 30, 30, 30, 30,  2, 19, 19,
   19,  0, 19, 19, 19, 19, 19, 19, 19, 19, 19,  9, 19, 19, 19, 19,
    0,  0,  2,  2,  2,  2, 87, 87, 87, 87, 87, 87,  2,  2, 87, 87,
    2,  2,  2,  2,  2,  2, 12, 12, 12, 12,  2,  2,  2,  2,  2,  2,
    2, 12, 12, 12, 12, 12, 13, 13,  2,  2,  2,  2,  2,  2, 19, 19,
   19, 19, 19, 19, 19,  2,  2,  2,  2,  4,  4,  4,  4,  4,  2,  2,
    2,  2,  2, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,  2, 14, 14,
   14, 14, 14,  2, 14,  2, 14, 14,  2, 14, 14,  2, 14, 14,  3,  3,
    3,  3,  3,  3,  0,  0,  1,  1,  1,  1,  1,  1,  6,  6,  0,  0,
    0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  2,  2,  3,  3,
    3,  3,  3,  2,  3,  3,  3,  3,  3,  3,  3,  2,  2,  0,  2,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17, 17, 17, 17,
   17, 17, 17, 17,  0,  0,  2,  2, 12, 12, 12, 12, 12, 12,  2,  2,
   12, 12, 12,  2,  2,  2,  2,  0,  0,  0,  0,  0,  2,  2, 49, 49,
   49, 49, 49, 49, 49, 49, 49, 49, 49, 49,  2, 49, 49, 49, 49, 49,
   49, 49, 49, 49, 49,  2, 49, 49, 49,  2, 49, 49,  2, 49, 49, 49,
   49, 49, 49, 49,  2,  2, 49, 49, 49,  2,  2,  2,  2,  2,  0,  0,
    0,  2,  2,  2,  2,  0,  0,  0,  0,  0,  2,  2,  2,  0,  0,  0,
    0,  0,  0,  2,  2,  2,  9,  2,  2,  2,  2,  2,  2,  2,  0,  0,
    0,  0,  0,  1,  2,  2, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
   71, 71, 71,  2,  2,  2, 67, 67, 67, 67, 67, 67, 67, 67, 67,  2,
    2,  2,  2,  2,  2,  2,  1,  0,  0,  0,  0,  0,  0,  0, 42, 42,
   42, 42, 42, 42, 42, 42, 42, 42, 42, 42,  2,  2,  2,  2,  2,  2,
    2,  2,  2, 42, 42, 42, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
   41,  2,  2,  2,  2,  2,118,118,118,118,118,118,118,118,118,118,
  118,  2,  2,  2,  2,  2, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
   53, 53, 53, 53,  2, 53, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
   59, 59,  2,  2,  2,  2, 59, 59, 59, 59, 59, 59,  2,  2, 40, 40,
   40, 40, 40, 40, 40, 40, 51, 51, 51, 51, 51, 51, 51, 51, 50, 50,
   50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,  2,  2, 50, 50,
    2,  2,  2,  2,  2,  2,135,135,135,135,135,135,135,135,135,135,
  135,135,  2,  2,  2,  2,106,106,106,106,106,106,106,106,104,104,
  104,104,104,104,104,104,104,104,104,104,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  2,  2,104,161,161,161,161,161,161,161,161,161,161,
  161,  2,161,161,161,161,161,161,161,  2,161,161,  2,161,161,161,
    2,161,161,161,161,161,161,161,  2,161,161,  2,  2,  2,170,170,
  170,170,170,170,170,170,170,170,170,170,  2,  2,  2,  2,110,110,
  110,110,110,110,110,110,110,110,110,110,110,110,110,  2,110,110,
  110,110,110,110,  2,  2, 19, 19, 19, 19, 19, 19,  2, 19, 19,  2,
   19, 19, 19, 19, 19, 19, 19, 19, 19,  2,  2,  2,  2,  2, 47, 47,
   47, 47, 47, 47,  2,  2, 47,  2, 47, 47, 47, 47, 47, 47, 47, 47,
   47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,  2, 47, 47,  2,
    2,  2, 47,  2,  2, 47, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
   81, 81, 81, 81,  2, 81,120,120,120,120,120,120,120,120,116,116,
  116,116,116,116,116,116,116,116,116,116,116,116,116,  2,  2,  2,
    2,  2,  2,  2,  2,116,128,128,128,128,128,128,128,128,128,128,
  128,  2,128,128,  2,  2,  2,  2,  2,128,128,128,128,128, 66, 66,
   66, 66, 66, 66, 66, 66, 66, 66, 66, 66,  2,  2,  2, 66, 72, 72,
   72, 72, 72, 72, 72, 72, 72, 72,  2,  2,  2,  2,  2, 72,173,173,
  173,173,173,173,173,173,173,173,  2,  2,  2,  2,  2,  2, 98, 98,
   98, 98, 98, 98, 98, 98, 97, 97, 97, 97, 97, 97, 97, 97,  2,  2,
    2,  2, 97, 97, 97, 97,  2,  2, 97, 97, 97, 97, 97, 97, 57, 57,
   57, 57,  2, 57, 57,  2,  2,  2,  2,  2, 57, 57, 57, 57, 57, 57,
   57, 57,  2, 57, 57, 57,  2, 57, 57, 57, 57, 57, 57, 57, 57, 57,
   57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,  2,  2, 57, 57,
   57,  2,  2,  2,  2, 57, 57,  2,  2,  2,  2,  2,  2,  2, 88, 88,
   88, 88, 88, 88, 88, 88,117,117,117,117,117,117,117,117,112,112,
  112,112,112,112,112,112,112,112,112,112,112,112,112,  2,  2,  2,
    2,112,112,112,112,112, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
   78, 78, 78, 78,  2,  2,  2, 78, 78, 78, 78, 78, 78, 78, 83, 83,
   83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,  2,  2, 82, 82,
   82, 82, 82, 82, 82, 82, 82, 82, 82,  2,  2,  2,  2,  2,122,122,
  122,122,122,122,122,122,122,122,  2,  2,  2,  2,  2,  2,  2,122,
  122,122,122,  2,  2,  2,  2,122,122,122,122,122,122,122, 89, 89,
   89, 89, 89, 89, 89, 89, 89,  2,  2,  2,  2,  2,  2,  2,130,130,
  130,130,130,130,130,130,130,130,130,  2,  2,  2,  2,  2,  2,  2,
  130,130,130,130,130,130,144,144,144,144,144,144,144,144,144,144,
    2,  2,  2,  2,  2,  2,165,165,165,165,165,165,165,165,165,165,
  165,165,165,165,  2,  2,  2,165,165,165,165,165,165,165,  2,  2,
    2,  2,  2,  2,165,165,  3,  3,  3,  3,  3,  3,  3,  2,156,156,
  156,156,156,156,156,156,156,156,  2,156,156,156,  2,  2,156,156,
    2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  2,
    2,  2,  2,  2,  2,  2,147,147,147,147,147,147,147,147,148,148,
  148,148,148,148,148,148,148,148,  2,  2,  2,  2,  2,  2,158,158,
  158,158,158,158,158,158,158,158,  2,  2,  2,  2,  2,  2,153,153,
  153,153,153,153,153,153,153,153,153,153,  2,  2,  2,  2,149,149,
  149,149,149,149,149,149,149,149,149,149,149,149,149,  2, 94, 94,
   94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,  2,  2,  2,  2,
   94, 94, 94, 94, 94, 94,  2,  2,  2,  2,  2,  2,  2, 94, 85, 85,
   85, 85, 85, 85, 85, 85, 85, 85, 85,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  2, 85,  2,  2,101,101,101,101,101,101,101,101,101,  2,
    2,  2,  2,  2,  2,  2,101,101,  2,  2,  2,  2,  2,  2, 96, 96,
   96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,  2, 96, 96,111,111,
  111,111,111,111,111,111,111,111,111,111,111,111,111,  2,100,100,
  100,100,100,100,100,100,  2, 36, 36, 36, 36, 36, 36, 36, 36, 36,
   36, 36, 36,  2,  2,  2,108,108,108,108,108,108,108,108,108,108,
    2,108,108,108,108,108,108,108,  2,  2,  2,  2,  2,  2,129,129,
  129,129,129,129,129,  2,129,  2,129,129,129,129,  2,129,129,129,
  129,129,129,129,129,129,129,129,129,129,129,129,  2,129,129,129,
    2,  2,  2,  2,  2,  2,109,109,109,109,109,109,109,109,109,109,
  109,  2,  2,  2,  2,  2,109,109,  2,  2,  2,  2,  2,  2,107,107,
  107,107,  2,107,107,107,107,107,107,107,107,  2,  2,107,107,  2,
    2,107,107,107,107,107,107,107,107,107,107,107,107,107,107,  2,
  107,107,107,107,107,107,107,  2,107,107,  2,107,107,107,107,107,
    2,  1,107,107,107,107,107,  2,  2,107,107,107,  2,  2,107,  2,
    2,  2,  2,  2,  2,107,  2,  2,  2,  2,  2,107,107,107,107,107,
  107,107,  2,  2,107,107,107,107,107,107,107,  2,  2,  2,171,171,
  171,171,171,171,171,171,171,171,  2,171,  2,  2,171,  2,171,171,
  171,171,171,171,  2,171,171,  2,171,  2,  2,171,  2,171,171,171,
  171,  2,171,171,171,171,171,  2,  2,  2,  2,  2,  2,  2,  2,171,
  171,  2,  2,  2,  2,  2,137,137,137,137,137,137,137,137,137,137,
  137,137,  2,137,137,137,137,137,  2,  2,  2,  2,  2,  2,124,124,
  124,124,124,124,124,124,124,124,  2,  2,  2,  2,  2,  2,123,123,
  123,123,123,123,123,123,123,123,123,123,123,123,  2,  2,114,114,
  114,114,114,114,114,114,114,114,114,114,114,  2,  2,  2,114,114,
    2,  2,  2,  2,  2,  2, 32, 32, 32, 32, 32,  2,  2,  2,102,102,
  102,102,102,102,102,102,102,102,  2,  2,  2,  2,  2,  2, 33, 33,
   33, 33,  2,  2,  2,  2,126,126,126,126,126,126,126,126,126,126,
  126,  2,  2,126,126,126,126,126,126,126,  2,  2,  2,  2,126,126,
  126,126,126,126,126,  2,142,142,142,142,142,142,142,142,142,142,
  142,142,  2,  2,  2,  2,125,125,125,125,125,125,125,125,125,125,
  125,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,125,154,154,
  154,154,154,154,154,  2,  2,154,  2,  2,154,154,154,154,154,154,
  154,154,  2,154,154,  2,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,  2,154,154,  2,  2,154,154,154,154,154,154,154,
    2,  2,  2,  2,  2,  2,150,150,150,150,150,150,150,150,  2,  2,
  150,150,150,150,150,150,150,150,150,150,150,  2,  2,  2,141,141,
  141,141,141,141,141,141,140,140,140,140,140,140,140,140,140,140,
  140,  2,  2,  2,  2,  2,121,121,121,121,121,121,121,121,121,  2,
    2,  2,  2,  2,  2,  2,  7,  7,  2,  2,  2,  2,  2,  2,169,169,
  169,169,169,169,169,169,169,169,  2,  2,  2,  2,  2,  2,133,133,
  133,133,133,133,133,133,133,  2,133,133,133,133,133,133,133,133,
  133,133,133,133,133,  2,133,133,133,133,133,133,  2,  2,133,133,
  133,133,133,  2,  2,  2,134,134,134,134,134,134,134,134,  2,  2,
  134,134,134,134,134,134,  2,134,134,134,134,134,134,134,134,134,
  134,134,134,134,134,  2,138,138,138,138,138,138,138,  2,138,138,
    2,138,138,138,138,138,138,138,138,138,138,138,138,138,  2,  2,
  138,  2,138,138,  2,138,138,138,  2,  2,  2,  2,  2,  2,143,143,
  143,143,143,143,  2,143,143,  2,143,143,143,143,143,143,143,143,
  143,143,143,143,143,143,143,143,143,143,143,143,143,  2,143,143,
    2,143,143,143,143,143,143,  2,  2,  2,  2,  2,  2,  2,143,143,
    2,  2,  2,  2,  2,  2,175,175,175,175,175,175,175,175,175,175,
  175,175,  2,  2,  2,  2,175,175,  2,  2,  2,  2,  2,  2,145,145,
  145,145,145,145,145,145,145,  2,  2,  2,  2,  2,  2,  2,163,163,
  163,163,163,163,163,163,163,  2,163,163,163,163,163,163,163,163,
  163,  2,  2,  2,163,163,163,163,163,  2,  2,  2,  2,  2, 86,  2,
    2,  2,  2,  2,  2,  2, 22, 22,  2,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  2,  2, 22, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
    2,  2,  2,  2,  2,  2, 63, 63, 63, 63, 63, 63, 63,  2, 63, 63,
   63, 63, 63,  2,  2,  2, 63, 63, 63, 63,  2,  2,  2,  2,157,157,
  157,157,157,157,157,157,157,157,157,  2,  2,  2,  2,  2, 80, 80,
   80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,  2,  2, 80, 80,
   80,  2,  2,  2,  2,  2,127,127,127,127,127,127,127,127,127,127,
  127,127,127,127,127,  2,166,166,166,166,166,166,166,166,166,166,
    2,  2,  2,  2,  2,  2, 79,  2,  2,  2,  2,  2,  2,  2,115,115,
  115,115,115,115,115,115,115,115,115,115,115,115,115,  2,115,115,
    2,  2,  2,  2,115,115,159,159,159,159,159,159,159,159,159,159,
  159,159,159,159,159,  2,159,159,  2,  2,  2,  2,  2,  2,103,103,
  103,103,103,103,103,103,103,103,103,103,103,103,  2,  2,119,119,
  119,119,119,119,119,119,119,119,119,119,119,119,  2,  2,119,119,
    2,119,119,119,119,119,  2,  2,  2,  2,  2,119,119,119,167,167,
  167,167,167,167,167,167,167,167,  2,  2,  2,  2,  2,  2,146,146,
  146,146,146,146,146,146,146,146,146,  2,  2,  2,  2,  2,172,172,
  172,172,172,172,172,172,172,  2,  2,172,172,172,172,172,172,172,
  172,172,  2,  2,  2,  2, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
   99,  2,  2,  2,  2, 99,  2,  2,  2,  2,  2,  2,  2, 99,136,139,
   13, 13,155,  2,  2,  2, 13, 13, 13, 13, 13, 13, 13,  2,136,136,
  136,136,136,136,136,136,155,155,155,155,155,155,155,155,155,155,
  155,155,155,155,  2,  2,  2,  2,  2,  2,  2,  2,  2,155,136,136,
  136,136,136,136,136,  2,136,136,136,  2,  2,  2,  2,  2, 17, 17,
   17, 17,  2, 17, 17, 17, 17, 17, 17, 17,  2, 17, 17,  2, 17, 15,
   15, 15, 15, 15, 15, 15, 17, 17, 17,  2,  2,  2,  2,  2,  2,  2,
   15,  2,  2,  2,  2,  2, 15, 15, 15,  2,  2, 17,  2,  2,  2,  2,
    2,  2, 17, 17, 17, 17,139,139,139,139,139,139,139,139,139,139,
  139,139,  2,  2,  2,  2,105,105,105,105,105,105,105,105,105,105,
  105,  2,  2,  2,  2,  2,105,105,105,105,105,  2,  2,  2,105,  2,
    2,  2,  2,  2,  2,  2,105,105,  2,  2,105,105,105,105,  2,  2,
    0,  0,  0,  0,  0,  0,  0,  2,  2,  2,  2,  2,  2,  2,  1,  1,
    1,  1,  1,  1,  1,  2,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,
    1,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,
    1,  1,  1,  1,  0,  0,  2,  2,  0,  2,  2,  0,  0,  2,  2,  0,
    0,  0,  0,  2,  0,  0,  0,  0,  2,  0,  2,  0,  0,  0,  0,  0,
    0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,
    0,  2,  2,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  2,  0,  0,
    0,  0,  0,  2,  0,  2,  0,  2,  0,  0,  0,  0,  0,  0,131,131,
  131,131,131,131,131,131,131,131,131,131,  2,  2,  2,  2,  2,  2,
    2,131,131,131,131,131,  2,131,131,131,131,131,131,131,  2,  2,
    2,  2,  2, 19, 19, 19, 56, 56, 56, 56, 56, 56, 56,  2, 56,  2,
    2, 56, 56, 56, 56, 56, 56, 56,  2, 56, 56,  2, 56, 56, 56, 56,
   56,  2,  2,  2,  2,  2,  6,  6,  6,  6,  6,  6,  2,  2,  2,  2,
    2,  2,  2,  2,  2,  6,151,151,151,151,151,151,151,151,151,151,
  151,151,151,  2,  2,  2,151,151,151,151,151,151,  2,  2,151,151,
    2,  2,  2,  2,151,151,160,160,160,160,160,160,160,160,160,160,
  160,160,160,160,160,  2,152,152,152,152,152,152,152,152,152,152,
    2,  2,  2,  2,  2,152,164,164,164,164,164,164,164,164,164,164,
    2,  2,  2,  2,  2,  2,168,168,168,168,168,168,168,168,168,168,
  168,  2,  2,  2,  2,168,174,174,174,174,174,174,174,174,174,174,
  174,174,174,174,174,  2,174,174,174,174,174,174,  2,  2,  2,  2,
    2,  2,  2,  2,174,174, 30, 30, 30, 30,  2, 30, 30,  2,113,113,
  113,113,113,113,113,113,113,113,113,113,113,  2,  2,113,113,113,
  113,113,113,113,113,  2,132,132,132,132,132,132,132,132,132,132,
  132,132,  2,  2,  2,  2,132,132,  2,  2,  2,  2,132,132,  3,  3,
    3,  3,  2,  3,  3,  3,  2,  3,  3,  2,  3,  2,  2,  3,  2,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  3,  3,  3,  2,  3,
    2,  3,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,  2,  3,  2,  3,
    2,  3,  2,  3,  3,  3,  2,  3,  2,  3,  2,  3,  2,  3,  2,  3,
    3,  3,  3,  2,  3,  2,  3,  3,  2,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  2,  2,  2,  2,  2,  3,  3,  3,  2,  3,  3,  3,  3,  3,
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0, 15,  0,
    0,  2,  2,  2,  2,  2,  0,  2,  2,  2,  0,  0,  0,  0,  0,  0,
    0,  2,  2,  2,  0,  0,  0,  2,  2,  2,  2,  0,  0,  0,  0,  0,
    0,  0,  0,  2,  2,  0, 13,  2,  2,  2,  2,  2,  2,  2, 13, 13,
   13,  2,  2,  2,  2,  2,  2,  0,  2,  2,  2,  2,  2,  2,  0,  1,
    2,  3,  4,  5,  6,  7,  8,  9,  9,  9,  9, 10,  9, 11, 12, 13,
    9,  9,  9, 14,  9,  9, 15,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 16, 17,  9,  9,  9,  9,
   18,  9,  9,  9,  9,  9, 19, 20, 21,  9, 22,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 23,  9,
    9,  9,  9,  9, 24,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9, 25,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 26, 27,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,  5,  6,  7,  8,
    9, 10, 11, 12,  0,  0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   23,  0,  0, 24, 25, 26, 27, 28, 29, 30,  0,  0, 31, 32,  0, 33,
    0, 34,  0, 35,  0,  0,  0,  0, 36, 37, 38, 39,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 40,  0,
    0,  0,  0,  0,  0,  0,  0,  0, 41, 42,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 43, 44,
    0, 45,  0,  0,  0,  0,  0,  0, 46, 47,  0,  0,  0,  0,  0, 48,
    0, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   50, 51,  0,  0,  0, 52,  0,  0, 53,  0,  0,  0,  0,  0,  0,  0,
   54,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0,  0,  0,  0,  0,
   56,  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   58, 59, 60, 61, 62, 63, 64, 65,  0,  0,  0,  0,  0,  0, 66,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 67, 68,  0, 69,
   70,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 71, 72, 73, 74,
   75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
   91, 92, 93, 94, 95, 96, 97, 98, 99,100,101,102,103,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,104,  0,
    0,  0,  0,  0,  0,105,106,  0,107,  0,  0,  0,108,  0,109,  0,
  110,  0,111,112,113,  0,114,  0,  0,  0,115,  0,  0,  0,116,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,117,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  118,119,120,121,  0,122,123,124,125,126,  0,127,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,129,130,131,
  132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,
  148,149,150,151,152,153,154,155,156,157,  0,  0,  0,158,159,160,
  161,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,162,  0,163,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,164,165,  0,  0,  0,  0,  0,  0,  0,166,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  167,  0,  0,  0,168,169,  0,  0,170,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,171,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,172,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,173,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,174,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,175,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,176,177,  0,  0,  0,  0,178,179,  0,  0,  0,180,181,182,183,
  184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,
  200,201,202,203,204,205,206,207,208,209,210,211,212,213,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,
];
static _hb_ucd_u16: [u16; 10832]=
[
     0,   0,   1,   2,   3,   4,   5,   6,   0,   0,   7,   8,   9,  10,  11,  12,
    13,  13,  13,  14,  15,  13,  13,  16,  17,  18,  19,  20,  21,  22,  13,  23,
    13,  13,  13,  24,  25,  11,  11,  11,  11,  26,  11,  27,  28,  29,  30,  31,
    32,  32,  32,  32,  32,  32,  32,  33,  34,  35,  36,  11,  37,  38,  13,  39,
     9,   9,   9,  11,  11,  11,  13,  13,  40,  13,  13,  13,  41,  13,  13,  13,
    13,  13,  13,  42,   9,  43,  11,  11,  44,  45,  32,  46,  47,  48,  49,  50,
    51,  52,  48,  48,  53,  32,  54,  55,  48,  48,  48,  48,  48,  56,  57,  58,
    59,  60,  48,  32,  61,  48,  48,  48,  48,  48,  62,  63,  64,  48,  65,  66,
    48,  67,  68,  69,  48,  70,  71,  48,  72,  73,  48,  48,  74,  32,  75,  32,
    76,  48,  48,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
    90,  83,  84,  91,  92,  93,  94,  95,  96,  97,  84,  98,  99, 100,  88, 101,
   102,  83,  84, 103, 104, 105,  88, 106, 107, 108, 109, 110, 111, 112,  94, 113,
   114, 115,  84, 116, 117, 118,  88, 119, 120, 115,  84, 121, 122, 123,  88, 124,
   125, 115,  48, 126, 127, 128,  88, 129, 130, 131,  48, 132, 133, 134,  94, 135,
   136,  48,  48, 137, 138, 139, 140, 140, 141,  48, 142, 143, 144, 145, 140, 140,
   146, 147, 148, 149, 150,  48, 151, 152, 153, 154,  32, 155, 156, 157, 140, 140,
    48,  48, 158, 159, 160, 161, 162, 163, 164, 165,   9,   9, 166,  11,  11, 167,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48, 168, 169,  48,  48, 168,  48,  48, 170, 171, 172,  48,  48,
    48, 171,  48,  48,  48, 173, 174, 175,  48, 176,   9,   9,   9,   9,   9, 177,
   178,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48, 179,  48, 180, 181,  48,  48,  48,  48, 182, 183,
    48, 184,  48, 185,  48, 186, 187, 188,  48,  48,  48, 189, 190, 191, 192, 193,
   194, 192,  48,  48, 195,  48,  48, 196, 197,  48, 198,  48,  48,  48,  48, 199,
    48, 200, 201, 202, 203,  48, 204, 205,  48,  48, 206,  48, 207, 208, 209, 209,
    48, 210,  48,  48,  48, 211, 212, 213, 192, 192, 214, 215,  32, 216, 217, 140,
   218,  48,  48, 219, 220, 160, 221, 222, 223,  48, 224,  64,  48,  48, 225, 226,
    48,  48, 227, 228, 229,  64,  48, 230, 231,   9,   9, 232, 233, 234, 235, 236,
    11,  11, 237,  27,  27,  27, 238, 239,  11, 240,  27,  27,  32,  32,  32,  32,
    13,  13,  13,  13,  13,  13,  13,  13,  13, 241,  13,  13,  13,  13,  13,  13,
   242, 243, 242, 242, 243, 244, 242, 245, 246, 246, 246, 247, 248, 249, 250, 251,
   252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 262, 263, 264, 265, 266,
   267, 268, 269, 270, 271, 272, 273, 273, 274, 275, 276, 209, 277, 278, 209, 279,
   280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
   281, 209, 282, 209, 209, 209, 209, 283, 209, 284, 280, 285, 209, 286, 287, 209,
   209, 209, 176, 140, 288, 140, 272, 272, 272, 289, 209, 209, 209, 209, 290, 272,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 291, 292, 209, 209, 293,
   209, 209, 209, 209, 209, 209, 294, 209, 209, 209, 209, 209, 209, 209, 209, 209,
   209, 209, 209, 209, 209, 209, 295, 296, 272, 297, 209, 209, 298, 280, 299, 280,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
   280, 280, 280, 280, 280, 280, 280, 280, 300, 301, 280, 280, 280, 302, 280, 303,
   280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
   209, 209, 209, 280, 304, 209, 209, 305, 209, 209, 209, 209, 209, 209, 209, 209,
     9,   9,   9,  11,  11,  11, 306, 307,  13,  13,  13,  13,  13,  13, 308, 309,
    11,  11, 310,  48,  48,  48, 311, 312,  48, 313, 314, 314, 314, 314,  32,  32,
   315, 316, 317, 318, 319, 320, 140, 140, 209, 321, 209, 209, 209, 209, 209, 322,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 323, 140, 209,
   324, 325, 326, 327, 136,  48,  48,  48,  48, 328, 178,  48,  48,  48,  48, 329,
   330,  48,  48, 136,  48,  48,  48,  48, 200, 331,  48,  48, 209, 209, 332,  48,
   209, 333, 334, 209, 335, 336, 209, 209, 334, 209, 209, 336, 209, 209, 209, 209,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 209, 209, 209, 209,
    48, 337,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48, 151, 209, 209, 209, 338,  48,  48, 230,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
   339,  48, 340, 140,  13,  13, 341, 342,  13, 343,  48,  48,  48,  48, 344, 345,
    31, 346, 347, 348,  13,  13,  13, 349, 350, 351, 352, 353, 354, 355, 140, 356,
   357,  48, 358, 359,  48,  48,  48, 360, 361,  48,  48, 362, 363, 192,  32, 364,
    64,  48, 365,  48, 366, 367,  48, 151,  76,  48,  48, 368, 369, 370, 371, 372,
    48,  48, 373, 374, 375, 376,  48, 377,  48,  48,  48, 378, 379, 380, 381, 382,
   383, 384, 314,  11,  11, 385, 386,  11,  11,  11,  11,  11,  48,  48, 387, 192,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 388,  48, 389,  48,  48, 206,
   390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390,
   390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48, 204,  48,  48,  48,  48,  48,  48, 207, 140, 140,
   392, 393, 394, 395, 396,  48,  48,  48,  48,  48,  48, 397, 398, 399,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48, 400, 209,  48,  48,  48,  48, 401,  48,  48, 402, 140, 140, 403,
    32, 404,  32, 405, 406, 407, 408, 409,  48,  48,  48,  48,  48,  48,  48, 410,
   411,   2,   3,   4,   5, 412, 413, 414,  48, 415,  48, 200, 416, 417, 418, 419,
   420,  48, 172, 421, 204, 204, 140, 140,  48,  48,  48,  48,  48,  48,  48,  71,
   422, 272, 272, 423, 273, 273, 273, 424, 425, 426, 427, 140, 140, 209, 209, 428,
   140, 140, 140, 140, 140, 140, 140, 140,  48, 151,  48,  48,  48, 100, 429, 430,
    48,  48, 431,  48, 432,  48,  48, 433,  48, 434,  48,  48, 435, 436, 140, 140,
     9,   9, 437,  11,  11,  48,  48,  48,  48, 204, 192,   9,   9, 438,  11, 439,
    48,  48, 440,  48,  48,  48, 441, 442, 442, 443, 444, 445,  48,  48,  48, 388,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48, 313,  48, 199, 440, 140, 446,  27,  27, 447, 140, 140, 140, 140,
   448,  48,  48, 449,  48, 450,  48, 451,  48, 200, 452, 140, 140, 140,  48, 453,
    48, 454,  48, 455,  48, 207, 140, 140,  48,  48,  48, 456, 272, 457, 272, 272,
   458, 459,  48, 460, 461, 462,  48, 463,  48, 464, 140, 140, 465,  48, 466, 467,
    48,  48,  48, 468,  48, 469,  48, 470,  48, 471, 472, 140, 140, 140, 140, 140,
    48,  48,  48,  48, 196, 140, 140, 140,   9,   9,   9, 473,  11,  11,  11, 474,
    48,  48, 475, 192, 476,   9, 477,  11, 478, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 272, 479,  48,  48, 480, 481, 482, 483, 140, 484,
    48, 464, 485,  48,  62, 486, 140,  48, 487, 140, 140,  48, 488, 140,  48, 313,
   489,  48,  48, 490, 491, 457, 492, 493, 223,  48,  48, 494, 495,  48, 196, 192,
   496,  48, 497, 498, 499,  48,  48, 500, 223,  48,  48, 501, 502, 503, 504, 505,
    48,  97, 506, 507, 508, 140, 140, 140, 509, 510, 511,  48,  48, 512, 513, 192,
   514,  83,  84, 515, 516, 517, 518, 519, 520,  48,  48, 521, 522, 523, 524, 140,
    48,  48,  48, 525, 526, 527, 481, 140,  48,  48,  48, 528, 529, 192, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140,  48,  48, 530, 531, 532, 533, 140, 140,
    48,  48,  48, 534, 535, 192, 536, 140,  48,  48, 537, 538, 192, 539, 540, 140,
    48, 541, 542, 543, 313, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
    48,  48, 506, 544, 140, 140, 140, 140, 140, 140,   9,   9,  11,  11, 148, 545,
   546, 547,  48, 548, 549, 192, 140, 140, 140, 140, 550,  48,  48, 551, 552, 140,
   553,  48,  48, 554, 555, 556,  48,  48, 557, 558, 559,  48,  48,  48,  48, 196,
   560, 140, 140, 140, 140, 140, 561, 140, 140, 140, 140, 140,  48,  48, 562, 192,
    84,  48, 530, 563, 564, 148, 175, 565,  48, 566, 567, 568, 140, 140, 140, 140,
   569,  48,  48, 570, 571, 192, 572,  48, 573, 574, 192,  48,  48, 575, 192, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,  48, 576,
   577, 115,  48, 578, 579, 580, 140, 140, 140, 140, 140, 100, 272, 581, 582, 583,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48, 207, 140, 140, 140, 140, 140, 140,
   273, 273, 273, 273, 273, 273, 584, 585,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48, 388, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140,  48,  48,  48,  48,  48,  48, 586,
    48,  48,  48, 587, 588, 589,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  71,
    48,  48,  48,  48, 313, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
    48, 590, 591, 192, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
    48,  48,  48, 196,  48, 200, 370,  48,  48,  48,  48, 200, 192,  48, 204, 592,
    48,  48,  48, 593, 594, 595, 596, 597,  48, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 598,  48, 599, 192, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140,   9,   9,  11,  11, 272, 600,   9, 601,  11, 602, 140, 140,
    48,  48,  48,  48, 603, 604, 605, 605, 606, 607, 140, 140, 140, 140, 608, 609,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 199, 140, 610,
    48, 200, 140, 140, 140, 140, 140, 140,  48,  48,  48,  48,  48,  48,  48, 611,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 612,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48, 611, 613, 140, 614, 615,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 206,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
    48,  48,  48,  48,  48,  48,  71, 151, 196, 616, 617, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 618,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 619, 209, 427, 209, 620,
    32,  32, 216,  32, 621, 209, 209, 209, 209, 209, 209, 209, 322, 140, 140, 140,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 323,
   209, 209, 622, 209, 209, 209, 623, 624, 625, 209, 626, 209, 209, 209, 288, 140,
   209, 209, 209, 209, 627, 140, 140, 140, 140, 140, 140, 140, 272, 628, 272, 628,
   209, 209, 209, 209, 209, 338, 272, 461, 140, 140, 140, 140, 140, 140, 140, 140,
     9, 629,  11, 630, 631, 632, 242,   9, 633, 634, 635, 636, 637,   9, 629,  11,
   638, 639,  11, 640, 641, 642, 643,   9, 644,  11,   9, 629,  11, 630, 631,  11,
   242,   9, 633, 643,   9, 644,  11,   9, 629,  11, 645,   9, 646, 647, 648, 649,
    11, 650,   9, 651, 652, 653, 654,  11, 655,   9, 656,  11, 657, 539, 539, 539,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
    32,  32,  32, 658,  32,  32, 659, 660, 661, 662,  45, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   663, 664, 665, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   666, 667, 668,  27,  27,  27, 669, 140, 670, 140, 140, 140, 140, 140, 140, 140,
    48,  48, 151, 671, 672, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140,  48, 673, 140,  48,  48, 674, 675,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,  48, 676, 192,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,  48, 590, 677,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,  48, 200, 678, 679,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 680, 200,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 681, 621, 140, 140,
     9,   9, 633,  11, 682, 370, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 504, 272, 272, 683, 684, 140, 140, 140, 140,
   504, 272, 685, 686, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   687,  48, 688, 689, 690, 691, 692, 693, 694, 206, 695, 206, 140, 140, 140, 696,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   209, 209, 697, 209, 209, 209, 209, 209, 209, 322, 333, 698, 698, 698, 209, 323,
   699, 209, 209, 209, 209, 209, 209, 209, 209, 209, 700, 140, 140, 140, 701, 209,
   702, 209, 209, 697, 703, 704, 323, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 705,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 706, 426, 426,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 176, 697, 427,
   697, 209, 209, 209, 707, 176, 209, 209, 707, 209, 700, 697, 704, 708, 140, 140,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
   209, 209, 209, 209, 209, 707, 700, 426, 709, 209, 209, 209, 710, 711, 712, 703,
   209, 209, 209, 209, 209, 209, 209, 209, 209, 713, 209, 209, 209, 209, 209, 714,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 140, 140,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48, 204,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 204,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 100,  48,
    48,  48,  48,  48,  48, 204, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
    48, 204, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
    48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  71,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    48,  48,  48,  48,  48,  48,  48, 207, 140, 140, 140, 140, 140, 140, 140, 140,
   140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
   715, 140, 587, 587, 587, 587, 587, 587, 140, 140, 140, 140, 140, 140, 140, 140,
    32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 140,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 716,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391,
   391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 717,
     0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   2,   3,   1,   2,   2,   3,
     0,   0,   0,   0,   0,   4,   0,   4,   2,   2,   5,   2,   2,   2,   5,   2,
     2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
     2,   2,   2,   2,   2,   2,   2,   6,   0,   0,   0,   0,   7,   8,   0,   0,
     9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  11,
    12,  13,  14,  14,  15,  14,  14,  14,  14,  14,  14,  14,  16,  17,  14,  14,
    18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
    19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
    18,  18,  18,  18,  18,  18,  20,  21,  21,  21,  22,  20,  21,  21,  21,  21,
    21,  23,  24,  25,  25,  25,  25,  25,  25,  26,  25,  25,  25,  27,  28,  26,
    29,  30,  31,  32,  31,  31,  31,  31,  33,  34,  35,  31,  31,  31,  36,  31,
    31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  29,  31,  31,  31,  31,
    37,  38,  37,  37,  37,  37,  37,  37,  37,  39,  31,  31,  31,  31,  31,  31,
    40,  40,  40,  40,  40,  40,  41,  26,  42,  42,  42,  42,  42,  42,  42,  43,
    44,  44,  44,  44,  44,  45,  44,  46,  47,  47,  47,  48,  37,  49,  31,  31,
    31,  31,  50,  31,  31,  31,  31,  31,  31,  31,  31,  31,  51,  31,  31,  31,
    52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  53,  52,  54,  52,  52,  52,
    55,  56,  57,  58,  58,  59,  60,  61,  56,  62,  63,  64,  65,  58,  58,  66,
    67,  68,  69,  70,  70,  71,  72,  73,  68,  74,  75,  76,  77,  70,  78,  26,
    79,  80,  81,  82,  82,  83,  84,  85,  80,  86,  87,  26,  88,  82,  89,  90,
    91,  92,  93,  94,  94,  95,  96,  97,  92,  98,  99, 100, 101,  94,  94,  26,
   102, 103, 104, 105, 106, 103, 107, 108, 103, 104, 109,  26, 110, 107, 107, 111,
   112, 113, 114, 112, 112, 114, 112, 115, 113, 116, 117, 118, 119, 112, 120, 112,
   121, 122, 123, 121, 121, 123, 124, 125, 122, 126, 127, 128, 129, 121, 130,  26,
   131, 132, 133, 131, 131, 131, 131, 131, 132, 133, 134, 131, 135, 131, 131, 131,
   136, 137, 138, 139, 137, 137, 140, 141, 138, 142, 143, 137, 144, 137, 145,  26,
   146, 147, 147, 147, 147, 147, 147, 148, 147, 147, 147, 149,  26,  26,  26,  26,
   150, 151, 152, 152, 153, 152, 152, 154, 155, 156, 152, 157,  26,  26,  26,  26,
   158, 158, 158, 158, 158, 158, 158, 158, 158, 159, 158, 158, 158, 160, 159, 158,
   158, 158, 158, 159, 158, 158, 158, 161, 158, 161, 162, 163,  26,  26,  26,  26,
   164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164,
   164, 164, 164, 164, 165, 165, 165, 165, 166, 167, 165, 165, 165, 165, 165, 168,
   169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169,
   170, 170, 170, 170, 170, 170, 170, 170, 170, 171, 172, 171, 170, 170, 170, 170,
   170, 171, 170, 170, 170, 170, 171, 172, 171, 170, 172, 170, 170, 170, 170, 170,
   170, 170, 171, 170, 170, 170, 170, 170, 170, 170, 170, 173, 170, 170, 170, 174,
   170, 170, 170, 175, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 177, 177,
   178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178,
   179, 179, 179, 180, 181, 181, 181, 181, 181, 181, 181, 181, 181, 182, 181, 183,
   184, 184, 185, 186, 187, 187, 188,  26, 189, 189, 190,  26, 191, 192, 193,  26,
   194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 195, 194, 196, 194, 196,
   197, 198, 198, 199, 198, 198, 198, 198, 198, 198, 198, 198, 198, 198, 198, 200,
   198, 198, 198, 198, 198, 201, 178, 178, 178, 178, 178, 178, 178, 178, 202,  26,
   203, 203, 203, 204, 203, 205, 203, 205, 206, 203, 207, 207, 207, 208, 209,  26,
   210, 210, 210, 210, 210, 211, 210, 210, 210, 212, 210, 213, 194, 194, 194, 194,
   214, 214, 214, 215, 216, 216, 216, 216, 216, 216, 216, 217, 216, 216, 216, 218,
   216, 219, 216, 219, 216, 220,   9,   9,   9,   9,   9, 221,   9, 222,  26,  26,
   223, 223, 223, 223, 223, 223, 223, 223, 223, 224, 223, 223, 223, 223, 223, 223,
   225, 225, 225, 225, 225, 225, 225, 225, 226, 226, 226, 226, 226, 226, 227, 228,
   229, 229, 229, 229, 229, 229, 229, 230, 229, 231, 232, 232, 232, 232, 232, 232,
    18, 233, 165, 165, 165, 165, 165, 234, 225,  26, 235,   9, 236, 237, 238, 239,
     2,   2,   2,   2, 240, 241,   2,   2,   2,   2,   2, 242, 243, 244,   2, 245,
     2,   2,   2,   2,   2,   2,   2, 246,   9,   9,   9,   9,   9,   9,   9,   9,
    14,  14, 247, 247,  14,  14,  14,  14, 247, 247,  14, 248,  14,  14,  14, 247,
    14,  14,  14,  14,  14,  14, 249,  14, 249,  14, 250, 251,  14,  14, 252, 253,
     0, 254,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0, 256, 257,
     0, 258,   2, 259,   0,   0,   0,   0, 260,  26,   9,   9,   9,   9, 261,  26,
     0,   0,   0,   0, 262, 263,   4,   0,   0, 264,   0,   0,   2,   2,   2,   2,
     2, 265,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0, 260,  26,  26,   0, 266,  26,  26,   0,   0,   0,   0,
   267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 268,   0,
   269, 269, 269, 269, 269, 269, 269, 269, 269, 269, 269, 269,   2,   2,   2,   2,
    17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17, 270, 271,
   165, 165, 165, 165, 166, 167, 272, 272, 272, 272, 272, 272, 272, 273, 274, 273,
   170, 170, 172,  26, 172, 172, 172, 172, 172, 172, 172, 172,  18,  18,  18,  18,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 275,  26,  26,  26,  26,
   276, 276, 276, 277, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 278,  26,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 279,  26,  26,  26,   0,   0,
   280,   0,   0,   0, 281, 282,   0, 283, 284, 285, 285, 285, 285, 285, 285, 285,
   285, 285, 286, 287, 288, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 290,
   291, 292, 292, 292, 292, 292, 293, 169, 169, 169, 169, 169, 169, 169, 169, 169,
   169, 294,   0,   0, 292, 292, 292, 292,   0,   0,   0,   0, 275, 295, 289, 289,
   169, 169, 169, 294,   0,   0,   0,   0,   0,   0,   0,   0, 169, 169, 169, 296,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 289, 289, 289, 289, 289, 297,
   289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289,   0,   0,   0,   0,   0,
   276, 276, 276, 276, 276, 276, 276, 276,   0,   0,   0,   0,   0,   0,   0,   0,
   298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298,
   298, 299, 298, 298, 298, 298, 298, 298, 300,  26, 301, 301, 301, 301, 301, 301,
   302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302, 302,
   302, 302, 302, 302, 302, 303,  26,  26,  18,  18,  18,  18,  18,  18,  18,  18,
    18,  18,  18,  18, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304,  26,
     0,   0,   0,   0, 305,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
     2, 306,   2,   2,   2,   2,   2,   2,   2,   2,   2, 259,  26,  26, 307,   2,
   308, 308, 308, 308, 308, 309,   0, 260, 310, 310, 310, 310, 310, 310, 310,  26,
   311, 311, 311, 311, 311, 311, 311, 311, 312, 313, 311, 314,  52,  52,  52,  52,
   315, 315, 315, 315, 315, 316, 317, 317, 317, 317, 318, 319, 169, 169, 169, 320,
   321, 321, 321, 321, 321, 321, 321, 321, 321, 322, 321, 323, 164, 164, 164, 324,
   325, 325, 325, 325, 325, 325, 326,  26, 325, 327, 325, 328, 164, 164, 164, 164,
   329, 329, 329, 329, 329, 329, 329, 329, 330,  26,  26, 331, 332, 332, 333,  26,
   334, 334, 334,  26, 172, 172,   2,   2,   2,   2,   2, 335, 336, 337, 176, 176,
   176, 176, 176, 176, 176, 176, 176, 176, 332, 332, 332, 332, 332, 338, 332, 339,
   169, 169, 169, 169, 340,  26, 169, 169, 294, 341, 169, 169, 169, 169, 169, 340,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 279, 276, 276,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 342,  26,  26,  26,  26,
   343,  26, 344, 345,  25,  25, 346, 347, 348,  25,  31,  31,  31,  31,  31,  31,
    31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
    31,  31,  31,  31,  31,  31,  31, 349,  31,  31,  31,  31,  31,  31,  31,  31,
    31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  26,  26,  26,  26,  31,  31,
     9,   9,   0, 260,   9, 350,   0,   0,   0,   0, 351,   0, 258, 352, 353,  31,
    31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31, 354,
   355,   0,   0,   0,   1,   2,   2,   3,   1,   2,   2,   3, 356, 289, 288, 289,
   289, 289, 289, 357, 169, 169, 169, 294, 358, 358, 358, 359, 258, 258,  26, 360,
   361, 362, 361, 361, 363, 361, 361, 364, 361, 365, 361, 365,  26,  26,  26,  26,
   361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 366,
   367,   0,   0,   0,   0,   0, 368,   0,  14,  14,  14,  14,  14,  14,  14,  14,
    14, 253,   0, 369, 370,  26,  26,  26,  26,  26,   0,   0,   0,   0,   0, 371,
   372, 372, 372, 373, 374, 374, 374, 374, 374, 374, 375,  26, 376,   0,   0, 352,
   377, 377, 377, 377, 378, 379, 380, 380, 380, 381, 382, 382, 382, 382, 382, 383,
   384, 384, 384, 385, 386, 386, 386, 386, 387, 386, 388,  26,  26,  26,  26,  26,
   389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 390, 390, 390, 390, 390, 390,
   391, 391, 391, 392, 391, 393, 394, 394, 394, 394, 395, 394, 394, 394, 394, 395,
   396, 396, 396, 396, 396,  26, 397, 397, 397, 397, 397, 397, 398, 399, 400, 401,
   400, 401, 402, 400, 403, 400, 403, 404, 405, 405, 405, 405, 405, 405, 406,  26,
   407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407,
   407, 407, 407, 407, 407, 407, 408,  26, 407, 407, 409,  26, 407,  26,  26,  26,
   410,   2,   2,   2,   2,   2, 411, 412,  26,  26,  26,  26,  26,  26,  26,  26,
   413, 414, 415, 415, 415, 415, 416, 417, 418, 418, 419, 418, 420, 420, 420, 420,
   421, 421, 421, 422, 423, 421,  26,  26,  26,  26,  26,  26, 424, 424, 425, 426,
   427, 427, 427, 428, 429, 429, 429, 430, 431, 431, 431, 432,  26,  26,  26,  26,
   433, 433, 433, 433, 434, 434, 434, 435, 434, 434, 436, 434, 434, 434, 434, 434,
   437, 438, 439, 440, 441, 441, 442, 443, 441, 444, 441, 444, 445, 445, 445, 445,
   446, 446, 446, 446,  26,  26,  26,  26, 447, 447, 447, 447, 448, 449, 448,  26,
   450, 450, 450, 450, 450, 450, 451, 452, 453, 453, 454, 453, 455, 455, 456, 455,
   457, 457, 458, 459,  26, 460,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   461, 461, 461, 461, 461, 461, 461, 461, 461, 462,  26,  26,  26,  26,  26,  26,
   463, 463, 463, 463, 463, 463, 464,  26, 463, 463, 463, 463, 463, 463, 464, 465,
   466, 466, 466, 466, 466,  26, 466, 467, 468, 468, 468, 468, 469, 470, 468, 468,
   469, 471,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  31,  31,  31, 472,
   473, 473, 473, 473, 473, 474, 475,  26, 476,  26,  31, 477,  26,  26,  26, 476,
   478, 478, 478, 478, 478,  26, 479, 479, 479, 479, 479, 480,  26,  26, 481, 481,
   481, 482,  26,  26,  26,  26, 483, 483, 483, 484,  26,  26, 485, 485, 486,  26,
   487, 487, 487, 487, 487, 487, 487, 487, 487, 488, 489, 487, 487, 487, 488, 490,
   491, 491, 491, 491, 491, 491, 491, 491, 492, 493, 494, 494, 494, 495, 494, 496,
   497, 497, 497, 497, 497, 497, 498, 497, 497,  26, 499, 499, 499, 499, 500,  26,
   501, 501, 501, 501, 501, 501, 501, 501, 501, 501, 501, 501, 502, 137, 503,  26,
   504, 504, 505, 504, 504, 504, 504, 504, 506,  26,  26,  26,  26,  26,  26,  26,
   507, 508, 509, 510, 509, 511, 512, 512, 512, 512, 512, 512, 512, 513, 512, 514,
   515, 516, 517, 518, 518, 519, 520, 521, 516, 522, 523, 524, 525, 526, 526,  26,
   527, 528, 527, 527, 527, 527, 529, 527, 530, 531, 529, 532, 533,  26,  26,  26,
   534, 534, 534, 534, 534, 534, 534, 534, 534, 534, 534, 535, 536,  26,  26,  26,
   537, 537, 537, 537, 537, 537, 537, 537, 537,  26, 537, 538,  26,  26,  26,  26,
   539, 539, 539, 539, 539, 539, 540, 539, 539, 539, 539, 540,  26,  26,  26,  26,
   541, 541, 541, 541, 541, 541, 541, 541, 542,  26, 541, 543, 198, 544,  26,  26,
   545, 545, 545, 545, 545, 545, 545, 546, 545, 546, 164, 164, 547,  26,  26,  26,
   548, 548, 548, 549, 548, 550, 548, 548, 551,  26,  26,  26,  26,  26,  26,  26,
   552, 552, 552, 552, 552, 552, 552, 553,  26,  26,  26,  26,  26,  26,  26,  26,
    26,  26,  26,  26, 554, 554, 554, 554, 554, 554, 554, 554, 554, 554, 555, 556,
   557, 558, 559, 560, 560, 560, 561, 562, 557,  26, 560, 563,  26,  26,  26,  26,
    26,  26,  26,  26, 564, 565, 564, 564, 564, 564, 564, 565, 566,  26,  26,  26,
   567, 567, 567, 567, 567, 567, 567, 567, 567,  26, 568, 568, 568, 568, 568, 568,
   568, 568, 568, 568, 569,  26, 178, 178, 570, 570, 570, 570, 570, 570, 570, 571,
    52, 572,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 501,  26,  26,  26,
    26,  26,  26,  26,  26,  26,  26,  26, 573, 573, 573, 573, 574,  26, 573, 574,
   575, 576, 575, 575, 575, 575, 577, 575, 578,  26, 575, 575, 575, 579, 580, 580,
   580, 580, 581, 580, 580, 582, 583,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   584, 585, 586, 586, 586, 586, 584, 587, 586,  26, 586, 588, 589, 590, 591, 591,
   591, 592, 593, 594, 591, 595, 596, 596, 596, 596, 596, 597, 596, 598,  26,  26,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 599, 599, 599, 600,
   601, 601, 602, 601, 601, 601, 601, 603, 601, 601, 601, 604,  26,  26,  26,  26,
    26,  26,  26,  26,  26,  26, 605,  26, 107, 107, 107, 107, 107, 107, 606, 607,
   608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608,
   608, 608, 608, 609,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 610, 611,  26,
   608, 608, 608, 608, 608, 608, 608, 608, 612,  26,  26,  26,  26,  26,  26,  26,
    26,  26, 613, 613, 613, 613, 613, 613, 613, 613, 613, 613, 613, 613, 614,  26,
   615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615,
   615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 616,  26, 615, 615, 615, 615,
   615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 615, 617,
   618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618,
   618, 618, 618, 618, 618, 618, 618, 618, 619,  26,  26,  26,  26,  26,  26,  26,
   620, 620, 620, 620, 620, 620, 620, 621,  26,  26,  26,  26,  26,  26,  26,  26,
   304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304, 304,
   304, 304, 304, 304, 304, 304, 304, 622, 623, 623, 623, 624, 623, 625, 626, 626,
   626, 626, 626, 626, 626, 626, 626, 627, 626, 628, 629, 629, 629, 630, 630,  26,
   631, 631, 631, 631, 631, 631, 631, 631, 632,  26, 631, 633, 633, 631, 631, 634,
   631, 631,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    26,  26,  26,  26,  26,  26,  26,  26, 635, 635, 635, 635, 635, 635, 635, 636,
    26,  26,  26,  26,  26,  26,  26,  26, 637, 637, 637, 637, 637, 637, 637, 637,
   637, 637, 637, 638, 639, 639, 639, 640, 639, 639, 641,  26,  26,  26,  26,  26,
   642, 642, 642, 642, 642, 642, 642, 642, 642, 643, 642, 642, 642, 642, 642, 642,
   642, 644, 642, 642,  26,  26,  26,  26,  26,  26,  26,  26, 645,  26, 646,  26,
   647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647,
   648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 648,
   648, 648, 648, 648, 648, 648, 648, 648, 648, 648, 649,  26,  26,  26,  26, 650,
   647, 647, 647, 651,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 647, 652,  26,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 653, 654,
   655, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285,
   285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285,
   285, 285, 285, 285, 656,  26, 657,  26,  26,  26, 658,  26, 659,  26, 660, 660,
   660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660,
   660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 660, 661,
   662, 662, 662, 662, 662, 662, 662, 662, 662, 662, 662, 662, 662, 663, 662, 664,
   662, 665, 662, 666, 352,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 369,
     0,   0,   0,   0,   0,   0, 352, 667,   0,   0, 668,  26,   0,   0, 668,  26,
     9,   9,   9,   9,   9, 221,   9,   9, 669,  26,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0, 352,  26,  26,  26,  26,  26,  26,  26,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 275,  26,
     0,   0,   0,   0, 258, 355,   0,   0,   0,   0,   0,   0, 670, 671,   0, 672,
   673, 674,   0,   0,   0, 675,   0,   0,   0,   0,   0,   0,   0, 266,  26,  26,
    14,  14,  14,  14,  14,  14,  14,  14, 247,  26,  26,  26,  26,  26,  26,  26,
    26,  26,  26,  26,  26,  26,  26,  26,   0,   0, 352,  26,   0,   0, 352,  26,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 258,  26,   0,   0,   0, 668,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,
     0,   0,   0, 255, 676, 677,   0, 678, 679,   0,   0,   0,   0,   0,   0,   0,
   680, 681, 255, 255,   0,   0,   0, 682, 683, 667, 684,   0,   0,   0,   0,   0,
     0,   0,   0,   0, 275,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0, 268,   0,   0,   0,   0,   0,   0,
   685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685, 685,
   685, 686,  26, 687, 688, 685,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     2,   2,   2, 343, 689, 412,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   690, 269, 269, 691, 692, 693,  18,  18,  18,  18,  18,  18,  18, 694,  26,  26,
    26, 695,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   696, 696, 696, 696, 696, 697, 696, 698, 696, 699,  26,  26,  26,  26,  26,  26,
    26,  26, 700, 700, 700, 701,  26,  26, 702, 702, 702, 702, 702, 702, 702, 703,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 704, 704, 704, 704, 704, 705,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 706, 706, 706, 706, 706, 707,
    26,  26,  26,  26,  26,  26,  26,  26, 708, 708, 708, 709, 708, 708, 710, 711,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 172, 712, 170, 172,
   713, 713, 713, 713, 713, 713, 713, 713, 713, 713, 713, 713, 713, 713, 713, 713,
   713, 713, 713, 713, 713, 713, 713, 713, 714, 713, 715,  26,  26,  26,  26,  26,
   716, 716, 716, 716, 716, 716, 716, 716, 716, 717, 716, 718,  26,  26,  26,  26,
    26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 355,   0,
     0,   0,   0,   0,   0,   0, 369,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   355,   0,   0,   0,   0,   0,   0, 275,  26,  26,  26,  26,  26,  26,  26,  26,
   719,  31,  31,  31, 720, 721, 722, 723, 724, 725, 720, 726, 720, 722, 722, 727,
    31, 728,  31, 729, 730, 728,  31, 729,  26,  26,  26,  26,  26,  26, 731,  26,
     0,   0,   0,   0,   0, 352,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0, 352,  26,   0, 258, 355,   0, 355,   0, 355,   0,   0,   0, 275,  26,
     0,   0,   0,   0,   0, 275,  26,  26,  26,  26,  26,  26, 732,   0,   0,   0,
   733,  26,   0,   0,   0,   0,   0, 352,   0, 668, 260,  26, 275,  26,  26,  26,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 734,   0, 369,   0, 369,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 260,   0, 352, 668,  26,
     0, 352,   0,   0,   0,   0,   0,   0,   0,  26,   0, 260,   0,   0,   0,   0,
     0,  26,   0,   0,   0, 275,   0, 352, 260,  26,   0, 668,  26,  26,  26,  26,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  26,   0, 275,   0, 369,
     0, 735,   0,   0,   0,   0,   0,   0, 258, 736,   0, 737,   0, 367,   0, 668,
     0,   0, 351,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 266,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276,  26,  26,  26,  26,
   276, 276, 276, 279, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276,
   276, 276, 276, 276, 276, 279, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 738,  26, 276, 276,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 279,  26,  26,  26,  26,
   276, 276, 276, 279,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 739, 276, 276, 276, 276, 276, 276,
   276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 342,
   740,  26,  26,  26,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
     9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   939, 940, 941, 942, 946, 948,   0, 962, 969, 970, 971, 976,1001,1002,1003,1008,
     0,1033,1040,1041,1042,1043,1047,   0,   0,1080,1081,1082,1086,1110,   0,   0,
  1124,1125,1126,1127,1131,1133,   0,1147,1154,1155,1156,1161,1187,1188,1189,1193,
     0,1219,1226,1227,1228,1229,1233,   0,   0,1267,1268,1269,1273,1298,   0,1303,
   943,1128, 944,1129, 954,1139, 958,1143, 959,1144, 960,1145, 961,1146, 964,1149,
     0,   0, 973,1158, 974,1159, 975,1160, 983,1168, 978,1163, 988,1173, 990,1175,
   991,1176, 993,1178, 994,1179,   0,   0,1004,1190,1005,1191,1006,1192,1014,1199,
  1007,   0,   0,   0,1016,1201,1020,1206,   0,1022,1208,1025,1211,1023,1209,   0,
     0,   0,   0,1032,1218,1037,1223,1035,1221,   0,   0,   0,1044,1230,1045,1231,
  1049,1235,   0,   0,1058,1244,1064,1250,1060,1246,1066,1252,1067,1253,1072,1258,
  1069,1255,1077,1264,1074,1261,   0,   0,1083,1270,1084,1271,1085,1272,1088,1275,
  1089,1276,1096,1283,1103,1290,1111,1299,1115,1118,1307,1120,1309,1121,1310,   0,
  1053,1239,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1093,
  1280,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 949,1134,1010,
  1195,1050,1236,1090,1277,1341,1368,1340,1367,1342,1369,1339,1366,   0,1320,1347,
  1418,1419,1323,1350,   0,   0, 992,1177,1018,1204,1055,1241,1416,1417,1415,1424,
  1202,   0,   0,   0, 987,1172,   0,   0,1031,1217,1321,1348,1322,1349,1338,1365,
   950,1135, 951,1136, 979,1164, 980,1165,1011,1196,1012,1197,1051,1237,1052,1238,
  1061,1247,1062,1248,1091,1278,1092,1279,1071,1257,1076,1263,   0,   0, 997,1182,
     0,   0,   0,   0,   0,   0, 945,1130, 982,1167,1337,1364,1335,1362,1046,1232,
  1422,1423,1113,1301,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     8,   9,   0,  10,1425,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
     0,   0,   0,   0,   0,1314,1427,   5,1434,1438,1443,   0,1450,   0,1455,1461,
  1514,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1446,1458,1468,1476,1480,1486,
  1517,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1489,1503,1494,1500,1508,   0,
     0,   0,   0,1520,1521,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1526,1528,   0,1525,   0,   0,   0,1522,   0,   0,   0,   0,1536,1532,1539,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1534,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1556,   0,   0,   0,   0,   0,   0,
  1548,1550,   0,1547,   0,   0,   0,1567,   0,   0,   0,   0,1558,1554,1561,   0,
     0,   0,   0,   0,   0,   0,1568,1569,   0,   0,   0,   0,   0,   0,   0,   0,
     0,1529,1551,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1523,1545,1524,1546,   0,   0,1527,1549,   0,   0,1570,1571,1530,1552,1531,1553,
     0,   0,1533,1555,1535,1557,1537,1559,   0,   0,1572,1573,1544,1566,1538,1560,
  1540,1562,1541,1563,1542,1564,   0,   0,1543,1565,   0,   0,   0,   0,   0,   0,
     0,   0,1606,1607,1609,1608,1610,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1613,   0,1611,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,1612,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1620,   0,   0,   0,   0,   0,   0,
     0,1623,   0,   0,1624,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,1614,1615,1616,1617,1618,1619,1621,1622,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1628,1629,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1625,1626,   0,1627,
     0,   0,   0,1634,   0,   0,1635,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1630,1631,1632,   0,   0,1633,   0,
     0,   0,   0,   0,   0,   0,   0,   0,1639,   0,   0,1638,1640,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1636,1637,   0,   0,
     0,   0,   0,   0,1641,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1642,1644,1643,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,1645,   0,   0,   0,   0,   0,   0,   0,
  1646,   0,   0,   0,   0,   0,   0,1648,1649,   0,1647,1650,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1651,1653,1652,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1654,   0,1655,1657,1656,   0,
     0,   0,   0,1659,   0,   0,   0,   0,   0,   0,   0,   0,   0,1660,   0,   0,
     0,   0,1661,   0,   0,   0,   0,1662,   0,   0,   0,   0,1663,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1658,   0,   0,   0,   0,   0,   0,
     0,   0,   0,1664,   0,1665,1673,   0,1674,   0,   0,   0,   0,   0,   0,   0,
     0,1666,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,1668,   0,   0,   0,   0,   0,   0,   0,   0,   0,1669,   0,   0,
     0,   0,1670,   0,   0,   0,   0,1671,   0,   0,   0,   0,1672,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1667,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,1675,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,1676,   0,1677,   0,1678,   0,1679,   0,1680,   0,
     0,   0,1681,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1682,   0,1683,   0,   0,
  1684,1685,   0,1686,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   953,1138, 955,1140, 956,1141, 957,1142,1324,1351, 963,1148, 965,1150, 968,1153,
   966,1151, 967,1152,1378,1380,1379,1381, 984,1169, 985,1170,1420,1421, 986,1171,
   989,1174, 995,1180, 998,1183, 996,1181, 999,1184,1000,1185,1015,1200,1329,1356,
  1017,1203,1019,1205,1021,1207,1024,1210,1687,1688,1027,1213,1026,1212,1028,1214,
  1029,1215,1030,1216,1034,1220,1036,1222,1039,1225,1038,1224,1334,1361,1336,1363,
  1382,1384,1383,1385,1056,1242,1057,1243,1059,1245,1063,1249,1689,1690,1065,1251,
  1068,1254,1070,1256,1386,1387,1388,1389,1691,1692,1073,1259,1075,1262,1079,1266,
  1078,1265,1095,1282,1098,1285,1097,1284,1390,1391,1392,1393,1099,1286,1100,1287,
  1101,1288,1102,1289,1105,1292,1104,1291,1106,1294,1107,1295,1108,1296,1114,1302,
  1119,1308,1122,1311,1123,1312,1186,1260,1293,1305,   0,1394,   0,   0,   0,   0,
   952,1137, 947,1132,1317,1344,1316,1343,1319,1346,1318,1345,1693,1695,1371,1375,
  1370,1374,1373,1377,1372,1376,1694,1696, 981,1166, 977,1162, 972,1157,1326,1353,
  1325,1352,1328,1355,1327,1354,1697,1698,1009,1194,1013,1198,1054,1240,1048,1234,
  1331,1358,1330,1357,1333,1360,1332,1359,1699,1700,1396,1401,1395,1400,1398,1403,
  1397,1402,1399,1404,1094,1281,1087,1274,1406,1411,1405,1410,1408,1413,1407,1412,
  1409,1414,1109,1297,1117,1306,1116,1304,1112,1300,   0,   0,   0,   0,   0,   0,
  1471,1472,1701,1705,1702,1706,1703,1707,1430,1431,1715,1719,1716,1720,1717,1721,
  1477,1478,1729,1731,1730,1732,   0,   0,1435,1436,1733,1735,1734,1736,   0,   0,
  1481,1482,1737,1741,1738,1742,1739,1743,1439,1440,1751,1755,1752,1756,1753,1757,
  1490,1491,1765,1768,1766,1769,1767,1770,1447,1448,1771,1774,1772,1775,1773,1776,
  1495,1496,1777,1779,1778,1780,   0,   0,1451,1452,1781,1783,1782,1784,   0,   0,
  1504,1505,1785,1788,1786,1789,1787,1790,   0,1459,   0,1791,   0,1792,   0,1793,
  1509,1510,1794,1798,1795,1799,1796,1800,1462,1463,1808,1812,1809,1813,1810,1814,
  1467,  21,1475,  22,1479,  23,1485,  24,1493,  27,1499,  28,1507,  29,   0,   0,
  1704,1708,1709,1710,1711,1712,1713,1714,1718,1722,1723,1724,1725,1726,1727,1728,
  1740,1744,1745,1746,1747,1748,1749,1750,1754,1758,1759,1760,1761,1762,1763,1764,
  1797,1801,1802,1803,1804,1805,1806,1807,1811,1815,1816,1817,1818,1819,1820,1821,
  1470,1469,1822,1474,1465,   0,1473,1825,1429,1428,1426,  12,1432,   0,  26,   0,
     0,1315,1823,1484,1466,   0,1483,1829,1433,  13,1437,  14,1441,1826,1827,1828,
  1488,1487,1513,  19,   0,   0,1492,1515,1445,1444,1442,  15,   0,1831,1832,1833,
  1502,1501,1516,  25,1497,1498,1506,1518,1457,1456,1454,  17,1453,1313,  11,   3,
     0,   0,1824,1512,1519,   0,1511,1830,1449,  16,1460,  18,1464,   4,   0,   0,
    30,  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,  20,   0,   0,   0,   2,   6,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1834,1835,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1836,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1837,1839,1838,
     0,   0,   0,   0,1840,   0,   0,   0,   0,1841,   0,   0,1842,   0,   0,   0,
     0,   0,   0,   0,1843,   0,1844,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,1845,   0,   0,1846,   0,   0,1847,   0,1848,   0,   0,   0,   0,   0,   0,
   937,   0,1850,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1849, 936, 938,
  1851,1852,   0,   0,1853,1854,   0,   0,1855,1856,   0,   0,   0,   0,   0,   0,
  1857,1858,   0,   0,1861,1862,   0,   0,1863,1864,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1867,1868,1869,1870,
  1859,1860,1865,1866,   0,   0,   0,   0,   0,   0,1871,1872,1873,1874,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,  32,  33,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1875,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1877,   0,1878,   0,
  1879,   0,1880,   0,1881,   0,1882,   0,1883,   0,1884,   0,1885,   0,1886,   0,
  1887,   0,1888,   0,   0,1889,   0,1890,   0,1891,   0,   0,   0,   0,   0,   0,
  1892,1893,   0,1894,1895,   0,1896,1897,   0,1898,1899,   0,1900,1901,   0,   0,
     0,   0,   0,   0,1876,   0,   0,   0,   0,   0,   0,   0,   0,   0,1902,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1904,   0,1905,   0,
  1906,   0,1907,   0,1908,   0,1909,   0,1910,   0,1911,   0,1912,   0,1913,   0,
  1914,   0,1915,   0,   0,1916,   0,1917,   0,1918,   0,   0,   0,   0,   0,   0,
  1919,1920,   0,1921,1922,   0,1923,1924,   0,1925,1926,   0,1927,1928,   0,   0,
     0,   0,   0,   0,1903,   0,   0,1929,1930,1931,1932,   0,   0,   0,1933,   0,
   710, 385, 724, 715, 455, 103, 186, 825, 825, 242, 751, 205, 241, 336, 524, 601,
   663, 676, 688, 738, 411, 434, 474, 500, 649, 746, 799, 108, 180, 416, 482, 662,
   810, 275, 462, 658, 692, 344, 618, 679, 293, 388, 440, 492, 740, 116, 146, 168,
   368, 414, 481, 527, 606, 660, 665, 722, 781, 803, 809, 538, 553, 588, 642, 758,
   811, 701, 233, 299, 573, 612, 487, 540, 714, 779, 232, 267, 412, 445, 457, 585,
   594, 766, 167, 613, 149, 148, 560, 589, 648, 768, 708, 345, 411, 704, 105, 259,
   313, 496, 518, 174, 542, 120, 307, 101, 430, 372, 584, 183, 228, 529, 650, 697,
   424, 732, 428, 349, 632, 355, 517, 110, 135, 147, 403, 580, 624, 700, 750, 170,
   193, 245, 297, 374, 463, 543, 763, 801, 812, 815, 162, 384, 420, 730, 287, 330,
   337, 366, 459, 476, 509, 558, 591, 610, 726, 652, 734, 759, 154, 163, 198, 473,
   683, 697, 292, 311, 353, 423, 572, 494, 113, 217, 259, 280, 314, 499, 506, 603,
   608, 752, 778, 782, 788, 117, 557, 748, 774, 320, 109, 126, 260, 265, 373, 411,
   479, 523, 655, 737, 823, 380, 765, 161, 395, 398, 438, 451, 502, 516, 537, 583,
   791, 136, 340, 769, 122, 273, 446, 727, 305, 322, 400, 496, 771, 155, 190, 269,
   377, 391, 406, 432, 501, 519, 599, 684, 687, 749, 776, 175, 452, 191, 480, 510,
   659, 772, 805, 813, 397, 444, 619, 566, 568, 575, 491, 471, 707, 111, 636, 156,
   153, 288, 346, 578, 256, 435, 383, 729, 680, 767, 694, 295, 128, 210,   0,   0,
   227,   0, 379,   0,   0, 150, 493, 525, 544, 551, 552, 556, 783, 576, 604,   0,
   661,   0, 703,   0,   0, 735, 743,   0,   0,   0, 793, 794, 795, 808, 741, 773,
   118, 127, 130, 166, 169, 177, 207, 213, 215, 226, 229, 268, 270, 317, 327, 329,
   335, 369, 375, 381, 404, 441, 448, 458, 477, 484, 503, 539, 545, 547, 546, 548,
   549, 550, 554, 555, 561, 564, 569, 591, 593, 595, 598, 607, 620, 625, 625, 651,
   690, 695, 705, 706, 716, 717, 733, 735, 777, 786, 790, 315, 869, 623,   0,   0,
   102, 145, 134, 115, 129, 138, 165, 171, 207, 202, 206, 212, 227, 231, 240, 243,
   250, 254, 294, 296, 303, 308, 319, 325, 321, 329, 326, 335, 341, 357, 360, 362,
   370, 379, 388, 389, 393, 421, 424, 438, 456, 454, 458, 465, 477, 535, 485, 490,
   493, 507, 512, 514, 521, 522, 525, 526, 528, 533, 532, 541, 565, 569, 574, 586,
   591, 597, 607, 637, 647, 674, 691, 693, 695, 698, 703, 699, 705, 704, 702, 706,
   709, 717, 728, 736, 747, 754, 770, 777, 783, 784, 786, 787, 790, 802, 825, 848,
   847, 857,  55,  65,  66, 883, 892, 916, 822, 824,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1586,   0,1605,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1602,1603,1934,1935,1574,1575,
  1576,1577,1579,1580,1581,1583,1584,   0,1585,1587,1588,1589,1591,   0,1592,   0,
  1593,1594,   0,1595,1596,   0,1598,1599,1600,1601,1604,1582,1578,1590,1597,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,1936,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,1937,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1938,   0,1939,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1940,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1941,1942,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1943,1944,   0,   0,   0,
     0,   0,   0,1945,   0,1946,   0,   0,   0,   0,   0,   0,   0,   0,1947,   0,
     0,1948,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,1950,   0,1949,1951,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1953,1952,   0,1954,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1955,1956,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,1957,   0,   0,   0,   0,   0,   0,   0,
     0,1958,1961,1959,1965,1960,1962,1964,1963,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,1967,1966,1968,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1969,1970,
  1971,1972,1973,1974,1975,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,1976,1977,1978,1980,1979,
  1981,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   106, 104, 107, 826, 114, 118, 119, 121, 123, 124, 127, 125,  34, 830, 130, 131,
   132, 137, 827,  35, 133, 139, 829, 142, 143, 112, 144, 145, 924, 151, 152,  37,
   157, 158, 159, 160,  38, 165, 166, 169, 171, 172, 173, 174, 176, 177, 178, 179,
   181, 182, 182, 182, 833, 468, 184, 185, 834, 187, 188, 189, 196, 192, 194, 195,
   197, 199, 200, 201, 203, 204, 204, 206, 208, 209, 211, 218, 213, 219, 214, 216,
   153, 234, 221, 222, 223, 220, 225, 224, 230, 835, 235, 236, 237, 238, 239, 244,
   836, 837, 247, 248, 249, 246, 251,  39,  40, 253, 255, 255, 838, 257, 258, 259,
   261, 839, 262, 263, 301, 264,  41, 266, 270, 272, 271, 841, 274, 842, 277, 276,
   278, 281, 282,  42, 283, 284, 285, 286,  43, 843,  44, 289, 290, 291, 293, 934,
   298, 845, 845, 621, 300, 300,  45, 852, 894, 302, 304,  46, 306, 309, 310, 312,
   316,  48,  47, 317, 846, 318, 323, 324, 325, 324, 328, 329, 333, 331, 332, 334,
   335, 336, 338, 339, 342, 343, 347, 351, 849, 350, 348, 352, 354, 359, 850, 361,
   358, 356,  49, 363, 365, 367, 364,  50, 369, 371, 851, 376, 386, 378,  53, 381,
    52,  51, 140, 141, 387, 382, 614,  78, 388, 389, 390, 394, 392, 856,  54, 399,
   396, 402, 404, 858, 405, 401, 407,  55, 408, 409, 410, 413, 859, 415,  56, 417,
   860, 418,  57, 419, 422, 424, 425, 861, 840, 862, 426, 863, 429, 431, 427, 433,
   437, 441, 438, 439, 442, 443, 864, 436, 449, 450,  58, 454, 453, 865, 447, 460,
   866, 867, 461, 466, 465, 464,  59, 467, 470, 469, 472, 828, 475, 868, 478, 870,
   483, 485, 486, 871, 488, 489, 872, 873, 495, 497,  60, 498,  61,  61, 504, 505,
   507, 508, 511,  62, 513, 874, 515, 875, 518, 844, 520, 876, 877, 878,  63,  64,
   528, 880, 879, 881, 882, 530, 531, 531, 533,  66, 534,  67,  68, 884, 536, 538,
   541,  69, 885, 549, 886, 887, 556, 559,  70, 561, 562, 563, 888, 889, 889, 567,
    71, 890, 570, 571,  72, 891, 577,  73, 581, 579, 582, 893, 587,  74, 590, 592,
   596,  75, 895, 896,  76, 897, 600, 898, 602, 605, 607, 899, 900, 609, 901, 611,
   853,  77, 615, 616,  79, 617, 252, 902, 903, 854, 855, 621, 622, 731,  80, 627,
   626, 628, 164, 629, 630, 631, 633, 904, 632, 634, 639, 640, 635, 641, 646, 651,
   638, 643, 644, 645, 905, 907, 906,  81, 653, 654, 656, 911, 657, 908,  82,  83,
   909, 910,  84, 664, 665, 666, 667, 669, 668, 671, 670, 674, 672, 673, 675,  85,
   677, 678,  86, 681, 682, 912, 685, 686,  87, 689,  36, 913, 914,  88,  89, 696,
   702, 709, 711, 915, 712, 713, 718, 719, 917, 831, 721, 720, 723, 832, 725, 728,
   918, 919, 739, 742, 744, 920, 745, 753, 756, 757, 755, 760, 761, 921, 762,  90,
   764, 922,  91, 775, 279, 780, 923, 925,  92,  93, 785, 926,  94, 927, 787, 787,
   789, 928, 792,  95, 796, 797, 798, 800,  96, 929, 802, 804, 806,  97,  98, 807,
   930,  99, 931, 932, 933, 814, 100, 816, 817, 818, 819, 820, 821, 935,   0,   0,
];
static _hb_ucd_i16: [i16; 196]=
[
      0,    0,    0,    0,    1,   -1,    0,    0,    2,    0,   -2,    0,    0,    0,    0,    2,
      0,   -2,    0,    0,    0,    0,    0,   16,    0,    0,    0,  -16,    0,    0,    1,   -1,
      0,    0,    0,    1,   -1,    0,    0,    0,    0,    1,   -1,    0,    3,    3,    3,   -3,
     -3,   -3,    0,    0,    0, 2016,    0,    0,    0,    0,    0, 2527, 1923, 1914, 1918,    0,
   2250,    0,    0,    0,    0,    0,    0,  138,    0,    7,    0,    0,   -7,    0,    0,    0,
      1,   -1,    1,   -1,   -1,    1,   -1,    0, 1824,    0,    0,    0,    0,    0, 2104,    0,
   2108, 2106,    0, 2106, 1316,    0,    0,    0,    0,    1,   -1,    1,   -1, -138,    0,    0,
      1,   -1,    8,    8,    8,    0,    7,    7,    0,    0,   -8,   -8,   -8,   -7,   -7,    0,
      1,   -1,    0,    2,-1316,    1,   -1,    0,   -1,    1,   -1,    1,   -1,    3,    1,   -1,
     -3,    1,   -1,    1,   -1,    0,    0,-1914,-1918,    0,    0,-1923,-1824,    0,    0,    0,
      0,-2016,    0,    0,    1,   -1,    0,    1,    0,    0,-2104,    0,    0,    0,    0,-2106,
  -2108,-2106,    0,    0,    1,   -1,-2250,    0,    0,    0,-2527,    0,    0,   -2,    0,    1,
     -1,    0,    1,   -1,
];

pub(crate) fn _hb_ucd_gc (u: usize) -> u8
{
  if u<1114110 { _hb_ucd_u8[7920usize+((((_hb_ucd_u8[2176usize+((((_hb_ucd_u16[(((_hb_ucd_u8[((((((u)>>1))>>3))>>5) as usize]) as usize)<<5) as usize+((((((u)>>1))>>3))&31) as usize]) as usize)<<3) as usize+((((u)>>1))&7) as usize) as usize]) as usize)<<1) as usize+((u)&1) as usize) as usize] } else { 2 }
}
pub(crate) fn _hb_ucd_ccc (u: usize) -> u8
{
  if u<125259 { _hb_ucd_u8[10388usize+((((_hb_ucd_u8[9284usize+((((_hb_ucd_u8[8548usize+((((_hb_ucd_u8[8302usize+(((((((u)>>2))>>3))>>4) as usize) as usize]) as usize)<<4) as usize+((((((u)>>2))>>3))&15) as usize) as usize]) as usize)<<3) as usize+((((u)>>2))&7) as usize) as usize]) as usize)<<2) as usize+((u)&3) as usize) as usize] } else { 0 }
}
fn _hb_ucd_b4 (a: &[u8], i: usize) -> u8
{
  (a[i>>1]>>((i&1)<<2))&15
}
pub(crate) fn _hb_ucd_bmg (u: usize) -> i16
{
  if u<65380 { _hb_ucd_i16[(((_hb_ucd_u8[11140usize+((((_hb_ucd_u8[11020usize+((((_hb_ucd_b4(&_hb_ucd_u8[10892usize..],((((((u)>>2))>>3))>>3) as usize)) as usize)<<3) as usize+((((((u)>>2))>>3))&7) as usize) as usize]) as usize)<<3) as usize+((((u)>>2))&7) as usize) as usize]) as usize)<<2) as usize+((u)&3) as usize] } else { 0 }
}
pub(crate) fn _hb_ucd_sc (u: usize) -> u8
{
  if u<918000 { _hb_ucd_u8[12662usize+((((_hb_ucd_u16[3328usize+((((_hb_ucd_u8[11926usize+((((_hb_ucd_u8[11476usize+(((((((u)>>3))>>4))>>4) as usize) as usize]) as usize)<<4) as usize+((((((u)>>3))>>4))&15) as usize) as usize]) as usize)<<4) as usize+((((u)>>3))&15) as usize) as usize]) as usize)<<3) as usize+((u)&7) as usize) as usize] } else { 2 }
}
pub(crate) fn _hb_ucd_dm (u: usize) -> u16
{
  if u<195102 { _hb_ucd_u16[7408usize+((((_hb_ucd_u8[18972usize+((((_hb_ucd_u8[18590usize+(((((u)>>4))>>5) as usize) as usize]) as usize)<<5) as usize+((((u)>>4))&31) as usize) as usize]) as usize)<<4) as usize+((u)&15) as usize) as usize] } else { 0 }
}

}

/* == End of generated table == */
