#include "qgsexpression.h"

void QgsExpression::buildFunctionHelp()
{


  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$area" ),
    Help( QStringLiteral( "$area" ), tr( "function" ), tr( "Returns the area of the current feature. The area calculated by this function respects both the current project's ellipsoid setting and area unit settings. For example, if an ellipsoid has been set for the project then the calculated area will be ellipsoidal, and if no ellipsoid is set then the calculated area will be planimetric." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$area" ), tr( "Returns the area of the current feature. The area calculated by this function respects both the current project's ellipsoid setting and area unit settings. For example, if an ellipsoid has been set for the project then the calculated area will be ellipsoidal, and if no ellipsoid is set then the calculated area will be planimetric." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$area" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "planimetric,current,area,surface,project,settings,ellipsoid,setting,calculated" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$currentfeature" ),
    Help( QStringLiteral( "$currentfeature" ), tr( "function" ), tr( "Returns the current feature being evaluated. This can be used with the 'attribute' function to evaluate attribute values from the current feature. <b>WARNING: This function is deprecated. It is recommended to use the replacement @feature variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$currentfeature" ), tr( "Returns the current feature being evaluated. This can be used with the 'attribute' function to evaluate attribute values from the current feature. <b>WARNING: This function is deprecated. It is recommended to use the replacement @feature variable instead.</b>" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "attribute( $currentfeature, 'name' )" ), tr( "value stored in 'name' attribute for the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "evaluated,attribute,current,evaluate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$face_area" ),
    Help( QStringLiteral( "$face_area" ), tr( "function" ), tr( "Returns the area of the current mesh face. The area calculated by this function respects both the current project's ellipsoid setting and area unit settings. For example, if an ellipsoid has been set for the project then the calculated area will be ellipsoidal, and if no ellipsoid is set then the calculated area will be planimetric." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$face_area" ), tr( "Returns the area of the current mesh face. The area calculated by this function respects both the current project's ellipsoid setting and area unit settings. For example, if an ellipsoid has been set for the project then the calculated area will be ellipsoidal, and if no ellipsoid is set then the calculated area will be planimetric." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$face_area" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "planimetric,mesh,current,area,surface,project,settings,face,ellipsoid,setting,calculated,set" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$face_index" ),
    Help( QStringLiteral( "$face_index" ), tr( "function" ), tr( "Returns the index of the current mesh face. " ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$face_index" ), tr( "Returns the index of the current mesh face. " ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$face_index" ), tr( "4581" ), QString() ),
          QString(),
          QStringList()
            << tr( "index,mesh,face,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$geometry" ),
    Help( QStringLiteral( "$geometry" ), tr( "function" ), tr( "Returns the geometry of the current feature. Can be used for processing with other functions. <b>WARNING: This function is deprecated. It is recommended to use the replacement @geometry variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$geometry" ), tr( "Returns the geometry of the current feature. Can be used for processing with other functions. <b>WARNING: This function is deprecated. It is recommended to use the replacement @geometry variable instead.</b>" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( $geometry )" ), tr( "'POINT(6 50)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "current,processing,functions" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$id" ),
    Help( QStringLiteral( "$id" ), tr( "function" ), tr( "Returns the feature id of the current row. <b>WARNING: This function is deprecated. It is recommended to use the replacement @id variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$id" ), tr( "Returns the feature id of the current row. <b>WARNING: This function is deprecated. It is recommended to use the replacement @id variable instead.</b>" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$id" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "row,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$length" ),
    Help( QStringLiteral( "$length" ), tr( "function" ), tr( "Returns the length of a linestring. If you need the length of a border of a polygon, use $perimeter instead. The length calculated by this function respects both the current project's ellipsoid setting and distance unit settings. For example, if an ellipsoid has been set for the project then the calculated length will be ellipsoidal, and if no ellipsoid is set then the calculated length will be planimetric." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$length" ), tr( "Returns the length of a linestring. If you need the length of a border of a polygon, use $perimeter instead. The length calculated by this function respects both the current project's ellipsoid setting and distance unit settings. For example, if an ellipsoid has been set for the project then the calculated length will be ellipsoidal, and if no ellipsoid is set then the calculated length will be planimetric." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$length" ), tr( "42.4711" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,planimetric,length,perimeter,current,linestring,project,settings,ellipsoid,border,setting,calculated" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$perimeter" ),
    Help( QStringLiteral( "$perimeter" ), tr( "function" ), tr( "Returns the perimeter length of the current feature. The perimeter calculated by this function respects both the current project's ellipsoid setting and distance unit settings. For example, if an ellipsoid has been set for the project then the calculated perimeter will be ellipsoidal, and if no ellipsoid is set then the calculated perimeter will be planimetric." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$perimeter" ), tr( "Returns the perimeter length of the current feature. The perimeter calculated by this function respects both the current project's ellipsoid setting and distance unit settings. For example, if an ellipsoid has been set for the project then the calculated perimeter will be ellipsoidal, and if no ellipsoid is set then the calculated perimeter will be planimetric." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$perimeter" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,planimetric,length,perimeter,current,polygon,project,settings,ellipsoid,setting,calculated" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$scale" ),
    Help( QStringLiteral( "$scale" ), tr( "function" ), tr( "Returns the current scale denominator of the map canvas.<br><br>Note: This function is only available in some contexts and will be 0 otherwise." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$scale" ), tr( "Returns the current scale denominator of the map canvas.<br><br>Note: This function is only available in some contexts and will be 0 otherwise." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$scale" ), tr( "10000" ), QString() ),
          QString(),
          QStringList()
            << tr( "denominator,contexts,current,scale,canvas,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$vertex_as_point" ),
    Help( QStringLiteral( "$vertex_as_point" ), tr( "function" ), tr( "Returns the current vertex as a point geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$vertex_as_point" ), tr( "Returns the current vertex as a point geometry." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( $vertex_as_point )" ), tr( "'POINT(800 1500 41)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "point,mesh,vertex,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$vertex_index" ),
    Help( QStringLiteral( "$vertex_index" ), tr( "function" ), tr( "Returns the index of the current mesh vertex." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$vertex_index" ), tr( "Returns the index of the current mesh vertex." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$vertex_index" ), tr( "9874" ), QString() ),
          QString(),
          QStringList()
            << tr( "index,mesh,vertex,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$vertex_x" ),
    Help( QStringLiteral( "$vertex_x" ), tr( "function" ), tr( "Returns the X coordinate of the current mesh vertex." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$vertex_x" ), tr( "Returns the X coordinate of the current mesh vertex." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$vertex_x" ), tr( "42.12" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,mesh,vertex,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$vertex_y" ),
    Help( QStringLiteral( "$vertex_y" ), tr( "function" ), tr( "Returns the Y coordinate of the current mesh vertex." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$vertex_y" ), tr( "Returns the Y coordinate of the current mesh vertex." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$vertex_y" ), tr( "12.24" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,mesh,vertex,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$vertex_z" ),
    Help( QStringLiteral( "$vertex_z" ), tr( "function" ), tr( "Returns the Z value of the current mesh vertex." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$vertex_z" ), tr( "Returns the Z value of the current mesh vertex." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$vertex_z" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "mesh,vertex,current" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$x" ),
    Help( QStringLiteral( "$x" ), tr( "function" ), tr( "Returns the x coordinate of the current point feature. If the feature is a multipoint feature, then the x-coordinate of the first point will be returned. <b>WARNING: This function is deprecated. It is recommended to use the replacement x() function with @geometry variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$x" ), tr( "Returns the x coordinate of the current point feature. If the feature is a multipoint feature, then the x-coordinate of the first point will be returned. <b>WARNING: This function is deprecated. It is recommended to use the replacement x() function with @geometry variable instead.</b>" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$x" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "first,point,coordinate,current,multipoint" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$x_at" ),
    Help( QStringLiteral( "$x_at" ), tr( "function" ), tr( "Retrieves a x coordinate of the current feature's geometry. <b>WARNING: This function is deprecated. It is recommended to use the replacement x_at function with @geometry variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$x_at" ), tr( "Retrieves a x coordinate of the current feature's geometry. <b>WARNING: This function is deprecated. It is recommended to use the replacement x_at function with @geometry variable instead.</b>" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "vertex" ), tr( "index of the vertex of the current geometry (indices start at 0; negative values apply from the last index, starting at -1)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$x_at(1)" ), tr( "5" ), QString() ),
          QString(),
          QStringList()
            << tr( "current,retrieves,feature,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$y" ),
    Help( QStringLiteral( "$y" ), tr( "function" ), tr( "Returns the y coordinate of the current point feature. If the feature is a multipoint feature, then the y-coordinate of the first point will be returned. <b>WARNING: This function is deprecated. It is recommended to use the replacement y() function with @geometry variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$y" ), tr( "Returns the y coordinate of the current point feature. If the feature is a multipoint feature, then the y-coordinate of the first point will be returned. <b>WARNING: This function is deprecated. It is recommended to use the replacement y() function with @geometry variable instead.</b>" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$y" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "first,point,coordinate,current,multipoint" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$y_at" ),
    Help( QStringLiteral( "$y_at" ), tr( "function" ), tr( "Retrieves a y coordinate of the current feature's geometry. <b>WARNING: This function is deprecated. It is recommended to use the replacement y_at function with @geometry variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$y_at" ), tr( "Retrieves a y coordinate of the current feature's geometry. <b>WARNING: This function is deprecated. It is recommended to use the replacement y_at function with @geometry variable instead.</b>" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "vertex" ), tr( "index of the vertex of the current geometry (indices start at 0; negative values apply from the last index, starting at -1)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$y_at(1)" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "current,retrieves,feature,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "$z" ),
    Help( QStringLiteral( "$z" ), tr( "function" ), tr( "Returns the z value of the current point feature if it is 3D. If the feature is a multipoint feature, then the z value of the first point will be returned. <b>WARNING: This function is deprecated. It is recommended to use the replacement z() function with @geometry variable instead.</b>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "$z" ), tr( "Returns the z value of the current point feature if it is 3D. If the feature is a multipoint feature, then the z value of the first point will be returned. <b>WARNING: This function is deprecated. It is recommended to use the replacement z() function with @geometry variable instead.</b>" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "$z" ), tr( "123" ), QString() ),
          QString(),
          QStringList()
            << tr( "first,point,current,multipoint,altitude,3D" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "AND" ),
    Help( QStringLiteral( "AND" ), tr( "operator" ), tr( "Returns TRUE when conditions a and b are true." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "AND" ), tr( "Returns TRUE when conditions a and b are true." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "condition" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "condition" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "TRUE AND TRUE" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "TRUE AND FALSE" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "4 = 2+2 AND 1 = 1" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 = 2+2 AND 1 = 2" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "condition" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Aggregates" ),
    Help( QStringLiteral( "Aggregates" ), tr( "group" ), tr( "Contains functions which aggregate values over layers and fields." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Aggregates" ), tr( "Contains functions which aggregate values over layers and fields." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Arrays" ),
    Help( QStringLiteral( "Arrays" ), tr( "group" ), tr( "This group contains expression functions for the creation and manipulation of arrays (also known as list data structures). The order of values within the array matters, in contrary to the 'map' data structure, where the order of key-value pairs is irrelevant and values are identified by their keys." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Arrays" ), tr( "This group contains expression functions for the creation and manipulation of arrays (also known as list data structures). The order of values within the array matters, in contrary to the 'map' data structure, where the order of key-value pairs is irrelevant and values are identified by their keys." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "BETWEEN" ),
    Help( QStringLiteral( "BETWEEN" ), tr( "operator" ), tr( "Returns TRUE if value is within the specified range. The range is considered inclusive of the bounds. To test for exclusion NOT BETWEEN can be used." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "BETWEEN" ), tr( "Returns TRUE if value is within the specified range. The range is considered inclusive of the bounds. To test for exclusion NOT BETWEEN can be used." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "the value to compare with a range. It can be a string, a number or a date." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "lower_bound AND higher_bound" ), tr( "range bounds" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'B' BETWEEN 'A' AND 'C'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "2 BETWEEN 1 AND 3" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "2 BETWEEN 2 AND 3" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'B' BETWEEN 'a' AND 'c'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "lower('B') BETWEEN 'a' AND 'b'" ), tr( "TRUE" ), QString() ),
          tr( "<i>value BETWEEN lower_bound AND higher_bound</i> is the same as \"<i>value &gt;= lower_bound AND value &lt;= higher_bound</i>\"." ),
          QStringList()
            << tr( "bound,contained,found,include,range,within" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "CASE" ),
    Help( QStringLiteral( "CASE" ), tr( "expression" ), tr( "CASE is used to evaluate a series of conditions and return a result for the first condition met. The conditions are evaluated sequentially, and if a condition is true, the evaluation stops, and the corresponding result is returned. If none of the conditions are true, the value in the ELSE clause is returned. Furthermore, if no ELSE clause is set and none of the conditions are met, NULL is returned.<br><pre>CASE<br>WHEN <i>condition</i> THEN <i>result</i><br>[ …n ]<br>[ ELSE <i>result</i> ]<br>END</pre>[ ] marks optional components<br>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "CASE" ), tr( "CASE is used to evaluate a series of conditions and return a result for the first condition met. The conditions are evaluated sequentially, and if a condition is true, the evaluation stops, and the corresponding result is returned. If none of the conditions are true, the value in the ELSE clause is returned. Furthermore, if no ELSE clause is set and none of the conditions are met, NULL is returned.<br><pre>CASE<br>WHEN <i>condition</i> THEN <i>result</i><br>[ …n ]<br>[ ELSE <i>result</i> ]<br>END</pre>[ ] marks optional components<br>" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "WHEN condition" ), tr( "A condition expression to evaluate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "THEN result" ), tr( "If <i>condition</i> evaluates to True then <i>result</i> is evaluated and returned." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "ELSE result" ), tr( "If none of the above conditions evaluated to True then <i>result</i> is evaluated and returned." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "CASE WHEN \"name\" IS NULL THEN 'None' END" ), tr( "Returns the string 'None' if the \"name\" field is NULL" ), QString() )
            << HelpExample( tr( "CASE WHEN $area > 10000 THEN 'Big property' WHEN $area > 5000 THEN 'Medium property' ELSE 'Small property' END" ), tr( "Returns the string 'Big property' if the area is bigger than 10000, 'Medium property' if the area is between 5000 and 10000, and 'Small property' for others" ), QString() ),
          QString(),
          QStringList()
            << tr( "casewhen,clause,series,met,first,corresponding,end,none,evaluated,components,conditions,optional,marks,return,evaluation,else,case,evaluate,result,stops,condition,set" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "CRS" ),
    Help( QStringLiteral( "CRS" ), tr( "group" ), tr( "This group contains functions to operate on coordinate reference system objects." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "CRS" ), tr( "This group contains functions to operate on coordinate reference system objects." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Color" ),
    Help( QStringLiteral( "Color" ), tr( "group" ), tr( "This group contains functions for manipulating colors" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Color" ), tr( "This group contains functions for manipulating colors" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Conditionals" ),
    Help( QStringLiteral( "Conditionals" ), tr( "group" ), tr( "This group contains functions to handle conditional checks in expressions." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Conditionals" ), tr( "This group contains functions to handle conditional checks in expressions." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Conversions" ),
    Help( QStringLiteral( "Conversions" ), tr( "group" ), tr( "This group contains functions to convert on data type to another e.g string to integer, integer to string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Conversions" ), tr( "This group contains functions to convert on data type to another e.g string to integer, integer to string." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Custom" ),
    Help( QStringLiteral( "Custom" ), tr( "group" ), tr( "This group contains custom user-created Python functions." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Custom" ), tr( "This group contains custom user-created Python functions." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Date and Time" ),
    Help( QStringLiteral( "Date and Time" ), tr( "group" ), tr( "This group contains functions for handling date and time data." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Date and Time" ), tr( "This group contains functions for handling date and time data." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Field" ),
    Help( QStringLiteral( "Field" ), tr( "group" ), tr( "Double-click to add field name to expression string.<br>Right-Click on field name to open context menu sample value loading options." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Field" ), tr( "Double-click to add field name to expression string.<br>Right-Click on field name to open context menu sample value loading options." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          tr( "Loading field values from online sources isn't supported before the layer is actually inserted, ie. when building queries." ),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Fields and Values" ),
    Help( QStringLiteral( "Fields and Values" ), tr( "group" ), tr( "Contains a list of fields from the layer.  Sample values can also be accessed via right-click.<br>Select the field name from the list then right-click to access context menu with options to load sample values from the selected field." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Fields and Values" ), tr( "Contains a list of fields from the layer.  Sample values can also be accessed via right-click.<br>Select the field name from the list then right-click to access context menu with options to load sample values from the selected field." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          tr( "Loading field values from online sources isn't supported before the layer is actually inserted, ie. when building queries." ),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Files and Paths" ),
    Help( QStringLiteral( "Files and Paths" ), tr( "group" ), tr( "Contains functions which manipulate file and path names." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Files and Paths" ), tr( "Contains functions which manipulate file and path names." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Form" ),
    Help( QStringLiteral( "Form" ), tr( "group" ), tr( "This group contains functions that are available in the attribute form context. For example, in field widget settings." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Form" ), tr( "This group contains functions that are available in the attribute form context. For example, in field widget settings." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Fuzzy Matching" ),
    Help( QStringLiteral( "Fuzzy Matching" ), tr( "group" ), tr( "This group contains functions for fuzzy comparisons between values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Fuzzy Matching" ), tr( "This group contains functions for fuzzy comparisons between values." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "General" ),
    Help( QStringLiteral( "General" ), tr( "group" ), tr( "This group contains general assorted functions." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "General" ), tr( "This group contains general assorted functions." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "GeometryGroup" ),
    Help( QStringLiteral( "GeometryGroup" ), tr( "group" ), tr( "This group contains functions that operate on geometry objects e.g length, area." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "GeometryGroup" ), tr( "This group contains functions that operate on geometry objects e.g length, area." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ILIKE" ),
    Help( QStringLiteral( "ILIKE" ), tr( "operator" ), tr( "Returns TRUE if the first parameter matches case-insensitive the supplied pattern. LIKE can be used instead of ILIKE to make the match case-sensitive. Works with numbers also." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "ILIKE" ), tr( "Returns TRUE if the first parameter matches case-insensitive the supplied pattern. LIKE can be used instead of ILIKE to make the match case-sensitive. Works with numbers also." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string/number" ), tr( "string to search" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pattern" ), tr( "pattern to find, you can use '%' as a wildcard, '_' as a single char and '\\\\' to escape these special characters." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'A' ILIKE 'A'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'A' ILIKE 'a'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'A' ILIKE 'B'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABC' ILIKE 'b'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABC' ILIKE 'B'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABC' ILIKE '_b_'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABC' ILIKE '_B_'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '_b_'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '_B_'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '_b%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '_B%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '%b%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '%B%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD%' ILIKE 'abcd\\\\%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' ILIKE '%B\\\\%'" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "compare,numbers,insensitive,first,match,sensitive,supplied,parameter,case,matches,pattern" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "IN" ),
    Help( QStringLiteral( "IN" ), tr( "operator" ), tr( "Returns TRUE if value is found within a list of values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "IN" ), tr( "Returns TRUE if value is found within a list of values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "list of values" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'A' IN ('A','B')" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'A' IN ('C','B')" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "list,contained,found" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "IS" ),
    Help( QStringLiteral( "IS" ), tr( "operator" ), tr( "Returns TRUE if a is the same as b." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "IS" ), tr( "Returns TRUE if a is the same as b." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "any value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "any value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'A' IS 'A'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'A' IS 'a'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "4 IS 4" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 IS 2+2" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 IS 2" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "@geometry IS NULL" ), tr( "0, if your geometry is not NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "compare,same,equal,identical" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "IS NOT" ),
    Help( QStringLiteral( "IS NOT" ), tr( "operator" ), tr( "Returns TRUE if a is not the same as b." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "IS NOT" ), tr( "Returns TRUE if a is not the same as b." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'a' IS NOT 'b'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'a' IS NOT 'a'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "4 IS NOT 2+2" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "compare,same,different" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "LIKE" ),
    Help( QStringLiteral( "LIKE" ), tr( "operator" ), tr( "Returns TRUE if the first parameter matches the supplied pattern. Works with numbers also." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "LIKE" ), tr( "Returns TRUE if the first parameter matches the supplied pattern. Works with numbers also." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string/number" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pattern" ), tr( "pattern to compare value with, you can use '%' as a wildcard, '_' as a single char and '\\\\' to escape these special characters." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'A' LIKE 'A'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'A' LIKE 'a'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'A' LIKE 'B'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABC' LIKE 'B'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABC' LIKE '_B_'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' LIKE '_B_'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'ABCD' LIKE '_B%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'ABCD' LIKE '%B%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'1%' LIKE '1\\\\%'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'1_' LIKE '1\\\\%'" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "compare,sensitive,numbers,first,end,start,begin,works,supplied,parameter,matches,pattern" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Layout" ),
    Help( QStringLiteral( "Layout" ), tr( "group" ), tr( "This group contains functions to manipulate print layout items properties." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Layout" ), tr( "This group contains functions to manipulate print layout items properties." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Map Layers" ),
    Help( QStringLiteral( "Map Layers" ), tr( "group" ), tr( "Contains a list of map layers available in the current project." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Map Layers" ), tr( "Contains a list of map layers available in the current project." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Maps" ),
    Help( QStringLiteral( "Maps" ), tr( "group" ), tr( "This group contains expression functions for the creation and manipulation of 'map' data structures (also known as dictionary objects, key-value pairs, or associative arrays). One can assign values to given keys. The order of the key-value pairs in the map object is not relevant." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Maps" ), tr( "This group contains expression functions for the creation and manipulation of 'map' data structures (also known as dictionary objects, key-value pairs, or associative arrays). One can assign values to given keys. The order of the key-value pairs in the map object is not relevant." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Math" ),
    Help( QStringLiteral( "Math" ), tr( "group" ), tr( "This group contains math functions e.g square root, sin and cos" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Math" ), tr( "This group contains math functions e.g square root, sin and cos" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Meshes" ),
    Help( QStringLiteral( "Meshes" ), tr( "group" ), tr( "Contains functions which calculate or return mesh related values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Meshes" ), tr( "Contains functions which calculate or return mesh related values." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
            << tr( "calculate,functions,return,mesh,related,contains" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "NOT" ),
    Help( QStringLiteral( "NOT" ), tr( "operator" ), tr( "Negates a condition." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "NOT" ), tr( "Negates a condition." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "condition" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "NOT 1" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "NOT 0" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "negates,condition" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "NOT BETWEEN" ),
    Help( QStringLiteral( "NOT BETWEEN" ), tr( "operator" ), tr( "Returns TRUE if value is not within the specified range. The range is considered inclusive of the bounds." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "NOT BETWEEN" ), tr( "Returns TRUE if value is not within the specified range. The range is considered inclusive of the bounds." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "the value to compare with a range. It can be a string, a number or a date." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "lower_bound AND higher_bound" ), tr( "range bounds" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'B' NOT BETWEEN 'A' AND 'C'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "1.0 NOT BETWEEN 1.1 AND 1.2" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "2 NOT BETWEEN 2 AND 3" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'B' NOT BETWEEN 'a' AND 'c'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "lower('B') NOT BETWEEN 'a' AND 'b'" ), tr( "FALSE" ), QString() ),
          tr( "<i>value NOT BETWEEN lower_bound AND higher_bound</i> is the same as \"<i>value &lt; lower_bound OR value &gt; higher_bound</i>\"." ),
          QStringList()
            << tr( "bound,contained,exclude,found,range" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "NULL" ),
    Help( QStringLiteral( "NULL" ), tr( "value" ), tr( "Equates to a NULL value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "NULL" ), tr( "Equates to a NULL value." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "NULL" ), tr( "a NULL value" ), QString() ),
          tr( "To test for NULL use an <i>IS NULL</i> or <i>IS NOT NULL</i> expression." ),
          QStringList()
            << tr( "equates,null" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "OR" ),
    Help( QStringLiteral( "OR" ), tr( "operator" ), tr( "Returns TRUE when condition a or b is true." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "OR" ), tr( "Returns TRUE when condition a or b is true." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "condition" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "condition" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "4 = 2+2 OR 1 = 1" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 = 2+2 OR 1 = 2" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 = 2   OR 1 = 2" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "condition" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Operators" ),
    Help( QStringLiteral( "Operators" ), tr( "group" ), tr( "This group contains operators e.g + - *" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Operators" ), tr( "This group contains operators e.g + - *" ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Processing" ),
    Help( QStringLiteral( "Processing" ), tr( "group" ), tr( "This group contains functions that are available in the processing algorithms context." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Processing" ), tr( "This group contains functions that are available in the processing algorithms context." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Rasters" ),
    Help( QStringLiteral( "Rasters" ), tr( "group" ), tr( "Contains functions which calculate raster statistics and values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Rasters" ), tr( "Contains functions which calculate raster statistics and values." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Recent (Selection)" ),
    Help( QStringLiteral( "Recent (Selection)" ), tr( "group" ), tr( "This group contains recently used expressions." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Recent (Selection)" ), tr( "This group contains recently used expressions." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Record and Attributes" ),
    Help( QStringLiteral( "Record and Attributes" ), tr( "group" ), tr( "This group contains functions that operate on record identifiers." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Record and Attributes" ), tr( "This group contains functions that operate on record identifiers." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Relations" ),
    Help( QStringLiteral( "Relations" ), tr( "group" ), tr( "Contains a list of relations available in the current project." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Relations" ), tr( "Contains a list of relations available in the current project." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Sensors" ),
    Help( QStringLiteral( "Sensors" ), tr( "group" ), tr( "This group contains functions to interact with sensors." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Sensors" ), tr( "This group contains functions to interact with sensors." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "String" ),
    Help( QStringLiteral( "String" ), tr( "group" ), tr( "This group contains functions that operate on strings e.g replace, convert to upper case." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "String" ), tr( "This group contains functions that operate on strings e.g replace, convert to upper case." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "UserGroup" ),
    Help( QStringLiteral( "UserGroup" ), tr( "group" ), tr( "This group contains expressions stored in the user profile." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "UserGroup" ), tr( "This group contains expressions stored in the user profile." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "Variables" ),
    Help( QStringLiteral( "Variables" ), tr( "group" ), tr( "This group contains dynamic variables which can be inserted into your expressions." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Variables" ), tr( "This group contains dynamic variables which can be inserted into your expressions." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>(),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "abs" ),
    Help( QStringLiteral( "abs" ), tr( "function" ), tr( "Returns the absolute value of a number." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "abs" ), tr( "Returns the absolute value of a number." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "a number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "abs(-2)" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "absolute" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "acos" ),
    Help( QStringLiteral( "acos" ), tr( "function" ), tr( "Returns the inverse cosine of a value in radians." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "acos" ), tr( "Returns the inverse cosine of a value in radians." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "cosine of an angle in radians" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "acos(0.5)" ), tr( "1.0471975511966" ), QString() ),
          QString(),
          QStringList()
            << tr( "angle,cosine,inverse,radians" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "affine_transform" ),
    Help( QStringLiteral( "affine_transform" ), tr( "function" ), tr( "Returns the geometry after an affine transformation. Calculations are in the Spatial Reference System of this geometry. The operations are performed in a scale, rotation, translation order. If there is a Z or M offset but the coordinate is not present in the geometry, it will be added." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "affine_transform" ), tr( "Returns the geometry after an affine transformation. Calculations are in the Spatial Reference System of this geometry. The operations are performed in a scale, rotation, translation order. If there is a Z or M offset but the coordinate is not present in the geometry, it will be added." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "delta_x" ), tr( "x-axis translation" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "delta_y" ), tr( "y-axis translation" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "rotation_z" ), tr( "rotation around z-axis in degrees counter-clockwise" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "scale_x" ), tr( "x-axis scale factor" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "scale_y" ), tr( "y-axis scale factor" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "delta_z" ), tr( "z-axis translation" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "delta_m" ), tr( "m-axis translation" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "scale_z" ), tr( "z-axis scale factor" ), false, false, true, QStringLiteral( "1" ) )
              << HelpArg( QStringLiteral( "scale_m" ), tr( "m-axis scale factor" ), false, false, true, QStringLiteral( "1" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(affine_transform(geom_from_wkt('LINESTRING(1 1, 2 2)'), 2, 2, 0, 1, 1))" ), tr( "'LineString (3 3, 4 4)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(affine_transform(geom_from_wkt('POLYGON((0 0, 0 3, 2 2, 0 0))'), 0, 0, -90, 1, 2))" ), tr( "'Polygon ((0 0, 6 0, 4 -2, 0 0))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(affine_transform(geom_from_wkt('POINT(3 1)'), 0, 0, 0, 1, 1, 5, 0))" ), tr( "'PointZ (3 1 5)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "affine,coordinate,operations,spatial,transformation,reference,offset,system,calculations,translation,rotation,order,added,present,scale" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "age" ),
    Help( QStringLiteral( "age" ), tr( "function" ), tr( "Returns the difference between two dates or datetimes.<br>The difference is returned as an <code>Interval</code> and needs to be used with one of the following functions in order to extract useful information:<br /><ul><li><code>year</code></li><li><code>month</code></li><li><code>week</code></li><li><code>day</code></li><li><code>hour</code></li><li><code>minute</code></li><li><code>second</code></li></ul>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "age" ), tr( "Returns the difference between two dates or datetimes.<br>The difference is returned as an <code>Interval</code> and needs to be used with one of the following functions in order to extract useful information:<br /><ul><li><code>year</code></li><li><code>month</code></li><li><code>week</code></li><li><code>day</code></li><li><code>hour</code></li><li><code>minute</code></li><li><code>second</code></li></ul>" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "datetime1" ), tr( "a string, date or datetime representing the later date" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "datetime2" ), tr( "a string, date or datetime representing the earlier date" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "day(age('2012-05-12','2012-05-02'))" ), tr( "10" ), QString() )
            << HelpExample( tr( "hour(age('2012-05-12','2012-05-02'))" ), tr( "240" ), QString() ),
          QString(),
          QStringList()
            << tr( "difference,needs,datetimes,order,extract,information,following,interval,dates,functions,year,month,week,day,hour,minute,second" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "aggregate" ),
    Help( QStringLiteral( "aggregate" ), tr( "function" ), tr( "Returns an aggregate value calculated using features from another layer." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "aggregate" ), tr( "Returns an aggregate value calculated using features from another layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "a string, representing either a layer name or layer ID" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "aggregate" ), tr( "a string corresponding to the aggregate to calculate. Valid options are:<br /><ul><li>count</li><li>count_distinct</li><li>count_missing</li><li>minimum or min</li><li>maximum or max</li><li>sum</li><li>mean</li><li>median</li><li>stdev</li><li>stdevsample</li><li>range</li><li>minority</li><li>majority</li><li>q1: first quartile</li><li>q3: third quartile</li><li>iqr: inter quartile range</li><li>min_length: minimum string length</li><li>max_length: maximum string length</li><li>concatenate: join strings with a concatenator</li><li>concatenate_unique: join unique strings with a concatenator</li><li>collect: create an aggregated multipart geometry</li><li>array_agg: create an array of aggregated values</li></ul>" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression or field name to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional filter expression to limit the features used for calculating the aggregate. Fields and geometry are from the features on the joined layer. The source feature can be accessed with the variable @parent." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "concatenator" ), tr( "optional string to use to join values for 'concatenate' and 'concatenate_unique' aggregates" ), false, false, true, QStringLiteral( "''" ) )
              << HelpArg( QStringLiteral( "order_by" ), tr( "optional filter expression to order the features used for calculating the aggregate. Fields and geometry are from the features on the joined layer. By default, the features will be returned in an unspecified order." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "aggregate(layer:='rail_stations',aggregate:='sum',expression:=\"passengers\")" ), tr( "sum of all values from the passengers field in the rail_stations layer" ), QString() )
            << HelpExample( tr( "aggregate('rail_stations','sum', \"passengers\"/7)" ), tr( "calculates a daily average of \"passengers\" by dividing the \"passengers\" field by 7 before summing the values" ), QString() )
            << HelpExample( tr( "aggregate(layer:='rail_stations',aggregate:='sum',expression:=\"passengers\",filter:=\"class\">3)" ), tr( "sums up all values from the \"passengers\" field from features where the \"class\" attribute is greater than 3 only" ), QString() )
            << HelpExample( tr( "aggregate(layer:='rail_stations',aggregate:='concatenate', expression:=\"name\", concatenator:=',')" ), tr( "comma separated list of the name field for all features in the rail_stations layer" ), QString() )
            << HelpExample( tr( "aggregate(layer:='countries', aggregate:='max', expression:=\"code\", filter:=intersects( @geometry, geometry(@parent) ) )" ), tr( "The country code of an intersecting country on the layer 'countries'" ), QString() )
            << HelpExample( tr( "aggregate(layer:='rail_stations',aggregate:='sum',expression:=\"passengers\",filter:=contains( @atlas_geometry, @geometry ) )" ), tr( "sum of all values from the passengers field in the rail_stations within the current atlas feature" ), QString() )
            << HelpExample( tr( "aggregate(layer:='rail_stations', aggregate:='collect', expression:=centroid(@geometry), filter:=\"region_name\" = attribute(@parent,'name') )" ), tr( "aggregates centroid geometries of the rail_stations of the same region as current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregate,combine,features,calculated,merge,concatenate,sum,mean,median,count,quartile,minimum,maximum,minority,majority,standard,deviation,length,unique" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "angle_at_vertex" ),
    Help( QStringLiteral( "angle_at_vertex" ), tr( "function" ), tr( "Returns the bisector angle (average angle) to the geometry for a specified vertex on a linestring geometry. Angles are in degrees clockwise from north." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "angle_at_vertex" ), tr( "Returns the bisector angle (average angle) to the geometry for a specified vertex on a linestring geometry. Angles are in degrees clockwise from north." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertex" ), tr( "vertex index, starting from 0; if the value is negative, the selected vertex index will be its total count minus the absolute value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "angle_at_vertex(geometry:=geom_from_wkt('LineString(0 0, 10 0, 10 10)'),vertex:=1)" ), tr( "45.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "angles,specified,clockwise,angle,linestring,degrees,bisector,north,average,vertex" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "apply_dash_pattern" ),
    Help( QStringLiteral( "apply_dash_pattern" ), tr( "function" ), tr( "Applies a dash pattern to a geometry, returning a MultiLineString geometry which is the input geometry stroked along each line/ring with the specified pattern." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "apply_dash_pattern" ), tr( "Applies a dash pattern to a geometry, returning a MultiLineString geometry which is the input geometry stroked along each line/ring with the specified pattern." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry (accepts (multi)linestrings or (multi)polygons)." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pattern" ), tr( "dash pattern, as an array of numbers representing dash and gap lengths. Must contain an even number of elements." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "start_rule" ), tr( "optional rule for constraining the start of the pattern. Valid values are 'no_rule', 'full_dash', 'half_dash', 'full_gap', 'half_gap'." ), false, false, true, QStringLiteral( "no_rule" ) )
              << HelpArg( QStringLiteral( "end_rule" ), tr( "optional rule for constraining the end of the pattern. Valid values are 'no_rule', 'full_dash', 'half_dash', 'full_gap', 'half_gap'." ), false, false, true, QStringLiteral( "no_rule" ) )
              << HelpArg( QStringLiteral( "adjustment" ), tr( "optional rule for specifying which part of patterns are adjusted to fit the desired pattern rules. Valid values are 'both', 'dash', 'gap'." ), false, false, true, QStringLiteral( "both" ) )
              << HelpArg( QStringLiteral( "pattern_offset" ), tr( "Optional distance specifying a specific distance along the pattern to commence at." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(apply_dash_pattern(geom_from_wkt('LINESTRING(1 1, 10 1)'), array(3, 1)))" ), tr( "MultiLineString ((1 1, 4 1),(5 1, 8 1),(9 1, 10 1, 10 1))" ), QString() )
            << HelpExample( tr( "geom_to_wkt(apply_dash_pattern(geom_from_wkt('LINESTRING(1 1, 10 1)'), array(3, 1), start_rule:='half_dash'))" ), tr( "MultiLineString ((1 1, 2.5 1),(3.5 1, 6.5 1),(7.5 1, 10 1, 10 1))" ), QString() ),
          QString(),
          QStringList()
            << tr( "dash,stroked,multilinestring,input,ring,specified,applies,line,pattern,returning" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "area" ),
    Help( QStringLiteral( "area" ), tr( "function" ), tr( "Returns the area of a geometry polygon object. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned area will match the units for the SRS. This differs from the calculations performed by the $area function, which will perform ellipsoidal calculations based on the project's ellipsoid and area unit settings." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "area" ), tr( "Returns the area of a geometry polygon object. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned area will match the units for the SRS. This differs from the calculations performed by the $area function, which will perform ellipsoidal calculations based on the project's ellipsoid and area unit settings." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "polygon geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "area(geom_from_wkt('POLYGON((0 0, 4 0, 4 2, 0 2, 0 0))'))" ), tr( "8.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "planimetric,polygon,spatial,reference,system,calculations,area,project,settings,surface,ellipsoid,units" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array" ),
    Help( QStringLiteral( "array" ), tr( "function" ), tr( "Returns an array containing all the values passed as parameter." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array" ), tr( "Returns an array containing all the values passed as parameter." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "a value" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "array(2,10)" ), tr( "[ 2, 10 ]" ), QString() )
            << HelpExample( tr( "array(2,10)[0]" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "list,array,parameter,containing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_agg" ),
    Help( QStringLiteral( "array_agg" ), tr( "function" ), tr( "Returns an array of aggregated values from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_agg" ), tr( "Returns an array of aggregated values from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "order_by" ), tr( "optional expression to use to order features used to calculate aggregate. By default, the features will be returned in an unspecified order." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_agg(\"name\",group_by:=\"state\")" ), tr( "list of name values, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,field,aggregated" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_all" ),
    Help( QStringLiteral( "array_all" ), tr( "function" ), tr( "Returns TRUE if an array contains all the values of a given array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_all" ), tr( "Returns TRUE if an array contains all the values of a given array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array_a" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "array_b" ), tr( "the array of values to search" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_all(array(1,2,3),array(2,3))" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "array_all(array(1,2,3),array(1,2,4))" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,contains,compare,search" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_append" ),
    Help( QStringLiteral( "array_append" ), tr( "function" ), tr( "Returns an array with the given value added at the end." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_append" ), tr( "Returns an array with the given value added at the end." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to add" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_append(array(1,2,3),4)" ), tr( "[ 1, 2, 3, 4 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,added,end" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_cat" ),
    Help( QStringLiteral( "array_cat" ), tr( "function" ), tr( "Returns an array containing all the given arrays concatenated." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_cat" ), tr( "Returns an array containing all the given arrays concatenated." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "array2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "array_cat(array(1,2),array(2,3))" ), tr( "[ 1, 2, 2, 3 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "concatenated,arrays,containing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_contains" ),
    Help( QStringLiteral( "array_contains" ), tr( "function" ), tr( "Returns TRUE if an array contains the given value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_contains" ), tr( "Returns TRUE if an array contains the given value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to search" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_contains(array(1,2,3),2)" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,search,contains" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_count" ),
    Help( QStringLiteral( "array_count" ), tr( "function" ), tr( "Counts the number of occurrences of a given value in an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_count" ), tr( "Counts the number of occurrences of a given value in an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to count" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_count(array('a', 'b', 'c', 'b'), 'b')" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "number,array,occurrences,given,counts" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_distinct" ),
    Help( QStringLiteral( "array_distinct" ), tr( "function" ), tr( "Returns an array containing distinct values of the given array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_distinct" ), tr( "Returns an array containing distinct values of the given array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_distinct(array(1,2,3,2,1))" ), tr( "[ 1, 2, 3 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,containing,distinct" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_filter" ),
    Help( QStringLiteral( "array_filter" ), tr( "function" ), tr( "Returns an array with only the items for which the expression evaluates to true." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_filter" ), tr( "Returns an array with only the items for which the expression evaluates to true." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an expression to evaluate on each item. The variable `@element` will be replaced by the current value." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "maximum number of elements to be returned. Use 0 to return all values." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_filter(array(1,2,3),@element &lt; 3)" ), tr( "[ 1, 2 ]" ), QString() )
            << HelpExample( tr( "array_filter(array(1,2,3),@element &lt; 3, 1)" ), tr( "[ 1 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,items,limit,evaluates" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_find" ),
    Help( QStringLiteral( "array_find" ), tr( "function" ), tr( "Returns the lowest index (0 for the first one) of a value within an array. Returns -1 if the value is not found." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_find" ), tr( "Returns the lowest index (0 for the first one) of a value within an array. Returns -1 if the value is not found." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to search" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_find(array('a', 'b', 'c'), 'b')" ), tr( "1" ), QString() )
            << HelpExample( tr( "array_find(array('a', 'b', 'c', 'b'), 'b')" ), tr( "1" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,found,first,lowest,index" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_first" ),
    Help( QStringLiteral( "array_first" ), tr( "function" ), tr( "Returns the first value of an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_first" ), tr( "Returns the first value of an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_first(array('a','b','c'))" ), tr( "'a'" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,first" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_foreach" ),
    Help( QStringLiteral( "array_foreach" ), tr( "function" ), tr( "Returns an array with the given expression evaluated on each item." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_foreach" ), tr( "Returns an array with the given expression evaluated on each item." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an expression to evaluate on each item. The variable `@element` will be replaced by the current value and the variable `@counter` by the current index (starting with 0)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_foreach(array('a','b','c'),upper(@element))" ), tr( "[ 'A', 'B', 'C' ]" ), QString() )
            << HelpExample( tr( "array_foreach(array(1,2,3),@element + 10)" ), tr( "[ 11, 12, 13 ]" ), QString() )
            << HelpExample( tr( "array_foreach(array(1,2,3),@element + @counter)" ), tr( "[ 1, 3, 5 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "evaluated,array,iterate,item" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_get" ),
    Help( QStringLiteral( "array_get" ), tr( "function" ), tr( "Returns the Nth value (0 for the first one) or the last -Nth value (-1 for the last one) of an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_get" ), tr( "Returns the Nth value (0 for the first one) or the last -Nth value (-1 for the last one) of an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pos" ), tr( "the index to get (0 based)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_get(array('a','b','c'),1)" ), tr( "'b'" ), QString() )
            << HelpExample( tr( "array_get(array('a','b','c'),-1)" ), tr( "'c'" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,position,index,last,nth,one,first" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_insert" ),
    Help( QStringLiteral( "array_insert" ), tr( "function" ), tr( "Returns an array with the given value added at the given position." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_insert" ), tr( "Returns an array with the given value added at the given position." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pos" ), tr( "the position where to add (0 based)" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to add" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_insert(array(1,2,3),1,100)" ), tr( "[ 1, 100, 2, 3 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,added,position" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_intersect" ),
    Help( QStringLiteral( "array_intersect" ), tr( "function" ), tr( "Returns TRUE if at least one element of array1 exists in array2." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_intersect" ), tr( "Returns TRUE if at least one element of array1 exists in array2." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array1" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "array2" ), tr( "another array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_intersect(array(1,2,3,4),array(4,0,2,5))" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,element,exists,intersection,overlap" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_last" ),
    Help( QStringLiteral( "array_last" ), tr( "function" ), tr( "Returns the last value of an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_last" ), tr( "Returns the last value of an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_last(array('a','b','c'))" ), tr( "'c'" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,last" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_length" ),
    Help( QStringLiteral( "array_length" ), tr( "function" ), tr( "Returns the number of elements of an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_length" ), tr( "Returns the number of elements of an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_length(array(1,2,3))" ), tr( "3" ), QString() ),
          QString(),
          QStringList()
            << tr( "elements,array,count" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_majority" ),
    Help( QStringLiteral( "array_majority" ), tr( "function" ), tr( "Returns the most common values in an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_majority" ), tr( "Returns the most common values in an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "option='all'" ), tr( "a string specifying the return values handling. Valid options are:<br><ul><li>all: Default, all most common values are returned in an array.</li><li>any: Returns one of the most common values.</li><li>median: Returns the median of the most common values. Non arithmetic values are ignored.</li><li>real_majority: Returns the value which occurs more than half the size of the array.</li></ul>" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_majority(array(0,1,42,42,43), 'all')" ), tr( "[ 42 ]" ), QString() )
            << HelpExample( tr( "array_majority(array(0,1,42,42,43,1), 'all')" ), tr( "[ 42, 1 ]" ), QString() )
            << HelpExample( tr( "array_majority(array(0,1,42,42,43,1), 'any')" ), tr( "1 or 42" ), QString() )
            << HelpExample( tr( "array_majority(array(0,1,1,2,2), 'median')" ), tr( "1.5" ), QString() )
            << HelpExample( tr( "array_majority(array(0,1,42,42,43), 'real_majority')" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "array_majority(array(0,1,42,42,43,42), 'real_majority')" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "array_majority(array(0,1,42,42,43,42,42), 'real_majority')" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "common,array,median" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_max" ),
    Help( QStringLiteral( "array_max" ), tr( "function" ), tr( "Returns the maximum value of an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_max" ), tr( "Returns the maximum value of an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_max(array(0,42,4,2))" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,maximum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_mean" ),
    Help( QStringLiteral( "array_mean" ), tr( "function" ), tr( "Returns the mean of arithmetic values in an array. Non numeric values in the array are ignored." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_mean" ), tr( "Returns the mean of arithmetic values in an array. Non numeric values in the array are ignored." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_mean(array(0,1,7,66.6,135.4))" ), tr( "42" ), QString() )
            << HelpExample( tr( "array_mean(array(0,84,'a','b','c'))" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,ignored,mean,numeric,arithmetic" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_median" ),
    Help( QStringLiteral( "array_median" ), tr( "function" ), tr( "Returns the median of arithmetic values in an array. Non arithmetic values in the array are ignored." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_median" ), tr( "Returns the median of arithmetic values in an array. Non arithmetic values in the array are ignored." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_median(array(0,1,42,42,43))" ), tr( "42" ), QString() )
            << HelpExample( tr( "array_median(array(0,1,2,42,'a','b'))" ), tr( "1.5" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,arithmetic,median,ignored" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_min" ),
    Help( QStringLiteral( "array_min" ), tr( "function" ), tr( "Returns the minimum value of an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_min" ), tr( "Returns the minimum value of an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_min(array(43,42,54))" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,minimum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_minority" ),
    Help( QStringLiteral( "array_minority" ), tr( "function" ), tr( "Returns the less common values in an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_minority" ), tr( "Returns the less common values in an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "option='all'" ), tr( "a string specifying the return values handling. Valid options are:<br /><ul><li>all: Default, all less common values are returned in an array.</li><li>any: Returns one of the less common values.</li><li>median: Returns the median of the less common values. Non arithmetic values are ignored.</li><li>real_minority: Returns values which occur less than half the size of the array.</li></ul>" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_minority(array(0,42,42), 'all')" ), tr( "[ 0 ]" ), QString() )
            << HelpExample( tr( "array_minority(array(0,1,42,42), 'all')" ), tr( "[ 0, 1 ]" ), QString() )
            << HelpExample( tr( "array_minority(array(0,1,42,42,43,1), 'any')" ), tr( "0 or 43" ), QString() )
            << HelpExample( tr( "array_minority(array(1,2,3,3), 'median')" ), tr( "1.5" ), QString() )
            << HelpExample( tr( "array_minority(array(0,1,42,42,43), 'real_minority')" ), tr( "[ 42, 43, 0, 1 ]" ), QString() )
            << HelpExample( tr( "array_minority(array(0,1,42,42,43,42), 'real_minority')" ), tr( "[ 42, 43, 0, 1 ]" ), QString() )
            << HelpExample( tr( "array_minority(array(0,1,42,42,43,42,42), 'real_minority')" ), tr( "[ 43, 0, 1 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "common,array,median" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_prepend" ),
    Help( QStringLiteral( "array_prepend" ), tr( "function" ), tr( "Returns an array with the given value added at the beginning." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_prepend" ), tr( "Returns an array with the given value added at the beginning." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to add" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_prepend(array(1,2,3),0)" ), tr( "[ 0, 1, 2, 3 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,added,beginning" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_prioritize" ),
    Help( QStringLiteral( "array_prioritize" ), tr( "function" ), tr( "Returns an array sorted using the ordering specified in another array. Values which are present in the first array but are missing from the second array will be added to the end of the result." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_prioritize" ), tr( "Returns an array sorted using the ordering specified in another array. Values which are present in the first array but are missing from the second array will be added to the end of the result." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "array_prioritize" ), tr( "an array with values ordered by priority" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_prioritize(array(1, 8, 2, 5), array(5, 4, 2, 1, 3, 8))" ), tr( "[ 5, 2, 1, 8 ]" ), QString() )
            << HelpExample( tr( "array_prioritize(array(5, 4, 2, 1, 3, 8), array(1, 8, 6, 5))" ), tr( "[ 1, 8, 5, 4, 2, 3 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "sorted,array,first,specified,missing,second,ordering,added,present,result,end" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_remove_all" ),
    Help( QStringLiteral( "array_remove_all" ), tr( "function" ), tr( "Returns an array with all the entries of the given value removed." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_remove_all" ), tr( "Returns an array with all the entries of the given value removed." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the values to remove" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_remove_all(array('a','b','c','b'),'b')" ), tr( "[ 'a', 'c' ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,entries,removed" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_remove_at" ),
    Help( QStringLiteral( "array_remove_at" ), tr( "function" ), tr( "Returns an array with the item at the given index removed. Supports positive (0 for the first element) and negative (the last -Nth value, -1 for the last element) index." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_remove_at" ), tr( "Returns an array with the item at the given index removed. Supports positive (0 for the first element) and negative (the last -Nth value, -1 for the last element) index." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pos" ), tr( "the position to remove (0 based)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_remove_at(array(1, 2, 3), 1)" ), tr( "[1, 3 ]" ), QString() )
            << HelpExample( tr( "array_remove_at(array(1, 2, 3), -1)" ), tr( "[1, 2 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,removed,index" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_replace" ),
    Help( QStringLiteral( "array_replace" ), tr( "function" ), tr( "Returns an array with the supplied value, array, or map of values replaced." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Value & array variant" ), tr( "Returns an array with the supplied value or array of values replaced by another value or an array of values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "the input array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "before" ), tr( "the value or array of values to replace" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "after" ), tr( "the value or array of values to use as a replacement" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_replace(array('QGIS','SHOULD','ROCK'),'SHOULD','DOES')" ), tr( "[ 'QGIS', 'DOES', 'ROCK' ]" ), QString() )
            << HelpExample( tr( "array_replace(array(3,2,1),array(1,2,3),array(7,8,9))" ), tr( "[ 9, 8, 7 ]" ), QString() )
            << HelpExample( tr( "array_replace(array('Q','G','I','S'),array('Q','S'),'-')" ), tr( "[ '-', 'G', 'I', '-' ]" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Map variant" ), tr( "Returns an array with the supplied map keys replaced by their paired values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "the input array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "map" ), tr( "the map containing keys and values" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_replace(array('APP', 'SHOULD', 'ROCK'),map('APP','QGIS','SHOULD','DOES'))" ), tr( "[ 'QGIS', 'DOES', 'ROCK' ]" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_reverse" ),
    Help( QStringLiteral( "array_reverse" ), tr( "function" ), tr( "Returns the given array with array values in reversed order." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_reverse" ), tr( "Returns the given array with array values in reversed order." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_reverse(array(2,4,0,10))" ), tr( "[ 10, 0, 4, 2 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,reversed,order" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_slice" ),
    Help( QStringLiteral( "array_slice" ), tr( "function" ), tr( "Returns a portion of the array. The slice is defined by the start_pos and end_pos arguments." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_slice" ), tr( "Returns a portion of the array. The slice is defined by the start_pos and end_pos arguments." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "start_pos" ), tr( "the index of the start position of the slice (0 based). The start_pos index is included in the slice. If you use a negative start_pos, the index is counted from the end of the list (-1 based)." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "end_pos" ), tr( "the index of the end position of the slice (0 based). The end_pos index is included in the slice. If you use a negative end_pos, the index is counted from the end of the list (-1 based)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_slice(array(1,2,3,4,5),0,3)" ), tr( "[ 1, 2, 3, 4 ]" ), QString() )
            << HelpExample( tr( "array_slice(array(1,2,3,4,5),0,-1)" ), tr( "[ 1, 2, 3, 4, 5 ]" ), QString() )
            << HelpExample( tr( "array_slice(array(1,2,3,4,5),-5,-1)" ), tr( "[ 1, 2, 3, 4, 5 ]" ), QString() )
            << HelpExample( tr( "array_slice(array(1,2,3,4,5),0,0)" ), tr( "[ 1 ]" ), QString() )
            << HelpExample( tr( "array_slice(array(1,2,3,4,5),-2,-1)" ), tr( "[ 4, 5 ]" ), QString() )
            << HelpExample( tr( "array_slice(array(1,2,3,4,5),-1,-1)" ), tr( "[ 5 ]" ), QString() )
            << HelpExample( tr( "array_slice(array('Dufour','Valmiera','Chugiak','Brighton'),1,2)" ), tr( "[ 'Valmiera', 'Chugiak' ]" ), QString() )
            << HelpExample( tr( "array_slice(array('Dufour','Valmiera','Chugiak','Brighton'),-2,-1)" ), tr( "[ 'Chugiak', 'Brighton' ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,defined,arguments,start,position,slice,portion,end,index" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_sort" ),
    Help( QStringLiteral( "array_sort" ), tr( "function" ), tr( "Returns the provided array with its elements sorted." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_sort" ), tr( "Returns the provided array with its elements sorted." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "ascending" ), tr( "set this parameter to false to sort the array in descending order" ), false, false, true, QStringLiteral( "true" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_sort(array(3,2,1))" ), tr( "[ 1, 2, 3 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "sorted,array,elements,provided" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_sum" ),
    Help( QStringLiteral( "array_sum" ), tr( "function" ), tr( "Returns the sum of arithmetic values in an array. Non numeric values in the array are ignored." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_sum" ), tr( "Returns the sum of arithmetic values in an array. Non numeric values in the array are ignored." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "an array" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_sum(array(0,1,39.4,1.6,'a'))" ), tr( "42.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,ignored,numeric,arithmetic,sum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "array_to_string" ),
    Help( QStringLiteral( "array_to_string" ), tr( "function" ), tr( "Concatenates array elements into a string separated by a delimiter and using optional string for empty values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "array_to_string" ), tr( "Concatenates array elements into a string separated by a delimiter and using optional string for empty values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "the input array" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "delimiter" ), tr( "the string delimiter used to separate concatenated array elements" ), false, false, true, QStringLiteral( "','" ) )
              << HelpArg( QStringLiteral( "empty_value" ), tr( "the optional string to use as replacement for empty (zero length) matches" ), false, false, true, QStringLiteral( "''" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_to_string(array('1','2','3'))" ), tr( "'1,2,3'" ), QString() )
            << HelpExample( tr( "array_to_string(array(1,2,3),'-')" ), tr( "'1-2-3'" ), QString() )
            << HelpExample( tr( "array_to_string(array('1','','3'),',','0')" ), tr( "'1,0,3'" ), QString() ),
          QString(),
          QStringList()
            << tr( "concatenates,delimiter,join,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ascii" ),
    Help( QStringLiteral( "ascii" ), tr( "function" ), tr( "Returns the unicode code associated with the first character of a string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "ascii" ), tr( "Returns the unicode code associated with the first character of a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to convert to unicode code" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ascii('Q')" ), tr( "81" ), QString() ),
          QString(),
          QStringList()
            << tr( "code,first,associated,character,unicode" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "asin" ),
    Help( QStringLiteral( "asin" ), tr( "function" ), tr( "Returns the inverse sine of a value in radians." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "asin" ), tr( "Returns the inverse sine of a value in radians." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "sine of an angle in radians" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "asin(1.0)" ), tr( "1.5707963267949" ), QString() ),
          QString(),
          QStringList()
            << tr( "sine,inverse,angle,radians" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "atan" ),
    Help( QStringLiteral( "atan" ), tr( "function" ), tr( "Returns the inverse tangent of a value in radians." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "atan" ), tr( "Returns the inverse tangent of a value in radians." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "tan of an angle in radians" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "atan(0.5)" ), tr( "0.463647609000806" ), QString() ),
          QString(),
          QStringList()
            << tr( "tangent,inverse,angle,radians" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "atan2" ),
    Help( QStringLiteral( "atan2" ), tr( "function" ), tr( "Returns the inverse tangent of dy/dx by using the signs of the two arguments to determine the quadrant of the result." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "atan2" ), tr( "Returns the inverse tangent of dy/dx by using the signs of the two arguments to determine the quadrant of the result." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "dy" ), tr( "y coordinate difference" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "dx" ), tr( "x coordinate difference" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "atan2(1.0, 1.732)" ), tr( "0.523611477769969" ), QString() ),
          QString(),
          QStringList()
            << tr( "tangent,arguments,signs,angle,inverse,quadrant" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "attribute" ),
    Help( QStringLiteral( "attribute" ), tr( "function" ), tr( "Returns an attribute from a feature." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Variant 1" ), tr( "Returns the value of an attribute from the current feature." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "attribute_name" ), tr( "name of attribute to be returned" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "attribute( 'name' )" ), tr( "value stored in 'name' attribute for the current feature" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Variant 2" ), tr( "Allows the target feature and attribute name to be specified." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "a feature" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "attribute_name" ), tr( "name of attribute to be returned" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "attribute( @atlas_feature, 'name' )" ), tr( "value stored in 'name' attribute for the current atlas feature" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "attributes" ),
    Help( QStringLiteral( "attributes" ), tr( "function" ), tr( "Returns a map containing all attributes from a feature, with field names as map keys." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Variant 1" ), tr( "Returns a map of all attributes from the current feature." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "attributes()['name']" ), tr( "value stored in 'name' attribute for the current feature" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Variant 2" ), tr( "Allows the target feature to be specified." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "a feature" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "attributes( @atlas_feature )['name']" ), tr( "value stored in 'name' attribute for the current atlas feature" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "azimuth" ),
    Help( QStringLiteral( "azimuth" ), tr( "function" ), tr( "Returns the north-based azimuth as the angle in radians measured clockwise from the vertical on point_a to point_b." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "azimuth" ), tr( "Returns the north-based azimuth as the angle in radians measured clockwise from the vertical on point_a to point_b." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point_a" ), tr( "point geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point_b" ), tr( "point geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "degrees( azimuth( make_point(25, 45), make_point(75, 100) ) )" ), tr( "42.273689" ), QString() )
            << HelpExample( tr( "degrees( azimuth( make_point(75, 100), make_point(25,45) ) )" ), tr( "222.273689" ), QString() ),
          QString(),
          QStringList()
            << tr( "measured,clockwise,points,angle,vertical,north,azimuth,radians" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "base_file_name" ),
    Help( QStringLiteral( "base_file_name" ), tr( "function" ), tr( "Returns the base name of the file without the directory or file suffix." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "base_file_name" ), tr( "Returns the base name of the file without the directory or file suffix." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "base_file_name('/home/qgis/data/country_boundaries.shp')" ), tr( "'country_boundaries'" ), QString() ),
          QString(),
          QStringList()
            << tr( "suffix,base,directory,name,file,folder,path" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "bearing" ),
    Help( QStringLiteral( "bearing" ), tr( "function" ), tr( "Returns the north-based bearing as the angle in radians measured clockwise on the ellipsoid from the vertical on point_a to point_b." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "bearing" ), tr( "Returns the north-based bearing as the angle in radians measured clockwise on the ellipsoid from the vertical on point_a to point_b." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point_a" ), tr( "point geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point_b" ), tr( "point geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "source_crs" ), tr( "an optional string or CRS object representing the source CRS of the points. By default the current layer's CRS is used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "ellipsoid" ), tr( "an optional string representing the acronym or the authority ID (e.g., 'EPSG:7030') of the ellipsoid on which the bearing should be measured. By default the current project's ellipsoid setting is used." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "degrees( bearing( make_point(16198544, -4534850), make_point(18736872, -1877769), 'EPSG:3857', 'EPSG:7030') )" ), tr( "49.980071" ), QString() )
            << HelpExample( tr( "degrees( bearing( make_point(18736872, -1877769), make_point(16198544, -4534850), 'EPSG:3857', 'WGS84') )" ), tr( "219.282386" ), QString() ),
          QString(),
          QStringList()
            << tr( "measured,clockwise,points,angle,vertical,north,azimuth,bearing,radians,ellipsoid" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "boundary" ),
    Help( QStringLiteral( "boundary" ), tr( "function" ), tr( "Returns the closure of the combinatorial boundary of the geometry (ie the topological boundary of the geometry). For instance, a polygon geometry will have a boundary consisting of the linestrings for each ring in the polygon. Some geometry types do not have a defined boundary, e.g., points or geometry collections, and will return NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "boundary" ), tr( "Returns the closure of the combinatorial boundary of the geometry (ie the topological boundary of the geometry). For instance, a polygon geometry will have a boundary consisting of the linestrings for each ring in the polygon. Some geometry types do not have a defined boundary, e.g., points or geometry collections, and will return NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(boundary(geom_from_wkt('Polygon((1 1, 0 0, -1 1, 1 1))')))" ), tr( "'LineString(1 1,0 0,-1 1,1 1)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(boundary(geom_from_wkt('LineString(1 1,0 0,-1 1)')))" ), tr( "'MultiPoint ((1 1),(-1 1))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "polygon,linestrings,instance,combinatorial,topological,points,collections,types,ring,boundary,closure" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "bounds" ),
    Help( QStringLiteral( "bounds" ), tr( "function" ), tr( "Returns a geometry which represents the bounding box of an input geometry. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "bounds" ), tr( "Returns a geometry which represents the bounding box of an input geometry. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "bounds(@geometry)" ), tr( "bounding box of the current feature's geometry" ), QString() )
            << HelpExample( tr( "geom_to_wkt(bounds(geom_from_wkt('Polygon((1 1, 0 0, -1 1, 1 1))')))" ), tr( "'Polygon ((-1 0, 1 0, 1 1, -1 1, -1 0))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "box,input,spatial,reference,calculations,system,represents,bounding" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "bounds_height" ),
    Help( QStringLiteral( "bounds_height" ), tr( "function" ), tr( "Returns the height of the bounding box of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "bounds_height" ), tr( "Returns the height of the bounding box of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "bounds_height(@geometry)" ), tr( "height of bounding box of the current feature's geometry" ), QString() )
            << HelpExample( tr( "bounds_height(geom_from_wkt('Polygon((1 1, 0 0, -1 1, 1 1))'))" ), tr( "1" ), QString() ),
          QString(),
          QStringList()
            << tr( "box,spatial,reference,calculations,system,height,bounding" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "bounds_width" ),
    Help( QStringLiteral( "bounds_width" ), tr( "function" ), tr( "Returns the width of the bounding box of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "bounds_width" ), tr( "Returns the width of the bounding box of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "bounds_width(@geometry)" ), tr( "width of bounding box of the current feature's geometry" ), QString() )
            << HelpExample( tr( "bounds_width(geom_from_wkt('Polygon((1 1, 0 0, -1 1, 1 1))'))" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "width,box,spatial,reference,calculations,system,bounding" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "buffer" ),
    Help( QStringLiteral( "buffer" ), tr( "function" ), tr( "Returns a geometry that represents all points whose distance from this geometry is less than or equal to distance. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "buffer" ), tr( "Returns a geometry that represents all points whose distance from this geometry is less than or equal to distance. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "buffer distance in layer units" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "number of segments to use to represent a quarter circle when a round join style is used. A larger number results in a smoother buffer with more nodes." ), false, false, true, QStringLiteral( "8" ) )
              << HelpArg( QStringLiteral( "cap" ), tr( "end cap style for buffer. Valid values are 'round', 'flat' or 'square'" ), false, false, true, QStringLiteral( "'round'" ) )
              << HelpArg( QStringLiteral( "join" ), tr( "join style for buffer. Valid values are 'round', 'bevel' or 'miter'." ), false, false, true, QStringLiteral( "'round'" ) )
              << HelpArg( QStringLiteral( "miter_limit" ), tr( "miter distance limit, for use when the join style is set to 'miter'" ), false, false, true, QStringLiteral( "2" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "buffer(@geometry, 10.5)" ), tr( "polygon of the current feature's geometry buffered by 10.5 units" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,equal,spatial,reference,calculations,system,points,segments,miter,join,cap,round" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "buffer_by_m" ),
    Help( QStringLiteral( "buffer_by_m" ), tr( "function" ), tr( "Creates a buffer along a line geometry where the buffer diameter varies according to the m-values at the line vertices." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "buffer_by_m" ), tr( "Creates a buffer along a line geometry where the buffer diameter varies according to the m-values at the line vertices." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "input geometry. Must be a (multi)line geometry with m values." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "number of segments to approximate quarter-circle curves in the buffer." ), false, false, true, QStringLiteral( "8" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "buffer_by_m(geometry:=geom_from_wkt('LINESTRINGM(1 2 0.5, 4 2 0.2)'),segments:=8)" ), tr( "A variable width buffer starting with a diameter of 0.5 and ending with a diameter of 0.2 along the linestring geometry." ), QString() ),
          QString(),
          QStringList()
            << tr( "line,according,values,varies,vertices,buffer,diameter" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ceil" ),
    Help( QStringLiteral( "ceil" ), tr( "function" ), tr( "Rounds a number upwards." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "ceil" ), tr( "Rounds a number upwards." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "a number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ceil(4.9)" ), tr( "5" ), QString() )
            << HelpExample( tr( "ceil(-4.9)" ), tr( "-4" ), QString() ),
          QString(),
          QStringList()
            << tr( "rounds,number" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "centroid" ),
    Help( QStringLiteral( "centroid" ), tr( "function" ), tr( "Returns the geometric center of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "centroid" ), tr( "Returns the geometric center of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "centroid(@geometry)" ), tr( "a point geometry" ), QString() ),
          QString(),
          QStringList()
            << tr( "geometric,center" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "char" ),
    Help( QStringLiteral( "char" ), tr( "function" ), tr( "Returns the character associated with a unicode code." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "char" ), tr( "Returns the character associated with a unicode code." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "code" ), tr( "a unicode code number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "char(81)" ), tr( "'Q'" ), QString() ),
          QString(),
          QStringList()
            << tr( "associated,character,unicode,code" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "clamp" ),
    Help( QStringLiteral( "clamp" ), tr( "function" ), tr( "Restricts an input value to a specified range." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "clamp" ), tr( "Restricts an input value to a specified range." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "minimum" ), tr( "the smallest value <i>input</i> is allowed to take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "input" ), tr( "a value which will be restricted to the range specified by <i>minimum</i> and <i>maximum</i>" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "maximum" ), tr( "the largest value <i>input</i> is allowed to take" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "clamp(1,5,10)" ), tr( "5" ), tr( "<i>input</i> is between 1 and 10 so is returned unchanged" ) )
            << HelpExample( tr( "clamp(1,0,10)" ), tr( "1" ), tr( "<i>input</i> is less than minimum value of 1, so function returns 1" ) )
            << HelpExample( tr( "clamp(1,11,10)" ), tr( "10" ), tr( "<i>input</i> is greater than maximum value of 10, so function returns 10" ) ),
          QString(),
          QStringList()
            << tr( "specified,restricts,input,range" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "close_line" ),
    Help( QStringLiteral( "close_line" ), tr( "function" ), tr( "Returns a closed line string of the input line string by appending the first point to the end of the line, if it is not already closed. If the geometry is not a line string or multi line string then the result will be NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "close_line" ), tr( "Returns a closed line string of the input line string by appending the first point to the end of the line, if it is not already closed. If the geometry is not a line string or multi line string then the result will be NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a line string geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(close_line(geom_from_wkt('LINESTRING(0 0, 1 0, 1 1)')))" ), tr( "'LineString (0 0, 1 0, 1 1, 0 0)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(close_line(geom_from_wkt('LINESTRING(0 0, 1 0, 1 1, 0 0)')))" ), tr( "'LineString (0 0, 1 0, 1 1, 0 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "first,point,closed,end,input,appending,result,line,multi" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "closest_point" ),
    Help( QStringLiteral( "closest_point" ), tr( "function" ), tr( "Returns the point on geometry1 that is closest to geometry2." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "closest_point" ), tr( "Returns the point on geometry1 that is closest to geometry2." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "geometry to find closest point on" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "geometry to find closest point to" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(closest_point(geom_from_wkt('LINESTRING (20 80, 98 190, 110 180, 50 75 )'),geom_from_wkt('POINT(100 100)')))" ), tr( "'Point(73.0769 115.384)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "closest,point,nearest" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "coalesce" ),
    Help( QStringLiteral( "coalesce" ), tr( "function" ), tr( "Returns the first non-NULL value from the expression list.<br>This function can take any number of arguments." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "coalesce" ), tr( "Returns the first non-NULL value from the expression list.<br>This function can take any number of arguments." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "expression2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "any valid expression or value, regardless of type." ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "coalesce(NULL, 2)" ), tr( "2" ), QString() )
            << HelpExample( tr( "coalesce(NULL, 2, 3)" ), tr( "2" ), QString() )
            << HelpExample( tr( "coalesce(7, NULL, 3*2)" ), tr( "7" ), QString() )
            << HelpExample( tr( "coalesce(\"fieldA\", \"fallbackField\", 'ERROR')" ), tr( "value of fieldA if it is non-NULL else the value of \"fallbackField\" or the string 'ERROR' if both are NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "list,first,arguments,null" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "collect" ),
    Help( QStringLiteral( "collect" ), tr( "function" ), tr( "Returns the multipart geometry of aggregated geometries from an expression" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "collect" ), tr( "Returns the multipart geometry of aggregated geometries from an expression" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "geometry expression to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "collect( @geometry )" ), tr( "multipart geometry of aggregated geometries" ), QString() )
            << HelpExample( tr( "collect( centroid(@geometry), group_by:=\"region\", filter:= \"use\" = 'civilian' )" ), tr( "aggregated centroids of the civilian features based on their region value" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregated,multipart" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "collect_geometries" ),
    Help( QStringLiteral( "collect_geometries" ), tr( "function" ), tr( "Collects a set of geometries into a multi-part geometry object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "List of arguments variant" ), tr( "Geometry parts are specified as separate arguments to the function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(collect_geometries(make_point(1,2), make_point(3,4), make_point(5,6)))" ), tr( "'MultiPoint ((1 2),(3 4),(5 6))'" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Array variant" ), tr( "Geometry parts are specified as an array of geometry parts." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "array of geometry objects" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(collect_geometries(array(make_point(1,2), make_point(3,4), make_point(5,6))))" ), tr( "'MultiPoint ((1 2),(3 4),(5 6))'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_cmyk" ),
    Help( QStringLiteral( "color_cmyk" ), tr( "function" ), tr( "Returns a string representation of a color based on its cyan, magenta, yellow and black components" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_cmyk" ), tr( "Returns a string representation of a color based on its cyan, magenta, yellow and black components" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "cyan" ), tr( "cyan component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "magenta" ), tr( "magenta component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "yellow" ), tr( "yellow component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "black" ), tr( "black component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_cmyk(100,50,0,10)" ), tr( "'0,115,230'" ), QString() ),
          QString(),
          QStringList()
            << tr( "cyan,color,black,yellow,representation,components" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_cmyka" ),
    Help( QStringLiteral( "color_cmyka" ), tr( "function" ), tr( "Returns a string representation of a color based on its cyan, magenta, yellow, black and alpha (transparency) components" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_cmyka" ), tr( "Returns a string representation of a color based on its cyan, magenta, yellow, black and alpha (transparency) components" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "cyan" ), tr( "cyan component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "magenta" ), tr( "magenta component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "yellow" ), tr( "yellow component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "black" ), tr( "black component of the color, as a percentage integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as an integer value from 0 (completely transparent) to 255 (opaque)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_cmyka(100,50,0,10,200)" ), tr( "'0,115,230,200'" ), QString() ),
          QString(),
          QStringList()
            << tr( "cyan,alpha,color,black,yellow,representation,components" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_cmykf" ),
    Help( QStringLiteral( "color_cmykf" ), tr( "function" ), tr( "Returns a color object based on its cyan, magenta, yellow, black and alpha components." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_cmykf" ), tr( "Returns a color object based on its cyan, magenta, yellow, black and alpha components." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "cyan" ), tr( "cyan component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "magenta" ), tr( "magenta component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "yellow" ), tr( "yellow component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "black" ), tr( "black component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as a float value from 0.0 to 1.0" ), false, false, true, QStringLiteral( "1.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_cmykf(1,0.9,0.81,0.62)" ), tr( "CMYKA: 1.00,0.90,0.81,0.62,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "cyan,magenta,yellow,black,alpha,color,components" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_grayscale_average" ),
    Help( QStringLiteral( "color_grayscale_average" ), tr( "function" ), tr( "Applies a grayscale filter to a color and returns it. Returned type is the same as color argument, i.e. a color string representation or a color object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_grayscale_average" ), tr( "Applies a grayscale filter to a color and returns it. Returned type is the same as color argument, i.e. a color string representation or a color object." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color" ), tr( "a color string representation or a color object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_grayscale_average('255,100,50')" ), tr( "'135,135,135,255'" ), QString() )
            << HelpExample( tr( "color_grayscale_average(color_cmykf(0.6,0.5,0.1,0.8))" ), tr( "CMYKA: 0.40,0.40,0.40,0.80,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "filter,color,provided,applies,grayscale,representation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_hsl" ),
    Help( QStringLiteral( "color_hsl" ), tr( "function" ), tr( "Returns a string representation of a color based on its hue, saturation, and lightness attributes." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_hsl" ), tr( "Returns a string representation of a color based on its hue, saturation, and lightness attributes." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hue" ), tr( "hue of the color, as an integer value from 0 to 360" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "saturation" ), tr( "saturation percentage of the color as an integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "lightness" ), tr( "lightness percentage of the color as an integer value from 0 to 100" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_hsl(100,50,70)" ), tr( "'166,217,140'" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,lightness,color,hue,representation,saturation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_hsla" ),
    Help( QStringLiteral( "color_hsla" ), tr( "function" ), tr( "Returns a string representation of a color based on its hue, saturation, lightness and alpha (transparency) attributes" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_hsla" ), tr( "Returns a string representation of a color based on its hue, saturation, lightness and alpha (transparency) attributes" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hue" ), tr( "hue of the color, as an integer value from 0 to 360" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "saturation" ), tr( "saturation percentage of the color as an integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "lightness" ), tr( "lightness percentage of the color as an integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as an integer value from 0 (completely transparent) to 255 (opaque)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_hsla(100,50,70,200)" ), tr( "'166,217,140,200'" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,alpha,lightness,color,transparency,hue,representation,saturation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_hslf" ),
    Help( QStringLiteral( "color_hslf" ), tr( "function" ), tr( "Returns a color object based on its hue, saturation, and lightness attributes." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_hslf" ), tr( "Returns a color object based on its hue, saturation, and lightness attributes." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hue" ), tr( "hue of the color, as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "saturation" ), tr( "saturation of the color as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "lightness" ), tr( "lightness of the color as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as a float value from 0.0 to 1.0" ), false, false, true, QStringLiteral( "1.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_hslf(0.3,0.52,0.7)" ), tr( "HSLA: 0.30,0.52,0.70,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,lightness,color,hue,saturation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_hsv" ),
    Help( QStringLiteral( "color_hsv" ), tr( "function" ), tr( "Returns a string representation of a color based on its hue, saturation, and value attributes." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_hsv" ), tr( "Returns a string representation of a color based on its hue, saturation, and value attributes." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hue" ), tr( "hue of the color, as an integer value from 0 to 360" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "saturation" ), tr( "saturation percentage of the color as an integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "value percentage of the color as an integer from 0 to 100" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_hsv(40,100,100)" ), tr( "'255,170,0'" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,color,hue,representation,saturation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_hsva" ),
    Help( QStringLiteral( "color_hsva" ), tr( "function" ), tr( "Returns a string representation of a color based on its hue, saturation, value and alpha (transparency) attributes." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_hsva" ), tr( "Returns a string representation of a color based on its hue, saturation, value and alpha (transparency) attributes." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hue" ), tr( "hue of the color, as an integer value from 0 to 360" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "saturation" ), tr( "saturation percentage of the color as an integer value from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "value percentage of the color as an integer from 0 to 100" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as an integer value from 0 (completely transparent) to 255 (opaque)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_hsva(40,100,100,200)" ), tr( "'255,170,0,200'" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,alpha,color,transparency,hue,representation,saturation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_hsvf" ),
    Help( QStringLiteral( "color_hsvf" ), tr( "function" ), tr( "Returns a color object based on its hue, saturation, and value attributes." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_hsvf" ), tr( "Returns a color object based on its hue, saturation, and value attributes." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hue" ), tr( "hue of the color, as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "saturation" ), tr( "saturation of the color as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "value of the color as as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as a float value from 0.0 to 1.0" ), false, false, true, QStringLiteral( "1.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_hsvf(0.4,1,0.6)" ), tr( "HSVA: 0.40,1.00,0.60,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,color,hue,saturation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_mix" ),
    Help( QStringLiteral( "color_mix" ), tr( "function" ), tr( "Returns a color mixing the red, green, blue, and alpha values of two provided colors based on a given ratio. Returned type is the same as color arguments, i.e. a color string representation or a color object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_mix" ), tr( "Returns a color mixing the red, green, blue, and alpha values of two provided colors based on a given ratio. Returned type is the same as color arguments, i.e. a color string representation or a color object." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color1" ), tr( "a color string or a color object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "color2" ), tr( "a color string or a color object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "ratio" ), tr( "a ratio" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_mix_rgb('0,0,0','255,255,255',0.5)" ), tr( "'127,127,127,255'" ), QString() )
            << HelpExample( tr( "color_mix(color_cmykf(0.9,0.9,0.9,0.9),color_cmykf(0.1,0.1,0.1,0.1),0.5)" ), tr( "CMYKA: 0.50,0.50,0.50,0.50,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "green,blue,red,alpha,mixing,color,colors,provided,ratio" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_mix_rgb" ),
    Help( QStringLiteral( "color_mix_rgb" ), tr( "function" ), tr( "Returns a string representing a color mixing the red, green, blue, and alpha values of two provided colors based on a given ratio." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_mix_rgb" ), tr( "Returns a string representing a color mixing the red, green, blue, and alpha values of two provided colors based on a given ratio." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color1" ), tr( "a color string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "color2" ), tr( "a color string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "ratio" ), tr( "a ratio" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_mix_rgb('0,0,0','255,255,255',0.5)" ), tr( "'127,127,127,255'" ), QString() ),
          QString(),
          QStringList()
            << tr( "green,blue,red,alpha,mixing,color,colors,provided,ratio" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_part" ),
    Help( QStringLiteral( "color_part" ), tr( "function" ), tr( "Returns a specific component from a color string or color object, e.g., the red component or alpha component." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_part" ), tr( "Returns a specific component from a color string or color object, e.g., the red component or alpha component." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color" ), tr( "a color string or a color object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "component" ), tr( "a string corresponding to the color component to return. Valid options are:<br /><ul><li>red: RGB red component (0-255)</li><li>green: RGB green component (0-255)</li><li>blue: RGB blue component (0-255)</li><li>alpha: alpha (transparency) value (0-255)</li><li>hue: HSV hue (0-360)</li><li>saturation: HSV saturation (0-100)</li><li>value: HSV value (0-100)</li><li>hsl_hue: HSL hue (0-360)</li><li>hsl_saturation: HSL saturation (0-100)</li><li>lightness: HSL lightness (0-100)</li><li>cyan: CMYK cyan component (0-100)</li><li>magenta: CMYK magenta component (0-100)</li><li>yellow: CMYK yellow component (0-100)</li><li>black: CMYK black component (0-100)</li></ul>" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_part('200,10,30','green')" ), tr( "10" ), QString() )
            << HelpExample( tr( "to_int(color_part(color_cmykf(0.1,0.2,0.3,0.9),'black'))" ), tr( "90" ), QString() ),
          QString(),
          QStringList()
            << tr( "red,specific,color,component,alpha" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_rgb" ),
    Help( QStringLiteral( "color_rgb" ), tr( "function" ), tr( "Returns a string representation of a color based on its red, green, and blue components." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_rgb" ), tr( "Returns a string representation of a color based on its red, green, and blue components." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "red" ), tr( "red component as an integer value from 0 to 255" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "green" ), tr( "green component as an integer value from 0 to 255" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "blue" ), tr( "blue component as an integer value from 0 to 255" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_rgb(255,127,0)" ), tr( "'255,127,0'" ), QString() ),
          QString(),
          QStringList()
            << tr( "green,blue,red,color,representation,components" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_rgba" ),
    Help( QStringLiteral( "color_rgba" ), tr( "function" ), tr( "Returns a string representation of a color based on its red, green, blue, and alpha (transparency) components." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_rgba" ), tr( "Returns a string representation of a color based on its red, green, blue, and alpha (transparency) components." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "red" ), tr( "red component as an integer value from 0 to 255" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "green" ), tr( "green component as an integer value from 0 to 255" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "blue" ), tr( "blue component as an integer value from 0 to 255" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as an integer value from 0 (completely transparent) to 255 (opaque)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_rgba(255,127,0,200)" ), tr( "'255,127,0,200'" ), QString() ),
          QString(),
          QStringList()
            << tr( "green,blue,red,alpha,color,representation,components" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "color_rgbf" ),
    Help( QStringLiteral( "color_rgbf" ), tr( "function" ), tr( "Returns a color object based on its red, green, blue and alpha components." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "color_rgbf" ), tr( "Returns a color object based on its red, green, blue and alpha components." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "red" ), tr( "red component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "green" ), tr( "green component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "blue" ), tr( "blue component as a float value from 0.0 to 1.0" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alpha" ), tr( "alpha component as a float value from 0.0 to 1.0" ), false, false, true, QStringLiteral( "1.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "color_rgbf(1.0,0.5,0)" ), tr( "RGBA: 1.00,0.50,0.00,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "green,blue,red,alpha,color,components" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "combine" ),
    Help( QStringLiteral( "combine" ), tr( "function" ), tr( "Returns the combination of two geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "combine" ), tr( "Returns the combination of two geometries." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( combine( geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 2 1)' ) ) )" ), tr( "'MULTILINESTRING((4 4, 2 1), (3 3, 4 4), (4 4, 5 5))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt( combine( geom_from_wkt( 'LINESTRING(3 3, 4 4)' ), geom_from_wkt( 'LINESTRING(3 3, 6 6, 2 1)' ) ) )" ), tr( "'LINESTRING(3 3, 4 4, 6 6, 2 1)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "combination,union" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "concat" ),
    Help( QStringLiteral( "concat" ), tr( "function" ), tr( "Concatenates several strings to one. NULL values are converted to empty strings. Other values (like numbers) are converted to strings." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "concat" ), tr( "Concatenates several strings to one. NULL values are converted to empty strings. Other values (like numbers) are converted to strings." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "string2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "string" ), tr( "a string value" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "concat('sun', 'set')" ), tr( "'sunset'" ), QString() )
            << HelpExample( tr( "concat('a','b','c','d','e')" ), tr( "'abcde'" ), QString() )
            << HelpExample( tr( "concat('Anno ', 1984)" ), tr( "'Anno 1984'" ), QString() )
            << HelpExample( tr( "concat('The Wall', NULL)" ), tr( "'The Wall'" ), QString() ),
          QString(),
          QStringList()
            << tr( "empty,converted,numbers,concatenates,null,strings,several,other,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "concatenate" ),
    Help( QStringLiteral( "concatenate" ), tr( "function" ), tr( "Returns all aggregated strings from a field or expression joined by a delimiter." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "concatenate" ), tr( "Returns all aggregated strings from a field or expression joined by a delimiter." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "concatenator" ), tr( "optional string to use to join values. Empty by default." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "order_by" ), tr( "optional expression to use to order features used to calculate aggregate. By default, the features will be returned in an unspecified order." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "concatenate(\"town_name\",group_by:=\"state\",concatenator:=',')" ), tr( "comma separated list of town_names, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregated,field,joined,delimiter,strings" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "concatenate_unique" ),
    Help( QStringLiteral( "concatenate_unique" ), tr( "function" ), tr( "Returns all unique strings from a field or expression joined by a delimiter." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "concatenate_unique" ), tr( "Returns all unique strings from a field or expression joined by a delimiter." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "concatenator" ), tr( "optional string to use to join values. Empty by default." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "order_by" ), tr( "optional expression to use to order features used to calculate aggregate. By default, the features will be returned in an unspecified order." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "concatenate_unique(\"town_name\",group_by:=\"state\",concatenator:=',')" ), tr( "comma separated list of unique town_names, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregated,unique,field,joined,delimiter,strings" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "concave_hull" ),
    Help( QStringLiteral( "concave_hull" ), tr( "function" ), tr( "Returns a possibly concave polygon that contains all the points in the geometry" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "concave_hull" ), tr( "Returns a possibly concave polygon that contains all the points in the geometry" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "target_percent" ), tr( "the percentage of area of the convex hull the solution tries to approach. A target_percent of 1 gives the same result as the convex hull. A target_percent between 0 and 0.99 produces a result that should have a smaller area than the convex hull." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "allow_holes" ), tr( "optional argument specifying whether to allow holes within the output geometry. Defaults to FALSE, set to TRUE to allow including holes in the output geometry." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(concave_hull(geom_from_wkt('MULTILINESTRING((106 164,30 112,74 70,82 112,130 94,130 62,122 40,156 32,162 76,172 88),(132 178,134 148,128 136,96 128,132 108,150 130,170 142,174 110,156 96,158 90,158 88),(22 64,66 28,94 38,94 68,114 76,112 30,132 10,168 18,178 34,186 52,184 74,190 100,190 122,182 148,178 170,176 184,156 164,146 178,132 186,92 182,56 158,36 150,62 150,76 128,88 118))'), 0.99))" ), tr( "'Polygon ((30 112, 36 150, 92 182, 132 186, 176 184, 190 122, 190 100, 186 52, 178 34, 168 18, 132 10, 112 30, 66 28, 22 64, 30 112))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "hull,concave,represents,encloses,set" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "contains" ),
    Help( QStringLiteral( "contains" ), tr( "function" ), tr( "Tests whether a geometry contains another. Returns TRUE if and only if no points of geometry2 lie in the exterior of geometry1, and at least one point of the interior of geometry2 lies in the interior of geometry1." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "contains" ), tr( "Tests whether a geometry contains another. Returns TRUE if and only if no points of geometry2 lie in the exterior of geometry1, and at least one point of the interior of geometry2 lies in the interior of geometry1." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "contains( geom_from_wkt( 'POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))' ), geom_from_wkt( 'POINT(0.5 0.5 )' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "contains( geom_from_wkt( 'POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "lie,point,lies,tests,interior,exterior,within,points,contains" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "convex_hull" ),
    Help( QStringLiteral( "convex_hull" ), tr( "function" ), tr( "Returns the convex hull of a geometry. It represents the minimum convex geometry that encloses all geometries within the set." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "convex_hull" ), tr( "Returns the convex hull of a geometry. It represents the minimum convex geometry that encloses all geometries within the set." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( convex_hull( geom_from_wkt( 'LINESTRING(3 3, 4 4, 4 10)' ) ) )" ), tr( "'POLYGON((3 3, 4 10, 4 4, 3 3))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "hull,convex,minimum,represents,encloses,set" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "cos" ),
    Help( QStringLiteral( "cos" ), tr( "function" ), tr( "Returns cosine of an angle." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "cos" ), tr( "Returns cosine of an angle." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "angle" ), tr( "angle in radians" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "cos(1.571)" ), tr( "0.000796326710733263" ), QString() ),
          QString(),
          QStringList()
            << tr( "angle,cosine" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "count" ),
    Help( QStringLiteral( "count" ), tr( "function" ), tr( "Returns the count of matching features." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "count" ), tr( "Returns the count of matching features." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "count(\"stations\",group_by:=\"state\")" ), tr( "count of stations, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregate,features,matching,count" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "count_distinct" ),
    Help( QStringLiteral( "count_distinct" ), tr( "function" ), tr( "Returns the count of distinct values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "count_distinct" ), tr( "Returns the count of distinct values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "count_distinct(\"stations\",group_by:=\"state\")" ), tr( "count of distinct stations values, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregate,distinct,count" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "count_missing" ),
    Help( QStringLiteral( "count_missing" ), tr( "function" ), tr( "Returns the count of missing (NULL) values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "count_missing" ), tr( "Returns the count of missing (NULL) values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "count_missing(\"stations\",group_by:=\"state\")" ), tr( "count of missing (NULL) station values, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "aggregate,missing,count" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "create_ramp" ),
    Help( QStringLiteral( "create_ramp" ), tr( "function" ), tr( "Returns a gradient ramp from a map of color strings and steps." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "create_ramp" ), tr( "Returns a gradient ramp from a map of color strings and steps." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map of color strings and steps" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "discrete" ), tr( "set this parameter to true to create a discrete color ramp" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ramp_color(create_ramp(map(0,'0,0,0',1,'255,0,0')),1)" ), tr( "'255,0,0,255'" ), QString() ),
          QString(),
          QStringList()
            << tr( "map,gradient,steps,strings,ramp,color" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "crosses" ),
    Help( QStringLiteral( "crosses" ), tr( "function" ), tr( "Tests whether a geometry crosses another. Returns TRUE if the supplied geometries have some, but not all, interior points in common." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "crosses" ), tr( "Tests whether a geometry crosses another. Returns TRUE if the supplied geometries have some, but not all, interior points in common." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "crosses( geom_from_wkt( 'LINESTRING(3 5, 4 4, 5 3)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "crosses( geom_from_wkt( 'POINT(4 5)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "common,supplied,crosses,tests,interior,points" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "crs_from_text" ),
    Help( QStringLiteral( "crs_from_text" ), tr( "function" ), tr( "Creates a coordinate reference system from a string definition. The string can represent an authority ID, a WKT definition, or a PROJ string definition of the CRS." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "crs_from_text" ), tr( "Creates a coordinate reference system from a string definition. The string can represent an authority ID, a WKT definition, or a PROJ string definition of the CRS." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "definition" ), tr( "CRS definition" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "crs_from_text('EPSG:3857')" ), tr( "crs value 'EPSG:3857 - WGS 84 / Pseudo-Mercator'" ), QString() )
            << HelpExample( tr( "crs_from_text('PROJ:+proj=merc +a=6378137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0=0 +y_0=0 +k=1 +units=m +nadgrids=@null +wktext +no_defs +type=crs')" ), tr( "crs value 'EPSG:3857 - WGS 84 / Pseudo-Mercator'" ), QString() ),
          QString(),
          QStringList()
            << tr( "crs,epsg" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "crs_to_authid" ),
    Help( QStringLiteral( "crs_to_authid" ), tr( "function" ), tr( "Returns the authority ID string for a coordinate reference system." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "crs_to_authid" ), tr( "Returns the authority ID string for a coordinate reference system." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "crs" ), tr( "crs value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "crs_to_authid(crs_from_text('PROJ:+proj=merc +a=6378137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0=0 +y_0=0 +k=1 +units=m +nadgrids=@null +wktext +no_defs +type=crs'))" ), tr( "'EPSG:3857'" ), QString() ),
          QString(),
          QStringList()
            << tr( "crs,epsg,authid" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "current_parent_value" ),
    Help( QStringLiteral( "current_parent_value" ), tr( "function" ), tr( "Only usable in an embedded form context, this function returns the current, unsaved value of a field in the parent form currently being edited. This will differ from the parent feature's actual attribute values for features which are currently being edited or have not yet been added to a parent layer. When used in a value-relation widget filter expression, this function should be wrapped into a 'coalesce()' that can retrieve the actual parent feature from the layer when the form is not used in an embedded context." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "current_parent_value" ), tr( "Only usable in an embedded form context, this function returns the current, unsaved value of a field in the parent form currently being edited. This will differ from the parent feature's actual attribute values for features which are currently being edited or have not yet been added to a parent layer. When used in a value-relation widget filter expression, this function should be wrapped into a 'coalesce()' that can retrieve the actual parent feature from the layer when the form is not used in an embedded context." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "field_name" ), tr( "a field name in the current parent form" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "current_parent_value( 'FIELD_NAME' )" ), tr( "The current value of a field 'FIELD_NAME' in the parent form." ), QString() ),
          QString(),
          QStringList()
            << tr( "field,actual,unsaved,wrapped,retrieve,widget,current,relation,differ,edited,embedded,coalesce,attribute,form,filter,added,features,parent,context,usable" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "current_value" ),
    Help( QStringLiteral( "current_value" ), tr( "function" ), tr( "Returns the current, unsaved value of a field in the form or table row currently being edited. This will differ from the feature's actual attribute values for features which are currently being edited or have not yet been added to a layer." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "current_value" ), tr( "Returns the current, unsaved value of a field in the form or table row currently being edited. This will differ from the feature's actual attribute values for features which are currently being edited or have not yet been added to a layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "field_name" ), tr( "a field name in the current form or table row" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "current_value( 'FIELD_NAME' )" ), tr( "The current value of field 'FIELD_NAME'." ), QString() ),
          QString(),
          QStringList()
            << tr( "table,field,actual,unsaved,current,differ,edited,row,attribute,form,added,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "darker" ),
    Help( QStringLiteral( "darker" ), tr( "function" ), tr( "Returns a darker (or lighter) color. Returned type is the same as color arguments, i.e. a color string representation or a color object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "darker" ), tr( "Returns a darker (or lighter) color. Returned type is the same as color arguments, i.e. a color string representation or a color object." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color" ), tr( "a color string or a color object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "factor" ), tr( "an integer corresponding to the darkening factor:<ul><li>if the factor is greater than 100, this function returns a darker color (e.g., setting factor to 200 returns a color that is half the brightness);</li><li>if the factor is less than 100, the return color is lighter, but using the lighter() function for this purpose is recommended;</li><li>if the factor is 0 or negative, the return value is unspecified.</li></ul>" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "darker('200,10,30', 200)" ), tr( "'100,5,15,255'" ), QString() ),
          QString(),
          QStringList()
            << tr( "darker,color,lighter" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "datetime_from_epoch" ),
    Help( QStringLiteral( "datetime_from_epoch" ), tr( "function" ), tr( "Returns a datetime whose date and time are the number of milliseconds, msecs, that have passed since 1970-01-01T00:00:00.000, Coordinated Universal Time (Qt.UTC), and converted to Qt.LocalTime." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "datetime_from_epoch" ), tr( "Returns a datetime whose date and time are the number of milliseconds, msecs, that have passed since 1970-01-01T00:00:00.000, Coordinated Universal Time (Qt.UTC), and converted to Qt.LocalTime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "int" ), tr( "number (milliseconds)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "datetime_from_epoch(1483225200000)" ), tr( "2017-01-01T00:00:00" ), QString() ),
          QString(),
          QStringList()
            << tr( "passed,datetime,localtime,msecs,date,coordinated,converted,universal,milliseconds,time" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "day" ),
    Help( QStringLiteral( "day" ), tr( "function" ), tr( "Extracts the day from a date, or the number of days from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Date variant" ), tr( "Extracts the day from a date or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "date" ), tr( "a date or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "day('2012-05-12')" ), tr( "12" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in days of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of days from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "day(to_interval('3 days'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "day(to_interval('3 weeks 2 days'))" ), tr( "23" ), QString() )
            << HelpExample( tr( "day(age('2012-01-01','2010-01-01'))" ), tr( "730" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "day_of_week" ),
    Help( QStringLiteral( "day_of_week" ), tr( "function" ), tr( "Returns the day of the week for a specified date or datetime. The returned value ranges from 0 to 6, where 0 corresponds to a Sunday and 6 to a Saturday." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "day_of_week" ), tr( "Returns the day of the week for a specified date or datetime. The returned value ranges from 0 to 6, where 0 corresponds to a Sunday and 6 to a Saturday." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "date" ), tr( "date or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "day_of_week(to_date('2015-09-21'))" ), tr( "1" ), QString() ),
          QString(),
          QStringList()
            << tr( "week,day,specified,datetime,corresponds,ranges,date,saturday" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "decode_uri" ),
    Help( QStringLiteral( "decode_uri" ), tr( "function" ), tr( "Takes a layer and decodes the uri of the underlying data provider. It depends on the dataprovider, which data is available." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "decode_uri" ), tr( "Takes a layer and decodes the uri of the underlying data provider. It depends on the dataprovider, which data is available." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "The layer for which the uri should be decoded." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "part" ), tr( "The part of the uri to return. If unspecified, a map with all uri parts will be returned." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "decode_uri(@layer)" ), tr( "{'layerId': '0', 'layerName': '', 'path': '/home/qgis/shapefile.shp'}" ), QString() )
            << HelpExample( tr( "decode_uri(@layer)" ), tr( "{'layerId': NULL, 'layerName': 'layer', 'path': '/home/qgis/geopackage.gpkg'}" ), QString() )
            << HelpExample( tr( "decode_uri(@layer, 'path')" ), tr( "'C:\\my_data\\qgis\\shape.shp'" ), QString() ),
          QString(),
          QStringList()
            << tr( "depends,layer,data,dataprovider,provider,uri,underlying,decodes,available" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "degrees" ),
    Help( QStringLiteral( "degrees" ), tr( "function" ), tr( "Converts from radians to degrees." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "degrees" ), tr( "Converts from radians to degrees." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "radians" ), tr( "numeric value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "degrees(3.14159)" ), tr( "180" ), QString() )
            << HelpExample( tr( "degrees(1)" ), tr( "57.2958" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,degrees,radians" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "densify_by_count" ),
    Help( QStringLiteral( "densify_by_count" ), tr( "function" ), tr( "Takes a polygon or line layer geometry and generates a new one in which the geometries have a larger number of vertices than the original one." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "densify_by_count" ), tr( "Takes a polygon or line layer geometry and generates a new one in which the geometries have a larger number of vertices than the original one." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry (accepts (multi)linestrings or (multi)polygons)." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertices" ), tr( "number of vertices to add (per segment)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(densify_by_count(geom_from_wkt('LINESTRING(1 1, 10 1)'), 3))" ), tr( "LineString (1 1, 3.25 1, 5.5 1, 7.75 1, 10 1)" ), QString() ),
          QString(),
          QStringList()
            << tr( "generates,layer,line,number,one,new,polygon,vertices,larger,original" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "densify_by_distance" ),
    Help( QStringLiteral( "densify_by_distance" ), tr( "function" ), tr( "Takes a polygon or line layer geometry and generates a new one in which the geometries are densified by adding additional vertices on edges that have a maximum distance of the specified interval distance." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "densify_by_distance" ), tr( "Takes a polygon or line layer geometry and generates a new one in which the geometries are densified by adding additional vertices on edges that have a maximum distance of the specified interval distance." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry (accepts (multi)linestrings or (multi)polygons)." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "maximum interval distance between vertices in output geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(densify_by_distance(geom_from_wkt('LINESTRING(1 1, 10 1)'), 4))" ), tr( "LineString (1 1, 4 1, 7 1, 10 1)" ), QString() ),
          QString(),
          QStringList()
            << tr( "maximum,edges,additional,generates,line,densified,adding,new,polygon,interval,layer,one,distance,vertices,specified" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "difference" ),
    Help( QStringLiteral( "difference" ), tr( "function" ), tr( "Returns a geometry that represents that part of geometry1 that does not intersect with geometry2." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "difference" ), tr( "Returns a geometry that represents that part of geometry1 that does not intersect with geometry2." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( difference( geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4)' ) ) )" ), tr( "'LINESTRING(4 4, 5 5)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "part,represents,intersect,clip" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "disjoint" ),
    Help( QStringLiteral( "disjoint" ), tr( "function" ), tr( "Tests whether geometries do not spatially intersect. Returns TRUE if the geometries do not share any space together." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "disjoint" ), tr( "Tests whether geometries do not spatially intersect. Returns TRUE if the geometries do not share any space together." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "disjoint( geom_from_wkt( 'POLYGON((0 0, 0 1, 1 1, 1 0, 0 0 ))' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "disjoint( geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ), geom_from_wkt( 'POINT(4 4)' ))" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "share,intersect,tests,space" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "display_expression" ),
    Help( QStringLiteral( "display_expression" ), tr( "function" ), tr( "Returns the display expression for a given feature in a layer. The expression is evaluated by default. Can be used with zero, one or more arguments, see below for details." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "No parameters" ), tr( "If called with no parameters, the function will evaluate the display expression of the current feature in the current layer." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "display_expression()" ), tr( "The display expression of the current feature in the current layer." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "One 'feature' parameter" ), tr( "If called with a 'feature' parameter only, the function will evaluate the specified feature from the current layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be evaluated." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "display_expression(@atlas_feature)" ), tr( "The display expression of the current atlas feature." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Layer and feature parameters" ), tr( "If the function is called with both a layer and a feature, it will evaluate the specified feature from the specified layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "The layer (or its ID or name)" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be evaluated." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "evaluate" ), tr( "If the expression must be evaluated. If false, the expression will be returned as a string literal only (which could potentially be later evaluated using the 'eval' function)." ), false, false, true, QStringLiteral( "true" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "display_expression( 'streets', get_feature_by_id('streets', 1))" ), tr( "The display expression of the feature with the ID 1 on the layer 'streets'." ), QString() )
            << HelpExample( tr( "display_expression('a_layer_id', @feature, 'False')" ), tr( "The display expression of the given feature not evaluated." ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "distance" ),
    Help( QStringLiteral( "distance" ), tr( "function" ), tr( "Returns the minimum distance (based on spatial reference) between two geometries in projected units." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "distance" ), tr( "Returns the minimum distance (based on spatial reference) between two geometries in projected units." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "distance( geom_from_wkt( 'POINT(4 4)' ), geom_from_wkt( 'POINT(4 8)' ) )" ), tr( "4" ), QString() ),
          QString(),
          QStringList()
            << tr( "projected,reference,spatial,minimum,units" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "distance_to_vertex" ),
    Help( QStringLiteral( "distance_to_vertex" ), tr( "function" ), tr( "Returns the distance along the geometry to a specified vertex." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "distance_to_vertex" ), tr( "Returns the distance along the geometry to a specified vertex." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertex" ), tr( "vertex index, starting from 0; if the value is negative, the selected vertex index will be its total count minus the absolute value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "distance_to_vertex(geometry:=geom_from_wkt('LineString(0 0, 10 0, 10 10)'),vertex:=1)" ), tr( "10.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,specified,vertex" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "end_point" ),
    Help( QStringLiteral( "end_point" ), tr( "function" ), tr( "Returns the last node from a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "end_point" ), tr( "Returns the last node from a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(end_point(geom_from_wkt('LINESTRING(4 0, 4 2, 0 2)')))" ), tr( "'Point (0 2)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "last,node,vertex" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "env" ),
    Help( QStringLiteral( "env" ), tr( "function" ), tr( "Gets an environment variable and returns its content as a string. If the variable is not found, NULL will be returned. This is handy to inject system specific configuration like drive letters or path prefixes. Definition of environment variables depends on the operating system, please check with your system administrator or the operating system documentation how this can be set." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "env" ), tr( "Gets an environment variable and returns its content as a string. If the variable is not found, NULL will be returned. This is handy to inject system specific configuration like drive letters or path prefixes. Definition of environment variables depends on the operating system, please check with your system administrator or the operating system documentation how this can be set." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "The name of the environment variable which should be retrieved." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "env( 'LANG' )" ), tr( "'en_US.UTF-8'" ), QString() )
            << HelpExample( tr( "env( 'MY_OWN_PREFIX_VAR' )" ), tr( "'Z:'" ), QString() )
            << HelpExample( tr( "env( 'I_DO_NOT_EXIST' )" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "operating,content,prefixes,gets,definition,found,drive,check,system,environment,path,variables,letters,inject,specific,configuration,depends,administrator,variable,documentation,handy,set" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "epoch" ),
    Help( QStringLiteral( "epoch" ), tr( "function" ), tr( "Returns the interval in milliseconds between the unix epoch and a given date value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "epoch" ), tr( "Returns the interval in milliseconds between the unix epoch and a given date value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "date" ), tr( "a date or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "epoch(to_date('2017-01-01'))" ), tr( "1483203600000" ), QString() ),
          QString(),
          QStringList()
            << tr( "interval,date,milliseconds,epoch" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "eval" ),
    Help( QStringLiteral( "eval" ), tr( "function" ), tr( "Evaluates an expression which is passed in a string. Useful to expand dynamic parameters passed as context variables or fields." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "eval" ), tr( "Evaluates an expression which is passed in a string. Useful to expand dynamic parameters passed as context variables or fields." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "an expression string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "eval('\\'nice\\'')" ), tr( "'nice'" ), QString() )
            << HelpExample( tr( "eval(@expression_var)" ), tr( "[whatever the result of evaluating @expression_var might be…]" ), QString() ),
          QString(),
          QStringList()
            << tr( "dynamic,fields,parameters,expression,expand,context,passed,variables,evaluates" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "eval_template" ),
    Help( QStringLiteral( "eval_template" ), tr( "function" ), tr( "Evaluates a template which is passed in a string. Useful to expand dynamic parameters passed as context variables or fields." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "eval_template" ), tr( "Evaluates a template which is passed in a string. Useful to expand dynamic parameters passed as context variables or fields." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "template" ), tr( "a template string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "eval_template('QGIS [% upper(\\'rocks\\') %]')" ), tr( "QGIS ROCKS" ), QString() ),
          QString(),
          QStringList()
            << tr( "dynamic,fields,parameters,template,expand,context,passed,variables,evaluates" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "exif" ),
    Help( QStringLiteral( "exif" ), tr( "function" ), tr( "Retrieves exif tag values from an image file." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "exif" ), tr( "Retrieves exif tag values from an image file." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "An image file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "tag" ), tr( "The tag to return. If empty, a map with all exif tag values will be returned." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "exif('/my/photo.jpg','Exif.Image.Orientation')" ), tr( "0" ), QString() ),
          QString(),
          QStringList()
            << tr( "exif,retrieves,tag,file,image,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "exif_geotag" ),
    Help( QStringLiteral( "exif_geotag" ), tr( "function" ), tr( "Creates a point geometry from the exif geotags of an image file." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "exif_geotag" ), tr( "Creates a point geometry from the exif geotags of an image file." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "An image file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(exif_geotag('/my/photo.jpg'))" ), tr( "'Point (2 4)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "geotags,exif,point,file,image" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "exp" ),
    Help( QStringLiteral( "exp" ), tr( "function" ), tr( "Returns exponential of an value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "exp" ), tr( "Returns exponential of an value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "number to return exponent of" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "exp(1.0)" ), tr( "2.71828182845905" ), QString() ),
          QString(),
          QStringList()
            << tr( "exponential" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "extend" ),
    Help( QStringLiteral( "extend" ), tr( "function" ), tr( "Extends the start and end of a linestring geometry by a specified amount. Lines are extended using the bearing of the first and last segment in the line. For a multilinestring, all the parts are extended. Distances are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "extend" ), tr( "Extends the start and end of a linestring geometry by a specified amount. Lines are extended using the bearing of the first and last segment in the line. For a multilinestring, all the parts are extended. Distances are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a (multi)linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "start_distance" ), tr( "distance to extend the start of the line" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "end_distance" ), tr( "distance to extend the end of the line." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(extend(geom_from_wkt('LineString(0 0, 1 0, 1 1)'),1,2))" ), tr( "'LineString (-1 0, 1 0, 1 3)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(extend(geom_from_wkt('MultiLineString((0 0, 1 0, 1 1), (2 2, 0 2, 0 5))'),1,2))" ), tr( "'MultiLineString ((-1 0, 1 0, 1 3),(3 2, 0 2, 0 7))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "start,distances,line,last,linestring,amount,parts,bearing,lines,extends,reference,spatial,extended,first,segment,system,multilinestring,specified,end" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "exterior_ring" ),
    Help( QStringLiteral( "exterior_ring" ), tr( "function" ), tr( "Returns a line string representing the exterior ring of a polygon geometry. If the geometry is not a polygon then the result will be NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "exterior_ring" ), tr( "Returns a line string representing the exterior ring of a polygon geometry. If the geometry is not a polygon then the result will be NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a polygon geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(exterior_ring(geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1),( 0.1 0.1, 0.1 0.2, 0.2 0.2, 0.2, 0.1, 0.1 0.1))')))" ), tr( "'LineString (-1 -1, 4 0, 4 2, 0 2, -1 -1)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "polygon,line,ring,exterior,result,representing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "extrude" ),
    Help( QStringLiteral( "extrude" ), tr( "function" ), tr( "Returns an extruded version of the input (Multi-)Curve or (Multi-)Linestring geometry with an extension specified by x and y." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "extrude" ), tr( "Returns an extruded version of the input (Multi-)Curve or (Multi-)Linestring geometry with an extension specified by x and y." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a curve or linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "x" ), tr( "x extension, numeric value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "y" ), tr( "y extension, numeric value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(extrude(geom_from_wkt('LineString(1 2, 3 2, 4 3)'), 1, 2))" ), tr( "'Polygon ((1 2, 3 2, 4 3, 5 5, 4 4, 2 4, 1 2))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(extrude(geom_from_wkt('MultiLineString((1 2, 3 2), (4 3, 8 3))'), 1, 2))" ), tr( "'MultiPolygon (((1 2, 3 2, 4 4, 2 4, 1 2)),((4 3, 8 3, 9 5, 5 5, 4 3)))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "curve,version,extension,input,specified,extruded,linestring,multi" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "feature_id" ),
    Help( QStringLiteral( "feature_id" ), tr( "function" ), tr( "Returns a feature's unique ID, or NULL if the feature is not valid." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "feature_id" ), tr( "Returns a feature's unique ID, or NULL if the feature is not valid." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "a feature object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "feature_id( @feature )" ), tr( "the ID of the current feature" ), QString() ),
          QString(),
          QStringList()
            << QString()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "file_exists" ),
    Help( QStringLiteral( "file_exists" ), tr( "function" ), tr( "Returns TRUE if a file path exists." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "file_exists" ), tr( "Returns TRUE if a file path exists." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "file_exists('/home/qgis/data/country_boundaries.shp')" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "path,exists,file" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "file_name" ),
    Help( QStringLiteral( "file_name" ), tr( "function" ), tr( "Returns the name of a file (including the file extension), excluding the directory." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "file_name" ), tr( "Returns the name of a file (including the file extension), excluding the directory." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "file_name('/home/qgis/data/country_boundaries.shp')" ), tr( "'country_boundaries.shp'" ), QString() ),
          QString(),
          QStringList()
            << tr( "extension,name,directory,file,path" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "file_path" ),
    Help( QStringLiteral( "file_path" ), tr( "function" ), tr( "Returns the directory component of a file path. This does not include the file name." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "file_path" ), tr( "Returns the directory component of a file path. This does not include the file name." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "file_path('/home/qgis/data/country_boundaries.shp')" ), tr( "'/home/qgis/data'" ), QString() ),
          QString(),
          QStringList()
            << tr( "path,directory,name,folder,file" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "file_size" ),
    Help( QStringLiteral( "file_size" ), tr( "function" ), tr( "Returns the size (in bytes) of a file." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "file_size" ), tr( "Returns the size (in bytes) of a file." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "file_size('/home/qgis/data/country_boundaries.geojson')" ), tr( "5674" ), QString() ),
          QString(),
          QStringList()
            << tr( "size,file,bytes" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "file_suffix" ),
    Help( QStringLiteral( "file_suffix" ), tr( "function" ), tr( "Returns the file suffix (extension) from a file path." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "file_suffix" ), tr( "Returns the file suffix (extension) from a file path." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "file_suffix('/home/qgis/data/country_boundaries.shp')" ), tr( "'shp'" ), QString() ),
          QString(),
          QStringList()
            << tr( "extension,path,suffix,file" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "flip_coordinates" ),
    Help( QStringLiteral( "flip_coordinates" ), tr( "function" ), tr( "Returns a copy of the geometry with the x and y coordinates swapped. Useful for repairing geometries which have had their latitude and longitude values reversed." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "flip_coordinates" ), tr( "Returns a copy of the geometry with the x and y coordinates swapped. Useful for repairing geometries which have had their latitude and longitude values reversed." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(flip_coordinates(make_point(1, 2)))" ), tr( "'Point (2 1)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(flip_coordinates(geom_from_wkt('LineString(0 2, 1 0, 1 6)')))" ), tr( "'LineString (2 0, 0 1, 6 1)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "latitude,longitude,reversed,swapped,coordinates,repairing,copy" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "floor" ),
    Help( QStringLiteral( "floor" ), tr( "function" ), tr( "Rounds a number downwards." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "floor" ), tr( "Rounds a number downwards." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "a number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "floor(4.9)" ), tr( "4" ), QString() )
            << HelpExample( tr( "floor(-4.9)" ), tr( "-5" ), QString() ),
          QString(),
          QStringList()
            << tr( "downwards,rounds,number" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "force_polygon_ccw" ),
    Help( QStringLiteral( "force_polygon_ccw" ), tr( "function" ), tr( "Forces a geometry to respect the convention where exterior rings are counter-clockwise, interior rings are clockwise." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "force_polygon_ccw" ), tr( "Forces a geometry to respect the convention where exterior rings are counter-clockwise, interior rings are clockwise." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry. Any non-polygon geometries are returned unchanged." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(force_polygon_ccw(geometry:=geom_from_wkt('Polygon ((-1 -1, 0 2, 4 2, 4 0, -1 -1))')))" ), tr( "'Polygon ((-1 -1, 4 0, 4 2, 0 2, -1 -1))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "exterior,clockwise,respect,convention,rings,counter,interior,forces" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "force_polygon_cw" ),
    Help( QStringLiteral( "force_polygon_cw" ), tr( "function" ), tr( "Forces a geometry to respect the convention where exterior rings are clockwise, interior rings are counter-clockwise." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "force_polygon_cw" ), tr( "Forces a geometry to respect the convention where exterior rings are clockwise, interior rings are counter-clockwise." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry. Any non-polygon geometries are returned unchanged." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(force_polygon_cw(geometry:=geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1))')))" ), tr( "'Polygon ((-1 -1, 0 2, 4 2, 4 0, -1 -1))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "exterior,clockwise,respect,convention,rings,interior,counter,forces" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "force_rhr" ),
    Help( QStringLiteral( "force_rhr" ), tr( "function" ), tr( "Forces a geometry to respect the Right-Hand-Rule, in which the area that is bounded by a polygon is to the right of the boundary. In particular, the exterior ring is oriented in a clockwise direction and the interior rings in a counter-clockwise direction. Due to the inconsistency in the definition of the Right-Hand-Rule in some contexts it is recommended to use the explicit force_polygon_cw function instead." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "force_rhr" ), tr( "Forces a geometry to respect the Right-Hand-Rule, in which the area that is bounded by a polygon is to the right of the boundary. In particular, the exterior ring is oriented in a clockwise direction and the interior rings in a counter-clockwise direction. Due to the inconsistency in the definition of the Right-Hand-Rule in some contexts it is recommended to use the explicit force_polygon_cw function instead." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry. Any non-polygon geometries are returned unchanged." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(force_rhr(geometry:=geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1))')))" ), tr( "'Polygon ((-1 -1, 0 2, 4 2, 4 0, -1 -1))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "contexts,clockwise,boundary,interior,rings,bounded,force_polygon_cw,explicit,polygon,area,exterior,inconsistency,right,use,hand,particular,respect,counter,forces,ring,recommended,oriented,direction,rule,definition" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "format" ),
    Help( QStringLiteral( "format" ), tr( "function" ), tr( "Format a string using supplied arguments." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "format" ), tr( "Format a string using supplied arguments." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "A string with placeholders %1, %2, etc., for the arguments. Placeholders can be repeated. The lowest numbered placeholder is replaced by arg1, the next by arg2, etc." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "arg1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "arg2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "arg" ), tr( "any type. Any number of arguments." ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "format('This %1 a %2','is', 'test')" ), tr( "'This is a test'" ), QString() )
            << HelpExample( tr( "format('This is %2','a bit unexpected but 2 is lowest number in string','normal')" ), tr( "'This is a bit unexpected but 2 is lowest number in string'" ), QString() ),
          QString(),
          QStringList()
            << tr( "format,supplied,arguments" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "format_date" ),
    Help( QStringLiteral( "format_date" ), tr( "function" ), tr( "Formats a date type or string into a custom string format. Uses Qt date/time format strings. See <a href='https://doc.qt.io/qt-5/qdatetime.html#toString'>QDateTime::toString</a>." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "format_date" ), tr( "Formats a date type or string into a custom string format. Uses Qt date/time format strings. See <a href='https://doc.qt.io/qt-5/qdatetime.html#toString'>QDateTime::toString</a>." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "datetime" ), tr( "date, time or datetime value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "format" ), tr( "String template used to format the string. <table><thead><tr><th>Expression</th><th>Output</th></tr></thead><tr valign=\"top\"><td>d</td><td>the day as number without a leading zero (1 to 31)</td></tr><tr valign=\"top\"><td>dd</td><td>the day as number with a leading zero (01 to 31)</td></tr><tr valign=\"top\"><td>ddd</td><td>the abbreviated localized day name (e.g. 'Mon' to 'Sun')</td></tr><tr valign=\"top\"><td>dddd</td><td>the long localized day name (e.g. 'Monday' to 'Sunday')</td></tr><tr valign=\"top\"><td>M</td><td>the month as number without a leading zero (1-12)</td></tr><tr valign=\"top\"><td>MM</td><td>the month as number with a leading zero (01-12)</td></tr><tr valign=\"top\"><td>MMM</td><td>the abbreviated localized month name (e.g. 'Jan' to 'Dec')</td></tr><tr valign=\"top\"><td>MMMM</td><td>the long localized month name (e.g. 'January' to 'December')</td></tr><tr valign=\"top\"><td>yy</td><td>the year as two digit number (00-99)</td></tr><tr valign=\"top\"><td>yyyy</td><td>the year as four digit number</td></tr></table><p>These expressions may be used for the time part of the format string:</p><table><thead><tr><th>Expression</th><th>Output</th></tr></thead><tr valign=\"top\"><td>h</td><td>the hour without a leading zero (0 to 23 or 1 to 12 if AM/PM display)</td></tr><tr valign=\"top\"><td>hh</td><td>the hour with a leading zero (00 to 23 or 01 to 12 if AM/PM display)</td></tr><tr valign=\"top\"><td>H</td><td>the hour without a leading zero (0 to 23, even with AM/PM display)</td></tr><tr valign=\"top\"><td>HH</td><td>the hour with a leading zero (00 to 23, even with AM/PM display)</td></tr><tr valign=\"top\"><td>m</td><td>the minute without a leading zero (0 to 59)</td></tr><tr valign=\"top\"><td>mm</td><td>the minute with a leading zero (00 to 59)</td></tr><tr valign=\"top\"><td>s</td><td>the second without a leading zero (0 to 59)</td></tr><tr valign=\"top\"><td>ss</td><td>the second with a leading zero (00 to 59)</td></tr><tr valign=\"top\"><td>z</td><td>the milliseconds without trailing zeroes (0 to 999)</td></tr><tr valign=\"top\"><td>zzz</td><td>the milliseconds with trailing zeroes (000 to 999)</td></tr><tr valign=\"top\"><td>AP or A</td><td>interpret as an AM/PM time. <i>AP</i> must be either 'AM' or 'PM'.</td></tr><tr valign=\"top\"><td>ap or a</td><td>Interpret as an AM/PM time. <i>ap</i> must be either 'am' or 'pm'.</td></tr></table>" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "language" ), tr( "language (lowercase, two- or three-letter, <a href='https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes'>ISO 639 language code</a>) used to format the date into a custom string. By default the current QGIS user locale is used." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "format_date('2012-05-15','dd.MM.yyyy')" ), tr( "'15.05.2012'" ), QString() )
            << HelpExample( tr( "format_date('2012-05-15','d MMMM yyyy','fr')" ), tr( "'15 mai 2012'" ), QString() )
            << HelpExample( tr( "format_date('2012-05-15','dddd')" ), tr( "'Tuesday', if the current locale is an English variant" ), QString() )
            << HelpExample( tr( "format_date('2012-05-15 13:54:20','dd.MM.yy')" ), tr( "'15.05.12'" ), QString() )
            << HelpExample( tr( "format_date('13:54:20','hh:mm AP')" ), tr( "'01:54 PM'" ), QString() ),
          QString(),
          QStringList()
            << tr( "custom,type,uses,format,strings,time,date,formats,see,qdatetime,tostring" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "format_number" ),
    Help( QStringLiteral( "format_number" ), tr( "function" ), tr( "Returns a number formatted with the locale separator for thousands. By default the current QGIS user locale is used. Also truncates the decimal places to the number of supplied places." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "format_number" ), tr( "Returns a number formatted with the locale separator for thousands. By default the current QGIS user locale is used. Also truncates the decimal places to the number of supplied places." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "number" ), tr( "number to be formatted" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "places" ), tr( "integer representing the number of decimal places to truncate the string to." ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "language" ), tr( "language (lowercase, two- or three-letter, <a href='https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes'>ISO 639 language code</a>) used to format the number into a string. By default the current QGIS user locale is used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "omit_group_separators" ), tr( "if set to true then group separators will not be included in the string" ), false, false, true, QStringLiteral( "false" ) )
              << HelpArg( QStringLiteral( "trim_trailing_zeroes" ), tr( "if set to true then trailing zeros following the decimal point will be trimmed from the string" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "format_number(10000000.332,2)" ), tr( "'10,000,000.33' if e.g. the current locale is an English variant" ), QString() )
            << HelpExample( tr( "format_number(10000000.332,2,'fr')" ), tr( "'10 000 000,33'" ), QString() ),
          QString(),
          QStringList()
            << tr( "formatted,truncates,places,separator,decimal,default,thousands,locale,language" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "from_base64" ),
    Help( QStringLiteral( "from_base64" ), tr( "function" ), tr( "Decodes a string in the Base64 encoding into a binary value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "from_base64" ), tr( "Decodes a string in the Base64 encoding into a binary value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to decode" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "from_base64('UUdJUw==')" ), tr( "'QGIS'" ), QString() ),
          QString(),
          QStringList()
            << tr( "encoding,base,binary,decodes" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "from_json" ),
    Help( QStringLiteral( "from_json" ), tr( "function" ), tr( "Loads a JSON formatted string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "from_json" ), tr( "Loads a JSON formatted string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "JSON string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "from_json('{\"1\":\"one\",\"2\":\"two\"}')" ), tr( "{ '1': 'one', '2': 'two' }" ), QString() )
            << HelpExample( tr( "from_json('[1,2,3]')" ), tr( "[1,2,3]" ), QString() ),
          QString(),
          QStringList()
            << tr( "json,loads,formatted" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "generate_series" ),
    Help( QStringLiteral( "generate_series" ), tr( "function" ), tr( "Creates an array containing a sequence of numbers." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "generate_series" ), tr( "Creates an array containing a sequence of numbers." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "start" ), tr( "first value of the sequence" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "stop" ), tr( "value that ends the sequence once reached" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "step" ), tr( "value used as the increment between values" ), false, false, true, QStringLiteral( "1" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "generate_series(1,5)" ), tr( "[ 1, 2, 3, 4, 5 ]" ), QString() )
            << HelpExample( tr( "generate_series(5,1,-1)" ), tr( "[ 5, 4, 3, 2, 1 ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "sequence,containing,numbers,array" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geom_from_gml" ),
    Help( QStringLiteral( "geom_from_gml" ), tr( "function" ), tr( "Returns a geometry from a GML representation of geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geom_from_gml" ), tr( "Returns a geometry from a GML representation of geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "gml" ), tr( "GML representation of a geometry as a string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_from_gml('&lt;gml:LineString srsName=\"EPSG:4326\"&gt;&lt;gml:coordinates&gt;4,4 5,5 6,6&lt;/gml:coordinates&gt;&lt;/gml:LineString&gt;')" ), tr( "a line geometry object" ), QString() ),
          QString(),
          QStringList()
            << tr( "representation,conversion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geom_from_wkb" ),
    Help( QStringLiteral( "geom_from_wkb" ), tr( "function" ), tr( "Returns a geometry created from a Well-Known Binary (WKB) representation." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geom_from_wkb" ), tr( "Returns a geometry created from a Well-Known Binary (WKB) representation." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "binary" ), tr( "Well-Known Binary (WKB) representation of a geometry (as a binary blob)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_from_wkb( geom_to_wkb( make_point(4,5) ) )" ), tr( "a point geometry object" ), QString() ),
          QString(),
          QStringList()
            << tr( "created,wkb,binary,known,representation,conversion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geom_from_wkt" ),
    Help( QStringLiteral( "geom_from_wkt" ), tr( "function" ), tr( "Returns a geometry created from a Well-Known Text (WKT) representation." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geom_from_wkt" ), tr( "Returns a geometry created from a Well-Known Text (WKT) representation." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "text" ), tr( "Well-Known Text (WKT) representation of a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_from_wkt( 'POINT(4 5)' )" ), tr( "a geometry object" ), QString() ),
          QString(),
          QStringList()
            << tr( "text,known,wkt,representation,conversion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geom_to_wkb" ),
    Help( QStringLiteral( "geom_to_wkb" ), tr( "function" ), tr( "Returns the Well-Known Binary (WKB) representation of a geometry" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geom_to_wkb" ), tr( "Returns the Well-Known Binary (WKB) representation of a geometry" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkb( @geometry )" ), tr( "binary blob containing a geometry object" ), QString() ),
          QString(),
          QStringList()
            << tr( "wkb,binary,representation,known,conversion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geom_to_wkt" ),
    Help( QStringLiteral( "geom_to_wkt" ), tr( "function" ), tr( "Returns the Well-Known Text (WKT) representation of the geometry without SRID metadata." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geom_to_wkt" ), tr( "Returns the Well-Known Text (WKT) representation of the geometry without SRID metadata." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "precision" ), tr( "numeric precision" ), false, false, true, QStringLiteral( "8" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( make_point(6, 50) )" ), tr( "'POINT(6 50)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(centroid(geom_from_wkt('Polygon((1 1, 0 0, -1 1, 1 1))')))" ), tr( "'POINT(0 0.66666667)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(centroid(geom_from_wkt('Polygon((1 1, 0 0, -1 1, 1 1))')), 2)" ), tr( "'POINT(0 0.67)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "text,wkt,srid,representation,known,conversion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geometries_to_array" ),
    Help( QStringLiteral( "geometries_to_array" ), tr( "function" ), tr( "Splits a geometry into simpler geometries in an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geometries_to_array" ), tr( "Splits a geometry into simpler geometries in an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "the input geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geometries_to_array(geom_from_wkt('MultiPoint (1 2, 5 21)'))" ), tr( "An array containing 'Point (1 2)' and 'Point (5 21)'" ), QString() )
            << HelpExample( tr( "geometries_to_array(geom_from_wkt('GeometryCollection (Polygon ((5 8, 4 1, 3 2, 5 8)),LineString (3 2, 4 2))'))" ), tr( "an array of a polygon and a line geometries" ), QString() )
            << HelpExample( tr( "geom_to_wkt(geometries_to_array(geom_from_wkt('GeometryCollection (Polygon ((5 8, 4 1, 3 2, 5 8)),LineString (3 2, 4 2))'))[0])" ), tr( "'Polygon ((5 8, 4 1, 3 2, 5 8))'" ), QString() )
            << HelpExample( tr( "geometries_to_array(geom_from_wkt('MULTIPOLYGON(((5 5,0 0,0 10,5 5)),((5 5,10 10,10 0,5 5))'))" ), tr( "an array of two polygon geometries" ), QString() ),
          QString(),
          QStringList()
            << tr( "split,convert,separate,collection,multi,part" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geometry" ),
    Help( QStringLiteral( "geometry" ), tr( "function" ), tr( "Returns a feature's geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geometry" ), tr( "Returns a feature's geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "a feature object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geometry( @feature )" ), tr( "the geometry of the current feature. Prefer using @geometry." ), QString() )
            << HelpExample( tr( "geom_to_wkt( geometry( get_feature_by_id( 'streets', 1 ) ) )" ), tr( "the geometry in WKT of the feature with the id 1 on the layer \"streets\", e.g. 'POINT(6 50)'" ), QString() )
            << HelpExample( tr( "intersects( @geometry, geometry( get_feature( 'streets', 'name', 'Main St.' ) ) )" ), tr( "TRUE if the current feature spatially intersects the 'Main St.' named feature in the \"streets\" layer" ), QString() ),
          QString(),
          QStringList()
            << QString()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geometry_n" ),
    Help( QStringLiteral( "geometry_n" ), tr( "function" ), tr( "Returns a specific geometry from a geometry collection, or NULL if the input geometry is not a collection. Also returns a part from a multipart geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geometry_n" ), tr( "Returns a specific geometry from a geometry collection, or NULL if the input geometry is not a collection. Also returns a part from a multipart geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry collection" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "index" ), tr( "index of geometry to return, where 1 is the first geometry in the collection" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(geometry_n(geom_from_wkt('GEOMETRYCOLLECTION(POINT(0 1), POINT(0 0), POINT(1 0), POINT(1 1))'),3))" ), tr( "'Point (1 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "part,input,multipart,collection,specific" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "geometry_type" ),
    Help( QStringLiteral( "geometry_type" ), tr( "function" ), tr( "Returns a string value describing the type of a geometry (Point, Line or Polygon)" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "geometry_type" ), tr( "Returns a string value describing the type of a geometry (Point, Line or Polygon)" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geometry_type( geom_from_wkt( 'LINESTRING(2 5, 3 6, 4 8)') )" ), tr( "'Line'" ), QString() )
            << HelpExample( tr( "geometry_type( geom_from_wkt( 'MULTILINESTRING((2 5, 3 6, 4 8), (1 1, 0 0))') )" ), tr( "'Line'" ), QString() )
            << HelpExample( tr( "geometry_type( geom_from_wkt( 'POINT(2 5)') )" ), tr( "'Point'" ), QString() )
            << HelpExample( tr( "geometry_type( geom_from_wkt( 'POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1))') )" ), tr( "'Polygon'" ), QString() ),
          QString(),
          QStringList()
            << tr( "describing,type,point,polygon,line" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "get_feature" ),
    Help( QStringLiteral( "get_feature" ), tr( "function" ), tr( "Returns the first feature of a layer matching a given attribute value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Single value variant" ), tr( "Along with the layer ID, a single column and value are specified." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "layer name or ID" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "attribute" ), tr( "attribute name to use for the match" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "attribute value to match" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "get_feature('streets','name','main st')" ), tr( "first feature found in \"streets\" layer with \"main st\" value in the \"name\" field" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Map variant" ), tr( "Along with the layer ID, a map containing the columns (key) and their respective value to be used." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "layer name or ID" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "attribute" ), tr( "Map containing the column and value pairs to use" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "get_feature('streets',map('name','main st','lane_num','4'))" ), tr( "first feature found in \"streets\" layer with \"main st\" value in the \"name\" field and  \"4\" value in the \"lane_num\" field" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "get_feature_by_id" ),
    Help( QStringLiteral( "get_feature_by_id" ), tr( "function" ), tr( "Returns the feature with an id on a layer." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "get_feature_by_id" ), tr( "Returns the feature with an id on a layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "layer, layer name or layer id" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "feature_id" ), tr( "the id of the feature which should be returned" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "get_feature_by_id('streets', 1)" ), tr( "the feature with the id 1 on the layer \"streets\"" ), QString() ),
          QString(),
          QStringList()
            << QString()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "hamming_distance" ),
    Help( QStringLiteral( "hamming_distance" ), tr( "function" ), tr( "Returns the Hamming distance between two strings. This equates to the number of characters at corresponding positions within the input strings where the characters are different. The input strings must be the same length, and the comparison is case-sensitive." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "hamming_distance" ), tr( "Returns the Hamming distance between two strings. This equates to the number of characters at corresponding positions within the input strings where the characters are different. The input strings must be the same length, and the comparison is case-sensitive." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string1" ), tr( "a string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "string2" ), tr( "a string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "hamming_distance('abc','xec')" ), tr( "2" ), QString() )
            << HelpExample( tr( "hamming_distance('abc','ABc')" ), tr( "2" ), QString() )
            << HelpExample( tr( "hamming_distance(upper('abc'),upper('ABC'))" ), tr( "0" ), QString() )
            << HelpExample( tr( "hamming_distance('abc','abcd')" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,length,input,sensitive,different,strings,corresponding,hamming,equates,characters,case,same,comparison,positions" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "hash" ),
    Help( QStringLiteral( "hash" ), tr( "function" ), tr( "Creates a hash from a string with a given method. One byte (8 bits) is represented with two hex ''digits'', so 'md4' (16 bytes) produces a 16 * 2 = 32 character long hex string and 'keccak_512' (64 bytes) produces a 64 * 2 = 128 character long hex string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "hash" ), tr( "Creates a hash from a string with a given method. One byte (8 bits) is represented with two hex ''digits'', so 'md4' (16 bytes) produces a 16 * 2 = 32 character long hex string and 'keccak_512' (64 bytes) produces a 64 * 2 = 128 character long hex string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to hash" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "method" ), tr( "The hash method among 'md4', 'md5', 'sha1', 'sha224', 'sha384', 'sha512', 'sha3_224', 'sha3_256', 'sha3_384', 'sha3_512', 'keccak_224', 'keccak_256', 'keccak_384', 'keccak_512'" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "hash('QGIS', 'md4')" ), tr( "'c0fc71c241cdebb6e888cbac0e2b68eb'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'md5')" ), tr( "'57470aaa9e22adaefac7f5f342f1c6da'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha1')" ), tr( "'f87cfb2b74cdd5867db913237024e7001e62b114'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha224')" ), tr( "'4093a619ada631c770f44bc643ead18fb393b93d6a6af1861fcfece0'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha256')" ), tr( "'eb045cba7a797aaa06ac58830846e40c8e8c780bc0676d3393605fae50c05309'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha384')" ), tr( "'91c1de038cc3d09fdd512e99f9dd9922efadc39ed21d3922e69a4305cc25506033aee388e554b78714c8734f9cd7e610'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha512')" ), tr( "'c2c092f2ab743bf8edbeb6d028a745f30fc720408465ed369421f0a4e20fa5e27f0c90ad72d3f1d836eaa5d25cd39897d4cf77e19984668ef58da6e3159f18ac'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha3_224')" ), tr( "'467f49a5039e7280d5d42fd433e80d203439e338eaabd701f0d6c17d'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha3_256')" ), tr( "'540f7354b6b8a6e735f2845250f15f4f3ba4f666c55574d9e9354575de0e980f'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha3_384')" ), tr( "'96052da1e77679e9a65f60d7ead961b287977823144786386eb43647b0901fd8516fa6f1b9d243fb3f28775e6dde6107'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'sha3_512')" ), tr( "'900d079dc69761da113980253aa8ac0414a8bd6d09879a916228f8743707c4758051c98445d6b8945ec854ff90655005e02aceb0a2ffc6a0ebf818745d665349'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'keccak_224')" ), tr( "'5b0ce6acef8b0a121d4ac4f3eaa8503c799ad4e26a3392d1fb201478'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'keccak_256')" ), tr( "'991c520aa6815392de24087f61b2ae0fd56abbfeee4a8ca019c1011d327c577e'" ), QString() )
            << HelpExample( tr( "hash('QGIS', 'keccak_384')" ), tr( "'c57a3aed9d856fa04e5eeee9b62b6e027cca81ba574116d3cc1f0d48a1ef9e5886ff463ea8d0fac772ee473bf92f810d'" ), QString() ),
          QString(),
          QStringList()
            << tr( "hex,bytes,byte,digits,hash,method,given,represented,character,long,bits,produces" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "hausdorff_distance" ),
    Help( QStringLiteral( "hausdorff_distance" ), tr( "function" ), tr( "Returns the Hausdorff distance between two geometries. This is basically a measure of how similar or dissimilar 2 geometries are, with a lower distance indicating more similar geometries.<br>The function can be executed with an optional densify fraction argument. If not specified, an approximation to the standard Hausdorff distance is used. This approximation is exact or close enough for a large subset of useful cases. Examples of these are:<br><br><li>computing distance between Linestrings that are roughly parallel to each other, and roughly equal in length. This occurs in matching linear networks.</li><li>Testing similarity of geometries.</li><br><br>If the default approximate provided by this method is insufficient, specify the optional densify fraction argument. Specifying this argument performs a segment densification before computing the discrete Hausdorff distance. The parameter sets the fraction by which to densify each segment. Each segment will be split into a number of equal-length subsegments, whose fraction of the total length is closest to the given fraction. Decreasing the densify fraction parameter will make the distance returned approach the true Hausdorff distance for the geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "hausdorff_distance" ), tr( "Returns the Hausdorff distance between two geometries. This is basically a measure of how similar or dissimilar 2 geometries are, with a lower distance indicating more similar geometries.<br>The function can be executed with an optional densify fraction argument. If not specified, an approximation to the standard Hausdorff distance is used. This approximation is exact or close enough for a large subset of useful cases. Examples of these are:<br><br><li>computing distance between Linestrings that are roughly parallel to each other, and roughly equal in length. This occurs in matching linear networks.</li><li>Testing similarity of geometries.</li><br><br>If the default approximate provided by this method is insufficient, specify the optional densify fraction argument. Specifying this argument performs a segment densification before computing the discrete Hausdorff distance. The parameter sets the fraction by which to densify each segment. Each segment will be split into a number of equal-length subsegments, whose fraction of the total length is closest to the given fraction. Decreasing the densify fraction parameter will make the distance returned approach the true Hausdorff distance for the geometries." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "densify_fraction" ), tr( "densify fraction amount" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "hausdorff_distance( geometry1:= geom_from_wkt('LINESTRING (0 0, 2 1)'),geometry2:=geom_from_wkt('LINESTRING (0 0, 2 0)'))" ), tr( "2" ), QString() )
            << HelpExample( tr( "hausdorff_distance( geom_from_wkt('LINESTRING (130 0, 0 0, 0 150)'),geom_from_wkt('LINESTRING (10 10, 10 150, 130 10)'))" ), tr( "14.142135623" ), QString() )
            << HelpExample( tr( "hausdorff_distance( geom_from_wkt('LINESTRING (130 0, 0 0, 0 150)'),geom_from_wkt('LINESTRING (10 10, 10 150, 130 10)'),0.5)" ), tr( "70.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,segment,dissimilar,densify,linestrings,parallel,other,matching,total,close,executed,specifying,occurs,equal,fraction,testing,method,discrete,linear,default,approximate,sets,length,large,lower,similar,similarity,parameter,measure,split,make,approach,closest,examples,provided,performs,insufficient,networks,specify,optional,decreasing,approximation,cases,densification,specified,computing,argument,subsegments,hausdorff,exact,indicating,subset,standard" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "hour" ),
    Help( QStringLiteral( "hour" ), tr( "function" ), tr( "Extracts the hour part from a datetime or time, or the number of hours from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Time variant" ), tr( "Extracts the hour part from a time or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "datetime" ), tr( "a time or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "hour( to_datetime('2012-07-22 13:24:57') )" ), tr( "13" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in hours of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of hours from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "hour(to_interval('3 hours'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "hour(age('2012-07-22T13:00:00','2012-07-22T10:00:00'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "hour(age('2012-01-01','2010-01-01'))" ), tr( "17520" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "hstore_to_map" ),
    Help( QStringLiteral( "hstore_to_map" ), tr( "function" ), tr( "Creates a map from a hstore-formatted string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "hstore_to_map" ), tr( "Creates a map from a hstore-formatted string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the input string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "hstore_to_map('qgis=>rocks')" ), tr( "{ 'qgis': 'rocks' }" ), QString() ),
          QString(),
          QStringList()
            << tr( "formatted,hstore,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "if" ),
    Help( QStringLiteral( "if" ), tr( "function" ), tr( "Tests a condition and returns a different result depending on the conditional check." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "if" ), tr( "Tests a condition and returns a different result depending on the conditional check." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "condition" ), tr( "the condition which should be checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "result_when_true" ), tr( "the result which will be returned when the condition is true or another value that does not convert to false." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "result_when_false" ), tr( "the result which will be returned when the condition is false or another value that converts to false like 0 or ''. NULL will also be converted to false." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "if( 1+1=2, 'Yes', 'No' )" ), tr( "'Yes'" ), QString() )
            << HelpExample( tr( "if( 1+1=3, 'Yes', 'No' )" ), tr( "'No'" ), QString() )
            << HelpExample( tr( "if( 5 > 3, 1, 0)" ), tr( "1" ), QString() )
            << HelpExample( tr( "if( '', 'It is true (not empty)', 'It is false (empty)' )" ), tr( "'It is false (empty)'" ), QString() )
            << HelpExample( tr( "if( ' ', 'It is true (not empty)', 'It is false (empty)' )" ), tr( "'It is true (not empty)'" ), QString() )
            << HelpExample( tr( "if( 0, 'One', 'Zero' )" ), tr( "'Zero'" ), QString() )
            << HelpExample( tr( "if( 10, 'One', 'Zero' )" ), tr( "'One'" ), QString() ),
          QString(),
          QStringList()
            << tr( "tests,different,check,result,conditional,depending,condition" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "inclination" ),
    Help( QStringLiteral( "inclination" ), tr( "function" ), tr( "Returns the inclination measured from the zenith (0) to the nadir (180) on point_a to point_b." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "inclination" ), tr( "Returns the inclination measured from the zenith (0) to the nadir (180) on point_a to point_b." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point_a" ), tr( "point geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point_b" ), tr( "point geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "inclination( make_point( 5, 10, 0 ), make_point( 5, 10, 5 ) )" ), tr( "0.0" ), QString() )
            << HelpExample( tr( "inclination( make_point( 5, 10, 0 ), make_point( 5, 10, 0 ) )" ), tr( "90.0" ), QString() )
            << HelpExample( tr( "inclination( make_point( 5, 10, 0 ), make_point( 50, 100, 0 ) )" ), tr( "90.0" ), QString() )
            << HelpExample( tr( "inclination( make_point( 5, 10, 0 ), make_point( 5, 10, -5 ) )" ), tr( "180.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "zenith,nadir,inclination,measured,points" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "interior_ring_n" ),
    Help( QStringLiteral( "interior_ring_n" ), tr( "function" ), tr( "Returns a specific interior ring from a polygon geometry, or NULL if the geometry is not a polygon." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "interior_ring_n" ), tr( "Returns a specific interior ring from a polygon geometry, or NULL if the geometry is not a polygon." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "polygon geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "index" ), tr( "index of interior to return, where 1 is the first interior ring" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(interior_ring_n(geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1),(-0.1 -0.1, 0.4 0, 0.4 0.2, 0 0.2, -0.1 -0.1),(-1 -1, 4 0, 4 2, 0 2, -1 -1))'),1))" ), tr( "'LineString (-0.1 -0.1, 0.4 0, 0.4 0.2, 0 0.2, -0.1 -0.1))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "interior,polygon,hole,ring" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "intersection" ),
    Help( QStringLiteral( "intersection" ), tr( "function" ), tr( "Returns a geometry that represents the shared portion of two geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "intersection" ), tr( "Returns a geometry that represents the shared portion of two geometries." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( intersection( geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4)' ) ) )" ), tr( "'LINESTRING(3 3, 4 4)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt( intersection( geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ), geom_from_wkt( 'MULTIPOINT(3.5 3.5, 4 5)' ) ) )" ), tr( "'POINT(3.5 3.5)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "shared,represents,portion,overlap" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "intersects" ),
    Help( QStringLiteral( "intersects" ), tr( "function" ), tr( "Tests whether a geometry intersects another. Returns TRUE if the geometries spatially intersect (share any portion of space) and false if they do not." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "intersects" ), tr( "Tests whether a geometry intersects another. Returns TRUE if the geometries spatially intersect (share any portion of space) and false if they do not." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "intersects( geom_from_wkt( 'POINT(4 4)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "intersects( geom_from_wkt( 'POINT(4 5)' ), geom_from_wkt( 'POINT(5 5)' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "share,space,intersects,tests,intersect,portion,overlaps" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "intersects_bbox" ),
    Help( QStringLiteral( "intersects_bbox" ), tr( "function" ), tr( "Tests whether a geometry's bounding box overlaps another geometry's bounding box. Returns TRUE if the geometries spatially intersect the bounding box defined and false if they do not." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "intersects_bbox" ), tr( "Tests whether a geometry's bounding box overlaps another geometry's bounding box. Returns TRUE if the geometries spatially intersect the bounding box defined and false if they do not." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "intersects_bbox( geom_from_wkt( 'POINT(4 5)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "intersects_bbox( geom_from_wkt( 'POINT(6 5)' ), geom_from_wkt( 'POLYGON((3 3, 4 4, 5 5, 3 3))' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "box,tests,overlaps,defined,intersect,bounding" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "iqr" ),
    Help( QStringLiteral( "iqr" ), tr( "function" ), tr( "Returns the calculated inter quartile range from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "iqr" ), tr( "Returns the calculated inter quartile range from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "iqr(\"population\",group_by:=\"state\")" ), tr( "inter quartile range of population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "field,quartile,range,inter,calculated,statistics,aggregates" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_attribute_valid" ),
    Help( QStringLiteral( "is_attribute_valid" ), tr( "function" ), tr( "Returns TRUE if a specific feature attribute meets all constraints." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_attribute_valid" ), tr( "Returns TRUE if a specific feature attribute meets all constraints." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "attribute" ), tr( "an attribute name" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "feature" ), tr( "A feature. If not set, the current feature will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "layer" ), tr( "A vector layer. If not set, the current layer will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "strength" ), tr( "Set to 'hard' or 'soft' to narrow down to a specific constraint type. If not set, the function will return FALSE if either a hard or a soft constraint fails." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_attribute_valid('HECTARES')" ), tr( "TRUE if the current feature's value in the \"HECTARES\" field meets all constraints." ), QString() )
            << HelpExample( tr( "is_attribute_valid('HOUSES',get_feature('my_layer', 'FID', 10), 'my_layer')" ), tr( "FALSE if the value in the \"HOUSES\" field from the feature with \"FID\"=10 in 'my_layer' fails to meet all constraints." ), QString() ),
          QString(),
          QStringList()
            << tr( "constraints,hard,soft" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_closed" ),
    Help( QStringLiteral( "is_closed" ), tr( "function" ), tr( "Returns TRUE if a line string is closed (start and end points are coincident), or false if a line string is not closed. If the geometry is not a line string then the result will be NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_closed" ), tr( "Returns TRUE if a line string is closed (start and end points are coincident), or false if a line string is not closed. If the geometry is not a line string then the result will be NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a line string geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_closed(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2)'))" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "is_closed(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2, 0 0)'))" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "points,start,closed,end,coincident,result,false,line" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_directory" ),
    Help( QStringLiteral( "is_directory" ), tr( "function" ), tr( "Returns TRUE if a path corresponds to a directory." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_directory" ), tr( "Returns TRUE if a path corresponds to a directory." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_directory('/home/qgis/data/country_boundaries.shp')" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "is_directory('/home/qgis/data/')" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "path,directory,folder" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_empty" ),
    Help( QStringLiteral( "is_empty" ), tr( "function" ), tr( "Returns TRUE if a geometry is empty (without coordinates), false if the geometry is not empty and NULL if there is no geometry. See also is_empty_or_null." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_empty" ), tr( "Returns TRUE if a geometry is empty (without coordinates), false if the geometry is not empty and NULL if there is no geometry. See also is_empty_or_null." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_empty(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2)'))" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "is_empty(geom_from_wkt('LINESTRING EMPTY'))" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "is_empty(geom_from_wkt('POINT(7 4)'))" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "is_empty(geom_from_wkt('POINT EMPTY'))" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "empty,is_empty_or_null,see,coordinates,false" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_empty_or_null" ),
    Help( QStringLiteral( "is_empty_or_null" ), tr( "function" ), tr( "Returns TRUE if a geometry is NULL or empty (without coordinates) or false otherwise. This function is like the expression '@geometry IS NULL or is_empty(@geometry)'" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_empty_or_null" ), tr( "Returns TRUE if a geometry is NULL or empty (without coordinates) or false otherwise. This function is like the expression '@geometry IS NULL or is_empty(@geometry)'" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_empty_or_null(NULL)" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "is_empty_or_null(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2)'))" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "is_empty_or_null(geom_from_wkt('LINESTRING EMPTY'))" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "is_empty_or_null(geom_from_wkt('POINT(7 4)'))" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "is_empty_or_null(geom_from_wkt('POINT EMPTY'))" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "empty,is_empty,coordinates,false" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_feature_valid" ),
    Help( QStringLiteral( "is_feature_valid" ), tr( "function" ), tr( "Returns TRUE if a feature meets all field constraints." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_feature_valid" ), tr( "Returns TRUE if a feature meets all field constraints." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "A feature. If not set, the current feature will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "layer" ), tr( "A vector layer. If not set, the current layer will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "strength" ), tr( "Set to 'hard' or 'soft' to narrow down to a specific constraint type. If not set, the function will return FALSE if either a hard or a soft constraint fails." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_feature_valid(strength:='hard')" ), tr( "TRUE if all fields from the current feature meet their hard constraints." ), QString() )
            << HelpExample( tr( "is_feature_valid(get_feature('my_layer', 'FID', 10), 'my_layer')" ), tr( "FALSE if all fields from feature with \"FID\"=10 in 'my_layer' fails to meet all constraints." ), QString() ),
          QString(),
          QStringList()
            << tr( "constraints,hard,soft" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_file" ),
    Help( QStringLiteral( "is_file" ), tr( "function" ), tr( "Returns TRUE if a path corresponds to a file." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_file" ), tr( "Returns TRUE if a path corresponds to a file." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "path" ), tr( "a file path or a map layer value. If a map layer value is specified then the file source of the layer will be used." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_file('/home/qgis/data/country_boundaries.shp')" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "is_file('/home/qgis/data/')" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "path,file" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_layer_visible" ),
    Help( QStringLiteral( "is_layer_visible" ), tr( "function" ), tr( "Returns TRUE if a specified layer is visible." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_layer_visible" ), tr( "Returns TRUE if a specified layer is visible." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "a string, representing either a layer name or layer ID" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_layer_visible('baseraster')" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "specified,visible" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_multipart" ),
    Help( QStringLiteral( "is_multipart" ), tr( "function" ), tr( "Returns TRUE if the geometry is of Multi type." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_multipart" ), tr( "Returns TRUE if the geometry is of Multi type." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_multipart(geom_from_wkt('MULTIPOINT ((0 0),(1 1),(2 2))'))" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "is_multipart(geom_from_wkt('POINT (0 0)'))" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "type,multi" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_selected" ),
    Help( QStringLiteral( "is_selected" ), tr( "function" ), tr( "Returns TRUE if a feature is selected. Can be used with zero, one or two arguments, see below for details." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "No parameters" ), tr( "If called with no parameters, the function will return TRUE if the current feature in the current layer is selected." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_selected()" ), tr( "TRUE if the current feature in the current layer is selected." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "One 'feature' parameter" ), tr( "If called with a 'feature' parameter only, the function returns TRUE if the specified feature from the current layer is selected." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be checked for selection." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_selected(@atlas_feature)" ), tr( "TRUE if the current atlas feature is selected." ), QString() )
            << HelpExample( tr( "is_selected(get_feature('streets', 'name', 'Main St.'))" ), tr( "TRUE if the unique named \"Main St.\" feature on the active \"streets\" layer is selected." ), QString() )
            << HelpExample( tr( "is_selected(get_feature_by_id('streets', 1))" ), tr( "TRUE if the feature with the id 1 on the active \"streets\" layer is selected." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Two parameters" ), tr( "If the function is called with both a layer and a feature, it will return TRUE if the specified feature from the specified layer is selected." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "The layer (its ID or name) on which the selection will be checked." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be checked for selection." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_selected( 'streets', get_feature('streets', 'name', \"street_name\"))" ), tr( "TRUE if the current building's street is selected (assuming the building layer has a field named 'street_name' and the 'streets' layer has a field called 'name' with unique values)." ), QString() )
            << HelpExample( tr( "is_selected( 'streets', get_feature_by_id('streets', 1))" ), tr( "TRUE if the feature with the id 1 on the \"streets\" layer is selected." ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "is_valid" ),
    Help( QStringLiteral( "is_valid" ), tr( "function" ), tr( "Returns TRUE if a geometry is valid; if it is well-formed in 2D according to the OGC rules." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "is_valid" ), tr( "Returns TRUE if a geometry is valid; if it is well-formed in 2D according to the OGC rules." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "is_valid(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2, 0 0)'))" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "is_valid(geom_from_wkt('LINESTRING(0 0)'))" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "rules,valid,ogc,according,formed" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "item_variables" ),
    Help( QStringLiteral( "item_variables" ), tr( "function" ), tr( "Returns a map of variables from a layout item inside this print layout." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "item_variables" ), tr( "Returns a map of variables from a layout item inside this print layout." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "id" ), tr( "layout item ID" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_get( item_variables('Map 0'), 'map_scale')" ), tr( "scale of the item 'Map 0' in the current print layout" ), QString() ),
          QString(),
          QStringList()
            << tr( "layout,item,variables,print,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "layer_property" ),
    Help( QStringLiteral( "layer_property" ), tr( "function" ), tr( "Returns a matching layer property or metadata value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "layer_property" ), tr( "Returns a matching layer property or metadata value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "a string, representing either a layer name or layer ID" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "property" ), tr( "a string corresponding to the property to return. Valid options are:<br /><ul><li>name: layer name</li><li>id: layer ID</li><li>title: metadata title string</li><li>abstract: metadata abstract string</li><li>keywords: metadata keywords</li><li>data_url: metadata URL</li><li>attribution: metadata attribution string</li><li>attribution_url: metadata attribution URL</li><li>source: layer source</li><li>min_scale: minimum display scale for layer</li><li>max_scale: maximum display scale for layer</li><li>is_editable: if layer is in edit mode</li><li>crs: layer CRS</li><li>crs_definition: layer CRS full definition</li><li>crs_description: layer CRS description</li><li>crs_ellipsoid: acronym of the layer CRS ellipsoid</li><li>extent: layer extent (as a geometry object)</li><li>distance_units: layer distance units</li><li>type: layer type, e.g., Vector or Raster</li><li>storage_type: storage format (vector layers only)</li><li>geometry_type: geometry type, e.g., Point (vector layers only)</li><li>feature_count: approximate feature count for layer (vector layers only)</li><li>path: File path to the layer data source. Only available for file based layers.</li></ul>" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "layer_property('streets','title')" ), tr( "'Basemap Streets'" ), QString() )
            << HelpExample( tr( "layer_property('airports','feature_count')" ), tr( "120" ), QString() )
            << HelpExample( tr( "layer_property('landsat','crs')" ), tr( "'EPSG:4326'" ), QString() ),
          QString(),
          QStringList()
            << tr( "property,matching,metadata,layer name,layer id,title,abstract,keywords,data url,attribution,attribution url,layer source,minimum scale,min scale,maximum scale,max scale,is editable,crs,crs definition,crs description,crs ellipsoid,layer extent,distance units,layer type,storage type,geometry type,feature count,file path" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "left" ),
    Help( QStringLiteral( "left" ), tr( "function" ), tr( "Returns a substring that contains the <i>n</i> leftmost characters of the string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "left" ), tr( "Returns a substring that contains the <i>n</i> leftmost characters of the string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "a string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "length" ), tr( "integer. The number of characters from the left of the string to return." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "left('Hello World',5)" ), tr( "'Hello'" ), QString() ),
          QString(),
          QStringList()
            << tr( "first,start,begin,substring,leftmost,characters,contains,extracts" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "length" ),
    Help( QStringLiteral( "length" ), tr( "function" ), tr( "Returns the number of characters in a string or the length of a geometry linestring." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "String variant" ), tr( "Returns the number of characters in a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to count length of" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "length('hello')" ), tr( "5" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Geometry variant" ), tr( "Calculate the length of a geometry line object. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned length will match the units for the SRS. This differs from the calculations performed by the $length function, which will perform ellipsoidal calculations based on the project's ellipsoid and distance unit settings." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "line geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "length(geom_from_wkt('LINESTRING(0 0, 4 0)'))" ), tr( "4.0" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "length3D" ),
    Help( QStringLiteral( "length3D" ), tr( "function" ), tr( "Calculates the 3D length of a geometry line object. If the geometry is not a 3D line object, it returns its 2D length. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned length will match the units for the SRS. This differs from the calculations performed by the $length function, which will perform ellipsoidal calculations based on the project's ellipsoid and distance unit settings." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "length3D" ), tr( "Calculates the 3D length of a geometry line object. If the geometry is not a 3D line object, it returns its 2D length. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned length will match the units for the SRS. This differs from the calculations performed by the $length function, which will perform ellipsoidal calculations based on the project's ellipsoid and distance unit settings." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "line geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "length3D(geom_from_wkt('LINESTRINGZ(0 0 0, 3 0 4)'))" ), tr( "5.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "planimetric,distance,length,spatial,reference,system,calculations,calculates,line,project,differs,object,match,settings,ellipsoid,units" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "levenshtein" ),
    Help( QStringLiteral( "levenshtein" ), tr( "function" ), tr( "Returns the Levenshtein edit distance between two strings. This equates to the minimum number of character edits (insertions, deletions or substitutions) required to change one string to another.<br />The Levenshtein distance is a measure of the similarity between two strings. Smaller distances mean the strings are more similar, and larger distances indicate more different strings. The distance is case sensitive." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "levenshtein" ), tr( "Returns the Levenshtein edit distance between two strings. This equates to the minimum number of character edits (insertions, deletions or substitutions) required to change one string to another.<br />The Levenshtein distance is a measure of the similarity between two strings. Smaller distances mean the strings are more similar, and larger distances indicate more different strings. The distance is case sensitive." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string1" ), tr( "a string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "string2" ), tr( "a string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "levenshtein('kittens','mitten')" ), tr( "2" ), QString() )
            << HelpExample( tr( "levenshtein('Kitten','kitten')" ), tr( "1" ), QString() )
            << HelpExample( tr( "levenshtein(upper('Kitten'),upper('kitten'))" ), tr( "0" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,required,edit,indicate,sensitive,similarity,insertions,similar,mean,measure,different,character,change,substitutions,strings,edits,distances,larger,deletions,equates,case,minimum,levenshtein,smaller" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "lighter" ),
    Help( QStringLiteral( "lighter" ), tr( "function" ), tr( "Returns a lighter (or darker) color. Returned type is the same as color arguments, i.e. a color string representation or a color object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "lighter" ), tr( "Returns a lighter (or darker) color. Returned type is the same as color arguments, i.e. a color string representation or a color object." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color" ), tr( "a color string or a color object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "factor" ), tr( "an integer corresponding to the lightening factor:<ul><li>if the factor is greater than 100, this function returns a lighter color (e.g., setting factor to 150 returns a color that is 50% brighter);</li><li>if the factor is less than 100, the return color is darker, but using the darker() function for this purpose is recommended;</li><li>if the factor is 0 or negative, the return value is unspecified.</li></ul>" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "lighter('200,10,30', 200)" ), tr( "'255,158,168,255'" ), QString() ),
          QString(),
          QStringList()
            << tr( "darker,color,lighter" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_interpolate_angle" ),
    Help( QStringLiteral( "line_interpolate_angle" ), tr( "function" ), tr( "Returns the angle parallel to the geometry at a specified distance along a linestring geometry. Angles are in degrees clockwise from north." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_interpolate_angle" ), tr( "Returns the angle parallel to the geometry at a specified distance along a linestring geometry. Angles are in degrees clockwise from north." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "distance along line to interpolate angle at" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "line_interpolate_angle(geometry:=geom_from_wkt('LineString(0 0, 10 0)'),distance:=5)" ), tr( "90.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,angles,parallel,specified,clockwise,angle,linestring,degrees,north" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_interpolate_point" ),
    Help( QStringLiteral( "line_interpolate_point" ), tr( "function" ), tr( "Returns the point interpolated by a specified distance along a linestring geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_interpolate_point" ), tr( "Returns the point interpolated by a specified distance along a linestring geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "distance along line to interpolate" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(line_interpolate_point(geometry:=geom_from_wkt('LineString(0 0, 8 0)'), distance:=5))" ), tr( "'Point (5 0)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(line_interpolate_point(geometry:=geom_from_wkt('LineString(0 0, 1 1, 2 0)'), distance:=2.1))" ), tr( "'Point (1.48492424 0.51507576)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(line_interpolate_point(geometry:=geom_from_wkt('LineString(0 0, 1 0)'), distance:=2))" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,interpolated,linestring,point,specified,along" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_interpolate_point_by_m" ),
    Help( QStringLiteral( "line_interpolate_point_by_m" ), tr( "function" ), tr( "Returns the point interpolated by a matching M value along a linestring geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_interpolate_point_by_m" ), tr( "Returns the point interpolated by a matching M value along a linestring geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "m" ), tr( "an M value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "use_3d_distance" ), tr( "controls whether 2D or 3D distances between vertices should be used during interpolation (this option is only considered for lines with z values)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(line_interpolate_point_by_m(geom_from_wkt('LineStringM(0 0 0, 10 10 10)'), m:=5))" ), tr( "'Point (5 5)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,interpolated,linestring,point,specified,along" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_locate_m" ),
    Help( QStringLiteral( "line_locate_m" ), tr( "function" ), tr( "Returns the distance along a linestring corresponding to the first matching interpolated M value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_locate_m" ), tr( "Returns the distance along a linestring corresponding to the first matching interpolated M value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "m" ), tr( "an M value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "use_3d_distance" ), tr( "controls whether 2D or 3D distances between vertices should be used during interpolation (this option is only considered for lines with z values)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "line_locate_m(geometry:=geom_from_wkt('LineStringM(0 0 0, 10 10 10)'),m:=5)" ), tr( "7.07106" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,linestring,interpolated,corresponding,along" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_locate_point" ),
    Help( QStringLiteral( "line_locate_point" ), tr( "function" ), tr( "Returns the distance along a linestring corresponding to the closest position the linestring comes to a specified point geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_locate_point" ), tr( "Returns the distance along a linestring corresponding to the closest position the linestring comes to a specified point geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point" ), tr( "point geometry to locate closest position on linestring to" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "line_locate_point(geometry:=geom_from_wkt('LineString(0 0, 10 0)'),point:=geom_from_wkt('Point(5 0)'))" ), tr( "5.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,point,specified,closest,linestring,position,corresponding,along" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_merge" ),
    Help( QStringLiteral( "line_merge" ), tr( "function" ), tr( "Returns a LineString or MultiLineString geometry, where any connected LineStrings from the input geometry have been merged into a single linestring. This function will return NULL if passed a geometry which is not a LineString/MultiLineString." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_merge" ), tr( "Returns a LineString or MultiLineString geometry, where any connected LineStrings from the input geometry have been merged into a single linestring. This function will return NULL if passed a geometry which is not a LineString/MultiLineString." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a LineString/MultiLineString geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(line_merge(geom_from_wkt('MULTILINESTRING((0 0, 1 1),(1 1, 2 2))')))" ), tr( "'LineString(0 0,1 1,2 2)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(line_merge(geom_from_wkt('MULTILINESTRING((0 0, 1 1),(11 1, 21 2))')))" ), tr( "'MultiLineString((0 0, 1 1),(11 1, 21 2)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "passed,single,return,input,linestrings,merged,connected,linestring,multilinestring" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "line_substring" ),
    Help( QStringLiteral( "line_substring" ), tr( "function" ), tr( "Returns the portion of a line (or curve) geometry which falls between the specified start and end distances (measured from the beginning of the line). Z and M values are linearly interpolated from existing values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "line_substring" ), tr( "Returns the portion of a line (or curve) geometry which falls between the specified start and end distances (measured from the beginning of the line). Z and M values are linearly interpolated from existing values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a linestring or curve geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "start_distance" ), tr( "distance to start of substring" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "end_distance" ), tr( "distance to end of substring" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(line_substring(geometry:=geom_from_wkt('LineString(0 0, 10 0)'),start_distance:=2,end_distance:=6))" ), tr( "'LineString (2 0,6 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "curve,start,specified,measured,falls,existing,interpolated,beginning,distances,line,end,portion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ln" ),
    Help( QStringLiteral( "ln" ), tr( "function" ), tr( "Returns the natural logarithm of a value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "ln" ), tr( "Returns the natural logarithm of a value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "numeric value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ln(1)" ), tr( "0" ), QString() )
            << HelpExample( tr( "ln(2.7182818284590452354)" ), tr( "1" ), QString() ),
          QString(),
          QStringList()
            << tr( "natural,logarithm" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "load_layer" ),
    Help( QStringLiteral( "load_layer" ), tr( "function" ), tr( "Loads a layer by source URI and provider name." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "load_layer" ), tr( "Loads a layer by source URI and provider name." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "uri" ), tr( "layer source URI string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "provider" ), tr( "layer data provider name" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "layer_property(load_layer('c:/data/roads.shp', 'ogr'), 'feature_count')" ), tr( "count of features from the c:/data/roads.shp vector layer" ), QString() ),
          QString(),
          QStringList()
            << tr( "layer,vector,raster,mesh,point,cloud" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "log" ),
    Help( QStringLiteral( "log" ), tr( "function" ), tr( "Returns the value of the logarithm of the passed value and base." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "log" ), tr( "Returns the value of the logarithm of the passed value and base." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "base" ), tr( "any positive number" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "any positive number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "log(2, 32)" ), tr( "5" ), QString() )
            << HelpExample( tr( "log(0.5, 32)" ), tr( "-5" ), QString() ),
          QString(),
          QStringList()
            << tr( "base,logarithm" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "log10" ),
    Help( QStringLiteral( "log10" ), tr( "function" ), tr( "Returns the value of the base 10 logarithm of the passed expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "log10" ), tr( "Returns the value of the base 10 logarithm of the passed expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "any positive number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "log10(1)" ), tr( "0" ), QString() )
            << HelpExample( tr( "log10(100)" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "base,logarithm" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "longest_common_substring" ),
    Help( QStringLiteral( "longest_common_substring" ), tr( "function" ), tr( "Returns the longest common substring between two strings. This substring is the longest string that is a substring of the two input strings. For example, the longest common substring of \"ABABC\" and \"BABCA\" is \"BABC\". The substring is case sensitive." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "longest_common_substring" ), tr( "Returns the longest common substring between two strings. This substring is the longest string that is a substring of the two input strings. For example, the longest common substring of \"ABABC\" and \"BABCA\" is \"BABC\". The substring is case sensitive." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string1" ), tr( "a string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "string2" ), tr( "a string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "longest_common_substring('ABABC','BABCA')" ), tr( "'BABC'" ), QString() )
            << HelpExample( tr( "longest_common_substring('abcDeF','abcdef')" ), tr( "'abc'" ), QString() )
            << HelpExample( tr( "longest_common_substring(upper('abcDeF'),upper('abcdex'))" ), tr( "'ABCDE'" ), QString() ),
          QString(),
          QStringList()
            << tr( "longest,common,input,sensitive,case,substring,strings" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "lower" ),
    Help( QStringLiteral( "lower" ), tr( "function" ), tr( "Converts a string to lower case letters." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "lower" ), tr( "Converts a string to lower case letters." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to convert to lower case" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "lower('HELLO World')" ), tr( "'hello world'" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,letters,lower,case" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "lpad" ),
    Help( QStringLiteral( "lpad" ), tr( "function" ), tr( "Returns a string padded on the left to the specified width, using a fill character. If the target width is smaller than the string's length, the string is truncated." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "lpad" ), tr( "Returns a string padded on the left to the specified width, using a fill character. If the target width is smaller than the string's length, the string is truncated." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to pad" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "width" ), tr( "length of new string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "fill" ), tr( "character to pad the remaining space with" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "lpad('Hello', 10, 'x')" ), tr( "'xxxxxHello'" ), QString() )
            << HelpExample( tr( "lpad('Hello', 3, 'x')" ), tr( "'Hel'" ), QString() ),
          QString(),
          QStringList()
            << tr( "length,padded,width,truncated,specified,target,fill,left,character,smaller" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ltrim" ),
    Help( QStringLiteral( "ltrim" ), tr( "function" ), tr( "Removes the longest string containing only the specified characters (a space by default) from the start of string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "ltrim" ), tr( "Removes the longest string containing only the specified characters (a space by default) from the start of string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to trim" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "characters" ), tr( "characters to trim" ), false, false, true, QStringLiteral( "' '" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ltrim('   hello world  ')" ), tr( "'hello world  '" ), QString() )
            << HelpExample( tr( "ltrim('zzzytest', 'xyz')" ), tr( "'test'" ), QString() ),
          QString(),
          QStringList()
            << tr( "removes,leading,whitespace,spaces,tabs" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "m" ),
    Help( QStringLiteral( "m" ), tr( "function" ), tr( "Returns the m (measure) value of a point geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "m" ), tr( "Returns the m (measure) value of a point geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a point geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "m( geom_from_wkt( 'POINTM(2 5 4)' ) )" ), tr( "4" ), QString() ),
          QString(),
          QStringList()
            << tr( "point,measure" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "m_at" ),
    Help( QStringLiteral( "m_at" ), tr( "function" ), tr( "Retrieves a m coordinate of the geometry, or NULL if the geometry has no m value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "m_at" ), tr( "Retrieves a m coordinate of the geometry, or NULL if the geometry has no m value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertex" ), tr( "index of the vertex of the geometry (indices start at 0; negative values apply from the last index, starting at -1)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "m_at(geom_from_wkt('LineStringZM(0 0 0 0, 10 10 0 5, 10 10 0 0)'), 1)" ), tr( "5" ), QString() ),
          QString(),
          QStringList()
            << tr( "retrieves,coordinate,measure" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "m_max" ),
    Help( QStringLiteral( "m_max" ), tr( "function" ), tr( "Returns the maximum m (measure) value of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "m_max" ), tr( "Returns the maximum m (measure) value of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry containing m values" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "m_max( make_point_m( 0,0,1 ) )" ), tr( "1" ), QString() )
            << HelpExample( tr( "m_max(make_line( make_point_m( 0,0,1 ), make_point_m( -1,-1,2 ), make_point_m( -2,-2,0 ) ) )" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "maximum,measure" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "m_min" ),
    Help( QStringLiteral( "m_min" ), tr( "function" ), tr( "Returns the minimum m (measure) value of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "m_min" ), tr( "Returns the minimum m (measure) value of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry containing m values" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "m_min( make_point_m( 0,0,1 ) )" ), tr( "1" ), QString() )
            << HelpExample( tr( "m_min(make_line( make_point_m( 0,0,1 ), make_point_m( -1,-1,2 ), make_point_m( -2,-2,0 ) ) )" ), tr( "0" ), QString() ),
          QString(),
          QStringList()
            << tr( "minimum,measure" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "main_angle" ),
    Help( QStringLiteral( "main_angle" ), tr( "function" ), tr( "Returns the angle of the long axis (clockwise, in degrees from North) of the oriented minimal bounding rectangle, which completely covers the geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "main_angle" ), tr( "Returns the angle of the long axis (clockwise, in degrees from North) of the oriented minimal bounding rectangle, which completely covers the geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "main_angle(geom_from_wkt('Polygon ((321577 129614, 321581 129618, 321585 129615, 321581 129610, 321577 129614))'))" ), tr( "38.66" ), QString() ),
          QString(),
          QStringList()
            << tr( "oriented,minimal,covers,clockwise,angle,long,north,degrees,rectangle,axis,bounding" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "majority" ),
    Help( QStringLiteral( "majority" ), tr( "function" ), tr( "Returns the aggregate majority of values (most commonly occurring value) from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "majority" ), tr( "Returns the aggregate majority of values (most commonly occurring value) from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "majority(\"class\",group_by:=\"state\")" ), tr( "most commonly occurring class value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "occurring,field,majority,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_circle" ),
    Help( QStringLiteral( "make_circle" ), tr( "function" ), tr( "Creates a circular polygon." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_circle" ), tr( "Creates a circular polygon." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "center" ), tr( "center point of the circle" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "radius" ), tr( "radius of the circle" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "optional argument for polygon segmentation. By default this value is 36" ), false, false, true, QStringLiteral( "36" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_circle(make_point(10,10), 5, 4))" ), tr( "'Polygon ((10 15, 15 10, 10 5, 5 10, 10 15))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_circle(make_point(10,10,5), 5, 4))" ), tr( "'PolygonZ ((10 15 5, 15 10 5, 10 5 5, 5 10 5, 10 15 5))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_circle(make_point(10,10,5,30), 5, 4))" ), tr( "'PolygonZM ((10 15 5 30, 15 10 5 30, 10 5 5 30, 5 10 5 30, 10 15 5 30))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "circular,polygon" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_date" ),
    Help( QStringLiteral( "make_date" ), tr( "function" ), tr( "Creates a date value from year, month and day numbers." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_date" ), tr( "Creates a date value from year, month and day numbers." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "year" ), tr( "Year number. Years 1 to 99 are interpreted as is. Year 0 is invalid." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "month" ), tr( "Month number, where 1=January" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "day" ), tr( "Day number, beginning with 1 for the first day in the month" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "make_date(2020,5,4)" ), tr( "date value 2020-05-04" ), QString() ),
          QString(),
          QStringList()
            << tr( "year,date,month,numbers,day" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_datetime" ),
    Help( QStringLiteral( "make_datetime" ), tr( "function" ), tr( "Creates a datetime value from year, month, day, hour, minute and second numbers." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_datetime" ), tr( "Creates a datetime value from year, month, day, hour, minute and second numbers." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "year" ), tr( "Year number. Years 1 to 99 are interpreted as is. Year 0 is invalid." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "month" ), tr( "Month number, where 1=January" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "day" ), tr( "Day number, beginning with 1 for the first day in the month" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "hour" ), tr( "Hour number" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "minute" ), tr( "Minutes" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "second" ), tr( "Seconds (fractional values include milliseconds)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "make_datetime(2020,5,4,13,45,30.5)" ), tr( "datetime value 2020-05-04 13:45:30.500" ), QString() ),
          QString(),
          QStringList()
            << tr( "minute,month,numbers,day,year,second,hour,datetime" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_ellipse" ),
    Help( QStringLiteral( "make_ellipse" ), tr( "function" ), tr( "Creates an elliptical polygon." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_ellipse" ), tr( "Creates an elliptical polygon." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "center" ), tr( "center point of the ellipse" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "semi_major_axis" ), tr( "semi-major axis of the ellipse" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "semi_minor_axis" ), tr( "semi-minor axis of the ellipse" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "azimuth" ), tr( "orientation of the ellipse" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "optional argument for polygon segmentation. By default this value is 36" ), false, false, true, QStringLiteral( "36" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_ellipse(make_point(10,10), 5, 2, 90, 4))" ), tr( "'Polygon ((15 10, 10 8, 5 10, 10 12, 15 10))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_ellipse(make_point(10,10,5), 5, 2, 90, 4))" ), tr( "'PolygonZ ((15 10 5, 10 8 5, 5 10 5, 10 12 5, 15 10 5))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_ellipse(make_point(10,10,5,30), 5, 2, 90, 4))" ), tr( "'PolygonZM ((15 10 5 30, 10 8 5 30, 5 10 5 30, 10 12 5 30, 15 10 5 30))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "polygon,elliptical" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_interval" ),
    Help( QStringLiteral( "make_interval" ), tr( "function" ), tr( "Creates an interval value from year, month, weeks, days, hours, minute and seconds values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_interval" ), tr( "Creates an interval value from year, month, weeks, days, hours, minute and seconds values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "years" ), tr( "Number of years (assumes a 365.25 day year length)." ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "months" ), tr( "Number of months (assumes a 30 day month length)" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "weeks" ), tr( "Number of weeks" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "days" ), tr( "Number of days" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "hours" ), tr( "Number of hours" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "minutes" ), tr( "Number of minutes" ), false, false, true, QStringLiteral( "0" ) )
              << HelpArg( QStringLiteral( "seconds" ), tr( "Number of seconds" ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "make_interval(hours:=3)" ), tr( "interval: 3 hours" ), QString() )
            << HelpExample( tr( "make_interval(days:=2, hours:=3)" ), tr( "interval: 2.125 days" ), QString() )
            << HelpExample( tr( "make_interval(minutes:=0.5, seconds:=5)" ), tr( "interval: 35 seconds" ), QString() ),
          QString(),
          QStringList()
            << tr( "minute,seconds,month,year,weeks,values,interval,hours,days" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_line" ),
    Help( QStringLiteral( "make_line" ), tr( "function" ), tr( "Creates a line geometry from a series of point geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "List of arguments variant" ), tr( "Line vertices are specified as separate arguments to the function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "point2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "point" ), tr( "a point geometry (or array of points)" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_line(make_point(2,4),make_point(3,5)))" ), tr( "'LineString (2 4, 3 5)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_line(make_point(2,4),make_point(3,5),make_point(9,7)))" ), tr( "'LineString (2 4, 3 5, 9 7)'" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Array variant" ), tr( "Line vertices are specified as an array of points." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "array" ), tr( "array of points" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_line(array(make_point(2,4),make_point(3,5),make_point(9,7))))" ), tr( "'LineString (2 4, 3 5, 9 7)'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_point" ),
    Help( QStringLiteral( "make_point" ), tr( "function" ), tr( "Creates a point geometry from an x and y (and optional z and m) value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_point" ), tr( "Creates a point geometry from an x and y (and optional z and m) value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "x" ), tr( "x coordinate of point" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "y" ), tr( "y coordinate of point" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "z" ), tr( "optional z coordinate of point" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "m" ), tr( "optional m value of point" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_point(2,4))" ), tr( "'Point (2 4)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_point(2,4,6))" ), tr( "'PointZ (2 4 6)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_point(2,4,6,8))" ), tr( "'PointZM (2 4 6 8)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "optional,point" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_point_m" ),
    Help( QStringLiteral( "make_point_m" ), tr( "function" ), tr( "Creates a point geometry from an x, y coordinate and m value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_point_m" ), tr( "Creates a point geometry from an x, y coordinate and m value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "x" ), tr( "x coordinate of point" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "y" ), tr( "y coordinate of point" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "m" ), tr( "m value of point" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_point_m(2,4,6))" ), tr( "'PointM (2 4 6)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "point,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_polygon" ),
    Help( QStringLiteral( "make_polygon" ), tr( "function" ), tr( "Creates a polygon geometry from an outer ring and optional series of inner ring geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_polygon" ), tr( "Creates a polygon geometry from an outer ring and optional series of inner ring geometries." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "outerRing" ), tr( "closed line geometry for polygon's outer ring" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "innerRing1" ), QString(), false, true, true, QString() )
              << HelpArg( QStringLiteral( "innerRing2" ), QString(), false, true, true, QString() )
              << HelpArg( QStringLiteral( "innerRing" ), tr( "optional closed line geometry for inner ring" ), true, false, true, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_polygon(geom_from_wkt('LINESTRING( 0 0, 0 1, 1 1, 1 0, 0 0 )')))" ), tr( "'Polygon ((0 0, 0 1, 1 1, 1 0, 0 0))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_polygon(geom_from_wkt('LINESTRING( 0 0, 0 1, 1 1, 1 0, 0 0 )'),geom_from_wkt('LINESTRING( 0.1 0.1, 0.1 0.2, 0.2 0.2, 0.2 0.1, 0.1 0.1 )'),geom_from_wkt('LINESTRING( 0.8 0.8, 0.8 0.9, 0.9 0.9, 0.9 0.8, 0.8 0.8 )')))" ), tr( "'Polygon ((0 0, 0 1, 1 1, 1 0, 0 0),(0.1 0.1, 0.1 0.2, 0.2 0.2, 0.2 0.1, 0.1 0.1),(0.8 0.8, 0.8 0.9, 0.9 0.9, 0.9 0.8, 0.8 0.8))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "outer,ring,series,inner,optional,polygon" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_rectangle_3points" ),
    Help( QStringLiteral( "make_rectangle_3points" ), tr( "function" ), tr( "Creates a rectangle from 3 points." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_rectangle_3points" ), tr( "Creates a rectangle from 3 points." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point1" ), tr( "First point." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point2" ), tr( "Second point." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point3" ), tr( "Third point." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "option" ), tr( "An optional argument to construct the rectangle. By default this value is 0. Value can be 0 (distance) or 1 (projected). Option distance: Second distance is equal to the distance between 2nd and 3rd point. Option projected: Second distance is equal to the distance of the perpendicular projection of the 3rd point on the segment or its extension." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_rectangle_3points(make_point(0, 0), make_point(0,5), make_point(5, 5), 0))" ), tr( "'Polygon ((0 0, 0 5, 5 5, 5 0, 0 0))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_rectangle_3points(make_point(0, 0), make_point(0,5), make_point(5, 3), 1))" ), tr( "'Polygon ((0 0, 0 5, 5 5, 5 0, 0 0))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "rectangle,points" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_regular_polygon" ),
    Help( QStringLiteral( "make_regular_polygon" ), tr( "function" ), tr( "Creates a regular polygon." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_regular_polygon" ), tr( "Creates a regular polygon." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "center" ), tr( "center of the regular polygon" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "radius" ), tr( "second point. The first if the regular polygon is inscribed. The midpoint of the first side if the regular polygon is circumscribed." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "number_sides" ), tr( "Number of sides/edges of the regular polygon" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "circle" ), tr( "Optional argument to construct the regular polygon. By default this value is 0. Value can be 0 (inscribed) or 1 (circumscribed)" ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_regular_polygon(make_point(0,0), make_point(0,5), 5))" ), tr( "'Polygon ((0 5, 4.76 1.55, 2.94 -4.05, -2.94 -4.05, -4.76 1.55, 0 5))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_regular_polygon(make_point(0,0), project(make_point(0,0), 4.0451, radians(36)), 5))" ), tr( "'Polygon ((0 5, 4.76 1.55, 2.94 -4.05, -2.94 -4.05, -4.76 1.55, 0 5))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "polygon,regular" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_square" ),
    Help( QStringLiteral( "make_square" ), tr( "function" ), tr( "Creates a square from a diagonal." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_square" ), tr( "Creates a square from a diagonal." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point1" ), tr( "First point of the diagonal" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point2" ), tr( "Last point of the diagonal" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_square( make_point(0,0), make_point(5,5)))" ), tr( "'Polygon ((0 0, -0 5, 5 5, 5 0, 0 0))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_square( make_point(5,0), make_point(5,5)))" ), tr( "'Polygon ((5 0, 2.5 2.5, 5 5, 7.5 2.5, 5 0))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "square,diagonal" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_time" ),
    Help( QStringLiteral( "make_time" ), tr( "function" ), tr( "Creates a time value from hour, minute and second numbers." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_time" ), tr( "Creates a time value from hour, minute and second numbers." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "hour" ), tr( "Hour number" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "minute" ), tr( "Minutes" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "second" ), tr( "Seconds (fractional values include milliseconds)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "make_time(13,45,30.5)" ), tr( "time value 13:45:30.500" ), QString() ),
          QString(),
          QStringList()
            << tr( "minute,hour,second,numbers,time" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_triangle" ),
    Help( QStringLiteral( "make_triangle" ), tr( "function" ), tr( "Creates a triangle polygon." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_triangle" ), tr( "Creates a triangle polygon." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point1" ), tr( "first point of the triangle" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point2" ), tr( "second point of the triangle" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point3" ), tr( "third point of the triangle" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_triangle(make_point(0,0), make_point(5,5), make_point(0,10)))" ), tr( "'Triangle ((0 0, 5 5, 0 10, 0 0))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(boundary(make_triangle(make_point(0,0), make_point(5,5), make_point(0,10))))" ), tr( "'LineString (0 0, 5 5, 0 10, 0 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "triangle,polygon" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "make_valid" ),
    Help( QStringLiteral( "make_valid" ), tr( "function" ), tr( "Returns a valid geometry or an empty geometry if the geometry could not be made valid." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "make_valid" ), tr( "Returns a valid geometry or an empty geometry if the geometry could not be made valid." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "method" ), tr( "repair algorithm. May be either 'structure' or 'linework'. The 'linework' option combines all rings into a set of noded lines and then extracts valid polygons from that linework. The 'structure' method first makes all rings valid and then merges shells and subtracts holes from shells to generate valid result. Assumes that holes and shells are correctly categorized." ), false, false, true, QStringLiteral( "structure" ) )
              << HelpArg( QStringLiteral( "keep_collapsed" ), tr( "if set to true, then components that have collapsed into a lower dimensionality will be kept. For example, a ring collapsing to a line, or a line collapsing to a point." ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(make_valid(geom_from_wkt('POLYGON((3 2, 4 1, 5 8, 3 2, 4 2))')))" ), tr( "'Polygon ((3 2, 5 8, 4 1, 3 2))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_valid(geom_from_wkt('POLYGON((3 2, 4 1, 5 8, 3 2, 4 2))'), 'linework'))" ), tr( "'GeometryCollection (Polygon ((5 8, 4 1, 3 2, 5 8)),LineString (3 2, 4 2))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(make_valid(geom_from_wkt('POLYGON((3 2, 4 1, 5 8))'), method:='linework'))" ), tr( "'Polygon ((3 2, 4 1, 5 8, 3 2))'" ), QString() )
            << HelpExample( tr( "make_valid(geom_from_wkt('LINESTRING(0 0)'))" ), tr( "An empty geometry" ), QString() ),
          QString(),
          QStringList()
            << tr( "rules,valid,ogc,according,formed,repair,fix" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map" ),
    Help( QStringLiteral( "map" ), tr( "function" ), tr( "Returns a map containing all the keys and values passed as pair of parameters." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map" ), tr( "Returns a map containing all the keys and values passed as pair of parameters." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "key1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "key2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "key" ), tr( "a key (string)" ), true, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "a value" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "map('1','one','2', 'two')" ), tr( "{ '1': 'one', '2': 'two' }" ), QString() )
            << HelpExample( tr( "map('1','one','2', 'two')['1']" ), tr( "'one'" ), QString() ),
          QString(),
          QStringList()
            << tr( "passed,keys,pair,containing,parameters,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_akeys" ),
    Help( QStringLiteral( "map_akeys" ), tr( "function" ), tr( "Returns all the keys of a map as an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_akeys" ), tr( "Returns all the keys of a map as an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_akeys(map('1','one','2','two'))" ), tr( "[ '1', '2' ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,map,keys" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_avals" ),
    Help( QStringLiteral( "map_avals" ), tr( "function" ), tr( "Returns all the values of a map as an array." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_avals" ), tr( "Returns all the values of a map as an array." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_avals(map('1','one','2','two'))" ), tr( "[ 'one', 'two' ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_concat" ),
    Help( QStringLiteral( "map_concat" ), tr( "function" ), tr( "Returns a map containing all the entries of the given maps. If two maps contain the same key, the value of the second map is taken." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_concat" ), tr( "Returns a map containing all the entries of the given maps. If two maps contain the same key, the value of the second map is taken." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "map2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "map_concat(map('1','one', '2','overridden'),map('2','two', '3','three'))" ), tr( "{ '1': 'one', '2': 'two', '3': 'three' }" ), QString() ),
          QString(),
          QStringList()
            << tr( "containing,key,concatenate,contain,entries,maps,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_credits" ),
    Help( QStringLiteral( "map_credits" ), tr( "function" ), tr( "Returns a list of credit (usage rights) strings for the layers shown in a layout, or specific layout map item." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_credits" ), tr( "Returns a list of credit (usage rights) strings for the layers shown in a layout, or specific layout map item." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "id" ), tr( "Map item ID. If not specified, the layers from all maps in the layout will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "include_layer_names" ), tr( "Set to true to include layer names before their credit strings" ), false, false, true, QStringLiteral( "false" ) )
              << HelpArg( QStringLiteral( "layer_name_separator" ), tr( "String to insert between layer names and their credit strings, if include_layer_names is true" ), false, false, true, QStringLiteral( "': '" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array_to_string( map_credits() )" ), tr( "comma separated list of layer credits for all layers shown in all map items in the layout, e.g 'CC-BY-NC, CC-BY-SA'" ), QString() )
            << HelpExample( tr( "array_to_string( map_credits( 'Main Map' ) )" ), tr( "comma separated list of layer credits for layers shown in the 'Main Map' layout item, e.g 'CC-BY-NC, CC-BY-SA'" ), QString() )
            << HelpExample( tr( "array_to_string( map_credits( 'Main Map', include_layer_names := true, layer_name_separator := ': ' ) )" ), tr( "comma separated list of layer names and their credits for layers shown in the 'Main Map' layout item, e.g. 'Railway lines: CC-BY-NC, Basemap: CC-BY-SA'" ), QString() ),
          QString(),
          QStringList()
            << tr( "list,rights,layers,layout,item,usage,credit,strings,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_delete" ),
    Help( QStringLiteral( "map_delete" ), tr( "function" ), tr( "Returns a map with the given key and its corresponding value deleted." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_delete" ), tr( "Returns a map with the given key and its corresponding value deleted." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "key" ), tr( "the key to delete" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_delete(map('1','one','2','two'),'2')" ), tr( "{ '1': 'one' }" ), QString() ),
          QString(),
          QStringList()
            << tr( "deleted,corresponding,map,key" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_exist" ),
    Help( QStringLiteral( "map_exist" ), tr( "function" ), tr( "Returns TRUE if the given key exists in the map." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_exist" ), tr( "Returns TRUE if the given key exists in the map." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "key" ), tr( "the key to lookup" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_exist(map('1','one','2','two'),'3')" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "map,exists,key" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_get" ),
    Help( QStringLiteral( "map_get" ), tr( "function" ), tr( "Returns the value of a map, given its key. Returns NULL if the key does not exist." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_get" ), tr( "Returns the value of a map, given its key. Returns NULL if the key does not exist." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "key" ), tr( "the key to lookup" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_get(map('1','one','2','two'),'2')" ), tr( "'two'" ), QString() )
            << HelpExample( tr( "map_get( item_variables('Map 0'), 'map_scale')" ), tr( "scale of the item 'Map 0' (if it exists) in the current print layout" ), QString() ),
          QString(),
          QStringList()
            << tr( "map,exists,key" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_insert" ),
    Help( QStringLiteral( "map_insert" ), tr( "function" ), tr( "Returns a map with an added key/value. If the key already exists, its value is overridden." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_insert" ), tr( "Returns a map with an added key/value. If the key already exists, its value is overridden." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "key" ), tr( "the key to add" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to add" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_insert(map('1','one'),'3','three')" ), tr( "{ '1': 'one', '3': 'three' }" ), QString() )
            << HelpExample( tr( "map_insert(map('1','one','2','overridden'),'2','two')" ), tr( "{ '1': 'one', '2': 'two' }" ), QString() ),
          QString(),
          QStringList()
            << tr( "map,added,exists,key,overridden" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_prefix_keys" ),
    Help( QStringLiteral( "map_prefix_keys" ), tr( "function" ), tr( "Returns a map with all keys prefixed by a given string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_prefix_keys" ), tr( "Returns a map with all keys prefixed by a given string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "prefix" ), tr( "a string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_prefix_keys(map('1','one','2','two'), 'prefix-')" ), tr( "{ 'prefix-1': 'one', 'prefix-2': 'two' }" ), QString() ),
          QString(),
          QStringList()
            << tr( "prefixed,keys,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_to_hstore" ),
    Help( QStringLiteral( "map_to_hstore" ), tr( "function" ), tr( "Merge map elements into a hstore-formatted string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_to_hstore" ), tr( "Merge map elements into a hstore-formatted string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "the input map" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_to_hstore(map('1','one','2','two'))" ), tr( "'\"1\"=>\"one\"','\"2\"=>\"two\"'" ), QString() ),
          QString(),
          QStringList()
            << tr( "formatted,hstore,elements,map,merge" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_to_html_dl" ),
    Help( QStringLiteral( "map_to_html_dl" ), tr( "function" ), tr( "Merge map elements into a HTML definition list string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_to_html_dl" ), tr( "Merge map elements into a HTML definition list string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "the input map" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_to_html_dl(map('1','one','2','two'))" ), tr( "<dl><dt>1</dt><dd>one</dd><dt>2</dt><dd>two</dd></dl>" ), QString() ),
          QString(),
          QStringList()
            << tr( "formatted,map,html" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "map_to_html_table" ),
    Help( QStringLiteral( "map_to_html_table" ), tr( "function" ), tr( "Merge map elements into a HTML table string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "map_to_html_table" ), tr( "Merge map elements into a HTML table string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "the input map" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "map_to_html_table(map('1','one','2','two'))" ), tr( "<table><thead><tr><th>1</th><th>2</th></tr></thead><tbody><tr><td>one</td><td>two</td></tr></tbody></table>" ), QString() ),
          QString(),
          QStringList()
            << tr( "formatted,map,html" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "maptip" ),
    Help( QStringLiteral( "maptip" ), tr( "function" ), tr( "Returns the maptip for a given feature in a layer. The expression is evaluated by default. Can be used with zero, one or more arguments, see below for details." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "No parameters" ), tr( "If called with no parameters, the function will evaluate the maptip of the current feature in the current layer." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "maptip()" ), tr( "The maptip of the current feature in the current layer." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "One 'feature' parameter" ), tr( "If called with a 'feature' parameter only, the function will evaluate the specified feature from the current layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be evaluated." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "maptip(@atlas_feature)" ), tr( "The maptip of the current atlas feature." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Layer and feature parameters" ), tr( "If the function is called with both a layer and a feature, it will evaluate the specified feature from the specified layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "The layer (or its ID or name)" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be evaluated." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "evaluate" ), tr( "If the expression must be evaluated. If false, the expression will be returned as a string literal only (which could potentially be later evaluated using the 'eval_template' function)." ), false, false, true, QStringLiteral( "true" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "maptip('streets', get_feature_by_id('streets', 1))" ), tr( "The maptip of the feature with the ID 1 on the layer 'streets'." ), QString() )
            << HelpExample( tr( "maptip('a_layer_id', @feature, 'False')" ), tr( "The maptip of the given feature not evaluated." ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "max" ),
    Help( QStringLiteral( "max" ), tr( "function" ), tr( "Returns the largest value in a set of values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "max" ), tr( "Returns the largest value in a set of values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "a number" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "max(2,10.2,5.5)" ), tr( "10.2" ), QString() )
            << HelpExample( tr( "max(20.5,NULL,6.2)" ), tr( "20.5" ), QString() ),
          QString(),
          QStringList()
            << tr( "longest,biggest,most,largest,maximum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "max_length" ),
    Help( QStringLiteral( "max_length" ), tr( "function" ), tr( "Returns the maximum length of strings from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "max_length" ), tr( "Returns the maximum length of strings from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "max_length(\"town_name\",group_by:=\"state\")" ), tr( "maximum length of town_name, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "length,maximum,strings,characters,count,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "maximum" ),
    Help( QStringLiteral( "maximum" ), tr( "function" ), tr( "Returns the aggregate maximum value from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "maximum" ), tr( "Returns the aggregate maximum value from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "maximum(\"population\",group_by:=\"state\")" ), tr( "maximum population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "maximum,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "md5" ),
    Help( QStringLiteral( "md5" ), tr( "function" ), tr( "Creates a md5 hash from a string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "md5" ), tr( "Creates a md5 hash from a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to hash" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "md5('QGIS')" ), tr( "'57470aaa9e22adaefac7f5f342f1c6da'" ), QString() ),
          QString(),
          QStringList()
            << tr( "hash" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "mean" ),
    Help( QStringLiteral( "mean" ), tr( "function" ), tr( "Returns the aggregate mean value from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "mean" ), tr( "Returns the aggregate mean value from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "mean(\"population\",group_by:=\"state\")" ), tr( "mean population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "average,aggregate,mean" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "median" ),
    Help( QStringLiteral( "median" ), tr( "function" ), tr( "Returns the aggregate median value from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "median" ), tr( "Returns the aggregate median value from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "median(\"population\",group_by:=\"state\")" ), tr( "median population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "median,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "mime_type" ),
    Help( QStringLiteral( "mime_type" ), tr( "function" ), tr( "Returns the mime type of the binary data." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "mime_type" ), tr( "Returns the mime type of the binary data." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "bytes" ), tr( "the binary data" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "mime_type('&lt;html&gt;&lt;body&gt;&lt;/body&gt;&lt;/html&gt;')" ), tr( "text/html" ), QString() )
            << HelpExample( tr( "mime_type(from_base64('R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAIAOw=='))" ), tr( "image/gif" ), QString() ),
          QString(),
          QStringList()
            << tr( "type,data,binary" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "min" ),
    Help( QStringLiteral( "min" ), tr( "function" ), tr( "Returns the smallest value in a set of values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "min" ), tr( "Returns the smallest value in a set of values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value1" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value2" ), QString(), false, true, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "a number" ), true, false, false, QString() ),
          /* variableLenArguments */ true,
          QList<HelpExample>()
            << HelpExample( tr( "min(20.5,10,6.2)" ), tr( "6.2" ), QString() )
            << HelpExample( tr( "min(2,-10.3,NULL)" ), tr( "-10.3" ), QString() ),
          QString(),
          QStringList()
            << tr( "least,smallest,minimum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "min_length" ),
    Help( QStringLiteral( "min_length" ), tr( "function" ), tr( "Returns the minimum length of strings from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "min_length" ), tr( "Returns the minimum length of strings from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "min_length(\"town_name\",group_by:=\"state\")" ), tr( "minimum length of town_name, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "length,characters,count,minimum,strings" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "minimal_circle" ),
    Help( QStringLiteral( "minimal_circle" ), tr( "function" ), tr( "Returns the minimal enclosing circle of a geometry. It represents the minimum circle that encloses all geometries within the set." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "minimal_circle" ), tr( "Returns the minimal enclosing circle of a geometry. It represents the minimum circle that encloses all geometries within the set." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "optional argument for polygon segmentation. By default this value is 36" ), false, false, true, QStringLiteral( "36" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( minimal_circle( geom_from_wkt( 'LINESTRING(0 5, 0 -5, 2 1)' ), 4 ) )" ), tr( "'Polygon ((0 5, 5 -0, -0 -5, -5 0, 0 5))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt( minimal_circle( geom_from_wkt( 'MULTIPOINT(1 2, 3 4, 3 2)' ), 4 ) )" ), tr( "'Polygon ((3 4, 3 2, 1 2, 1 4, 3 4))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "enclosing,minimal,minimum,represents,encloses,circle,smallest" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "minimum" ),
    Help( QStringLiteral( "minimum" ), tr( "function" ), tr( "Returns the aggregate minimum value from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "minimum" ), tr( "Returns the aggregate minimum value from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "minimum(\"population\",group_by:=\"state\")" ), tr( "minimum population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "minimum,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "minority" ),
    Help( QStringLiteral( "minority" ), tr( "function" ), tr( "Returns the aggregate minority of values (least occurring value) from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "minority" ), tr( "Returns the aggregate minority of values (least occurring value) from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "minority(\"class\",group_by:=\"state\")" ), tr( "least occurring class value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "least,occurring,field,minority,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "minute" ),
    Help( QStringLiteral( "minute" ), tr( "function" ), tr( "Extracts the minutes part from a datetime or time, or the number of minutes from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Time variant" ), tr( "Extracts the minutes part from a time or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "datetime" ), tr( "a time or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "minute( to_datetime('2012-07-22 13:24:57') )" ), tr( "24" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in minutes of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of minutes from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "minute(to_interval('3 minutes'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "minute(age('2012-07-22T00:20:00','2012-07-22T00:00:00'))" ), tr( "20" ), QString() )
            << HelpExample( tr( "minute(age('2012-01-01','2010-01-01'))" ), tr( "1051200" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "month" ),
    Help( QStringLiteral( "month" ), tr( "function" ), tr( "Extracts the month part from a date, or the number of months from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Date variant" ), tr( "Extracts the month part from a date or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "date" ), tr( "a date or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "month('2012-05-12')" ), tr( "05" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in months of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of months from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "month(to_interval('3 months'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "month(age('2012-01-01','2010-01-01'))" ), tr( "4.03333" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "nodes_to_points" ),
    Help( QStringLiteral( "nodes_to_points" ), tr( "function" ), tr( "Returns a multipoint geometry consisting of every node in the input geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "nodes_to_points" ), tr( "Returns a multipoint geometry consisting of every node in the input geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "ignore_closing_nodes" ), tr( "optional argument specifying whether to include duplicate nodes which close lines or polygons rings. Defaults to false, set to true to avoid including these duplicate nodes in the output collection." ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(nodes_to_points(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2)')))" ), tr( "'MultiPoint ((0 0),(1 1),(2 2))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(nodes_to_points(geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1))'),true))" ), tr( "'MultiPoint ((-1 -1),(4 0),(4 2),(0 2))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "vertex,multipoint,node,input" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "now" ),
    Help( QStringLiteral( "now" ), tr( "function" ), tr( "Returns the current date and time. The function is static and will return consistent results while evaluating. The time returned is the time when the expression is prepared." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "now" ), tr( "Returns the current date and time. The function is static and will return consistent results while evaluating. The time returned is the time when the expression is prepared." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "now()" ), tr( "2012-07-22T13:24:57" ), QString() ),
          QString(),
          QStringList()
            << tr( "static,evaluating,current,date,time" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "nullif" ),
    Help( QStringLiteral( "nullif" ), tr( "function" ), tr( "Returns a NULL value if value1 equals value2; otherwise it returns value1. This can be used to conditionally substitute values with NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "nullif" ), tr( "Returns a NULL value if value1 equals value2; otherwise it returns value1. This can be used to conditionally substitute values with NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value1" ), tr( "The value that should either be used or substituted with NULL." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value2" ), tr( "The control value that will trigger the NULL substitution." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "nullif('(none)', '(none)')" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "nullif('text', '(none)')" ), tr( "'text'" ), QString() )
            << HelpExample( tr( "nullif(\"name\", '')" ), tr( "NULL, if name is an empty string (or already NULL), the name in any other case." ), QString() ),
          QString(),
          QStringList()
            << tr( "substitute,equals,condition,compare" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "num_geometries" ),
    Help( QStringLiteral( "num_geometries" ), tr( "function" ), tr( "Returns the number of geometries in a geometry collection, or the number of parts in a multi-part geometry. The function returns NULL if the input geometry is not a collection." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "num_geometries" ), tr( "Returns the number of geometries in a geometry collection, or the number of parts in a multi-part geometry. The function returns NULL if the input geometry is not a collection." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry collection or multi-part geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "num_geometries(geom_from_wkt('GEOMETRYCOLLECTION(POINT(0 1), POINT(0 0), POINT(1 0), POINT(1 1))'))" ), tr( "4" ), QString() )
            << HelpExample( tr( "num_geometries(geom_from_wkt('MULTIPOINT((0 1), (0 0), (1 0))'))" ), tr( "3" ), QString() ),
          QString(),
          QStringList()
            << tr( "collection,multipart,parts,count" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "num_interior_rings" ),
    Help( QStringLiteral( "num_interior_rings" ), tr( "function" ), tr( "Returns the number of interior rings in a polygon or geometry collection, or NULL if the input geometry is not a polygon or collection." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "num_interior_rings" ), tr( "Returns the number of interior rings in a polygon or geometry collection, or NULL if the input geometry is not a polygon or collection." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "input geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "num_interior_rings(geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1),(-0.1 -0.1, 0.4 0, 0.4 0.2, 0 0.2, -0.1 -0.1))'))" ), tr( "1" ), QString() ),
          QString(),
          QStringList()
            << tr( "rings,holes,count,polygon,collection,interior" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "num_points" ),
    Help( QStringLiteral( "num_points" ), tr( "function" ), tr( "Returns the number of vertices in a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "num_points" ), tr( "Returns the number of vertices in a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "num_points(@geometry)" ), tr( "number of vertices in the current feature's geometry" ), QString() ),
          QString(),
          QStringList()
            << tr( "vertices" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "num_rings" ),
    Help( QStringLiteral( "num_rings" ), tr( "function" ), tr( "Returns the number of rings (including exterior rings) in a polygon or geometry collection, or NULL if the input geometry is not a polygon or collection." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "num_rings" ), tr( "Returns the number of rings (including exterior rings) in a polygon or geometry collection, or NULL if the input geometry is not a polygon or collection." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "input geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "num_rings(geom_from_wkt('POLYGON((-1 -1, 4 0, 4 2, 0 2, -1 -1),(-0.1 -0.1, 0.4 0, 0.4 0.2, 0 0.2, -0.1 -0.1))'))" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "rings,holes,polygon,collection,exterior,including" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "num_selected" ),
    Help( QStringLiteral( "num_selected" ), tr( "function" ), tr( "Returns the number of selected features on a given layer. By default works on the layer on which the expression is evaluated." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "num_selected" ), tr( "Returns the number of selected features on a given layer. By default works on the layer on which the expression is evaluated." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "The layer (or its id or name) on which the selection will be checked." ), false, false, true, QStringLiteral( "current layer" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "num_selected()" ), tr( "The number of selected features on the current layer." ), QString() )
            << HelpExample( tr( "num_selected('streets')" ), tr( "The number of selected features on the layer streets" ), QString() ),
          QString(),
          QStringList()
            << tr( "evaluated,selected,works,default,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "offset_curve" ),
    Help( QStringLiteral( "offset_curve" ), tr( "function" ), tr( "Returns a geometry formed by offsetting a linestring geometry to the side. Distances are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "offset_curve" ), tr( "Returns a geometry formed by offsetting a linestring geometry to the side. Distances are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a (multi)linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "offset distance. Positive values will be buffered to the left of lines, negative values to the right" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "number of segments to use to represent a quarter circle when a round join style is used. A larger number results in a smoother line with more nodes." ), false, false, true, QStringLiteral( "8" ) )
              << HelpArg( QStringLiteral( "join" ), tr( "join style for corners, where 1 = round, 2 = miter and 3 = bevel" ), false, false, true, QStringLiteral( "1" ) )
              << HelpArg( QStringLiteral( "miter_limit" ), tr( "limit on the miter ratio used for very sharp corners (when using miter joins only)" ), false, false, true, QStringLiteral( "2.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "offset_curve(@geometry, 10.5)" ), tr( "line offset to the left by 10.5 units" ), QString() )
            << HelpExample( tr( "offset_curve(@geometry, -10.5)" ), tr( "line offset to the right by 10.5 units" ), QString() )
            << HelpExample( tr( "offset_curve(@geometry, 10.5, segments:=16, join:=1)" ), tr( "line offset to the left by 10.5 units, using more segments to result in a smoother curve" ), QString() )
            << HelpExample( tr( "offset_curve(@geometry, 10.5, join:=3)" ), tr( "line offset to the left by 10.5 units, using a beveled join" ), QString() ),
          QString(),
          QStringList()
            << tr( "spatial,offsetting,reference,system,linestring,formed,distances,side" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "*" ),
    Help( QStringLiteral( "*" ), tr( "operator" ), tr( "Multiplication of two values" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "*" ), tr( "Multiplication of two values" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 * 4" ), tr( "20" ), QString() )
            << HelpExample( tr( "5 * NULL" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "multiplication,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "||" ),
    Help( QStringLiteral( "||" ), tr( "operator" ), tr( "Joins two values together into a string.<br><br>If one of the values is NULL the result will be NULL. See the CONCAT function for a different behavior." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "||" ), tr( "Joins two values together into a string.<br><br>If one of the values is NULL the result will be NULL. See the CONCAT function for a different behavior." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'Here' || ' and ' || 'there'" ), tr( "'Here and there'" ), QString() )
            << HelpExample( tr( "'Nothing' || NULL" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "'Dia: ' || \"Diameter\"" ), tr( "'Dia: 25'" ), QString() )
            << HelpExample( tr( "1 || 2" ), tr( "'12'" ), QString() ),
          QString(),
          QStringList()
            << tr( "behavior,different,see,concat,null,joins,result,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "/" ),
    Help( QStringLiteral( "/" ), tr( "operator" ), tr( "Division of two values" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "/" ), tr( "Division of two values" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 / 4" ), tr( "1.25" ), QString() )
            << HelpExample( tr( "5 / NULL" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "division,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "=" ),
    Help( QStringLiteral( "=" ), tr( "operator" ), tr( "Compares two values and evaluates to 1 if they are equal." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "=" ), tr( "Compares two values and evaluates to 1 if they are equal." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 = 4" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "4 = 4" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "5 = NULL" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "NULL = NULL" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "compares,evaluates,values,equal" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "^" ),
    Help( QStringLiteral( "^" ), tr( "operator" ), tr( "Power of two values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "^" ), tr( "Power of two values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 ^ 4" ), tr( "625" ), QString() )
            << HelpExample( tr( "5 ^ NULL" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "power,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "//" ),
    Help( QStringLiteral( "//" ), tr( "operator" ), tr( "Floor division of two values" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "//" ), tr( "Floor division of two values" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "9 // 2" ), tr( "4" ), QString() ),
          QString(),
          QStringList()
            << tr( "division,floor,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( ">=" ),
    Help( QStringLiteral( ">=" ), tr( "operator" ), tr( "Compares two values and evaluates to 1 if the left value is greater or equal than the right value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( ">=" ), tr( "Compares two values and evaluates to 1 if the left value is greater or equal than the right value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 &gt;= 4" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "5 &gt;= 5" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 &gt;= 5" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "compares,equal,values,greater,left,evaluates,right" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( ">" ),
    Help( QStringLiteral( ">" ), tr( "operator" ), tr( "Compares two values and evaluates to 1 if the left value is greater than the right value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( ">" ), tr( "Compares two values and evaluates to 1 if the left value is greater than the right value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 &gt; 4" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "5 &gt; 5" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "4 &gt; 5" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "greater,compares,evaluates,left,values,right" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "[]" ),
    Help( QStringLiteral( "[]" ), tr( "operator" ), tr( "Index operator. Returns an element from an array or map value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "[]" ), tr( "Index operator. Returns an element from an array or map value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "index" ), tr( "array index or map key value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "array(1,2,3)[0]" ), tr( "1" ), QString() )
            << HelpExample( tr( "array(1,2,3)[2]" ), tr( "3" ), QString() )
            << HelpExample( tr( "array(1,2,3)[-1]" ), tr( "3" ), QString() )
            << HelpExample( tr( "map('a',1,'b',2)['a']" ), tr( "1" ), QString() )
            << HelpExample( tr( "map('a',1,'b',2)['b']" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,operator,element,map,index" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "<=" ),
    Help( QStringLiteral( "<=" ), tr( "operator" ), tr( "Compares two values and evaluates to 1 if the left value is less or equal than the right value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "<=" ), tr( "Compares two values and evaluates to 1 if the left value is less or equal than the right value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 &lt;= 4" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "5 &lt;= 5" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 &lt;= 5" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "compares,equal,less,values,left,evaluates,right" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "<" ),
    Help( QStringLiteral( "<" ), tr( "operator" ), tr( "Compares two values and evaluates to 1 if the left value is less than the right value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "<" ), tr( "Compares two values and evaluates to 1 if the left value is less than the right value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 &lt; 4" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "5 &lt; 5" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "4 &lt; 5" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "left,evaluates,compares,less,values,right" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "-" ),
    Help( QStringLiteral( "-" ), tr( "operator" ), tr( "Subtraction of two values. If one of the values is NULL the result will be NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "-" ), tr( "Subtraction of two values. If one of the values is NULL the result will be NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 - 4" ), tr( "1" ), QString() )
            << HelpExample( tr( "5 - NULL" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "to_datetime('2012-05-05 12:00:00') - to_interval('1 day 2 hours')" ), tr( "2012-05-04T10:00:00" ), QString() ),
          QString(),
          QStringList()
            << tr( "subtraction,null,result,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "%" ),
    Help( QStringLiteral( "%" ), tr( "operator" ), tr( "Remainder of division. Takes the sign of the dividend." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "%" ), tr( "Remainder of division. Takes the sign of the dividend." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "9 % 2" ), tr( "1" ), QString() )
            << HelpExample( tr( "9 % -2" ), tr( "1" ), QString() )
            << HelpExample( tr( "-9 % 2" ), tr( "-1" ), QString() )
            << HelpExample( tr( "5 % NULL" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "division,remainder,modulo" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "<>" ),
    Help( QStringLiteral( "<>" ), tr( "operator" ), tr( "Compares two values and evaluates to 1 if they are not equal." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "<>" ), tr( "Compares two values and evaluates to 1 if they are not equal." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 &lt;&gt; 4" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "4 &lt;&gt; 4" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "5 &lt;&gt; NULL" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "NULL &lt;&gt; NULL" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "compares,evaluates,values,equal" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "+" ),
    Help( QStringLiteral( "+" ), tr( "operator" ), tr( "Addition of two values. If one of the values is NULL the result will be NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "+" ), tr( "Addition of two values. If one of the values is NULL the result will be NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "a" ), tr( "value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "b" ), tr( "value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "5 + 4" ), tr( "9" ), QString() )
            << HelpExample( tr( "5 + NULL" ), tr( "NULL" ), QString() )
            << HelpExample( tr( "'QGIS ' + 'ROCKS'" ), tr( "'QGIS ROCKS'" ), QString() )
            << HelpExample( tr( "to_datetime('2020-08-01 12:00:00') + '1 day 2 hours'" ), tr( "2020-08-02T14:00:00" ), QString() ),
          QString(),
          QStringList()
            << tr( "addition,null,result,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "~" ),
    Help( QStringLiteral( "~" ), tr( "operator" ), tr( "Performs a regular expression match on a string value. Backslash characters must be double escaped (e.g., \"\\\\s\" to match a white space character)." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "~" ), tr( "Performs a regular expression match on a string value. Backslash characters must be double escaped (e.g., \"\\\\s\" to match a white space character)." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "A string value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "regex" ), tr( "A regular expression. Slashes must be escaped, eg \\\\d." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "'hello' ~ 'll'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'hello' ~ '^ll'" ), tr( "FALSE" ), QString() )
            << HelpExample( tr( "'hello' ~ 'llo$'" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "'abc123' ~ '\\\\d+'" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
            << tr( "white,space,regular,performs,backslash,characters,escaped,character,expression,match,regexp" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "order_parts" ),
    Help( QStringLiteral( "order_parts" ), tr( "function" ), tr( "Orders the parts of a MultiGeometry by a given criteria" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "order_parts" ), tr( "Orders the parts of a MultiGeometry by a given criteria" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a multi-type geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "orderby" ), tr( "an expression string defining the order criteria" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "ascending" ), tr( "boolean, True for ascending, False for descending" ), false, false, true, QStringLiteral( "true" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(order_parts(geom_from_wkt('MultiPolygon (((1 1, 5 1, 5 5, 1 5, 1 1)),((1 1, 9 1, 9 9, 1 9, 1 1)))'), 'area(@geometry)', False))" ), tr( "'MultiPolygon (((1 1, 9 1, 9 9, 1 9, 1 1)),((1 1, 5 1, 5 5, 1 5, 1 1)))'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(order_parts(geom_from_wkt('LineString(1 2, 3 2, 4 3)'), '1', True))" ), tr( "'LineString(1 2, 3 2, 4 3)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "criteria,multigeometry,orders,parts,given" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "oriented_bbox" ),
    Help( QStringLiteral( "oriented_bbox" ), tr( "function" ), tr( "Returns a geometry which represents the minimal oriented bounding box of an input geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "oriented_bbox" ), tr( "Returns a geometry which represents the minimal oriented bounding box of an input geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( oriented_bbox( geom_from_wkt( 'MULTIPOINT(1 2, 3 4, 3 2)' ) ) )" ), tr( "'Polygon ((3 2, 3 4, 1 4, 1 2, 3 2))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "oriented,box,minimal,represents,bounding" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlaps" ),
    Help( QStringLiteral( "overlaps" ), tr( "function" ), tr( "Tests whether a geometry overlaps another. Returns TRUE if the geometries share space, are of the same dimension, but are not completely contained by each other." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlaps" ), tr( "Tests whether a geometry overlaps another. Returns TRUE if the geometries share space, are of the same dimension, but are not completely contained by each other." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlaps( geom_from_wkt( 'LINESTRING(3 5, 4 4, 5 5, 5 3)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "overlaps( geom_from_wkt( 'LINESTRING(0 0, 1 1)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "share,tests,contained,overlaps,same,dimension,space" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_contains" ),
    Help( QStringLiteral( "overlay_contains" ), tr( "function" ), tr( "Returns whether the current feature spatially contains at least one feature from a target layer, or an array of expression-based results for the features in the target layer contained in the current feature.<br><br>Read more on the underlying GEOS \"Contains\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Contains.html'>ST_Contains</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_contains" ), tr( "Returns whether the current feature spatially contains at least one feature from a target layer, or an array of expression-based results for the features in the target layer contained in the current feature.<br><br>Read more on the underlying GEOS \"Contains\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Contains.html'>ST_Contains</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_contains('regions')" ), tr( "TRUE if the current feature spatially contains a region" ), QString() )
            << HelpExample( tr( "overlay_contains('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature spatially contains a region with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_contains('regions', name)" ), tr( "an array of names, for the regions contained in the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_contains('regions', name))" ), tr( "a string as a comma separated list of names, for the regions contained in the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_contains(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions contained in the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_contains(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions contained in the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "predicate,contained,target,contains,array,geos,st_contains,postgis,underlying,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_crosses" ),
    Help( QStringLiteral( "overlay_crosses" ), tr( "function" ), tr( "Returns whether the current feature spatially crosses at least one feature from a target layer, or an array of expression-based results for the features in the target layer crossed by the current feature.<br><br>Read more on the underlying GEOS \"Crosses\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Crosses.html'>ST_Crosses</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_crosses" ), tr( "Returns whether the current feature spatially crosses at least one feature from a target layer, or an array of expression-based results for the features in the target layer crossed by the current feature.<br><br>Read more on the underlying GEOS \"Crosses\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Crosses.html'>ST_Crosses</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_crosses('regions')" ), tr( "TRUE if the current feature spatially crosses a region" ), QString() )
            << HelpExample( tr( "overlay_crosses('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature spatially crosses a region with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_crosses('regions', name)" ), tr( "an array of names, for the regions crossed by the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_crosses('regions', name))" ), tr( "a string as a comma separated list of names, for the regions crossed by the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_crosses(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions crossed by the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_crosses(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions crossed by the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "predicate,st_crosses,crosses,current,target,array,geos,underlying,features,crossed" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_disjoint" ),
    Help( QStringLiteral( "overlay_disjoint" ), tr( "function" ), tr( "Returns whether the current feature is spatially disjoint from all the features of a target layer, or an array of expression-based results for the features in the target layer that are disjoint from the current feature.<br><br>Read more on the underlying GEOS \"Disjoint\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Disjoint.html'>ST_Disjoint</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_disjoint" ), tr( "Returns whether the current feature is spatially disjoint from all the features of a target layer, or an array of expression-based results for the features in the target layer that are disjoint from the current feature.<br><br>Read more on the underlying GEOS \"Disjoint\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Disjoint.html'>ST_Disjoint</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_disjoint('regions')" ), tr( "TRUE if the current feature is spatially disjoint from all the regions" ), QString() )
            << HelpExample( tr( "overlay_disjoint('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature is spatially disjoint from all the regions with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_disjoint('regions', name)" ), tr( "an array of names, for the regions spatially disjoint from the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_disjoint('regions', name))" ), tr( "a string as a comma separated list of names, for the regions spatially disjoint from the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_disjoint(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions spatially disjoint from the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_disjoint(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions spatially disjoint from the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "predicate,st_disjoint,disjoint,current,target,array,geos,underlying,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_equals" ),
    Help( QStringLiteral( "overlay_equals" ), tr( "function" ), tr( "Returns whether the current feature spatially equals to at least one feature from a target layer, or an array of expression-based results for the features in the target layer that are spatially equal to the current feature.<br><br>Read more on the underlying GEOS \"Equals\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Equals.html'>ST_Equals</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_equals" ), tr( "Returns whether the current feature spatially equals to at least one feature from a target layer, or an array of expression-based results for the features in the target layer that are spatially equal to the current feature.<br><br>Read more on the underlying GEOS \"Equals\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Equals.html'>ST_Equals</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_equals('regions')" ), tr( "TRUE if the current feature is spatially equal to a region" ), QString() )
            << HelpExample( tr( "overlay_equals('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature is spatially equal to a region with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_equals('regions', name)" ), tr( "an array of names, for the regions spatially equal to the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_equals('regions', name))" ), tr( "a string as a comma separated list of names, for the regions spatially equal to the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_equals(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions spatially equal to the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_equals(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions spatially equal to the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "predicate,current,equals,equal,target,array,geos,st_equals,described,underlying,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_intersects" ),
    Help( QStringLiteral( "overlay_intersects" ), tr( "function" ), tr( "Returns whether the current feature spatially intersects at least one feature from a target layer, or an array of expression-based results for the features in the target layer intersected by the current feature.<br><br>Read more on the underlying GEOS \"Intersects\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Intersects.html'>ST_Intersects</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_intersects" ), tr( "Returns whether the current feature spatially intersects at least one feature from a target layer, or an array of expression-based results for the features in the target layer intersected by the current feature.<br><br>Read more on the underlying GEOS \"Intersects\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Intersects.html'>ST_Intersects</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) )
              << HelpArg( QStringLiteral( "min_overlap" ), tr( "defines an optional exclusion filter:<ul><li>for polygons, a minimum area in current feature squared units for the intersection. If the intersection results in multiple polygons the intersection will be returned if at least one of the polygons has an area greater or equal to the value</li><li>for lines, a minimum length in current feature units. If the intersection results in multiple lines the intersection will be returned if at least one of the lines has a length greater or equal to the value.</li></ul>" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "min_inscribed_circle_radius" ), tr( "defines an optional exclusion filter (for polygons only): minimum radius in current feature units for the maximum inscribed circle of the intersection. If the intersection results in multiple polygons the intersection will be returned if at least one of the polygons has a radius for the maximum inscribed circle greater or equal to the value.<br>Read more on the underlying GEOS predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_MaximumInscribedCircle.html'>ST_MaximumInscribedCircle</a> function.<br>This argument requires GEOS >= 3.9." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "return_details" ), tr( "Set this to true to return a list of maps containing (key names in quotes) the feature 'id', the expression 'result' and the 'overlap' value (of the largest element in case of multipart). The 'radius' of the maximum inscribed circle is also returned when the target layer is a polygon. Only valid when used with the expression parameter" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "sort_by_intersection_size" ), tr( "only valid when used with an expression, set this to 'des' to return the results ordered by the overlap value in descending order or set this to 'asc' for ascending order." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_intersects('regions')" ), tr( "TRUE if the current feature spatially intersects a region" ), QString() )
            << HelpExample( tr( "overlay_intersects('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature spatially intersects a region with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_intersects('regions', name)" ), tr( "an array of names, for the regions intersected by the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_intersects('regions', name))" ), tr( "a string as a comma separated list of names, for the regions intersected by the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_intersects(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions intersected by the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_intersects(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions intersected by the current feature" ), QString() )
            << HelpExample( tr( "overlay_intersects(layer:='regions', min_overlap:=0.54)" ), tr( "TRUE if the current feature spatially intersects a region and the intersection area (of at least one of the parts in case of multipolygons) is greater or equal to 0.54" ), QString() )
            << HelpExample( tr( "overlay_intersects(layer:='regions', min_inscribed_circle_radius:=0.54)" ), tr( "TRUE if the current feature spatially intersects a region and the intersection area maximum inscribed circle's radius (of at least one of the parts in case of multipart) is greater or equal to 0.54" ), QString() )
            << HelpExample( tr( "overlay_intersects(layer:='regions', expression:= geom_to_wkt(@geometry), return_details:=true)" ), tr( "an array of maps containing 'id', 'result', 'overlap' and 'radius'" ), QString() )
            << HelpExample( tr( "overlay_intersects(layer:='regions', expression:= geom_to_wkt(@geometry), sort_by_intersection_size:='des')" ), tr( "an array of geometries (in WKT) ordered by the overlap value in descending order" ), QString() ),
          QString(),
          QStringList()
            << tr( "intersected,predicate,current,target,array,geos,postgis,described,st_intersects,intersects,underlying,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_nearest" ),
    Help( QStringLiteral( "overlay_nearest" ), tr( "function" ), tr( "Returns whether the current feature has feature(s) from a target layer within a given distance, or an array of expression-based results for the features in the target layer within a distance from the current feature.<br><br>Note: This function can be slow and consume a lot of memory for large layers." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_nearest" ), tr( "Returns whether the current feature has feature(s) from a target layer within a given distance, or an array of expression-based results for the features in the target layer within a distance from the current feature.<br><br>Note: This function can be slow and consume a lot of memory for large layers." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the target layer" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features in the target layer will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, only the nearest feature will be returned. If set to -1, returns all the matching features." ), false, false, true, QStringLiteral( "1" ) )
              << HelpArg( QStringLiteral( "max_distance" ), tr( "an optional distance to limit the search of matching features. If not set, all the features in the target layer will be used." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_nearest('airports')" ), tr( "TRUE if the \"airports\" layer has at least one feature" ), QString() )
            << HelpExample( tr( "overlay_nearest('airports', max_distance:= 5000)" ), tr( "TRUE if there is an airport within a distance of 5000 map units from the current feature" ), QString() )
            << HelpExample( tr( "overlay_nearest('airports', name)" ), tr( "the name of the closest airport to the current feature, as an array" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_nearest('airports', name))" ), tr( "the name of the closest airport to the current feature, as a string" ), QString() )
            << HelpExample( tr( "overlay_nearest(layer:='airports', expression:= name, max_distance:= 5000)" ), tr( "the name of the closest airport within a distance of 5000 map units from the current feature, as an array" ), QString() )
            << HelpExample( tr( "overlay_nearest(layer:='airports', expression:=\"name\", filter:= \"Use\"='Civilian', limit:=3)" ), tr( "an array of names, for up to the three closest civilian airports ordered by distance" ), QString() )
            << HelpExample( tr( "overlay_nearest(layer:='airports', expression:=\"name\", limit:= -1, max_distance:= 5000)" ), tr( "an array of names, for all the airports within a distance of 5000 map units from the current feature, ordered by distance" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,near,close,current,target,array,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_touches" ),
    Help( QStringLiteral( "overlay_touches" ), tr( "function" ), tr( "Returns whether the current feature spatially touches at least one feature from a target layer, or an array of expression-based results for the features in the target layer touched by the current feature.<br><br>Read more on the underlying GEOS \"Touches\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Touches.html'>ST_Touches</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_touches" ), tr( "Returns whether the current feature spatially touches at least one feature from a target layer, or an array of expression-based results for the features in the target layer touched by the current feature.<br><br>Read more on the underlying GEOS \"Touches\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Touches.html'>ST_Touches</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_touches('regions')" ), tr( "TRUE if the current feature spatially touches a region" ), QString() )
            << HelpExample( tr( "overlay_touches('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature spatially touches a region with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_touches('regions', name)" ), tr( "an array of names, for the regions touched by the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_touches('regions', name))" ), tr( "a string as a comma separated list of names, for the regions touched by the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_touches(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions touched by the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_touches(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions touched by the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "predicate,touches,current,target,array,geos,touched,st_touches,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "overlay_within" ),
    Help( QStringLiteral( "overlay_within" ), tr( "function" ), tr( "Returns whether the current feature is spatially within at least one feature from a target layer, or an array of expression-based results for the features in the target layer that contain the current feature.<br><br>Read more on the underlying GEOS \"Within\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Within.html'>ST_Within</a> function." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "overlay_within" ), tr( "Returns whether the current feature is spatially within at least one feature from a target layer, or an array of expression-based results for the features in the target layer that contain the current feature.<br><br>Read more on the underlying GEOS \"Within\" predicate, as described in PostGIS <a href='https://postgis.net/docs/ST_Within.html'>ST_Within</a> function." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the layer whose overlay is checked" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "an optional expression to evaluate on the features from the target layer. If not set, the function will just return a boolean indicating whether there is at least one match." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "an optional expression to filter the target features to check. If not set, all the features will be checked." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "limit" ), tr( "an optional integer to limit the number of matching features. If not set, all the matching features will be returned." ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "cache" ), tr( "set this to true to build a local spatial index (most of the time, this is unwanted, unless you are working with a particularly slow data provider)" ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "overlay_within('regions')" ), tr( "TRUE if the current feature is spatially within a region" ), QString() )
            << HelpExample( tr( "overlay_within('regions', filter:= population > 10000)" ), tr( "TRUE if the current feature is spatially within a region with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_within('regions', name)" ), tr( "an array of names, for the regions containing the current feature" ), QString() )
            << HelpExample( tr( "array_to_string(overlay_within('regions', name))" ), tr( "a string as a comma separated list of names, for the regions containing the current feature" ), QString() )
            << HelpExample( tr( "array_sort(overlay_within(layer:='regions', expression:=\"name\", filter:= population > 10000))" ), tr( "an ordered array of names, for the regions containing the current feature and with a population greater than 10000" ), QString() )
            << HelpExample( tr( "overlay_within(layer:='regions', expression:= geom_to_wkt(@geometry), limit:=2)" ), tr( "an array of geometries (in WKT), for up to two regions containing the current feature" ), QString() ),
          QString(),
          QStringList()
            << tr( "predicate,current,contain,target,array,geos,underlying,features" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "parameter" ),
    Help( QStringLiteral( "parameter" ), tr( "function" ), tr( "Returns the value of a processing algorithm input parameter." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "parameter" ), tr( "Returns the value of a processing algorithm input parameter." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "name of the corresponding input parameter" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "parameter('BUFFER_SIZE')" ), tr( "5.6" ), QString() ),
          QString(),
          QStringList()
            << tr( "algorithm,parameter,processing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "perimeter" ),
    Help( QStringLiteral( "perimeter" ), tr( "function" ), tr( "Returns the perimeter of a geometry polygon object. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned perimeter will match the units for the SRS. This differs from the calculations performed by the $perimeter function, which will perform ellipsoidal calculations based on the project's ellipsoid and distance unit settings." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "perimeter" ), tr( "Returns the perimeter of a geometry polygon object. Calculations are always planimetric in the Spatial Reference System (SRS) of this geometry, and the units of the returned perimeter will match the units for the SRS. This differs from the calculations performed by the $perimeter function, which will perform ellipsoidal calculations based on the project's ellipsoid and distance unit settings." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "polygon geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "perimeter(geom_from_wkt('POLYGON((0 0, 4 0, 4 2, 0 2, 0 0))'))" ), tr( "12.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "planimetric,distance,polygon,perimeter,spatial,reference,system,calculations,project,differs,object,match,settings,ellipsoid,units" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "pi" ),
    Help( QStringLiteral( "pi" ), tr( "function" ), tr( "Returns value of pi for calculations." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "pi" ), tr( "Returns value of pi for calculations." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "pi()" ), tr( "3.14159265358979" ), QString() ),
          QString(),
          QStringList()
            << tr( "calculations,pi" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "point_n" ),
    Help( QStringLiteral( "point_n" ), tr( "function" ), tr( "Returns a specific node from a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "point_n" ), tr( "Returns a specific node from a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "index" ), tr( "index of node to return, where 1 is the first node; if the value is negative, the selected vertex index will be its total count minus the absolute value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(point_n(geom_from_wkt('POLYGON((0 0, 4 0, 4 2, 0 2, 0 0))'),2))" ), tr( "'Point (4 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "specific,node,vertex" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "point_on_surface" ),
    Help( QStringLiteral( "point_on_surface" ), tr( "function" ), tr( "Returns a point guaranteed to lie on the surface of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "point_on_surface" ), tr( "Returns a point guaranteed to lie on the surface of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "point_on_surface(@geometry)" ), tr( "a point geometry" ), QString() ),
          QString(),
          QStringList()
            << tr( "point,surface,lie,centroid,overlay,within" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "pole_of_inaccessibility" ),
    Help( QStringLiteral( "pole_of_inaccessibility" ), tr( "function" ), tr( "Calculates the approximate pole of inaccessibility for a surface, which is the most distant internal point from the boundary of the surface. This function uses the 'polylabel' algorithm (Vladimir Agafonkin, 2016), which is an iterative approach guaranteed to find the true pole of inaccessibility within a specified tolerance. More precise tolerances require more iterations and will take longer to calculate." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "pole_of_inaccessibility" ), tr( "Calculates the approximate pole of inaccessibility for a surface, which is the most distant internal point from the boundary of the surface. This function uses the 'polylabel' algorithm (Vladimir Agafonkin, 2016), which is an iterative approach guaranteed to find the true pole of inaccessibility within a specified tolerance. More precise tolerances require more iterations and will take longer to calculate." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "tolerance" ), tr( "maximum distance between the returned point and the true pole location" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(pole_of_inaccessibility( geom_from_wkt('POLYGON((0 1, 0 9, 3 10, 3 3, 10 3, 10 1, 0 1))'), 0.1))" ), tr( "'Point(1.546875 2.546875)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "inaccessibility,precise,tolerances,boundary,iterations,internal,approximate,approach,polylabel,distant,pole" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "project" ),
    Help( QStringLiteral( "project" ), tr( "function" ), tr( "Returns a point projected from a start point using a distance, a bearing (azimuth) and an elevation in radians." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "project" ), tr( "Returns a point projected from a start point using a distance, a bearing (azimuth) and an elevation in radians." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "point" ), tr( "start point" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "distance to project" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "azimuth" ), tr( "azimuth in radians clockwise, where 0 corresponds to north" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "elevation" ), tr( "angle of inclination in radians" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(project(make_point(1, 2), 3, radians(270)))" ), tr( "'Point(-2, 2)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,elevation,projected,start,point,azimuth,radians,bearing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "project_color" ),
    Help( QStringLiteral( "project_color" ), tr( "function" ), tr( "Returns a color from the project's color scheme." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "project_color" ), tr( "Returns a color from the project's color scheme." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "a color name" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "project_color('Logo color')" ), tr( "'20,140,50'" ), QString() ),
          QString(),
          QStringList()
            << tr( "scheme,project,color" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "project_color_object" ),
    Help( QStringLiteral( "project_color_object" ), tr( "function" ), tr( "Returns a color from the project's color scheme. Contrary to project_color which returns a color string representation, project_color_object returns a color object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "project_color_object" ), tr( "Returns a color from the project's color scheme. Contrary to project_color which returns a color string representation, project_color_object returns a color object." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "a color name" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "project_color_object('Logo color')" ), tr( "RGBA: 0.08,0.55,0.20,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "scheme,project,color" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "q1" ),
    Help( QStringLiteral( "q1" ), tr( "function" ), tr( "Returns the calculated first quartile from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "q1" ), tr( "Returns the calculated first quartile from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "q1(\"population\",group_by:=\"state\")" ), tr( "first quartile of population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "field,quartile,first,calculated" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "q3" ),
    Help( QStringLiteral( "q3" ), tr( "function" ), tr( "Returns the calculated third quartile from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "q3" ), tr( "Returns the calculated third quartile from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "q3(\"population\",group_by:=\"state\")" ), tr( "third quartile of population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "third,field,quartile,calculated" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "radians" ),
    Help( QStringLiteral( "radians" ), tr( "function" ), tr( "Converts from degrees to radians." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "radians" ), tr( "Converts from degrees to radians." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "degrees" ), tr( "numeric value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "radians(180)" ), tr( "3.14159" ), QString() )
            << HelpExample( tr( "radians(57.2958)" ), tr( "1" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,degrees,radians" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ramp_color" ),
    Help( QStringLiteral( "ramp_color" ), tr( "function" ), tr( "Returns a string representing a color from a color ramp." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Saved ramp variant" ), tr( "Returns a string representing a color from a saved ramp" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "ramp_name" ), tr( "the name of the color ramp as a string, for example 'Spectral'" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the position on the ramp to select the color from as a real number between 0 and 1" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ramp_color('Spectral',0.3)" ), tr( "'253,190,115,255'" ), QString() ),
          tr( "The color ramps available vary between QGIS installations. This function may not give the expected results if you move your QGIS project between installations." ),
          QStringList()
       )
        << HelpVariant( tr( "Expression-created ramp variant" ), tr( "Returns a string representing a color from an expression-created ramp" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "ramp" ), tr( "the color ramp" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the position on the ramp to select the color from as a real number between 0 and 1" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ramp_color(create_ramp(map(0,'0,0,0',1,'255,0,0')),1)" ), tr( "'255,0,0,255'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "ramp_color_object" ),
    Help( QStringLiteral( "ramp_color_object" ), tr( "function" ), tr( "Returns a color object from a color ramp. Contrary to ramp_color which returns a color string representation, ramp_color_object returns a color object." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Saved ramp variant" ), tr( "Returns a color object from a saved ramp" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "ramp_name" ), tr( "the name of the color ramp as a string, for example 'Spectral'" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the position on the ramp to select the color from as a real number between 0 and 1" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ramp_color_object('Spectral',0.3)" ), tr( "RGBA: 0.99,0.75,0.45,1.00" ), QString() ),
          tr( "The color ramps available vary between QGIS installations. This function may not give the expected results if you move your QGIS project between installations." ),
          QStringList()
       )
        << HelpVariant( tr( "Expression-created ramp variant" ), tr( "Returns a color object from an expression-created ramp" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "ramp" ), tr( "the color ramp" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the position on the ramp to select the color from as a real number between 0 and 1" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "ramp_color_object(create_ramp(map(0,color_rgbf(0,0,0),1,color_rgbf(1,0,0))),1)" ), tr( "RGBA: 1.00,0.00,0.00,1.00" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "rand" ),
    Help( QStringLiteral( "rand" ), tr( "function" ), tr( "Returns a random integer within the range specified by the minimum and maximum argument (inclusive). If a seed is provided, the returned will always be the same, depending on the seed." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "rand" ), tr( "Returns a random integer within the range specified by the minimum and maximum argument (inclusive). If a seed is provided, the returned will always be the same, depending on the seed." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "min" ), tr( "an integer representing the smallest possible random number desired" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max" ), tr( "an integer representing the largest possible random number desired" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "seed" ), tr( "any value to use as seed" ), false, false, true, QStringLiteral( "NULL" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "rand(1, 10)" ), tr( "8" ), QString() ),
          QString(),
          QStringList()
            << tr( "random,inclusive,specified,range,argument,seed,same,provided,minimum,maximum,integer,depending" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "randf" ),
    Help( QStringLiteral( "randf" ), tr( "function" ), tr( "Returns a random float within the range specified by the minimum and maximum argument (inclusive). If a seed is provided, the returned will always be the same, depending on the seed." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "randf" ), tr( "Returns a random float within the range specified by the minimum and maximum argument (inclusive). If a seed is provided, the returned will always be the same, depending on the seed." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "min" ), tr( "an float representing the smallest possible random number desired" ), false, false, true, QStringLiteral( "0.0" ) )
              << HelpArg( QStringLiteral( "max" ), tr( "an float representing the largest possible random number desired" ), false, false, true, QStringLiteral( "1.0" ) )
              << HelpArg( QStringLiteral( "seed" ), tr( "any value to use as seed" ), false, false, true, QStringLiteral( "NULL" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "randf(1, 10)" ), tr( "4.59258286403147" ), QString() ),
          QString(),
          QStringList()
            << tr( "random,specified,range,argument,seed,same,provided,float,minimum,maximum,inclusive,depending" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "range" ),
    Help( QStringLiteral( "range" ), tr( "function" ), tr( "Returns the aggregate range of values (maximum - minimum) from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "range" ), tr( "Returns the aggregate range of values (maximum - minimum) from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "range(\"population\",group_by:=\"state\")" ), tr( "range of population values, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "field,range,aggregate,minimum,maximum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "raster_attributes" ),
    Help( QStringLiteral( "raster_attributes" ), tr( "function" ), tr( "Returns a map with the fields names as keys and the raster attribute table values as values from the attribute table entry that matches the given raster value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "raster_attributes" ), tr( "Returns a map with the fields names as keys and the raster attribute table values as values from the attribute table entry that matches the given raster value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the name or id of a raster layer" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "band" ), tr( "the band number for the associated attribute table lookup." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "raster value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "raster_attributes('vegetation', 1, raster_value('vegetation', 1, make_point(1,1)))" ), tr( "{'class': 'Vegetated', 'subclass': 'Trees'}" ), QString() )
            << HelpExample( tr( "raster_attributes('vegetation', 1, raster_value('vegetation', 1, @layer_cursor_point))" ), tr( "{'class': 'Vegetated', 'subclass': 'Trees'}" ), QString() ),
          QString(),
          QStringList()
            << tr( "provider,point,raster,found,attributes" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "raster_statistic" ),
    Help( QStringLiteral( "raster_statistic" ), tr( "function" ), tr( "Returns statistics from a raster layer." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "raster_statistic" ), tr( "Returns statistics from a raster layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "a string, representing either a raster layer name or layer ID" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "band" ), tr( "integer representing the band number from the raster layer, starting at 1" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "property" ), tr( "a string corresponding to the property to return. Valid options are:<br /><ul><li>min: minimum value</li><li>max: maximum value</li><li>avg: average (mean) value</li><li>stdev: standard deviation of values</li><li>range: range of values (max - min)</li><li>sum: sum of all values from raster</li></ul>" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "raster_statistic('lc',1,'avg')" ), tr( "Average value from band 1 from 'lc' raster layer" ), QString() )
            << HelpExample( tr( "raster_statistic('ac2010',3,'min')" ), tr( "Minimum value from band 3 from 'ac2010' raster layer" ), QString() ),
          QString(),
          QStringList()
            << tr( "raster,statistics" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "raster_value" ),
    Help( QStringLiteral( "raster_value" ), tr( "function" ), tr( "Returns the raster value found at the provided point." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "raster_value" ), tr( "Returns the raster value found at the provided point." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "the name or id of a raster layer" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "band" ), tr( "the band number to sample the value from." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "point" ), tr( "point geometry (for multipart geometries having more than one part, a NULL value will be returned)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "raster_value('dem', 1, make_point(1,1))" ), tr( "25" ), QString() )
            << HelpExample( tr( "raster_value('ndvi', 2, @layer_cursor_point)" ), tr( "25" ), QString() ),
          QString(),
          QStringList()
            << tr( "provided,point,raster,found" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "regexp_match" ),
    Help( QStringLiteral( "regexp_match" ), tr( "function" ), tr( "Return the first matching position matching a regular expression within an unicode string, or 0 if the substring is not found." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "regexp_match" ), tr( "Return the first matching position matching a regular expression within an unicode string, or 0 if the substring is not found." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "input_string" ), tr( "the string to test against the regular expression" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "regex" ), tr( "The regular expression to test against. Backslash characters must be double escaped (e.g., \"\\\\s\" to match a white space character or  \"\\\\b\" to match a word boundary)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "regexp_match('QGIS ROCKS','\\\\sROCKS')" ), tr( "5" ), QString() )
            << HelpExample( tr( "regexp_match('Budač','udač\\\\b')" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "return,found,matching,unicode,regular,position,substring,first" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "regexp_matches" ),
    Help( QStringLiteral( "regexp_matches" ), tr( "function" ), tr( "Returns an array of all strings captured by capturing groups, in the order the groups themselves appear in the supplied regular expression against a string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "regexp_matches" ), tr( "Returns an array of all strings captured by capturing groups, in the order the groups themselves appear in the supplied regular expression against a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to capture groups from against the regular expression" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "regex" ), tr( "the regular expression used to capture groups" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "empty_value" ), tr( "the optional string to use as replacement for empty (zero length) matches" ), false, false, true, QStringLiteral( "''" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "regexp_matches('QGIS=>rocks','(.*)=>(.*)')" ), tr( "[ 'QGIS', 'rocks' ]" ), QString() )
            << HelpExample( tr( "regexp_matches('key=>','(.*)=>(.*)','empty value')" ), tr( "[ 'key', 'empty value' ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "array,groups,capturing,captured,order,appear,supplied,regular,strings" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "regexp_replace" ),
    Help( QStringLiteral( "regexp_replace" ), tr( "function" ), tr( "Returns a string with the supplied regular expression replaced." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "regexp_replace" ), tr( "Returns a string with the supplied regular expression replaced." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "input_string" ), tr( "the string to replace matches in" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "regex" ), tr( "The regular expression to replace. Backslash characters must be double escaped (e.g., \"\\\\s\" to match a white space character)." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "replacement" ), tr( "The string that will replace any matching occurrences of the supplied regular expression. Captured groups can be inserted into the replacement string using \\\\1, \\\\2, etc." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "regexp_replace('QGIS SHOULD ROCK','\\\\sSHOULD\\\\s',' DOES ')" ), tr( "'QGIS DOES ROCK'" ), QString() )
            << HelpExample( tr( "regexp_replace('ABC123','\\\\d+','')" ), tr( "'ABC'" ), QString() )
            << HelpExample( tr( "regexp_replace('my name is John','(.*) is (.*)','\\\\2 is \\\\1')" ), tr( "'John is my name'" ), QString() ),
          QString(),
          QStringList()
            << tr( "regular,supplied,replaced" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "regexp_substr" ),
    Help( QStringLiteral( "regexp_substr" ), tr( "function" ), tr( "Returns the portion of a string which matches a supplied regular expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "regexp_substr" ), tr( "Returns the portion of a string which matches a supplied regular expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "input_string" ), tr( "the string to find matches in" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "regex" ), tr( "The regular expression to match against. Backslash characters must be double escaped (e.g., \"\\\\s\" to match a white space character)." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "regexp_substr('abc123','(\\\\d+)')" ), tr( "'123'" ), QString() ),
          QString(),
          QStringList()
            << tr( "regular,matches,supplied,portion" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "relate" ),
    Help( QStringLiteral( "relate" ), tr( "function" ), tr( "Tests the Dimensional Extended 9 Intersection Model (DE-9IM) representation of the relationship between two geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Relationship variant" ), tr( "Returns the Dimensional Extended 9 Intersection Model (DE-9IM) representation of the relationship between two geometries." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "relate( geom_from_wkt( 'LINESTRING(40 40,120 120)' ), geom_from_wkt( 'LINESTRING(40 40,60 120)' ) )" ), tr( "'FF1F00102'" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Pattern match variant" ), tr( "Tests whether the DE-9IM relationship between two geometries matches a specified pattern." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "pattern" ), tr( "DE-9IM pattern to match" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "relate( geom_from_wkt( 'LINESTRING(40 40,120 120)' ), geom_from_wkt( 'LINESTRING(40 40,60 120)' ), '**1F001**' )" ), tr( "TRUE" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "relation_aggregate" ),
    Help( QStringLiteral( "relation_aggregate" ), tr( "function" ), tr( "Returns an aggregate value calculated using all matching child features from a layer relation." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "relation_aggregate" ), tr( "Returns an aggregate value calculated using all matching child features from a layer relation." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "relation" ), tr( "a string, representing a relation ID" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "aggregate" ), tr( "a string corresponding to the aggregate to calculate. Valid options are:<br /><ul><li>count</li><li>count_distinct</li><li>count_missing</li><li>minimum or min</li><li>maximum or max</li><li>sum</li><li>mean</li><li>median</li><li>stdev</li><li>stdevsample</li><li>range</li><li>minority</li><li>majority</li><li>q1: first quartile</li><li>q3: third quartile</li><li>iqr: inter quartile range</li><li>min_length: minimum string length</li><li>max_length: maximum string length</li><li>concatenate: join strings with a concatenator</li><li>concatenate_unique: join unique strings with a concatenator</li><li>collect: create an aggregated multipart geometry</li><li>array_agg: create an array of aggregated values</li></ul>" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression or field name to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "concatenator" ), tr( "optional string to use to join values for 'concatenate' aggregate" ), false, false, true, QStringLiteral( "''" ) )
              << HelpArg( QStringLiteral( "order_by" ), tr( "optional expression to order the features used for calculating the aggregate. Fields and geometry are from the features on the joined layer. By default, the features will be returned in an unspecified order." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "relation_aggregate(relation:='my_relation',aggregate:='mean',expression:=\"passengers\")" ), tr( "mean value of all matching child features using the 'my_relation' relation" ), QString() )
            << HelpExample( tr( "relation_aggregate('my_relation','sum', \"passengers\"/7)" ), tr( "sum of the passengers field divided by 7 for all matching child features using the 'my_relation' relation" ), QString() )
            << HelpExample( tr( "relation_aggregate('my_relation','concatenate', \"towns\", concatenator:=',')" ), tr( "comma separated list of the towns field for all matching child features using the 'my_relation' relation" ), QString() )
            << HelpExample( tr( "relation_aggregate('my_relation','array_agg', \"id\")" ), tr( "array of the id field from all matching child features using the 'my_relation' relation" ), QString() ),
          QString(),
          QStringList()
            << tr( "child,matching,aggregate,features,relation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "repeat" ),
    Help( QStringLiteral( "repeat" ), tr( "function" ), tr( "Repeats a string a specified number of times." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "repeat" ), tr( "Repeats a string a specified number of times." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to repeat" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "number" ), tr( "number of times to repeat string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "repeat('Hello', 3)" ), tr( "'HelloHelloHello'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "replace" ),
    Help( QStringLiteral( "replace" ), tr( "function" ), tr( "Returns a string with the supplied string, array, or map of strings replaced." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "String & array variant" ), tr( "Returns a string with the supplied string or array of strings replaced by a string or an array of strings." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the input string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "before" ), tr( "the string or array of strings to replace" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "after" ), tr( "the string or array of strings to use as a replacement" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "replace('QGIS SHOULD ROCK','SHOULD','DOES')" ), tr( "'QGIS DOES ROCK'" ), QString() )
            << HelpExample( tr( "replace('QGIS ABC',array('A','B','C'),array('X','Y','Z'))" ), tr( "'QGIS XYZ'" ), QString() )
            << HelpExample( tr( "replace('QGIS',array('Q','S'),'')" ), tr( "'GI'" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Map variant" ), tr( "Returns a string with the supplied map keys replaced by paired values. Longer map keys are evaluated first." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the input string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "map" ), tr( "the map containing keys and values" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "replace('APP SHOULD ROCK',map('APP','QGIS','SHOULD','DOES'))" ), tr( "'QGIS DOES ROCK'" ), QString() )
            << HelpExample( tr( "replace('forty two',map('for','4','two','2','forty two','42'))" ), tr( "'42'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "represent_attributes" ),
    Help( QStringLiteral( "represent_attributes" ), tr( "function" ), tr( "Returns a map with the attribute names as keys and the configured representation values as values. The representation value for the attributes depends on the configured widget type for each attribute.  Can be used with zero, one or more arguments, see below for details." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "No parameters" ), tr( "If called with no parameters, the function will return the representation of the attributes of the current feature in the current layer." ),
          QList<HelpArg>(),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "represent_attributes()" ), tr( "The representation of the attributes for the current feature." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "One 'feature' parameter" ), tr( "If called with a 'feature' parameter only, the function will return the representation of the attributes of the specified feature from the current layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be evaluated." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "represent_attributes(@atlas_feature)" ), tr( "The representation of the attributes for the specified feature from the current layer." ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Layer and feature parameters" ), tr( "If called with a 'layer' and a 'feature' parameter, the function will return the representation of the attributes of the specified feature from the specified layer." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "layer" ), tr( "The layer (or its ID or name)." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "feature" ), tr( "The feature which should be evaluated." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "represent_attributes('atlas_layer', @atlas_feature)" ), tr( "The representation of the attributes for the specified feature from the specified layer." ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "represent_value" ),
    Help( QStringLiteral( "represent_value" ), tr( "function" ), tr( "Returns the configured representation value for a field value. It depends on the configured widget type. Often, this is useful for 'Value Map' widgets." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "represent_value" ), tr( "Returns the configured representation value for a field value. It depends on the configured widget type. Often, this is useful for 'Value Map' widgets." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "The value which should be resolved. Most likely a field." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "fieldName" ), tr( "The field name for which the widget configuration should be loaded." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "represent_value(\"field_with_value_map\")" ), tr( "Description for value" ), QString() )
            << HelpExample( tr( "represent_value('static value', 'field_name')" ), tr( "Description for static value" ), QString() ),
          QString(),
          QStringList()
            << tr( "depends,configured,field,type,widgets,map,representation,widget" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "reverse" ),
    Help( QStringLiteral( "reverse" ), tr( "function" ), tr( "Reverses the direction of a line string or reverses a string of text." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "String variant" ), tr( "Reverses the order of characters in a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to reverse" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "reverse('hello')" ), tr( "'olleh'" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Geometry variant" ), tr( "Reverses the direction of a line string by reversing the order of its vertices." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(reverse(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2)')))" ), tr( "'LINESTRING(2 2, 1 1, 0 0)'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "right" ),
    Help( QStringLiteral( "right" ), tr( "function" ), tr( "Returns a substring that contains the <i>n</i> rightmost characters of the string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "right" ), tr( "Returns a substring that contains the <i>n</i> rightmost characters of the string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "a string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "length" ), tr( "integer. The number of characters from the right of the string to return." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "right('Hello World',5)" ), tr( "'World'" ), QString() ),
          QString(),
          QStringList()
            << tr( "last,end,substring,rightmost,characters,contains" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "rotate" ),
    Help( QStringLiteral( "rotate" ), tr( "function" ), tr( "Returns a rotated version of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "rotate" ), tr( "Returns a rotated version of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "rotation" ), tr( "clockwise rotation in degrees" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "center" ), tr( "rotation center point. If not specified, the center of the geometry's bounding box is used." ), false, false, true, QStringLiteral( "NULL" ) )
              << HelpArg( QStringLiteral( "per_part" ), tr( "apply rotation per part. If true, then rotation will apply around the center of each part's bounding box when the input geometry is multipart and an explicit rotation center point is not specified." ), false, false, true, QStringLiteral( "false" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "rotate(@geometry, 45, make_point(4, 5))" ), tr( "geometry rotated 45 degrees clockwise around the (4, 5) point" ), QString() )
            << HelpExample( tr( "rotate(@geometry, 45)" ), tr( "geometry rotated 45 degrees clockwise around the center of its bounding box" ), QString() ),
          QString(),
          QStringList()
            << tr( "version,spatial,reference,calculations,rotated,system" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "round" ),
    Help( QStringLiteral( "round" ), tr( "function" ), tr( "Rounds a number to number of decimal places." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "round" ), tr( "Rounds a number to number of decimal places." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "decimal number to be rounded" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "places" ), tr( "Optional integer representing number of places to round decimals to. Can be negative." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "round(1234.567, 2)" ), tr( "1234.57" ), QString() )
            << HelpExample( tr( "round(1234.567)" ), tr( "1235" ), QString() )
            << HelpExample( tr( "round(1234.567, -1)" ), tr( "1230" ), QString() ),
          QString(),
          QStringList()
            << tr( "rounds,places,decimal,number" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "roundness" ),
    Help( QStringLiteral( "roundness" ), tr( "function" ), tr( "Calculates how close a polygon shape is to a circle. The function returns 1 when the polygon shape is a perfect circle and 0 when it is completely flat." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "roundness" ), tr( "Calculates how close a polygon shape is to a circle. The function returns 1 when the polygon shape is a perfect circle and 0 when it is completely flat." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a polygon" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "round(roundness(geom_from_wkt('POLYGON(( 0 0, 0 1, 1 1, 1 0, 0 0))')), 3)" ), tr( "0.785" ), QString() )
            << HelpExample( tr( "round(roundness(geom_from_wkt('POLYGON(( 0 0, 0 0.1, 1 0.1, 1 0, 0 0))')), 3)" ), tr( "0.260" ), QString() ),
          QString(),
          QStringList()
            << tr( "polygon,perfect,flat,close,shape,calculates,circle" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "rpad" ),
    Help( QStringLiteral( "rpad" ), tr( "function" ), tr( "Returns a string padded on the right to the specified width, using a fill character. If the target width is smaller than the string's length, the string is truncated." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "rpad" ), tr( "Returns a string padded on the right to the specified width, using a fill character. If the target width is smaller than the string's length, the string is truncated." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to pad" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "width" ), tr( "length of new string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "fill" ), tr( "character to pad the remaining space with" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "rpad('Hello', 10, 'x')" ), tr( "'Helloxxxxx'" ), QString() )
            << HelpExample( tr( "rpad('Hello', 3, 'x')" ), tr( "'Hel'" ), QString() ),
          QString(),
          QStringList()
            << tr( "length,right,padded,width,specified,truncated,target,fill,character,smaller" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "rtrim" ),
    Help( QStringLiteral( "rtrim" ), tr( "function" ), tr( "Removes the longest string containing only the specified characters (a space by default) from the end of string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "rtrim" ), tr( "Removes the longest string containing only the specified characters (a space by default) from the end of string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to trim" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "characters" ), tr( "characters to trim" ), false, false, true, QStringLiteral( "' '" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "rtrim('   hello world  ')" ), tr( "'   hello world'" ), QString() )
            << HelpExample( tr( "rtrim('testxxzx', 'xyz')" ), tr( "'test'" ), QString() ),
          QString(),
          QStringList()
            << tr( "removes,whitespace,spaces,tabs,trailing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "scale" ),
    Help( QStringLiteral( "scale" ), tr( "function" ), tr( "Returns a scaled version of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "scale" ), tr( "Returns a scaled version of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "x_scale" ), tr( "x-axis scaling factor" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "y_scale" ), tr( "y-axis scaling factor" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "center" ), tr( "scaling center point. If not specified, the center of the geometry's bounding box is used." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "scale(@geometry, 2, 0.5, make_point(4, 5))" ), tr( "geometry scaled twice horizontally and halved vertically, around the (4, 5) point" ), QString() )
            << HelpExample( tr( "scale(@geometry, 2, 0.5)" ), tr( "geometry twice horizontally and halved vertically, around the center of its bounding box" ), QString() ),
          QString(),
          QStringList()
            << tr( "scaled,spatial,affine,calculations,resize" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "scale_exponential" ),
    Help( QStringLiteral( "scale_exponential" ), tr( "function" ), tr( "Transforms a given value from an input domain to an output range using an exponential curve. This function can be used to ease values in or out of the specified output range." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "scale_exponential" ), tr( "Transforms a given value from an input domain to an output range using an exponential curve. This function can be used to ease values in or out of the specified output range." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "A value in the input domain. The function will return a corresponding scaled value in the output range." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "domain_min" ), tr( "Specifies the minimum value in the input domain, the smallest value the input value should take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "domain_max" ), tr( "Specifies the maximum value in the input domain, the largest value the input value should take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "range_min" ), tr( "Specifies the minimum value in the output range, the smallest value which should be output by the function." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "range_max" ), tr( "Specifies the maximum value in the output range, the largest value which should be output by the function." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "exponent" ), tr( "A positive value (greater than 0), which dictates the way input values are mapped to the output range. Large exponents will cause the output values to 'ease in', starting slowly before accelerating as the input values approach the domain maximum. Smaller exponents (less than 1) will cause output values to 'ease out', where the mapping starts quickly but slows as it approaches the domain maximum." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "scale_exponential(5,0,10,0,100,2)" ), tr( "3.030" ), tr( "easing in, using an exponent of 2" ) )
            << HelpExample( tr( "scale_exponential(3,0,10,0,100,0.5)" ), tr( "87.585" ), tr( "easing out, using an exponent of 0.5" ) ),
          QString(),
          QStringList()
            << tr( "exponential,curve,ease,transforms,output,given,input,domain,range,specified,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "scale_linear" ),
    Help( QStringLiteral( "scale_linear" ), tr( "function" ), tr( "Transforms a given value from an input domain to an output range using linear interpolation." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "scale_linear" ), tr( "Transforms a given value from an input domain to an output range using linear interpolation." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "A value in the input domain. The function will return a corresponding scaled value in the output range." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "domain_min" ), tr( "Specifies the minimum value in the input domain, the smallest value the input value should take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "domain_max" ), tr( "Specifies the maximum value in the input domain, the largest value the input value should take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "range_min" ), tr( "Specifies the minimum value in the output range, the smallest value which should be output by the function." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "range_max" ), tr( "Specifies the maximum value in the output range, the largest value which should be output by the function." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "scale_linear(5,0,10,0,100)" ), tr( "50" ), QString() )
            << HelpExample( tr( "scale_linear(0.2,0,1,0,360)" ), tr( "72" ), tr( "scaling a value between 0 and 1 to an angle between 0 and 360" ) )
            << HelpExample( tr( "scale_linear(1500,1000,10000,9,20)" ), tr( "9.6111111" ), tr( "scaling a population which varies between 1000 and 10000 to a font size between 9 and 20" ) ),
          QString(),
          QStringList()
            << tr( "transforms,linear,output,given,input,domain,range,interpolation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "scale_polynomial" ),
    Help( QStringLiteral( "scale_polynomial" ), tr( "function" ), tr( "Transforms a given value from an input domain to an output range using a polynomial curve. This function can be used to ease values in or out of the specified output range." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "scale_polynomial" ), tr( "Transforms a given value from an input domain to an output range using a polynomial curve. This function can be used to ease values in or out of the specified output range." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "A value in the input domain. The function will return a corresponding scaled value in the output range." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "domain_min" ), tr( "Specifies the minimum value in the input domain, the smallest value the input value should take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "domain_max" ), tr( "Specifies the maximum value in the input domain, the largest value the input value should take." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "range_min" ), tr( "Specifies the minimum value in the output range, the smallest value which should be output by the function." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "range_max" ), tr( "Specifies the maximum value in the output range, the largest value which should be output by the function." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "exponent" ), tr( "A positive value (greater than 0), which dictates the way input values are mapped to the output range. Large exponents will cause the output values to 'ease in', starting slowly before accelerating as the input values approach the domain maximum. Smaller exponents (less than 1) will cause output values to 'ease out', where the mapping starts quickly but slows as it approaches the domain maximum." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "scale_polynomial(5,0,10,0,100,2)" ), tr( "25" ), tr( "easing in, using an exponent of 2" ) )
            << HelpExample( tr( "scale_polynomial(3,0,10,0,100,0.5)" ), tr( "54.772" ), tr( "easing out, using an exponent of 0.5" ) ),
          QString(),
          QStringList()
            << tr( "polynomial,curve,ease,transforms,output,given,input,domain,range,specified,values" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "second" ),
    Help( QStringLiteral( "second" ), tr( "function" ), tr( "Extracts the seconds part from a datetime or time, or the number of seconds from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Time variant" ), tr( "Extracts the seconds part from a time or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "datetime" ), tr( "a time or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "second( to_datetime('2012-07-22 13:24:57') )" ), tr( "57" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in seconds of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of seconds from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "second(to_interval('3 minutes'))" ), tr( "180" ), QString() )
            << HelpExample( tr( "second(age('2012-07-22T00:20:00','2012-07-22T00:00:00'))" ), tr( "1200" ), QString() )
            << HelpExample( tr( "second(age('2012-01-01','2010-01-01'))" ), tr( "63072000" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "segments_to_lines" ),
    Help( QStringLiteral( "segments_to_lines" ), tr( "function" ), tr( "Returns a multi line geometry consisting of a line for every segment in the input geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "segments_to_lines" ), tr( "Returns a multi line geometry consisting of a line for every segment in the input geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(segments_to_lines(geom_from_wkt('LINESTRING(0 0, 1 1, 2 2)')))" ), tr( "'MultiLineString ((0 0, 1 1),(1 1, 2 2))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "consisting,segment,input,multi,line" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sensor_data" ),
    Help( QStringLiteral( "sensor_data" ), tr( "function" ), tr( "Returns the last captured value (or values as a map for sensors which report multiple values) from a registered sensor." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sensor_data" ), tr( "Returns the last captured value (or values as a map for sensors which report multiple values) from a registered sensor." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "the sensor name" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expiration" ), tr( "maximum millisecond since last captured value allowed" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "sensor_data('geiger_1')" ), tr( "'2000'" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "set_color_part" ),
    Help( QStringLiteral( "set_color_part" ), tr( "function" ), tr( "Sets a specific color component for a color string or a color object, e.g., the red component or alpha component." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "set_color_part" ), tr( "Sets a specific color component for a color string or a color object, e.g., the red component or alpha component." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "color" ), tr( "a color string or a color object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "component" ), tr( "a string corresponding to the color component to set. Valid options are:<br /><ul><li>red: RGB red component (0-255)</li><li>green: RGB green component (0-255)</li><li>blue: RGB blue component (0-255)</li><li>alpha: alpha (transparency) value (0-255)</li><li>hue: HSV hue (0-360)</li><li>saturation: HSV saturation (0-100)</li><li>value: HSV value (0-100)</li><li>hsl_hue: HSL hue (0-360)</li><li>hsl_saturation: HSL saturation (0-100)</li><li>lightness: HSL lightness (0-100)</li><li>cyan: CMYK cyan component (0-100)</li><li>magenta: CMYK magenta component (0-100)</li><li>yellow: CMYK yellow component (0-100)</li><li>black: CMYK black component (0-100)</li></ul>" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "new value for color component, respecting the ranges listed above" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "set_color_part('200,10,30','green',50)" ), tr( "'200,50,30,255'" ), QString() )
            << HelpExample( tr( "set_color_part(color_cmykf(0.21,0,0.92,0.70),'black',100)" ), tr( "CMYKA: 0.21,0.00,0.92,1.00,1.00" ), QString() ),
          QString(),
          QStringList()
            << tr( "alpha,component,specific,red,color,sets" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sha256" ),
    Help( QStringLiteral( "sha256" ), tr( "function" ), tr( "Creates a sha256 hash from a string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sha256" ), tr( "Creates a sha256 hash from a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to hash" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "sha256('QGIS')" ), tr( "'eb045cba7a797aaa06ac58830846e40c8e8c780bc0676d3393605fae50c05309'" ), QString() ),
          QString(),
          QStringList()
            << tr( "hash" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "shared_paths" ),
    Help( QStringLiteral( "shared_paths" ), tr( "function" ), tr( "Returns a collection containing paths shared by the two input geometries. Those going in the same direction are in the first element of the collection, those going in the opposite direction are in the second element. The paths themselves are given in the direction of the first geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "shared_paths" ), tr( "Returns a collection containing paths shared by the two input geometries. Those going in the same direction are in the first element of the collection, those going in the opposite direction are in the second element. The paths themselves are given in the direction of the first geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a LineString/MultiLineString geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a LineString/MultiLineString geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(shared_paths(geom_from_wkt('MULTILINESTRING((26 125,26 200,126 200,126 125,26 125),(51 150,101 150,76 175,51 150)))'),geom_from_wkt('LINESTRING(151 100,126 156.25,126 125,90 161, 76 175)')))" ), tr( "'GeometryCollection (MultiLineString ((126 156.25, 126 125),(101 150, 90 161),(90 161, 76 175)),MultiLineString EMPTY)'" ), QString() )
            << HelpExample( tr( "geom_to_wkt(shared_paths(geom_from_wkt('LINESTRING(76 175,90 161,126 125,126 156.25,151 100)'),geom_from_wkt('MULTILINESTRING((26 125,26 200,126 200,126 125,26 125),(51 150,101 150,76 175,51 150))')))" ), tr( "'GeometryCollection (MultiLineString EMPTY,MultiLineString ((76 175, 90 161),(90 161, 101 150),(126 125, 126 156.25)))'" ), QString() ),
          QString(),
          QStringList()
            << tr( "linestrings,paths,overlapping,shared,linestring,multilinestring" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "shortest_line" ),
    Help( QStringLiteral( "shortest_line" ), tr( "function" ), tr( "Returns the shortest line joining geometry1 to geometry2. The resultant line will start at geometry1 and end at geometry2." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "shortest_line" ), tr( "Returns the shortest line joining geometry1 to geometry2. The resultant line will start at geometry1 and end at geometry2." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "geometry to find shortest line from" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "geometry to find shortest line to" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(shortest_line(geom_from_wkt('LINESTRING (20 80, 98 190, 110 180, 50 75 )'),geom_from_wkt('POINT(100 100)')))" ), tr( "'LineString(73.0769 115.384, 100 100)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "start,resultant,joining,end,shortest,line" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "simplify" ),
    Help( QStringLiteral( "simplify" ), tr( "function" ), tr( "Simplifies a geometry by removing nodes using a distance based threshold (ie, the Douglas Peucker algorithm). The algorithm preserves large deviations in geometries and reduces the number of vertices in nearly straight segments." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "simplify" ), tr( "Simplifies a geometry by removing nodes using a distance based threshold (ie, the Douglas Peucker algorithm). The algorithm preserves large deviations in geometries and reduces the number of vertices in nearly straight segments." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "tolerance" ), tr( "maximum deviation from straight segments for points to be removed" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(simplify(geometry:=geom_from_wkt('LineString(0 0, 5 0.1, 10 0)'),tolerance:=5))" ), tr( "'LineString(0 0, 10 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "straight,large,deviations,nodes,algorithm,reduces,simplifies,segments,number,threshold,distance,removing,vertices,based,preserves" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "simplify_vw" ),
    Help( QStringLiteral( "simplify_vw" ), tr( "function" ), tr( "Simplifies a geometry by removing nodes using an area based threshold (ie, the Visvalingam-Whyatt algorithm). The algorithm removes vertices which create small areas in geometries, e.g., narrow spikes or nearly straight segments." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "simplify_vw" ), tr( "Simplifies a geometry by removing nodes using an area based threshold (ie, the Visvalingam-Whyatt algorithm). The algorithm removes vertices which create small areas in geometries, e.g., narrow spikes or nearly straight segments." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "tolerance" ), tr( "a measure of the maximum area created by a node for the node to be removed" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(simplify_vw(geometry:=geom_from_wkt('LineString(0 0, 5 0, 5.01 10, 5.02 0, 10 0)'),tolerance:=5))" ), tr( "'LineString(0 0, 10 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "spikes,areas,straight,nodes,algorithm,area,simplifies,removes,narrow,segments,visvalingam,threshold,create,vertices,removing,based,small" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sin" ),
    Help( QStringLiteral( "sin" ), tr( "function" ), tr( "Returns the sine of an angle." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sin" ), tr( "Returns the sine of an angle." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "angle" ), tr( "angle in radians" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "sin(1.571)" ), tr( "0.999999682931835" ), QString() ),
          QString(),
          QStringList()
            << tr( "sine,angle" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "single_sided_buffer" ),
    Help( QStringLiteral( "single_sided_buffer" ), tr( "function" ), tr( "Returns a geometry formed by buffering out just one side of a linestring geometry. Distances are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "single_sided_buffer" ), tr( "Returns a geometry formed by buffering out just one side of a linestring geometry. Distances are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a (multi)linestring geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "distance" ), tr( "buffer distance. Positive values will be buffered to the left of lines, negative values to the right" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "number of segments to use to represent a quarter circle when a round join style is used. A larger number results in a smoother buffer with more nodes." ), false, false, true, QStringLiteral( "8" ) )
              << HelpArg( QStringLiteral( "join" ), tr( "join style for corners, where 1 = round, 2 = miter and 3 = bevel" ), false, false, true, QStringLiteral( "1" ) )
              << HelpArg( QStringLiteral( "miter_limit" ), tr( "limit on the miter ratio used for very sharp corners (when using miter joins only)" ), false, false, true, QStringLiteral( "2.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "single_sided_buffer(@geometry, 10.5)" ), tr( "line buffered to the left by 10.5 units" ), QString() )
            << HelpExample( tr( "single_sided_buffer(@geometry, -10.5)" ), tr( "line buffered to the right by 10.5 units" ), QString() )
            << HelpExample( tr( "single_sided_buffer(@geometry, 10.5, segments:=16, join:=1)" ), tr( "line buffered to the left by 10.5 units, using more segments to result in a smoother buffer" ), QString() )
            << HelpExample( tr( "single_sided_buffer(@geometry, 10.5, join:=3)" ), tr( "line buffered to the left by 10.5 units, using a beveled join" ), QString() ),
          QString(),
          QStringList()
            << tr( "buffering,spatial,reference,system,linestring,formed,distances,side" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sinuosity" ),
    Help( QStringLiteral( "sinuosity" ), tr( "function" ), tr( "Returns the sinuosity of a curve, which is the ratio of the curve length to the straight (2D) distance between its endpoints." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sinuosity" ), tr( "Returns the sinuosity of a curve, which is the ratio of the curve length to the straight (2D) distance between its endpoints." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "Input curve (circularstring, linestring)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "round(sinuosity(geom_from_wkt('LINESTRING(2 0, 2 2, 3 2, 3 3)')), 3)" ), tr( "1.265" ), QString() )
            << HelpExample( tr( "sinuosity(geom_from_wkt('LINESTRING( 3 1, 5 1)'))" ), tr( "1.0" ), QString() ),
          QString(),
          QStringList()
            << tr( "curve,distance,length,endpoints,sinuosity,ratio,straight" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "smooth" ),
    Help( QStringLiteral( "smooth" ), tr( "function" ), tr( "Smooths a geometry by adding extra nodes which round off corners in the geometry. If input geometries contain Z or M values, these will also be smoothed and the output geometry will retain the same dimensionality as the input geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "smooth" ), tr( "Smooths a geometry by adding extra nodes which round off corners in the geometry. If input geometries contain Z or M values, these will also be smoothed and the output geometry will retain the same dimensionality as the input geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "iterations" ), tr( "number of smoothing iterations to apply. Larger numbers result in smoother but more complex geometries." ), false, false, true, QStringLiteral( "1" ) )
              << HelpArg( QStringLiteral( "offset" ), tr( "value between 0 and 0.5 which controls how tightly the smoothed geometry follow the original geometry. Smaller values result in a tighter smoothing, larger values result in looser smoothing." ), false, false, true, QStringLiteral( "0.25" ) )
              << HelpArg( QStringLiteral( "min_length" ), tr( "minimum length of segments to apply smoothing to. This parameter can be used to avoid placing excessive additional nodes in shorter segments of the geometry." ), false, false, true, QStringLiteral( "-1" ) )
              << HelpArg( QStringLiteral( "max_angle" ), tr( "maximum angle at node for smoothing to be applied (0-180). By lowering the maximum angle intentionally sharp corners in the geometry can be preserved. For instance, a value of 80 degrees will retain right angles in the geometry." ), false, false, true, QStringLiteral( "180" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(smooth(geometry:=geom_from_wkt('LineString(0 0, 5 0, 5 5)'),iterations:=1,offset:=0.2,min_length:=-1,max_angle:=180))" ), tr( "'LineString (0 0, 4 0, 5 1, 5 5)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "adding,corners,smoothed,dimensionality,round,output,contain,input,retain,extra,smooths,nodes,values,same" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "soundex" ),
    Help( QStringLiteral( "soundex" ), tr( "function" ), tr( "Returns the Soundex representation of a string. Soundex is a phonetic matching algorithm, so strings with similar sounds should be represented by the same Soundex code." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "soundex" ), tr( "Returns the Soundex representation of a string. Soundex is a phonetic matching algorithm, so strings with similar sounds should be represented by the same Soundex code." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "a string" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "soundex('robert')" ), tr( "'R163'" ), QString() )
            << HelpExample( tr( "soundex('rupert')" ), tr( "'R163'" ), QString() )
            << HelpExample( tr( "soundex('rubin')" ), tr( "'R150'" ), QString() ),
          QString(),
          QStringList()
            << tr( "code,represented,similar,matching,algorithm,soundex,same,phonetic,representation,strings,sounds" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sqlite_fetch_and_increment" ),
    Help( QStringLiteral( "sqlite_fetch_and_increment" ), tr( "function" ), tr( "Manage autoincrementing values in sqlite databases.<p>SQlite default values can only be applied on insert and not prefetched.</p><p>This makes it impossible to acquire an incremented primary key via AUTO_INCREMENT before creating the row in the database. Sidenote: with postgres, this works via the option <i>evaluate default values</i>.</p><p>When adding new features with relations, it is really nice to be able to already add children for a parent, while the parents form is still open and hence the parent feature uncommitted.</p><p>To get around this limitation, this function can be used to manage sequence values in a separate table on sqlite based formats like gpkg.</p><p>The sequence table will be filtered for a sequence id (filter_attribute and filter_value) and the current value of the id_field will be incremented by 1 and the incremented value returned.</p><p>If additional columns require values to be specified, the default_values map can be used for this purpose.</p><p><b>Note</b><br/>This function modifies the target sqlite table. It is intended for usage with default value configurations for attributes.</p><p>When the database parameter is a layer and the layer is in transaction mode, the value will only be retrieved once during the lifetime of a transaction and cached and incremented. This makes it unsafe to work on the same database from several processes in parallel.</p>" ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sqlite_fetch_and_increment" ), tr( "Manage autoincrementing values in sqlite databases.<p>SQlite default values can only be applied on insert and not prefetched.</p><p>This makes it impossible to acquire an incremented primary key via AUTO_INCREMENT before creating the row in the database. Sidenote: with postgres, this works via the option <i>evaluate default values</i>.</p><p>When adding new features with relations, it is really nice to be able to already add children for a parent, while the parents form is still open and hence the parent feature uncommitted.</p><p>To get around this limitation, this function can be used to manage sequence values in a separate table on sqlite based formats like gpkg.</p><p>The sequence table will be filtered for a sequence id (filter_attribute and filter_value) and the current value of the id_field will be incremented by 1 and the incremented value returned.</p><p>If additional columns require values to be specified, the default_values map can be used for this purpose.</p><p><b>Note</b><br/>This function modifies the target sqlite table. It is intended for usage with default value configurations for attributes.</p><p>When the database parameter is a layer and the layer is in transaction mode, the value will only be retrieved once during the lifetime of a transaction and cached and incremented. This makes it unsafe to work on the same database from several processes in parallel.</p>" ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "database" ), tr( "Path to the sqlite file or geopackage layer" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "table" ), tr( "Name of the table that manages the sequences" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "id_field" ), tr( "Name of the field that contains the current value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "filter_attribute" ), tr( "Name the field that contains a unique identifier for this sequence. Must have a UNIQUE index." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "filter_value" ), tr( "Name of the sequence to use." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "default_values" ), tr( "Map with default values for additional columns on the table. The values need to be fully quoted. Functions are allowed." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "sqlite_fetch_and_increment(@layer, 'sequence_table', 'last_unique_id', 'sequence_id', 'global', map('last_change', 'date(''now'')', 'user', '''' || @user_account_name || ''''))" ), tr( "0" ), QString() )
            << HelpExample( tr( "sqlite_fetch_and_increment(layer_property(@layer, 'path'), 'sequence_table', 'last_unique_id', 'sequence_id', 'global', map('last_change', 'date(''now'')', 'user', '''' || @user_account_name || ''''))" ), tr( "0" ), QString() ),
          QString(),
          QStringList()
            << tr( "attributes,children,applied,uncommitted,works,relations,prefetched,intended,creating,several,auto_increment,form,databases,transaction,parents,filter_value,mode,open,primary,evaluate,sidenote,add,require,impossible,default_values,table,insert,nice,formats,current,adding,get,target,work,specified,usage,columns,retrieved,autoincrementing,new,limitation,gpkg,parallel,database,additional,makes,postgres,modifies,sequence,cached,manage,key,same,id_field,acquire,filtered,default,filter_attribute,parent,option,unsafe,sqlite,separate,parameter,map,row,configurations,lifetime,processes,incremented,able,features,purpose" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sqrt" ),
    Help( QStringLiteral( "sqrt" ), tr( "function" ), tr( "Returns square root of a value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sqrt" ), tr( "Returns square root of a value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "a number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "sqrt(9)" ), tr( "3" ), QString() ),
          QString(),
          QStringList()
            << tr( "root,square" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "square_wave" ),
    Help( QStringLiteral( "square_wave" ), tr( "function" ), tr( "Constructs square/rectangular waves along the boundary of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "square_wave" ), tr( "Constructs square/rectangular waves along the boundary of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "wavelength" ), tr( "wavelength of square waveform" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "amplitude" ), tr( "amplitude of square waveform" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "strict" ), tr( "By default the wavelength argument is treated as a \"maximum wavelength\", where the actual wavelength will be dynamically adjusted so that an exact number of square waves are created along the boundaries of the geometry. If the strict argument is set to true then the wavelength will be used exactly and an incomplete pattern may be used for the final waveform." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "square_wave(geom_from_wkt('LineString(0 0, 10 0)'), 3, 1)" ), tr( "Square waves with wavelength 3 and amplitude 1 along the linestring" ), QString() ),
          QString(),
          QStringList()
            << tr( "waves,rectangular,constructs,square,boundary" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "square_wave_randomized" ),
    Help( QStringLiteral( "square_wave_randomized" ), tr( "function" ), tr( "Constructs randomized square/rectangular waves along the boundary of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "square_wave_randomized" ), tr( "Constructs randomized square/rectangular waves along the boundary of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "min_wavelength" ), tr( "minimum wavelength of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max_wavelength" ), tr( "maximum wavelength of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "min_amplitude" ), tr( "minimum amplitude of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max_amplitude" ), tr( "maximum amplitude of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "seed" ), tr( "specifies a random seed for generating waves. If the seed is 0, then a completely random set of waves will be generated." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "square_wave_randomized(geom_from_wkt('LineString(0 0, 10 0)'), 2, 3, 0.1, 0.2)" ), tr( "Randomly sized square waves with wavelengths between 2 and 3 and amplitudes between 0.1 and 0.2 along the linestring" ), QString() ),
          QString(),
          QStringList()
            << tr( "waves,rectangular,constructs,square,boundary,randomized" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "start_point" ),
    Help( QStringLiteral( "start_point" ), tr( "function" ), tr( "Returns the first node from a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "start_point" ), tr( "Returns the first node from a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt(start_point(geom_from_wkt('LINESTRING(4 0, 4 2, 0 2)')))" ), tr( "'Point (4 0)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "first,node" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "stdev" ),
    Help( QStringLiteral( "stdev" ), tr( "function" ), tr( "Returns the aggregate standard deviation value from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "stdev" ), tr( "Returns the aggregate standard deviation value from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "stdev(\"population\",group_by:=\"state\")" ), tr( "standard deviation of population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "deviation,field,standard,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "straight_distance_2d" ),
    Help( QStringLiteral( "straight_distance_2d" ), tr( "function" ), tr( "Returns the direct/euclidean distance between the first and last vertex of a geometry. The geometry must be a curve (circularstring, linestring)." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "straight_distance_2d" ), tr( "Returns the direct/euclidean distance between the first and last vertex of a geometry. The geometry must be a curve (circularstring, linestring)." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "The geometry." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "straight_distance_2d(geom_from_wkt('LINESTRING(1 0, 1 1)'))" ), tr( "1" ), QString() )
            << HelpExample( tr( "round(straight_distance_2d(geom_from_wkt('LINESTRING(1 4, 3 5, 5 0)')), 3)" ), tr( "5.657" ), QString() ),
          QString(),
          QStringList()
            << tr( "distance,curve,circularstring,first,last,direct,euclidean,linestring,vertex" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "string_to_array" ),
    Help( QStringLiteral( "string_to_array" ), tr( "function" ), tr( "Splits string into an array using supplied delimiter and optional string for empty values." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "string_to_array" ), tr( "Splits string into an array using supplied delimiter and optional string for empty values." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the input string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "delimiter" ), tr( "the string delimiter used to split the input string" ), false, false, true, QStringLiteral( "','" ) )
              << HelpArg( QStringLiteral( "empty_value" ), tr( "the optional string to use as replacement for empty (zero length) matches" ), false, false, true, QStringLiteral( "''" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "string_to_array('1,2,3',',')" ), tr( "[ '1', '2', '3' ]" ), QString() )
            << HelpExample( tr( "string_to_array('1,,3',',','0')" ), tr( "[ '1', '0', '3' ]" ), QString() ),
          QString(),
          QStringList()
            << tr( "split,convert,separate,delimiter,divides" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "strpos" ),
    Help( QStringLiteral( "strpos" ), tr( "function" ), tr( "Return the first matching position of a substring within another string, or 0 if the substring is not found." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "strpos" ), tr( "Return the first matching position of a substring within another string, or 0 if the substring is not found." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "haystack" ), tr( "string that is to be searched" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "needle" ), tr( "string to search for" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "strpos('HELLO WORLD','WORLD')" ), tr( "7" ), QString() )
            << HelpExample( tr( "strpos('HELLO WORLD','GOODBYE')" ), tr( "0" ), QString() ),
          QString(),
          QStringList()
            << tr( "substring,position,return,found,first,matching" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "substr" ),
    Help( QStringLiteral( "substr" ), tr( "function" ), tr( "Returns a part of a string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "substr" ), tr( "Returns a part of a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the full input string" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "start" ), tr( "integer representing start position to extract beginning with 1; if start is negative, the return string will begin at the end of the string minus the start value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "length" ), tr( "integer representing length of string to extract; if length is negative, the return string will omit the given length of characters from the end of the string" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "substr('HELLO WORLD',3,5)" ), tr( "'LLO W'" ), QString() )
            << HelpExample( tr( "substr('HELLO WORLD',6)" ), tr( "' WORLD'" ), QString() )
            << HelpExample( tr( "substr('HELLO WORLD',-5)" ), tr( "'WORLD'" ), QString() )
            << HelpExample( tr( "substr('HELLO',3,-1)" ), tr( "'LL'" ), QString() )
            << HelpExample( tr( "substr('HELLO WORLD',-5,2)" ), tr( "'WO'" ), QString() )
            << HelpExample( tr( "substr('HELLO WORLD',-5,-1)" ), tr( "'WORL'" ), QString() ),
          QString(),
          QStringList()
            << tr( "part" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sum" ),
    Help( QStringLiteral( "sum" ), tr( "function" ), tr( "Returns the aggregate summed value from a field or expression." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sum" ), tr( "Returns the aggregate summed value from a field or expression." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "sub expression of field to aggregate" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "group_by" ), tr( "optional expression to use to group aggregate calculations" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "filter" ), tr( "optional expression to use to filter features used to calculate aggregate" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "sum(\"population\",group_by:=\"state\")" ), tr( "summed population value, grouped by state field" ), QString() ),
          QString(),
          QStringList()
            << tr( "field,summed,aggregate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "sym_difference" ),
    Help( QStringLiteral( "sym_difference" ), tr( "function" ), tr( "Returns a geometry that represents the portions of two geometries that do not intersect." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "sym_difference" ), tr( "Returns a geometry that represents the portions of two geometries that do not intersect." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( sym_difference( geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ), geom_from_wkt( 'LINESTRING(3 3, 8 8)' ) ) )" ), tr( "'LINESTRING(5 5, 8 8)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "portions,represents,intersect" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "tan" ),
    Help( QStringLiteral( "tan" ), tr( "function" ), tr( "Returns the tangent of an angle." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "tan" ), tr( "Returns the tangent of an angle." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "angle" ), tr( "angle in radians" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "tan(1.0)" ), tr( "1.5574077246549" ), QString() ),
          QString(),
          QStringList()
            << tr( "angle,tangent" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "tapered_buffer" ),
    Help( QStringLiteral( "tapered_buffer" ), tr( "function" ), tr( "Creates a buffer along a line geometry where the buffer diameter varies evenly over the length of the line." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "tapered_buffer" ), tr( "Creates a buffer along a line geometry where the buffer diameter varies evenly over the length of the line." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "input geometry. Must be a (multi)line geometry." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "start_width" ), tr( "width of buffer at start of line," ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "end_width" ), tr( "width of buffer at end of line." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "segments" ), tr( "number of segments to approximate quarter-circle curves in the buffer." ), false, false, true, QStringLiteral( "8" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "tapered_buffer(geometry:=geom_from_wkt('LINESTRING(1 2, 4 2)'),start_width:=1,end_width:=2,segments:=8)" ), tr( "A tapered buffer starting with a diameter of 1 and ending with a diameter of 2 along the linestring geometry." ), QString() ),
          QString(),
          QStringList()
            << tr( "varies,buffer,line,diameter,length" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "title" ),
    Help( QStringLiteral( "title" ), tr( "function" ), tr( "Converts all words of a string to title case (all words lower case with leading capital letter)." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "title" ), tr( "Converts all words of a string to title case (all words lower case with leading capital letter)." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to convert to title case" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "title('hello WOrld')" ), tr( "'Hello World'" ), QString() ),
          QString(),
          QStringList()
            << tr( "letter,words,lower,converts,leading,capital,title,case" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_base64" ),
    Help( QStringLiteral( "to_base64" ), tr( "function" ), tr( "Encodes a binary value into a string, using the Base64 encoding." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_base64" ), tr( "Encodes a binary value into a string, using the Base64 encoding." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "the binary value to encode" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_base64('QGIS')" ), tr( "'UUdJUw=='" ), QString() ),
          QString(),
          QStringList()
            << tr( "encoding,base,binary,encodes" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_bool" ),
    Help( QStringLiteral( "to_bool" ), tr( "function" ), tr( "Converts a given value to a boolean. The function will return false if the value is NULL, an empty string, an empty list, or 0." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_bool" ), tr( "Converts a given value to a boolean. The function will return false if the value is NULL, an empty string, an empty list, or 0." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "value to convert to boolean" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_bool('')" ), tr( "false" ), QString() )
            << HelpExample( tr( "to_bool('123')" ), tr( "true" ), QString() )
            << HelpExample( tr( "to_bool('false')" ), tr( "true" ), QString() )
            << HelpExample( tr( "to_bool(0)" ), tr( "false" ), QString() )
            << HelpExample( tr( "to_bool(1)" ), tr( "true" ), QString() )
            << HelpExample( tr( "to_bool(null)" ), tr( "false" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,boolean" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_date" ),
    Help( QStringLiteral( "to_date" ), tr( "function" ), tr( "Converts a string into a date object. An optional format string can be provided to parse the string; see <a href='https://doc.qt.io/qt-5/qdate.html#fromString-2'>QDate::fromString</a> or the documentation of the format_date function for additional documentation on the format. By default the current QGIS user locale is used." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_date" ), tr( "Converts a string into a date object. An optional format string can be provided to parse the string; see <a href='https://doc.qt.io/qt-5/qdate.html#fromString-2'>QDate::fromString</a> or the documentation of the format_date function for additional documentation on the format. By default the current QGIS user locale is used." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string representing a date value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "format" ), tr( "format used to convert the string into a date" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "language" ), tr( "language (lowercase, two- or three-letter, ISO 639 language code) used to convert the string into a date. By default the current QGIS user locale is used." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_date('2012-05-04')" ), tr( "2012-05-04" ), QString() )
            << HelpExample( tr( "to_date('June 29, 2019','MMMM d, yyyy')" ), tr( "2019-06-29, if the current locale uses the name 'June' for the sixth month, otherwise an error occurs" ), QString() )
            << HelpExample( tr( "to_date('29 juin, 2019','d MMMM, yyyy','fr')" ), tr( "2019-06-29" ), QString() ),
          QString(),
          QStringList()
            << tr( "provided,additional,user,format_date,parse,qdate,converts,default,current,format,object,fromstring,date,optional,documentation,see" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_datetime" ),
    Help( QStringLiteral( "to_datetime" ), tr( "function" ), tr( "Converts a string into a datetime object. An optional format string can be provided to parse the string; see <a href='https://doc.qt.io/qt-5/qdate.html#fromString-2'>QDate::fromString</a>, <a href='https://doc.qt.io/qt-5/qtime.html#fromString-1'>QTime::fromString</a> or the documentation of the format_date function for additional documentation on the format. By default the current QGIS user locale is used." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_datetime" ), tr( "Converts a string into a datetime object. An optional format string can be provided to parse the string; see <a href='https://doc.qt.io/qt-5/qdate.html#fromString-2'>QDate::fromString</a>, <a href='https://doc.qt.io/qt-5/qtime.html#fromString-1'>QTime::fromString</a> or the documentation of the format_date function for additional documentation on the format. By default the current QGIS user locale is used." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string representing a datetime value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "format" ), tr( "format used to convert the string into a datetime" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "language" ), tr( "language (lowercase, two- or three-letter, ISO 639 language code) used to convert the string into a datetime. By default the current QGIS user locale is used." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_datetime('2012-05-04 12:50:00')" ), tr( "2012-05-04T12:50:00" ), QString() )
            << HelpExample( tr( "to_datetime('June 29, 2019 @ 12:34','MMMM d, yyyy @ HH:mm')" ), tr( "2019-06-29T12:34, if the current locale uses the name 'June' for the sixth month, otherwise an error occurs" ), QString() )
            << HelpExample( tr( "to_datetime('29 juin, 2019 @ 12:34','d MMMM, yyyy @ HH:mm','fr')" ), tr( "2019-06-29T12:34" ), QString() ),
          QString(),
          QStringList()
            << tr( "provided,additional,user,format_date,parse,qdate,converts,default,datetime,current,format,object,fromstring,optional,documentation,qtime,see" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_decimal" ),
    Help( QStringLiteral( "to_decimal" ), tr( "function" ), tr( "Converts a degree, minute, second coordinate to its decimal equivalent." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_decimal" ), tr( "Converts a degree, minute, second coordinate to its decimal equivalent." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "A degree, minute, second string." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_decimal('6°21\\'16.445')" ), tr( "6.3545680555" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,minute,degree,equivalent,second,coordinate,decimal" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_dm" ),
    Help( QStringLiteral( "to_dm" ), tr( "function" ), tr( "Converts a coordinate to degree, minute." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_dm" ), tr( "Converts a coordinate to degree, minute." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "coordinate" ), tr( "A latitude or longitude value." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "axis" ), tr( "The axis of the coordinate. Either 'x' or 'y'." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "precision" ), tr( "Number of decimals." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "formatting" ), tr( "Designates the formatting type. Acceptable values are NULL (default), 'aligned' or 'suffix'." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_dm(6.1545681, 'x', 3)" ), tr( "6°9.274′" ), QString() )
            << HelpExample( tr( "to_dm(6.1545681, 'y', 4, 'aligned')" ), tr( "6°09.2741′N" ), QString() )
            << HelpExample( tr( "to_dm(6.1545681, 'y', 4, 'suffix')" ), tr( "6°9.2741′N" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,minute,degree,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_dms" ),
    Help( QStringLiteral( "to_dms" ), tr( "function" ), tr( "Converts a coordinate to degree, minute, second." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_dms" ), tr( "Converts a coordinate to degree, minute, second." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "coordinate" ), tr( "A latitude or longitude value." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "axis" ), tr( "The axis of the coordinate. Either 'x' or 'y'." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "precision" ), tr( "Number of decimals." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "formatting" ), tr( "Designates the formatting type. Acceptable values are NULL (default), 'aligned' or 'suffix'." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_dms(6.1545681, 'x', 3)" ), tr( "6°9′16.445″" ), QString() )
            << HelpExample( tr( "to_dms(6.1545681, 'y', 4, 'aligned')" ), tr( "6°09′16.4452″N" ), QString() )
            << HelpExample( tr( "to_dms(6.1545681, 'y', 4, 'suffix')" ), tr( "6°9′16.4452″N" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,minute,degree,second,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_int" ),
    Help( QStringLiteral( "to_int" ), tr( "function" ), tr( "Converts a string to integer number. If a value cannot be converted to integer the expression is invalid (e.g '123asd' is invalid)." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_int" ), tr( "Converts a string to integer number. If a value cannot be converted to integer the expression is invalid (e.g '123asd' is invalid)." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to convert to integer number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_int('123')" ), tr( "123" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,invalid,converted,integer" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_interval" ),
    Help( QStringLiteral( "to_interval" ), tr( "function" ), tr( "Converts a string to an interval type. Can be used to take days, hours, month, etc of a date." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_interval" ), tr( "Converts a string to an interval type. Can be used to take days, hours, month, etc of a date." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "a string representing an interval. Allowable formats include {n} days {n} hours {n} months." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_interval('1 day 2 hours')" ), tr( "interval: 1.08333 days" ), QString() )
            << HelpExample( tr( "to_interval( '0.5 hours' )" ), tr( "interval: 30 minutes" ), QString() )
            << HelpExample( tr( "to_datetime('2012-05-05 12:00:00') - to_interval('1 day 2 hours')" ), tr( "2012-05-04T10:00:00" ), QString() ),
          QString(),
          QStringList()
            << tr( "type,month,converts,date,interval,take,hours,days" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_json" ),
    Help( QStringLiteral( "to_json" ), tr( "function" ), tr( "Create a JSON formatted string from a map, array or other value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_json" ), tr( "Create a JSON formatted string from a map, array or other value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "value" ), tr( "The input value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_json(map('1','one','2','two'))" ), tr( "{\"1\":\"one\",\"2\":\"two\"}" ), QString() )
            << HelpExample( tr( "to_json(array(1,2,3))" ), tr( "[1,2,3]" ), QString() ),
          QString(),
          QStringList()
            << tr( "formatted,json,array,create,other,map" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_real" ),
    Help( QStringLiteral( "to_real" ), tr( "function" ), tr( "Converts a string to a real number. If a value cannot be converted to real the expression is invalid (e.g '123.56asd' is invalid).  Numbers are rounded after saving changes if the precision is smaller than the result of the conversion." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_real" ), tr( "Converts a string to a real number. If a value cannot be converted to real the expression is invalid (e.g '123.56asd' is invalid).  Numbers are rounded after saving changes if the precision is smaller than the result of the conversion." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to convert to real number" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_real('123.45')" ), tr( "123.45" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,precision,invalid,rounded,numbers,changes,real,result,converted,saving,conversion,smaller" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_string" ),
    Help( QStringLiteral( "to_string" ), tr( "function" ), tr( "Converts a number to string. The conversion is not locale-aware, see 'format_number' for a locale-aware alternative." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_string" ), tr( "Converts a number to string. The conversion is not locale-aware, see 'format_number' for a locale-aware alternative." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "number" ), tr( "Integer or real value. The number to convert to string." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_string(1.23)" ), tr( "'1.23'" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,number" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "to_time" ),
    Help( QStringLiteral( "to_time" ), tr( "function" ), tr( "Converts a string into a time object. An optional format string can be provided to parse the string; see <a href='https://doc.qt.io/qt-5/qtime.html#fromString-1'>QTime::fromString</a> for additional documentation on the format." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "to_time" ), tr( "Converts a string into a time object. An optional format string can be provided to parse the string; see <a href='https://doc.qt.io/qt-5/qtime.html#fromString-1'>QTime::fromString</a> for additional documentation on the format." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string representing a time value" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "format" ), tr( "format used to convert the string into a time" ), false, false, true, QString() )
              << HelpArg( QStringLiteral( "language" ), tr( "language (lowercase, two- or three-letter, ISO 639 language code) used to convert the string into a time" ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "to_time('12:30:01')" ), tr( "12:30:01" ), QString() )
            << HelpExample( tr( "to_time('12:34','HH:mm')" ), tr( "12:34:00" ), QString() )
            << HelpExample( tr( "to_time('12:34','HH:mm','fr')" ), tr( "12:34:00" ), QString() ),
          QString(),
          QStringList()
            << tr( "provided,additional,format,object,parse,time,converts,fromstring,optional,documentation,qtime,see" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "touches" ),
    Help( QStringLiteral( "touches" ), tr( "function" ), tr( "Tests whether a geometry touches another. Returns TRUE if the geometries have at least one point in common, but their interiors do not intersect." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "touches" ), tr( "Tests whether a geometry touches another. Returns TRUE if the geometries have at least one point in common, but their interiors do not intersect." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "touches( geom_from_wkt( 'LINESTRING(5 3, 4 4)' ), geom_from_wkt( 'LINESTRING(3 3, 4 4, 5 5)' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "touches( geom_from_wkt( 'POINT(4 4)' ), geom_from_wkt( 'POINT(5 5)' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "point,common,touches,interiors,tests,intersect" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "transform" ),
    Help( QStringLiteral( "transform" ), tr( "function" ), tr( "Returns the geometry transformed from a source CRS to a destination CRS." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "transform" ), tr( "Returns the geometry transformed from a source CRS to a destination CRS." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "source_auth_id" ), tr( "the source CRS definition or CRS object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "dest_auth_id" ), tr( "the destination CRS definition or CRS object" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( transform( make_point(488995.53240249, 7104473.38600835), 'EPSG:2154', 'EPSG:4326' ) )" ), tr( "'POINT(0 51)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "crs,source,transformed,destination,reprojection" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "translate" ),
    Help( QStringLiteral( "translate" ), tr( "function" ), tr( "Returns a translated version of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "translate" ), tr( "Returns a translated version of a geometry. Calculations are in the Spatial Reference System of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "dx" ), tr( "delta x" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "dy" ), tr( "delta y" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "translate(@geometry, 5, 10)" ), tr( "a geometry of the same type like the original one" ), QString() ),
          QString(),
          QStringList()
            << tr( "spatial,reference,calculations,system,translated,displace,move" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "triangular_wave" ),
    Help( QStringLiteral( "triangular_wave" ), tr( "function" ), tr( "Constructs triangular waves along the boundary of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "triangular_wave" ), tr( "Constructs triangular waves along the boundary of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "wavelength" ), tr( "wavelength of triangular waveform" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "amplitude" ), tr( "amplitude of triangular waveform" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "strict" ), tr( "By default the wavelength argument is treated as a \"maximum wavelength\", where the actual wavelength will be dynamically adjusted so that an exact number of triangular waves are created along the boundaries of the geometry. If the strict argument is set to true then the wavelength will be used exactly and an incomplete pattern may be used for the final waveform." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "triangular_wave(geom_from_wkt('LineString(0 0, 10 0)'), 3, 1)" ), tr( "Triangular waves with wavelength 3 and amplitude 1 along the linestring" ), QString() ),
          QString(),
          QStringList()
            << tr( "waves,boundary,constructs,triangular" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "triangular_wave_randomized" ),
    Help( QStringLiteral( "triangular_wave_randomized" ), tr( "function" ), tr( "Constructs randomized triangular waves along the boundary of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "triangular_wave_randomized" ), tr( "Constructs randomized triangular waves along the boundary of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "min_wavelength" ), tr( "minimum wavelength of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max_wavelength" ), tr( "maximum wavelength of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "min_amplitude" ), tr( "minimum amplitude of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max_amplitude" ), tr( "maximum amplitude of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "seed" ), tr( "specifies a random seed for generating waves. If the seed is 0, then a completely random set of waves will be generated." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "triangular_wave_randomized(geom_from_wkt('LineString(0 0, 10 0)'), 2, 3, 0.1, 0.2)" ), tr( "Randomly sized triangular waves with wavelengths between 2 and 3 and amplitudes between 0.1 and 0.2 along the linestring" ), QString() ),
          QString(),
          QStringList()
            << tr( "waves,boundary,constructs,randomized,triangular" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "trim" ),
    Help( QStringLiteral( "trim" ), tr( "function" ), tr( "Removes all leading and trailing whitespace (spaces, tabs, etc) from a string." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "trim" ), tr( "Removes all leading and trailing whitespace (spaces, tabs, etc) from a string." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "string to trim" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "trim('   hello world  ')" ), tr( "'hello world'" ), QString() ),
          QString(),
          QStringList()
            << tr( "removes,leading,whitespace,spaces,tabs,trailing" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "try" ),
    Help( QStringLiteral( "try" ), tr( "function" ), tr( "Tries an expression and returns its value if error-free. If the expression returns an error, an alternative value will be returned when provided otherwise the function will return NULL." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "try" ), tr( "Tries an expression and returns its value if error-free. If the expression returns an error, an alternative value will be returned when provided otherwise the function will return NULL." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "expression" ), tr( "the expression which should be run" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "alternative" ), tr( "the result which will be returned if the expression returns an error." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "try( to_int( '1' ), 0 )" ), tr( "1" ), QString() )
            << HelpExample( tr( "try( to_int( 'a' ), 0 )" ), tr( "0" ), QString() )
            << HelpExample( tr( "try( to_date( 'invalid_date' ) )" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "return,tries,error,alternative,provided,exception" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "union" ),
    Help( QStringLiteral( "union" ), tr( "function" ), tr( "Returns a geometry that represents the point set union of the geometries." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "union" ), tr( "Returns a geometry that represents the point set union of the geometries." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "geom_to_wkt( union( make_point(4, 4), make_point(5, 5) ) )" ), tr( "'MULTIPOINT(4 4, 5 5)'" ), QString() ),
          QString(),
          QStringList()
            << tr( "union,dissolve,point,represents,set" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "upper" ),
    Help( QStringLiteral( "upper" ), tr( "function" ), tr( "Converts a string to upper case letters." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "upper" ), tr( "Converts a string to upper case letters." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to convert to upper case" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "upper('hello WOrld')" ), tr( "'HELLO WORLD'" ), QString() ),
          QString(),
          QStringList()
            << tr( "converts,upper,letters,case" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "url_encode" ),
    Help( QStringLiteral( "url_encode" ), tr( "function" ), tr( "Returns an URL encoded string from a map. Transforms all characters in their properly-encoded form producing a fully-compliant query string.<br>Note that the plus sign '+' is not converted." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "url_encode" ), tr( "Returns an URL encoded string from a map. Transforms all characters in their properly-encoded form producing a fully-compliant query string.<br>Note that the plus sign '+' is not converted." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "map" ), tr( "a map." ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "url_encode(map('a&+b', 'a and plus b', 'a=b', 'a equals b'))" ), tr( "'a%26+b=a%20and%20plus%20b&a%3Db=a%20equals%20b'" ), QString() ),
          QString(),
          QStringList()
            << tr( "encoded,producing,form,characters,query,plus,url,compliant,converted,map,sign,transforms" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "uuid" ),
    Help( QStringLiteral( "uuid" ), tr( "function" ), tr( "Generates a Universally Unique Identifier (UUID) for each row using the Qt <a href='https://doc.qt.io/qt-5/quuid.html#createUuid'>QUuid::createUuid</a> method." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "uuid" ), tr( "Generates a Universally Unique Identifier (UUID) for each row using the Qt <a href='https://doc.qt.io/qt-5/quuid.html#createUuid'>QUuid::createUuid</a> method." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "format" ), tr( "The format, as the UUID will be formatted. 'WithBraces', 'WithoutBraces' or 'Id128'." ), false, false, true, QStringLiteral( "'WithBraces'" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "uuid()" ), tr( "'{0bd2f60f-f157-4a6d-96af-d4ba4cb366a1}'" ), QString() )
            << HelpExample( tr( "uuid('WithoutBraces')" ), tr( "'0bd2f60f-f157-4a6d-96af-d4ba4cb366a1'" ), QString() )
            << HelpExample( tr( "uuid('Id128')" ), tr( "'0bd2f60ff1574a6d96afd4ba4cb366a1'" ), QString() ),
          QString(),
          QStringList()
            << tr( "createuuid,generates,method,unique,quuid,identifier,row" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "var" ),
    Help( QStringLiteral( "var" ), tr( "function" ), tr( "Returns the value stored within a specified variable." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "var" ), tr( "Returns the value stored within a specified variable." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "a variable name" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "var('qgis_version')" ), tr( "'2.12'" ), QString() ),
          QString(),
          QStringList()
            << tr( "stored,variable,specified" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "wave" ),
    Help( QStringLiteral( "wave" ), tr( "function" ), tr( "Constructs rounded (sine-like) waves along the boundary of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "wave" ), tr( "Constructs rounded (sine-like) waves along the boundary of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "wavelength" ), tr( "wavelength of sine-like waveform" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "amplitude" ), tr( "amplitude of sine-like waveform" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "strict" ), tr( "By default the wavelength argument is treated as a \"maximum wavelength\", where the actual wavelength will be dynamically adjusted so that an exact number of waves are created along the boundaries of the geometry. If the strict argument is set to true then the wavelength will be used exactly and an incomplete pattern may be used for the final waveform." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "wave(geom_from_wkt('LineString(0 0, 10 0)'), 3, 1)" ), tr( "Sine-like waves with wavelength 3 and amplitude 1 along the linestring" ), QString() ),
          QString(),
          QStringList()
            << tr( "waves,rounded,sine,boundary,constructs" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "wave_randomized" ),
    Help( QStringLiteral( "wave_randomized" ), tr( "function" ), tr( "Constructs randomized curved (sine-like) waves along the boundary of a geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "wave_randomized" ), tr( "Constructs randomized curved (sine-like) waves along the boundary of a geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "min_wavelength" ), tr( "minimum wavelength of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max_wavelength" ), tr( "maximum wavelength of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "min_amplitude" ), tr( "minimum amplitude of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "max_amplitude" ), tr( "maximum amplitude of waves" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "seed" ), tr( "specifies a random seed for generating waves. If the seed is 0, then a completely random set of waves will be generated." ), false, false, true, QStringLiteral( "0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "wave_randomized(geom_from_wkt('LineString(0 0, 10 0)'), 2, 3, 0.1, 0.2)" ), tr( "Randomly sized curved waves with wavelengths between 2 and 3 and amplitudes between 0.1 and 0.2 along the linestring" ), QString() ),
          QString(),
          QStringList()
            << tr( "waves,sine,boundary,curved,constructs,randomized" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "wedge_buffer" ),
    Help( QStringLiteral( "wedge_buffer" ), tr( "function" ), tr( "Returns a wedge shaped buffer originating from a point geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "wedge_buffer" ), tr( "Returns a wedge shaped buffer originating from a point geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "center" ), tr( "center point (origin) of buffer. Must be a point geometry." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "azimuth" ), tr( "angle (in degrees) for the middle of the wedge to point." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "width" ), tr( "buffer width (in degrees). Note that the wedge will extend to half of the angular width either side of the azimuth direction." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "outer_radius" ), tr( "outer radius for buffers" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "inner_radius" ), tr( "optional inner radius for buffers" ), false, false, true, QStringLiteral( "0.0" ) ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "wedge_buffer(center:=geom_from_wkt('POINT(1 2)'),azimuth:=90,width:=180,outer_radius:=1)" ), tr( "A wedge shaped buffer centered on the point (1,2), facing to the East, with a width of 180 degrees and outer radius of 1." ), QString() ),
          QString(),
          QStringList()
            << tr( "buffer,wedge,point,originating,shaped" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "week" ),
    Help( QStringLiteral( "week" ), tr( "function" ), tr( "Extracts the week number from a date, or the number of weeks from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Date variant" ), tr( "Extracts the week number from a date or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "date" ), tr( "a date or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "week('2012-05-12')" ), tr( "19" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in weeks of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of months from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "week(to_interval('3 weeks'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "week(age('2012-01-01','2010-01-01'))" ), tr( "104.285" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "with_variable" ),
    Help( QStringLiteral( "with_variable" ), tr( "function" ), tr( "This function sets a variable for any expression code that will be provided as 3rd argument. This is only useful for complicated expressions, where the same calculated value needs to be used in different places." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "with_variable" ), tr( "This function sets a variable for any expression code that will be provided as 3rd argument. This is only useful for complicated expressions, where the same calculated value needs to be used in different places." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "name" ), tr( "the name of the variable to set" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "value" ), tr( "the value to set" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "expression" ), tr( "the expression for which the variable will be available" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "with_variable('my_sum', 1 + 2 + 3, @my_sum * 2 + @my_sum * 5)" ), tr( "42" ), QString() ),
          QString(),
          QStringList()
            << tr( "variable,argument,value,evaluation" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "within" ),
    Help( QStringLiteral( "within" ), tr( "function" ), tr( "Tests whether a geometry is within another. Returns TRUE if the geometry1 is completely within geometry2." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "within" ), tr( "Tests whether a geometry is within another. Returns TRUE if the geometry1 is completely within geometry2." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry1" ), tr( "a geometry" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "geometry2" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "within( geom_from_wkt( 'POINT( 0.5 0.5)' ), geom_from_wkt( 'POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))' ) )" ), tr( "TRUE" ), QString() )
            << HelpExample( tr( "within( geom_from_wkt( 'POINT( 5 5 )' ), geom_from_wkt( 'POLYGON((0 0, 0 1, 1 1, 1 0, 0 0 ))' ) )" ), tr( "FALSE" ), QString() ),
          QString(),
          QStringList()
            << tr( "tests,contains,completely" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "wordwrap" ),
    Help( QStringLiteral( "wordwrap" ), tr( "function" ), tr( "Returns a string wrapped to a maximum/minimum number of characters." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "wordwrap" ), tr( "Returns a string wrapped to a maximum/minimum number of characters." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "string" ), tr( "the string to be wrapped" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "wrap_length" ), tr( "an integer. If wrap_length is positive the number represents the ideal maximum number of characters to wrap; if negative, the number represents the minimum number of characters to wrap." ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "delimiter_string" ), tr( "Optional delimiter string to wrap to a new line." ), false, false, true, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "wordwrap('UNIVERSITY OF QGIS',13)" ), tr( "'UNIVERSITY OF<br>QGIS'" ), QString() )
            << HelpExample( tr( "wordwrap('UNIVERSITY OF QGIS',-3)" ), tr( "'UNIVERSITY<br>OF QGIS'" ), QString() ),
          QString(),
          QStringList()
            << tr( "maximum,minimum,wrapped,characters,multiline" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "x" ),
    Help( QStringLiteral( "x" ), tr( "function" ), tr( "Returns the x coordinate of a point geometry, or the x coordinate of the centroid for a non-point geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "x" ), tr( "Returns the x coordinate of a point geometry, or the x coordinate of the centroid for a non-point geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "x( geom_from_wkt( 'POINT(2 5)' ) )" ), tr( "2" ), QString() )
            << HelpExample( tr( "x( @geometry )" ), tr( "x coordinate of the current feature's centroid" ), QString() ),
          QString(),
          QStringList()
            << tr( "centroid,point,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "x_at" ),
    Help( QStringLiteral( "x_at" ), tr( "function" ), tr( "Retrieves a x coordinate of the geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "x_at" ), tr( "Retrieves a x coordinate of the geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertex" ), tr( "index of the vertex of the geometry (indices start at 0; negative values apply from the last index, starting at -1)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "x_at( geom_from_wkt( 'POINT(4 5)' ), 0 )" ), tr( "4" ), QString() ),
          QString(),
          QStringList()
            << tr( "retrieves,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "x_max" ),
    Help( QStringLiteral( "x_max" ), tr( "function" ), tr( "Returns the maximum x coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "x_max" ), tr( "Returns the maximum x coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "x_max( geom_from_wkt( 'LINESTRING(2 5, 3 6, 4 8)') )" ), tr( "4" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,spatial,reference,calculations,system,maximum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "x_min" ),
    Help( QStringLiteral( "x_min" ), tr( "function" ), tr( "Returns the minimum x coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "x_min" ), tr( "Returns the minimum x coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "x_min( geom_from_wkt( 'LINESTRING(2 5, 3 6, 4 8)') )" ), tr( "2" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,spatial,reference,calculations,system,minimum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "y" ),
    Help( QStringLiteral( "y" ), tr( "function" ), tr( "Returns the y coordinate of a point geometry, or the y coordinate of the centroid for a non-point geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "y" ), tr( "Returns the y coordinate of a point geometry, or the y coordinate of the centroid for a non-point geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "y( geom_from_wkt( 'POINT(2 5)' ) )" ), tr( "5" ), QString() )
            << HelpExample( tr( "y( @geometry )" ), tr( "y coordinate of the current feature's centroid" ), QString() ),
          QString(),
          QStringList()
            << tr( "centroid,point,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "y_at" ),
    Help( QStringLiteral( "y_at" ), tr( "function" ), tr( "Retrieves a y coordinate of the geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "y_at" ), tr( "Retrieves a y coordinate of the geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertex" ), tr( "index of the vertex of the geometry (indices start at 0; negative values apply from the last index, starting at -1)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "y_at( geom_from_wkt( 'POINT(4 5)' ), 0 )" ), tr( "5" ), QString() ),
          QString(),
          QStringList()
            << tr( "retrieves,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "y_max" ),
    Help( QStringLiteral( "y_max" ), tr( "function" ), tr( "Returns the maximum y coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "y_max" ), tr( "Returns the maximum y coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "y_max( geom_from_wkt( 'LINESTRING(2 5, 3 6, 4 8)') )" ), tr( "8" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,spatial,reference,calculations,system,maximum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "y_min" ),
    Help( QStringLiteral( "y_min" ), tr( "function" ), tr( "Returns the minimum y coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "y_min" ), tr( "Returns the minimum y coordinate of a geometry. Calculations are in the spatial reference system of this geometry." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "y_min( geom_from_wkt( 'LINESTRING(2 5, 3 6, 4 8)') )" ), tr( "5" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,spatial,reference,calculations,system,minimum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "year" ),
    Help( QStringLiteral( "year" ), tr( "function" ), tr( "Extracts the year part from a date, or the number of years from an interval." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "Date variant" ), tr( "Extracts the year part from a date or datetime." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "date" ), tr( "a date or datetime value" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "year('2012-05-12')" ), tr( "2012" ), QString() ),
          QString(),
          QStringList()
       )
        << HelpVariant( tr( "Interval variant" ), tr( "Calculates the length in years of an interval." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "interval" ), tr( "interval value to return number of years from" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "year(to_interval('3 years'))" ), tr( "3" ), QString() )
            << HelpExample( tr( "year(age('2012-01-01','2010-01-01'))" ), tr( "1.9986" ), QString() ),
          QString(),
          QStringList()
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "z" ),
    Help( QStringLiteral( "z" ), tr( "function" ), tr( "Returns the z coordinate of a point geometry, or NULL if the geometry has no z value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "z" ), tr( "Returns the z coordinate of a point geometry, or NULL if the geometry has no z value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a point geometry" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "z( geom_from_wkt( 'POINTZ(2 5 7)' ) )" ), tr( "7" ), QString() ),
          QString(),
          QStringList()
            << tr( "point,coordinate" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "z_at" ),
    Help( QStringLiteral( "z_at" ), tr( "function" ), tr( "Retrieves a z coordinate of the geometry, or NULL if the geometry has no z value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "z_at" ), tr( "Retrieves a z coordinate of the geometry, or NULL if the geometry has no z value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "geometry object" ), false, false, false, QString() )
              << HelpArg( QStringLiteral( "vertex" ), tr( "index of the vertex of the geometry (indices start at 0; negative values apply from the last index, starting at -1)" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "z_at(geom_from_wkt('LineStringZ(0 0 0, 10 10 5, 10 10 0)'), 1)" ), tr( "5" ), QString() ),
          QString(),
          QStringList()
            << tr( "retrieves,coordinate,3D" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "z_max" ),
    Help( QStringLiteral( "z_max" ), tr( "function" ), tr( "Returns the maximum z coordinate of a geometry, or NULL if the geometry has no z value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "z_max" ), tr( "Returns the maximum z coordinate of a geometry, or NULL if the geometry has no z value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry with z coordinate" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "z_max( geom_from_wkt( 'POINT ( 0 0 1 )' ) )" ), tr( "1" ), QString() )
            << HelpExample( tr( "z_max( geom_from_wkt( 'MULTIPOINT ( 0 0 1 , 1 1 3 )' ) )" ), tr( "3" ), QString() )
            << HelpExample( tr( "z_max( make_line( make_point( 0,0,0 ), make_point( -1,-1,-2 ) ) )" ), tr( "0" ), QString() )
            << HelpExample( tr( "z_max( geom_from_wkt( 'LINESTRING( 0 0 0, 1 0 2, 1 1 -1 )' ) )" ), tr( "2" ), QString() )
            << HelpExample( tr( "z_max( geom_from_wkt( 'POINT ( 0 0 )' ) )" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,maximum" )
       )
      )
    );

  QgsExpression::functionHelpTexts().insert( QStringLiteral( "z_min" ),
    Help( QStringLiteral( "z_min" ), tr( "function" ), tr( "Returns the minimum z coordinate of a geometry, or NULL if the geometry has no z value." ),
      QList<HelpVariant>()
        << HelpVariant( tr( "z_min" ), tr( "Returns the minimum z coordinate of a geometry, or NULL if the geometry has no z value." ),
          QList<HelpArg>()
              << HelpArg( QStringLiteral( "geometry" ), tr( "a geometry with z coordinate" ), false, false, false, QString() ),
          /* variableLenArguments */ false,
          QList<HelpExample>()
            << HelpExample( tr( "z_min( geom_from_wkt( 'POINT ( 0 0 1 )' ) )" ), tr( "1" ), QString() )
            << HelpExample( tr( "z_min( geom_from_wkt( 'MULTIPOINT ( 0 0 1 , 1 1 3 )' ) )" ), tr( "1" ), QString() )
            << HelpExample( tr( "z_min( make_line( make_point( 0,0,0 ), make_point( -1,-1,-2 ) ) )" ), tr( "-2" ), QString() )
            << HelpExample( tr( "z_min( geom_from_wkt( 'LINESTRING( 0 0 0, 1 0 2, 1 1 -1 )' ) )" ), tr( "-1" ), QString() )
            << HelpExample( tr( "z_min( geom_from_wkt( 'POINT ( 0 0 )' ) )" ), tr( "NULL" ), QString() ),
          QString(),
          QStringList()
            << tr( "coordinate,minimum" )
       )
      )
    );
}

