/* localsearch-music-item-factory.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-music-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <tinysparql.h>
#include "rygel-server.h"
#include <glib-object.h>
#include "rygel-core.h"
#include <gee.h>

#define RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_CATEGORY "nmm:MusicPiece"
#define RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_GRAPH "tracker:Audio"
#define RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_GRAPH_IRI "http://tracker.api.gnome.org/ontology/v3/tracker#Audio"
#define RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#MusicPiece"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION = RYGEL_LOCAL_SEARCH_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_DISC_NUM,
	RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY
} RygelLocalSearchMusicItemFactoryMusicMetadata;

#define RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_TYPE_MUSIC_METADATA (rygel_local_search_music_item_factory_music_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_local_search_music_item_factory_parent_class = NULL;

static GType rygel_local_search_music_item_factory_music_metadata_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static RygelMediaFileItem* rygel_local_search_music_item_factory_real_create (RygelLocalSearchItemFactory* base,
                                                                       const gchar* id,
                                                                       const gchar* uri,
                                                                       RygelLocalSearchSearchContainer* parent,
                                                                       TrackerSparqlCursor* metadata,
                                                                       GError** error);
static void rygel_local_search_music_item_factory_real_set_metadata (RygelLocalSearchItemFactory* base,
                                                              RygelMediaFileItem* item,
                                                              const gchar* uri,
                                                              TrackerSparqlCursor* metadata,
                                                              GError** error);
static GType rygel_local_search_music_item_factory_get_type_once (void);

 G_GNUC_NO_INLINE static GType
rygel_local_search_music_item_factory_music_metadata_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION", "duration"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM", "audio-album"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST", "audio-artist"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM", "audio-track-num"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE", "audio-genre"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE", "sample-rate"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS", "channels"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE", "bits-per-sample"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE", "bitrate"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_DISC_NUM, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_DISC_NUM", "audio-disc-num"}, {RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY, "RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
	GType rygel_local_search_music_item_factory_music_metadata_type_id;
	rygel_local_search_music_item_factory_music_metadata_type_id = g_enum_register_static ("RygelLocalSearchMusicItemFactoryMusicMetadata", values);
	return rygel_local_search_music_item_factory_music_metadata_type_id;
}

static GType
rygel_local_search_music_item_factory_music_metadata_get_type (void)
{
	static volatile gsize rygel_local_search_music_item_factory_music_metadata_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_music_item_factory_music_metadata_type_id__once)) {
		GType rygel_local_search_music_item_factory_music_metadata_type_id;
		rygel_local_search_music_item_factory_music_metadata_type_id = rygel_local_search_music_item_factory_music_metadata_get_type_once ();
		g_once_init_leave (&rygel_local_search_music_item_factory_music_metadata_type_id__once, rygel_local_search_music_item_factory_music_metadata_type_id);
	}
	return rygel_local_search_music_item_factory_music_metadata_type_id__once;
}

RygelLocalSearchMusicItemFactory*
rygel_local_search_music_item_factory_construct (GType object_type)
{
	RygelLocalSearchMusicItemFactory* self = NULL;
	gchar* upload_folder = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp4_ = rygel_configuration_get_music_upload_folder ((RygelConfiguration*) config, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (upload_folder);
		upload_folder = _tmp5_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = upload_folder;
	self = (RygelLocalSearchMusicItemFactory*) rygel_local_search_item_factory_construct (object_type, RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_CATEGORY, RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_CATEGORY_IRI, RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_GRAPH, RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_GRAPH_IRI, RYGEL_MUSIC_ITEM_UPNP_CLASS, _tmp6_);
	_tmp7_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "res@duration");
	_tmp8_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "upnp:album");
	_tmp9_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "upnp:artist");
	_tmp10_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "upnp:originalTrackNumber");
	_tmp11_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "upnp:genre");
	_tmp12_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "sampleRate");
	_tmp13_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "upnp:nrAudioChannels");
	_tmp14_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "upnp:bitsPerSample");
	_tmp15_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "upnp:bitrate");
	_tmp16_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "rygel:originalVolumeNumber");
	_g_free0 (upload_folder);
	return self;
}

RygelLocalSearchMusicItemFactory*
rygel_local_search_music_item_factory_new (void)
{
	return rygel_local_search_music_item_factory_construct (RYGEL_LOCAL_SEARCH_TYPE_MUSIC_ITEM_FACTORY);
}

static RygelMediaFileItem*
rygel_local_search_music_item_factory_real_create (RygelLocalSearchItemFactory* base,
                                                   const gchar* id,
                                                   const gchar* uri,
                                                   RygelLocalSearchSearchContainer* parent,
                                                   TrackerSparqlCursor* metadata,
                                                   GError** error)
{
	RygelLocalSearchMusicItemFactory * self;
	RygelMusicItem* item = NULL;
	RygelMusicItem* _tmp0_;
	GError* _inner_error0_ = NULL;
	RygelMediaFileItem* result;
	self = (RygelLocalSearchMusicItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = rygel_music_item_new (id, (RygelMediaContainer*) parent, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
	item = _tmp0_;
	rygel_local_search_item_factory_set_metadata ((RygelLocalSearchItemFactory*) self, (RygelMediaFileItem*) item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaFileItem*) item;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_local_search_music_item_factory_real_set_metadata (RygelLocalSearchItemFactory* base,
                                                         RygelMediaFileItem* item,
                                                         const gchar* uri,
                                                         TrackerSparqlCursor* metadata,
                                                         GError** error)
{
	RygelLocalSearchMusicItemFactory * self;
	RygelMusicItem* music = NULL;
	RygelMusicItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMusicItem* _tmp16_;
	RygelMusicItem* _tmp17_;
	GError* _inner_error0_ = NULL;
	self = (RygelLocalSearchMusicItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	RYGEL_LOCAL_SEARCH_ITEM_FACTORY_CLASS (rygel_local_search_music_item_factory_parent_class)->set_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LOCAL_SEARCH_TYPE_ITEM_FACTORY, RygelLocalSearchItemFactory), item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	rygel_local_search_item_factory_set_ref_id ((RygelLocalSearchItemFactory*) self, item, "AllMusic");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) item) : NULL);
	music = _tmp0_;
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION)) {
		const gchar* _tmp2_;
		_tmp2_ = tracker_sparql_cursor_get_string (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, NULL);
		_tmp1_ = g_strcmp0 (_tmp2_, "0") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		RygelMusicItem* _tmp3_;
		_tmp3_ = music;
		rygel_audio_item_set_duration ((RygelAudioItem*) _tmp3_, (glong) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE)) {
		RygelMusicItem* _tmp4_;
		_tmp4_ = music;
		rygel_audio_item_set_sample_freq ((RygelAudioItem*) _tmp4_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS)) {
		RygelMusicItem* _tmp5_;
		_tmp5_ = music;
		rygel_audio_item_set_channels ((RygelAudioItem*) _tmp5_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE)) {
		RygelMusicItem* _tmp6_;
		_tmp6_ = music;
		rygel_audio_item_set_bits_per_sample ((RygelAudioItem*) _tmp6_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE)) {
		RygelMusicItem* _tmp7_;
		_tmp7_ = music;
		rygel_audio_item_set_bitrate ((RygelAudioItem*) _tmp7_, ((gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE)) / 8);
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM)) {
		RygelMusicItem* _tmp8_;
		_tmp8_ = music;
		rygel_music_item_set_track_number (_tmp8_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_DISC_NUM)) {
		RygelMusicItem* _tmp9_;
		_tmp9_ = music;
		rygel_music_item_set_disc_number (_tmp9_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_DISC_NUM));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST)) {
		RygelMusicItem* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = music;
		_tmp11_ = tracker_sparql_cursor_get_string (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, NULL);
		rygel_media_object_set_artist ((RygelMediaObject*) _tmp10_, _tmp11_);
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM)) {
		RygelMusicItem* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = music;
		_tmp13_ = tracker_sparql_cursor_get_string (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, NULL);
		rygel_audio_item_set_album ((RygelAudioItem*) _tmp12_, _tmp13_);
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE)) {
		RygelMusicItem* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = music;
		_tmp15_ = tracker_sparql_cursor_get_string (metadata, (gint) RYGEL_LOCAL_SEARCH_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, NULL);
		rygel_media_object_set_genre ((RygelMediaObject*) _tmp14_, _tmp15_);
	}
	_tmp16_ = music;
	rygel_music_item_lookup_album_art (_tmp16_);
	_tmp17_ = music;
	RYGEL_LOCAL_SEARCH_ITEM_FACTORY_CLASS (rygel_local_search_music_item_factory_parent_class)->add_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LOCAL_SEARCH_TYPE_ITEM_FACTORY, RygelLocalSearchItemFactory), (RygelMediaFileItem*) _tmp17_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (music);
		return;
	}
	_g_object_unref0 (music);
}

static void
rygel_local_search_music_item_factory_class_init (RygelLocalSearchMusicItemFactoryClass * klass,
                                                  gpointer klass_data)
{
	rygel_local_search_music_item_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelLocalSearchItemFactoryClass *) klass)->create = (RygelMediaFileItem* (*) (RygelLocalSearchItemFactory*, const gchar*, const gchar*, RygelLocalSearchSearchContainer*, TrackerSparqlCursor*, GError**)) rygel_local_search_music_item_factory_real_create;
	((RygelLocalSearchItemFactoryClass *) klass)->set_metadata = (void (*) (RygelLocalSearchItemFactory*, RygelMediaFileItem*, const gchar*, TrackerSparqlCursor*, GError**)) rygel_local_search_music_item_factory_real_set_metadata;
}

static void
rygel_local_search_music_item_factory_instance_init (RygelLocalSearchMusicItemFactory * self,
                                                     gpointer klass)
{
}

/**
 * LocalSearch music item factory.
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_music_item_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchMusicItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_music_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchMusicItemFactory), 0, (GInstanceInitFunc) rygel_local_search_music_item_factory_instance_init, NULL };
	GType rygel_local_search_music_item_factory_type_id;
	rygel_local_search_music_item_factory_type_id = g_type_register_static (RYGEL_LOCAL_SEARCH_TYPE_ITEM_FACTORY, "RygelLocalSearchMusicItemFactory", &g_define_type_info, 0);
	return rygel_local_search_music_item_factory_type_id;
}

GType
rygel_local_search_music_item_factory_get_type (void)
{
	static volatile gsize rygel_local_search_music_item_factory_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_music_item_factory_type_id__once)) {
		GType rygel_local_search_music_item_factory_type_id;
		rygel_local_search_music_item_factory_type_id = rygel_local_search_music_item_factory_get_type_once ();
		g_once_init_leave (&rygel_local_search_music_item_factory_type_id__once, rygel_local_search_music_item_factory_type_id);
	}
	return rygel_local_search_music_item_factory_type_id__once;
}

