/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_lsa.h"
#include "bin/default/librpc/gen_ndr/ndr_lsa_c.h"

/* lsarpc - client functions generated by pidl */

struct dcerpc_lsa_Close_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_Close_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_Close_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_Close *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_Close_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_Close_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CLOSE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_Close_r_done, req);

	return req;
}

static void dcerpc_lsa_Close_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_Close_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_Close_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_Close_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_Close_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_Close *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CLOSE, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_Close_state {
	struct lsa_Close orig;
	struct lsa_Close tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_Close_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_Close_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_Close_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_Close_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_Close_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_Close_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_Close_done, req);
	return req;
}

static void dcerpc_lsa_Close_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_Close_state *state = tevent_req_data(
		req, struct dcerpc_lsa_Close_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_Close_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_Close_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       NTSTATUS *result)
{
	struct dcerpc_lsa_Close_state *state = tevent_req_data(
		req, struct dcerpc_lsa_Close_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_Close(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct policy_handle *_handle /* [in,out] [ref] */,
			  NTSTATUS *result)
{
	struct lsa_Close r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_Close_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_Delete_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_Delete_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_Delete_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_Delete *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_Delete_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_Delete_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_DELETE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_Delete_r_done, req);

	return req;
}

static void dcerpc_lsa_Delete_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_Delete_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_Delete_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_Delete_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_Delete_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_Delete *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_DELETE, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_Delete_state {
	struct lsa_Delete orig;
	struct lsa_Delete tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_Delete_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_Delete_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_Delete_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_Delete_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_Delete_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_Delete_done, req);
	return req;
}

static void dcerpc_lsa_Delete_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_Delete_state *state = tevent_req_data(
		req, struct dcerpc_lsa_Delete_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_Delete_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_Delete_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				NTSTATUS *result)
{
	struct dcerpc_lsa_Delete_state *state = tevent_req_data(
		req, struct dcerpc_lsa_Delete_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_Delete(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   struct policy_handle *_handle /* [in] [ref] */,
			   NTSTATUS *result)
{
	struct lsa_Delete r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_Delete_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumPrivs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumPrivs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumPrivs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumPrivs *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumPrivs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumPrivs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMPRIVS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumPrivs_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumPrivs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumPrivs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumPrivs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumPrivs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumPrivs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumPrivs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMPRIVS, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumPrivs_state {
	struct lsa_EnumPrivs orig;
	struct lsa_EnumPrivs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumPrivs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumPrivs_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t *_resume_handle /* [in,out] [ref] */,
					     struct lsa_PrivArray *_privs /* [out] [ref] */,
					     uint32_t _max_count /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumPrivs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumPrivs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_count = _max_count;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.privs = _privs;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumPrivs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumPrivs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumPrivs_done, req);
	return req;
}

static void dcerpc_lsa_EnumPrivs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumPrivs_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumPrivs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumPrivs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.privs = *state->tmp.out.privs;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumPrivs_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_lsa_EnumPrivs_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumPrivs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumPrivs(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *_handle /* [in] [ref] */,
			      uint32_t *_resume_handle /* [in,out] [ref] */,
			      struct lsa_PrivArray *_privs /* [out] [ref] */,
			      uint32_t _max_count /* [in]  */,
			      NTSTATUS *result)
{
	struct lsa_EnumPrivs r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.resume_handle = _resume_handle;
	r.in.max_count = _max_count;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.privs = _privs;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumPrivs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_privs = *r.out.privs;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QuerySecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QuerySecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QuerySecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QuerySecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QuerySecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QuerySecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QuerySecurity_r_done, req);

	return req;
}

static void dcerpc_lsa_QuerySecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QuerySecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QuerySecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QuerySecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QuerySecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QuerySecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QuerySecurity_state {
	struct lsa_QuerySecurity orig;
	struct lsa_QuerySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QuerySecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QuerySecurity_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 uint32_t _sec_info /* [in]  */,
						 struct sec_desc_buf **_sdbuf /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QuerySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QuerySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;

	/* Out parameters */
	state->orig.out.sdbuf = _sdbuf;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QuerySecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QuerySecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QuerySecurity_done, req);
	return req;
}

static void dcerpc_lsa_QuerySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QuerySecurity_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QuerySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QuerySecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sdbuf = *state->tmp.out.sdbuf;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QuerySecurity_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_lsa_QuerySecurity_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QuerySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QuerySecurity(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  uint32_t _sec_info /* [in]  */,
				  struct sec_desc_buf **_sdbuf /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct lsa_QuerySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sec_info = _sec_info;

	/* Out parameters */
	r.out.sdbuf = _sdbuf;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QuerySecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sdbuf = *r.out.sdbuf;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetSecObj_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetSecObj_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetSecObj_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetSecObj *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetSecObj_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetSecObj_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETSECOBJ, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetSecObj_r_done, req);

	return req;
}

static void dcerpc_lsa_SetSecObj_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetSecObj_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetSecObj_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetSecObj_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetSecObj_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetSecObj *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETSECOBJ, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetSecObj_state {
	struct lsa_SetSecObj orig;
	struct lsa_SetSecObj tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetSecObj_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetSecObj_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _sec_info /* [in]  */,
					     struct sec_desc_buf *_sdbuf /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetSecObj_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetSecObj_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;
	state->orig.in.sdbuf = _sdbuf;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetSecObj_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetSecObj_done, req);
	return req;
}

static void dcerpc_lsa_SetSecObj_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetSecObj_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetSecObj_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetSecObj_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetSecObj_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_lsa_SetSecObj_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetSecObj_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetSecObj(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *_handle /* [in] [ref] */,
			      uint32_t _sec_info /* [in]  */,
			      struct sec_desc_buf *_sdbuf /* [in] [ref] */,
			      NTSTATUS *result)
{
	struct lsa_SetSecObj r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sec_info = _sec_info;
	r.in.sdbuf = _sdbuf;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetSecObj_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenPolicy_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenPolicy_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenPolicy_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenPolicy *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenPolicy_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenPolicy_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENPOLICY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenPolicy_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenPolicy_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenPolicy_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenPolicy_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenPolicy_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenPolicy_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenPolicy *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENPOLICY, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenPolicy_state {
	struct lsa_OpenPolicy orig;
	struct lsa_OpenPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenPolicy_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenPolicy_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint16_t *_system_name /* [in] [unique] */,
					      struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.attr = _attr;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenPolicy_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenPolicy_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenPolicy_done, req);
	return req;
}

static void dcerpc_lsa_OpenPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenPolicy_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenPolicy_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_lsa_OpenPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenPolicy(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *_system_name /* [in] [unique] */,
			       struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
			       uint32_t _access_mask /* [in]  */,
			       struct policy_handle *_handle /* [out] [ref] */,
			       NTSTATUS *result)
{
	struct lsa_OpenPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.attr = _attr;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenPolicy_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QueryInfoPolicy_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryInfoPolicy_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryInfoPolicy_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QueryInfoPolicy *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryInfoPolicy_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryInfoPolicy_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYINFOPOLICY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryInfoPolicy_r_done, req);

	return req;
}

static void dcerpc_lsa_QueryInfoPolicy_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QueryInfoPolicy_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QueryInfoPolicy_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QueryInfoPolicy *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYINFOPOLICY, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QueryInfoPolicy_state {
	struct lsa_QueryInfoPolicy orig;
	struct lsa_QueryInfoPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryInfoPolicy_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryInfoPolicy_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_handle /* [in] [ref] */,
						   enum lsa_PolicyInfo _level /* [in]  */,
						   union lsa_PolicyInformation **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryInfoPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryInfoPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QueryInfoPolicy_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QueryInfoPolicy_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryInfoPolicy_done, req);
	return req;
}

static void dcerpc_lsa_QueryInfoPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QueryInfoPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryInfoPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QueryInfoPolicy_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_lsa_QueryInfoPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryInfoPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_handle /* [in] [ref] */,
				    enum lsa_PolicyInfo _level /* [in]  */,
				    union lsa_PolicyInformation **_info /* [out] [ref,switch_is(level)] */,
				    NTSTATUS *result)
{
	struct lsa_QueryInfoPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QueryInfoPolicy_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetInfoPolicy_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetInfoPolicy_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetInfoPolicy_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetInfoPolicy *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetInfoPolicy_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetInfoPolicy_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETINFOPOLICY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetInfoPolicy_r_done, req);

	return req;
}

static void dcerpc_lsa_SetInfoPolicy_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetInfoPolicy_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetInfoPolicy_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetInfoPolicy_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetInfoPolicy_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetInfoPolicy *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETINFOPOLICY, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetInfoPolicy_state {
	struct lsa_SetInfoPolicy orig;
	struct lsa_SetInfoPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetInfoPolicy_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetInfoPolicy_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 enum lsa_PolicyInfo _level /* [in]  */,
						 union lsa_PolicyInformation *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetInfoPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetInfoPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetInfoPolicy_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetInfoPolicy_done, req);
	return req;
}

static void dcerpc_lsa_SetInfoPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetInfoPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetInfoPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetInfoPolicy_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetInfoPolicy_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_lsa_SetInfoPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetInfoPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetInfoPolicy(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  enum lsa_PolicyInfo _level /* [in]  */,
				  union lsa_PolicyInformation *_info /* [in] [ref,switch_is(level)] */,
				  NTSTATUS *result)
{
	struct lsa_SetInfoPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetInfoPolicy_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CreateAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CreateAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATEACCOUNT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_CreateAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CreateAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CreateAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CreateAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATEACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CreateAccount_state {
	struct lsa_CreateAccount orig;
	struct lsa_CreateAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateAccount_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct dom_sid2 *_sid /* [in] [ref] */,
						 uint32_t _access_mask /* [in]  */,
						 struct policy_handle *_acct_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.acct_handle = _acct_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CreateAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CreateAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateAccount_done, req);
	return req;
}

static void dcerpc_lsa_CreateAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CreateAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CreateAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.acct_handle = *state->tmp.out.acct_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateAccount_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_lsa_CreateAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateAccount(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  struct dom_sid2 *_sid /* [in] [ref] */,
				  uint32_t _access_mask /* [in]  */,
				  struct policy_handle *_acct_handle /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct lsa_CreateAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sid = _sid;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.acct_handle = _acct_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CreateAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_acct_handle = *r.out.acct_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumAccounts_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumAccounts_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumAccounts_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumAccounts *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumAccounts_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumAccounts_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMACCOUNTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumAccounts_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumAccounts_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumAccounts_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumAccounts_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumAccounts_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumAccounts_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumAccounts *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMACCOUNTS, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumAccounts_state {
	struct lsa_EnumAccounts orig;
	struct lsa_EnumAccounts tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumAccounts_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumAccounts_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t *_resume_handle /* [in,out] [ref] */,
						struct lsa_SidArray *_sids /* [out] [ref] */,
						uint32_t _num_entries /* [in] [range(0,8192)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumAccounts_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumAccounts_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.num_entries = _num_entries;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumAccounts_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumAccounts_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumAccounts_done, req);
	return req;
}

static void dcerpc_lsa_EnumAccounts_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumAccounts_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumAccounts_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumAccounts_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumAccounts_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_EnumAccounts_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumAccounts_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumAccounts(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t *_resume_handle /* [in,out] [ref] */,
				 struct lsa_SidArray *_sids /* [out] [ref] */,
				 uint32_t _num_entries /* [in] [range(0,8192)] */,
				 NTSTATUS *result)
{
	struct lsa_EnumAccounts r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.resume_handle = _resume_handle;
	r.in.num_entries = _num_entries;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumAccounts_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_sids = *r.out.sids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CreateTrustedDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CreateTrustedDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAIN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomain_r_done, req);

	return req;
}

static void dcerpc_lsa_CreateTrustedDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CreateTrustedDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CreateTrustedDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CreateTrustedDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CreateTrustedDomain_state {
	struct lsa_CreateTrustedDomain orig;
	struct lsa_CreateTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomain_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_policy_handle /* [in] [ref] */,
						       struct lsa_DomainInfo *_info /* [in] [ref] */,
						       uint32_t _access_mask /* [in]  */,
						       struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CreateTrustedDomain_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CreateTrustedDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomain_done, req);
	return req;
}

static void dcerpc_lsa_CreateTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CreateTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CreateTrustedDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomain_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_lsa_CreateTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomain(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_policy_handle /* [in] [ref] */,
					struct lsa_DomainInfo *_info /* [in] [ref] */,
					uint32_t _access_mask /* [in]  */,
					struct policy_handle *_trustdom_handle /* [out] [ref] */,
					NTSTATUS *result)
{
	struct lsa_CreateTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = _policy_handle;
	r.in.info = _info;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CreateTrustedDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumTrustDom_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumTrustDom_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumTrustDom_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumTrustDom *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumTrustDom_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumTrustDom_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMTRUSTDOM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumTrustDom_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumTrustDom_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumTrustDom_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumTrustDom_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumTrustDom_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumTrustDom_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumTrustDom *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMTRUSTDOM, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumTrustDom_state {
	struct lsa_EnumTrustDom orig;
	struct lsa_EnumTrustDom tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumTrustDom_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumTrustDom_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t *_resume_handle /* [in,out] [ref] */,
						struct lsa_DomainList *_domains /* [out] [ref] */,
						uint32_t _max_size /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumTrustDom_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumTrustDom_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.domains = _domains;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumTrustDom_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumTrustDom_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumTrustDom_done, req);
	return req;
}

static void dcerpc_lsa_EnumTrustDom_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumTrustDom_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumTrustDom_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumTrustDom_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.domains = *state->tmp.out.domains;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumTrustDom_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_EnumTrustDom_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumTrustDom_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumTrustDom(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t *_resume_handle /* [in,out] [ref] */,
				 struct lsa_DomainList *_domains /* [out] [ref] */,
				 uint32_t _max_size /* [in]  */,
				 NTSTATUS *result)
{
	struct lsa_EnumTrustDom r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.resume_handle = _resume_handle;
	r.in.max_size = _max_size;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.domains = _domains;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumTrustDom_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_domains = *r.out.domains;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupNames_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupNames *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupNames_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupNames_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupNames_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupNames *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupNames_state {
	struct lsa_LookupNames orig;
	struct lsa_LookupNames tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _num_names /* [in] [range(0,1000)] */,
					       struct lsa_String *_names /* [in] [size_is(num_names)] */,
					       struct lsa_RefDomainList **_domains /* [out] [ref] */,
					       struct lsa_TransSidArray *_sids /* [in,out] [ref] */,
					       enum lsa_LookupNamesLevel _level /* [in]  */,
					       uint32_t *_count /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupNames_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames_done, req);
	return req;
}

static void dcerpc_lsa_LookupNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupNames_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupNames_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_LookupNames_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				uint32_t _num_names /* [in] [range(0,1000)] */,
				struct lsa_String *_names /* [in] [size_is(num_names)] */,
				struct lsa_RefDomainList **_domains /* [out] [ref] */,
				struct lsa_TransSidArray *_sids /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel _level /* [in]  */,
				uint32_t *_count /* [in,out] [ref] */,
				NTSTATUS *result)
{
	struct lsa_LookupNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.num_names = _num_names;
	r.in.names = _names;
	r.in.sids = _sids;
	r.in.level = _level;
	r.in.count = _count;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.sids = _sids;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupNames_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_sids = *r.out.sids;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupSids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupSids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupSids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupSids *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupSids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupSids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPSIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupSids_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupSids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupSids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupSids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupSids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupSids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupSids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPSIDS, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupSids_state {
	struct lsa_LookupSids orig;
	struct lsa_LookupSids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupSids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupSids_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct lsa_SidArray *_sids /* [in] [ref] */,
					      struct lsa_RefDomainList **_domains /* [out] [ref] */,
					      struct lsa_TransNameArray *_names /* [in,out] [ref] */,
					      enum lsa_LookupNamesLevel _level /* [in]  */,
					      uint32_t *_count /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupSids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupSids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sids = _sids;
	state->orig.in.names = _names;
	state->orig.in.level = _level;
	state->orig.in.count = _count;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupSids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupSids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupSids_done, req);
	return req;
}

static void dcerpc_lsa_LookupSids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupSids_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupSids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupSids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupSids_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_lsa_LookupSids_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupSids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupSids(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       struct lsa_SidArray *_sids /* [in] [ref] */,
			       struct lsa_RefDomainList **_domains /* [out] [ref] */,
			       struct lsa_TransNameArray *_names /* [in,out] [ref] */,
			       enum lsa_LookupNamesLevel _level /* [in]  */,
			       uint32_t *_count /* [in,out] [ref] */,
			       NTSTATUS *result)
{
	struct lsa_LookupSids r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sids = _sids;
	r.in.names = _names;
	r.in.level = _level;
	r.in.count = _count;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.names = _names;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupSids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_names = *r.out.names;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CreateSecret_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateSecret_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateSecret_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CreateSecret *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateSecret_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateSecret_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATESECRET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateSecret_r_done, req);

	return req;
}

static void dcerpc_lsa_CreateSecret_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateSecret_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CreateSecret_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CreateSecret_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateSecret_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CreateSecret *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATESECRET, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CreateSecret_state {
	struct lsa_CreateSecret orig;
	struct lsa_CreateSecret tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateSecret_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateSecret_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						struct lsa_String _name /* [in]  */,
						uint32_t _access_mask /* [in]  */,
						struct policy_handle *_sec_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateSecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateSecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.sec_handle = _sec_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CreateSecret_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CreateSecret_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateSecret_done, req);
	return req;
}

static void dcerpc_lsa_CreateSecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CreateSecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateSecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CreateSecret_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sec_handle = *state->tmp.out.sec_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateSecret_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_CreateSecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateSecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateSecret(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 struct lsa_String _name /* [in]  */,
				 uint32_t _access_mask /* [in]  */,
				 struct policy_handle *_sec_handle /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct lsa_CreateSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.sec_handle = _sec_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CreateSecret_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sec_handle = *r.out.sec_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENACCOUNT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenAccount_state {
	struct lsa_OpenAccount orig;
	struct lsa_OpenAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenAccount_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct dom_sid2 *_sid /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_acct_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.acct_handle = _acct_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenAccount_done, req);
	return req;
}

static void dcerpc_lsa_OpenAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.acct_handle = *state->tmp.out.acct_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenAccount_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_OpenAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenAccount(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				struct dom_sid2 *_sid /* [in] [ref] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_acct_handle /* [out] [ref] */,
				NTSTATUS *result)
{
	struct lsa_OpenAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sid = _sid;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.acct_handle = _acct_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_acct_handle = *r.out.acct_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumPrivsAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumPrivsAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumPrivsAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumPrivsAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumPrivsAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumPrivsAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMPRIVSACCOUNT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumPrivsAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumPrivsAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumPrivsAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumPrivsAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumPrivsAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumPrivsAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumPrivsAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMPRIVSACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumPrivsAccount_state {
	struct lsa_EnumPrivsAccount orig;
	struct lsa_EnumPrivsAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumPrivsAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumPrivsAccount_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct lsa_PrivilegeSet **_privs /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumPrivsAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumPrivsAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.privs = _privs;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumPrivsAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumPrivsAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumPrivsAccount_done, req);
	return req;
}

static void dcerpc_lsa_EnumPrivsAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumPrivsAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumPrivsAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumPrivsAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.privs = *state->tmp.out.privs;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumPrivsAccount_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_lsa_EnumPrivsAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumPrivsAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumPrivsAccount(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     struct lsa_PrivilegeSet **_privs /* [out] [ref] */,
				     NTSTATUS *result)
{
	struct lsa_EnumPrivsAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.privs = _privs;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumPrivsAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_privs = *r.out.privs;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_AddPrivilegesToAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_AddPrivilegesToAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_AddPrivilegesToAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_AddPrivilegesToAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_AddPrivilegesToAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_AddPrivilegesToAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ADDPRIVILEGESTOACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_AddPrivilegesToAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_AddPrivilegesToAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_AddPrivilegesToAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_AddPrivilegesToAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_AddPrivilegesToAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_AddPrivilegesToAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_AddPrivilegesToAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ADDPRIVILEGESTOACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_AddPrivilegesToAccount_state {
	struct lsa_AddPrivilegesToAccount orig;
	struct lsa_AddPrivilegesToAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_AddPrivilegesToAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_AddPrivilegesToAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct lsa_PrivilegeSet *_privs /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_AddPrivilegesToAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_AddPrivilegesToAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.privs = _privs;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_AddPrivilegesToAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_AddPrivilegesToAccount_done, req);
	return req;
}

static void dcerpc_lsa_AddPrivilegesToAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_AddPrivilegesToAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_AddPrivilegesToAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_AddPrivilegesToAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_AddPrivilegesToAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_lsa_AddPrivilegesToAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_AddPrivilegesToAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_AddPrivilegesToAccount(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   struct lsa_PrivilegeSet *_privs /* [in] [ref] */,
					   NTSTATUS *result)
{
	struct lsa_AddPrivilegesToAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.privs = _privs;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_AddPrivilegesToAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_RemovePrivilegesFromAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_RemovePrivilegesFromAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_RemovePrivilegesFromAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_RemovePrivilegesFromAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_RemovePrivilegesFromAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_RemovePrivilegesFromAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_RemovePrivilegesFromAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_RemovePrivilegesFromAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_RemovePrivilegesFromAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_RemovePrivilegesFromAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_RemovePrivilegesFromAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_RemovePrivilegesFromAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_RemovePrivilegesFromAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_RemovePrivilegesFromAccount_state {
	struct lsa_RemovePrivilegesFromAccount orig;
	struct lsa_RemovePrivilegesFromAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_RemovePrivilegesFromAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_RemovePrivilegesFromAccount_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_handle /* [in] [ref] */,
							       uint8_t _remove_all /* [in]  */,
							       struct lsa_PrivilegeSet *_privs /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_RemovePrivilegesFromAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_RemovePrivilegesFromAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.remove_all = _remove_all;
	state->orig.in.privs = _privs;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_RemovePrivilegesFromAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_RemovePrivilegesFromAccount_done, req);
	return req;
}

static void dcerpc_lsa_RemovePrivilegesFromAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_RemovePrivilegesFromAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_RemovePrivilegesFromAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_RemovePrivilegesFromAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_RemovePrivilegesFromAccount_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_lsa_RemovePrivilegesFromAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_RemovePrivilegesFromAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_RemovePrivilegesFromAccount(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_handle /* [in] [ref] */,
						uint8_t _remove_all /* [in]  */,
						struct lsa_PrivilegeSet *_privs /* [in] [unique] */,
						NTSTATUS *result)
{
	struct lsa_RemovePrivilegesFromAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.remove_all = _remove_all;
	r.in.privs = _privs;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_RemovePrivilegesFromAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_GetSystemAccessAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_GetSystemAccessAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_GetSystemAccessAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_GetSystemAccessAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_GetSystemAccessAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_GetSystemAccessAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_GETSYSTEMACCESSACCOUNT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_GetSystemAccessAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_GetSystemAccessAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_GetSystemAccessAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_GetSystemAccessAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_GetSystemAccessAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_GetSystemAccessAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_GetSystemAccessAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_GETSYSTEMACCESSACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_GetSystemAccessAccount_state {
	struct lsa_GetSystemAccessAccount orig;
	struct lsa_GetSystemAccessAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_GetSystemAccessAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_GetSystemAccessAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t *_access_mask /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_GetSystemAccessAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_GetSystemAccessAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.access_mask = _access_mask;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_GetSystemAccessAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_GetSystemAccessAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_GetSystemAccessAccount_done, req);
	return req;
}

static void dcerpc_lsa_GetSystemAccessAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_GetSystemAccessAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_GetSystemAccessAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_GetSystemAccessAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.access_mask = *state->tmp.out.access_mask;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_GetSystemAccessAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_lsa_GetSystemAccessAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_GetSystemAccessAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_GetSystemAccessAccount(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t *_access_mask /* [out] [ref] */,
					   NTSTATUS *result)
{
	struct lsa_GetSystemAccessAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.access_mask = _access_mask;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_GetSystemAccessAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_access_mask = *r.out.access_mask;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetSystemAccessAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetSystemAccessAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetSystemAccessAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetSystemAccessAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetSystemAccessAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetSystemAccessAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETSYSTEMACCESSACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetSystemAccessAccount_r_done, req);

	return req;
}

static void dcerpc_lsa_SetSystemAccessAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetSystemAccessAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetSystemAccessAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetSystemAccessAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetSystemAccessAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetSystemAccessAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETSYSTEMACCESSACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetSystemAccessAccount_state {
	struct lsa_SetSystemAccessAccount orig;
	struct lsa_SetSystemAccessAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetSystemAccessAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetSystemAccessAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _access_mask /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetSystemAccessAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetSystemAccessAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetSystemAccessAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetSystemAccessAccount_done, req);
	return req;
}

static void dcerpc_lsa_SetSystemAccessAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetSystemAccessAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetSystemAccessAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetSystemAccessAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetSystemAccessAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_lsa_SetSystemAccessAccount_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetSystemAccessAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetSystemAccessAccount(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _access_mask /* [in]  */,
					   NTSTATUS *result)
{
	struct lsa_SetSystemAccessAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.access_mask = _access_mask;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetSystemAccessAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenTrustedDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenTrustedDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenTrustedDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenTrustedDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenTrustedDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenTrustedDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENTRUSTEDDOMAIN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenTrustedDomain_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenTrustedDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenTrustedDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenTrustedDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenTrustedDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenTrustedDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenTrustedDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENTRUSTEDDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenTrustedDomain_state {
	struct lsa_OpenTrustedDomain orig;
	struct lsa_OpenTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenTrustedDomain_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     struct dom_sid2 *_sid /* [in] [ref] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenTrustedDomain_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenTrustedDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenTrustedDomain_done, req);
	return req;
}

static void dcerpc_lsa_OpenTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenTrustedDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenTrustedDomain_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_lsa_OpenTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenTrustedDomain(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      struct dom_sid2 *_sid /* [in] [ref] */,
				      uint32_t _access_mask /* [in]  */,
				      struct policy_handle *_trustdom_handle /* [out] [ref] */,
				      NTSTATUS *result)
{
	struct lsa_OpenTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sid = _sid;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenTrustedDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QueryTrustedDomainInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryTrustedDomainInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryTrustedDomainInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QueryTrustedDomainInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryTrustedDomainInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryTrustedDomainInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYTRUSTEDDOMAININFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryTrustedDomainInfo_r_done, req);

	return req;
}

static void dcerpc_lsa_QueryTrustedDomainInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QueryTrustedDomainInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QueryTrustedDomainInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QueryTrustedDomainInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYTRUSTEDDOMAININFO, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QueryTrustedDomainInfo_state {
	struct lsa_QueryTrustedDomainInfo orig;
	struct lsa_QueryTrustedDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryTrustedDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryTrustedDomainInfo_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_trustdom_handle /* [in] [ref] */,
							  enum lsa_TrustDomInfoEnum _level /* [in]  */,
							  union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryTrustedDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryTrustedDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.trustdom_handle = _trustdom_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QueryTrustedDomainInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QueryTrustedDomainInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryTrustedDomainInfo_done, req);
	return req;
}

static void dcerpc_lsa_QueryTrustedDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QueryTrustedDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryTrustedDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QueryTrustedDomainInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfo_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_lsa_QueryTrustedDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryTrustedDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfo(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_trustdom_handle /* [in] [ref] */,
					   enum lsa_TrustDomInfoEnum _level /* [in]  */,
					   union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */,
					   NTSTATUS *result)
{
	struct lsa_QueryTrustedDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.trustdom_handle = _trustdom_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QueryTrustedDomainInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetInformationTrustedDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetInformationTrustedDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetInformationTrustedDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetInformationTrustedDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetInformationTrustedDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetInformationTrustedDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetInformationTrustedDomain_r_done, req);

	return req;
}

static void dcerpc_lsa_SetInformationTrustedDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetInformationTrustedDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetInformationTrustedDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetInformationTrustedDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetInformationTrustedDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetInformationTrustedDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetInformationTrustedDomain_state {
	struct lsa_SetInformationTrustedDomain orig;
	struct lsa_SetInformationTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetInformationTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetInformationTrustedDomain_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_trustdom_handle /* [in] [ref] */,
							       enum lsa_TrustDomInfoEnum _level /* [in]  */,
							       union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetInformationTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetInformationTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.trustdom_handle = _trustdom_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetInformationTrustedDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetInformationTrustedDomain_done, req);
	return req;
}

static void dcerpc_lsa_SetInformationTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetInformationTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetInformationTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetInformationTrustedDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetInformationTrustedDomain_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_lsa_SetInformationTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetInformationTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetInformationTrustedDomain(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_trustdom_handle /* [in] [ref] */,
						enum lsa_TrustDomInfoEnum _level /* [in]  */,
						union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */,
						NTSTATUS *result)
{
	struct lsa_SetInformationTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.trustdom_handle = _trustdom_handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetInformationTrustedDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenSecret_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenSecret_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenSecret_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenSecret *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenSecret_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenSecret_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENSECRET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenSecret_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenSecret_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenSecret_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenSecret_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenSecret_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenSecret_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenSecret *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENSECRET, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenSecret_state {
	struct lsa_OpenSecret orig;
	struct lsa_OpenSecret tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenSecret_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenSecret_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct lsa_String _name /* [in]  */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_sec_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenSecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenSecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.sec_handle = _sec_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenSecret_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenSecret_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenSecret_done, req);
	return req;
}

static void dcerpc_lsa_OpenSecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenSecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenSecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenSecret_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sec_handle = *state->tmp.out.sec_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenSecret_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_lsa_OpenSecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenSecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenSecret(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       struct lsa_String _name /* [in]  */,
			       uint32_t _access_mask /* [in]  */,
			       struct policy_handle *_sec_handle /* [out] [ref] */,
			       NTSTATUS *result)
{
	struct lsa_OpenSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.sec_handle = _sec_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenSecret_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sec_handle = *r.out.sec_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetSecret_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetSecret_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetSecret_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetSecret *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetSecret_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetSecret_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETSECRET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetSecret_r_done, req);

	return req;
}

static void dcerpc_lsa_SetSecret_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetSecret_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetSecret_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetSecret_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetSecret_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetSecret *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETSECRET, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetSecret_state {
	struct lsa_SetSecret orig;
	struct lsa_SetSecret tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetSecret_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetSecret_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct policy_handle *_sec_handle /* [in] [ref] */,
					     struct lsa_DATA_BUF *_new_val /* [in] [unique] */,
					     struct lsa_DATA_BUF *_old_val /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetSecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetSecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sec_handle = _sec_handle;
	state->orig.in.new_val = _new_val;
	state->orig.in.old_val = _old_val;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetSecret_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetSecret_done, req);
	return req;
}

static void dcerpc_lsa_SetSecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetSecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetSecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetSecret_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetSecret_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_lsa_SetSecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetSecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetSecret(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *_sec_handle /* [in] [ref] */,
			      struct lsa_DATA_BUF *_new_val /* [in] [unique] */,
			      struct lsa_DATA_BUF *_old_val /* [in] [unique] */,
			      NTSTATUS *result)
{
	struct lsa_SetSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.sec_handle = _sec_handle;
	r.in.new_val = _new_val;
	r.in.old_val = _old_val;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetSecret_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QuerySecret_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QuerySecret_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QuerySecret_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QuerySecret *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QuerySecret_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QuerySecret_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYSECRET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QuerySecret_r_done, req);

	return req;
}

static void dcerpc_lsa_QuerySecret_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QuerySecret_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QuerySecret_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QuerySecret_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QuerySecret_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QuerySecret *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYSECRET, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QuerySecret_state {
	struct lsa_QuerySecret orig;
	struct lsa_QuerySecret tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QuerySecret_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QuerySecret_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_sec_handle /* [in] [ref] */,
					       struct lsa_DATA_BUF_PTR *_new_val /* [in,out] [unique] */,
					       NTTIME *_new_mtime /* [in,out] [unique] */,
					       struct lsa_DATA_BUF_PTR *_old_val /* [in,out] [unique] */,
					       NTTIME *_old_mtime /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QuerySecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QuerySecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sec_handle = _sec_handle;
	state->orig.in.new_val = _new_val;
	state->orig.in.new_mtime = _new_mtime;
	state->orig.in.old_val = _old_val;
	state->orig.in.old_mtime = _old_mtime;

	/* Out parameters */
	state->orig.out.new_val = _new_val;
	state->orig.out.new_mtime = _new_mtime;
	state->orig.out.old_val = _old_val;
	state->orig.out.old_mtime = _old_mtime;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QuerySecret_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QuerySecret_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QuerySecret_done, req);
	return req;
}

static void dcerpc_lsa_QuerySecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QuerySecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QuerySecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QuerySecret_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.new_val && state->tmp.out.new_val) {
		*state->orig.out.new_val = *state->tmp.out.new_val;
	}
	if (state->orig.out.new_mtime && state->tmp.out.new_mtime) {
		*state->orig.out.new_mtime = *state->tmp.out.new_mtime;
	}
	if (state->orig.out.old_val && state->tmp.out.old_val) {
		*state->orig.out.old_val = *state->tmp.out.old_val;
	}
	if (state->orig.out.old_mtime && state->tmp.out.old_mtime) {
		*state->orig.out.old_mtime = *state->tmp.out.old_mtime;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QuerySecret_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_QuerySecret_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QuerySecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QuerySecret(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_sec_handle /* [in] [ref] */,
				struct lsa_DATA_BUF_PTR *_new_val /* [in,out] [unique] */,
				NTTIME *_new_mtime /* [in,out] [unique] */,
				struct lsa_DATA_BUF_PTR *_old_val /* [in,out] [unique] */,
				NTTIME *_old_mtime /* [in,out] [unique] */,
				NTSTATUS *result)
{
	struct lsa_QuerySecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.sec_handle = _sec_handle;
	r.in.new_val = _new_val;
	r.in.new_mtime = _new_mtime;
	r.in.old_val = _old_val;
	r.in.old_mtime = _old_mtime;

	/* Out parameters */
	r.out.new_val = _new_val;
	r.out.new_mtime = _new_mtime;
	r.out.old_val = _old_val;
	r.out.old_mtime = _old_mtime;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QuerySecret_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_new_val && r.out.new_val) {
		*_new_val = *r.out.new_val;
	}
	if (_new_mtime && r.out.new_mtime) {
		*_new_mtime = *r.out.new_mtime;
	}
	if (_old_val && r.out.old_val) {
		*_old_val = *r.out.old_val;
	}
	if (_old_mtime && r.out.old_mtime) {
		*_old_mtime = *r.out.old_mtime;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupPrivValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupPrivValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupPrivValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupPrivValue *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupPrivValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupPrivValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPPRIVVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupPrivValue_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupPrivValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupPrivValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupPrivValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupPrivValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupPrivValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupPrivValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPPRIVVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupPrivValue_state {
	struct lsa_LookupPrivValue orig;
	struct lsa_LookupPrivValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupPrivValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupPrivValue_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_handle /* [in] [ref] */,
						   struct lsa_String *_name /* [in] [ref] */,
						   struct lsa_LUID *_luid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupPrivValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupPrivValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.luid = _luid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupPrivValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupPrivValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupPrivValue_done, req);
	return req;
}

static void dcerpc_lsa_LookupPrivValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupPrivValue_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupPrivValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupPrivValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.luid = *state->tmp.out.luid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupPrivValue_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_lsa_LookupPrivValue_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupPrivValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupPrivValue(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_handle /* [in] [ref] */,
				    struct lsa_String *_name /* [in] [ref] */,
				    struct lsa_LUID *_luid /* [out] [ref] */,
				    NTSTATUS *result)
{
	struct lsa_LookupPrivValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;

	/* Out parameters */
	r.out.luid = _luid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupPrivValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_luid = *r.out.luid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupPrivName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupPrivName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupPrivName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupPrivName *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupPrivName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupPrivName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPPRIVNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupPrivName_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupPrivName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupPrivName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupPrivName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupPrivName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupPrivName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupPrivName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPPRIVNAME, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupPrivName_state {
	struct lsa_LookupPrivName orig;
	struct lsa_LookupPrivName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupPrivName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupPrivName_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct lsa_LUID *_luid /* [in] [ref] */,
						  struct lsa_StringLarge **_name /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupPrivName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupPrivName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.luid = _luid;

	/* Out parameters */
	state->orig.out.name = _name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupPrivName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupPrivName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupPrivName_done, req);
	return req;
}

static void dcerpc_lsa_LookupPrivName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupPrivName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupPrivName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupPrivName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name = *state->tmp.out.name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupPrivName_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_lsa_LookupPrivName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupPrivName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupPrivName(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   struct lsa_LUID *_luid /* [in] [ref] */,
				   struct lsa_StringLarge **_name /* [out] [ref] */,
				   NTSTATUS *result)
{
	struct lsa_LookupPrivName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.luid = _luid;

	/* Out parameters */
	r.out.name = _name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupPrivName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_name = *r.out.name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupPrivDisplayName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupPrivDisplayName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupPrivDisplayName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupPrivDisplayName *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupPrivDisplayName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupPrivDisplayName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPPRIVDISPLAYNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupPrivDisplayName_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupPrivDisplayName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupPrivDisplayName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupPrivDisplayName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupPrivDisplayName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupPrivDisplayName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupPrivDisplayName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPPRIVDISPLAYNAME, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupPrivDisplayName_state {
	struct lsa_LookupPrivDisplayName orig;
	struct lsa_LookupPrivDisplayName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupPrivDisplayName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupPrivDisplayName_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 struct lsa_String *_name /* [in] [ref] */,
							 uint16_t _language_id /* [in]  */,
							 uint16_t _language_id_sys /* [in]  */,
							 struct lsa_StringLarge **_disp_name /* [out] [ref] */,
							 uint16_t *_returned_language_id /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupPrivDisplayName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupPrivDisplayName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.language_id = _language_id;
	state->orig.in.language_id_sys = _language_id_sys;

	/* Out parameters */
	state->orig.out.disp_name = _disp_name;
	state->orig.out.returned_language_id = _returned_language_id;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupPrivDisplayName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupPrivDisplayName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupPrivDisplayName_done, req);
	return req;
}

static void dcerpc_lsa_LookupPrivDisplayName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupPrivDisplayName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupPrivDisplayName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupPrivDisplayName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.disp_name = *state->tmp.out.disp_name;
	*state->orig.out.returned_language_id = *state->tmp.out.returned_language_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupPrivDisplayName_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_lsa_LookupPrivDisplayName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupPrivDisplayName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupPrivDisplayName(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  struct lsa_String *_name /* [in] [ref] */,
					  uint16_t _language_id /* [in]  */,
					  uint16_t _language_id_sys /* [in]  */,
					  struct lsa_StringLarge **_disp_name /* [out] [ref] */,
					  uint16_t *_returned_language_id /* [out] [ref] */,
					  NTSTATUS *result)
{
	struct lsa_LookupPrivDisplayName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.language_id = _language_id;
	r.in.language_id_sys = _language_id_sys;

	/* Out parameters */
	r.out.disp_name = _disp_name;
	r.out.returned_language_id = _returned_language_id;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupPrivDisplayName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_disp_name = *r.out.disp_name;
	*_returned_language_id = *r.out.returned_language_id;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_DeleteObject_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_DeleteObject_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_DeleteObject_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_DeleteObject *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_DeleteObject_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_DeleteObject_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_DELETEOBJECT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_DeleteObject_r_done, req);

	return req;
}

static void dcerpc_lsa_DeleteObject_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_DeleteObject_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_DeleteObject_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_DeleteObject_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_DeleteObject_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_DeleteObject *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_DELETEOBJECT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_DeleteObject_state {
	struct lsa_DeleteObject orig;
	struct lsa_DeleteObject tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_DeleteObject_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_DeleteObject_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_DeleteObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_DeleteObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_DeleteObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_DeleteObject_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_DeleteObject_done, req);
	return req;
}

static void dcerpc_lsa_DeleteObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_DeleteObject_state *state = tevent_req_data(
		req, struct dcerpc_lsa_DeleteObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_DeleteObject_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_DeleteObject_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_DeleteObject_state *state = tevent_req_data(
		req, struct dcerpc_lsa_DeleteObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_DeleteObject(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in,out] [ref] */,
				 NTSTATUS *result)
{
	struct lsa_DeleteObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_DeleteObject_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumAccountsWithUserRight_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumAccountsWithUserRight_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumAccountsWithUserRight_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumAccountsWithUserRight *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumAccountsWithUserRight_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumAccountsWithUserRight_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumAccountsWithUserRight_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumAccountsWithUserRight_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumAccountsWithUserRight_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumAccountsWithUserRight_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumAccountsWithUserRight_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumAccountsWithUserRight_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumAccountsWithUserRight *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumAccountsWithUserRight_state {
	struct lsa_EnumAccountsWithUserRight orig;
	struct lsa_EnumAccountsWithUserRight tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumAccountsWithUserRight_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumAccountsWithUserRight_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_handle /* [in] [ref] */,
							     struct lsa_String *_name /* [in] [unique] */,
							     struct lsa_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumAccountsWithUserRight_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumAccountsWithUserRight_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumAccountsWithUserRight_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumAccountsWithUserRight_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumAccountsWithUserRight_done, req);
	return req;
}

static void dcerpc_lsa_EnumAccountsWithUserRight_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumAccountsWithUserRight_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumAccountsWithUserRight_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumAccountsWithUserRight_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumAccountsWithUserRight_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct dcerpc_lsa_EnumAccountsWithUserRight_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumAccountsWithUserRight_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumAccountsWithUserRight(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct lsa_String *_name /* [in] [unique] */,
					      struct lsa_SidArray *_sids /* [out] [ref] */,
					      NTSTATUS *result)
{
	struct lsa_EnumAccountsWithUserRight r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;

	/* Out parameters */
	r.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumAccountsWithUserRight_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sids = *r.out.sids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumAccountRights_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumAccountRights_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumAccountRights_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumAccountRights *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumAccountRights_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumAccountRights_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMACCOUNTRIGHTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumAccountRights_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumAccountRights_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumAccountRights_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumAccountRights_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumAccountRights_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumAccountRights_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumAccountRights *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMACCOUNTRIGHTS, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumAccountRights_state {
	struct lsa_EnumAccountRights orig;
	struct lsa_EnumAccountRights tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumAccountRights_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumAccountRights_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     struct dom_sid2 *_sid /* [in] [ref] */,
						     struct lsa_RightSet *_rights /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumAccountRights_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumAccountRights_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.rights = _rights;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumAccountRights_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumAccountRights_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumAccountRights_done, req);
	return req;
}

static void dcerpc_lsa_EnumAccountRights_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumAccountRights_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumAccountRights_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumAccountRights_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rights = *state->tmp.out.rights;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumAccountRights_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_lsa_EnumAccountRights_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumAccountRights_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumAccountRights(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      struct dom_sid2 *_sid /* [in] [ref] */,
				      struct lsa_RightSet *_rights /* [out] [ref] */,
				      NTSTATUS *result)
{
	struct lsa_EnumAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sid = _sid;

	/* Out parameters */
	r.out.rights = _rights;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumAccountRights_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rights = *r.out.rights;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_AddAccountRights_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_AddAccountRights_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_AddAccountRights_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_AddAccountRights *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_AddAccountRights_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_AddAccountRights_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ADDACCOUNTRIGHTS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_AddAccountRights_r_done, req);

	return req;
}

static void dcerpc_lsa_AddAccountRights_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_AddAccountRights_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_AddAccountRights_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_AddAccountRights_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_AddAccountRights_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_AddAccountRights *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ADDACCOUNTRIGHTS, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_AddAccountRights_state {
	struct lsa_AddAccountRights orig;
	struct lsa_AddAccountRights tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_AddAccountRights_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_AddAccountRights_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct dom_sid2 *_sid /* [in] [ref] */,
						    struct lsa_RightSet *_rights /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_AddAccountRights_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_AddAccountRights_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.rights = _rights;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_AddAccountRights_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_AddAccountRights_done, req);
	return req;
}

static void dcerpc_lsa_AddAccountRights_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_AddAccountRights_state *state = tevent_req_data(
		req, struct dcerpc_lsa_AddAccountRights_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_AddAccountRights_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_AddAccountRights_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_lsa_AddAccountRights_state *state = tevent_req_data(
		req, struct dcerpc_lsa_AddAccountRights_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_AddAccountRights(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     struct dom_sid2 *_sid /* [in] [ref] */,
				     struct lsa_RightSet *_rights /* [in] [ref] */,
				     NTSTATUS *result)
{
	struct lsa_AddAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sid = _sid;
	r.in.rights = _rights;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_AddAccountRights_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_RemoveAccountRights_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_RemoveAccountRights_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_RemoveAccountRights_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_RemoveAccountRights *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_RemoveAccountRights_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_RemoveAccountRights_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_REMOVEACCOUNTRIGHTS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_RemoveAccountRights_r_done, req);

	return req;
}

static void dcerpc_lsa_RemoveAccountRights_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_RemoveAccountRights_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_RemoveAccountRights_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_RemoveAccountRights_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_RemoveAccountRights_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_RemoveAccountRights *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_REMOVEACCOUNTRIGHTS, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_RemoveAccountRights_state {
	struct lsa_RemoveAccountRights orig;
	struct lsa_RemoveAccountRights tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_RemoveAccountRights_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_RemoveAccountRights_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct dom_sid2 *_sid /* [in] [ref] */,
						       uint8_t _remove_all /* [in]  */,
						       struct lsa_RightSet *_rights /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_RemoveAccountRights_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_RemoveAccountRights_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.remove_all = _remove_all;
	state->orig.in.rights = _rights;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_RemoveAccountRights_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_RemoveAccountRights_done, req);
	return req;
}

static void dcerpc_lsa_RemoveAccountRights_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_RemoveAccountRights_state *state = tevent_req_data(
		req, struct dcerpc_lsa_RemoveAccountRights_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_RemoveAccountRights_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_RemoveAccountRights_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_lsa_RemoveAccountRights_state *state = tevent_req_data(
		req, struct dcerpc_lsa_RemoveAccountRights_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_RemoveAccountRights(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					struct dom_sid2 *_sid /* [in] [ref] */,
					uint8_t _remove_all /* [in]  */,
					struct lsa_RightSet *_rights /* [in] [ref] */,
					NTSTATUS *result)
{
	struct lsa_RemoveAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sid = _sid;
	r.in.remove_all = _remove_all;
	r.in.rights = _rights;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_RemoveAccountRights_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QueryTrustedDomainInfoBySid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryTrustedDomainInfoBySid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryTrustedDomainInfoBySid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QueryTrustedDomainInfoBySid *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryTrustedDomainInfoBySid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryTrustedDomainInfoBySid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryTrustedDomainInfoBySid_r_done, req);

	return req;
}

static void dcerpc_lsa_QueryTrustedDomainInfoBySid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoBySid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QueryTrustedDomainInfoBySid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QueryTrustedDomainInfoBySid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoBySid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QueryTrustedDomainInfoBySid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state {
	struct lsa_QueryTrustedDomainInfoBySid orig;
	struct lsa_QueryTrustedDomainInfoBySid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryTrustedDomainInfoBySid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryTrustedDomainInfoBySid_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_handle /* [in] [ref] */,
							       struct dom_sid2 *_dom_sid /* [in] [ref] */,
							       enum lsa_TrustDomInfoEnum _level /* [in]  */,
							       union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.dom_sid = _dom_sid;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QueryTrustedDomainInfoBySid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QueryTrustedDomainInfoBySid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryTrustedDomainInfoBySid_done, req);
	return req;
}

static void dcerpc_lsa_QueryTrustedDomainInfoBySid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QueryTrustedDomainInfoBySid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoBySid_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryTrustedDomainInfoBySid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoBySid(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_handle /* [in] [ref] */,
						struct dom_sid2 *_dom_sid /* [in] [ref] */,
						enum lsa_TrustDomInfoEnum _level /* [in]  */,
						union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */,
						NTSTATUS *result)
{
	struct lsa_QueryTrustedDomainInfoBySid r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.dom_sid = _dom_sid;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QueryTrustedDomainInfoBySid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetTrustedDomainInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetTrustedDomainInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetTrustedDomainInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetTrustedDomainInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetTrustedDomainInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetTrustedDomainInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETTRUSTEDDOMAININFO, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetTrustedDomainInfo_r_done, req);

	return req;
}

static void dcerpc_lsa_SetTrustedDomainInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetTrustedDomainInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetTrustedDomainInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetTrustedDomainInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETTRUSTEDDOMAININFO, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetTrustedDomainInfo_state {
	struct lsa_SetTrustedDomainInfo orig;
	struct lsa_SetTrustedDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetTrustedDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetTrustedDomainInfo_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							struct dom_sid2 *_dom_sid /* [in] [ref] */,
							enum lsa_TrustDomInfoEnum _level /* [in]  */,
							union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetTrustedDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetTrustedDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.dom_sid = _dom_sid;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetTrustedDomainInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetTrustedDomainInfo_done, req);
	return req;
}

static void dcerpc_lsa_SetTrustedDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetTrustedDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetTrustedDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetTrustedDomainInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfo_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_lsa_SetTrustedDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetTrustedDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfo(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 struct dom_sid2 *_dom_sid /* [in] [ref] */,
					 enum lsa_TrustDomInfoEnum _level /* [in]  */,
					 union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */,
					 NTSTATUS *result)
{
	struct lsa_SetTrustedDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.dom_sid = _dom_sid;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetTrustedDomainInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_DeleteTrustedDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_DeleteTrustedDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_DeleteTrustedDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_DeleteTrustedDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_DeleteTrustedDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_DeleteTrustedDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_DELETETRUSTEDDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_DeleteTrustedDomain_r_done, req);

	return req;
}

static void dcerpc_lsa_DeleteTrustedDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_DeleteTrustedDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_DeleteTrustedDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_DeleteTrustedDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_DeleteTrustedDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_DeleteTrustedDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_DELETETRUSTEDDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_DeleteTrustedDomain_state {
	struct lsa_DeleteTrustedDomain orig;
	struct lsa_DeleteTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_DeleteTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_DeleteTrustedDomain_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct dom_sid2 *_dom_sid /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_DeleteTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_DeleteTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.dom_sid = _dom_sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_DeleteTrustedDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_DeleteTrustedDomain_done, req);
	return req;
}

static void dcerpc_lsa_DeleteTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_DeleteTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_DeleteTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_DeleteTrustedDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_DeleteTrustedDomain_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_lsa_DeleteTrustedDomain_state *state = tevent_req_data(
		req, struct dcerpc_lsa_DeleteTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_DeleteTrustedDomain(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					struct dom_sid2 *_dom_sid /* [in] [ref] */,
					NTSTATUS *result)
{
	struct lsa_DeleteTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.dom_sid = _dom_sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_DeleteTrustedDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_StorePrivateData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_StorePrivateData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_StorePrivateData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_StorePrivateData *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_StorePrivateData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_StorePrivateData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_STOREPRIVATEDATA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_StorePrivateData_r_done, req);

	return req;
}

static void dcerpc_lsa_StorePrivateData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_StorePrivateData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_StorePrivateData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_StorePrivateData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_StorePrivateData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_StorePrivateData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_STOREPRIVATEDATA, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_StorePrivateData_state {
	struct lsa_StorePrivateData orig;
	struct lsa_StorePrivateData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_StorePrivateData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_StorePrivateData_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct lsa_String *_name /* [in] [ref] */,
						    struct lsa_DATA_BUF *_val /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_StorePrivateData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_StorePrivateData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.val = _val;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_StorePrivateData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_StorePrivateData_done, req);
	return req;
}

static void dcerpc_lsa_StorePrivateData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_StorePrivateData_state *state = tevent_req_data(
		req, struct dcerpc_lsa_StorePrivateData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_StorePrivateData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_StorePrivateData_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_lsa_StorePrivateData_state *state = tevent_req_data(
		req, struct dcerpc_lsa_StorePrivateData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_StorePrivateData(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     struct lsa_String *_name /* [in] [ref] */,
				     struct lsa_DATA_BUF *_val /* [in] [unique] */,
				     NTSTATUS *result)
{
	struct lsa_StorePrivateData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.val = _val;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_StorePrivateData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_RetrievePrivateData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_RetrievePrivateData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_RetrievePrivateData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_RetrievePrivateData *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_RetrievePrivateData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_RetrievePrivateData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_RETRIEVEPRIVATEDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_RetrievePrivateData_r_done, req);

	return req;
}

static void dcerpc_lsa_RetrievePrivateData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_RetrievePrivateData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_RetrievePrivateData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_RetrievePrivateData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_RetrievePrivateData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_RetrievePrivateData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_RETRIEVEPRIVATEDATA, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_RetrievePrivateData_state {
	struct lsa_RetrievePrivateData orig;
	struct lsa_RetrievePrivateData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_RetrievePrivateData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_RetrievePrivateData_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct lsa_String *_name /* [in] [ref] */,
						       struct lsa_DATA_BUF **_val /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_RetrievePrivateData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_RetrievePrivateData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.val = _val;

	/* Out parameters */
	state->orig.out.val = _val;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_RetrievePrivateData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_RetrievePrivateData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_RetrievePrivateData_done, req);
	return req;
}

static void dcerpc_lsa_RetrievePrivateData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_RetrievePrivateData_state *state = tevent_req_data(
		req, struct dcerpc_lsa_RetrievePrivateData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_RetrievePrivateData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.val = *state->tmp.out.val;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_RetrievePrivateData_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_lsa_RetrievePrivateData_state *state = tevent_req_data(
		req, struct dcerpc_lsa_RetrievePrivateData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_RetrievePrivateData(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					struct lsa_String *_name /* [in] [ref] */,
					struct lsa_DATA_BUF **_val /* [in,out] [ref] */,
					NTSTATUS *result)
{
	struct lsa_RetrievePrivateData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.val = _val;

	/* Out parameters */
	r.out.val = _val;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_RetrievePrivateData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_val = *r.out.val;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenPolicy2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenPolicy2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenPolicy2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenPolicy2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenPolicy2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenPolicy2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENPOLICY2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenPolicy2_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenPolicy2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenPolicy2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenPolicy2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenPolicy2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenPolicy2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenPolicy2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENPOLICY2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenPolicy2_state {
	struct lsa_OpenPolicy2 orig;
	struct lsa_OpenPolicy2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenPolicy2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenPolicy2_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_system_name /* [in] [charset(UTF16),unique] */,
					       struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenPolicy2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenPolicy2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.attr = _attr;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenPolicy2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenPolicy2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenPolicy2_done, req);
	return req;
}

static void dcerpc_lsa_OpenPolicy2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenPolicy2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenPolicy2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenPolicy2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenPolicy2_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_OpenPolicy2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenPolicy2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenPolicy2(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_system_name /* [in] [charset(UTF16),unique] */,
				struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				NTSTATUS *result)
{
	struct lsa_OpenPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.attr = _attr;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenPolicy2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_GetUserName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_GetUserName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_GetUserName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_GetUserName *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_GetUserName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_GetUserName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_GETUSERNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_GetUserName_r_done, req);

	return req;
}

static void dcerpc_lsa_GetUserName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_GetUserName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_GetUserName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_GetUserName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_GetUserName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_GetUserName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_GETUSERNAME, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_GetUserName_state {
	struct lsa_GetUserName orig;
	struct lsa_GetUserName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_GetUserName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_GetUserName_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_system_name /* [in] [charset(UTF16),unique] */,
					       struct lsa_String **_account_name /* [in,out] [ref] */,
					       struct lsa_String **_authority_name /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_GetUserName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_GetUserName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.authority_name = _authority_name;

	/* Out parameters */
	state->orig.out.account_name = _account_name;
	state->orig.out.authority_name = _authority_name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_GetUserName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_GetUserName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_GetUserName_done, req);
	return req;
}

static void dcerpc_lsa_GetUserName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_GetUserName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_GetUserName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_GetUserName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.account_name = *state->tmp.out.account_name;
	if (state->orig.out.authority_name && state->tmp.out.authority_name) {
		*state->orig.out.authority_name = *state->tmp.out.authority_name;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_GetUserName_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_GetUserName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_GetUserName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_GetUserName(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_system_name /* [in] [charset(UTF16),unique] */,
				struct lsa_String **_account_name /* [in,out] [ref] */,
				struct lsa_String **_authority_name /* [in,out] [unique] */,
				NTSTATUS *result)
{
	struct lsa_GetUserName r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.account_name = _account_name;
	r.in.authority_name = _authority_name;

	/* Out parameters */
	r.out.account_name = _account_name;
	r.out.authority_name = _authority_name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_GetUserName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_account_name = *r.out.account_name;
	if (_authority_name && r.out.authority_name) {
		*_authority_name = *r.out.authority_name;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QueryInfoPolicy2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryInfoPolicy2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryInfoPolicy2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QueryInfoPolicy2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryInfoPolicy2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryInfoPolicy2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYINFOPOLICY2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryInfoPolicy2_r_done, req);

	return req;
}

static void dcerpc_lsa_QueryInfoPolicy2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QueryInfoPolicy2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QueryInfoPolicy2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QueryInfoPolicy2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYINFOPOLICY2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QueryInfoPolicy2_state {
	struct lsa_QueryInfoPolicy2 orig;
	struct lsa_QueryInfoPolicy2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryInfoPolicy2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryInfoPolicy2_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    enum lsa_PolicyInfo _level /* [in]  */,
						    union lsa_PolicyInformation **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryInfoPolicy2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryInfoPolicy2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QueryInfoPolicy2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QueryInfoPolicy2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryInfoPolicy2_done, req);
	return req;
}

static void dcerpc_lsa_QueryInfoPolicy2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QueryInfoPolicy2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryInfoPolicy2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QueryInfoPolicy2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy2_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_lsa_QueryInfoPolicy2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryInfoPolicy2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryInfoPolicy2(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     enum lsa_PolicyInfo _level /* [in]  */,
				     union lsa_PolicyInformation **_info /* [out] [ref,switch_is(level)] */,
				     NTSTATUS *result)
{
	struct lsa_QueryInfoPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QueryInfoPolicy2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetInfoPolicy2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetInfoPolicy2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetInfoPolicy2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetInfoPolicy2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetInfoPolicy2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetInfoPolicy2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETINFOPOLICY2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetInfoPolicy2_r_done, req);

	return req;
}

static void dcerpc_lsa_SetInfoPolicy2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetInfoPolicy2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetInfoPolicy2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetInfoPolicy2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetInfoPolicy2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetInfoPolicy2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETINFOPOLICY2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetInfoPolicy2_state {
	struct lsa_SetInfoPolicy2 orig;
	struct lsa_SetInfoPolicy2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetInfoPolicy2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetInfoPolicy2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  enum lsa_PolicyInfo _level /* [in]  */,
						  union lsa_PolicyInformation *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetInfoPolicy2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetInfoPolicy2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetInfoPolicy2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetInfoPolicy2_done, req);
	return req;
}

static void dcerpc_lsa_SetInfoPolicy2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetInfoPolicy2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetInfoPolicy2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetInfoPolicy2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetInfoPolicy2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_lsa_SetInfoPolicy2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetInfoPolicy2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetInfoPolicy2(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   enum lsa_PolicyInfo _level /* [in]  */,
				   union lsa_PolicyInformation *_info /* [in] [ref,switch_is(level)] */,
				   NTSTATUS *result)
{
	struct lsa_SetInfoPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetInfoPolicy2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QueryTrustedDomainInfoByName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryTrustedDomainInfoByName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryTrustedDomainInfoByName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QueryTrustedDomainInfoByName *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryTrustedDomainInfoByName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryTrustedDomainInfoByName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryTrustedDomainInfoByName_r_done, req);

	return req;
}

static void dcerpc_lsa_QueryTrustedDomainInfoByName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoByName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QueryTrustedDomainInfoByName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QueryTrustedDomainInfoByName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoByName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QueryTrustedDomainInfoByName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QueryTrustedDomainInfoByName_state {
	struct lsa_QueryTrustedDomainInfoByName orig;
	struct lsa_QueryTrustedDomainInfoByName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryTrustedDomainInfoByName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryTrustedDomainInfoByName_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								struct policy_handle *_handle /* [in] [ref] */,
								struct lsa_String *_trusted_domain /* [in] [ref] */,
								enum lsa_TrustDomInfoEnum _level /* [in]  */,
								union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryTrustedDomainInfoByName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryTrustedDomainInfoByName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain = _trusted_domain;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QueryTrustedDomainInfoByName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QueryTrustedDomainInfoByName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryTrustedDomainInfoByName_done, req);
	return req;
}

static void dcerpc_lsa_QueryTrustedDomainInfoByName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QueryTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryTrustedDomainInfoByName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QueryTrustedDomainInfoByName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoByName_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      NTSTATUS *result)
{
	struct dcerpc_lsa_QueryTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryTrustedDomainInfoByName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryTrustedDomainInfoByName(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct lsa_String *_trusted_domain /* [in] [ref] */,
						 enum lsa_TrustDomInfoEnum _level /* [in]  */,
						 union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */,
						 NTSTATUS *result)
{
	struct lsa_QueryTrustedDomainInfoByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.trusted_domain = _trusted_domain;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QueryTrustedDomainInfoByName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetTrustedDomainInfoByName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetTrustedDomainInfoByName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetTrustedDomainInfoByName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetTrustedDomainInfoByName *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetTrustedDomainInfoByName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetTrustedDomainInfoByName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETTRUSTEDDOMAININFOBYNAME, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetTrustedDomainInfoByName_r_done, req);

	return req;
}

static void dcerpc_lsa_SetTrustedDomainInfoByName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfoByName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetTrustedDomainInfoByName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetTrustedDomainInfoByName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfoByName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetTrustedDomainInfoByName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETTRUSTEDDOMAININFOBYNAME, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetTrustedDomainInfoByName_state {
	struct lsa_SetTrustedDomainInfoByName orig;
	struct lsa_SetTrustedDomainInfoByName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetTrustedDomainInfoByName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetTrustedDomainInfoByName_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      struct lsa_String *_trusted_domain /* [in] [ref] */,
							      enum lsa_TrustDomInfoEnum _level /* [in]  */,
							      union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetTrustedDomainInfoByName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetTrustedDomainInfoByName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain = _trusted_domain;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetTrustedDomainInfoByName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetTrustedDomainInfoByName_done, req);
	return req;
}

static void dcerpc_lsa_SetTrustedDomainInfoByName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetTrustedDomainInfoByName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetTrustedDomainInfoByName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfoByName_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct dcerpc_lsa_SetTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetTrustedDomainInfoByName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetTrustedDomainInfoByName(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct lsa_String *_trusted_domain /* [in] [ref] */,
					       enum lsa_TrustDomInfoEnum _level /* [in]  */,
					       union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */,
					       NTSTATUS *result)
{
	struct lsa_SetTrustedDomainInfoByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.trusted_domain = _trusted_domain;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetTrustedDomainInfoByName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_EnumTrustedDomainsEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumTrustedDomainsEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumTrustedDomainsEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_EnumTrustedDomainsEx *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumTrustedDomainsEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumTrustedDomainsEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMTRUSTEDDOMAINSEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumTrustedDomainsEx_r_done, req);

	return req;
}

static void dcerpc_lsa_EnumTrustedDomainsEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumTrustedDomainsEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_EnumTrustedDomainsEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_EnumTrustedDomainsEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumTrustedDomainsEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_EnumTrustedDomainsEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_ENUMTRUSTEDDOMAINSEX, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_EnumTrustedDomainsEx_state {
	struct lsa_EnumTrustedDomainsEx orig;
	struct lsa_EnumTrustedDomainsEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_EnumTrustedDomainsEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_EnumTrustedDomainsEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t *_resume_handle /* [in,out] [ref] */,
							struct lsa_DomainListEx *_domains /* [out] [ref] */,
							uint32_t _max_size /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_EnumTrustedDomainsEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_EnumTrustedDomainsEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.domains = _domains;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_EnumTrustedDomainsEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_EnumTrustedDomainsEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_EnumTrustedDomainsEx_done, req);
	return req;
}

static void dcerpc_lsa_EnumTrustedDomainsEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_EnumTrustedDomainsEx_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumTrustedDomainsEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_EnumTrustedDomainsEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.domains = *state->tmp.out.domains;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_EnumTrustedDomainsEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_lsa_EnumTrustedDomainsEx_state *state = tevent_req_data(
		req, struct dcerpc_lsa_EnumTrustedDomainsEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_EnumTrustedDomainsEx(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 uint32_t *_resume_handle /* [in,out] [ref] */,
					 struct lsa_DomainListEx *_domains /* [out] [ref] */,
					 uint32_t _max_size /* [in]  */,
					 NTSTATUS *result)
{
	struct lsa_EnumTrustedDomainsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.resume_handle = _resume_handle;
	r.in.max_size = _max_size;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.domains = _domains;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_EnumTrustedDomainsEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_domains = *r.out.domains;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CreateTrustedDomainEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomainEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomainEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CreateTrustedDomainEx *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomainEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomainEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAINEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomainEx_r_done, req);

	return req;
}

static void dcerpc_lsa_CreateTrustedDomainEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CreateTrustedDomainEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CreateTrustedDomainEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CreateTrustedDomainEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAINEX, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CreateTrustedDomainEx_state {
	struct lsa_CreateTrustedDomainEx orig;
	struct lsa_CreateTrustedDomainEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomainEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomainEx_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_policy_handle /* [in] [ref] */,
							 struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
							 struct lsa_TrustDomainInfoAuthInfo *_auth_info /* [in] [ref] */,
							 uint32_t _access_mask /* [in]  */,
							 struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomainEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomainEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.auth_info = _auth_info;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CreateTrustedDomainEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CreateTrustedDomainEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomainEx_done, req);
	return req;
}

static void dcerpc_lsa_CreateTrustedDomainEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CreateTrustedDomainEx_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomainEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CreateTrustedDomainEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_lsa_CreateTrustedDomainEx_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomainEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_policy_handle /* [in] [ref] */,
					  struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
					  struct lsa_TrustDomainInfoAuthInfo *_auth_info /* [in] [ref] */,
					  uint32_t _access_mask /* [in]  */,
					  struct policy_handle *_trustdom_handle /* [out] [ref] */,
					  NTSTATUS *result)
{
	struct lsa_CreateTrustedDomainEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = _policy_handle;
	r.in.info = _info;
	r.in.auth_info = _auth_info;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CreateTrustedDomainEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CloseTrustedDomainEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CloseTrustedDomainEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CloseTrustedDomainEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CloseTrustedDomainEx *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CloseTrustedDomainEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CloseTrustedDomainEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CLOSETRUSTEDDOMAINEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CloseTrustedDomainEx_r_done, req);

	return req;
}

static void dcerpc_lsa_CloseTrustedDomainEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CloseTrustedDomainEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CloseTrustedDomainEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CloseTrustedDomainEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CloseTrustedDomainEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CloseTrustedDomainEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CLOSETRUSTEDDOMAINEX, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CloseTrustedDomainEx_state {
	struct lsa_CloseTrustedDomainEx orig;
	struct lsa_CloseTrustedDomainEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CloseTrustedDomainEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CloseTrustedDomainEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CloseTrustedDomainEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CloseTrustedDomainEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CloseTrustedDomainEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CloseTrustedDomainEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CloseTrustedDomainEx_done, req);
	return req;
}

static void dcerpc_lsa_CloseTrustedDomainEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CloseTrustedDomainEx_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CloseTrustedDomainEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CloseTrustedDomainEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CloseTrustedDomainEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_lsa_CloseTrustedDomainEx_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CloseTrustedDomainEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CloseTrustedDomainEx(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in,out] [ref] */,
					 NTSTATUS *result)
{
	struct lsa_CloseTrustedDomainEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CloseTrustedDomainEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_QueryDomainInformationPolicy_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryDomainInformationPolicy_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryDomainInformationPolicy_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_QueryDomainInformationPolicy *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryDomainInformationPolicy_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryDomainInformationPolicy_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYDOMAININFORMATIONPOLICY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryDomainInformationPolicy_r_done, req);

	return req;
}

static void dcerpc_lsa_QueryDomainInformationPolicy_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryDomainInformationPolicy_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_QueryDomainInformationPolicy_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_QueryDomainInformationPolicy_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryDomainInformationPolicy_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_QueryDomainInformationPolicy *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_QUERYDOMAININFORMATIONPOLICY, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_QueryDomainInformationPolicy_state {
	struct lsa_QueryDomainInformationPolicy orig;
	struct lsa_QueryDomainInformationPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_QueryDomainInformationPolicy_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_QueryDomainInformationPolicy_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								struct policy_handle *_handle /* [in] [ref] */,
								enum lsa_DomainInfoEnum _level /* [in]  */,
								union lsa_DomainInformationPolicy **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_QueryDomainInformationPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_QueryDomainInformationPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_QueryDomainInformationPolicy_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_QueryDomainInformationPolicy_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_QueryDomainInformationPolicy_done, req);
	return req;
}

static void dcerpc_lsa_QueryDomainInformationPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_QueryDomainInformationPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryDomainInformationPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_QueryDomainInformationPolicy_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_QueryDomainInformationPolicy_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      NTSTATUS *result)
{
	struct dcerpc_lsa_QueryDomainInformationPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_QueryDomainInformationPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_QueryDomainInformationPolicy(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *_handle /* [in] [ref] */,
						 enum lsa_DomainInfoEnum _level /* [in]  */,
						 union lsa_DomainInformationPolicy **_info /* [out] [ref,switch_is(level)] */,
						 NTSTATUS *result)
{
	struct lsa_QueryDomainInformationPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_QueryDomainInformationPolicy_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_SetDomainInformationPolicy_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetDomainInformationPolicy_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetDomainInformationPolicy_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_SetDomainInformationPolicy *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetDomainInformationPolicy_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetDomainInformationPolicy_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETDOMAININFORMATIONPOLICY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetDomainInformationPolicy_r_done, req);

	return req;
}

static void dcerpc_lsa_SetDomainInformationPolicy_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetDomainInformationPolicy_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_SetDomainInformationPolicy_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_SetDomainInformationPolicy_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetDomainInformationPolicy_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_SetDomainInformationPolicy *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_SETDOMAININFORMATIONPOLICY, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_SetDomainInformationPolicy_state {
	struct lsa_SetDomainInformationPolicy orig;
	struct lsa_SetDomainInformationPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_SetDomainInformationPolicy_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_SetDomainInformationPolicy_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      enum lsa_DomainInfoEnum _level /* [in]  */,
							      union lsa_DomainInformationPolicy *_info /* [in] [switch_is(level),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_SetDomainInformationPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_SetDomainInformationPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_SetDomainInformationPolicy_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_SetDomainInformationPolicy_done, req);
	return req;
}

static void dcerpc_lsa_SetDomainInformationPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_SetDomainInformationPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetDomainInformationPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_SetDomainInformationPolicy_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_SetDomainInformationPolicy_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct dcerpc_lsa_SetDomainInformationPolicy_state *state = tevent_req_data(
		req, struct dcerpc_lsa_SetDomainInformationPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_SetDomainInformationPolicy(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       enum lsa_DomainInfoEnum _level /* [in]  */,
					       union lsa_DomainInformationPolicy *_info /* [in] [switch_is(level),unique] */,
					       NTSTATUS *result)
{
	struct lsa_SetDomainInformationPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_SetDomainInformationPolicy_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenTrustedDomainByName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenTrustedDomainByName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenTrustedDomainByName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenTrustedDomainByName *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenTrustedDomainByName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenTrustedDomainByName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENTRUSTEDDOMAINBYNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenTrustedDomainByName_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenTrustedDomainByName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenTrustedDomainByName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenTrustedDomainByName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenTrustedDomainByName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenTrustedDomainByName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenTrustedDomainByName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENTRUSTEDDOMAINBYNAME, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenTrustedDomainByName_state {
	struct lsa_OpenTrustedDomainByName orig;
	struct lsa_OpenTrustedDomainByName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenTrustedDomainByName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenTrustedDomainByName_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   struct lsa_String _name /* [in]  */,
							   uint32_t _access_mask /* [in]  */,
							   struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenTrustedDomainByName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenTrustedDomainByName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenTrustedDomainByName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenTrustedDomainByName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenTrustedDomainByName_done, req);
	return req;
}

static void dcerpc_lsa_OpenTrustedDomainByName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenTrustedDomainByName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenTrustedDomainByName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenTrustedDomainByName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenTrustedDomainByName_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct dcerpc_lsa_OpenTrustedDomainByName_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenTrustedDomainByName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenTrustedDomainByName(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    struct lsa_String _name /* [in]  */,
					    uint32_t _access_mask /* [in]  */,
					    struct policy_handle *_trustdom_handle /* [out] [ref] */,
					    NTSTATUS *result)
{
	struct lsa_OpenTrustedDomainByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenTrustedDomainByName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupSids2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupSids2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupSids2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupSids2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupSids2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupSids2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPSIDS2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupSids2_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupSids2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupSids2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupSids2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupSids2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupSids2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupSids2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPSIDS2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupSids2_state {
	struct lsa_LookupSids2 orig;
	struct lsa_LookupSids2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupSids2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupSids2_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct lsa_SidArray *_sids /* [in] [ref] */,
					       struct lsa_RefDomainList **_domains /* [out] [ref] */,
					       struct lsa_TransNameArray2 *_names /* [in,out] [ref] */,
					       enum lsa_LookupNamesLevel _level /* [in]  */,
					       uint32_t *_count /* [in,out] [ref] */,
					       enum lsa_LookupOptions _lookup_options /* [in]  */,
					       enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupSids2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupSids2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sids = _sids;
	state->orig.in.names = _names;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupSids2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupSids2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupSids2_done, req);
	return req;
}

static void dcerpc_lsa_LookupSids2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupSids2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupSids2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupSids2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupSids2_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_LookupSids2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupSids2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupSids2(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				struct lsa_SidArray *_sids /* [in] [ref] */,
				struct lsa_RefDomainList **_domains /* [out] [ref] */,
				struct lsa_TransNameArray2 *_names /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel _level /* [in]  */,
				uint32_t *_count /* [in,out] [ref] */,
				enum lsa_LookupOptions _lookup_options /* [in]  */,
				enum lsa_ClientRevision _client_revision /* [in]  */,
				NTSTATUS *result)
{
	struct lsa_LookupSids2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sids = _sids;
	r.in.names = _names;
	r.in.level = _level;
	r.in.count = _count;
	r.in.lookup_options = _lookup_options;
	r.in.client_revision = _client_revision;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.names = _names;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupSids2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_names = *r.out.names;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupNames2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupNames2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames2_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupNames2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupNames2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupNames2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupNames2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupNames2_state {
	struct lsa_LookupNames2 orig;
	struct lsa_LookupNames2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames2_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [size_is(num_names)] */,
						struct lsa_RefDomainList **_domains /* [out] [ref] */,
						struct lsa_TransSidArray2 *_sids /* [in,out] [ref] */,
						enum lsa_LookupNamesLevel _level /* [in]  */,
						uint32_t *_count /* [in,out] [ref] */,
						enum lsa_LookupOptions _lookup_options /* [in]  */,
						enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupNames2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupNames2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames2_done, req);
	return req;
}

static void dcerpc_lsa_LookupNames2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupNames2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupNames2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames2_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_LookupNames2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames2(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t _num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *_names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **_domains /* [out] [ref] */,
				 struct lsa_TransSidArray2 *_sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel _level /* [in]  */,
				 uint32_t *_count /* [in,out] [ref] */,
				 enum lsa_LookupOptions _lookup_options /* [in]  */,
				 enum lsa_ClientRevision _client_revision /* [in]  */,
				 NTSTATUS *result)
{
	struct lsa_LookupNames2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.num_names = _num_names;
	r.in.names = _names;
	r.in.sids = _sids;
	r.in.level = _level;
	r.in.count = _count;
	r.in.lookup_options = _lookup_options;
	r.in.client_revision = _client_revision;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.sids = _sids;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupNames2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_sids = *r.out.sids;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CreateTrustedDomainEx2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomainEx2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomainEx2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CreateTrustedDomainEx2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomainEx2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomainEx2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAINEX2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomainEx2_r_done, req);

	return req;
}

static void dcerpc_lsa_CreateTrustedDomainEx2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CreateTrustedDomainEx2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CreateTrustedDomainEx2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CreateTrustedDomainEx2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAINEX2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CreateTrustedDomainEx2_state {
	struct lsa_CreateTrustedDomainEx2 orig;
	struct lsa_CreateTrustedDomainEx2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomainEx2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomainEx2_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_policy_handle /* [in] [ref] */,
							  struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
							  struct lsa_TrustDomainInfoAuthInfoInternal *_auth_info_internal /* [in] [ref] */,
							  uint32_t _access_mask /* [in]  */,
							  struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomainEx2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomainEx2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.auth_info_internal = _auth_info_internal;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CreateTrustedDomainEx2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CreateTrustedDomainEx2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomainEx2_done, req);
	return req;
}

static void dcerpc_lsa_CreateTrustedDomainEx2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CreateTrustedDomainEx2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomainEx2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CreateTrustedDomainEx2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx2_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_lsa_CreateTrustedDomainEx2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomainEx2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx2(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_policy_handle /* [in] [ref] */,
					   struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
					   struct lsa_TrustDomainInfoAuthInfoInternal *_auth_info_internal /* [in] [ref] */,
					   uint32_t _access_mask /* [in]  */,
					   struct policy_handle *_trustdom_handle /* [out] [ref] */,
					   NTSTATUS *result)
{
	struct lsa_CreateTrustedDomainEx2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = _policy_handle;
	r.in.info = _info;
	r.in.auth_info_internal = _auth_info_internal;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CreateTrustedDomainEx2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupNames3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupNames3 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames3_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupNames3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupNames3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupNames3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupNames3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES3, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupNames3_state {
	struct lsa_LookupNames3 orig;
	struct lsa_LookupNames3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames3_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [size_is(num_names)] */,
						struct lsa_RefDomainList **_domains /* [out] [ref] */,
						struct lsa_TransSidArray3 *_sids /* [in,out] [ref] */,
						enum lsa_LookupNamesLevel _level /* [in]  */,
						uint32_t *_count /* [in,out] [ref] */,
						enum lsa_LookupOptions _lookup_options /* [in]  */,
						enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupNames3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupNames3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames3_done, req);
	return req;
}

static void dcerpc_lsa_LookupNames3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupNames3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupNames3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames3_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_LookupNames3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames3(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t _num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *_names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **_domains /* [out] [ref] */,
				 struct lsa_TransSidArray3 *_sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel _level /* [in]  */,
				 uint32_t *_count /* [in,out] [ref] */,
				 enum lsa_LookupOptions _lookup_options /* [in]  */,
				 enum lsa_ClientRevision _client_revision /* [in]  */,
				 NTSTATUS *result)
{
	struct lsa_LookupNames3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.num_names = _num_names;
	r.in.names = _names;
	r.in.sids = _sids;
	r.in.level = _level;
	r.in.count = _count;
	r.in.lookup_options = _lookup_options;
	r.in.client_revision = _client_revision;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.sids = _sids;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupNames3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_sids = *r.out.sids;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_lsaRQueryForestTrustInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRQueryForestTrustInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRQueryForestTrustInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_lsaRQueryForestTrustInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRQueryForestTrustInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRQueryForestTrustInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRQueryForestTrustInformation_r_done, req);

	return req;
}

static void dcerpc_lsa_lsaRQueryForestTrustInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_lsaRQueryForestTrustInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_lsaRQueryForestTrustInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_lsaRQueryForestTrustInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_lsaRQueryForestTrustInformation_state {
	struct lsa_lsaRQueryForestTrustInformation orig;
	struct lsa_lsaRQueryForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRQueryForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRQueryForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   struct policy_handle *_handle /* [in] [ref] */,
								   struct lsa_String *_trusted_domain_name /* [in] [ref] */,
								   enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
								   struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRQueryForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRQueryForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.highest_record_type = _highest_record_type;

	/* Out parameters */
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_lsaRQueryForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_lsaRQueryForestTrustInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRQueryForestTrustInformation_done, req);
	return req;
}

static void dcerpc_lsa_lsaRQueryForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_lsaRQueryForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRQueryForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_lsaRQueryForestTrustInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 NTSTATUS *result)
{
	struct dcerpc_lsa_lsaRQueryForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRQueryForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct lsa_String *_trusted_domain_name /* [in] [ref] */,
						    enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
						    struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */,
						    NTSTATUS *result)
{
	struct lsa_lsaRQueryForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.trusted_domain_name = _trusted_domain_name;
	r.in.highest_record_type = _highest_record_type;

	/* Out parameters */
	r.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_lsaRQueryForestTrustInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_lsaRSetForestTrustInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRSetForestTrustInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRSetForestTrustInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_lsaRSetForestTrustInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRSetForestTrustInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRSetForestTrustInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARSETFORESTTRUSTINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRSetForestTrustInformation_r_done, req);

	return req;
}

static void dcerpc_lsa_lsaRSetForestTrustInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_lsaRSetForestTrustInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_lsaRSetForestTrustInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_lsaRSetForestTrustInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARSETFORESTTRUSTINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_lsaRSetForestTrustInformation_state {
	struct lsa_lsaRSetForestTrustInformation orig;
	struct lsa_lsaRSetForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRSetForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRSetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle *_handle /* [in] [ref] */,
								 struct lsa_StringLarge *_trusted_domain_name /* [in] [ref] */,
								 enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
								 struct lsa_ForestTrustInformation *_forest_trust_info /* [in] [ref] */,
								 uint8_t _check_only /* [in]  */,
								 struct lsa_ForestTrustCollisionInfo **_collision_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRSetForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRSetForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.highest_record_type = _highest_record_type;
	state->orig.in.forest_trust_info = _forest_trust_info;
	state->orig.in.check_only = _check_only;

	/* Out parameters */
	state->orig.out.collision_info = _collision_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_lsaRSetForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_lsaRSetForestTrustInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRSetForestTrustInformation_done, req);
	return req;
}

static void dcerpc_lsa_lsaRSetForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_lsaRSetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRSetForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_lsaRSetForestTrustInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.collision_info = *state->tmp.out.collision_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       NTSTATUS *result)
{
	struct dcerpc_lsa_lsaRSetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRSetForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct lsa_StringLarge *_trusted_domain_name /* [in] [ref] */,
						  enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
						  struct lsa_ForestTrustInformation *_forest_trust_info /* [in] [ref] */,
						  uint8_t _check_only /* [in]  */,
						  struct lsa_ForestTrustCollisionInfo **_collision_info /* [out] [ref] */,
						  NTSTATUS *result)
{
	struct lsa_lsaRSetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.trusted_domain_name = _trusted_domain_name;
	r.in.highest_record_type = _highest_record_type;
	r.in.forest_trust_info = _forest_trust_info;
	r.in.check_only = _check_only;

	/* Out parameters */
	r.out.collision_info = _collision_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_lsaRSetForestTrustInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_collision_info = *r.out.collision_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupSids3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupSids3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupSids3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupSids3 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupSids3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupSids3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPSIDS3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupSids3_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupSids3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupSids3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupSids3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupSids3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupSids3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupSids3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPSIDS3, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupSids3_state {
	struct lsa_LookupSids3 orig;
	struct lsa_LookupSids3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupSids3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupSids3_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct lsa_SidArray *_sids /* [in] [ref] */,
					       struct lsa_RefDomainList **_domains /* [out] [ref] */,
					       struct lsa_TransNameArray2 *_names /* [in,out] [ref] */,
					       enum lsa_LookupNamesLevel _level /* [in]  */,
					       uint32_t *_count /* [in,out] [ref] */,
					       enum lsa_LookupOptions _lookup_options /* [in]  */,
					       enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupSids3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupSids3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sids = _sids;
	state->orig.in.names = _names;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupSids3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupSids3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupSids3_done, req);
	return req;
}

static void dcerpc_lsa_LookupSids3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupSids3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupSids3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupSids3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupSids3_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_LookupSids3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupSids3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupSids3(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct lsa_SidArray *_sids /* [in] [ref] */,
				struct lsa_RefDomainList **_domains /* [out] [ref] */,
				struct lsa_TransNameArray2 *_names /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel _level /* [in]  */,
				uint32_t *_count /* [in,out] [ref] */,
				enum lsa_LookupOptions _lookup_options /* [in]  */,
				enum lsa_ClientRevision _client_revision /* [in]  */,
				NTSTATUS *result)
{
	struct lsa_LookupSids3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = _sids;
	r.in.names = _names;
	r.in.level = _level;
	r.in.count = _count;
	r.in.lookup_options = _lookup_options;
	r.in.client_revision = _client_revision;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.names = _names;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupSids3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_names = *r.out.names;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_LookupNames4_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames4_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames4_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_LookupNames4 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames4_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames4_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES4, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames4_r_done, req);

	return req;
}

static void dcerpc_lsa_LookupNames4_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames4_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_LookupNames4_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_LookupNames4_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames4_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_LookupNames4 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LOOKUPNAMES4, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_LookupNames4_state {
	struct lsa_LookupNames4 orig;
	struct lsa_LookupNames4 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_LookupNames4_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_LookupNames4_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [size_is(num_names)] */,
						struct lsa_RefDomainList **_domains /* [out] [ref] */,
						struct lsa_TransSidArray3 *_sids /* [in,out] [ref] */,
						enum lsa_LookupNamesLevel _level /* [in]  */,
						uint32_t *_count /* [in,out] [ref] */,
						enum lsa_LookupOptions _lookup_options /* [in]  */,
						enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_LookupNames4_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_LookupNames4_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_LookupNames4_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_LookupNames4_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_LookupNames4_done, req);
	return req;
}

static void dcerpc_lsa_LookupNames4_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_LookupNames4_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames4_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_LookupNames4_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_LookupNames4_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_lsa_LookupNames4_state *state = tevent_req_data(
		req, struct dcerpc_lsa_LookupNames4_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_LookupNames4(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 uint32_t _num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *_names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **_domains /* [out] [ref] */,
				 struct lsa_TransSidArray3 *_sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel _level /* [in]  */,
				 uint32_t *_count /* [in,out] [ref] */,
				 enum lsa_LookupOptions _lookup_options /* [in]  */,
				 enum lsa_ClientRevision _client_revision /* [in]  */,
				 NTSTATUS *result)
{
	struct lsa_LookupNames4 r;
	NTSTATUS status;

	/* In parameters */
	r.in.num_names = _num_names;
	r.in.names = _names;
	r.in.sids = _sids;
	r.in.level = _level;
	r.in.count = _count;
	r.in.lookup_options = _lookup_options;
	r.in.client_revision = _client_revision;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.sids = _sids;
	r.out.count = _count;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_LookupNames4_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_sids = *r.out.sids;
	*_count = *r.out.count;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_CreateTrustedDomainEx3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomainEx3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomainEx3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_CreateTrustedDomainEx3 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomainEx3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomainEx3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAINEX3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomainEx3_r_done, req);

	return req;
}

static void dcerpc_lsa_CreateTrustedDomainEx3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_CreateTrustedDomainEx3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_CreateTrustedDomainEx3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_CreateTrustedDomainEx3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_CREATETRUSTEDDOMAINEX3, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_CreateTrustedDomainEx3_state {
	struct lsa_CreateTrustedDomainEx3 orig;
	struct lsa_CreateTrustedDomainEx3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_CreateTrustedDomainEx3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_CreateTrustedDomainEx3_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_policy_handle /* [in] [ref] */,
							  struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
							  struct lsa_TrustDomainInfoAuthInfoInternalAES *_auth_info_internal /* [in] [ref] */,
							  uint32_t _access_mask /* [in]  */,
							  struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_CreateTrustedDomainEx3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_CreateTrustedDomainEx3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.auth_info_internal = _auth_info_internal;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_CreateTrustedDomainEx3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_CreateTrustedDomainEx3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_CreateTrustedDomainEx3_done, req);
	return req;
}

static void dcerpc_lsa_CreateTrustedDomainEx3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_CreateTrustedDomainEx3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomainEx3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_CreateTrustedDomainEx3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx3_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_lsa_CreateTrustedDomainEx3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_CreateTrustedDomainEx3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_CreateTrustedDomainEx3(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_policy_handle /* [in] [ref] */,
					   struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
					   struct lsa_TrustDomainInfoAuthInfoInternalAES *_auth_info_internal /* [in] [ref] */,
					   uint32_t _access_mask /* [in]  */,
					   struct policy_handle *_trustdom_handle /* [out] [ref] */,
					   NTSTATUS *result)
{
	struct lsa_CreateTrustedDomainEx3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = _policy_handle;
	r.in.info = _info;
	r.in.auth_info_internal = _auth_info_internal;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.trustdom_handle = _trustdom_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_CreateTrustedDomainEx3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_OpenPolicy3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenPolicy3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenPolicy3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_OpenPolicy3 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenPolicy3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenPolicy3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENPOLICY3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenPolicy3_r_done, req);

	return req;
}

static void dcerpc_lsa_OpenPolicy3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenPolicy3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_OpenPolicy3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_OpenPolicy3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenPolicy3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_OpenPolicy3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_OPENPOLICY3, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_OpenPolicy3_state {
	struct lsa_OpenPolicy3 orig;
	struct lsa_OpenPolicy3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_OpenPolicy3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_OpenPolicy3_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_system_name /* [in] [charset(UTF16),unique] */,
					       struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       uint32_t _in_version /* [in]  */,
					       union lsa_revision_info *_in_revision_info /* [in] [ref,switch_is(in_version)] */,
					       uint32_t *_out_version /* [out] [ref] */,
					       union lsa_revision_info *_out_revision_info /* [out] [ref,switch_is(*out_version)] */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_OpenPolicy3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_OpenPolicy3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.attr = _attr;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.in_version = _in_version;
	state->orig.in.in_revision_info = _in_revision_info;

	/* Out parameters */
	state->orig.out.out_version = _out_version;
	state->orig.out.out_revision_info = _out_revision_info;
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_OpenPolicy3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_OpenPolicy3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_OpenPolicy3_done, req);
	return req;
}

static void dcerpc_lsa_OpenPolicy3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_OpenPolicy3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenPolicy3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_OpenPolicy3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.out_version = *state->tmp.out.out_version;
	*state->orig.out.out_revision_info = *state->tmp.out.out_revision_info;
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_OpenPolicy3_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_lsa_OpenPolicy3_state *state = tevent_req_data(
		req, struct dcerpc_lsa_OpenPolicy3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_OpenPolicy3(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_system_name /* [in] [charset(UTF16),unique] */,
				struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
				uint32_t _access_mask /* [in]  */,
				uint32_t _in_version /* [in]  */,
				union lsa_revision_info *_in_revision_info /* [in] [ref,switch_is(in_version)] */,
				uint32_t *_out_version /* [out] [ref] */,
				union lsa_revision_info *_out_revision_info /* [out] [ref,switch_is(*out_version)] */,
				struct policy_handle *_handle /* [out] [ref] */,
				NTSTATUS *result)
{
	struct lsa_OpenPolicy3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.attr = _attr;
	r.in.access_mask = _access_mask;
	r.in.in_version = _in_version;
	r.in.in_revision_info = _in_revision_info;

	/* Out parameters */
	r.out.out_version = _out_version;
	r.out.out_revision_info = _out_revision_info;
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_OpenPolicy3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_out_version = *r.out.out_version;
	*_out_revision_info = *r.out.out_revision_info;
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_lsaRQueryForestTrustInformation2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRQueryForestTrustInformation2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRQueryForestTrustInformation2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_lsaRQueryForestTrustInformation2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRQueryForestTrustInformation2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRQueryForestTrustInformation2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRQueryForestTrustInformation2_r_done, req);

	return req;
}

static void dcerpc_lsa_lsaRQueryForestTrustInformation2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_lsaRQueryForestTrustInformation2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_lsaRQueryForestTrustInformation2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_lsaRQueryForestTrustInformation2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state {
	struct lsa_lsaRQueryForestTrustInformation2 orig;
	struct lsa_lsaRQueryForestTrustInformation2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRQueryForestTrustInformation2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRQueryForestTrustInformation2_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct policy_handle *_handle /* [in] [ref] */,
								    struct lsa_String *_trusted_domain_name /* [in] [ref] */,
								    enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
								    struct lsa_ForestTrustInformation2 **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.highest_record_type = _highest_record_type;

	/* Out parameters */
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_lsaRQueryForestTrustInformation2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_lsaRQueryForestTrustInformation2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRQueryForestTrustInformation2_done, req);
	return req;
}

static void dcerpc_lsa_lsaRQueryForestTrustInformation2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_lsaRQueryForestTrustInformation2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation2_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  NTSTATUS *result)
{
	struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRQueryForestTrustInformation2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRQueryForestTrustInformation2(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct policy_handle *_handle /* [in] [ref] */,
						     struct lsa_String *_trusted_domain_name /* [in] [ref] */,
						     enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
						     struct lsa_ForestTrustInformation2 **_forest_trust_info /* [out] [ref] */,
						     NTSTATUS *result)
{
	struct lsa_lsaRQueryForestTrustInformation2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.trusted_domain_name = _trusted_domain_name;
	r.in.highest_record_type = _highest_record_type;

	/* Out parameters */
	r.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_lsaRQueryForestTrustInformation2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_lsa_lsaRSetForestTrustInformation2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRSetForestTrustInformation2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRSetForestTrustInformation2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct lsa_lsaRSetForestTrustInformation2 *r)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRSetForestTrustInformation2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRSetForestTrustInformation2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARSETFORESTTRUSTINFORMATION2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRSetForestTrustInformation2_r_done, req);

	return req;
}

static void dcerpc_lsa_lsaRSetForestTrustInformation2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_lsa_lsaRSetForestTrustInformation2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_lsa_lsaRSetForestTrustInformation2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct lsa_lsaRSetForestTrustInformation2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_lsarpc,
			NDR_LSA_LSARSETFORESTTRUSTINFORMATION2, mem_ctx, r);

	return status;
}

struct dcerpc_lsa_lsaRSetForestTrustInformation2_state {
	struct lsa_lsaRSetForestTrustInformation2 orig;
	struct lsa_lsaRSetForestTrustInformation2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_lsa_lsaRSetForestTrustInformation2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_lsa_lsaRSetForestTrustInformation2_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct dcerpc_binding_handle *h,
								  struct policy_handle *_handle /* [in] [ref] */,
								  struct lsa_StringLarge *_trusted_domain_name /* [in] [ref] */,
								  enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
								  struct lsa_ForestTrustInformation2 *_forest_trust_info /* [in] [ref] */,
								  uint8_t _check_only /* [in]  */,
								  struct lsa_ForestTrustCollisionInfo **_collision_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_lsa_lsaRSetForestTrustInformation2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_lsa_lsaRSetForestTrustInformation2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.highest_record_type = _highest_record_type;
	state->orig.in.forest_trust_info = _forest_trust_info;
	state->orig.in.check_only = _check_only;

	/* Out parameters */
	state->orig.out.collision_info = _collision_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_lsa_lsaRSetForestTrustInformation2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_lsa_lsaRSetForestTrustInformation2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_lsa_lsaRSetForestTrustInformation2_done, req);
	return req;
}

static void dcerpc_lsa_lsaRSetForestTrustInformation2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_lsa_lsaRSetForestTrustInformation2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRSetForestTrustInformation2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_lsa_lsaRSetForestTrustInformation2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.collision_info = *state->tmp.out.collision_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation2_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							NTSTATUS *result)
{
	struct dcerpc_lsa_lsaRSetForestTrustInformation2_state *state = tevent_req_data(
		req, struct dcerpc_lsa_lsaRSetForestTrustInformation2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_lsa_lsaRSetForestTrustInformation2(struct dcerpc_binding_handle *h,
						   TALLOC_CTX *mem_ctx,
						   struct policy_handle *_handle /* [in] [ref] */,
						   struct lsa_StringLarge *_trusted_domain_name /* [in] [ref] */,
						   enum lsa_ForestTrustRecordType _highest_record_type /* [in]  */,
						   struct lsa_ForestTrustInformation2 *_forest_trust_info /* [in] [ref] */,
						   uint8_t _check_only /* [in]  */,
						   struct lsa_ForestTrustCollisionInfo **_collision_info /* [out] [ref] */,
						   NTSTATUS *result)
{
	struct lsa_lsaRSetForestTrustInformation2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.trusted_domain_name = _trusted_domain_name;
	r.in.highest_record_type = _highest_record_type;
	r.in.forest_trust_info = _forest_trust_info;
	r.in.check_only = _check_only;

	/* Out parameters */
	r.out.collision_info = _collision_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_lsa_lsaRSetForestTrustInformation2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_collision_info = *r.out.collision_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

