const char sysprof_lua[] =
"local evread = require \"utils.evread\"\n"
"local sysprof = require \"sysprof.parse\"\n"
"\n"
"local stdout, stderr = io.stdout, io.stderr\n"
"local match, gmatch = string.match, string.gmatch\n"
"\n"
"-- Program options.\n"
"local opt_map = {}\n"
"\n"
"function opt_map.help()\n"
"  stdout:write [[\n"
"luajit-parse-sysprof - parser of the profile collected\n"
"                       with LuaJIT's sysprof.\n"
"\n"
"SYNOPSIS\n"
"\n"
"luajit-parse-sysprof [options] sysprof.bin\n"
"\n"
"Supported options are:\n"
"\n"
"  --help                            Show this help and exit\n"
"]]\n"
"  os.exit(0)\n"
"end\n"
"\n"
"-- Print error and exit with error status.\n"
"local function opterror(...)\n"
"  stderr:write(\"luajit-parse-sysprof.lua: ERROR: \", ...)\n"
"  stderr:write(\"\\n\")\n"
"  os.exit(1)\n"
"end\n"
"\n"
"-- Parse single option.\n"
"local function parseopt(opt, args)\n"
"  local opt_current = #opt == 1 and \"-\"..opt or \"--\"..opt\n"
"  local f = opt_map[opt]\n"
"  if not f then\n"
"    opterror(\"unrecognized option `\", opt_current, \"'. Try `--help'.\\n\")\n"
"  end\n"
"  f(args)\n"
"end\n"
"\n"
"-- Parse arguments.\n"
"local function parseargs(args)\n"
"  -- Process all option arguments.\n"
"  args.argn = 1\n"
"  repeat\n"
"    local a = args[args.argn]\n"
"    if not a then\n"
"      break\n"
"    end\n"
"    local lopt, opt = match(a, \"^%-(%-\?)(.+)\")\n"
"    if not opt then\n"
"      break\n"
"    end\n"
"    args.argn = args.argn + 1\n"
"    if lopt == \"\" then\n"
"      -- Loop through short options.\n"
"      for o in gmatch(opt, \".\") do\n"
"        parseopt(o, args)\n"
"      end\n"
"    else\n"
"      -- Long option.\n"
"      parseopt(opt, args)\n"
"    end\n"
"  until false\n"
"\n"
"  -- Check for proper number of arguments.\n"
"  local nargs = #args - args.argn + 1\n"
"  if nargs ~= 1 then\n"
"    opt_map.help()\n"
"  end\n"
"\n"
"  -- Translate a single input file.\n"
"  -- TODO: Handle multiple files\?\n"
"  return args[args.argn]\n"
"end\n"
"\n"
"local function dump(inputfile)\n"
"  -- XXX: This function exits with a non-zero exit code and\n"
"  -- prints an error message if it encounters any failure during\n"
"  -- the process of parsing.\n"
"  local events = evread(sysprof.parse, inputfile)\n"
"\n"
"  for stack, count in pairs(events) do\n"
"    print(stack, count)\n"
"  end\n"
"  -- XXX: The second argument is required to properly close Lua\n"
"  -- universe (i.e. invoke <lua_close> before exiting).\n"
"  os.exit(0, true)\n"
"end\n"
"\n"
"-- XXX: When this script is used as a preloaded module by an\n"
"-- application, it should return one function for correct parsing\n"
"-- of command line flags like --leak-only and dumping profile\n"
"-- info.\n"
"local function dump_wrapped(...)\n"
"  return dump(parseargs(...))\n"
"end\n"
"\n"
"return dump_wrapped\n"
""
;
