/* LinuxDistro.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LinuxDistro.vala, do not modify */

/*
 * LinuxDistro.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;
typedef struct _LinuxDistroPrivate LinuxDistroPrivate;
enum  {
	LINUX_DISTRO_0_PROPERTY,
	LINUX_DISTRO_DIST_TYPE_PROPERTY,
	LINUX_DISTRO_NUM_PROPERTIES
};
static GParamSpec* linux_distro_properties[LINUX_DISTRO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _LinuxDistro {
	GObject parent_instance;
	LinuxDistroPrivate * priv;
	gchar* dist_id;
	gchar* description;
	gchar* release;
	gchar* codename;
};

struct _LinuxDistroClass {
	GObjectClass parent_class;
};

static gpointer linux_distro_parent_class = NULL;

VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN LinuxDistro* linux_distro_new (void);
VALA_EXTERN LinuxDistro* linux_distro_construct (GType object_type);
VALA_EXTERN gchar* linux_distro_full_name (LinuxDistro* self);
VALA_EXTERN LinuxDistro* linux_distro_get_dist_info (const gchar* root_path);
static LinuxDistro* linux_distro_read_info_file (const gchar* file_path);
VALA_EXTERN gchar* linux_distro_get_dist_type (LinuxDistro* self);
static void linux_distro_finalize (GObject * obj);
static GType linux_distro_get_type_once (void);
static void _vala_linux_distro_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

LinuxDistro*
linux_distro_construct (GType object_type)
{
	LinuxDistro * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (LinuxDistro*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->dist_id);
	self->dist_id = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->description);
	self->description = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->release);
	self->release = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->codename);
	self->codename = _tmp3_;
	return self;
}

LinuxDistro*
linux_distro_new (void)
{
	return linux_distro_construct (TYPE_LINUX_DISTRO);
}

gchar*
linux_distro_full_name (LinuxDistro* self)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dist_id;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	} else {
		gchar* val = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp2_ = g_strdup ("");
		val = _tmp2_;
		_tmp3_ = val;
		_tmp4_ = self->dist_id;
		_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
		_g_free0 (val);
		val = _tmp5_;
		_tmp7_ = self->release;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ > 0) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->release;
			_tmp11_ = g_strconcat (" ", _tmp10_, NULL);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp11_;
		} else {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("");
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp12_;
		}
		_tmp13_ = val;
		_tmp14_ = g_strconcat (_tmp13_, _tmp6_, NULL);
		_g_free0 (val);
		val = _tmp14_;
		_tmp16_ = self->codename;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ > 0) {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp19_ = self->codename;
			_tmp20_ = g_strconcat (" (", _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp21_, ")", NULL);
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp22_;
			_g_free0 (_tmp21_);
		} else {
			gchar* _tmp23_;
			_tmp23_ = g_strdup ("");
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp23_;
		}
		_tmp24_ = val;
		_tmp25_ = g_strconcat (_tmp24_, _tmp15_, NULL);
		_g_free0 (val);
		val = _tmp25_;
		result = val;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp6_);
		return result;
	}
}

LinuxDistro*
linux_distro_get_dist_info (const gchar* root_path)
{
	LinuxDistro* info = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	LinuxDistro* _tmp2_;
	LinuxDistro* _tmp3_;
	LinuxDistro* _tmp4_;
	LinuxDistro* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	LinuxDistro* _tmp8_;
	LinuxDistro* _tmp9_;
	LinuxDistro* _tmp11_;
	LinuxDistro* result;
	g_return_val_if_fail (root_path != NULL, NULL);
	_tmp0_ = g_strconcat (root_path, "/etc/lsb-release", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = linux_distro_read_info_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	info = _tmp3_;
	_tmp4_ = info;
	if (_tmp4_ != NULL) {
		result = info;
		return result;
	}
	_tmp6_ = g_strconcat (root_path, "/etc/os-release", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = linux_distro_read_info_file (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp5_ = _tmp9_;
	if (_tmp5_ == NULL) {
		LinuxDistro* _tmp10_;
		_tmp10_ = linux_distro_new ();
		_g_object_unref0 (_tmp5_);
		_tmp5_ = _tmp10_;
	}
	_tmp11_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp11_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (info);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static LinuxDistro*
linux_distro_read_info_file (const gchar* file_path)
{
	gchar* dist_file_cont = NULL;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	LinuxDistro* info = NULL;
	LinuxDistro* _tmp4_;
	gchar** lines = NULL;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GError* _inner_error0_ = NULL;
	LinuxDistro* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		g_file_get_contents (file_path, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (dist_file_cont);
		dist_file_cont = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (dist_file_cont);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (dist_file_cont);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp1_ = dist_file_cont;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = NULL;
		_g_free0 (dist_file_cont);
		return result;
	}
	_tmp4_ = linux_distro_new ();
	info = _tmp4_;
	_tmp5_ = dist_file_cont;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	lines = _tmp7_;
	lines_length1 = _vala_array_length (_tmp6_);
	_lines_size_ = lines_length1;
	_tmp8_ = lines;
	_tmp8__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp8_;
		line_collection_length1 = _tmp8__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp9_;
			gchar* line = NULL;
			_tmp9_ = g_strdup (line_collection[line_it]);
			line = _tmp9_;
			{
				gchar** linesplit = NULL;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gint linesplit_length1;
				gint _linesplit_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar* key = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* val = NULL;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp26_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				GQuark _tmp35_ = 0U;
				static GQuark _tmp34_label0 = 0;
				static GQuark _tmp34_label1 = 0;
				static GQuark _tmp34_label2 = 0;
				static GQuark _tmp34_label3 = 0;
				static GQuark _tmp34_label4 = 0;
				static GQuark _tmp34_label5 = 0;
				static GQuark _tmp34_label6 = 0;
				static GQuark _tmp34_label7 = 0;
				_tmp10_ = line;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "=", 3);
				linesplit = _tmp12_;
				linesplit_length1 = _vala_array_length (_tmp11_);
				_linesplit_size_ = linesplit_length1;
				_tmp13_ = linesplit;
				_tmp13__length1 = linesplit_length1;
				if (_tmp13__length1 != 2) {
					linesplit = (_vala_array_free (linesplit, linesplit_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp14_ = linesplit;
				_tmp14__length1 = linesplit_length1;
				_tmp15_ = _tmp14_[0];
				_tmp16_ = string_strip (_tmp15_);
				key = _tmp16_;
				_tmp17_ = linesplit;
				_tmp17__length1 = linesplit_length1;
				_tmp18_ = _tmp17_[1];
				_tmp19_ = string_strip (_tmp18_);
				val = _tmp19_;
				_tmp20_ = val;
				if (g_str_has_prefix (_tmp20_, "\"")) {
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gchar* _tmp25_;
					_tmp21_ = val;
					_tmp22_ = val;
					_tmp23_ = strlen (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = string_slice (_tmp21_, (glong) 1, (glong) _tmp24_);
					_g_free0 (val);
					val = _tmp25_;
				}
				_tmp26_ = val;
				if (g_str_has_suffix (_tmp26_, "\"")) {
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gchar* _tmp31_;
					_tmp27_ = val;
					_tmp28_ = val;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = string_slice (_tmp27_, (glong) 0, (glong) (_tmp30_ - 1));
					_g_free0 (val);
					val = _tmp31_;
				}
				_tmp32_ = key;
				_tmp33_ = _tmp32_;
				_tmp35_ = (NULL == _tmp33_) ? 0 : g_quark_from_string (_tmp33_);
				if ((_tmp35_ == ((0 != _tmp34_label0) ? _tmp34_label0 : (_tmp34_label0 = g_quark_from_static_string ("ID")))) || (_tmp35_ == ((0 != _tmp34_label1) ? _tmp34_label1 : (_tmp34_label1 = g_quark_from_static_string ("DISTRIB_ID"))))) {
					switch (0) {
						default:
						{
							LinuxDistro* _tmp36_;
							const gchar* _tmp37_;
							gchar* _tmp38_;
							_tmp36_ = info;
							_tmp37_ = val;
							_tmp38_ = g_strdup (_tmp37_);
							_g_free0 (_tmp36_->dist_id);
							_tmp36_->dist_id = _tmp38_;
							break;
						}
					}
				} else if ((_tmp35_ == ((0 != _tmp34_label2) ? _tmp34_label2 : (_tmp34_label2 = g_quark_from_static_string ("VERSION_ID")))) || (_tmp35_ == ((0 != _tmp34_label3) ? _tmp34_label3 : (_tmp34_label3 = g_quark_from_static_string ("DISTRIB_RELEASE"))))) {
					switch (0) {
						default:
						{
							LinuxDistro* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp39_ = info;
							_tmp40_ = val;
							_tmp41_ = g_strdup (_tmp40_);
							_g_free0 (_tmp39_->release);
							_tmp39_->release = _tmp41_;
							break;
						}
					}
				} else if ((_tmp35_ == ((0 != _tmp34_label4) ? _tmp34_label4 : (_tmp34_label4 = g_quark_from_static_string ("VERSION_CODENAME")))) || (_tmp35_ == ((0 != _tmp34_label5) ? _tmp34_label5 : (_tmp34_label5 = g_quark_from_static_string ("DISTRIB_CODENAME"))))) {
					switch (0) {
						default:
						{
							LinuxDistro* _tmp42_;
							const gchar* _tmp43_;
							gchar* _tmp44_;
							_tmp42_ = info;
							_tmp43_ = val;
							_tmp44_ = g_strdup (_tmp43_);
							_g_free0 (_tmp42_->codename);
							_tmp42_->codename = _tmp44_;
							break;
						}
					}
				} else if ((_tmp35_ == ((0 != _tmp34_label6) ? _tmp34_label6 : (_tmp34_label6 = g_quark_from_static_string ("PRETTY_NAME")))) || (_tmp35_ == ((0 != _tmp34_label7) ? _tmp34_label7 : (_tmp34_label7 = g_quark_from_static_string ("DISTRIB_DESCRIPTION"))))) {
					switch (0) {
						default:
						{
							LinuxDistro* _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp45_ = info;
							_tmp46_ = val;
							_tmp47_ = g_strdup (_tmp46_);
							_g_free0 (_tmp45_->description);
							_tmp45_->description = _tmp47_;
							break;
						}
					}
				}
				_g_free0 (val);
				_g_free0 (key);
				linesplit = (_vala_array_free (linesplit, linesplit_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = info;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (dist_file_cont);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
linux_distro_get_dist_type (LinuxDistro* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dist_id;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_contains ("fedora rhel rocky centos almalinux", _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("redhat");
		result = _tmp4_;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = self->dist_id;
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_contains (_tmp8_, "manjaro");
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = self->dist_id;
			_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
			_tmp12_ = _tmp11_;
			_tmp5_ = string_contains (_tmp12_, "arch");
			_g_free0 (_tmp12_);
		}
		if (_tmp5_) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("arch");
			result = _tmp13_;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp15_ = self->dist_id;
			_tmp16_ = g_utf8_strdown (_tmp15_, (gssize) -1);
			_tmp17_ = _tmp16_;
			_tmp18_ = string_contains (_tmp17_, "ubuntu");
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				_tmp14_ = TRUE;
			} else {
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp19_ = self->dist_id;
				_tmp20_ = g_utf8_strdown (_tmp19_, (gssize) -1);
				_tmp21_ = _tmp20_;
				_tmp14_ = string_contains (_tmp21_, "debian");
				_g_free0 (_tmp21_);
			}
			if (_tmp14_) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup ("debian");
				result = _tmp22_;
				return result;
			} else {
				gchar* _tmp23_;
				_tmp23_ = g_strdup ("");
				result = _tmp23_;
				return result;
			}
		}
	}
}

static void
linux_distro_class_init (LinuxDistroClass * klass,
                         gpointer klass_data)
{
	linux_distro_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_linux_distro_get_property;
	G_OBJECT_CLASS (klass)->finalize = linux_distro_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LINUX_DISTRO_DIST_TYPE_PROPERTY, linux_distro_properties[LINUX_DISTRO_DIST_TYPE_PROPERTY] = g_param_spec_string ("dist-type", "dist-type", "dist-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
linux_distro_instance_init (LinuxDistro * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = g_strdup ("");
	self->dist_id = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->description = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->release = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->codename = _tmp3_;
}

static void
linux_distro_finalize (GObject * obj)
{
	LinuxDistro * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LINUX_DISTRO, LinuxDistro);
	_g_free0 (self->dist_id);
	_g_free0 (self->description);
	_g_free0 (self->release);
	_g_free0 (self->codename);
	G_OBJECT_CLASS (linux_distro_parent_class)->finalize (obj);
}

static GType
linux_distro_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LinuxDistroClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) linux_distro_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LinuxDistro), 0, (GInstanceInitFunc) linux_distro_instance_init, NULL };
	GType linux_distro_type_id;
	linux_distro_type_id = g_type_register_static (G_TYPE_OBJECT, "LinuxDistro", &g_define_type_info, 0);
	return linux_distro_type_id;
}

GType
linux_distro_get_type (void)
{
	static volatile gsize linux_distro_type_id__once = 0;
	if (g_once_init_enter (&linux_distro_type_id__once)) {
		GType linux_distro_type_id;
		linux_distro_type_id = linux_distro_get_type_once ();
		g_once_init_leave (&linux_distro_type_id__once, linux_distro_type_id);
	}
	return linux_distro_type_id__once;
}

static void
_vala_linux_distro_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	LinuxDistro * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LINUX_DISTRO, LinuxDistro);
	switch (property_id) {
		case LINUX_DISTRO_DIST_TYPE_PROPERTY:
		g_value_take_string (value, linux_distro_get_dist_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

